/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.mja.cmp.mjaButton;
import com.mja.descartes.Descartes;
import com.mja.descartes.controlConfig;
import com.mja.file.mjaHtml;
import com.mja.lang.translator;
import com.mja.textedit.EditorQPanel;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TextAreaControl
extends Panel
implements ActionListener {
    private EditorQPanel EQP;
    private Descartes D;
    private String name;
    private controlConfig txtctrl;
    private mjaButton b_switch;
    private static final Color pbgc = new Color(12636376);
    private boolean hasSol = false;
    private String solution;
    private boolean showingSol = false;

    public TextAreaControl(Descartes descartes, controlConfig controlConfig2) {
        this.D = descartes;
        this.txtctrl = controlConfig2;
        this.name = controlConfig2.getName();
        this.setBackground(pbgc);
        this.setBounds(controlConfig2.getTextX(), controlConfig2.getTextY(), controlConfig2.getTextW(), controlConfig2.getTextH());
        this.setLayout(null);
        this.EQP = new EditorQPanel(descartes, new Frame(), descartes.Tr, descartes.p, true, false, false, true);
        this.EQP.init();
        this.EQP.setText(mjaHtml.decodeHTMLEncoding(controlConfig2.s_value[controlConfig.ixtext]));
        descartes.p.defineVar(this.name, controlConfig2.s_value[controlConfig.ixtext]);
        this.EQP.getEB().setAttributes("fuentes=no colores=no formulas=si fracciones=si potencias=si radicales=si series=si integrales=si limites=si matrices=si defparts=si expresiones=no caracteres=no unicode=si rtf=no im\u00e1genes=no ayuda=no");
        translator cfr_ignored_0 = descartes.Tr;
        if (!translator.isTrue(controlConfig2.s_value[controlConfig.ixbuttons])) {
            this.EQP.hideEditorButtons();
        }
        this.hasSol = BasicStr.hasContent(controlConfig2.s_value[controlConfig.ixsolution]);
        int n = controlConfig2.getTextW() - 8;
        int n2 = controlConfig2.getTextH() - (this.hasSol ? 28 : 8);
        this.EQP.setCanvasSize(n, n2);
        this.EQP.setBounds(4, 4, n, n2);
        this.add(this.EQP);
        this.EQP.setEditing(true);
        if (this.hasSol) {
            this.solution = mjaHtml.decodeHTMLEncoding(controlConfig2.s_value[controlConfig.ixsolution]);
            System.out.println(this.solution);
            this.b_switch = new mjaButton("S");
            this.b_switch.addActionListener(this);
            this.b_switch.setBounds(controlConfig2.getTextW() - 24, controlConfig2.getTextH() - 20, 20, 16);
            this.add(this.b_switch);
            if (descartes.isArquimedesItem()) {
                if (!descartes.inNippeEditor()) {
                    this.b_switch.setVisible(false);
                }
            }
        }
    }

    public void registerTextInParser() {
        String string = this.EQP.getText(false);
        this.D.p.defineVar(this.name, string);
    }

    public void updateVisualComponent() {
        this.EQP.setText(this.D.p.Var(this.name).getStringValue());
        this.EQP.getEC().updateScreen();
        this.showingSol = false;
        this.EQP.repaint();
    }

    public void showSolution() {
        this.registerTextInParser();
        this.EQP.setText(this.solution);
        this.EQP.getEC().updateScreen();
        this.showingSol = true;
        this.EQP.repaint();
    }

    public void showUserText() {
        this.updateVisualComponent();
        this.EQP.getEC().updateScreen();
        this.showingSol = false;
        this.EQP.repaint();
    }

    protected void defineTextValue(String string) {
        this.D.p.defineVar(this.name, string);
        this.updateVisualComponent();
    }

    public void start() {
        if (this.D.disableControls) {
            this.EQP.setEditing(false);
        }
        this.EQP.start();
        this.updateVisualComponent();
        if (this.D.disableControls) {
            this.EQP.setEnabled(false);
        }
    }

    public void locate() {
        this.setVisible(this.txtctrl.condVis.Evaluate(1.0) > 0.0);
        this.setEnabled(this.txtctrl.condActiv.Evaluate(1.0) > 0.0);
        if (this.txtctrl.xN != null && this.txtctrl.yN != null && this.txtctrl.wN != null && this.txtctrl.hN != null) {
            Dimension dimension = this.getSize();
            double d = this.txtctrl.wN.Evaluate(100.0);
            double d2 = this.txtctrl.hN.Evaluate(23.0);
            int n = (int)Math.floor(d + 0.5);
            int n2 = (int)Math.floor(d2 + 0.5);
            int n3 = (int)Math.floor(this.txtctrl.xN.Evaluate(0.0) + 0.5);
            int n4 = (int)Math.floor(this.txtctrl.yN.Evaluate(0.0) + 0.5);
            Point point = this.getLocation();
            if (point.x != n3 || point.y != n4 || dimension.width != n || dimension.height != n2) {
                this.setBounds(n3, n4, n, n2);
                int n5 = this.txtctrl.getTextW() - 8;
                int n6 = this.txtctrl.getTextH() - (this.hasSol ? 28 : 8);
                this.EQP.setCanvasSize(n5, n6);
                this.EQP.setBounds(4, 4, n5, n6);
                this.b_switch.setBounds(this.txtctrl.getTextW() - 24, this.txtctrl.getTextH() - 20, 20, 16);
            }
        }
    }

    public void stop() {
        this.EQP.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b_switch) {
            if (this.showingSol) {
                this.showUserText();
                this.EQP.setEnabled(true);
                this.EQP.setEditing(true);
                this.b_switch.setLabel("S");
                this.b_switch.setBounds(this.txtctrl.getTextW() - 24, this.txtctrl.getTextH() - 20, 20, 16);
                this.b_switch.repaint();
            } else {
                this.showSolution();
                this.EQP.setEditing(false);
                this.EQP.setEnabled(false);
                this.b_switch.setLabel("T");
                this.b_switch.setBounds(this.txtctrl.getTextW() - 24, this.txtctrl.getTextH() - 20, 20, 16);
                this.b_switch.repaint();
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.EQP.repaint();
    }
}

