/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.math;

import com.jla.desc2.math.R2;
import com.jla.desc2.parser.Node;
import com.jla.desc2.parser.Parser;

public class R2Newton {
    static double delta = 1.0E-12;
    static double epsilon = 1.0E-6;
    private Parser P;
    private Node F;
    private Node X;
    private Node Y;
    private double f0;
    private R2 normal;

    public R2Newton(Parser parser, Node node) {
        this.P = parser;
        this.F = node;
        if (node.getSymbol().equals("=")) {
            node.equalToMinus();
            this.X = parser.Var("x");
            this.Y = parser.Var("y");
        }
    }

    public R2Newton(Parser parser, String string) throws Exception {
        this.P = parser;
        this.F = parser.Analyse(string);
        if (!this.F.getSymbol().equals("=")) {
            throw new Exception("\"" + string + "\"" + " is not a formula");
        }
        this.F.equalToMinus();
        this.X = parser.Var("x");
        this.Y = parser.Var("y");
    }

    public R2 getUnitNormal() {
        this.normal.normalize();
        return this.normal.copy();
    }

    public R2 gradient(R2 r2) throws Exception {
        R2 r22 = new R2(0.0, 0.0);
        try {
            this.X.r = r2.x;
            this.Y.r = r2.y;
            this.f0 = this.F.Evaluate(true);
            this.X.r += delta;
            r22.x = (this.F.Evaluate(true) - this.f0) / delta;
            this.X.r -= delta;
            this.Y.r += delta;
            r22.y = (this.F.Evaluate(true) - this.f0) / delta;
            this.Y.r -= delta;
        }
        catch (Exception exception) {
            System.out.println("Exception in gradient:");
            throw exception;
        }
        return r22;
    }

    public boolean rangeOK() {
        return this.F.rangeOK();
    }

    public R2 findZero(R2 r2) throws Exception {
        R2 r22 = r2.copy();
        for (int i = 0; i < 256; ++i) {
            double d = r22.x;
            double d2 = r22.y;
            this.normal = this.gradient(r22);
            this.normal.mul(-this.f0 / this.normal.norm2());
            r22.x = d + this.normal.x;
            r22.y = d2 + this.normal.y;
            if (!(this.normal.norm() < epsilon)) continue;
            if (this.normal.x == 0.0 && this.normal.y == 0.0) {
                this.normal.x = r22.x - r2.x;
                this.normal.y = r22.y - r2.y;
            }
            return r22;
        }
        throw new Exception("Zero not found.");
    }
}

