/*
 * Decompiled with CFR 0.152.
 */
package org.cnice.rad.common;

import java.io.Serializable;
import java.util.Calendar;

public class SqlMetadata
implements Serializable {
    public static final int INTEGER = 4;
    public static final int VARCHAR = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int LONGVARBINARY = -4;
    private int type;
    private String name;

    public SqlMetadata(int n, String string) {
        this.type = n;
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static int getSqlMetadataType(int n) throws Exception {
        if (n == 4 || n == -6) {
            return 4;
        }
        if (n == 12 || n == 1) {
            return 12;
        }
        if (n == 91) {
            return 91;
        }
        if (n == 92) {
            return 92;
        }
        if (n == 93) {
            return 93;
        }
        if (n == -4) {
            return -4;
        }
        throw new Exception("Not supported sql type " + n);
    }

    public static String getDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        String string = SqlMetadata.justify(calendar.get(1), -4, '0') + "-" + SqlMetadata.justify(calendar.get(2) + 1, -2, '0') + "-" + SqlMetadata.justify(calendar.get(5), -2, '0');
        string = string + " " + SqlMetadata.justify(calendar.get(11), -2, '0') + ":" + SqlMetadata.justify(calendar.get(12), -2, '0') + ":" + SqlMetadata.justify(calendar.get(13), -2, '0');
        return string;
    }

    public static String justify(int n, int n2, char c) {
        return SqlMetadata.justify(String.valueOf(n), n2, c);
    }

    public static String justify(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n > 0) {
            while (stringBuffer.length() < n) {
                stringBuffer.append(c);
            }
        } else {
            while (stringBuffer.length() < -n) {
                stringBuffer.insert(0, c);
            }
        }
        String string2 = new String(stringBuffer);
        if (n > 0) {
            if (string2.length() > n) {
                string2 = string2.substring(0, n);
            }
        } else if (string2.length() > -n) {
            string2 = string2.substring(string2.length() + n);
        }
        return string2;
    }
}

