/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.descartes;

import com.jla.desc2.descartes.Control;
import com.jla.desc2.descartes.Descartes;
import com.jla.desc2.descartes.config;
import com.jla.desc2.descartes.data;
import com.jla.desc2.descartes.mjaGraph;
import com.jla.desc2.gui.mjaButton;
import com.jla.desc2.gui.mjaGui;
import com.jla.desc2.math.R2;
import com.jla.desc2.parser.Algorithm;
import com.jla.desc2.parser.Node;
import com.jla.desc2.parser.Parser;
import com.jla.desc2.util.mjaStr;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class R2Space
extends Panel
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener,
Runnable {
    private static final double infNotExp = 1.0E-8;
    private static final double supNotExp = 9.9999999999E9;
    int w = -1;
    int h = -1;
    int Ox;
    int Oy;
    double esc;
    private Descartes D;
    private static final int bck = 0;
    private static final int net = 1;
    private static final int net10 = 2;
    private static final int axe = 3;
    private static final int tex = 4;
    private Color[] DC;
    private Color bC;
    private int Oxa;
    private int Oya;
    private double esca;
    private Control[] control;
    private volatile Control aC;
    private mjaGraph[] graph;
    private Image back;
    private Image front;
    private Image img;
    private Graphics bg;
    private Graphics fg;
    private Graphics ig;
    private Graphics[] bga;
    private Graphics[] tga;
    private Graphics[] fga;
    private boolean netOn;
    private boolean net10On;
    private boolean axesOn;
    private boolean textOn;
    private boolean fillInFront;
    private Thread thr;
    private Panel animCtrl;
    private mjaButton[] b;
    volatile boolean running;
    private Graphics g;
    volatile boolean pause;
    volatile boolean onestep;
    private Algorithm alg;
    private volatile boolean stay;
    private int acix = 0;

    public R2Space(Descartes descartes) {
        this.D = descartes;
        this.setLayout(null);
        this.animCtrl = new Panel();
        this.animCtrl.setBounds(0, 0, 120, 20);
        this.add(this.animCtrl);
        this.b = new mjaButton[6];
        this.animCtrl.setLayout(new GridLayout(1, this.b.length));
        for (int i = 0; i < this.b.length; ++i) {
            this.b[i] = new mjaButton(i);
            this.animCtrl.add(this.b[i]);
            this.b[i].addActionListener(this);
        }
        this.animCtrl.setVisible(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    R2 injection(double d, double d2) {
        return new R2((d - (double)this.Ox) / this.esc, ((double)this.Oy - d2) / this.esc);
    }

    R2 projection(R2 r2) {
        return new R2((double)this.Ox + this.esc * r2.x, (double)this.Oy - this.esc * r2.y);
    }

    double X(int n, double d) {
        double d2 = (double)this.Ox + this.esc * d;
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.w + n)) {
            d2 = this.w + n;
        }
        return d2;
    }

    double Y(int n, double d) {
        double d2 = (double)this.Oy - this.esc * d;
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.h + n)) {
            d2 = this.h + n;
        }
        return d2;
    }

    int XX(int n, double d) {
        return (int)Math.round(this.X(n, d));
    }

    int YY(int n, double d) {
        return (int)Math.round(this.Y(n, d));
    }

    public boolean inside(R2 r2) {
        return -this.w <= r2.ix() && r2.ix() <= 2 * this.w && -this.h <= r2.iy() && r2.iy() <= 2 * this.h;
    }

    Panel initializeObjects(config config2) {
        int n;
        int n2;
        this.netOn = config2.isOn[1];
        this.net10On = config2.isOn[2];
        this.axesOn = config2.isOn[3];
        this.textOn = config2.isOn[4];
        this.DC = config2.color;
        this.bC = this.DC[0];
        int n3 = 0;
        for (n2 = 0; n2 < config2.cc.length; ++n2) {
            if (config2.cc[n2].type != 96) continue;
            ++n3;
        }
        this.control = new Control[n3];
        n2 = 0;
        for (n = 0; n < config2.cc.length; ++n) {
            if (config2.cc[n].type != 96) continue;
            this.control[n2] = config2.cc[n].ctrl;
            this.control[n2++].Initialize(this.D);
        }
        this.graph = new mjaGraph[config2.gc.length];
        n = 0;
        for (int i = 0; i < this.graph.length; ++i) {
            if (config2.gc[i].type < 0) {
                this.graph[i] = null;
                continue;
            }
            this.graph[i] = new mjaGraph(this.D, config2.gc[i]);
            if (!this.graph[i].gc.isVisible) continue;
            ++n;
        }
        Panel panel = null;
        if (n > 0) {
            panel = new Panel();
            panel.setLayout(new GridLayout(1, n));
            for (int i = 0; i < this.graph.length; ++i) {
                if (!this.graph[i].gc.isVisible) continue;
                this.graph[i].TF = new TextField(this.graph[i].gc.formula);
                this.graph[i].TF.setForeground(this.graph[i].gc.gcolor);
                if (mjaStr.osIsWindows()) {
                    this.graph[i].TF.setFont(mjaGui.Courier);
                } else {
                    this.graph[i].TF.setFont(mjaGui.Courier_11);
                }
                if (this.graph[i].gc.isEditable) {
                    this.graph[i].TF.setEditable(true);
                    this.graph[i].TF.addKeyListener(this);
                } else {
                    this.graph[i].TF.setEditable(false);
                }
                this.graph[i].TF.setBackground(this.bC);
                panel.add(this.graph[i].TF);
            }
        }
        return panel;
    }

    private boolean initializeGraphicStuff() {
        boolean bl = false;
        if (this.img == null || this.w != this.getSize().width || this.h != this.getSize().height) {
            this.g = this.getGraphics();
            this.w = this.getSize().width;
            this.h = this.getSize().height;
            this.back = this.createImage(this.w, this.h);
            this.bg = this.back.getGraphics();
            this.bg.setFont(mjaGui.Courier);
            this.img = this.createImage(this.w, this.h);
            this.ig = this.img.getGraphics();
            this.ig.setFont(mjaGui.Courier);
            this.front = this.createImage(this.w, this.h);
            this.fg = this.front.getGraphics();
            this.fg.setFont(mjaGui.Courier);
            this.bga = new Graphics[1];
            this.bga[0] = this.bg;
            bl = true;
        }
        this.fillInFront = false;
        for (int i = 0; i < this.graph.length; ++i) {
            if (this.graph[i] == null || this.graph[i].gc.isInBack || this.graph[i].gc.type != 43) continue;
            this.fillInFront = true;
            break;
        }
        if (this.fillInFront) {
            this.fga = new Graphics[2];
            this.fga[0] = this.fg;
            this.fga[1] = this.ig;
            this.tga = new Graphics[3];
            this.tga[0] = this.bg;
            this.tga[1] = this.fg;
            this.tga[2] = this.ig;
        } else {
            this.fga = new Graphics[1];
            this.fga[0] = this.ig;
            this.tga = new Graphics[2];
            this.tga[0] = this.bg;
            this.tga[1] = this.ig;
        }
        bl = this.spaceChanged() | bl;
        return bl;
    }

    private boolean spaceChanged() {
        this.Ox = (int)Math.round(this.D.p.value("Ox") + (double)this.w / 2.0);
        this.Oy = this.D.cfg.version0.startsWith("1") && !this.D.cfg.hasVisibleEquation() ? (int)Math.round(this.D.p.value("Oy") + (double)(this.h - 24) / 2.0) : (int)Math.round(this.D.p.value("Oy") + (double)this.h / 2.0);
        this.esc = this.D.p.value("escala", 48.0);
        if (this.esc < 1.0E-6) {
            this.esc = 1.0E-6;
        }
        if (this.esc > 1000000.0) {
            this.esc = 1000000.0;
        }
        boolean bl = this.esc != this.esca || this.Ox != this.Oxa || this.Oy != this.Oya;
        this.esca = this.esc;
        this.Oxa = this.Ox;
        this.Oya = this.Oy;
        return bl;
    }

    private void drawBackground() {
        int n;
        this.bg.setColor(data.adaptColor(this.D, this.DC[0]));
        this.bg.fillRect(0, 0, this.w, this.h);
        double d = this.esc;
        int n2 = 0;
        while (d > (double)(this.w + this.h)) {
            d /= 10.0;
            ++n2;
        }
        while (d < (double)((this.w + this.h) / 10)) {
            d *= 10.0;
        }
        if (this.netOn) {
            this.bg.setColor(data.adaptColor(this.D, this.DC[1]));
            this.drawMarks(d / 10.0, -1);
            if (this.net10On) {
                this.bg.setColor(data.adaptColor(this.D, this.DC[2]));
                this.drawMarks(d, -1);
            }
        }
        if (this.axesOn) {
            this.bg.setFont(mjaGui.Courier);
            this.bg.setColor(data.adaptColor(this.D, this.DC[3]));
            if (this.D.cfg.x_On) {
                this.bg.drawLine(0, this.Oy, this.w, this.Oy);
            }
            if (this.D.cfg.y_On) {
                this.bg.drawLine(this.Ox, 0, this.Ox, this.h);
            }
            if (this.D.cfg.numbers) {
                if (d > (double)((this.w + this.h) / 2)) {
                    this.drawNumbers(d / 5.0, d <= this.esc ? n2 + 1 : n2);
                } else if (d > (double)((this.w + this.h) / 4)) {
                    this.drawNumbers(d / 2.0, d <= this.esc ? n2 + 1 : n2);
                } else {
                    this.drawNumbers(d, n2);
                }
            }
            this.drawMarks(d, 3);
            this.drawMarks(d /= 2.0, 2);
            this.drawMarks(d /= 5.0, 1);
            this.bg.setColor(data.adaptColor(this.D, this.DC[3]));
            n = this.Ox - 2 - this.bg.getFontMetrics(this.bg.getFont()).stringWidth(this.D.cfg.y_axis);
            int n3 = this.bg.getFontMetrics(this.bg.getFont()).getAscent();
            if (this.D.cfg.y_On) {
                this.bg.drawString(this.D.cfg.y_axis, n, n3);
            }
            n = this.w - 3 - this.bg.getFontMetrics(this.bg.getFont()).stringWidth(this.D.cfg.x_axis);
            n3 = this.Oy + n3;
            if (this.D.cfg.x_On) {
                this.bg.drawString(this.D.cfg.x_axis, n, n3);
            }
        }
        for (n = 0; n < this.graph.length; ++n) {
            if (this.graph[n] == null || !this.graph[n].gc.isInBack) continue;
            this.drawGraph(this.D.p, this.graph[n]);
        }
    }

    private void drawMarks(double d, int n) {
        int n2;
        int n3 = 0;
        int n4 = this.w;
        int n5 = 0;
        int n6 = this.h;
        if (n >= 0) {
            n3 = this.Ox - n;
            n4 = this.Ox + n;
            n5 = this.Oy - n;
            n6 = this.Oy + n;
        }
        if (this.D.cfg.x_On && n > 0 || n < 0) {
            int n7;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n7 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                this.bg.drawLine(n7, n5, n7, n6);
                ++n2;
            }
        }
        if (this.D.cfg.y_On && n > 0 || n < 0) {
            int n8;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n8 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                this.bg.drawLine(n3, n8, n4, n8);
                ++n2;
            }
        }
    }

    private void drawNumbers(double d, int n) {
        int n2;
        if (this.D.cfg.x_On) {
            int n3;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n3 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                this.bg.drawString(mjaStr.DoubleToString((double)n2 * d / this.esc, 4, false), n3 + 2, this.Oy - 2);
                ++n2;
            }
        }
        if (this.D.cfg.y_On) {
            int n4;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n4 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                this.bg.drawString(mjaStr.DoubleToString(-((double)n2) * d / this.esc, 4, false), this.Ox + 2, n4 - 2);
                ++n2;
            }
        }
    }

    void draw(boolean bl, boolean bl2, boolean bl3) {
        if (this.initializeGraphicStuff() || bl2) {
            this.drawBackground();
        }
        if (this.fillInFront) {
            this.fg.setColor(data.adaptColor(this.D, this.DC[0]));
            this.fg.fillRect(0, 0, this.w, this.h);
        }
        if (bl3 && this.D.cfg.animCfg.active) {
            this.alg = new Algorithm(this.D.p, false, this.D.cfg.animCfg.s_do, this.D.cfg.animCfg.s_ini, this.D.cfg.animCfg.s_while);
            this.alg.initialize();
        }
        if (bl && this.D.cfg.animCfg.active) {
            this.stop();
            this.start();
        } else if (this.thr == null || !this.thr.isAlive() || this.pause) {
            this.drawFront();
        }
    }

    private void animDraw() {
        this.D.doCalculations(false);
        if (this.initializeGraphicStuff()) {
            this.drawBackground();
        }
        if (this.fillInFront) {
            this.fg.setColor(data.adaptColor(this.D, this.DC[0]));
            this.fg.fillRect(0, 0, this.w, this.h);
        }
        this.drawFront();
    }

    private void drawFront() {
        int n;
        this.ig.drawImage(this.back, 0, 0, this);
        for (n = 0; n < this.control.length; ++n) {
            this.control[n].adjust();
        }
        for (n = 0; n < this.graph.length; ++n) {
            if (this.graph[n] == null || this.graph[n].gc.isInBack) continue;
            this.drawGraph(this.D.p, this.graph[n]);
        }
        for (n = 0; n < this.control.length; ++n) {
            if (this.control[n].hasTrace) {
                this.control[n].drawControl(true, this.bga);
            }
            this.control[n].drawControl(false, this.fga);
        }
        this.g.drawImage(this.img, 0, 0, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawGraph(Parser parser, mjaGraph mjaGraph2) {
        int n;
        for (n = 0; n < this.bga.length; ++n) {
            if (mjaGraph2.gc.isInBack) {
                this.bga[n].setColor(data.adaptColor(this.D, mjaGraph2.gc.gcolor));
                continue;
            }
            this.bga[n].setColor(data.adaptColor(this.D, mjaGraph2.gc.traceColor));
        }
        for (n = 0; n < this.fga.length; ++n) {
            this.fga[n].setColor(data.adaptColor(this.D, mjaGraph2.gc.gcolor));
        }
        if (mjaGraph2.sparz != null) {
            Node node;
            Node node2 = node = parser.Var(mjaGraph2.sparz.name);
            synchronized (node2) {
                double d = node.r;
                int n2 = (int)Math.round(mjaGraph2.sparz.NN.Evaluate(32.0));
                double d2 = mjaGraph2.sparz.Ni.Evaluate(0.0);
                double d3 = mjaGraph2.sparz.Nf.Evaluate(1.0);
                for (int i = 0; i <= n2; ++i) {
                    node.r = d2 + (d3 - d2) * (double)i / (double)n2;
                    this.drawGraph(mjaGraph2);
                }
                node.r = d;
            }
        } else {
            this.drawGraph(mjaGraph2);
        }
    }

    private void drawGraph(mjaGraph mjaGraph2) {
        if (mjaGraph2.gc.isInBack) {
            mjaGraph2.draw(this.back, this.bga);
        } else if (mjaGraph2.gc.hasTrace) {
            mjaGraph2.draw(this.front, this.tga);
        } else {
            mjaGraph2.draw(this.front, this.fga);
        }
    }

    private void writeCoordinates(int n, int n2) {
        if (this.textOn) {
            int n3;
            int n4;
            int n5;
            Graphics graphics = this.getGraphics();
            graphics.setFont(mjaGui.Courier);
            graphics.setColor(data.adaptColor(this.D, this.DC[4]));
            graphics.drawOval(n - 2, n2 - 2, 4, 4);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = 0;
            while (this.esc > Math.pow(10.0, n6)) {
                ++n6;
            }
            if (n6 > 0) {
                ++n6;
            }
            String string = "(" + mjaStr.DoubleToString((double)(n - this.Ox) / this.esc, n6) + "," + mjaStr.DoubleToString((double)(this.Oy - n2) / this.esc, n6) + ")";
            int n7 = fontMetrics.stringWidth(string);
            int n8 = n - n7 / 2;
            int n9 = n2 - 12;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > (n5 = this.getSize().width - n7)) {
                n8 = n5;
            }
            if (n9 < (n4 = fontMetrics.getAscent())) {
                n9 = n4;
            }
            if (n9 > (n3 = this.getSize().height - fontMetrics.getDescent())) {
                n9 = n3;
            }
            graphics.drawString(string, n8, n9);
        }
    }

    public void paint(Graphics graphics) {
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void start() {
        this.pause = false;
        this.onestep = false;
        if (this.D.cfg.animCfg.controls) {
            this.animCtrl.setBounds((this.w - this.animCtrl.getSize().width) / 2, this.h - this.animCtrl.getSize().height, this.animCtrl.getSize().width, this.animCtrl.getSize().height);
            this.b[0].type = -1;
            this.animCtrl.setVisible(true);
        }
        this.thr = new Thread(this);
        this.thr.start();
    }

    void stop() {
        this.animCtrl.setVisible(false);
        this.D.animEnded();
        this.running = false;
        if (this.thr != null) {
            this.thr.stop();
            this.thr = null;
        }
    }

    public void run() {
        this.D.animStarted();
        this.running = true;
        Node node = this.D.p.Analyse(this.D.cfg.animCfg.s_delay, "60");
        this.animDraw();
        this.stay = false;
        try {
            do {
                long l = System.currentTimeMillis() + Math.round(node.Evaluate(50.0));
                Thread.sleep(20L);
                if (!this.pause || this.onestep) {
                    this.stay = false;
                    this.alg.step();
                    this.onestep = false;
                    this.animDraw();
                }
                while (System.currentTimeMillis() < l) {
                    Thread.sleep(20L);
                }
            } while (this.alg.repeat() || this.stay || this.D.cfg.animCfg.loop);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stop();
    }

    static void limitExceeded() {
        mjaGui.ask(null, "Descartes", " \u00a1Se ha excedidio el l\u00edmite de\n 100000 repeticiones en un algoritmo!", "ok", null);
    }

    void backStep() {
        try {
            this.alg.backstep();
            this.animDraw();
        }
        catch (Exception exception) {
            R2Space.limitExceeded();
        }
    }

    void toEnd() {
        try {
            this.alg.toEnd();
            this.stay = true;
            this.animDraw();
        }
        catch (Exception exception) {
            R2Space.limitExceeded();
        }
    }

    void setActiveControl(int n) {
        if (n < 0) {
            n = this.control.length - 1;
        }
        if (n >= this.control.length) {
            n = 0;
        }
        for (int i = 0; i < this.control.length; ++i) {
            this.control[i].isActive = false;
        }
        this.control[n].isActive = true;
        this.aC = this.control[n];
        this.acix = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b[0]) {
            this.pause = !this.pause;
        } else if (actionEvent.getSource() == this.b[2]) {
            boolean bl = this.pause;
            this.stop();
            this.alg.initialize();
            this.animDraw();
            this.start();
            this.pause = bl;
        } else if (actionEvent.getSource() == this.b[3]) {
            this.pause = true;
            this.backStep();
        } else if (actionEvent.getSource() == this.b[4]) {
            this.pause = true;
            this.onestep = true;
        } else if (actionEvent.getSource() == this.b[5]) {
            this.pause = true;
            this.toEnd();
        } else if (actionEvent.getSource() == this.b[1]) {
            this.stop();
        }
        this.b[0].type = this.pause ? 0 : -1;
        this.b[0].repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.D.showExternalSpinners();
        } else {
            if (this.aC != null) {
                this.aC.isActive = false;
                this.D.draw(false, false);
            }
            this.aC = null;
            for (int i = 0; i < this.control.length; ++i) {
                R2 r2 = new R2(mouseEvent.getX(), mouseEvent.getY());
                if (!(this.projection(this.control[i].cpos).distance(r2) < (double)(this.control[i].size + 1))) continue;
                this.setActiveControl(i);
                this.D.draw(false, false);
                return;
            }
            this.writeCoordinates(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.aC != null) {
            this.D.draw(false, false);
            this.requestFocus();
        } else {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            this.D.showExternalSpinners();
        } else if (mouseEvent.getClickCount() == 2) {
            R2Space r2Space = this;
            if (r2Space.D.inNippeEditor()) {
                this.D.edit();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.aC != null) {
            this.aC.setControlPos(mouseEvent.getX(), mouseEvent.getY());
            this.D.draw(false, false);
        } else {
            this.g.drawImage(this.img, 0, 0, this);
            this.writeCoordinates(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this && this.control.length > 0) {
            if (this.aC == null) {
                this.setActiveControl(0);
            }
            if (this.aC != null) {
                Control control = this.aC;
                R2 r2 = this.aC.getControlPos();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        r2.x -= 1.0;
                        break;
                    }
                    case 39: {
                        r2.x += 1.0;
                        break;
                    }
                    case 38: {
                        r2.y -= 1.0;
                        break;
                    }
                    case 40: {
                        r2.y += 1.0;
                        break;
                    }
                    case 9: {
                        if (keyEvent.getModifiers() == 1) {
                            --this.acix;
                            if (this.acix < 0) {
                                this.acix = this.control.length - 1;
                            }
                        } else {
                            ++this.acix;
                            if (this.acix >= this.control.length) {
                                this.acix = 0;
                            }
                        }
                        this.setActiveControl(this.acix);
                        keyEvent.consume();
                    }
                }
                control.setControlPos(r2.x, r2.y);
            }
            this.D.draw(false, false);
        } else if (keyEvent.getSource() instanceof TextField && keyEvent.getKeyCode() == 10) {
            for (int i = 0; i < this.graph.length; ++i) {
                if (this.graph[i].TF != keyEvent.getSource()) continue;
                if (!this.graph[i].gc.isEditable) break;
                this.graph[i].gc.formula = this.graph[i].TF.getText();
                this.graph[i].analyse();
                if (this.graph[i].gc.isInBack) {
                    this.drawBackground();
                }
                this.D.draw(false, false);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

