/*
 * Decompiled with CFR 0.152.
 */
package org.jfxtras.stage;

import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.swing.SwingScene;
import com.sun.javafx.tk.swing.WindowStage;
import com.sun.scenario.Settings;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jfxtras.stage.TransparentSwingScene;

public class WindowHelper {
    private static Boolean transparencySupported = null;

    private static final boolean isMac() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    private static final boolean isLinux() {
        return "Linux".equalsIgnoreCase(System.getProperty("os.name"));
    }

    private static final boolean isSolaris() {
        return "Solaris".equalsIgnoreCase(System.getProperty("os.name"));
    }

    private static final boolean isTransparencySupported() {
        if (transparencySupported == null) {
            if (WindowHelper.isLinux() || WindowHelper.isSolaris()) {
                boolean trans = false;
                transparencySupported = Settings.getBoolean((String)"javafx.allowTransparentStage", (boolean)trans);
            } else {
                transparencySupported = true;
            }
            if (!transparencySupported.booleanValue()) {
                System.err.println("Warning: Transparent windows are not supported by the current platform.");
            }
        }
        return transparencySupported;
    }

    public static Window extractWindow(Stage stage) {
        return stage == null ? null : ((WindowStage)stage.get$javafx$stage$Stage$impl_peer()).window;
    }

    static void setStagePeer(Stage stage, TKStage peer) {
        stage.set$javafx$stage$Stage$impl_peer(peer);
        peer.setTKStageListener((TKStageListener)stage.get$javafx$stage$Stage$stageListener());
        peer.setTitle(stage.get$title());
        peer.setResizable(stage.get$resizable());
        if (stage.get$javafx$stage$Stage$impl_peer() instanceof WindowStage) {
            Window oldWindow = ((WindowStage)stage.get$javafx$stage$Stage$impl_peer()).window;
            try {
                Method iconImagesMethod = Window.class.getMethod("getIconImages", null);
                if (iconImagesMethod != null) {
                    peer.setIcons((List)iconImagesMethod.invoke((Object)oldWindow, new Object[0]));
                }
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(WindowHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(WindowHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(WindowHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(WindowHelper.class.getName()).log(Level.SEVERE, "Icons on Dialogs only supported on Java 6 or later", ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(WindowHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        peer.setOpacity(stage.get$opacity());
        peer.setIconified(stage.get$iconified());
        peer.setFullScreen(stage.get$fullScreen());
        if (stage.get$scene() != null) {
            peer.setScene(stage.get$scene().get$javafx$scene$Scene$impl_peer());
        }
        peer.initSecurityContext();
    }

    static SwingScene setTransparentScenePeer(Scene scene) {
        if (scene == null) {
            return null;
        }
        SwingScene oldPeer = (SwingScene)scene.get$javafx$scene$Scene$impl_peer();
        TransparentSwingScene newPeer = new TransparentSwingScene(scene);
        newPeer.setRoot((PGNode)oldPeer.scenePanel.getScene());
        newPeer.setCursor(oldPeer.scenePanel.getCursor());
        newPeer.setFillPaint(oldPeer.scenePanel.getBackgroundPaint());
        Dimension size = oldPeer.scenePanel.getPreferredSize();
        newPeer.setContentSize(size.width, size.height);
        scene.set$javafx$scene$Scene$impl_peer((TKScene)newPeer);
        return newPeer;
    }

    static GraphicsConfiguration getTransparentGraphicsConfiguration() {
        try {
            Class<?> c = Class.forName("com.sun.awt.AWTUtilities");
            Method isTC = c.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            GraphicsConfiguration translucencyCapableGC = null;
            for (int i = 0; i < devices.length && translucencyCapableGC == null; ++i) {
                GraphicsConfiguration[] configs = devices[i].getConfigurations();
                for (int j = 0; j < configs.length && translucencyCapableGC == null; ++j) {
                    Boolean res = (Boolean)isTC.invoke(null, configs[j]);
                    if (!res.booleanValue()) continue;
                    translucencyCapableGC = configs[j];
                    System.out.println("FOUND translucency capable GC: " + configs[j]);
                }
            }
            return translucencyCapableGC;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    static JFrame createJFrame(StageStyle style) {
        JFrame frame;
        if (WindowHelper.isMac()) {
            frame = new JFrame(){

                protected JRootPane createRootPane() {
                    JRootPane rp = new JRootPane(){

                        public void paint(Graphics g) {
                            g.clearRect(0, 0, this.getWidth(), this.getHeight());
                            super.paint(g);
                        }
                    };
                    rp.setOpaque(true);
                    return rp;
                }
            };
        } else if ((WindowHelper.isLinux() || WindowHelper.isSolaris()) && style == StageStyle.TRANSPARENT && WindowHelper.isTransparencySupported()) {
            GraphicsConfiguration xpgc = WindowHelper.getTransparentGraphicsConfiguration();
            frame = new JFrame(xpgc);
        } else {
            frame = new JFrame();
        }
        frame.setBackground(Color.WHITE);
        return frame;
    }

    static JFrame createJFrame(Window owner) {
        JFrame dialog = new JFrame();
        dialog.setBackground(Color.WHITE);
        return dialog;
    }

    static JDialog createJDialog(StageStyle style, Window owner) {
        JDialog dialog;
        if (WindowHelper.isMac()) {
            dialog = owner instanceof Frame ? new MacJDialog((Frame)owner) : (owner instanceof Dialog ? new MacJDialog((Frame)owner) : new MacJDialog(owner));
        } else if ((WindowHelper.isLinux() || WindowHelper.isSolaris()) && style == StageStyle.TRANSPARENT && WindowHelper.isTransparencySupported()) {
            GraphicsConfiguration xpgc = WindowHelper.getTransparentGraphicsConfiguration();
            dialog = owner instanceof Frame ? new JDialog((Frame)owner, null, false, xpgc) : (owner instanceof Dialog ? new JDialog((Dialog)owner, null, false, xpgc) : new JDialog());
        } else {
            dialog = owner instanceof Frame ? new JDialog((Frame)owner) : (owner instanceof Dialog ? new JDialog((Dialog)owner) : new JDialog());
        }
        dialog.setBackground(Color.WHITE);
        return dialog;
    }

    private static class MacJDialog
    extends JDialog {
        public MacJDialog(Frame owner) {
            super(owner);
        }

        public MacJDialog(Dialog owner) {
            super(owner);
        }

        public MacJDialog(Window owner) {
        }

        protected JRootPane createRootPane() {
            JRootPane rp = new JRootPane(){

                public void paint(Graphics g) {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    super.paint(g);
                }
            };
            rp.setOpaque(true);
            return rp;
        }
    }
}

