/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.descartes;

import com.jla.desc2.descartes.Descartes;
import com.jla.desc2.descartes.data;
import com.jla.desc2.descartes.mjaGraph;
import com.jla.desc2.gui.mjaGui;
import com.jla.desc2.math.R2;
import com.jla.desc2.math.R2Newton;
import com.jla.desc2.parser.Node;
import com.jla.desc2.util.Attribute;
import com.jla.desc2.util.mjaStr;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public class Control {
    public R2 cpos;
    public int size;
    public String controlName;
    public String s_decimals = "2";
    public String s_size = "4";
    public String s_constraint;
    public String text;
    public String s_initialPos = "(0,0)";
    public String s_cond;
    public Font font = mjaGui.Courier;
    public Color ccolor = Color.blue;
    public Color icolor = Color.red;
    public Color tcolor = Color.gray;
    public boolean hasTrace;
    public static final String _x = ".x";
    public static final String _y = ".y";
    private Descartes D;
    private Vector[] pstr;
    private Node constraint;
    private Node decimals;
    private Node cond;
    private Node funcOfX;
    private Node funcOfY;
    private R2Newton newt;
    boolean isActive;

    Control(int n, String string) {
        this.controlName = string;
    }

    Control(int n, String string, String string2) {
        this(n, string);
        Attribute[] attributeArray = Attribute.parse(string2);
        this.s_initialPos = data.getValue(n, attributeArray, 55);
        this.text = data.getValue(n, attributeArray, 63);
        this.text = mjaStr.replace(this.text, "\\n", "\n");
        this.font = mjaStr.parseFont(data.getValue(n, attributeArray, 92), this.font);
        this.ccolor = data.parseColor(data.getValue(n, attributeArray, 13), this.ccolor, this.ccolor);
        this.icolor = data.parseColor(data.getValue(n, attributeArray, 125), this.icolor, this.icolor);
        String string3 = data.getValue(n, attributeArray, 10);
        this.hasTrace = mjaStr.hasContent(string3);
        if (this.hasTrace) {
            this.tcolor = data.parseColor(string3, this.tcolor, this.tcolor);
        }
        this.s_decimals = data.getValue(n, attributeArray, 17, this.s_decimals);
        this.s_size = data.getValue(n, attributeArray, 16, this.s_size);
        this.s_constraint = data.getValue(n, attributeArray, 58);
        this.s_cond = data.getValue(n, attributeArray, 107);
    }

    String toString(String string, int n) {
        String string2 = data.toString(string, n, 55, "'" + this.s_initialPos + "'");
        string2 = string2 + data.toString(string, n, 13, mjaStr.getColorName(data.colorName[n], this.ccolor), data.newName[n][20]);
        string2 = string2 + data.toString(string, n, 125, mjaStr.getColorName(data.colorName[n], this.icolor), data.newName[n][25]);
        string2 = string2 + data.toString(string, n, 63, "'" + mjaStr.replace(this.text, "\n", "\\n") + "'");
        string2 = string2 + data.toString(string, n, 17, "'" + this.s_decimals + "'", "2");
        string2 = string2 + data.toString(string, n, 16, this.s_size, "4");
        string2 = string2 + data.toString(string, n, 107, "'" + this.s_cond + "'");
        if (this.hasTrace) {
            string2 = string2 + data.toString(string, n, 10, mjaStr.getColorName(data.colorName[n], this.tcolor));
        }
        if (mjaStr.hasContent(this.s_constraint)) {
            string2 = string2 + data.toString(string, n, 58, "'" + this.s_constraint + "'");
        }
        if (!this.font.equals(mjaGui.Courier)) {
            string2 = string2 + data.toString(string, n, 92, mjaStr.FontToString(this.font));
        }
        return string2.trim();
    }

    void Initialize(Descartes descartes) {
        Node node;
        this.D = descartes;
        String[] stringArray = mjaStr.toStringArray(this.text);
        this.pstr = new Vector[stringArray.length];
        for (int i = 0; i < this.pstr.length; ++i) {
            this.pstr[i] = descartes.p.parseString(stringArray[i]);
        }
        this.size = mjaStr.parseInteger(this.s_size, 2, 2);
        if (mjaStr.hasContent(this.s_constraint)) {
            this.constraint = descartes.p.Analyse(this.s_constraint);
            if (this.constraint.getSymbol().equals("=")) {
                Node node2 = this.constraint.getLeft();
                node = this.constraint.getRight()[0];
                if (node2.getSymbol().equals("y") && !node.contains("y")) {
                    this.funcOfX = node;
                } else if (node2.getSymbol().equals("x") && !node.contains("x")) {
                    this.funcOfY = node;
                }
                this.constraint.equalToMinus();
                this.newt = new R2Newton(descartes.p, this.constraint);
            } else {
                this.constraint = null;
            }
        }
        this.decimals = descartes.p.Analyse(this.s_decimals, 2.0);
        this.cond = descartes.p.Analyse(this.s_cond, "1");
        this.cpos = new R2(0.0, 0.0);
        try {
            stringArray = mjaStr.getTokens(this.s_initialPos);
            if (stringArray.length >= 2) {
                Node node3 = descartes.p.Analyse(stringArray[0]);
                node = descartes.p.Analyse(stringArray[1]);
                this.cpos = new R2(node3.Evaluate(0.0), node.Evaluate(0.0));
            } else {
                System.out.println("wrong expression: " + this.s_initialPos);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        descartes.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_x).toString()).r = this.cpos.x;
        descartes.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_y).toString()).r = this.cpos.y;
    }

    void setControlPos(double d, double d2) {
        this.cpos = this.D.cs.injection(d, d2);
        if (this.constraint != null) {
            try {
                this.cpos = this.newt.findZero(this.cpos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.D.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_x).toString()).r = this.cpos.x;
        this.D.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_y).toString()).r = this.cpos.y;
        this.D.updateSpinners();
    }

    R2 getControlPos() {
        return this.D.cs.projection(this.cpos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjust() {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                double d3 = this.cpos.x;
                double d4 = this.cpos.y;
                this.cpos.x = this.D.p.value(this.controlName + _x);
                this.cpos.y = this.D.p.value(this.controlName + _y);
                node.r = this.cpos.x;
                node2.r = this.cpos.y;
                if (this.constraint != null) {
                    try {
                        if (this.funcOfX != null && this.cpos.x != d3) {
                            this.cpos.y = this.funcOfX.Evaluate();
                        } else if (this.funcOfY != null && this.cpos.y != d4) {
                            this.cpos.x = this.funcOfY.Evaluate();
                        } else {
                            this.cpos = this.newt.findZero(this.cpos);
                        }
                    }
                    catch (Exception exception) {
                        this.cpos.x = d3;
                        this.cpos.y = d3;
                    }
                }
                this.D.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_x).toString()).r = this.cpos.x;
                this.D.p.Var((String)new StringBuilder().append((String)this.controlName).append((String)_y).toString()).r = this.cpos.y;
                node.r = d;
                node2.r = d2;
            }
        }
        this.D.updateSpinners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawControl(boolean bl, Graphics[] graphicsArray) {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.r;
                double d2 = node2.r;
                node.r = this.cpos.x;
                node2.r = this.cpos.y;
                if (this.cond.Evaluate(1.0) > 0.0) {
                    R2 r2 = this.D.cs.projection(this.cpos);
                    for (int i = 0; i < graphicsArray.length; ++i) {
                        if (bl) {
                            graphicsArray[i].setColor(this.tcolor);
                            graphicsArray[i].drawOval(r2.ix() - this.size, r2.iy() - this.size, 2 * this.size, 2 * this.size);
                            continue;
                        }
                        graphicsArray[i].setColor(this.icolor);
                        mjaGraph.circle(graphicsArray[i], r2.ix(), r2.iy(), this.size);
                        if (this.isActive) {
                            graphicsArray[i].setColor(mjaGui.bestContrast(this.icolor));
                            graphicsArray[i].drawOval(r2.ix() - this.size + 2, r2.iy() - this.size + 2, 2 * this.size - 4, 2 * this.size - 4);
                        }
                        graphicsArray[i].setColor(this.ccolor);
                        graphicsArray[i].drawOval(r2.ix() - this.size, r2.iy() - this.size, 2 * this.size, 2 * this.size);
                    }
                    if (!bl) {
                        this.drawText(r2, graphicsArray);
                    }
                }
                node.r = d;
                node2.r = d2;
            }
        }
    }

    void drawText(R2 r2, Graphics[] graphicsArray) {
        if (this.D.cs.inside(r2)) {
            for (int i = 0; i < graphicsArray.length; ++i) {
                graphicsArray[i].setFont(this.font);
                FontMetrics fontMetrics = graphicsArray[i].getFontMetrics(this.font);
                for (int j = 0; j < this.pstr.length; ++j) {
                    String string = "";
                    int n = 0;
                    n += j * fontMetrics.getHeight();
                    int n2 = (int)Math.round(this.decimals.Evaluate(2.0));
                    for (int k = 0; k < this.pstr[j].size(); ++k) {
                        Node node = (Node)this.pstr[j].elementAt(k);
                        string = string + node.toString(n2, this.D.language);
                    }
                    graphicsArray[i].drawString(string, r2.ix() + this.size, n + r2.iy() - this.size);
                }
            }
        }
    }
}

