/*
 * Decompiled with CFR 0.152.
 */
package com.mja.parser;

import com.jla.nippe.LMSApplet;
import com.jla.nippe.NotSoAbstractNippe;
import com.mja.file.mjaFile;
import com.mja.gui.mjaText;
import com.mja.parser.Algorithm;
import com.mja.parser.Node;
import com.mja.util.BasicStr;
import edu.lite.radial.RadialServices;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unam.matem.Attribute;

public class Parser {
    public LMSApplet lms_applet;
    public NotSoAbstractNippe nsa_nippe;
    public static final String pi = "\u03c0";
    private Vector dataFiles = new Vector();
    private Hashtable FS;
    private Hashtable VS;
    private Hashtable XS;
    private Hashtable FAS;
    private Hashtable AS;
    private Hashtable MS;
    private Vector ALS;
    public static final int DESCARTES = 1;
    public static final int ATUTOR = 2;
    public static final int PECEI = 3;
    private int option = 1;
    String whereIsIt = "";
    static final String RADIAL = "--radial--";

    public Parser(NotSoAbstractNippe notSoAbstractNippe) {
        this(1);
        this.nsa_nippe = notSoAbstractNippe;
        Node.C = notSoAbstractNippe;
        if (notSoAbstractNippe instanceof LMSApplet) {
            this.lms_applet = (LMSApplet)notSoAbstractNippe;
        }
    }

    public Parser(int n) {
        this.option = n;
        this.renew();
    }

    public void renew() {
        this.dataFiles = new Vector();
        this.FS = new Hashtable();
        this.VS = new Hashtable();
        this.XS = new Hashtable();
        this.FAS = new Hashtable();
        this.AS = new Hashtable();
        this.MS = new Hashtable();
        this.ALS = new Vector();
        switch (this.option) {
            case 1: {
                this.defineVar("e", Math.E);
            }
            case 2: 
            case 3: {
                this.defineVar(pi, Math.PI);
                this.defineVar("pi", Math.PI);
                break;
            }
        }
    }

    public boolean inNippeEditor() {
        if (this.nsa_nippe != null) {
            Parser parser = this;
            return parser.nsa_nippe.inNippeEditor();
        }
        return false;
    }

    private static boolean seemsFileName(String string) {
        return !string.toLowerCase().startsWith("http://") && (string.toLowerCase().endsWith(".mp3") || string.toLowerCase().endsWith(".txt") || string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".jpg") || string.toLowerCase().endsWith(".jpeg"));
    }

    public String[] guessFilenames() {
        int n;
        String[] stringArray;
        String[] stringArray2;
        Vector<Object> vector = new Vector<Object>();
        String string = BasicStr.decimal_symbol;
        BasicStr.decimal_symbol = ".";
        Enumeration enumeration = this.VS.elements();
        while (enumeration.hasMoreElements()) {
            stringArray2 = (String[])enumeration.nextElement();
            stringArray = stringArray2.getString();
            if (!Parser.seemsFileName((String)stringArray)) continue;
            vector.addElement(stringArray);
        }
        enumeration = this.AS.elements();
        while (enumeration.hasMoreElements()) {
            stringArray2 = (Node)enumeration.nextElement();
            stringArray = stringArray2.sarray;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null || !Parser.seemsFileName(stringArray[n])) continue;
                vector.addElement(stringArray[n]);
            }
        }
        enumeration = this.MS.elements();
        while (enumeration.hasMoreElements()) {
            stringArray2 = (Node)enumeration.nextElement();
            stringArray = stringArray2.smatrix;
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < ((String)stringArray[n]).length; ++i) {
                    if (stringArray[n][i] == null || !Parser.seemsFileName(stringArray[n][i])) continue;
                    vector.addElement(stringArray[n][i]);
                }
            }
        }
        BasicStr.decimal_symbol = string;
        stringArray2 = new String[vector.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    public String dump() {
        int n;
        String[] stringArray;
        Object object;
        Node node;
        String string = BasicStr.decimal_symbol;
        BasicStr.decimal_symbol = ".";
        String string2 = "";
        Enumeration enumeration = this.VS.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            if (!this.isVar(node.toExpression())) continue;
            string2 = string2 + node.toExpression() + " = " + node.getString() + "\n";
        }
        enumeration = this.AS.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            object = this.getRealArray(node.toExpression());
            stringArray = this.getStringArray(node.toExpression());
            for (n = 0; n < ((double[])object).length; ++n) {
                string2 = stringArray[n] != null ? string2 + node.toExpression() + "[" + n + "] = " + stringArray[n] + "\n" : string2 + node.toExpression() + "[" + n + "] = " + object[n] + "\n";
            }
        }
        enumeration = this.MS.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            object = this.getRealMatrix(node.toExpression());
            stringArray = this.getStringMatrix(node.toExpression());
            for (n = 0; n < ((double[])object).length; ++n) {
                for (int i = 0; i < ((double)object[n]).length; ++i) {
                    string2 = stringArray[n][i] != null ? string2 + node.toExpression() + "[" + n + "][" + i + "] = " + stringArray[n][i] + "\n" : string2 + node.toExpression() + "[" + n + "][" + i + "] = " + (double)object[n][i] + "\n";
                }
            }
        }
        BasicStr.decimal_symbol = string;
        return string2;
    }

    public void undump(String string) {
        String[] stringArray = BasicStr.toStringArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            String string2 = stringArray[i].substring(0, n).trim();
            if (!BasicStr.hasContent(string2) || string2.equals("-")) continue;
            String string3 = stringArray[i].substring(n + 1).trim();
            if (string3.startsWith("'") && string3.endsWith("'")) {
                this.Var(string2).setOnlyStr(string3.substring(1, string3.length() - 1));
                continue;
            }
            if (string3.startsWith("{\rtf") && string3.endsWith("}")) {
                this.Var(string2).setOnlyStr(string3);
                continue;
            }
            if (this.isVar(string2)) {
                double d = Double.parseDouble(string3);
                this.Var(string2).setDouble(d);
                continue;
            }
            Algorithm algorithm = new Algorithm("DUMP" + i, this, true, stringArray[i], "", "");
            try {
                algorithm.perform();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String dumpy() {
        String string = BasicStr.decimal_symbol;
        BasicStr.decimal_symbol = ".";
        String string2 = "";
        Enumeration enumeration = this.VS.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!this.isVar(node.toExpression())) continue;
            string2 = string2 + node.toExpression() + " = " + node.getString() + "\n";
        }
        BasicStr.decimal_symbol = string;
        return string2;
    }

    public Attribute[] getState() {
        String string = this.dumpy();
        String[] stringArray = BasicStr.toStringArray(string);
        Attribute[] attributeArray = new Attribute[stringArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            int n = stringArray[i].indexOf("=");
            if (n <= 0) continue;
            String string2 = stringArray[i].substring(0, n).trim();
            String string3 = stringArray[i].substring(n + 1).trim();
            attributeArray[i] = string2.startsWith("public.") ? new Attribute(string2, string3) : new Attribute("", "");
        }
        return attributeArray;
    }

    public boolean adoptValues(Attribute[] attributeArray) {
        boolean bl = false;
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] == null || attributeArray[i].name.length() <= 0 || !this.isVar(attributeArray[i].name)) continue;
            String string = this.Var(attributeArray[i].name).getStr();
            double d = Double.NaN;
            if (string == null) {
                d = this.Var(attributeArray[i].name).getDouble();
            }
            String string2 = BasicStr.trim(attributeArray[i].value, '\'');
            double d2 = Double.NaN;
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = Double.NaN;
            }
            if (string != null) {
                if (string.equals(string2)) continue;
                bl = true;
                this.Var(attributeArray[i].name).setStrAndAnalyse(string2);
                continue;
            }
            if (d == Double.NaN || d == d2) continue;
            bl = true;
            this.Var(attributeArray[i].name).setDouble(d2);
        }
        return bl;
    }

    public void randomizeVariables(double d, double d2, int n) {
        Enumeration enumeration = this.VS.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (pi.equals(string)) continue;
            Node node = this.Var(string);
            int n2 = (int)Math.round(Math.pow(10.0, Math.max(0, Math.min(8, n))));
            double d3 = (d2 - d) * Math.random() + d;
            node.setDouble((double)((int)Math.round(d3 * (double)n2)) / (double)n2);
        }
    }

    private boolean numericallyDifferent(Node node, Node node2) {
        for (int i = 0; i < 20; ++i) {
            this.randomizeVariables(-100.0, 100.0, 8);
            double d = node.Evaluate(Math.random());
            double d2 = node2.Evaluate(Math.random());
            if (!(Math.abs(d - d2) > 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    public boolean areNumericallyEqual(Node node, Node node2) {
        if (node.symb == 9 && node2.symb == 9) {
            Node node3 = Node.Subtract(node.left, node.right[0]);
            Node node4 = Node.Subtract(node2.left, node2.right[0]);
            boolean bl = this.numericallyDifferent(node3, node4);
            node3 = Node.Multiply(node.left, node2.right[0]);
            node4 = Node.Multiply(node2.left, node.right[0]);
            boolean bl2 = this.numericallyDifferent(node3, node4);
            node3 = Node.Multiply(node.left, node2.left);
            node4 = Node.Multiply(node.right[0], node2.right[0]);
            boolean bl3 = this.numericallyDifferent(node3, node4);
            return !bl || !bl2 || !bl3;
        }
        return !this.numericallyDifferent(node, node2);
    }

    public void defineVar(String string, String string2) {
        Node node = new Node(this, string, 0.0);
        node.setOnlyStr(string2);
        this.VS.put(string, node);
    }

    void defineVar(String string, double d) {
        this.VS.put(string, this.Analyse(Double.toString(d), d));
    }

    public Node Var(String string) {
        if (!this.isVar(string)) {
            Node node = null;
            node = string.startsWith("'") && string.endsWith("'") ? new Node(this, BasicStr.trim(string, '\'')) : new Node(this, string, 0.0);
            if (Node.isVarName(string)) {
                this.VS.put(string, node);
            } else {
                return node;
            }
        }
        return (Node)this.VS.get(string);
    }

    public String[][] getVariables() {
        String[][] stringArray = new String[this.VS.size()][2];
        Enumeration enumeration = this.VS.elements();
        Enumeration enumeration2 = this.VS.keys();
        for (int i = 0; i < this.VS.size(); ++i) {
            Node node = (Node)enumeration.nextElement();
            stringArray[i][0] = (String)enumeration2.nextElement();
            stringArray[i][1] = node.getStringValue();
        }
        return stringArray;
    }

    public void defineFunc(String string, String[] stringArray, String string2, boolean bl) {
        Node node;
        Node node2 = (Node)this.FS.get(string);
        Algorithm algorithm = (Algorithm)this.FAS.get(string + ".func-alg");
        if (node2 == null) {
            node2 = new Node(this, string, 0.0);
            this.FS.put(string, node2);
            algorithm = new Algorithm(string);
            this.FAS.put(string + ".func-alg", algorithm);
        }
        node2.var = new Node[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            node2.var[i] = this.Var(stringArray[i]);
        }
        node2.sequence = bl;
        try {
            node = this.Analyse("Function " + string, string2, true, true);
        }
        catch (Exception exception) {
            node = new Node(this, 0.0);
        }
        node2.assign(node);
    }

    public void defineFunc(String string, String[] stringArray, String string2, String string3, boolean bl) {
        this.defineFunc(string, stringArray, string2, bl);
        if (BasicStr.hasContent(string3)) {
            try {
                this.Func((String)string).range = this.Analyse("Function " + string + ".domain", string3, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void defineFunc(String string, String[] stringArray, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this.defineFunc(string, stringArray, string2, string3, bl);
        Node node = this.Func(string);
        Algorithm algorithm = (Algorithm)this.FAS.get(string + ".func-alg");
        Algorithm algorithm2 = new Algorithm(string, this, false, "Function", string5, string6, string7);
        algorithm.assign(algorithm2);
        if (string4 == null) {
            string4 = "";
        }
        String[] stringArray2 = string4.split("\\s*,\\s*");
        node.localVarsList = new Node[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            node.localVarsList[i] = this.Var(stringArray2[i]);
        }
    }

    public void defineExpr(String string, String string2) {
        Node node;
        Node node2 = (Node)this.XS.get(string);
        try {
            node = this.Analyse("Variable " + string, string2, true, true);
        }
        catch (Exception exception) {
            node = new Node(this, 0.0);
        }
        if (node2 != null) {
            node2.assign(node);
        } else {
            Node node3 = new Node(this, string, 0.0);
            node3.assign(node);
            this.XS.put(string, node3);
        }
    }

    public double rvalue(String string) {
        return this.rvalue(string, 0.0);
    }

    private double rvalue(String string, double d) {
        if (this.isAux(string)) {
            return ((Node)this.XS.get(string)).Evaluate(d);
        }
        if (this.isVar(string)) {
            return this.Var(string).getDouble();
        }
        return d;
    }

    public String svalue(String string) {
        if (this.isAux(string)) {
            return ((Node)this.XS.get(string)).getStr();
        }
        if (this.isVar(string)) {
            return this.Var(string).getStr();
        }
        return null;
    }

    public Algorithm funcAlg(String string) {
        if (this.FAS.containsKey(string + ".func-alg")) {
            return (Algorithm)this.FAS.get(string + ".func-alg");
        }
        return null;
    }

    private Node defFunc(String string, String[] stringArray) {
        this.defineFunc(string, stringArray, "0", false);
        return (Node)this.FS.get(string);
    }

    private Node Func(String string) {
        if (this.isFun(string)) {
            return (Node)this.FS.get(string);
        }
        return null;
    }

    public boolean isAux(String string) {
        return this.XS.containsKey(string);
    }

    public boolean isVar(String string) {
        return this.VS.containsKey(string);
    }

    public boolean isArray(String string) {
        return this.AS.containsKey(string);
    }

    public boolean isMatrix(String string) {
        return this.MS.containsKey(string);
    }

    public Node getMatrix(String string) {
        if (this.MS.containsKey(string)) {
            return (Node)this.MS.get(string);
        }
        return null;
    }

    private boolean isFun(String string) {
        return this.FS.containsKey(string);
    }

    private boolean isFunDer(String string) {
        if (string.length() > 1 && string.endsWith("\u00b4")) {
            String string2 = string.substring(0, string.length() - 1);
            return this.isFun(string2);
        }
        return false;
    }

    public static String checkStyle(String string) {
        int n;
        String string2 = "";
        if (string.indexOf("--") >= 0 || string.indexOf("++") >= 0 || string.indexOf("+-") >= 0 || string.indexOf("-+") >= 0) {
            string2 = string2 + "\n signos consecutivos";
        }
        String string3 = new String(string);
        while (string3.length() > 0 && (n = string3.indexOf("((")) >= 0) {
            int n2 = n + string3.substring(n).indexOf("))");
            if (n2 > n) {
                int n3 = 0;
                for (int i = n + 2; i < n2; ++i) {
                    if (string3.charAt(i) == '(') {
                        ++n3;
                        continue;
                    }
                    if (string3.charAt(i) != ')') continue;
                    --n3;
                }
                if (n3 == 0) {
                    string2 = string2 + "\n par\u00e9ntesis innecesarios";
                    break;
                }
            }
            string3 = string3.substring(n + 1);
        }
        if (string2.length() > 0) {
            string2 = "Hay errores de estilo:" + string2;
        }
        return string2;
    }

    public String evaluateString(String string, int n, boolean bl) {
        Vector vector = this.parseString(string);
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof Node) {
                Node node = (Node)vector.elementAt(i);
                double d = node.Evaluate(0.0);
                string2 = string2 + node.getStringValue(n, bl);
                continue;
            }
            string2 = string2 + (String)vector.elementAt(i);
        }
        return string2;
    }

    private Vector parseString(String string) {
        Vector<Object> vector = new Vector<Object>();
        if (BasicStr.hasContent(string)) {
            vector.addElement("");
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == '[') {
                    ++n2;
                } else if (c == ']') {
                    --n2;
                }
                if (n2 == 1 && c == '[' || n2 == 0 && c == ']') {
                    if (stringBuffer.length() > 0) {
                        String string2 = new String(stringBuffer);
                        if (n == 0) {
                            vector.addElement(string2);
                        } else {
                            vector.addElement(this.Analyse(string2));
                        }
                        stringBuffer = new StringBuffer("");
                    }
                    n = 1 - n;
                } else {
                    stringBuffer.append(c);
                }
                if (n2 >= 0) continue;
                n2 = 0;
            }
            String string3 = new String(stringBuffer);
            if (n == 0) {
                vector.addElement(string3);
            } else {
                vector.addElement(this.Analyse(string3));
            }
        }
        return vector;
    }

    public Node Analyse(String string, double d) {
        return this.Analyse(string, Double.toString(d));
    }

    public Node Analyse(String string, String string2) {
        Node node = this.Analyse(string);
        if (node == null) {
            node = this.Analyse(string2);
        }
        return node;
    }

    public Node Analyse(String string) {
        Node node = null;
        try {
            node = this.Analyse("", string, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    Node Analyse(String string, String string2, boolean bl) throws Exception {
        return this.Analyse(string, string2, bl, true);
    }

    /*
     * Unable to fully structure code
     */
    public Node Analyse(String var1_1, String var2_2, boolean var3_3, boolean var4_4) throws Exception {
        this.whereIsIt = var1_1;
        var5_5 = new String(var2_2);
        if (!BasicStr.hasContent(var5_5)) {
            return null;
        }
        if (var5_5.startsWith("|") && var5_5.endsWith("|")) {
            var5_5 = BasicStr.replace(var5_5, "|", "'");
        }
        if (!var5_5.startsWith("'")) {
            var5_5 = BasicStr.replace(var5_5, "\u00b2", "^2");
            var5_5 = BasicStr.replace(var5_5, "\u00b3", "^3");
        }
        if (var5_5.startsWith("'") && var5_5.indexOf(1, 39) == var5_5.length() - 1) {
            var6_6 = new Node(this, 0.0);
            var6_6.setOnlyStr(BasicStr.trim(var5_5, '\''));
            return var6_6;
        }
        var6_7 = Node.getTokens(var5_5);
        var7_8 = new Stack<E>();
        var8_9 = new Stack<Object>();
        var9_10 = false;
        var10_11 = 0;
        var11_12 = false;
        var12_13 = false;
        var13_14 = false;
        var14_15 = 0;
        block17: while (var14_15 < var6_7.length) {
            block42: {
                var15_16 = var6_7[var14_15++];
                var16_17 = null;
                if (var14_15 < var6_7.length && (var6_7[var14_15].startsWith("(") || var6_7[var14_15].startsWith("["))) {
                    if (var14_15 < var6_7.length && var6_7[var14_15].startsWith("[")) {
                        var16_17 = this.isMatrix(var15_16) ? new Node(this, var15_16, this.Matrix(var15_16), true) : new Node(this, var15_16, this.Array(var15_16), false);
                    } else if (this.isFun(var15_16)) {
                        var16_17 = new Node(this, var15_16, false, this.Func(var15_16), this.funcAlg(var15_16));
                    } else if (this.isFunDer(var15_16)) {
                        var17_18 = var15_16.substring(0, var15_16.length() - 1);
                        var16_17 = new Node(this, var15_16, true, this.Func((String)var17_18), this.funcAlg((String)var17_18));
                    } else if (var14_15 < var6_7.length && var6_7[var14_15].startsWith("(") && Node.symbol(var15_16) == 75) {
                        var16_17 = new Node(this, var15_16, false, this.defFunc(var15_16, new String[0]), this.funcAlg(var15_16));
                        var16_17.predefined = true;
                        var16_17.level = var7_8.size();
                    }
                }
                if (var16_17 == null) {
                    var16_17 = new Node(this, var15_16, this.isVar(var15_16));
                }
                switch (var16_17.type) {
                    case 3: 
                    case 4: 
                    case 15: 
                    case 16: {
                        var12_13 = true;
                        break;
                    }
                    case 12: {
                        var16_17.type = var12_13 == false ? 13 : 9;
                    }
                    default: {
                        var12_13 = false;
                    }
                }
                if (var16_17.type == 1) break block42;
                if (var16_17.type == 4) {
                    var9_10 = true;
                    if (var10_11 > 0) {
                        --var10_11;
                        while (true) {
                            var17_18 = (Node)var8_9.pop();
                            if (var17_18.type == 2) {
                                if (var8_9.empty()) continue block17;
                                var18_19 = (Node)var8_9.peek();
                                if (var18_19.type != 14) continue block17;
                                var18_19.right = new Node[var18_19.NumVars()];
                                continue block17;
                            }
                            this.addNode(var7_8, (Node)var17_18, var3_3, var4_4);
                        }
                    }
                    this.Error("too many ) in " + var5_5, var4_4);
                    continue;
                }
                if (!var9_10) {
                    switch (var16_17.type) {
                        case 2: {
                            ++var10_11;
                        }
                        case 13: 
                        case 14: {
                            var8_9.push(var16_17);
                            continue block17;
                        }
                        case 15: 
                        case 16: {
                            this.addNode(var7_8, var16_17, var3_3, var4_4);
                            var9_10 = true;
                            continue block17;
                        }
                        case 17: {
                            this.addNode(var7_8, var16_17, var3_3, var4_4);
                            var9_10 = true;
                            continue block17;
                        }
                    }
                    this.Error("expression expected in " + var5_5 + "\nAt token " + var14_15 + " \"" + var16_17.getSymbol() + "\"", var4_4);
                    continue;
                }
                switch (var16_17.type) {
                    case 3: {
                        if (var10_11 <= 0) ** GOTO lbl97
                        while (true) {
                            var17_18 = (Node)var8_9.pop();
                            if (var17_18.type != 2) ** GOTO lbl95
                            var8_9.push(var17_18);
                            ** GOTO lbl98
lbl95:
                            // 1 sources

                            this.addNode(var7_8, (Node)var17_18, var3_3, var4_4);
                        }
lbl97:
                        // 1 sources

                        this.Error(", not expected in " + var5_5, var4_4);
lbl98:
                        // 2 sources

                        var9_10 = false;
                        var12_13 = false;
                        continue block17;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        while (!var8_9.isEmpty()) {
                            var17_18 = (Node)var8_9.peek();
                            if (var17_18.type < var16_17.type) break;
                            this.addNode(var7_8, (Node)var8_9.pop(), var3_3, var4_4);
                        }
                        var8_9.push(var16_17);
                        var9_10 = false;
                        continue block17;
                    }
                    case 11: {
                        while (!var8_9.isEmpty()) {
                            var17_18 = (Node)var8_9.peek();
                            if (var17_18.type <= var16_17.type || var17_18.type == 13) break;
                            this.addNode(var7_8, (Node)var8_9.pop(), var3_3, var4_4);
                        }
                        var8_9.push(var16_17);
                        var9_10 = false;
                        continue block17;
                    }
                }
                this.Error("operator expected in " + var5_5 + "\nAt token " + var14_15 + " \"" + var16_17.getSymbol() + "\"", var4_4);
                continue;
            }
            if (!var9_10) {
                this.Error("incomplete expression " + var5_5, var4_4);
            }
            if (var10_11 > 0) {
                this.Error(") expected in " + var5_5, var4_4);
            }
            while (!var8_9.isEmpty()) {
                this.addNode(var7_8, (Node)var8_9.pop(), var3_3, var4_4);
            }
            var17_18 = (Node)var7_8.peek();
            try {
                Node.check((Node)var17_18);
            }
            catch (Exception var18_20) {
                System.out.println("NOT OK expr=" + var5_5 + " //" + var3_3);
                var18_20.printStackTrace();
            }
            return var17_18;
        }
        this.Error("Parser internal error.", var4_4);
        return null;
    }

    private void addNode(Stack stack, Node node, boolean bl, boolean bl2) throws Exception {
        switch (node.type) {
            case 13: {
                node.right = new Node[1];
            }
            case 14: {
                int n;
                Node node2 = this.Func(node.getSymbol());
                if (node2 != null && node.predefined) {
                    n = stack.size() - node.level;
                    node.right = new Node[n];
                    node2.var = new Node[n];
                    for (int i = 0; i < n; ++i) {
                        node2.var[i] = this.Var("x" + i);
                    }
                }
                for (n = node.right.length - 1; n >= 0; --n) {
                    if (stack.isEmpty()) continue;
                    node.right[n] = (Node)stack.pop();
                }
                if (node2 == null || !node.predefined) break;
                node.predefined = false;
                break;
            }
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                node.right = new Node[1];
                if (!stack.isEmpty()) {
                    node.right[0] = (Node)stack.pop();
                }
                if (stack.isEmpty()) break;
                node.left = (Node)stack.pop();
                break;
            }
            case 16: {
                String string = node.getSymbol();
                if (this.isAux(string)) {
                    node = (Node)this.XS.get(string);
                    break;
                }
                if (this.isVar(string)) {
                    node = (Node)this.VS.get(string);
                    break;
                }
                if (this.isMatrix(string)) {
                    node = (Node)this.MS.get(string);
                    break;
                }
                if (string.startsWith(".")) {
                    string = "0" + string;
                }
                try {
                    node.setDouble(Double.valueOf(string));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) {
                        node = this.Var(node.getSymbol());
                        break;
                    }
                    String string2 = "\"" + node.getSymbol() + "\"" + " no declarado";
                    this.Error(string2, bl2);
                    throw new Exception(string2);
                }
            }
            default: {
                node.type = 12;
            }
        }
        stack.push(node);
    }

    public String getSolution(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            String string2;
            StringTokenizer stringTokenizer2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("'") && string3.endsWith("'")) {
                string3 = BasicStr.toLowerCase(string3.substring(1, string3.length() - 1));
            }
            if (string3.startsWith("`") && string3.endsWith("\u00b4")) {
                string3 = BasicStr.eliminateAccents(string3.substring(1, string3.length() - 1));
            }
            if (string3.startsWith("'") && string3.endsWith("'")) {
                string3 = BasicStr.toLowerCase(string3.substring(1, string3.length() - 1));
            }
            if ((string3.startsWith("(") || string3.startsWith("[")) && (string3.endsWith(")") || string3.endsWith("]")) && (stringTokenizer2 = (string2 = string3.substring(1, string3.length() - 1)).indexOf(":") > 0 ? new StringTokenizer(string2, ":") : new StringTokenizer(string2, ",")).countTokens() == 2) {
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken();
                try {
                    Node node = this.Analyse(BasicStr.replace(string4, ",", "."));
                    Node node2 = this.Analyse(BasicStr.replace(string5, ",", "."));
                    double d = node.Evaluate(0.0);
                    double d2 = node2.Evaluate(0.0);
                    if (string4.equals(string5) && node.getStr() != null) {
                        return node.getStr();
                    }
                    if (d <= d2) {
                        return BasicStr.DoubleToString((d + d2) / 2.0, 6, false, ".");
                    }
                    return "No hay soluci\u00f3n";
                }
                catch (Exception exception) {
                    return "NaN";
                }
            }
            return string3;
        }
        return "";
    }

    boolean isOk(String string, String string2) {
        return this.isCorrect(0, string, string2);
    }

    boolean isok(String string, String string2) {
        return this.isCorrect(3, string, string2);
    }

    public boolean isCorrect(String string, String string2) {
        return this.isCorrect("", string, string2);
    }

    public boolean isCorrect(String string, String string2, String string3) {
        boolean bl = false;
        int n = string2.toLowerCase().indexOf(RADIAL);
        if (n == 0) {
            String string4 = string2.substring(n + RADIAL.length());
            bl = this.radialOk(string, string4, string3);
        } else if (n > 0) {
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + RADIAL.length());
            bl = this.isCorrect(3, string5, string3) || this.radialOk(string, string6, string3);
        } else {
            bl = this.isCorrect(3, string2, string3);
        }
        if (BasicStr.hasContent(string)) {
            this.Var(string + "." + "ok").setDouble(bl ? 1.0 : 0.0);
        }
        return bl;
    }

    private boolean radialOk(String string, String string2, String string3) {
        RadialServices radialServices = new RadialServices();
        String string4 = radialServices.getAnswer(string2, string3);
        boolean bl = radialServices.isCorrect();
        String string5 = radialServices.getCorrection();
        if (BasicStr.hasContent(string)) {
            this.Var(string + "." + "correction").setOnlyStr(string5);
        }
        if (bl) {
            if (BasicStr.hasContent(string5)) {
                System.out.println("correction=" + string5);
            }
            System.out.print("RADIAL: ");
        }
        return bl;
    }

    private boolean isCorrect(int n, String string, String string2) {
        boolean bl = false;
        int n2 = string.toLowerCase().indexOf(RADIAL);
        if (n2 == 0) {
            String string3 = string.substring(n2 + RADIAL.length());
            bl = this.radialOk("", string3, string2);
            return bl;
        }
        if (n2 > 0) {
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + RADIAL.length());
            bl = this.isInternallyCorrect(n, string4, string2) || this.radialOk("", string5, string2);
        } else {
            bl = this.isInternallyCorrect(n, string, string2);
        }
        return bl;
    }

    private boolean isInternallyCorrect(int n, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "&");
            boolean[] blArray = new boolean[stringTokenizer2.countTokens()];
            int n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string4;
                StringTokenizer stringTokenizer3;
                String string5 = stringTokenizer2.nextToken();
                String string6 = string2;
                if (string5.startsWith("'") && string5.endsWith("'")) {
                    string6 = BasicStr.toLowerCase(string6);
                    string5 = BasicStr.toLowerCase(string5.substring(1, string5.length() - 1));
                }
                if (string5.startsWith("`") && string5.endsWith("\u00b4")) {
                    string6 = BasicStr.eliminateAccents(string6);
                    string5 = BasicStr.eliminateAccents(string5.substring(1, string5.length() - 1));
                }
                if (string5.startsWith("'") && string5.endsWith("'")) {
                    string6 = BasicStr.toLowerCase(string6);
                    string5 = BasicStr.toLowerCase(string5.substring(1, string5.length() - 1));
                }
                if (string6.equals(string5)) {
                    blArray[n2++] = true;
                    continue;
                }
                switch (n) {
                    case 1: {
                        string6 = BasicStr.toLowerCase(string6);
                        string5 = BasicStr.toLowerCase(string5);
                        break;
                    }
                    case 2: {
                        string6 = BasicStr.eliminateAccents(string6);
                        string5 = BasicStr.eliminateAccents(string5);
                        break;
                    }
                    case 3: {
                        string6 = BasicStr.toLowerCase(string6);
                        string5 = BasicStr.toLowerCase(string5);
                        string6 = BasicStr.eliminateAccents(string6);
                        string5 = BasicStr.eliminateAccents(string5);
                        break;
                    }
                }
                if (string5.endsWith("*") && string6.startsWith(string5.substring(0, string5.length() - 1))) {
                    blArray[n2++] = true;
                    continue;
                }
                if (string5.startsWith("*") && string6.endsWith(string5.substring(1))) {
                    blArray[n2++] = true;
                    continue;
                }
                if (string5.startsWith("*") && string5.endsWith("*") && string6.indexOf(string5.substring(1, string5.length() - 1)) >= 0) {
                    blArray[n2++] = true;
                    continue;
                }
                if ((string5.startsWith("(") || string5.startsWith("[")) && (string5.endsWith(")") || string5.endsWith("]")) && (stringTokenizer3 = (string4 = string5.substring(1, string5.length() - 1)).indexOf(":") > 0 ? new StringTokenizer(string4, ":") : new StringTokenizer(string4, ",")).countTokens() == 2) {
                    String string7 = stringTokenizer3.nextToken();
                    String string8 = stringTokenizer3.nextToken();
                    try {
                        Node node = this.Analyse(BasicStr.replace(string7, ",", "."));
                        Node node2 = this.Analyse(BasicStr.replace(string8, ",", "."));
                        Node node3 = this.Analyse(BasicStr.replace(string6, ",", "."));
                        try {
                            double d = node.Evaluate(0.0);
                            double d2 = node2.Evaluate(0.0);
                            double d3 = node3.Evaluate(0.0);
                            if (string7.equals(string8) && node.getStr() != null) {
                                if (string6.equals(node.getStr())) {
                                    blArray[n2++] = true;
                                    continue;
                                }
                            } else if ((d < d3 || d <= d3 && string5.startsWith("[")) && (d3 < d2 || d3 <= d2 && string5.endsWith("]"))) {
                                blArray[n2++] = true;
                                continue;
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string6.length() == string5.length()) {
                    boolean bl = false;
                    for (int i = 0; i < string6.length(); ++i) {
                        if (string5.charAt(i) == '?' || string5.charAt(i) == string6.charAt(i)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        blArray[n2++] = true;
                        continue;
                    }
                }
                ++n2;
            }
            boolean bl = true;
            for (int i = 0; i < blArray.length; ++i) {
                bl &= blArray[i];
            }
            if (bl) {
                System.out.println("INTERNAL  ");
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public Algorithm defineConstant(String string, boolean bl, String string2, String string3, String string4) {
        Algorithm algorithm = new Algorithm(string, this, bl, "Constant", string2, string3, string4);
        this.ALS.addElement(algorithm);
        return algorithm;
    }

    public Algorithm defineAlgorithm(String string, boolean bl, String string2, String string3, String string4) {
        Algorithm algorithm = new Algorithm(string, this, bl, "Algorithm", string2, string3, string4);
        this.ALS.addElement(algorithm);
        return algorithm;
    }

    public void doAlgorithms(boolean bl) throws Exception {
        Enumeration enumeration = this.ALS.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object e = enumeration.nextElement();
            if (e instanceof Algorithm) {
                object = (Algorithm)e;
                if (!bl && ((Algorithm)object).evOnce) continue;
                ((Algorithm)object).perform();
                continue;
            }
            if (!(e instanceof Node)) continue;
            object = (Node)e;
            if (this.MS.contains(object)) {
                this.evaluateMatrix((Node)object, bl);
                continue;
            }
            if (!this.AS.contains(object)) continue;
            this.evaluateArray((Node)object, bl);
        }
        if (this.nsa_nippe != null) {
            this.nsa_nippe.sendChanges();
        }
    }

    public Node Array(String string) {
        if (!this.isArray(string)) {
            this.defineArray("3", string, "", "", true);
        }
        return (Node)this.AS.get(string);
    }

    public Node Matrix(String string) {
        if (!this.isMatrix(string)) {
            this.defineMatrix("3", "3", string, "", "", true);
            new Exception("\u00a1Creating nondefined matrix!").printStackTrace();
        }
        return (Node)this.MS.get(string);
    }

    public double[] getRealArray(String string) {
        if (this.isArray(string)) {
            return ((Node)this.AS.get((Object)string)).rarray;
        }
        return null;
    }

    public double[][] getRealMatrix(String string) {
        if (this.isMatrix(string)) {
            return ((Node)this.MS.get((Object)string)).rmatrix;
        }
        return null;
    }

    public String[] getStringArray(String string) {
        if (this.isArray(string)) {
            return ((Node)this.AS.get((Object)string)).sarray;
        }
        return null;
    }

    public String[][] getStringMatrix(String string) {
        if (this.isMatrix(string)) {
            return ((Node)this.MS.get((Object)string)).smatrix;
        }
        return null;
    }

    public static String getExprFromContent(String string, String string2) {
        if (BasicStr.hasContent(string)) {
            String[] stringArray = BasicStr.toStringArray(string);
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + string2 + "[" + i + "]=" + stringArray[i] + ";";
            }
            return string3;
        }
        return "";
    }

    public Vector getDataFilePaths() {
        return this.dataFiles;
    }

    public void defineArray(String string, String string2, String string3, String string4, boolean bl) {
        Object object;
        Object object2;
        Node node = null;
        Node node2 = null;
        String string5 = string;
        String string6 = string3;
        boolean bl2 = false;
        if (BasicStr.hasContent(string4)) {
            try {
                node = this.Analyse("Vector " + string2, string4, false, false);
                node.evOnce = bl;
                bl2 = true;
            }
            catch (Exception exception) {
                object2 = mjaFile.readFile(this.nsa_nippe, this.nsa_nippe.inWeb(), string4, true);
                if (BasicStr.hasContent((String)object2)) {
                    this.dataFiles.add(string4);
                    object = BasicStr.toStringArray((String)object2);
                    string5 = Integer.toString(((String[])object).length);
                    bl2 = true;
                }
                string6 = Parser.getExprFromContent((String)object2, string2);
            }
        }
        if (!bl2 && BasicStr.hasContent(string6)) {
            String string7 = string6.replaceAll("/;\\s*;/", ";0;");
            object2 = BasicStr.toStringArray(string7 = string7.replaceAll(";", "\n"));
            if (object2 != null && ((String[])object2).length > 0) {
                boolean bl3;
                object = "(.|\\s)*]\\s*=\\s*.*";
                boolean bl4 = bl3 = !object2[0].matches((String)object);
                if (bl3) {
                    string6 = Parser.getExprFromContent(string7, string2);
                    string5 = String.valueOf(((String[])object2).length);
                }
            }
        }
        if (node == null) {
            int n = (int)Math.round(this.Analyse(string5, "3").Evaluate(3.0));
            this.Var(string2 + ".long").setDouble(n);
            object2 = this.Analyse(string5);
            node = new Node(this, string2, (Node)object2, new Node[n], bl);
            node2 = (Node)this.AS.get(string2);
        }
        if (node2 == null) {
            node2 = node;
            this.AS.put(string2, node);
        } else {
            node2.assign(node);
        }
        int n = this.ALS.indexOf(node2.alg);
        object2 = new Algorithm(string2, this, bl, "Vector", string6, "", "");
        if (node2.alg == null) {
            node2.alg = object2;
        } else {
            node2.alg.assign((Algorithm)object2);
        }
        if (n < 0) {
            this.ALS.addElement(node2);
        }
    }

    public void evaluateArray(String string, boolean bl) {
        if (this.isArray(string)) {
            Node node = this.Array(string);
            try {
                this.evaluateArray(node, bl);
            }
            catch (Exception exception) {
                System.out.println("Error evaluating array " + string);
            }
        }
    }

    private void evaluateArray(Node node, boolean bl) throws Exception {
        int n = 3;
        Algorithm algorithm = null;
        if (this.VS.contains(node)) {
            if (!(node.evOnce && !bl || node.filename.equals(node.getStr()))) {
                Object object;
                String string;
                Enumeration enumeration = this.AS.keys();
                String string2 = "";
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = this.AS.get(string);
                    if (object != node) continue;
                    string2 = string;
                    break;
                }
                if (BasicStr.hasContent(string = mjaFile.readFile(this.nsa_nippe, this.nsa_nippe.inWeb(), node.getStr(), true))) {
                    object = BasicStr.toStringArray(string);
                    n = ((V)object).length;
                    this.Var(string2 + ".long").setDouble(n);
                    String string3 = Parser.getExprFromContent(string, string2);
                    algorithm = new Algorithm(string2, this, false, "Vector", string3, "", "");
                    double[] dArray = new double[n];
                    String[] stringArray = new String[n];
                    node.rarray = dArray;
                    node.sarray = stringArray;
                }
            }
        } else {
            n = (int)Math.round(node.size.Evaluate(3.0));
            algorithm = node.alg;
            double[] dArray = node.rarray;
            String[] stringArray = node.sarray;
            if (dArray.length != n) {
                double[] dArray2 = new double[n];
                String[] stringArray2 = new String[n];
                if (!bl) {
                    for (int i = 0; i < Math.min(dArray.length, dArray2.length); ++i) {
                        dArray2[i] = dArray[i];
                        stringArray2[i] = stringArray[i];
                    }
                }
                node.rarray = dArray2;
                node.sarray = stringArray2;
            }
        }
        if (algorithm != null && (!node.evOnce || bl)) {
            algorithm.perform();
        }
    }

    public void defineMatrix(String string, String string2, String string3, String string4, String string5, boolean bl) {
        Node node = this.Analyse(string, "3");
        Node node2 = this.Analyse(string2, "3");
        int n = (int)Math.round(node.Evaluate(3.0));
        int n2 = (int)Math.round(node2.Evaluate(3.0));
        int n3 = n * n2;
        this.Var(string3 + ".filas").setDouble(n2);
        this.Var(string3 + ".columnas").setDouble(n);
        this.Var(string3 + ".rows").setDouble(n2);
        this.Var(string3 + ".columns").setDouble(n);
        Node node3 = new Node(this, string3, node, node2, new Node[n3], bl);
        Node node4 = (Node)this.MS.get(string3);
        if (node4 == null) {
            node4 = node3;
            this.MS.put(string3, node3);
        } else {
            node4.ncols = node;
            node4.nrows = node2;
            node4.assign(node3);
        }
        int n4 = this.ALS.indexOf(node4.alg);
        Algorithm algorithm = new Algorithm(string3, this, bl, "Matrix", string5, "", "");
        if (node4.alg == null) {
            node4.alg = algorithm;
        } else {
            node4.alg.assign(algorithm);
        }
        if (n4 < 0) {
            this.ALS.addElement(node4);
        }
    }

    public void evaluateMatrix(String string, boolean bl) {
        if (this.isMatrix(string)) {
            Node node = this.Matrix(string);
            try {
                this.evaluateMatrix(node, bl);
            }
            catch (Exception exception) {
                System.out.println("Error evaluating matrix " + string);
            }
        }
    }

    private void evaluateMatrix(Node node, boolean bl) throws Exception {
        try {
            int n = (int)Math.round(node.nrows.Evaluate(3.0));
            int n2 = (int)Math.round(node.ncols.Evaluate(3.0));
            double[][] dArray = node.rmatrix;
            String[][] stringArray = node.smatrix;
            if (dArray == null || dArray[0] == null || dArray.length != n2 || dArray[0].length != n) {
                double[][] dArray2 = new double[n2][n];
                String[][] stringArray2 = new String[n2][n];
                if (!bl) {
                    for (int i = 0; i < Math.min(dArray.length, dArray2.length); ++i) {
                        for (int j = 0; j < Math.min(dArray[i].length, dArray2[i].length); ++j) {
                            dArray2[j][i] = dArray[j][i];
                            stringArray2[j][i] = stringArray[j][i];
                        }
                    }
                }
                node.rmatrix = dArray2;
                node.smatrix = stringArray2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!node.evOnce || bl) {
            node.alg.perform();
        }
    }

    public static void analyseEquation(Parser parser, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = "Analysis:";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n++ > 0) {
                string2 = string2 + "=";
                System.out.print("=");
            }
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3;
            Node node = null;
            try {
                node = parser.Analyse("Equation", string3, true);
                if (node == null) continue;
                string2 = string2 + node.toExpression();
            }
            catch (Exception exception) {
                System.out.println(string);
                System.out.println(string2);
                exception.printStackTrace();
            }
        }
    }

    private void Error(String string, boolean bl) throws Exception {
        if (bl) {
            System.out.println("\n" + string + "\n" + this.whereIsIt);
            if (this.inNippeEditor() && this.nsa_nippe != null) {
                mjaText.msg(this.nsa_nippe, "Error", string + "\n" + this.whereIsIt);
            }
        }
        Exception exception = new Exception(string);
        throw exception;
    }
}

