/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.jla.calc.calcWin;
import com.mja.cmp.mjaButton;
import com.mja.descartes.Action;
import com.mja.descartes.Descartes;
import com.mja.descartes.controlConfig;
import com.mja.descgui.ScrollBarControl;
import com.mja.descgui.mjaGui;
import com.mja.descgui.textControl;
import com.mja.file.mjaFont;
import com.mja.file.mjaHtml;
import com.mja.gui.mjaText;
import com.mja.parser.Node;
import com.mja.textedit.EditorCanvas;
import com.mja.util.BasicStr;
import com.mja.util.LiveOrDie;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public abstract class NumericControl
extends Panel
implements MouseListener,
KeyListener,
FocusListener,
ComponentListener,
LiveOrDie {
    public static final Color labelColor = new Color(14738664);
    public controlConfig ccfg;
    public String answer;
    JLabel lb;
    public JTextField TF = new JTextField(10);
    private boolean TFhasFocus = false;
    public static final double minDouble = -1.7976931348623157E308;
    public static final double maxDouble = Double.MAX_VALUE;
    protected Node xN;
    protected Node yN;
    protected Node wN;
    protected Node hN;
    protected Node visibilityN;
    protected Node activityN;
    protected boolean onlyText = false;
    Descartes D;
    protected double v0;
    protected Node var;
    protected Node dvN;
    private Node pvN;
    private Node minN;
    private Node maxN;
    private int p0;
    private Node notexp;
    private boolean fixed;
    protected boolean discrete;
    protected boolean interior;
    private String title;
    private String explanation;
    private String tooltip;
    private String more;
    private String space;
    private Vector listeners = new Vector();
    private Action a;
    private String cID = "";
    String s_p;
    String s_v;
    String s_vincr;
    String s_vmin;
    String s_vmax;
    String s_notexp;
    String s_visicond;
    String s_activcond;
    boolean vertical = false;
    String pattern = "";
    private boolean isUsed = false;
    private String typeName = "";
    int minlbw = 0;
    int minTFw = 0;
    private boolean inScenario;
    private Font expl_f;
    private Font tooltip_f;
    private String aa;
    private boolean ba;
    private boolean firstTime = true;
    private long T = 0L;

    public abstract void updateVisualComponent();

    public abstract void stop();

    protected abstract void defineTextValue(String var1);

    void init(Descartes descartes, controlConfig controlConfig2, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, boolean bl2, String string8, String string9, String string10) {
        this.D = descartes;
        this.ccfg = controlConfig2;
        this.s_p = string3;
        this.fixed = bl;
        this.s_v = string4;
        this.s_vincr = string5;
        this.s_vmin = string6;
        this.s_vmax = string7;
        this.s_notexp = string8;
        this.s_visicond = string9;
        this.s_activcond = string10;
        this.setBackground(labelColor);
        this.title = string;
        if ("_._".equals(this.title) || "_nada_".equals(this.title) || "_void_".equals(this.title)) {
            this.title = "";
        }
        this.lb = new JLabel(this.title);
        this.lb.setHorizontalAlignment(0);
        this.lb.setBackground(labelColor);
        this.lb.setForeground(Color.black);
        this.lb.setOpaque(true);
        this.lb.addMouseListener(this);
        this.lb.addKeyListener(this);
        this.TF.setHorizontalAlignment(2);
        this.TF.setBackground(Color.white);
        this.TF.setForeground(Color.black);
        this.TF.setDisabledTextColor(new Color(2113664));
        this.TF.addKeyListener(this);
        this.TF.addMouseListener(this);
        this.TF.addFocusListener(this);
        this.TF.setEditable(true);
        if (!bl2) {
            this.TF.setVisible(false);
        }
        this.setName(string2);
        this.var = descartes.p.Var(this.getName());
        this.reinitialize();
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addActionListener(descartes);
        this.addMouseListener(descartes.scene);
        this.addKeyListener(descartes.scene);
        this.pattern = controlConfig2.getAnswerPattern().trim();
        String string11 = descartes.p.getSolution(this.pattern);
        this.disableFocusTraversalKeys();
        descartes.p.Var(this.getName() + ".sol").setOnlyStr(string11);
        this.addComponentListener(this);
    }

    public void disableFocusTraversalKeys() {
        Component[] componentArray = this.getFocusableComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setFocusTraversalKeysEnabled(false);
        }
    }

    public Component[] getFocusableComponents() {
        Component[] componentArray = new Component[]{this.TF};
        return componentArray;
    }

    public void setIsUsed(boolean bl) {
        this.isUsed = bl;
        if (this.isUsed) {
            this.D.cfg.addControl(this.ccfg);
        } else {
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
            this.D.cfg.removeControl(this.ccfg);
        }
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public Component cloneComponent(String string) {
        controlConfig controlConfig2 = this.ccfg.cloneControlConfig();
        NumericControl numericControl = controlConfig2.makeNumericControl(this.D);
        numericControl.setSize(this.getSize().width, this.getSize().height);
        this.D.scene.addEditObjectToText(controlConfig2, string);
        return numericControl;
    }

    public void start() {
        this.locate();
        this.updateFont();
    }

    public void setControlID(String string) {
        this.cID = string;
    }

    public String getControlID() {
        return this.cID;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(mouseListener);
        }
    }

    public void reinitialize() {
        this.pvN = this.D.p.Analyse(this.s_p, 2.0);
        this.notexp = this.D.p.Analyse(this.s_notexp, 0.0);
        this.p0 = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
        if (this.pvN.isANumber()) {
            this.pvN = null;
        }
        if (this.var.getStr() == null) {
            this.var.setDouble(BasicStr.round(this.var.getDouble(), this.p0));
        }
        this.dvN = this.D.p.Analyse(this.s_vincr, 0.1);
        this.minN = this.D.p.Analyse(this.s_vmin, -1.7976931348623157E308);
        this.maxN = this.D.p.Analyse(this.s_vmax, Double.MAX_VALUE);
        this.defineValue(this.s_v);
        this.v0 = this.var.getDouble();
        this.visibilityN = this.D.p.Analyse(this.s_visicond, "1");
        this.activityN = this.D.p.Analyse(this.s_activcond, "1");
        this.informRAD();
        this.checkCorrect();
    }

    private void updateFontAndSize() {
        if (!this.vertical) {
            this.updateFont();
            Graphics graphics = this.D.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.lb.getFont());
            this.minlbw = fontMetrics.stringWidth(this.getTitle()) + 10;
            this.minTFw = fontMetrics.stringWidth(this.TF.getText() + "0");
            double d = this.var.getDouble();
            String string = this.var.getStr();
            if (BasicStr.hasContent(this.s_vmin)) {
                this.var.setDouble(this.minN.Evaluate(0.0));
                this.minTFw = Math.max(this.minTFw, fontMetrics.stringWidth(this.getStringValue()));
            }
            if (BasicStr.hasContent(this.s_vmax)) {
                this.var.setDouble(this.maxN.Evaluate(0.0));
                this.minTFw = Math.max(this.minTFw, fontMetrics.stringWidth(this.getStringValue()));
            }
            if (string != null) {
                this.var.setOnlyStr(string);
            } else {
                this.var.setDouble(d);
            }
            this.minTFw += 7;
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateFontAndSize();
    }

    public void setDescartes(Descartes descartes) {
        this.D = descartes;
    }

    public void setAction(String string, String string2, Font font, int n) {
        this.a = BasicStr.hasContent(string) ? new Action(this.D, this.getName(), string, string2, font, n) : null;
    }

    void informRAD() {
        if (this.D.cfg.useRAD) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = this.getName();
            stringArray[0][1] = Double.toString(this.var.getDouble());
            this.D.informLMS(mjaHtml.getHTMLEncoding(this.getTypeName()), this.getTitle(), "", stringArray);
        }
    }

    public void executeAction() {
        this.informRAD();
        if (this.a != null) {
            this.a.execute();
        }
    }

    public Action getAction() {
        return this.a;
    }

    public void setInterior(boolean bl) {
        this.interior = bl;
    }

    public void setInScenario(boolean bl) {
        this.inScenario = bl;
    }

    public boolean inScenario() {
        return this.inScenario;
    }

    public void setNodeBounds(Node node, Node node2, Node node3, Node node4) {
        this.xN = node;
        this.yN = node2;
        this.wN = node3;
        this.hN = node4;
    }

    public void checkActive() {
        boolean bl = this.isActive();
    }

    public boolean isActive() {
        if (this.activityN == null) {
            return true;
        }
        boolean bl = this.activityN.Evaluate(1.0) > 0.0;
        this.TF.setEnabled(bl);
        if (bl) {
            this.TF.setBackground(Color.white);
        } else {
            this.TF.setBackground(new Color(0xF8F8F8));
        }
        return bl;
    }

    public void locate() {
        this.setVisible(this.visibilityN.Evaluate(1.0) > 0.0);
        if ((this.isInterior() || this.inScenario()) && this.xN != null && this.yN != null && this.wN != null && this.hN != null) {
            Dimension dimension = this.getSize();
            double d = this.wN.Evaluate(100.0);
            double d2 = this.hN.Evaluate(23.0);
            int n = (int)Math.floor(d + 0.5);
            int n2 = (int)Math.floor(d2 + 0.5);
            if (this.inScenario()) {
                if (dimension.width != n || dimension.height != n2) {
                    this.setSize(n, n2);
                }
            } else {
                int n3 = (int)Math.floor(this.xN.Evaluate(0.0) + 0.5);
                int n4 = (int)Math.floor(this.yN.Evaluate(0.0) + 0.5);
                Point point = this.getLocation();
                if (point.x != n3 || point.y != n4 || dimension.width != n || dimension.height != n2) {
                    this.setBounds(n3, n4, n, n2);
                    this.updateFont();
                }
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.lb.setForeground(color);
        this.TF.setForeground(color);
    }

    public void setBackground(Color color) {
        if (color != null) {
            super.setBackground(color);
            if (this.lb != null) {
                this.lb.setBackground(color);
            }
            if (this.TF != null) {
                this.TF.setBackground(color);
            }
        } else {
            if (this.lb != null) {
                this.lb.setBackground(labelColor);
            }
            if (this.TF != null) {
                this.TF.setBackground(Color.white);
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.lb != null) {
            this.lb.setFont(font);
        }
        if (this.TF != null) {
            this.TF.setFont(font);
        }
    }

    public void setFont(int n) {
        String string = "SansSerif";
        int n2 = 0;
        Font font = mjaFont.makeFont(string, n2, BasicStr.fontSizeForHeight(n));
        this.setFont(font);
    }

    public void updateFont() {
        if (!(this instanceof ScrollBarControl) || !((ScrollBarControl)this).isVertical()) {
            this.setFont(this.getSize().height);
        }
    }

    public void setSpace(String string) {
        this.space = string;
    }

    public boolean isInterior() {
        return this.interior;
    }

    public String getSpace() {
        return this.space;
    }

    public void setTitle(String string) {
        this.title = string;
        this.lb.setText(string);
    }

    public String getTitle() {
        return this.title;
    }

    public void setDiscrete(boolean bl) {
        this.discrete = bl;
    }

    public void setExplanation(String string, Font font) {
        this.explanation = string;
        this.expl_f = font;
    }

    public void setTooltip(String string, String string2, Font font) {
        this.tooltip = string;
        this.tooltip_f = font;
        this.more = string2;
        if (!BasicStr.hasContent(this.explanation)) {
            this.explanation = string;
        }
    }

    boolean TFhasFocus() {
        return this.TFhasFocus;
    }

    public final void updateFromNode() {
        if (this.var.getDouble() != Double.NaN && this.var.getStr() == null) {
            this.setValue(this.var.getDouble());
        }
        this.updateVisualComponent();
        this.checkCorrect();
        this.checkActive();
    }

    public final void updateFromText() {
        this.defineValue(this.TF.getText());
    }

    public boolean isBeingEdited() {
        return this.TFhasFocus();
    }

    public String getStringValue(double d) {
        int n = this.precision();
        d = BasicStr.round(d, n);
        String string = "";
        string = this.notexp.Evaluate(0.0) > 0.0 ? BasicStr.notExp(d, n, this.fixed) : BasicStr.DoubleToString(d, n, this.fixed);
        return string;
    }

    public int peso() {
        try {
            return BasicStr.parseInteger(this.ccfg.s_value[controlConfig.ixweight], 1, 1);
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private void checkCorrect() {
        String string = this.D.p.getSolution(this.pattern);
        this.D.p.Var(this.getName() + ".sol").setOnlyStr(string);
        String string2 = this.getStringValue().trim();
        if (!string2.equals(this.aa)) {
            this.ba = BasicStr.hasContent(string2) ? this.D.p.isCorrect(this.getName(), this.pattern, string2) : false;
            this.aa = string2;
        }
    }

    public String getStringValue() {
        return this.getStringValue(this.var.getDouble());
    }

    public double getDoubleValue() {
        return this.var.getDouble();
    }

    public void defineValue(double d) {
        this.defineValue(Double.toString(d));
    }

    public void defineValue(String string) {
        block8: {
            boolean bl = false;
            if (this instanceof textControl && this.onlyText) {
                bl = !this.TF.getText().equals(string);
                this.defineTextValue(string);
            } else {
                String string2 = string;
                if (string2.equals("''") || string2.equals("||")) {
                    this.defineTextValue(string2);
                } else {
                    double d = this.var.getDouble();
                    try {
                        string2 = string2.replace(',', '.');
                        Node node = this.D.p.Analyse("NumericControl " + this.getName(), string2, true, true);
                        double d2 = d;
                        d = node.Evaluate();
                        if (node.getStr() == null && d != Double.NaN) {
                            this.setValue(d);
                            bl = d2 != d;
                        }
                    }
                    catch (Exception exception) {
                        if (!(this instanceof textControl)) break block8;
                        if (this.firstTime) {
                            this.onlyText = true;
                        }
                        bl = !this.TF.getText().equals(string);
                        this.defineTextValue(string);
                    }
                }
            }
        }
        this.firstTime = false;
        this.updateVisualComponent();
    }

    public void step(boolean bl) {
        if (this.isActive()) {
            int n = this.precision();
            double d = Math.max(BasicStr.minIncr(n), this.dvN.Evaluate(0.01));
            double d2 = this.var.getDouble();
            double d3 = this.minN.Evaluate(-1.7976931348623157E308);
            double d4 = this.maxN.Evaluate(Double.MAX_VALUE);
            if (bl) {
                if ((d2 += d) > d4) {
                    Toolkit.getDefaultToolkit().beep();
                    d2 = d4;
                }
            } else if ((d2 -= d) < d3) {
                Toolkit.getDefaultToolkit().beep();
                d2 = d3;
            }
            this.setValue(d2);
            if (Math.abs(this.var.getDouble()) < Math.pow(10.0, -13.0)) {
                this.var.setDouble(0.0);
            }
            this.updateFromNode();
        }
    }

    public double getMin() {
        return this.minN.Evaluate(-1.7976931348623157E308);
    }

    public double getMax() {
        return this.maxN.Evaluate(Double.MAX_VALUE);
    }

    public double getIncr() {
        return this.dvN.Evaluate(0.01);
    }

    protected int precision() {
        int n = this.p0;
        if (this.pvN != null) {
            n = (int)Math.round(this.pvN.Evaluate(2.0));
        }
        return n;
    }

    protected void setValue(double d) {
        double d2 = d;
        double d3 = this.minN.Evaluate(-1.7976931348623157E308);
        double d4 = this.maxN.Evaluate(Double.MAX_VALUE);
        if (d2 < d3) {
            d2 = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        int n = this.precision();
        if (this.discrete) {
            try {
                double d5 = this.dvN.Evaluate(0.1);
                double d6 = BasicStr.round(this.v0, n);
                double d7 = BasicStr.round(d5, n);
                if (d7 != 0.0) {
                    d2 = d6 + d7 * (double)Math.round((d2 - d6) / d7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        d2 = BasicStr.round(d2, n);
        String string = this.getStringValue(d2);
        string = string.replace(',', '.');
        try {
            d2 = Double.parseDouble(string);
            this.var.setDouble(d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.activityN != null) {
            boolean bl = this.isActive();
        }
        this.checkCorrect();
    }

    private void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    void callListeners(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        block2: {
            block3: {
                BasicStr.ShiftOn = keyEvent.isShiftDown();
                BasicStr.CtrlOn = keyEvent.isControlDown();
                if (!this.isActive()) break block2;
                if (keyEvent.getKeyCode() == 10) break block3;
                if (keyEvent.getKeyCode() != 9) break block2;
            }
            this.D.updateNodesFromControls();
            this.defineValue(this.TF.getText());
            this.D.updateTextFieldsFromNodes();
            this.executeAction();
            this.callListeners("");
            this.TF.setText(this.getStringValue());
            this.TF.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        BasicStr.ShiftOn = false;
        BasicStr.CtrlOn = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.lb) {
            // empty if block
        }
        if (mouseEvent.getSource() == this.TF) {
            this.TF.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.lb) {
            this.invalidate();
            this.paintAll(this.getGraphics());
        }
        if (this.isActive() && (mouseEvent.getSource() == this.lb || mouseEvent.getSource() instanceof Button || mouseEvent.getSource() instanceof mjaButton) && BasicStr.hasContent(this.tooltip) && this.T + 3000L < System.currentTimeMillis()) {
            this.T = System.currentTimeMillis();
            mjaGui.showTooltip(this.D.scene, (Component)mouseEvent.getSource(), this.tooltip, this.more, this.tooltip_f);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.T = 0L;
    }

    private boolean inEC() {
        return this.getParent() instanceof EditorCanvas;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isActive()) {
            if (mouseEvent.getSource() == this.TF && mouseEvent.getClickCount() == 2) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("com.mja.textedit.EditorCanvas");
                }
                catch (Exception exception) {
                    clazz = null;
                }
                if (clazz == null || !this.inEC()) {
                    NumericControl.useCalc(this);
                }
            } else if (mouseEvent.getModifiers() == 4 && BasicStr.hasContent(this.explanation)) {
                mouseEvent.consume();
                mjaText.msg((Component)mouseEvent.getSource(), this.getTitle(), this.explanation, this.expl_f);
            }
        }
    }

    static void useCalc(NumericControl numericControl) {
        calcWin calcWin2 = new calcWin(true, numericControl instanceof textControl);
        Point point = numericControl.TF.getLocationOnScreen();
        calcWin2.setLocation(point.x - (calcWin2.getSize().width - numericControl.TF.getSize().width) / 2, Math.max(0, point.y - calcWin2.getSize().height));
        calcWin2.show();
        if (calcWin2.getValue() != null) {
            numericControl.var.setStrAndAnalyse(calcWin2.getValue());
            numericControl.defineValue(calcWin2.getValue());
            numericControl.updateFromNode();
        }
        calcWin2.dispose();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.TF) {
            this.TFhasFocus = false;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.TF) {
            this.TFhasFocus = true;
            this.TF.setSelectionStart(0);
            this.TF.setSelectionEnd(this.TF.getText().length());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.disableFocusTraversalKeys();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.disableFocusTraversalKeys();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateFontAndSize();
        this.disableFocusTraversalKeys();
    }
}

