/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.parser.Node;
import com.mja.parser.Node_R;
import com.mja.parser.Parser;
import java.util.Vector;

public class StepConfig {
    private Parser p;
    private String oexpr;
    private String sexpr;
    private String expl;
    private Node ON;
    private Node SN;
    private Vector rv;
    private int decimals;

    public StepConfig(Vector vector, Parser parser, Node node, String string, int n) {
        this.rv = vector;
        this.p = parser;
        this.ON = node;
        this.oexpr = this.ON.toExpression(true, true);
        this.SN = Node_R.replaceRandomVariables(parser, node, vector, n, true);
        this.sexpr = this.SN.toExpression(true);
        this.expl = string;
        this.decimals = this.decimals;
    }

    public StepConfig(Vector vector, Parser parser, String string, String string2, int n) {
        this(vector, parser, parser.Analyse(StepConfig.parseSquareBrackets(string, n)), string2, n);
    }

    public StepConfig cloneStep() {
        StepConfig stepConfig = new StepConfig(this.rv, this.p, this.ON, this.expl, this.decimals);
        return stepConfig;
    }

    private static String parseSquareBrackets(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c;
            if ((c = string.charAt(n3++)) == '[') {
                stringBuffer.append("expr(");
                ++n2;
                continue;
            }
            if (c == ']') {
                if (n2 <= 0) {
                    new Exception(string.substring(0, n3 + 1) + "\ntoo many ] ").printStackTrace();
                }
                if (n2 > 0) {
                    stringBuffer.append("," + n + ",0)");
                }
                --n2;
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public String toString() {
        String string = this.oexpr;
        while (string.length() < 30) {
            string = string + " ";
        }
        string = string + " | " + this.expl;
        return string;
    }

    public String getOExpression(boolean bl) {
        return this.ON.toExpression(bl, true);
    }

    public String getSExpression(boolean bl) {
        return this.SN.toExpression(bl);
    }

    public String getOExpression() {
        return this.oexpr;
    }

    public String getSExpression() {
        return this.sexpr;
    }

    public String getExplanation() {
        return this.expl;
    }

    public Node getSNode() {
        return this.SN;
    }

    public void setExplanation(String string) {
        this.expl = string;
    }
}

