/*
 * Decompiled with CFR 0.152.
 */
package org.unam.matem;

class Node {
    String token;
    int symb;
    int type;
    double r;
    Node left;
    Node right;
    static final int LP = 0;
    static final int RP = 1;
    static final int MAS = 2;
    static final int MENOS = 3;
    static final int POR = 4;
    static final int DIV = 5;
    static final int VAR = 6;
    static final int NOOP = 7;
    static final int No = 0;
    static final int Lp = 1;
    static final int Rp = 2;
    static final int B1 = 3;
    static final int B2 = 4;
    static final int Vi = 5;
    static final int In = 6;

    Node(String string) {
        this.token = string;
        this.symb = Node.Symbol(this.token);
        this.type = Node.Type(this.symb);
    }

    static int Symbol(String string) {
        if (string.equals("(")) {
            return 0;
        }
        if (string.equals(")")) {
            return 1;
        }
        if (string.equals("+")) {
            return 2;
        }
        if (string.equals("-")) {
            return 3;
        }
        if (string.equals("*")) {
            return 4;
        }
        if (string.equals("/")) {
            return 5;
        }
        return 6;
    }

    static int Type(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
        }
        return 0;
    }

    String toExpr() {
        if (this.left != null && this.right != null) {
            return "(" + this.left.toExpr() + this.token + this.right.toExpr() + ")";
        }
        return this.token;
    }

    double Evaluate() {
        if (this.left != null && this.right != null) {
            switch (this.symb) {
                case 2: {
                    return this.left.Evaluate() + this.right.Evaluate();
                }
                case 3: {
                    return this.left.Evaluate() - this.right.Evaluate();
                }
                case 4: {
                    return this.left.Evaluate() * this.right.Evaluate();
                }
                case 5: {
                    return this.left.Evaluate() / this.right.Evaluate();
                }
            }
            return 0.0;
        }
        return this.r;
    }
}

