/*
 * Decompiled with CFR 0.152.
 */
package com.mja.textedit;

import com.mja.file.mjaFont;
import com.mja.gui.Explainer;
import com.mja.gui.MouseCursorHandler;
import com.mja.gui.editDialog;
import com.mja.gui.mjaText;
import com.mja.lang.Expl;
import com.mja.lang.translator;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MathEditor
extends editDialog
implements ActionListener,
MouseListener,
Explainer {
    private Label l_dec;
    private TextField tf;
    private TextField tf_dec;
    private Checkbox ch_fixed;
    private Button b_help;
    private translator Tr;
    private MouseCursorHandler mch;

    MathEditor(Frame frame, translator translator2, String string, String string2, boolean bl) {
        super(frame, translator2.getTr(55), true, translator2.getTr(85), translator2.getTr(84));
        this.Tr = translator2;
        this.mch = new MouseCursorHandler(this, this);
        this.setFont(mjaFont.AWTSansSerif);
        this.tf = new TextField(40);
        this.add("Center", this.tf);
        this.tf.setFont(mjaFont.makeFont("SansSerif", 0, 17));
        this.tf.setText(string);
        this.tf.addActionListener(this);
        this.tf.addMouseListener(this);
        Panel panel = new Panel();
        this.add("North", panel);
        this.l_dec = new Label(translator2.getTr(30));
        panel.add(this.l_dec);
        this.l_dec.addMouseListener(this);
        this.tf_dec = new TextField(20);
        panel.add(this.tf_dec);
        this.tf_dec.setFont(mjaFont.AWTMono);
        this.tf_dec.setText(string2);
        this.tf_dec.addMouseListener(this);
        this.ch_fixed = new Checkbox(translator2.getTr(192));
        panel.add(this.ch_fixed);
        this.ch_fixed.setState(bl);
        this.ch_fixed.addMouseListener(this);
        this.b_help = new Button("?");
        panel.add(this.b_help);
        this.b_help.addActionListener(this);
        this.b_help.addMouseListener(this);
    }

    String getExpr() {
        return this.tf.getText();
    }

    String getDecExpr() {
        String string = this.tf_dec.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    boolean getFixed() {
        return this.ch_fixed.getState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.mch.isHand()) {
            if (actionEvent.getSource() == this.tf) {
                this.ok = true;
                this.setVisible(false);
            } else if (actionEvent.getSource() == this.b_help) {
                this.mch.setHand();
            }
        }
    }

    @Override
    public String getExplLabel(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            return label.getText();
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            if (textField == this.tf_dec) {
                return this.l_dec.getText();
            }
            if (textField == this.tf) {
                return this.Tr.getTr(55);
            }
        } else {
            if (component instanceof Button) {
                Button button = (Button)component;
                return button.getLabel();
            }
            if (component instanceof Checkbox) {
                Checkbox checkbox = (Checkbox)component;
                return checkbox.getLabel();
            }
        }
        return "";
    }

    @Override
    public String getExplanation(MouseEvent mouseEvent) {
        Button button;
        String[] stringArray = null;
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            if (label == this.l_dec) {
                stringArray = Expl.EditExpression[0];
            }
        } else if (component instanceof TextField) {
            TextField textField = (TextField)component;
            if (textField == this.tf_dec) {
                stringArray = Expl.EditExpression[0];
            } else if (textField == this.tf) {
                stringArray = Expl.EditExpression[3];
            }
        } else if (component instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)component;
            if (checkbox == this.ch_fixed) {
                stringArray = Expl.EditExpression[1];
            }
        } else if (component instanceof Button && (button = (Button)component) == this.b_help) {
            stringArray = Expl.EditExpression[2];
        }
        return Expl.get(stringArray, this.Tr.getActiveLanguage());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4 || this.mch.isHand()) {
            mjaText.msg((Component)mouseEvent.getSource(), this.getExplLabel(mouseEvent), this.getExplanation(mouseEvent), mjaFont.AWTMono);
            if (this.mch.isHand()) {
                mouseEvent.consume();
                this.mch.setNull();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

