/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2011, Pablo Impallari
 * (www.impallari.com|impallari@gmail.com),
Copyright (c) 2011, Igino Marini.
 * (www.ikern.com|mail@iginomarini.com),
with Reserved Font Name Kaushan Script.
 * 
 * Trademark:
 * Kaushan Script is a trademark of Pablo Impallari.
 * 
 * Full name:
 * KaushanScript-Regular
 * 
 * Description:
 * Kaushan Script feels like writing quickly with an inked brush.

When making
 * digital typefaces, the more you refine the shapes of the letters, the more
 * energy you take away from them. Because of that, Kaushan is unrefined - and
 * carries a lot of energy. 

By avoiding typographical perfection, it stays more
 * natural. The angles of the vertical strokes vary a little, and the positioning
 * along the baseline jumps around, giving it a more rustic and natural
 * feeling.

Most script fonts have long ascenders and descenders, and this means
 * they look too small when used at normal sizes on the web. This font it's
 * optimized in the technical details to be very readable as a web font, even when
 * used as small as at 16 pixels.

It was funded by people like you, via
 * Kickstarter.
Special thanks to the project backers! They are all listed on the
 * website: http://www.impallari.com/kaushan
 * 
 * Manufacturer:
 * Pablo Impallari
 * 
 * Designer:
 * Pablo Impallari
 * 
 * Vendor URL:
 * www.impallari.com
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":169,"face":{"font-family":"Kaushan Script","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"3 6 6 2 4 7 5 8 2 5","ascent":"288","descent":"-72","x-height":"13","cap-height":"29","bbox":"-75 -318 413 132.041","underline-thickness":"16.92","underline-position":"-17.64","stemh":"18","stemv":"45","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":85},"A":{"d":"96,-104v-21,37,-40,83,-43,131v-23,-7,-31,-12,-31,-22v0,-15,18,-57,48,-110r-29,0v3,-7,17,-13,39,-17v38,-63,87,-115,126,-136r0,-7v13,0,50,16,52,22v-24,42,-54,170,-46,270v-23,-2,-53,-4,-46,-35v0,-30,2,-60,7,-92v-13,-1,-47,-3,-77,-4xm178,-129r21,-92v-24,9,-60,48,-90,96v20,-2,43,-4,69,-4","w":231,"k":{"7":5,"4":4,"T":15,"Y":25,"a":12,"\u00e1":12,"s":3,"\"":3,"'":3,"c":14,"e":13,"\u00e9":13,"o":13,"\u00f3":13,"u":11,"\u00fa":11,"w":12,"y":11,"V":14,"W":12,"j":9,"X":3,"f":17,"z":11,"E":4,"\u00c9":4,"F":3,"t":15,"v":14,"x":4,"C":5,"G":5,"I":3,"\u00cd":3,"O":4,"\u00d3":4,"S":3,"U":5,"\u00da":5,"b":12,"q":14,"\u201c":3,"\u2018":3,"d":11,"h":10,"i":10,"\u00ed":10,"k":10,"l":10,"n":10,"\u00f1":10,"r":10,"g":14,"m":10,"\u2122":4,"*":4,"}":4,"p":6,")":-8,"\\":8}},"\u00c1":{"d":"96,-104v-21,37,-40,83,-43,131v-23,-7,-31,-12,-31,-22v0,-15,18,-57,48,-110r-29,0v3,-7,17,-13,39,-17v38,-63,87,-115,126,-136r0,-7v13,0,50,16,52,22v-24,42,-54,170,-46,270v-23,-2,-53,-4,-46,-35v0,-30,2,-60,7,-92v-13,-1,-47,-3,-77,-4xm178,-129r21,-92v-24,9,-60,48,-90,96v20,-2,43,-4,69,-4xm272,-318v10,3,21,14,21,23v-49,17,-58,29,-89,13v21,-5,48,-18,68,-36","w":231,"k":{"T":15,"Y":25,"a":12,"\u00e1":12,"s":3,"\"":3,"'":3,"c":14,"e":13,"\u00e9":13,"o":13,"\u00f3":13,"u":11,"\u00fa":11,"w":12,"y":11,"V":14,"W":12,"j":9,"X":3,"f":17,"z":11,"E":4,"\u00c9":4,"F":3,"t":15,"v":14,"x":4,"C":5,"G":5,"I":3,"\u00cd":3,"O":4,"\u00d3":4,"S":3,"U":5,"\u00da":5,"b":12,"q":14,"\u201c":3,"\u2018":3,"d":11,"h":10,"i":10,"\u00ed":10,"k":10,"l":10,"n":10,"\u00f1":10,"r":10,"g":14,"m":10,"\u2122":4,"*":4,"}":4,"p":6,")":-8,"\\":8}},"B":{"d":"192,-264v102,0,120,100,47,134v79,60,-16,159,-108,157v-37,0,-66,-14,-82,-40v18,-54,66,-172,95,-211v-26,8,-50,19,-60,29v-9,-6,-19,-24,-20,-36v25,-18,83,-33,128,-33xm225,-123v-24,9,-74,22,-90,1v-22,49,-41,98,-42,111v65,23,152,-28,152,-78v0,-16,-7,-27,-20,-34xm270,-202v0,-34,-49,-40,-87,-32v2,2,3,5,4,7v-9,12,-26,45,-43,83v13,-3,35,-4,50,-1v46,-8,76,-30,76,-57","w":258,"k":{"\\":11,"\/":5,"x":5,"v":8,"7":7,"q":2,")":7,"p":3,"m":3,"]":10,"}":5,"b":4,"X":8,"V":7,"T":18,"Y":21,"s":2,"c":3,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":2,"\u00fa":2,"w":4,"y":2,"W":6,"j":3,"f":11,"z":3,"E":2,"\u00c9":2,"t":6,"h":4,"i":3,"\u00ed":3,"k":3,"l":4,"n":2,"\u00f1":2,"r":3,"g":2,"Z":2}},"C":{"d":"219,-253v-69,0,-118,126,-118,194v0,35,12,58,30,62v21,-5,54,-27,91,-62v2,2,5,5,5,7v-27,37,-61,68,-85,80v-59,-1,-91,-35,-91,-99v0,-101,76,-195,161,-195v67,0,61,67,25,96v-12,-2,-23,-12,-25,-25v17,-14,27,-30,27,-43v0,-10,-7,-15,-20,-15","w":217,"k":{"A":2,"\u00c1":2,"T":4,"Y":9,"s":2,"c":4,"o":2,"\u00f3":2,"w":4,"j":2,"X":6,"f":5,"E":2,"\u00c9":2,"t":2,"v":6,"C":2,"G":2,"b":2,"q":2,"h":2,"i":2,"\u00ed":2,"k":3,"l":2,"\/":4}},"D":{"d":"60,-19v21,-48,74,-186,84,-220v-30,12,-53,38,-64,76v-11,-4,-21,-14,-24,-29v9,-44,55,-74,116,-74v77,0,131,47,131,116v0,94,-74,177,-160,177v-39,0,-69,-16,-83,-46xm273,-170v2,-61,-59,-90,-120,-73v21,8,36,17,41,22v-12,13,-97,193,-92,214v98,19,168,-66,171,-163","w":280,"k":{"T":19,"Y":22,"a":2,"\u00e1":2,"s":3,"\"":7,"'":7,"c":2,"o":2,"\u00f3":2,"u":2,"\u00fa":2,"w":3,"y":2,"V":9,"W":7,"\u201d":6,"\u2019":6,"j":3,"X":12,"f":3,"z":3,"t":3,"v":4,"x":3,"b":2,"q":2,"\u201c":9,"\u2018":9,"7":6,"d":2,"h":3,"i":2,"\u00ed":2,"k":3,"l":3,"n":3,"\u00f1":3,"r":3,"g":2,"m":3,"\u2122":6,"\/":8,"Z":4,"*":9,"}":6,"p":4,")":8,"\\":14,"]":11}},"E":{"d":"139,-149v37,-7,79,-11,69,31v-27,-5,-60,1,-85,6v-22,51,-37,97,-38,111v39,-8,79,-14,122,-17v6,10,11,24,8,39v-48,-1,-92,-3,-144,8v-11,-4,-22,-16,-32,-32v8,-17,23,-51,45,-110v-10,-3,-18,-10,-21,-18v3,-3,14,-6,31,-10v14,-37,20,-53,26,-81v-23,-1,-32,-18,-24,-37v47,7,143,-6,155,-6v11,0,20,12,24,33v-38,-4,-67,-1,-98,4v-6,9,-14,24,-38,79","w":219,"k":{"Y":5,"a":7,"\u00e1":7,"c":12,"e":8,"\u00e9":8,"o":9,"\u00f3":9,"u":7,"\u00fa":7,"w":9,"y":7,"f":6,"t":3,"v":9,"C":4,"G":4,"O":2,"\u00d3":2,"b":5,"q":11,"d":6,"h":5,"i":8,"\u00ed":8,"k":8,"l":5,"n":4,"\u00f1":4,"r":4,"g":9,"m":7,")":-14,"]":-6,"1":-2}},"\u00c9":{"d":"139,-149v37,-7,79,-11,69,31v-27,-5,-60,1,-85,6v-22,51,-37,97,-38,111v39,-8,79,-14,122,-17v6,10,11,24,8,39v-48,-1,-92,-3,-144,8v-11,-4,-22,-16,-32,-32v8,-17,23,-51,45,-110v-10,-3,-18,-10,-21,-18v3,-3,14,-6,31,-10v14,-37,20,-53,26,-81v-23,-1,-32,-18,-24,-37v47,7,143,-6,155,-6v11,0,20,12,24,33v-38,-4,-67,-1,-98,4v-6,9,-14,24,-38,79xm228,-318v10,3,21,14,21,23v-49,17,-57,29,-88,13v21,-5,47,-18,67,-36","w":219,"k":{"Y":5,"a":7,"\u00e1":7,"c":12,"e":8,"\u00e9":8,"o":9,"\u00f3":9,"u":7,"\u00fa":7,"w":9,"y":7,"f":6,"t":3,"v":9,"C":4,"G":4,"O":2,"\u00d3":2,"b":5,"q":11,"d":6,"h":5,"i":8,"\u00ed":8,"k":8,"l":5,"n":4,"\u00f1":4,"r":4,"g":9,"m":7,")":-14,"]":-6,"1":-2}},"F":{"d":"139,-145v38,-7,81,-13,71,31v-27,-5,-62,1,-87,5v-22,51,-35,95,-43,138v-16,-4,-28,-14,-39,-32v7,-15,17,-41,43,-107v-10,-3,-17,-9,-20,-17v3,-3,15,-6,31,-10v12,-36,26,-60,25,-85v-24,0,-36,-18,-27,-38v47,7,142,-6,154,-6v11,0,20,12,25,33v-37,-2,-64,0,-93,4v-6,9,-13,23,-40,84","w":198,"k":{"\/":17,"v":3,"2":-4,"3":-4,"7":-14,"\u201c":-5,"?":-2,"q":5,"p":8,"m":7,"j":2,"\u00ed":3,"*":-7,"M":3,"J":18,"a":6,"\u00e1":6,"s":10,"c":4,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":6,"\u00fa":6,"w":5,"y":6,",":14,"\u2026":14,".":14,"d":6,"h":2,"i":3,"k":3,"l":2,"n":8,"\u00f1":8,"r":6,"g":6}},"G":{"d":"221,-253v-64,0,-123,109,-123,189v0,42,18,71,41,73v31,-7,64,-52,68,-87v-27,7,-57,12,-66,-14v17,-9,72,-22,95,-22v17,0,23,17,19,35v-5,-1,-11,-2,-17,-2v-6,42,-54,98,-95,108v-64,-1,-92,-32,-92,-99v0,-99,79,-194,163,-194v60,-1,67,56,27,87v-11,-3,-20,-12,-22,-23v17,-12,22,-21,22,-35v0,-11,-7,-16,-20,-16","w":234,"k":{"4":-2,"T":6,"Y":14,"V":4,"W":4,"X":5,"f":6,"t":3,"v":4,"\/":6,"}":4,")":6,"\\":7,"]":7}},"H":{"d":"188,12v-23,-35,-6,-70,7,-123v-32,2,-66,8,-89,8v-21,50,-34,92,-41,132v-18,-4,-29,-16,-39,-32v8,-16,20,-46,43,-106v-8,-3,-13,-8,-16,-14v3,-2,12,-3,24,-6v20,-55,28,-71,39,-138v20,4,37,19,49,38v-9,12,-24,48,-44,93v30,-4,62,-8,85,-9v17,-50,38,-98,52,-112v9,1,35,13,40,22v-17,16,-35,54,-50,96v8,7,9,19,4,29v-4,-1,-8,-1,-13,-1v-17,58,-30,104,-26,140v-21,-1,-16,-13,-25,-17","w":243,"k":{"Y":4,"a":8,"\u00e1":8,"s":5,"c":8,"e":8,"\u00e9":8,"o":8,"\u00f3":8,"u":7,"\u00fa":7,"w":8,"y":7,"j":5,"f":9,"z":5,"t":6,"v":10,"x":5,"b":5,"q":9,"d":8,"h":6,"i":7,"\u00ed":7,"k":7,"l":6,"n":6,"\u00f1":6,"r":6,"g":9,"m":6,"p":6}},"I":{"d":"47,-21v0,-52,54,-208,81,-236v9,1,35,13,39,22v-41,43,-89,204,-84,264v-21,-1,-17,-13,-26,-17v-6,-3,-10,-25,-10,-33","w":113,"k":{"a":8,"\u00e1":8,"s":6,"c":10,"e":9,"\u00e9":9,"o":9,"\u00f3":9,"u":7,"\u00fa":7,"w":9,"y":7,"j":6,"f":12,"z":6,"t":8,"v":10,"x":5,"b":7,"q":9,"d":8,"h":6,"i":7,"\u00ed":7,"k":6,"l":6,"n":6,"\u00f1":6,"r":6,"g":9,"m":6,"p":6}},"\u00cd":{"d":"47,-21v0,-52,54,-208,81,-236v9,1,35,13,39,22v-41,43,-89,204,-84,264v-21,-1,-17,-13,-26,-17v-6,-3,-10,-25,-10,-33xm201,-318v10,3,21,14,21,23v-49,17,-57,29,-88,13v21,-5,47,-18,67,-36","w":113,"k":{"'":-31,"\u2019":-26,"\u2018":-3,"\u201d":-15,"\"":-31,")":-6,"]":-7,"}":-28,"*":-5,"a":8,"\u00e1":8,"s":6,"c":10,"e":9,"\u00e9":9,"o":9,"\u00f3":9,"u":7,"\u00fa":7,"w":9,"y":7,"j":6,"f":12,"z":6,"t":8,"v":10,"x":5,"b":7,"q":9,"d":8,"h":6,"i":7,"\u00ed":7,"k":6,"l":6,"n":6,"\u00f1":6,"r":6,"g":9,"m":6,"p":6}},"J":{"d":"50,37v79,-31,133,-197,121,-303v18,0,40,8,55,18v-31,144,-54,260,-154,301v-74,-5,-79,-46,-45,-104v12,1,33,10,39,18v-19,23,-39,49,-16,70","w":184,"k":{"Y":2,"a":5,"\u00e1":5,"s":6,"c":5,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":4,"\u00fa":4,"w":6,"y":4,"V":2,"W":2,"j":3,"f":4,"z":3,"t":3,"v":6,"x":4,"b":5,"q":5,"d":5,"h":4,"i":4,"\u00ed":4,"k":4,"l":4,"n":4,"\u00f1":4,"r":4,"g":5,"m":4,"\/":6,"p":4,")":4,"]":4}},"K":{"d":"120,-114v60,-89,119,-152,151,-152v13,0,32,22,32,38v-59,19,-115,63,-154,120v15,40,45,92,77,114v-5,10,-24,21,-36,21v-25,0,-41,-47,-70,-141xm166,-229v-24,39,-94,195,-100,258v-18,-4,-29,-16,-39,-32v12,-33,81,-180,90,-264v20,4,37,19,49,38","w":235,"k":{"7":-8,"\u00ed":12,"@":6,"A":4,"\u00c1":4,"a":18,"\u00e1":18,"c":29,"e":21,"\u00e9":21,"o":22,"\u00f3":22,"u":19,"\u00fa":19,"w":18,"y":18,"j":4,"f":16,"z":6,"t":15,"v":23,"x":4,"C":9,"G":10,"I":4,"\u00cd":4,"O":7,"\u00d3":7,"S":2,"b":5,"\u2014":12,"\u2013":12,"-":12,"q":28,"N":2,"\u00d1":2,"d":16,"h":10,"i":12,"k":14,"l":8,"n":14,"\u00f1":14,"r":14,"g":23,"m":17,"\u2122":-4,"*":-8,"p":4,")":-5,"Q":3}},"L":{"d":"73,-5v28,-1,64,-16,97,-16v8,14,11,27,7,42v-43,-4,-57,-1,-118,8v-11,-4,-23,-16,-32,-32v17,-35,80,-188,91,-266v19,4,32,14,45,33v-10,17,-87,207,-90,231","w":180,"k":{"0":10,"6":6,"7":16,"9":4,"4":22,"8":5,"@":9,"D":10,"R":4,"T":26,"Y":34,"a":12,"\u00e1":12,"\"":21,"'":21,"c":25,"e":16,"\u00e9":16,"o":16,"\u00f3":16,"u":12,"\u00fa":12,"w":14,"y":12,"V":23,"W":23,"\u201d":20,"\u2019":20,"j":2,"f":28,"z":3,"E":4,"\u00c9":4,"F":4,"t":31,"v":27,"C":18,"G":17,"I":6,"\u00cd":6,"O":12,"\u00d3":12,"S":10,"U":17,"\u00da":17,"b":28,"\u2014":23,"\u2013":23,"-":23,"q":20,"\u201c":20,"\u2018":20,"d":10,"h":10,"i":15,"\u00ed":15,"k":14,"l":12,"n":5,"\u00f1":5,"r":6,"B":8,"P":4,"g":18,"m":12,"\u2122":22,"*":21,")":-15,"\\":25,"]":-6}},"M":{"d":"17,5v0,-52,119,-255,163,-270v13,0,49,16,51,22v-13,27,-39,114,-49,185v33,-79,102,-184,134,-207v13,0,50,16,52,22v-35,69,-51,182,-46,270v-20,-3,-55,-5,-46,-37v-2,-60,16,-141,33,-211v-41,20,-118,162,-124,248v-24,-2,-52,-6,-46,-37v-2,-60,16,-138,32,-209v-34,27,-115,162,-123,246v-23,-7,-31,-12,-31,-22","w":339,"k":{"\\":9,"\u2122":4,"0":4,"x":4,"v":11,"7":5,"q":11,")":-9,"p":5,"m":8,"4":4,"}":4,"b":10,"@":4,"*":4,"X":2,"V":9,"F":3,"T":9,"Y":16,"a":9,"\u00e1":9,"s":3,"\"":4,"'":4,"c":12,"e":10,"\u00e9":10,"o":10,"\u00f3":10,"u":9,"\u00fa":9,"w":10,"y":8,"W":6,"\u201d":3,"\u2019":3,"j":6,"f":14,"z":9,"E":3,"\u00c9":3,"t":12,"C":5,"G":5,"I":2,"\u00cd":2,"O":4,"\u00d3":4,"S":3,"U":4,"\u00da":4,"\u2014":3,"\u2013":3,"-":3,"\u201c":3,"\u2018":3,"N":2,"\u00d1":2,"d":9,"h":7,"i":8,"\u00ed":8,"k":8,"l":7,"n":7,"\u00f1":7,"r":7,"g":11}},"N":{"d":"68,27v-27,-8,-35,-14,-35,-27v0,-44,66,-205,98,-250r-3,-15v13,0,54,16,56,22v-7,67,-6,151,14,217v23,-116,59,-234,77,-236v10,2,26,14,31,24v-46,20,-92,206,-93,265v-23,1,-48,-4,-51,-16v-22,-79,-26,-148,-29,-231v-28,52,-72,177,-65,247","w":245,"k":{"7":-5,"a":9,"\u00e1":9,"s":7,"c":11,"e":10,"\u00e9":10,"o":9,"\u00f3":9,"u":8,"\u00fa":8,"w":9,"y":8,"j":6,"f":13,"z":5,"t":7,"v":11,"x":5,"b":5,"q":10,"d":9,"h":7,"i":8,"\u00ed":8,"k":7,"l":7,"n":7,"\u00f1":7,"r":6,"g":10,"m":7,"p":6}},"\u00d1":{"d":"68,27v-27,-8,-35,-14,-35,-27v0,-44,66,-205,98,-250r-3,-15v13,0,54,16,56,22v-7,67,-6,151,14,217v23,-116,59,-234,77,-236v10,2,26,14,31,24v-46,20,-92,206,-93,265v-23,1,-48,-4,-51,-16v-22,-79,-26,-148,-29,-231v-28,52,-72,177,-65,247xm159,-307v37,11,58,6,95,-11v6,6,10,20,12,29v-39,19,-99,15,-107,-18","w":245,"k":{"a":9,"\u00e1":9,"s":7,"c":11,"e":10,"\u00e9":10,"o":9,"\u00f3":9,"u":8,"\u00fa":8,"w":9,"y":8,"j":6,"f":13,"z":5,"t":7,"v":11,"x":5,"b":5,"q":10,"d":9,"h":7,"i":8,"\u00ed":8,"k":7,"l":7,"n":7,"\u00f1":7,"r":6,"g":10,"m":7,"p":6}},"O":{"d":"288,-180v1,100,-75,210,-171,210v-44,0,-68,-29,-68,-83v0,-93,62,-237,153,-209v19,6,41,25,42,33v-8,-2,-17,-2,-23,-2v-66,0,-129,101,-129,187v0,37,13,56,37,56v88,0,147,-139,129,-247v12,6,30,14,30,55","w":260,"k":{"7":4,"T":17,"Y":22,"a":3,"\u00e1":3,"s":5,"c":3,"e":3,"\u00e9":3,"o":3,"\u00f3":3,"u":3,"\u00fa":3,"w":4,"y":3,"V":5,"W":5,"j":4,"X":12,"f":2,"z":2,"t":2,"v":3,"x":3,"b":3,"q":3,"d":3,"h":4,"i":3,"\u00ed":3,"k":4,"l":4,"n":4,"\u00f1":4,"r":4,"g":3,"m":4,"\/":9,"Z":5,"}":5,"p":5,")":9,"\\":10,"]":11}},"\u00d3":{"d":"288,-180v1,100,-75,210,-171,210v-44,0,-68,-29,-68,-83v0,-93,62,-237,153,-209v19,6,41,25,42,33v-8,-2,-17,-2,-23,-2v-66,0,-129,101,-129,187v0,37,13,56,37,56v88,0,147,-139,129,-247v12,6,30,14,30,55xm283,-318v10,3,21,14,21,23v-49,17,-58,29,-88,13v21,-5,47,-18,67,-36","w":260,"k":{"T":17,"Y":22,"a":3,"\u00e1":3,"s":5,"c":3,"e":3,"\u00e9":3,"o":3,"\u00f3":3,"u":3,"\u00fa":3,"w":4,"y":3,"V":5,"W":5,"j":4,"X":12,"f":2,"z":2,"t":2,"v":3,"x":3,"b":3,"q":3,"d":3,"h":4,"i":3,"\u00ed":3,"k":4,"l":4,"n":4,"\u00f1":4,"r":4,"g":3,"m":4,"\/":9,"Z":5,"}":5,"p":5,")":9,"\\":10,"]":11}},"P":{"d":"282,-194v0,53,-57,99,-124,99v-12,0,-17,-3,-26,-12v-24,52,-38,95,-47,136v-18,-4,-29,-16,-38,-32v7,-14,75,-163,89,-220v-22,7,-42,18,-55,28v-8,-6,-19,-25,-20,-36v53,-39,221,-60,221,37xm267,-196v0,-35,-39,-47,-78,-39r5,6v-10,12,-29,52,-52,100v75,0,125,-30,125,-67","w":231,"k":{"\/":22,"q":5,")":12,"p":3,"m":4,"j":2,"]":13,"X":6,"J":30,"T":3,"Y":8,"a":9,"\u00e1":9,"s":8,"c":4,"e":6,"\u00e9":6,"o":6,"\u00f3":6,"u":5,"\u00fa":5,"w":3,"y":5,",":30,"\u2026":30,".":30,"\u2014":3,"\u2013":3,"-":3,"d":7,"i":4,"\u00ed":4,"k":2,"n":4,"\u00f1":4,"r":3,"g":8,"Z":4}},"Q":{"d":"295,-193v2,70,-62,182,-132,211v26,14,72,35,81,35v5,0,14,-6,19,-14v16,19,-21,46,-33,52v-17,-1,-25,-4,-55,-25v-53,-36,-76,-47,-107,-47v-26,0,-42,9,-45,27v-3,-1,-6,-4,-6,-7v0,-24,18,-37,49,-41v-11,-9,-17,-27,-17,-50v0,-101,76,-214,144,-214v27,0,58,27,61,37v-99,-26,-159,110,-168,208v-3,35,27,17,49,30v79,-22,148,-142,133,-244v19,10,27,22,27,42","w":258,"k":{"\\":8,"\/":-27,"v":2,";":-11,"q":2,")":-29,"p":2,"m":3,",":-19,"]":-15,"}":-11,"b":2,"X":10,"V":3,"Q":-7,"J":-5,"T":11,"Y":17,"a":2,"\u00e1":2,"c":2,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":3,"\u00fa":3,"w":3,"y":3,"W":3,"j":-9,"d":2,"h":3,"i":3,"\u00ed":3,"k":3,"l":3,"n":3,"\u00f1":3,"r":3,"g":2,"Z":-16}},"R":{"d":"153,-105v-10,0,-16,0,-19,-6v-26,56,-40,96,-49,140v-16,-4,-29,-14,-39,-32v6,-13,11,-19,61,-138v15,-36,20,-51,28,-82v-22,8,-42,18,-54,28v-8,-6,-20,-25,-21,-36v54,-39,223,-60,221,33v0,46,-44,83,-101,91v15,43,43,94,68,117v-4,9,-21,21,-32,21v-21,0,-37,-38,-63,-136xm193,-229v-6,9,-31,56,-50,97v72,0,124,-28,124,-68v0,-32,-40,-42,-78,-35","w":248,"k":{"0":4,"3":4,"6":5,"7":8,"1":-2,"4":6,"8":5,"@":5,"T":15,"Y":19,"a":13,"\u00e1":13,"c":18,"e":15,"\u00e9":15,"o":15,"\u00f3":15,"u":13,"\u00fa":13,"w":12,"y":13,"V":8,"W":7,"X":6,"f":9,"z":3,"E":3,"\u00c9":3,"F":3,"t":6,"v":11,"C":4,"G":4,"O":3,"\u00d3":3,"S":4,"U":3,"\u00da":3,"b":9,"q":18,"d":11,"h":8,"i":14,"\u00ed":14,"k":12,"l":8,"n":6,"\u00f1":6,"r":8,"g":18,"m":12,"}":5,")":-10,"\\":12,"?":4,"&":4}},"S":{"d":"81,-191v0,-42,47,-76,98,-75v31,0,62,10,92,23v6,23,-1,43,-17,52v-19,-26,-58,-37,-92,-37v-33,0,-62,10,-62,27v0,50,160,65,160,141v0,49,-34,87,-89,87v-70,0,-180,-51,-116,-118v-1,33,79,75,124,75v54,0,66,-32,66,-43v0,-19,-36,-35,-77,-53v-61,-27,-87,-45,-87,-79","w":252,"k":{"7":6,"T":13,"Y":20,"\"":6,"'":6,"c":4,"o":2,"\u00f3":2,"w":4,"V":11,"W":9,"\u201d":5,"\u2019":5,"j":2,"f":14,"z":2,"t":9,"v":10,"C":2,"G":2,"U":2,"\u00da":2,"b":5,"q":3,"\u201c":6,"\u2018":6,"h":3,"i":3,"\u00ed":3,"k":3,"l":3,"r":2,"m":2,"\u2122":7,"*":6,"}":4,"\\":11,"]":4}},"T":{"d":"160,-222v-42,9,-94,7,-79,-38v42,12,163,-6,180,-6v18,0,24,15,28,37v-30,-3,-52,-3,-81,1v-32,65,-73,190,-82,258v-17,-3,-29,-12,-40,-30v7,-35,57,-161,74,-222","w":211,"k":{"2":-7,"3":-8,"6":7,"7":-17,"\u201d":-4,"\u201c":-10,"\u00ed":15,"@":17,"A":17,"\u00c1":17,"J":17,"a":41,"\u00e1":41,"s":35,"c":42,"e":41,"\u00e9":41,"o":41,"\u00f3":41,"u":41,"\u00fa":41,"w":42,"y":40,"\u2019":-4,"j":2,"f":18,"z":32,"t":32,"v":35,"x":30,",":19,"\u2026":19,".":19,"C":2,"G":3,"b":2,"\u2014":19,"\u2013":19,"-":19,"q":41,"\u2018":-10,"d":13,"h":5,"i":15,"k":9,"l":13,"n":39,"\u00f1":39,"r":35,"M":10,"g":41,"m":39,"\u2122":-3,"\/":16,"*":-12,"p":29,"]":-3,"Q":2,"?":-5,":":18,";":18}},"U":{"d":"288,-252v-11,113,-45,282,-160,282v-44,0,-70,-26,-70,-78v0,-60,30,-159,62,-218v17,1,46,14,55,24v-42,57,-70,141,-70,201v0,37,9,53,36,53v90,0,119,-167,111,-273v3,0,26,3,36,9","w":250,"k":{"T":3,"Y":4,"a":5,"\u00e1":5,"s":6,"c":5,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":5,"\u00fa":5,"w":6,"y":5,"V":2,"W":2,"j":4,"X":4,"f":3,"z":3,"t":3,"v":6,"x":4,"b":4,"q":5,"d":5,"h":5,"i":5,"\u00ed":5,"k":5,"l":6,"n":5,"\u00f1":5,"r":4,"g":5,"m":4,"\/":8,"Z":2,"}":4,"p":4,")":6,"]":6}},"\u00da":{"d":"288,-252v-11,113,-45,282,-160,282v-44,0,-70,-26,-70,-78v0,-60,30,-159,62,-218v17,1,46,14,55,24v-42,57,-70,141,-70,201v0,37,9,53,36,53v90,0,119,-167,111,-273v3,0,26,3,36,9xm248,-318v10,3,21,14,21,23v-49,17,-57,29,-88,13v21,-5,47,-18,67,-36","w":250,"k":{"T":3,"Y":4,"a":5,"\u00e1":5,"s":6,"c":5,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":5,"\u00fa":5,"w":6,"y":5,"V":2,"W":2,"j":4,"X":4,"f":3,"z":3,"t":3,"v":6,"x":4,"b":4,"q":5,"d":5,"h":5,"i":5,"\u00ed":5,"k":5,"l":6,"n":5,"\u00f1":5,"r":4,"g":5,"m":4,"\/":8,"Z":2,"}":4,"p":4,")":6,"]":6}},"V":{"d":"151,23v-19,10,-46,-2,-56,-12v-17,-109,-5,-148,-6,-276v13,0,54,16,56,22v-15,40,-17,182,-8,237v40,-122,110,-254,132,-256v10,2,25,14,29,24v-54,19,-136,204,-147,261","w":222,"k":{"\/":13,"\u2122":-12,"x":18,"v":22,"2":-3,"3":-9,"7":-17,"\u201c":-6,"?":-2,"q":20,"p":17,"m":18,"j":4,"\u00ed":9,"b":3,"@":6,"*":-10,"M":5,"A":6,"\u00c1":6,"J":10,"a":20,"\u00e1":20,"s":22,"c":22,"e":21,"\u00e9":21,"o":21,"\u00f3":21,"u":18,"\u00fa":18,"w":21,"y":18,"f":16,"z":18,"t":17,",":12,"\u2026":12,".":12,"G":2,"\u2014":8,"\u2013":8,"-":8,"d":15,"h":8,"i":9,"k":11,"l":6,"n":17,"\u00f1":17,"r":17,"g":21,":":6,";":6}},"W":{"d":"82,11v-9,-103,5,-149,13,-276v13,0,52,16,55,22v-19,47,-30,160,-25,239v30,-44,94,-219,103,-261v13,0,54,16,55,22v-19,46,-29,157,-25,235v46,-120,107,-237,122,-253v11,1,24,9,33,19v-42,33,-122,208,-142,265v-19,10,-46,-1,-55,-12v-9,-67,-1,-120,5,-192v-22,65,-55,155,-84,204v-19,10,-46,-2,-55,-12","w":343,"k":{"3":-5,"7":-11,"@":5,"A":5,"\u00c1":5,"J":8,"a":17,"\u00e1":17,"s":17,"c":17,"e":18,"\u00e9":18,"o":18,"\u00f3":18,"u":16,"\u00fa":16,"w":19,"y":16,"j":7,"f":14,"z":3,"t":5,"v":18,"x":8,",":10,"\u2026":10,".":10,"C":2,"G":2,"b":3,"\u2014":6,"\u2013":6,"-":6,"q":17,"d":16,"h":10,"i":12,"\u00ed":12,"k":13,"l":8,"n":15,"\u00f1":15,"r":14,"M":5,"g":18,"m":15,"\/":13,"*":-9,"p":14,")":4,"Q":2}},"X":{"d":"170,-139v35,-41,66,-70,75,-106v0,-4,-1,-9,-4,-17v15,9,22,15,28,29v-2,23,-18,41,-95,112v19,87,33,115,59,122v-8,9,-37,25,-50,25v-13,0,-16,-13,-38,-124v-55,56,-95,110,-95,127v-12,-1,-26,-16,-26,-28v24,-46,57,-70,117,-119v-15,-77,-38,-116,-66,-116v6,-14,20,-25,34,-28v32,0,37,9,61,123","w":229,"k":{"\\":4,"0":4,"v":18,"q":22,")":-7,"1":-7,"m":13,"4":8,"b":15,"@":5,"V":5,"Q":3,"F":4,"T":7,"Y":14,"a":15,"\u00e1":15,"c":21,"e":16,"\u00e9":16,"o":16,"\u00f3":16,"u":15,"\u00fa":15,"w":15,"y":15,"W":5,"j":2,"f":17,"z":3,"E":4,"\u00c9":4,"t":16,"C":10,"G":10,"I":6,"\u00cd":6,"O":8,"\u00d3":8,"S":6,"U":4,"\u00da":4,"\u2014":13,"\u2013":13,"-":13,"d":12,"h":10,"i":15,"\u00ed":15,"k":13,"l":10,"n":6,"\u00f1":6,"r":7,"g":16}},"Y":{"d":"169,-124v36,-39,64,-82,88,-137v13,1,25,7,32,14v-53,63,-83,102,-112,144v-14,49,-26,101,-26,129v-10,0,-51,-9,-55,-13v15,-26,30,-79,42,-115v-24,-75,-45,-134,-63,-154v9,-4,43,-8,62,-9v0,35,22,129,32,141","w":220,"k":{"0":6,"6":9,"7":-8,"1":5,"9":5,"\u00ed":17,"4":6,"8":4,"@":12,"A":12,"\u00c1":12,"J":13,"a":30,"\u00e1":30,"s":30,"c":31,"e":30,"\u00e9":30,"o":29,"\u00f3":29,"u":27,"\u00fa":27,"w":30,"y":27,"j":9,"f":22,"z":24,"E":3,"\u00c9":3,"t":22,"v":31,"x":21,",":19,"\u2026":19,".":19,"C":7,"G":7,"I":3,"\u00cd":3,"O":6,"\u00d3":6,"S":4,"U":2,"\u00da":2,"b":8,"\u2014":21,"\u2013":21,"-":21,"q":29,"H":4,"K":2,"N":5,"\u00d1":5,"d":20,"h":15,"i":17,"k":19,"l":13,"n":26,"\u00f1":26,"r":26,"M":11,"g":30,"m":26,"\/":15,"Z":3,"*":-9,"}":6,"p":26,")":5,"Q":5,"&":5,":":11,";":11,"!":5}},"Z":{"d":"80,-12v29,-3,142,-12,144,-26v4,11,14,43,10,62v-80,-7,-179,-2,-222,36v-9,-19,-16,-46,5,-56v57,-82,151,-164,240,-221v-53,-2,-128,-2,-159,14v-3,-11,-6,-49,0,-63v60,10,138,20,204,14v8,10,8,27,8,39v-110,45,-201,146,-230,201","w":251,"k":{"Y":4,"a":5,"\u00e1":5,"c":4,"e":4,"\u00e9":4,"o":4,"\u00f3":4,"u":5,"\u00fa":5,"w":5,"y":5,"j":4,"f":2,"v":4,"q":5,"d":5,"h":3,"i":4,"\u00ed":4,"k":4,"l":3,"n":5,"\u00f1":5,"r":4,"g":5,"m":5,"p":3,")":-9}},"a":{"d":"67,-14v25,-4,73,-90,92,-131v10,0,27,7,27,12v-21,53,-47,96,-24,134v-18,10,-42,10,-42,-20v0,-13,4,-34,13,-57v-19,44,-51,80,-73,84v-18,-1,-30,-19,-30,-44v0,-54,52,-127,91,-129v10,3,26,20,27,29v-39,6,-86,70,-86,114v0,5,2,7,5,8","k":{"X":9,"W":21,"V":25,"S":10,"R":14,"Q":6,"P":14,"N":5,"L":6,"K":5,"H":5,"G":8,"F":10,"C":8,"B":14,"D":20,"T":47,"Y":57,"a":2,"\u00e1":2,"\"":11,"'":11,"c":3,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":1,"\u00fa":1,"w":3,"y":1,"\u201d":16,"\u2019":16,"f":5,"z":1,"E":10,"\u00c9":10,"t":6,"v":4,"I":6,"\u00cd":6,"O":7,"\u00d3":7,"U":9,"\u00da":9,"b":3,"q":2,"\u201c":19,"\u2018":19,"d":1,"i":1,"\u00ed":1,"g":2,"\u2122":5,"*":12,"}":8,"\\":24,"]":9,"?":6}},"\u00e1":{"d":"67,-14v25,-4,73,-90,92,-131v10,0,27,7,27,12v-21,53,-47,96,-24,134v-18,10,-42,10,-42,-20v0,-13,4,-34,13,-57v-19,44,-51,80,-73,84v-18,-1,-30,-19,-30,-44v0,-54,52,-127,91,-129v10,3,26,20,27,29v-39,6,-86,70,-86,114v0,5,2,7,5,8xm201,-262v10,6,21,28,21,41v-49,28,-55,42,-88,25v21,-8,47,-33,67,-66","k":{"D":20,"T":47,"Y":57,"a":2,"\u00e1":2,"\"":11,"'":11,"c":3,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":1,"\u00fa":1,"w":3,"y":1,"\u201d":16,"\u2019":16,"f":5,"z":1,"E":10,"\u00c9":10,"t":6,"v":4,"I":6,"\u00cd":6,"O":7,"\u00d3":7,"U":9,"\u00da":9,"b":3,"q":2,"\u201c":19,"\u2018":19,"d":1,"i":1,"\u00ed":1,"g":2,"\u2122":5,"*":12,"}":8,"\\":24,"]":9,"?":6}},"^":{"d":"93,-257v4,57,10,80,23,95v-20,5,-31,-19,-44,-49v-19,26,-35,43,-58,23v18,-10,35,-28,49,-55v-7,-16,14,-14,30,-14","w":129},"~":{"d":"50,-97v29,-19,73,5,105,-11v6,6,11,18,13,28v-36,28,-64,-7,-115,-3v-2,-3,-2,-8,-3,-14","w":158},"*":{"d":"157,-300v47,0,31,40,13,58v14,0,29,-5,45,-12v1,16,5,36,-16,37v-12,0,-22,-2,-34,-7v5,13,12,25,24,39v-9,5,-19,8,-27,8v-18,-2,-19,-32,-17,-47v-11,9,-20,20,-29,36v-6,-5,-17,-16,-17,-29v0,-11,32,-23,40,-25v-11,-7,-25,-12,-43,-16v11,-44,45,-21,58,5v5,-14,5,-30,3,-47","w":163,"k":{"X":-5,"P":-19,"M":4,"B":-17}},"@":{"d":"44,-64v0,-47,62,-135,127,-135v44,0,83,36,83,69v0,39,-55,99,-87,99v-20,0,-42,-22,-42,-42v0,-23,18,-51,52,-61v18,6,33,25,34,40v-26,-11,-52,11,-51,34v0,6,4,10,10,10v41,-2,116,-121,27,-121v-50,0,-110,66,-110,123v0,35,22,64,52,64v21,0,46,-14,83,-49v3,4,3,5,3,8v-28,29,-60,58,-95,58v-48,0,-86,-56,-86,-97","w":235,"k":{"\u2019":10,"Y":26,"W":9,"V":9,"T":19,"\"":8,"'":8}},"b":{"d":"62,-4v-7,-8,-23,-14,-22,-32v0,-86,69,-244,115,-264v9,3,29,16,35,22v-53,42,-92,110,-116,201v27,-50,70,-97,90,-97v15,4,32,21,32,38v0,61,-62,149,-102,149v-11,0,-26,-5,-26,-10v45,-30,95,-96,95,-151v0,-3,-1,-5,-4,-6v-20,1,-93,114,-97,150","k":{"\\":13,"\u2122":6,"x":3,"?":6,")":5,"]":11,"}":6,"*":8,"Z":5,"X":19,"W":17,"V":21,"S":3,"R":14,"Q":4,"P":14,"N":5,"M":3,"L":6,"K":6,"J":2,"H":3,"G":4,"F":10,"C":4,"B":12,"D":14,"T":40,"Y":39,"s":1,"\"":7,"'":7,"\u201d":8,"\u2019":8,"f":1,"E":9,"\u00c9":9,"t":1,"I":6,"\u00cd":6,"O":4,"\u00d3":4,"U":8,"\u00da":8,"\u201c":9,"\u2018":9}},"|":{"d":"65,47r-30,-15v2,-87,62,-279,101,-331v12,2,36,17,40,23v-61,67,-98,231,-111,323","w":99,"k":{"v":5,"q":4,"m":4,"P":-4,"B":-3,"R":-5,"Y":-3,"a":4,"\u00e1":4,"c":4,"e":4,"\u00e9":4,"o":4,"\u00f3":4,"u":4,"\u00fa":4,"w":4,"y":4}},"{":{"d":"109,-241v15,-39,45,-71,77,-37v-63,32,-25,128,-99,152v60,28,-7,119,-7,154v0,14,13,21,32,25r-3,5v-24,-4,-61,-13,-61,-43v0,-28,33,-72,33,-106v0,-22,-13,-29,-32,-29v-10,-7,0,-10,7,-12v41,-19,36,-65,53,-109","w":120,"k":{"0":5,"v":8,"6":4,"q":5,"(":5,"9":5,"m":5,"4":7,"5":4,"f":5,"{":6,"b":4,"V":4,"A":4,"\u00c1":4,"T":4,"Y":8,"a":4,"\u00e1":4,"c":6,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":5,"\u00fa":5,"w":6,"y":5,"W":6,"z":4,"t":5,"C":5,"G":5,"I":4,"\u00cd":4,"O":5,"\u00d3":5,"U":5,"\u00da":5,"h":4,"i":4,"\u00ed":4,"k":4,"n":4,"\u00f1":4,"r":4,"g":4}},"}":{"d":"87,7v-14,39,-45,71,-77,37v64,-31,25,-128,99,-152v-60,-28,7,-119,7,-154v0,-14,-12,-21,-31,-25r3,-5v24,4,60,13,60,43v0,28,-33,72,-33,106v0,22,14,29,33,29v3,2,5,5,5,7v-52,14,-48,65,-66,114","w":120,"k":{"]":6,"}":6}},"[":{"d":"188,-285v25,1,25,10,23,24v-18,-2,-39,-1,-59,0v-3,37,-100,268,-100,294v20,-5,89,-28,80,12v-31,-3,-56,0,-87,5v-11,-4,-20,-16,-29,-32v11,-20,106,-283,103,-295v24,-5,56,-8,69,-8","w":138,"k":{"0":10,"v":5,"6":12,"7":-3,"q":5,"(":5,"1":4,"9":7,"m":5,"4":10,"5":6,"8":5,"{":5,"P":-5,"M":4,"F":-2,"B":-5,"A":8,"\u00c1":8,"R":-6,"T":-7,"Y":-8,"a":5,"\u00e1":5,"c":5,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":5,"\u00fa":5,"w":5,"y":5,"C":8,"G":8,"I":5,"\u00cd":5,"O":7,"\u00d3":7,"U":4,"\u00da":4,"N":4,"\u00d1":4,"n":4,"\u00f1":4,"r":4,"g":5,"Z":-4}},"]":{"d":"27,50v-25,-1,-25,-9,-23,-23v18,2,39,1,59,0v3,-37,100,-268,100,-294v-20,5,-89,28,-80,-12v31,3,56,-1,87,-6v11,4,20,17,29,33v-11,20,-106,283,-103,295v-24,5,-56,7,-69,7","w":138},"c":{"d":"148,-151v-35,6,-71,63,-71,107v0,61,42,25,75,4v2,1,4,5,4,7v-16,20,-46,40,-62,43v-109,-26,-42,-181,42,-181v53,0,45,76,12,80v-6,0,-12,-4,-16,-10v16,-15,24,-28,24,-40v0,-7,-3,-10,-8,-10","w":151,"k":{"Z":2,"X":11,"W":22,"V":26,"S":4,"R":17,"Q":4,"P":18,"N":4,"M":2,"L":5,"K":5,"H":3,"G":5,"F":9,"C":5,"B":14,"D":14,"T":41,"Y":48,"\"":5,"'":5,"\u201d":7,"\u2019":7,"f":2,"E":8,"\u00c9":8,"t":1,"v":1,"x":2,"I":8,"\u00cd":8,"O":5,"\u00d3":5,"U":11,"\u00da":11,"\u201c":11,"\u2018":11,"\u2122":3,"*":7,"}":6,"\\":21,"]":10,"?":5}},":":{"d":"89,-22v-15,29,-42,50,-58,22v0,-12,9,-39,11,-48v11,0,38,12,47,26xm125,-136v-15,29,-42,48,-58,21v0,-12,9,-39,11,-48v11,0,38,13,47,27","w":102,"k":{"T":21,"Y":26,"V":10,"W":9,"\u201d":4,"\u2019":4}},",":{"d":"6,61v-3,-3,-6,-9,-6,-14v34,-29,39,-51,30,-96v24,1,48,13,51,25v-11,40,-36,68,-75,85","w":86,"k":{"\u201d":35,"\u201c":41,"\"":34,"D":6,"T":22,"Y":31,"'":34,"c":6,"V":21,"W":18,"\u2019":35,"f":9,"t":7,"v":6,"C":9,"G":9,"I":4,"\u00cd":4,"O":7,"\u00d3":7,"S":3,"U":8,"\u00da":8,"b":5,"4":25,"\u2014":7,"\u2013":7,"-":7,"9":4,"q":5,"\u2018":41,"7":20,"0":8}},"d":{"d":"113,-168v9,0,24,6,34,15v-4,-38,-13,-64,-48,-120v3,-9,21,-24,33,-26v27,30,49,93,49,143v0,75,-52,167,-101,175v-33,-4,-52,-21,-52,-52v0,-50,48,-126,85,-135xm77,5v36,-14,73,-88,70,-151v-35,15,-87,94,-87,131v0,12,6,18,17,20","w":155,"k":{"Z":4,"X":17,"W":16,"V":20,"S":4,"R":10,"Q":4,"P":11,"N":4,"M":3,"L":5,"K":5,"H":4,"G":4,"F":9,"C":4,"B":10,"D":6,"T":31,"Y":35,"\"":3,"'":3,"\u201d":3,"\u2019":3,"E":10,"\u00c9":10,"x":1,"I":6,"\u00cd":6,"O":4,"\u00d3":4,"U":8,"\u00da":8,"\u201c":4,"\u2018":4,"\u2122":4,"*":4,"}":6,")":5,"\\":12,"]":9,"?":4}},"e":{"d":"164,-149v-4,59,-35,83,-96,107v-2,15,-1,38,16,38v26,0,51,-26,66,-42v3,2,4,4,6,6v-22,28,-49,49,-72,54v-33,-4,-53,-26,-53,-55v0,-68,81,-172,133,-108xm139,-137v-26,4,-56,36,-68,81v38,-19,66,-48,68,-81","w":145,"k":{"D":17,"R":16,"T":40,"Y":50,"\"":6,"'":6,"V":24,"W":21,"\u201d":8,"\u2019":8,"X":9,"f":3,"E":9,"\u00c9":9,"F":10,"t":3,"v":3,"x":2,"C":8,"G":8,"I":8,"\u00cd":8,"O":7,"\u00d3":7,"S":4,"U":12,"\u00da":12,"\u201c":12,"\u2018":12,"H":3,"K":4,"L":5,"N":4,"\u00d1":4,"B":14,"P":16,"\u2122":4,"*":8,"}":6,"\\":22,"]":9,"Q":4,"?":6}},"\u00e9":{"d":"164,-149v-4,59,-35,83,-96,107v-2,15,-1,38,16,38v26,0,51,-26,66,-42v3,2,4,4,6,6v-22,28,-49,49,-72,54v-33,-4,-53,-26,-53,-55v0,-68,81,-172,133,-108xm139,-137v-26,4,-56,36,-68,81v38,-19,66,-48,68,-81xm198,-262v10,6,21,28,21,41v-49,28,-55,42,-88,25v21,-8,47,-33,67,-66","w":145,"k":{"\u201c":12,"?":6,"*":8,"D":17,"R":16,"T":40,"Y":50,"\"":6,"'":6,"V":24,"W":21,"\u201d":8,"\u2019":8,"X":9,"f":3,"E":9,"\u00c9":9,"F":10,"t":3,"v":3,"x":2,"C":8,"G":8,"I":8,"\u00cd":8,"O":7,"\u00d3":7,"S":4,"U":12,"\u00da":12,"\u2018":12,"H":3,"K":4,"L":5,"N":4,"\u00d1":4,"B":14,"P":16,"\u2122":4,"}":6,"\\":22,"]":9,"Q":4}},"8":{"d":"210,-75v0,53,-49,91,-94,91v-42,0,-77,-15,-77,-62v0,-43,33,-71,79,-92v-17,-15,-31,-32,-31,-56v0,-41,46,-68,85,-73v36,12,61,30,61,53v0,25,-32,50,-65,65v20,20,42,41,42,74xm76,-39v0,27,17,39,35,39v24,0,52,-23,52,-67v0,-23,-13,-39,-28,-54v-44,25,-59,56,-59,82xm154,-162v27,-16,73,-69,27,-87v-20,4,-47,24,-47,45v0,17,8,29,20,42","w":204,"k":{"\\":9,"\/":6,"7":4,")":6,"]":9,"}":5,"Y":15,"W":7,"V":7,"T":9}},"\u2026":{"d":"83,-22v-15,29,-42,50,-58,22v0,-12,8,-39,10,-48v11,0,39,12,48,26xm166,-22v-14,29,-41,50,-58,22v0,-12,9,-39,11,-48v11,0,38,12,47,26xm250,-22v-15,29,-42,50,-58,22v0,-12,8,-39,10,-48v11,0,39,12,48,26","w":253},"\u2014":{"d":"79,-67v-22,0,-35,-14,-28,-35v47,6,143,-5,156,-5v11,0,21,11,25,32v-57,-7,-110,8,-153,8","w":224,"k":{"D":4,"T":21,"Y":31,"s":8,"\"":10,"'":10,"V":11,"W":9,"\u201d":13,"\u2019":13,"X":9,"f":9,"z":9,"E":3,"\u00c9":3,"F":3,"t":5,"v":3,"x":8}},"\u2013":{"d":"77,-67v-21,0,-33,-15,-26,-35v44,6,135,-5,146,-5v10,0,19,11,23,32v-54,-7,-104,8,-143,8","w":212,"k":{"D":4,"T":21,"Y":31,"s":8,"\"":10,"'":10,"V":11,"W":9,"\u201d":13,"\u2019":13,"X":9,"f":9,"z":9,"E":3,"\u00c9":3,"F":3,"t":5,"v":3,"x":8}},"=":{"d":"71,-33v-22,0,-31,-17,-23,-36v37,6,116,-4,126,-4v9,0,16,12,19,31v-46,-7,-88,9,-122,9xm93,-104v-20,1,-30,-18,-22,-35v36,9,115,-5,125,-5v9,0,17,12,20,32v-46,-7,-89,8,-123,8","w":205,"k":{"7":8}},"!":{"d":"51,-68v0,-40,68,-196,96,-217v15,3,38,24,40,36v-49,41,-99,122,-114,209v-12,-3,-22,-7,-22,-28xm44,28v-32,-1,-23,-49,-5,-57v13,0,29,11,35,23v-11,12,-16,34,-30,34","w":108},"f":{"d":"200,-207v-7,-13,-11,-34,-7,-53v-16,0,-40,42,-61,104r30,-1v2,2,5,12,5,21r-40,-2v-36,108,-64,201,-72,242v-15,-6,-7,-23,-23,-29v8,-49,17,-92,51,-213v-19,-2,-34,9,-35,-7v5,-2,21,-5,39,-8v29,-78,57,-125,115,-117v9,-5,19,-11,29,-2v-9,16,-19,58,-31,65","w":123,"k":{"&":-2,"\\":-21,"\u2122":-20,"\u2019":-20,"\u201d":-13,"?":-14,")":-12,"j":-13,"]":-36,"}":-19,"|":-5,"*":-28,"Z":-16,"X":-25,"W":-19,"V":-25,"S":-10,"R":-37,"P":-37,"M":3,"J":9,"F":-19,"B":-34,"A":5,"\u00c1":5,"D":-28,"T":-31,"Y":-34,"a":2,"\u00e1":2,"s":1,"\"":-24,"'":-24,"e":1,"\u00e9":1,"o":1,"\u00f3":1,"E":-16,"\u00c9":-16,",":6,"\u2026":6,".":6,"U":-3,"\u00da":-3,"\u2014":7,"\u2013":7,"-":7,"\u201c":-17,"\u2018":-17,"d":1,"g":3}},"5":{"d":"63,-137v13,-34,45,-96,62,-118v9,4,23,10,32,19v13,-1,52,-9,64,-13v16,8,24,24,32,46v-29,-8,-64,-13,-95,-13v-20,18,-38,51,-46,67v43,-18,81,12,80,56v0,53,-72,105,-135,106v-12,-3,-25,-14,-30,-33v53,-1,140,-39,140,-89v0,-35,-52,-21,-72,-7v-10,-4,-26,-12,-32,-21","w":193,"k":{"\/":12,")":7,"]":8,"Y":9,"R":-9,"P":-9,"B":-5,"D":-15}},"4":{"d":"223,-248v14,3,32,10,40,23v-25,35,-48,73,-68,113v8,-1,22,-8,22,4r-29,10v-17,35,-30,71,-38,109v-14,0,-29,-2,-39,-13v9,-29,19,-56,32,-84v-41,4,-81,6,-106,-22v38,-43,71,-95,95,-148v17,5,34,13,48,25v-33,37,-77,89,-98,119v21,9,44,9,70,6v23,-49,47,-96,71,-142","w":205,"k":{"\/":11,")":6,"]":6,"Y":5,"X":-3,"R":-10,"P":-9,"J":4,"B":-6,"D":-6}},"g":{"d":"62,-15v32,-12,87,-80,99,-121v13,1,23,4,27,8v-40,92,-59,175,-110,232v-32,36,-92,35,-116,3v0,-3,2,-5,5,-7v12,10,15,12,25,12v50,0,92,-55,117,-146v-11,12,-36,29,-49,34v-16,-3,-29,-23,-29,-46v0,-56,67,-127,118,-127v17,0,24,6,28,23v-3,-1,-6,-2,-10,-2v-34,1,-114,92,-105,137","w":162,"k":{"Z":3,"X":14,"W":18,"V":22,"S":5,"R":14,"Q":5,"P":15,"N":5,"M":3,"L":6,"K":6,"H":4,"G":5,"F":10,"C":5,"B":13,"D":16,"T":45,"Y":52,"\"":6,"'":6,"\u201d":8,"\u2019":8,"f":3,"E":11,"\u00c9":11,"t":2,"I":7,"\u00cd":7,"O":5,"\u00d3":5,"U":10,"\u00da":10,"\u201c":12,"\u2018":12,"\u2122":4,"*":9,"}":6,"\\":21,"]":5,"?":6}},"`":{"d":"28,-262v20,33,46,58,67,66v-33,17,-39,2,-88,-25v0,-13,11,-35,21,-41","w":102},">":{"d":"204,-109v-10,-27,-66,-71,-102,-81v1,-4,8,-8,12,-8v42,12,72,36,100,63v10,10,22,28,22,47v1,27,-47,14,-72,14v-35,0,-57,5,-106,19v-20,-26,-16,-49,24,-50v32,-1,97,-4,122,-4","w":224},"h":{"d":"35,-6v4,-93,63,-235,121,-293v15,0,37,8,45,17v-62,64,-97,122,-121,207v46,-58,81,-88,103,-88v13,0,28,8,39,22v-30,32,-67,100,-67,119v0,5,1,6,6,6v11,-3,14,-3,15,3v0,4,-27,17,-35,17v-10,0,-20,-12,-20,-23v0,-13,23,-63,40,-108v-45,26,-82,80,-108,137v-1,3,-5,7,-7,7v-3,0,-11,-15,-11,-23","w":186,"k":{"X":15,"W":17,"V":19,"S":4,"R":14,"Q":3,"P":14,"N":5,"M":3,"L":6,"K":6,"H":3,"G":3,"F":8,"C":3,"B":13,"D":14,"T":40,"Y":39,"\"":7,"'":7,"\u201d":8,"\u2019":8,"E":6,"\u00c9":6,"I":7,"\u00cd":7,"O":3,"\u00d3":3,"U":8,"\u00da":8,"\u201c":9,"\u2018":9,"g":1,"\u2122":5,"*":8,"}":6,")":6,"\\":13,"]":13,"?":5}},"-":{"d":"73,-67v-19,1,-28,-17,-22,-35v38,6,116,-5,126,-5v9,0,17,11,20,32v-46,-7,-89,8,-124,8","w":189,"k":{"7":10,"9":4,"D":4,"T":21,"Y":31,"s":8,"\"":10,"'":10,"V":11,"W":9,"\u201d":13,"\u2019":13,"X":9,"f":9,"z":9,"E":3,"\u00c9":3,"F":3,"t":5,"v":3,"x":8}},"i":{"d":"115,-126v-29,35,-43,82,-53,132v-4,0,-27,-9,-27,-30v5,-21,9,-106,47,-126v8,2,24,10,33,24xm115,-171v-15,-2,-10,-16,-14,-28v0,-8,5,-32,11,-47v11,0,37,14,44,25v-11,10,-37,42,-41,50","w":84,"k":{"W":2,"R":-16,"P":-15,"N":3,"M":3,"L":3,"K":3,"F":3,"B":-13,"D":-13,"Y":3,"f":3,"E":3,"\u00c9":3,"t":3,"I":3,"\u00cd":3,"U":2,"\u00da":2,"*":-3}},"\u00ed":{"d":"113,-122v-29,36,-42,82,-51,133v-3,0,-27,-9,-27,-31v5,-22,7,-105,44,-125v8,1,25,9,34,23xm158,-245v10,6,21,28,21,41v-49,28,-54,43,-88,26v21,-8,47,-34,67,-67","w":86,"k":{"&":-11,"'":-18,"\u2019":-22,"\u2018":-20,"\u201d":-26,"\u201c":-21,"\"":-18,"?":-24,"l":-10,"k":-4,"j":-3,"h":-9,"!":-6,"}":-8,"|":-12,"b":-17,"*":-3,"D":-13,"Y":3,"f":3,"E":3,"\u00c9":3,"t":3,"I":3,"\u00cd":3,"U":2,"\u00da":2}},"j":{"d":"43,-67v18,-71,34,-103,53,-103v7,0,15,4,24,10v-38,60,-57,168,-75,212v-23,56,-40,78,-69,78v-21,0,-43,-9,-51,-21v6,-16,21,11,35,5v31,0,44,-28,83,-181xm112,-188v-8,-3,-12,-7,-9,-16v-12,-15,1,-39,6,-60v11,0,37,15,44,26v-12,10,-38,42,-41,50","w":84,"k":{"R":-12,"V":2,"W":3,"j":-17,"X":-3,"E":3,"\u00c9":3,"C":4,"G":4,"I":5,"\u00cd":5,"O":4,"\u00d3":4,"S":2,"U":4,"\u00da":4,"H":3,"K":5,"L":5,"N":4,"\u00d1":4,"M":3,"B":-10,"P":-12,"Q":4}},"k":{"d":"170,-149v-32,-12,-112,96,-104,164v-15,0,-16,-13,-23,-17v-4,-3,-7,-15,-7,-32v0,-52,88,-241,124,-266v13,1,34,24,34,37v-43,35,-91,112,-114,183v31,-53,68,-87,97,-88v39,30,-3,94,-40,101v10,33,30,72,63,91v-4,10,-21,20,-37,20v-34,-8,-44,-70,-53,-116v18,-10,65,-55,60,-77","w":185,"k":{",":-2,"@":5,"Z":-9,"X":3,"W":27,"V":31,"S":17,"R":19,"P":19,"N":6,"L":5,"K":5,"H":5,"G":16,"F":14,"C":16,"B":20,"D":23,"T":45,"Y":47,"a":8,"\u00e1":8,"\"":8,"'":8,"c":10,"e":9,"\u00e9":9,"o":9,"\u00f3":9,"u":7,"\u00fa":7,"w":8,"y":7,"\u201d":8,"\u2019":8,"j":-5,"f":10,"z":2,"E":14,"\u00c9":14,"t":12,"v":9,"I":12,"\u00cd":12,"O":14,"\u00d3":14,"U":16,"\u00da":16,"b":9,"\u2014":6,"\u2013":6,"-":6,"q":9,"\u201c":8,"\u2018":8,"d":6,"h":5,"i":7,"\u00ed":7,"k":6,"l":4,"n":3,"\u00f1":3,"r":5,"g":10,"m":6,"\u2122":7,"\/":-9,"*":8,"}":-3,"p":-10,")":-34,"\\":16,"]":-18,"&":5,"!":-3}},"l":{"d":"184,-276v-56,62,-116,199,-119,302v-14,-2,-14,-12,-23,-17v-17,-43,-2,-76,21,-143v28,-82,56,-135,81,-165v12,2,36,17,40,23","w":84,"k":{"Z":-4,"X":-6,"W":-4,"V":-11,"R":-15,"Q":4,"P":-15,"N":4,"M":4,"L":3,"K":3,"H":2,"G":5,"F":-5,"C":4,"B":-13,"A":3,"\u00c1":3,"D":-5,"T":-13,"Y":-15,"a":1,"\u00e1":1,"\"":-15,"'":-15,"c":2,"e":1,"\u00e9":1,"o":1,"\u00f3":1,"w":2,"\u201d":-12,"\u2019":-12,"E":-3,"\u00c9":-3,"v":2,"I":6,"\u00cd":6,"O":4,"\u00d3":4,"U":3,"\u00da":3,"b":1,"q":2,"\u201c":-4,"\u2018":-4,"d":1,"g":2,"\u2122":-8,"*":-18,"}":-14,")":-4,"\\":-8,"]":-26}},"<":{"d":"192,-69v-56,11,-116,29,-151,-17v4,-13,30,-32,48,-48v27,-24,41,-44,69,-88v30,2,48,19,39,45v-2,-1,-3,-2,-5,-2v-14,0,-81,71,-107,95v13,13,87,7,110,1v2,4,-1,11,-3,14","w":185},"m":{"d":"163,-122v-22,-3,-97,109,-114,131v-25,-19,-19,-46,-9,-81v11,-35,31,-71,47,-99v13,3,23,8,35,20v-9,30,-46,67,-51,107v27,-39,77,-108,108,-108v12,0,28,9,29,12v-5,19,-42,73,-45,93v47,-64,83,-107,110,-107v10,0,20,5,23,15v-9,28,-45,86,-45,120v0,25,25,-1,24,16v-21,24,-61,15,-61,-23v0,-33,20,-65,29,-85v-23,2,-80,92,-103,120v-10,-4,-19,-14,-22,-26v5,-30,15,-63,45,-105","w":275,"k":{"\\":22,"\u2122":3,"v":2,"?":4,"q":1,"]":7,"}":6,"b":1,"*":9,"X":5,"W":18,"V":22,"S":9,"R":12,"Q":4,"P":13,"N":4,"L":3,"K":3,"G":8,"F":9,"C":8,"B":12,"D":15,"T":44,"Y":51,"\"":7,"'":7,"c":1,"\u201d":13,"\u2019":13,"f":2,"E":9,"\u00c9":9,"t":3,"I":6,"\u00cd":6,"O":6,"\u00d3":6,"U":9,"\u00da":9,"\u201c":15,"\u2018":15}},"n":{"d":"155,-99v-39,18,-82,86,-111,117v-35,-29,-10,-69,10,-123v16,-43,35,-68,39,-70v13,4,25,19,30,35v-11,26,-48,77,-51,99v39,-41,71,-96,123,-110v12,0,21,11,26,20v-22,14,-46,68,-48,103v-3,29,25,-1,27,17v-21,24,-65,17,-65,-23v0,-12,3,-27,20,-65","w":194,"k":{"W":16,"V":20,"S":4,"R":10,"P":11,"G":4,"F":5,"C":4,"B":9,"D":13,"T":39,"Y":46,"\"":4,"'":4,"\u201d":9,"\u2019":9,"E":4,"\u00c9":4,"I":4,"\u00cd":4,"O":3,"\u00d3":3,"U":6,"\u00da":6,"\u201c":13,"\u2018":13,"*":5,"\\":18,"]":5}},"9":{"d":"83,22v-13,-4,-40,-19,-43,-29v33,-4,104,-62,137,-124v-21,22,-52,46,-74,47v-20,-11,-41,-38,-41,-60v0,-44,79,-118,119,-118v37,8,62,31,62,64v0,58,-91,197,-160,220xm105,-104v59,-14,147,-108,70,-144v-40,26,-101,93,-70,144","w":199,"k":{"\\":4,"\/":14,")":9,"]":10,"Z":4,"Y":12,"T":5,"J":4,",":4,"\u2026":4,".":4}},"\u00f1":{"d":"155,-99v-39,18,-82,86,-111,117v-35,-29,-10,-69,10,-123v16,-43,35,-68,39,-70v13,4,25,19,30,35v-11,26,-48,77,-51,99v39,-41,71,-96,123,-110v12,0,21,11,26,20v-22,14,-46,68,-48,103v-3,29,25,-1,27,17v-21,24,-65,17,-65,-23v0,-12,3,-27,20,-65xm113,-217v36,12,58,6,95,-11v6,6,10,23,12,33v-41,18,-100,12,-107,-22","w":194,"k":{"D":13,"T":39,"Y":46,"\"":4,"'":4,"\u201d":9,"\u2019":9,"E":4,"\u00c9":4,"I":4,"\u00cd":4,"O":3,"\u00d3":3,"U":6,"\u00da":6,"\u201c":13,"\u2018":13,"*":5,"\\":18,"]":5}},"o":{"d":"77,13v-92,-26,-25,-180,51,-183v8,4,16,12,23,25v19,-2,24,8,25,34v0,60,-41,112,-99,124xm145,-138v-43,11,-75,69,-78,110v0,12,4,25,9,26v48,-8,87,-76,69,-136","w":158,"k":{"Z":3,"X":16,"W":19,"V":23,"S":4,"R":15,"Q":5,"P":15,"N":5,"M":2,"L":8,"K":6,"H":5,"G":5,"F":12,"C":6,"B":14,"D":17,"T":44,"Y":56,"\"":8,"'":8,"\u201d":9,"\u2019":9,"f":5,"z":3,"E":13,"\u00c9":13,"t":4,"v":3,"x":5,"I":8,"\u00cd":8,"O":5,"\u00d3":5,"U":10,"\u00da":10,"\u201c":13,"\u2018":13,"\u2122":6,"*":10,"}":8,")":6,"\\":23,"]":14,"?":6}},"\u00f3":{"d":"77,13v-92,-26,-25,-180,51,-183v8,4,16,12,23,25v19,-2,24,8,25,34v0,60,-41,112,-99,124xm145,-138v-43,11,-75,69,-78,110v0,12,4,25,9,26v48,-8,87,-76,69,-136xm209,-258v10,6,21,28,21,41v-49,28,-55,41,-89,25v21,-8,48,-33,68,-66","w":158,"k":{"\u2019":9,"\u2018":13,"?":6,"*":10,"D":17,"T":44,"Y":56,"\"":8,"'":8,"\u201d":9,"f":5,"z":3,"E":13,"\u00c9":13,"t":4,"v":3,"x":5,"I":8,"\u00cd":8,"O":5,"\u00d3":5,"U":10,"\u00da":10,"\u201c":13,"\u2122":6,"}":8,")":6,"\\":23,"]":14}},"1":{"d":"73,-175v23,-34,53,-51,76,-87v14,4,43,8,49,20v-39,41,-59,135,-89,218v31,-7,59,1,49,32v-49,-12,-122,29,-146,-13v4,-4,31,-9,60,-14v14,-58,34,-124,53,-179v-16,8,-36,22,-48,33v-3,-1,-4,-5,-4,-10","w":157,"k":{"\\":5,")":-7,"1":-4,"-":7,"4":6,"Z":-10,"Y":11,"W":7,"V":5,"U":4,"T":4,"J":-9,"G":4,"C":4}},"p":{"d":"23,132v-16,-10,-23,-22,-23,-50v0,-35,72,-219,77,-236v3,-11,17,-35,26,-43v17,3,34,9,37,15v-14,13,-35,57,-42,82v7,-13,53,-62,72,-62v18,0,31,11,31,27v4,61,-47,133,-98,138v-9,0,-16,-5,-18,-10v37,-22,73,-82,85,-144v-38,17,-85,84,-94,107v-13,32,-36,105,-53,176","w":179,"k":{"\\":21,"\u2122":5,"x":4,"v":1,"?":6,")":5,"]":12,"}":7,"*":9,"Z":3,"X":20,"W":16,"V":20,"S":3,"R":15,"Q":5,"P":15,"N":4,"M":3,"L":6,"K":5,"H":4,"G":4,"F":10,"C":5,"B":11,"D":15,"T":45,"Y":53,"s":2,"\"":8,"'":8,"\u201d":10,"\u2019":10,"f":2,"z":2,"E":10,"\u00c9":10,"t":2,"I":5,"\u00cd":5,"O":5,"\u00d3":5,"U":8,"\u00da":8,"\u201c":13,"\u2018":13}},"(":{"d":"91,47r-5,5v-22,-26,-36,-59,-36,-116v0,-117,63,-211,125,-243v14,5,32,32,33,38v-106,21,-159,195,-117,316","w":114,"k":{"0":9,"v":6,"3":-2,"6":10,"7":-9,"q":6,"1":4,"9":7,"m":6,"4":9,"5":4,"X":-8,"V":-13,"Q":4,"P":-13,"M":6,"F":-9,"B":-11,"A":9,"\u00c1":9,"D":-3,"R":-13,"T":-15,"Y":-17,"a":6,"\u00e1":6,"s":4,"c":6,"e":6,"\u00e9":6,"o":6,"\u00f3":6,"u":6,"\u00fa":6,"w":6,"y":6,"W":-7,"E":-7,"\u00c9":-7,"C":7,"G":8,"I":4,"\u00cd":4,"O":6,"\u00d3":6,"d":-5,"n":6,"\u00f1":6,"r":5,"g":6,"Z":-7}},")":{"d":"102,-284r4,-5v22,26,37,59,37,116v0,117,-63,211,-125,243v-14,-5,-32,-32,-33,-38v106,-21,159,-195,117,-316","w":115,"k":{"]":7,"}":4}},".":{"d":"83,-22v-15,29,-42,50,-58,22v0,-12,8,-39,10,-48v11,0,39,12,48,26","w":86,"k":{"\u201d":35,"\u201c":41,"\"":34,"D":6,"T":22,"Y":31,"'":34,"c":6,"V":21,"W":18,"\u2019":35,"f":9,"t":7,"v":6,"C":9,"G":9,"I":4,"\u00cd":4,"O":7,"\u00d3":7,"S":3,"U":8,"\u00da":8,"b":5,"4":25,"\u2014":7,"\u2013":7,"-":7,"9":4,"q":5,"\u2018":41,"7":20,"0":8}},"+":{"d":"116,-14v-9,-1,-20,-8,-30,-17v4,-14,7,-28,11,-41v-29,5,-64,-3,-50,-33r61,1v11,-30,23,-55,34,-69v12,2,39,17,43,23v-11,12,-20,25,-29,42v41,-4,50,-11,60,29v-31,-4,-50,-2,-76,2v-9,20,-17,41,-24,63","w":200,"k":{"7":8}},"q":{"d":"33,-53v0,-52,49,-123,103,-123v14,0,29,14,31,25v6,-13,26,-9,33,1v-59,118,-84,171,-107,281v-2,2,-13,1,-13,-2v-2,-7,-15,-8,-15,-16v0,-42,15,-90,38,-143v-17,17,-30,28,-36,28v-13,0,-34,-32,-34,-51xm163,-146v-55,-17,-98,85,-97,124v0,1,1,3,3,3v33,-13,95,-123,94,-127","w":162,"k":{"\\":17,"?":5,"]":7,"}":5,"*":7,"Z":4,"X":19,"W":16,"V":17,"S":5,"R":14,"Q":3,"P":15,"N":5,"M":4,"L":6,"K":6,"J":3,"H":3,"G":3,"F":9,"C":3,"B":13,"D":12,"T":45,"Y":41,"\"":5,"'":5,"\u201d":10,"\u2019":10,"j":-18,"E":8,"\u00c9":8,"I":7,"\u00cd":7,"O":3,"\u00d3":3,"U":7,"\u00da":7,"\u201c":13,"\u2018":13}},"?":{"d":"221,-210v14,52,-113,107,-106,174v-16,-1,-38,-15,-44,-28v0,-22,20,-66,67,-94v38,-22,56,-44,56,-61v0,-15,-13,-30,-26,-30v-16,1,-43,34,-37,59v-20,4,-47,-6,-51,-16v7,-32,43,-74,69,-74v37,0,72,34,72,70xm69,28v-7,0,-22,-7,-22,-21v0,-9,5,-36,19,-36v9,0,27,11,33,23v-11,12,-16,34,-30,34","w":172},"\"":{"d":"88,-183v-15,-20,6,-45,6,-79v0,-12,-1,-24,-4,-38v23,1,44,11,50,23v-8,43,-24,76,-52,94xm153,-183v-15,-20,6,-45,6,-79v0,-12,-1,-24,-4,-38v23,1,44,11,50,23v-8,43,-24,76,-52,94","w":132,"k":{"A":12,"\u00c1":12,"D":-7,"J":21,"R":-16,"T":-2,"Y":-5,"a":5,"\u00e1":5,"s":4,"c":3,"e":4,"\u00e9":4,"o":4,"\u00f3":4,"w":3,"X":-5,",":31,"\u2026":31,".":31,"q":3,"7":-2,"M":5,"B":-13,"P":-15,"g":4,"\u2122":-5,"\/":24}},"\u201c":{"d":"227,-300v3,3,6,9,6,14v-35,29,-40,52,-29,96v-24,-1,-48,-13,-51,-25v11,-40,35,-68,74,-85xm155,-300v3,3,6,9,6,14v-35,29,-40,52,-29,96v-24,-1,-48,-13,-51,-25v11,-40,35,-68,74,-85","w":152,"k":{"A":9,"\u00c1":9,"D":-8,"J":22,"R":-2,"a":4,"\u00e1":4,"s":3,"o":3,"\u00f3":3,"w":5,"v":4,",":28,"\u2026":28,".":28,"M":3}},"\u201d":{"d":"82,-190v-3,-3,-6,-8,-6,-13v34,-30,38,-53,29,-97v24,1,48,14,51,26v-11,40,-35,67,-74,84xm154,-190v-3,-3,-6,-8,-6,-13v34,-30,38,-53,29,-97v24,1,48,14,51,26v-11,40,-35,67,-74,84","w":148,"k":{"T":-5,"A":13,"\u00c1":13,"D":-7,"J":20,"R":-17,"Y":-11,"a":10,"\u00e1":10,"s":6,"c":5,"e":7,"\u00e9":7,"o":7,"\u00f3":7,"u":5,"\u00fa":5,"w":10,"y":5,"X":-6,"v":8,",":34,"\u2026":34,".":34,"q":6,"n":4,"\u00f1":4,"r":3,"M":6,"B":-14,"P":-16,"g":6,"m":4}},"\u2018":{"d":"142,-300v3,3,6,9,6,14v-17,28,-19,58,-15,97v-24,-1,-48,-14,-51,-26v9,-40,29,-68,60,-85","w":81,"k":{"A":9,"\u00c1":9,"D":-8,"J":22,"R":-2,"a":4,"\u00e1":4,"s":3,"o":3,"\u00f3":3,"w":5,"v":4,",":28,"\u2026":28,".":28,"M":3}},"\u2019":{"d":"86,-189v-3,-3,-5,-9,-5,-14v17,-28,20,-59,14,-97v24,1,49,14,52,26v-9,40,-30,68,-61,85","w":70,"k":{"\/":24,"\u2122":-8,"*":-2,"A":13,"\u00c1":13,"D":-7,"J":20,"R":-17,"T":-5,"Y":-11,"a":10,"\u00e1":10,"s":6,"c":5,"e":7,"\u00e9":7,"o":7,"\u00f3":7,"u":5,"\u00fa":5,"w":10,"y":5,"X":-6,"v":8,",":34,"\u2026":34,".":34,"q":6,"n":4,"\u00f1":4,"r":3,"M":6,"B":-14,"P":-16,"g":6,"m":4}},"'":{"d":"88,-183v-15,-20,6,-45,6,-79v0,-12,-1,-24,-4,-38v23,1,44,11,50,23v-8,43,-24,76,-52,94","w":67,"k":{"A":12,"\u00c1":12,"D":-7,"J":21,"R":-16,"T":-2,"Y":-5,"a":5,"\u00e1":5,"s":4,"c":3,"e":4,"\u00e9":4,"o":4,"\u00f3":4,"w":3,"X":-5,",":31,"\u2026":31,".":31,"q":3,"7":-2,"M":5,"B":-13,"P":-15,"g":4,"\u2122":-5,"\/":24}},"r":{"d":"26,-7v8,-35,32,-132,60,-166v13,2,30,10,36,17v-13,15,-22,34,-32,65v26,-23,45,-43,62,-69v6,-4,22,-1,24,4v-7,18,-10,43,-2,58v0,3,-8,13,-15,20v-13,-6,-23,-19,-28,-33v-45,31,-61,57,-75,123v-9,-1,-27,-12,-30,-19","w":145,"k":{"Z":5,"X":25,"W":16,"V":17,"S":2,"R":16,"Q":2,"P":16,"N":3,"M":3,"L":7,"K":5,"J":21,"H":3,"F":9,"B":16,"D":11,"T":33,"Y":35,"s":6,"\"":5,"'":5,"\u201d":8,"\u2019":8,"E":8,"\u00c9":8,"x":1,",":12,"\u2026":12,".":12,"I":4,"\u00cd":4,"U":5,"\u00da":5,"\u201c":12,"\u2018":12,"\/":4,"*":6,"}":7,")":9,"\\":18,"]":16,"?":4}},"s":{"d":"159,-143v-1,19,-14,53,-24,36v3,-6,12,-32,-3,-32v-20,-2,-30,31,-29,76v10,1,30,-6,24,6v-30,8,-24,4,-24,25v0,57,-74,95,-96,41v0,-37,32,-67,74,-70v0,-24,-11,-46,-11,-66v0,-26,23,-53,48,-58v11,3,38,31,41,42xm40,21v23,-9,43,-38,43,-63v-21,6,-66,41,-43,63","w":124,"k":{"Z":3,"X":16,"W":16,"V":19,"S":3,"R":16,"Q":3,"P":16,"N":4,"M":2,"L":6,"K":5,"G":3,"F":6,"C":3,"B":16,"D":8,"T":42,"Y":42,"\"":5,"'":5,"\u201d":8,"\u2019":8,"E":5,"\u00c9":5,"I":5,"\u00cd":5,"O":3,"\u00d3":3,"U":6,"\u00da":6,"\u201c":10,"\u2018":10,"\u2122":4,"*":8,"}":6,")":4,"\\":18,"]":10,"?":5}},";":{"d":"14,61v-3,-3,-6,-9,-6,-14v35,-29,40,-52,29,-96v24,1,49,13,52,25v-11,40,-36,68,-75,85xm124,-136v-15,29,-42,48,-58,21v0,-12,8,-39,10,-48v11,0,39,13,48,27","w":102,"k":{"T":21,"Y":26,"V":10,"W":9,"\u201d":4,"\u2019":4}},"7":{"d":"87,-131v16,-3,32,-4,48,-2v18,-30,40,-61,64,-89v-35,-14,-78,-17,-90,16v-18,-3,-32,-15,-36,-31v25,-49,96,-19,137,2v5,-5,10,-11,15,-16v13,5,24,18,28,31v-29,15,-56,51,-78,94v22,7,40,19,48,33r-3,3v-12,-6,-31,-12,-54,-15v-20,45,-33,93,-33,130v-22,-4,-41,-15,-47,-25v1,-27,14,-67,36,-109v-18,-1,-38,3,-49,2v0,-6,8,-21,14,-24","w":200,"k":{"\/":9,")":6,"]":7,"Y":10,"R":-8,"P":-8,"D":-5}},"6":{"d":"198,-264v10,0,38,16,48,30v-34,5,-110,56,-144,119v23,-24,53,-45,77,-46v20,11,42,34,42,56v0,44,-77,122,-118,122v-37,-8,-64,-29,-64,-62v0,-83,90,-196,159,-219xm178,-144v-59,19,-100,67,-100,107v0,14,10,33,23,37v38,-18,89,-81,89,-118v0,-10,-3,-20,-12,-26","w":203,"k":{"\\":5,"\/":9,")":8,"]":8,"}":5,"Y":11,"W":4,"V":4,"T":4,"R":-5,"P":-4,"B":-4}},"t":{"d":"77,-138r-21,0v-2,-3,-5,-15,-5,-21v13,1,24,2,34,2v14,-28,36,-60,44,-64v10,0,32,8,37,13v-14,18,-23,32,-35,52v12,2,34,-7,33,9v-12,4,-26,7,-43,7v-24,46,-38,93,-38,123v1,31,38,11,50,2v7,14,-30,29,-37,32v-24,-1,-51,-22,-51,-39v0,-23,14,-72,32,-116","w":126,"k":{"X":3,"W":15,"V":16,"S":6,"R":5,"Q":3,"P":5,"N":2,"L":2,"G":4,"F":6,"C":4,"B":7,"T":35,"Y":30,"c":3,"E":5,"\u00c9":5,"I":5,"\u00cd":5,"O":4,"\u00d3":4,"U":7,"\u00da":7,"\u2014":9,"\u2013":9,"-":9,"q":3,"g":2,"\\":10,"]":8}},"3":{"d":"84,-238v14,-10,53,-19,76,-19v87,0,56,89,5,123v32,4,45,19,45,45v0,73,-89,102,-151,102v-19,0,-30,-23,-26,-46v58,12,146,-13,149,-62v0,-16,-10,-27,-32,-30v-29,16,-52,22,-55,-17v44,0,102,-18,104,-77v-3,-10,-12,-13,-25,-13v-23,0,-56,15,-75,34v-11,-7,-18,-23,-15,-40","w":199,"k":{"\\":13,"\/":7,"7":7,")":9,"]":12,"}":6,"Y":19,"W":8,"V":9,"T":12,"\"":6,"'":6}},"2":{"d":"203,-18v-2,49,-115,9,-146,39v-12,-5,-22,-16,-26,-28v6,-28,28,-45,78,-86v56,-46,90,-80,90,-117v0,-23,-13,-37,-32,-37v-37,0,-74,57,-44,91v-27,5,-48,-12,-48,-37v0,-36,46,-68,91,-68v40,0,66,24,66,60v0,60,-119,131,-147,189v38,-2,79,-18,106,-42v4,5,12,22,12,36","w":203,"k":{"\\":9,"\/":4,"7":4,"1":-4,"-":4,"]":8,"Z":-2,"Y":15,"W":6,"V":6,"T":8,"J":-3}},"u":{"d":"168,5v-18,4,-60,-25,-45,-55v-9,4,-36,53,-53,57v-15,-1,-35,-11,-39,-28v0,-62,33,-116,67,-150v8,0,25,4,32,12v-2,2,-70,101,-58,145v16,-11,58,-66,72,-98v4,-12,12,-33,28,-48v13,0,30,6,34,11v-22,51,-59,102,-38,154","w":177,"k":{"X":11,"W":17,"V":21,"S":9,"R":13,"Q":4,"P":14,"N":5,"M":2,"L":6,"K":6,"H":4,"G":6,"F":10,"C":7,"B":13,"D":15,"T":46,"Y":48,"a":2,"\u00e1":2,"\"":6,"'":6,"c":2,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":1,"\u00fa":1,"w":2,"y":1,"\u201d":10,"\u2019":10,"E":10,"\u00c9":10,"t":1,"v":2,"I":6,"\u00cd":6,"O":6,"\u00d3":6,"U":8,"\u00da":8,"b":1,"q":2,"\u201c":14,"\u2018":14,"d":1,"i":2,"\u00ed":2,"g":2,"m":1,"\u2122":3,"*":8,"}":7,"\\":20,"]":9,"?":6}},"\u00fa":{"d":"168,5v-18,4,-60,-25,-45,-55v-9,4,-36,53,-53,57v-15,-1,-35,-11,-39,-28v0,-62,33,-116,67,-150v8,0,25,4,32,12v-2,2,-70,101,-58,145v16,-11,58,-66,72,-98v4,-12,12,-33,28,-48v13,0,30,6,34,11v-22,51,-59,102,-38,154xm204,-262v10,6,21,28,21,41v-49,28,-54,41,-88,25v21,-8,47,-33,67,-66","w":177,"k":{"D":15,"T":46,"Y":48,"a":2,"\u00e1":2,"\"":6,"'":6,"c":2,"e":2,"\u00e9":2,"o":2,"\u00f3":2,"u":1,"\u00fa":1,"w":2,"y":1,"\u201d":10,"\u2019":10,"E":10,"\u00c9":10,"t":1,"v":2,"I":6,"\u00cd":6,"O":6,"\u00d3":6,"U":8,"\u00da":8,"b":1,"q":2,"\u201c":14,"\u2018":14,"d":1,"i":2,"\u00ed":2,"g":2,"m":1,"\u2122":3,"*":8,"}":7,"\\":20,"]":9,"?":6}},"_":{"d":"45,37v-22,0,-35,-14,-28,-35v47,7,143,-6,156,-6v11,0,21,11,25,32v-59,-5,-110,8,-153,9","w":204},"v":{"d":"87,-15v34,-32,76,-91,92,-157v6,0,20,5,23,8v-17,81,-78,140,-139,181v-42,-26,-7,-26,-7,-102v0,-37,-13,-71,25,-73v7,0,16,1,20,5v-7,34,-5,105,-14,138","w":161,"k":{"\\":14,"\/":8,"?":5,")":9,"]":16,"}":6,"*":5,"Z":7,"X":24,"W":15,"V":15,"S":4,"R":15,"Q":3,"P":16,"N":5,"M":6,"L":8,"K":8,"J":16,"H":2,"F":7,"B":15,"D":4,"T":45,"Y":37,"s":3,"\u201d":4,"\u2019":4,"E":6,"\u00c9":6,",":6,"\u2026":6,".":6,"I":5,"\u00cd":5,"O":2,"\u00d3":2,"U":5,"\u00da":5,"\u201c":8,"\u2018":8}},"w":{"d":"135,-83v-27,21,-56,69,-76,97v-15,-5,-21,-15,-21,-29v0,-39,15,-182,83,-134v-28,23,-31,72,-36,108v22,-35,50,-52,63,-82v4,-9,4,-31,22,-31v9,0,23,1,24,7v-15,20,-27,94,-33,129v25,-25,73,-80,76,-145v4,-5,23,-10,30,-5v-5,53,-25,81,-69,129v-18,19,-45,49,-55,49v-37,-3,-9,-74,-8,-93","w":228,"k":{"Z":6,"X":22,"W":14,"V":15,"S":3,"R":13,"Q":2,"P":13,"N":4,"M":4,"L":6,"K":6,"J":15,"H":2,"F":6,"B":12,"D":3,"T":44,"Y":35,"s":3,"\u201d":3,"\u2019":3,"E":5,"\u00c9":5,",":5,"\u2026":5,".":5,"I":5,"\u00cd":5,"O":2,"\u00d3":2,"U":4,"\u00da":4,"\u201c":7,"\u2018":7,"\/":5,"*":4,"}":6,")":9,"\\":14,"]":16,"?":4}},"x":{"d":"147,-2v-5,8,-19,13,-29,14v-8,-9,-19,-26,-28,-48v-24,22,-50,41,-71,53v-5,-1,-9,-6,-9,-14v19,-10,56,-36,74,-57v-16,-38,-29,-85,-29,-104v0,-20,33,-3,47,-1v-3,27,1,48,9,75v20,-23,36,-48,53,-87v12,2,22,8,24,13v-5,22,-31,57,-69,95v6,18,16,39,28,61","w":153,"k":{"\\":17,"?":5,"q":3,"m":1,"]":9,"}":6,"*":6,"X":12,"W":19,"V":21,"S":7,"R":15,"Q":4,"P":15,"N":6,"M":2,"L":6,"K":6,"H":4,"G":6,"F":12,"C":6,"B":14,"D":8,"T":45,"Y":40,"a":3,"\u00e1":3,"\"":4,"'":4,"c":3,"e":3,"\u00e9":3,"o":3,"\u00f3":3,"u":2,"\u00fa":2,"w":2,"y":2,"\u201d":5,"\u2019":5,"E":9,"\u00c9":9,"I":8,"\u00cd":8,"O":6,"\u00d3":6,"U":10,"\u00da":10,"\u2014":4,"\u2013":4,"-":4,"\u201c":9,"\u2018":9,"d":2,"i":2,"\u00ed":2,"k":1,"g":3}},"y":{"d":"208,-149v-53,103,-64,279,-185,279v-24,0,-67,-14,-52,-32v11,10,15,11,26,11v55,0,106,-66,133,-170v-12,19,-39,60,-61,68v-15,-1,-35,-11,-39,-28v2,-61,33,-116,68,-150v8,0,24,4,32,12v-6,2,-59,94,-62,139v0,4,2,5,3,6v41,-18,75,-100,103,-146v13,0,30,6,34,11","w":176,"k":{"Z":3,"X":14,"W":17,"V":21,"S":5,"R":14,"Q":4,"P":14,"N":4,"M":3,"L":5,"K":5,"H":4,"G":4,"F":9,"C":4,"B":11,"D":15,"T":45,"Y":45,"\"":6,"'":6,"\u201d":11,"\u2019":11,"E":9,"\u00c9":9,"I":6,"\u00cd":6,"O":4,"\u00d3":4,"U":9,"\u00da":9,"\u201c":14,"\u2018":14,"*":8,"}":5,"\\":18,"]":5,"?":5}},"z":{"d":"22,-5v0,-16,58,-72,121,-117v-38,-8,-50,-12,-74,6v-13,-12,-17,-21,-16,-40v35,-37,88,21,125,4v4,3,9,16,9,25v-30,12,-89,61,-116,99v25,10,65,-1,81,-15v13,9,19,22,16,40v-39,34,-108,-27,-135,15v-6,-3,-11,-9,-11,-17","k":{"X":6,"W":27,"V":31,"S":9,"R":17,"Q":4,"P":18,"N":5,"M":2,"L":4,"K":4,"H":3,"G":11,"F":11,"C":11,"B":17,"A":3,"\u00c1":3,"D":22,"T":43,"Y":53,"a":2,"\u00e1":2,"\"":8,"'":8,"c":5,"e":3,"\u00e9":3,"o":3,"\u00f3":3,"u":1,"\u00fa":1,"w":3,"y":1,"\u201d":14,"\u2019":14,"f":4,"E":9,"\u00c9":9,"t":5,"v":4,"I":12,"\u00cd":12,"O":10,"\u00d3":10,"U":14,"\u00da":14,"b":3,"\u2014":5,"\u2013":5,"-":5,"q":4,"\u201c":17,"\u2018":17,"d":1,"h":1,"i":2,"\u00ed":2,"k":2,"l":1,"g":3,"m":1,"\u2122":4,"*":10,"}":7,"\\":24,"]":8,"?":5}},"0":{"d":"107,13v-36,0,-59,-27,-59,-78v0,-87,78,-200,159,-200v40,0,59,31,59,75v0,86,-64,203,-159,203xm93,-50v0,32,12,43,34,47v65,-4,110,-147,110,-197v0,-26,-5,-44,-19,-47v-66,8,-125,134,-125,197","w":232,"k":{"\\":7,"\/":11,")":10,"]":10,"}":4,"Z":4,"Y":14,"W":4,"V":4,"T":8}},"\u00d7":{"d":"137,-91v12,13,27,23,33,41v0,11,-10,23,-17,31v-13,-21,-26,-36,-39,-49v-15,16,-29,33,-43,50v-6,-3,-14,-10,-18,-19v13,-18,26,-35,39,-51v-21,-17,-57,-52,-11,-69v8,17,20,31,33,44v20,-22,38,-41,52,-51v9,5,26,21,27,28v-18,11,-37,27,-56,45","w":174},"\u2122":{"d":"123,-235v-14,3,-30,-1,-22,-16v21,12,65,-16,66,14r-24,-1v-13,25,-22,61,-24,77v-34,-12,-5,-25,4,-74xm201,-162v-8,0,-17,-2,-19,-6v0,-19,9,-45,14,-68v-11,15,-33,54,-35,75v-11,-3,-15,-5,-15,-9v0,-9,34,-72,50,-81v5,0,18,6,19,8v-3,6,-8,21,-11,36v16,-25,26,-57,51,-36v-12,21,-13,62,-13,81v-6,0,-18,-3,-20,-6v0,-18,4,-40,13,-69v-12,13,-31,53,-34,75","w":212,"k":{"f":-2,"P":-6,"M":3,"B":-3,"A":8,"\u00c1":8,"D":-3,"J":24,"R":-6,"z":-10,"t":-12}},"\/":{"d":"266,-267v-80,141,-181,272,-255,330v-5,-1,-13,-9,-15,-17v70,-42,205,-259,229,-334v12,0,38,13,41,21","w":196,"k":{"\/":81,"0":4,"6":5,"q":5,"p":4,"1":4,"9":4,"m":5,"Q":4,"P":-6,"M":8,"B":-4,"A":10,"\u00c1":10,"J":15,"R":-6,"T":-2,"Y":-2,"a":5,"\u00e1":5,"s":6,"c":4,"e":5,"\u00e9":5,"o":5,"\u00f3":5,"u":5,"\u00fa":5,"w":5,"y":5,"C":4,"G":4,"n":5,"\u00f1":5,"r":5,"g":5}},"\\":{"d":"95,-267v3,-8,30,-21,42,-21v21,139,60,284,80,328v-2,8,-10,16,-15,17v-31,-53,-72,-185,-107,-324","w":237,"k":{"0":14,"v":12,"2":8,"3":8,"6":11,"7":23,"\u2019":33,"q":11,"9":10,"m":8,"4":20,"5":7,"f":6,"8":10,"b":13,"V":24,"P":5,"F":8,"B":8,"D":12,"R":5,"T":26,"Y":33,"a":8,"\u00e1":8,"\"":33,"'":33,"c":13,"e":9,"\u00e9":9,"o":10,"\u00f3":10,"u":8,"\u00fa":8,"w":9,"y":8,"W":21,"z":5,"E":8,"\u00c9":8,"t":13,"C":14,"G":14,"I":9,"\u00cd":9,"O":12,"\u00d3":12,"S":11,"U":14,"\u00da":14,"H":5,"K":4,"L":4,"N":5,"\u00d1":5,"d":8,"h":7,"i":9,"\u00ed":9,"k":9,"l":8,"n":6,"\u00f1":6,"r":6,"g":9}},"#":{"d":"122,-125v-31,3,-62,3,-51,-28v17,3,38,2,60,1v14,-44,27,-90,39,-136v12,0,26,6,33,21v-14,40,-28,77,-42,114r32,-1v14,-43,26,-89,38,-134v12,0,26,6,33,21r-41,111v39,0,46,-13,52,24v-26,-3,-34,-2,-61,-1v-5,13,-10,25,-15,37v36,-1,43,-12,48,24v-25,-3,-32,-2,-57,0v-23,56,-45,102,-63,128v-5,-3,-9,-8,-10,-16v11,-20,28,-60,47,-111v-13,1,-25,2,-37,3v-22,54,-43,98,-61,124v-5,-3,-9,-8,-10,-16v10,-19,27,-57,45,-106v-34,4,-68,9,-58,-27v19,4,43,3,68,2v4,-11,7,-22,11,-34xm151,-128v-5,12,-9,24,-14,35v12,0,24,0,36,-1v4,-12,8,-24,12,-37v-12,1,-23,2,-34,3","w":243},"&":{"d":"229,-121v-23,4,-51,-2,-39,-29v44,12,94,-23,95,28v-20,-1,-27,-3,-41,-1v-33,54,-90,129,-144,147v-37,-4,-65,-29,-65,-62v0,-45,38,-91,74,-109v-18,-8,-25,-19,-25,-31v0,-35,55,-80,90,-86v10,1,39,25,41,35v-2,12,-14,29,-24,37v-12,-4,13,-20,8,-31v0,-5,-3,-6,-8,-6v-27,0,-70,47,-70,77v11,1,32,13,35,20v-47,11,-81,74,-81,111v0,17,8,29,23,29v39,0,100,-84,131,-129","w":240,"k":{"\u2019":12,"q":-3,"f":-5,"b":-2,"X":6,"V":4,"Q":-4,"A":-10,"\u00c1":-10,"T":15,"Y":20,"\"":11,"'":11,"c":-5,"o":-3,"\u00f3":-3,"u":-2,"\u00fa":-2,"y":-3,"j":-3,"z":-3,"G":-2,"H":-6,"d":-3,"i":-3,"\u00ed":-3,"r":-2,"g":-4,"Z":6}},"$":{"d":"224,-283r-10,30v16,5,32,13,47,22v4,24,-4,42,-19,50v-9,-15,-23,-26,-40,-33r-26,79v41,19,66,45,66,81v0,62,-61,94,-122,72v-8,17,-16,32,-23,45v-21,-10,0,-28,7,-51v-52,-25,-92,-63,-46,-113v-3,20,33,63,61,71v9,-26,18,-54,26,-84v-41,-23,-58,-44,-58,-72v0,-44,38,-78,96,-74v3,-15,5,-29,7,-40v10,3,27,8,34,17xm172,-18v88,0,48,-60,-6,-86r-29,81v13,4,24,5,35,5xm153,-224v-76,4,-46,51,2,76r19,-74v-7,-1,-15,-2,-21,-2","w":240,"k":{"7":5,"4":5}},"%":{"d":"203,-95v36,0,33,60,0,59v-34,0,-36,-57,0,-59xm110,-234v18,0,27,19,27,35v0,34,-55,31,-55,-4v0,-12,13,-31,28,-31xm266,-257v-73,108,-171,224,-220,271v-5,-1,-13,-9,-15,-17v56,-51,156,-187,200,-271v12,0,32,9,35,17","w":222},"\u00a0":{"w":85}}});
