/*
 * Decompiled with CFR 0.152.
 */
package com.mja.lang;

import com.mja.file.mjaFile;
import com.mja.gui.mjaColor;
import com.mja.lang.Expl;
import com.mja.lang.data;
import com.mja.util.BasicStr;
import java.applet.Applet;
import java.awt.Color;
import org.unam.matem.Attribute;

public class translator {
    private static boolean initialized = false;
    private static String idiomasPath = "resources/idiomas/";
    private static String indexPath = idiomasPath + "Tr__index.txt";
    private static String[][] newName;
    private int language;
    public static final int numColors = 13;
    public static String[][] colorName;
    public static final Color[] namedColor;

    public translator(Applet applet) {
        if (!initialized) {
            initialized = translator.initialize(applet);
        }
    }

    private static synchronized boolean initialize(Applet applet) {
        try {
            int n;
            int n2;
            int n3;
            String string = "";
            try {
                string = mjaFile.getResource(applet, indexPath);
            }
            catch (Exception exception) {
                System.out.println("No languages for translator");
            }
            String[] stringArray = BasicStr.toStringArray(string);
            data.numLang = 0;
            Expl.langs = new String[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                Expl.langs[n3] = stringArray[n3].substring(3, stringArray[n3].length() - 4);
                if (!BasicStr.hasContent(stringArray[n3].trim())) continue;
                ++data.numLang;
            }
            newName = new String[data.numLang][329];
            n3 = 329;
            int n4 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!BasicStr.hasContent(stringArray[n2].trim())) continue;
                n = 0;
                try {
                    String string2 = mjaFile.getResource(applet, idiomasPath + stringArray[n2]);
                    if (BasicStr.hasContent(string2)) {
                        String[] stringArray2 = BasicStr.toStringArray(string2);
                        for (n = 0; n < n3; ++n) {
                            int n5;
                            translator.newName[n4][n] = "";
                            if (n >= stringArray2.length || (n5 = stringArray2[n].indexOf(":")) <= 0 || n5 + 2 > stringArray2[n].length()) continue;
                            String string3 = stringArray2[n].substring(n5 + 2);
                            translator.newName[n4][n] = BasicStr.replace(string3, "\\n", "\n");
                        }
                    } else {
                        for (n = 0; n < n3; ++n) {
                            translator.newName[n4][n] = n4 > 0 ? newName[0][n] : "?";
                        }
                    }
                }
                catch (Exception exception) {
                    for (n = 0; n < n3; ++n) {
                        translator.newName[n4][n] = n4 > 0 ? newName[0][n] : "?";
                    }
                }
                ++n4;
            }
            if (colorName == null) {
                colorName = new String[data.numLang][13];
                for (n2 = 0; n2 < data.numLang; ++n2) {
                    for (n = 0; n < 13; ++n) {
                        translator.colorName[n2][n] = newName[n2][5 + n];
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void setActiveLanguage(int n) {
        this.language = n;
    }

    public int getActiveLanguage() {
        return this.language;
    }

    public String getTr(int n) {
        String string = newName[this.language][n];
        return string;
    }

    public String getTr(int n, int n2) {
        String string = newName[Math.min(n2, data.numLang - 1)][n];
        return string;
    }

    public int guessOriginalLanguageFromName(int n, String string) {
        for (int i = 0; i < newName.length; ++i) {
            if (!newName[i][n].equals(string)) continue;
            return i;
        }
        return this.language;
    }

    public String getLanguageName(int n) {
        return newName[n][0];
    }

    public String getColorName(int n) {
        return colorName[this.language][n];
    }

    public Attribute getParam(Applet applet, int n) {
        String string = applet.getParameter(newName[this.language][n]);
        if (!BasicStr.hasContent(string)) {
            string = "";
            for (int i = 0; i < data.numLang; ++i) {
                String string2 = applet.getParameter(newName[i][n]);
                if (!BasicStr.hasContent(string2)) continue;
                string = string2;
                break;
            }
        }
        return new Attribute(newName[this.language][n], string);
    }

    public int getLanguage(String string) {
        if (BasicStr.hasContent(string)) {
            for (int i = 0; i < data.numLang; ++i) {
                String string2 = newName[i][0];
                if (!BasicStr.equalsIgnoreAccents(string2, string)) continue;
                return i;
            }
        }
        return 1;
    }

    public String booleanName(boolean bl) {
        if (bl) {
            return newName[this.language][4];
        }
        return newName[this.language][3];
    }

    private static boolean equals(String string, String string2, int n) {
        for (int i = 0; i < data.numLang; ++i) {
            boolean bl = BasicStr.equalsIgnoreAccents(string, string2 + newName[i][n]);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String string, int n) {
        return translator.equals(string, "", n);
    }

    private static boolean equalsIgnoreCase(String string, String string2, int n) {
        for (int i = 0; i < data.numLang; ++i) {
            boolean bl = BasicStr.equalsIgnoreAccents(string.toLowerCase(), string2.toLowerCase() + newName[i][n].toLowerCase());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String string, int n) {
        return translator.equalsIgnoreCase(string, "", n);
    }

    public static boolean isTrue(String string) {
        return translator.isTrue(string, false);
    }

    public static boolean isTrue(String string, boolean bl) {
        if (BasicStr.hasContent(string)) {
            return translator.equals(string, 2) || translator.equals(string, 4) || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("s") || string.equalsIgnoreCase("t");
        }
        return bl;
    }

    public static boolean isFalse(String string) {
        if (BasicStr.hasContent(string)) {
            return translator.equals(string, 1) || translator.equals(string, 3) || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("f");
        }
        return false;
    }

    public static boolean isNotFalse(String string) {
        if (BasicStr.hasContent(string)) {
            return !translator.equals(string, 1) && !translator.equals(string, 3) && !string.equalsIgnoreCase("n") && !string.equalsIgnoreCase("f");
        }
        return true;
    }

    public Attribute getAttribute(Attribute[] attributeArray, int n) {
        return new Attribute(this.getTr(n), this.getValue(attributeArray, n));
    }

    public String getValue(Attribute[] attributeArray, int n) {
        return this.getValue(attributeArray, n, "");
    }

    public String getValue(Attribute[] attributeArray, int n, String string) {
        return this.getValue(attributeArray, "", n, string);
    }

    public String getValue(Attribute[] attributeArray, String string, int n, String string2) {
        if (attributeArray != null) {
            int n2;
            for (n2 = 0; n2 < attributeArray.length; ++n2) {
                if (!BasicStr.equalsIgnoreAccents(attributeArray[n2].name, string + newName[this.language][n])) continue;
                return attributeArray[n2].value;
            }
            for (n2 = 0; n2 < attributeArray.length; ++n2) {
                if (!translator.equals(attributeArray[n2].name, string, n)) continue;
                return attributeArray[n2].value;
            }
        }
        return string2;
    }

    public int getIndex(int[] nArray, String string, int n) {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!BasicStr.equalsIgnoreAccents(string, newName[this.language][nArray[n2]])) continue;
            return nArray[n2];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!translator.equals(string, nArray[n2])) continue;
            return nArray[n2];
        }
        return n;
    }

    public mjaColor parseColor(String string, mjaColor mjaColor3, mjaColor mjaColor4) {
        if (translator.isTrue(string)) {
            return mjaColor3;
        }
        if (BasicStr.hasContent(string) && translator.isNotFalse(string)) {
            mjaColor mjaColor5 = mjaColor.parseColor(this.language, string, null, null);
            if (mjaColor5 != null && mjaColor5.getAdaptedColor() != null) {
                return mjaColor5;
            }
            return mjaColor3;
        }
        return mjaColor4;
    }

    public Color ParseColor(String string, Color color, Color color2) {
        if (translator.isTrue(string)) {
            return color;
        }
        if (BasicStr.hasContent(string) && translator.isNotFalse(string)) {
            return translator.ParseColor(this.language, string, color, color2);
        }
        return color2;
    }

    public static Color ParseColor(int n, String string, Color color, Color color2) {
        if (BasicStr.hasContent(string)) {
            int n2;
            int n3;
            if (n >= 0) {
                for (n3 = 0; n3 < colorName[n].length; ++n3) {
                    if (!string.equalsIgnoreCase(colorName[n][n3])) continue;
                    return namedColor[n3];
                }
            }
            for (n3 = 0; n3 < data.numLang; ++n3) {
                for (n2 = 0; n2 < colorName[n3].length; ++n2) {
                    if (!string.equalsIgnoreCase(colorName[n3][n2])) continue;
                    return namedColor[n2];
                }
            }
            try {
                long l = Long.parseLong(string, 16);
                int n4 = (int)(l / 0x1000000L);
                return new Color((int)(l %= 0x1000000L));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n2 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    boolean bl = false;
                    String[] stringArray = BasicStr.getTokens(string);
                    n2 = Integer.parseInt(stringArray[0], 16);
                    n5 = Integer.parseInt(stringArray[1], 16);
                    n6 = Integer.parseInt(stringArray[2], 16);
                    return new Color(n2, n5, n6);
                }
                catch (Exception exception) {
                    return color;
                }
            }
        }
        return color2;
    }

    public static int parseLocation(String string) {
        if (BasicStr.hasContent(string)) {
            if (translator.equals(string, 120)) {
                return 0;
            }
            if (translator.equals(string, 263)) {
                return 1;
            }
            if (translator.equals(string, 264)) {
                return 2;
            }
            if (translator.equals(string, 265)) {
                return 3;
            }
            if (translator.equals(string, 266)) {
                return 4;
            }
            if (translator.equals(string, 267)) {
                return 5;
            }
            if (translator.equals(string, 268)) {
                return 6;
            }
            if (translator.equals(string, 269)) {
                return 7;
            }
            if (translator.equals(string, 270)) {
                return 8;
            }
        }
        return 0;
    }

    public static int parseAlign(String string, int n) {
        if (BasicStr.hasContent(string)) {
            if (string.equalsIgnoreCase("izquierda")) {
                return 1;
            }
            if (string.equalsIgnoreCase("centro")) {
                return 2;
            }
            if (string.equalsIgnoreCase("derecha")) {
                return 3;
            }
        }
        return n;
    }

    public static int parseAdjust(String string, int n) {
        if (BasicStr.hasContent(string)) {
            if (!(translator.equals(string, 1) || translator.equals(string, 3) || string.equalsIgnoreCase("n"))) {
                return 1;
            }
            return 0;
        }
        return n;
    }

    public String toString(String string, int n, String string2, String string3) {
        return this.toString(string, newName[this.language][n], string2, string3);
    }

    public String toString(String string, String string2, String string3, String string4) {
        if (BasicStr.hasContent(string3) && !string3.equals("''") && !string3.equals(string4) && !string3.equals("'" + string4 + "'")) {
            return string2 + "=" + string3 + string;
        }
        return "";
    }

    static {
        namedColor = new Color[]{Color.black, Color.magenta, Color.blue, Color.cyan, Color.green, Color.yellow, Color.orange, Color.red, Color.pink, Color.darkGray, Color.gray, Color.lightGray, Color.white};
    }
}

