$( window ).resize(function() {
  $( "#calculator" ).attr("zoom") ;
});


// Global variables to store calculator settings
var calculator =
    {
      previousAnswer: 0,
      justCalculated: false,
      degreeOrRadians: "degree",
    }
// This function append the supplied argument to the calculator display screen
function appendCalcScreen(inputString)
{
  $("textarea.calc-screen").val($("textarea.calc-screen").val() + inputString);
}

function backspaceCalcScreen()
{
  var currentCalcScreenValue = $("textarea.calc-screen").val();
  if (currentCalcScreenValue.length > 0)
    {
      $("textarea.calc-screen").val(currentCalcScreenValue.substring(0, currentCalcScreenValue.length - 1));
    }
}

function clearScreen()
{
  $("textarea.calc-screen").val("");
}

// Defines the tokens and their properties.
var nonNumericTokensDefinitions = 
[
  {lexeme: "+", category:"operator", associativity:"left", precedence:1, evalFunction: (function(LHS, RHS) {return LHS+RHS;})},
  {lexeme: "-", category:"operator", associativity:"left", precedence:1, evalFunction: (function(LHS, RHS) {return LHS-RHS;})},
  {lexeme: "*", category:"operator", associativity:"left", precedence:2, evalFunction: (function(LHS, RHS) {return LHS*RHS;})},
  {lexeme: "/", category:"operator", associativity:"left", precedence:2, evalFunction: (function(LHS, RHS) {return LHS/RHS;})},
  {lexeme: "^", category:"operator", associativity:"right", precedence:3, evalFunction: (function(LHS, RHS) {return Math.pow(LHS,RHS);})},
  {lexeme: "-u", category:"function", evalFunction: (function(RHS) {return -1.0*RHS;})},
  {lexeme: "=", category:"operator", associativity:"right", precedence:0},
  {lexeme: "log", category:"function", evalFunction: (function(RHS) {return Math.log10(RHS);})},
  {lexeme: "ln", category:"function", evalFunction: (function(RHS) {return Math.log(RHS);})},
  {lexeme: "sin", category:"function", evalFunction: (function(RHS) {return Math.sin(RHS);})},
  {lexeme: "asin", category:"function", evalFunction: (function(RHS) {return Math.asin(RHS);})},
  {lexeme: "cos", category:"function", evalFunction: (function(RHS) {return Math.cos(RHS);})},
  {lexeme: "acos", category:"function", evalFunction: (function(RHS) {return Math.acos(RHS);})},
  {lexeme: "tan", category:"function", evalFunction: (function(RHS) {return Math.tan(RHS);})},
  {lexeme: "atan", category:"function", evalFunction: (function(RHS) {return Math.atan(RHS);})},
  {lexeme: "Ans", category:"variable", evalFunction: (function() {return calculator.previousAnswer;})},
  {lexeme: "(", category:"bracket"},
  {lexeme: ")", category:"bracket"}
];

function evaulatePostfixTokens(tokenPostfixArray)
{
  var i = 0;
  while ((i < tokenPostfixArray.length) && (tokenPostfixArray.length !== 1))
    {
      var currentPostfixToken = tokenPostfixArray[i];
      var currentPostfixTokenCategory = getTokenCategory(currentPostfixToken);
      
      if ($.isNumeric(currentPostfixToken))
      {
        i++;
        continue;
      }
      else if (currentPostfixTokenCategory === "function")
        {
          // If the function is at the start of the Postfix Token and has no parameter, flag n error
          if (i < 1)
            {
              return null;
            }
          else if (($.isNumeric(tokenPostfixArray[i-1])) === true)
            {
              previousPostfixToken = tokenPostfixArray[i-1];
              var functionEvaulationResult = getTokenEvalFunction(currentPostfixToken)(previousPostfixToken);
              tokenPostfixArray.splice(i-1,2,functionEvaulationResult);
              i = i - 1;
              
              // Deal with the case when user specify something like 5log4, where there is an implicit *
              if (($.isNumeric(tokenPostfixArray[i-1])) === true)
              {
                tokenPostfixArray.splice(i-1,2,tokenPostfixArray[i-1]*functionEvaulationResult);
                i = i - 1;                
              }              
            }
          else
            {
              return null;
            }                                               
        }
      else if (currentPostfixTokenCategory === "operator")
        {
          // Check if there is sufficient number of operands 
          if (i < 2)
            {
              // Insufficient number of operands, return error
              return null;
            }
          // Check if the two items in front of the operator are numbers
          else if ((($.isNumeric(tokenPostfixArray[i-1])) === true) && (($.isNumeric(tokenPostfixArray[i-2])) === true))
            {
              // Evaulate the operator 
              var functionEvaulationResult = getTokenEvalFunction(currentPostfixToken)(tokenPostfixArray[i-2],tokenPostfixArray[i-1]);
              
              // Replace the operator and operands with the result
               tokenPostfixArray.splice(i-2,3,functionEvaulationResult);
              
              // Shift our scanner location
               i = i - 2;
                            
            }
          else 
            {
              return null
            }
        }
    }

   // Deal with input where user specify 5(4*2) where there is an implicit * before brackets
   if (($.isNumeric(tokenPostfixArray[i-1])) === true)
   {
      tokenPostfixArray.splice(i-2,2,tokenPostfixArray[i-1]*tokenPostfixArray[i-2]);
      i = i - 2;                
   } 
  return tokenPostfixArray[0];
}

function getTokenProperty(inputLexeme, property)
{
  for (var i = 0; i < nonNumericTokensDefinitions.length; i++)
    {
      if (nonNumericTokensDefinitions[i].lexeme === inputLexeme)
        {
          return nonNumericTokensDefinitions[i][property];
        }
    }
  return null;
}

function getTokenEvalFunction(inputLexeme)
{
  return getTokenProperty(inputLexeme, "evalFunction");
}
function getTokenPrecedence(inputLexeme)
{
  return getTokenProperty(inputLexeme, "precedence");
}

function getTokenAssociativity(inputLexeme)
{
  return getTokenProperty(inputLexeme, "associativity");
}
  
function getTokenCategory(inputLexeme)
{
  return getTokenProperty(inputLexeme, "category");
}
function identifyNonNumericToken(inputStringArgument)
{
  var matchedTokenLexeme = null;  
  // Loop through the tokens definition to find a match
  for (var i = 0; i < nonNumericTokensDefinitions.length; i++)
    {
      currentTokenDefinition = nonNumericTokensDefinitions[i];
      // See if our token matches our provided string
      if (currentTokenDefinition.lexeme === inputStringArgument.substring(0,currentTokenDefinition.lexeme.length))
          {
            matchedTokenLexeme = currentTokenDefinition.lexeme;
            return matchedTokenLexeme;
          }
    }
  return matchedTokenLexeme;
}

// This function goes through a token array and identify any unery operators and provide a "u" postfix for identification
function processUneryOperators(inputTokenArray)
{
    for (var i = 0; i < inputTokenArray.length; i++)
      {
        
        if (inputTokenArray[i] === "Ans")
          {
            inputTokenArray[i] = calculator.previousAnswer;
          }
        // Identify and flag unery "-" operator
        if (inputTokenArray[i] === "-")
        {
          var previousToken = inputTokenArray[i-1];
          var nextToken = inputTokenArray[i+1];
 
          if (
            (i === 0) || 
            (getTokenCategory(previousToken) === "operator") ||
            (previousToken == "(") ||
            (getTokenCategory(nextToken) === "function")
            )
          {
            inputTokenArray[i] = "-u";
          }
        }
      }
  return inputTokenArray;
}

function tokenize(inputStringArgument)
{
  // Array of tokens that are to be returned
  var tokenArray = [];
  
  // Temporary placeholder for the current token as we parse the string
  var currentToken ="";
  
  // Remove unwanted whitespace
  var inputString = inputStringArgument.replace(" ","");
  
  console.log("Input String: " + inputString);
  
  // Start parsing our string from left to right
  for (var i = 0; i < inputString.length; i++)
    {
      // Test for numeric and decimals
      if (($.isNumeric(inputString[i])) || (inputString[i] === "."))
        {
          // If the current token (so far) is numeric, we append this char to it
          if ($.isNumeric(currentToken) || (currentToken === ""))
            {
              currentToken += inputString[i];
            }
        }
      // Test the non-numeric value to match operators and functions
      else
        {
          // We have found a non-numeric value, we will push any numeric token to the tokenArray
          if ($.isNumeric(currentToken))
            {
              // Push into the tokenArray as a number (converted from token string)
              tokenArray.push(Number(currentToken));
              currentToken = "";                              
            }
          
          // We now match this non-numeric value to a token lexeme
          currentToken = identifyNonNumericToken(inputString.substring(i));
          
          // If we have found a valid non-numeric token
          if (currentToken !== null)
            {
              tokenArray.push(currentToken);
              // Advance our scanner forward by the lexueme's length less 1 (due to the i++ in the loop)
              i += currentToken.length - 1;
              currentToken = "";
            }
          else
            {
              // We have not found a valid token, return error.
              return null;
            }
        }
      
    // If we are at the end of our input string, push the last token to the array if it's not empty (numeric literal)
    if ((i === (inputString.length - 1)) && (currentToken !== ""))
      {
        $.isNumeric(currentToken) ? tokenArray.push(Number(currentToken)) : tokenArray.push(currentToken);
      }
      
    }
  
  return tokenArray;
}

function convertInfixTokenArraytoPostFix(infixTokenArray)
{
  var postfixResult =[];
  var operatorStack=[];
  
  for (var i =0; i < infixTokenArray.length; i++)
    {
      currentToken = infixTokenArray[i];
      if ($.isNumeric(currentToken))
        {
          postfixResult.push(currentToken);
          
          // Check if the top token of the opstack is a function, if so, pop it into the postfix result
          while (operatorStack.length >0)
            {
              operatorStackTopToken = operatorStack[operatorStack.length - 1];
              if (getTokenCategory(operatorStackTopToken) === "function")
              {
                postfixResult.push(operatorStack.pop());
              }
              else
                {
                  break;
                }
            }
        }
      else if (getTokenCategory(currentToken) === "variable")
         {
           operatorStack.push(currentToken);
         }
      else if (getTokenCategory(currentToken) === "function")
        {
          operatorStack.push(currentToken);
        }
      else if (getTokenCategory(currentToken) == "operator")
        {
          while (operatorStack.length > 0)
            {
              operatorStackTopToken = operatorStack[operatorStack.length - 1];
              if (getTokenCategory(operatorStackTopToken) === "operator")
                {
                  var opStackTopTokenAssociativity = getTokenAssociativity(operatorStackTopToken);
                  var opStackTopTokenPrecedence = getTokenPrecedence(operatorStackTopToken);
                  var currentTokenAssociativity = getTokenAssociativity(currentToken);
                  var currentTokenPrecedence = getTokenPrecedence(currentToken);
                  
                  if (
                    ((currentTokenAssociativity === "left") && (currentTokenPrecedence <= opStackTopTokenPrecedence))
                    ||
                    ((currentTokenAssociativity === "right") && (currentTokenPrecedence < opStackTopTokenPrecedence)))
                    {
                      postfixResult.push(operatorStack.pop());
                    }
                  else
                    {
                      break;
                    }
                }
              else
                {
                  break;
                }
            }
          operatorStack.push(currentToken);
        }
      else if(currentToken === "(")
        {
          operatorStack.push(currentToken);
        }
      else if(currentToken === ")")
        {
          do 
          {
            operatorStackTopToken = operatorStack[operatorStack.length - 1];
            if (operatorStackTopToken !== "(")
              {
                postfixResult.push(operatorStack.pop());
              }
              else
              {
                operatorStack.pop();
                // Check if it's a pair of bracket enclosed for a function ie. cos(1+2), if so, pop the opstack into the postfix result
                while (operatorStack.length >0)
                  {
                    operatorStackTopToken = operatorStack[operatorStack.length - 1];
                    if (getTokenCategory(operatorStackTopToken) === "function")
                      {
                      postfixResult.push(operatorStack.pop());
                      }
                    else
                      {
                        break;
                      }
                  }
                break;
              }
            } while (operatorStack.length > 0)
        }
    }
  
  while (operatorStack.length > 0)
    {
      postfixResult.push(operatorStack.pop());
    }
      
   return postfixResult;
}

function executeCalculate()
{
  var processedTokenArray = tokenize($("textarea.calc-screen").val());
  console.log(processedTokenArray);
  processedTokenArray = processUneryOperators(processedTokenArray);
  console.log(processedTokenArray);
  processedTokenArray = convertInfixTokenArraytoPostFix(processedTokenArray);
  console.log(processedTokenArray);
  result = evaulatePostfixTokens(processedTokenArray);
  console.log(result);
  
  calculator.justCalculated = true;
  
  // Write the result to screen, or shows "Error" if any error occured.
  if (result !== null)
    {
      $("textarea.calc-screen").val(result);
      calculator.previousAnswer = result;
    }
  else
    {
      $("textarea.calc-screen").val("Error");
    }
}

$(document).ready(
  function()
  {
    
  }
);
//////////////////////////////
// Capture keyboard events. //
//////////////////////////////

// Keydown function to capture "special" keys
$(document).keydown(function(){
  // Key that applies even when user has the calculator screen TextArea focused.
  //console.log(event.which);
  switch (event.which)
    {
      case 13:
        executeCalculate();
        event.preventDefault();
        break;
     case 27:
        $("[ccmd=AC]").trigger("click");
        break;        
    }
  
  // If user doesn't have the calculator screen TextArea focused, we want to capture the keyboard events still
  if (($(document.activeElement)).attr("id") !== "calc-screen")
  {
    //console.log(event.which);

     // Intercept certain keystrokes to link to special functions:
    switch (event.which)
      {
       // User pressed "Enter", trigger the execute button
        case 13:
          executeCalculate();
          event.preventDefault();
          //backspaceCalcScreen();
          break;
          // User pressed "Shift"
        case 16:
          break;
          // User pressed "Escape", press the AC button to clear screen
        case 27:
          $("[ccmd=AC]").trigger("click");
          break;
          // User pressed "Backspace", press the DEL button
        case 8:
          event.preventDefault();
          $("[ccmd=DEL]").trigger("click");
          break;          
      }
  }
});

// Keypress function for all other "standard" keys
$(document).keypress(function(){
  // If user doesn't have the calculator screen TextArea focused, we want to capture the keyboard events still
  if (($(document.activeElement)).attr("id") !== "calc-screen")
  {
        if (calculator.justCalculated === true)
        {
          calculator.justCalculated = false;
          clearScreen();
        }
    
        appendCalcScreen(String.fromCharCode(event.which));
  }
});

function appendAnsIfRequired()
  {
    if (calculator.justCalculated === true)
        {
          calculator.justCalculated = false;
          clearScreen();
          appendCalcScreen("Ans");
        }
    return;
  }

  function clearScreenIfRequired()
  {
    if (calculator.justCalculated === true)
        {
          calculator.justCalculated = false;
          clearScreen();
        }
    return;    
  }
  
// Event to convert clicks on buttons to their correct functions
$(".calc-btn, .calc-btn-small").click(function(){
  var ButtonCommand = $(this).attr("ccmd");
  
  switch (ButtonCommand)
  {
    // User pressed all clear to clear screen
    case "AC":
      clearScreen();
      break;
    // Call the parser to evaulate what's on screen
    case "EXECUTE":
      executeCalculate();
      break;
    case "DEL":
      backspaceCalcScreen();
      break;
    case "ADD":
      appendAnsIfRequired();
      appendCalcScreen("+");
      break;
    case "MINUS":
      appendAnsIfRequired();
      appendCalcScreen("-");
      break;
    case "MULTIPLY":
      appendAnsIfRequired();
      appendCalcScreen("*");
      break;
    case "DIVIDE":
      appendAnsIfRequired();
      appendCalcScreen("/");
      break;
    case "SQUARED":
      appendAnsIfRequired();
      appendCalcScreen("^2");
      break;
    case "POWER":
      appendAnsIfRequired();
      appendCalcScreen("^");
      break;
    case "DECIMAL POINT":
      appendCalcScreen(".");
      break;
    // Exponent in scientific notation
    case "EXPONENT":
      appendAnsIfRequired();
      appendCalcScreen("*10^");
      break;
    case "UNERY NEGATIVE":
      clearScreenIfRequired();
      appendCalcScreen("(-1)*");
      break;
    case "FIT":
     // window.open(this.href,"_self","width=290, height=520, location=no, menubar=no, status=no, toolbar=no");
      window.open(this.href, "Calculator", "width=320, height=520");
      break;
    case undefined:
      clearScreenIfRequired();
      appendCalcScreen($(this).html());
  }

});