
	var statApp = angular.module("stat",[]);
	statApp.controller("statCon", function($scope){
		$scope.output = 0;
		$scope.count = 0;
		$scope.list = [];
		$scope.m = 0;
		$scope.display = "0";
		
		
		
		$scope.digit = function(num){
			
			
			if ($scope.display === "0"){
				$scope.display = num + "";
			} else {
				$scope.display += num + "";
			}
			
			
			
			$scope.output = parseFloat($scope.display);
			
		}
		
		$scope.clear = function(){
			$scope.output = 0;
			$scope.dis();
		}
		
		$scope.clearAll = function(){
			$scope.clear();
			
			$scope.count = 0;
			$scope.list = [];
			$scope.mc();
			$scope.dis();
		}
		
		$scope.plusMinus = function(){
			$scope.output *= -1;
			$scope.dis();
		}
		
		$scope.shrink = function(){
		
		if($scope.display.length === 1){
			$scope.display = "0";
			$scope.output = 0;
		} else {
			$scope.display = $scope.display.slice(0, $scope.display.length - 1); 
			$scope.output = parseFloat($scope.display);
		}
		
		}
		
		$scope.add = function(){
			$scope.list.push($scope.output); 
			$scope.clear();
			$scope.count++;
			
			$scope.dis();
		}
		
		$scope.mem = function(sign){
			$scope.m += $scope.output * sign;
		}
		
		$scope.ms = function(){
			$scope.m = $scope.output;
		}
		
		$scope.mc = function(){
			$scope.m = 0;
		}
		
		$scope.mr = function(){
			$scope.output = $scope.m;
			
			$scope.dis();
		}
		
		$scope.sum = function(arr, pow){
		
			var sum = 0;
			
			arr.forEach(function(cur){
				sum += Math.pow(cur, pow);
			});
			
			return sum;
		}
		
		//dv is input if arr is input.  dv is only 0 or 1
		$scope.ave = function(arr, dv){
		
		
		
			if (arguments.length === 0){
				$scope.output = $scope.sum($scope.list, 1) / $scope.list.length;
				$scope.dis();
			} else {
				return $scope.sum(arr, 1) / (arr.length - dv);
			}
				
		}
		
		$scope.rms = function(){
			$scope.output = $scope.sum($scope.list, 2) / $scope.list.length;
			
			$scope.dis();
		}
		
		$scope.displaySum = function(){
			$scope.output = $scope.sum($scope.list, 1);
			
			$scope.dis();
		}
		
		$scope.displaySquareSum = function(){
			$scope.output = $scope.sum($scope.list,2);
			
			$scope.dis();
		}
		
		$scope.dis = function(){
			$scope.display = $scope.output + "";
			
		}
		
		$scope.exp = function(){
			$scope.display = $scope.output.toExponential() + "";
		}
		
		//todo test this function more
		$scope.fe = function(){
			var tst = parseFloat($scope.display);
			if ( tst === $scope.display.valueOf() ){
				$scope.exp();
			} else {
				$scope.display = tst.valueOf();
			}
		}
		
		//todo  add functionality for sigma,n - 1 cases as well
		//sd stands for standard deviation
		$scope.sd = function(dv){
			var mean = $scope.ave($scope.list, 0);
			var df = [];
			
			//Calculate the squared difference between list array items and the mean
			for (var i = 0, len = $scope.list.length; i < len; i++){
				df.push( Math.pow($scope.list[i] - mean, 2) );
			}
			
			$scope.output = Math.pow($scope.ave(df, dv ), 0.5);
			
			$scope.dis();
	
			
		}
		
	});
