var offX = 300;
var offY = 150;

var totalAnim = 2000;
var startTime = new Date().getTime();
var last = startTime;

var totalX = 600;
var totalY = 300;

var yValues = new Array();

var eq = $("#y").val();
eq = fix(eq, false);
$("#y").val(eq);



$("#canvasOverlay").mousemove(function() 
{
  var e=arguments[0] ; 
  hover(Math.floor(e.pageX - offX));
});

$("#canvasOverlay").mouseout(function(){clearOverlay();});

function hover(x)
{
  
  //var y = yValues[x].toFixed(2);
  var y = yValues[x];
  
  $("#notes").html("x: " + x + ", y: " + y);
  
  
  var selectHeight = 10;
  var selectWidth = 10;
  
  
  var c=document.getElementById("canvasOverlay");
  var ctx=c.getContext("2d");
  
  ctx.clearRect ( 0 , 0 , 600 , 300 );
  c.width = c.width;
  
  ctx.strokeStyle = "rgba(0,150,0,0.5)";
  ctx.lineWidth = selectWidth;
  
  ctx.beginPath();

  ctx.moveTo(x + offX,0-y + offY - (selectHeight/2));
  ctx.lineTo(x + offX,0-y + offY + (selectHeight/2));
  ctx.stroke(); 
  
    ctx.lineWidth = 1;
  ctx.moveTo(x + offX,0 - offY);
  ctx.lineTo(x + offX,0 + totalY);
  ctx.stroke(); 
  
  
}

clearCanvas();
render();





function fix(eq, changed)
{
  var cont = true;
  
  for (var i = 0; i < eq.length && cont; i++)
  {
    var c1 = eq.charAt(i);
    var c2 = eq.charAt(i+1);

    if (c2.toUpperCase() == "X"){
     if (IsNumeric(c1) || c1 == c2)
     {
       eq = eq.substr(0,i+1) + "*" + eq.substr(i+1,i+1+eq.length);              
       cont = false;
     }
    }
  }
  
  if (!cont)
  { return fix(eq, true); }
  else
  {
    if (changed)
    { debug("Changing equation to " + eq); }
    return eq;
  }
}


    
function IsNumeric(input)
{
    return (input - 0) == input && (''+input).replace(/^\s+|\s+$/g, "").length > 0;
}
    
function refresh()
{
  startTime = new Date().getTime();
  eq = fix($("#y").val(), false);
  $("#y").val(eq);
  
  render();
}

function render()
{  
  yValues = new Array();  //wipe this array
  var x = 0;
  var y = eval(eq);
  $("#notes").html("&nbsp");
  debug("Drawing formula <i>" + eq + "</i> which crosses y axis at " + y);
  renderLoop(); 
}

function renderLoop()
{
  var now = new Date().getTime();
  var delta = now - startTime;  
  var frac = delta/totalAnim;
  
  var c = document.getElementById("myCanvas");
  var ctx = c.getContext("2d");    
  
  ctx.beginPath();
  ctx.strokeStyle = "#000";
  ctx.webkitImageSmoothingEnabled = true;
  ctx.lineWidth = 1;
  ctx.beginPath();
  ctx.moveTo(0 + i0,0 + offY);


  var i0 = 0-(totalX/2);
  var i1 = 0+(totalX/2);
  var maxi = i0+(i1-i0)*frac;
  
  
  
  
  
  if (eq=="")
  {
     $("#y").val("x"); 
  }
  
  for (var x = i0; x < maxi; x++)
  {
    var y = eval(eq);
    yValues[x] = y;
    ctx.lineTo(offX + x, offY + (0 - y));
  }
  
  
  if(delta < totalAnim)
  {    
    requestAnimationFrame(renderLoop); 
  }
  ctx.stroke();    
}




//////////////////////////////////////////
// Draw the axis bars
//////////////////////////////////////////
function drawAxis(ctx)
{
  ctx.strokeStyle = "#666";
  
  var yLength = totalY;
  var xLength = totalX;
  
  //Y Axis
  ctx.moveTo(0 + offX,0 + offY - (yLength/2));
  ctx.lineTo(0 + offX,0 + offY + (yLength/2));
  
  //X Axis
  ctx.moveTo(0 + offX - (xLength/2),0 + offY);
  ctx.lineTo(0 + offX + (xLength/2),0 + offY);
  
  
  ctx.moveTo(0 + offX,0 + offY);
  ctx.stroke();
}





//////////////////////////////////////////
// Draw small lines in light grey
//////////////////////////////////////////
function drawGrid(ctx)
{
  ctx.strokeStyle = "#CCC";
  
  var jump = 10;
  
  var yLength = totalY;
  var xLength = totalX;
  
  
  for (var i = 0 + offY - (yLength/2); i < 0 + offY + (yLength/2); i += jump)
  {
    //Horizontal Lines
    ctx.moveTo(0 + offX - (xLength/2),i);
    ctx.lineTo(0 + offX + (xLength/2),i);
  }
  
  
  for (var i = 0 + offX - (xLength/2); i < 0 + offX + (xLength/2); i += jump)
  {
    //Vertical Lines
    ctx.moveTo(i, 0 + offY - (yLength/2));
    ctx.lineTo(i, 0 + offY + (yLength/2));    
  }
  
  
  ctx.moveTo(0 + offX,0 + offY);
  ctx.stroke();
}


//////////////////////////////////////////
// Clear the whole canvas
//////////////////////////////////////////
function clearCanvas()
{
  var c=document.getElementById("myCanvas");
  var ctx=c.getContext("2d");
    
  $("#notes").html("&nbsp");
                     
  ctx.clearRect ( 0 , 0 , 600 , 300 );
  c.width = c.width;
  drawAxis(ctx);drawGrid(ctx);
  
  clearOverlay();
}

function clearOverlay()
{
  var c=document.getElementById("canvasOverlay");
  var ctx=c.getContext("2d");    
  $("#notes").html("&nbsp");
                     
  ctx.clearRect ( 0 , 0 , 600 , 300 );
  c.width = c.width;
}

function debug(m)
{
 $("#debug").html(m + "<br>" + $("#debug").html()); 
}