// # 180 websites in 180 days - 13 & 19 Days CASIO Calculator
// ---> by Ivan Oung
// --------------------------------
// ## 1. Variable declarations
// --------------------------------
// ## 2. Functions declarations
// ### 2.1 Validating input events from either clicking keys or typing with keyboard
// ## 2.2 Converting a click on the keyboard to a string
// ## 2.3 Equal trigger
// ## 2.4 Backspacing
// ## 2.5 Complete clear
// --------------------------------
// ## 3. Interaction declarations
// ### 3.1 Functions on keyboard
// ### 3.2 Recording keystrokes with feedback
// ### 3.3 Recording backspace key press on keyboard
// ### 3.4 Validating the values stored in buttons
// ### 3.5(temp solution) Stop user from expecting clicking events from non-functionable buttons
// --------------------------------
// ## 4. Possible code improvements
// ### 4.1 Function button to be implemented

// ## 1. Variable declarations
// Check for digits
var reg1 = /\d/;
// Check for signs
var regSigns = /\+|\-|\*|\//;
var storage;
// Recording where the last signage location to make C effective
var signLocation;
// Validate input with only 1 '.' in each set of numbers
var canHaveDotHwat = true;
// Check to see if the result on the screen is a new input or not
var didYouPressEqual = false;
// Claiming all the status of the current dashboard
var topStatusBar = new function() {
    this.bk = false;
    this.gt = false;
    this.e = false;
    this.k = false;
    this.taxplus = false;
    this.taxminus = false;
    this.cost = false;
    this.sell = false;
    this.mar = false;
    this.percentage = false;
    this.divide = false;
    this.multiply = false;
    this.minus = false;
    this.plus = false;
}();
console.log(topStatusBar);

// ## 2. Functions declarations
// ### 2.1 Validating input events from either clicking keys or typing with keyboard
function validation(event) {
    var el = event;
    var strHtml = $("#memory").text();
    var accumulateString = strHtml + el;

    if (reg1.test(el) && accumulateString.length < 14) {
        if (didYouPressEqual === true) {
            $("#memory").text(el);
            didYouPressEqual = false;
        } else {
            $("#memory").text(accumulateString);
        }
    } else if (regSigns.test(el)) {
        // if situation for signages
        if (regSigns.test(strHtml.charAt(strHtml.length - 1))) {
            $("#memory").text(strHtml.slice(0, strHtml.length - 1) + el);
            signLocation = accumulateString.length - 2;
        } else {
            $("#memory").text(accumulateString);
            signLocation = accumulateString.length - 1;
        }
        //         Updating the location of the sign for future use
        canHaveDotHwat = true;
    } else if (
        el == "." &&
        canHaveDotHwat == true &&
        accumulateString.length < 14
    ) {
        canHaveDotHwat = false;
        $("#memory").text(accumulateString);
    } else if (el == "=") {
        hwatDeAnswer();
    }
}

// ## 2.2 Converting a click on the keyboard to a string
// ### Interestingly enough, this.which||this.keyCode does not work with keyup or keydown, but works with keypressed...
function convertClickToString(event) {
    var char = event.which || event.keyCode;
    return String.fromCharCode(char);
}

// ## 2.3 Equal trigger
function hwatDeAnswer() {
    $("#memory").text(eval($("#memory").text()));
    didYouPressEqual = true;
}

// ## 2.4 Backspacing
function backSpacing() {
    $("#memory").text(
        $("#memory")
            .text()
            .slice(0, -1)
    );
}

// ## 2.5 Complete clear
function wipeOut() {
    $("#memory").text("");
    canHaveDotHwat = true;
    didYouPressEqual = false;
}

// ## 3. Interaction declarations
// ### 3.1 Functions on keyboard
$("#equal").click(() => {
    hwatDeAnswer();
});

$("#backspace").click(() => {
    backSpacing();
});

$("#ac").click(() => {
    wipeOut();
});

$("#c").click(() => {
    $("#memory").text(
        $("#memory")
            .text()
            .slice(0, signLocation)
    );
});

// ### 3.2 Recording keystrokes with feedback
$(document).keypress(function(event) {
    validation(convertClickToString(event));
});
// ### 3.3 Recording backspace key press on keyboard
$(document).keydown(function(event) {
    if ((event.which || event.keyCode) === 8) {
        backSpacing();
    }
});

// ### 3.4 Validating the values stored in buttons
$(".numbers, .operation").click(function() {
    validation($(this).attr("value"));
});

// ### 3.5(temp solution) Stop user from expecting clicking events from non-functionable buttons
$(document).ready(function() {
    $(".nonBasic").addClass("unclickable");
});
// ## 4. Fields of improvements
// ### 4.1 Function button to be implemented
// - Tax +/-
// - CST, SELL MAR
// - '%'
// - GT
// - MRC, M-, M+
