/* This design was inspired by the Busicom LE-80A Handy, a very early pocket calculator sold in the 70s. It has an unusual key layout, lacking a dedicated equals key. There are eight, seven-segment LED digit displays and a ninth display for error flags and the negative indicator.
*/

var inputBuffer = [];   // display inputBuffer
var memory = null;  // left argument
var operator = '';  // operator memory

$('button').click(function() {
  this.id[0] === "n" ?
    pressNumber(this.id[1]) :
    performOperation(this.id[1], inputBuffer);
});

function pressNumber(num) {
  if (num === '0' && inputBuffer.length === 0) {return;}
  if (num === 'P') {
    if (inputBuffer.indexOf('.') !== -1) {return;}
    if (inputBuffer.length === 0) inputBuffer.unshift('0')
    num = '.';
  }
  
  if (inputBuffer.filter(char => char !== '.').length < 8 ) {
    inputBuffer.push(num);
    updateDisplay(inputBuffer);
  }
}


function performOperation(type, arr) {
  arr.unshift('0');
  var number = parseFloat(arr.join(""));
  inputBuffer = [];
  
  if (type === 'C') {
    clearDisplay();
    memory = null;
    operator = '';
  } else if (type === operator && memory != null) {
    switch (type) {
      case 'A':
        memory += number;
        convertToDisplay(memory);
        break;
      case 'S':
        memory -= number;
        convertToDisplay(memory);
        break;
      case 'X':
        memory *= number;
        convertToDisplay(memory);
        break;
      case 'D':
        memory /= number;
        convertToDisplay(memory);
        break;
    }
  } else if (type !== operator && memory != null) {
      performOperation(operator, arr);
      operator = type;
  } else {
    operator = type;
    memory = number;
  }
}


function convertToDisplay(float) {
  var ans = []
  if (float > 99999999 || float < -99999999) {
    ans = ['E'];
  } else {
    ans = Math.abs(float)
              .toFixed(7) // BUG: can display rounding error when chaining operations
              .slice(0,9)
              .replace(/[0]+$/g, "") // suppress trailing zeros caused by floating point error
              .split('')
  }
  updateDisplay(ans, float < 0 ? true : false);
}


function updateDisplay(digitArr, neg){
  digitArr = digitArr.reduce(function(a, b, index) {
          b === '.' ? a[index] += b : a.push(b);
          return a;
        }, [0]).reverse();
  
  clearDisplay();
  if (neg === true) {$('#dN').removeClass('led-off').addClass('led-on');}

    for (var i = 0; i < digitArr.length - 1; i++) {
      $('#d' + i).html(digitArr[i]).removeClass('led-off').addClass('led-on')
    }
}


function clearDisplay() {
  $('#d0').html('0');
  $('#d1').removeClass('led-on').addClass('led-off').html('8.');
  $('#d2').removeClass('led-on').addClass('led-off').html('8.');
  $('#d3').removeClass('led-on').addClass('led-off').html('8.');
  $('#d4').removeClass('led-on').addClass('led-off').html('8.');
  $('#d5').removeClass('led-on').addClass('led-off').html('8.');
  $('#d6').removeClass('led-on').addClass('led-off').html('8.');
  $('#d7').removeClass('led-on').addClass('led-off').html('8.');
  $('#dN').removeClass('led-on').addClass('led-off');
}