$(function() {
 
  // ******** Define and Initialize Variables ******** //
  var isOn = false;
  var makeNegative = false;
  var displayStr = "";
  var currVal = 0;
  var storedVal = 0;
  var mem = 0;
  var storedOp = "";
  var prevEntry = "0";
  

  // ******** Functions ******** //
  var operators = {
    'plus': function(a, b) { return a + b },
    'minus': function(a, b) { return a - b },
    'times': function(a, b) { return a * b },
    'divide': function(a, b) { return a / b },
    'sqrt': function(a) { return Math.sqrt(a)},
    'percent': function (a, b) { return a * ( b / 100 )}
  };
  
  function ClearAllButMemory() {
    displayStr = "0";
    currVal = 0;
    storedVal = 0;
    storedOp = "";
    prevEntry = "0";
  }
  
  function PrepareStringForDisplay(str) {
    var val = +str;
    
    // Value can't be expressed on this display correctly
    if (val > 99999999 || val < -9999999) return "Error";
    
    var dpos = str.indexOf('.');

    // If it's an integer within expressible range, display it
    if (dpos === -1) return str;
    
    if (isNaN(prevEntry)) {
      // Ignore decimal point in terms of string length
      var charCount = str.length - 1;
      
      // If the value exceeds the display width, round it to fit
      if (charCount > 8) {
        var exp = dpos - 8; // the 10log of the rightmost digit
        val = val.toString().split('e');
        val = Math.round(+(val[0] + 'e' + (val[1] ? (+val[1] - exp) : -exp)));
        // Shift back
        val = val.toString().split('e');
        val = +(val[0] + 'e' + (val[1] ? (+val[1] + exp) : exp));
      }
      str = val.toString();
    }
    
    // Close the gap around the decimal point
    str = str.substr(0, dpos - 1) +
          '<span id="dot">' +
          str[dpos - 1] +
          '.</span>' +
          str.substr(dpos + 1);
 
    return str;
  }
  // ******** END: Functions ******** //
  
  
  
  // ******** Calc Button Click ******** // 
  $('button').click(function() {
    var btnVal = $(this).val();
    
    // Require ON/C button click to start calculator
    if (isOn === false && btnVal !== 'on-c') return;
    isOn = true;
    
    // Require clear after error
    if (displayStr === "Error" && (btnVal !== "on-c" && btnVal !== "cl")) return;
    
    // **** Buttons Switch-Case **** //
    switch(btnVal) {
      // Clear all, including memory
      case 'on-c':
        ClearAllButMemory();
        mem = 0;
        break;

      // Clear last entry, otherwise clear all but memory
      case 'cl':
        if (displayStr == "0" || displayStr == "Error") {
          ClearAllButMemory();
        } else {
          prevEntry = "0";
          displayStr = "0";
        }
        break;
        
      // Recall memory, but clear memory if clicked twice in a row
      case 'rm-cm':
        if (prevEntry !== "rm-cm") {
          displayStr = mem.toString();
          currVal = +displayStr;
        } else {
          displayStr = "0";
          currVal = 0;
          mem = 0;
        }
        prevEntry = "rm-cm";
        break;
        
      case 'm-plus':
      case 'm-minus':
        if (prevEntry === "result") {
          storedOp = "";
          currVal = storedVal;
        }
        storedVal = currVal;
        btnVal === "m-plus" ? mem += currVal : mem -=currVal;
        displayStr = mem.toString();
        currVal = +displayStr;
        storedOp = "";
        prevEntry = "result";
        break;
      
      case '0':
      case '1':
      case '2':
      case '3':  
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':  
      case '9':
        if (isNaN(prevEntry) || displayStr === "0") {
          makeNegative ? displayStr = "-" + btnVal : displayStr = btnVal;
          makeNegative = false;
        } else {
          if (displayStr.length > 7 + (displayStr.indexOf('.') !== -1)) break;
          displayStr += btnVal;
        }
        prevEntry = btnVal;
        currVal = +displayStr;
        break;
      
      case '.':
        if (isNaN(prevEntry)) {
          makeNegative ? displayStr = "-0." : displayStr = "0.";
          makeNegative = false;
          prevEntry = "0";
        } else if (displayStr.indexOf('.') === -1) {
          if (displayStr.length > 7 + (displayStr.indexOf('.') !== -1)) break;
          displayStr += '.';
        }
        break;
        
      case 'percent':
        if (storedOp === "minus" || storedOp === "plus") {
          currVal = operators[btnVal](storedVal, currVal);
        } else {
          currVal = currVal * 0.01;
          displayStr = currVal.toString();
          break;
        }
        displayStr = currVal.toString();
        prevEntry = "result";
        break;

      case 'sqrt': 
        if (prevEntry === "result") {
          storedOp = "";
          currVal = storedVal;
        }
        if (currVal < 0) {
          displayStr = "Error";
          break;
        }
        currVal = +displayStr;
        currVal = Math.sqrt(currVal);
        if (storedVal === 0 || prevEntry === "result") storedVal = currVal;
        displayStr = currVal.toString();
        prevEntry = "result";
        break;

      case 'minus':
        if (prevEntry === "operation" || +displayStr === 0) {
            makeNegative ? makeNegative = false : makeNegative = true;
            break;
          }
      case 'plus':  
      case 'times':
      case 'divide':
        if (isNaN(prevEntry) || prevEntry === "0") {
          storedOp = "";
          currVal = storedVal;
        }
        if (storedOp !== "") { // If there's a stored op, do it
          // Catch division by zero error
          if (storedOp === 'divide' && currVal === 0) {
            displayStr = "Error";
            break;
          }
          // Perform stored operation
          storedVal = operators[storedOp](storedVal, currVal); 
          displayStr = storedVal.toString();
        } else { // Otherwise, it's a new op so just store current value
          storedVal = +displayStr;
        }
        // And, either way, store the operation type
        storedOp = btnVal;
        prevEntry = "operation";
        break;

      case 'equals':
        if (storedOp !== "") { // If there's a stored op, do it
          // Catch division by zero error
          if (storedOp === 'divide' && currVal === 0) {
            displayStr = "Error";
            break;
          }
          // Perform stored operation
          storedVal = operators[storedOp](storedVal, currVal);
          displayStr = storedVal.toString();
        } else {
          // Display current value
          displayStr = currVal.toString();
        }
        prevEntry = "result";
        break;

      default:
        alert("What button was that?!");
        
    } /* END: Buttons Switch-Case */
    
  var lcd = PrepareStringForDisplay(displayStr);
  $('#digits').html(lcd);
    
}) /******** END: Calc Button Click ********/

  
  // Fade the screen with solar array hover
  
  
  $('#solar-array').hover(function () {
    $('#solar-array').click(function(e) {
    e.preventDefault();
    return;
    })
    $('#digits').stop().animate({opacity: 0.1}, 4000);
  }, function () {
    $('#digits').stop().animate({opacity: 1.0}, 1000);
  });
  
});