/*
HP21 Calculator Emulator - hpdisp.js
Copyright (c) 2012-2015 Greg Sydney-Smith

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

Revision History:
2015-03-29 Release 1.07, Updated license terms.
2013-01-01 From HP29 version.
2012-12-24 Initial release.
*/

function displayVal(v)
{
  switch (cs.fmt) {
  case "FIX" : myDisplayFIX(v,cs.dsp); break;
  case "SCI" : myDisplaySCI(v,cs.dsp); break;
  case "ENG" : myDisplayENG(v,cs.dsp); break;
  }
}

function displayProg(pc,inst) {
  var w = 12;
  var s = "";
  var spaces="               ";
  var n = pc;
  var v = Math.floor(n/ 10); n -= v* 10; s += v;
  s += n;
  s += spaces.substr(1,w-2-inst.length) + inst;
  // add an extra space before any dot register names (".0" - ".5")
  s  = s.replace("."," .");
  myDisplayMsg(s);
}

function displayCrd()   { myDisplayMsg(" Crd"); }
function displayError() { myDisplayMsg(" Error"); }

function displayRnn(nn) {
  var w = 12;
  var s=("               ".substr(0,w-nn.length))+nn;
  myDisplayMsg(s);
}

// display input buffer comes here. Reformat if necessary (to suit display size)
function display(a,eex) {
  var w = 12+1;
  var r = [];
  for (var i=0; i<1+10+1; i++)
    r[i]= a[i];
  for (; i<w; i++)
    r[i]= " ";
  if (eex) { r[w-3]=a[12]; r[w-2]=a[13]; r[w-1]=a[14]; }
  myDisplay(r);
}

// Private below here

// in FIX2, does 0.005 round to 0.01 and display as that
// or does anything less than 0.01 switch to SCI??
function myDisplayFIX(v,n) {
  var s;
  var r = new Array;

//alert("displayFIX("+v+","+n+")");
  precision= Math.pow(10,n);

  v1= (v<0) ? -v : v;
  if (v1 != 0 && v1 < (1/precision)) { myDisplaySCI(v,9); return; }
  if (           v1 > 9999999999)    { myDisplaySCI(v,9); return; }

  // round to displayed precision
  v1 *= precision; v1 += 0.5; v1=Math.floor(v1);

  for (var i=0; (i<1+n) || (v1>0); i++)
  {
    r[i]= v1 % 10;
    v1 = Math.floor(v1/10);
  }

  // set sign digit
  s= (v<0) ? "-" : " ";

  // add digits
  for (j=0; j<i-n; j++)
    s += r[i-1-j];
  s += ".";
  for (; j<i; j++)
    s += r[i-1-j];

  myDisplayMsg(""+s);
}


function myDisplaySCI(v,n) {
  var w = 12+1; // +1 for decimal point (dp)
  var exp = 0;
  var s;
  var r = new Array;

//alert("displaySCI("+v+","+n+")");

  var v1= (v<0) ? -v : v;
  if (v1 != 0) 
  {
    while (v1 >=10) { v1 /= 10; exp++; }
    while (v1 <  1) { v1 *= 10; exp--; }
  }

  if ((exp < -99) || (99 < exp))
    { cs.error=1; return; } // is this what it really does???

  // round to displayed precision
  precision= Math.pow(10,n);
  v1 *= precision; v1 += 0.5; v1=Math.floor(v1);

  for (var i=0; (i<1+n) || (v1>0); i++)
  {
    r[i]= v1 % 10;
    v1 = Math.floor(v1/10);
  }

  // set sign digit
  s= (v<0) ? "-" : " ";

  // add digits
  for (j=0; j<i-n; j++)
    s += r[i-1-j];
  s += ".";
  for (; j<i; j++)
    s += r[i-1-j];

  // add exponent
  for (; j<10; j++)  // got a sign, a dot, now upto 10 mantissa digits
    s += " ";
  s = s.substr(0,w-3); // in case width is less than 15
  s += (exp<0) ? "-" : " ";
  e =  (exp<0) ? -exp : exp;
  s += (""+Math.floor(e/10));
  s += (""+Math.floor(e%10));
  myDisplayMsg(""+s);
}


function myDisplayENG(v,n) {
  var w = 12+1;
  var exp = 0;
  var s;
  var r = new Array;

//alert("displayENG("+v+","+n+")");

  v1= (v<0) ? -v : v;
  if (v1 != 0) 
  {
    while (v1 >=1000) { v1 /= 1000; exp+=3; }
    while (v1 <    1) { v1 *= 1000; exp-=3; }
  }

  if ((exp < -99) || (99 < exp))
    { cs.error=1; return; } // is this what it really does???

  // round to displayed precision
  n -= (v1>=100) ? 2 : (v1>=10) ? 1 : 0; // in ENG, n is significant digits; not decimal places
  if (n<0) n=0;
  precision= Math.pow(10,n);
  v1 *= precision; v1 += 0.5; v1=Math.floor(v1);

  for (var i=0; (i<1+n) || (v1>0); i++)
  {
    r[i]= v1 % 10;
    v1 = Math.floor(v1/10);
  }

  // set sign digit
  s= (v<0) ? "-" : " ";

  // add digits
  for (j=0; j<i-n; j++)
    s += r[i-1-j];
  s += ".";
  for (; j<i; j++)
    s += r[i-1-j];

  // add exponent
  for (; j<10; j++)  // got a sign, a dot, now upto 10 mantissa digits
    s += " ";
  s = s.substr(0,w-3); // in case width is less than 15
  s += (exp<0) ? "-" : " ";
  e =  (exp<0) ? -exp : exp;
  s += (""+Math.floor(e/10));
  s += (""+Math.floor(e%10));
  myDisplayMsg(""+s);
}


function myDisplayMsg(txt) {
  var w = 12+1;
  var d = [];
//alert("displayMsg("+txt+")");
  for (var i=0; (i<w) && (i<txt.length); i++)
    d[i]= txt.substr(i,1);
  for (   ; i<w; i++)
    d[i]= " ";
  myDisplay(d);
}

// Low-Level Print the contents of 'a' onto the LED display.
function myDisplay(a) {
  var w = 12;
  var j = 0; // should be 0, or 1 if a decimal point has been found
  for (var i=0; i<w ; i++) {
    var dp = false;
    var v  = a[i+j];
    if (a[i+j+1] == ".") { dp=true; j++; } // lookahead for dot
    myDisplayDigit(i,""+v,dp);
  }
}

function myDisplayDigit(x,v,dp) {
//alert("a["+x+"]="+v+", dp="+dp);
    if (v == " ")   v="s";
    if (v == "-")   v="m";
    if (v == ".") { v="s"; dp=true; }
    var s= ""+v;
    if (dp && cs.show_dp) s+="d";  // show_dp= true except during -x- or -stk-
    if (   cs.low_power ) dp= !dp;
    if (!  cs.power_mode) s= "s";
    document.getElementById("d"+x).src = "images/led-"+s+".gif";
}
