/*
HP21 Calculator Emulator - hpscan.js
Copyright (c) 2012-2015 Greg Sydney-Smith

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

Revision History:
2015-03-29 Release 1.07, Updated license terms.
2013-01-01 Updated for HP21.
2012-03-13 Initial release.
*/

function Keyboard() {
    var result = "";
    var state = 0;
    var idx = 0;
    var keys = new Array ("","","","","");
  
    this.done  = function (result) { alert("keyboard.done: "+result); };
    this.press = function (key) {
        var i, x;
        var keytype = getKeyType(key); // alert("type="+keytype);
    
        //alert("state="+state+" idx="+idx+" key="+key);
        keys[idx++]= key;
    
        switch (state) {
        case 0  : state = (key     == "15") ?  15 :
                          (key     == "74") ?  74 : 101; break;
    
        case 15 : // f
                  idx = 0;
                  keys[idx++] = "15"; keys[idx++] = key;
                  state = (key     == "15") ?  15 :
                          (keytype ==  "x") ? 100 :
                          (keytype ==  "o") ? 100 :   0; break;

        case 74 : // DSP
                  state = (keytype ==  "n") ? 101 :
                          (key     == "73") ? 741 :   0; break;
        case 741: // DSP .
                  state = (keytype == "n" ) ? 101 :   0; break;
        }
        
        if (state == 101) {
//alert("in 101");
          for (i=0; i<idx; i++)
            if ((x="72,62,63,64,52,53,54,42,43,44".indexOf(keys[i])) >= 0)
              keys[i]= "00,01,02,03,04,05,06,07,08,09".substr(x,2);
          state = 100;
        }
        
        if (state == 100) {
//alert("in 100");
          result="";
          for (i=0; i<idx; i++) result += keys[i]+" ";
          result= result.substr(0,result.length-1);
          this.done(result);
          state = 0;
        }
        
        if (state==0) idx=0; 
    };
    
    function getKeyType(key) {
        var x;
        var keys = "11,12,13,14,15,21,22,23,24,25,31,32,33,34,41,42,43,44,51,52,53,54,61,62,63,64,71,72,73,74,";
        var types = "xxxxf"+"xxxxx"+"-xxx"+"onnn"+"onnn"+"onnn"+"on--";
        if ((x= keys.indexOf(key+",")) < 0) alert("getKeyType: invalid key - "+key);
        return types.substr(x /= 3,1);
    }
}

