/*
HP21 Calculator Emulator - hpscan.js
Copyright (c) 2012-2015 Greg Sydney-Smith

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

Revision History:
2015-03-29 Release 1.07, Updated license terms.
2013-01-01 Initial release.
*/


// main parsed keyboard entry point
function do_kb(code) {
    execute(code);
}


function execute(code) {
//alert(code);

  switch (code) {

  case "11"      : do_inv(); break;
  case "12"      : do_sin(); break;
  case "13"      : do_cos(); break;
  case "14"      : do_tan(); break;
  case "15 11"   : do_y2x(); break;
  case "15 12"   : do_asin(); break;
  case "15 13"   : do_acos(); break;
  case "15 14"   : do_atan(); break;
 
  case "21"      : do_xy(); break;
  case "22"      : do_rdn(); break;
  case "23"      : do_epow(); break;
  case "24"      : do_sto("",0); break;
  case "25"      : do_rcl(0); break;
  case "15 21"   : do_P2R(); break;
  case "15 22"   : do_R2P(); break;
  case "15 23"   : do_ln(); break;
  case "15 24"   : do_log(); break;
  case "15 25"   : do_10pow(); break;
 
  case "31"      : do_enter(); break;
  case "32"      : do_CHS(); break;
  case "33"      : do_EEX(); break;
  case "34"      : do_clx(); break;
  case "15 32"   : do_sqrt(); break;
  case "15 33"   : do_pi(); break;
  case "15 34"   : do_clr(); break;
 
  case "41"      : do_subtract(); break;
  case "07"      : do_num(7); break;
  case "08"      : do_num(8); break;
  case "09"      : do_num(9); break;
  case "15 41"   : do_sto("-",0); break;

  case "51"      : do_add(); break;
  case "04"      : do_num(4); break;
  case "05"      : do_num(5); break;
  case "06"      : do_num(6); break;
  case "15 51"   : do_sto("+",0); break;
 
  case "61"      : do_multiply(); break;
  case "01"      : do_num(1); break;
  case "02"      : do_num(2); break;
  case "03"      : do_num(3); break;
  case "15 61"   : do_sto("*",0); break;
 
  case "71"      : do_divide(); break;
  case "00"      : do_num(0); break;
  case "73"      : do_decimal(); break;
  case "74 00"   : do_fmt("SCI"); do_DSP(0); break;
  case "74 01"   : do_fmt("SCI"); do_DSP(1); break;
  case "74 02"   : do_fmt("SCI"); do_DSP(2); break;
  case "74 03"   : do_fmt("SCI"); do_DSP(3); break;
  case "74 04"   : do_fmt("SCI"); do_DSP(4); break;
  case "74 05"   : do_fmt("SCI"); do_DSP(5); break;
  case "74 06"   : do_fmt("SCI"); do_DSP(6); break;
  case "74 07"   : do_fmt("SCI"); do_DSP(7); break;
  case "74 08"   : do_fmt("SCI"); do_DSP(8); break;
  case "74 09"   : do_fmt("SCI"); do_DSP(9); break;
  case "74 73 00": do_fmt("FIX"); do_DSP(0); break;
  case "74 73 01": do_fmt("FIX"); do_DSP(1); break;
  case "74 73 02": do_fmt("FIX"); do_DSP(2); break;
  case "74 73 03": do_fmt("FIX"); do_DSP(3); break;
  case "74 73 04": do_fmt("FIX"); do_DSP(4); break;
  case "74 73 05": do_fmt("FIX"); do_DSP(5); break;
  case "74 73 06": do_fmt("FIX"); do_DSP(6); break;
  case "74 73 07": do_fmt("FIX"); do_DSP(7); break;
  case "74 73 08": do_fmt("FIX"); do_DSP(8); break;
  case "74 73 09": do_fmt("FIX"); do_DSP(9); break;
  case "15 71"   : do_sto("/",0); break;

  default        : alert("execute: unexpected code - "+code);
  }

  // at the end of each execute should display the value of x or of the input buffer
  // put displayVal / ib.display() code here
  // if (error) displayError(); else if (ib.hasData()) ... else displayVal(x);
  showDisplay();
}


function showDisplay() {
    if      (cs.error    ) displayError();
    else if (ib.hasData()) ib.display();
    else    { x= ib.get(); displayVal(x); }
}


