/*
HP21 Calculator Emulator - hpstate.js
Copyright (c) 2012-2015 Greg Sydney-Smith

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

Revision History:
2015-03-29 Release 1.07, Updated license terms.
2013-01-01 From HP29 version.
2012-12-24 Initial release.
*/

/*
   auto_enter:
   "The stack is automatically raised by an entry into x or by RCL
   unless the entry immediately follows CLx or ENTER."
*/

// display width = 12

function CalcState (mems,flags) {

    this.t = 0;
    this.z = 0;
    this.y = 0;
    this.x = 0;
    this.lastX = 0;         // myLastX

    this.fmt = "FIX";       // calcFmt
    this.dsp = 2;           // calcDSP
    this.angleMode = "DEG"; // calcAngleMode;

    this.mem   = [];        // calcMem
    this.flag  = [];        // calcFlags

    this.power_mode=1;
    this.prgm_mode =0;      // prgm_mode
    this.low_power = false;
    this.show_dp = true;

    this.busy = false;      // calcBusy
    this.btnID   = -1;
    this.btnStep =  0;
    this.auto_enter=1;      // this causes the current x value to be pushed up the stack (->y, y->z, z->t) by a new value eg h pi, rck 6, ...
    this.error     =0;

    for (var i=0; i<mems;  i++) this.mem[ i]= 0;
    for (var i=0; i<flags; i++) this.flag[i]= 0;

    this.btnStart = function (process,period) {
        if (this.busy) return;
        this.busy   = true;
        this.btnStep= 0;
        this.btnID  = setInterval(process,period);
    };

    this.btnEnd = function () {
        clearInterval(this.btnID);
        this.btnStep=  0;
        this.btnID  = -1;
        this.busy   = false;
    };
    
}

