/*
HP21 Calculator Emulator - hpscan.js
Copyright (c) 2012-2015 Greg Sydney-Smith

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

Revision History:
2015-03-29 Release 1.07, Updated license terms.
2013-01-01 Add div(x,y,w,h,frac).
2012-03-13 Initial release.
*/

function Resizer() {
    this.dw= document.documentElement.clientWidth -4;
    this.dh= document.documentElement.clientHeight-4;
    var aspect_width = this.dw;
    var aspect_height= this.dh;
    this.aw= this.dw;
    this.ah= this.dh;
    
    this.setAspectRatio = function (w,h) {
        aspect_width = w;  // units are independent of device pixels
        aspect_height= h;  // could be 10000 or 0.794
    }

    this.resize = function () {
        this.dw= document.documentElement.clientWidth -4; // allow 2px app border
        this.dh= document.documentElement.clientHeight-4;

        var scaleX= this.dw/aspect_width;
        var scaleY= this.dh/aspect_height;
        var scale= Math.min(scaleX,scaleY);
        this.aw = parseInt(scale*aspect_width ,10);
        this.ah = parseInt(scale*aspect_height,10);
    }

    this.size  = function (x) { return parseInt(x*this.ah+0.5,10); }
    this.sizew = function (x) { return parseInt(x*this.aw+0.5,10); }

    this.resizeAppDiv = function (Id) {
        var o= document.getElementById(Id);
        o.style.marginLeft  = parseInt((this.dw-this.aw)/2,10)+"px";
        o.style.marginTop   = parseInt((this.dh-this.ah)/2,10)+"px";
        o.style.width = this.aw+"px"; // assumes 0 margin, border, padding for app
        o.style.height= this.ah+"px";
    }

    this.resizeId = function (Id,dx,dy) {
        var o= document.getElementById(Id);
        o.width =dx;
        o.height=dy;
    }

    this.resizeIdStyle = function (Id,x,y,dx,dy) {
        var o= document.getElementById(Id);
        o.style.left  = parseInt(x+0.5,10)+"px";
        o.style.top   = parseInt(y+0.5,10)+"px";
        o.style.width = contentWidth( o,dx)+"px";
        o.style.height= contentHeight(o,dy)+"px";
    }

    this.resizeDivImg = function (div,img,x,y,dx,dy) {
        this.resizeIdStyle(div,x,y,dx,dy);
        this.resizeId(img,dx,dy);
    }

    this.resizeIdFont = function (Id,dy) {
        document.getElementById(Id).style.fontSize=parseInt(dy+0.5,10)+"px";
    }

    this.resizeButton = function (id,x,y,w,h,frac) {
        var o = document.getElementById(id);
        var h0= h-2; // 1px border. cant use contentHeight() because we change padding
        var h1= parseInt(frac*h0+0.5,10);
        var h2= parseInt((h0-h1)/2,10);
        o.style.left  = parseInt(x+0.5,10)+"px";
        o.style.top   = parseInt(y+0.5,10)+"px";
        o.style.width = contentWidth( o,w)+"px";
        o.style.height= h1+"px";
        o.style.fontSize=h1+"px";
        o.style.paddingTop=    h2+"px";
        o.style.paddingBottom= h2+"px";
    }

    // use this for single line items. Centers vertically. Leaves l/r padding intact.
    // x y w h (w & h are internal so deduct any mbp) fs [lines]
    // centers so height becomes fs*lines, sets fontSize
    this.div = function (id,x,y,w,h,frac) {
        var o  = document.getElementById(id);
        var fh = parseInt(frac*h,10);
        var mid= parseInt(fh,10);       // for multilines set lineHeight=1.2 and add .2*fh*(lines-1)
        var top= parseInt((h-mid)/2,10);
        var bot= parseInt(h-top-mid,10);
        o.style.left  = parseInt(x,10)+"px";
        o.style.top   = parseInt(y,10)+"px";
        o.style.width = parseInt(w,10)+"px";
        o.style.height= mid+"px";
        o.style.fontSize=fh+"px";
        o.style.paddingTop=    top+"px";
        o.style.paddingBottom= bot+"px";
    }

    function contentWidth(o,dx) {
        var w= parseInt(dx+0.5,10);
        var deducts = [ o.style.marginLeft, o.style.borderLeft, o.style.paddingLeft,
               o.style.marginRight, o.style.borderRight, o.style.paddingRight];
        for (var i=0; i<deducts.length; i++) {
            var x = parseInt(deducts[i],10); if (isNaN(x)) x=0;
            w -= x;
        }
        return w;
    }
    function contentHeight(o,dy) {
        var h= parseInt(dy+0.5,10);
        var deducts = [ o.style.marginTop, o.style.borderTop, o.style.paddingTop,
               o.style.marginBottom, o.style.borderBottom, o.style.paddingBottom];
        for (var i=0; i<deducts.length; i++) {
            var x = parseInt(deducts[i],10); if (isNaN(x)) x=0;
            h -= x;
        }
        return h;
    }
}
