(function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z=function(t,e){return function(){return t.apply(e,arguments)}},D=function(t,e){for(var r in e){if(O.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},O={}.hasOwnProperty;w="#define M_PI 3.1415926535897932384626433832795\n\nfloat easeInOutSine(float pos) {\n#ifdef FLOW\n    return pos;\n#else\n    return 0.5 * (1.0 - cos(M_PI * pos));\n#endif\n}";C=w+"uniform float deltaAngle;\nuniform float scale;\nuniform float time;\nuniform float duration;\nuniform float scaleZ;\n\nvec4 getPointSample(vec4 xyzw);\n\nvec4 rotate(vec4 xyzw) {\n    vec4 point = getPointSample(xyzw);\n\n    float start = point.w;\n    float pos = (time - start) / abs(duration);\n    if(duration < 0.0) pos = 1.0 - pos;\n    if(pos < 0.0) return vec4(point.xyz, 0.0);\n    if(pos > 1.0) pos = 1.0;\n    pos = easeInOutSine(pos);\n    float c = cos(deltaAngle * pos);\n    float s = sin(deltaAngle * pos);\n    point.xy = vec2(point.x * c - point.y * s, point.x * s + point.y * c)\n        * pow(scale, pos);\n    if(scaleZ != 0.0) point.z *= pow(scaleZ, pos);\n    return vec4(point.xyz, 0.0);\n}";b=w+"uniform float scaleX;\nuniform float scaleY;\nuniform float scaleZ;\nuniform float time;\nuniform float duration;\n\nvec4 getPointSample(vec4 xyzw);\n\nvec4 rotate(vec4 xyzw) {\n    vec4 point = getPointSample(xyzw);\n\n    float start = point.w;\n    float pos = (time - start) / abs(duration);\n    if(duration < 0.0) pos = 1.0 - pos;\n    if(pos < 0.0) return vec4(point.xyz, 0.0);\n    if(pos > 1.0) pos = 1.0;\n\n    pos = easeInOutSine(pos);\n    point.x *= pow(scaleX, pos);\n    point.y *= pow(scaleY, pos);\n    if(scaleZ != 0.0) point.z *= pow(scaleZ, pos);\n    return vec4(point.xyz, 0.0);\n}";L=w+"uniform float scale;\nuniform float translate;\nuniform float time;\nuniform float duration;\nuniform float scaleZ;\n\nvec4 getPointSample(vec4 xyzw);\n\nvec4 shear(vec4 xyzw) {\n    vec4 point = getPointSample(xyzw);\n\n    float start = point.w;\n    float pos = (time - start) / abs(duration);\n    if(duration < 0.0) pos = 1.0 - pos;\n    if(pos < 0.0) return vec4(point.xyz, 0.0);\n    if(pos > 1.0) pos = 1.0;\n\n    pos = easeInOutSine(pos);\n    float s = pow(scale, pos);\n    point.x  = s * (point.x + translate * pos * point.y);\n    point.y *= s;\n    if(scaleZ != 0.0) point.z *= pow(scaleZ, pos);\n    return vec4(point.xyz, 0.0);\n}";x=w+"uniform float time;\nuniform float duration;\n\nvec4 getPointSample(vec4 xyzw);\nvec4 getColorSample(vec4 xyzw);\n\nvec3 hsv2rgb(vec3 c) {\n  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\n  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\n\n#ifdef FLOW\n#define TRANSITION 0.0\n#else\n#define TRANSITION 0.2\n#endif\n\nvec4 getColor(vec4 xyzw) {\n    vec4 color = getColorSample(xyzw);\n    vec4 point = getPointSample(xyzw);\n\n    float start = point.w;\n    float pos, ease;\n    pos = (time - start) / abs(duration);\n    if(duration < 0.0) pos = 1.0 - pos;\n    if(pos < 0.0) pos = 0.0;\n    else if(pos > 1.0) pos = 1.0;\n\n    if(pos < TRANSITION) {\n        ease = easeInOutSine(pos / TRANSITION);\n        color.w *= ease * 0.6 + 0.4;\n        color.y *= ease * 0.6 + 0.4;\n    }\n    else if(pos > 1.0 - TRANSITION) {\n        ease = easeInOutSine((1.0 - pos) / TRANSITION);\n        color.w *= ease * 0.6 + 0.4;\n        color.y *= ease * 0.6 + 0.4;\n    }\n    return vec4(hsv2rgb(color.xyz), color.w);\n}";P=w+"uniform float time;\nuniform float small;\nuniform float duration;\n\nvec4 getPointSample(vec4 xyzw);\n\n#ifdef FLOW\n#define TRANSITION 0.0\n#else\n#define TRANSITION 0.2\n#endif\n#define BIG (small * 7.0 / 5.0)\n\nvec4 getSize(vec4 xyzw) {\n    vec4 point = getPointSample(xyzw);\n\n    float start = point.w;\n    float pos, ease, size = BIG;\n    pos = (time - start) / abs(duration);\n    if(duration < 0.0) pos = 1.0 - pos;\n    if(pos < 0.0) pos = 0.0;\n    else if(pos > 1.0) pos = 1.0;\n\n    if(pos < TRANSITION) {\n        ease = easeInOutSine(pos / TRANSITION);\n        size = small * (1.0-ease) + BIG * ease;\n    }\n    else if(pos > 1.0 - TRANSITION) {\n        ease = easeInOutSine((1.0 - pos) / TRANSITION);\n        size = small * (1.0-ease) + BIG * ease;\n    }\n    return vec4(size, 0.0, 0.0, 0.0);\n}";h=function(t,e,r){var i,n,o,s,a;n=Math.floor(t*6);i=t*6-n;o=r*(1-e);s=r*(1-i*e);a=r*(1-(1-i)*e);switch(n%6){case 0:return[r,a,o];case 1:return[s,r,o];case 2:return[o,r,a];case 3:return[o,s,r];case 4:return[a,o,r];case 5:return[r,o,s]}};R=function(t,e){return function(r){return Math.pow(e,r)*Math.pow(t,1-r)}};M=function(t,e){return function(r){return e*r+t*(1-r)}};S=function(t,e,r){return function(i){return Math.pow(i,r)*(e-t)+t}};T=function(t,e,r){return function(i){return Math.floor(Math.random()*(r+1))*(e-t)/r+t}};k=function(t){return t[Math.floor(Math.random()*t.length)]};A=function(){return k([-1,1])};H=function(t,e){var r,i,n;i=[];for(r in e){n=e[r];if(e.hasOwnProperty(r)){i.push(t[r]=n)}else{i.push(void 0)}}return i};l=function(){function t(t){this.randomizeCoords=z(this.randomizeCoords,this);this.loadDynamics=z(this.loadDynamics,this);this.updateView=z(this.updateView,this);this.setCoords=z(this.setCoords,this);var e,r,i,n,o,s,a,u,l;if(t==null){t={}}this.is3D=(n=t.is3D)!=null?n:false;this.axisColors=(o=(s=t.axisColors)!=null?s.slice():void 0)!=null?o:[];this.refColor=(a=t.refColor)!=null?a:"rgb(80, 120, 255)";this.timer=(u=t.timer)!=null?u:true;this.axisOpts={end:false,width:3,zBias:-1,depth:1,color:"black",range:[-10,10]};H(this.axisOpts,(l=t.axisOpts)!=null?l:{});if((e=this.axisColors)[0]==null){e[0]=[0,0,0,.3]}if((r=this.axisColors)[1]==null){r[1]=[0,0,0,.3]}if((i=this.axisColors)[2]==null){i[2]=[0,0,0,.3]}this.mathbox=null;this.view0=null;this.view=null;this.initialized=false;this.shaderElt=null;this.linesElt=null;this.linesDataElt=null}t.prototype.setCoords=function(t,e,r){var i,n,o,s;if(t[2]==null){t[2]=0}if(e[2]==null){e[2]=0}if(r==null){r=[0,0,1]}this.v1=t;this.v2=e;this.v3=r;this.coordMat=(new THREE.Matrix4).set(t[0],e[0],r[0],0,t[1],e[1],r[1],0,t[2],e[2],r[2],0,0,0,0,1);i=this.coordMatInv=(new THREE.Matrix4).getInverse(this.coordMat);n=[new THREE.Vector3(1,1,1),new THREE.Vector3(-1,1,1),new THREE.Vector3(1,-1,1),new THREE.Vector3(1,1,-1)].map(function(t){return t.applyMatrix4(i)});o=Math.max.apply(null,n.map(function(t){return t.length()}));this.extents={rad:o,x:Math.max.apply(null,n.map(function(t){return Math.abs(t.x)})),y:Math.max.apply(null,n.map(function(t){return Math.abs(t.y)})),z:Math.max.apply(null,n.map(function(t){return Math.abs(t.z)}))};return(s=this.controller)!=null?s.recomputeExtents():void 0};t.prototype.updateView=function(t,e){var r,i,n,o,s,a,u,l,h,f,c,p,d,m;if(this.mathbox==null){this.mathbox=t}if(this.view0==null){this.view0=e}if(this.view){this.view.set("matrix",this.coordMat)}else{this.view=this.view0.transform({matrix:this.coordMat});d=this.is3D?[1,2,3]:[1,2];for(s=0,a=d.length;s<a;s++){o=d[s];this.axisOpts.axis=o;this.axisOpts.color=this.axisColors[o-1];this.axisOpts.opacity=this.axisColors[o-1][3];this.view.axis(this.axisOpts)}}r=this.mathbox._context.canvas;n=this.controller.flow;h=this.controller.numPointsRow;u=this.controller.numPointsCol;l=this.controller.numPointsDep;if(this.initialized){f=this.current.shaderParams();if(n){f.code="#define FLOW\n"+f.code}this.shaderElt.set(f);return this.linesDataElt.set(this.current.linesParams())}else{c={id:"points-orig",channels:4,width:h,height:u,data:this.controller.points,live:false};if(this.is3D){c.depth=l;p=this.view.voxel}else{p=this.view.matrix}this.pointsElt=p(c);f=this.current.shaderParams();if(n){f.code="#define FLOW\n"+f.code}i=this.controller;if(this.timer){m=function(t){return i.curTime=t}}else{m=function(t){return i.curTime}}this.shaderElt=this.pointsElt.shader(f,{time:m,duration:function(t){return function(){return t.controller.duration*t.controller.direction}}(this)});this.shaderElt.resample({id:"points"});c={channels:4,width:h,height:u,data:this.controller.colors,live:false};if(this.is3D){c.depth=l;p=this.view.voxel}else{p=this.view.matrix}p(c).shader({code:(n?"#define FLOW\n":"")+x,sources:[this.pointsElt]},{time:function(){return i.curTime},duration:function(t){return function(){return t.controller.duration*t.controller.direction}}(this)}).resample({id:"colors"});this.view0.shader({code:(n?"#define FLOW\n":"")+P},{time:function(){return i.curTime},small:function(){return 5/739*r.clientWidth},duration:function(t){return function(){return t.controller.duration*t.controller.direction}}(this)}).resample({source:this.pointsElt,id:"sizes"});this.view.point({points:"#points",color:"white",colors:"#colors",size:1,sizes:"#sizes",zBias:1,zIndex:2});this.linesDataElt=this.view.matrix(this.current.linesParams());this.linesElt=this.view.line({color:this.refColor,width:this.is3D?5:2,opacity:this.is3D?.8:.4,zBias:0,zIndex:1});return this.initialized=true}};t.prototype.loadDynamics=function(t){this.current=t;return this.matrixOrigCoords=(new THREE.Matrix4).multiply(this.coordMat).multiply(this.current.stepMat).multiply(this.coordMatInv)};t.prototype.randomizeCoords=function(){var t,e,r,i,n,o;r=[0,0];i=[0,0];t=M(.5,2);e=t(Math.random());n=Math.random()*2*π;r[0]=Math.cos(n)*e;r[1]=Math.sin(n)*e;o=A()*M(π/4,3*π/4)(Math.random());e=t(Math.random());i[0]=Math.cos(n+o)*e;i[1]=Math.sin(n+o)*e;return this.setCoords(r,i)};return t}();s=function(){function t(t){this.delay=z(this.delay,this);this.start=z(this.start,this);this.unStep=z(this.unStep,this);this.step=z(this.step,this);this.goForwards=z(this.goForwards,this);this.goBackwards=z(this.goBackwards,this);this.loadDynamics=z(this.loadDynamics,this);this.recomputeExtents=z(this.recomputeExtents,this);this.addView=z(this.addView,this);var e,r,i,n,o,s,a;if(t==null){t={}}this.numPointsRow=(e=t.numPointsRow)!=null?e:50;this.numPointsCol=(r=t.numPointsCol)!=null?r:100;this.numPointsDep=(i=t.numPointsDep)!=null?i:10;this.duration=(n=t.duration)!=null?n:3;this.continuous=(o=t.continuous)!=null?o:true;this.is3D=(s=t.is3D)!=null?s:false;this.flow=(a=t.flow)!=null?a:false;this.views=[];this.extents={rad:0,x:0,y:0,z:0};this.current=null;this.direction=1;if(!this.is3D){this.numPointsDep=1}this.numPoints=this.numPointsRow*this.numPointsCol*this.numPointsDep-1;this.curTime=0;this.startTime=-this.duration;this.points=[[0,0,0,1e15]];this.colors=[[0,0,0,1]].concat(function(){var t,e,r;r=[];for(t=0,e=this.numPoints;0<=e?t<e:t>e;0<=e?t++:t--){r.push([Math.random(),1,.7,1])}return r}.call(this))}t.prototype.addView=function(t){t.controller=this;this.views.push(t);return this.recomputeExtents()};t.prototype.recomputeExtents=function(){var t,e,r,i,n,o;this.extents={rad:0,x:0,y:0,z:0};i=this.views;n=[];for(t=0,e=i.length;t<e;t++){o=i[t];n.push(function(){var t,e,i,n;i=["rad","x","y","z"];n=[];for(e=0,t=i.length;e<t;e++){r=i[e];n.push(this.extents[r]=Math.max(this.extents[r],o.extents[r]))}return n}.call(this))}return n};t.prototype.loadDynamics=function(t,e){var r,i,n,o,s,a,u,l;if(e==null){e={}}if(e.onPlane==null){e.onPlane=1/this.numPointsDep}this.current=new t(this.extents,e);for(r=i=1,s=this.numPoints;1<=s?i<=s:i>=s;r=1<=s?++i:--i){this.points[r]=this.current.newPoint();this.points[r][3]=this.curTime+this.delay(true)}a=this.views;u=[];for(o=0,n=a.length;o<n;o++){l=a[o];u.push(l.loadDynamics(this.current))}return u};t.prototype.goBackwards=function(){var t,e,r,i;i=this.points;for(t=0,e=i.length;t<e;t++){r=i[t];this.current.stepMat.applyToVector3Array(r,0,3)}return this.direction=-1};t.prototype.goForwards=function(){var t,e,r,i;i=this.points;for(t=0,e=i.length;t<e;t++){r=i[t];this.current.inverse.stepMat.applyToVector3Array(r,0,3)}return this.direction=1};t.prototype.step=function(){var t,e,r,i,n,o,s,a,u;if(!this.continuous&&!this.flow){if(this.startTime+this.duration>this.curTime){return}this.startTime=this.curTime}if(this.direction===-1){this.goForwards()}s=this.points;for(t=e=0,r=s.length;e<r;t=++e){o=s[t];if(t===0){continue}if(o[3]+this.duration<=this.curTime){this.current.stepMat.applyToVector3Array(o,0,3);this.current.updatePoint(o);o[3]=this.curTime+this.delay()}}a=this.views;for(n=0,i=a.length;n<i;n++){u=a[n];u.pointsElt.set("data",[]);u.pointsElt.set("data",this.points)}return null};t.prototype.unStep=function(){var t,e,r,i,n,o,s,a,u,l;if(!this.continuous&&!this.flow){if(this.startTime+this.duration>this.curTime){return}this.startTime=this.curTime}if(this.direction===1){this.goBackwards()}e=this.current.inverse;a=this.points;for(t=r=0,i=a.length;r<i;t=++r){s=a[t];if(t===0){continue}if(s[3]+this.duration<=this.curTime){e.updatePoint(s);e.stepMat.applyToVector3Array(s,0,3);s[3]=this.curTime+this.delay()}}u=this.views;for(o=0,n=u.length;o<n;o++){l=u[o];l.pointsElt.set("data",[]);l.pointsElt.set("data",this.points)}return null};t.prototype.start=function(t){if(t==null){t=100}return setInterval(this.step,t)};t.prototype.delay=function(t){var e,r;if(!this.continuous){if(t){return-this.duration}else{return 0}}r=this.numPoints/1e3;e=Math.random()*r;if(t){return e-.5*r}else{return e}};return t}();u=function(){function t(t,e){var r,i;this.extents=t;this.linesParams=z(this.linesParams,this);this.updatePoint=z(this.updatePoint,this);this.newPoint=z(this.newPoint,this);this.timeToLeave=z(this.timeToLeave,this);this.scaleZ=(r=e.scaleZ)!=null?r:0;this.onPlane=(i=e.onPlane)!=null?i:1/20;if(Math.abs(this.scaleZ)<1e-5){this.is3D=false;this.zAtTime=function(t,e){return 0};this.timeToLeaveZ=function(t){return Infinity};this.needsResetZ=function(t){return function(t){return false}}(this)}else if(Math.abs(this.scaleZ-1)<1e-5){this.is3D=true;this.scaleZ=1;this.origLerpZ=M(.01,this.extents.z);this.zAtTime=function(t,e){return t};this.timeToLeaveZ=function(t){return Infinity};this.needsResetZ=function(t){return function(t){return false}}(this)}else if(this.scaleZ<1){this.is3D=true;this.origLerpZ=R(.01,this.extents.z/this.scaleZ);this.newLerpZ=R(this.extents.z,this.extents.z/this.scaleZ);this.zAtTime=function(t){return function(e,r){return e*Math.pow(t.scaleZ,r)}}(this);this.timeToLeaveZ=function(t){return function(e){return Math.log(.01/Math.abs(e))/Math.log(t.scaleZ)}}(this);this.needsResetZ=function(t){return function(t){return Math.abs(t)<.01}}(this)}else if(this.scaleZ>1){this.is3D=true;this.origLerpZ=R(.01/this.scaleZ,this.extents.z);this.newLerpZ=R(.01/this.scaleZ,.01);this.zAtTime=function(t){return function(e,r){return e*Math.pow(t.scaleZ,r)}}(this);this.timeToLeaveZ=function(t){return function(e){return Math.log(t.extents.z/Math.abs(e))/Math.log(t.scaleZ)}}(this);this.needsResetZ=function(t){return function(e){return Math.abs(e)>t.extents.z}}(this)}this.invScaleZ=this.is3D?1/this.scaleZ:0}t.prototype.makeStepMat=function(t,e,r,i){var n;n=this.scaleZ;this.stepMat22=[[t,e],[r,i]];return this.stepMat=(new THREE.Matrix4).set(t,e,0,0,r,i,0,0,0,0,n,0,0,0,0,1)};t.prototype.timeToLeave=function(t){var e;e=this.timeToLeaveZ(t[2]);if(isFinite(e)&&e>=0&&e<=25){return e}e=this.timeToLeaveXY(t[0],t[1]);if(e>=0&&e<=25){return e}else{return Infinity}};t.prototype.newPoint=function(){var t,e;if(this.is3D){if(Math.random()<this.onPlane){e=0}else{e=A()*this.origLerpZ(Math.random())}}else{e=0}t=this.origDistr();return[t[0],t[1],e,0]};t.prototype.updatePoint=function(t){var e;if(this.needsResetXY(t[0],t[1])){e=this.newDistr(t),t[0]=e[0],t[1]=e[1]}if(!(this.is3D&&this.scaleZ!==1)){return t}if(t[2]===0){return t}if(this.needsResetZ(t[2])){t[2]=A()*this.newLerpZ(Math.random())}return t};t.prototype.linesParams=function(){var t;t=this.makeReference();return{channels:2,height:t.length,width:t[0].length,items:t[0][0].length,live:false,data:t}};t.prototype.shaderParams=function(t){if(t.uniforms==null){t.uniforms={}}t.uniforms.scaleZ={type:"f",value:this.scaleZ};return t};return t}();o=function(t){D(e,t);function e(t,r){this.shaderParams=z(this.shaderParams,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);var i,n;e.__super__.constructor.call(this,t,r);if(r==null){r={}}this.θ=(i=r.θ)!=null?i:A()*M(π/6,5*π/6)(Math.random());this.scale=(n=r.scale)!=null?n:this.randomScale();this.logScale=Math.log(this.scale);this.makeStepMat(Math.cos(this.θ)*this.scale,-Math.sin(this.θ)*this.scale,Math.sin(this.θ)*this.scale,Math.cos(this.θ)*this.scale);this.makeDistributions(r)}e.prototype.origDistr=function(){return this.distr(this.origDist)};e.prototype.newDistr=function(){return this.distr(this.newDist)};e.prototype.distr=function(t){var e,r;e=t(Math.random());r=Math.random()*2*π;return[Math.cos(r)*e,Math.sin(r)*e]};e.prototype.shaderParams=function(){return e.__super__.shaderParams.call(this,{code:C,uniforms:{deltaAngle:{type:"f",value:this.θ},scale:{type:"f",value:this.scale}}})};return e}(u);n=function(t){D(e,t);e.prototype.descr=function(){return"Ovals"};function e(t,r){this.makePath=z(this.makePath,this);this.makeReference=z(this.makeReference,this);this.makeDistributions=z(this.makeDistributions,this);this.randomScale=z(this.randomScale,this);var i;e.__super__.constructor.call(this,t,r);this.inverse=(i=r!=null?r.inverse:void 0)!=null?i:new e(t,{"θ":-this.θ,scale:1/this.scale,inverse:this,scaleZ:this.invScaleZ})}e.prototype.randomScale=function(){return 1};e.prototype.makeDistributions=function(t){return this.newDist=this.origDist=S(.01,this.extents.rad,1/2)};e.prototype.makeReference=function(){var t,e,r,i,n,o,s,a,u,l,h;a=[];for(h=t=0,r=2*π,i=π/72;i>0?t<r:t>r;h=t+=i){u=[];for(l=e=n=this.extents.rad/10,o=this.extents.rad,s=this.extents.rad/10;s>0?e<o:e>o;l=e+=s){u.push([l*Math.cos(h),l*Math.sin(h)])}a.push(u)}a.push(a[0]);return[a]};e.prototype.makePath=function(t,e){var r,i,n,o,s,a,u,l;u=this.timeToLeave(t);if(!isFinite(u)){u=2*π*(e.length+1)/(e.length*Math.abs(this.θ))}a=u*this.θ;for(i=n=0,o=e.length;0<=o?n<o:n>o;i=0<=o?++n:--n){l=a*i/e.length;r=Math.cos(l);s=Math.sin(l);e[i]=[r*t[0]-s*t[1],s*t[0]+r*t[1],this.zAtTime(t[2],u*i/e.length)]}return e};e.prototype.needsResetXY=function(t,e){return false};e.prototype.timeToLeaveXY=function(t,e){return Infinity};return e}(o);y=function(t){D(e,t);function e(){this.makePath=z(this.makePath,this);this.makeReference=z(this.makeReference,this);return e.__super__.constructor.apply(this,arguments)}e.prototype.makeReference=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;c=[];t=.05;m=this.scale>1?this.scale:1/this.scale;n=(Math.log(this.extents.rad)-Math.log(t))/Math.log(m);p=Math.ceil(this.θ*n/2*π);e=this.direction;for(r=s=0,l=p;0<=l?s<=l:s>=l;r=0<=l?++s:--s){d=[];for(g=a=0;a<=100;g=++a){y=(r+g/100)*2*π;v=t*Math.pow(m,y/this.θ);i=[];for(o=u=0,h=2*π,f=π/4;f>0?u<h:u>h;o=u+=f){i.push([v*Math.cos(e*(y+o)),v*Math.sin(e*(y+o))])}d.push(i)}c.push(d)}return c};e.prototype.makePath=function(t,e){var r,i,n,o,s,a,u,l,h,f;h=this.timeToLeave(t);if(!isFinite(h)){h=2*π*(e.length+1)/(e.length*Math.abs(this.θ))}l=h*this.θ;for(i=n=0,o=e.length;0<=o?n<o:n>o;i=0<=o?++n:--n){f=l*i/e.length;r=Math.cos(f);s=Math.sin(f);u=h*i/e.length;a=Math.pow(this.scale,u);e[i]=[a*r*t[0]-a*s*t[1],a*s*t[0]+a*r*t[1],this.zAtTime(t[2],u)]}return e};return e}(o);E=function(t){D(e,t);e.prototype.descr=function(){return"Spiral in"};function e(t,r){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeDistributions=z(this.makeDistributions,this);var i;e.__super__.constructor.call(this,t,r);this.direction=-1;this.inverse=(i=r!=null?r.inverse:void 0)!=null?i:new _(t,{"θ":-this.θ,scale:1/this.scale,inverse:this,dist:this.distType,scaleZ:this.invScaleZ})}e.prototype.randomScale=function(){return M(.3,.8)(Math.random())};e.prototype.makeDistributions=function(t){var e,r,i;this.close=.01;this.medium=this.extents.rad;this.far=this.extents.rad/this.scale;this.distType=(i=t.dist)!=null?i:k(["cont","disc"]);switch(this.distType){case"cont":this.origDist=R(this.close,this.far);return this.newDist=R(this.medium,this.far);case"disc":r=[];e=this.far;while(e>this.close){r.push(e);e*=this.scale}this.origDist=function(t){return r[Math.floor(t*r.length)]};return this.newDist=function(t){return function(e){return t.far}}(this)}};e.prototype.needsResetXY=function(t,e){return t*t+e*e<this.close*this.close};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(.01)-.5*Math.log(t*t+e*e))/this.logScale};return e}(y);_=function(t){D(e,t);e.prototype.descr=function(){return"Spiral out"};function e(t,r){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeDistributions=z(this.makeDistributions,this);this.randomScale=z(this.randomScale,this);var i;e.__super__.constructor.call(this,t,r);this.direction=1;this.inverse=(i=r!=null?r.inverse:void 0)!=null?i:new E(t,{"θ":-this.θ,scale:1/this.scale,inverse:this,dist:this.distType,scaleZ:this.invScaleZ})}e.prototype.randomScale=function(){return M(1/.8,1/.3)(Math.random())};e.prototype.makeDistributions=function(t){var e,r,i;this.veryClose=.01/this.scale;this.close=.01;this.medium=this.extents.rad;this.distType=(i=t.dist)!=null?i:k(["cont","disc"]);switch(this.distType){case"cont":this.origDist=R(this.veryClose,this.medium);return this.newDist=R(this.veryClose,this.close);case"disc":r=[];e=this.veryClose;while(e<this.medium){r.push(e);e*=this.scale}this.origDist=function(t){return r[Math.floor(t*r.length)]};return this.newDist=function(t){return function(e){return t.veryClose}}(this)}};e.prototype.needsResetXY=function(t,e){return t*t+e*e>this.medium*this.medium};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(this.extents.rad)-.5*Math.log(t*t+e*e))/this.logScale};return e}(y);a=function(t){D(e,t);function e(t,r){this.makePath=z(this.makePath,this);this.shaderParams=z(this.shaderParams,this);this.swap=z(this.swap,this);var i,n;e.__super__.constructor.call(this,t,r);if(r==null){r={}}this.swapped=false;this.makeScales(r);i=this.λ1;if(r.negate1){i*=-1}n=this.λ2;if(r.negate2){n*=-1}if(this.swapped){this.makeStepMat(n,0,0,i)}else{this.makeStepMat(i,0,0,n)}}e.prototype.swap=function(){var t;t=[this.λ1,this.λ2],this.λ2=t[0],this.λ1=t[1];this.extents={rad:this.extents.rad,x:this.extents.y,y:this.extents.x,z:this.extents.z};return this.swapped=true};e.prototype.shaderParams=function(){return e.__super__.shaderParams.call(this,{code:b,uniforms:{scaleX:{type:"f",value:this.swapped?this.λ2:this.λ1},scaleY:{type:"f",value:this.swapped?this.λ1:this.λ2}}})};e.prototype.makePath=function(t,e){var r,i,n,o,s,a,u;u=this.timeToLeave(t);if(!isFinite(u)){u=25}if(this.swapped){o=this.λ2;s=this.λ1}else{o=this.λ1;s=this.λ2}for(r=i=0,n=e.length;0<=n?i<n:i>n;r=0<=n?++i:--i){a=u*r/e.length;e[r]=[t[0]*Math.pow(o,a),t[1]*Math.pow(s,a),this.zAtTime(t[2],a)]}return e};return e}(u);f=function(t){D(e,t);e.prototype.descr=function(){return"Hyperbolas"};function e(t,r){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeReference=z(this.makeReference,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);this.makeScales=z(this.makeScales,this);var i,n,o,s;e.__super__.constructor.call(this,t,r);i=this.swapped?[this.λ2,this.λ1]:[this.λ1,this.λ2],o=i[0],s=i[1];this.inverse=(n=r!=null?r.inverse:void 0)!=null?n:new e(t,{"λ1":1/o,"λ2":1/s,inverse:this,scaleZ:this.invScaleZ})}e.prototype.makeScales=function(t){var e,r;this.λ1=(e=t.λ1)!=null?e:M(.3,.8)(Math.random());this.λ2=(r=t.λ2)!=null?r:M(1/.8,1/.3)(Math.random());if(this.λ1>this.λ2){this.swap()}this.logScaleX=Math.log(this.λ1);this.logScaleY=Math.log(this.λ2);this.close=.05;this.closeR=Math.pow(this.close,this.logScaleY-this.logScaleX);this.farR=Math.pow(this.extents.x,this.logScaleY)*Math.pow(this.extents.y,-this.logScaleX);return this.lerpR=M(this.closeR,this.farR)};e.prototype.origDistr=function(){return this.distr(true)};e.prototype.newDistr=function(){return this.distr(false)};e.prototype.distr=function(t){var e,r,i,n;r=this.lerpR(Math.random());if(t){e=Math.pow(r*Math.pow(this.extents.y,this.logScaleX),1/this.logScaleY);i=R(e,this.extents.x/this.λ1)(Math.random())}else{i=R(this.extents.x,this.extents.x/this.λ1)(Math.random())}n=Math.pow(1/r*Math.pow(i,this.logScaleY),1/this.logScaleX);if(this.swapped){return[A()*n,A()*i]}else{return[A()*i,A()*n]}};e.prototype.makeReference=function(){var t,e,r,i,n,o,s,a,u,l,h;s=[];for(u=r=0;r<20;u=++r){o=this.lerpR(u/20);t=Math.pow(o*Math.pow(this.extents.y,this.logScaleX),1/this.logScaleY);i=R(t,this.extents.x);a=[];for(e=n=0;n<=100;e=++n){l=i(e/100);h=Math.pow(1/o*Math.pow(l,this.logScaleY),1/this.logScaleX);if(this.swapped){a.push([[h,l],[h,-l],[-h,l],[-h,-l]])}else{a.push([[l,h],[-l,h],[l,-h],[-l,-h]])}}s.push(a)}return s};e.prototype.needsResetXY=function(t,e){return Math.abs(this.swapped?t:e)>this.extents.y};e.prototype.timeToLeaveXY=function(t,e){if(this.swapped){e=t}return(Math.log(this.extents.y)-Math.log(Math.abs(e)))/this.logScaleY};return e}(a);r=function(t){D(e,t);function e(){this.makeReference=z(this.makeReference,this);this.makeScales=z(this.makeScales,this);return e.__super__.constructor.apply(this,arguments)}e.prototype.makeScales=function(t){var e,r;this.logScaleX=Math.log(this.λ1);this.logScaleY=Math.log(this.λ2);r=.05;this.lerpR=function(t){t=M(r,1-r)(t);return Math.pow(t,this.logScaleY)*Math.pow(1-t,-this.logScaleX)};e=this.logScaleY/this.logScaleX;this.sMin=.01;this.sMax=Math.pow(this.extents.x,e)+this.extents.y;this.yValAt=function(t,e){return e/(1+Math.pow(t,1/this.logScaleX))};return this.xOfY=function(t,e){return Math.pow(e*Math.pow(t,this.logScaleX),1/this.logScaleY)}};e.prototype.makeReference=function(){var t,e,r,i,n,o,s,a,u;o=[];for(t=e=0;e<15;t=++e){n=this.lerpR(t/15);r=R(.01,this.extents.y);s=[];for(t=i=0;i<=100;t=++i){u=r(t/100);a=this.xOfY(u,n);s.push([[a,u],[-a,u],[a,-u],[-a,-u]])}o.push(s)}return o};return e}(a);t=function(t){D(e,t);e.prototype.descr=function(){return"Attracting point"};function e(t,r){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);this.makeScales=z(this.makeScales,this);var i;e.__super__.constructor.call(this,t,r);this.inverse=(i=r!=null?r.inverse:void 0)!=null?i:new c(t,{"λ1":1/this.λ1,"λ2":1/this.λ2,inverse:this,scaleZ:this.invScaleZ})}e.prototype.makeScales=function(t){var r,i;this.λ1=(r=t.λ1)!=null?r:M(.3,.9)(Math.random());this.λ2=(i=t.λ2)!=null?i:M(.3,this.λ1)(Math.random());if(this.λ1<this.λ2){throw"Must pass smaller eigenvalue second"}return e.__super__.makeScales.call(this,t)};e.prototype.origDistr=function(){return this.distr(true)};e.prototype.newDistr=function(){return this.distr(false)};e.prototype.distr=function(t){var e,r,i,n,o;i=this.lerpR(Math.random());r=this.yValAt(i,this.sMax/this.λ2);if(t){e=this.yValAt(i,this.sMin)}else{e=this.yValAt(i,this.sMax)}o=R(e,r)(Math.random());n=this.xOfY(o,i);return[A()*n,A()*o]};e.prototype.needsResetXY=function(t,e){return Math.abs(e)<.01};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(.01)-Math.log(Math.abs(e)))/this.logScaleY};return e}(r);c=function(e){D(r,e);r.prototype.descr=function(){return"Repelling point"};function r(e,i){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);this.makeScales=z(this.makeScales,this);var n;r.__super__.constructor.call(this,e,i);this.inverse=(n=i!=null?i.inverse:void 0)!=null?n:new t(e,{"λ1":1/this.λ1,"λ2":1/this.λ2,inverse:this,scaleZ:this.invScaleZ})}r.prototype.makeScales=function(t){var e,i;this.λ2=(e=t.λ2)!=null?e:M(1/.9,1/.3)(Math.random());this.λ1=(i=t.λ1)!=null?i:M(1/.9,this.λ2)(Math.random());if(this.λ1>this.λ2){throw"Must pass smaller eigenvalue first"}return r.__super__.makeScales.call(this,t)};r.prototype.origDistr=function(){return this.distr(true)};r.prototype.newDistr=function(){return this.distr(false)};r.prototype.distr=function(t){var e,r,i,n,o;i=this.lerpR(Math.random());e=this.yValAt(i,this.sMin/this.λ2);if(t){r=this.yValAt(i,this.sMax)}else{r=this.yValAt(i,this.sMin)}o=R(e,r)(Math.random());n=this.xOfY(o,i);return[A()*n,A()*o]};r.prototype.needsResetXY=function(t,e){return Math.abs(t)>this.extents.x||Math.abs(e)>this.extents.y};r.prototype.timeToLeaveXY=function(t,e){return Math.min((Math.log(this.extents.x)-Math.log(Math.abs(t)))/this.logScaleX,(Math.log(this.extents.y)-Math.log(Math.abs(e)))/this.logScaleY)};return r}(r);i=function(t){D(e,t);function e(){this.makeReference=z(this.makeReference,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);this.makeScales=z(this.makeScales,this);return e.__super__.constructor.apply(this,arguments)}e.prototype.makeScales=function(t){this.λ1=1;return this.lerpX=M(-this.extents.x,this.extents.x)};e.prototype.origDistr=function(){return this.distr(this.origLerpY)};e.prototype.newDistr=function(){return this.distr(this.newLerpY)};e.prototype.distr=function(t){var e,r;e=this.lerpX(Math.random());r=t(Math.random());return[e,A()*r]};e.prototype.makeReference=function(){var t,e,r,i,n;e=[];r=[];for(t=i=0;i<20;t=++i){n=this.lerpX((t+.5)/20);e.push([n,-this.extents.y]);r.push([n,this.extents.y])}return[[e,r]]};return e}(a);e=function(t){D(e,t);e.prototype.descr=function(){return"Attracting line"};function e(t,r){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeScales=z(this.makeScales,this);var i;e.__super__.constructor.call(this,t,r);this.inverse=(i=r!=null?r.inverse:void 0)!=null?i:new p(t,{"λ1":1/this.λ1,"λ2":1/this.λ2,inverse:this,scaleZ:this.invScaleZ})}e.prototype.makeScales=function(t){var r;e.__super__.makeScales.call(this,t);this.λ2=(r=t.λ2)!=null?r:M(.3,.8)(Math.random());this.origLerpY=R(.01,this.extents.y/this.λ2);return this.newLerpY=R(this.extents.y,this.extents.y/this.λ2)};e.prototype.needsResetXY=function(t,e){return Math.abs(e)<.01};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(.01)-Math.log(Math.abs(e)))/this.logScaleY};return e}(i);p=function(t){D(r,t);r.prototype.descr=function(){return"Repelling line"};function r(t,i){this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeScales=z(this.makeScales,this);var n;r.__super__.constructor.call(this,t,i);this.inverse=(n=i!=null?i.inverse:void 0)!=null?n:new e(t,{"λ1":1/this.λ1,"λ2":1/this.λ2,inverse:this,scaleZ:this.invScaleZ})}r.prototype.makeScales=function(t){var e;r.__super__.makeScales.call(this,t);this.λ2=(e=t.λ2)!=null?e:M(1/.8,1/.3)(Math.random());this.origLerpY=R(.01/this.λ2,this.extents.y);return this.newLerpY=R(.01/this.λ2,.01)};r.prototype.needsResetXY=function(t,e){return Math.abs(e)>this.extents.y};r.prototype.timeToLeaveXY=function(t,e){return(Math.log(this.extents.y)-Math.log(Math.abs(e)))/this.logScaleY};return r}(i);g=function(t){D(e,t);e.prototype.descr=function(){return"Shear"};function e(t,r){this.makePath=z(this.makePath,this);this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);this.makeReference=z(this.makeReference,this);this.shaderParams=z(this.shaderParams,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);var i,n;e.__super__.constructor.call(this,t,r);if(r==null){r={}}this.translate=(i=r.translate)!=null?i:A()*M(.2,2)(Math.random());this.makeStepMat(1,this.translate,0,1);this.lerpY=M(.01,this.extents.y);this.lerpY2=M(-this.extents.y,this.extents.y);this.inverse=(n=r!=null?r.inverse:void 0)!=null?n:new e(t,{translate:-this.translate,inverse:this,scaleZ:this.invScaleZ})}e.prototype.origDistr=function(){var t,e,r,i;t=this.translate;i=this.lerpY(Math.random());if(Math.random()<.005){i=0;r=M(-this.extents.x,this.extents.x)(Math.random())}else{if(t<0){r=M(-this.extents.x,this.extents.x-t*i)(Math.random())}else{r=M(-this.extents.x-t*i,this.extents.x)(Math.random())}}e=A();return[e*r,e*i]};e.prototype.newDistr=function(t){var e,r,i,n;e=this.translate;n=Math.abs(t[1]);if(e<0){i=M(this.extents.x,this.extents.x-e*n)(Math.random())}else{i=M(-this.extents.x-e*n,-this.extents.x)(Math.random())}r=A();return[r*i,r*n]};e.prototype.shaderParams=function(){return e.__super__.shaderParams.call(this,{code:L,uniforms:{scale:{type:"f",value:1},translate:{type:"f",value:this.translate}}})};e.prototype.makeReference=function(){var t,e,r,i,n;e=[];r=[];for(t=i=0;i<20;t=++i){n=this.lerpY2((t+.5)/20);e.push([-this.extents.x,n]);r.push([this.extents.x,n])}return[[e,r]]};e.prototype.needsResetXY=function(t,e){return Math.abs(t)>this.extents.x};e.prototype.timeToLeaveXY=function(t,e){var r;r=e>0?this.extents.x:-this.extents.x;return(r-t)/(this.translate*e)};e.prototype.makePath=function(t,e){var r,i,n,o,s;s=this.timeToLeave(t);if(!isFinite(s)){s=100}for(r=i=0,n=e.length;0<=n?i<n:i>n;r=0<=n?++i:--i){o=s*r/e.length;e[r]=[t[0]+o*this.translate*t[1],t[1],this.zAtTime(t[2],o)]}return e};return e}(u);d=function(t){D(e,t);function e(t,r){this.makePath=z(this.makePath,this);this.makeReference=z(this.makeReference,this);this.shaderParams=z(this.shaderParams,this);this.distr=z(this.distr,this);this.newDistr=z(this.newDistr,this);this.origDistr=z(this.origDistr,this);var i,n,o;e.__super__.constructor.call(this,t,r);if(r==null){r={}}this.translate=(n=r.translate)!=null?n:A()*M(.2,2)(Math.random());o=this.scale;i=this.translate;this.makeStepMat(o,o*i,0,o);this.logScale=Math.log(o);this.xOfY=function(t,e){return e*(t+i*Math.log(e)/this.logScale)};this.lerpR=function(t){return Math.tan((t-.5)*π)};this.lerpR2=function(t){return Math.tan((t/.99+.005-.5)*π)}}e.prototype.origDistr=function(){return this.distr(this.lerpY)};e.prototype.newDistr=function(){return this.distr(this.lerpYNew)};e.prototype.distr=function(t){var e,r,i,n;e=this.lerpR2(Math.random());n=t(Math.random());i=this.xOfY(e,n);r=A();return[r*i,r*n]};e.prototype.shaderParams=function(){return e.__super__.shaderParams.call(this,{code:L,uniforms:{scale:{type:"f",value:this.scale},translate:{type:"f",value:this.translate}}})};e.prototype.makeReference=function(){var t,e,r,i,n,o,s,a,u,l,h;a=[];n=40;for(t=r=1,s=n;1<=s?r<s:r>s;t=1<=s?++r:--r){o=this.lerpR(t/n);u=[];for(e=i=0;i<100;e=++i){h=this.lerpY(e/100);l=this.xOfY(o,h);u.push([[l,h],[-l,-h]])}a.push(u)}return a};e.prototype.makePath=function(t,e){var r,i,n,o,s,a,u,l;u=this.timeToLeave(t);if(!isFinite(u)){u=25}l=this.scale;r=this.translate;for(i=n=0,o=e.length;0<=o?n<o:n>o;i=0<=o?++n:--n){a=u*i/e.length;s=Math.pow(l,a);e[i]=[s*t[0]+s*r*a*t[1],s*t[1],this.zAtTime(t[2],a)]}return e};return e}(u);v=function(t){D(e,t);e.prototype.descr=function(){return"Scale-out shear"};function e(t,r){var i,n;this.extents=t;this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);if(r==null){r={}}this.scale=(i=r.scale)!=null?i:M(1/.7,1/.3)(Math.random());this.lerpY=R(.01/this.scale,this.extents.y);this.lerpYNew=R(.01/this.scale,.01);e.__super__.constructor.call(this,this.extents,r);this.inverse=(n=r!=null?r.inverse:void 0)!=null?n:new m(this.extents,{translate:-this.translate,scale:1/this.scale,inverse:this,scaleZ:this.invScaleZ})}e.prototype.needsResetXY=function(t,e){return Math.abs(e)>this.extents.y};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(this.extents.y)-Math.log(Math.abs(e)))/this.logScale};return e}(d);m=function(t){D(e,t);e.prototype.descr=function(){return"Scale-in shear"};function e(t,r){var i,n;this.extents=t;this.timeToLeaveXY=z(this.timeToLeaveXY,this);this.needsResetXY=z(this.needsResetXY,this);if(r==null){r={}}this.scale=(i=r.scale)!=null?i:M(.3,.7)(Math.random());this.lerpY=R(.01,this.extents.y/this.scale);this.lerpYNew=R(this.extents.y,this.extents.y/this.scale);e.__super__.constructor.call(this,this.extents,r);this.inverse=(n=r!=null?r.inverse:void 0)!=null?n:new v(this.extents,{translate:-this.translate,scale:1/this.scale,inverse:this,scaleZ:this.invScaleZ})}e.prototype.needsResetXY=function(t,e){return Math.abs(e)<.01};e.prototype.timeToLeaveXY=function(t,e){return(Math.log(.01)-Math.log(Math.abs(e)))/this.logScale};return e}(d);window.dynamics={};window.dynamics.DynamicsView=l;window.dynamics.Controller=s;window.dynamics.Circle=n;window.dynamics.SpiralIn=E;window.dynamics.SpiralOut=_;window.dynamics.Hyperbolas=f;window.dynamics.Attract=t;window.dynamics.Repel=c;window.dynamics.AttractLine=e;window.dynamics.RepelLine=p;window.dynamics.Shear=g;window.dynamics.ScaleOutShear=v;window.dynamics.ScaleInShear=m}).call(this);var THREE={REVISION:"71"};if(typeof module==="object"){module.exports=THREE}if(Math.sign===undefined){Math.sign=function(t){return t<0?-1:t>0?1:+t}}THREE.log=function(){console.log.apply(console,arguments)};THREE.warn=function(){console.warn.apply(console,arguments)};THREE.error=function(){console.error.apply(console,arguments)};THREE.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2};THREE.CullFaceNone=0;THREE.CullFaceBack=1;THREE.CullFaceFront=2;THREE.CullFaceFrontBack=3;THREE.FrontFaceDirectionCW=0;THREE.FrontFaceDirectionCCW=1;THREE.BasicShadowMap=0;THREE.PCFShadowMap=1;THREE.PCFSoftShadowMap=2;THREE.FrontSide=0;THREE.BackSide=1;THREE.DoubleSide=2;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.CustomBlending=5;THREE.AddEquation=100;THREE.SubtractEquation=101;THREE.ReverseSubtractEquation=102;THREE.MinEquation=103;THREE.MaxEquation=104;THREE.ZeroFactor=200;THREE.OneFactor=201;THREE.SrcColorFactor=202;THREE.OneMinusSrcColorFactor=203;THREE.SrcAlphaFactor=204;THREE.OneMinusSrcAlphaFactor=205;THREE.DstAlphaFactor=206;THREE.OneMinusDstAlphaFactor=207;THREE.DstColorFactor=208;THREE.OneMinusDstColorFactor=209;THREE.SrcAlphaSaturateFactor=210;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.AddOperation=2;THREE.UVMapping=300;THREE.CubeReflectionMapping=301;THREE.CubeRefractionMapping=302;THREE.EquirectangularReflectionMapping=303;THREE.EquirectangularRefractionMapping=304;THREE.SphericalReflectionMapping=305;THREE.RepeatWrapping=1e3;THREE.ClampToEdgeWrapping=1001;THREE.MirroredRepeatWrapping=1002;THREE.NearestFilter=1003;THREE.NearestMipMapNearestFilter=1004;THREE.NearestMipMapLinearFilter=1005;THREE.LinearFilter=1006;THREE.LinearMipMapNearestFilter=1007;THREE.LinearMipMapLinearFilter=1008;THREE.UnsignedByteType=1009;THREE.ByteType=1010;THREE.ShortType=1011;THREE.UnsignedShortType=1012;THREE.IntType=1013;THREE.UnsignedIntType=1014;THREE.FloatType=1015;THREE.HalfFloatType=1025;THREE.UnsignedShort4444Type=1016;THREE.UnsignedShort5551Type=1017;THREE.UnsignedShort565Type=1018;THREE.AlphaFormat=1019;THREE.RGBFormat=1020;THREE.RGBAFormat=1021;THREE.LuminanceFormat=1022;THREE.LuminanceAlphaFormat=1023;THREE.RGBEFormat=THREE.RGBAFormat;THREE.RGB_S3TC_DXT1_Format=2001;THREE.RGBA_S3TC_DXT1_Format=2002;THREE.RGBA_S3TC_DXT3_Format=2003;THREE.RGBA_S3TC_DXT5_Format=2004;THREE.RGB_PVRTC_4BPPV1_Format=2100;THREE.RGB_PVRTC_2BPPV1_Format=2101;THREE.RGBA_PVRTC_4BPPV1_Format=2102;THREE.RGBA_PVRTC_2BPPV1_Format=2103;THREE.Projector=function(){THREE.error("THREE.Projector has been moved to /examples/js/renderers/Projector.js.");this.projectVector=function(t,e){THREE.warn("THREE.Projector: .projectVector() is now vector.project().");t.project(e)};this.unprojectVector=function(t,e){THREE.warn("THREE.Projector: .unprojectVector() is now vector.unproject().");t.unproject(e)};this.pickingRay=function(t,e){THREE.error("THREE.Projector: .pickingRay() is now raycaster.setFromCamera().")}};THREE.CanvasRenderer=function(){THREE.error("THREE.CanvasRenderer has been moved to /examples/js/renderers/CanvasRenderer.js");this.domElement=document.createElement("canvas");this.clear=function(){};this.render=function(){};this.setClearColor=function(){};this.setSize=function(){}};THREE.Color=function(t){if(arguments.length===3){return this.setRGB(arguments[0],arguments[1],arguments[2])}return this.set(t)};THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,set:function(t){if(t instanceof THREE.Color){this.copy(t)}else if(typeof t==="number"){this.setHex(t)}else if(typeof t==="string"){this.setStyle(t)}return this},setHex:function(t){t=Math.floor(t);this.r=(t>>16&255)/255;this.g=(t>>8&255)/255;this.b=(t&255)/255;return this},setRGB:function(t,e,r){this.r=t;this.g=e;this.b=r;return this},setHSL:function(t,e,r){if(e===0){this.r=this.g=this.b=r}else{var i=function(t,e,r){if(r<0)r+=1;if(r>1)r-=1;if(r<1/6)return t+(e-t)*6*r;if(r<1/2)return e;if(r<2/3)return t+(e-t)*6*(2/3-r);return t};var n=r<=.5?r*(1+e):r+e-r*e;var o=2*r-n;this.r=i(o,n,t+1/3);this.g=i(o,n,t);this.b=i(o,n,t-1/3)}return this},setStyle:function(t){if(/^rgb\((\d+), ?(\d+), ?(\d+)\)$/i.test(t)){var e=/^rgb\((\d+), ?(\d+), ?(\d+)\)$/i.exec(t);this.r=Math.min(255,parseInt(e[1],10))/255;this.g=Math.min(255,parseInt(e[2],10))/255;this.b=Math.min(255,parseInt(e[3],10))/255;return this}if(/^rgb\((\d+)\%, ?(\d+)\%, ?(\d+)\%\)$/i.test(t)){var e=/^rgb\((\d+)\%, ?(\d+)\%, ?(\d+)\%\)$/i.exec(t);this.r=Math.min(100,parseInt(e[1],10))/100;this.g=Math.min(100,parseInt(e[2],10))/100;this.b=Math.min(100,parseInt(e[3],10))/100;return this}if(/^\#([0-9a-f]{6})$/i.test(t)){var e=/^\#([0-9a-f]{6})$/i.exec(t);this.setHex(parseInt(e[1],16));return this}if(/^\#([0-9a-f])([0-9a-f])([0-9a-f])$/i.test(t)){var e=/^\#([0-9a-f])([0-9a-f])([0-9a-f])$/i.exec(t);this.setHex(parseInt(e[1]+e[1]+e[2]+e[2]+e[3]+e[3],16));return this}if(/^(\w+)$/i.test(t)){this.setHex(THREE.ColorKeywords[t]);return this}},copy:function(t){this.r=t.r;this.g=t.g;this.b=t.b;return this},copyGammaToLinear:function(t,e){if(e===undefined)e=2;this.r=Math.pow(t.r,e);this.g=Math.pow(t.g,e);this.b=Math.pow(t.b,e);return this},copyLinearToGamma:function(t,e){if(e===undefined)e=2;var r=e>0?1/e:1;this.r=Math.pow(t.r,r);this.g=Math.pow(t.g,r);this.b=Math.pow(t.b,r);return this},convertGammaToLinear:function(){var t=this.r,e=this.g,r=this.b;this.r=t*t;this.g=e*e;this.b=r*r;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);this.b=Math.sqrt(this.b);return this},getHex:function(){return this.r*255<<16^this.g*255<<8^this.b*255<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(t){var e=t||{h:0,s:0,l:0};var r=this.r,i=this.g,n=this.b;var o=Math.max(r,i,n);var s=Math.min(r,i,n);var a,u;var l=(s+o)/2;if(s===o){a=0;u=0}else{var h=o-s;u=l<=.5?h/(o+s):h/(2-o-s);switch(o){case r:a=(i-n)/h+(i<n?6:0);break;case i:a=(n-r)/h+2;break;case n:a=(r-i)/h+4;break}a/=6}e.h=a;e.s=u;e.l=l;return e},getStyle:function(){return"rgb("+(this.r*255|0)+","+(this.g*255|0)+","+(this.b*255|0)+")"},offsetHSL:function(t,e,r){var i=this.getHSL();i.h+=t;i.s+=e;i.l+=r;this.setHSL(i.h,i.s,i.l);return this},add:function(t){this.r+=t.r;this.g+=t.g;this.b+=t.b;return this},addColors:function(t,e){this.r=t.r+e.r;this.g=t.g+e.g;this.b=t.b+e.b;return this},addScalar:function(t){this.r+=t;this.g+=t;this.b+=t;return this},multiply:function(t){this.r*=t.r;this.g*=t.g;this.b*=t.b;return this},multiplyScalar:function(t){this.r*=t;this.g*=t;this.b*=t;return this},lerp:function(t,e){this.r+=(t.r-this.r)*e;this.g+=(t.g-this.g)*e;this.b+=(t.b-this.b)*e;return this},equals:function(t){return t.r===this.r&&t.g===this.g&&t.b===this.b},fromArray:function(t){this.r=t[0];this.g=t[1];this.b=t[2];return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this.r;t[e+1]=this.g;t[e+2]=this.b;return t},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.ColorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};THREE.Quaternion=function(t,e,r,i){this._x=t||0;this._y=e||0;this._z=r||0;this._w=i!==undefined?i:1};THREE.Quaternion.prototype={constructor:THREE.Quaternion,_x:0,_y:0,_z:0,_w:0,get x(){return this._x},set x(t){this._x=t;this.onChangeCallback()},get y(){return this._y},set y(t){this._y=t;this.onChangeCallback()},get z(){return this._z},set z(t){this._z=t;this.onChangeCallback()},get w(){return this._w},set w(t){this._w=t;this.onChangeCallback()},set:function(t,e,r,i){this._x=t;this._y=e;this._z=r;this._w=i;this.onChangeCallback();return this},copy:function(t){this._x=t.x;this._y=t.y;this._z=t.z;this._w=t.w;this.onChangeCallback();return this},setFromEuler:function(t,e){if(t instanceof THREE.Euler===false){throw new Error("THREE.Quaternion: .setFromEuler() now expects a Euler rotation rather than a Vector3 and order.")}var r=Math.cos(t._x/2);var i=Math.cos(t._y/2);var n=Math.cos(t._z/2);var o=Math.sin(t._x/2);var s=Math.sin(t._y/2);var a=Math.sin(t._z/2);if(t.order==="XYZ"){this._x=o*i*n+r*s*a;this._y=r*s*n-o*i*a;this._z=r*i*a+o*s*n;this._w=r*i*n-o*s*a}else if(t.order==="YXZ"){this._x=o*i*n+r*s*a;this._y=r*s*n-o*i*a;this._z=r*i*a-o*s*n;this._w=r*i*n+o*s*a}else if(t.order==="ZXY"){this._x=o*i*n-r*s*a;this._y=r*s*n+o*i*a;this._z=r*i*a+o*s*n;this._w=r*i*n-o*s*a}else if(t.order==="ZYX"){this._x=o*i*n-r*s*a;this._y=r*s*n+o*i*a;this._z=r*i*a-o*s*n;this._w=r*i*n+o*s*a}else if(t.order==="YZX"){this._x=o*i*n+r*s*a;this._y=r*s*n+o*i*a;this._z=r*i*a-o*s*n;this._w=r*i*n-o*s*a}else if(t.order==="XZY"){this._x=o*i*n-r*s*a;this._y=r*s*n-o*i*a;this._z=r*i*a+o*s*n;this._w=r*i*n+o*s*a}if(e!==false)this.onChangeCallback();return this},setFromAxisAngle:function(t,e){var r=e/2,i=Math.sin(r);this._x=t.x*i;this._y=t.y*i;this._z=t.z*i;this._w=Math.cos(r);this.onChangeCallback();return this},setFromRotationMatrix:function(t){var e=t.elements,r=e[0],i=e[4],n=e[8],o=e[1],s=e[5],a=e[9],u=e[2],l=e[6],h=e[10],f=r+s+h,c;if(f>0){c=.5/Math.sqrt(f+1);this._w=.25/c;this._x=(l-a)*c;this._y=(n-u)*c;this._z=(o-i)*c}else if(r>s&&r>h){c=2*Math.sqrt(1+r-s-h);this._w=(l-a)/c;this._x=.25*c;this._y=(i+o)/c;this._z=(n+u)/c}else if(s>h){c=2*Math.sqrt(1+s-r-h);this._w=(n-u)/c;this._x=(i+o)/c;this._y=.25*c;this._z=(a+l)/c}else{c=2*Math.sqrt(1+h-r-s);this._w=(o-i)/c;this._x=(n+u)/c;this._y=(a+l)/c;this._z=.25*c}this.onChangeCallback();return this},setFromUnitVectors:function(){var t,e;var r=1e-6;return function(i,n){if(t===undefined)t=new THREE.Vector3;e=i.dot(n)+1;if(e<r){e=0;if(Math.abs(i.x)>Math.abs(i.z)){t.set(-i.y,i.x,0)}else{t.set(0,-i.z,i.y)}}else{t.crossVectors(i,n)}this._x=t.x;this._y=t.y;this._z=t.z;this._w=e;this.normalize();return this}}(),inverse:function(){this.conjugate().normalize();return this},conjugate:function(){this._x*=-1;this._y*=-1;this._z*=-1;this.onChangeCallback();return this},dot:function(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var t=this.length();if(t===0){this._x=0;this._y=0;this._z=0;this._w=1}else{t=1/t;this._x=this._x*t;this._y=this._y*t;this._z=this._z*t;this._w=this._w*t}this.onChangeCallback();return this},multiply:function(t,e){if(e!==undefined){THREE.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead.");return this.multiplyQuaternions(t,e)}return this.multiplyQuaternions(this,t)},multiplyQuaternions:function(t,e){var r=t._x,i=t._y,n=t._z,o=t._w;var s=e._x,a=e._y,u=e._z,l=e._w;this._x=r*l+o*s+i*u-n*a;this._y=i*l+o*a+n*s-r*u;this._z=n*l+o*u+r*a-i*s;this._w=o*l-r*s-i*a-n*u;this.onChangeCallback();return this},multiplyVector3:function(t){THREE.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead.");return t.applyQuaternion(this)},slerp:function(t,e){if(e===0)return this;if(e===1)return this.copy(t);var r=this._x,i=this._y,n=this._z,o=this._w;var s=o*t._w+r*t._x+i*t._y+n*t._z;if(s<0){this._w=-t._w;this._x=-t._x;this._y=-t._y;this._z=-t._z;s=-s}else{this.copy(t)}if(s>=1){this._w=o;this._x=r;this._y=i;this._z=n;return this}var a=Math.acos(s);var u=Math.sqrt(1-s*s);if(Math.abs(u)<.001){this._w=.5*(o+this._w);this._x=.5*(r+this._x);this._y=.5*(i+this._y);this._z=.5*(n+this._z);return this}var l=Math.sin((1-e)*a)/u,h=Math.sin(e*a)/u;this._w=o*l+this._w*h;this._x=r*l+this._x*h;this._y=i*l+this._y*h;this._z=n*l+this._z*h;this.onChangeCallback();return this},equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w},fromArray:function(t,e){if(e===undefined)e=0;this._x=t[e];this._y=t[e+1];this._z=t[e+2];this._w=t[e+3];this.onChangeCallback();return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this._x;t[e+1]=this._y;t[e+2]=this._z;t[e+3]=this._w;return t},onChange:function(t){this.onChangeCallback=t;return this},onChangeCallback:function(){},clone:function(){return new THREE.Quaternion(this._x,this._y,this._z,this._w)}};THREE.Quaternion.slerp=function(t,e,r,i){return r.copy(t).slerp(e,i)};THREE.Vector2=function(t,e){this.x=t||0;this.y=e||0};THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(t,e){this.x=t;this.y=e;return this},setX:function(t){this.x=t;return this},setY:function(t){this.y=t;return this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}},copy:function(t){this.x=t.x;this.y=t.y;return this},add:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead.");return this.addVectors(t,e)}this.x+=t.x;this.y+=t.y;return this},addScalar:function(t){this.x+=t;this.y+=t;return this},addVectors:function(t,e){this.x=t.x+e.x;this.y=t.y+e.y;return this},sub:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.");return this.subVectors(t,e)}this.x-=t.x;this.y-=t.y;return this},subScalar:function(t){this.x-=t;this.y-=t;return this},subVectors:function(t,e){this.x=t.x-e.x;this.y=t.y-e.y;return this},multiply:function(t){this.x*=t.x;this.y*=t.y;return this},multiplyScalar:function(t){this.x*=t;this.y*=t;return this},divide:function(t){this.x/=t.x;this.y/=t.y;return this},divideScalar:function(t){if(t!==0){var e=1/t;this.x*=e;this.y*=e}else{this.x=0;this.y=0}return this},min:function(t){if(this.x>t.x){this.x=t.x}if(this.y>t.y){this.y=t.y}return this},max:function(t){if(this.x<t.x){this.x=t.x}if(this.y<t.y){this.y=t.y}return this},clamp:function(t,e){if(this.x<t.x){this.x=t.x}else if(this.x>e.x){this.x=e.x}if(this.y<t.y){this.y=t.y}else if(this.y>e.y){this.y=e.y}return this},clampScalar:function(){var t,e;return function(r,i){if(t===undefined){t=new THREE.Vector2;e=new THREE.Vector2}t.set(r,r);e.set(i,i);return this.clamp(t,e)}}(),floor:function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);return this},round:function(){this.x=Math.round(this.x);this.y=Math.round(this.y);return this},roundToZero:function(){this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x);this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y);return this},negate:function(){this.x=-this.x;this.y=-this.y;return this},dot:function(t){return this.x*t.x+this.y*t.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x,r=this.y-t.y;return e*e+r*r},setLength:function(t){var e=this.length();if(e!==0&&t!==e){this.multiplyScalar(t/e)}return this},lerp:function(t,e){this.x+=(t.x-this.x)*e;this.y+=(t.y-this.y)*e;return this},lerpVectors:function(t,e,r){this.subVectors(e,t).multiplyScalar(r).add(t);return this},equals:function(t){return t.x===this.x&&t.y===this.y},fromArray:function(t,e){if(e===undefined)e=0;this.x=t[e];this.y=t[e+1];return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this.x;t[e+1]=this.y;return t},fromAttribute:function(t,e,r){if(r===undefined)r=0;e=e*t.itemSize+r;this.x=t.array[e];this.y=t.array[e+1];return this},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(t,e,r){this.x=t||0;this.y=e||0;this.z=r||0};THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(t,e,r){this.x=t;this.y=e;this.z=r;return this},setX:function(t){this.x=t;return this},setY:function(t){this.y=t;return this},setZ:function(t){this.z=t;return this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}},copy:function(t){this.x=t.x;this.y=t.y;this.z=t.z;return this},add:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead.");return this.addVectors(t,e)}this.x+=t.x;this.y+=t.y;this.z+=t.z;return this},addScalar:function(t){this.x+=t;this.y+=t;this.z+=t;return this},addVectors:function(t,e){this.x=t.x+e.x;this.y=t.y+e.y;this.z=t.z+e.z;return this},sub:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.");return this.subVectors(t,e)}this.x-=t.x;this.y-=t.y;this.z-=t.z;return this},subScalar:function(t){this.x-=t;this.y-=t;this.z-=t;return this},subVectors:function(t,e){this.x=t.x-e.x;this.y=t.y-e.y;this.z=t.z-e.z;return this},multiply:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead.");return this.multiplyVectors(t,e)}this.x*=t.x;this.y*=t.y;this.z*=t.z;return this},multiplyScalar:function(t){this.x*=t;this.y*=t;this.z*=t;return this},multiplyVectors:function(t,e){this.x=t.x*e.x;this.y=t.y*e.y;this.z=t.z*e.z;return this},applyEuler:function(){var t;return function(e){if(e instanceof THREE.Euler===false){THREE.error("THREE.Vector3: .applyEuler() now expects a Euler rotation rather than a Vector3 and order.")}if(t===undefined)t=new THREE.Quaternion;this.applyQuaternion(t.setFromEuler(e));return this}}(),applyAxisAngle:function(){var t;return function(e,r){if(t===undefined)t=new THREE.Quaternion;this.applyQuaternion(t.setFromAxisAngle(e,r));return this}}(),applyMatrix3:function(t){var e=this.x;var r=this.y;var i=this.z;var n=t.elements;this.x=n[0]*e+n[3]*r+n[6]*i;this.y=n[1]*e+n[4]*r+n[7]*i;this.z=n[2]*e+n[5]*r+n[8]*i;return this},applyMatrix4:function(t){var e=this.x,r=this.y,i=this.z;var n=t.elements;this.x=n[0]*e+n[4]*r+n[8]*i+n[12];this.y=n[1]*e+n[5]*r+n[9]*i+n[13];this.z=n[2]*e+n[6]*r+n[10]*i+n[14];return this},applyProjection:function(t){var e=this.x,r=this.y,i=this.z;var n=t.elements;var o=1/(n[3]*e+n[7]*r+n[11]*i+n[15]);this.x=(n[0]*e+n[4]*r+n[8]*i+n[12])*o;this.y=(n[1]*e+n[5]*r+n[9]*i+n[13])*o;this.z=(n[2]*e+n[6]*r+n[10]*i+n[14])*o;return this},applyQuaternion:function(t){var e=this.x;var r=this.y;var i=this.z;var n=t.x;var o=t.y;var s=t.z;var a=t.w;var u=a*e+o*i-s*r;var l=a*r+s*e-n*i;var h=a*i+n*r-o*e;var f=-n*e-o*r-s*i;this.x=u*a+f*-n+l*-s-h*-o;this.y=l*a+f*-o+h*-n-u*-s;this.z=h*a+f*-s+u*-o-l*-n;return this},project:function(){var t;return function(e){if(t===undefined)t=new THREE.Matrix4;t.multiplyMatrices(e.projectionMatrix,t.getInverse(e.matrixWorld));return this.applyProjection(t)}}(),unproject:function(){var t;return function(e){if(t===undefined)t=new THREE.Matrix4;t.multiplyMatrices(e.matrixWorld,t.getInverse(e.projectionMatrix));return this.applyProjection(t)}}(),transformDirection:function(t){var e=this.x,r=this.y,i=this.z;var n=t.elements;this.x=n[0]*e+n[4]*r+n[8]*i;this.y=n[1]*e+n[5]*r+n[9]*i;this.z=n[2]*e+n[6]*r+n[10]*i;this.normalize();return this},divide:function(t){this.x/=t.x;this.y/=t.y;this.z/=t.z;return this},divideScalar:function(t){if(t!==0){var e=1/t;this.x*=e;this.y*=e;this.z*=e}else{this.x=0;this.y=0;this.z=0}return this},min:function(t){if(this.x>t.x){this.x=t.x}if(this.y>t.y){this.y=t.y}if(this.z>t.z){this.z=t.z}return this},max:function(t){if(this.x<t.x){this.x=t.x}if(this.y<t.y){this.y=t.y}if(this.z<t.z){this.z=t.z}return this},clamp:function(t,e){if(this.x<t.x){this.x=t.x}else if(this.x>e.x){this.x=e.x}if(this.y<t.y){this.y=t.y}else if(this.y>e.y){this.y=e.y}if(this.z<t.z){this.z=t.z}else if(this.z>e.z){this.z=e.z}return this},clampScalar:function(){var t,e;return function(r,i){if(t===undefined){t=new THREE.Vector3;e=new THREE.Vector3}t.set(r,r,r);e.set(i,i,i);return this.clamp(t,e)}}(),floor:function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);this.z=Math.floor(this.z);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);this.z=Math.ceil(this.z);return this},round:function(){this.x=Math.round(this.x);this.y=Math.round(this.y);this.z=Math.round(this.z);return this},roundToZero:function(){this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x);this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y);this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z);return this},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(t){var e=this.length();if(e!==0&&t!==e){this.multiplyScalar(t/e)}return this},lerp:function(t,e){this.x+=(t.x-this.x)*e;this.y+=(t.y-this.y)*e;this.z+=(t.z-this.z)*e;return this},lerpVectors:function(t,e,r){this.subVectors(e,t).multiplyScalar(r).add(t);return this},cross:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead.");return this.crossVectors(t,e)}var r=this.x,i=this.y,n=this.z;this.x=i*t.z-n*t.y;this.y=n*t.x-r*t.z;this.z=r*t.y-i*t.x;return this},crossVectors:function(t,e){var r=t.x,i=t.y,n=t.z;var o=e.x,s=e.y,a=e.z;this.x=i*a-n*s;this.y=n*o-r*a;this.z=r*s-i*o;return this},projectOnVector:function(){var t,e;return function(r){if(t===undefined)t=new THREE.Vector3;t.copy(r).normalize();e=this.dot(t);return this.copy(t).multiplyScalar(e)}}(),projectOnPlane:function(){var t;return function(e){if(t===undefined)t=new THREE.Vector3;t.copy(this).projectOnVector(e);return this.sub(t)}}(),reflect:function(){var t;return function(e){if(t===undefined)t=new THREE.Vector3;return this.sub(t.copy(e).multiplyScalar(2*this.dot(e)))}}(),angleTo:function(t){var e=this.dot(t)/(this.length()*t.length());return Math.acos(THREE.Math.clamp(e,-1,1))},distanceTo:function(t){return Math.sqrt(this.distanceToSquared(t))},distanceToSquared:function(t){var e=this.x-t.x;var r=this.y-t.y;var i=this.z-t.z;return e*e+r*r+i*i},setEulerFromRotationMatrix:function(t,e){THREE.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(t,e){THREE.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(t){THREE.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition().");return this.setFromMatrixPosition(t)},getScaleFromMatrix:function(t){THREE.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale().");return this.setFromMatrixScale(t)},getColumnFromMatrix:function(t,e){THREE.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn().");return this.setFromMatrixColumn(t,e)},setFromMatrixPosition:function(t){this.x=t.elements[12];this.y=t.elements[13];this.z=t.elements[14];return this},setFromMatrixScale:function(t){var e=this.set(t.elements[0],t.elements[1],t.elements[2]).length();var r=this.set(t.elements[4],t.elements[5],t.elements[6]).length();var i=this.set(t.elements[8],t.elements[9],t.elements[10]).length();this.x=e;this.y=r;this.z=i;return this},setFromMatrixColumn:function(t,e){var r=t*4;var i=e.elements;this.x=i[r];this.y=i[r+1];this.z=i[r+2];return this},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z},fromArray:function(t,e){if(e===undefined)e=0;this.x=t[e];this.y=t[e+1];this.z=t[e+2];return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this.x;t[e+1]=this.y;t[e+2]=this.z;return t},fromAttribute:function(t,e,r){if(r===undefined)r=0;e=e*t.itemSize+r;this.x=t.array[e];this.y=t.array[e+1];this.z=t.array[e+2];return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(t,e,r,i){this.x=t||0;this.y=e||0;this.z=r||0;this.w=i!==undefined?i:1};THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(t,e,r,i){this.x=t;this.y=e;this.z=r;this.w=i;return this},setX:function(t){this.x=t;return this},setY:function(t){this.y=t;return this},setZ:function(t){this.z=t;return this},setW:function(t){this.w=t;return this},setComponent:function(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}},getComponent:function(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}},copy:function(t){this.x=t.x;this.y=t.y;this.z=t.z;this.w=t.w!==undefined?t.w:1;return this},add:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead.");return this.addVectors(t,e)}this.x+=t.x;this.y+=t.y;this.z+=t.z;this.w+=t.w;return this},addScalar:function(t){this.x+=t;this.y+=t;this.z+=t;this.w+=t;return this},addVectors:function(t,e){this.x=t.x+e.x;this.y=t.y+e.y;this.z=t.z+e.z;this.w=t.w+e.w;return this},sub:function(t,e){if(e!==undefined){THREE.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.");return this.subVectors(t,e)}this.x-=t.x;this.y-=t.y;this.z-=t.z;this.w-=t.w;return this},subScalar:function(t){this.x-=t;this.y-=t;this.z-=t;this.w-=t;return this},subVectors:function(t,e){this.x=t.x-e.x;this.y=t.y-e.y;this.z=t.z-e.z;this.w=t.w-e.w;return this},multiplyScalar:function(t){this.x*=t;this.y*=t;this.z*=t;this.w*=t;return this},applyMatrix4:function(t){var e=this.x;var r=this.y;var i=this.z;var n=this.w;var o=t.elements;this.x=o[0]*e+o[4]*r+o[8]*i+o[12]*n;this.y=o[1]*e+o[5]*r+o[9]*i+o[13]*n;this.z=o[2]*e+o[6]*r+o[10]*i+o[14]*n;this.w=o[3]*e+o[7]*r+o[11]*i+o[15]*n;return this},divideScalar:function(t){if(t!==0){var e=1/t;this.x*=e;this.y*=e;this.z*=e;this.w*=e}else{this.x=0;this.y=0;this.z=0;this.w=1}return this},setAxisAngleFromQuaternion:function(t){this.w=2*Math.acos(t.w);var e=Math.sqrt(1-t.w*t.w);if(e<1e-4){this.x=1;this.y=0;this.z=0}else{this.x=t.x/e;this.y=t.y/e;this.z=t.z/e}return this},setAxisAngleFromRotationMatrix:function(t){var e,r,i,n,o=.01,s=.1,a=t.elements,u=a[0],l=a[4],h=a[8],f=a[1],c=a[5],p=a[9],d=a[2],m=a[6],v=a[10];if(Math.abs(l-f)<o&&Math.abs(h-d)<o&&Math.abs(p-m)<o){if(Math.abs(l+f)<s&&Math.abs(h+d)<s&&Math.abs(p+m)<s&&Math.abs(u+c+v-3)<s){this.set(1,0,0,0);return this}e=Math.PI;var g=(u+1)/2;var y=(c+1)/2;var E=(v+1)/2;var _=(l+f)/4;var x=(h+d)/4;var b=(p+m)/4;if(g>y&&g>E){if(g<o){r=0;i=.707106781;n=.707106781}else{r=Math.sqrt(g);i=_/r;n=x/r}}else if(y>E){if(y<o){r=.707106781;i=0;n=.707106781}else{i=Math.sqrt(y);r=_/i;n=b/i}}else{if(E<o){r=.707106781;i=.707106781;n=0}else{n=Math.sqrt(E);r=x/n;i=b/n}}this.set(r,i,n,e);return this}var T=Math.sqrt((m-p)*(m-p)+(h-d)*(h-d)+(f-l)*(f-l));if(Math.abs(T)<.001)T=1;this.x=(m-p)/T;this.y=(h-d)/T;this.z=(f-l)/T;this.w=Math.acos((u+c+v-1)/2);return this},min:function(t){if(this.x>t.x){this.x=t.x}if(this.y>t.y){this.y=t.y}if(this.z>t.z){this.z=t.z}if(this.w>t.w){this.w=t.w}return this},max:function(t){if(this.x<t.x){this.x=t.x}if(this.y<t.y){this.y=t.y}if(this.z<t.z){this.z=t.z}if(this.w<t.w){this.w=t.w}return this},clamp:function(t,e){if(this.x<t.x){this.x=t.x}else if(this.x>e.x){this.x=e.x}if(this.y<t.y){this.y=t.y}else if(this.y>e.y){this.y=e.y}if(this.z<t.z){this.z=t.z}else if(this.z>e.z){this.z=e.z}if(this.w<t.w){this.w=t.w}else if(this.w>e.w){this.w=e.w}return this},clampScalar:function(){var t,e;return function(r,i){if(t===undefined){t=new THREE.Vector4;e=new THREE.Vector4}t.set(r,r,r,r);e.set(i,i,i,i);return this.clamp(t,e)}}(),floor:function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);this.z=Math.floor(this.z);this.w=Math.floor(this.w);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);this.z=Math.ceil(this.z);this.w=Math.ceil(this.w);return this},round:function(){this.x=Math.round(this.x);this.y=Math.round(this.y);this.z=Math.round(this.z);this.w=Math.round(this.w);return this},roundToZero:function(){this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x);this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y);this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z);this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w);return this},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;this.w=-this.w;return this},dot:function(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length())},setLength:function(t){var e=this.length();if(e!==0&&t!==e){this.multiplyScalar(t/e)}return this},lerp:function(t,e){this.x+=(t.x-this.x)*e;this.y+=(t.y-this.y)*e;this.z+=(t.z-this.z)*e;this.w+=(t.w-this.w)*e;return this},lerpVectors:function(t,e,r){this.subVectors(e,t).multiplyScalar(r).add(t);return this},equals:function(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w},fromArray:function(t,e){if(e===undefined)e=0;this.x=t[e];this.y=t[e+1];this.z=t[e+2];this.w=t[e+3];return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this.x;t[e+1]=this.y;t[e+2]=this.z;t[e+3]=this.w;return t},fromAttribute:function(t,e,r){if(r===undefined)r=0;e=e*t.itemSize+r;this.x=t.array[e];this.y=t.array[e+1];this.z=t.array[e+2];this.w=t.array[e+3];return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Euler=function(t,e,r,i){this._x=t||0;this._y=e||0;this._z=r||0;this._order=i||THREE.Euler.DefaultOrder};THREE.Euler.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"];THREE.Euler.DefaultOrder="XYZ";THREE.Euler.prototype={constructor:THREE.Euler,_x:0,_y:0,_z:0,_order:THREE.Euler.DefaultOrder,get x(){return this._x},set x(t){this._x=t;this.onChangeCallback()},get y(){return this._y},set y(t){this._y=t;this.onChangeCallback()},get z(){return this._z},set z(t){this._z=t;this.onChangeCallback()},get order(){return this._order},set order(t){this._order=t;this.onChangeCallback()},set:function(t,e,r,i){this._x=t;this._y=e;this._z=r;this._order=i||this._order;this.onChangeCallback();return this},copy:function(t){this._x=t._x;this._y=t._y;this._z=t._z;this._order=t._order;this.onChangeCallback();return this},setFromRotationMatrix:function(t,e,r){var i=THREE.Math.clamp;var n=t.elements;var o=n[0],s=n[4],a=n[8];var u=n[1],l=n[5],h=n[9];var f=n[2],c=n[6],p=n[10];e=e||this._order;if(e==="XYZ"){this._y=Math.asin(i(a,-1,1));if(Math.abs(a)<.99999){this._x=Math.atan2(-h,p);this._z=Math.atan2(-s,o)}else{this._x=Math.atan2(c,l);this._z=0}}else if(e==="YXZ"){this._x=Math.asin(-i(h,-1,1));if(Math.abs(h)<.99999){this._y=Math.atan2(a,p);this._z=Math.atan2(u,l)}else{this._y=Math.atan2(-f,o);this._z=0}}else if(e==="ZXY"){this._x=Math.asin(i(c,-1,1));if(Math.abs(c)<.99999){this._y=Math.atan2(-f,p);this._z=Math.atan2(-s,l)}else{this._y=0;this._z=Math.atan2(u,o)}}else if(e==="ZYX"){this._y=Math.asin(-i(f,-1,1));if(Math.abs(f)<.99999){this._x=Math.atan2(c,p);this._z=Math.atan2(u,o)}else{this._x=0;this._z=Math.atan2(-s,l)}}else if(e==="YZX"){this._z=Math.asin(i(u,-1,1));if(Math.abs(u)<.99999){this._x=Math.atan2(-h,l);this._y=Math.atan2(-f,o)}else{this._x=0;this._y=Math.atan2(a,p)}}else if(e==="XZY"){this._z=Math.asin(-i(s,-1,1));if(Math.abs(s)<.99999){this._x=Math.atan2(c,l);this._y=Math.atan2(a,o)}else{this._x=Math.atan2(-h,p);this._y=0}}else{THREE.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+e)}this._order=e;if(r!==false)this.onChangeCallback();return this},setFromQuaternion:function(){var t;return function(e,r,i){if(t===undefined)t=new THREE.Matrix4;t.makeRotationFromQuaternion(e);this.setFromRotationMatrix(t,r,i);return this}}(),setFromVector3:function(t,e){return this.set(t.x,t.y,t.z,e||this._order)},reorder:function(){var t=new THREE.Quaternion;return function(e){t.setFromEuler(this);this.setFromQuaternion(t,e)}}(),equals:function(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order},fromArray:function(t){this._x=t[0];this._y=t[1];this._z=t[2];if(t[3]!==undefined)this._order=t[3];this.onChangeCallback();return this},toArray:function(t,e){if(t===undefined)t=[];if(e===undefined)e=0;t[e]=this._x;t[e+1]=this._y;t[e+2]=this._z;t[e+3]=this._order;return t},toVector3:function(t){if(t){return t.set(this._x,this._y,this._z)}else{return new THREE.Vector3(this._x,this._y,this._z)}},onChange:function(t){this.onChangeCallback=t;return this},onChangeCallback:function(){},clone:function(){return new THREE.Euler(this._x,this._y,this._z,this._order)}};THREE.Line3=function(t,e){this.start=t!==undefined?t:new THREE.Vector3;this.end=e!==undefined?e:new THREE.Vector3};THREE.Line3.prototype={constructor:THREE.Line3,set:function(t,e){this.start.copy(t);this.end.copy(e);return this},copy:function(t){this.start.copy(t.start);this.end.copy(t.end);return this},center:function(t){var e=t||new THREE.Vector3;return e.addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(t){var e=t||new THREE.Vector3;return e.subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,e){var r=e||new THREE.Vector3;return this.delta(r).multiplyScalar(t).add(this.start)},closestPointToPointParameter:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(r,i){t.subVectors(r,this.start);e.subVectors(this.end,this.start);var n=e.dot(e);var o=e.dot(t);var s=o/n;if(i){s=THREE.Math.clamp(s,0,1)}return s}}(),closestPointToPoint:function(t,e,r){var i=this.closestPointToPointParameter(t,e);var n=r||new THREE.Vector3;return this.delta(n).multiplyScalar(i).add(this.start)},applyMatrix4:function(t){this.start.applyMatrix4(t);this.end.applyMatrix4(t);return this},equals:function(t){return t.start.equals(this.start)&&t.end.equals(this.end)},clone:function(){return(new THREE.Line3).copy(this)}};THREE.Box2=function(t,e){this.min=t!==undefined?t:new THREE.Vector2(Infinity,Infinity);this.max=e!==undefined?e:new THREE.Vector2(-Infinity,-Infinity)};THREE.Box2.prototype={constructor:THREE.Box2,set:function(t,e){this.min.copy(t);this.max.copy(e);return this},setFromPoints:function(t){this.makeEmpty();for(var e=0,r=t.length;e<r;e++){this.expandByPoint(t[e])}return this},setFromCenterAndSize:function(){var t=new THREE.Vector2;return function(e,r){var i=t.copy(r).multiplyScalar(.5);this.min.copy(e).sub(i);this.max.copy(e).add(i);return this}}(),copy:function(t){this.min.copy(t.min);this.max.copy(t.max);return this},makeEmpty:function(){this.min.x=this.min.y=Infinity;this.max.x=this.max.y=-Infinity;return this},empty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},center:function(t){var e=t||new THREE.Vector2;return e.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(t){var e=t||new THREE.Vector2;return e.subVectors(this.max,this.min)},expandByPoint:function(t){this.min.min(t);this.max.max(t);return this},expandByVector:function(t){this.min.sub(t);this.max.add(t);return this},expandByScalar:function(t){this.min.addScalar(-t);this.max.addScalar(t);return this},containsPoint:function(t){if(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y){return false}return true},containsBox:function(t){if(this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y){return true}return false},getParameter:function(t,e){var r=e||new THREE.Vector2;return r.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))},isIntersectionBox:function(t){if(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y){return false}return true},clampPoint:function(t,e){var r=e||new THREE.Vector2;return r.copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new THREE.Vector2;return function(e){var r=t.copy(e).clamp(this.min,this.max);return r.sub(e).length()}}(),intersect:function(t){this.min.max(t.min);this.max.min(t.max);return this},union:function(t){this.min.min(t.min);this.max.max(t.max);return this},translate:function(t){this.min.add(t);this.max.add(t);return this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)},clone:function(){return(new THREE.Box2).copy(this)}};THREE.Box3=function(t,e){this.min=t!==undefined?t:new THREE.Vector3(Infinity,Infinity,Infinity);this.max=e!==undefined?e:new THREE.Vector3(-Infinity,-Infinity,-Infinity)};THREE.Box3.prototype={constructor:THREE.Box3,set:function(t,e){this.min.copy(t);this.max.copy(e);return this},setFromPoints:function(t){this.makeEmpty();for(var e=0,r=t.length;e<r;e++){this.expandByPoint(t[e])}return this},setFromCenterAndSize:function(){var t=new THREE.Vector3;return function(e,r){var i=t.copy(r).multiplyScalar(.5);this.min.copy(e).sub(i);this.max.copy(e).add(i);return this}}(),setFromObject:function(){var t=new THREE.Vector3;return function(e){var r=this;e.updateMatrixWorld(true);this.makeEmpty();e.traverse(function(e){var i=e.geometry;if(i!==undefined){if(i instanceof THREE.Geometry){var n=i.vertices;for(var o=0,s=n.length;o<s;o++){t.copy(n[o]);t.applyMatrix4(e.matrixWorld);r.expandByPoint(t)}}else if(i instanceof THREE.BufferGeometry&&i.attributes["position"]!==undefined){var a=i.attributes["position"].array;for(var o=0,s=a.length;o<s;o+=3){t.set(a[o],a[o+1],a[o+2]);t.applyMatrix4(e.matrixWorld);r.expandByPoint(t)}}}});return this}}(),copy:function(t){this.min.copy(t.min);this.max.copy(t.max);return this},makeEmpty:function(){this.min.x=this.min.y=this.min.z=Infinity;this.max.x=this.max.y=this.max.z=-Infinity;return this},empty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},center:function(t){var e=t||new THREE.Vector3;return e.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(t){var e=t||new THREE.Vector3;return e.subVectors(this.max,this.min)},expandByPoint:function(t){this.min.min(t);this.max.max(t);return this},expandByVector:function(t){this.min.sub(t);this.max.add(t);return this},expandByScalar:function(t){this.min.addScalar(-t);this.max.addScalar(t);return this},containsPoint:function(t){if(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y||t.z<this.min.z||t.z>this.max.z){return false}return true},containsBox:function(t){if(this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z){return true}return false},getParameter:function(t,e){var r=e||new THREE.Vector3;return r.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))},isIntersectionBox:function(t){if(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y||t.max.z<this.min.z||t.min.z>this.max.z){return false}return true},clampPoint:function(t,e){var r=e||new THREE.Vector3;return r.copy(t).clamp(this.min,this.max)},distanceToPoint:function(){var t=new THREE.Vector3;return function(e){var r=t.copy(e).clamp(this.min,this.max);return r.sub(e).length()}}(),getBoundingSphere:function(){var t=new THREE.Vector3;return function(e){var r=e||new THREE.Sphere;r.center=this.center();r.radius=this.size(t).length()*.5;return r}}(),intersect:function(t){this.min.max(t.min);this.max.min(t.max);return this},union:function(t){this.min.min(t.min);this.max.max(t.max);return this},applyMatrix4:function(){var t=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];return function(e){t[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e);t[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e);t[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e);t[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e);t[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e);t[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e);t[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e);t[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e);this.makeEmpty();this.setFromPoints(t);return this}}(),translate:function(t){this.min.add(t);this.max.add(t);return this},equals:function(t){return t.min.equals(this.min)&&t.max.equals(this.max)},clone:function(){return(new THREE.Box3).copy(this)}};THREE.Matrix3=function(){this.elements=new Float32Array([1,0,0,0,1,0,0,0,1]);if(arguments.length>0){THREE.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}};THREE.Matrix3.prototype={constructor:THREE.Matrix3,set:function(t,e,r,i,n,o,s,a,u){var l=this.elements;l[0]=t;l[3]=e;l[6]=r;l[1]=i;l[4]=n;l[7]=o;l[2]=s;l[5]=a;l[8]=u;return this},identity:function(){this.set(1,0,0,0,1,0,0,0,1);return this},copy:function(t){var e=t.elements;this.set(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]);return this},multiplyVector3:function(t){THREE.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead.");return t.applyMatrix3(this)},multiplyVector3Array:function(t){THREE.warn("THREE.Matrix3: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead.");return this.applyToVector3Array(t)},applyToVector3Array:function(){var t=new THREE.Vector3;return function(e,r,i){if(r===undefined)r=0;if(i===undefined)i=e.length;for(var n=0,o=r;n<i;n+=3,o+=3){t.x=e[o];t.y=e[o+1];t.z=e[o+2];t.applyMatrix3(this);e[o]=t.x;e[o+1]=t.y;e[o+2]=t.z}return e}}(),multiplyScalar:function(t){var e=this.elements;e[0]*=t;e[3]*=t;e[6]*=t;e[1]*=t;e[4]*=t;e[7]*=t;e[2]*=t;e[5]*=t;e[8]*=t;return this},determinant:function(){var t=this.elements;var e=t[0],r=t[1],i=t[2],n=t[3],o=t[4],s=t[5],a=t[6],u=t[7],l=t[8];return e*o*l-e*s*u-r*n*l+r*s*a+i*n*u-i*o*a},getInverse:function(t,e){var r=t.elements;var i=this.elements;i[0]=r[10]*r[5]-r[6]*r[9];i[1]=-r[10]*r[1]+r[2]*r[9];i[2]=r[6]*r[1]-r[2]*r[5];i[3]=-r[10]*r[4]+r[6]*r[8];i[4]=r[10]*r[0]-r[2]*r[8];i[5]=-r[6]*r[0]+r[2]*r[4];i[6]=r[9]*r[4]-r[5]*r[8];i[7]=-r[9]*r[0]+r[1]*r[8];i[8]=r[5]*r[0]-r[1]*r[4];var n=r[0]*i[0]+r[1]*i[3]+r[2]*i[6];if(n===0){var o="Matrix3.getInverse(): can't invert matrix, determinant is 0";if(e||false){throw new Error(o)}else{THREE.warn(o)}this.identity();return this}this.multiplyScalar(1/n);return this},transpose:function(){var t,e=this.elements;t=e[1];e[1]=e[3];e[3]=t;t=e[2];e[2]=e[6];e[6]=t;t=e[5];e[5]=e[7];e[7]=t;return this},flattenToArrayOffset:function(t,e){var r=this.elements;t[e]=r[0];t[e+1]=r[1];t[e+2]=r[2];t[e+3]=r[3];t[e+4]=r[4];t[e+5]=r[5];t[e+6]=r[6];t[e+7]=r[7];t[e+8]=r[8];return t},getNormalMatrix:function(t){this.getInverse(t).transpose();return this},transposeIntoArray:function(t){var e=this.elements;t[0]=e[0];t[1]=e[3];t[2]=e[6];t[3]=e[1];t[4]=e[4];t[5]=e[7];t[6]=e[2];t[7]=e[5];t[8]=e[8];return this},fromArray:function(t){this.elements.set(t);return this},toArray:function(){var t=this.elements;return[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8]]},clone:function(){return(new THREE.Matrix3).fromArray(this.elements)}};THREE.Matrix4=function(){this.elements=new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);if(arguments.length>0){THREE.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}};THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m){var v=this.elements;v[0]=t;v[4]=e;v[8]=r;v[12]=i;v[1]=n;v[5]=o;v[9]=s;v[13]=a;v[2]=u;v[6]=l;v[10]=h;v[14]=f;v[3]=c;v[7]=p;v[11]=d;v[15]=m;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(t){this.elements.set(t.elements);return this},extractPosition:function(t){THREE.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition().");return this.copyPosition(t)},copyPosition:function(t){var e=this.elements;var r=t.elements;e[12]=r[12];e[13]=r[13];e[14]=r[14];return this},extractBasis:function(t,e,r){var i=this.elements;t.set(i[0],i[1],i[2]);e.set(i[4],i[5],i[6]);r.set(i[8],i[9],i[10]);return this},makeBasis:function(t,e,r){this.set(t.x,e.x,r.x,0,t.y,e.y,r.y,0,t.z,e.z,r.z,0,0,0,0,1);return this},extractRotation:function(){var t=new THREE.Vector3;return function(e){var r=this.elements;var i=e.elements;var n=1/t.set(i[0],i[1],i[2]).length();var o=1/t.set(i[4],i[5],i[6]).length();var s=1/t.set(i[8],i[9],i[10]).length();r[0]=i[0]*n;r[1]=i[1]*n;r[2]=i[2]*n;r[4]=i[4]*o;r[5]=i[5]*o;r[6]=i[6]*o;r[8]=i[8]*s;r[9]=i[9]*s;r[10]=i[10]*s;return this}}(),makeRotationFromEuler:function(t){if(t instanceof THREE.Euler===false){THREE.error("THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.")}var e=this.elements;var r=t.x,i=t.y,n=t.z;var o=Math.cos(r),s=Math.sin(r);var a=Math.cos(i),u=Math.sin(i);var l=Math.cos(n),h=Math.sin(n);if(t.order==="XYZ"){var f=o*l,c=o*h,p=s*l,d=s*h;e[0]=a*l;e[4]=-a*h;e[8]=u;e[1]=c+p*u;e[5]=f-d*u;e[9]=-s*a;e[2]=d-f*u;e[6]=p+c*u;e[10]=o*a}else if(t.order==="YXZ"){var m=a*l,v=a*h,g=u*l,y=u*h;e[0]=m+y*s;e[4]=g*s-v;e[8]=o*u;e[1]=o*h;e[5]=o*l;e[9]=-s;e[2]=v*s-g;e[6]=y+m*s;e[10]=o*a}else if(t.order==="ZXY"){var m=a*l,v=a*h,g=u*l,y=u*h;e[0]=m-y*s;e[4]=-o*h;e[8]=g+v*s;e[1]=v+g*s;e[5]=o*l;e[9]=y-m*s;e[2]=-o*u;e[6]=s;e[10]=o*a}else if(t.order==="ZYX"){var f=o*l,c=o*h,p=s*l,d=s*h;e[0]=a*l;e[4]=p*u-c;e[8]=f*u+d;e[1]=a*h;e[5]=d*u+f;e[9]=c*u-p;e[2]=-u;e[6]=s*a;e[10]=o*a}else if(t.order==="YZX"){var E=o*a,_=o*u,x=s*a,b=s*u;e[0]=a*l;e[4]=b-E*h;e[8]=x*h+_;e[1]=h;e[5]=o*l;e[9]=-s*l;e[2]=-u*l;e[6]=_*h+x;e[10]=E-b*h}else if(t.order==="XZY"){var E=o*a,_=o*u,x=s*a,b=s*u;e[0]=a*l;e[4]=-h;e[8]=u*l;e[1]=E*h+b;e[5]=o*l;e[9]=_*h-x;e[2]=x*h-_;e[6]=s*l;e[10]=b*h+E}e[3]=0;e[7]=0;e[11]=0;e[12]=0;e[13]=0;e[14]=0;e[15]=1;return this},setRotationFromQuaternion:function(t){THREE.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion().");return this.makeRotationFromQuaternion(t)},makeRotationFromQuaternion:function(t){var e=this.elements;var r=t.x,i=t.y,n=t.z,o=t.w;var s=r+r,a=i+i,u=n+n;var l=r*s,h=r*a,f=r*u;var c=i*a,p=i*u,d=n*u;var m=o*s,v=o*a,g=o*u;e[0]=1-(c+d);e[4]=h-g;e[8]=f+v;e[1]=h+g;e[5]=1-(l+d);e[9]=p-m;e[2]=f-v;e[6]=p+m;e[10]=1-(l+c);e[3]=0;e[7]=0;e[11]=0;e[12]=0;e[13]=0;e[14]=0;e[15]=1;return this},lookAt:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Vector3;return function(i,n,o){var s=this.elements;r.subVectors(i,n).normalize();if(r.length()===0){r.z=1}t.crossVectors(o,r).normalize();if(t.length()===0){r.x+=1e-4;t.crossVectors(o,r).normalize()}e.crossVectors(r,t);s[0]=t.x;s[4]=e.x;s[8]=r.x;s[1]=t.y;s[5]=e.y;s[9]=r.y;s[2]=t.z;s[6]=e.z;s[10]=r.z;return this}}(),multiply:function(t,e){if(e!==undefined){THREE.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead.");return this.multiplyMatrices(t,e)}return this.multiplyMatrices(this,t)},multiplyMatrices:function(t,e){var r=t.elements;var i=e.elements;var n=this.elements;var o=r[0],s=r[4],a=r[8],u=r[12];var l=r[1],h=r[5],f=r[9],c=r[13];var p=r[2],d=r[6],m=r[10],v=r[14];var g=r[3],y=r[7],E=r[11],_=r[15];var x=i[0],b=i[4],T=i[8],w=i[12];var R=i[1],H=i[5],M=i[9],S=i[13];var k=i[2],A=i[6],C=i[10],L=i[14];var P=i[3],z=i[7],D=i[11],O=i[15];n[0]=o*x+s*R+a*k+u*P;n[4]=o*b+s*H+a*A+u*z;n[8]=o*T+s*M+a*C+u*D;n[12]=o*w+s*S+a*L+u*O;n[1]=l*x+h*R+f*k+c*P;n[5]=l*b+h*H+f*A+c*z;n[9]=l*T+h*M+f*C+c*D;n[13]=l*w+h*S+f*L+c*O;n[2]=p*x+d*R+m*k+v*P;n[6]=p*b+d*H+m*A+v*z;n[10]=p*T+d*M+m*C+v*D;n[14]=p*w+d*S+m*L+v*O;n[3]=g*x+y*R+E*k+_*P;n[7]=g*b+y*H+E*A+_*z;n[11]=g*T+y*M+E*C+_*D;n[15]=g*w+y*S+E*L+_*O;return this},multiplyToArray:function(t,e,r){var i=this.elements;this.multiplyMatrices(t,e);r[0]=i[0];r[1]=i[1];r[2]=i[2];r[3]=i[3];r[4]=i[4];r[5]=i[5];r[6]=i[6];r[7]=i[7];r[8]=i[8];r[9]=i[9];r[10]=i[10];r[11]=i[11];r[12]=i[12];r[13]=i[13];r[14]=i[14];r[15]=i[15];return this},multiplyScalar:function(t){var e=this.elements;e[0]*=t;e[4]*=t;e[8]*=t;e[12]*=t;e[1]*=t;e[5]*=t;e[9]*=t;e[13]*=t;e[2]*=t;e[6]*=t;e[10]*=t;e[14]*=t;e[3]*=t;e[7]*=t;e[11]*=t;e[15]*=t;return this},multiplyVector3:function(t){THREE.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) or vector.applyProjection( matrix ) instead.");return t.applyProjection(this)},multiplyVector4:function(t){THREE.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead.");return t.applyMatrix4(this)},multiplyVector3Array:function(t){THREE.warn("THREE.Matrix4: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead.");return this.applyToVector3Array(t)},applyToVector3Array:function(){var t=new THREE.Vector3;return function(e,r,i){if(r===undefined)r=0;if(i===undefined)i=e.length;for(var n=0,o=r;n<i;n+=3,o+=3){t.x=e[o];t.y=e[o+1];t.z=e[o+2];t.applyMatrix4(this);e[o]=t.x;e[o+1]=t.y;e[o+2]=t.z}return e}}(),rotateAxis:function(t){THREE.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead.");t.transformDirection(this)},crossVector:function(t){THREE.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead.");return t.applyMatrix4(this)},determinant:function(){var t=this.elements;var e=t[0],r=t[4],i=t[8],n=t[12];var o=t[1],s=t[5],a=t[9],u=t[13];var l=t[2],h=t[6],f=t[10],c=t[14];var p=t[3],d=t[7],m=t[11],v=t[15];return p*(+n*a*h-i*u*h-n*s*f+r*u*f+i*s*c-r*a*c)+d*(+e*a*c-e*u*f+n*o*f-i*o*c+i*u*l-n*a*l)+m*(+e*u*h-e*s*c-n*o*h+r*o*c+n*s*l-r*u*l)+v*(-i*s*l-e*a*h+e*s*f+i*o*h-r*o*f+r*a*l)},transpose:function(){var t=this.elements;var e;e=t[1];t[1]=t[4];t[4]=e;e=t[2];t[2]=t[8];t[8]=e;e=t[6];t[6]=t[9];t[9]=e;e=t[3];t[3]=t[12];t[12]=e;e=t[7];t[7]=t[13];t[13]=e;e=t[11];t[11]=t[14];t[14]=e;return this},flattenToArrayOffset:function(t,e){var r=this.elements;t[e]=r[0];t[e+1]=r[1];t[e+2]=r[2];t[e+3]=r[3];t[e+4]=r[4];t[e+5]=r[5];t[e+6]=r[6];t[e+7]=r[7];t[e+8]=r[8];t[e+9]=r[9];t[e+10]=r[10];t[e+11]=r[11];t[e+12]=r[12];t[e+13]=r[13];t[e+14]=r[14];t[e+15]=r[15];return t},getPosition:function(){var t=new THREE.Vector3;return function(){THREE.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead.");var e=this.elements;return t.set(e[12],e[13],e[14])}}(),setPosition:function(t){var e=this.elements;e[12]=t.x;e[13]=t.y;e[14]=t.z;return this},getInverse:function(t,e){var r=this.elements;var i=t.elements;var n=i[0],o=i[4],s=i[8],a=i[12];var u=i[1],l=i[5],h=i[9],f=i[13];var c=i[2],p=i[6],d=i[10],m=i[14];var v=i[3],g=i[7],y=i[11],E=i[15];r[0]=h*m*g-f*d*g+f*p*y-l*m*y-h*p*E+l*d*E;r[4]=a*d*g-s*m*g-a*p*y+o*m*y+s*p*E-o*d*E;r[8]=s*f*g-a*h*g+a*l*y-o*f*y-s*l*E+o*h*E;r[12]=a*h*p-s*f*p-a*l*d+o*f*d+s*l*m-o*h*m;r[1]=f*d*v-h*m*v-f*c*y+u*m*y+h*c*E-u*d*E;r[5]=s*m*v-a*d*v+a*c*y-n*m*y-s*c*E+n*d*E;r[9]=a*h*v-s*f*v-a*u*y+n*f*y+s*u*E-n*h*E;r[13]=s*f*c-a*h*c+a*u*d-n*f*d-s*u*m+n*h*m;r[2]=l*m*v-f*p*v+f*c*g-u*m*g-l*c*E+u*p*E;r[6]=a*p*v-o*m*v-a*c*g+n*m*g+o*c*E-n*p*E;r[10]=o*f*v-a*l*v+a*u*g-n*f*g-o*u*E+n*l*E;r[14]=a*l*c-o*f*c-a*u*p+n*f*p+o*u*m-n*l*m;r[3]=h*p*v-l*d*v-h*c*g+u*d*g+l*c*y-u*p*y;r[7]=o*d*v-s*p*v+s*c*g-n*d*g-o*c*y+n*p*y;r[11]=s*l*v-o*h*v-s*u*g+n*h*g+o*u*y-n*l*y;r[15]=o*h*c-s*l*c+s*u*p-n*h*p-o*u*d+n*l*d;var _=n*r[0]+u*r[4]+c*r[8]+v*r[12];if(_==0){var x="THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0";if(e||false){throw new Error(x)}else{THREE.warn(x)}this.identity();return this}this.multiplyScalar(1/_);return this},translate:function(t){THREE.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(t){THREE.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(t){THREE.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(t){THREE.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(t,e){THREE.error("THREE.Matrix4: .rotateByAxis() has been removed.")},scale:function(t){var e=this.elements;var r=t.x,i=t.y,n=t.z;e[0]*=r;e[4]*=i;e[8]*=n;e[1]*=r;e[5]*=i;e[9]*=n;e[2]*=r;e[6]*=i;e[10]*=n;e[3]*=r;e[7]*=i;e[11]*=n;return this},getMaxScaleOnAxis:function(){var t=this.elements;var e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2];var r=t[4]*t[4]+t[5]*t[5]+t[6]*t[6];var i=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,Math.max(r,i)))},makeTranslation:function(t,e,r){this.set(1,0,0,t,0,1,0,e,0,0,1,r,0,0,0,1);return this},makeRotationX:function(t){var e=Math.cos(t),r=Math.sin(t);this.set(1,0,0,0,0,e,-r,0,0,r,e,0,0,0,0,1);return this},makeRotationY:function(t){var e=Math.cos(t),r=Math.sin(t);this.set(e,0,r,0,0,1,0,0,-r,0,e,0,0,0,0,1);return this},makeRotationZ:function(t){var e=Math.cos(t),r=Math.sin(t);this.set(e,-r,0,0,r,e,0,0,0,0,1,0,0,0,0,1);return this},makeRotationAxis:function(t,e){var r=Math.cos(e);var i=Math.sin(e);var n=1-r;var o=t.x,s=t.y,a=t.z;var u=n*o,l=n*s;this.set(u*o+r,u*s-i*a,u*a+i*s,0,u*s+i*a,l*s+r,l*a-i*o,0,u*a-i*s,l*a+i*o,n*a*a+r,0,0,0,0,1);return this},makeScale:function(t,e,r){this.set(t,0,0,0,0,e,0,0,0,0,r,0,0,0,0,1);return this},compose:function(t,e,r){this.makeRotationFromQuaternion(e);this.scale(r);this.setPosition(t);return this},decompose:function(){var t=new THREE.Vector3;var e=new THREE.Matrix4;return function(r,i,n){var o=this.elements;var s=t.set(o[0],o[1],o[2]).length();var a=t.set(o[4],o[5],o[6]).length();var u=t.set(o[8],o[9],o[10]).length();var l=this.determinant();if(l<0){s=-s}r.x=o[12];r.y=o[13];r.z=o[14];e.elements.set(this.elements);var h=1/s;var f=1/a;var c=1/u;e.elements[0]*=h;e.elements[1]*=h;e.elements[2]*=h;e.elements[4]*=f;e.elements[5]*=f;e.elements[6]*=f;e.elements[8]*=c;e.elements[9]*=c;e.elements[10]*=c;i.setFromRotationMatrix(e);n.x=s;n.y=a;n.z=u;return this}}(),makeFrustum:function(t,e,r,i,n,o){var s=this.elements;var a=2*n/(e-t);var u=2*n/(i-r);var l=(e+t)/(e-t);var h=(i+r)/(i-r);var f=-(o+n)/(o-n);var c=-2*o*n/(o-n);s[0]=a;s[4]=0;s[8]=l;s[12]=0;s[1]=0;s[5]=u;s[9]=h;s[13]=0;s[2]=0;s[6]=0;s[10]=f;s[14]=c;s[3]=0;s[7]=0;s[11]=-1;s[15]=0;return this},makePerspective:function(t,e,r,i){var n=r*Math.tan(THREE.Math.degToRad(t*.5));var o=-n;var s=o*e;var a=n*e;return this.makeFrustum(s,a,o,n,r,i)},makeOrthographic:function(t,e,r,i,n,o){var s=this.elements;var a=e-t;var u=r-i;var l=o-n;var h=(e+t)/a;var f=(r+i)/u;var c=(o+n)/l;s[0]=2/a;s[4]=0;s[8]=0;s[12]=-h;s[1]=0;s[5]=2/u;s[9]=0;s[13]=-f;s[2]=0;s[6]=0;s[10]=-2/l;s[14]=-c;s[3]=0;s[7]=0;s[11]=0;s[15]=1;return this},fromArray:function(t){this.elements.set(t);return this},toArray:function(){var t=this.elements;return[t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15]]},clone:function(){return(new THREE.Matrix4).fromArray(this.elements)}};THREE.Ray=function(t,e){this.origin=t!==undefined?t:new THREE.Vector3;this.direction=e!==undefined?e:new THREE.Vector3};THREE.Ray.prototype={constructor:THREE.Ray,set:function(t,e){this.origin.copy(t);this.direction.copy(e);return this},copy:function(t){this.origin.copy(t.origin);this.direction.copy(t.direction);return this},at:function(t,e){var r=e||new THREE.Vector3;return r.copy(this.direction).multiplyScalar(t).add(this.origin)},recast:function(){var t=new THREE.Vector3;return function(e){this.origin.copy(this.at(e,t));return this}}(),closestPointToPoint:function(t,e){var r=e||new THREE.Vector3;r.subVectors(t,this.origin);var i=r.dot(this.direction);if(i<0){return r.copy(this.origin)}return r.copy(this.direction).multiplyScalar(i).add(this.origin)},distanceToPoint:function(){var t=new THREE.Vector3;return function(e){var r=t.subVectors(e,this.origin).dot(this.direction);if(r<0){return this.origin.distanceTo(e)}t.copy(this.direction).multiplyScalar(r).add(this.origin);return t.distanceTo(e)}}(),distanceSqToSegment:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Vector3;return function(i,n,o,s){t.copy(i).add(n).multiplyScalar(.5);e.copy(n).sub(i).normalize();r.copy(this.origin).sub(t);var a=i.distanceTo(n)*.5;var u=-this.direction.dot(e);var l=r.dot(this.direction);var h=-r.dot(e);var f=r.lengthSq();var c=Math.abs(1-u*u);var p,d,m,v;if(c>0){p=u*h-l;d=u*l-h;v=a*c;if(p>=0){if(d>=-v){if(d<=v){var g=1/c;p*=g;d*=g;m=p*(p+u*d+2*l)+d*(u*p+d+2*h)+f}else{d=a;p=Math.max(0,-(u*d+l));m=-p*p+d*(d+2*h)+f}}else{d=-a;p=Math.max(0,-(u*d+l));m=-p*p+d*(d+2*h)+f}}else{if(d<=-v){p=Math.max(0,-(-u*a+l));d=p>0?-a:Math.min(Math.max(-a,-h),a);m=-p*p+d*(d+2*h)+f}else if(d<=v){p=0;d=Math.min(Math.max(-a,-h),a);m=d*(d+2*h)+f}else{p=Math.max(0,-(u*a+l));d=p>0?a:Math.min(Math.max(-a,-h),a);m=-p*p+d*(d+2*h)+f}}}else{d=u>0?-a:a;p=Math.max(0,-(u*d+l));m=-p*p+d*(d+2*h)+f}if(o){o.copy(this.direction).multiplyScalar(p).add(this.origin)}if(s){s.copy(e).multiplyScalar(d).add(t)}return m}}(),isIntersectionSphere:function(t){return this.distanceToPoint(t.center)<=t.radius},intersectSphere:function(){var t=new THREE.Vector3;return function(e,r){t.subVectors(e.center,this.origin);var i=t.dot(this.direction);var n=t.dot(t)-i*i;var o=e.radius*e.radius;if(n>o)return null;var s=Math.sqrt(o-n);var a=i-s;var u=i+s;if(a<0&&u<0)return null;if(a<0)return this.at(u,r);return this.at(a,r)}}(),isIntersectionPlane:function(t){var e=t.distanceToPoint(this.origin);if(e===0){return true}var r=t.normal.dot(this.direction);if(r*e<0){return true}return false},distanceToPlane:function(t){var e=t.normal.dot(this.direction);if(e==0){if(t.distanceToPoint(this.origin)==0){return 0}return null}var r=-(this.origin.dot(t.normal)+t.constant)/e;return r>=0?r:null},intersectPlane:function(t,e){var r=this.distanceToPlane(t);if(r===null){return null}return this.at(r,e)},isIntersectionBox:function(){var t=new THREE.Vector3;return function(e){return this.intersectBox(e,t)!==null}}(),intersectBox:function(t,e){var r,i,n,o,s,a;var u=1/this.direction.x,l=1/this.direction.y,h=1/this.direction.z;var f=this.origin;if(u>=0){r=(t.min.x-f.x)*u;i=(t.max.x-f.x)*u}else{r=(t.max.x-f.x)*u;i=(t.min.x-f.x)*u}if(l>=0){n=(t.min.y-f.y)*l;o=(t.max.y-f.y)*l}else{n=(t.max.y-f.y)*l;o=(t.min.y-f.y)*l}if(r>o||n>i)return null;if(n>r||r!==r)r=n;if(o<i||i!==i)i=o;if(h>=0){s=(t.min.z-f.z)*h;a=(t.max.z-f.z)*h}else{s=(t.max.z-f.z)*h;a=(t.min.z-f.z)*h}if(r>a||s>i)return null;if(s>r||r!==r)r=s;if(a<i||i!==i)i=a;if(i<0)return null;return this.at(r>=0?r:i,e)},intersectTriangle:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Vector3;var i=new THREE.Vector3;return function(n,o,s,a,u){e.subVectors(o,n);r.subVectors(s,n);i.crossVectors(e,r);var l=this.direction.dot(i);var h;if(l>0){if(a)return null;h=1}else if(l<0){h=-1;l=-l}else{return null}t.subVectors(this.origin,n);var f=h*this.direction.dot(r.crossVectors(t,r));if(f<0){return null}var c=h*this.direction.dot(e.cross(t));if(c<0){return null}if(f+c>l){return null}var p=-h*t.dot(i);if(p<0){return null}return this.at(p/l,u)}}(),applyMatrix4:function(t){this.direction.add(this.origin).applyMatrix4(t);this.origin.applyMatrix4(t);this.direction.sub(this.origin);this.direction.normalize();return this},equals:function(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)},clone:function(){return(new THREE.Ray).copy(this)}};THREE.Sphere=function(t,e){this.center=t!==undefined?t:new THREE.Vector3;this.radius=e!==undefined?e:0};THREE.Sphere.prototype={constructor:THREE.Sphere,set:function(t,e){this.center.copy(t);this.radius=e;return this},setFromPoints:function(){var t=new THREE.Box3;return function(e,r){var i=this.center;if(r!==undefined){i.copy(r)}else{t.setFromPoints(e).center(i)}var n=0;for(var o=0,s=e.length;o<s;o++){n=Math.max(n,i.distanceToSquared(e[o]))}this.radius=Math.sqrt(n);return this}}(),copy:function(t){this.center.copy(t.center);this.radius=t.radius;return this},empty:function(){return this.radius<=0},containsPoint:function(t){return t.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(t){return t.distanceTo(this.center)-this.radius},intersectsSphere:function(t){var e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e},clampPoint:function(t,e){var r=this.center.distanceToSquared(t);var i=e||new THREE.Vector3;i.copy(t);if(r>this.radius*this.radius){i.sub(this.center).normalize();i.multiplyScalar(this.radius).add(this.center)}return i},getBoundingBox:function(t){var e=t||new THREE.Box3;e.set(this.center,this.center);e.expandByScalar(this.radius);return e},applyMatrix4:function(t){this.center.applyMatrix4(t);this.radius=this.radius*t.getMaxScaleOnAxis();return this},translate:function(t){this.center.add(t);return this},equals:function(t){return t.center.equals(this.center)&&t.radius===this.radius},clone:function(){return(new THREE.Sphere).copy(this)}};THREE.Frustum=function(t,e,r,i,n,o){this.planes=[t!==undefined?t:new THREE.Plane,e!==undefined?e:new THREE.Plane,r!==undefined?r:new THREE.Plane,i!==undefined?i:new THREE.Plane,n!==undefined?n:new THREE.Plane,o!==undefined?o:new THREE.Plane]};THREE.Frustum.prototype={constructor:THREE.Frustum,set:function(t,e,r,i,n,o){var s=this.planes;s[0].copy(t);s[1].copy(e);s[2].copy(r);s[3].copy(i);s[4].copy(n);s[5].copy(o);return this},copy:function(t){var e=this.planes;for(var r=0;r<6;r++){e[r].copy(t.planes[r])}return this},setFromMatrix:function(t){var e=this.planes;var r=t.elements;var i=r[0],n=r[1],o=r[2],s=r[3];var a=r[4],u=r[5],l=r[6],h=r[7];var f=r[8],c=r[9],p=r[10],d=r[11];var m=r[12],v=r[13],g=r[14],y=r[15];e[0].setComponents(s-i,h-a,d-f,y-m).normalize();e[1].setComponents(s+i,h+a,d+f,y+m).normalize();e[2].setComponents(s+n,h+u,d+c,y+v).normalize();e[3].setComponents(s-n,h-u,d-c,y-v).normalize();e[4].setComponents(s-o,h-l,d-p,y-g).normalize();e[5].setComponents(s+o,h+l,d+p,y+g).normalize();return this},intersectsObject:function(){var t=new THREE.Sphere;return function(e){var r=e.geometry;if(r.boundingSphere===null)r.computeBoundingSphere();t.copy(r.boundingSphere);t.applyMatrix4(e.matrixWorld);return this.intersectsSphere(t)}}(),intersectsSphere:function(t){var e=this.planes;var r=t.center;var i=-t.radius;for(var n=0;n<6;n++){var o=e[n].distanceToPoint(r);if(o<i){return false}}return true},intersectsBox:function(){var t=new THREE.Vector3,e=new THREE.Vector3;return function(r){var i=this.planes;for(var n=0;n<6;n++){var o=i[n];t.x=o.normal.x>0?r.min.x:r.max.x;e.x=o.normal.x>0?r.max.x:r.min.x;t.y=o.normal.y>0?r.min.y:r.max.y;e.y=o.normal.y>0?r.max.y:r.min.y;t.z=o.normal.z>0?r.min.z:r.max.z;e.z=o.normal.z>0?r.max.z:r.min.z;var s=o.distanceToPoint(t);var a=o.distanceToPoint(e);if(s<0&&a<0){return false}}return true}}(),containsPoint:function(t){var e=this.planes;for(var r=0;r<6;r++){if(e[r].distanceToPoint(t)<0){return false}}return true},clone:function(){return(new THREE.Frustum).copy(this)}};THREE.Plane=function(t,e){this.normal=t!==undefined?t:new THREE.Vector3(1,0,0);this.constant=e!==undefined?e:0};THREE.Plane.prototype={constructor:THREE.Plane,set:function(t,e){this.normal.copy(t);this.constant=e;return this},setComponents:function(t,e,r,i){this.normal.set(t,e,r);this.constant=i;return this},setFromNormalAndCoplanarPoint:function(t,e){this.normal.copy(t);this.constant=-e.dot(this.normal);return this},setFromCoplanarPoints:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(r,i,n){var o=t.subVectors(n,i).cross(e.subVectors(r,i)).normalize();this.setFromNormalAndCoplanarPoint(o,r);return this}}(),copy:function(t){this.normal.copy(t.normal);this.constant=t.constant;return this},normalize:function(){var t=1/this.normal.length();this.normal.multiplyScalar(t);this.constant*=t;return this},negate:function(){this.constant*=-1;this.normal.negate();return this},distanceToPoint:function(t){return this.normal.dot(t)+this.constant},distanceToSphere:function(t){return this.distanceToPoint(t.center)-t.radius},projectPoint:function(t,e){return this.orthoPoint(t,e).sub(t).negate()},orthoPoint:function(t,e){var r=this.distanceToPoint(t);var i=e||new THREE.Vector3;return i.copy(this.normal).multiplyScalar(r)},isIntersectionLine:function(t){var e=this.distanceToPoint(t.start);var r=this.distanceToPoint(t.end);return e<0&&r>0||r<0&&e>0},intersectLine:function(){var t=new THREE.Vector3;return function(e,r){var i=r||new THREE.Vector3;var n=e.delta(t);var o=this.normal.dot(n);if(o==0){if(this.distanceToPoint(e.start)==0){return i.copy(e.start)}return undefined}var s=-(e.start.dot(this.normal)+this.constant)/o;if(s<0||s>1){return undefined}return i.copy(n).multiplyScalar(s).add(e.start)}}(),coplanarPoint:function(t){var e=t||new THREE.Vector3;return e.copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Matrix3;return function(i,n){var o=n||r.getNormalMatrix(i);var s=t.copy(this.normal).applyMatrix3(o);var a=this.coplanarPoint(e);a.applyMatrix4(i);this.setFromNormalAndCoplanarPoint(s,a);return this}}(),translate:function(t){this.constant=this.constant-t.dot(this.normal);return this},equals:function(t){return t.normal.equals(this.normal)&&t.constant==this.constant},clone:function(){return(new THREE.Plane).copy(this)}};THREE.Math={generateUUID:function(){var t="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");var e=new Array(36);var r=0,i;return function(){for(var n=0;n<36;n++){if(n==8||n==13||n==18||n==23){e[n]="-"}else if(n==14){e[n]="4"}else{if(r<=2)r=33554432+Math.random()*16777216|0;i=r&15;r=r>>4;e[n]=t[n==19?i&3|8:i]}}return e.join("")}}(),clamp:function(t,e,r){return t<e?e:t>r?r:t},clampBottom:function(t,e){return t<e?e:t},mapLinear:function(t,e,r,i,n){return i+(t-e)*(n-i)/(r-e)},smoothstep:function(t,e,r){if(t<=e)return 0;if(t>=r)return 1;t=(t-e)/(r-e);return t*t*(3-2*t)},smootherstep:function(t,e,r){if(t<=e)return 0;if(t>=r)return 1;t=(t-e)/(r-e);return t*t*t*(t*(t*6-15)+10)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(t,e){return Math.floor(this.randFloat(t,e))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},degToRad:function(){var t=Math.PI/180;return function(e){return e*t}}(),radToDeg:function(){var t=180/Math.PI;return function(e){return e*t}}(),isPowerOfTwo:function(t){return(t&t-1)===0&&t!==0},nextPowerOfTwo:function(t){t--;t|=t>>1;t|=t>>2;t|=t>>4;t|=t>>8;t|=t>>16;t++;return t}};THREE.Spline=function(t){this.points=t;var e=[],r={x:0,y:0,z:0},i,n,o,s,a,u,l,h,f;this.initFromArray=function(t){this.points=[];for(var e=0;e<t.length;e++){this.points[e]={x:t[e][0],y:t[e][1],z:t[e][2]}}};this.getPoint=function(t){i=(this.points.length-1)*t;n=Math.floor(i);o=i-n;e[0]=n===0?n:n-1;e[1]=n;e[2]=n>this.points.length-2?this.points.length-1:n+1;e[3]=n>this.points.length-3?this.points.length-1:n+2;u=this.points[e[0]];l=this.points[e[1]];h=this.points[e[2]];f=this.points[e[3]];s=o*o;a=o*s;r.x=c(u.x,l.x,h.x,f.x,o,s,a);r.y=c(u.y,l.y,h.y,f.y,o,s,a);r.z=c(u.z,l.z,h.z,f.z,o,s,a);return r};this.getControlPointsArray=function(){var t,e,r=this.points.length,i=[];for(t=0;t<r;t++){e=this.points[t];i[t]=[e.x,e.y,e.z]}return i};this.getLength=function(t){var e,r,i,n,o=0,s=0,a=0,u=new THREE.Vector3,l=new THREE.Vector3,h=[],f=0;h[0]=0;if(!t)t=100;i=this.points.length*t;u.copy(this.points[0]);for(e=1;e<i;e++){r=e/i;n=this.getPoint(r);l.copy(n);f+=l.distanceTo(u);u.copy(n);o=(this.points.length-1)*r;s=Math.floor(o);if(s!=a){h[s]=f;a=s}}h[h.length]=f;return{chunks:h,total:f}};this.reparametrizeByArcLength=function(t){var e,r,i,n,o,s,a,u,l=[],h=new THREE.Vector3,f=this.getLength();l.push(h.copy(this.points[0]).clone());for(e=1;e<this.points.length;e++){s=f.chunks[e]-f.chunks[e-1];a=Math.ceil(t*s/f.total);n=(e-1)/(this.points.length-1);o=e/(this.points.length-1);for(r=1;r<a-1;r++){i=n+r*(1/a)*(o-n);u=this.getPoint(i);l.push(h.copy(u).clone())}l.push(h.copy(this.points[e]).clone())}this.points=l};function c(t,e,r,i,n,o,s){var a=(r-t)*.5,u=(i-e)*.5;return(2*(e-r)+a+u)*s+(-3*(e-r)-2*a-u)*o+a*n+e}};THREE.Triangle=function(t,e,r){this.a=t!==undefined?t:new THREE.Vector3;this.b=e!==undefined?e:new THREE.Vector3;this.c=r!==undefined?r:new THREE.Vector3};THREE.Triangle.normal=function(){var t=new THREE.Vector3;return function(e,r,i,n){var o=n||new THREE.Vector3;o.subVectors(i,r);t.subVectors(e,r);o.cross(t);var s=o.lengthSq();if(s>0){return o.multiplyScalar(1/Math.sqrt(s))}return o.set(0,0,0)}}();THREE.Triangle.barycoordFromPoint=function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Vector3;return function(i,n,o,s,a){t.subVectors(s,n);e.subVectors(o,n);r.subVectors(i,n);var u=t.dot(t);var l=t.dot(e);var h=t.dot(r);var f=e.dot(e);var c=e.dot(r);var p=u*f-l*l;var d=a||new THREE.Vector3;if(p==0){return d.set(-2,-1,-1)}var m=1/p;var v=(f*h-l*c)*m;var g=(u*c-l*h)*m;return d.set(1-v-g,g,v)}}();THREE.Triangle.containsPoint=function(){var t=new THREE.Vector3;return function(e,r,i,n){var o=THREE.Triangle.barycoordFromPoint(e,r,i,n,t);return o.x>=0&&o.y>=0&&o.x+o.y<=1}}();THREE.Triangle.prototype={constructor:THREE.Triangle,set:function(t,e,r){this.a.copy(t);this.b.copy(e);this.c.copy(r);return this},setFromPointsAndIndices:function(t,e,r,i){this.a.copy(t[e]);this.b.copy(t[r]);this.c.copy(t[i]);return this},copy:function(t){this.a.copy(t.a);this.b.copy(t.b);this.c.copy(t.c);return this},area:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(){t.subVectors(this.c,this.b);e.subVectors(this.a,this.b);return t.cross(e).length()*.5}}(),midpoint:function(t){var e=t||new THREE.Vector3;return e.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(t){return THREE.Triangle.normal(this.a,this.b,this.c,t)},plane:function(t){var e=t||new THREE.Plane;return e.setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(t,e){return THREE.Triangle.barycoordFromPoint(t,this.a,this.b,this.c,e)},containsPoint:function(t){return THREE.Triangle.containsPoint(t,this.a,this.b,this.c)},equals:function(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)},clone:function(){return(new THREE.Triangle).copy(this)}};THREE.Clock=function(t){this.autoStart=t!==undefined?t:true;this.startTime=0;this.oldTime=0;this.elapsedTime=0;this.running=false};THREE.Clock.prototype={constructor:THREE.Clock,start:function(){this.startTime=self.performance!==undefined&&self.performance.now!==undefined?self.performance.now():Date.now();this.oldTime=this.startTime;this.running=true},stop:function(){this.getElapsedTime();this.running=false},getElapsedTime:function(){this.getDelta();return this.elapsedTime},getDelta:function(){var t=0;if(this.autoStart&&!this.running){this.start()}if(this.running){var e=self.performance!==undefined&&self.performance.now!==undefined?self.performance.now():Date.now();t=.001*(e-this.oldTime);this.oldTime=e;this.elapsedTime+=t}return t}};THREE.EventDispatcher=function(){};THREE.EventDispatcher.prototype={constructor:THREE.EventDispatcher,apply:function(t){t.addEventListener=THREE.EventDispatcher.prototype.addEventListener;t.hasEventListener=THREE.EventDispatcher.prototype.hasEventListener;t.removeEventListener=THREE.EventDispatcher.prototype.removeEventListener;t.dispatchEvent=THREE.EventDispatcher.prototype.dispatchEvent},addEventListener:function(t,e){if(this._listeners===undefined)this._listeners={};var r=this._listeners;if(r[t]===undefined){r[t]=[]}if(r[t].indexOf(e)===-1){r[t].push(e)}},hasEventListener:function(t,e){if(this._listeners===undefined)return false;var r=this._listeners;if(r[t]!==undefined&&r[t].indexOf(e)!==-1){return true}return false},removeEventListener:function(t,e){if(this._listeners===undefined)return;var r=this._listeners;var i=r[t];if(i!==undefined){var n=i.indexOf(e);if(n!==-1){i.splice(n,1)}}},dispatchEvent:function(t){if(this._listeners===undefined)return;var e=this._listeners;var r=e[t.type];if(r!==undefined){t.target=this;var i=[];var n=r.length;for(var o=0;o<n;o++){i[o]=r[o]}for(var o=0;o<n;o++){i[o].call(this,t)}}}};(function(t){t.Raycaster=function(e,r,i,n){this.ray=new t.Ray(e,r);this.near=i||0;this.far=n||Infinity;this.params={Sprite:{},Mesh:{},PointCloud:{threshold:1},LOD:{},Line:{}}};var e=function(t,e){return t.distance-e.distance};var r=function(t,e,i,n){t.raycast(e,i);if(n===true){var o=t.children;for(var s=0,a=o.length;s<a;s++){r(o[s],e,i,true)}}};t.Raycaster.prototype={constructor:t.Raycaster,precision:1e-4,linePrecision:1,set:function(t,e){this.ray.set(t,e)},setFromCamera:function(e,r){if(r instanceof t.PerspectiveCamera){this.ray.origin.copy(r.position);this.ray.direction.set(e.x,e.y,.5).unproject(r).sub(r.position).normalize()}else if(r instanceof t.OrthographicCamera){this.ray.origin.set(e.x,e.y,-1).unproject(r);this.ray.direction.set(0,0,-1).transformDirection(r.matrixWorld)}else{t.error("THREE.Raycaster: Unsupported camera type.")}},intersectObject:function(t,i){var n=[];r(t,this,n,i);n.sort(e);return n},intersectObjects:function(i,n){var o=[];if(i instanceof Array===false){t.warn("THREE.Raycaster.intersectObjects: objects is not an Array.");return o}for(var s=0,a=i.length;s<a;s++){r(i[s],this,o,n)}o.sort(e);return o}}})(THREE);THREE.Object3D=function(){Object.defineProperty(this,"id",{value:THREE.Object3DIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Object3D";this.parent=undefined;this.children=[];this.up=THREE.Object3D.DefaultUp.clone();var t=new THREE.Vector3;var e=new THREE.Euler;var r=new THREE.Quaternion;var i=new THREE.Vector3(1,1,1);var n=function(){r.setFromEuler(e,false)};var o=function(){e.setFromQuaternion(r,undefined,false)};e.onChange(n);r.onChange(o);Object.defineProperties(this,{position:{enumerable:true,value:t},rotation:{enumerable:true,value:e},quaternion:{enumerable:true,value:r},scale:{enumerable:true,value:i}});this.rotationAutoUpdate=true;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixAutoUpdate=true;this.matrixWorldNeedsUpdate=false;this.visible=true;this.castShadow=false;this.receiveShadow=false;this.frustumCulled=true;this.renderOrder=0;this.userData={}};THREE.Object3D.DefaultUp=new THREE.Vector3(0,1,0);THREE.Object3D.prototype={constructor:THREE.Object3D,get eulerOrder(){THREE.warn("THREE.Object3D: .eulerOrder has been moved to .rotation.order.");return this.rotation.order},set eulerOrder(t){THREE.warn("THREE.Object3D: .eulerOrder has been moved to .rotation.order.");this.rotation.order=t},get useQuaternion(){THREE.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set useQuaternion(t){THREE.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},applyMatrix:function(t){this.matrix.multiplyMatrices(t,this.matrix);this.matrix.decompose(this.position,this.quaternion,this.scale)},setRotationFromAxisAngle:function(t,e){this.quaternion.setFromAxisAngle(t,e)},setRotationFromEuler:function(t){this.quaternion.setFromEuler(t,true)},setRotationFromMatrix:function(t){this.quaternion.setFromRotationMatrix(t)},setRotationFromQuaternion:function(t){this.quaternion.copy(t)},rotateOnAxis:function(){var t=new THREE.Quaternion;return function(e,r){t.setFromAxisAngle(e,r);this.quaternion.multiply(t);return this}}(),rotateX:function(){var t=new THREE.Vector3(1,0,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateY:function(){var t=new THREE.Vector3(0,1,0);return function(e){return this.rotateOnAxis(t,e)}}(),rotateZ:function(){var t=new THREE.Vector3(0,0,1);return function(e){return this.rotateOnAxis(t,e)}}(),translateOnAxis:function(){var t=new THREE.Vector3;return function(e,r){t.copy(e).applyQuaternion(this.quaternion);this.position.add(t.multiplyScalar(r));return this}}(),translate:function(t,e){THREE.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead.");return this.translateOnAxis(e,t)},translateX:function(){var t=new THREE.Vector3(1,0,0);return function(e){return this.translateOnAxis(t,e)}}(),translateY:function(){var t=new THREE.Vector3(0,1,0);return function(e){return this.translateOnAxis(t,e)}}(),translateZ:function(){var t=new THREE.Vector3(0,0,1);return function(e){return this.translateOnAxis(t,e)}}(),localToWorld:function(t){return t.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var t=new THREE.Matrix4;return function(e){return e.applyMatrix4(t.getInverse(this.matrixWorld))}}(),lookAt:function(){var t=new THREE.Matrix4;return function(e){t.lookAt(e,this.position,this.up);this.quaternion.setFromRotationMatrix(t)}}(),add:function(t){if(arguments.length>1){for(var e=0;e<arguments.length;e++){this.add(arguments[e])}return this}if(t===this){THREE.error("THREE.Object3D.add: object can't be added as a child of itself.",t);return this}if(t instanceof THREE.Object3D){if(t.parent!==undefined){t.parent.remove(t)}t.parent=this;t.dispatchEvent({type:"added"});this.children.push(t)}else{THREE.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t)}return this},remove:function(t){if(arguments.length>1){for(var e=0;e<arguments.length;e++){this.remove(arguments[e])}}var r=this.children.indexOf(t);if(r!==-1){t.parent=undefined;t.dispatchEvent({type:"removed"});this.children.splice(r,1)}},getChildByName:function(t){THREE.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName().");return this.getObjectByName(t)},getObjectById:function(t){return this.getObjectByProperty("id",t)},getObjectByName:function(t){return this.getObjectByProperty("name",t)},getObjectByProperty:function(t,e){if(this[t]===e)return this;for(var r=0,i=this.children.length;r<i;r++){var n=this.children[r];var o=n.getObjectByProperty(t,e);if(o!==undefined){return o}}return undefined},getWorldPosition:function(t){var e=t||new THREE.Vector3;this.updateMatrixWorld(true);return e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(r){var i=r||new THREE.Quaternion;this.updateMatrixWorld(true);this.matrixWorld.decompose(t,i,e);return i}}(),getWorldRotation:function(){var t=new THREE.Quaternion;return function(e){var r=e||new THREE.Euler;this.getWorldQuaternion(t);return r.setFromQuaternion(t,this.rotation.order,false)}}(),getWorldScale:function(){var t=new THREE.Vector3;var e=new THREE.Quaternion;return function(r){var i=r||new THREE.Vector3;this.updateMatrixWorld(true);this.matrixWorld.decompose(t,e,i);return i}}(),getWorldDirection:function(){var t=new THREE.Quaternion;return function(e){var r=e||new THREE.Vector3;this.getWorldQuaternion(t);return r.set(0,0,1).applyQuaternion(t)}}(),raycast:function(){},traverse:function(t){t(this);for(var e=0,r=this.children.length;e<r;e++){this.children[e].traverse(t)}},traverseVisible:function(t){if(this.visible===false)return;t(this);for(var e=0,r=this.children.length;e<r;e++){this.children[e].traverseVisible(t)}},traverseAncestors:function(t){if(this.parent){t(this.parent);this.parent.traverseAncestors(t)}},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale);this.matrixWorldNeedsUpdate=true},updateMatrixWorld:function(t){if(this.matrixAutoUpdate===true)this.updateMatrix();if(this.matrixWorldNeedsUpdate===true||t===true){if(this.parent===undefined){this.matrixWorld.copy(this.matrix)}else{this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)}this.matrixWorldNeedsUpdate=false;t=true}for(var e=0,r=this.children.length;e<r;e++){this.children[e].updateMatrixWorld(t)}},toJSON:function(){var t={metadata:{version:4.3,type:"Object",generator:"ObjectExporter"}};var e={};var r=function(r){if(t.geometries===undefined){t.geometries=[]}if(e[r.uuid]===undefined){var i=r.toJSON();delete i.metadata;e[r.uuid]=i;t.geometries.push(i)}return r.uuid};var i={};var n=function(e){if(t.materials===undefined){t.materials=[]}if(i[e.uuid]===undefined){var r=e.toJSON();delete r.metadata;i[e.uuid]=r;t.materials.push(r)}return e.uuid};var o=function(t){var e={};e.uuid=t.uuid;e.type=t.type;if(t.name!=="")e.name=t.name;if(JSON.stringify(t.userData)!=="{}")e.userData=t.userData;if(t.visible!==true)e.visible=t.visible;if(t instanceof THREE.PerspectiveCamera){e.fov=t.fov;e.aspect=t.aspect;e.near=t.near;e.far=t.far}else if(t instanceof THREE.OrthographicCamera){e.left=t.left;e.right=t.right;e.top=t.top;e.bottom=t.bottom;e.near=t.near;e.far=t.far}else if(t instanceof THREE.AmbientLight){e.color=t.color.getHex()}else if(t instanceof THREE.DirectionalLight){e.color=t.color.getHex();e.intensity=t.intensity}else if(t instanceof THREE.PointLight){e.color=t.color.getHex();e.intensity=t.intensity;e.distance=t.distance;e.decay=t.decay}else if(t instanceof THREE.SpotLight){e.color=t.color.getHex();e.intensity=t.intensity;e.distance=t.distance;e.angle=t.angle;e.exponent=t.exponent;e.decay=t.decay}else if(t instanceof THREE.HemisphereLight){e.color=t.color.getHex();e.groundColor=t.groundColor.getHex()}else if(t instanceof THREE.Mesh||t instanceof THREE.Line||t instanceof THREE.PointCloud){e.geometry=r(t.geometry);e.material=n(t.material);if(t instanceof THREE.Line)e.mode=t.mode}else if(t instanceof THREE.Sprite){e.material=n(t.material)}e.matrix=t.matrix.toArray();if(t.children.length>0){e.children=[];for(var i=0;i<t.children.length;i++){e.children.push(o(t.children[i]))}}return e};t.object=o(this);return t},clone:function(t,e){if(t===undefined)t=new THREE.Object3D;if(e===undefined)e=true;t.name=this.name;t.up.copy(this.up);t.position.copy(this.position);t.quaternion.copy(this.quaternion);t.scale.copy(this.scale);t.rotationAutoUpdate=this.rotationAutoUpdate;t.matrix.copy(this.matrix);t.matrixWorld.copy(this.matrixWorld);t.matrixAutoUpdate=this.matrixAutoUpdate;t.matrixWorldNeedsUpdate=this.matrixWorldNeedsUpdate;t.visible=this.visible;t.castShadow=this.castShadow;t.receiveShadow=this.receiveShadow;t.frustumCulled=this.frustumCulled;t.userData=JSON.parse(JSON.stringify(this.userData));if(e===true){for(var r=0;r<this.children.length;r++){var i=this.children[r];t.add(i.clone())}}return t}};THREE.EventDispatcher.prototype.apply(THREE.Object3D.prototype);THREE.Object3DIdCount=0;THREE.Face3=function(t,e,r,i,n,o){this.a=t;this.b=e;this.c=r;this.normal=i instanceof THREE.Vector3?i:new THREE.Vector3;this.vertexNormals=i instanceof Array?i:[];this.color=n instanceof THREE.Color?n:new THREE.Color;this.vertexColors=n instanceof Array?n:[];this.vertexTangents=[];this.materialIndex=o!==undefined?o:0};THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var t=new THREE.Face3(this.a,this.b,this.c);t.normal.copy(this.normal);t.color.copy(this.color);t.materialIndex=this.materialIndex;for(var e=0,r=this.vertexNormals.length;e<r;e++){t.vertexNormals[e]=this.vertexNormals[e].clone()}for(var e=0,r=this.vertexColors.length;e<r;e++){t.vertexColors[e]=this.vertexColors[e].clone()}for(var e=0,r=this.vertexTangents.length;e<r;e++){t.vertexTangents[e]=this.vertexTangents[e].clone()}return t}};THREE.Face4=function(t,e,r,i,n,o,s){THREE.warn("THREE.Face4 has been removed. A THREE.Face3 will be created instead.");return new THREE.Face3(t,e,r,n,o,s)};THREE.BufferAttribute=function(t,e){this.array=t;this.itemSize=e;this.needsUpdate=false};THREE.BufferAttribute.prototype={constructor:THREE.BufferAttribute,get length(){return this.array.length},copyAt:function(t,e,r){t*=this.itemSize;r*=e.itemSize;for(var i=0,n=this.itemSize;i<n;i++){this.array[t+i]=e.array[r+i]}return this},set:function(t,e){if(e===undefined)e=0;this.array.set(t,e);return this},setX:function(t,e){this.array[t*this.itemSize]=e;return this},setY:function(t,e){this.array[t*this.itemSize+1]=e;return this},setZ:function(t,e){this.array[t*this.itemSize+2]=e;return this},setXY:function(t,e,r){t*=this.itemSize;this.array[t]=e;this.array[t+1]=r;return this},setXYZ:function(t,e,r,i){t*=this.itemSize;this.array[t]=e;this.array[t+1]=r;this.array[t+2]=i;return this},setXYZW:function(t,e,r,i,n){t*=this.itemSize;this.array[t]=e;this.array[t+1]=r;this.array[t+2]=i;this.array[t+3]=n;return this},clone:function(){return new THREE.BufferAttribute(new this.array.constructor(this.array),this.itemSize)}};THREE.Int8Attribute=function(t,e){THREE.warn("THREE.Int8Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Uint8Attribute=function(t,e){THREE.warn("THREE.Uint8Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Uint8ClampedAttribute=function(t,e){THREE.warn("THREE.Uint8ClampedAttribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Int16Attribute=function(t,e){THREE.warn("THREE.Int16Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Uint16Attribute=function(t,e){THREE.warn("THREE.Uint16Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Int32Attribute=function(t,e){THREE.warn("THREE.Int32Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Uint32Attribute=function(t,e){THREE.warn("THREE.Uint32Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Float32Attribute=function(t,e){THREE.warn("THREE.Float32Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.Float64Attribute=function(t,e){THREE.warn("THREE.Float64Attribute has been removed. Use THREE.BufferAttribute( array, itemSize ) instead.");return new THREE.BufferAttribute(t,e)};THREE.DynamicBufferAttribute=function(t,e){THREE.BufferAttribute.call(this,t,e);this.updateRange={offset:0,count:-1}};THREE.DynamicBufferAttribute.prototype=Object.create(THREE.BufferAttribute.prototype);THREE.DynamicBufferAttribute.prototype.constructor=THREE.DynamicBufferAttribute;THREE.DynamicBufferAttribute.prototype.clone=function(){return new THREE.DynamicBufferAttribute(new this.array.constructor(this.array),this.itemSize)};THREE.BufferGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="BufferGeometry";this.attributes={};this.attributesKeys=[];this.drawcalls=[];this.offsets=this.drawcalls;this.boundingBox=null;this.boundingSphere=null};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,addAttribute:function(t,e){if(e instanceof THREE.BufferAttribute===false){THREE.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute ).");this.attributes[t]={array:arguments[1],itemSize:arguments[2]};return}this.attributes[t]=e;this.attributesKeys=Object.keys(this.attributes)},getAttribute:function(t){return this.attributes[t]},addDrawCall:function(t,e,r){this.drawcalls.push({start:t,count:e,index:r!==undefined?r:0})},applyMatrix:function(t){var e=this.attributes.position;if(e!==undefined){t.applyToVector3Array(e.array);e.needsUpdate=true}var r=this.attributes.normal;if(r!==undefined){var i=(new THREE.Matrix3).getNormalMatrix(t);i.applyToVector3Array(r.array);r.needsUpdate=true}if(this.boundingBox!==null){this.computeBoundingBox()}if(this.boundingSphere!==null){this.computeBoundingSphere()}},center:function(){this.computeBoundingBox();var t=this.boundingBox.center().negate();this.applyMatrix((new THREE.Matrix4).setPosition(t));return t},fromGeometry:function(t,e){e=e||{vertexColors:THREE.NoColors};var r=t.vertices;var i=t.faces;var n=t.faceVertexUvs;var o=e.vertexColors;var s=n[0].length>0;var a=i[0].vertexNormals.length==3;var u=new Float32Array(i.length*3*3);this.addAttribute("position",new THREE.BufferAttribute(u,3));var l=new Float32Array(i.length*3*3);this.addAttribute("normal",new THREE.BufferAttribute(l,3));if(o!==THREE.NoColors){var h=new Float32Array(i.length*3*3);this.addAttribute("color",new THREE.BufferAttribute(h,3))}if(s===true){var f=new Float32Array(i.length*3*2);this.addAttribute("uv",new THREE.BufferAttribute(f,2))}for(var c=0,p=0,d=0;c<i.length;c++,p+=6,d+=9){var m=i[c];var v=r[m.a];var g=r[m.b];var y=r[m.c];u[d]=v.x;u[d+1]=v.y;u[d+2]=v.z;u[d+3]=g.x;u[d+4]=g.y;u[d+5]=g.z;u[d+6]=y.x;u[d+7]=y.y;u[d+8]=y.z;if(a===true){var E=m.vertexNormals[0];var _=m.vertexNormals[1];var x=m.vertexNormals[2];l[d]=E.x;l[d+1]=E.y;l[d+2]=E.z;l[d+3]=_.x;l[d+4]=_.y;l[d+5]=_.z;l[d+6]=x.x;l[d+7]=x.y;l[d+8]=x.z}else{var b=m.normal;l[d]=b.x;l[d+1]=b.y;l[d+2]=b.z;l[d+3]=b.x;l[d+4]=b.y;l[d+5]=b.z;l[d+6]=b.x;l[d+7]=b.y;l[d+8]=b.z}if(o===THREE.FaceColors){var T=m.color;h[d]=T.r;h[d+1]=T.g;h[d+2]=T.b;h[d+3]=T.r;h[d+4]=T.g;h[d+5]=T.b;h[d+6]=T.r;h[d+7]=T.g;h[d+8]=T.b}else if(o===THREE.VertexColors){var w=m.vertexColors[0];var R=m.vertexColors[1];var H=m.vertexColors[2];h[d]=w.r;h[d+1]=w.g;h[d+2]=w.b;h[d+3]=R.r;h[d+4]=R.g;h[d+5]=R.b;h[d+6]=H.r;h[d+7]=H.g;h[d+8]=H.b}if(s===true){var M=n[0][c][0];var S=n[0][c][1];var k=n[0][c][2];f[p]=M.x;f[p+1]=M.y;f[p+2]=S.x;f[p+3]=S.y;f[p+4]=k.x;f[p+5]=k.y}}this.computeBoundingSphere();return this},computeBoundingBox:function(){var t=new THREE.Vector3;return function(){if(this.boundingBox===null){this.boundingBox=new THREE.Box3}var e=this.attributes.position.array;if(e){var r=this.boundingBox;r.makeEmpty();for(var i=0,n=e.length;i<n;i+=3){t.set(e[i],e[i+1],e[i+2]);r.expandByPoint(t)}}if(e===undefined||e.length===0){this.boundingBox.min.set(0,0,0);this.boundingBox.max.set(0,0,0)}if(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z)){THREE.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.')}}}(),computeBoundingSphere:function(){var t=new THREE.Box3;var e=new THREE.Vector3;return function(){if(this.boundingSphere===null){this.boundingSphere=new THREE.Sphere}var r=this.attributes.position.array;if(r){t.makeEmpty();var i=this.boundingSphere.center;for(var n=0,o=r.length;n<o;n+=3){e.set(r[n],r[n+1],r[n+2]);t.expandByPoint(e)}t.center(i);var s=0;for(var n=0,o=r.length;n<o;n+=3){e.set(r[n],r[n+1],r[n+2]);s=Math.max(s,i.distanceToSquared(e))}this.boundingSphere.radius=Math.sqrt(s);if(isNaN(this.boundingSphere.radius)){THREE.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.')}}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var t=this.attributes;if(t.position){var e=t.position.array;if(t.normal===undefined){this.addAttribute("normal",new THREE.BufferAttribute(new Float32Array(e.length),3))}else{var r=t.normal.array;for(var i=0,n=r.length;i<n;i++){r[i]=0}}var r=t.normal.array;var o,s,a,u=new THREE.Vector3,l=new THREE.Vector3,h=new THREE.Vector3,f=new THREE.Vector3,c=new THREE.Vector3;if(t.index){var p=t.index.array;var d=this.offsets.length>0?this.offsets:[{start:0,count:p.length,index:0}];for(var m=0,v=d.length;m<v;++m){var g=d[m].start;var y=d[m].count;var E=d[m].index;for(var i=g,n=g+y;i<n;i+=3){o=(E+p[i])*3;s=(E+p[i+1])*3;a=(E+p[i+2])*3;u.fromArray(e,o);l.fromArray(e,s);h.fromArray(e,a);f.subVectors(h,l);c.subVectors(u,l);f.cross(c);r[o]+=f.x;r[o+1]+=f.y;r[o+2]+=f.z;r[s]+=f.x;r[s+1]+=f.y;r[s+2]+=f.z;r[a]+=f.x;r[a+1]+=f.y;r[a+2]+=f.z}}}else{for(var i=0,n=e.length;i<n;i+=9){u.fromArray(e,i);l.fromArray(e,i+3);h.fromArray(e,i+6);f.subVectors(h,l);c.subVectors(u,l);f.cross(c);r[i]=f.x;r[i+1]=f.y;r[i+2]=f.z;r[i+3]=f.x;r[i+4]=f.y;r[i+5]=f.z;r[i+6]=f.x;r[i+7]=f.y;r[i+8]=f.z}}this.normalizeNormals();t.normal.needsUpdate=true}},computeTangents:function(){if(this.attributes.index===undefined||this.attributes.position===undefined||this.attributes.normal===undefined||this.attributes.uv===undefined){THREE.warn("THREE.BufferGeometry: Missing required attributes (index, position, normal or uv) in BufferGeometry.computeTangents()");return}var t=this.attributes.index.array;var e=this.attributes.position.array;var r=this.attributes.normal.array;var i=this.attributes.uv.array;var n=e.length/3;if(this.attributes.tangent===undefined){this.addAttribute("tangent",new THREE.BufferAttribute(new Float32Array(4*n),4))}var o=this.attributes.tangent.array;var s=[],a=[];for(var u=0;u<n;u++){s[u]=new THREE.Vector3;a[u]=new THREE.Vector3}var l=new THREE.Vector3,h=new THREE.Vector3,f=new THREE.Vector3,c=new THREE.Vector2,p=new THREE.Vector2,d=new THREE.Vector2,m,v,g,y,E,_,x,b,T,w,R;var H=new THREE.Vector3,M=new THREE.Vector3;function S(t,r,n){l.fromArray(e,t*3);h.fromArray(e,r*3);f.fromArray(e,n*3);c.fromArray(i,t*2);p.fromArray(i,r*2);d.fromArray(i,n*2);m=h.x-l.x;v=f.x-l.x;g=h.y-l.y;y=f.y-l.y;E=h.z-l.z;_=f.z-l.z;x=p.x-c.x;b=d.x-c.x;T=p.y-c.y;w=d.y-c.y;R=1/(x*w-b*T);H.set((w*m-T*v)*R,(w*g-T*y)*R,(w*E-T*_)*R);M.set((x*v-b*m)*R,(x*y-b*g)*R,(x*_-b*E)*R);s[t].add(H);s[r].add(H);s[n].add(H);a[t].add(M);a[r].add(M);a[n].add(M)}var k,A;var C,L;var P,z,D;if(this.drawcalls.length===0){this.addDrawCall(0,t.length,0)}var O=this.drawcalls;for(C=0,L=O.length;C<L;++C){var F=O[C].start;var U=O[C].count;var B=O[C].index;for(k=F,A=F+U;k<A;k+=3){P=B+t[k];z=B+t[k+1];D=B+t[k+2];S(P,z,D)}}var V=new THREE.Vector3,N=new THREE.Vector3;var I=new THREE.Vector3,j=new THREE.Vector3;var G,W,X;function q(t){I.fromArray(r,t*3);j.copy(I);W=s[t];V.copy(W);V.sub(I.multiplyScalar(I.dot(W))).normalize();N.crossVectors(j,W);X=N.dot(a[t]);G=X<0?-1:1;o[t*4]=V.x;o[t*4+1]=V.y;o[t*4+2]=V.z;o[t*4+3]=G}for(C=0,L=O.length;C<L;++C){var F=O[C].start;var U=O[C].count;var B=O[C].index;for(k=F,A=F+U;k<A;k+=3){P=B+t[k];z=B+t[k+1];D=B+t[k+2];q(P);q(z);q(D)}}},computeOffsets:function(t){if(t===undefined)t=65535;var e=this.attributes.index.array;var r=this.attributes.position.array;var i=e.length/3;var n=new Uint16Array(e.length);var o=0;var s=0;var a=[{start:0,count:0,index:0}];var u=a[0];var l=0;var h=0;var f=new Int32Array(6);var c=new Int32Array(r.length);var p=new Int32Array(r.length);for(var d=0;d<r.length;d++){c[d]=-1;p[d]=-1}for(var m=0;m<i;m++){h=0;for(var v=0;v<3;v++){var g=e[m*3+v];if(c[g]==-1){f[v*2]=g;f[v*2+1]=-1;h++}else if(c[g]<u.index){f[v*2]=g;f[v*2+1]=-1;l++}else{f[v*2]=g;f[v*2+1]=c[g]}}var y=s+h;if(y>u.index+t){var E={start:o,count:0,index:s};a.push(E);u=E;for(var _=0;_<6;_+=2){var x=f[_+1];if(x>-1&&x<u.index)f[_+1]=-1}}for(var _=0;_<6;_+=2){var g=f[_];var x=f[_+1];if(x===-1)x=s++;c[g]=x;p[x]=g;n[o++]=x-u.index;u.count++}}this.reorderBuffers(n,p,s);this.offsets=a;this.drawcalls=a;return a},merge:function(t,e){if(t instanceof THREE.BufferGeometry===false){THREE.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",t);return}if(e===undefined)e=0;var r=this.attributes;for(var i in r){if(t.attributes[i]===undefined)continue;var n=r[i];var o=n.array;var s=t.attributes[i];var a=s.array;var u=s.itemSize;for(var l=0,h=u*e;l<a.length;l++,h++){o[h]=a[l]}}return this},normalizeNormals:function(){var t=this.attributes.normal.array;var e,r,i,n;for(var o=0,s=t.length;o<s;o+=3){e=t[o];r=t[o+1];i=t[o+2];n=1/Math.sqrt(e*e+r*r+i*i);t[o]*=n;t[o+1]*=n;t[o+2]*=n}},reorderBuffers:function(t,e,r){var i={};for(var n in this.attributes){if(n=="index")continue;var o=this.attributes[n].array;i[n]=new o.constructor(this.attributes[n].itemSize*r)}for(var s=0;s<r;s++){var a=e[s];for(var n in this.attributes){if(n=="index")continue;var u=this.attributes[n].array;var l=this.attributes[n].itemSize;var h=i[n];for(var f=0;f<l;f++)h[s*l+f]=u[a*l+f]}}this.attributes["index"].array=t;for(var n in this.attributes){if(n=="index")continue;this.attributes[n].array=i[n];this.attributes[n].numItems=this.attributes[n].itemSize*r}},toJSON:function(){var t={metadata:{version:4,type:"BufferGeometry",generator:"BufferGeometryExporter"},uuid:this.uuid,type:this.type,data:{attributes:{}}};var e=this.attributes;var r=this.offsets;var i=this.boundingSphere;for(var n in e){var o=e[n];var s=Array.prototype.slice.call(o.array);t.data.attributes[n]={itemSize:o.itemSize,type:o.array.constructor.name,array:s}}if(r.length>0){t.data.offsets=JSON.parse(JSON.stringify(r))}if(i!==null){t.data.boundingSphere={center:i.center.toArray(),radius:i.radius}}return t},clone:function(){var t=new THREE.BufferGeometry;for(var e in this.attributes){var r=this.attributes[e];t.addAttribute(e,r.clone())}for(var i=0,n=this.offsets.length;i<n;i++){var o=this.offsets[i];t.offsets.push({start:o.start,index:o.index,count:o.count})}return t},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.BufferGeometry.prototype);THREE.Geometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Geometry";this.vertices=[];this.colors=[];this.faces=[];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.lineDistances=[];this.boundingBox=null;this.boundingSphere=null;this.hasTangents=false;this.dynamic=true;this.verticesNeedUpdate=false;this.elementsNeedUpdate=false;this.uvsNeedUpdate=false;this.normalsNeedUpdate=false;this.tangentsNeedUpdate=false;this.colorsNeedUpdate=false;this.lineDistancesNeedUpdate=false;this.groupsNeedUpdate=false};THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(t){var e=(new THREE.Matrix3).getNormalMatrix(t);for(var r=0,i=this.vertices.length;r<i;r++){var n=this.vertices[r];n.applyMatrix4(t)}for(var r=0,i=this.faces.length;r<i;r++){var o=this.faces[r];o.normal.applyMatrix3(e).normalize();for(var s=0,a=o.vertexNormals.length;s<a;s++){o.vertexNormals[s].applyMatrix3(e).normalize()}}if(this.boundingBox!==null){this.computeBoundingBox()}if(this.boundingSphere!==null){this.computeBoundingSphere()}this.verticesNeedUpdate=true;this.normalsNeedUpdate=true},fromBufferGeometry:function(t){var e=this;var r=t.attributes;var i=r.position.array;var n=r.index!==undefined?r.index.array:undefined;var o=r.normal!==undefined?r.normal.array:undefined;var s=r.color!==undefined?r.color.array:undefined;var a=r.uv!==undefined?r.uv.array:undefined;var u=[];var l=[];for(var h=0,f=0;h<i.length;h+=3,f+=2){e.vertices.push(new THREE.Vector3(i[h],i[h+1],i[h+2]));if(o!==undefined){u.push(new THREE.Vector3(o[h],o[h+1],o[h+2]))}if(s!==undefined){e.colors.push(new THREE.Color(s[h],s[h+1],s[h+2]))}if(a!==undefined){l.push(new THREE.Vector2(a[f],a[f+1]))}}var c=function(t,r,i){var n=o!==undefined?[u[t].clone(),u[r].clone(),u[i].clone()]:[];var h=s!==undefined?[e.colors[t].clone(),e.colors[r].clone(),e.colors[i].clone()]:[];e.faces.push(new THREE.Face3(t,r,i,n,h));if(a!==undefined){e.faceVertexUvs[0].push([l[t].clone(),l[r].clone(),l[i].clone()])}};if(n!==undefined){var p=t.drawcalls;if(p.length>0){for(var h=0;h<p.length;h++){var d=p[h];var m=d.start;var v=d.count;var g=d.index;for(var f=m,y=m+v;f<y;f+=3){c(g+n[f],g+n[f+1],g+n[f+2])}}}else{for(var h=0;h<n.length;h+=3){c(n[h],n[h+1],n[h+2])}}}else{for(var h=0;h<i.length/3;h+=3){c(h,h+1,h+2)}}this.computeFaceNormals();if(t.boundingBox!==null){this.boundingBox=t.boundingBox.clone()}if(t.boundingSphere!==null){this.boundingSphere=t.boundingSphere.clone()}return this},center:function(){this.computeBoundingBox();var t=this.boundingBox.center().negate();this.applyMatrix((new THREE.Matrix4).setPosition(t));return t},computeFaceNormals:function(){var t=new THREE.Vector3,e=new THREE.Vector3;for(var r=0,i=this.faces.length;r<i;r++){var n=this.faces[r];var o=this.vertices[n.a];var s=this.vertices[n.b];var a=this.vertices[n.c];t.subVectors(a,s);e.subVectors(o,s);t.cross(e);t.normalize();n.normal.copy(t)}},computeVertexNormals:function(t){var e,r,i,n,o,s;s=new Array(this.vertices.length);for(e=0,r=this.vertices.length;e<r;e++){s[e]=new THREE.Vector3}if(t){var a,u,l;var h=new THREE.Vector3,f=new THREE.Vector3;for(i=0,n=this.faces.length;i<n;i++){o=this.faces[i];a=this.vertices[o.a];u=this.vertices[o.b];l=this.vertices[o.c];h.subVectors(l,u);f.subVectors(a,u);h.cross(f);s[o.a].add(h);s[o.b].add(h);s[o.c].add(h)}}else{for(i=0,n=this.faces.length;i<n;i++){o=this.faces[i];s[o.a].add(o.normal);s[o.b].add(o.normal);s[o.c].add(o.normal)}}for(e=0,r=this.vertices.length;e<r;e++){s[e].normalize()}for(i=0,n=this.faces.length;i<n;i++){o=this.faces[i];o.vertexNormals[0]=s[o.a].clone();o.vertexNormals[1]=s[o.b].clone();o.vertexNormals[2]=s[o.c].clone()}},computeMorphNormals:function(){var t,e,r,i,n;for(r=0,i=this.faces.length;r<i;r++){n=this.faces[r];if(!n.__originalFaceNormal){n.__originalFaceNormal=n.normal.clone()}else{n.__originalFaceNormal.copy(n.normal)}if(!n.__originalVertexNormals)n.__originalVertexNormals=[];for(t=0,e=n.vertexNormals.length;t<e;t++){if(!n.__originalVertexNormals[t]){n.__originalVertexNormals[t]=n.vertexNormals[t].clone()}else{n.__originalVertexNormals[t].copy(n.vertexNormals[t])}}}var o=new THREE.Geometry;o.faces=this.faces;for(t=0,e=this.morphTargets.length;t<e;t++){if(!this.morphNormals[t]){this.morphNormals[t]={};this.morphNormals[t].faceNormals=[];this.morphNormals[t].vertexNormals=[];var s=this.morphNormals[t].faceNormals;var a=this.morphNormals[t].vertexNormals;var u,l;for(r=0,i=this.faces.length;r<i;r++){u=new THREE.Vector3;l={a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3};s.push(u);a.push(l)}}var h=this.morphNormals[t];o.vertices=this.morphTargets[t].vertices;o.computeFaceNormals();o.computeVertexNormals();var u,l;for(r=0,i=this.faces.length;r<i;r++){n=this.faces[r];u=h.faceNormals[r];l=h.vertexNormals[r];u.copy(n.normal);l.a.copy(n.vertexNormals[0]);l.b.copy(n.vertexNormals[1]);l.c.copy(n.vertexNormals[2])}}for(r=0,i=this.faces.length;r<i;r++){n=this.faces[r];n.normal=n.__originalFaceNormal;n.vertexNormals=n.__originalVertexNormals}},computeTangents:function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M=[],S=[],k=new THREE.Vector3,A=new THREE.Vector3,C=new THREE.Vector3,L=new THREE.Vector3,P=new THREE.Vector3,z;for(r=0,i=this.vertices.length;r<i;r++){M[r]=new THREE.Vector3;S[r]=new THREE.Vector3}function D(t,e,r,i,n,o,s){u=t.vertices[e];l=t.vertices[r];h=t.vertices[i];f=a[n];c=a[o];p=a[s];d=l.x-u.x;m=h.x-u.x;v=l.y-u.y;g=h.y-u.y;y=l.z-u.z;E=h.z-u.z;_=c.x-f.x;x=p.x-f.x;b=c.y-f.y;T=p.y-f.y;w=1/(_*T-x*b);k.set((T*d-b*m)*w,(T*v-b*g)*w,(T*y-b*E)*w);A.set((_*m-x*d)*w,(_*g-x*v)*w,(_*E-x*y)*w);M[e].add(k);M[r].add(k);M[i].add(k);S[e].add(A);S[r].add(A);S[i].add(A)}for(t=0,e=this.faces.length;t<e;t++){s=this.faces[t];a=this.faceVertexUvs[0][t];D(this,s.a,s.b,s.c,0,1,2)}var O=["a","b","c","d"];for(t=0,e=this.faces.length;t<e;t++){s=this.faces[t];for(n=0;n<Math.min(s.vertexNormals.length,3);n++){P.copy(s.vertexNormals[n]);o=s[O[n]];R=M[o];C.copy(R);C.sub(P.multiplyScalar(P.dot(R))).normalize();L.crossVectors(s.vertexNormals[n],R);H=L.dot(S[o]);z=H<0?-1:1;s.vertexTangents[n]=new THREE.Vector4(C.x,C.y,C.z,z)}}this.hasTangents=true},computeLineDistances:function(){var t=0;var e=this.vertices;for(var r=0,i=e.length;r<i;r++){if(r>0){t+=e[r].distanceTo(e[r-1])}this.lineDistances[r]=t}},computeBoundingBox:function(){if(this.boundingBox===null){this.boundingBox=new THREE.Box3}this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){if(this.boundingSphere===null){this.boundingSphere=new THREE.Sphere}this.boundingSphere.setFromPoints(this.vertices)},merge:function(t,e,r){if(t instanceof THREE.Geometry===false){THREE.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",t);return}var i,n=this.vertices.length,o=this.vertices,s=t.vertices,a=this.faces,u=t.faces,l=this.faceVertexUvs[0],h=t.faceVertexUvs[0];if(r===undefined)r=0;if(e!==undefined){i=(new THREE.Matrix3).getNormalMatrix(e)}for(var f=0,c=s.length;f<c;f++){var p=s[f];var d=p.clone();if(e!==undefined)d.applyMatrix4(e);o.push(d)}for(f=0,c=u.length;f<c;f++){var m=u[f],v,g,y,E=m.vertexNormals,_=m.vertexColors;v=new THREE.Face3(m.a+n,m.b+n,m.c+n);v.normal.copy(m.normal);if(i!==undefined){v.normal.applyMatrix3(i).normalize()}for(var x=0,b=E.length;x<b;x++){g=E[x].clone();if(i!==undefined){g.applyMatrix3(i).normalize()}v.vertexNormals.push(g)}v.color.copy(m.color);for(var x=0,b=_.length;x<b;x++){y=_[x];v.vertexColors.push(y.clone())}v.materialIndex=m.materialIndex+r;a.push(v)}for(f=0,c=h.length;f<c;f++){var T=h[f],w=[];if(T===undefined){continue}for(var x=0,b=T.length;x<b;x++){w.push(T[x].clone())}l.push(w)}},mergeMesh:function(t){if(t instanceof THREE.Mesh===false){THREE.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",t);return}t.matrixAutoUpdate&&t.updateMatrix();this.merge(t.geometry,t.matrix)},mergeVertices:function(){var t={};var e=[],r=[];var i,n;var o=4;var s=Math.pow(10,o);var a,u,l;var h,f,c;for(a=0,u=this.vertices.length;a<u;a++){i=this.vertices[a];n=Math.round(i.x*s)+"_"+Math.round(i.y*s)+"_"+Math.round(i.z*s);if(t[n]===undefined){t[n]=a;e.push(this.vertices[a]);r[a]=e.length-1}else{r[a]=r[t[n]]}}var p=[];for(a=0,u=this.faces.length;a<u;a++){l=this.faces[a];l.a=r[l.a];l.b=r[l.b];l.c=r[l.c];h=[l.a,l.b,l.c];var d=-1;for(var m=0;m<3;m++){if(h[m]==h[(m+1)%3]){d=m;p.push(a);break}}}for(a=p.length-1;a>=0;a--){var v=p[a];this.faces.splice(v,1);for(f=0,c=this.faceVertexUvs.length;f<c;f++){this.faceVertexUvs[f].splice(v,1)}}var g=this.vertices.length-e.length;this.vertices=e;return g},toJSON:function(){var t={metadata:{version:4,type:"BufferGeometry",generator:"BufferGeometryExporter"},uuid:this.uuid,type:this.type};if(this.name!=="")t.name=this.name;if(this.parameters!==undefined){var e=this.parameters;for(var r in e){if(e[r]!==undefined)t[r]=e[r]}return t}var i=[];for(var n=0;n<this.vertices.length;n++){var o=this.vertices[n];i.push(o.x,o.y,o.z)}var s=[];var a=[];var u={};var l=[];var h={};var f=[];var c={};for(var n=0;n<this.faces.length;n++){var p=this.faces[n];var d=false;var m=false;var v=this.faceVertexUvs[0][n]!==undefined;var g=p.normal.length()>0;var y=p.vertexNormals.length>0;var E=p.color.r!==1||p.color.g!==1||p.color.b!==1;var _=p.vertexColors.length>0;var x=0;x=R(x,0,0);x=R(x,1,d);x=R(x,2,m);x=R(x,3,v);x=R(x,4,g);x=R(x,5,y);x=R(x,6,E);x=R(x,7,_);s.push(x);s.push(p.a,p.b,p.c);if(v){var b=this.faceVertexUvs[0][n];s.push(S(b[0]),S(b[1]),S(b[2]))}if(g){s.push(H(p.normal))}if(y){var T=p.vertexNormals;s.push(H(T[0]),H(T[1]),H(T[2]))}if(E){s.push(M(p.color))}if(_){var w=p.vertexColors;s.push(M(w[0]),M(w[1]),M(w[2]))}}function R(t,e,r){return r?t|1<<e:t&~(1<<e)}function H(t){var e=t.x.toString()+t.y.toString()+t.z.toString();if(u[e]!==undefined){return u[e]}u[e]=a.length/3;a.push(t.x,t.y,t.z);return u[e]}function M(t){var e=t.r.toString()+t.g.toString()+t.b.toString();if(h[e]!==undefined){return h[e]}h[e]=l.length;l.push(t.getHex());return h[e]}function S(t){var e=t.x.toString()+t.y.toString();if(c[e]!==undefined){return c[e]}c[e]=f.length/2;f.push(t.x,t.y);return c[e]}t.data={};t.data.vertices=i;t.data.normals=a;if(l.length>0)t.data.colors=l;if(f.length>0)t.data.uvs=[f];t.data.faces=s;return t},clone:function(){var t=new THREE.Geometry;var e=this.vertices;for(var r=0,i=e.length;r<i;r++){t.vertices.push(e[r].clone())}var n=this.faces;for(var r=0,i=n.length;r<i;r++){t.faces.push(n[r].clone())}for(var r=0,i=this.faceVertexUvs.length;r<i;r++){var o=this.faceVertexUvs[r];if(t.faceVertexUvs[r]===undefined){t.faceVertexUvs[r]=[]}for(var s=0,a=o.length;s<a;s++){var u=o[s],l=[];for(var h=0,f=u.length;h<f;h++){var c=u[h];l.push(c.clone())}t.faceVertexUvs[r].push(l)}}return t},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.Geometry.prototype);THREE.GeometryIdCount=0;THREE.Camera=function(){THREE.Object3D.call(this);this.type="Camera";this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4};THREE.Camera.prototype=Object.create(THREE.Object3D.prototype);THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.getWorldDirection=function(){var t=new THREE.Quaternion;return function(e){var r=e||new THREE.Vector3;this.getWorldQuaternion(t);return r.set(0,0,-1).applyQuaternion(t)}}();THREE.Camera.prototype.lookAt=function(){var t=new THREE.Matrix4;return function(e){t.lookAt(this.position,e,this.up);this.quaternion.setFromRotationMatrix(t)}}();THREE.Camera.prototype.clone=function(t){if(t===undefined)t=new THREE.Camera;THREE.Object3D.prototype.clone.call(this,t);t.matrixWorldInverse.copy(this.matrixWorldInverse);t.projectionMatrix.copy(this.projectionMatrix);return t};THREE.CubeCamera=function(t,e,r){THREE.Object3D.call(this);this.type="CubeCamera";var i=90,n=1;var o=new THREE.PerspectiveCamera(i,n,t,e);o.up.set(0,-1,0);o.lookAt(new THREE.Vector3(1,0,0));this.add(o);var s=new THREE.PerspectiveCamera(i,n,t,e);s.up.set(0,-1,0);s.lookAt(new THREE.Vector3(-1,0,0));this.add(s);var a=new THREE.PerspectiveCamera(i,n,t,e);a.up.set(0,0,1);a.lookAt(new THREE.Vector3(0,1,0));this.add(a);var u=new THREE.PerspectiveCamera(i,n,t,e);u.up.set(0,0,-1);u.lookAt(new THREE.Vector3(0,-1,0));this.add(u);var l=new THREE.PerspectiveCamera(i,n,t,e);l.up.set(0,-1,0);l.lookAt(new THREE.Vector3(0,0,1));this.add(l);var h=new THREE.PerspectiveCamera(i,n,t,e);h.up.set(0,-1,0);h.lookAt(new THREE.Vector3(0,0,-1));this.add(h);this.renderTarget=new THREE.WebGLRenderTargetCube(r,r,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter});this.updateCubeMap=function(t,e){var r=this.renderTarget;var i=r.generateMipmaps;r.generateMipmaps=false;r.activeCubeFace=0;t.render(e,o,r);r.activeCubeFace=1;t.render(e,s,r);r.activeCubeFace=2;t.render(e,a,r);r.activeCubeFace=3;t.render(e,u,r);r.activeCubeFace=4;t.render(e,l,r);r.generateMipmaps=i;r.activeCubeFace=5;t.render(e,h,r)}};THREE.CubeCamera.prototype=Object.create(THREE.Object3D.prototype);THREE.CubeCamera.prototype.constructor=THREE.CubeCamera;THREE.OrthographicCamera=function(t,e,r,i,n,o){THREE.Camera.call(this);this.type="OrthographicCamera";this.zoom=1;this.left=t;this.right=e;this.top=r;this.bottom=i;this.near=n!==undefined?n:.1;this.far=o!==undefined?o:2e3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=Object.create(THREE.Camera.prototype);THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){var t=(this.right-this.left)/(2*this.zoom);var e=(this.top-this.bottom)/(2*this.zoom);var r=(this.right+this.left)/2;var i=(this.top+this.bottom)/2;this.projectionMatrix.makeOrthographic(r-t,r+t,i+e,i-e,this.near,this.far)};THREE.OrthographicCamera.prototype.clone=function(){var t=new THREE.OrthographicCamera;THREE.Camera.prototype.clone.call(this,t);t.zoom=this.zoom;t.left=this.left;t.right=this.right;t.top=this.top;t.bottom=this.bottom;t.near=this.near;t.far=this.far;t.projectionMatrix.copy(this.projectionMatrix);return t};THREE.PerspectiveCamera=function(t,e,r,i){THREE.Camera.call(this);this.type="PerspectiveCamera";this.zoom=1;this.fov=t!==undefined?t:50;this.aspect=e!==undefined?e:1;this.near=r!==undefined?r:.1;this.far=i!==undefined?i:2e3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=Object.create(THREE.Camera.prototype);THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(t,e){if(e===undefined)e=24;this.fov=2*THREE.Math.radToDeg(Math.atan(e/(t*2)));this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(t,e,r,i,n,o){this.fullWidth=t;this.fullHeight=e;this.x=r;this.y=i;this.width=n;this.height=o;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){var t=THREE.Math.radToDeg(2*Math.atan(Math.tan(THREE.Math.degToRad(this.fov)*.5)/this.zoom));if(this.fullWidth){var e=this.fullWidth/this.fullHeight;var r=Math.tan(THREE.Math.degToRad(t*.5))*this.near;var i=-r;var n=e*i;var o=e*r;var s=Math.abs(o-n);var a=Math.abs(r-i);this.projectionMatrix.makeFrustum(n+this.x*s/this.fullWidth,n+(this.x+this.width)*s/this.fullWidth,r-(this.y+this.height)*a/this.fullHeight,r-this.y*a/this.fullHeight,this.near,this.far)}else{this.projectionMatrix.makePerspective(t,this.aspect,this.near,this.far)}};THREE.PerspectiveCamera.prototype.clone=function(){var t=new THREE.PerspectiveCamera;THREE.Camera.prototype.clone.call(this,t);t.zoom=this.zoom;t.fov=this.fov;t.aspect=this.aspect;t.near=this.near;t.far=this.far;t.projectionMatrix.copy(this.projectionMatrix);return t};THREE.Light=function(t){THREE.Object3D.call(this);this.type="Light";this.color=new THREE.Color(t)};THREE.Light.prototype=Object.create(THREE.Object3D.prototype);THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.clone=function(t){if(t===undefined)t=new THREE.Light;THREE.Object3D.prototype.clone.call(this,t);t.color.copy(this.color);return t};THREE.AmbientLight=function(t){THREE.Light.call(this,t);this.type="AmbientLight"};THREE.AmbientLight.prototype=Object.create(THREE.Light.prototype);THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.AmbientLight.prototype.clone=function(){var t=new THREE.AmbientLight;THREE.Light.prototype.clone.call(this,t);return t};THREE.AreaLight=function(t,e){THREE.Light.call(this,t);this.type="AreaLight";this.normal=new THREE.Vector3(0,-1,0);this.right=new THREE.Vector3(1,0,0);this.intensity=e!==undefined?e:1;this.width=1;this.height=1;this.constantAttenuation=1.5;this.linearAttenuation=.5;this.quadraticAttenuation=.1};THREE.AreaLight.prototype=Object.create(THREE.Light.prototype);THREE.AreaLight.prototype.constructor=THREE.AreaLight;THREE.DirectionalLight=function(t,e){THREE.Light.call(this,t);this.type="DirectionalLight";this.position.set(0,1,0);this.target=new THREE.Object3D;this.intensity=e!==undefined?e:1;this.castShadow=false;this.onlyShadow=false;this.shadowCameraNear=50;this.shadowCameraFar=5e3;this.shadowCameraLeft=-500;this.shadowCameraRight=500;this.shadowCameraTop=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=false;this.shadowBias=0;this.shadowDarkness=.5;this.shadowMapWidth=512;this.shadowMapHeight=512;this.shadowCascade=false;this.shadowCascadeOffset=new THREE.Vector3(0,0,-1e3);this.shadowCascadeCount=2;this.shadowCascadeBias=[0,0,0];this.shadowCascadeWidth=[512,512,512];this.shadowCascadeHeight=[512,512,512];this.shadowCascadeNearZ=[-1,.99,.998];this.shadowCascadeFarZ=[.99,.998,1];this.shadowCascadeArray=[];this.shadowMap=null;this.shadowMapSize=null;this.shadowCamera=null;this.shadowMatrix=null};THREE.DirectionalLight.prototype=Object.create(THREE.Light.prototype);THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.DirectionalLight.prototype.clone=function(){var t=new THREE.DirectionalLight;THREE.Light.prototype.clone.call(this,t);t.target=this.target.clone();t.intensity=this.intensity;t.castShadow=this.castShadow;t.onlyShadow=this.onlyShadow;t.shadowCameraNear=this.shadowCameraNear;t.shadowCameraFar=this.shadowCameraFar;t.shadowCameraLeft=this.shadowCameraLeft;t.shadowCameraRight=this.shadowCameraRight;t.shadowCameraTop=this.shadowCameraTop;t.shadowCameraBottom=this.shadowCameraBottom;t.shadowCameraVisible=this.shadowCameraVisible;t.shadowBias=this.shadowBias;t.shadowDarkness=this.shadowDarkness;t.shadowMapWidth=this.shadowMapWidth;t.shadowMapHeight=this.shadowMapHeight;t.shadowCascade=this.shadowCascade;t.shadowCascadeOffset.copy(this.shadowCascadeOffset);t.shadowCascadeCount=this.shadowCascadeCount;t.shadowCascadeBias=this.shadowCascadeBias.slice(0);t.shadowCascadeWidth=this.shadowCascadeWidth.slice(0);t.shadowCascadeHeight=this.shadowCascadeHeight.slice(0);t.shadowCascadeNearZ=this.shadowCascadeNearZ.slice(0);t.shadowCascadeFarZ=this.shadowCascadeFarZ.slice(0);return t};THREE.HemisphereLight=function(t,e,r){THREE.Light.call(this,t);this.type="HemisphereLight";this.position.set(0,100,0);this.groundColor=new THREE.Color(e);this.intensity=r!==undefined?r:1};THREE.HemisphereLight.prototype=Object.create(THREE.Light.prototype);THREE.HemisphereLight.prototype.constructor=THREE.HemisphereLight;THREE.HemisphereLight.prototype.clone=function(){var t=new THREE.HemisphereLight;THREE.Light.prototype.clone.call(this,t);t.groundColor.copy(this.groundColor);t.intensity=this.intensity;return t};THREE.PointLight=function(t,e,r,i){THREE.Light.call(this,t);this.type="PointLight";this.intensity=e!==undefined?e:1;this.distance=r!==undefined?r:0;this.decay=i!==undefined?i:1};THREE.PointLight.prototype=Object.create(THREE.Light.prototype);THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.PointLight.prototype.clone=function(){var t=new THREE.PointLight;THREE.Light.prototype.clone.call(this,t);t.intensity=this.intensity;t.distance=this.distance;t.decay=this.decay;return t};THREE.SpotLight=function(t,e,r,i,n,o){THREE.Light.call(this,t);this.type="SpotLight";this.position.set(0,1,0);this.target=new THREE.Object3D;this.intensity=e!==undefined?e:1;this.distance=r!==undefined?r:0;this.angle=i!==undefined?i:Math.PI/3;this.exponent=n!==undefined?n:10;this.decay=o!==undefined?o:1;this.castShadow=false;this.onlyShadow=false;this.shadowCameraNear=50;this.shadowCameraFar=5e3;this.shadowCameraFov=50;this.shadowCameraVisible=false;this.shadowBias=0;this.shadowDarkness=.5;this.shadowMapWidth=512;this.shadowMapHeight=512;this.shadowMap=null;this.shadowMapSize=null;this.shadowCamera=null;this.shadowMatrix=null};THREE.SpotLight.prototype=Object.create(THREE.Light.prototype);THREE.SpotLight.prototype.constructor=THREE.SpotLight;THREE.SpotLight.prototype.clone=function(){var t=new THREE.SpotLight;THREE.Light.prototype.clone.call(this,t);t.target=this.target.clone();t.intensity=this.intensity;t.distance=this.distance;t.angle=this.angle;t.exponent=this.exponent;t.decay=this.decay;t.castShadow=this.castShadow;t.onlyShadow=this.onlyShadow;t.shadowCameraNear=this.shadowCameraNear;t.shadowCameraFar=this.shadowCameraFar;t.shadowCameraFov=this.shadowCameraFov;t.shadowCameraVisible=this.shadowCameraVisible;t.shadowBias=this.shadowBias;t.shadowDarkness=this.shadowDarkness;t.shadowMapWidth=this.shadowMapWidth;t.shadowMapHeight=this.shadowMapHeight;return t};THREE.Cache={files:{},add:function(t,e){this.files[t]=e},get:function(t){return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};THREE.Loader=function(t){this.showStatus=t;this.statusDomElement=t?THREE.Loader.prototype.addStatusElement():null;this.imageLoader=new THREE.ImageLoader;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:undefined,addStatusElement:function(){var t=document.createElement("div");t.style.position="absolute";t.style.right="0px";t.style.top="0px";t.style.fontSize="0.8em";t.style.textAlign="left";t.style.background="rgba(0,0,0,0.25)";t.style.color="#fff";t.style.width="120px";t.style.padding="0.5em 0.5em 0.5em 0.5em";t.style.zIndex=1e3;t.innerHTML="Loading ...";return t},updateProgress:function(t){var e="Loaded ";if(t.total){e+=(100*t.loaded/t.total).toFixed(0)+"%"}else{e+=(t.loaded/1024).toFixed(2)+" KB"}this.statusDomElement.innerHTML=e},extractUrlBase:function(t){var e=t.split("/");if(e.length===1)return"./";e.pop();return e.join("/")+"/"},initMaterials:function(t,e){var r=[];for(var i=0;i<t.length;++i){r[i]=this.createMaterial(t[i],e)}return r},needsTangents:function(t){for(var e=0,r=t.length;e<r;e++){var i=t[e];if(i instanceof THREE.ShaderMaterial)return true}return false},createMaterial:function(t,e){var r=this;function i(t){var e=Math.log(t)/Math.LN2;return Math.pow(2,Math.round(e))}function n(t,n,o,s,a,u,l){var h=e+o;var f;var c=THREE.Loader.Handlers.get(h);if(c!==null){f=c.load(h)}else{f=new THREE.Texture;c=r.imageLoader;c.crossOrigin=r.crossOrigin;c.load(h,function(t){if(THREE.Math.isPowerOfTwo(t.width)===false||THREE.Math.isPowerOfTwo(t.height)===false){var e=i(t.width);var r=i(t.height);var n=document.createElement("canvas");n.width=e;n.height=r;var o=n.getContext("2d");o.drawImage(t,0,0,e,r);f.image=n}else{f.image=t}f.needsUpdate=true})}f.sourceFile=o;if(s){f.repeat.set(s[0],s[1]);if(s[0]!==1)f.wrapS=THREE.RepeatWrapping;if(s[1]!==1)f.wrapT=THREE.RepeatWrapping}if(a){f.offset.set(a[0],a[1])}if(u){var p={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(p[u[0]]!==undefined)f.wrapS=p[u[0]];if(p[u[1]]!==undefined)f.wrapT=p[u[1]]}if(l){f.anisotropy=l}t[n]=f}function o(t){return(t[0]*255<<16)+(t[1]*255<<8)+t[2]*255}var s="MeshLambertMaterial";var a={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,bumpMap:null,wireframe:false};if(t.shading){var u=t.shading.toLowerCase();if(u==="phong")s="MeshPhongMaterial";else if(u==="basic")s="MeshBasicMaterial"}if(t.blending!==undefined&&THREE[t.blending]!==undefined){a.blending=THREE[t.blending]}if(t.transparent!==undefined){a.transparent=t.transparent}if(t.opacity!==undefined&&t.opacity<1){a.transparent=true}if(t.depthTest!==undefined){a.depthTest=t.depthTest}if(t.depthWrite!==undefined){a.depthWrite=t.depthWrite}if(t.visible!==undefined){a.visible=t.visible}if(t.flipSided!==undefined){a.side=THREE.BackSide}if(t.doubleSided!==undefined){a.side=THREE.DoubleSide}if(t.wireframe!==undefined){a.wireframe=t.wireframe}if(t.vertexColors!==undefined){if(t.vertexColors==="face"){a.vertexColors=THREE.FaceColors}else if(t.vertexColors){a.vertexColors=THREE.VertexColors}}if(t.colorDiffuse){a.color=o(t.colorDiffuse)}else if(t.DbgColor){a.color=t.DbgColor}if(t.colorSpecular){a.specular=o(t.colorSpecular)}if(t.colorEmissive){a.emissive=o(t.colorEmissive)}if(t.transparency!==undefined){console.warn("THREE.Loader: transparency has been renamed to opacity");t.opacity=t.transparency}if(t.opacity!==undefined){a.opacity=t.opacity}if(t.specularCoef){a.shininess=t.specularCoef}if(t.mapDiffuse&&e){n(a,"map",t.mapDiffuse,t.mapDiffuseRepeat,t.mapDiffuseOffset,t.mapDiffuseWrap,t.mapDiffuseAnisotropy)}if(t.mapLight&&e){n(a,"lightMap",t.mapLight,t.mapLightRepeat,t.mapLightOffset,t.mapLightWrap,t.mapLightAnisotropy)}if(t.mapBump&&e){n(a,"bumpMap",t.mapBump,t.mapBumpRepeat,t.mapBumpOffset,t.mapBumpWrap,t.mapBumpAnisotropy)}if(t.mapNormal&&e){n(a,"normalMap",t.mapNormal,t.mapNormalRepeat,t.mapNormalOffset,t.mapNormalWrap,t.mapNormalAnisotropy)}if(t.mapSpecular&&e){n(a,"specularMap",t.mapSpecular,t.mapSpecularRepeat,t.mapSpecularOffset,t.mapSpecularWrap,t.mapSpecularAnisotropy)}if(t.mapAlpha&&e){n(a,"alphaMap",t.mapAlpha,t.mapAlphaRepeat,t.mapAlphaOffset,t.mapAlphaWrap,t.mapAlphaAnisotropy)}if(t.mapBumpScale){a.bumpScale=t.mapBumpScale}if(t.mapNormalFactor){a.normalScale=new THREE.Vector2(t.mapNormalFactor,t.mapNormalFactor)}var l=new THREE[s](a);if(t.DbgName!==undefined)l.name=t.DbgName;return l}};THREE.Loader.Handlers={handlers:[],add:function(t,e){this.handlers.push(t,e)},get:function(t){for(var e=0,r=this.handlers.length;e<r;e+=2){var i=this.handlers[e];var n=this.handlers[e+1];if(i.test(t)){return n}}return null}};THREE.XHRLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager};THREE.XHRLoader.prototype={constructor:THREE.XHRLoader,load:function(t,e,r,i){var n=this;var o=THREE.Cache.get(t);if(o!==undefined){if(e)e(o);return}var s=new XMLHttpRequest;s.open("GET",t,true);s.addEventListener("load",function(r){THREE.Cache.add(t,this.response);if(e)e(this.response);n.manager.itemEnd(t)},false);if(r!==undefined){s.addEventListener("progress",function(t){r(t)},false)}if(i!==undefined){s.addEventListener("error",function(t){i(t)},false)}if(this.crossOrigin!==undefined)s.crossOrigin=this.crossOrigin;if(this.responseType!==undefined)s.responseType=this.responseType;s.send(null);n.manager.itemStart(t)},setResponseType:function(t){this.responseType=t},setCrossOrigin:function(t){this.crossOrigin=t}};THREE.ImageLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager};THREE.ImageLoader.prototype={constructor:THREE.ImageLoader,load:function(t,e,r,i){var n=this;var o=THREE.Cache.get(t);if(o!==undefined){e(o);return}var s=document.createElement("img");s.addEventListener("load",function(r){THREE.Cache.add(t,this);if(e)e(this);n.manager.itemEnd(t)},false);if(r!==undefined){s.addEventListener("progress",function(t){r(t)},false)}if(i!==undefined){s.addEventListener("error",function(t){i(t)},false)}if(this.crossOrigin!==undefined)s.crossOrigin=this.crossOrigin;s.src=t;n.manager.itemStart(t);return s},setCrossOrigin:function(t){this.crossOrigin=t}};THREE.JSONLoader=function(t){THREE.Loader.call(this,t);this.withCredentials=false};THREE.JSONLoader.prototype=Object.create(THREE.Loader.prototype);THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.load=function(t,e,r){r=r&&typeof r==="string"?r:this.extractUrlBase(t);this.onLoadStart();this.loadAjaxJSON(this,t,e,r)};THREE.JSONLoader.prototype.loadAjaxJSON=function(t,e,r,i,n){var o=new XMLHttpRequest;var s=0;o.onreadystatechange=function(){if(o.readyState===o.DONE){if(o.status===200||o.status===0){if(o.responseText){var a=JSON.parse(o.responseText);var u=a.metadata;if(u!==undefined){if(u.type==="object"){THREE.error("THREE.JSONLoader: "+e+" should be loaded with THREE.ObjectLoader instead.");return}if(u.type==="scene"){THREE.error("THREE.JSONLoader: "+e+" seems to be a Scene. Use THREE.SceneLoader instead.");return}}var l=t.parse(a,i);r(l.geometry,l.materials)}else{THREE.error("THREE.JSONLoader: "+e+" seems to be unreachable or the file is empty.")}t.onLoadComplete()}else{THREE.error("THREE.JSONLoader: Couldn't load "+e+" ("+o.status+")")}}else if(o.readyState===o.LOADING){if(n){if(s===0){s=o.getResponseHeader("Content-Length")}n({total:s,loaded:o.responseText.length})}}else if(o.readyState===o.HEADERS_RECEIVED){if(n!==undefined){s=o.getResponseHeader("Content-Length")}}};o.open("GET",e,true);o.withCredentials=this.withCredentials;o.send(null)};THREE.JSONLoader.prototype.parse=function(t,e){var r=new THREE.Geometry,i=t.scale!==undefined?1/t.scale:1;n(i);o();s(i);r.computeFaceNormals();r.computeBoundingSphere();function n(e){function i(t,e){return t&1<<e}var n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C=t.faces,L=t.vertices,P=t.normals,z=t.colors,D=0;if(t.uvs!==undefined){for(n=0;n<t.uvs.length;n++){if(t.uvs[n].length)D++}for(n=0;n<D;n++){r.faceVertexUvs[n]=[]}}a=0;u=L.length;while(a<u){x=new THREE.Vector3;x.x=L[a++]*e;x.y=L[a++]*e;x.z=L[a++]*e;r.vertices.push(x)}a=0;u=C.length;while(a<u){p=C[a++];d=i(p,0);m=i(p,1);v=i(p,3);g=i(p,4);y=i(p,5);E=i(p,6);_=i(p,7);if(d){T=new THREE.Face3;T.a=C[a];T.b=C[a+1];T.c=C[a+3];w=new THREE.Face3;w.a=C[a+1];w.b=C[a+2];w.c=C[a+3];a+=4;if(m){c=C[a++];T.materialIndex=c;w.materialIndex=c}s=r.faces.length;if(v){for(n=0;n<D;n++){M=t.uvs[n];r.faceVertexUvs[n][s]=[];r.faceVertexUvs[n][s+1]=[];for(o=0;o<4;o++){f=C[a++];k=M[f*2];A=M[f*2+1];S=new THREE.Vector2(k,A);if(o!==2)r.faceVertexUvs[n][s].push(S);if(o!==0)r.faceVertexUvs[n][s+1].push(S)}}}if(g){h=C[a++]*3;T.normal.set(P[h++],P[h++],P[h]);w.normal.copy(T.normal)}if(y){for(n=0;n<4;n++){h=C[a++]*3;H=new THREE.Vector3(P[h++],P[h++],P[h]);if(n!==2)T.vertexNormals.push(H);if(n!==0)w.vertexNormals.push(H)}}if(E){l=C[a++];R=z[l];T.color.setHex(R);w.color.setHex(R)}if(_){for(n=0;n<4;n++){l=C[a++];R=z[l];if(n!==2)T.vertexColors.push(new THREE.Color(R));if(n!==0)w.vertexColors.push(new THREE.Color(R))}}r.faces.push(T);r.faces.push(w)}else{b=new THREE.Face3;b.a=C[a++];b.b=C[a++];b.c=C[a++];if(m){c=C[a++];b.materialIndex=c}s=r.faces.length;if(v){for(n=0;n<D;n++){M=t.uvs[n];r.faceVertexUvs[n][s]=[];for(o=0;o<3;o++){f=C[a++];k=M[f*2];A=M[f*2+1];S=new THREE.Vector2(k,A);r.faceVertexUvs[n][s].push(S)}}}if(g){h=C[a++]*3;b.normal.set(P[h++],P[h++],P[h])}if(y){for(n=0;n<3;n++){h=C[a++]*3;H=new THREE.Vector3(P[h++],P[h++],P[h]);b.vertexNormals.push(H)}}if(E){l=C[a++];b.color.setHex(z[l])}if(_){for(n=0;n<3;n++){l=C[a++];b.vertexColors.push(new THREE.Color(z[l]))}}r.faces.push(b)}}}function o(){var e=t.influencesPerVertex!==undefined?t.influencesPerVertex:2;if(t.skinWeights){for(var i=0,n=t.skinWeights.length;i<n;i+=e){var o=t.skinWeights[i];var s=e>1?t.skinWeights[i+1]:0;var a=e>2?t.skinWeights[i+2]:0;var u=e>3?t.skinWeights[i+3]:0;r.skinWeights.push(new THREE.Vector4(o,s,a,u))}}if(t.skinIndices){for(var i=0,n=t.skinIndices.length;i<n;i+=e){var l=t.skinIndices[i];var h=e>1?t.skinIndices[i+1]:0;var f=e>2?t.skinIndices[i+2]:0;var c=e>3?t.skinIndices[i+3]:0;r.skinIndices.push(new THREE.Vector4(l,h,f,c))}}r.bones=t.bones;if(r.bones&&r.bones.length>0&&(r.skinWeights.length!==r.skinIndices.length||r.skinIndices.length!==r.vertices.length)){THREE.warn("THREE.JSONLoader: When skinning, number of vertices ("+r.vertices.length+"), skinIndices ("+r.skinIndices.length+"), and skinWeights ("+r.skinWeights.length+") should match.")}r.animation=t.animation;r.animations=t.animations}function s(e){if(t.morphTargets!==undefined){var i,n,o,s,a,u;for(i=0,n=t.morphTargets.length;i<n;i++){r.morphTargets[i]={};r.morphTargets[i].name=t.morphTargets[i].name;r.morphTargets[i].vertices=[];a=r.morphTargets[i].vertices;u=t.morphTargets[i].vertices;for(o=0,s=u.length;o<s;o+=3){var l=new THREE.Vector3;l.x=u[o]*e;l.y=u[o+1]*e;l.z=u[o+2]*e;a.push(l)}}}if(t.morphColors!==undefined){var i,n,h,f,c,p,d;for(i=0,n=t.morphColors.length;i<n;i++){r.morphColors[i]={};r.morphColors[i].name=t.morphColors[i].name;r.morphColors[i].colors=[];c=r.morphColors[i].colors;p=t.morphColors[i].colors;for(h=0,f=p.length;h<f;h+=3){d=new THREE.Color(16755200);d.setRGB(p[h],p[h+1],p[h+2]);c.push(d)}}}}if(t.materials===undefined||t.materials.length===0){return{geometry:r}}else{var a=this.initMaterials(t.materials,e);if(this.needsTangents(a)){r.computeTangents()}return{geometry:r,materials:a}}};THREE.LoadingManager=function(t,e,r){var i=this;var n=0,o=0;this.onLoad=t;this.onProgress=e;this.onError=r;this.itemStart=function(t){o++};this.itemEnd=function(t){n++;if(i.onProgress!==undefined){i.onProgress(t,n,o)}if(n===o&&i.onLoad!==undefined){i.onLoad()}}};THREE.DefaultLoadingManager=new THREE.LoadingManager;THREE.BufferGeometryLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager};THREE.BufferGeometryLoader.prototype={constructor:THREE.BufferGeometryLoader,load:function(t,e,r,i){var n=this;var o=new THREE.XHRLoader(n.manager);o.setCrossOrigin(this.crossOrigin);o.load(t,function(t){e(n.parse(JSON.parse(t)))},r,i)},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t){var e=new THREE.BufferGeometry;var r=t.data.attributes;for(var i in r){var n=r[i];var o=new self[n.type](n.array);e.addAttribute(i,new THREE.BufferAttribute(o,n.itemSize))}var s=t.data.offsets;if(s!==undefined){e.offsets=JSON.parse(JSON.stringify(s))}var a=t.data.boundingSphere;if(a!==undefined){var u=new THREE.Vector3;if(a.center!==undefined){u.fromArray(a.center)}e.boundingSphere=new THREE.Sphere(u,a.radius)}return e}};THREE.MaterialLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager};THREE.MaterialLoader.prototype={constructor:THREE.MaterialLoader,load:function(t,e,r,i){var n=this;var o=new THREE.XHRLoader(n.manager);o.setCrossOrigin(this.crossOrigin);o.load(t,function(t){e(n.parse(JSON.parse(t)))},r,i)},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t){var e=new THREE[t.type];if(t.color!==undefined)e.color.setHex(t.color);if(t.emissive!==undefined)e.emissive.setHex(t.emissive);if(t.specular!==undefined)e.specular.setHex(t.specular);if(t.shininess!==undefined)e.shininess=t.shininess;if(t.uniforms!==undefined)e.uniforms=t.uniforms;if(t.vertexShader!==undefined)e.vertexShader=t.vertexShader;if(t.fragmentShader!==undefined)e.fragmentShader=t.fragmentShader;if(t.vertexColors!==undefined)e.vertexColors=t.vertexColors;if(t.shading!==undefined)e.shading=t.shading;if(t.blending!==undefined)e.blending=t.blending;if(t.side!==undefined)e.side=t.side;if(t.opacity!==undefined)e.opacity=t.opacity;if(t.transparent!==undefined)e.transparent=t.transparent;if(t.wireframe!==undefined)e.wireframe=t.wireframe;if(t.size!==undefined)e.size=t.size;if(t.sizeAttenuation!==undefined)e.sizeAttenuation=t.sizeAttenuation;if(t.materials!==undefined){for(var r=0,i=t.materials.length;r<i;r++){e.materials.push(this.parse(t.materials[r]))}}return e}};THREE.ObjectLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager;this.texturePath=""};THREE.ObjectLoader.prototype={constructor:THREE.ObjectLoader,load:function(t,e,r,i){if(this.texturePath===""){this.texturePath=t.substring(0,t.lastIndexOf("/")+1)}var n=this;var o=new THREE.XHRLoader(n.manager);o.setCrossOrigin(this.crossOrigin);o.load(t,function(t){n.parse(JSON.parse(t),e)},r,i)},setTexturePath:function(t){this.texturePath=t},setCrossOrigin:function(t){this.crossOrigin=t},parse:function(t,e){var r=this.parseGeometries(t.geometries);var i=this.parseImages(t.images,function(){if(e!==undefined)e(s)});var n=this.parseTextures(t.textures,i);var o=this.parseMaterials(t.materials,n);var s=this.parseObject(t.object,r,o);if(t.images===undefined||t.images.length===0){if(e!==undefined)e(s)}return s},parseGeometries:function(t){var e={};if(t!==undefined){var r=new THREE.JSONLoader;var i=new THREE.BufferGeometryLoader;for(var n=0,o=t.length;n<o;n++){var s;var a=t[n];switch(a.type){case"PlaneGeometry":case"PlaneBufferGeometry":s=new THREE[a.type](a.width,a.height,a.widthSegments,a.heightSegments);break;case"BoxGeometry":case"CubeGeometry":s=new THREE.BoxGeometry(a.width,a.height,a.depth,a.widthSegments,a.heightSegments,a.depthSegments);break;case"CircleGeometry":s=new THREE.CircleGeometry(a.radius,a.segments);break;case"CylinderGeometry":s=new THREE.CylinderGeometry(a.radiusTop,a.radiusBottom,a.height,a.radialSegments,a.heightSegments,a.openEnded);break;case"SphereGeometry":s=new THREE.SphereGeometry(a.radius,a.widthSegments,a.heightSegments,a.phiStart,a.phiLength,a.thetaStart,a.thetaLength);break;case"IcosahedronGeometry":s=new THREE.IcosahedronGeometry(a.radius,a.detail);break;case"TorusGeometry":s=new THREE.TorusGeometry(a.radius,a.tube,a.radialSegments,a.tubularSegments,a.arc);break;case"TorusKnotGeometry":s=new THREE.TorusKnotGeometry(a.radius,a.tube,a.radialSegments,a.tubularSegments,a.p,a.q,a.heightScale);break;case"BufferGeometry":s=i.parse(a);break;case"Geometry":s=r.parse(a.data).geometry;break}s.uuid=a.uuid;if(a.name!==undefined)s.name=a.name;e[a.uuid]=s}}return e},parseMaterials:function(t,e){var r={};if(t!==undefined){var i=function(t){if(e[t]===undefined){THREE.warn("THREE.ObjectLoader: Undefined texture",t)}return e[t]};var n=new THREE.MaterialLoader;for(var o=0,s=t.length;o<s;o++){var a=t[o];var u=n.parse(a);u.uuid=a.uuid;if(a.name!==undefined)u.name=a.name;if(a.map!==undefined){u.map=i(a.map)}if(a.bumpMap!==undefined){u.bumpMap=i(a.bumpMap);if(a.bumpScale){u.bumpScale=new THREE.Vector2(a.bumpScale,a.bumpScale)}}if(a.alphaMap!==undefined){u.alphaMap=i(a.alphaMap)}if(a.envMap!==undefined){u.envMap=i(a.envMap)}if(a.normalMap!==undefined){u.normalMap=i(a.normalMap);if(a.normalScale){u.normalScale=new THREE.Vector2(a.normalScale,a.normalScale)}}if(a.lightMap!==undefined){u.lightMap=i(a.lightMap)}if(a.specularMap!==undefined){u.specularMap=i(a.specularMap)}r[a.uuid]=u}}return r},parseImages:function(t,e){var r=this;var i={};if(t!==undefined&&t.length>0){var n=new THREE.LoadingManager(e);var o=new THREE.ImageLoader(n);o.setCrossOrigin(this.crossOrigin);var s=function(t){r.manager.itemStart(t);return o.load(t,function(){r.manager.itemEnd(t)})};for(var a=0,u=t.length;a<u;a++){var l=t[a];var h=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(l.url)?l.url:r.texturePath+l.url;i[l.uuid]=s(h)}}return i},parseTextures:function(t,e){var r={};if(t!==undefined){for(var i=0,n=t.length;i<n;i++){var o=t[i];if(o.image===undefined){THREE.warn('THREE.ObjectLoader: No "image" speficied for',o.uuid)}if(e[o.image]===undefined){THREE.warn("THREE.ObjectLoader: Undefined image",o.image)}var s=new THREE.Texture(e[o.image]);s.needsUpdate=true;s.uuid=o.uuid;if(o.name!==undefined)s.name=o.name;if(o.repeat!==undefined)s.repeat=new THREE.Vector2(o.repeat[0],o.repeat[1]);if(o.minFilter!==undefined)s.minFilter=THREE[o.minFilter];if(o.magFilter!==undefined)s.magFilter=THREE[o.magFilter];if(o.anisotropy!==undefined)s.anisotropy=o.anisotropy;if(o.wrap instanceof Array){s.wrapS=THREE[o.wrap[0]];s.wrapT=THREE[o.wrap[1]]}r[o.uuid]=s}}return r},parseObject:function(){var t=new THREE.Matrix4;return function(e,r,i){var n;var o=function(t){if(r[t]===undefined){THREE.warn("THREE.ObjectLoader: Undefined geometry",t)}return r[t]};var s=function(t){if(i[t]===undefined){THREE.warn("THREE.ObjectLoader: Undefined material",t)}return i[t]};switch(e.type){case"Scene":n=new THREE.Scene;break;case"PerspectiveCamera":n=new THREE.PerspectiveCamera(e.fov,e.aspect,e.near,e.far);break;case"OrthographicCamera":n=new THREE.OrthographicCamera(e.left,e.right,e.top,e.bottom,e.near,e.far);break;case"AmbientLight":n=new THREE.AmbientLight(e.color);break;case"DirectionalLight":n=new THREE.DirectionalLight(e.color,e.intensity);break;case"PointLight":n=new THREE.PointLight(e.color,e.intensity,e.distance,e.decay);break;case"SpotLight":n=new THREE.SpotLight(e.color,e.intensity,e.distance,e.angle,e.exponent,e.decay);break;case"HemisphereLight":n=new THREE.HemisphereLight(e.color,e.groundColor,e.intensity);break;case"Mesh":n=new THREE.Mesh(o(e.geometry),s(e.material));break;case"Line":n=new THREE.Line(o(e.geometry),s(e.material),e.mode);break;case"PointCloud":n=new THREE.PointCloud(o(e.geometry),s(e.material));break;case"Sprite":n=new THREE.Sprite(s(e.material));break;case"Group":n=new THREE.Group;break;default:n=new THREE.Object3D}n.uuid=e.uuid;if(e.name!==undefined)n.name=e.name;if(e.matrix!==undefined){t.fromArray(e.matrix);t.decompose(n.position,n.quaternion,n.scale)}else{if(e.position!==undefined)n.position.fromArray(e.position);if(e.rotation!==undefined)n.rotation.fromArray(e.rotation);if(e.scale!==undefined)n.scale.fromArray(e.scale)}if(e.visible!==undefined)n.visible=e.visible;if(e.userData!==undefined)n.userData=e.userData;if(e.children!==undefined){for(var a in e.children){n.add(this.parseObject(e.children[a],r,i))}}return n}}()};THREE.TextureLoader=function(t){this.manager=t!==undefined?t:THREE.DefaultLoadingManager};THREE.TextureLoader.prototype={constructor:THREE.TextureLoader,load:function(t,e,r,i){var n=this;var o=new THREE.ImageLoader(n.manager);o.setCrossOrigin(this.crossOrigin);o.load(t,function(t){var r=new THREE.Texture(t);r.needsUpdate=true;if(e!==undefined){e(r)}},r,i)},setCrossOrigin:function(t){this.crossOrigin=t}};THREE.DataTextureLoader=THREE.BinaryTextureLoader=function(){this._parser=null};THREE.BinaryTextureLoader.prototype={constructor:THREE.BinaryTextureLoader,load:function(t,e,r,i){var n=this;var o=new THREE.DataTexture;var s=new THREE.XHRLoader;s.setResponseType("arraybuffer");s.load(t,function(t){var r=n._parser(t);if(!r)return;if(undefined!==r.image){o.image=r.image}else if(undefined!==r.data){o.image.width=r.width;o.image.height=r.height;o.image.data=r.data}o.wrapS=undefined!==r.wrapS?r.wrapS:THREE.ClampToEdgeWrapping;o.wrapT=undefined!==r.wrapT?r.wrapT:THREE.ClampToEdgeWrapping;o.magFilter=undefined!==r.magFilter?r.magFilter:THREE.LinearFilter;o.minFilter=undefined!==r.minFilter?r.minFilter:THREE.LinearMipMapLinearFilter;o.anisotropy=undefined!==r.anisotropy?r.anisotropy:1;if(undefined!==r.format){o.format=r.format}if(undefined!==r.type){o.type=r.type}if(undefined!==r.mipmaps){o.mipmaps=r.mipmaps}if(1===r.mipmapCount){o.minFilter=THREE.LinearFilter}o.needsUpdate=true;if(e)e(o,r)},r,i);return o}};THREE.CompressedTextureLoader=function(){this._parser=null};THREE.CompressedTextureLoader.prototype={constructor:THREE.CompressedTextureLoader,load:function(t,e,r){var i=this;var n=[];var o=new THREE.CompressedTexture;o.image=n;var s=new THREE.XHRLoader;s.setResponseType("arraybuffer");if(t instanceof Array){var a=0;var u=function(r){s.load(t[r],function(t){var s=i._parser(t,true);n[r]={width:s.width,height:s.height,format:s.format,mipmaps:s.mipmaps};a+=1;if(a===6){if(s.mipmapCount==1)o.minFilter=THREE.LinearFilter;o.format=s.format;o.needsUpdate=true;if(e)e(o)}})};for(var l=0,h=t.length;l<h;++l){u(l)}}else{s.load(t,function(t){var r=i._parser(t,true);if(r.isCubemap){var s=r.mipmaps.length/r.mipmapCount;for(var a=0;a<s;a++){n[a]={mipmaps:[]};for(var u=0;u<r.mipmapCount;u++){n[a].mipmaps.push(r.mipmaps[a*r.mipmapCount+u]);n[a].format=r.format;n[a].width=r.width;n[a].height=r.height}}}else{o.image.width=r.width;o.image.height=r.height;o.mipmaps=r.mipmaps}if(r.mipmapCount===1){o.minFilter=THREE.LinearFilter}o.format=r.format;o.needsUpdate=true;if(e)e(o)})}return o}};THREE.Material=function(){Object.defineProperty(this,"id",{value:THREE.MaterialIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Material";this.side=THREE.FrontSide;this.opacity=1;this.transparent=false;this.blending=THREE.NormalBlending;this.blendSrc=THREE.SrcAlphaFactor;this.blendDst=THREE.OneMinusSrcAlphaFactor;this.blendEquation=THREE.AddEquation;this.blendSrcAlpha=null;this.blendDstAlpha=null;this.blendEquationAlpha=null;this.depthTest=true;this.depthWrite=true;this.colorWrite=true;this.polygonOffset=false;this.polygonOffsetFactor=0;this.polygonOffsetUnits=0;this.alphaTest=0;this.overdraw=0;this.visible=true;this._needsUpdate=true};THREE.Material.prototype={constructor:THREE.Material,get needsUpdate(){return this._needsUpdate},set needsUpdate(t){if(t===true)this.update();this._needsUpdate=t},setValues:function(t){if(t===undefined)return;for(var e in t){var r=t[e];if(r===undefined){THREE.warn("THREE.Material: '"+e+"' parameter is undefined.");continue}if(e in this){var i=this[e];if(i instanceof THREE.Color){i.set(r)}else if(i instanceof THREE.Vector3&&r instanceof THREE.Vector3){i.copy(r)}else if(e=="overdraw"){this[e]=Number(r)}else{this[e]=r}}}},toJSON:function(){var t={metadata:{version:4.2,type:"material",generator:"MaterialExporter"},uuid:this.uuid,type:this.type};if(this.name!=="")t.name=this.name;if(this instanceof THREE.MeshBasicMaterial){t.color=this.color.getHex();if(this.vertexColors!==THREE.NoColors)t.vertexColors=this.vertexColors;if(this.blending!==THREE.NormalBlending)t.blending=this.blending;if(this.side!==THREE.FrontSide)t.side=this.side}else if(this instanceof THREE.MeshLambertMaterial){t.color=this.color.getHex();t.emissive=this.emissive.getHex();if(this.vertexColors!==THREE.NoColors)t.vertexColors=this.vertexColors;if(this.shading!==THREE.SmoothShading)t.shading=this.shading;if(this.blending!==THREE.NormalBlending)t.blending=this.blending;if(this.side!==THREE.FrontSide)t.side=this.side}else if(this instanceof THREE.MeshPhongMaterial){t.color=this.color.getHex();t.emissive=this.emissive.getHex();t.specular=this.specular.getHex();t.shininess=this.shininess;if(this.vertexColors!==THREE.NoColors)t.vertexColors=this.vertexColors;if(this.shading!==THREE.SmoothShading)t.shading=this.shading;if(this.blending!==THREE.NormalBlending)t.blending=this.blending;if(this.side!==THREE.FrontSide)t.side=this.side}else if(this instanceof THREE.MeshNormalMaterial){if(this.blending!==THREE.NormalBlending)t.blending=this.blending;if(this.side!==THREE.FrontSide)t.side=this.side}else if(this instanceof THREE.MeshDepthMaterial){if(this.blending!==THREE.NormalBlending)t.blending=this.blending;if(this.side!==THREE.FrontSide)t.side=this.side}else if(this instanceof THREE.PointCloudMaterial){t.size=this.size;t.sizeAttenuation=this.sizeAttenuation;t.color=this.color.getHex();if(this.vertexColors!==THREE.NoColors)t.vertexColors=this.vertexColors;if(this.blending!==THREE.NormalBlending)t.blending=this.blending}else if(this instanceof THREE.ShaderMaterial){t.uniforms=this.uniforms;t.vertexShader=this.vertexShader;t.fragmentShader=this.fragmentShader}else if(this instanceof THREE.SpriteMaterial){t.color=this.color.getHex()}if(this.opacity<1)t.opacity=this.opacity;if(this.transparent!==false)t.transparent=this.transparent;if(this.wireframe!==false)t.wireframe=this.wireframe;return t},clone:function(t){if(t===undefined)t=new THREE.Material;t.name=this.name;t.side=this.side;t.opacity=this.opacity;t.transparent=this.transparent;t.blending=this.blending;t.blendSrc=this.blendSrc;t.blendDst=this.blendDst;t.blendEquation=this.blendEquation;t.blendSrcAlpha=this.blendSrcAlpha;t.blendDstAlpha=this.blendDstAlpha;t.blendEquationAlpha=this.blendEquationAlpha;t.depthTest=this.depthTest;t.depthWrite=this.depthWrite;t.polygonOffset=this.polygonOffset;t.polygonOffsetFactor=this.polygonOffsetFactor;t.polygonOffsetUnits=this.polygonOffsetUnits;t.alphaTest=this.alphaTest;t.overdraw=this.overdraw;t.visible=this.visible;return t},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.Material.prototype);THREE.MaterialIdCount=0;THREE.LineBasicMaterial=function(t){THREE.Material.call(this);this.type="LineBasicMaterial";this.color=new THREE.Color(16777215);this.linewidth=1;this.linecap="round";this.linejoin="round";this.vertexColors=THREE.NoColors;this.fog=true;this.setValues(t)};THREE.LineBasicMaterial.prototype=Object.create(THREE.Material.prototype);THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;THREE.LineBasicMaterial.prototype.clone=function(){var t=new THREE.LineBasicMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.linewidth=this.linewidth;t.linecap=this.linecap;t.linejoin=this.linejoin;t.vertexColors=this.vertexColors;t.fog=this.fog;return t};THREE.LineDashedMaterial=function(t){THREE.Material.call(this);this.type="LineDashedMaterial";this.color=new THREE.Color(16777215);this.linewidth=1;this.scale=1;this.dashSize=3;this.gapSize=1;this.vertexColors=false;this.fog=true;this.setValues(t)};THREE.LineDashedMaterial.prototype=Object.create(THREE.Material.prototype);THREE.LineDashedMaterial.prototype.constructor=THREE.LineDashedMaterial;THREE.LineDashedMaterial.prototype.clone=function(){var t=new THREE.LineDashedMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.linewidth=this.linewidth;t.scale=this.scale;t.dashSize=this.dashSize;t.gapSize=this.gapSize;t.vertexColors=this.vertexColors;t.fog=this.fog;return t};THREE.MeshBasicMaterial=function(t){THREE.Material.call(this);this.type="MeshBasicMaterial";this.color=new THREE.Color(16777215);this.map=null;this.lightMap=null;this.specularMap=null;this.alphaMap=null;this.envMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=true;this.shading=THREE.SmoothShading;this.wireframe=false;this.wireframeLinewidth=1;this.wireframeLinecap="round";this.wireframeLinejoin="round";this.vertexColors=THREE.NoColors;this.skinning=false;this.morphTargets=false;this.setValues(t)};THREE.MeshBasicMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;THREE.MeshBasicMaterial.prototype.clone=function(){var t=new THREE.MeshBasicMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.map=this.map;t.lightMap=this.lightMap;t.specularMap=this.specularMap;t.alphaMap=this.alphaMap;t.envMap=this.envMap;t.combine=this.combine;t.reflectivity=this.reflectivity;t.refractionRatio=this.refractionRatio;t.fog=this.fog;t.shading=this.shading;t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;t.wireframeLinecap=this.wireframeLinecap;t.wireframeLinejoin=this.wireframeLinejoin;t.vertexColors=this.vertexColors;t.skinning=this.skinning;t.morphTargets=this.morphTargets;return t};THREE.MeshLambertMaterial=function(t){THREE.Material.call(this);this.type="MeshLambertMaterial";this.color=new THREE.Color(16777215);this.emissive=new THREE.Color(0);this.wrapAround=false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=null;this.lightMap=null;this.specularMap=null;this.alphaMap=null;this.envMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=true;this.shading=THREE.SmoothShading;this.wireframe=false;this.wireframeLinewidth=1;this.wireframeLinecap="round";this.wireframeLinejoin="round";this.vertexColors=THREE.NoColors;this.skinning=false;this.morphTargets=false;this.morphNormals=false;this.setValues(t)};THREE.MeshLambertMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;THREE.MeshLambertMaterial.prototype.clone=function(){var t=new THREE.MeshLambertMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.emissive.copy(this.emissive);t.wrapAround=this.wrapAround;t.wrapRGB.copy(this.wrapRGB);t.map=this.map;t.lightMap=this.lightMap;t.specularMap=this.specularMap;t.alphaMap=this.alphaMap;t.envMap=this.envMap;t.combine=this.combine;t.reflectivity=this.reflectivity;t.refractionRatio=this.refractionRatio;t.fog=this.fog;t.shading=this.shading;t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;t.wireframeLinecap=this.wireframeLinecap;t.wireframeLinejoin=this.wireframeLinejoin;t.vertexColors=this.vertexColors;t.skinning=this.skinning;t.morphTargets=this.morphTargets;t.morphNormals=this.morphNormals;return t};THREE.MeshPhongMaterial=function(t){THREE.Material.call(this);this.type="MeshPhongMaterial";this.color=new THREE.Color(16777215);this.emissive=new THREE.Color(0);this.specular=new THREE.Color(1118481);this.shininess=30;this.metal=false;this.wrapAround=false;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=null;this.lightMap=null;this.bumpMap=null;this.bumpScale=1;this.normalMap=null;this.normalScale=new THREE.Vector2(1,1);this.specularMap=null;this.alphaMap=null;this.envMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=true;this.shading=THREE.SmoothShading;this.wireframe=false;this.wireframeLinewidth=1;this.wireframeLinecap="round";this.wireframeLinejoin="round";this.vertexColors=THREE.NoColors;this.skinning=false;this.morphTargets=false;this.morphNormals=false;this.setValues(t)};THREE.MeshPhongMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshPhongMaterial.prototype.clone=function(){var t=new THREE.MeshPhongMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.emissive.copy(this.emissive);t.specular.copy(this.specular);t.shininess=this.shininess;t.metal=this.metal;t.wrapAround=this.wrapAround;t.wrapRGB.copy(this.wrapRGB);t.map=this.map;t.lightMap=this.lightMap;t.bumpMap=this.bumpMap;t.bumpScale=this.bumpScale;t.normalMap=this.normalMap;t.normalScale.copy(this.normalScale);t.specularMap=this.specularMap;t.alphaMap=this.alphaMap;t.envMap=this.envMap;t.combine=this.combine;t.reflectivity=this.reflectivity;t.refractionRatio=this.refractionRatio;t.fog=this.fog;t.shading=this.shading;t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;t.wireframeLinecap=this.wireframeLinecap;t.wireframeLinejoin=this.wireframeLinejoin;t.vertexColors=this.vertexColors;t.skinning=this.skinning;t.morphTargets=this.morphTargets;t.morphNormals=this.morphNormals;return t};THREE.MeshDepthMaterial=function(t){THREE.Material.call(this);this.type="MeshDepthMaterial";this.morphTargets=false;this.wireframe=false;this.wireframeLinewidth=1;this.setValues(t)};THREE.MeshDepthMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;THREE.MeshDepthMaterial.prototype.clone=function(){var t=new THREE.MeshDepthMaterial;THREE.Material.prototype.clone.call(this,t);t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;return t};THREE.MeshNormalMaterial=function(t){THREE.Material.call(this,t);this.type="MeshNormalMaterial";this.wireframe=false;this.wireframeLinewidth=1;this.morphTargets=false;this.setValues(t)};THREE.MeshNormalMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshNormalMaterial.prototype.clone=function(){var t=new THREE.MeshNormalMaterial;THREE.Material.prototype.clone.call(this,t);t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;return t};THREE.MeshFaceMaterial=function(t){this.uuid=THREE.Math.generateUUID();this.type="MeshFaceMaterial";this.materials=t instanceof Array?t:[]};THREE.MeshFaceMaterial.prototype={constructor:THREE.MeshFaceMaterial,toJSON:function(){var t={metadata:{version:4.2,type:"material",generator:"MaterialExporter"},uuid:this.uuid,type:this.type,materials:[]};for(var e=0,r=this.materials.length;e<r;e++){t.materials.push(this.materials[e].toJSON())}return t},clone:function(){var t=new THREE.MeshFaceMaterial;for(var e=0;e<this.materials.length;e++){t.materials.push(this.materials[e].clone())}return t}};THREE.PointCloudMaterial=function(t){THREE.Material.call(this);this.type="PointCloudMaterial";this.color=new THREE.Color(16777215);this.map=null;this.size=1;this.sizeAttenuation=true;this.vertexColors=THREE.NoColors;this.fog=true;this.setValues(t)};THREE.PointCloudMaterial.prototype=Object.create(THREE.Material.prototype);THREE.PointCloudMaterial.prototype.constructor=THREE.PointCloudMaterial;THREE.PointCloudMaterial.prototype.clone=function(){var t=new THREE.PointCloudMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.map=this.map;t.size=this.size;t.sizeAttenuation=this.sizeAttenuation;t.vertexColors=this.vertexColors;t.fog=this.fog;return t};THREE.ParticleBasicMaterial=function(t){THREE.warn("THREE.ParticleBasicMaterial has been renamed to THREE.PointCloudMaterial.");return new THREE.PointCloudMaterial(t)};THREE.ParticleSystemMaterial=function(t){THREE.warn("THREE.ParticleSystemMaterial has been renamed to THREE.PointCloudMaterial.");return new THREE.PointCloudMaterial(t)};THREE.ShaderMaterial=function(t){THREE.Material.call(this);this.type="ShaderMaterial";this.defines={};this.uniforms={};this.attributes=null;this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}";this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";this.shading=THREE.SmoothShading;this.linewidth=1;this.wireframe=false;this.wireframeLinewidth=1;this.fog=false;this.lights=false;this.vertexColors=THREE.NoColors;this.skinning=false;this.morphTargets=false;this.morphNormals=false;this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]};this.index0AttributeName=undefined;this.setValues(t)};THREE.ShaderMaterial.prototype=Object.create(THREE.Material.prototype);THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;THREE.ShaderMaterial.prototype.clone=function(){var t=new THREE.ShaderMaterial;THREE.Material.prototype.clone.call(this,t);t.fragmentShader=this.fragmentShader;t.vertexShader=this.vertexShader;t.uniforms=THREE.UniformsUtils.clone(this.uniforms);t.attributes=this.attributes;t.defines=this.defines;t.shading=this.shading;t.wireframe=this.wireframe;t.wireframeLinewidth=this.wireframeLinewidth;t.fog=this.fog;t.lights=this.lights;t.vertexColors=this.vertexColors;t.skinning=this.skinning;t.morphTargets=this.morphTargets;t.morphNormals=this.morphNormals;return t};THREE.RawShaderMaterial=function(t){THREE.ShaderMaterial.call(this,t);this.type="RawShaderMaterial"};THREE.RawShaderMaterial.prototype=Object.create(THREE.ShaderMaterial.prototype);THREE.RawShaderMaterial.prototype.constructor=THREE.RawShaderMaterial;THREE.RawShaderMaterial.prototype.clone=function(){var t=new THREE.RawShaderMaterial;THREE.ShaderMaterial.prototype.clone.call(this,t);return t};THREE.SpriteMaterial=function(t){THREE.Material.call(this);this.type="SpriteMaterial";this.color=new THREE.Color(16777215);this.map=null;this.rotation=0;this.fog=false;this.setValues(t)};THREE.SpriteMaterial.prototype=Object.create(THREE.Material.prototype);THREE.SpriteMaterial.prototype.constructor=THREE.SpriteMaterial;THREE.SpriteMaterial.prototype.clone=function(){var t=new THREE.SpriteMaterial;THREE.Material.prototype.clone.call(this,t);t.color.copy(this.color);t.map=this.map;t.rotation=this.rotation;t.fog=this.fog;return t};THREE.Texture=function(t,e,r,i,n,o,s,a,u){Object.defineProperty(this,"id",{value:THREE.TextureIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.sourceFile="";this.image=t!==undefined?t:THREE.Texture.DEFAULT_IMAGE;this.mipmaps=[];this.mapping=e!==undefined?e:THREE.Texture.DEFAULT_MAPPING;this.wrapS=r!==undefined?r:THREE.ClampToEdgeWrapping;this.wrapT=i!==undefined?i:THREE.ClampToEdgeWrapping;this.magFilter=n!==undefined?n:THREE.LinearFilter;this.minFilter=o!==undefined?o:THREE.LinearMipMapLinearFilter;this.anisotropy=u!==undefined?u:1;this.format=s!==undefined?s:THREE.RGBAFormat;this.type=a!==undefined?a:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=true;this.premultiplyAlpha=false;this.flipY=true;this.unpackAlignment=4;this._needsUpdate=false;this.onUpdate=null};THREE.Texture.DEFAULT_IMAGE=undefined;THREE.Texture.DEFAULT_MAPPING=THREE.UVMapping;THREE.Texture.prototype={constructor:THREE.Texture,get needsUpdate(){return this._needsUpdate},set needsUpdate(t){if(t===true)this.update();this._needsUpdate=t},clone:function(t){if(t===undefined)t=new THREE.Texture;t.image=this.image;t.mipmaps=this.mipmaps.slice(0);t.mapping=this.mapping;t.wrapS=this.wrapS;t.wrapT=this.wrapT;t.magFilter=this.magFilter;t.minFilter=this.minFilter;t.anisotropy=this.anisotropy;t.format=this.format;t.type=this.type;t.offset.copy(this.offset);t.repeat.copy(this.repeat);t.generateMipmaps=this.generateMipmaps;t.premultiplyAlpha=this.premultiplyAlpha;t.flipY=this.flipY;t.unpackAlignment=this.unpackAlignment;return t},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.Texture.prototype);THREE.TextureIdCount=0;THREE.CubeTexture=function(t,e,r,i,n,o,s,a,u){e=e!==undefined?e:THREE.CubeReflectionMapping;THREE.Texture.call(this,t,e,r,i,n,o,s,a,u);this.images=t};THREE.CubeTexture.prototype=Object.create(THREE.Texture.prototype);THREE.CubeTexture.prototype.constructor=THREE.CubeTexture;THREE.CubeTexture.clone=function(t){if(t===undefined)t=new THREE.CubeTexture;THREE.Texture.prototype.clone.call(this,t);t.images=this.images;return t};THREE.CompressedTexture=function(t,e,r,i,n,o,s,a,u,l,h){THREE.Texture.call(this,null,o,s,a,u,l,i,n,h);this.image={width:e,height:r};this.mipmaps=t;this.flipY=false;this.generateMipmaps=false};THREE.CompressedTexture.prototype=Object.create(THREE.Texture.prototype);THREE.CompressedTexture.prototype.constructor=THREE.CompressedTexture;THREE.CompressedTexture.prototype.clone=function(){var t=new THREE.CompressedTexture;THREE.Texture.prototype.clone.call(this,t);return t};THREE.DataTexture=function(t,e,r,i,n,o,s,a,u,l,h){THREE.Texture.call(this,null,o,s,a,u,l,i,n,h);this.image={data:t,width:e,height:r}};THREE.DataTexture.prototype=Object.create(THREE.Texture.prototype);THREE.DataTexture.prototype.constructor=THREE.DataTexture;THREE.DataTexture.prototype.clone=function(){var t=new THREE.DataTexture;THREE.Texture.prototype.clone.call(this,t);return t};THREE.VideoTexture=function(t,e,r,i,n,o,s,a,u){THREE.Texture.call(this,t,e,r,i,n,o,s,a,u);this.generateMipmaps=false;var l=this;var h=function(){requestAnimationFrame(h);if(t.readyState===t.HAVE_ENOUGH_DATA){l.needsUpdate=true}};h()};THREE.VideoTexture.prototype=Object.create(THREE.Texture.prototype);THREE.VideoTexture.prototype.constructor=THREE.VideoTexture;THREE.Group=function(){THREE.Object3D.call(this);this.type="Group"};THREE.Group.prototype=Object.create(THREE.Object3D.prototype);THREE.Group.prototype.constructor=THREE.Group;THREE.PointCloud=function(t,e){THREE.Object3D.call(this);this.type="PointCloud";this.geometry=t!==undefined?t:new THREE.Geometry;this.material=e!==undefined?e:new THREE.PointCloudMaterial({color:Math.random()*16777215})};THREE.PointCloud.prototype=Object.create(THREE.Object3D.prototype);THREE.PointCloud.prototype.constructor=THREE.PointCloud;THREE.PointCloud.prototype.raycast=function(){var t=new THREE.Matrix4;var e=new THREE.Ray;return function(r,i){var n=this;var o=n.geometry;var s=r.params.PointCloud.threshold;t.getInverse(this.matrixWorld);e.copy(r.ray).applyMatrix4(t);if(o.boundingBox!==null){if(e.isIntersectionBox(o.boundingBox)===false){return}}var a=s/((this.scale.x+this.scale.y+this.scale.z)/3);var u=new THREE.Vector3;var l=function(t,o){var s=e.distanceToPoint(t);if(s<a){var u=e.closestPointToPoint(t);u.applyMatrix4(n.matrixWorld);var l=r.ray.origin.distanceTo(u);i.push({distance:l,distanceToRay:s,point:u.clone(),index:o,face:null,object:n})}};if(o instanceof THREE.BufferGeometry){var h=o.attributes;var f=h.position.array;if(h.index!==undefined){var c=h.index.array;var p=o.offsets;if(p.length===0){var d={start:0,count:c.length,index:0};p=[d]}for(var m=0,v=p.length;m<v;++m){var g=p[m].start;var y=p[m].count;var E=p[m].index;for(var _=g,x=g+y;_<x;_++){var b=E+c[_];u.fromArray(f,b*3);l(u,b)}}}else{var T=f.length/3;for(var _=0;_<T;_++){u.set(f[3*_],f[3*_+1],f[3*_+2]);l(u,_)}}}else{var w=this.geometry.vertices;for(var _=0;_<w.length;_++){l(w[_],_)}}}}();THREE.PointCloud.prototype.clone=function(t){if(t===undefined)t=new THREE.PointCloud(this.geometry,this.material);THREE.Object3D.prototype.clone.call(this,t);return t};THREE.ParticleSystem=function(t,e){THREE.warn("THREE.ParticleSystem has been renamed to THREE.PointCloud.");return new THREE.PointCloud(t,e)};THREE.Line=function(t,e,r){THREE.Object3D.call(this);this.type="Line";this.geometry=t!==undefined?t:new THREE.Geometry;this.material=e!==undefined?e:new THREE.LineBasicMaterial({color:Math.random()*16777215});this.mode=r!==undefined?r:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=Object.create(THREE.Object3D.prototype);THREE.Line.prototype.constructor=THREE.Line;THREE.Line.prototype.raycast=function(){var t=new THREE.Matrix4;var e=new THREE.Ray;var r=new THREE.Sphere;return function(i,n){var o=i.linePrecision;var s=o*o;var a=this.geometry;if(a.boundingSphere===null)a.computeBoundingSphere();r.copy(a.boundingSphere);r.applyMatrix4(this.matrixWorld);if(i.ray.isIntersectionSphere(r)===false){return}t.getInverse(this.matrixWorld);e.copy(i.ray).applyMatrix4(t);var u=new THREE.Vector3;var l=new THREE.Vector3;var h=new THREE.Vector3;var f=new THREE.Vector3;var c=this.mode===THREE.LineStrip?1:2;if(a instanceof THREE.BufferGeometry){var p=a.attributes;if(p.index!==undefined){var d=p.index.array;var m=p.position.array;var v=a.offsets;if(v.length===0){v=[{start:0,count:d.length,index:0}]}for(var g=0;g<v.length;g++){var y=v[g].start;var E=v[g].count;var _=v[g].index;for(var x=y;x<y+E-1;x+=c){var b=_+d[x];var T=_+d[x+1];u.fromArray(m,b*3);l.fromArray(m,T*3);var w=e.distanceSqToSegment(u,l,f,h);if(w>s)continue;var R=e.origin.distanceTo(f);if(R<i.near||R>i.far)continue;n.push({distance:R,point:h.clone().applyMatrix4(this.matrixWorld),index:x,offsetIndex:g,face:null,faceIndex:null,object:this})}}}else{var m=p.position.array;for(var x=0;x<m.length/3-1;x+=c){u.fromArray(m,3*x);l.fromArray(m,3*x+3);var w=e.distanceSqToSegment(u,l,f,h);if(w>s)continue;var R=e.origin.distanceTo(f);if(R<i.near||R>i.far)continue;n.push({distance:R,point:h.clone().applyMatrix4(this.matrixWorld),index:x,face:null,faceIndex:null,object:this})}}}else if(a instanceof THREE.Geometry){var H=a.vertices;var M=H.length;for(var x=0;x<M-1;x+=c){var w=e.distanceSqToSegment(H[x],H[x+1],f,h);if(w>s)continue;var R=e.origin.distanceTo(f);if(R<i.near||R>i.far)continue;n.push({distance:R,point:h.clone().applyMatrix4(this.matrixWorld),index:x,face:null,faceIndex:null,object:this})}}}}();THREE.Line.prototype.clone=function(t){if(t===undefined)t=new THREE.Line(this.geometry,this.material,this.mode);THREE.Object3D.prototype.clone.call(this,t);return t};THREE.Mesh=function(t,e){THREE.Object3D.call(this);this.type="Mesh";this.geometry=t!==undefined?t:new THREE.Geometry;this.material=e!==undefined?e:new THREE.MeshBasicMaterial({color:Math.random()*16777215});this.updateMorphTargets()};THREE.Mesh.prototype=Object.create(THREE.Object3D.prototype);THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.updateMorphTargets=function(){if(this.geometry.morphTargets!==undefined&&this.geometry.morphTargets.length>0){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var t=0,e=this.geometry.morphTargets.length;t<e;t++){this.morphTargetInfluences.push(0);this.morphTargetDictionary[this.geometry.morphTargets[t].name]=t}}};THREE.Mesh.prototype.getMorphTargetIndexByName=function(t){if(this.morphTargetDictionary[t]!==undefined){return this.morphTargetDictionary[t]}THREE.warn("THREE.Mesh.getMorphTargetIndexByName: morph target "+t+" does not exist. Returning 0.");return 0};THREE.Mesh.prototype.raycast=function(){var t=new THREE.Matrix4;var e=new THREE.Ray;var r=new THREE.Sphere;var i=new THREE.Vector3;var n=new THREE.Vector3;var o=new THREE.Vector3;return function(s,a){var u=this.geometry;if(u.boundingSphere===null)u.computeBoundingSphere();r.copy(u.boundingSphere);r.applyMatrix4(this.matrixWorld);if(s.ray.isIntersectionSphere(r)===false){return}t.getInverse(this.matrixWorld);e.copy(s.ray).applyMatrix4(t);if(u.boundingBox!==null){if(e.isIntersectionBox(u.boundingBox)===false){return}}if(u instanceof THREE.BufferGeometry){var l=this.material;if(l===undefined)return;var h=u.attributes;var f,c,p;var d=s.precision;if(h.index!==undefined){var m=h.index.array;var v=h.position.array;var g=u.offsets;if(g.length===0){g=[{start:0,count:m.length,index:0}]}for(var y=0,E=g.length;y<E;++y){var _=g[y].start;var x=g[y].count;var b=g[y].index;for(var T=_,w=_+x;T<w;T+=3){f=b+m[T];c=b+m[T+1];p=b+m[T+2];i.fromArray(v,f*3);n.fromArray(v,c*3);o.fromArray(v,p*3);if(l.side===THREE.BackSide){var R=e.intersectTriangle(o,n,i,true)}else{var R=e.intersectTriangle(i,n,o,l.side!==THREE.DoubleSide)}if(R===null)continue;R.applyMatrix4(this.matrixWorld);var H=s.ray.origin.distanceTo(R);if(H<d||H<s.near||H>s.far)continue;a.push({distance:H,point:R,face:new THREE.Face3(f,c,p,THREE.Triangle.normal(i,n,o)),faceIndex:null,object:this})}}}else{var v=h.position.array;for(var T=0,M=0,w=v.length;T<w;T+=3,M+=9){f=T;c=T+1;p=T+2;i.fromArray(v,M);n.fromArray(v,M+3);o.fromArray(v,M+6);if(l.side===THREE.BackSide){var R=e.intersectTriangle(o,n,i,true)}else{var R=e.intersectTriangle(i,n,o,l.side!==THREE.DoubleSide)}if(R===null)continue;R.applyMatrix4(this.matrixWorld);var H=s.ray.origin.distanceTo(R);if(H<d||H<s.near||H>s.far)continue;a.push({distance:H,point:R,face:new THREE.Face3(f,c,p,THREE.Triangle.normal(i,n,o)),faceIndex:null,object:this})}}}else if(u instanceof THREE.Geometry){var S=this.material instanceof THREE.MeshFaceMaterial;var k=S===true?this.material.materials:null;var f,c,p;var d=s.precision;var A=u.vertices;for(var C=0,L=u.faces.length;C<L;C++){var P=u.faces[C];var l=S===true?k[P.materialIndex]:this.material;if(l===undefined)continue;f=A[P.a];c=A[P.b];p=A[P.c];if(l.morphTargets===true){var z=u.morphTargets;var D=this.morphTargetInfluences;i.set(0,0,0);n.set(0,0,0);o.set(0,0,0);for(var O=0,F=z.length;O<F;O++){var U=D[O];if(U===0)continue;var B=z[O].vertices;i.x+=(B[P.a].x-f.x)*U;i.y+=(B[P.a].y-f.y)*U;i.z+=(B[P.a].z-f.z)*U;n.x+=(B[P.b].x-c.x)*U;n.y+=(B[P.b].y-c.y)*U;n.z+=(B[P.b].z-c.z)*U;o.x+=(B[P.c].x-p.x)*U;o.y+=(B[P.c].y-p.y)*U;o.z+=(B[P.c].z-p.z)*U}i.add(f);n.add(c);o.add(p);f=i;c=n;p=o}if(l.side===THREE.BackSide){var R=e.intersectTriangle(p,c,f,true)}else{var R=e.intersectTriangle(f,c,p,l.side!==THREE.DoubleSide)}if(R===null)continue;R.applyMatrix4(this.matrixWorld);var H=s.ray.origin.distanceTo(R);if(H<d||H<s.near||H>s.far)continue;a.push({distance:H,point:R,face:P,faceIndex:C,object:this})}}}}();THREE.Mesh.prototype.clone=function(t,e){if(t===undefined)t=new THREE.Mesh(this.geometry,this.material);THREE.Object3D.prototype.clone.call(this,t,e);return t};THREE.Bone=function(t){THREE.Object3D.call(this);this.type="Bone";this.skin=t};THREE.Bone.prototype=Object.create(THREE.Object3D.prototype);THREE.Bone.prototype.constructor=THREE.Bone;THREE.Skeleton=function(t,e,r){this.useVertexTexture=r!==undefined?r:true;this.identityMatrix=new THREE.Matrix4;t=t||[];this.bones=t.slice(0);if(this.useVertexTexture){var i;if(this.bones.length>256)i=64;else if(this.bones.length>64)i=32;else if(this.bones.length>16)i=16;else i=8;this.boneTextureWidth=i;this.boneTextureHeight=i;this.boneMatrices=new Float32Array(this.boneTextureWidth*this.boneTextureHeight*4);this.boneTexture=new THREE.DataTexture(this.boneMatrices,this.boneTextureWidth,this.boneTextureHeight,THREE.RGBAFormat,THREE.FloatType);this.boneTexture.minFilter=THREE.NearestFilter;this.boneTexture.magFilter=THREE.NearestFilter;this.boneTexture.generateMipmaps=false;this.boneTexture.flipY=false}else{this.boneMatrices=new Float32Array(16*this.bones.length)}if(e===undefined){this.calculateInverses()}else{if(this.bones.length===e.length){this.boneInverses=e.slice(0)}else{THREE.warn("THREE.Skeleton bonInverses is the wrong length.");this.boneInverses=[];for(var n=0,o=this.bones.length;n<o;n++){this.boneInverses.push(new THREE.Matrix4)}}}};THREE.Skeleton.prototype.calculateInverses=function(){this.boneInverses=[];for(var t=0,e=this.bones.length;t<e;t++){var r=new THREE.Matrix4;if(this.bones[t]){r.getInverse(this.bones[t].matrixWorld)}this.boneInverses.push(r)}};THREE.Skeleton.prototype.pose=function(){var t;for(var e=0,r=this.bones.length;e<r;e++){t=this.bones[e];if(t){t.matrixWorld.getInverse(this.boneInverses[e])}}for(var e=0,r=this.bones.length;e<r;e++){t=this.bones[e];if(t){if(t.parent){t.matrix.getInverse(t.parent.matrixWorld);t.matrix.multiply(t.matrixWorld)}else{t.matrix.copy(t.matrixWorld)}t.matrix.decompose(t.position,t.quaternion,t.scale)}}};THREE.Skeleton.prototype.update=function(){var t=new THREE.Matrix4;return function(){for(var e=0,r=this.bones.length;e<r;e++){var i=this.bones[e]?this.bones[e].matrixWorld:this.identityMatrix;t.multiplyMatrices(i,this.boneInverses[e]);t.flattenToArrayOffset(this.boneMatrices,e*16)}if(this.useVertexTexture){this.boneTexture.needsUpdate=true}}}();THREE.SkinnedMesh=function(t,e,r){THREE.Mesh.call(this,t,e);this.type="SkinnedMesh";this.bindMode="attached";this.bindMatrix=new THREE.Matrix4;this.bindMatrixInverse=new THREE.Matrix4;var i=[];if(this.geometry&&this.geometry.bones!==undefined){var n,o,s,a,u;for(var l=0,h=this.geometry.bones.length;l<h;++l){o=this.geometry.bones[l];s=o.pos;a=o.rotq;u=o.scl;n=new THREE.Bone(this);i.push(n);n.name=o.name;n.position.set(s[0],s[1],s[2]);n.quaternion.set(a[0],a[1],a[2],a[3]);if(u!==undefined){n.scale.set(u[0],u[1],u[2])}else{n.scale.set(1,1,1)}}for(var l=0,h=this.geometry.bones.length;l<h;++l){o=this.geometry.bones[l];if(o.parent!==-1){i[o.parent].add(i[l])}else{this.add(i[l])}}}this.normalizeSkinWeights();this.updateMatrixWorld(true);this.bind(new THREE.Skeleton(i,undefined,r))};THREE.SkinnedMesh.prototype=Object.create(THREE.Mesh.prototype);THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;THREE.SkinnedMesh.prototype.bind=function(t,e){this.skeleton=t;if(e===undefined){this.updateMatrixWorld(true);e=this.matrixWorld}this.bindMatrix.copy(e);this.bindMatrixInverse.getInverse(e)};THREE.SkinnedMesh.prototype.pose=function(){this.skeleton.pose()};THREE.SkinnedMesh.prototype.normalizeSkinWeights=function(){if(this.geometry instanceof THREE.Geometry){for(var t=0;t<this.geometry.skinIndices.length;t++){var e=this.geometry.skinWeights[t];var r=1/e.lengthManhattan();if(r!==Infinity){e.multiplyScalar(r)}else{e.set(1)}}}else{}};THREE.SkinnedMesh.prototype.updateMatrixWorld=function(t){THREE.Mesh.prototype.updateMatrixWorld.call(this,true);if(this.bindMode==="attached"){this.bindMatrixInverse.getInverse(this.matrixWorld)}else if(this.bindMode==="detached"){this.bindMatrixInverse.getInverse(this.bindMatrix)}else{THREE.warn("THREE.SkinnedMesh unreckognized bindMode: "+this.bindMode)}};THREE.SkinnedMesh.prototype.clone=function(t){if(t===undefined){t=new THREE.SkinnedMesh(this.geometry,this.material,this.useVertexTexture)}THREE.Mesh.prototype.clone.call(this,t);return t};THREE.MorphAnimMesh=function(t,e){THREE.Mesh.call(this,t,e);this.type="MorphAnimMesh";this.duration=1e3;this.mirroredLoop=false;this.time=0;this.lastKeyframe=0;this.currentKeyframe=0;this.direction=1;this.directionBackwards=false;this.setFrameRange(0,this.geometry.morphTargets.length-1)};THREE.MorphAnimMesh.prototype=Object.create(THREE.Mesh.prototype);THREE.MorphAnimMesh.prototype.constructor=THREE.MorphAnimMesh;THREE.MorphAnimMesh.prototype.setFrameRange=function(t,e){this.startKeyframe=t;this.endKeyframe=e;this.length=this.endKeyframe-this.startKeyframe+1};THREE.MorphAnimMesh.prototype.setDirectionForward=function(){this.direction=1;this.directionBackwards=false};THREE.MorphAnimMesh.prototype.setDirectionBackward=function(){this.direction=-1;this.directionBackwards=true};THREE.MorphAnimMesh.prototype.parseAnimations=function(){var t=this.geometry;if(!t.animations)t.animations={};var e,r=t.animations;var i=/([a-z]+)_?(\d+)/;for(var n=0,o=t.morphTargets.length;n<o;n++){var s=t.morphTargets[n];var a=s.name.match(i);if(a&&a.length>1){var u=a[1];if(!r[u])r[u]={start:Infinity,end:-Infinity};var l=r[u];if(n<l.start)l.start=n;if(n>l.end)l.end=n;if(!e)e=u}}t.firstAnimation=e};THREE.MorphAnimMesh.prototype.setAnimationLabel=function(t,e,r){if(!this.geometry.animations)this.geometry.animations={};this.geometry.animations[t]={start:e,end:r}};THREE.MorphAnimMesh.prototype.playAnimation=function(t,e){var r=this.geometry.animations[t];if(r){this.setFrameRange(r.start,r.end);this.duration=1e3*((r.end-r.start)/e);this.time=0}else{THREE.warn("THREE.MorphAnimMesh: animation["+t+"] undefined in .playAnimation()")}};THREE.MorphAnimMesh.prototype.updateAnimation=function(t){var e=this.duration/this.length;this.time+=this.direction*t;if(this.mirroredLoop){if(this.time>this.duration||this.time<0){this.direction*=-1;if(this.time>this.duration){this.time=this.duration;this.directionBackwards=true}if(this.time<0){this.time=0;this.directionBackwards=false}}}else{this.time=this.time%this.duration;if(this.time<0)this.time+=this.duration}var r=this.startKeyframe+THREE.Math.clamp(Math.floor(this.time/e),0,this.length-1);if(r!==this.currentKeyframe){this.morphTargetInfluences[this.lastKeyframe]=0;this.morphTargetInfluences[this.currentKeyframe]=1;this.morphTargetInfluences[r]=0;this.lastKeyframe=this.currentKeyframe;this.currentKeyframe=r}var i=this.time%e/e;if(this.directionBackwards){i=1-i}this.morphTargetInfluences[this.currentKeyframe]=i;this.morphTargetInfluences[this.lastKeyframe]=1-i};THREE.MorphAnimMesh.prototype.interpolateTargets=function(t,e,r){var i=this.morphTargetInfluences;for(var n=0,o=i.length;n<o;n++){i[n]=0}if(t>-1)i[t]=1-r;if(e>-1)i[e]=r};THREE.MorphAnimMesh.prototype.clone=function(t){if(t===undefined)t=new THREE.MorphAnimMesh(this.geometry,this.material);t.duration=this.duration;t.mirroredLoop=this.mirroredLoop;t.time=this.time;t.lastKeyframe=this.lastKeyframe;t.currentKeyframe=this.currentKeyframe;t.direction=this.direction;t.directionBackwards=this.directionBackwards;THREE.Mesh.prototype.clone.call(this,t);return t};THREE.LOD=function(){THREE.Object3D.call(this);this.objects=[]};THREE.LOD.prototype=Object.create(THREE.Object3D.prototype);THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.addLevel=function(t,e){if(e===undefined)e=0;e=Math.abs(e);for(var r=0;r<this.objects.length;r++){if(e<this.objects[r].distance){break}}this.objects.splice(r,0,{distance:e,object:t});this.add(t)};THREE.LOD.prototype.getObjectForDistance=function(t){for(var e=1,r=this.objects.length;e<r;e++){if(t<this.objects[e].distance){break}}return this.objects[e-1].object};THREE.LOD.prototype.raycast=function(){var t=new THREE.Vector3;return function(e,r){t.setFromMatrixPosition(this.matrixWorld);var i=e.ray.origin.distanceTo(t);this.getObjectForDistance(i).raycast(e,r)}}();THREE.LOD.prototype.update=function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(r){if(this.objects.length>1){t.setFromMatrixPosition(r.matrixWorld);e.setFromMatrixPosition(this.matrixWorld);var i=t.distanceTo(e);this.objects[0].object.visible=true;for(var n=1,o=this.objects.length;n<o;n++){if(i>=this.objects[n].distance){this.objects[n-1].object.visible=false;this.objects[n].object.visible=true}else{break}}for(;n<o;n++){this.objects[n].object.visible=false}}}}();THREE.LOD.prototype.clone=function(t){if(t===undefined)t=new THREE.LOD;THREE.Object3D.prototype.clone.call(this,t);for(var e=0,r=this.objects.length;e<r;e++){var i=this.objects[e].object.clone();i.visible=e===0;t.addLevel(i,this.objects[e].distance)}return t};THREE.Sprite=function(){var t=new Uint16Array([0,1,2,0,2,3]);var e=new Float32Array([-.5,-.5,0,.5,-.5,0,.5,.5,0,-.5,.5,0]);var r=new Float32Array([0,0,1,0,1,1,0,1]);var i=new THREE.BufferGeometry;i.addAttribute("index",new THREE.BufferAttribute(t,1));i.addAttribute("position",new THREE.BufferAttribute(e,3));i.addAttribute("uv",new THREE.BufferAttribute(r,2));return function(t){THREE.Object3D.call(this);this.type="Sprite";this.geometry=i;this.material=t!==undefined?t:new THREE.SpriteMaterial}}();THREE.Sprite.prototype=Object.create(THREE.Object3D.prototype);THREE.Sprite.prototype.constructor=THREE.Sprite;THREE.Sprite.prototype.raycast=function(){var t=new THREE.Vector3;return function(e,r){t.setFromMatrixPosition(this.matrixWorld);var i=e.ray.distanceToPoint(t);if(i>this.scale.x){return}r.push({distance:i,point:this.position,face:null,object:this})}}();THREE.Sprite.prototype.clone=function(t){if(t===undefined)t=new THREE.Sprite(this.material);THREE.Object3D.prototype.clone.call(this,t);return t};THREE.Particle=THREE.Sprite;THREE.LensFlare=function(t,e,r,i,n){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=undefined;if(t!==undefined){this.add(t,e,r,i,n)}};THREE.LensFlare.prototype=Object.create(THREE.Object3D.prototype);THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.add=function(t,e,r,i,n,o){if(e===undefined)e=-1;if(r===undefined)r=0;if(o===undefined)o=1;if(n===undefined)n=new THREE.Color(16777215);if(i===undefined)i=THREE.NormalBlending;r=Math.min(r,Math.max(0,r));this.lensFlares.push({texture:t,size:e,distance:r,x:0,y:0,z:0,scale:1,rotation:1,opacity:o,color:n,blending:i})};THREE.LensFlare.prototype.updateLensFlares=function(){var t,e=this.lensFlares.length;var r;var i=-this.positionScreen.x*2;var n=-this.positionScreen.y*2;for(t=0;t<e;t++){r=this.lensFlares[t];r.x=this.positionScreen.x+i*r.distance;r.y=this.positionScreen.y+n*r.distance;r.wantedRotation=r.x*Math.PI*.25;r.rotation+=(r.wantedRotation-r.rotation)*.25}};THREE.Scene=function(){THREE.Object3D.call(this);this.type="Scene";this.fog=null;this.overrideMaterial=null;this.autoUpdate=true};THREE.Scene.prototype=Object.create(THREE.Object3D.prototype);THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.clone=function(t){if(t===undefined)t=new THREE.Scene;THREE.Object3D.prototype.clone.call(this,t);if(this.fog!==null)t.fog=this.fog.clone();if(this.overrideMaterial!==null)t.overrideMaterial=this.overrideMaterial.clone();t.autoUpdate=this.autoUpdate;t.matrixAutoUpdate=this.matrixAutoUpdate;return t};THREE.Fog=function(t,e,r){this.name="";this.color=new THREE.Color(t);this.near=e!==undefined?e:1;this.far=r!==undefined?r:1e3};THREE.Fog.prototype.clone=function(){return new THREE.Fog(this.color.getHex(),this.near,this.far)};THREE.FogExp2=function(t,e){this.name="";this.color=new THREE.Color(t);this.density=e!==undefined?e:25e-5};THREE.FogExp2.prototype.clone=function(){return new THREE.FogExp2(this.color.getHex(),this.density)};THREE.ShaderChunk={};THREE.ShaderChunk["common"]="#define PI 3.14159\n#define PI2 6.28318\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n\nfloat square( in float a ) { return a*a; }\nvec2  square( in vec2 a )  { return vec2( a.x*a.x, a.y*a.y ); }\nvec3  square( in vec3 a )  { return vec3( a.x*a.x, a.y*a.y, a.z*a.z ); }\nvec4  square( in vec4 a )  { return vec4( a.x*a.x, a.y*a.y, a.z*a.z, a.w*a.w ); }\nfloat saturate( in float a ) { return clamp( a, 0.0, 1.0 ); }\nvec2  saturate( in vec2 a )  { return clamp( a, 0.0, 1.0 ); }\nvec3  saturate( in vec3 a )  { return clamp( a, 0.0, 1.0 ); }\nvec4  saturate( in vec4 a )  { return clamp( a, 0.0, 1.0 ); }\nfloat average( in float a ) { return a; }\nfloat average( in vec2 a )  { return ( a.x + a.y) * 0.5; }\nfloat average( in vec3 a )  { return ( a.x + a.y + a.z) / 3.0; }\nfloat average( in vec4 a )  { return ( a.x + a.y + a.z + a.w) * 0.25; }\nfloat whiteCompliment( in float a ) { return saturate( 1.0 - a ); }\nvec2  whiteCompliment( in vec2 a )  { return saturate( vec2(1.0) - a ); }\nvec3  whiteCompliment( in vec3 a )  { return saturate( vec3(1.0) - a ); }\nvec4  whiteCompliment( in vec4 a )  { return saturate( vec4(1.0) - a ); }\nvec3 transformDirection( in vec3 normal, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( normal, 0.0 ) ).xyz );\n}\n// http://en.wikibooks.org/wiki/GLSL_Programming/Applying_Matrix_Transformations\nvec3 inverseTransformDirection( in vec3 normal, in mat4 matrix ) {\n\treturn normalize( ( vec4( normal, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal) {\n\tfloat distance = dot( planeNormal, point-pointOnPlane );\n\treturn point - distance * planeNormal;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn pointOnLine + lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) );\n}\nfloat calcLightAttenuation( float lightDistance, float cutoffDistance, float decayExponent ) {\n\tif ( decayExponent > 0.0 ) {\n\t  return pow( saturate( 1.0 - lightDistance / cutoffDistance ), decayExponent );\n\t}\n\treturn 1.0;\n}\n\nvec3 inputToLinear( in vec3 a ) {\n#ifdef GAMMA_INPUT\n\treturn pow( a, vec3( float( GAMMA_FACTOR ) ) );\n#else\n\treturn a;\n#endif\n}\nvec3 linearToOutput( in vec3 a ) {\n#ifdef GAMMA_OUTPUT\n\treturn pow( a, vec3( 1.0 / float( GAMMA_FACTOR ) ) );\n#else\n\treturn a;\n#endif\n}\n";THREE.ShaderChunk["alphatest_fragment"]="#ifdef ALPHATEST\n\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n\n#endif\n";THREE.ShaderChunk["lights_lambert_vertex"]="vLightFront = vec3( 0.0 );\n\n#ifdef DOUBLE_SIDED\n\n\tvLightBack = vec3( 0.0 );\n\n#endif\n\ntransformedNormal = normalize( transformedNormal );\n\n#if MAX_DIR_LIGHTS > 0\n\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\n\n\tvec3 dirVector = transformDirection( directionalLightDirection[ i ], viewMatrix );\n\n\tfloat dotProduct = dot( transformedNormal, dirVector );\n\tvec3 directionalLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n\t#ifdef DOUBLE_SIDED\n\n\t\tvec3 directionalLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n\t\t#ifdef WRAP_AROUND\n\n\t\t\tvec3 directionalLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n\t\t#endif\n\n\t#endif\n\n\t#ifdef WRAP_AROUND\n\n\t\tvec3 directionalLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n\t\tdirectionalLightWeighting = mix( directionalLightWeighting, directionalLightWeightingHalf, wrapRGB );\n\n\t\t#ifdef DOUBLE_SIDED\n\n\t\t\tdirectionalLightWeightingBack = mix( directionalLightWeightingBack, directionalLightWeightingHalfBack, wrapRGB );\n\n\t\t#endif\n\n\t#endif\n\n\tvLightFront += directionalLightColor[ i ] * directionalLightWeighting;\n\n\t#ifdef DOUBLE_SIDED\n\n\t\tvLightBack += directionalLightColor[ i ] * directionalLightWeightingBack;\n\n\t#endif\n\n}\n\n#endif\n\n#if MAX_POINT_LIGHTS > 0\n\n\tfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n\n\t\tvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\n\t\tvec3 lVector = lPosition.xyz - mvPosition.xyz;\n\n\t\tfloat attenuation = calcLightAttenuation( length( lVector ), pointLightDistance[ i ], pointLightDecay[ i ] );\n\n\t\tlVector = normalize( lVector );\n\t\tfloat dotProduct = dot( transformedNormal, lVector );\n\n\t\tvec3 pointLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n\t\t#ifdef DOUBLE_SIDED\n\n\t\t\tvec3 pointLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n\t\t\t#ifdef WRAP_AROUND\n\n\t\t\t\tvec3 pointLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n\t\t\t#endif\n\n\t\t#endif\n\n\t\t#ifdef WRAP_AROUND\n\n\t\t\tvec3 pointLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n\t\t\tpointLightWeighting = mix( pointLightWeighting, pointLightWeightingHalf, wrapRGB );\n\n\t\t\t#ifdef DOUBLE_SIDED\n\n\t\t\t\tpointLightWeightingBack = mix( pointLightWeightingBack, pointLightWeightingHalfBack, wrapRGB );\n\n\t\t\t#endif\n\n\t\t#endif\n\n\t\tvLightFront += pointLightColor[ i ] * pointLightWeighting * attenuation;\n\n\t\t#ifdef DOUBLE_SIDED\n\n\t\t\tvLightBack += pointLightColor[ i ] * pointLightWeightingBack * attenuation;\n\n\t\t#endif\n\n\t}\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n\tfor( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\n\n\t\tvec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\n\t\tvec3 lVector = lPosition.xyz - mvPosition.xyz;\n\n\t\tfloat spotEffect = dot( spotLightDirection[ i ], normalize( spotLightPosition[ i ] - worldPosition.xyz ) );\n\n\t\tif ( spotEffect > spotLightAngleCos[ i ] ) {\n\n\t\t\tspotEffect = max( pow( max( spotEffect, 0.0 ), spotLightExponent[ i ] ), 0.0 );\n\n\t\t\tfloat attenuation = calcLightAttenuation( length( lVector ), spotLightDistance[ i ], spotLightDecay[ i ] );\n\n\t\t\tlVector = normalize( lVector );\n\n\t\t\tfloat dotProduct = dot( transformedNormal, lVector );\n\t\t\tvec3 spotLightWeighting = vec3( max( dotProduct, 0.0 ) );\n\n\t\t\t#ifdef DOUBLE_SIDED\n\n\t\t\t\tvec3 spotLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n\n\t\t\t\t#ifdef WRAP_AROUND\n\n\t\t\t\t\tvec3 spotLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n\n\t\t\t\t#endif\n\n\t\t\t#endif\n\n\t\t\t#ifdef WRAP_AROUND\n\n\t\t\t\tvec3 spotLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\n\t\t\t\tspotLightWeighting = mix( spotLightWeighting, spotLightWeightingHalf, wrapRGB );\n\n\t\t\t\t#ifdef DOUBLE_SIDED\n\n\t\t\t\t\tspotLightWeightingBack = mix( spotLightWeightingBack, spotLightWeightingHalfBack, wrapRGB );\n\n\t\t\t\t#endif\n\n\t\t\t#endif\n\n\t\t\tvLightFront += spotLightColor[ i ] * spotLightWeighting * attenuation * spotEffect;\n\n\t\t\t#ifdef DOUBLE_SIDED\n\n\t\t\t\tvLightBack += spotLightColor[ i ] * spotLightWeightingBack * attenuation * spotEffect;\n\n\t\t\t#endif\n\n\t\t}\n\n\t}\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n\tfor( int i = 0; i < MAX_HEMI_LIGHTS; i ++ ) {\n\n\t\tvec3 lVector = transformDirection( hemisphereLightDirection[ i ], viewMatrix );\n\n\t\tfloat dotProduct = dot( transformedNormal, lVector );\n\n\t\tfloat hemiDiffuseWeight = 0.5 * dotProduct + 0.5;\n\t\tfloat hemiDiffuseWeightBack = -0.5 * dotProduct + 0.5;\n\n\t\tvLightFront += mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeight );\n\n\t\t#ifdef DOUBLE_SIDED\n\n\t\t\tvLightBack += mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeightBack );\n\n\t\t#endif\n\n\t}\n\n#endif\n\nvLightFront += ambientLightColor;\n\n#ifdef DOUBLE_SIDED\n\n\tvLightBack += ambientLightColor;\n\n#endif\n";THREE.ShaderChunk["map_particle_pars_fragment"]="#ifdef USE_MAP\n\n\tuniform vec4 offsetRepeat;\n\tuniform sampler2D map;\n\n#endif\n";THREE.ShaderChunk["default_vertex"]="#ifdef USE_SKINNING\n\n\tvec4 mvPosition = modelViewMatrix * skinned;\n\n#elif defined( USE_MORPHTARGETS )\n\n\tvec4 mvPosition = modelViewMatrix * vec4( morphed, 1.0 );\n\n#else\n\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\n#endif\n\ngl_Position = projectionMatrix * mvPosition;\n";THREE.ShaderChunk["map_pars_fragment"]="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n\tvarying vec2 vUv;\n\n#endif\n\n#ifdef USE_MAP\n\n\tuniform sampler2D map;\n\n#endif";THREE.ShaderChunk["skinnormal_vertex"]="#ifdef USE_SKINNING\n\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\n\t#ifdef USE_MORPHNORMALS\n\n\tvec4 skinnedNormal = skinMatrix * vec4( morphedNormal, 0.0 );\n\n\t#else\n\n\tvec4 skinnedNormal = skinMatrix * vec4( normal, 0.0 );\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["logdepthbuf_pars_vertex"]="#ifdef USE_LOGDEPTHBUF\n\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\n\t\tvarying float vFragDepth;\n\n\t#endif\n\n\tuniform float logDepthBufFC;\n\n#endif";THREE.ShaderChunk["lightmap_pars_vertex"]="#ifdef USE_LIGHTMAP\n\n\tvarying vec2 vUv2;\n\n#endif";THREE.ShaderChunk["lights_phong_fragment"]="#ifndef FLAT_SHADED\n\n\tvec3 normal = normalize( vNormal );\n\n\t#ifdef DOUBLE_SIDED\n\n\t\tnormal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n\n\t#endif\n\n#else\n\n\tvec3 fdx = dFdx( vViewPosition );\n\tvec3 fdy = dFdy( vViewPosition );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n\n#endif\n\nvec3 viewPosition = normalize( vViewPosition );\n\n#ifdef USE_NORMALMAP\n\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n\n#elif defined( USE_BUMPMAP )\n\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n\n#endif\n\nvec3 totalDiffuseLight = vec3( 0.0 );\nvec3 totalSpecularLight = vec3( 0.0 );\n\n#if MAX_POINT_LIGHTS > 0\n\n\tfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n\n\t\tvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\n\t\tvec3 lVector = lPosition.xyz + vViewPosition.xyz;\n\n\t\tfloat attenuation = calcLightAttenuation( length( lVector ), pointLightDistance[ i ], pointLightDecay[ i ] );\n\n\t\tlVector = normalize( lVector );\n\n\t\t// diffuse\n\n\t\tfloat dotProduct = dot( normal, lVector );\n\n\t\t#ifdef WRAP_AROUND\n\n\t\t\tfloat pointDiffuseWeightFull = max( dotProduct, 0.0 );\n\t\t\tfloat pointDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\n\n\t\t\tvec3 pointDiffuseWeight = mix( vec3( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n\n\t\t#else\n\n\t\t\tfloat pointDiffuseWeight = max( dotProduct, 0.0 );\n\n\t\t#endif\n\n\t\ttotalDiffuseLight += pointLightColor[ i ] * pointDiffuseWeight * attenuation;\n\n\t\t\t\t// specular\n\n\t\tvec3 pointHalfVector = normalize( lVector + viewPosition );\n\t\tfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\n\t\tfloat pointSpecularWeight = specularStrength * max( pow( pointDotNormalHalf, shininess ), 0.0 );\n\n\t\tfloat specularNormalization = ( shininess + 2.0 ) / 8.0;\n\n\t\tvec3 schlick = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( lVector, pointHalfVector ), 0.0 ), 5.0 );\n\t\ttotalSpecularLight += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * attenuation * specularNormalization;\n\n\t}\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n\tfor ( int i = 0; i < MAX_SPOT_LIGHTS; i ++ ) {\n\n\t\tvec4 lPosition = viewMatrix * vec4( spotLightPosition[ i ], 1.0 );\n\t\tvec3 lVector = lPosition.xyz + vViewPosition.xyz;\n\n\t\tfloat attenuation = calcLightAttenuation( length( lVector ), spotLightDistance[ i ], spotLightDecay[ i ] );\n\n\t\tlVector = normalize( lVector );\n\n\t\tfloat spotEffect = dot( spotLightDirection[ i ], normalize( spotLightPosition[ i ] - vWorldPosition ) );\n\n\t\tif ( spotEffect > spotLightAngleCos[ i ] ) {\n\n\t\t\tspotEffect = max( pow( max( spotEffect, 0.0 ), spotLightExponent[ i ] ), 0.0 );\n\n\t\t\t// diffuse\n\n\t\t\tfloat dotProduct = dot( normal, lVector );\n\n\t\t\t#ifdef WRAP_AROUND\n\n\t\t\t\tfloat spotDiffuseWeightFull = max( dotProduct, 0.0 );\n\t\t\t\tfloat spotDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\n\n\t\t\t\tvec3 spotDiffuseWeight = mix( vec3( spotDiffuseWeightFull ), vec3( spotDiffuseWeightHalf ), wrapRGB );\n\n\t\t\t#else\n\n\t\t\t\tfloat spotDiffuseWeight = max( dotProduct, 0.0 );\n\n\t\t\t#endif\n\n\t\t\ttotalDiffuseLight += spotLightColor[ i ] * spotDiffuseWeight * attenuation * spotEffect;\n\n\t\t\t// specular\n\n\t\t\tvec3 spotHalfVector = normalize( lVector + viewPosition );\n\t\t\tfloat spotDotNormalHalf = max( dot( normal, spotHalfVector ), 0.0 );\n\t\t\tfloat spotSpecularWeight = specularStrength * max( pow( spotDotNormalHalf, shininess ), 0.0 );\n\n\t\t\tfloat specularNormalization = ( shininess + 2.0 ) / 8.0;\n\n\t\t\tvec3 schlick = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( lVector, spotHalfVector ), 0.0 ), 5.0 );\n\t\t\ttotalSpecularLight += schlick * spotLightColor[ i ] * spotSpecularWeight * spotDiffuseWeight * attenuation * specularNormalization * spotEffect;\n\n\t\t}\n\n\t}\n\n#endif\n\n#if MAX_DIR_LIGHTS > 0\n\n\tfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\n\n\t\tvec3 dirVector = transformDirection( directionalLightDirection[ i ], viewMatrix );\n\n\t\t// diffuse\n\n\t\tfloat dotProduct = dot( normal, dirVector );\n\n\t\t#ifdef WRAP_AROUND\n\n\t\t\tfloat dirDiffuseWeightFull = max( dotProduct, 0.0 );\n\t\t\tfloat dirDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\n\n\t\t\tvec3 dirDiffuseWeight = mix( vec3( dirDiffuseWeightFull ), vec3( dirDiffuseWeightHalf ), wrapRGB );\n\n\t\t#else\n\n\t\t\tfloat dirDiffuseWeight = max( dotProduct, 0.0 );\n\n\t\t#endif\n\n\t\ttotalDiffuseLight += directionalLightColor[ i ] * dirDiffuseWeight;\n\n\t\t// specular\n\n\t\tvec3 dirHalfVector = normalize( dirVector + viewPosition );\n\t\tfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\n\t\tfloat dirSpecularWeight = specularStrength * max( pow( dirDotNormalHalf, shininess ), 0.0 );\n\n\t\t/*\n\t\t// fresnel term from skin shader\n\t\tconst float F0 = 0.128;\n\n\t\tfloat base = 1.0 - dot( viewPosition, dirHalfVector );\n\t\tfloat exponential = pow( base, 5.0 );\n\n\t\tfloat fresnel = exponential + F0 * ( 1.0 - exponential );\n\t\t*/\n\n\t\t/*\n\t\t// fresnel term from fresnel shader\n\t\tconst float mFresnelBias = 0.08;\n\t\tconst float mFresnelScale = 0.3;\n\t\tconst float mFresnelPower = 5.0;\n\n\t\tfloat fresnel = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( -viewPosition ), normal ), mFresnelPower );\n\t\t*/\n\n\t\tfloat specularNormalization = ( shininess + 2.0 ) / 8.0;\n\n\t\t// \t\tdirSpecular += specular * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight * specularNormalization * fresnel;\n\n\t\tvec3 schlick = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( dirVector, dirHalfVector ), 0.0 ), 5.0 );\n\t\ttotalSpecularLight += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight * specularNormalization;\n\n\n\t}\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n\tfor( int i = 0; i < MAX_HEMI_LIGHTS; i ++ ) {\n\n\t\tvec3 lVector = transformDirection( hemisphereLightDirection[ i ], viewMatrix );\n\n\t\t// diffuse\n\n\t\tfloat dotProduct = dot( normal, lVector );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotProduct + 0.5;\n\n\t\tvec3 hemiColor = mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeight );\n\n\t\ttotalDiffuseLight += hemiColor;\n\n\t\t// specular (sky light)\n\n\t\tvec3 hemiHalfVectorSky = normalize( lVector + viewPosition );\n\t\tfloat hemiDotNormalHalfSky = 0.5 * dot( normal, hemiHalfVectorSky ) + 0.5;\n\t\tfloat hemiSpecularWeightSky = specularStrength * max( pow( max( hemiDotNormalHalfSky, 0.0 ), shininess ), 0.0 );\n\n\t\t// specular (ground light)\n\n\t\tvec3 lVectorGround = -lVector;\n\n\t\tvec3 hemiHalfVectorGround = normalize( lVectorGround + viewPosition );\n\t\tfloat hemiDotNormalHalfGround = 0.5 * dot( normal, hemiHalfVectorGround ) + 0.5;\n\t\tfloat hemiSpecularWeightGround = specularStrength * max( pow( max( hemiDotNormalHalfGround, 0.0 ), shininess ), 0.0 );\n\n\t\tfloat dotProductGround = dot( normal, lVectorGround );\n\n\t\tfloat specularNormalization = ( shininess + 2.0 ) / 8.0;\n\n\t\tvec3 schlickSky = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( lVector, hemiHalfVectorSky ), 0.0 ), 5.0 );\n\t\tvec3 schlickGround = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( lVectorGround, hemiHalfVectorGround ), 0.0 ), 5.0 );\n\t\ttotalSpecularLight += hemiColor * specularNormalization * ( schlickSky * hemiSpecularWeightSky * max( dotProduct, 0.0 ) + schlickGround * hemiSpecularWeightGround * max( dotProductGround, 0.0 ) );\n\n\t}\n\n#endif\n\n#ifdef METAL\n\n\toutgoingLight += diffuseColor.rgb * ( totalDiffuseLight + ambientLightColor ) * specular + totalSpecularLight + emissive;\n\n#else\n\n\toutgoingLight += diffuseColor.rgb * ( totalDiffuseLight + ambientLightColor ) + totalSpecularLight + emissive;\n\n#endif\n";THREE.ShaderChunk["fog_pars_fragment"]="#ifdef USE_FOG\n\n\tuniform vec3 fogColor;\n\n\t#ifdef FOG_EXP2\n\n\t\tuniform float fogDensity;\n\n\t#else\n\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n\n#endif";THREE.ShaderChunk["morphnormal_vertex"]="#ifdef USE_MORPHNORMALS\n\n\tvec3 morphedNormal = vec3( 0.0 );\n\n\tmorphedNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tmorphedNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tmorphedNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tmorphedNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n\n\tmorphedNormal += normal;\n\n#endif";THREE.ShaderChunk["envmap_pars_fragment"]="#ifdef USE_ENVMAP\n\n\tuniform float reflectivity;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\n\t\tuniform float refractionRatio;\n\n\t#else\n\n\t\tvarying vec3 vReflect;\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["logdepthbuf_fragment"]="#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\n\tgl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n\n#endif";THREE.ShaderChunk["normalmap_pars_fragment"]="#ifdef USE_NORMALMAP\n\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\n\t// Per-Pixel Tangent Space Normal Mapping\n\t// http://hacksoflife.blogspot.ch/2009/11/per-pixel-tangent-space-normal-mapping.html\n\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\n\t}\n\n#endif\n";THREE.ShaderChunk["lights_phong_pars_vertex"]="#if MAX_SPOT_LIGHTS > 0 || defined( USE_BUMPMAP ) || defined( USE_ENVMAP )\n\n\tvarying vec3 vWorldPosition;\n\n#endif\n";THREE.ShaderChunk["lightmap_pars_fragment"]="#ifdef USE_LIGHTMAP\n\n\tvarying vec2 vUv2;\n\tuniform sampler2D lightMap;\n\n#endif";THREE.ShaderChunk["shadowmap_vertex"]="#ifdef USE_SHADOWMAP\n\n\tfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\n\n\t\tvShadowCoord[ i ] = shadowMatrix[ i ] * worldPosition;\n\n\t}\n\n#endif";THREE.ShaderChunk["lights_phong_vertex"]="#if MAX_SPOT_LIGHTS > 0 || defined( USE_BUMPMAP ) || defined( USE_ENVMAP )\n\n\tvWorldPosition = worldPosition.xyz;\n\n#endif";THREE.ShaderChunk["map_fragment"]="#ifdef USE_MAP\n\n\tvec4 texelColor = texture2D( map, vUv );\n\n\ttexelColor.xyz = inputToLinear( texelColor.xyz );\n\n\tdiffuseColor *= texelColor;\n\n#endif";THREE.ShaderChunk["lightmap_vertex"]="#ifdef USE_LIGHTMAP\n\n\tvUv2 = uv2;\n\n#endif";THREE.ShaderChunk["map_particle_fragment"]="#ifdef USE_MAP\n\n\tdiffuseColor *= texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n\n#endif\n";THREE.ShaderChunk["color_pars_fragment"]="#ifdef USE_COLOR\n\n\tvarying vec3 vColor;\n\n#endif\n";THREE.ShaderChunk["color_vertex"]="#ifdef USE_COLOR\n\n\tvColor.xyz = inputToLinear( color.xyz );\n\n#endif";THREE.ShaderChunk["skinning_vertex"]="#ifdef USE_SKINNING\n\n\t#ifdef USE_MORPHTARGETS\n\n\tvec4 skinVertex = bindMatrix * vec4( morphed, 1.0 );\n\n\t#else\n\n\tvec4 skinVertex = bindMatrix * vec4( position, 1.0 );\n\n\t#endif\n\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\tskinned  = bindMatrixInverse * skinned;\n\n#endif\n";THREE.ShaderChunk["envmap_pars_vertex"]="#if defined( USE_ENVMAP ) && ! defined( USE_BUMPMAP ) && ! defined( USE_NORMALMAP ) && ! defined( PHONG )\n\n\tvarying vec3 vReflect;\n\n\tuniform float refractionRatio;\n\n#endif\n";THREE.ShaderChunk["linear_to_gamma_fragment"]="\n\toutgoingLight = linearToOutput( outgoingLight );\n";THREE.ShaderChunk["color_pars_vertex"]="#ifdef USE_COLOR\n\n\tvarying vec3 vColor;\n\n#endif";THREE.ShaderChunk["lights_lambert_pars_vertex"]="uniform vec3 ambientLightColor;\n\n#if MAX_DIR_LIGHTS > 0\n\n\tuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\n\tuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n\tuniform vec3 hemisphereLightSkyColor[ MAX_HEMI_LIGHTS ];\n\tuniform vec3 hemisphereLightGroundColor[ MAX_HEMI_LIGHTS ];\n\tuniform vec3 hemisphereLightDirection[ MAX_HEMI_LIGHTS ];\n\n#endif\n\n#if MAX_POINT_LIGHTS > 0\n\n\tuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n\tuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n\tuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n\tuniform float pointLightDecay[ MAX_POINT_LIGHTS ];\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n\tuniform vec3 spotLightColor[ MAX_SPOT_LIGHTS ];\n\tuniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\n\tuniform vec3 spotLightDirection[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightAngleCos[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightExponent[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightDecay[ MAX_SPOT_LIGHTS ];\n\n#endif\n\n#ifdef WRAP_AROUND\n\n\tuniform vec3 wrapRGB;\n\n#endif\n";THREE.ShaderChunk["map_pars_vertex"]="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n\tvarying vec2 vUv;\n\tuniform vec4 offsetRepeat;\n\n#endif\n";THREE.ShaderChunk["envmap_fragment"]="#ifdef USE_ENVMAP\n\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\n\t\t// Transforming Normal Vectors with the Inverse Transformation\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\n\t\t#else\n\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\n\t\t#endif\n\n\t#else\n\n\t\tvec3 reflectVec = vReflect;\n\n\t#endif\n\n\t#ifdef DOUBLE_SIDED\n\t\tfloat flipNormal = ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n\t#else\n\t\tfloat flipNormal = 1.0;\n\t#endif\n\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\tsampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\tvec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#endif\n\n\tenvColor.xyz = inputToLinear( envColor.xyz );\n\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["specularmap_pars_fragment"]="#ifdef USE_SPECULARMAP\n\n\tuniform sampler2D specularMap;\n\n#endif";THREE.ShaderChunk["logdepthbuf_vertex"]="#ifdef USE_LOGDEPTHBUF\n\n\tgl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\n#else\n\n\t\tgl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\n\t#endif\n\n#endif";THREE.ShaderChunk["morphtarget_pars_vertex"]="#ifdef USE_MORPHTARGETS\n\n\t#ifndef USE_MORPHNORMALS\n\n\tuniform float morphTargetInfluences[ 8 ];\n\n\t#else\n\n\tuniform float morphTargetInfluences[ 4 ];\n\n\t#endif\n\n#endif";THREE.ShaderChunk["specularmap_fragment"]="float specularStrength;\n\n#ifdef USE_SPECULARMAP\n\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n\n#else\n\n\tspecularStrength = 1.0;\n\n#endif";THREE.ShaderChunk["fog_fragment"]="#ifdef USE_FOG\n\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\n\t\tfloat depth = gl_FragDepthEXT / gl_FragCoord.w;\n\n\t#else\n\n\t\tfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n\n\t#endif\n\n\t#ifdef FOG_EXP2\n\n\t\tfloat fogFactor = exp2( - square( fogDensity ) * square( depth ) * LOG2 );\n\t\tfogFactor = whiteCompliment( fogFactor );\n\n\t#else\n\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n\n\t#endif\n\t\n\toutgoingLight = mix( outgoingLight, fogColor, fogFactor );\n\n#endif";THREE.ShaderChunk["bumpmap_pars_fragment"]="#ifdef USE_BUMPMAP\n\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\n\t// Derivative maps - bump mapping unparametrized surfaces by Morten Mikkelsen\n\t// http://mmikkelsen3d.blogspot.sk/2011/07/derivative-maps.html\n\n\t// Evaluate the derivative of the height w.r.t. screen-space using forward differencing (listing 2)\n\n\tvec2 dHdxy_fwd() {\n\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\n\t\treturn vec2( dBx, dBy );\n\n\t}\n\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\n\t\tvec3 vSigmaX = dFdx( surf_pos );\n\t\tvec3 vSigmaY = dFdy( surf_pos );\n\t\tvec3 vN = surf_norm;\t\t// normalized\n\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\n\t}\n\n#endif\n";THREE.ShaderChunk["defaultnormal_vertex"]="#ifdef USE_SKINNING\n\n\tvec3 objectNormal = skinnedNormal.xyz;\n\n#elif defined( USE_MORPHNORMALS )\n\n\tvec3 objectNormal = morphedNormal;\n\n#else\n\n\tvec3 objectNormal = normal;\n\n#endif\n\n#ifdef FLIP_SIDED\n\n\tobjectNormal = -objectNormal;\n\n#endif\n\nvec3 transformedNormal = normalMatrix * objectNormal;\n";THREE.ShaderChunk["lights_phong_pars_fragment"]="uniform vec3 ambientLightColor;\n\n#if MAX_DIR_LIGHTS > 0\n\n\tuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\n\tuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n\n#endif\n\n#if MAX_HEMI_LIGHTS > 0\n\n\tuniform vec3 hemisphereLightSkyColor[ MAX_HEMI_LIGHTS ];\n\tuniform vec3 hemisphereLightGroundColor[ MAX_HEMI_LIGHTS ];\n\tuniform vec3 hemisphereLightDirection[ MAX_HEMI_LIGHTS ];\n\n#endif\n\n#if MAX_POINT_LIGHTS > 0\n\n\tuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n\n\tuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n\tuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n\tuniform float pointLightDecay[ MAX_POINT_LIGHTS ];\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0\n\n\tuniform vec3 spotLightColor[ MAX_SPOT_LIGHTS ];\n\tuniform vec3 spotLightPosition[ MAX_SPOT_LIGHTS ];\n\tuniform vec3 spotLightDirection[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightAngleCos[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightExponent[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightDistance[ MAX_SPOT_LIGHTS ];\n\tuniform float spotLightDecay[ MAX_SPOT_LIGHTS ];\n\n#endif\n\n#if MAX_SPOT_LIGHTS > 0 || defined( USE_BUMPMAP ) || defined( USE_ENVMAP )\n\n\tvarying vec3 vWorldPosition;\n\n#endif\n\n#ifdef WRAP_AROUND\n\n\tuniform vec3 wrapRGB;\n\n#endif\n\nvarying vec3 vViewPosition;\n\n#ifndef FLAT_SHADED\n\n\tvarying vec3 vNormal;\n\n#endif\n";THREE.ShaderChunk["skinbase_vertex"]="#ifdef USE_SKINNING\n\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n\n#endif";THREE.ShaderChunk["map_vertex"]="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP )\n\n\tvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n\n#endif";THREE.ShaderChunk["lightmap_fragment"]="#ifdef USE_LIGHTMAP\n\n\toutgoingLight *= diffuseColor.xyz * texture2D( lightMap, vUv2 ).xyz;\n\n#endif";THREE.ShaderChunk["shadowmap_pars_vertex"]="#ifdef USE_SHADOWMAP\n\n\tvarying vec4 vShadowCoord[ MAX_SHADOWS ];\n\tuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n\n#endif";THREE.ShaderChunk["color_fragment"]="#ifdef USE_COLOR\n\n\tdiffuseColor.rgb *= vColor;\n\n#endif";THREE.ShaderChunk["morphtarget_vertex"]="#ifdef USE_MORPHTARGETS\n\n\tvec3 morphed = vec3( 0.0 );\n\tmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\tmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\tmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\tmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\n\t#ifndef USE_MORPHNORMALS\n\n\tmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\tmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\tmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\tmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\n\t#endif\n\n\tmorphed += position;\n\n#endif";THREE.ShaderChunk["envmap_vertex"]="#if defined( USE_ENVMAP ) && ! defined( USE_BUMPMAP ) && ! defined( USE_NORMALMAP ) && ! defined( PHONG )\n\n\tvec3 worldNormal = transformDirection( objectNormal, modelMatrix );\n\n\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\n\t#ifdef ENVMAP_MODE_REFLECTION\n\n\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\n\t#else\n\n\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["shadowmap_fragment"]="#ifdef USE_SHADOWMAP\n\n\t#ifdef SHADOWMAP_DEBUG\n\n\t\tvec3 frustumColors[3];\n\t\tfrustumColors[0] = vec3( 1.0, 0.5, 0.0 );\n\t\tfrustumColors[1] = vec3( 0.0, 1.0, 0.8 );\n\t\tfrustumColors[2] = vec3( 0.0, 0.5, 1.0 );\n\n\t#endif\n\n\t#ifdef SHADOWMAP_CASCADE\n\n\t\tint inFrustumCount = 0;\n\n\t#endif\n\n\tfloat fDepth;\n\tvec3 shadowColor = vec3( 1.0 );\n\n\tfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\n\n\t\tvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\n\n\t\t\t\t// if ( something && something ) breaks ATI OpenGL shader compiler\n\t\t\t\t// if ( all( something, something ) ) using this instead\n\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\n\t\t\t\t// don't shadow pixels outside of light frustum\n\t\t\t\t// use just first frustum (for cascades)\n\t\t\t\t// don't shadow pixels behind far plane of light frustum\n\n\t\t#ifdef SHADOWMAP_CASCADE\n\n\t\t\tinFrustumCount += int( inFrustum );\n\t\t\tbvec3 frustumTestVec = bvec3( inFrustum, inFrustumCount == 1, shadowCoord.z <= 1.0 );\n\n\t\t#else\n\n\t\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\n\t\t#endif\n\n\t\tbool frustumTest = all( frustumTestVec );\n\n\t\tif ( frustumTest ) {\n\n\t\t\tshadowCoord.z += shadowBias[ i ];\n\n\t\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\n\t\t\t\t\t\t// Percentage-close filtering\n\t\t\t\t\t\t// (9 pixel kernel)\n\t\t\t\t\t\t// http://fabiensanglard.net/shadowmappingPCF/\n\n\t\t\t\tfloat shadow = 0.0;\n\n\t\t/*\n\t\t\t\t\t\t// nested loops breaks shader compiler / validator on some ATI cards when using OpenGL\n\t\t\t\t\t\t// must enroll loop manually\n\n\t\t\t\tfor ( float y = -1.25; y <= 1.25; y += 1.25 )\n\t\t\t\t\tfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\n\n\t\t\t\t\t\tvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\n\n\t\t\t\t\t\t\t\t// doesn't seem to produce any noticeable visual difference compared to simple texture2D lookup\n\t\t\t\t\t\t\t\t//vec4 rgbaDepth = texture2DProj( shadowMap[ i ], vec4( vShadowCoord[ i ].w * ( vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy ), 0.05, vShadowCoord[ i ].w ) );\n\n\t\t\t\t\t\tfloat fDepth = unpackDepth( rgbaDepth );\n\n\t\t\t\t\t\tif ( fDepth < shadowCoord.z )\n\t\t\t\t\t\t\tshadow += 1.0;\n\n\t\t\t\t}\n\n\t\t\t\tshadow /= 9.0;\n\n\t\t*/\n\n\t\t\t\tconst float shadowDelta = 1.0 / 9.0;\n\n\t\t\t\tfloat xPixelOffset = 1.0 / shadowMapSize[ i ].x;\n\t\t\t\tfloat yPixelOffset = 1.0 / shadowMapSize[ i ].y;\n\n\t\t\t\tfloat dx0 = -1.25 * xPixelOffset;\n\t\t\t\tfloat dy0 = -1.25 * yPixelOffset;\n\t\t\t\tfloat dx1 = 1.25 * xPixelOffset;\n\t\t\t\tfloat dy1 = 1.25 * yPixelOffset;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\n\t\t\t\tif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\n\n\t\t\t\tshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n\n\t\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\n\t\t\t\t\t\t// Percentage-close filtering\n\t\t\t\t\t\t// (9 pixel kernel)\n\t\t\t\t\t\t// http://fabiensanglard.net/shadowmappingPCF/\n\n\t\t\t\tfloat shadow = 0.0;\n\n\t\t\t\tfloat xPixelOffset = 1.0 / shadowMapSize[ i ].x;\n\t\t\t\tfloat yPixelOffset = 1.0 / shadowMapSize[ i ].y;\n\n\t\t\t\tfloat dx0 = -1.0 * xPixelOffset;\n\t\t\t\tfloat dy0 = -1.0 * yPixelOffset;\n\t\t\t\tfloat dx1 = 1.0 * xPixelOffset;\n\t\t\t\tfloat dy1 = 1.0 * yPixelOffset;\n\n\t\t\t\tmat3 shadowKernel;\n\t\t\t\tmat3 depthKernel;\n\n\t\t\t\tdepthKernel[0][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\n\t\t\t\tdepthKernel[0][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\n\t\t\t\tdepthKernel[0][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\n\t\t\t\tdepthKernel[1][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\n\t\t\t\tdepthKernel[1][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\n\t\t\t\tdepthKernel[1][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\n\t\t\t\tdepthKernel[2][0] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\n\t\t\t\tdepthKernel[2][1] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\n\t\t\t\tdepthKernel[2][2] = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\n\n\t\t\t\tvec3 shadowZ = vec3( shadowCoord.z );\n\t\t\t\tshadowKernel[0] = vec3(lessThan(depthKernel[0], shadowZ ));\n\t\t\t\tshadowKernel[0] *= vec3(0.25);\n\n\t\t\t\tshadowKernel[1] = vec3(lessThan(depthKernel[1], shadowZ ));\n\t\t\t\tshadowKernel[1] *= vec3(0.25);\n\n\t\t\t\tshadowKernel[2] = vec3(lessThan(depthKernel[2], shadowZ ));\n\t\t\t\tshadowKernel[2] *= vec3(0.25);\n\n\t\t\t\tvec2 fractionalCoord = 1.0 - fract( shadowCoord.xy * shadowMapSize[i].xy );\n\n\t\t\t\tshadowKernel[0] = mix( shadowKernel[1], shadowKernel[0], fractionalCoord.x );\n\t\t\t\tshadowKernel[1] = mix( shadowKernel[2], shadowKernel[1], fractionalCoord.x );\n\n\t\t\t\tvec4 shadowValues;\n\t\t\t\tshadowValues.x = mix( shadowKernel[0][1], shadowKernel[0][0], fractionalCoord.y );\n\t\t\t\tshadowValues.y = mix( shadowKernel[0][2], shadowKernel[0][1], fractionalCoord.y );\n\t\t\t\tshadowValues.z = mix( shadowKernel[1][1], shadowKernel[1][0], fractionalCoord.y );\n\t\t\t\tshadowValues.w = mix( shadowKernel[1][2], shadowKernel[1][1], fractionalCoord.y );\n\n\t\t\t\tshadow = dot( shadowValues, vec4( 1.0 ) );\n\n\t\t\t\tshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n\n\t\t\t#else\n\n\t\t\t\tvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\n\t\t\t\tfloat fDepth = unpackDepth( rgbaDepth );\n\n\t\t\t\tif ( fDepth < shadowCoord.z )\n\n\t\t// spot with multiple shadows is darker\n\n\t\t\t\t\tshadowColor = shadowColor * vec3( 1.0 - shadowDarkness[ i ] );\n\n\t\t// spot with multiple shadows has the same color as single shadow spot\n\n\t\t// \t\t\t\t\tshadowColor = min( shadowColor, vec3( shadowDarkness[ i ] ) );\n\n\t\t\t#endif\n\n\t\t}\n\n\n\t\t#ifdef SHADOWMAP_DEBUG\n\n\t\t\t#ifdef SHADOWMAP_CASCADE\n\n\t\t\t\tif ( inFrustum && inFrustumCount == 1 ) outgoingLight *= frustumColors[ i ];\n\n\t\t\t#else\n\n\t\t\t\tif ( inFrustum ) outgoingLight *= frustumColors[ i ];\n\n\t\t\t#endif\n\n\t\t#endif\n\n\t}\n\n\t// NOTE: I am unsure if this is correct in linear space.  -bhouston, Dec 29, 2014\n\tshadowColor = inputToLinear( shadowColor );\n\n\toutgoingLight = outgoingLight * shadowColor;\n\n#endif\n";THREE.ShaderChunk["worldpos_vertex"]="#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n\n\t#ifdef USE_SKINNING\n\n\t\tvec4 worldPosition = modelMatrix * skinned;\n\n\t#elif defined( USE_MORPHTARGETS )\n\n\t\tvec4 worldPosition = modelMatrix * vec4( morphed, 1.0 );\n\n\t#else\n\n\t\tvec4 worldPosition = modelMatrix * vec4( position, 1.0 );\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["shadowmap_pars_fragment"]="#ifdef USE_SHADOWMAP\n\n\tuniform sampler2D shadowMap[ MAX_SHADOWS ];\n\tuniform vec2 shadowMapSize[ MAX_SHADOWS ];\n\n\tuniform float shadowDarkness[ MAX_SHADOWS ];\n\tuniform float shadowBias[ MAX_SHADOWS ];\n\n\tvarying vec4 vShadowCoord[ MAX_SHADOWS ];\n\n\tfloat unpackDepth( const in vec4 rgba_depth ) {\n\n\t\tconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\n\t\tfloat depth = dot( rgba_depth, bit_shift );\n\t\treturn depth;\n\n\t}\n\n#endif";THREE.ShaderChunk["skinning_pars_vertex"]="#ifdef USE_SKINNING\n\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\n\t#ifdef BONE_TEXTURE\n\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureWidth;\n\t\tuniform int boneTextureHeight;\n\n\t\tmat4 getBoneMatrix( const in float i ) {\n\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureWidth ) );\n\t\t\tfloat y = floor( j / float( boneTextureWidth ) );\n\n\t\t\tfloat dx = 1.0 / float( boneTextureWidth );\n\t\t\tfloat dy = 1.0 / float( boneTextureHeight );\n\n\t\t\ty = dy * ( y + 0.5 );\n\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\n\t\t\treturn bone;\n\n\t\t}\n\n\t#else\n\n\t\tuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n\n\t\tmat4 getBoneMatrix( const in float i ) {\n\n\t\t\tmat4 bone = boneGlobalMatrices[ int(i) ];\n\t\t\treturn bone;\n\n\t\t}\n\n\t#endif\n\n#endif\n";THREE.ShaderChunk["logdepthbuf_pars_fragment"]="#ifdef USE_LOGDEPTHBUF\n\n\tuniform float logDepthBufFC;\n\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\n\t\t#extension GL_EXT_frag_depth : enable\n\t\tvarying float vFragDepth;\n\n\t#endif\n\n#endif";THREE.ShaderChunk["alphamap_fragment"]="#ifdef USE_ALPHAMAP\n\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n\n#endif\n";THREE.ShaderChunk["alphamap_pars_fragment"]="#ifdef USE_ALPHAMAP\n\n\tuniform sampler2D alphaMap;\n\n#endif\n";THREE.UniformsUtils={merge:function(t){var e={};for(var r=0;r<t.length;r++){var i=this.clone(t[r]);for(var n in i){e[n]=i[n]}}return e},clone:function(t){var e={};for(var r in t){e[r]={};for(var i in t[r]){var n=t[r][i];if(n instanceof THREE.Color||n instanceof THREE.Vector2||n instanceof THREE.Vector3||n instanceof THREE.Vector4||n instanceof THREE.Matrix4||n instanceof THREE.Texture){e[r][i]=n.clone()}else if(n instanceof Array){e[r][i]=n.slice()}else{e[r][i]=n}}}return e}};THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:null},specularMap:{type:"t",value:null},alphaMap:{type:"t",value:null},envMap:{type:"t",value:null},flipEnvMap:{type:"f",value:-1},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:.98},morphTargetInfluences:{type:"f",value:0}},bump:{bumpMap:{type:"t",value:null},bumpScale:{type:"f",value:1}},normalmap:{normalMap:{type:"t",value:null},normalScale:{type:"v2",value:new THREE.Vector2(1,1)}},fog:{fogDensity:{type:"f",value:25e-5},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2e3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},hemisphereLightDirection:{type:"fv",value:[]},hemisphereLightSkyColor:{type:"fv",value:[]},hemisphereLightGroundColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]},pointLightDecay:{type:"fv1",value:[]},spotLightColor:{type:"fv",value:[]},spotLightPosition:{type:"fv",value:[]},spotLightDirection:{type:"fv",value:[]},spotLightDistance:{type:"fv1",value:[]},spotLightAngleCos:{type:"fv1",value:[]},spotLightExponent:{type:"fv1",value:[]},spotLightDecay:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},fogDensity:{type:"f",value:25e-5},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2e3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:[]},shadowMapSize:{type:"v2v",value:[]},shadowBias:{type:"fv1",value:[]},shadowDarkness:{type:"fv1",value:[]},shadowMatrix:{type:"m4v",value:[]}}};THREE.ShaderLib={basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib["common"],THREE.UniformsLib["fog"],THREE.UniformsLib["shadowmap"]]),vertexShader:[THREE.ShaderChunk["common"],THREE.ShaderChunk["map_pars_vertex"],THREE.ShaderChunk["lightmap_pars_vertex"],THREE.ShaderChunk["envmap_pars_vertex"],THREE.ShaderChunk["color_pars_vertex"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["skinning_pars_vertex"],THREE.ShaderChunk["shadowmap_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["map_vertex"],THREE.ShaderChunk["lightmap_vertex"],THREE.ShaderChunk["color_vertex"],THREE.ShaderChunk["skinbase_vertex"],"\t#ifdef USE_ENVMAP",THREE.ShaderChunk["morphnormal_vertex"],THREE.ShaderChunk["skinnormal_vertex"],THREE.ShaderChunk["defaultnormal_vertex"],"\t#endif",THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["skinning_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],THREE.ShaderChunk["worldpos_vertex"],THREE.ShaderChunk["envmap_vertex"],THREE.ShaderChunk["shadowmap_vertex"],"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;","uniform float opacity;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_fragment"],THREE.ShaderChunk["map_pars_fragment"],THREE.ShaderChunk["alphamap_pars_fragment"],THREE.ShaderChunk["lightmap_pars_fragment"],THREE.ShaderChunk["envmap_pars_fragment"],THREE.ShaderChunk["fog_pars_fragment"],THREE.ShaderChunk["shadowmap_pars_fragment"],THREE.ShaderChunk["specularmap_pars_fragment"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tvec3 outgoingLight = vec3( 0.0 );","\tvec4 diffuseColor = vec4( diffuse, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],THREE.ShaderChunk["map_fragment"],THREE.ShaderChunk["color_fragment"],THREE.ShaderChunk["alphamap_fragment"],THREE.ShaderChunk["alphatest_fragment"],THREE.ShaderChunk["specularmap_fragment"],"\toutgoingLight = diffuseColor.rgb;",THREE.ShaderChunk["lightmap_fragment"],THREE.ShaderChunk["envmap_fragment"],THREE.ShaderChunk["shadowmap_fragment"],THREE.ShaderChunk["linear_to_gamma_fragment"],THREE.ShaderChunk["fog_fragment"],"\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );","}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib["common"],THREE.UniformsLib["fog"],THREE.UniformsLib["lights"],THREE.UniformsLib["shadowmap"],{emissive:{type:"c",value:new THREE.Color(0)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["#define LAMBERT","varying vec3 vLightFront;","#ifdef DOUBLE_SIDED","\tvarying vec3 vLightBack;","#endif",THREE.ShaderChunk["common"],THREE.ShaderChunk["map_pars_vertex"],THREE.ShaderChunk["lightmap_pars_vertex"],THREE.ShaderChunk["envmap_pars_vertex"],THREE.ShaderChunk["lights_lambert_pars_vertex"],THREE.ShaderChunk["color_pars_vertex"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["skinning_pars_vertex"],THREE.ShaderChunk["shadowmap_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["map_vertex"],THREE.ShaderChunk["lightmap_vertex"],THREE.ShaderChunk["color_vertex"],THREE.ShaderChunk["morphnormal_vertex"],THREE.ShaderChunk["skinbase_vertex"],THREE.ShaderChunk["skinnormal_vertex"],THREE.ShaderChunk["defaultnormal_vertex"],THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["skinning_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],THREE.ShaderChunk["worldpos_vertex"],THREE.ShaderChunk["envmap_vertex"],THREE.ShaderChunk["lights_lambert_vertex"],THREE.ShaderChunk["shadowmap_vertex"],"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;","uniform vec3 emissive;","uniform float opacity;","varying vec3 vLightFront;","#ifdef DOUBLE_SIDED","\tvarying vec3 vLightBack;","#endif",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_fragment"],THREE.ShaderChunk["map_pars_fragment"],THREE.ShaderChunk["alphamap_pars_fragment"],THREE.ShaderChunk["lightmap_pars_fragment"],THREE.ShaderChunk["envmap_pars_fragment"],THREE.ShaderChunk["fog_pars_fragment"],THREE.ShaderChunk["shadowmap_pars_fragment"],THREE.ShaderChunk["specularmap_pars_fragment"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tvec3 outgoingLight = vec3( 0.0 );","\tvec4 diffuseColor = vec4( diffuse, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],THREE.ShaderChunk["map_fragment"],THREE.ShaderChunk["color_fragment"],THREE.ShaderChunk["alphamap_fragment"],THREE.ShaderChunk["alphatest_fragment"],THREE.ShaderChunk["specularmap_fragment"],"\t#ifdef DOUBLE_SIDED","\t\tif ( gl_FrontFacing )","\t\t\toutgoingLight += diffuseColor.rgb * vLightFront + emissive;","\t\telse","\t\t\toutgoingLight += diffuseColor.rgb * vLightBack + emissive;","\t#else","\t\toutgoingLight += diffuseColor.rgb * vLightFront + emissive;","\t#endif",THREE.ShaderChunk["lightmap_fragment"],THREE.ShaderChunk["envmap_fragment"],THREE.ShaderChunk["shadowmap_fragment"],THREE.ShaderChunk["linear_to_gamma_fragment"],THREE.ShaderChunk["fog_fragment"],"\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );","}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib["common"],THREE.UniformsLib["bump"],THREE.UniformsLib["normalmap"],THREE.UniformsLib["fog"],THREE.UniformsLib["lights"],THREE.UniformsLib["shadowmap"],{emissive:{type:"c",value:new THREE.Color(0)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["#define PHONG","varying vec3 vViewPosition;","#ifndef FLAT_SHADED","\tvarying vec3 vNormal;","#endif",THREE.ShaderChunk["common"],THREE.ShaderChunk["map_pars_vertex"],THREE.ShaderChunk["lightmap_pars_vertex"],THREE.ShaderChunk["envmap_pars_vertex"],THREE.ShaderChunk["lights_phong_pars_vertex"],THREE.ShaderChunk["color_pars_vertex"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["skinning_pars_vertex"],THREE.ShaderChunk["shadowmap_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["map_vertex"],THREE.ShaderChunk["lightmap_vertex"],THREE.ShaderChunk["color_vertex"],THREE.ShaderChunk["morphnormal_vertex"],THREE.ShaderChunk["skinbase_vertex"],THREE.ShaderChunk["skinnormal_vertex"],THREE.ShaderChunk["defaultnormal_vertex"],"#ifndef FLAT_SHADED","\tvNormal = normalize( transformedNormal );","#endif",THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["skinning_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],"\tvViewPosition = -mvPosition.xyz;",THREE.ShaderChunk["worldpos_vertex"],THREE.ShaderChunk["envmap_vertex"],THREE.ShaderChunk["lights_phong_vertex"],THREE.ShaderChunk["shadowmap_vertex"],"}"].join("\n"),fragmentShader:["#define PHONG","uniform vec3 diffuse;","uniform vec3 emissive;","uniform vec3 specular;","uniform float shininess;","uniform float opacity;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_fragment"],THREE.ShaderChunk["map_pars_fragment"],THREE.ShaderChunk["alphamap_pars_fragment"],THREE.ShaderChunk["lightmap_pars_fragment"],THREE.ShaderChunk["envmap_pars_fragment"],THREE.ShaderChunk["fog_pars_fragment"],THREE.ShaderChunk["lights_phong_pars_fragment"],THREE.ShaderChunk["shadowmap_pars_fragment"],THREE.ShaderChunk["bumpmap_pars_fragment"],THREE.ShaderChunk["normalmap_pars_fragment"],THREE.ShaderChunk["specularmap_pars_fragment"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tvec3 outgoingLight = vec3( 0.0 );","\tvec4 diffuseColor = vec4( diffuse, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],THREE.ShaderChunk["map_fragment"],THREE.ShaderChunk["color_fragment"],THREE.ShaderChunk["alphamap_fragment"],THREE.ShaderChunk["alphatest_fragment"],THREE.ShaderChunk["specularmap_fragment"],THREE.ShaderChunk["lights_phong_fragment"],THREE.ShaderChunk["lightmap_fragment"],THREE.ShaderChunk["envmap_fragment"],THREE.ShaderChunk["shadowmap_fragment"],THREE.ShaderChunk["linear_to_gamma_fragment"],THREE.ShaderChunk["fog_fragment"],"\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );","}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib["particle"],THREE.UniformsLib["shadowmap"]]),vertexShader:["uniform float size;","uniform float scale;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_vertex"],THREE.ShaderChunk["shadowmap_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["color_vertex"],"\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );","\t#ifdef USE_SIZEATTENUATION","\t\tgl_PointSize = size * ( scale / length( mvPosition.xyz ) );","\t#else","\t\tgl_PointSize = size;","\t#endif","\tgl_Position = projectionMatrix * mvPosition;",THREE.ShaderChunk["logdepthbuf_vertex"],THREE.ShaderChunk["worldpos_vertex"],THREE.ShaderChunk["shadowmap_vertex"],"}"].join("\n"),fragmentShader:["uniform vec3 psColor;","uniform float opacity;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_fragment"],THREE.ShaderChunk["map_particle_pars_fragment"],THREE.ShaderChunk["fog_pars_fragment"],THREE.ShaderChunk["shadowmap_pars_fragment"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tvec3 outgoingLight = vec3( 0.0 );","\tvec4 diffuseColor = vec4( psColor, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],THREE.ShaderChunk["map_particle_fragment"],THREE.ShaderChunk["color_fragment"],THREE.ShaderChunk["alphatest_fragment"],"\toutgoingLight = diffuseColor.rgb;",THREE.ShaderChunk["shadowmap_fragment"],THREE.ShaderChunk["fog_fragment"],"\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );","}"].join("\n")},dashed:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib["common"],THREE.UniformsLib["fog"],{scale:{type:"f",value:1},dashSize:{type:"f",value:1},totalSize:{type:"f",value:2}}]),vertexShader:["uniform float scale;","attribute float lineDistance;","varying float vLineDistance;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["color_vertex"],"\tvLineDistance = scale * lineDistance;","\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );","\tgl_Position = projectionMatrix * mvPosition;",THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;","uniform float opacity;","uniform float dashSize;","uniform float totalSize;","varying float vLineDistance;",THREE.ShaderChunk["common"],THREE.ShaderChunk["color_pars_fragment"],THREE.ShaderChunk["fog_pars_fragment"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tif ( mod( vLineDistance, totalSize ) > dashSize ) {","\t\tdiscard;","\t}","\tvec3 outgoingLight = vec3( 0.0 );","\tvec4 diffuseColor = vec4( diffuse, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],THREE.ShaderChunk["color_fragment"],"\toutgoingLight = diffuseColor.rgb;",THREE.ShaderChunk["fog_fragment"],"\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );","}"].join("\n")},depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2e3},opacity:{type:"f",value:1}},vertexShader:[THREE.ShaderChunk["common"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:["uniform float mNear;","uniform float mFar;","uniform float opacity;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {",THREE.ShaderChunk["logdepthbuf_fragment"],"\t#ifdef USE_LOGDEPTHBUF_EXT","\t\tfloat depth = gl_FragDepthEXT / gl_FragCoord.w;","\t#else","\t\tfloat depth = gl_FragCoord.z / gl_FragCoord.w;","\t#endif","\tfloat color = 1.0 - smoothstep( mNear, mFar, depth );","\tgl_FragColor = vec4( vec3( color ), opacity );","}"].join("\n")},normal:{uniforms:{opacity:{type:"f",value:1}},vertexShader:["varying vec3 vNormal;",THREE.ShaderChunk["common"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {","\tvNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:["uniform float opacity;","varying vec3 vNormal;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tgl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );",THREE.ShaderChunk["logdepthbuf_fragment"],"}"].join("\n")},cube:{uniforms:{tCube:{type:"t",value:null},tFlip:{type:"f",value:-1}},vertexShader:["varying vec3 vWorldPosition;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {","\tvWorldPosition = transformDirection( position, modelMatrix );","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:["uniform samplerCube tCube;","uniform float tFlip;","varying vec3 vWorldPosition;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );",THREE.ShaderChunk["logdepthbuf_fragment"],"}"].join("\n")},equirect:{uniforms:{tEquirect:{type:"t",value:null},tFlip:{type:"f",value:-1}},vertexShader:["varying vec3 vWorldPosition;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {","\tvWorldPosition = transformDirection( position, modelMatrix );","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:["uniform sampler2D tEquirect;","uniform float tFlip;","varying vec3 vWorldPosition;",THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"void main() {","vec3 direction = normalize( vWorldPosition );","vec2 sampleUV;","sampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );","sampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;","gl_FragColor = texture2D( tEquirect, sampleUV );",THREE.ShaderChunk["logdepthbuf_fragment"],"}"].join("\n")},depthRGBA:{uniforms:{},vertexShader:[THREE.ShaderChunk["common"],THREE.ShaderChunk["morphtarget_pars_vertex"],THREE.ShaderChunk["skinning_pars_vertex"],THREE.ShaderChunk["logdepthbuf_pars_vertex"],"void main() {",THREE.ShaderChunk["skinbase_vertex"],THREE.ShaderChunk["morphtarget_vertex"],THREE.ShaderChunk["skinning_vertex"],THREE.ShaderChunk["default_vertex"],THREE.ShaderChunk["logdepthbuf_vertex"],"}"].join("\n"),fragmentShader:[THREE.ShaderChunk["common"],THREE.ShaderChunk["logdepthbuf_pars_fragment"],"vec4 pack_depth( const in float depth ) {","\tconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );","\tconst vec4 bit_mask = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );","\tvec4 res = mod( depth * bit_shift * vec4( 255 ), vec4( 256 ) ) / vec4( 255 );","\tres -= res.xxyz * bit_mask;","\treturn res;","}","void main() {",THREE.ShaderChunk["logdepthbuf_fragment"],"\t#ifdef USE_LOGDEPTHBUF_EXT","\t\tgl_FragData[ 0 ] = pack_depth( gl_FragDepthEXT );","\t#else","\t\tgl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );","\t#endif","}"].join("\n")}};THREE.WebGLRenderer=function(t){console.log("THREE.WebGLRenderer",THREE.REVISION);t=t||{};var e=t.canvas!==undefined?t.canvas:document.createElement("canvas"),r=t.context!==undefined?t.context:null,i=1,n=t.precision!==undefined?t.precision:"highp",o=t.alpha!==undefined?t.alpha:false,s=t.depth!==undefined?t.depth:true,a=t.stencil!==undefined?t.stencil:true,u=t.antialias!==undefined?t.antialias:false,l=t.premultipliedAlpha!==undefined?t.premultipliedAlpha:true,h=t.preserveDrawingBuffer!==undefined?t.preserveDrawingBuffer:false,f=t.logarithmicDepthBuffer!==undefined?t.logarithmicDepthBuffer:false,c=new THREE.Color(0),p=0;var d=[];var m={};var v=[];var g=[];var y=[];var E=[];var _=[];this.domElement=e;this.context=null;this.autoClear=true;this.autoClearColor=true;this.autoClearDepth=true;this.autoClearStencil=true;this.sortObjects=true;this.gammaFactor=2;this.gammaInput=false;this.gammaOutput=false;this.shadowMapEnabled=false;this.shadowMapType=THREE.PCFShadowMap;this.shadowMapCullFace=THREE.CullFaceFront;this.shadowMapDebug=false;this.shadowMapCascade=false;this.maxMorphTargets=8;this.maxMorphNormals=4;this.autoScaleCubemaps=true;this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}};var x=this,b=[],T=null,w=null,R=-1,H="",M=null,S=0,k=0,A=0,C=e.width,L=e.height,P=0,z=0,D=new THREE.Frustum,O=new THREE.Matrix4,F=new THREE.Vector3,U=new THREE.Vector3,B=true,V={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[],decays:[]},spot:{length:0,colors:[],positions:[],distances:[],directions:[],anglesCos:[],exponents:[],decays:[]},hemi:{length:0,skyColors:[],groundColors:[],positions:[]}};var N;try{var I={alpha:o,depth:s,stencil:a,antialias:u,premultipliedAlpha:l,preserveDrawingBuffer:h};N=r||e.getContext("webgl",I)||e.getContext("experimental-webgl",I);if(N===null){if(e.getContext("webgl")!==null){throw"Error creating WebGL context with your selected attributes."}else{throw"Error creating WebGL context."}}e.addEventListener("webglcontextlost",function(t){t.preventDefault();q();X();m={}},false)}catch(t){THREE.error("THREE.WebGLRenderer: "+t)}var j=new THREE.WebGLState(N,Se);if(N.getShaderPrecisionFormat===undefined){N.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}}}var G=new THREE.WebGLExtensions(N);G.get("OES_texture_float");G.get("OES_texture_float_linear");G.get("OES_texture_half_float");G.get("OES_texture_half_float_linear");G.get("OES_standard_derivatives");if(f){G.get("EXT_frag_depth")}var W=function(t,e,r,i){if(l===true){t*=i;e*=i;r*=i}N.clearColor(t,e,r,i)};var X=function(){N.clearColor(0,0,0,1);N.clearDepth(1);N.clearStencil(0);N.enable(N.DEPTH_TEST);N.depthFunc(N.LEQUAL);N.frontFace(N.CCW);N.cullFace(N.BACK);N.enable(N.CULL_FACE);N.enable(N.BLEND);N.blendEquation(N.FUNC_ADD);N.blendFunc(N.SRC_ALPHA,N.ONE_MINUS_SRC_ALPHA);N.viewport(k,A,C,L);W(c.r,c.g,c.b,p)};var q=function(){T=null;M=null;H="";R=-1;B=true;j.reset()};X();this.context=N;this.state=j;var Y=N.getParameter(N.MAX_TEXTURE_IMAGE_UNITS);var Z=N.getParameter(N.MAX_VERTEX_TEXTURE_IMAGE_UNITS);var K=N.getParameter(N.MAX_TEXTURE_SIZE);var Q=N.getParameter(N.MAX_CUBE_MAP_TEXTURE_SIZE);var J=Z>0;var $=J&&G.get("OES_texture_float");var tt=N.getShaderPrecisionFormat(N.VERTEX_SHADER,N.HIGH_FLOAT);var et=N.getShaderPrecisionFormat(N.VERTEX_SHADER,N.MEDIUM_FLOAT);var rt=N.getShaderPrecisionFormat(N.FRAGMENT_SHADER,N.HIGH_FLOAT);var it=N.getShaderPrecisionFormat(N.FRAGMENT_SHADER,N.MEDIUM_FLOAT);var nt=function(){var t;return function(){if(t!==undefined){return t}t=[];if(G.get("WEBGL_compressed_texture_pvrtc")||G.get("WEBGL_compressed_texture_s3tc")){var e=N.getParameter(N.COMPRESSED_TEXTURE_FORMATS);for(var r=0;r<e.length;r++){t.push(e[r])}}return t}}();var ot=tt.precision>0&&rt.precision>0;var st=et.precision>0&&it.precision>0;if(n==="highp"&&!ot){if(st){n="mediump";THREE.warn("THREE.WebGLRenderer: highp not supported, using mediump.")}else{n="lowp";THREE.warn("THREE.WebGLRenderer: highp and mediump not supported, using lowp.")}}if(n==="mediump"&&!st){n="lowp";THREE.warn("THREE.WebGLRenderer: mediump not supported, using lowp.")}var at=new THREE.ShadowMapPlugin(this,d,m,v);var ut=new THREE.SpritePlugin(this,E);var lt=new THREE.LensFlarePlugin(this,_);this.getContext=function(){return N};this.forceContextLoss=function(){G.get("WEBGL_lose_context").loseContext()};this.supportsVertexTextures=function(){return J};this.supportsFloatTextures=function(){return G.get("OES_texture_float")};this.supportsHalfFloatTextures=function(){return G.get("OES_texture_half_float")};this.supportsStandardDerivatives=function(){return G.get("OES_standard_derivatives")};this.supportsCompressedTextureS3TC=function(){return G.get("WEBGL_compressed_texture_s3tc")};this.supportsCompressedTexturePVRTC=function(){return G.get("WEBGL_compressed_texture_pvrtc")};this.supportsBlendMinMax=function(){return G.get("EXT_blend_minmax")};this.getMaxAnisotropy=function(){var t;return function(){if(t!==undefined){return t}var e=G.get("EXT_texture_filter_anisotropic");t=e!==null?N.getParameter(e.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0;return t}}();this.getPrecision=function(){return n};this.getPixelRatio=function(){return i};this.setPixelRatio=function(t){i=t};this.setSize=function(t,r,n){e.width=t*i;e.height=r*i;if(n!==false){e.style.width=t+"px";e.style.height=r+"px"}this.setViewport(0,0,t,r)};this.setViewport=function(t,e,r,n){k=t*i;A=e*i;C=r*i;L=n*i;N.viewport(k,A,C,L)};this.setScissor=function(t,e,r,n){N.scissor(t*i,e*i,r*i,n*i)};this.enableScissorTest=function(t){t?N.enable(N.SCISSOR_TEST):N.disable(N.SCISSOR_TEST)};this.getClearColor=function(){return c};this.setClearColor=function(t,e){c.set(t);p=e!==undefined?e:1;W(c.r,c.g,c.b,p)};this.getClearAlpha=function(){return p};this.setClearAlpha=function(t){p=t;W(c.r,c.g,c.b,p)};this.clear=function(t,e,r){var i=0;if(t===undefined||t)i|=N.COLOR_BUFFER_BIT;if(e===undefined||e)i|=N.DEPTH_BUFFER_BIT;if(r===undefined||r)i|=N.STENCIL_BUFFER_BIT;N.clear(i)};this.clearColor=function(){N.clear(N.COLOR_BUFFER_BIT)};this.clearDepth=function(){N.clear(N.DEPTH_BUFFER_BIT)};this.clearStencil=function(){N.clear(N.STENCIL_BUFFER_BIT)};this.clearTarget=function(t,e,r,i){this.setRenderTarget(t);this.clear(e,r,i)};this.resetGLState=q;function ht(t){t.__webglVertexBuffer=N.createBuffer();t.__webglColorBuffer=N.createBuffer();x.info.memory.geometries++}function ft(t){t.__webglVertexBuffer=N.createBuffer();t.__webglColorBuffer=N.createBuffer();t.__webglLineDistanceBuffer=N.createBuffer();x.info.memory.geometries++}function ct(t){t.__webglVertexBuffer=N.createBuffer();t.__webglNormalBuffer=N.createBuffer();t.__webglTangentBuffer=N.createBuffer();t.__webglColorBuffer=N.createBuffer();t.__webglUVBuffer=N.createBuffer();t.__webglUV2Buffer=N.createBuffer();t.__webglSkinIndicesBuffer=N.createBuffer();t.__webglSkinWeightsBuffer=N.createBuffer();t.__webglFaceBuffer=N.createBuffer();t.__webglLineBuffer=N.createBuffer();var e=t.numMorphTargets;if(e){t.__webglMorphTargetsBuffers=[];for(var r=0,i=e;r<i;r++){t.__webglMorphTargetsBuffers.push(N.createBuffer())}}var n=t.numMorphNormals;if(n){t.__webglMorphNormalsBuffers=[];for(var r=0,i=n;r<i;r++){t.__webglMorphNormalsBuffers.push(N.createBuffer())}}x.info.memory.geometries++}var pt=function(t){var e=t.target;e.traverse(function(t){t.removeEventListener("remove",pt);Jt(t)})};var dt=function(t){var e=t.target;e.removeEventListener("dispose",dt);Et(e)};var mt=function(t){var e=t.target;e.removeEventListener("dispose",mt);_t(e);x.info.memory.textures--};var vt=function(t){var e=t.target;e.removeEventListener("dispose",vt);xt(e);x.info.memory.textures--};var gt=function(t){var e=t.target;e.removeEventListener("dispose",gt);bt(e)};var yt=function(t){var e=["__webglVertexBuffer","__webglNormalBuffer","__webglTangentBuffer","__webglColorBuffer","__webglUVBuffer","__webglUV2Buffer","__webglSkinIndicesBuffer","__webglSkinWeightsBuffer","__webglFaceBuffer","__webglLineBuffer","__webglLineDistanceBuffer"];for(var r=0,i=e.length;r<i;r++){var n=e[r];if(t[n]!==undefined){N.deleteBuffer(t[n]);delete t[n]}}if(t.__webglCustomAttributesList!==undefined){for(var n in t.__webglCustomAttributesList){N.deleteBuffer(t.__webglCustomAttributesList[n].buffer)}delete t.__webglCustomAttributesList}x.info.memory.geometries--};var Et=function(t){delete t.__webglInit;if(t instanceof THREE.BufferGeometry){for(var e in t.attributes){var r=t.attributes[e];if(r.buffer!==undefined){N.deleteBuffer(r.buffer);delete r.buffer}}x.info.memory.geometries--}else{var i=jt[t.id];if(i!==undefined){for(var n=0,o=i.length;n<o;n++){var s=i[n];if(s.numMorphTargets!==undefined){for(var a=0,u=s.numMorphTargets;a<u;a++){N.deleteBuffer(s.__webglMorphTargetsBuffers[a])}delete s.__webglMorphTargetsBuffers}if(s.numMorphNormals!==undefined){for(var a=0,u=s.numMorphNormals;a<u;a++){N.deleteBuffer(s.__webglMorphNormalsBuffers[a])}delete s.__webglMorphNormalsBuffers}yt(s)}delete jt[t.id]}else{yt(t)}}H=""};var _t=function(t){if(t.image&&t.image.__webglTextureCube){N.deleteTexture(t.image.__webglTextureCube);delete t.image.__webglTextureCube}else{if(t.__webglInit===undefined)return;N.deleteTexture(t.__webglTexture);delete t.__webglTexture;delete t.__webglInit}};var xt=function(t){if(!t||t.__webglTexture===undefined)return;N.deleteTexture(t.__webglTexture);delete t.__webglTexture;if(t instanceof THREE.WebGLRenderTargetCube){for(var e=0;e<6;e++){N.deleteFramebuffer(t.__webglFramebuffer[e]);N.deleteRenderbuffer(t.__webglRenderbuffer[e])}}else{N.deleteFramebuffer(t.__webglFramebuffer);N.deleteRenderbuffer(t.__webglRenderbuffer)}delete t.__webglFramebuffer;delete t.__webglRenderbuffer};var bt=function(t){var e=t.program.program;if(e===undefined)return;t.program=undefined;var r,i,n;var o=false;for(r=0,i=b.length;r<i;r++){n=b[r];if(n.program===e){n.usedTimes--;if(n.usedTimes===0){o=true}break}}if(o===true){var s=[];for(r=0,i=b.length;r<i;r++){n=b[r];if(n.program!==e){s.push(n)}}b=s;N.deleteProgram(e);x.info.memory.programs--}};function Tt(t){var e=t.geometry;var r=t.material;var i=e.vertices.length;if(r.attributes){if(e.__webglCustomAttributesList===undefined){e.__webglCustomAttributesList=[]}for(var n in r.attributes){var o=r.attributes[n];if(!o.__webglInitialized||o.createUniqueBuffers){o.__webglInitialized=true;var s=1;if(o.type==="v2")s=2;else if(o.type==="v3")s=3;else if(o.type==="v4")s=4;else if(o.type==="c")s=3;o.size=s;o.array=new Float32Array(i*s);o.buffer=N.createBuffer();o.buffer.belongsToAttribute=n;o.needsUpdate=true}e.__webglCustomAttributesList.push(o)}}}function wt(t,e){var r=t.vertices.length;t.__vertexArray=new Float32Array(r*3);t.__colorArray=new Float32Array(r*3);t.__webglParticleCount=r;Tt(e)}function Rt(t,e){var r=t.vertices.length;t.__vertexArray=new Float32Array(r*3);t.__colorArray=new Float32Array(r*3);t.__lineDistanceArray=new Float32Array(r*1);t.__webglLineCount=r;Tt(e)}function Ht(t,e){var r=e.geometry,i=t.faces3,n=i.length*3,o=i.length*1,s=i.length*3,a=Mt(e,t);t.__vertexArray=new Float32Array(n*3);t.__normalArray=new Float32Array(n*3);t.__colorArray=new Float32Array(n*3);t.__uvArray=new Float32Array(n*2);if(r.faceVertexUvs.length>1){t.__uv2Array=new Float32Array(n*2)}if(r.hasTangents){t.__tangentArray=new Float32Array(n*4)}if(e.geometry.skinWeights.length&&e.geometry.skinIndices.length){t.__skinIndexArray=new Float32Array(n*4);t.__skinWeightArray=new Float32Array(n*4)}var u=G.get("OES_element_index_uint")!==null&&o>21845?Uint32Array:Uint16Array;t.__typeArray=u;t.__faceArray=new u(o*3);t.__lineArray=new u(s*2);var l=t.numMorphTargets;if(l){t.__morphTargetsArrays=[];for(var h=0,f=l;h<f;h++){t.__morphTargetsArrays.push(new Float32Array(n*3))}}var c=t.numMorphNormals;if(c){t.__morphNormalsArrays=[];for(var h=0,f=c;h<f;h++){t.__morphNormalsArrays.push(new Float32Array(n*3))}}t.__webglFaceCount=o*3;t.__webglLineCount=s*2;if(a.attributes){if(t.__webglCustomAttributesList===undefined){t.__webglCustomAttributesList=[]}for(var p in a.attributes){var d=a.attributes[p];var m={};for(var v in d){m[v]=d[v]}if(!m.__webglInitialized||m.createUniqueBuffers){m.__webglInitialized=true;var g=1;if(m.type==="v2")g=2;else if(m.type==="v3")g=3;else if(m.type==="v4")g=4;else if(m.type==="c")g=3;m.size=g;m.array=new Float32Array(n*g);m.buffer=N.createBuffer();m.buffer.belongsToAttribute=p;d.needsUpdate=true;m.__original=d}t.__webglCustomAttributesList.push(m)}}t.__inittedArrays=true}function Mt(t,e){return t.material instanceof THREE.MeshFaceMaterial?t.material.materials[e.materialIndex]:t.material}function St(t){return t instanceof THREE.MeshPhongMaterial===false&&t.shading===THREE.FlatShading}function kt(t,e,r){var i,n,o,s,a,u=t.vertices,l=u.length,h=t.colors,f=h.length,c=t.__vertexArray,p=t.__colorArray,d=t.verticesNeedUpdate,m=t.colorsNeedUpdate,v=t.__webglCustomAttributesList,g,y,E,_,x,b;if(d){for(i=0;i<l;i++){o=u[i];s=i*3;c[s]=o.x;c[s+1]=o.y;c[s+2]=o.z}N.bindBuffer(N.ARRAY_BUFFER,t.__webglVertexBuffer);N.bufferData(N.ARRAY_BUFFER,c,e)}if(m){for(n=0;n<f;n++){a=h[n];s=n*3;p[s]=a.r;p[s+1]=a.g;p[s+2]=a.b}N.bindBuffer(N.ARRAY_BUFFER,t.__webglColorBuffer);N.bufferData(N.ARRAY_BUFFER,p,e)}if(v){for(g=0,y=v.length;g<y;g++){b=v[g];if(b.needsUpdate&&(b.boundTo===undefined||b.boundTo==="vertices")){_=b.value.length;s=0;if(b.size===1){for(E=0;E<_;E++){b.array[E]=b.value[E]}}else if(b.size===2){for(E=0;E<_;E++){x=b.value[E];b.array[s]=x.x;b.array[s+1]=x.y;s+=2}}else if(b.size===3){if(b.type==="c"){for(E=0;E<_;E++){x=b.value[E];b.array[s]=x.r;b.array[s+1]=x.g;b.array[s+2]=x.b;s+=3}}else{for(E=0;E<_;E++){x=b.value[E];b.array[s]=x.x;b.array[s+1]=x.y;b.array[s+2]=x.z;s+=3}}}else if(b.size===4){for(E=0;E<_;E++){x=b.value[E];b.array[s]=x.x;b.array[s+1]=x.y;b.array[s+2]=x.z;b.array[s+3]=x.w;s+=4}}}N.bindBuffer(N.ARRAY_BUFFER,b.buffer);N.bufferData(N.ARRAY_BUFFER,b.array,e);b.needsUpdate=false}}}function At(t,e){var r,i,n,o,s,a,u=t.vertices,l=t.colors,h=t.lineDistances,f=u.length,c=l.length,p=h.length,d=t.__vertexArray,m=t.__colorArray,v=t.__lineDistanceArray,g=t.verticesNeedUpdate,y=t.colorsNeedUpdate,E=t.lineDistancesNeedUpdate,_=t.__webglCustomAttributesList,x,b,T,w,R,H;if(g){for(r=0;r<f;r++){o=u[r];s=r*3;d[s]=o.x;d[s+1]=o.y;d[s+2]=o.z}N.bindBuffer(N.ARRAY_BUFFER,t.__webglVertexBuffer);N.bufferData(N.ARRAY_BUFFER,d,e)}if(y){for(i=0;i<c;i++){a=l[i];s=i*3;m[s]=a.r;m[s+1]=a.g;m[s+2]=a.b}N.bindBuffer(N.ARRAY_BUFFER,t.__webglColorBuffer);N.bufferData(N.ARRAY_BUFFER,m,e)}if(E){for(n=0;n<p;n++){v[n]=h[n]}N.bindBuffer(N.ARRAY_BUFFER,t.__webglLineDistanceBuffer);N.bufferData(N.ARRAY_BUFFER,v,e)}if(_){for(x=0,b=_.length;x<b;x++){H=_[x];if(H.needsUpdate&&(H.boundTo===undefined||H.boundTo==="vertices")){s=0;w=H.value.length;if(H.size===1){for(T=0;T<w;T++){H.array[T]=H.value[T]}}else if(H.size===2){for(T=0;T<w;T++){R=H.value[T];H.array[s]=R.x;H.array[s+1]=R.y;s+=2}}else if(H.size===3){if(H.type==="c"){for(T=0;T<w;T++){R=H.value[T];H.array[s]=R.r;H.array[s+1]=R.g;H.array[s+2]=R.b;s+=3}}else{for(T=0;T<w;T++){R=H.value[T];H.array[s]=R.x;H.array[s+1]=R.y;H.array[s+2]=R.z;s+=3}}}else if(H.size===4){for(T=0;T<w;T++){R=H.value[T];H.array[s]=R.x;H.array[s+1]=R.y;H.array[s+2]=R.z;H.array[s+3]=R.w;s+=4}}N.bindBuffer(N.ARRAY_BUFFER,H.buffer);N.bufferData(N.ARRAY_BUFFER,H.array,e);H.needsUpdate=false}}}}function Ct(t,e,r,i,n){if(!t.__inittedArrays){return}var o=St(n);var s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,I,j,G,W,X,q=0,Y=0,Z=0,K=0,Q=0,J=0,$=0,tt=0,et=0,rt=0,it=0,nt=0,ot,st=t.__vertexArray,at=t.__uvArray,ut=t.__uv2Array,lt=t.__normalArray,ht=t.__tangentArray,ft=t.__colorArray,ct=t.__skinIndexArray,pt=t.__skinWeightArray,dt=t.__morphTargetsArrays,mt=t.__morphNormalsArrays,vt=t.__webglCustomAttributesList,gt,yt=t.__faceArray,Et=t.__lineArray,_t=e.geometry,xt=_t.verticesNeedUpdate,bt=_t.elementsNeedUpdate,Tt=_t.uvsNeedUpdate,wt=_t.normalsNeedUpdate,Rt=_t.tangentsNeedUpdate,Ht=_t.colorsNeedUpdate,Mt=_t.morphTargetsNeedUpdate,kt=_t.vertices,At=t.faces3,Ct=_t.faces,Lt=_t.faceVertexUvs[0],Pt=_t.faceVertexUvs[1],zt=_t.skinIndices,Dt=_t.skinWeights,Ot=_t.morphTargets,Ft=_t.morphNormals;if(xt){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];g=kt[l.a];y=kt[l.b];E=kt[l.c];st[Y]=g.x;st[Y+1]=g.y;st[Y+2]=g.z;st[Y+3]=y.x;st[Y+4]=y.y;st[Y+5]=y.z;st[Y+6]=E.x;st[Y+7]=E.y;st[Y+8]=E.z;Y+=9}N.bindBuffer(N.ARRAY_BUFFER,t.__webglVertexBuffer);N.bufferData(N.ARRAY_BUFFER,st,r)}if(Mt){for(V=0,I=Ot.length;V<I;V++){it=0;for(s=0,a=At.length;s<a;s++){W=At[s];l=Ct[W];g=Ot[V].vertices[l.a];y=Ot[V].vertices[l.b];E=Ot[V].vertices[l.c];j=dt[V];j[it]=g.x;j[it+1]=g.y;j[it+2]=g.z;j[it+3]=y.x;j[it+4]=y.y;j[it+5]=y.z;j[it+6]=E.x;j[it+7]=E.y;j[it+8]=E.z;if(n.morphNormals){if(o){T=Ft[V].faceNormals[W];w=T;R=T}else{X=Ft[V].vertexNormals[W];T=X.a;w=X.b;R=X.c}G=mt[V];G[it]=T.x;G[it+1]=T.y;G[it+2]=T.z;G[it+3]=w.x;G[it+4]=w.y;G[it+5]=w.z;G[it+6]=R.x;G[it+7]=R.y;G[it+8]=R.z}it+=9}N.bindBuffer(N.ARRAY_BUFFER,t.__webglMorphTargetsBuffers[V]);N.bufferData(N.ARRAY_BUFFER,dt[V],r);if(n.morphNormals){N.bindBuffer(N.ARRAY_BUFFER,t.__webglMorphNormalsBuffers[V]);N.bufferData(N.ARRAY_BUFFER,mt[V],r)}}}if(Dt.length){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];k=Dt[l.a];A=Dt[l.b];C=Dt[l.c];pt[rt]=k.x;pt[rt+1]=k.y;pt[rt+2]=k.z;pt[rt+3]=k.w;pt[rt+4]=A.x;pt[rt+5]=A.y;pt[rt+6]=A.z;pt[rt+7]=A.w;pt[rt+8]=C.x;pt[rt+9]=C.y;pt[rt+10]=C.z;pt[rt+11]=C.w;L=zt[l.a];P=zt[l.b];z=zt[l.c];ct[rt]=L.x;ct[rt+1]=L.y;ct[rt+2]=L.z;ct[rt+3]=L.w;ct[rt+4]=P.x;ct[rt+5]=P.y;ct[rt+6]=P.z;ct[rt+7]=P.w;ct[rt+8]=z.x;ct[rt+9]=z.y;ct[rt+10]=z.z;ct[rt+11]=z.w;rt+=12}if(rt>0){N.bindBuffer(N.ARRAY_BUFFER,t.__webglSkinIndicesBuffer);N.bufferData(N.ARRAY_BUFFER,ct,r);N.bindBuffer(N.ARRAY_BUFFER,t.__webglSkinWeightsBuffer);N.bufferData(N.ARRAY_BUFFER,pt,r)}}if(Ht){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];c=l.vertexColors;p=l.color;if(c.length===3&&n.vertexColors===THREE.VertexColors){H=c[0];M=c[1];S=c[2]}else{H=p;M=p;S=p}ft[et]=H.r;ft[et+1]=H.g;ft[et+2]=H.b;ft[et+3]=M.r;ft[et+4]=M.g;ft[et+5]=M.b;ft[et+6]=S.r;ft[et+7]=S.g;ft[et+8]=S.b;et+=9}if(et>0){N.bindBuffer(N.ARRAY_BUFFER,t.__webglColorBuffer);N.bufferData(N.ARRAY_BUFFER,ft,r)}}if(Rt&&_t.hasTangents){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];d=l.vertexTangents;_=d[0];x=d[1];b=d[2];ht[$]=_.x;ht[$+1]=_.y;ht[$+2]=_.z;ht[$+3]=_.w;ht[$+4]=x.x;ht[$+5]=x.y;ht[$+6]=x.z;ht[$+7]=x.w;ht[$+8]=b.x;ht[$+9]=b.y;ht[$+10]=b.z;ht[$+11]=b.w;$+=12}N.bindBuffer(N.ARRAY_BUFFER,t.__webglTangentBuffer);N.bufferData(N.ARRAY_BUFFER,ht,r)}if(wt){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];h=l.vertexNormals;f=l.normal;if(h.length===3&&o===false){for(D=0;D<3;D++){F=h[D];lt[J]=F.x;lt[J+1]=F.y;lt[J+2]=F.z;J+=3}}else{for(D=0;D<3;D++){lt[J]=f.x;lt[J+1]=f.y;lt[J+2]=f.z;J+=3}}}N.bindBuffer(N.ARRAY_BUFFER,t.__webglNormalBuffer);N.bufferData(N.ARRAY_BUFFER,lt,r)}if(Tt&&Lt){for(s=0,a=At.length;s<a;s++){u=At[s];m=Lt[u];if(m===undefined)continue;for(D=0;D<3;D++){U=m[D];at[Z]=U.x;at[Z+1]=U.y;Z+=2}}if(Z>0){N.bindBuffer(N.ARRAY_BUFFER,t.__webglUVBuffer);N.bufferData(N.ARRAY_BUFFER,at,r)}}if(Tt&&Pt){for(s=0,a=At.length;s<a;s++){u=At[s];v=Pt[u];if(v===undefined)continue;for(D=0;D<3;D++){B=v[D];ut[K]=B.x;ut[K+1]=B.y;K+=2}}if(K>0){N.bindBuffer(N.ARRAY_BUFFER,t.__webglUV2Buffer);N.bufferData(N.ARRAY_BUFFER,ut,r)}}if(bt){for(s=0,a=At.length;s<a;s++){yt[Q]=q;yt[Q+1]=q+1;yt[Q+2]=q+2;Q+=3;Et[tt]=q;Et[tt+1]=q+1;Et[tt+2]=q;Et[tt+3]=q+2;Et[tt+4]=q+1;Et[tt+5]=q+2;tt+=6;q+=3}N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,t.__webglFaceBuffer);N.bufferData(N.ELEMENT_ARRAY_BUFFER,yt,r);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,t.__webglLineBuffer);N.bufferData(N.ELEMENT_ARRAY_BUFFER,Et,r)}if(vt){for(D=0,O=vt.length;D<O;D++){gt=vt[D];if(!gt.__original.needsUpdate)continue;nt=0;if(gt.size===1){if(gt.boundTo===undefined||gt.boundTo==="vertices"){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];gt.array[nt]=gt.value[l.a];gt.array[nt+1]=gt.value[l.b];gt.array[nt+2]=gt.value[l.c];nt+=3}}else if(gt.boundTo==="faces"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];gt.array[nt]=ot;gt.array[nt+1]=ot;gt.array[nt+2]=ot;nt+=3}}}else if(gt.size===2){if(gt.boundTo===undefined||gt.boundTo==="vertices"){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];g=gt.value[l.a];y=gt.value[l.b];E=gt.value[l.c];gt.array[nt]=g.x;gt.array[nt+1]=g.y;gt.array[nt+2]=y.x;gt.array[nt+3]=y.y;gt.array[nt+4]=E.x;gt.array[nt+5]=E.y;nt+=6}}else if(gt.boundTo==="faces"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];g=ot;y=ot;E=ot;gt.array[nt]=g.x;gt.array[nt+1]=g.y;gt.array[nt+2]=y.x;gt.array[nt+3]=y.y;gt.array[nt+4]=E.x;gt.array[nt+5]=E.y;nt+=6}}}else if(gt.size===3){var Ut;if(gt.type==="c"){Ut=["r","g","b"]}else{Ut=["x","y","z"]}if(gt.boundTo===undefined||gt.boundTo==="vertices"){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];g=gt.value[l.a];y=gt.value[l.b];E=gt.value[l.c];gt.array[nt]=g[Ut[0]];gt.array[nt+1]=g[Ut[1]];gt.array[nt+2]=g[Ut[2]];gt.array[nt+3]=y[Ut[0]];gt.array[nt+4]=y[Ut[1]];gt.array[nt+5]=y[Ut[2]];gt.array[nt+6]=E[Ut[0]];gt.array[nt+7]=E[Ut[1]];gt.array[nt+8]=E[Ut[2]];nt+=9}}else if(gt.boundTo==="faces"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];g=ot;y=ot;E=ot;gt.array[nt]=g[Ut[0]];gt.array[nt+1]=g[Ut[1]];gt.array[nt+2]=g[Ut[2]];gt.array[nt+3]=y[Ut[0]];gt.array[nt+4]=y[Ut[1]];gt.array[nt+5]=y[Ut[2]];gt.array[nt+6]=E[Ut[0]];gt.array[nt+7]=E[Ut[1]];gt.array[nt+8]=E[Ut[2]];nt+=9}}else if(gt.boundTo==="faceVertices"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];g=ot[0];y=ot[1];E=ot[2];gt.array[nt]=g[Ut[0]];gt.array[nt+1]=g[Ut[1]];gt.array[nt+2]=g[Ut[2]];gt.array[nt+3]=y[Ut[0]];gt.array[nt+4]=y[Ut[1]];gt.array[nt+5]=y[Ut[2]];gt.array[nt+6]=E[Ut[0]];gt.array[nt+7]=E[Ut[1]];gt.array[nt+8]=E[Ut[2]];nt+=9}}}else if(gt.size===4){if(gt.boundTo===undefined||gt.boundTo==="vertices"){for(s=0,a=At.length;s<a;s++){l=Ct[At[s]];g=gt.value[l.a];y=gt.value[l.b];E=gt.value[l.c];gt.array[nt]=g.x;gt.array[nt+1]=g.y;gt.array[nt+2]=g.z;gt.array[nt+3]=g.w;gt.array[nt+4]=y.x;gt.array[nt+5]=y.y;gt.array[nt+6]=y.z;gt.array[nt+7]=y.w;gt.array[nt+8]=E.x;gt.array[nt+9]=E.y;gt.array[nt+10]=E.z;gt.array[nt+11]=E.w;nt+=12}}else if(gt.boundTo==="faces"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];g=ot;y=ot;E=ot;gt.array[nt]=g.x;gt.array[nt+1]=g.y;gt.array[nt+2]=g.z;gt.array[nt+3]=g.w;gt.array[nt+4]=y.x;gt.array[nt+5]=y.y;gt.array[nt+6]=y.z;gt.array[nt+7]=y.w;gt.array[nt+8]=E.x;gt.array[nt+9]=E.y;gt.array[nt+10]=E.z;gt.array[nt+11]=E.w;nt+=12}}else if(gt.boundTo==="faceVertices"){for(s=0,a=At.length;s<a;s++){ot=gt.value[At[s]];g=ot[0];y=ot[1];E=ot[2];gt.array[nt]=g.x;gt.array[nt+1]=g.y;gt.array[nt+2]=g.z;gt.array[nt+3]=g.w;gt.array[nt+4]=y.x;gt.array[nt+5]=y.y;gt.array[nt+6]=y.z;gt.array[nt+7]=y.w;gt.array[nt+8]=E.x;gt.array[nt+9]=E.y;gt.array[nt+10]=E.z;gt.array[nt+11]=E.w;nt+=12}}}N.bindBuffer(N.ARRAY_BUFFER,gt.buffer);N.bufferData(N.ARRAY_BUFFER,gt.array,r)}}if(i){delete t.__inittedArrays;delete t.__colorArray;delete t.__normalArray;delete t.__tangentArray;delete t.__uvArray;delete t.__uv2Array;delete t.__faceArray;delete t.__vertexArray;delete t.__lineArray;delete t.__skinIndexArray;delete t.__skinWeightArray}}this.renderBufferImmediate=function(t,e,r){j.initAttributes();if(t.hasPositions&&!t.__webglVertexBuffer)t.__webglVertexBuffer=N.createBuffer();if(t.hasNormals&&!t.__webglNormalBuffer)t.__webglNormalBuffer=N.createBuffer();if(t.hasUvs&&!t.__webglUvBuffer)t.__webglUvBuffer=N.createBuffer();if(t.hasColors&&!t.__webglColorBuffer)t.__webglColorBuffer=N.createBuffer();if(t.hasPositions){N.bindBuffer(N.ARRAY_BUFFER,t.__webglVertexBuffer);N.bufferData(N.ARRAY_BUFFER,t.positionArray,N.DYNAMIC_DRAW);j.enableAttribute(e.attributes.position);N.vertexAttribPointer(e.attributes.position,3,N.FLOAT,false,0,0)}if(t.hasNormals){N.bindBuffer(N.ARRAY_BUFFER,t.__webglNormalBuffer);if(r instanceof THREE.MeshPhongMaterial===false&&r.shading===THREE.FlatShading){var i,n,o,s,a,u,l,h,f,c,p,d,m,v,g=t.count*3;for(v=0;v<g;v+=9){m=t.normalArray;s=m[v];l=m[v+1];c=m[v+2];a=m[v+3];h=m[v+4];p=m[v+5];u=m[v+6];f=m[v+7];d=m[v+8];i=(s+a+u)/3;n=(l+h+f)/3;o=(c+p+d)/3;m[v]=i;m[v+1]=n;m[v+2]=o;m[v+3]=i;m[v+4]=n;m[v+5]=o;m[v+6]=i;m[v+7]=n;m[v+8]=o}}N.bufferData(N.ARRAY_BUFFER,t.normalArray,N.DYNAMIC_DRAW);j.enableAttribute(e.attributes.normal);N.vertexAttribPointer(e.attributes.normal,3,N.FLOAT,false,0,0)}if(t.hasUvs&&r.map){N.bindBuffer(N.ARRAY_BUFFER,t.__webglUvBuffer);N.bufferData(N.ARRAY_BUFFER,t.uvArray,N.DYNAMIC_DRAW);j.enableAttribute(e.attributes.uv);N.vertexAttribPointer(e.attributes.uv,2,N.FLOAT,false,0,0)}if(t.hasColors&&r.vertexColors!==THREE.NoColors){N.bindBuffer(N.ARRAY_BUFFER,t.__webglColorBuffer);N.bufferData(N.ARRAY_BUFFER,t.colorArray,N.DYNAMIC_DRAW);j.enableAttribute(e.attributes.color);N.vertexAttribPointer(e.attributes.color,3,N.FLOAT,false,0,0)}j.disableUnusedAttributes();N.drawArrays(N.TRIANGLES,0,t.count);t.count=0};function Lt(t,e,r,i){var n=r.attributes;var o=e.attributes;var s=e.attributesKeys;for(var a=0,u=s.length;a<u;a++){var l=s[a];var h=o[l];if(h>=0){var f=n[l];if(f!==undefined){var c=f.itemSize;N.bindBuffer(N.ARRAY_BUFFER,f.buffer);j.enableAttribute(h);N.vertexAttribPointer(h,c,N.FLOAT,false,0,i*c*4)}else if(t.defaultAttributeValues!==undefined){if(t.defaultAttributeValues[l].length===2){N.vertexAttrib2fv(h,t.defaultAttributeValues[l])}else if(t.defaultAttributeValues[l].length===3){N.vertexAttrib3fv(h,t.defaultAttributeValues[l])}}}}j.disableUnusedAttributes()}this.renderBufferDirect=function(t,e,r,n,o,s){if(n.visible===false)return;Zt(s);var a=ie(t,e,r,n,s);var u=false,l=n.wireframe?1:0,h="direct_"+o.id+"_"+a.id+"_"+l;if(h!==H){H=h;u=true}if(u){j.initAttributes()}if(s instanceof THREE.Mesh){var f=n.wireframe===true?N.LINES:N.TRIANGLES;var c=o.attributes.index;if(c){var p,d;if(c.array instanceof Uint32Array&&G.get("OES_element_index_uint")){p=N.UNSIGNED_INT;d=4}else{p=N.UNSIGNED_SHORT;d=2}var m=o.offsets;if(m.length===0){if(u){Lt(n,a,o,0);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,c.array.length,p,0);x.info.render.calls++;x.info.render.vertices+=c.array.length;x.info.render.faces+=c.array.length/3}else{u=true;for(var v=0,g=m.length;v<g;v++){var y=m[v].index;if(u){Lt(n,a,o,y);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,m[v].count,p,m[v].start*d);x.info.render.calls++;x.info.render.vertices+=m[v].count;x.info.render.faces+=m[v].count/3}}}else{if(u){Lt(n,a,o,0)}var E=o.attributes["position"];N.drawArrays(f,0,E.array.length/E.itemSize);x.info.render.calls++;x.info.render.vertices+=E.array.length/E.itemSize;x.info.render.faces+=E.array.length/(3*E.itemSize)}}else if(s instanceof THREE.PointCloud){var f=N.POINTS;var c=o.attributes.index;if(c){var p,d;if(c.array instanceof Uint32Array&&G.get("OES_element_index_uint")){p=N.UNSIGNED_INT;d=4}else{p=N.UNSIGNED_SHORT;d=2}var m=o.offsets;if(m.length===0){if(u){Lt(n,a,o,0);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,c.array.length,p,0);x.info.render.calls++;x.info.render.points+=c.array.length}else{if(m.length>1)u=true;for(var v=0,g=m.length;v<g;v++){var y=m[v].index;if(u){Lt(n,a,o,y);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,m[v].count,p,m[v].start*d);x.info.render.calls++;x.info.render.points+=m[v].count}}}else{if(u){Lt(n,a,o,0)}var E=o.attributes.position;var m=o.offsets;if(m.length===0){N.drawArrays(f,0,E.array.length/3);x.info.render.calls++;x.info.render.points+=E.array.length/3}else{for(var v=0,g=m.length;v<g;v++){N.drawArrays(f,m[v].index,m[v].count);x.info.render.calls++;x.info.render.points+=m[v].count}}}}else if(s instanceof THREE.Line){var f=s.mode===THREE.LineStrip?N.LINE_STRIP:N.LINES;j.setLineWidth(n.linewidth*i);var c=o.attributes.index;if(c){var p,d;if(c.array instanceof Uint32Array){p=N.UNSIGNED_INT;d=4}else{p=N.UNSIGNED_SHORT;d=2}var m=o.offsets;if(m.length===0){if(u){Lt(n,a,o,0);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,c.array.length,p,0);x.info.render.calls++;x.info.render.vertices+=c.array.length}else{if(m.length>1)u=true;for(var v=0,g=m.length;v<g;v++){var y=m[v].index;if(u){Lt(n,a,o,y);N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,c.buffer)}N.drawElements(f,m[v].count,p,m[v].start*d);x.info.render.calls++;x.info.render.vertices+=m[v].count}}}else{if(u){Lt(n,a,o,0)}var E=o.attributes.position;var m=o.offsets;if(m.length===0){N.drawArrays(f,0,E.array.length/3);x.info.render.calls++;x.info.render.vertices+=E.array.length/3}else{for(var v=0,g=m.length;v<g;v++){N.drawArrays(f,m[v].index,m[v].count);x.info.render.calls++;x.info.render.vertices+=m[v].count}}}}};this.renderBuffer=function(t,e,r,n,o,s){if(n.visible===false)return;Zt(s);var a=ie(t,e,r,n,s);var u=a.attributes;var l=false,h=n.wireframe?1:0,f=o.id+"_"+a.id+"_"+h;if(f!==H){H=f;l=true}if(l){j.initAttributes()}if(!n.morphTargets&&u.position>=0){if(l){N.bindBuffer(N.ARRAY_BUFFER,o.__webglVertexBuffer);j.enableAttribute(u.position);N.vertexAttribPointer(u.position,3,N.FLOAT,false,0,0)}}else{if(s.morphTargetBase){Pt(n,o,s)}}if(l){if(o.__webglCustomAttributesList){for(var c=0,p=o.__webglCustomAttributesList.length;c<p;c++){var d=o.__webglCustomAttributesList[c];if(u[d.buffer.belongsToAttribute]>=0){N.bindBuffer(N.ARRAY_BUFFER,d.buffer);j.enableAttribute(u[d.buffer.belongsToAttribute]);N.vertexAttribPointer(u[d.buffer.belongsToAttribute],d.size,N.FLOAT,false,0,0)}}}if(u.color>=0){if(s.geometry.colors.length>0||s.geometry.faces.length>0){N.bindBuffer(N.ARRAY_BUFFER,o.__webglColorBuffer);j.enableAttribute(u.color);N.vertexAttribPointer(u.color,3,N.FLOAT,false,0,0)}else if(n.defaultAttributeValues!==undefined){N.vertexAttrib3fv(u.color,n.defaultAttributeValues.color)}}if(u.normal>=0){N.bindBuffer(N.ARRAY_BUFFER,o.__webglNormalBuffer);j.enableAttribute(u.normal);N.vertexAttribPointer(u.normal,3,N.FLOAT,false,0,0)}if(u.tangent>=0){N.bindBuffer(N.ARRAY_BUFFER,o.__webglTangentBuffer);j.enableAttribute(u.tangent);N.vertexAttribPointer(u.tangent,4,N.FLOAT,false,0,0)}if(u.uv>=0){if(s.geometry.faceVertexUvs[0]){N.bindBuffer(N.ARRAY_BUFFER,o.__webglUVBuffer);j.enableAttribute(u.uv);N.vertexAttribPointer(u.uv,2,N.FLOAT,false,0,0)}else if(n.defaultAttributeValues!==undefined){N.vertexAttrib2fv(u.uv,n.defaultAttributeValues.uv)}}if(u.uv2>=0){if(s.geometry.faceVertexUvs[1]){N.bindBuffer(N.ARRAY_BUFFER,o.__webglUV2Buffer);j.enableAttribute(u.uv2);N.vertexAttribPointer(u.uv2,2,N.FLOAT,false,0,0)}else if(n.defaultAttributeValues!==undefined){N.vertexAttrib2fv(u.uv2,n.defaultAttributeValues.uv2)}}if(n.skinning&&u.skinIndex>=0&&u.skinWeight>=0){N.bindBuffer(N.ARRAY_BUFFER,o.__webglSkinIndicesBuffer);j.enableAttribute(u.skinIndex);N.vertexAttribPointer(u.skinIndex,4,N.FLOAT,false,0,0);N.bindBuffer(N.ARRAY_BUFFER,o.__webglSkinWeightsBuffer);j.enableAttribute(u.skinWeight);N.vertexAttribPointer(u.skinWeight,4,N.FLOAT,false,0,0)}if(u.lineDistance>=0){N.bindBuffer(N.ARRAY_BUFFER,o.__webglLineDistanceBuffer);j.enableAttribute(u.lineDistance);N.vertexAttribPointer(u.lineDistance,1,N.FLOAT,false,0,0)}}j.disableUnusedAttributes();if(s instanceof THREE.Mesh){var m=o.__typeArray===Uint32Array?N.UNSIGNED_INT:N.UNSIGNED_SHORT;if(n.wireframe){j.setLineWidth(n.wireframeLinewidth*i);if(l)N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,o.__webglLineBuffer);N.drawElements(N.LINES,o.__webglLineCount,m,0)}else{if(l)N.bindBuffer(N.ELEMENT_ARRAY_BUFFER,o.__webglFaceBuffer);N.drawElements(N.TRIANGLES,o.__webglFaceCount,m,0)}x.info.render.calls++;x.info.render.vertices+=o.__webglFaceCount;x.info.render.faces+=o.__webglFaceCount/3}else if(s instanceof THREE.Line){var v=s.mode===THREE.LineStrip?N.LINE_STRIP:N.LINES;j.setLineWidth(n.linewidth*i);N.drawArrays(v,0,o.__webglLineCount);x.info.render.calls++}else if(s instanceof THREE.PointCloud){N.drawArrays(N.POINTS,0,o.__webglParticleCount);x.info.render.calls++;x.info.render.points+=o.__webglParticleCount}};function Pt(t,e,r){var i=t.program.attributes;if(r.morphTargetBase!==-1&&i.position>=0){N.bindBuffer(N.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[r.morphTargetBase]);j.enableAttribute(i.position);N.vertexAttribPointer(i.position,3,N.FLOAT,false,0,0)}else if(i.position>=0){N.bindBuffer(N.ARRAY_BUFFER,e.__webglVertexBuffer);j.enableAttribute(i.position);N.vertexAttribPointer(i.position,3,N.FLOAT,false,0,0)}if(r.morphTargetForcedOrder.length){var n=0;var o=r.morphTargetForcedOrder;var s=r.morphTargetInfluences;var a;while(n<t.numSupportedMorphTargets&&n<o.length){a=i["morphTarget"+n];if(a>=0){N.bindBuffer(N.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[o[n]]);j.enableAttribute(a);N.vertexAttribPointer(a,3,N.FLOAT,false,0,0)}a=i["morphNormal"+n];if(a>=0&&t.morphNormals){N.bindBuffer(N.ARRAY_BUFFER,e.__webglMorphNormalsBuffers[o[n]]);j.enableAttribute(a);N.vertexAttribPointer(a,3,N.FLOAT,false,0,0)}r.__webglMorphTargetInfluences[n]=s[o[n]];n++}}else{var u=[];var s=r.morphTargetInfluences;var l=r.geometry.morphTargets;if(s.length>l.length){console.warn("THREE.WebGLRenderer: Influences array is bigger than morphTargets array.");s.length=l.length}for(var h=0,f=s.length;h<f;h++){var c=s[h];u.push([c,h])}if(u.length>t.numSupportedMorphTargets){u.sort(Ot);u.length=t.numSupportedMorphTargets}else if(u.length>t.numSupportedMorphNormals){u.sort(Ot)}else if(u.length===0){u.push([0,0])}var a;for(var n=0,p=t.numSupportedMorphTargets;n<p;n++){if(u[n]){var d=u[n][1];a=i["morphTarget"+n];if(a>=0){N.bindBuffer(N.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[d]);j.enableAttribute(a);N.vertexAttribPointer(a,3,N.FLOAT,false,0,0)}a=i["morphNormal"+n];if(a>=0&&t.morphNormals){N.bindBuffer(N.ARRAY_BUFFER,e.__webglMorphNormalsBuffers[d]);j.enableAttribute(a);N.vertexAttribPointer(a,3,N.FLOAT,false,0,0)}r.__webglMorphTargetInfluences[n]=s[d]}else{r.__webglMorphTargetInfluences[n]=0}}}if(t.program.uniforms.morphTargetInfluences!==null){N.uniform1fv(t.program.uniforms.morphTargetInfluences,r.__webglMorphTargetInfluences)}}function zt(t,e){if(t.object.renderOrder!==e.object.renderOrder){return t.object.renderOrder-e.object.renderOrder}else if(t.material.id!==e.material.id){return t.material.id-e.material.id}else if(t.z!==e.z){return t.z-e.z}else{return t.id-e.id}}function Dt(t,e){if(t.object.renderOrder!==e.object.renderOrder){return t.object.renderOrder-e.object.renderOrder}if(t.z!==e.z){return e.z-t.z}else{return t.id-e.id}}function Ot(t,e){return e[0]-t[0]}this.render=function(t,e,r,i){if(e instanceof THREE.Camera===false){THREE.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");return}var n=t.fog;H="";R=-1;M=null;B=true;if(t.autoUpdate===true)t.updateMatrixWorld();if(e.parent===undefined)e.updateMatrixWorld();t.traverse(function(t){if(t instanceof THREE.SkinnedMesh){t.skeleton.update()}});e.matrixWorldInverse.getInverse(e.matrixWorld);O.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse);D.setFromMatrix(O);d.length=0;g.length=0;y.length=0;E.length=0;_.length=0;Ft(t);if(x.sortObjects===true){g.sort(zt);y.sort(Dt)}at.render(t,e);x.info.render.calls=0;x.info.render.vertices=0;x.info.render.faces=0;x.info.render.points=0;this.setRenderTarget(r);if(this.autoClear||i){this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil)}for(var o=0,s=v.length;o<s;o++){var a=v[o];var u=a.object;if(u.visible){ge(u,e);Vt(a)}}if(t.overrideMaterial){var l=t.overrideMaterial;re(l);Ut(g,e,d,n,l);Ut(y,e,d,n,l);Bt(v,"",e,d,n,l)}else{j.setBlending(THREE.NoBlending);Ut(g,e,d,n,null);Bt(v,"opaque",e,d,n,null);Ut(y,e,d,n,null);Bt(v,"transparent",e,d,n,null)}ut.render(t,e);lt.render(t,e,P,z);if(r&&r.generateMipmaps&&r.minFilter!==THREE.NearestFilter&&r.minFilter!==THREE.LinearFilter){He(r)}j.setDepthTest(true);j.setDepthWrite(true);j.setColorWrite(true)};function Ft(t){if(t.visible===false)return;if(t instanceof THREE.Scene||t instanceof THREE.Group){}else{It(t);if(t instanceof THREE.Light){d.push(t)}else if(t instanceof THREE.Sprite){E.push(t)}else if(t instanceof THREE.LensFlare){_.push(t)}else{var e=m[t.id];if(e&&(t.frustumCulled===false||D.intersectsObject(t)===true)){for(var r=0,i=e.length;r<i;r++){var n=e[r];Nt(n);n.render=true;if(x.sortObjects===true){F.setFromMatrixPosition(t.matrixWorld);F.applyProjection(O);n.z=F.z}}}}}for(var r=0,i=t.children.length;r<i;r++){Ft(t.children[r])}}function Ut(t,e,r,i,n){var o;for(var s=0,a=t.length;s<a;s++){var u=t[s];var l=u.object;var h=u.buffer;ge(l,e);if(n){o=n}else{o=u.material;if(!o)continue;re(o)}x.setMaterialFaces(o);if(h instanceof THREE.BufferGeometry){x.renderBufferDirect(e,r,i,o,h,l)}else{x.renderBuffer(e,r,i,o,h,l)}}}function Bt(t,e,r,i,n,o){var s;for(var a=0,u=t.length;a<u;a++){var l=t[a];var h=l.object;if(h.visible){if(o){s=o}else{s=l[e];if(!s)continue;re(s)}x.renderImmediateObject(r,i,n,s,h)}}}this.renderImmediateObject=function(t,e,r,i,n){var o=ie(t,e,r,i,n);H="";x.setMaterialFaces(i);if(n.immediateRenderCallback){n.immediateRenderCallback(o,N,D)}else{n.render(function(t){x.renderBufferImmediate(t,o,i)})}};function Vt(t){var e=t.object,r=e.material;if(r.transparent){t.transparent=r;t.opaque=null}else{t.opaque=r;t.transparent=null}}function Nt(t){var e=t.object;var r=t.buffer;var i=e.geometry;var n=e.material;if(n instanceof THREE.MeshFaceMaterial){var o=i instanceof THREE.BufferGeometry?0:r.materialIndex;n=n.materials[o];t.material=n;if(n.transparent){y.push(t)}else{g.push(t)}}else if(n){t.material=n;if(n.transparent){y.push(t)}else{g.push(t)}}}function It(t){if(t.__webglInit===undefined){t.__webglInit=true;t._modelViewMatrix=new THREE.Matrix4;t._normalMatrix=new THREE.Matrix3;t.addEventListener("removed",pt)}var e=t.geometry;if(e===undefined){}else if(e.__webglInit===undefined){e.__webglInit=true;e.addEventListener("dispose",dt);if(e instanceof THREE.BufferGeometry){x.info.memory.geometries++}else if(t instanceof THREE.Mesh){Xt(t,e)}else if(t instanceof THREE.Line){if(e.__webglVertexBuffer===undefined){ft(e);Rt(e,t);e.verticesNeedUpdate=true;e.colorsNeedUpdate=true;e.lineDistancesNeedUpdate=true}}else if(t instanceof THREE.PointCloud){if(e.__webglVertexBuffer===undefined){ht(e);wt(e,t);e.verticesNeedUpdate=true;e.colorsNeedUpdate=true}}}if(t.__webglActive===undefined){t.__webglActive=true;if(t instanceof THREE.Mesh){if(e instanceof THREE.BufferGeometry){qt(m,e,t)}else if(e instanceof THREE.Geometry){var r=jt[e.id];for(var i=0,n=r.length;i<n;i++){qt(m,r[i],t)}}}else if(t instanceof THREE.Line||t instanceof THREE.PointCloud){qt(m,e,t)}else if(t instanceof THREE.ImmediateRenderObject||t.immediateRenderCallback){Yt(v,t)}}}var jt={};var Gt=0;function Wt(t,e){var r=G.get("OES_element_index_uint")?4294967296:65535;var i,n={};var o=t.morphTargets.length;var s=t.morphNormals.length;var a;var u={};var l=[];for(var h=0,f=t.faces.length;h<f;h++){var c=t.faces[h];var p=e?c.materialIndex:0;if(!(p in n)){n[p]={hash:p,counter:0}}i=n[p].hash+"_"+n[p].counter;if(!(i in u)){a={id:Gt++,faces3:[],materialIndex:p,vertices:0,numMorphTargets:o,numMorphNormals:s};u[i]=a;l.push(a)}if(u[i].vertices+3>r){n[p].counter+=1;i=n[p].hash+"_"+n[p].counter;if(!(i in u)){a={id:Gt++,faces3:[],materialIndex:p,vertices:0,numMorphTargets:o,numMorphNormals:s};u[i]=a;l.push(a)}}u[i].faces3.push(h);u[i].vertices+=3}return l}function Xt(t,e){var r=t.material,i=false;if(jt[e.id]===undefined||e.groupsNeedUpdate===true){delete m[t.id];jt[e.id]=Wt(e,r instanceof THREE.MeshFaceMaterial);e.groupsNeedUpdate=false}var n=jt[e.id];for(var o=0,s=n.length;o<s;o++){var a=n[o];if(a.__webglVertexBuffer===undefined){ct(a);Ht(a,t);e.verticesNeedUpdate=true;e.morphTargetsNeedUpdate=true;e.elementsNeedUpdate=true;e.uvsNeedUpdate=true;e.normalsNeedUpdate=true;e.tangentsNeedUpdate=true;e.colorsNeedUpdate=true;i=true}else{i=false}if(i||t.__webglActive===undefined){qt(m,a,t)}}t.__webglActive=true}function qt(t,e,r){var i=r.id;t[i]=t[i]||[];t[i].push({id:i,buffer:e,object:r,material:null,z:0})}function Yt(t,e){t.push({id:null,object:e,opaque:null,transparent:null,z:0})}function Zt(t){var e=t.geometry;if(e instanceof THREE.BufferGeometry){var r=e.attributes;var i=e.attributesKeys;for(var n=0,o=i.length;n<o;n++){var s=i[n];var a=r[s];var u=s==="index"?N.ELEMENT_ARRAY_BUFFER:N.ARRAY_BUFFER;if(a.buffer===undefined){a.buffer=N.createBuffer();N.bindBuffer(u,a.buffer);N.bufferData(u,a.array,a instanceof THREE.DynamicBufferAttribute?N.DYNAMIC_DRAW:N.STATIC_DRAW);a.needsUpdate=false}else if(a.needsUpdate===true){N.bindBuffer(u,a.buffer);if(a.updateRange===undefined||a.updateRange.count===-1){N.bufferSubData(u,0,a.array)}else if(a.updateRange.count===0){console.error("THREE.WebGLRenderer.updateObject: using updateRange for THREE.DynamicBufferAttribute and marked as needsUpdate but count is 0, ensure you are using set methods or updating manually.")}else{N.bufferSubData(u,a.updateRange.offset*a.array.BYTES_PER_ELEMENT,a.array.subarray(a.updateRange.offset,a.updateRange.offset+a.updateRange.count));a.updateRange.count=0}a.needsUpdate=false}}}else if(t instanceof THREE.Mesh){if(e.groupsNeedUpdate===true){Xt(t,e)}var l=jt[e.id];for(var n=0,h=l.length;n<h;n++){var f=l[n];var c=Mt(t,f);var p=c.attributes&&Kt(c);if(e.verticesNeedUpdate||e.morphTargetsNeedUpdate||e.elementsNeedUpdate||e.uvsNeedUpdate||e.normalsNeedUpdate||e.colorsNeedUpdate||e.tangentsNeedUpdate||p){Ct(f,t,N.DYNAMIC_DRAW,!e.dynamic,c)}}e.verticesNeedUpdate=false;e.morphTargetsNeedUpdate=false;e.elementsNeedUpdate=false;e.uvsNeedUpdate=false;e.normalsNeedUpdate=false;e.colorsNeedUpdate=false;e.tangentsNeedUpdate=false;c.attributes&&Qt(c)}else if(t instanceof THREE.Line){var c=Mt(t,e);var p=c.attributes&&Kt(c);if(e.verticesNeedUpdate||e.colorsNeedUpdate||e.lineDistancesNeedUpdate||p){At(e,N.DYNAMIC_DRAW)}e.verticesNeedUpdate=false;e.colorsNeedUpdate=false;e.lineDistancesNeedUpdate=false;c.attributes&&Qt(c)}else if(t instanceof THREE.PointCloud){var c=Mt(t,e);var p=c.attributes&&Kt(c);if(e.verticesNeedUpdate||e.colorsNeedUpdate||p){kt(e,N.DYNAMIC_DRAW,t)}e.verticesNeedUpdate=false;e.colorsNeedUpdate=false;c.attributes&&Qt(c)}}function Kt(t){for(var e in t.attributes){if(t.attributes[e].needsUpdate)return true}return false}function Qt(t){for(var e in t.attributes){t.attributes[e].needsUpdate=false}}function Jt(t){if(t instanceof THREE.Mesh||t instanceof THREE.PointCloud||t instanceof THREE.Line){delete m[t.id]}else if(t instanceof THREE.ImmediateRenderObject||t.immediateRenderCallback){$t(v,t)}delete t.__webglInit;delete t._modelViewMatrix;delete t._normalMatrix;delete t.__webglActive}function $t(t,e){for(var r=t.length-1;r>=0;r--){if(t[r].object===e){t.splice(r,1)}}}var te={MeshDepthMaterial:"depth",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointCloudMaterial:"particle_basic"};function ee(t,e,r,i){t.addEventListener("dispose",gt);var o=te[t.type];if(o){var s=THREE.ShaderLib[o];t.__webglShader={uniforms:THREE.UniformsUtils.clone(s.uniforms),vertexShader:s.vertexShader,fragmentShader:s.fragmentShader}}else{t.__webglShader={uniforms:t.uniforms,vertexShader:t.vertexShader,fragmentShader:t.fragmentShader}}var a=Ae(e);var u=Ce(e);var l=ke(i);var h={precision:n,supportsVertexTextures:J,map:!!t.map,envMap:!!t.envMap,envMapMode:t.envMap&&t.envMap.mapping,lightMap:!!t.lightMap,bumpMap:!!t.bumpMap,normalMap:!!t.normalMap,specularMap:!!t.specularMap,alphaMap:!!t.alphaMap,combine:t.combine,vertexColors:t.vertexColors,fog:r,useFog:t.fog,fogExp:r instanceof THREE.FogExp2,flatShading:t.shading===THREE.FlatShading,sizeAttenuation:t.sizeAttenuation,logarithmicDepthBuffer:f,skinning:t.skinning,maxBones:l,useVertexTexture:$&&i&&i.skeleton&&i.skeleton.useVertexTexture,morphTargets:t.morphTargets,morphNormals:t.morphNormals,maxMorphTargets:x.maxMorphTargets,maxMorphNormals:x.maxMorphNormals,maxDirLights:a.directional,maxPointLights:a.point,maxSpotLights:a.spot,maxHemiLights:a.hemi,maxShadows:u,shadowMapEnabled:x.shadowMapEnabled&&i.receiveShadow&&u>0,shadowMapType:x.shadowMapType,shadowMapDebug:x.shadowMapDebug,shadowMapCascade:x.shadowMapCascade,alphaTest:t.alphaTest,metal:t.metal,wrapAround:t.wrapAround,doubleSided:t.side===THREE.DoubleSide,flipSided:t.side===THREE.BackSide};var c=[];if(o){c.push(o)}else{c.push(t.fragmentShader);c.push(t.vertexShader)}if(t.defines!==undefined){for(var p in t.defines){c.push(p);c.push(t.defines[p])}}for(var p in h){c.push(p);c.push(h[p])}var d=c.join();var m;for(var v=0,g=b.length;v<g;v++){var y=b[v];if(y.code===d){m=y;m.usedTimes++;break}}if(m===undefined){m=new THREE.WebGLProgram(x,d,t,h);b.push(m);x.info.memory.programs=b.length}t.program=m;var E=m.attributes;if(t.morphTargets){t.numSupportedMorphTargets=0;var _,T="morphTarget";for(var w=0;w<x.maxMorphTargets;w++){_=T+w;if(E[_]>=0){t.numSupportedMorphTargets++}}}if(t.morphNormals){t.numSupportedMorphNormals=0;var _,T="morphNormal";for(w=0;w<x.maxMorphNormals;w++){_=T+w;if(E[_]>=0){t.numSupportedMorphNormals++}}}t.uniformsList=[];for(var R in t.__webglShader.uniforms){var H=t.program.uniforms[R];if(H){t.uniformsList.push([t.__webglShader.uniforms[R],H])}}}function re(t){if(t.transparent===true){j.setBlending(t.blending,t.blendEquation,t.blendSrc,t.blendDst,t.blendEquationAlpha,t.blendSrcAlpha,t.blendDstAlpha)}else{j.setBlending(THREE.NoBlending)}j.setDepthTest(t.depthTest);j.setDepthWrite(t.depthWrite);j.setColorWrite(t.colorWrite);j.setPolygonOffset(t.polygonOffset,t.polygonOffsetFactor,t.polygonOffsetUnits)}function ie(t,e,r,i,n){S=0;if(i.needsUpdate){if(i.program)bt(i);ee(i,e,r,n);i.needsUpdate=false}if(i.morphTargets){if(!n.__webglMorphTargetInfluences){n.__webglMorphTargetInfluences=new Float32Array(x.maxMorphTargets)}}var o=false;var s=false;var a=false;var u=i.program,l=u.uniforms,h=i.__webglShader.uniforms;if(u.id!==T){N.useProgram(u.program);T=u.id;o=true;s=true;a=true}if(i.id!==R){if(R===-1)a=true;R=i.id;s=true}if(o||t!==M){N.uniformMatrix4fv(l.projectionMatrix,false,t.projectionMatrix.elements);if(f){N.uniform1f(l.logDepthBufFC,2/(Math.log(t.far+1)/Math.LN2))}if(t!==M)M=t;if(i instanceof THREE.ShaderMaterial||i instanceof THREE.MeshPhongMaterial||i.envMap){if(l.cameraPosition!==null){F.setFromMatrixPosition(t.matrixWorld);N.uniform3f(l.cameraPosition,F.x,F.y,F.z)}}if(i instanceof THREE.MeshPhongMaterial||i instanceof THREE.MeshLambertMaterial||i instanceof THREE.MeshBasicMaterial||i instanceof THREE.ShaderMaterial||i.skinning){if(l.viewMatrix!==null){N.uniformMatrix4fv(l.viewMatrix,false,t.matrixWorldInverse.elements)}}}if(i.skinning){if(n.bindMatrix&&l.bindMatrix!==null){N.uniformMatrix4fv(l.bindMatrix,false,n.bindMatrix.elements)}if(n.bindMatrixInverse&&l.bindMatrixInverse!==null){N.uniformMatrix4fv(l.bindMatrixInverse,false,n.bindMatrixInverse.elements)}if($&&n.skeleton&&n.skeleton.useVertexTexture){if(l.boneTexture!==null){var c=me();N.uniform1i(l.boneTexture,c);x.setTexture(n.skeleton.boneTexture,c)}if(l.boneTextureWidth!==null){N.uniform1i(l.boneTextureWidth,n.skeleton.boneTextureWidth)}if(l.boneTextureHeight!==null){N.uniform1i(l.boneTextureHeight,n.skeleton.boneTextureHeight)}}else if(n.skeleton&&n.skeleton.boneMatrices){if(l.boneGlobalMatrices!==null){N.uniformMatrix4fv(l.boneGlobalMatrices,false,n.skeleton.boneMatrices)}}}if(s){if(r&&i.fog){ue(h,r)}if(i instanceof THREE.MeshPhongMaterial||i instanceof THREE.MeshLambertMaterial||i.lights){if(B){a=true;Ee(e);B=false}if(a){fe(h,V);ce(h,true)}else{ce(h,false)}}if(i instanceof THREE.MeshBasicMaterial||i instanceof THREE.MeshLambertMaterial||i instanceof THREE.MeshPhongMaterial){ne(h,i)}if(i instanceof THREE.LineBasicMaterial){oe(h,i)}else if(i instanceof THREE.LineDashedMaterial){oe(h,i);se(h,i)}else if(i instanceof THREE.PointCloudMaterial){ae(h,i)}else if(i instanceof THREE.MeshPhongMaterial){le(h,i)}else if(i instanceof THREE.MeshLambertMaterial){he(h,i)}else if(i instanceof THREE.MeshDepthMaterial){h.mNear.value=t.near;h.mFar.value=t.far;h.opacity.value=i.opacity}else if(i instanceof THREE.MeshNormalMaterial){h.opacity.value=i.opacity}if(n.receiveShadow&&!i._shadowPass){pe(h,e)}ve(i.uniformsList)}de(l,n);if(l.modelMatrix!==null){N.uniformMatrix4fv(l.modelMatrix,false,n.matrixWorld.elements)}return u}function ne(t,e){t.opacity.value=e.opacity;t.diffuse.value=e.color;t.map.value=e.map;t.lightMap.value=e.lightMap;t.specularMap.value=e.specularMap;t.alphaMap.value=e.alphaMap;if(e.bumpMap){t.bumpMap.value=e.bumpMap;t.bumpScale.value=e.bumpScale}if(e.normalMap){t.normalMap.value=e.normalMap;t.normalScale.value.copy(e.normalScale)}var r;if(e.map){r=e.map}else if(e.specularMap){r=e.specularMap}else if(e.normalMap){r=e.normalMap}else if(e.bumpMap){r=e.bumpMap}else if(e.alphaMap){r=e.alphaMap}if(r!==undefined){var i=r.offset;var n=r.repeat;t.offsetRepeat.value.set(i.x,i.y,n.x,n.y)}t.envMap.value=e.envMap;t.flipEnvMap.value=e.envMap instanceof THREE.WebGLRenderTargetCube?1:-1;t.reflectivity.value=e.reflectivity;t.refractionRatio.value=e.refractionRatio}function oe(t,e){t.diffuse.value=e.color;t.opacity.value=e.opacity}function se(t,e){t.dashSize.value=e.dashSize;t.totalSize.value=e.dashSize+e.gapSize;t.scale.value=e.scale}function ae(t,r){t.psColor.value=r.color;t.opacity.value=r.opacity;t.size.value=r.size;t.scale.value=e.height/2;t.map.value=r.map;if(r.map!==null){var i=r.map.offset;var n=r.map.repeat;t.offsetRepeat.value.set(i.x,i.y,n.x,n.y)}}function ue(t,e){t.fogColor.value=e.color;if(e instanceof THREE.Fog){t.fogNear.value=e.near;t.fogFar.value=e.far}else if(e instanceof THREE.FogExp2){t.fogDensity.value=e.density}}function le(t,e){t.shininess.value=e.shininess;t.emissive.value=e.emissive;t.specular.value=e.specular;if(e.wrapAround){t.wrapRGB.value.copy(e.wrapRGB)}}function he(t,e){t.emissive.value=e.emissive;if(e.wrapAround){t.wrapRGB.value.copy(e.wrapRGB)}}function fe(t,e){t.ambientLightColor.value=e.ambient;t.directionalLightColor.value=e.directional.colors;t.directionalLightDirection.value=e.directional.positions;t.pointLightColor.value=e.point.colors;t.pointLightPosition.value=e.point.positions;t.pointLightDistance.value=e.point.distances;t.pointLightDecay.value=e.point.decays;t.spotLightColor.value=e.spot.colors;t.spotLightPosition.value=e.spot.positions;t.spotLightDistance.value=e.spot.distances;t.spotLightDirection.value=e.spot.directions;t.spotLightAngleCos.value=e.spot.anglesCos;t.spotLightExponent.value=e.spot.exponents;t.spotLightDecay.value=e.spot.decays;t.hemisphereLightSkyColor.value=e.hemi.skyColors;t.hemisphereLightGroundColor.value=e.hemi.groundColors;t.hemisphereLightDirection.value=e.hemi.positions}function ce(t,e){t.ambientLightColor.needsUpdate=e;t.directionalLightColor.needsUpdate=e;t.directionalLightDirection.needsUpdate=e;t.pointLightColor.needsUpdate=e;t.pointLightPosition.needsUpdate=e;t.pointLightDistance.needsUpdate=e;t.pointLightDecay.needsUpdate=e;t.spotLightColor.needsUpdate=e;t.spotLightPosition.needsUpdate=e;t.spotLightDistance.needsUpdate=e;t.spotLightDirection.needsUpdate=e;t.spotLightAngleCos.needsUpdate=e;t.spotLightExponent.needsUpdate=e;t.spotLightDecay.needsUpdate=e;t.hemisphereLightSkyColor.needsUpdate=e;t.hemisphereLightGroundColor.needsUpdate=e;t.hemisphereLightDirection.needsUpdate=e}function pe(t,e){if(t.shadowMatrix){var r=0;for(var i=0,n=e.length;i<n;i++){var o=e[i];if(!o.castShadow)continue;if(o instanceof THREE.SpotLight||o instanceof THREE.DirectionalLight&&!o.shadowCascade){t.shadowMap.value[r]=o.shadowMap;t.shadowMapSize.value[r]=o.shadowMapSize;t.shadowMatrix.value[r]=o.shadowMatrix;t.shadowDarkness.value[r]=o.shadowDarkness;t.shadowBias.value[r]=o.shadowBias;r++}}}}function de(t,e){N.uniformMatrix4fv(t.modelViewMatrix,false,e._modelViewMatrix.elements);if(t.normalMatrix){N.uniformMatrix3fv(t.normalMatrix,false,e._normalMatrix.elements)}}function me(){var t=S;if(t>=Y){THREE.warn("WebGLRenderer: trying to use "+t+" texture units while this GPU supports only "+Y)}S+=1;return t}function ve(t){var e,r,i;for(var n=0,o=t.length;n<o;n++){var s=t[n][0];if(s.needsUpdate===false)continue;var a=s.type;var u=s.value;var l=t[n][1];switch(a){case"1i":N.uniform1i(l,u);break;case"1f":N.uniform1f(l,u);break;case"2f":N.uniform2f(l,u[0],u[1]);break;case"3f":N.uniform3f(l,u[0],u[1],u[2]);break;case"4f":N.uniform4f(l,u[0],u[1],u[2],u[3]);break;case"1iv":N.uniform1iv(l,u);break;case"3iv":N.uniform3iv(l,u);break;case"1fv":N.uniform1fv(l,u);break;case"2fv":N.uniform2fv(l,u);break;case"3fv":N.uniform3fv(l,u);break;case"4fv":N.uniform4fv(l,u);break;case"Matrix3fv":N.uniformMatrix3fv(l,false,u);break;case"Matrix4fv":N.uniformMatrix4fv(l,false,u);break;case"i":N.uniform1i(l,u);break;case"f":N.uniform1f(l,u);break;case"v2":N.uniform2f(l,u.x,u.y);break;case"v3":N.uniform3f(l,u.x,u.y,u.z);break;case"v4":N.uniform4f(l,u.x,u.y,u.z,u.w);break;case"c":N.uniform3f(l,u.r,u.g,u.b);break;case"iv1":N.uniform1iv(l,u);break;case"iv":N.uniform3iv(l,u);break;case"fv1":N.uniform1fv(l,u);break;case"fv":N.uniform3fv(l,u);break;case"v2v":if(s._array===undefined){s._array=new Float32Array(2*u.length)}for(var h=0,f=u.length;h<f;h++){i=h*2;s._array[i]=u[h].x;s._array[i+1]=u[h].y}N.uniform2fv(l,s._array);break;case"v3v":if(s._array===undefined){s._array=new Float32Array(3*u.length)}for(var h=0,f=u.length;h<f;h++){i=h*3;s._array[i]=u[h].x;s._array[i+1]=u[h].y;s._array[i+2]=u[h].z}N.uniform3fv(l,s._array);break;case"v4v":if(s._array===undefined){s._array=new Float32Array(4*u.length)}for(var h=0,f=u.length;h<f;h++){i=h*4;s._array[i]=u[h].x;s._array[i+1]=u[h].y;s._array[i+2]=u[h].z;s._array[i+3]=u[h].w}N.uniform4fv(l,s._array);break;case"m3":N.uniformMatrix3fv(l,false,u.elements);break;case"m3v":if(s._array===undefined){s._array=new Float32Array(9*u.length)}for(var h=0,f=u.length;h<f;h++){u[h].flattenToArrayOffset(s._array,h*9)}N.uniformMatrix3fv(l,false,s._array);break;case"m4":N.uniformMatrix4fv(l,false,u.elements);break;case"m4v":if(s._array===undefined){s._array=new Float32Array(16*u.length)}for(var h=0,f=u.length;h<f;h++){u[h].flattenToArrayOffset(s._array,h*16)}N.uniformMatrix4fv(l,false,s._array);break;case"t":e=u;r=me();N.uniform1i(l,r);if(!e)continue;if(e instanceof THREE.CubeTexture||e.image instanceof Array&&e.image.length===6){be(e,r)}else if(e instanceof THREE.WebGLRenderTargetCube){Te(e,r)}else{x.setTexture(e,r)}break;case"tv":if(s._array===undefined){s._array=[]}for(var h=0,f=s.value.length;h<f;h++){s._array[h]=me()}N.uniform1iv(l,s._array);for(var h=0,f=s.value.length;h<f;h++){e=s.value[h];r=s._array[h];if(!e)continue;x.setTexture(e,r)}break;default:THREE.warn("THREE.WebGLRenderer: Unknown uniform type: "+a)}}}function ge(t,e){t._modelViewMatrix.multiplyMatrices(e.matrixWorldInverse,t.matrixWorld);t._normalMatrix.getNormalMatrix(t._modelViewMatrix)}function ye(t,e,r,i){t[e]=r.r*i;t[e+1]=r.g*i;t[e+2]=r.b*i}function Ee(t){var e,r,i,n=0,o=0,s=0,a,u,l,h,f,c=V,p=c.directional.colors,d=c.directional.positions,m=c.point.colors,v=c.point.positions,g=c.point.distances,y=c.point.decays,E=c.spot.colors,_=c.spot.positions,x=c.spot.distances,b=c.spot.directions,T=c.spot.anglesCos,w=c.spot.exponents,R=c.spot.decays,H=c.hemi.skyColors,M=c.hemi.groundColors,S=c.hemi.positions,k=0,A=0,C=0,L=0,P=0,z=0,D=0,O=0,B=0,N=0,I=0,j=0;for(e=0,r=t.length;e<r;e++){i=t[e];if(i.onlyShadow)continue;a=i.color;h=i.intensity;f=i.distance;if(i instanceof THREE.AmbientLight){if(!i.visible)continue;n+=a.r;o+=a.g;s+=a.b}else if(i instanceof THREE.DirectionalLight){P+=1;if(!i.visible)continue;U.setFromMatrixPosition(i.matrixWorld);F.setFromMatrixPosition(i.target.matrixWorld);U.sub(F);U.normalize();B=k*3;d[B]=U.x;d[B+1]=U.y;d[B+2]=U.z;ye(p,B,a,h);k+=1}else if(i instanceof THREE.PointLight){z+=1;if(!i.visible)continue;N=A*3;ye(m,N,a,h);F.setFromMatrixPosition(i.matrixWorld);v[N]=F.x;v[N+1]=F.y;v[N+2]=F.z;g[A]=f;y[A]=i.distance===0?0:i.decay;A+=1}else if(i instanceof THREE.SpotLight){D+=1;if(!i.visible)continue;I=C*3;ye(E,I,a,h);U.setFromMatrixPosition(i.matrixWorld);_[I]=U.x;_[I+1]=U.y;_[I+2]=U.z;x[C]=f;F.setFromMatrixPosition(i.target.matrixWorld);U.sub(F);U.normalize();b[I]=U.x;b[I+1]=U.y;b[I+2]=U.z;T[C]=Math.cos(i.angle);w[C]=i.exponent;R[C]=i.distance===0?0:i.decay;C+=1}else if(i instanceof THREE.HemisphereLight){O+=1;if(!i.visible)continue;U.setFromMatrixPosition(i.matrixWorld);U.normalize();j=L*3;S[j]=U.x;S[j+1]=U.y;S[j+2]=U.z;u=i.color;l=i.groundColor;ye(H,j,u,h);ye(M,j,l,h);L+=1}}for(e=k*3,r=Math.max(p.length,P*3);e<r;e++)p[e]=0;for(e=A*3,r=Math.max(m.length,z*3);e<r;e++)m[e]=0;for(e=C*3,r=Math.max(E.length,D*3);e<r;e++)E[e]=0;for(e=L*3,r=Math.max(H.length,O*3);e<r;e++)H[e]=0;for(e=L*3,r=Math.max(M.length,O*3);e<r;e++)M[e]=0;c.directional.length=k;c.point.length=A;c.spot.length=C;c.hemi.length=L;c.ambient[0]=n;c.ambient[1]=o;c.ambient[2]=s}this.setFaceCulling=function(t,e){if(t===THREE.CullFaceNone){N.disable(N.CULL_FACE)}else{if(e===THREE.FrontFaceDirectionCW){N.frontFace(N.CW)}else{N.frontFace(N.CCW)}if(t===THREE.CullFaceBack){N.cullFace(N.BACK)}else if(t===THREE.CullFaceFront){N.cullFace(N.FRONT)}else{N.cullFace(N.FRONT_AND_BACK)}N.enable(N.CULL_FACE)}};this.setMaterialFaces=function(t){j.setDoubleSided(t.side===THREE.DoubleSide);j.setFlipSided(t.side===THREE.BackSide)};function _e(t,e,r){var i;if(r){N.texParameteri(t,N.TEXTURE_WRAP_S,Se(e.wrapS));N.texParameteri(t,N.TEXTURE_WRAP_T,Se(e.wrapT));N.texParameteri(t,N.TEXTURE_MAG_FILTER,Se(e.magFilter));N.texParameteri(t,N.TEXTURE_MIN_FILTER,Se(e.minFilter))}else{N.texParameteri(t,N.TEXTURE_WRAP_S,N.CLAMP_TO_EDGE);N.texParameteri(t,N.TEXTURE_WRAP_T,N.CLAMP_TO_EDGE);if(e.wrapS!==THREE.ClampToEdgeWrapping||e.wrapT!==THREE.ClampToEdgeWrapping){THREE.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping. ( "+e.sourceFile+" )")}N.texParameteri(t,N.TEXTURE_MAG_FILTER,Me(e.magFilter));N.texParameteri(t,N.TEXTURE_MIN_FILTER,Me(e.minFilter));if(e.minFilter!==THREE.NearestFilter&&e.minFilter!==THREE.LinearFilter){THREE.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter. ( "+e.sourceFile+" )")}}i=G.get("EXT_texture_filter_anisotropic");if(i&&e.type!==THREE.FloatType&&e.type!==THREE.HalfFloatType){if(e.anisotropy>1||e.__currentAnisotropy){N.texParameterf(t,i.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(e.anisotropy,x.getMaxAnisotropy()));e.__currentAnisotropy=e.anisotropy}}}this.uploadTexture=function(t){if(t.__webglInit===undefined){t.__webglInit=true;t.addEventListener("dispose",mt);t.__webglTexture=N.createTexture();x.info.memory.textures++}N.bindTexture(N.TEXTURE_2D,t.__webglTexture);N.pixelStorei(N.UNPACK_FLIP_Y_WEBGL,t.flipY);N.pixelStorei(N.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.premultiplyAlpha);N.pixelStorei(N.UNPACK_ALIGNMENT,t.unpackAlignment);t.image=xe(t.image,K);var e=t.image,r=THREE.Math.isPowerOfTwo(e.width)&&THREE.Math.isPowerOfTwo(e.height),i=Se(t.format),n=Se(t.type);_e(N.TEXTURE_2D,t,r);var o,s=t.mipmaps;if(t instanceof THREE.DataTexture){if(s.length>0&&r){for(var a=0,u=s.length;a<u;a++){o=s[a];N.texImage2D(N.TEXTURE_2D,a,i,o.width,o.height,0,i,n,o.data)}t.generateMipmaps=false}else{N.texImage2D(N.TEXTURE_2D,0,i,e.width,e.height,0,i,n,e.data)}}else if(t instanceof THREE.CompressedTexture){for(var a=0,u=s.length;a<u;a++){o=s[a];if(t.format!==THREE.RGBAFormat&&t.format!==THREE.RGBFormat){if(nt().indexOf(i)>-1){N.compressedTexImage2D(N.TEXTURE_2D,a,i,o.width,o.height,0,o.data)}else{THREE.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()")}}else{N.texImage2D(N.TEXTURE_2D,a,i,o.width,o.height,0,i,n,o.data)}}}else{if(s.length>0&&r){for(var a=0,u=s.length;a<u;a++){o=s[a];N.texImage2D(N.TEXTURE_2D,a,i,i,n,o)}t.generateMipmaps=false}else{N.texImage2D(N.TEXTURE_2D,0,i,i,n,t.image)}}if(t.generateMipmaps&&r)N.generateMipmap(N.TEXTURE_2D);t.needsUpdate=false;if(t.onUpdate)t.onUpdate()};this.setTexture=function(t,e){N.activeTexture(N.TEXTURE0+e);if(t.needsUpdate){x.uploadTexture(t)}else{N.bindTexture(N.TEXTURE_2D,t.__webglTexture)}};function xe(t,e){if(t.width>e||t.height>e){var r=e/Math.max(t.width,t.height);var i=document.createElement("canvas");i.width=Math.floor(t.width*r);i.height=Math.floor(t.height*r);var n=i.getContext("2d");n.drawImage(t,0,0,t.width,t.height,0,0,i.width,i.height);THREE.warn("THREE.WebGLRenderer: image is too big ("+t.width+"x"+t.height+"). Resized to "+i.width+"x"+i.height,t);return i}return t}function be(t,e){if(t.image.length===6){if(t.needsUpdate){if(!t.image.__webglTextureCube){t.addEventListener("dispose",mt);t.image.__webglTextureCube=N.createTexture();x.info.memory.textures++}N.activeTexture(N.TEXTURE0+e);N.bindTexture(N.TEXTURE_CUBE_MAP,t.image.__webglTextureCube);N.pixelStorei(N.UNPACK_FLIP_Y_WEBGL,t.flipY);var r=t instanceof THREE.CompressedTexture;var i=t.image[0]instanceof THREE.DataTexture;var n=[];for(var o=0;o<6;o++){if(x.autoScaleCubemaps&&!r&&!i){n[o]=xe(t.image[o],Q)}else{n[o]=i?t.image[o].image:t.image[o]}}var s=n[0],a=THREE.Math.isPowerOfTwo(s.width)&&THREE.Math.isPowerOfTwo(s.height),u=Se(t.format),l=Se(t.type);_e(N.TEXTURE_CUBE_MAP,t,a);for(var o=0;o<6;o++){if(!r){if(i){N.texImage2D(N.TEXTURE_CUBE_MAP_POSITIVE_X+o,0,u,n[o].width,n[o].height,0,u,l,n[o].data)}else{N.texImage2D(N.TEXTURE_CUBE_MAP_POSITIVE_X+o,0,u,u,l,n[o])}}else{var h,f=n[o].mipmaps;for(var c=0,p=f.length;c<p;c++){h=f[c];if(t.format!==THREE.RGBAFormat&&t.format!==THREE.RGBFormat){if(nt().indexOf(u)>-1){N.compressedTexImage2D(N.TEXTURE_CUBE_MAP_POSITIVE_X+o,c,u,h.width,h.height,0,h.data)}else{THREE.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setCubeTexture()")}}else{N.texImage2D(N.TEXTURE_CUBE_MAP_POSITIVE_X+o,c,u,h.width,h.height,0,u,l,h.data)}}}}if(t.generateMipmaps&&a){N.generateMipmap(N.TEXTURE_CUBE_MAP)}t.needsUpdate=false;if(t.onUpdate)t.onUpdate()}else{N.activeTexture(N.TEXTURE0+e);N.bindTexture(N.TEXTURE_CUBE_MAP,t.image.__webglTextureCube)}}}function Te(t,e){N.activeTexture(N.TEXTURE0+e);N.bindTexture(N.TEXTURE_CUBE_MAP,t.__webglTexture)}function we(t,e,r){N.bindFramebuffer(N.FRAMEBUFFER,t);N.framebufferTexture2D(N.FRAMEBUFFER,N.COLOR_ATTACHMENT0,r,e.__webglTexture,0)}function Re(t,e){N.bindRenderbuffer(N.RENDERBUFFER,t);if(e.depthBuffer&&!e.stencilBuffer){N.renderbufferStorage(N.RENDERBUFFER,N.DEPTH_COMPONENT16,e.width,e.height);N.framebufferRenderbuffer(N.FRAMEBUFFER,N.DEPTH_ATTACHMENT,N.RENDERBUFFER,t)}else if(e.depthBuffer&&e.stencilBuffer){N.renderbufferStorage(N.RENDERBUFFER,N.DEPTH_STENCIL,e.width,e.height);N.framebufferRenderbuffer(N.FRAMEBUFFER,N.DEPTH_STENCIL_ATTACHMENT,N.RENDERBUFFER,t)}else{N.renderbufferStorage(N.RENDERBUFFER,N.RGBA4,e.width,e.height)}}this.setRenderTarget=function(t){var e=t instanceof THREE.WebGLRenderTargetCube;if(t&&t.__webglFramebuffer===undefined){if(t.depthBuffer===undefined)t.depthBuffer=true;if(t.stencilBuffer===undefined)t.stencilBuffer=true;t.addEventListener("dispose",vt);t.__webglTexture=N.createTexture();x.info.memory.textures++;var r=THREE.Math.isPowerOfTwo(t.width)&&THREE.Math.isPowerOfTwo(t.height),i=Se(t.format),n=Se(t.type);if(e){t.__webglFramebuffer=[];t.__webglRenderbuffer=[];N.bindTexture(N.TEXTURE_CUBE_MAP,t.__webglTexture);_e(N.TEXTURE_CUBE_MAP,t,r);for(var o=0;o<6;o++){t.__webglFramebuffer[o]=N.createFramebuffer();t.__webglRenderbuffer[o]=N.createRenderbuffer();N.texImage2D(N.TEXTURE_CUBE_MAP_POSITIVE_X+o,0,i,t.width,t.height,0,i,n,null);we(t.__webglFramebuffer[o],t,N.TEXTURE_CUBE_MAP_POSITIVE_X+o);Re(t.__webglRenderbuffer[o],t)}if(r)N.generateMipmap(N.TEXTURE_CUBE_MAP)}else{t.__webglFramebuffer=N.createFramebuffer();if(t.shareDepthFrom){t.__webglRenderbuffer=t.shareDepthFrom.__webglRenderbuffer}else{t.__webglRenderbuffer=N.createRenderbuffer()}N.bindTexture(N.TEXTURE_2D,t.__webglTexture);_e(N.TEXTURE_2D,t,r);N.texImage2D(N.TEXTURE_2D,0,i,t.width,t.height,0,i,n,null);we(t.__webglFramebuffer,t,N.TEXTURE_2D);if(t.shareDepthFrom){if(t.depthBuffer&&!t.stencilBuffer){N.framebufferRenderbuffer(N.FRAMEBUFFER,N.DEPTH_ATTACHMENT,N.RENDERBUFFER,t.__webglRenderbuffer)}else if(t.depthBuffer&&t.stencilBuffer){N.framebufferRenderbuffer(N.FRAMEBUFFER,N.DEPTH_STENCIL_ATTACHMENT,N.RENDERBUFFER,t.__webglRenderbuffer)}}else{Re(t.__webglRenderbuffer,t)}if(r)N.generateMipmap(N.TEXTURE_2D)}if(e){N.bindTexture(N.TEXTURE_CUBE_MAP,null)}else{N.bindTexture(N.TEXTURE_2D,null)}N.bindRenderbuffer(N.RENDERBUFFER,null);N.bindFramebuffer(N.FRAMEBUFFER,null)}var s,a,u,l,h;if(t){if(e){s=t.__webglFramebuffer[t.activeCubeFace]}else{s=t.__webglFramebuffer}a=t.width;u=t.height;l=0;h=0}else{s=null;a=C;u=L;l=k;h=A}if(s!==w){N.bindFramebuffer(N.FRAMEBUFFER,s);N.viewport(l,h,a,u);w=s}P=a;z=u};this.readRenderTargetPixels=function(t,e,r,i,n,o){if(!(t instanceof THREE.WebGLRenderTarget)){console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");return}if(t.__webglFramebuffer){if(t.format!==THREE.RGBAFormat){console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA format. readPixels can read only RGBA format.");return}var s=false;if(t.__webglFramebuffer!==w){N.bindFramebuffer(N.FRAMEBUFFER,t.__webglFramebuffer);s=true}if(N.checkFramebufferStatus(N.FRAMEBUFFER)===N.FRAMEBUFFER_COMPLETE){N.readPixels(e,r,i,n,N.RGBA,N.UNSIGNED_BYTE,o)}else{console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}if(s){N.bindFramebuffer(N.FRAMEBUFFER,w)}}};function He(t){if(t instanceof THREE.WebGLRenderTargetCube){N.bindTexture(N.TEXTURE_CUBE_MAP,t.__webglTexture);N.generateMipmap(N.TEXTURE_CUBE_MAP);N.bindTexture(N.TEXTURE_CUBE_MAP,null)}else{N.bindTexture(N.TEXTURE_2D,t.__webglTexture);N.generateMipmap(N.TEXTURE_2D);N.bindTexture(N.TEXTURE_2D,null)}}function Me(t){if(t===THREE.NearestFilter||t===THREE.NearestMipMapNearestFilter||t===THREE.NearestMipMapLinearFilter){return N.NEAREST}return N.LINEAR}function Se(t){var e;if(t===THREE.RepeatWrapping)return N.REPEAT;if(t===THREE.ClampToEdgeWrapping)return N.CLAMP_TO_EDGE;if(t===THREE.MirroredRepeatWrapping)return N.MIRRORED_REPEAT;if(t===THREE.NearestFilter)return N.NEAREST;if(t===THREE.NearestMipMapNearestFilter)return N.NEAREST_MIPMAP_NEAREST;if(t===THREE.NearestMipMapLinearFilter)return N.NEAREST_MIPMAP_LINEAR;if(t===THREE.LinearFilter)return N.LINEAR;if(t===THREE.LinearMipMapNearestFilter)return N.LINEAR_MIPMAP_NEAREST;if(t===THREE.LinearMipMapLinearFilter)return N.LINEAR_MIPMAP_LINEAR;if(t===THREE.UnsignedByteType)return N.UNSIGNED_BYTE;if(t===THREE.UnsignedShort4444Type)return N.UNSIGNED_SHORT_4_4_4_4;if(t===THREE.UnsignedShort5551Type)return N.UNSIGNED_SHORT_5_5_5_1;if(t===THREE.UnsignedShort565Type)return N.UNSIGNED_SHORT_5_6_5;if(t===THREE.ByteType)return N.BYTE;if(t===THREE.ShortType)return N.SHORT;if(t===THREE.UnsignedShortType)return N.UNSIGNED_SHORT;if(t===THREE.IntType)return N.INT;if(t===THREE.UnsignedIntType)return N.UNSIGNED_INT;if(t===THREE.FloatType)return N.FLOAT;e=G.get("OES_texture_half_float");if(e!==null){if(t===THREE.HalfFloatType)return e.HALF_FLOAT_OES}if(t===THREE.AlphaFormat)return N.ALPHA;if(t===THREE.RGBFormat)return N.RGB;if(t===THREE.RGBAFormat)return N.RGBA;if(t===THREE.LuminanceFormat)return N.LUMINANCE;if(t===THREE.LuminanceAlphaFormat)return N.LUMINANCE_ALPHA;if(t===THREE.AddEquation)return N.FUNC_ADD;if(t===THREE.SubtractEquation)return N.FUNC_SUBTRACT;if(t===THREE.ReverseSubtractEquation)return N.FUNC_REVERSE_SUBTRACT;if(t===THREE.ZeroFactor)return N.ZERO;if(t===THREE.OneFactor)return N.ONE;if(t===THREE.SrcColorFactor)return N.SRC_COLOR;if(t===THREE.OneMinusSrcColorFactor)return N.ONE_MINUS_SRC_COLOR;if(t===THREE.SrcAlphaFactor)return N.SRC_ALPHA;if(t===THREE.OneMinusSrcAlphaFactor)return N.ONE_MINUS_SRC_ALPHA;if(t===THREE.DstAlphaFactor)return N.DST_ALPHA;if(t===THREE.OneMinusDstAlphaFactor)return N.ONE_MINUS_DST_ALPHA;if(t===THREE.DstColorFactor)return N.DST_COLOR;if(t===THREE.OneMinusDstColorFactor)return N.ONE_MINUS_DST_COLOR;if(t===THREE.SrcAlphaSaturateFactor)return N.SRC_ALPHA_SATURATE;e=G.get("WEBGL_compressed_texture_s3tc");if(e!==null){if(t===THREE.RGB_S3TC_DXT1_Format)return e.COMPRESSED_RGB_S3TC_DXT1_EXT;if(t===THREE.RGBA_S3TC_DXT1_Format)return e.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(t===THREE.RGBA_S3TC_DXT3_Format)return e.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(t===THREE.RGBA_S3TC_DXT5_Format)return e.COMPRESSED_RGBA_S3TC_DXT5_EXT}e=G.get("WEBGL_compressed_texture_pvrtc");if(e!==null){if(t===THREE.RGB_PVRTC_4BPPV1_Format)return e.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(t===THREE.RGB_PVRTC_2BPPV1_Format)return e.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(t===THREE.RGBA_PVRTC_4BPPV1_Format)return e.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(t===THREE.RGBA_PVRTC_2BPPV1_Format)return e.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}e=G.get("EXT_blend_minmax");if(e!==null){if(t===THREE.MinEquation)return e.MIN_EXT;if(t===THREE.MaxEquation)return e.MAX_EXT}return 0}function ke(t){if($&&t&&t.skeleton&&t.skeleton.useVertexTexture){return 1024}else{var e=N.getParameter(N.MAX_VERTEX_UNIFORM_VECTORS);var r=Math.floor((e-20)/4);var i=r;if(t!==undefined&&t instanceof THREE.SkinnedMesh){i=Math.min(t.skeleton.bones.length,i);if(i<t.skeleton.bones.length){THREE.warn("WebGLRenderer: too many bones - "+t.skeleton.bones.length+", this GPU supports just "+i+" (try OpenGL instead of ANGLE)")}}return i}}function Ae(t){var e=0;var r=0;var i=0;var n=0;for(var o=0,s=t.length;o<s;o++){var a=t[o];if(a.onlyShadow||a.visible===false)continue;if(a instanceof THREE.DirectionalLight)e++;if(a instanceof THREE.PointLight)r++;if(a instanceof THREE.SpotLight)i++;if(a instanceof THREE.HemisphereLight)n++}return{directional:e,point:r,spot:i,hemi:n}}function Ce(t){var e=0;for(var r=0,i=t.length;r<i;r++){var n=t[r];if(!n.castShadow)continue;if(n instanceof THREE.SpotLight)e++;if(n instanceof THREE.DirectionalLight&&!n.shadowCascade)e++}return e}this.initMaterial=function(){THREE.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")};this.addPrePlugin=function(){THREE.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")};this.addPostPlugin=function(){THREE.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")};this.updateShadowMap=function(){THREE.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}};THREE.WebGLRenderTarget=function(t,e,r){this.width=t;this.height=e;r=r||{};this.wrapS=r.wrapS!==undefined?r.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=r.wrapT!==undefined?r.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=r.magFilter!==undefined?r.magFilter:THREE.LinearFilter;this.minFilter=r.minFilter!==undefined?r.minFilter:THREE.LinearMipMapLinearFilter;this.anisotropy=r.anisotropy!==undefined?r.anisotropy:1;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=r.format!==undefined?r.format:THREE.RGBAFormat;this.type=r.type!==undefined?r.type:THREE.UnsignedByteType;this.depthBuffer=r.depthBuffer!==undefined?r.depthBuffer:true;this.stencilBuffer=r.stencilBuffer!==undefined?r.stencilBuffer:true;this.generateMipmaps=true;this.shareDepthFrom=r.shareDepthFrom!==undefined?r.shareDepthFrom:null};THREE.WebGLRenderTarget.prototype={constructor:THREE.WebGLRenderTarget,setSize:function(t,e){this.width=t;this.height=e},clone:function(){var t=new THREE.WebGLRenderTarget(this.width,this.height);t.wrapS=this.wrapS;t.wrapT=this.wrapT;t.magFilter=this.magFilter;t.minFilter=this.minFilter;t.anisotropy=this.anisotropy;t.offset.copy(this.offset);t.repeat.copy(this.repeat);t.format=this.format;t.type=this.type;t.depthBuffer=this.depthBuffer;t.stencilBuffer=this.stencilBuffer;t.generateMipmaps=this.generateMipmaps;t.shareDepthFrom=this.shareDepthFrom;return t},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.WebGLRenderTarget.prototype);THREE.WebGLRenderTargetCube=function(t,e,r){THREE.WebGLRenderTarget.call(this,t,e,r);this.activeCubeFace=0};THREE.WebGLRenderTargetCube.prototype=Object.create(THREE.WebGLRenderTarget.prototype);THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;THREE.WebGLExtensions=function(t){var e={};this.get=function(r){if(e[r]!==undefined){return e[r]}var i;switch(r){case"EXT_texture_filter_anisotropic":i=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":i=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":i=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:i=t.getExtension(r)}if(i===null){THREE.warn("THREE.WebGLRenderer: "+r+" extension not supported.")}e[r]=i;return i}};THREE.WebGLProgram=function(){var t=0;var e=function(t){var e,r,i=[];for(var n in t){e=t[n];if(e===false)continue;r="#define "+n+" "+e;i.push(r)}return i.join("\n")};var r=function(t,e,r){var i={};for(var n=0,o=r.length;n<o;n++){var s=r[n];i[s]=t.getUniformLocation(e,s)}return i};var i=function(t,e,r){var i={};for(var n=0,o=r.length;n<o;n++){var s=r[n];i[s]=t.getAttribLocation(e,s)}return i};return function(n,o,s,a){var u=n;var l=u.context;var h=s.defines;var f=s.__webglShader.uniforms;var c=s.attributes;var p=s.__webglShader.vertexShader;var d=s.__webglShader.fragmentShader;var m=s.index0AttributeName;if(m===undefined&&a.morphTargets===true){m="position"}var v="SHADOWMAP_TYPE_BASIC";if(a.shadowMapType===THREE.PCFShadowMap){v="SHADOWMAP_TYPE_PCF"}else if(a.shadowMapType===THREE.PCFSoftShadowMap){v="SHADOWMAP_TYPE_PCF_SOFT"}var g="ENVMAP_TYPE_CUBE";var y="ENVMAP_MODE_REFLECTION";var E="ENVMAP_BLENDING_MULTIPLY";if(a.envMap){switch(s.envMap.mapping){case THREE.CubeReflectionMapping:case THREE.CubeRefractionMapping:g="ENVMAP_TYPE_CUBE";break;case THREE.EquirectangularReflectionMapping:case THREE.EquirectangularRefractionMapping:g="ENVMAP_TYPE_EQUIREC";break;case THREE.SphericalReflectionMapping:g="ENVMAP_TYPE_SPHERE";break}switch(s.envMap.mapping){case THREE.CubeRefractionMapping:case THREE.EquirectangularRefractionMapping:y="ENVMAP_MODE_REFRACTION";break}switch(s.combine){case THREE.MultiplyOperation:E="ENVMAP_BLENDING_MULTIPLY";break;case THREE.MixOperation:E="ENVMAP_BLENDING_MIX";break;case THREE.AddOperation:E="ENVMAP_BLENDING_ADD";break}}var _=n.gammaFactor>0?n.gammaFactor:1;var x=e(h);var b=l.createProgram();var T,w;if(s instanceof THREE.RawShaderMaterial){T="";w=""}else{T=["precision "+a.precision+" float;","precision "+a.precision+" int;",x,a.supportsVertexTextures?"#define VERTEX_TEXTURES":"",u.gammaInput?"#define GAMMA_INPUT":"",u.gammaOutput?"#define GAMMA_OUTPUT":"","#define GAMMA_FACTOR "+_,"#define MAX_DIR_LIGHTS "+a.maxDirLights,"#define MAX_POINT_LIGHTS "+a.maxPointLights,"#define MAX_SPOT_LIGHTS "+a.maxSpotLights,"#define MAX_HEMI_LIGHTS "+a.maxHemiLights,"#define MAX_SHADOWS "+a.maxShadows,"#define MAX_BONES "+a.maxBones,a.map?"#define USE_MAP":"",a.envMap?"#define USE_ENVMAP":"",a.envMap?"#define "+y:"",a.lightMap?"#define USE_LIGHTMAP":"",a.bumpMap?"#define USE_BUMPMAP":"",a.normalMap?"#define USE_NORMALMAP":"",a.specularMap?"#define USE_SPECULARMAP":"",a.alphaMap?"#define USE_ALPHAMAP":"",a.vertexColors?"#define USE_COLOR":"",a.flatShading?"#define FLAT_SHADED":"",a.skinning?"#define USE_SKINNING":"",a.useVertexTexture?"#define BONE_TEXTURE":"",a.morphTargets?"#define USE_MORPHTARGETS":"",a.morphNormals?"#define USE_MORPHNORMALS":"",a.wrapAround?"#define WRAP_AROUND":"",a.doubleSided?"#define DOUBLE_SIDED":"",a.flipSided?"#define FLIP_SIDED":"",a.shadowMapEnabled?"#define USE_SHADOWMAP":"",a.shadowMapEnabled?"#define "+v:"",a.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",a.shadowMapCascade?"#define SHADOWMAP_CASCADE":"",a.sizeAttenuation?"#define USE_SIZEATTENUATION":"",a.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","attribute vec2 uv2;","#ifdef USE_COLOR","\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif",""].join("\n");w=["precision "+a.precision+" float;","precision "+a.precision+" int;",a.bumpMap||a.normalMap||a.flatShading?"#extension GL_OES_standard_derivatives : enable":"",x,"#define MAX_DIR_LIGHTS "+a.maxDirLights,"#define MAX_POINT_LIGHTS "+a.maxPointLights,"#define MAX_SPOT_LIGHTS "+a.maxSpotLights,"#define MAX_HEMI_LIGHTS "+a.maxHemiLights,"#define MAX_SHADOWS "+a.maxShadows,a.alphaTest?"#define ALPHATEST "+a.alphaTest:"",u.gammaInput?"#define GAMMA_INPUT":"",u.gammaOutput?"#define GAMMA_OUTPUT":"","#define GAMMA_FACTOR "+_,a.useFog&&a.fog?"#define USE_FOG":"",a.useFog&&a.fogExp?"#define FOG_EXP2":"",a.map?"#define USE_MAP":"",a.envMap?"#define USE_ENVMAP":"",a.envMap?"#define "+g:"",a.envMap?"#define "+y:"",a.envMap?"#define "+E:"",a.lightMap?"#define USE_LIGHTMAP":"",a.bumpMap?"#define USE_BUMPMAP":"",a.normalMap?"#define USE_NORMALMAP":"",a.specularMap?"#define USE_SPECULARMAP":"",a.alphaMap?"#define USE_ALPHAMAP":"",a.vertexColors?"#define USE_COLOR":"",a.flatShading?"#define FLAT_SHADED":"",a.metal?"#define METAL":"",a.wrapAround?"#define WRAP_AROUND":"",a.doubleSided?"#define DOUBLE_SIDED":"",a.flipSided?"#define FLIP_SIDED":"",a.shadowMapEnabled?"#define USE_SHADOWMAP":"",a.shadowMapEnabled?"#define "+v:"",a.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",a.shadowMapCascade?"#define SHADOWMAP_CASCADE":"",a.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",""].join("\n")}var R=new THREE.WebGLShader(l,l.VERTEX_SHADER,T+p);var H=new THREE.WebGLShader(l,l.FRAGMENT_SHADER,w+d);l.attachShader(b,R);l.attachShader(b,H);if(m!==undefined){l.bindAttribLocation(b,0,m)}l.linkProgram(b);var M=l.getProgramInfoLog(b);if(l.getProgramParameter(b,l.LINK_STATUS)===false){THREE.error("THREE.WebGLProgram: shader error: "+l.getError(),"gl.VALIDATE_STATUS",l.getProgramParameter(b,l.VALIDATE_STATUS),"gl.getPRogramInfoLog",M)}if(M!==""){THREE.warn("THREE.WebGLProgram: gl.getProgramInfoLog()"+M)}l.deleteShader(R);l.deleteShader(H);var S=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","modelMatrix","cameraPosition","morphTargetInfluences","bindMatrix","bindMatrixInverse"];if(a.useVertexTexture){S.push("boneTexture");S.push("boneTextureWidth");S.push("boneTextureHeight")}else{S.push("boneGlobalMatrices")}if(a.logarithmicDepthBuffer){S.push("logDepthBufFC")}for(var k in f){S.push(k)}this.uniforms=r(l,b,S);S=["position","normal","uv","uv2","tangent","color","skinIndex","skinWeight","lineDistance"];for(var A=0;A<a.maxMorphTargets;A++){S.push("morphTarget"+A)}for(var A=0;A<a.maxMorphNormals;A++){S.push("morphNormal"+A)}for(var C in c){S.push(C)}this.attributes=i(l,b,S);this.attributesKeys=Object.keys(this.attributes);this.id=t++;this.code=o;this.usedTimes=1;this.program=b;this.vertexShader=R;this.fragmentShader=H;return this}}();THREE.WebGLShader=function(){var t=function(t){var e=t.split("\n");for(var r=0;r<e.length;r++){e[r]=r+1+": "+e[r]}return e.join("\n")};return function(e,r,i){var n=e.createShader(r);e.shaderSource(n,i);e.compileShader(n);if(e.getShaderParameter(n,e.COMPILE_STATUS)===false){THREE.error("THREE.WebGLShader: Shader couldn't compile.")}if(e.getShaderInfoLog(n)!==""){THREE.warn("THREE.WebGLShader: gl.getShaderInfoLog()",e.getShaderInfoLog(n),t(i))}return n}}();THREE.WebGLState=function(t,e){var r=new Uint8Array(16);var i=new Uint8Array(16);var n=null;var o=null;var s=null;var a=null;var u=null;var l=null;var h=null;var f=null;var c=null;var p=null;var d=null;var m=null;var v=null;var g=null;var y=null;var E=null;this.initAttributes=function(){for(var t=0,e=r.length;t<e;t++){r[t]=0}};this.enableAttribute=function(e){r[e]=1;if(i[e]===0){t.enableVertexAttribArray(e);i[e]=1}};this.disableUnusedAttributes=function(){for(var e=0,n=i.length;e<n;e++){if(i[e]!==r[e]){t.disableVertexAttribArray(e);i[e]=0}}};this.setBlending=function(r,i,f,c,p,d,m){if(r!==n){if(r===THREE.NoBlending){t.disable(t.BLEND)}else if(r===THREE.AdditiveBlending){t.enable(t.BLEND);t.blendEquation(t.FUNC_ADD);t.blendFunc(t.SRC_ALPHA,t.ONE)}else if(r===THREE.SubtractiveBlending){t.enable(t.BLEND);t.blendEquation(t.FUNC_ADD);t.blendFunc(t.ZERO,t.ONE_MINUS_SRC_COLOR)}else if(r===THREE.MultiplyBlending){t.enable(t.BLEND);t.blendEquation(t.FUNC_ADD);t.blendFunc(t.ZERO,t.SRC_COLOR)}else if(r===THREE.CustomBlending){t.enable(t.BLEND)}else{t.enable(t.BLEND);t.blendEquationSeparate(t.FUNC_ADD,t.FUNC_ADD);t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA)}n=r}if(r===THREE.CustomBlending){p=p||i;d=d||f;m=m||c;if(i!==o||p!==u){t.blendEquationSeparate(e(i),e(p));o=i;u=p}if(f!==s||c!==a||d!==l||m!==h){t.blendFuncSeparate(e(f),e(c),e(d),e(m));s=f;a=c;l=d;h=m}}else{o=null;s=null;a=null;u=null;l=null;h=null}};this.setDepthTest=function(e){if(f!==e){if(e){t.enable(t.DEPTH_TEST)}else{t.disable(t.DEPTH_TEST)}f=e}};this.setDepthWrite=function(e){if(c!==e){t.depthMask(e);c=e}};this.setColorWrite=function(e){if(p!==e){t.colorMask(e,e,e,e);p=e}};this.setDoubleSided=function(e){if(d!==e){if(e){t.disable(t.CULL_FACE)}else{t.enable(t.CULL_FACE)}d=e}};this.setFlipSided=function(e){if(m!==e){if(e){t.frontFace(t.CW)}else{t.frontFace(t.CCW)}m=e}};this.setLineWidth=function(e){if(e!==v){t.lineWidth(e);v=e}};this.setPolygonOffset=function(e,r,i){if(g!==e){if(e){t.enable(t.POLYGON_OFFSET_FILL)}else{t.disable(t.POLYGON_OFFSET_FILL)}g=e}if(e&&(y!==r||E!==i)){t.polygonOffset(r,i);y=r;E=i}};this.reset=function(){for(var t=0;t<i.length;t++){i[t]=0}n=null;f=null;c=null;p=null;d=null;m=null}};THREE.LensFlarePlugin=function(t,e){var r=t.context;var i,n;var o,s,a;var u;var l,h;var f=function(){var t=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]);var e=new Uint16Array([0,1,2,0,2,3]);i=r.createBuffer();n=r.createBuffer();r.bindBuffer(r.ARRAY_BUFFER,i);r.bufferData(r.ARRAY_BUFFER,t,r.STATIC_DRAW);r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n);r.bufferData(r.ELEMENT_ARRAY_BUFFER,e,r.STATIC_DRAW);l=r.createTexture();h=r.createTexture();r.bindTexture(r.TEXTURE_2D,l);r.texImage2D(r.TEXTURE_2D,0,r.RGB,16,16,0,r.RGB,r.UNSIGNED_BYTE,null);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,r.CLAMP_TO_EDGE);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,r.CLAMP_TO_EDGE);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.NEAREST);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.NEAREST);r.bindTexture(r.TEXTURE_2D,h);r.texImage2D(r.TEXTURE_2D,0,r.RGBA,16,16,0,r.RGBA,r.UNSIGNED_BYTE,null);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,r.CLAMP_TO_EDGE);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,r.CLAMP_TO_EDGE);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.NEAREST);r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.NEAREST);u=r.getParameter(r.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0;var f;if(u){f={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","uniform sampler2D occlusionMap;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float vVisibility;","void main() {","vUV = uv;","vec2 pos = position;","if( renderType == 2 ) {","vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );","vVisibility =        visibility.r / 9.0;","vVisibility *= 1.0 - visibility.g / 9.0;","vVisibility *=       visibility.b / 9.0;","vVisibility *= 1.0 - visibility.a / 9.0;","pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","}","gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["uniform lowp int renderType;","uniform sampler2D map;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","varying float vVisibility;","void main() {","if( renderType == 0 ) {","gl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );","} else if( renderType == 1 ) {","gl_FragColor = texture2D( map, vUV );","} else {","vec4 texture = texture2D( map, vUV );","texture.a *= opacity * vVisibility;","gl_FragColor = texture;","gl_FragColor.rgb *= color;","}","}"].join("\n")}}else{f={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","void main() {","vUV = uv;","vec2 pos = position;","if( renderType == 2 ) {","pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","}","gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["precision mediump float;","uniform lowp int renderType;","uniform sampler2D map;","uniform sampler2D occlusionMap;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","void main() {","if( renderType == 0 ) {","gl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );","} else if( renderType == 1 ) {","gl_FragColor = texture2D( map, vUV );","} else {","float visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a;","visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a;","visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a;","visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;","visibility = ( 1.0 - visibility / 4.0 );","vec4 texture = texture2D( map, vUV );","texture.a *= opacity * visibility;","gl_FragColor = texture;","gl_FragColor.rgb *= color;","}","}"].join("\n")}}o=c(f);s={vertex:r.getAttribLocation(o,"position"),uv:r.getAttribLocation(o,"uv")};a={renderType:r.getUniformLocation(o,"renderType"),map:r.getUniformLocation(o,"map"),occlusionMap:r.getUniformLocation(o,"occlusionMap"),opacity:r.getUniformLocation(o,"opacity"),color:r.getUniformLocation(o,"color"),scale:r.getUniformLocation(o,"scale"),rotation:r.getUniformLocation(o,"rotation"),screenPosition:r.getUniformLocation(o,"screenPosition")}};this.render=function(c,p,d,m){if(e.length===0)return;var v=new THREE.Vector3;var g=m/d,y=d*.5,E=m*.5;var _=16/m,x=new THREE.Vector2(_*g,_);var b=new THREE.Vector3(1,1,0),T=new THREE.Vector2(1,1);if(o===undefined){f()}r.useProgram(o);r.enableVertexAttribArray(s.vertex);r.enableVertexAttribArray(s.uv);r.uniform1i(a.occlusionMap,0);r.uniform1i(a.map,1);r.bindBuffer(r.ARRAY_BUFFER,i);r.vertexAttribPointer(s.vertex,2,r.FLOAT,false,2*8,0);r.vertexAttribPointer(s.uv,2,r.FLOAT,false,2*8,8);r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n);r.disable(r.CULL_FACE);r.depthMask(false);for(var w=0,R=e.length;w<R;w++){_=16/m;x.set(_*g,_);var H=e[w];v.set(H.matrixWorld.elements[12],H.matrixWorld.elements[13],H.matrixWorld.elements[14]);v.applyMatrix4(p.matrixWorldInverse);v.applyProjection(p.projectionMatrix);b.copy(v);T.x=b.x*y+y;T.y=b.y*E+E;if(u||T.x>0&&T.x<d&&T.y>0&&T.y<m){r.activeTexture(r.TEXTURE1);r.bindTexture(r.TEXTURE_2D,l);r.copyTexImage2D(r.TEXTURE_2D,0,r.RGB,T.x-8,T.y-8,16,16,0);r.uniform1i(a.renderType,0);r.uniform2f(a.scale,x.x,x.y);r.uniform3f(a.screenPosition,b.x,b.y,b.z);r.disable(r.BLEND);r.enable(r.DEPTH_TEST);r.drawElements(r.TRIANGLES,6,r.UNSIGNED_SHORT,0);r.activeTexture(r.TEXTURE0);r.bindTexture(r.TEXTURE_2D,h);r.copyTexImage2D(r.TEXTURE_2D,0,r.RGBA,T.x-8,T.y-8,16,16,0);r.uniform1i(a.renderType,1);r.disable(r.DEPTH_TEST);r.activeTexture(r.TEXTURE1);r.bindTexture(r.TEXTURE_2D,l);r.drawElements(r.TRIANGLES,6,r.UNSIGNED_SHORT,0);H.positionScreen.copy(b);if(H.customUpdateCallback){H.customUpdateCallback(H)}else{H.updateLensFlares()}r.uniform1i(a.renderType,2);r.enable(r.BLEND);for(var M=0,S=H.lensFlares.length;M<S;M++){var k=H.lensFlares[M];if(k.opacity>.001&&k.scale>.001){b.x=k.x;b.y=k.y;b.z=k.z;_=k.size*k.scale/m;x.x=_*g;x.y=_;r.uniform3f(a.screenPosition,b.x,b.y,b.z);r.uniform2f(a.scale,x.x,x.y);r.uniform1f(a.rotation,k.rotation);r.uniform1f(a.opacity,k.opacity);r.uniform3f(a.color,k.color.r,k.color.g,k.color.b);t.state.setBlending(k.blending,k.blendEquation,k.blendSrc,k.blendDst);t.setTexture(k.texture,1);r.drawElements(r.TRIANGLES,6,r.UNSIGNED_SHORT,0)}}}}r.enable(r.CULL_FACE);r.enable(r.DEPTH_TEST);r.depthMask(true);t.resetGLState()};function c(e){var i=r.createProgram();var n=r.createShader(r.FRAGMENT_SHADER);var o=r.createShader(r.VERTEX_SHADER);var s="precision "+t.getPrecision()+" float;\n";r.shaderSource(n,s+e.fragmentShader);r.shaderSource(o,s+e.vertexShader);r.compileShader(n);r.compileShader(o);r.attachShader(i,n);r.attachShader(i,o);r.linkProgram(i);return i}};THREE.ShadowMapPlugin=function(t,e,r,i){var n=t.context;var o,s,a,u,l=new THREE.Frustum,h=new THREE.Matrix4,f=new THREE.Vector3,c=new THREE.Vector3,p=new THREE.Vector3,d=[];var m=THREE.ShaderLib["depthRGBA"];var v=THREE.UniformsUtils.clone(m.uniforms);o=new THREE.ShaderMaterial({uniforms:v,vertexShader:m.vertexShader,fragmentShader:m.fragmentShader});s=new THREE.ShaderMaterial({uniforms:v,vertexShader:m.vertexShader,fragmentShader:m.fragmentShader,morphTargets:true});a=new THREE.ShaderMaterial({uniforms:v,vertexShader:m.vertexShader,fragmentShader:m.fragmentShader,skinning:true});u=new THREE.ShaderMaterial({uniforms:v,vertexShader:m.vertexShader,fragmentShader:m.fragmentShader,morphTargets:true,skinning:true});o._shadowPass=true;s._shadowPass=true;a._shadowPass=true;u._shadowPass=true;this.render=function(r,f){if(t.shadowMapEnabled===false)return;var c,m,v,b,T,w,R,H,M,S,k,A,C,L=[],P=0,z=null;n.clearColor(1,1,1,1);n.disable(n.BLEND);n.enable(n.CULL_FACE);n.frontFace(n.CCW);if(t.shadowMapCullFace===THREE.CullFaceFront){n.cullFace(n.FRONT)}else{n.cullFace(n.BACK)}t.state.setDepthTest(true);for(c=0,m=e.length;c<m;c++){C=e[c];if(!C.castShadow)continue;if(C instanceof THREE.DirectionalLight&&C.shadowCascade){for(T=0;T<C.shadowCascadeCount;T++){var D;if(!C.shadowCascadeArray[T]){D=y(C,T);D.originalCamera=f;var O=new THREE.Gyroscope;O.position.copy(C.shadowCascadeOffset);O.add(D);O.add(D.target);f.add(O);C.shadowCascadeArray[T]=D}else{D=C.shadowCascadeArray[T]}E(C,T);L[P]=D;P++}}else{L[P]=C;P++}}for(c=0,m=L.length;c<m;c++){C=L[c];if(!C.shadowMap){var F=THREE.LinearFilter;if(t.shadowMapType===THREE.PCFSoftShadowMap){F=THREE.NearestFilter}var U={minFilter:F,magFilter:F,format:THREE.RGBAFormat};C.shadowMap=new THREE.WebGLRenderTarget(C.shadowMapWidth,C.shadowMapHeight,U);C.shadowMapSize=new THREE.Vector2(C.shadowMapWidth,C.shadowMapHeight);C.shadowMatrix=new THREE.Matrix4}if(!C.shadowCamera){if(C instanceof THREE.SpotLight){C.shadowCamera=new THREE.PerspectiveCamera(C.shadowCameraFov,C.shadowMapWidth/C.shadowMapHeight,C.shadowCameraNear,C.shadowCameraFar)}else if(C instanceof THREE.DirectionalLight){C.shadowCamera=new THREE.OrthographicCamera(C.shadowCameraLeft,C.shadowCameraRight,C.shadowCameraTop,C.shadowCameraBottom,C.shadowCameraNear,C.shadowCameraFar)}else{THREE.error("THREE.ShadowMapPlugin: Unsupported light type for shadow",C);continue}r.add(C.shadowCamera);if(r.autoUpdate===true)r.updateMatrixWorld()}if(C.shadowCameraVisible&&!C.cameraHelper){C.cameraHelper=new THREE.CameraHelper(C.shadowCamera);r.add(C.cameraHelper)}if(C.isVirtual&&D.originalCamera==f){_(f,C)}w=C.shadowMap;R=C.shadowMatrix;H=C.shadowCamera;H.position.setFromMatrixPosition(C.matrixWorld);p.setFromMatrixPosition(C.target.matrixWorld);H.lookAt(p);H.updateMatrixWorld();H.matrixWorldInverse.getInverse(H.matrixWorld);if(C.cameraHelper)C.cameraHelper.visible=C.shadowCameraVisible;if(C.shadowCameraVisible)C.cameraHelper.update();R.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1);R.multiply(H.projectionMatrix);R.multiply(H.matrixWorldInverse);h.multiplyMatrices(H.projectionMatrix,H.matrixWorldInverse);l.setFromMatrix(h);t.setRenderTarget(w);t.clear();d.length=0;g(r,r,H);var B,V,N;for(v=0,b=d.length;v<b;v++){k=d[v];A=k.object;M=k.buffer;B=x(A);V=A.geometry.morphTargets!==undefined&&A.geometry.morphTargets.length>0&&B.morphTargets;N=A instanceof THREE.SkinnedMesh&&B.skinning;if(A.customDepthMaterial){S=A.customDepthMaterial}else if(N){S=V?u:a}else if(V){S=s}else{S=o}t.setMaterialFaces(B);if(M instanceof THREE.BufferGeometry){t.renderBufferDirect(H,e,z,S,M,A)}else{t.renderBuffer(H,e,z,S,M,A)}}for(v=0,b=i.length;v<b;v++){k=i[v];A=k.object;if(A.visible&&A.castShadow){A._modelViewMatrix.multiplyMatrices(H.matrixWorldInverse,A.matrixWorld);t.renderImmediateObject(H,e,z,o,A)}}}var I=t.getClearColor(),j=t.getClearAlpha();n.clearColor(I.r,I.g,I.b,j);n.enable(n.BLEND);if(t.shadowMapCullFace===THREE.CullFaceFront){n.cullFace(n.BACK)}t.resetGLState()};function g(t,e,i){if(e.visible){var n=r[e.id];if(n&&e.castShadow&&(e.frustumCulled===false||l.intersectsObject(e)===true)){for(var o=0,s=n.length;o<s;o++){var a=n[o];e._modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,e.matrixWorld);d.push(a)}}for(var o=0,s=e.children.length;o<s;o++){g(t,e.children[o],i)}}}function y(t,e){var r=new THREE.DirectionalLight;r.isVirtual=true;r.onlyShadow=true;r.castShadow=true;r.shadowCameraNear=t.shadowCameraNear;r.shadowCameraFar=t.shadowCameraFar;r.shadowCameraLeft=t.shadowCameraLeft;r.shadowCameraRight=t.shadowCameraRight;r.shadowCameraBottom=t.shadowCameraBottom;r.shadowCameraTop=t.shadowCameraTop;r.shadowCameraVisible=t.shadowCameraVisible;r.shadowDarkness=t.shadowDarkness;r.shadowBias=t.shadowCascadeBias[e];r.shadowMapWidth=t.shadowCascadeWidth[e];r.shadowMapHeight=t.shadowCascadeHeight[e];r.pointsWorld=[];r.pointsFrustum=[];var i=r.pointsWorld,n=r.pointsFrustum;for(var o=0;o<8;o++){i[o]=new THREE.Vector3;n[o]=new THREE.Vector3}var s=t.shadowCascadeNearZ[e];var a=t.shadowCascadeFarZ[e];n[0].set(-1,-1,s);n[1].set(1,-1,s);n[2].set(-1,1,s);n[3].set(1,1,s);n[4].set(-1,-1,a);n[5].set(1,-1,a);n[6].set(-1,1,a);n[7].set(1,1,a);return r}function E(t,e){var r=t.shadowCascadeArray[e];r.position.copy(t.position);r.target.position.copy(t.target.position);r.lookAt(r.target);r.shadowCameraVisible=t.shadowCameraVisible;r.shadowDarkness=t.shadowDarkness;r.shadowBias=t.shadowCascadeBias[e];var i=t.shadowCascadeNearZ[e];var n=t.shadowCascadeFarZ[e];var o=r.pointsFrustum;o[0].z=i;o[1].z=i;o[2].z=i;o[3].z=i;o[4].z=n;o[5].z=n;o[6].z=n;o[7].z=n}function _(t,e){var r=e.shadowCamera,i=e.pointsFrustum,n=e.pointsWorld;f.set(Infinity,Infinity,Infinity);c.set(-Infinity,-Infinity,-Infinity);for(var o=0;o<8;o++){var s=n[o];s.copy(i[o]);s.unproject(t);s.applyMatrix4(r.matrixWorldInverse);if(s.x<f.x)f.x=s.x;if(s.x>c.x)c.x=s.x;if(s.y<f.y)f.y=s.y;if(s.y>c.y)c.y=s.y;if(s.z<f.z)f.z=s.z;if(s.z>c.z)c.z=s.z}r.left=f.x;r.right=c.x;r.top=c.y;r.bottom=f.y;r.updateProjectionMatrix()}function x(t){return t.material instanceof THREE.MeshFaceMaterial?t.material.materials[0]:t.material}};THREE.SpritePlugin=function(t,e){var r=t.context;var i,n;var o,s,a;var u;var l=new THREE.Vector3;var h=new THREE.Quaternion;var f=new THREE.Vector3;var c=function(){var t=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]);var e=new Uint16Array([0,1,2,0,2,3]);i=r.createBuffer();n=r.createBuffer();r.bindBuffer(r.ARRAY_BUFFER,i);r.bufferData(r.ARRAY_BUFFER,t,r.STATIC_DRAW);r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n);r.bufferData(r.ELEMENT_ARRAY_BUFFER,e,r.STATIC_DRAW);o=p();s={position:r.getAttribLocation(o,"position"),uv:r.getAttribLocation(o,"uv")};a={uvOffset:r.getUniformLocation(o,"uvOffset"),uvScale:r.getUniformLocation(o,"uvScale"),rotation:r.getUniformLocation(o,"rotation"),scale:r.getUniformLocation(o,"scale"),color:r.getUniformLocation(o,"color"),map:r.getUniformLocation(o,"map"),opacity:r.getUniformLocation(o,"opacity"),modelViewMatrix:r.getUniformLocation(o,"modelViewMatrix"),projectionMatrix:r.getUniformLocation(o,"projectionMatrix"),fogType:r.getUniformLocation(o,"fogType"),fogDensity:r.getUniformLocation(o,"fogDensity"),fogNear:r.getUniformLocation(o,"fogNear"),fogFar:r.getUniformLocation(o,"fogFar"),fogColor:r.getUniformLocation(o,"fogColor"),alphaTest:r.getUniformLocation(o,"alphaTest")};var l=document.createElement("canvas");l.width=8;l.height=8;var h=l.getContext("2d");h.fillStyle="white";h.fillRect(0,0,8,8);u=new THREE.Texture(l);u.needsUpdate=true};this.render=function(p,m){if(e.length===0)return;if(o===undefined){c()}r.useProgram(o);r.enableVertexAttribArray(s.position);r.enableVertexAttribArray(s.uv);r.disable(r.CULL_FACE);r.enable(r.BLEND);r.bindBuffer(r.ARRAY_BUFFER,i);r.vertexAttribPointer(s.position,2,r.FLOAT,false,2*8,0);r.vertexAttribPointer(s.uv,2,r.FLOAT,false,2*8,8);r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n);r.uniformMatrix4fv(a.projectionMatrix,false,m.projectionMatrix.elements);r.activeTexture(r.TEXTURE0);r.uniform1i(a.map,0);var v=0;var g=0;var y=p.fog;if(y){r.uniform3f(a.fogColor,y.color.r,y.color.g,y.color.b);if(y instanceof THREE.Fog){r.uniform1f(a.fogNear,y.near);r.uniform1f(a.fogFar,y.far);r.uniform1i(a.fogType,1);v=1;g=1}else if(y instanceof THREE.FogExp2){r.uniform1f(a.fogDensity,y.density);r.uniform1i(a.fogType,2);v=2;g=2}}else{r.uniform1i(a.fogType,0);v=0;g=0}for(var E=0,_=e.length;E<_;E++){var x=e[E];x._modelViewMatrix.multiplyMatrices(m.matrixWorldInverse,x.matrixWorld);x.z=-x._modelViewMatrix.elements[14]}e.sort(d);var b=[];for(var E=0,_=e.length;E<_;E++){var x=e[E];var T=x.material;r.uniform1f(a.alphaTest,T.alphaTest);r.uniformMatrix4fv(a.modelViewMatrix,false,x._modelViewMatrix.elements);x.matrixWorld.decompose(l,h,f);b[0]=f.x;b[1]=f.y;var w=0;if(p.fog&&T.fog){w=g}if(v!==w){r.uniform1i(a.fogType,w);v=w}if(T.map!==null){r.uniform2f(a.uvOffset,T.map.offset.x,T.map.offset.y);r.uniform2f(a.uvScale,T.map.repeat.x,T.map.repeat.y)}else{r.uniform2f(a.uvOffset,0,0);r.uniform2f(a.uvScale,1,1)}r.uniform1f(a.opacity,T.opacity);r.uniform3f(a.color,T.color.r,T.color.g,T.color.b);r.uniform1f(a.rotation,T.rotation);r.uniform2fv(a.scale,b);t.state.setBlending(T.blending,T.blendEquation,T.blendSrc,T.blendDst);t.state.setDepthTest(T.depthTest);t.state.setDepthWrite(T.depthWrite);if(T.map&&T.map.image&&T.map.image.width){t.setTexture(T.map,0)}else{t.setTexture(u,0)}r.drawElements(r.TRIANGLES,6,r.UNSIGNED_SHORT,0)}r.enable(r.CULL_FACE);t.resetGLState()};function p(){var e=r.createProgram();var i=r.createShader(r.VERTEX_SHADER);var n=r.createShader(r.FRAGMENT_SHADER);r.shaderSource(i,["precision "+t.getPrecision()+" float;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform float rotation;","uniform vec2 scale;","uniform vec2 uvOffset;","uniform vec2 uvScale;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","void main() {","vUV = uvOffset + uv * uvScale;","vec2 alignedPosition = position * scale;","vec2 rotatedPosition;","rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;","rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;","vec4 finalPosition;","finalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );","finalPosition.xy += rotatedPosition;","finalPosition = projectionMatrix * finalPosition;","gl_Position = finalPosition;","}"].join("\n"));r.shaderSource(n,["precision "+t.getPrecision()+" float;","uniform vec3 color;","uniform sampler2D map;","uniform float opacity;","uniform int fogType;","uniform vec3 fogColor;","uniform float fogDensity;","uniform float fogNear;","uniform float fogFar;","uniform float alphaTest;","varying vec2 vUV;","void main() {","vec4 texture = texture2D( map, vUV );","if ( texture.a < alphaTest ) discard;","gl_FragColor = vec4( color * texture.xyz, texture.a * opacity );","if ( fogType > 0 ) {","float depth = gl_FragCoord.z / gl_FragCoord.w;","float fogFactor = 0.0;","if ( fogType == 1 ) {","fogFactor = smoothstep( fogNear, fogFar, depth );","} else {","const float LOG2 = 1.442695;","float fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );","fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );","}","gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );","}","}"].join("\n"));r.compileShader(i);r.compileShader(n);r.attachShader(e,i);r.attachShader(e,n);r.linkProgram(e);return e}function d(t,e){if(t.z!==e.z){return e.z-t.z}else{return e.id-t.id}}};THREE.GeometryUtils={merge:function(t,e,r){THREE.warn("THREE.GeometryUtils: .merge() has been moved to Geometry. Use geometry.merge( geometry2, matrix, materialIndexOffset ) instead.");var i;if(e instanceof THREE.Mesh){e.matrixAutoUpdate&&e.updateMatrix();i=e.matrix;e=e.geometry}t.merge(e,i,r)},center:function(t){THREE.warn("THREE.GeometryUtils: .center() has been moved to Geometry. Use geometry.center() instead.");return t.center()}};THREE.ImageUtils={crossOrigin:undefined,loadTexture:function(t,e,r,i){var n=new THREE.ImageLoader;n.crossOrigin=this.crossOrigin;var o=new THREE.Texture(undefined,e);n.load(t,function(t){o.image=t;o.needsUpdate=true;if(r)r(o)},undefined,function(t){if(i)i(t)});o.sourceFile=t;return o},loadTextureCube:function(t,e,r,i){var n=[];var o=new THREE.ImageLoader;o.crossOrigin=this.crossOrigin;var s=new THREE.CubeTexture(n,e);s.flipY=false;var a=0;var u=function(e){o.load(t[e],function(t){s.images[e]=t;a+=1;if(a===6){s.needsUpdate=true;if(r)r(s)}},undefined,i)};for(var l=0,h=t.length;l<h;++l){u(l)}return s},loadCompressedTexture:function(){THREE.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},loadCompressedTextureCube:function(){THREE.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")},getNormalMap:function(t,e){var r=function(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]};var i=function(t,e){return[t[0]-e[0],t[1]-e[1],t[2]-e[2]]};var n=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2]);return[t[0]/e,t[1]/e,t[2]/e]};e=e|1;var o=t.width;var s=t.height;var a=document.createElement("canvas");a.width=o;a.height=s;var u=a.getContext("2d");u.drawImage(t,0,0);var l=u.getImageData(0,0,o,s).data;var h=u.createImageData(o,s);var f=h.data;for(var c=0;c<o;c++){for(var p=0;p<s;p++){var d=p-1<0?0:p-1;var m=p+1>s-1?s-1:p+1;var v=c-1<0?0:c-1;var g=c+1>o-1?o-1:c+1;var y=[];var E=[0,0,l[(p*o+c)*4]/255*e];y.push([-1,0,l[(p*o+v)*4]/255*e]);y.push([-1,-1,l[(d*o+v)*4]/255*e]);y.push([0,-1,l[(d*o+c)*4]/255*e]);y.push([1,-1,l[(d*o+g)*4]/255*e]);y.push([1,0,l[(p*o+g)*4]/255*e]);y.push([1,1,l[(m*o+g)*4]/255*e]);y.push([0,1,l[(m*o+c)*4]/255*e]);y.push([-1,1,l[(m*o+v)*4]/255*e]);var _=[];var x=y.length;for(var b=0;b<x;b++){var T=y[b];var w=y[(b+1)%x];T=i(T,E);w=i(w,E);_.push(n(r(T,w)))}var R=[0,0,0];for(var b=0;b<_.length;b++){R[0]+=_[b][0];R[1]+=_[b][1];R[2]+=_[b][2]}R[0]/=_.length;R[1]/=_.length;R[2]/=_.length;var H=(p*o+c)*4;f[H]=(R[0]+1)/2*255|0;f[H+1]=(R[1]+1)/2*255|0;f[H+2]=R[2]*255|0;f[H+3]=255}}u.putImageData(h,0,0);return a},generateDataTexture:function(t,e,r){var i=t*e;var n=new Uint8Array(3*i);var o=Math.floor(r.r*255);var s=Math.floor(r.g*255);var a=Math.floor(r.b*255);for(var u=0;u<i;u++){n[u*3]=o;n[u*3+1]=s;n[u*3+2]=a}var l=new THREE.DataTexture(n,t,e,THREE.RGBFormat);l.needsUpdate=true;return l}};THREE.SceneUtils={createMultiMaterialObject:function(t,e){var r=new THREE.Object3D;for(var i=0,n=e.length;i<n;i++){r.add(new THREE.Mesh(t,e[i]))}return r},detach:function(t,e,r){t.applyMatrix(e.matrixWorld);e.remove(t);r.add(t)},attach:function(t,e,r){var i=new THREE.Matrix4;i.getInverse(r.matrixWorld);t.applyMatrix(i);e.remove(t);r.add(t)}};THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){try{return this.faces[this.face][this.weight][this.style]}catch(t){throw"The font "+this.face+" with "+this.weight+" weight and "+this.style+" style is missing."}},loadFace:function(t){var e=t.familyName.toLowerCase();var r=this;r.faces[e]=r.faces[e]||{};r.faces[e][t.cssFontWeight]=r.faces[e][t.cssFontWeight]||{};r.faces[e][t.cssFontWeight][t.cssFontStyle]=t;r.faces[e][t.cssFontWeight][t.cssFontStyle]=t;return t},drawText:function(t){var e,r=this.getFace(),i=this.size/r.resolution,n=0,o=String(t).split(""),s=o.length;var a=[];for(e=0;e<s;e++){var u=new THREE.Path;var l=this.extractGlyphPoints(o[e],r,i,n,u);n+=l.offset;a.push(l.path)}var h=n/2;return{paths:a,offset:h}},extractGlyphPoints:function(t,e,r,i,n){var o=[];var s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R=e.glyphs[t]||e.glyphs["?"];if(!R)return;if(R.o){l=R._cachedOutline||(R._cachedOutline=R.o.split(" "));f=l.length;c=r;p=r;for(s=0;s<f;){h=l[s++];switch(h){case"m":d=l[s++]*c+i;m=l[s++]*p;n.moveTo(d,m);break;case"l":d=l[s++]*c+i;m=l[s++]*p;n.lineTo(d,m);break;case"q":v=l[s++]*c+i;g=l[s++]*p;_=l[s++]*c+i;x=l[s++]*p;n.quadraticCurveTo(_,x,v,g);w=o[o.length-1];if(w){y=w.x;E=w.y;for(a=1,u=this.divisions;a<=u;a++){var H=a/u;THREE.Shape.Utils.b2(H,y,_,v);THREE.Shape.Utils.b2(H,E,x,g)}}break;case"b":v=l[s++]*c+i;g=l[s++]*p;_=l[s++]*c+i;x=l[s++]*p;b=l[s++]*c+i;T=l[s++]*p;n.bezierCurveTo(_,x,b,T,v,g);w=o[o.length-1];if(w){y=w.x;E=w.y;for(a=1,u=this.divisions;a<=u;a++){var H=a/u;THREE.Shape.Utils.b3(H,y,_,b,v);THREE.Shape.Utils.b3(H,E,x,T,g)}}break}}}return{offset:R.ha*r,path:n}}};THREE.FontUtils.generateShapes=function(t,e){e=e||{};var r=e.size!==undefined?e.size:100;var i=e.curveSegments!==undefined?e.curveSegments:4;var n=e.font!==undefined?e.font:"helvetiker";var o=e.weight!==undefined?e.weight:"normal";var s=e.style!==undefined?e.style:"normal";THREE.FontUtils.size=r;THREE.FontUtils.divisions=i;THREE.FontUtils.face=n;THREE.FontUtils.weight=o;THREE.FontUtils.style=s;var a=THREE.FontUtils.drawText(t);var u=a.paths;var l=[];for(var h=0,f=u.length;h<f;h++){Array.prototype.push.apply(l,u[h].toShapes())}return l};(function(t){var e=1e-10;var r=function(t,e){var r=t.length;if(r<3)return null;var o=[],s=[],a=[];var u,l,h;if(i(t)>0){for(l=0;l<r;l++)s[l]=l}else{for(l=0;l<r;l++)s[l]=r-1-l}var f=r;var c=2*f;for(l=f-1;f>2;){if(c--<=0){THREE.warn("THREE.FontUtils: Warning, unable to triangulate polygon! in Triangulate.process()");if(e)return a;return o}u=l;if(f<=u)u=0;l=u+1;if(f<=l)l=0;h=l+1;if(f<=h)h=0;if(n(t,u,l,h,f,s)){var p,d,m,v,g;p=s[u];d=s[l];m=s[h];o.push([t[p],t[d],t[m]]);a.push([s[u],s[l],s[h]]);for(v=l,g=l+1;g<f;v++,g++){s[v]=s[g]}f--;c=2*f}}if(e)return a;return o};var i=function(t){var e=t.length;var r=0;for(var i=e-1,n=0;n<e;i=n++){r+=t[i].x*t[n].y-t[n].x*t[i].y}return r*.5};var n=function(t,r,i,n,o,s){var a;var u,l,h,f;var c,p,d,m;u=t[s[r]].x;l=t[s[r]].y;h=t[s[i]].x;f=t[s[i]].y;c=t[s[n]].x;p=t[s[n]].y;if(e>(h-u)*(p-l)-(f-l)*(c-u))return false;var v,g,y,E,_,x;var b,T,w,R,H,M;var S,k,A;v=c-h;g=p-f;y=u-c;E=l-p;_=h-u;x=f-l;for(a=0;a<o;a++){d=t[s[a]].x;m=t[s[a]].y;if(d===u&&m===l||d===h&&m===f||d===c&&m===p)continue;b=d-u;T=m-l;w=d-h;R=m-f;H=d-c;M=m-p;A=v*R-g*w;S=_*T-x*b;k=y*M-E*H;if(A>=-e&&k>=-e&&S>=-e)return false}return true};t.Triangulate=r;t.Triangulate.area=i;return t})(THREE.FontUtils);self._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};THREE.typeface_js=self._typeface_js;THREE.Audio=function(t){THREE.Object3D.call(this);this.type="Audio";this.context=t.context;this.source=this.context.createBufferSource();this.source.onended=this.onEnded.bind(this);this.gain=this.context.createGain();this.gain.connect(this.context.destination);this.panner=this.context.createPanner();this.panner.connect(this.gain);this.autoplay=false;this.startTime=0;this.isPlaying=false};THREE.Audio.prototype=Object.create(THREE.Object3D.prototype);THREE.Audio.prototype.constructor=THREE.Audio;THREE.Audio.prototype.load=function(t){var e=this;var r=new XMLHttpRequest;r.open("GET",t,true);r.responseType="arraybuffer";r.onload=function(t){e.context.decodeAudioData(this.response,function(t){e.source.buffer=t;if(e.autoplay)e.play()})};r.send();return this};THREE.Audio.prototype.play=function(){if(this.isPlaying===true){THREE.warn("THREE.Audio: Audio is already playing.");return}var t=this.context.createBufferSource();t.buffer=this.source.buffer;t.loop=this.source.loop;t.onended=this.source.onended;t.connect(this.panner);t.start(0,this.startTime);this.isPlaying=true;this.source=t};THREE.Audio.prototype.pause=function(){this.source.stop();this.startTime=this.context.currentTime};THREE.Audio.prototype.stop=function(){this.source.stop();this.startTime=0};THREE.Audio.prototype.onEnded=function(){this.isPlaying=false};THREE.Audio.prototype.setLoop=function(t){this.source.loop=t};THREE.Audio.prototype.setRefDistance=function(t){this.panner.refDistance=t};THREE.Audio.prototype.setRolloffFactor=function(t){this.panner.rolloffFactor=t};THREE.Audio.prototype.setVolume=function(t){this.gain.gain.value=t};THREE.Audio.prototype.updateMatrixWorld=function(){var t=new THREE.Vector3;return function(e){THREE.Object3D.prototype.updateMatrixWorld.call(this,e);t.setFromMatrixPosition(this.matrixWorld);this.panner.setPosition(t.x,t.y,t.z)}}();THREE.AudioListener=function(){THREE.Object3D.call(this);this.type="AudioListener";this.context=new(window.AudioContext||window.webkitAudioContext)};THREE.AudioListener.prototype=Object.create(THREE.Object3D.prototype);THREE.AudioListener.prototype.constructor=THREE.AudioListener;THREE.AudioListener.prototype.updateMatrixWorld=function(){var t=new THREE.Vector3;var e=new THREE.Quaternion;var r=new THREE.Vector3;var i=new THREE.Vector3;var n=new THREE.Vector3;var o=new THREE.Vector3;return function(s){THREE.Object3D.prototype.updateMatrixWorld.call(this,s);var a=this.context.listener;var u=this.up;this.matrixWorld.decompose(t,e,r);i.set(0,0,-1).applyQuaternion(e);n.subVectors(t,o);a.setPosition(t.x,t.y,t.z);a.setOrientation(i.x,i.y,i.z,u.x,u.y,u.z);a.setVelocity(n.x,n.y,n.z);o.copy(t)}}();THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(t){THREE.warn("THREE.Curve: Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(t){var e=this.getUtoTmapping(t);return this.getPoint(e)};THREE.Curve.prototype.getPoints=function(t){if(!t)t=5;var e,r=[];for(e=0;e<=t;e++){r.push(this.getPoint(e/t))}return r};THREE.Curve.prototype.getSpacedPoints=function(t){if(!t)t=5;var e,r=[];for(e=0;e<=t;e++){r.push(this.getPointAt(e/t))}return r};THREE.Curve.prototype.getLength=function(){var t=this.getLengths();return t[t.length-1]};THREE.Curve.prototype.getLengths=function(t){if(!t)t=this.__arcLengthDivisions?this.__arcLengthDivisions:200;if(this.cacheArcLengths&&this.cacheArcLengths.length==t+1&&!this.needsUpdate){return this.cacheArcLengths}this.needsUpdate=false;var e=[];var r,i=this.getPoint(0);var n,o=0;e.push(0);for(n=1;n<=t;n++){r=this.getPoint(n/t);o+=r.distanceTo(i);e.push(o);i=r}this.cacheArcLengths=e;return e};THREE.Curve.prototype.updateArcLengths=function(){this.needsUpdate=true;this.getLengths()};THREE.Curve.prototype.getUtoTmapping=function(t,e){var r=this.getLengths();var i=0,n=r.length;var o;if(e){o=e}else{o=t*r[n-1]}var s=0,a=n-1,u;while(s<=a){i=Math.floor(s+(a-s)/2);u=r[i]-o;if(u<0){s=i+1}else if(u>0){a=i-1}else{a=i;break}}i=a;if(r[i]==o){var l=i/(n-1);return l}var h=r[i];var f=r[i+1];var c=f-h;var p=(o-h)/c;var l=(i+p)/(n-1);return l};THREE.Curve.prototype.getTangent=function(t){var e=1e-4;var r=t-e;var i=t+e;if(r<0)r=0;if(i>1)i=1;var n=this.getPoint(r);var o=this.getPoint(i);var s=o.clone().sub(n);return s.normalize()};THREE.Curve.prototype.getTangentAt=function(t){var e=this.getUtoTmapping(t);return this.getTangent(e)};THREE.Curve.Utils={tangentQuadraticBezier:function(t,e,r,i){return 2*(1-t)*(r-e)+2*t*(i-r)},tangentCubicBezier:function(t,e,r,i,n){return-3*e*(1-t)*(1-t)+3*r*(1-t)*(1-t)-6*t*r*(1-t)+6*t*i*(1-t)-3*t*t*i+3*t*t*n},tangentSpline:function(t,e,r,i,n){var o=6*t*t-6*t;var s=3*t*t-4*t+1;var a=-6*t*t+6*t;var u=3*t*t-2*t;return o+s+a+u},interpolate:function(t,e,r,i,n){var o=(r-t)*.5;var s=(i-e)*.5;var a=n*n;var u=n*a;return(2*e-2*r+o+s)*u+(-3*e+3*r-2*o-s)*a+o*n+e}};THREE.Curve.create=function(t,e){t.prototype=Object.create(THREE.Curve.prototype);t.prototype.constructor=t;t.prototype.getPoint=e;return t};THREE.CurvePath=function(){this.curves=[];this.bends=[];this.autoClose=false};THREE.CurvePath.prototype=Object.create(THREE.Curve.prototype);THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(t){this.curves.push(t)};THREE.CurvePath.prototype.checkConnection=function(){};THREE.CurvePath.prototype.closePath=function(){var t=this.curves[0].getPoint(0);var e=this.curves[this.curves.length-1].getPoint(1);if(!t.equals(e)){this.curves.push(new THREE.LineCurve(e,t))}};THREE.CurvePath.prototype.getPoint=function(t){var e=t*this.getLength();var r=this.getCurveLengths();var i=0,n,o;while(i<r.length){if(r[i]>=e){n=r[i]-e;o=this.curves[i];var s=1-n/o.getLength();return o.getPointAt(s)}i++}return null};THREE.CurvePath.prototype.getLength=function(){var t=this.getCurveLengths();return t[t.length-1]};THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length){return this.cacheLengths}var t=[],e=0;var r,i=this.curves.length;for(r=0;r<i;r++){e+=this.curves[r].getLength();t.push(e)}this.cacheLengths=t;return t};THREE.CurvePath.prototype.getBoundingBox=function(){var t=this.getPoints();var e,r,i;var n,o,s;e=r=Number.NEGATIVE_INFINITY;n=o=Number.POSITIVE_INFINITY;var a,u,l,h;var f=t[0]instanceof THREE.Vector3;h=f?new THREE.Vector3:new THREE.Vector2;for(u=0,l=t.length;u<l;u++){a=t[u];if(a.x>e)e=a.x;else if(a.x<n)n=a.x;if(a.y>r)r=a.y;else if(a.y<o)o=a.y;if(f){if(a.z>i)i=a.z;else if(a.z<s)s=a.z}h.add(a)}var c={minX:n,minY:o,maxX:e,maxY:r};if(f){c.maxZ=i;c.minZ=s}return c};THREE.CurvePath.prototype.createPointsGeometry=function(t){var e=this.getPoints(t,true);return this.createGeometry(e)};THREE.CurvePath.prototype.createSpacedPointsGeometry=function(t){var e=this.getSpacedPoints(t,true);return this.createGeometry(e)};THREE.CurvePath.prototype.createGeometry=function(t){var e=new THREE.Geometry;for(var r=0;r<t.length;r++){e.vertices.push(new THREE.Vector3(t[r].x,t[r].y,t[r].z||0))}return e};THREE.CurvePath.prototype.addWrapPath=function(t){this.bends.push(t)};THREE.CurvePath.prototype.getTransformedPoints=function(t,e){var r=this.getPoints(t);var i,n;if(!e){e=this.bends}for(i=0,n=e.length;i<n;i++){r=this.getWrapPoints(r,e[i])}return r};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(t,e){var r=this.getSpacedPoints(t);var i,n;if(!e){e=this.bends}for(i=0,n=e.length;i<n;i++){r=this.getWrapPoints(r,e[i])}return r};THREE.CurvePath.prototype.getWrapPoints=function(t,e){var r=this.getBoundingBox();var i,n,o,s,a,u;for(i=0,n=t.length;i<n;i++){o=t[i];s=o.x;a=o.y;u=s/r.maxX;u=e.getUtoTmapping(u,s);var l=e.getPoint(u);var h=e.getTangent(u);h.set(-h.y,h.x).multiplyScalar(a);o.x=l.x+h.x;o.y=l.y+h.y}return t};THREE.Gyroscope=function(){THREE.Object3D.call(this)};THREE.Gyroscope.prototype=Object.create(THREE.Object3D.prototype);THREE.Gyroscope.prototype.constructor=THREE.Gyroscope;THREE.Gyroscope.prototype.updateMatrixWorld=function(){var t=new THREE.Vector3;var e=new THREE.Quaternion;var r=new THREE.Vector3;var i=new THREE.Vector3;var n=new THREE.Quaternion;var o=new THREE.Vector3;return function(s){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||s){if(this.parent){this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix);this.matrixWorld.decompose(i,n,o);this.matrix.decompose(t,e,r);this.matrixWorld.compose(i,e,o)}else{this.matrixWorld.copy(this.matrix)}this.matrixWorldNeedsUpdate=false;s=true}for(var a=0,u=this.children.length;a<u;a++){this.children[a].updateMatrixWorld(s)}}}();THREE.Path=function(t){THREE.CurvePath.call(this);this.actions=[];if(t){this.fromPoints(t)}};THREE.Path.prototype=Object.create(THREE.CurvePath.prototype);THREE.Path.prototype.constructor=THREE.Path;THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc",ELLIPSE:"ellipse"};THREE.Path.prototype.fromPoints=function(t){this.moveTo(t[0].x,t[0].y);for(var e=1,r=t.length;e<r;e++){this.lineTo(t[e].x,t[e].y)}};THREE.Path.prototype.moveTo=function(t,e){var r=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:r})};THREE.Path.prototype.lineTo=function(t,e){var r=Array.prototype.slice.call(arguments);var i=this.actions[this.actions.length-1].args;var n=i[i.length-2];var o=i[i.length-1];var s=new THREE.LineCurve(new THREE.Vector2(n,o),new THREE.Vector2(t,e));this.curves.push(s);this.actions.push({action:THREE.PathActions.LINE_TO,args:r})};THREE.Path.prototype.quadraticCurveTo=function(t,e,r,i){var n=Array.prototype.slice.call(arguments);var o=this.actions[this.actions.length-1].args;var s=o[o.length-2];var a=o[o.length-1];var u=new THREE.QuadraticBezierCurve(new THREE.Vector2(s,a),new THREE.Vector2(t,e),new THREE.Vector2(r,i));this.curves.push(u);this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:n})};THREE.Path.prototype.bezierCurveTo=function(t,e,r,i,n,o){var s=Array.prototype.slice.call(arguments);var a=this.actions[this.actions.length-1].args;var u=a[a.length-2];var l=a[a.length-1];var h=new THREE.CubicBezierCurve(new THREE.Vector2(u,l),new THREE.Vector2(t,e),new THREE.Vector2(r,i),new THREE.Vector2(n,o));this.curves.push(h);this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:s})};THREE.Path.prototype.splineThru=function(t){var e=Array.prototype.slice.call(arguments);var r=this.actions[this.actions.length-1].args;var i=r[r.length-2];var n=r[r.length-1];var o=[new THREE.Vector2(i,n)];Array.prototype.push.apply(o,t);var s=new THREE.SplineCurve(o);this.curves.push(s);this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:e})};THREE.Path.prototype.arc=function(t,e,r,i,n,o){var s=this.actions[this.actions.length-1].args;var a=s[s.length-2];var u=s[s.length-1];this.absarc(t+a,e+u,r,i,n,o)};THREE.Path.prototype.absarc=function(t,e,r,i,n,o){this.absellipse(t,e,r,r,i,n,o)};THREE.Path.prototype.ellipse=function(t,e,r,i,n,o,s){var a=this.actions[this.actions.length-1].args;var u=a[a.length-2];var l=a[a.length-1];this.absellipse(t+u,e+l,r,i,n,o,s)};THREE.Path.prototype.absellipse=function(t,e,r,i,n,o,s){var a=Array.prototype.slice.call(arguments);var u=new THREE.EllipseCurve(t,e,r,i,n,o,s);this.curves.push(u);var l=u.getPoint(1);a.push(l.x);a.push(l.y);this.actions.push({action:THREE.PathActions.ELLIPSE,args:a})};THREE.Path.prototype.getSpacedPoints=function(t,e){if(!t)t=40;var r=[];for(var i=0;i<t;i++){r.push(this.getPoint(i/t))}return r};THREE.Path.prototype.getPoints=function(t,e){if(this.useSpacedPoints){console.log("tata");return this.getSpacedPoints(t,e)}t=t||12;var r=[];var i,n,o,s,a;var u,l,h,f,c,p,d,m,v,g,y,E,_;for(i=0,n=this.actions.length;i<n;i++){o=this.actions[i];s=o.action;a=o.args;switch(s){case THREE.PathActions.MOVE_TO:r.push(new THREE.Vector2(a[0],a[1]));break;case THREE.PathActions.LINE_TO:r.push(new THREE.Vector2(a[0],a[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:u=a[2];l=a[3];c=a[0];p=a[1];if(r.length>0){v=r[r.length-1];d=v.x;m=v.y}else{v=this.actions[i-1].args;d=v[v.length-2];m=v[v.length-1]}for(g=1;g<=t;g++){y=g/t;E=THREE.Shape.Utils.b2(y,d,c,u);_=THREE.Shape.Utils.b2(y,m,p,l);r.push(new THREE.Vector2(E,_))}break;case THREE.PathActions.BEZIER_CURVE_TO:u=a[4];l=a[5];c=a[0];p=a[1];h=a[2];f=a[3];if(r.length>0){v=r[r.length-1];d=v.x;m=v.y}else{v=this.actions[i-1].args;d=v[v.length-2];m=v[v.length-1]}for(g=1;g<=t;g++){y=g/t;E=THREE.Shape.Utils.b3(y,d,c,h,u);_=THREE.Shape.Utils.b3(y,m,p,f,l);r.push(new THREE.Vector2(E,_))}break;case THREE.PathActions.CSPLINE_THRU:v=this.actions[i-1].args;var x=new THREE.Vector2(v[v.length-2],v[v.length-1]);var b=[x];var T=t*a[0].length;b=b.concat(a[0]);var w=new THREE.SplineCurve(b);for(g=1;g<=T;g++){r.push(w.getPointAt(g/T))}break;case THREE.PathActions.ARC:var R=a[0],H=a[1],M=a[2],S=a[3],k=a[4],A=!!a[5];var C=k-S;var L;var P=t*2;for(g=1;g<=P;g++){y=g/P;if(!A){y=1-y}L=S+y*C;E=R+M*Math.cos(L);_=H+M*Math.sin(L);r.push(new THREE.Vector2(E,_))}break;case THREE.PathActions.ELLIPSE:var R=a[0],H=a[1],z=a[2],D=a[3],S=a[4],k=a[5],A=!!a[6];var C=k-S;var L;var P=t*2;for(g=1;g<=P;g++){y=g/P;if(!A){y=1-y}L=S+y*C;E=R+z*Math.cos(L);_=H+D*Math.sin(L);r.push(new THREE.Vector2(E,_))}break}}var O=r[r.length-1];var F=1e-10;if(Math.abs(O.x-r[0].x)<F&&Math.abs(O.y-r[0].y)<F)r.splice(r.length-1,1);if(e){r.push(r[0])}return r};THREE.Path.prototype.toShapes=function(t,e){function r(t){var e,r,i,n,o;var s=[],a=new THREE.Path;for(e=0,r=t.length;e<r;e++){i=t[e];o=i.args;n=i.action;if(n==THREE.PathActions.MOVE_TO){if(a.actions.length!=0){s.push(a);a=new THREE.Path}}a[n].apply(a,o)}if(a.actions.length!=0){s.push(a)}return s}function i(t){var e=[];for(var r=0,i=t.length;r<i;r++){var n=t[r];var o=new THREE.Shape;o.actions=n.actions;o.curves=n.curves;e.push(o)}return e}function n(t,e){var r=1e-10;var i=e.length;var n=false;for(var o=i-1,s=0;s<i;o=s++){var a=e[o];var u=e[s];var l=u.x-a.x;var h=u.y-a.y;if(Math.abs(h)>r){if(h<0){a=e[s];l=-l;u=e[o];h=-h}if(t.y<a.y||t.y>u.y)continue;if(t.y==a.y){if(t.x==a.x)return true}else{var f=h*(t.x-a.x)-l*(t.y-a.y);if(f==0)return true;if(f<0)continue;n=!n}}else{if(t.y!=a.y)continue;if(u.x<=t.x&&t.x<=a.x||a.x<=t.x&&t.x<=u.x)return true}}return n}var o=r(this.actions);if(o.length==0)return[];if(e===true)return i(o);var s,a,u,l=[];if(o.length==1){a=o[0];u=new THREE.Shape;u.actions=a.actions;u.curves=a.curves;l.push(u);return l}var h=!THREE.Shape.Utils.isClockWise(o[0].getPoints());h=t?!h:h;var f=[];var c=[];var p=[];var d=0;var m;c[d]=undefined;p[d]=[];var v,g;for(v=0,g=o.length;v<g;v++){a=o[v];m=a.getPoints();s=THREE.Shape.Utils.isClockWise(m);s=t?!s:s;if(s){if(!h&&c[d])d++;c[d]={s:new THREE.Shape,p:m};c[d].s.actions=a.actions;c[d].s.curves=a.curves;if(h)d++;p[d]=[]}else{p[d].push({h:a,p:m[0]})}}if(!c[0])return i(o);if(c.length>1){var y=false;var E=[];for(var _=0,x=c.length;_<x;_++){f[_]=[]}for(var _=0,x=c.length;_<x;_++){var b=p[_];for(var T=0;T<b.length;T++){var w=b[T];var R=true;for(var H=0;H<c.length;H++){if(n(w.p,c[H].p)){if(_!=H)E.push({froms:_,tos:H,hole:T});if(R){R=false;f[H].push(w)}else{y=true}}}if(R){f[_].push(w)}}}if(E.length>0){if(!y)p=f}}var M,S,k;for(v=0,g=c.length;v<g;v++){u=c[v].s;l.push(u);M=p[v];for(S=0,k=M.length;S<k;S++){u.holes.push(M[S].h)}}return l};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=Object.create(THREE.Path.prototype);THREE.Shape.prototype.constructor=THREE.Shape;THREE.Shape.prototype.extrude=function(t){var e=new THREE.ExtrudeGeometry(this,t);return e};THREE.Shape.prototype.makeGeometry=function(t){var e=new THREE.ShapeGeometry(this,t);return e};THREE.Shape.prototype.getPointsHoles=function(t){var e,r=this.holes.length,i=[];for(e=0;e<r;e++){i[e]=this.holes[e].getTransformedPoints(t,this.bends)}return i};THREE.Shape.prototype.getSpacedPointsHoles=function(t){var e,r=this.holes.length,i=[];for(e=0;e<r;e++){i[e]=this.holes[e].getTransformedSpacedPoints(t,this.bends)}return i};THREE.Shape.prototype.extractAllPoints=function(t){return{shape:this.getTransformedPoints(t),holes:this.getPointsHoles(t)}};THREE.Shape.prototype.extractPoints=function(t){if(this.useSpacedPoints){return this.extractAllSpacedPoints(t)}return this.extractAllPoints(t)};THREE.Shape.prototype.extractAllSpacedPoints=function(t){return{shape:this.getTransformedSpacedPoints(t),holes:this.getSpacedPointsHoles(t)}};THREE.Shape.Utils={triangulateShape:function(t,e){function r(t,e,r){if(t.x!=e.x){if(t.x<e.x){return t.x<=r.x&&r.x<=e.x}else{return e.x<=r.x&&r.x<=t.x}}else{if(t.y<e.y){return t.y<=r.y&&r.y<=e.y}else{return e.y<=r.y&&r.y<=t.y}}}function i(t,e,i,n,o){var s=1e-10;var a=e.x-t.x,u=e.y-t.y;var l=n.x-i.x,h=n.y-i.y;var f=t.x-i.x;var c=t.y-i.y;var p=u*l-a*h;var d=u*f-a*c;if(Math.abs(p)>s){var m;if(p>0){if(d<0||d>p)return[];m=h*f-l*c;if(m<0||m>p)return[]}else{if(d>0||d<p)return[];m=h*f-l*c;if(m>0||m<p)return[]}if(m==0){if(o&&(d==0||d==p))return[];return[t]}if(m==p){if(o&&(d==0||d==p))return[];return[e]}if(d==0)return[i];if(d==p)return[n];var v=m/p;return[{x:t.x+v*a,y:t.y+v*u}]}else{if(d!=0||h*f!=l*c)return[];var g=a==0&&u==0;var y=l==0&&h==0;if(g&&y){if(t.x!=i.x||t.y!=i.y)return[];return[t]}if(g){if(!r(i,n,t))return[];return[t]}if(y){if(!r(t,e,i))return[];return[i]}var E,_,x,b;var T,w,R,H;if(a!=0){if(t.x<e.x){E=t;x=t.x;_=e;b=e.x}else{E=e;x=e.x;_=t;b=t.x}if(i.x<n.x){T=i;R=i.x;w=n;H=n.x}else{T=n;R=n.x;w=i;H=i.x}}else{if(t.y<e.y){E=t;x=t.y;_=e;b=e.y}else{E=e;x=e.y;_=t;b=t.y}if(i.y<n.y){T=i;R=i.y;w=n;H=n.y}else{T=n;R=n.y;w=i;H=i.y}}if(x<=R){if(b<R)return[];if(b==R){if(o)return[];return[T]}if(b<=H)return[T,_];return[T,w]}else{if(x>H)return[];if(x==H){if(o)return[];return[E]}if(b<=H)return[E,_];return[E,w]}}}function n(t,e,r,i){var n=1e-10;var o=e.x-t.x,s=e.y-t.y;var a=r.x-t.x,u=r.y-t.y;var l=i.x-t.x,h=i.y-t.y;var f=o*u-s*a;var c=o*h-s*l;if(Math.abs(f)>n){var p=l*u-h*a;if(f>0){return c>=0&&p>=0}else{return c>=0||p>=0}}else{return c>0}}function o(t,e){var r=t.concat();var o;function s(t,e){var i=r.length-1;var s=t-1;if(s<0)s=i;var a=t+1;if(a>i)a=0;var u=n(r[t],r[s],r[a],o[e]);if(!u){return false}var l=o.length-1;var h=e-1;if(h<0)h=l;var f=e+1;if(f>l)f=0;u=n(o[e],o[h],o[f],r[t]);if(!u){return false}return true}function a(t,e){var n,o,s;for(n=0;n<r.length;n++){o=n+1;o%=r.length;s=i(t,e,r[n],r[o],true);if(s.length>0)return true}return false}var u=[];function l(t,r){var n,o,s,a,l;for(n=0;n<u.length;n++){o=e[u[n]];for(s=0;s<o.length;s++){a=s+1;a%=o.length;l=i(t,r,o[s],o[a],true);if(l.length>0)return true}}return false}var h,f,c,p,d,m,v=[],g,y,E,_;for(var x=0,b=e.length;x<b;x++){u.push(x)}var T=0;var w=u.length*2;while(u.length>0){w--;if(w<0){console.log("Infinite Loop! Holes left:"+u.length+", Probably Hole outside Shape!");break}for(f=T;f<r.length;f++){c=r[f];h=-1;for(var x=0;x<u.length;x++){d=u[x];m=c.x+":"+c.y+":"+d;if(v[m]!==undefined)continue;o=e[d];for(var R=0;R<o.length;R++){p=o[R];if(!s(f,R))continue;if(a(c,p))continue;if(l(c,p))continue;h=R;u.splice(x,1);g=r.slice(0,f+1);y=r.slice(f);E=o.slice(h);_=o.slice(0,h+1);r=g.concat(E).concat(_).concat(y);T=f;break}if(h>=0)break;v[m]=true}if(h>=0)break}}return r}var s,a,u,l,h,f,c={};var p=t.concat();for(var d=0,m=e.length;d<m;d++){Array.prototype.push.apply(p,e[d])}for(s=0,a=p.length;s<a;s++){h=p[s].x+":"+p[s].y;if(c[h]!==undefined){THREE.warn("THREE.Shape: Duplicate point",h)}c[h]=s}var v=o(t,e);var g=THREE.FontUtils.Triangulate(v,false);for(s=0,a=g.length;s<a;s++){l=g[s];for(u=0;u<3;u++){h=l[u].x+":"+l[u].y;f=c[h];if(f!==undefined){l[u]=f}}}return g.concat()},isClockWise:function(t){return THREE.FontUtils.Triangulate.area(t)<0},b2p0:function(t,e){var r=1-t;return r*r*e},b2p1:function(t,e){return 2*(1-t)*t*e},b2p2:function(t,e){return t*t*e},b2:function(t,e,r,i){return this.b2p0(t,e)+this.b2p1(t,r)+this.b2p2(t,i)},b3p0:function(t,e){var r=1-t;return r*r*r*e},b3p1:function(t,e){var r=1-t;return 3*r*r*t*e},b3p2:function(t,e){var r=1-t;return 3*r*t*t*e},b3p3:function(t,e){return t*t*t*e},b3:function(t,e,r,i,n){return this.b3p0(t,e)+this.b3p1(t,r)+this.b3p2(t,i)+this.b3p3(t,n)}};THREE.LineCurve=function(t,e){this.v1=t;this.v2=e};THREE.LineCurve.prototype=Object.create(THREE.Curve.prototype);THREE.LineCurve.prototype.constructor=THREE.LineCurve;THREE.LineCurve.prototype.getPoint=function(t){var e=this.v2.clone().sub(this.v1);e.multiplyScalar(t).add(this.v1);return e};THREE.LineCurve.prototype.getPointAt=function(t){return this.getPoint(t)};THREE.LineCurve.prototype.getTangent=function(t){var e=this.v2.clone().sub(this.v1);return e.normalize()};THREE.QuadraticBezierCurve=function(t,e,r){this.v0=t;this.v1=e;this.v2=r};THREE.QuadraticBezierCurve.prototype=Object.create(THREE.Curve.prototype);THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;THREE.QuadraticBezierCurve.prototype.getPoint=function(t){var e=new THREE.Vector2;e.x=THREE.Shape.Utils.b2(t,this.v0.x,this.v1.x,this.v2.x);e.y=THREE.Shape.Utils.b2(t,this.v0.y,this.v1.y,this.v2.y);return e};THREE.QuadraticBezierCurve.prototype.getTangent=function(t){var e=new THREE.Vector2;e.x=THREE.Curve.Utils.tangentQuadraticBezier(t,this.v0.x,this.v1.x,this.v2.x);e.y=THREE.Curve.Utils.tangentQuadraticBezier(t,this.v0.y,this.v1.y,this.v2.y);return e.normalize()};THREE.CubicBezierCurve=function(t,e,r,i){this.v0=t;this.v1=e;this.v2=r;this.v3=i};THREE.CubicBezierCurve.prototype=Object.create(THREE.Curve.prototype);THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;THREE.CubicBezierCurve.prototype.getPoint=function(t){var e,r;e=THREE.Shape.Utils.b3(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x);r=THREE.Shape.Utils.b3(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(e,r)};THREE.CubicBezierCurve.prototype.getTangent=function(t){var e,r;e=THREE.Curve.Utils.tangentCubicBezier(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x);r=THREE.Curve.Utils.tangentCubicBezier(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y);var i=new THREE.Vector2(e,r);i.normalize();return i};THREE.SplineCurve=function(t){this.points=t==undefined?[]:t};THREE.SplineCurve.prototype=Object.create(THREE.Curve.prototype);THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;THREE.SplineCurve.prototype.getPoint=function(t){var e=this.points;var r=(e.length-1)*t;var i=Math.floor(r);var n=r-i;var o=e[i==0?i:i-1];var s=e[i];var a=e[i>e.length-2?e.length-1:i+1];var u=e[i>e.length-3?e.length-1:i+2];var l=new THREE.Vector2;l.x=THREE.Curve.Utils.interpolate(o.x,s.x,a.x,u.x,n);l.y=THREE.Curve.Utils.interpolate(o.y,s.y,a.y,u.y,n);return l};THREE.EllipseCurve=function(t,e,r,i,n,o,s){this.aX=t;this.aY=e;this.xRadius=r;this.yRadius=i;this.aStartAngle=n;this.aEndAngle=o;this.aClockwise=s};THREE.EllipseCurve.prototype=Object.create(THREE.Curve.prototype);THREE.EllipseCurve.prototype.constructor=THREE.EllipseCurve;THREE.EllipseCurve.prototype.getPoint=function(t){var e=this.aEndAngle-this.aStartAngle;if(e<0)e+=Math.PI*2;if(e>Math.PI*2)e-=Math.PI*2;var r;if(this.aClockwise===true){r=this.aEndAngle+(1-t)*(Math.PI*2-e)}else{r=this.aStartAngle+t*e}var i=new THREE.Vector2;i.x=this.aX+this.xRadius*Math.cos(r);i.y=this.aY+this.yRadius*Math.sin(r);return i};THREE.ArcCurve=function(t,e,r,i,n,o){THREE.EllipseCurve.call(this,t,e,r,r,i,n,o)};THREE.ArcCurve.prototype=Object.create(THREE.EllipseCurve.prototype);THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.LineCurve3=THREE.Curve.create(function(t,e){this.v1=t;this.v2=e},function(t){var e=new THREE.Vector3;e.subVectors(this.v2,this.v1);e.multiplyScalar(t);e.add(this.v1);return e});THREE.QuadraticBezierCurve3=THREE.Curve.create(function(t,e,r){this.v0=t;this.v1=e;this.v2=r},function(t){var e=new THREE.Vector3;e.x=THREE.Shape.Utils.b2(t,this.v0.x,this.v1.x,this.v2.x);e.y=THREE.Shape.Utils.b2(t,this.v0.y,this.v1.y,this.v2.y);e.z=THREE.Shape.Utils.b2(t,this.v0.z,this.v1.z,this.v2.z);return e});THREE.CubicBezierCurve3=THREE.Curve.create(function(t,e,r,i){this.v0=t;this.v1=e;this.v2=r;this.v3=i},function(t){var e=new THREE.Vector3;e.x=THREE.Shape.Utils.b3(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x);e.y=THREE.Shape.Utils.b3(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y);e.z=THREE.Shape.Utils.b3(t,this.v0.z,this.v1.z,this.v2.z,this.v3.z);return e});THREE.SplineCurve3=THREE.Curve.create(function(t){this.points=t==undefined?[]:t},function(t){var e=this.points;var r=(e.length-1)*t;var i=Math.floor(r);var n=r-i;var o=e[i==0?i:i-1];var s=e[i];var a=e[i>e.length-2?e.length-1:i+1];var u=e[i>e.length-3?e.length-1:i+2];var l=new THREE.Vector3;l.x=THREE.Curve.Utils.interpolate(o.x,s.x,a.x,u.x,n);l.y=THREE.Curve.Utils.interpolate(o.y,s.y,a.y,u.y,n);l.z=THREE.Curve.Utils.interpolate(o.z,s.z,a.z,u.z,n);return l});THREE.ClosedSplineCurve3=THREE.Curve.create(function(t){this.points=t==undefined?[]:t},function(t){var e=this.points;var r=(e.length-0)*t;var i=Math.floor(r);var n=r-i;i+=i>0?0:(Math.floor(Math.abs(i)/e.length)+1)*e.length;var o=e[(i-1)%e.length];var s=e[i%e.length];var a=e[(i+1)%e.length];var u=e[(i+2)%e.length];var l=new THREE.Vector3;l.x=THREE.Curve.Utils.interpolate(o.x,s.x,a.x,u.x,n);l.y=THREE.Curve.Utils.interpolate(o.y,s.y,a.y,u.y,n);l.z=THREE.Curve.Utils.interpolate(o.z,s.z,a.z,u.z,n);return l});THREE.AnimationHandler={LINEAR:0,CATMULLROM:1,CATMULLROM_FORWARD:2,add:function(){THREE.warn("THREE.AnimationHandler.add() has been deprecated.")},get:function(){THREE.warn("THREE.AnimationHandler.get() has been deprecated.")},remove:function(){THREE.warn("THREE.AnimationHandler.remove() has been deprecated.")},animations:[],init:function(t){if(t.initialized===true)return t;for(var e=0;e<t.hierarchy.length;e++){for(var r=0;r<t.hierarchy[e].keys.length;r++){if(t.hierarchy[e].keys[r].time<0){t.hierarchy[e].keys[r].time=0}if(t.hierarchy[e].keys[r].rot!==undefined&&!(t.hierarchy[e].keys[r].rot instanceof THREE.Quaternion)){var i=t.hierarchy[e].keys[r].rot;t.hierarchy[e].keys[r].rot=(new THREE.Quaternion).fromArray(i)}}if(t.hierarchy[e].keys.length&&t.hierarchy[e].keys[0].morphTargets!==undefined){var n={};for(var r=0;r<t.hierarchy[e].keys.length;r++){for(var o=0;o<t.hierarchy[e].keys[r].morphTargets.length;o++){var s=t.hierarchy[e].keys[r].morphTargets[o];n[s]=-1}}t.hierarchy[e].usedMorphTargets=n;for(var r=0;r<t.hierarchy[e].keys.length;r++){var a={};for(var s in n){for(var o=0;o<t.hierarchy[e].keys[r].morphTargets.length;o++){if(t.hierarchy[e].keys[r].morphTargets[o]===s){a[s]=t.hierarchy[e].keys[r].morphTargetsInfluences[o];break}}if(o===t.hierarchy[e].keys[r].morphTargets.length){a[s]=0}}t.hierarchy[e].keys[r].morphTargetsInfluences=a}}for(var r=1;r<t.hierarchy[e].keys.length;r++){if(t.hierarchy[e].keys[r].time===t.hierarchy[e].keys[r-1].time){t.hierarchy[e].keys.splice(r,1);r--}}for(var r=0;r<t.hierarchy[e].keys.length;r++){t.hierarchy[e].keys[r].index=r}}t.initialized=true;return t},parse:function(t){var e=function(t,r){r.push(t);for(var i=0;i<t.children.length;i++)e(t.children[i],r)};var r=[];if(t instanceof THREE.SkinnedMesh){for(var i=0;i<t.skeleton.bones.length;i++){r.push(t.skeleton.bones[i])}}else{e(t,r)}return r},play:function(t){if(this.animations.indexOf(t)===-1){this.animations.push(t)}},stop:function(t){var e=this.animations.indexOf(t);if(e!==-1){this.animations.splice(e,1)}},update:function(t){for(var e=0;e<this.animations.length;e++){this.animations[e].resetBlendWeights()}for(var e=0;e<this.animations.length;e++){this.animations[e].update(t)}}};THREE.Animation=function(t,e){this.root=t;this.data=THREE.AnimationHandler.init(e);this.hierarchy=THREE.AnimationHandler.parse(t);this.currentTime=0;this.timeScale=1;this.isPlaying=false;this.loop=true;this.weight=0;this.interpolationType=THREE.AnimationHandler.LINEAR};THREE.Animation.prototype={constructor:THREE.Animation,keyTypes:["pos","rot","scl"],play:function(t,e){this.currentTime=t!==undefined?t:0;this.weight=e!==undefined?e:1;this.isPlaying=true;this.reset();THREE.AnimationHandler.play(this)},stop:function(){this.isPlaying=false;THREE.AnimationHandler.stop(this)},reset:function(){for(var t=0,e=this.hierarchy.length;t<e;t++){var r=this.hierarchy[t];if(r.animationCache===undefined){r.animationCache={animations:{},blending:{positionWeight:0,quaternionWeight:0,scaleWeight:0}}}var i=this.data.name;var n=r.animationCache.animations;var o=n[i];if(o===undefined){o={prevKey:{pos:0,rot:0,scl:0},nextKey:{pos:0,rot:0,scl:0},originalMatrix:r.matrix};n[i]=o}for(var s=0;s<3;s++){var a=this.keyTypes[s];var u=this.data.hierarchy[t].keys[0];var l=this.getNextKeyWith(a,t,1);while(l.time<this.currentTime&&l.index>u.index){u=l;l=this.getNextKeyWith(a,t,l.index+1)}o.prevKey[a]=u;o.nextKey[a]=l}}},resetBlendWeights:function(){for(var t=0,e=this.hierarchy.length;t<e;t++){var r=this.hierarchy[t];var i=r.animationCache;if(i!==undefined){var n=i.blending;n.positionWeight=0;n.quaternionWeight=0;n.scaleWeight=0}}},update:function(){var t=[];var e=new THREE.Vector3;var r=new THREE.Vector3;var i=new THREE.Quaternion;var n=function(t,e){var r=[],i=[],n,s,a,u,l,h,f,c,p;n=(t.length-1)*e;s=Math.floor(n);a=n-s;r[0]=s===0?s:s-1;r[1]=s;r[2]=s>t.length-2?s:s+1;r[3]=s>t.length-3?s:s+2;h=t[r[0]];f=t[r[1]];c=t[r[2]];p=t[r[3]];u=a*a;l=a*u;i[0]=o(h[0],f[0],c[0],p[0],a,u,l);i[1]=o(h[1],f[1],c[1],p[1],a,u,l);i[2]=o(h[2],f[2],c[2],p[2],a,u,l);return i};var o=function(t,e,r,i,n,o,s){var a=(r-t)*.5,u=(i-e)*.5;return(2*(e-r)+a+u)*s+(-3*(e-r)-2*a-u)*o+a*n+e};return function(o){if(this.isPlaying===false)return;this.currentTime+=o*this.timeScale;if(this.weight===0)return;var s=this.data.length;if(this.currentTime>s||this.currentTime<0){if(this.loop){this.currentTime%=s;if(this.currentTime<0)this.currentTime+=s;this.reset()}else{this.stop()}}for(var a=0,u=this.hierarchy.length;a<u;a++){var l=this.hierarchy[a];var h=l.animationCache.animations[this.data.name];var f=l.animationCache.blending;for(var c=0;c<3;c++){var p=this.keyTypes[c];var d=h.prevKey[p];var m=h.nextKey[p];if(this.timeScale>0&&m.time<=this.currentTime||this.timeScale<0&&d.time>=this.currentTime){d=this.data.hierarchy[a].keys[0];m=this.getNextKeyWith(p,a,1);while(m.time<this.currentTime&&m.index>d.index){d=m;m=this.getNextKeyWith(p,a,m.index+1)}h.prevKey[p]=d;h.nextKey[p]=m}var v=(this.currentTime-d.time)/(m.time-d.time);var g=d[p];var y=m[p];if(v<0)v=0;if(v>1)v=1;if(p==="pos"){if(this.interpolationType===THREE.AnimationHandler.LINEAR){r.x=g[0]+(y[0]-g[0])*v;r.y=g[1]+(y[1]-g[1])*v;r.z=g[2]+(y[2]-g[2])*v;var E=this.weight/(this.weight+f.positionWeight);l.position.lerp(r,E);f.positionWeight+=this.weight}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){t[0]=this.getPrevKeyWith("pos",a,d.index-1)["pos"];t[1]=g;t[2]=y;t[3]=this.getNextKeyWith("pos",a,m.index+1)["pos"];v=v*.33+.33;var _=n(t,v);var E=this.weight/(this.weight+f.positionWeight);f.positionWeight+=this.weight;var x=l.position;x.x=x.x+(_[0]-x.x)*E;x.y=x.y+(_[1]-x.y)*E;x.z=x.z+(_[2]-x.z)*E;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){var b=n(t,v*1.01);e.set(b[0],b[1],b[2]);e.sub(x);e.y=0;e.normalize();var T=Math.atan2(e.x,e.z);l.rotation.set(0,T,0)}}}else if(p==="rot"){THREE.Quaternion.slerp(g,y,i,v);if(f.quaternionWeight===0){l.quaternion.copy(i);f.quaternionWeight=this.weight}else{var E=this.weight/(this.weight+f.quaternionWeight);THREE.Quaternion.slerp(l.quaternion,i,l.quaternion,E);f.quaternionWeight+=this.weight}}else if(p==="scl"){r.x=g[0]+(y[0]-g[0])*v;r.y=g[1]+(y[1]-g[1])*v;r.z=g[2]+(y[2]-g[2])*v;var E=this.weight/(this.weight+f.scaleWeight);l.scale.lerp(r,E);f.scaleWeight+=this.weight}}}return true}}(),getNextKeyWith:function(t,e,r){var i=this.data.hierarchy[e].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){r=r<i.length-1?r:i.length-1}else{r=r%i.length}for(;r<i.length;r++){if(i[r][t]!==undefined){return i[r]}}return this.data.hierarchy[e].keys[0]},getPrevKeyWith:function(t,e,r){var i=this.data.hierarchy[e].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){r=r>0?r:0}else{r=r>=0?r:r+i.length}for(;r>=0;r--){if(i[r][t]!==undefined){return i[r]}}return this.data.hierarchy[e].keys[i.length-1]}};THREE.KeyFrameAnimation=function(t){this.root=t.node;this.data=THREE.AnimationHandler.init(t);this.hierarchy=THREE.AnimationHandler.parse(this.root);this.currentTime=0;this.timeScale=.001;this.isPlaying=false;this.isPaused=true;this.loop=true;for(var e=0,r=this.hierarchy.length;e<r;e++){var i=this.data.hierarchy[e].keys,n=this.data.hierarchy[e].sids,o=this.hierarchy[e];if(i.length&&n){for(var s=0;s<n.length;s++){var a=n[s],u=this.getNextKeyWith(a,e,0);if(u){u.apply(a)}}o.matrixAutoUpdate=false;this.data.hierarchy[e].node.updateMatrix();o.matrixWorldNeedsUpdate=true}}};THREE.KeyFrameAnimation.prototype={constructor:THREE.KeyFrameAnimation,play:function(t){this.currentTime=t!==undefined?t:0;if(this.isPlaying===false){this.isPlaying=true;var e,r=this.hierarchy.length,i,n;for(e=0;e<r;e++){i=this.hierarchy[e];n=this.data.hierarchy[e];if(n.animationCache===undefined){n.animationCache={};n.animationCache.prevKey=null;n.animationCache.nextKey=null;n.animationCache.originalMatrix=i.matrix}var o=this.data.hierarchy[e].keys;if(o.length){n.animationCache.prevKey=o[0];n.animationCache.nextKey=o[1];this.startTime=Math.min(o[0].time,this.startTime);this.endTime=Math.max(o[o.length-1].time,this.endTime)}}this.update(0)}this.isPaused=false;THREE.AnimationHandler.play(this)},stop:function(){this.isPlaying=false;this.isPaused=false;THREE.AnimationHandler.stop(this);for(var t=0;t<this.data.hierarchy.length;t++){var e=this.hierarchy[t];var r=this.data.hierarchy[t];if(r.animationCache!==undefined){var i=r.animationCache.originalMatrix;i.copy(e.matrix);e.matrix=i;delete r.animationCache}}},update:function(t){if(this.isPlaying===false)return;this.currentTime+=t*this.timeScale;var e=this.data.length;if(this.loop===true&&this.currentTime>e){this.currentTime%=e}this.currentTime=Math.min(this.currentTime,e);for(var r=0,i=this.hierarchy.length;r<i;r++){var n=this.hierarchy[r];var o=this.data.hierarchy[r];var s=o.keys,a=o.animationCache;if(s.length){var u=a.prevKey;var l=a.nextKey;if(l.time<=this.currentTime){while(l.time<this.currentTime&&l.index>u.index){u=l;l=s[u.index+1]}a.prevKey=u;a.nextKey=l}if(l.time>=this.currentTime){u.interpolate(l,this.currentTime)}else{u.interpolate(l,l.time)}this.data.hierarchy[r].node.updateMatrix();n.matrixWorldNeedsUpdate=true}}},getNextKeyWith:function(t,e,r){var i=this.data.hierarchy[e].keys;r=r%i.length;for(;r<i.length;r++){if(i[r].hasTarget(t)){return i[r]}}return i[0]},getPrevKeyWith:function(t,e,r){var i=this.data.hierarchy[e].keys;r=r>=0?r:r+i.length;for(;r>=0;r--){if(i[r].hasTarget(t)){return i[r]}}return i[i.length-1]}};THREE.MorphAnimation=function(t){this.mesh=t;this.frames=t.morphTargetInfluences.length;this.currentTime=0;this.duration=1e3;this.loop=true;this.lastFrame=0;this.currentFrame=0;this.isPlaying=false};THREE.MorphAnimation.prototype={constructor:THREE.MorphAnimation,play:function(){this.isPlaying=true},pause:function(){this.isPlaying=false},update:function(t){if(this.isPlaying===false)return;this.currentTime+=t;if(this.loop===true&&this.currentTime>this.duration){this.currentTime%=this.duration}this.currentTime=Math.min(this.currentTime,this.duration);var e=this.duration/this.frames;var r=Math.floor(this.currentTime/e);var i=this.mesh.morphTargetInfluences;if(r!=this.currentFrame){i[this.lastFrame]=0;i[this.currentFrame]=1;i[r]=0;this.lastFrame=this.currentFrame;this.currentFrame=r}i[r]=this.currentTime%e/e;i[this.lastFrame]=1-i[r]}};THREE.BoxGeometry=function(t,e,r,i,n,o){THREE.Geometry.call(this);this.type="BoxGeometry";this.parameters={width:t,height:e,depth:r,widthSegments:i,heightSegments:n,depthSegments:o};this.widthSegments=i||1;this.heightSegments=n||1;this.depthSegments=o||1;var s=this;var a=t/2;var u=e/2;var l=r/2;h("z","y",-1,-1,r,e,a,0);h("z","y",1,-1,r,e,-a,1);h("x","z",1,1,t,r,u,2);h("x","z",1,-1,t,r,-u,3);h("x","y",1,-1,t,e,l,4);h("x","y",-1,-1,t,e,-l,5);function h(t,e,r,i,n,o,a,u){var l,h,f,c=s.widthSegments,p=s.heightSegments,d=n/2,m=o/2,v=s.vertices.length;if(t==="x"&&e==="y"||t==="y"&&e==="x"){l="z"}else if(t==="x"&&e==="z"||t==="z"&&e==="x"){l="y";p=s.depthSegments}else if(t==="z"&&e==="y"||t==="y"&&e==="z"){l="x";c=s.depthSegments}var g=c+1,y=p+1,E=n/c,_=o/p,x=new THREE.Vector3;x[l]=a>0?1:-1;for(f=0;f<y;f++){for(h=0;h<g;h++){var b=new THREE.Vector3;b[t]=(h*E-d)*r;b[e]=(f*_-m)*i;b[l]=a;s.vertices.push(b)}}for(f=0;f<p;f++){for(h=0;h<c;h++){var T=h+g*f;var w=h+g*(f+1);var R=h+1+g*(f+1);var H=h+1+g*f;var M=new THREE.Vector2(h/c,1-f/p);var S=new THREE.Vector2(h/c,1-(f+1)/p);var k=new THREE.Vector2((h+1)/c,1-(f+1)/p);var A=new THREE.Vector2((h+1)/c,1-f/p);var C=new THREE.Face3(T+v,w+v,H+v);C.normal.copy(x);C.vertexNormals.push(x.clone(),x.clone(),x.clone());C.materialIndex=u;s.faces.push(C);s.faceVertexUvs[0].push([M,S,A]);C=new THREE.Face3(w+v,R+v,H+v);C.normal.copy(x);C.vertexNormals.push(x.clone(),x.clone(),x.clone());C.materialIndex=u;s.faces.push(C);s.faceVertexUvs[0].push([S.clone(),k,A.clone()])}}}this.mergeVertices()};THREE.BoxGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.BoxGeometry.prototype.constructor=THREE.BoxGeometry;THREE.CircleGeometry=function(t,e,r,i){THREE.Geometry.call(this);this.type="CircleGeometry";this.parameters={radius:t,segments:e,thetaStart:r,thetaLength:i};t=t||50;e=e!==undefined?Math.max(3,e):8;r=r!==undefined?r:0;i=i!==undefined?i:Math.PI*2;var n,o=[],s=new THREE.Vector3,a=new THREE.Vector2(.5,.5);this.vertices.push(s);o.push(a);for(n=0;n<=e;n++){var u=new THREE.Vector3;var l=r+n/e*i;u.x=t*Math.cos(l);u.y=t*Math.sin(l);this.vertices.push(u);o.push(new THREE.Vector2((u.x/t+1)/2,(u.y/t+1)/2))}var h=new THREE.Vector3(0,0,1);for(n=1;n<=e;n++){this.faces.push(new THREE.Face3(n,n+1,0,[h.clone(),h.clone(),h.clone()]));this.faceVertexUvs[0].push([o[n].clone(),o[n+1].clone(),a.clone()])}this.computeFaceNormals();this.boundingSphere=new THREE.Sphere(new THREE.Vector3,t)};THREE.CircleGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.CircleGeometry.prototype.constructor=THREE.CircleGeometry;THREE.CubeGeometry=function(t,e,r,i,n,o){THREE.warn("THREE.CubeGeometry has been renamed to THREE.BoxGeometry.");return new THREE.BoxGeometry(t,e,r,i,n,o)};THREE.CylinderGeometry=function(t,e,r,i,n,o,s,a){THREE.Geometry.call(this);this.type="CylinderGeometry";this.parameters={radiusTop:t,radiusBottom:e,height:r,radialSegments:i,heightSegments:n,openEnded:o,thetaStart:s,thetaLength:a};t=t!==undefined?t:20;e=e!==undefined?e:20;r=r!==undefined?r:100;i=i||8;n=n||1;o=o!==undefined?o:false;s=s!==undefined?s:0;a=a!==undefined?a:2*Math.PI;var u=r/2;var l,h,f=[],c=[];for(h=0;h<=n;h++){var p=[];var d=[];var m=h/n;var v=m*(e-t)+t;for(l=0;l<=i;l++){var g=l/i;var y=new THREE.Vector3;y.x=v*Math.sin(g*a+s);y.y=-m*r+u;y.z=v*Math.cos(g*a+s);this.vertices.push(y);p.push(this.vertices.length-1);d.push(new THREE.Vector2(g,1-m))}f.push(p);c.push(d)}var E=(e-t)/r;var _,x;for(l=0;l<i;l++){if(t!==0){_=this.vertices[f[0][l]].clone();x=this.vertices[f[0][l+1]].clone()}else{_=this.vertices[f[1][l]].clone();x=this.vertices[f[1][l+1]].clone()}_.setY(Math.sqrt(_.x*_.x+_.z*_.z)*E).normalize();x.setY(Math.sqrt(x.x*x.x+x.z*x.z)*E).normalize();for(h=0;h<n;h++){var b=f[h][l];var T=f[h+1][l];var w=f[h+1][l+1];var R=f[h][l+1];var H=_.clone();var M=_.clone();var S=x.clone();var k=x.clone();var A=c[h][l].clone();var C=c[h+1][l].clone();var L=c[h+1][l+1].clone();var P=c[h][l+1].clone();this.faces.push(new THREE.Face3(b,T,R,[H,M,k]));this.faceVertexUvs[0].push([A,C,P]);this.faces.push(new THREE.Face3(T,w,R,[M.clone(),S,k.clone()]));this.faceVertexUvs[0].push([C.clone(),L,P.clone()])}}if(o===false&&t>0){this.vertices.push(new THREE.Vector3(0,u,0));for(l=0;l<i;l++){var b=f[0][l];var T=f[0][l+1];var w=this.vertices.length-1;var H=new THREE.Vector3(0,1,0);var M=new THREE.Vector3(0,1,0);var S=new THREE.Vector3(0,1,0);var A=c[0][l].clone();var C=c[0][l+1].clone();var L=new THREE.Vector2(C.x,0);this.faces.push(new THREE.Face3(b,T,w,[H,M,S]));this.faceVertexUvs[0].push([A,C,L])}}if(o===false&&e>0){this.vertices.push(new THREE.Vector3(0,-u,0));for(l=0;l<i;l++){var b=f[n][l+1];var T=f[n][l];var w=this.vertices.length-1;var H=new THREE.Vector3(0,-1,0);var M=new THREE.Vector3(0,-1,0);var S=new THREE.Vector3(0,-1,0);var A=c[n][l+1].clone();var C=c[n][l].clone();var L=new THREE.Vector2(C.x,1);this.faces.push(new THREE.Face3(b,T,w,[H,M,S]));this.faceVertexUvs[0].push([A,C,L])}}this.computeFaceNormals()};THREE.CylinderGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;THREE.ExtrudeGeometry=function(t,e){if(typeof t==="undefined"){t=[];return}THREE.Geometry.call(this);this.type="ExtrudeGeometry";t=t instanceof Array?t:[t];this.addShapeList(t,e);this.computeFaceNormals()};THREE.ExtrudeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;THREE.ExtrudeGeometry.prototype.addShapeList=function(t,e){var r=t.length;for(var i=0;i<r;i++){var n=t[i];this.addShape(n,e)}};THREE.ExtrudeGeometry.prototype.addShape=function(t,e){var r=e.amount!==undefined?e.amount:100;var i=e.bevelThickness!==undefined?e.bevelThickness:6;var n=e.bevelSize!==undefined?e.bevelSize:i-2;var o=e.bevelSegments!==undefined?e.bevelSegments:3;var s=e.bevelEnabled!==undefined?e.bevelEnabled:true;var a=e.curveSegments!==undefined?e.curveSegments:12;var u=e.steps!==undefined?e.steps:1;var l=e.extrudePath;var h,f=false;var c=e.material;var p=e.extrudeMaterial;var d=e.UVGenerator!==undefined?e.UVGenerator:THREE.ExtrudeGeometry.WorldUVGenerator;var m,v,g,y;if(l){h=l.getSpacedPoints(u);f=true;s=false;m=e.frames!==undefined?e.frames:new THREE.TubeGeometry.FrenetFrames(l,u,false);v=new THREE.Vector3;g=new THREE.Vector3;y=new THREE.Vector3}if(!s){o=0;i=0;n=0}var E,_,x;var b=this;var T=this.vertices.length;var w=t.extractPoints(a);var R=w.shape;var H=w.holes;var M=!THREE.Shape.Utils.isClockWise(R);if(M){R=R.reverse();for(_=0,x=H.length;_<x;_++){E=H[_];if(THREE.Shape.Utils.isClockWise(E)){H[_]=E.reverse()}}M=false}var S=THREE.Shape.Utils.triangulateShape(R,H);var k=R;for(_=0,x=H.length;_<x;_++){E=H[_];R=R.concat(E)}function A(t,e,r){if(!e)THREE.error("THREE.ExtrudeGeometry: vec does not exist");return e.clone().multiplyScalar(r).add(t)}var C,L,P,z,D,O=R.length,F,U=S.length;function B(t,e,r){var i=1e-10;var n,o,s=1;var a=t.x-e.x,u=t.y-e.y;var l=r.x-t.x,h=r.y-t.y;var f=a*a+u*u;var c=a*h-u*l;if(Math.abs(c)>i){var p=Math.sqrt(f);var d=Math.sqrt(l*l+h*h);var m=e.x-u/p;var v=e.y+a/p;var g=r.x-h/d;var y=r.y+l/d;var E=((g-m)*h-(y-v)*l)/(a*h-u*l);n=m+a*E-t.x;o=v+u*E-t.y;var _=n*n+o*o;if(_<=2){return new THREE.Vector2(n,o)}else{s=Math.sqrt(_/2)}}else{var x=false;if(a>i){if(l>i){x=true}}else{if(a<-i){if(l<-i){x=true}}else{if(Math.sign(u)==Math.sign(h)){x=true}}}if(x){n=-u;o=a;s=Math.sqrt(f)}else{n=a;o=u;s=Math.sqrt(f/2)}}return new THREE.Vector2(n/s,o/s)}var V=[];for(var N=0,I=k.length,j=I-1,G=N+1;N<I;N++,j++,G++){if(j===I)j=0;if(G===I)G=0;V[N]=B(k[N],k[j],k[G])}var W=[],X,q=V.concat();for(_=0,x=H.length;_<x;_++){E=H[_];X=[];for(N=0,I=E.length,j=I-1,G=N+1;N<I;N++,j++,G++){if(j===I)j=0;if(G===I)G=0;X[N]=B(E[N],E[j],E[G])}W.push(X);q=q.concat(X)}for(C=0;C<o;C++){P=C/o;z=i*(1-P);L=n*Math.sin(P*Math.PI/2);for(N=0,I=k.length;N<I;N++){D=A(k[N],V[N],L);J(D.x,D.y,-z)}for(_=0,x=H.length;_<x;_++){E=H[_];X=W[_];for(N=0,I=E.length;N<I;N++){D=A(E[N],X[N],L);J(D.x,D.y,-z)}}}L=n;for(N=0;N<O;N++){D=s?A(R[N],q[N],L):R[N];if(!f){J(D.x,D.y,0)}else{g.copy(m.normals[0]).multiplyScalar(D.x);v.copy(m.binormals[0]).multiplyScalar(D.y);y.copy(h[0]).add(g).add(v);J(y.x,y.y,y.z)}}var Y;for(Y=1;Y<=u;Y++){for(N=0;N<O;N++){D=s?A(R[N],q[N],L):R[N];if(!f){J(D.x,D.y,r/u*Y)}else{g.copy(m.normals[Y]).multiplyScalar(D.x);v.copy(m.binormals[Y]).multiplyScalar(D.y);y.copy(h[Y]).add(g).add(v);J(y.x,y.y,y.z)}}}for(C=o-1;C>=0;C--){P=C/o;z=i*(1-P);L=n*Math.sin(P*Math.PI/2);for(N=0,I=k.length;N<I;N++){D=A(k[N],V[N],L);J(D.x,D.y,r+z)}for(_=0,x=H.length;_<x;_++){E=H[_];X=W[_];for(N=0,I=E.length;N<I;N++){D=A(E[N],X[N],L);if(!f){J(D.x,D.y,r+z)}else{J(D.x,D.y+h[u-1].y,h[u-1].x+z)}}}}Z();K();function Z(){if(s){var t=0;var e=O*t;for(N=0;N<U;N++){F=S[N];$(F[2]+e,F[1]+e,F[0]+e)}t=u+o*2;e=O*t;for(N=0;N<U;N++){F=S[N];$(F[0]+e,F[1]+e,F[2]+e)}}else{for(N=0;N<U;N++){F=S[N];$(F[2],F[1],F[0])}for(N=0;N<U;N++){F=S[N];$(F[0]+O*u,F[1]+O*u,F[2]+O*u)}}}function K(){var t=0;Q(k,t);t+=k.length;for(_=0,x=H.length;_<x;_++){E=H[_];Q(E,t);t+=E.length}}function Q(t,e){var r,i;N=t.length;while(--N>=0){r=N;i=N-1;if(i<0)i=t.length-1;var n=0,s=u+o*2;for(n=0;n<s;n++){var a=O*n;var l=O*(n+1);var h=e+r+a,f=e+i+a,c=e+i+l,p=e+r+l;tt(h,f,c,p,t,n,s,r,i)}}}function J(t,e,r){b.vertices.push(new THREE.Vector3(t,e,r))}function $(t,e,r){t+=T;e+=T;r+=T;b.faces.push(new THREE.Face3(t,e,r,null,null,c));var i=d.generateTopUV(b,t,e,r);b.faceVertexUvs[0].push(i)}function tt(t,e,r,i,n,o,s,a,u){t+=T;e+=T;r+=T;i+=T;b.faces.push(new THREE.Face3(t,e,i,null,null,p));b.faces.push(new THREE.Face3(e,r,i,null,null,p));var l=d.generateSideWallUV(b,t,e,r,i);b.faceVertexUvs[0].push([l[0],l[1],l[3]]);b.faceVertexUvs[0].push([l[1],l[2],l[3]])}};THREE.ExtrudeGeometry.WorldUVGenerator={generateTopUV:function(t,e,r,i){var n=t.vertices;var o=n[e];var s=n[r];var a=n[i];return[new THREE.Vector2(o.x,o.y),new THREE.Vector2(s.x,s.y),new THREE.Vector2(a.x,a.y)]},generateSideWallUV:function(t,e,r,i,n){var o=t.vertices;var s=o[e];var a=o[r];var u=o[i];var l=o[n];if(Math.abs(s.y-a.y)<.01){return[new THREE.Vector2(s.x,1-s.z),new THREE.Vector2(a.x,1-a.z),new THREE.Vector2(u.x,1-u.z),new THREE.Vector2(l.x,1-l.z)]}else{return[new THREE.Vector2(s.y,1-s.z),new THREE.Vector2(a.y,1-a.z),new THREE.Vector2(u.y,1-u.z),new THREE.Vector2(l.y,1-l.z)]}}};THREE.ShapeGeometry=function(t,e){THREE.Geometry.call(this);this.type="ShapeGeometry";if(t instanceof Array===false)t=[t];this.addShapeList(t,e);this.computeFaceNormals()};THREE.ShapeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ShapeGeometry.prototype.constructor=THREE.ShapeGeometry;THREE.ShapeGeometry.prototype.addShapeList=function(t,e){for(var r=0,i=t.length;r<i;r++){this.addShape(t[r],e)}return this};THREE.ShapeGeometry.prototype.addShape=function(t,e){if(e===undefined)e={};var r=e.curveSegments!==undefined?e.curveSegments:12;var i=e.material;var n=e.UVGenerator===undefined?THREE.ExtrudeGeometry.WorldUVGenerator:e.UVGenerator;var o,s,a;var u=this.vertices.length;var l=t.extractPoints(r);var h=l.shape;var f=l.holes;var c=!THREE.Shape.Utils.isClockWise(h);if(c){h=h.reverse();for(o=0,s=f.length;o<s;o++){a=f[o];if(THREE.Shape.Utils.isClockWise(a)){f[o]=a.reverse()}}c=false}var p=THREE.Shape.Utils.triangulateShape(h,f);var d=h;for(o=0,s=f.length;o<s;o++){a=f[o];h=h.concat(a)}var m,v=h.length;var g,y=p.length;for(o=0;o<v;o++){m=h[o];this.vertices.push(new THREE.Vector3(m.x,m.y,0))}for(o=0;o<y;o++){g=p[o];var E=g[0]+u;var _=g[1]+u;var x=g[2]+u;this.faces.push(new THREE.Face3(E,_,x,null,null,i));this.faceVertexUvs[0].push(n.generateTopUV(this,E,_,x))}};THREE.LatheGeometry=function(t,e,r,i){THREE.Geometry.call(this);this.type="LatheGeometry";this.parameters={points:t,segments:e,phiStart:r,phiLength:i};e=e||12;r=r||0;i=i||2*Math.PI;var n=1/(t.length-1);var o=1/e;for(var s=0,a=e;s<=a;s++){var u=r+s*o*i;var l=Math.cos(u),h=Math.sin(u);for(var f=0,c=t.length;f<c;f++){var p=t[f];var d=new THREE.Vector3;d.x=l*p.x-h*p.y;d.y=h*p.x+l*p.y;d.z=p.z;this.vertices.push(d)}}var m=t.length;for(var s=0,a=e;s<a;s++){for(var f=0,c=t.length-1;f<c;f++){var v=f+m*s;var g=v;var y=v+m;var l=v+1+m;var E=v+1;var _=s*o;var x=f*n;var b=_+o;var T=x+n;this.faces.push(new THREE.Face3(g,y,E));this.faceVertexUvs[0].push([new THREE.Vector2(_,x),new THREE.Vector2(b,x),new THREE.Vector2(_,T)]);this.faces.push(new THREE.Face3(y,l,E));this.faceVertexUvs[0].push([new THREE.Vector2(b,x),new THREE.Vector2(b,T),new THREE.Vector2(_,T)])}}this.mergeVertices();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;THREE.PlaneGeometry=function(t,e,r,i){console.info("THREE.PlaneGeometry: Consider using THREE.PlaneBufferGeometry for lower memory footprint.");THREE.Geometry.call(this);this.type="PlaneGeometry";this.parameters={width:t,height:e,widthSegments:r,heightSegments:i};this.fromBufferGeometry(new THREE.PlaneBufferGeometry(t,e,r,i))};THREE.PlaneGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;THREE.PlaneBufferGeometry=function(t,e,r,i){THREE.BufferGeometry.call(this);this.type="PlaneBufferGeometry";this.parameters={width:t,height:e,widthSegments:r,heightSegments:i};var n=t/2;var o=e/2;var s=r||1;var a=i||1;var u=s+1;var l=a+1;var h=t/s;var f=e/a;var c=new Float32Array(u*l*3);var p=new Float32Array(u*l*3);var d=new Float32Array(u*l*2);var m=0;var v=0;for(var g=0;g<l;g++){var y=g*f-o;for(var E=0;E<u;E++){var _=E*h-n;c[m]=_;c[m+1]=-y;p[m+2]=1;d[v]=E/s;d[v+1]=1-g/a;m+=3;v+=2}}m=0;var x=new(c.length/3>65535?Uint32Array:Uint16Array)(s*a*6);for(var g=0;g<a;g++){for(var E=0;E<s;E++){var b=E+u*g;var T=E+u*(g+1);var w=E+1+u*(g+1);var R=E+1+u*g;x[m]=b;x[m+1]=T;x[m+2]=R;x[m+3]=T;x[m+4]=w;x[m+5]=R;m+=6}}this.addAttribute("index",new THREE.BufferAttribute(x,1));this.addAttribute("position",new THREE.BufferAttribute(c,3));this.addAttribute("normal",new THREE.BufferAttribute(p,3));this.addAttribute("uv",new THREE.BufferAttribute(d,2))};THREE.PlaneBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.PlaneBufferGeometry.prototype.constructor=THREE.PlaneBufferGeometry;THREE.RingGeometry=function(t,e,r,i,n,o){THREE.Geometry.call(this);this.type="RingGeometry";this.parameters={innerRadius:t,outerRadius:e,thetaSegments:r,phiSegments:i,thetaStart:n,thetaLength:o};t=t||0;e=e||50;n=n!==undefined?n:0;o=o!==undefined?o:Math.PI*2;r=r!==undefined?Math.max(3,r):8;i=i!==undefined?Math.max(1,i):8;var s,a,u=[],l=t,h=(e-t)/i;for(s=0;s<i+1;s++){for(a=0;a<r+1;a++){var f=new THREE.Vector3;var c=n+a/r*o;f.x=l*Math.cos(c);f.y=l*Math.sin(c);this.vertices.push(f);u.push(new THREE.Vector2((f.x/e+1)/2,(f.y/e+1)/2))}l+=h}var p=new THREE.Vector3(0,0,1);for(s=0;s<i;s++){var d=s*(r+1);for(a=0;a<r;a++){var c=a+d;var m=c;var v=c+r+1;var g=c+r+2;this.faces.push(new THREE.Face3(m,v,g,[p.clone(),p.clone(),p.clone()]));this.faceVertexUvs[0].push([u[m].clone(),u[v].clone(),u[g].clone()]);m=c;v=c+r+2;g=c+1;this.faces.push(new THREE.Face3(m,v,g,[p.clone(),p.clone(),p.clone()]));this.faceVertexUvs[0].push([u[m].clone(),u[v].clone(),u[g].clone()])}}this.computeFaceNormals();this.boundingSphere=new THREE.Sphere(new THREE.Vector3,l)};THREE.RingGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.RingGeometry.prototype.constructor=THREE.RingGeometry;THREE.SphereGeometry=function(t,e,r,i,n,o,s){THREE.Geometry.call(this);this.type="SphereGeometry";this.parameters={radius:t,widthSegments:e,heightSegments:r,phiStart:i,phiLength:n,thetaStart:o,thetaLength:s};t=t||50;e=Math.max(3,Math.floor(e)||8);r=Math.max(2,Math.floor(r)||6);i=i!==undefined?i:0;n=n!==undefined?n:Math.PI*2;o=o!==undefined?o:0;s=s!==undefined?s:Math.PI;var a,u,l=[],h=[];for(u=0;u<=r;u++){var f=[];var c=[];for(a=0;a<=e;a++){var p=a/e;var d=u/r;var m=new THREE.Vector3;m.x=-t*Math.cos(i+p*n)*Math.sin(o+d*s);m.y=t*Math.cos(o+d*s);m.z=t*Math.sin(i+p*n)*Math.sin(o+d*s);this.vertices.push(m);f.push(this.vertices.length-1);c.push(new THREE.Vector2(p,1-d))}l.push(f);h.push(c)}for(u=0;u<r;u++){for(a=0;a<e;a++){var v=l[u][a+1];var g=l[u][a];var y=l[u+1][a];var E=l[u+1][a+1];var _=this.vertices[v].clone().normalize();var x=this.vertices[g].clone().normalize();var b=this.vertices[y].clone().normalize();var T=this.vertices[E].clone().normalize();var w=h[u][a+1].clone();var R=h[u][a].clone();var H=h[u+1][a].clone();var M=h[u+1][a+1].clone();if(Math.abs(this.vertices[v].y)===t){w.x=(w.x+R.x)/2;this.faces.push(new THREE.Face3(v,y,E,[_,b,T]));this.faceVertexUvs[0].push([w,H,M])}else if(Math.abs(this.vertices[y].y)===t){H.x=(H.x+M.x)/2;this.faces.push(new THREE.Face3(v,g,y,[_,x,b]));this.faceVertexUvs[0].push([w,R,H])}else{this.faces.push(new THREE.Face3(v,g,E,[_,x,T]));this.faceVertexUvs[0].push([w,R,M]);this.faces.push(new THREE.Face3(g,y,E,[x.clone(),b,T.clone()]));this.faceVertexUvs[0].push([R.clone(),H,M.clone()])}}}this.computeFaceNormals();this.boundingSphere=new THREE.Sphere(new THREE.Vector3,t)};THREE.SphereGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;THREE.TextGeometry=function(t,e){e=e||{};var r=THREE.FontUtils.generateShapes(t,e);e.amount=e.height!==undefined?e.height:50;if(e.bevelThickness===undefined)e.bevelThickness=10;if(e.bevelSize===undefined)e.bevelSize=8;if(e.bevelEnabled===undefined)e.bevelEnabled=false;THREE.ExtrudeGeometry.call(this,r,e);this.type="TextGeometry"};THREE.TextGeometry.prototype=Object.create(THREE.ExtrudeGeometry.prototype);THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;THREE.TorusGeometry=function(t,e,r,i,n){THREE.Geometry.call(this);this.type="TorusGeometry";this.parameters={radius:t,tube:e,radialSegments:r,tubularSegments:i,arc:n};t=t||100;e=e||40;r=r||8;i=i||6;n=n||Math.PI*2;var o=new THREE.Vector3,s=[],a=[];for(var u=0;u<=r;u++){for(var l=0;l<=i;l++){var h=l/i*n;var f=u/r*Math.PI*2;o.x=t*Math.cos(h);o.y=t*Math.sin(h);var c=new THREE.Vector3;c.x=(t+e*Math.cos(f))*Math.cos(h);c.y=(t+e*Math.cos(f))*Math.sin(h);c.z=e*Math.sin(f);this.vertices.push(c);s.push(new THREE.Vector2(l/i,u/r));a.push(c.clone().sub(o).normalize())}}for(var u=1;u<=r;u++){for(var l=1;l<=i;l++){var p=(i+1)*u+l-1;var d=(i+1)*(u-1)+l-1;var m=(i+1)*(u-1)+l;var v=(i+1)*u+l;var g=new THREE.Face3(p,d,v,[a[p].clone(),a[d].clone(),a[v].clone()]);this.faces.push(g);this.faceVertexUvs[0].push([s[p].clone(),s[d].clone(),s[v].clone()]);g=new THREE.Face3(d,m,v,[a[d].clone(),a[m].clone(),a[v].clone()]);this.faces.push(g);this.faceVertexUvs[0].push([s[d].clone(),s[m].clone(),s[v].clone()])}}this.computeFaceNormals()};THREE.TorusGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;THREE.TorusKnotGeometry=function(t,e,r,i,n,o,s){THREE.Geometry.call(this);this.type="TorusKnotGeometry";this.parameters={radius:t,tube:e,radialSegments:r,tubularSegments:i,p:n,q:o,heightScale:s};t=t||100;e=e||40;r=r||64;i=i||8;n=n||2;o=o||3;s=s||1;var a=new Array(r);var u=new THREE.Vector3;var l=new THREE.Vector3;var h=new THREE.Vector3;for(var f=0;f<r;++f){a[f]=new Array(i);var c=f/r*2*n*Math.PI;var p=A(c,o,n,t,s);var d=A(c+.01,o,n,t,s);u.subVectors(d,p);l.addVectors(d,p);h.crossVectors(u,l);l.crossVectors(h,u);h.normalize();l.normalize();for(var m=0;m<i;++m){var v=m/i*2*Math.PI;var g=-e*Math.cos(v);var y=e*Math.sin(v);var E=new THREE.Vector3;E.x=p.x+g*l.x+y*h.x;E.y=p.y+g*l.y+y*h.y;E.z=p.z+g*l.z+y*h.z;a[f][m]=this.vertices.push(E)-1}}for(var f=0;f<r;++f){for(var m=0;m<i;++m){var _=(f+1)%r;var x=(m+1)%i;var b=a[f][m];var T=a[_][m];var w=a[_][x];var R=a[f][x];var H=new THREE.Vector2(f/r,m/i);var M=new THREE.Vector2((f+1)/r,m/i);var S=new THREE.Vector2((f+1)/r,(m+1)/i);var k=new THREE.Vector2(f/r,(m+1)/i);this.faces.push(new THREE.Face3(b,T,R));this.faceVertexUvs[0].push([H,M,k]);this.faces.push(new THREE.Face3(T,w,R));this.faceVertexUvs[0].push([M.clone(),S,k.clone()])}}this.computeFaceNormals();this.computeVertexNormals();function A(t,e,r,i,n){var o=Math.cos(t);var s=Math.sin(t);var a=e/r*t;var u=Math.cos(a);var l=i*(2+u)*.5*o;var h=i*(2+u)*s*.5;var f=n*i*Math.sin(a)*.5;return new THREE.Vector3(l,h,f)}};THREE.TorusKnotGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;THREE.TubeGeometry=function(t,e,r,i,n,o){THREE.Geometry.call(this);this.type="TubeGeometry";this.parameters={path:t,segments:e,radius:r,radialSegments:i,closed:n};e=e||64;r=r||1;i=i||8;n=n||false;o=o||THREE.TubeGeometry.NoTaper;var s=[];var a=this,u,l,h,f=e+1,c,p,d,m,v,g,y=new THREE.Vector3,E,_,x,b,T,w,R,H,M,S,k,A;var C=new THREE.TubeGeometry.FrenetFrames(t,e,n),L=C.tangents,P=C.normals,z=C.binormals;this.tangents=L;this.normals=P;this.binormals=z;function D(t,e,r){return a.vertices.push(new THREE.Vector3(t,e,r))-1}for(E=0;E<f;E++){s[E]=[];c=E/(f-1);g=t.getPointAt(c);u=L[E];l=P[E];h=z[E];d=r*o(c);for(_=0;_<i;_++){p=_/i*2*Math.PI;m=-d*Math.cos(p);v=d*Math.sin(p);y.copy(g);y.x+=m*l.x+v*h.x;y.y+=m*l.y+v*h.y;y.z+=m*l.z+v*h.z;s[E][_]=D(y.x,y.y,y.z)}}for(E=0;E<e;E++){for(_=0;_<i;_++){x=n?(E+1)%e:E+1;b=(_+1)%i;T=s[E][_];w=s[x][_];R=s[x][b];H=s[E][b];M=new THREE.Vector2(E/e,_/i);S=new THREE.Vector2((E+1)/e,_/i);k=new THREE.Vector2((E+1)/e,(_+1)/i);A=new THREE.Vector2(E/e,(_+1)/i);this.faces.push(new THREE.Face3(T,w,H));this.faceVertexUvs[0].push([M,S,A]);this.faces.push(new THREE.Face3(w,R,H));this.faceVertexUvs[0].push([S.clone(),k,A.clone()])}}this.computeFaceNormals();this.computeVertexNormals()};THREE.TubeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TubeGeometry.prototype.constructor=THREE.TubeGeometry;THREE.TubeGeometry.NoTaper=function(t){return 1};THREE.TubeGeometry.SinusoidalTaper=function(t){return Math.sin(Math.PI*t)};THREE.TubeGeometry.FrenetFrames=function(t,e,r){var i=new THREE.Vector3,n=[],o=[],s=[],a=new THREE.Vector3,u=new THREE.Matrix4,l=e+1,h,f=1e-4,c,p,d,m,v,g;this.tangents=n;this.normals=o;this.binormals=s;for(v=0;v<l;v++){g=v/(l-1);n[v]=t.getTangentAt(g);n[v].normalize()}y();function y(){o[0]=new THREE.Vector3;s[0]=new THREE.Vector3;c=Number.MAX_VALUE;p=Math.abs(n[0].x);d=Math.abs(n[0].y);m=Math.abs(n[0].z);if(p<=c){c=p;i.set(1,0,0)}if(d<=c){c=d;i.set(0,1,0)}if(m<=c){i.set(0,0,1)}a.crossVectors(n[0],i).normalize();o[0].crossVectors(n[0],a);s[0].crossVectors(n[0],o[0])}for(v=1;v<l;v++){o[v]=o[v-1].clone();s[v]=s[v-1].clone();a.crossVectors(n[v-1],n[v]);if(a.length()>f){a.normalize();h=Math.acos(THREE.Math.clamp(n[v-1].dot(n[v]),-1,1));o[v].applyMatrix4(u.makeRotationAxis(a,h))}s[v].crossVectors(n[v],o[v])}if(r){h=Math.acos(THREE.Math.clamp(o[0].dot(o[l-1]),-1,1));h/=l-1;if(n[0].dot(a.crossVectors(o[0],o[l-1]))>0){h=-h}for(v=1;v<l;v++){o[v].applyMatrix4(u.makeRotationAxis(n[v],h*v));s[v].crossVectors(n[v],o[v])}}};THREE.PolyhedronGeometry=function(t,e,r,i){THREE.Geometry.call(this);this.type="PolyhedronGeometry";this.parameters={vertices:t,indices:e,radius:r,detail:i};r=r||1;i=i||0;var n=this;for(var o=0,s=t.length;o<s;o+=3){_(new THREE.Vector3(t[o],t[o+1],t[o+2]))}var a=this.vertices;var u=[];for(var o=0,l=0,s=e.length;o<s;o+=3,l++){var h=a[e[o]];var f=a[e[o+1]];var c=a[e[o+2]];u[l]=new THREE.Face3(h.index,f.index,c.index,[h.clone(),f.clone(),c.clone()])}var p=new THREE.Vector3;for(var o=0,s=u.length;o<s;o++){b(u[o],i)}for(var o=0,s=this.faceVertexUvs[0].length;o<s;o++){var d=this.faceVertexUvs[0][o];var m=d[0].x;var v=d[1].x;var g=d[2].x;var y=Math.max(m,Math.max(v,g));var E=Math.min(m,Math.min(v,g));if(y>.9&&E<.1){if(m<.2)d[0].x+=1;if(v<.2)d[1].x+=1;if(g<.2)d[2].x+=1}}for(var o=0,s=this.vertices.length;o<s;o++){this.vertices[o].multiplyScalar(r)}this.mergeVertices();this.computeFaceNormals();this.boundingSphere=new THREE.Sphere(new THREE.Vector3,r);function _(t){var e=t.normalize().clone();e.index=n.vertices.push(e)-1;var r=T(t)/2/Math.PI+.5;var i=w(t)/Math.PI+.5;e.uv=new THREE.Vector2(r,1-i);return e}function x(t,e,r){var i=new THREE.Face3(t.index,e.index,r.index,[t.clone(),e.clone(),r.clone()]);n.faces.push(i);p.copy(t).add(e).add(r).divideScalar(3);var o=T(p);n.faceVertexUvs[0].push([R(t.uv,t,o),R(e.uv,e,o),R(r.uv,r,o)])}function b(t,e){var r=Math.pow(2,e);var i=_(n.vertices[t.a]);var o=_(n.vertices[t.b]);var s=_(n.vertices[t.c]);var a=[];for(var u=0;u<=r;u++){a[u]=[];var l=_(i.clone().lerp(s,u/r));var h=_(o.clone().lerp(s,u/r));var f=r-u;for(var c=0;c<=f;c++){if(c==0&&u==r){a[u][c]=l}else{a[u][c]=_(l.clone().lerp(h,c/f))}}}for(var u=0;u<r;u++){for(var c=0;c<2*(r-u)-1;c++){var p=Math.floor(c/2);if(c%2==0){x(a[u][p+1],a[u+1][p],a[u][p])}else{x(a[u][p+1],a[u+1][p+1],a[u+1][p])}}}}function T(t){return Math.atan2(t.z,-t.x)}function w(t){return Math.atan2(-t.y,Math.sqrt(t.x*t.x+t.z*t.z))}function R(t,e,r){if(r<0&&t.x===1)t=new THREE.Vector2(t.x-1,t.y);if(e.x===0&&e.z===0)t=new THREE.Vector2(r/2/Math.PI+.5,t.y);return t.clone()}};THREE.PolyhedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry;THREE.DodecahedronGeometry=function(t,e){this.parameters={radius:t,detail:e};var r=(1+Math.sqrt(5))/2;var i=1/r;var n=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-i,-r,0,-i,r,0,i,-r,0,i,r,-i,-r,0,-i,r,0,i,-r,0,i,r,0,-r,0,-i,r,0,-i,-r,0,i,r,0,i];var o=[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9];THREE.PolyhedronGeometry.call(this,n,o,t,e)};THREE.DodecahedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.DodecahedronGeometry.prototype.constructor=THREE.DodecahedronGeometry;THREE.IcosahedronGeometry=function(t,e){var r=(1+Math.sqrt(5))/2;var i=[-1,r,0,1,r,0,-1,-r,0,1,-r,0,0,-1,r,0,1,r,0,-1,-r,0,1,-r,r,0,-1,r,0,1,-r,0,-1,-r,0,1];var n=[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1];THREE.PolyhedronGeometry.call(this,i,n,t,e);this.type="IcosahedronGeometry";this.parameters={radius:t,detail:e}};THREE.IcosahedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;THREE.OctahedronGeometry=function(t,e){this.parameters={radius:t,detail:e};var r=[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1];var i=[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2];THREE.PolyhedronGeometry.call(this,r,i,t,e);this.type="OctahedronGeometry";this.parameters={radius:t,detail:e}};THREE.OctahedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry;THREE.TetrahedronGeometry=function(t,e){var r=[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1];var i=[2,1,0,0,3,2,1,3,0,2,3,1];THREE.PolyhedronGeometry.call(this,r,i,t,e);this.type="TetrahedronGeometry";this.parameters={radius:t,detail:e}};THREE.TetrahedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry;THREE.ParametricGeometry=function(t,e,r){THREE.Geometry.call(this);this.type="ParametricGeometry";this.parameters={func:t,slices:e,stacks:r};var i=this.vertices;var n=this.faces;var o=this.faceVertexUvs[0];var s,a,u;var l,h;var f=e+1;for(s=0;s<=r;s++){h=s/r;for(a=0;a<=e;a++){l=a/e;u=t(l,h);i.push(u)}}var c,p,d,m;var v,g,y,E;for(s=0;s<r;s++){for(a=0;a<e;a++){c=s*f+a;p=s*f+a+1;d=(s+1)*f+a+1;m=(s+1)*f+a;v=new THREE.Vector2(a/e,s/r);g=new THREE.Vector2((a+1)/e,s/r);y=new THREE.Vector2((a+1)/e,(s+1)/r);E=new THREE.Vector2(a/e,(s+1)/r);n.push(new THREE.Face3(c,p,m));o.push([v,g,E]);n.push(new THREE.Face3(p,d,m));o.push([g.clone(),y,E.clone()])}}this.computeFaceNormals();this.computeVertexNormals()};THREE.ParametricGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ParametricGeometry.prototype.constructor=THREE.ParametricGeometry;THREE.AxisHelper=function(t){t=t||1;var e=new Float32Array([0,0,0,t,0,0,0,0,0,0,t,0,0,0,0,0,0,t]);var r=new Float32Array([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1]);var i=new THREE.BufferGeometry;i.addAttribute("position",new THREE.BufferAttribute(e,3));i.addAttribute("color",new THREE.BufferAttribute(r,3));var n=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});THREE.Line.call(this,i,n,THREE.LinePieces)};THREE.AxisHelper.prototype=Object.create(THREE.Line.prototype);THREE.AxisHelper.prototype.constructor=THREE.AxisHelper;THREE.ArrowHelper=function(){var t=new THREE.Geometry;t.vertices.push(new THREE.Vector3(0,0,0),new THREE.Vector3(0,1,0));var e=new THREE.CylinderGeometry(0,.5,1,5,1);e.applyMatrix((new THREE.Matrix4).makeTranslation(0,-.5,0));return function(r,i,n,o,s,a){THREE.Object3D.call(this);if(o===undefined)o=16776960;if(n===undefined)n=1;if(s===undefined)s=.2*n;if(a===undefined)a=.2*s;this.position.copy(i);this.line=new THREE.Line(t,new THREE.LineBasicMaterial({color:o}));this.line.matrixAutoUpdate=false;this.add(this.line);this.cone=new THREE.Mesh(e,new THREE.MeshBasicMaterial({color:o}));this.cone.matrixAutoUpdate=false;this.add(this.cone);this.setDirection(r);this.setLength(n,s,a)}}();THREE.ArrowHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.ArrowHelper.prototype.constructor=THREE.ArrowHelper;THREE.ArrowHelper.prototype.setDirection=function(){var t=new THREE.Vector3;var e;return function(r){if(r.y>.99999){this.quaternion.set(0,0,0,1)}else if(r.y<-.99999){this.quaternion.set(1,0,0,0)}else{t.set(r.z,0,-r.x).normalize();e=Math.acos(r.y);this.quaternion.setFromAxisAngle(t,e)}}}();THREE.ArrowHelper.prototype.setLength=function(t,e,r){if(e===undefined)e=.2*t;if(r===undefined)r=.2*e;this.line.scale.set(1,t-e,1);this.line.updateMatrix();this.cone.scale.set(r,e,r);this.cone.position.y=t;this.cone.updateMatrix()};THREE.ArrowHelper.prototype.setColor=function(t){this.line.material.color.set(t);this.cone.material.color.set(t)};THREE.BoxHelper=function(t){var e=new THREE.BufferGeometry;e.addAttribute("position",new THREE.BufferAttribute(new Float32Array(72),3));THREE.Line.call(this,e,new THREE.LineBasicMaterial({color:16776960}),THREE.LinePieces);if(t!==undefined){this.update(t)}};THREE.BoxHelper.prototype=Object.create(THREE.Line.prototype);THREE.BoxHelper.prototype.constructor=THREE.BoxHelper;THREE.BoxHelper.prototype.update=function(t){var e=t.geometry;if(e.boundingBox===null){e.computeBoundingBox()}var r=e.boundingBox.min;var i=e.boundingBox.max;var n=this.geometry.attributes.position.array;n[0]=i.x;n[1]=i.y;n[2]=i.z;n[3]=r.x;n[4]=i.y;n[5]=i.z;n[6]=r.x;n[7]=i.y;n[8]=i.z;n[9]=r.x;n[10]=r.y;n[11]=i.z;n[12]=r.x;n[13]=r.y;n[14]=i.z;n[15]=i.x;n[16]=r.y;n[17]=i.z;n[18]=i.x;n[19]=r.y;n[20]=i.z;n[21]=i.x;n[22]=i.y;n[23]=i.z;n[24]=i.x;n[25]=i.y;n[26]=r.z;n[27]=r.x;n[28]=i.y;n[29]=r.z;n[30]=r.x;n[31]=i.y;n[32]=r.z;n[33]=r.x;n[34]=r.y;n[35]=r.z;n[36]=r.x;n[37]=r.y;n[38]=r.z;n[39]=i.x;n[40]=r.y;n[41]=r.z;n[42]=i.x;n[43]=r.y;n[44]=r.z;n[45]=i.x;n[46]=i.y;n[47]=r.z;n[48]=i.x;n[49]=i.y;n[50]=i.z;n[51]=i.x;n[52]=i.y;n[53]=r.z;n[54]=r.x;n[55]=i.y;n[56]=i.z;n[57]=r.x;n[58]=i.y;n[59]=r.z;n[60]=r.x;n[61]=r.y;n[62]=i.z;n[63]=r.x;n[64]=r.y;n[65]=r.z;n[66]=i.x;n[67]=r.y;n[68]=i.z;n[69]=i.x;n[70]=r.y;n[71]=r.z;this.geometry.attributes.position.needsUpdate=true;this.geometry.computeBoundingSphere();this.matrix=t.matrixWorld;this.matrixAutoUpdate=false};THREE.BoundingBoxHelper=function(t,e){var r=e!==undefined?e:8947848;this.object=t;this.box=new THREE.Box3;THREE.Mesh.call(this,new THREE.BoxGeometry(1,1,1),new THREE.MeshBasicMaterial({color:r,wireframe:true}))};THREE.BoundingBoxHelper.prototype=Object.create(THREE.Mesh.prototype);THREE.BoundingBoxHelper.prototype.constructor=THREE.BoundingBoxHelper;THREE.BoundingBoxHelper.prototype.update=function(){this.box.setFromObject(this.object);this.box.size(this.scale);this.box.center(this.position)};THREE.CameraHelper=function(t){var e=new THREE.Geometry;var r=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});var i={};var n=16755200;var o=16711680;var s=43775;var a=16777215;var u=3355443;l("n1","n2",n);l("n2","n4",n);l("n4","n3",n);l("n3","n1",n);l("f1","f2",n);l("f2","f4",n);l("f4","f3",n);l("f3","f1",n);l("n1","f1",n);l("n2","f2",n);l("n3","f3",n);l("n4","f4",n);l("p","n1",o);l("p","n2",o);l("p","n3",o);l("p","n4",o);l("u1","u2",s);l("u2","u3",s);l("u3","u1",s);l("c","t",a);l("p","c",u);l("cn1","cn2",u);l("cn3","cn4",u);l("cf1","cf2",u);l("cf3","cf4",u);function l(t,e,r){h(t,r);h(e,r)}function h(t,r){e.vertices.push(new THREE.Vector3);e.colors.push(new THREE.Color(r));if(i[t]===undefined){i[t]=[]}i[t].push(e.vertices.length-1)}THREE.Line.call(this,e,r,THREE.LinePieces);this.camera=t;this.matrix=t.matrixWorld;this.matrixAutoUpdate=false;this.pointMap=i;this.update()};THREE.CameraHelper.prototype=Object.create(THREE.Line.prototype);THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;THREE.CameraHelper.prototype.update=function(){var t,e;var r=new THREE.Vector3;var i=new THREE.Camera;var n=function(n,o,s,a){r.set(o,s,a).unproject(i);var u=e[n];if(u!==undefined){for(var l=0,h=u.length;l<h;l++){t.vertices[u[l]].copy(r)}}};return function(){t=this.geometry;e=this.pointMap;var r=1,o=1;i.projectionMatrix.copy(this.camera.projectionMatrix);n("c",0,0,-1);n("t",0,0,1);n("n1",-r,-o,-1);n("n2",r,-o,-1);n("n3",-r,o,-1);n("n4",r,o,-1);n("f1",-r,-o,1);n("f2",r,-o,1);n("f3",-r,o,1);n("f4",r,o,1);n("u1",r*.7,o*1.1,-1);n("u2",-r*.7,o*1.1,-1);n("u3",0,o*2,-1);n("cf1",-r,0,1);n("cf2",r,0,1);n("cf3",0,-o,1);n("cf4",0,o,1);n("cn1",-r,0,-1);n("cn2",r,0,-1);n("cn3",0,-o,-1);n("cn4",0,o,-1);t.verticesNeedUpdate=true}}();THREE.DirectionalLightHelper=function(t,e){THREE.Object3D.call(this);this.light=t;this.light.updateMatrixWorld();this.matrix=t.matrixWorld;this.matrixAutoUpdate=false;e=e||1;var r=new THREE.Geometry;r.vertices.push(new THREE.Vector3(-e,e,0),new THREE.Vector3(e,e,0),new THREE.Vector3(e,-e,0),new THREE.Vector3(-e,-e,0),new THREE.Vector3(-e,e,0));var i=new THREE.LineBasicMaterial({fog:false});i.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.lightPlane=new THREE.Line(r,i);this.add(this.lightPlane);r=new THREE.Geometry;r.vertices.push(new THREE.Vector3,new THREE.Vector3);i=new THREE.LineBasicMaterial({fog:false});i.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.targetLine=new THREE.Line(r,i);this.add(this.targetLine);this.update()};THREE.DirectionalLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.DirectionalLightHelper.prototype.constructor=THREE.DirectionalLightHelper;THREE.DirectionalLightHelper.prototype.dispose=function(){this.lightPlane.geometry.dispose();this.lightPlane.material.dispose();this.targetLine.geometry.dispose();this.targetLine.material.dispose()};THREE.DirectionalLightHelper.prototype.update=function(){var t=new THREE.Vector3;var e=new THREE.Vector3;var r=new THREE.Vector3;return function(){t.setFromMatrixPosition(this.light.matrixWorld);e.setFromMatrixPosition(this.light.target.matrixWorld);r.subVectors(e,t);this.lightPlane.lookAt(r);this.lightPlane.material.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.targetLine.geometry.vertices[1].copy(r);this.targetLine.geometry.verticesNeedUpdate=true;this.targetLine.material.color.copy(this.lightPlane.material.color)}}();THREE.EdgesHelper=function(t,e,r){var i=e!==undefined?e:16777215;r=r!==undefined?r:1;var n=Math.cos(THREE.Math.degToRad(r));var o=[0,0],s={};var a=function(t,e){return t-e};var u=["a","b","c"];var l=new THREE.BufferGeometry;var h;if(t.geometry instanceof THREE.BufferGeometry){h=new THREE.Geometry;h.fromBufferGeometry(t.geometry)}else{h=t.geometry.clone()}h.mergeVertices();h.computeFaceNormals();var f=h.vertices;var c=h.faces;var p=0;for(var d=0,m=c.length;d<m;d++){var v=c[d];for(var g=0;g<3;g++){o[0]=v[u[g]];o[1]=v[u[(g+1)%3]];o.sort(a);var y=o.toString();if(s[y]===undefined){s[y]={vert1:o[0],vert2:o[1],face1:d,face2:undefined};p++}else{s[y].face2=d}}}var E=new Float32Array(p*2*3);var _=0;for(var y in s){var x=s[y];if(x.face2===undefined||c[x.face1].normal.dot(c[x.face2].normal)<=n){var b=f[x.vert1];E[_++]=b.x;E[_++]=b.y;E[_++]=b.z;b=f[x.vert2];E[_++]=b.x;E[_++]=b.y;E[_++]=b.z}}l.addAttribute("position",new THREE.BufferAttribute(E,3));THREE.Line.call(this,l,new THREE.LineBasicMaterial({color:i}),THREE.LinePieces);this.matrix=t.matrixWorld;this.matrixAutoUpdate=false};THREE.EdgesHelper.prototype=Object.create(THREE.Line.prototype);THREE.EdgesHelper.prototype.constructor=THREE.EdgesHelper;THREE.FaceNormalsHelper=function(t,e,r,i){this.object=t;this.size=e!==undefined?e:1;var n=r!==undefined?r:16776960;var o=i!==undefined?i:1;var s=new THREE.Geometry;var a=this.object.geometry.faces;for(var u=0,l=a.length;u<l;u++){s.vertices.push(new THREE.Vector3,new THREE.Vector3)}THREE.Line.call(this,s,new THREE.LineBasicMaterial({color:n,linewidth:o}),THREE.LinePieces);this.matrixAutoUpdate=false;this.normalMatrix=new THREE.Matrix3;this.update()};THREE.FaceNormalsHelper.prototype=Object.create(THREE.Line.prototype);THREE.FaceNormalsHelper.prototype.constructor=THREE.FaceNormalsHelper;THREE.FaceNormalsHelper.prototype.update=function(){var t=this.geometry.vertices;var e=this.object;var r=e.geometry.vertices;var i=e.geometry.faces;var n=e.matrixWorld;e.updateMatrixWorld(true);this.normalMatrix.getNormalMatrix(n);for(var o=0,s=0,a=i.length;o<a;o++,s+=2){var u=i[o];t[s].copy(r[u.a]).add(r[u.b]).add(r[u.c]).divideScalar(3).applyMatrix4(n);t[s+1].copy(u.normal).applyMatrix3(this.normalMatrix).normalize().multiplyScalar(this.size).add(t[s])}this.geometry.verticesNeedUpdate=true;return this};THREE.GridHelper=function(t,e){var r=new THREE.Geometry;var i=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});this.color1=new THREE.Color(4473924);this.color2=new THREE.Color(8947848);for(var n=-t;n<=t;n+=e){r.vertices.push(new THREE.Vector3(-t,0,n),new THREE.Vector3(t,0,n),new THREE.Vector3(n,0,-t),new THREE.Vector3(n,0,t));var o=n===0?this.color1:this.color2;r.colors.push(o,o,o,o)}THREE.Line.call(this,r,i,THREE.LinePieces)};THREE.GridHelper.prototype=Object.create(THREE.Line.prototype);THREE.GridHelper.prototype.constructor=THREE.GridHelper;THREE.GridHelper.prototype.setColors=function(t,e){this.color1.set(t);this.color2.set(e);this.geometry.colorsNeedUpdate=true};THREE.HemisphereLightHelper=function(t,e){THREE.Object3D.call(this);this.light=t;this.light.updateMatrixWorld();this.matrix=t.matrixWorld;this.matrixAutoUpdate=false;this.colors=[new THREE.Color,new THREE.Color];var r=new THREE.SphereGeometry(e,4,2);r.applyMatrix((new THREE.Matrix4).makeRotationX(-Math.PI/2));for(var i=0,n=8;i<n;i++){r.faces[i].color=this.colors[i<4?0:1]}var o=new THREE.MeshBasicMaterial({vertexColors:THREE.FaceColors,wireframe:true});this.lightSphere=new THREE.Mesh(r,o);this.add(this.lightSphere);this.update()};THREE.HemisphereLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.HemisphereLightHelper.prototype.constructor=THREE.HemisphereLightHelper;THREE.HemisphereLightHelper.prototype.dispose=function(){this.lightSphere.geometry.dispose();this.lightSphere.material.dispose()};THREE.HemisphereLightHelper.prototype.update=function(){var t=new THREE.Vector3;return function(){this.colors[0].copy(this.light.color).multiplyScalar(this.light.intensity);this.colors[1].copy(this.light.groundColor).multiplyScalar(this.light.intensity);this.lightSphere.lookAt(t.setFromMatrixPosition(this.light.matrixWorld).negate());this.lightSphere.geometry.colorsNeedUpdate=true}}();THREE.PointLightHelper=function(t,e){this.light=t;this.light.updateMatrixWorld();var r=new THREE.SphereGeometry(e,4,2);var i=new THREE.MeshBasicMaterial({wireframe:true,fog:false});i.color.copy(this.light.color).multiplyScalar(this.light.intensity);THREE.Mesh.call(this,r,i);this.matrix=this.light.matrixWorld;this.matrixAutoUpdate=false};THREE.PointLightHelper.prototype=Object.create(THREE.Mesh.prototype);THREE.PointLightHelper.prototype.constructor=THREE.PointLightHelper;THREE.PointLightHelper.prototype.dispose=function(){this.geometry.dispose();this.material.dispose()};THREE.PointLightHelper.prototype.update=function(){this.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)};THREE.SkeletonHelper=function(t){this.bones=this.getBoneList(t);var e=new THREE.Geometry;for(var r=0;r<this.bones.length;r++){var i=this.bones[r];if(i.parent instanceof THREE.Bone){e.vertices.push(new THREE.Vector3);e.vertices.push(new THREE.Vector3);e.colors.push(new THREE.Color(0,0,1));e.colors.push(new THREE.Color(0,1,0))}}var n=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,depthTest:false,depthWrite:false,transparent:true});THREE.Line.call(this,e,n,THREE.LinePieces);this.root=t;this.matrix=t.matrixWorld;this.matrixAutoUpdate=false;this.update()};THREE.SkeletonHelper.prototype=Object.create(THREE.Line.prototype);THREE.SkeletonHelper.prototype.constructor=THREE.SkeletonHelper;THREE.SkeletonHelper.prototype.getBoneList=function(t){var e=[];if(t instanceof THREE.Bone){e.push(t)}for(var r=0;r<t.children.length;r++){e.push.apply(e,this.getBoneList(t.children[r]))}return e};THREE.SkeletonHelper.prototype.update=function(){var t=this.geometry;var e=(new THREE.Matrix4).getInverse(this.root.matrixWorld);var r=new THREE.Matrix4;var i=0;for(var n=0;n<this.bones.length;n++){var o=this.bones[n];if(o.parent instanceof THREE.Bone){r.multiplyMatrices(e,o.matrixWorld);t.vertices[i].setFromMatrixPosition(r);r.multiplyMatrices(e,o.parent.matrixWorld);t.vertices[i+1].setFromMatrixPosition(r);i+=2}}t.verticesNeedUpdate=true;t.computeBoundingSphere()};THREE.SpotLightHelper=function(t){THREE.Object3D.call(this);this.light=t;this.light.updateMatrixWorld();this.matrix=t.matrixWorld;this.matrixAutoUpdate=false;var e=new THREE.CylinderGeometry(0,1,1,8,1,true);e.applyMatrix((new THREE.Matrix4).makeTranslation(0,-.5,0));e.applyMatrix((new THREE.Matrix4).makeRotationX(-Math.PI/2));var r=new THREE.MeshBasicMaterial({wireframe:true,fog:false});this.cone=new THREE.Mesh(e,r);this.add(this.cone);this.update()};THREE.SpotLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.SpotLightHelper.prototype.constructor=THREE.SpotLightHelper;THREE.SpotLightHelper.prototype.dispose=function(){this.cone.geometry.dispose();this.cone.material.dispose()};THREE.SpotLightHelper.prototype.update=function(){var t=new THREE.Vector3;var e=new THREE.Vector3;return function(){var r=this.light.distance?this.light.distance:1e4;var i=r*Math.tan(this.light.angle);this.cone.scale.set(i,i,r);t.setFromMatrixPosition(this.light.matrixWorld);e.setFromMatrixPosition(this.light.target.matrixWorld);this.cone.lookAt(e.sub(t));this.cone.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)}}();THREE.VertexNormalsHelper=function(t,e,r,i){this.object=t;this.size=e!==undefined?e:1;var n=r!==undefined?r:16711680;var o=i!==undefined?i:1;var s=new THREE.Geometry;var a=t.geometry.faces;for(var u=0,l=a.length;u<l;u++){var h=a[u];for(var f=0,c=h.vertexNormals.length;f<c;f++){s.vertices.push(new THREE.Vector3,new THREE.Vector3)}}THREE.Line.call(this,s,new THREE.LineBasicMaterial({color:n,linewidth:o}),THREE.LinePieces);this.matrixAutoUpdate=false;this.normalMatrix=new THREE.Matrix3;this.update()};THREE.VertexNormalsHelper.prototype=Object.create(THREE.Line.prototype);THREE.VertexNormalsHelper.prototype.constructor=THREE.VertexNormalsHelper;THREE.VertexNormalsHelper.prototype.update=function(t){var e=new THREE.Vector3;return function(t){var r=["a","b","c","d"];this.object.updateMatrixWorld(true);this.normalMatrix.getNormalMatrix(this.object.matrixWorld);var i=this.geometry.vertices;var n=this.object.geometry.vertices;var o=this.object.geometry.faces;var s=this.object.matrixWorld;var a=0;for(var u=0,l=o.length;u<l;u++){var h=o[u];for(var f=0,c=h.vertexNormals.length;f<c;f++){var p=h[r[f]];var d=n[p];var m=h.vertexNormals[f];i[a].copy(d).applyMatrix4(s);e.copy(m).applyMatrix3(this.normalMatrix).normalize().multiplyScalar(this.size);e.add(i[a]);a=a+1;i[a].copy(e);a=a+1}}this.geometry.verticesNeedUpdate=true;return this}}();THREE.VertexTangentsHelper=function(t,e,r,i){this.object=t;this.size=e!==undefined?e:1;var n=r!==undefined?r:255;var o=i!==undefined?i:1;var s=new THREE.Geometry;var a=t.geometry.faces;for(var u=0,l=a.length;u<l;u++){var h=a[u];for(var f=0,c=h.vertexTangents.length;f<c;f++){s.vertices.push(new THREE.Vector3);s.vertices.push(new THREE.Vector3)}}THREE.Line.call(this,s,new THREE.LineBasicMaterial({color:n,linewidth:o}),THREE.LinePieces);this.matrixAutoUpdate=false;this.update()};THREE.VertexTangentsHelper.prototype=Object.create(THREE.Line.prototype);THREE.VertexTangentsHelper.prototype.constructor=THREE.VertexTangentsHelper;THREE.VertexTangentsHelper.prototype.update=function(t){var e=new THREE.Vector3;return function(t){var r=["a","b","c","d"];this.object.updateMatrixWorld(true);var i=this.geometry.vertices;var n=this.object.geometry.vertices;var o=this.object.geometry.faces;var s=this.object.matrixWorld;var a=0;for(var u=0,l=o.length;u<l;u++){var h=o[u];for(var f=0,c=h.vertexTangents.length;f<c;f++){var p=h[r[f]];var d=n[p];var m=h.vertexTangents[f];i[a].copy(d).applyMatrix4(s);e.copy(m).transformDirection(s).multiplyScalar(this.size);e.add(i[a]);a=a+1;i[a].copy(e);a=a+1}}this.geometry.verticesNeedUpdate=true;return this}}();THREE.WireframeHelper=function(t,e){var r=e!==undefined?e:16777215;var i=[0,0],n={};var o=function(t,e){return t-e};var s=["a","b","c"];var a=new THREE.BufferGeometry;if(t.geometry instanceof THREE.Geometry){var u=t.geometry.vertices;var l=t.geometry.faces;var h=0;var f=new Uint32Array(6*l.length);for(var c=0,p=l.length;c<p;c++){var d=l[c];for(var m=0;m<3;m++){i[0]=d[s[m]];i[1]=d[s[(m+1)%3]];i.sort(o);var v=i.toString();if(n[v]===undefined){f[2*h]=i[0];f[2*h+1]=i[1];n[v]=true;h++}}}var g=new Float32Array(h*2*3);for(var c=0,p=h;c<p;c++){for(var m=0;m<2;m++){var y=u[f[2*c+m]];var E=6*c+3*m;g[E+0]=y.x;g[E+1]=y.y;g[E+2]=y.z}}a.addAttribute("position",new THREE.BufferAttribute(g,3))}else if(t.geometry instanceof THREE.BufferGeometry){if(t.geometry.attributes.index!==undefined){var u=t.geometry.attributes.position.array;var _=t.geometry.attributes.index.array;var x=t.geometry.drawcalls;var h=0;if(x.length===0){x=[{count:_.length,index:0,start:0}]}var f=new Uint32Array(2*_.length);for(var b=0,T=x.length;b<T;++b){var w=x[b].start;var R=x[b].count;var E=x[b].index;for(var c=w,H=w+R;c<H;c+=3){for(var m=0;m<3;m++){i[0]=E+_[c+m];i[1]=E+_[c+(m+1)%3];i.sort(o);var v=i.toString();if(n[v]===undefined){f[2*h]=i[0];f[2*h+1]=i[1];n[v]=true;h++}}}}var g=new Float32Array(h*2*3);for(var c=0,p=h;c<p;c++){for(var m=0;m<2;m++){var E=6*c+3*m;var M=3*f[2*c+m];g[E+0]=u[M];g[E+1]=u[M+1];g[E+2]=u[M+2]}}a.addAttribute("position",new THREE.BufferAttribute(g,3))}else{var u=t.geometry.attributes.position.array;var h=u.length/3;var S=h/3;var g=new Float32Array(h*2*3);for(var c=0,p=S;c<p;c++){for(var m=0;m<3;m++){var E=18*c+6*m;var k=9*c+3*m;g[E+0]=u[k];g[E+1]=u[k+1];g[E+2]=u[k+2];var M=9*c+3*((m+1)%3);g[E+3]=u[M];g[E+4]=u[M+1];g[E+5]=u[M+2]}}a.addAttribute("position",new THREE.BufferAttribute(g,3))}}THREE.Line.call(this,a,new THREE.LineBasicMaterial({color:r}),THREE.LinePieces);this.matrix=t.matrixWorld;this.matrixAutoUpdate=false};THREE.WireframeHelper.prototype=Object.create(THREE.Line.prototype);THREE.WireframeHelper.prototype.constructor=THREE.WireframeHelper;THREE.ImmediateRenderObject=function(){THREE.Object3D.call(this);this.render=function(t){}};THREE.ImmediateRenderObject.prototype=Object.create(THREE.Object3D.prototype);THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject;THREE.MorphBlendMesh=function(t,e){THREE.Mesh.call(this,t,e);this.animationsMap={};this.animationsList=[];var r=this.geometry.morphTargets.length;var i="__default";var n=0;var o=r-1;var s=r/1;this.createAnimation(i,n,o,s);this.setAnimationWeight(i,1)};THREE.MorphBlendMesh.prototype=Object.create(THREE.Mesh.prototype);THREE.MorphBlendMesh.prototype.constructor=THREE.MorphBlendMesh;THREE.MorphBlendMesh.prototype.createAnimation=function(t,e,r,i){var n={startFrame:e,endFrame:r,length:r-e+1,fps:i,duration:(r-e)/i,lastFrame:0,currentFrame:0,active:false,time:0,direction:1,weight:1,directionBackwards:false,mirroredLoop:false};this.animationsMap[t]=n;this.animationsList.push(n)};THREE.MorphBlendMesh.prototype.autoCreateAnimations=function(t){var e=/([a-z]+)_?(\d+)/;var r,i={};var n=this.geometry;for(var o=0,s=n.morphTargets.length;o<s;o++){var a=n.morphTargets[o];var u=a.name.match(e);if(u&&u.length>1){var l=u[1];if(!i[l])i[l]={start:Infinity,end:-Infinity};var h=i[l];if(o<h.start)h.start=o;if(o>h.end)h.end=o;if(!r)r=l}}for(var l in i){var h=i[l];this.createAnimation(l,h.start,h.end,t)}this.firstAnimation=r};THREE.MorphBlendMesh.prototype.setAnimationDirectionForward=function(t){var e=this.animationsMap[t];if(e){e.direction=1;e.directionBackwards=false}};THREE.MorphBlendMesh.prototype.setAnimationDirectionBackward=function(t){var e=this.animationsMap[t];if(e){e.direction=-1;e.directionBackwards=true}};THREE.MorphBlendMesh.prototype.setAnimationFPS=function(t,e){var r=this.animationsMap[t];if(r){r.fps=e;r.duration=(r.end-r.start)/r.fps}};THREE.MorphBlendMesh.prototype.setAnimationDuration=function(t,e){var r=this.animationsMap[t];if(r){r.duration=e;r.fps=(r.end-r.start)/r.duration}};THREE.MorphBlendMesh.prototype.setAnimationWeight=function(t,e){var r=this.animationsMap[t];if(r){r.weight=e}};THREE.MorphBlendMesh.prototype.setAnimationTime=function(t,e){var r=this.animationsMap[t];if(r){r.time=e}};THREE.MorphBlendMesh.prototype.getAnimationTime=function(t){var e=0;var r=this.animationsMap[t];if(r){e=r.time}return e};THREE.MorphBlendMesh.prototype.getAnimationDuration=function(t){var e=-1;var r=this.animationsMap[t];if(r){e=r.duration}return e};THREE.MorphBlendMesh.prototype.playAnimation=function(t){var e=this.animationsMap[t];if(e){e.time=0;e.active=true}else{THREE.warn("THREE.MorphBlendMesh: animation["+t+"] undefined in .playAnimation()")}};THREE.MorphBlendMesh.prototype.stopAnimation=function(t){var e=this.animationsMap[t];if(e){e.active=false}};THREE.MorphBlendMesh.prototype.update=function(t){for(var e=0,r=this.animationsList.length;e<r;e++){var i=this.animationsList[e];if(!i.active)continue;var n=i.duration/i.length;i.time+=i.direction*t;if(i.mirroredLoop){if(i.time>i.duration||i.time<0){i.direction*=-1;if(i.time>i.duration){i.time=i.duration;i.directionBackwards=true}if(i.time<0){i.time=0;i.directionBackwards=false}}}else{i.time=i.time%i.duration;if(i.time<0)i.time+=i.duration}var o=i.startFrame+THREE.Math.clamp(Math.floor(i.time/n),0,i.length-1);var s=i.weight;if(o!==i.currentFrame){this.morphTargetInfluences[i.lastFrame]=0;this.morphTargetInfluences[i.currentFrame]=1*s;this.morphTargetInfluences[o]=0;i.lastFrame=i.currentFrame;i.currentFrame=o}var a=i.time%n/n;if(i.directionBackwards)a=1-a;this.morphTargetInfluences[i.currentFrame]=a*s;this.morphTargetInfluences[i.lastFrame]=(1-a)*s}};(function(){var t;var e=[],r=[];var i=0;var n=+new Date+"";var o=75;var s=40;var a=" \t\v\f \ufeff"+"\n\r\u2028\u2029"+" ᠎             　";var u=/\b__p \+= '';/g,l=/\b(__p \+=) '' \+/g,h=/(__e\(.*?\)|\b__t\)) \+\n'';/g;var f=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;var c=/\w*$/;var p=/^\s*function[ \n\r\t]+\w/;var d=/<%=([\s\S]+?)%>/g;var m=RegExp("^["+a+"]*0+(?=.$)");var v=/($^)/;var g=/\bthis\b/;var y=/['\n\r\t\u2028\u2029\\]/g;var E=["Array","Boolean","Date","Function","Math","Number","Object","RegExp","String","_","attachEvent","clearTimeout","isFinite","isNaN","parseInt","setTimeout"];var _=0;var x="[object Arguments]",b="[object Array]",T="[object Boolean]",w="[object Date]",R="[object Function]",H="[object Number]",M="[object Object]",S="[object RegExp]",k="[object String]";var A={};A[R]=false;A[x]=A[b]=A[T]=A[w]=A[H]=A[M]=A[S]=A[k]=true;var C={leading:false,maxWait:0,trailing:false};var L={configurable:false,enumerable:false,value:null,writable:false};var P={boolean:false,function:true,object:true,number:false,string:false,undefined:false};var z={"\\":"\\","'":"'","\n":"n","\r":"r","\t":"t","\u2028":"u2028","\u2029":"u2029"};var D=P[typeof window]&&window||this;var O=P[typeof exports]&&exports&&!exports.nodeType&&exports;var F=P[typeof module]&&module&&!module.nodeType&&module;var U=F&&F.exports===O&&O;var B=P[typeof global]&&global;if(B&&(B.global===B||B.window===B)){D=B}function V(t,e,r){var i=(r||0)-1,n=t?t.length:0;while(++i<n){if(t[i]===e){return i}}return-1}function N(t,e){var r=typeof e;t=t.cache;if(r=="boolean"||e==null){return t[e]?0:-1}if(r!="number"&&r!="string"){r="object"}var i=r=="number"?e:n+e;t=(t=t[r])&&t[i];return r=="object"?t&&V(t,e)>-1?0:-1:t?0:-1}function I(t){var e=this.cache,r=typeof t;if(r=="boolean"||t==null){e[t]=true}else{if(r!="number"&&r!="string"){r="object"}var i=r=="number"?t:n+t,o=e[r]||(e[r]={});if(r=="object"){(o[i]||(o[i]=[])).push(t)}else{o[i]=true}}}function j(t){return t.charCodeAt(0)}function G(t,e){var r=t.criteria,i=e.criteria,n=-1,o=r.length;while(++n<o){var s=r[n],a=i[n];if(s!==a){if(s>a||typeof s=="undefined"){return 1}if(s<a||typeof a=="undefined"){return-1}}}return t.index-e.index}function W(t){var e=-1,r=t.length,i=t[0],n=t[r/2|0],o=t[r-1];if(i&&typeof i=="object"&&n&&typeof n=="object"&&o&&typeof o=="object"){return false}var s=Y();s["false"]=s["null"]=s["true"]=s["undefined"]=false;var a=Y();a.array=t;a.cache=s;a.push=I;while(++e<r){a.push(t[e])}return a}function X(t){return"\\"+z[t]}function q(){return e.pop()||[]}function Y(){return r.pop()||{array:null,cache:null,criteria:null,false:false,index:0,null:false,number:null,object:null,push:null,string:null,true:false,undefined:false,value:null}}function Z(t){t.length=0;if(e.length<s){e.push(t)}}function K(t){var e=t.cache;if(e){K(e)}t.array=t.cache=t.criteria=t.object=t.number=t.string=t.value=null;if(r.length<s){r.push(t)}}function Q(t,e,r){e||(e=0);if(typeof r=="undefined"){r=t?t.length:0}var i=-1,n=r-e||0,o=Array(n<0?0:n);while(++i<n){o[i]=t[e+i]}return o}function J(e){e=e?$.defaults(D.Object(),e,$.pick(D,E)):D;var r=e.Array,s=e.Boolean,z=e.Date,O=e.Function,F=e.Math,U=e.Number,B=e.Object,I=e.RegExp,tt=e.String,et=e.TypeError;var rt=[];var it=B.prototype;var nt=e._;var ot=it.toString;var st=I("^"+tt(ot).replace(/[.*+?^${}()|[\]\\]/g,"\\$&").replace(/toString| for [^\]]+/g,".*?")+"$");var at=F.ceil,ut=e.clearTimeout,lt=F.floor,ht=O.prototype.toString,ft=Xt(ft=B.getPrototypeOf)&&ft,ct=it.hasOwnProperty,pt=rt.push,dt=e.setTimeout,mt=rt.splice,vt=rt.unshift;var gt=function(){try{var t={},e=Xt(e=B.defineProperty)&&e,r=e(t,t,t)&&e}catch(t){}return r}();var yt=Xt(yt=B.create)&&yt,Et=Xt(Et=r.isArray)&&Et,_t=e.isFinite,xt=e.isNaN,bt=Xt(bt=B.keys)&&bt,Tt=F.max,wt=F.min,Rt=e.parseInt,Ht=F.random;var Mt={};Mt[b]=r;Mt[T]=s;Mt[w]=z;Mt[R]=O;Mt[M]=B;Mt[H]=U;Mt[S]=I;Mt[k]=tt;function St(t){return t&&typeof t=="object"&&!Qt(t)&&ct.call(t,"__wrapped__")?t:new kt(t)}function kt(t,e){this.__chain__=!!e;this.__wrapped__=t}kt.prototype=St.prototype;var At=St.support={};At.funcDecomp=!Xt(e.WinRTError)&&g.test(J);At.funcNames=typeof O.name=="string";St.templateSettings={escape:/<%-([\s\S]+?)%>/g,evaluate:/<%([\s\S]+?)%>/g,interpolate:d,variable:"",imports:{_:St}};function Ct(t){var e=t[0],r=t[2],i=t[4];function n(){if(r){var t=Q(r);pt.apply(t,arguments)}if(this instanceof n){var o=Pt(e.prototype),s=e.apply(o,t||arguments);return Re(s)?s:o}return e.apply(i,t||arguments)}qt(n,t);return n}function Lt(t,e,r,i,n){if(r){var o=r(t);if(typeof o!="undefined"){return o}}var s=Re(t);if(s){var a=ot.call(t);if(!A[a]){return t}var u=Mt[a];switch(a){case T:case w:return new u(+t);case H:case k:return new u(t);case S:o=u(t.source,c.exec(t));o.lastIndex=t.lastIndex;return o}}else{return t}var l=Qt(t);if(e){var h=!i;i||(i=q());n||(n=q());var f=i.length;while(f--){if(i[f]==t){return n[f]}}o=l?u(t.length):{}}else{o=l?Q(t):ne({},t)}if(l){if(ct.call(t,"index")){o.index=t.index}if(ct.call(t,"input")){o.input=t.input}}if(!e){return o}i.push(t);n.push(o);(l?qe:pe)(t,function(t,s){o[s]=Lt(t,e,r,i,n)});if(h){Z(i);Z(n)}return o}function Pt(t,e){return Re(t)?yt(t):{}}if(!yt){Pt=function(){function t(){}return function(r){if(Re(r)){t.prototype=r;var i=new t;t.prototype=null}return i||e.Object()}}()}function zt(t,e,r){if(typeof t!="function"){return Jr}if(typeof e=="undefined"||!("prototype"in t)){return t}var i=t.__bindData__;if(typeof i=="undefined"){if(At.funcNames){i=!t.name}i=i||!At.funcDecomp;if(!i){var n=ht.call(t);if(!At.funcNames){i=!p.test(n)}if(!i){i=g.test(n);qt(t,i)}}}if(i===false||i!==true&&i[1]&1){return t}switch(r){case 1:return function(r){return t.call(e,r)};case 2:return function(r,i){return t.call(e,r,i)};case 3:return function(r,i,n){return t.call(e,r,i,n)};case 4:return function(r,i,n,o){return t.call(e,r,i,n,o)}}return Dr(t,e)}function Dt(t){var e=t[0],r=t[1],i=t[2],n=t[3],o=t[4],s=t[5];var a=r&1,u=r&2,l=r&4,h=r&8,f=e;function c(){var t=a?o:this;if(i){var p=Q(i);pt.apply(p,arguments)}if(n||l){p||(p=Q(arguments));if(n){pt.apply(p,n)}if(l&&p.length<s){r|=16&~32;return Dt([e,h?r:r&~3,p,null,o,s])}}p||(p=arguments);if(u){e=t[f]}if(this instanceof c){t=Pt(e.prototype);var d=e.apply(t,p);return Re(d)?d:t}return e.apply(t,p)}qt(c,t);return c}function Ot(t,e){var r=-1,i=Wt(),n=t?t.length:0,s=n>=o&&i===V,a=[];if(s){var u=W(e);if(u){i=N;e=u}else{s=false}}while(++r<n){var l=t[r];if(i(e,l)<0){a.push(l)}}if(s){K(e)}return a}function Ft(t,e,r,i){var n=(i||0)-1,o=t?t.length:0,s=[];while(++n<o){var a=t[n];if(a&&typeof a=="object"&&typeof a.length=="number"&&(Qt(a)||Kt(a))){if(!e){a=Ft(a,e,r)}var u=-1,l=a.length,h=s.length;s.length+=l;while(++u<l){s[h++]=a[u]}}else if(!r){s.push(a)}}return s}function Ut(t,e,r,i,n,o){if(r){var s=r(t,e);if(typeof s!="undefined"){return!!s}}if(t===e){return t!==0||1/t==1/e}var a=typeof t,u=typeof e;if(t===t&&!(t&&P[a])&&!(e&&P[u])){return false}if(t==null||e==null){return t===e}var l=ot.call(t),h=ot.call(e);if(l==x){l=M}if(h==x){h=M}if(l!=h){return false}switch(l){case T:case w:return+t==+e;case H:return t!=+t?e!=+e:t==0?1/t==1/e:t==+e;case S:case k:return t==tt(e)}var f=l==b;if(!f){var c=ct.call(t,"__wrapped__"),p=ct.call(e,"__wrapped__");if(c||p){return Ut(c?t.__wrapped__:t,p?e.__wrapped__:e,r,i,n,o)}if(l!=M){return false}var d=t.constructor,m=e.constructor;if(d!=m&&!(we(d)&&d instanceof d&&we(m)&&m instanceof m)&&("constructor"in t&&"constructor"in e)){return false}}var v=!n;n||(n=q());o||(o=q());var g=n.length;while(g--){if(n[g]==t){return o[g]==e}}var y=0;s=true;n.push(t);o.push(e);if(f){g=t.length;y=e.length;s=y==g;if(s||i){while(y--){var E=g,_=e[y];if(i){while(E--){if(s=Ut(t[E],_,r,i,n,o)){break}}}else if(!(s=Ut(t[y],_,r,i,n,o))){break}}}}else{fe(e,function(e,a,u){if(ct.call(u,a)){y++;return s=ct.call(t,a)&&Ut(t[a],e,r,i,n,o)}});if(s&&!i){fe(t,function(t,e,r){if(ct.call(r,e)){return s=--y>-1}})}}n.pop();o.pop();if(v){Z(n);Z(o)}return s}function Bt(t,e,r,i,n){(Qt(e)?qe:pe)(e,function(e,o){var s,a,u=e,l=t[o];if(e&&((a=Qt(e))||ke(e))){var h=i.length;while(h--){if(s=i[h]==e){l=n[h];break}}if(!s){var f;if(r){u=r(l,e);if(f=typeof u!="undefined"){l=u}}if(!f){l=a?Qt(l)?l:[]:ke(l)?l:{}}i.push(e);n.push(l);if(!f){Bt(l,e,r,i,n)}}}else{if(r){u=r(l,e);if(typeof u=="undefined"){u=e}}if(typeof u!="undefined"){l=u}}t[o]=l})}function Vt(t,e){return t+lt(Ht()*(e-t+1))}function Nt(t,e,r){var i=-1,n=Wt(),s=t?t.length:0,a=[];var u=!e&&s>=o&&n===V,l=r||u?q():a;if(u){var h=W(l);n=N;l=h}while(++i<s){var f=t[i],c=r?r(f,i,t):f;if(e?!i||l[l.length-1]!==c:n(l,c)<0){if(r||u){l.push(c)}a.push(f)}}if(u){Z(l.array);K(l)}else if(r){Z(l)}return a}function It(t){return function(e,r,i){var n={};r=St.createCallback(r,i,3);var o=-1,s=e?e.length:0;if(typeof s=="number"){while(++o<s){var a=e[o];t(n,a,r(a,o,e),e)}}else{pe(e,function(e,i,o){t(n,e,r(e,i,o),o)})}return n}}function jt(t,e,r,i,n,o){var s=e&1,a=e&2,u=e&4,l=e&8,h=e&16,f=e&32;if(!a&&!we(t)){throw new et}if(h&&!r.length){e&=~16;h=r=false}if(f&&!i.length){e&=~32;f=i=false}var c=t&&t.__bindData__;if(c&&c!==true){c=Q(c);if(c[2]){c[2]=Q(c[2])}if(c[3]){c[3]=Q(c[3])}if(s&&!(c[1]&1)){c[4]=n}if(!s&&c[1]&1){e|=8}if(u&&!(c[1]&4)){c[5]=o}if(h){pt.apply(c[2]||(c[2]=[]),r)}if(f){vt.apply(c[3]||(c[3]=[]),i)}c[1]|=e;return jt.apply(null,c)}var p=e==1||e===17?Ct:Dt;return p([t,e,r,i,n,o])}function Gt(t){return te[t]}function Wt(){var t=(t=St.indexOf)===yr?V:t;return t}function Xt(t){return typeof t=="function"&&st.test(t)}var qt=!gt?ei:function(t,e){L.value=e;gt(t,"__bindData__",L)};function Yt(t){var e,r;if(!(t&&ot.call(t)==M)||(e=t.constructor,we(e)&&!(e instanceof e))){return false}fe(t,function(t,e){r=e});return typeof r=="undefined"||ct.call(t,r)}function Zt(t){return ee[t]}function Kt(t){return t&&typeof t=="object"&&typeof t.length=="number"&&ot.call(t)==x||false}var Qt=Et||function(t){return t&&typeof t=="object"&&typeof t.length=="number"&&ot.call(t)==b||false};var Jt=function(t){var e,r=t,i=[];if(!r)return i;if(!P[typeof t])return i;for(e in r){if(ct.call(r,e)){i.push(e)}}return i};var $t=!bt?Jt:function(t){if(!Re(t)){return[]}return bt(t)};var te={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"};var ee=ge(te);var re=I("("+$t(ee).join("|")+")","g"),ie=I("["+$t(te).join("")+"]","g");var ne=function(t,e,r){var i,n=t,o=n;if(!n)return o;var s=arguments,a=0,u=typeof r=="number"?2:s.length;if(u>3&&typeof s[u-2]=="function"){var l=zt(s[--u-1],s[u--],2)}else if(u>2&&typeof s[u-1]=="function"){l=s[--u]}while(++a<u){n=s[a];if(n&&P[typeof n]){var h=-1,f=P[typeof n]&&$t(n),c=f?f.length:0;while(++h<c){i=f[h];o[i]=l?l(o[i],n[i]):n[i]}}}return o};function oe(t,e,r,i){if(typeof e!="boolean"&&e!=null){i=r;r=e;e=false}return Lt(t,e,typeof r=="function"&&zt(r,i,1))}function se(t,e,r){return Lt(t,true,typeof e=="function"&&zt(e,r,1))}function ae(t,e){var r=Pt(t);return e?ne(r,e):r}var ue=function(t,e,r){var i,n=t,o=n;if(!n)return o;var s=arguments,a=0,u=typeof r=="number"?2:s.length;while(++a<u){n=s[a];if(n&&P[typeof n]){var l=-1,h=P[typeof n]&&$t(n),f=h?h.length:0;while(++l<f){i=h[l];if(typeof o[i]=="undefined")o[i]=n[i]}}}return o};function le(t,e,r){var i;e=St.createCallback(e,r,3);pe(t,function(t,r,n){if(e(t,r,n)){i=r;return false}});return i}function he(t,e,r){var i;e=St.createCallback(e,r,3);de(t,function(t,r,n){if(e(t,r,n)){i=r;return false}});return i}var fe=function(t,e,r){var i,n=t,o=n;if(!n)return o;if(!P[typeof n])return o;e=e&&typeof r=="undefined"?e:zt(e,r,3);for(i in n){if(e(n[i],i,t)===false)return o}return o};function ce(t,e,r){var i=[];fe(t,function(t,e){i.push(e,t)});var n=i.length;e=zt(e,r,3);while(n--){if(e(i[n--],i[n],t)===false){break}}return t}var pe=function(t,e,r){var i,n=t,o=n;if(!n)return o;if(!P[typeof n])return o;e=e&&typeof r=="undefined"?e:zt(e,r,3);var s=-1,a=P[typeof n]&&$t(n),u=a?a.length:0;while(++s<u){i=a[s];if(e(n[i],i,t)===false)return o}return o};function de(t,e,r){var i=$t(t),n=i.length;e=zt(e,r,3);while(n--){var o=i[n];if(e(t[o],o,t)===false){break}}return t}function me(t){var e=[];fe(t,function(t,r){if(we(t)){e.push(r)}});return e.sort()}function ve(t,e){return t?ct.call(t,e):false}function ge(t){var e=-1,r=$t(t),i=r.length,n={};while(++e<i){var o=r[e];n[t[o]]=o}return n}function ye(t){return t===true||t===false||t&&typeof t=="object"&&ot.call(t)==T||false}function Ee(t){return t&&typeof t=="object"&&ot.call(t)==w||false}function _e(t){return t&&t.nodeType===1||false}function xe(t){var e=true;if(!t){return e}var r=ot.call(t),i=t.length;if(r==b||r==k||r==x||r==M&&typeof i=="number"&&we(t.splice)){return!i}pe(t,function(){return e=false});return e}function be(t,e,r,i){return Ut(t,e,typeof r=="function"&&zt(r,i,2))}function Te(t){return _t(t)&&!xt(parseFloat(t))}function we(t){return typeof t=="function"}function Re(t){return!!(t&&P[typeof t])}function He(t){return Se(t)&&t!=+t}function Me(t){return t===null}function Se(t){return typeof t=="number"||t&&typeof t=="object"&&ot.call(t)==H||false}var ke=!ft?Yt:function(t){if(!(t&&ot.call(t)==M)){return false}var e=t.valueOf,r=Xt(e)&&(r=ft(e))&&ft(r);return r?t==r||ft(t)==r:Yt(t)};function Ae(t){return t&&typeof t=="object"&&ot.call(t)==S||false}function Ce(t){return typeof t=="string"||t&&typeof t=="object"&&ot.call(t)==k||false}function Le(t){return typeof t=="undefined"}function Pe(t,e,r){var i={};e=St.createCallback(e,r,3);pe(t,function(t,r,n){i[r]=e(t,r,n)});return i}function ze(t){var e=arguments,r=2;if(!Re(t)){return t}if(typeof e[2]!="number"){r=e.length}if(r>3&&typeof e[r-2]=="function"){var i=zt(e[--r-1],e[r--],2)}else if(r>2&&typeof e[r-1]=="function"){i=e[--r]}var n=Q(arguments,1,r),o=-1,s=q(),a=q();while(++o<r){Bt(t,n[o],i,s,a)}Z(s);Z(a);return t}function De(t,e,r){var i={};if(typeof e!="function"){var n=[];fe(t,function(t,e){n.push(e)});n=Ot(n,Ft(arguments,true,false,1));var o=-1,s=n.length;while(++o<s){var a=n[o];i[a]=t[a]}}else{e=St.createCallback(e,r,3);fe(t,function(t,r,n){if(!e(t,r,n)){i[r]=t}})}return i}function Oe(t){var e=-1,i=$t(t),n=i.length,o=r(n);while(++e<n){var s=i[e];o[e]=[s,t[s]]}return o}function Fe(t,e,r){var i={};if(typeof e!="function"){var n=-1,o=Ft(arguments,true,false,1),s=Re(t)?o.length:0;while(++n<s){var a=o[n];if(a in t){i[a]=t[a]}}}else{e=St.createCallback(e,r,3);fe(t,function(t,r,n){if(e(t,r,n)){i[r]=t}})}return i}function Ue(t,e,r,i){var n=Qt(t);if(r==null){if(n){r=[]}else{var o=t&&t.constructor,s=o&&o.prototype;r=Pt(s)}}if(e){e=St.createCallback(e,i,4);(n?qe:pe)(t,function(t,i,n){return e(r,t,i,n)})}return r}function Be(t){var e=-1,i=$t(t),n=i.length,o=r(n);while(++e<n){o[e]=t[i[e]]}return o}function Ve(t){var e=arguments,i=-1,n=Ft(e,true,false,1),o=e[2]&&e[2][e[1]]===t?1:n.length,s=r(o);while(++i<o){s[i]=t[n[i]]}return s}function Ne(t,e,r){var i=-1,n=Wt(),o=t?t.length:0,s=false;r=(r<0?Tt(0,o+r):r)||0;if(Qt(t)){s=n(t,e,r)>-1}else if(typeof o=="number"){s=(Ce(t)?t.indexOf(e,r):n(t,e,r))>-1}else{pe(t,function(t){if(++i>=r){return!(s=t===e)}})}return s}var Ie=It(function(t,e,r){ct.call(t,r)?t[r]++:t[r]=1});function je(t,e,r){var i=true;e=St.createCallback(e,r,3);var n=-1,o=t?t.length:0;if(typeof o=="number"){while(++n<o){if(!(i=!!e(t[n],n,t))){break}}}else{pe(t,function(t,r,n){return i=!!e(t,r,n)})}return i}function Ge(t,e,r){var i=[];e=St.createCallback(e,r,3);var n=-1,o=t?t.length:0;if(typeof o=="number"){while(++n<o){var s=t[n];if(e(s,n,t)){i.push(s)}}}else{pe(t,function(t,r,n){if(e(t,r,n)){i.push(t)}})}return i}function We(t,e,r){e=St.createCallback(e,r,3);var i=-1,n=t?t.length:0;if(typeof n=="number"){while(++i<n){var o=t[i];if(e(o,i,t)){return o}}}else{var s;pe(t,function(t,r,i){if(e(t,r,i)){s=t;return false}});return s}}function Xe(t,e,r){var i;e=St.createCallback(e,r,3);Ye(t,function(t,r,n){if(e(t,r,n)){i=t;return false}});return i}function qe(t,e,r){var i=-1,n=t?t.length:0;e=e&&typeof r=="undefined"?e:zt(e,r,3);if(typeof n=="number"){while(++i<n){if(e(t[i],i,t)===false){break}}}else{pe(t,e)}return t}function Ye(t,e,r){var i=t?t.length:0;e=e&&typeof r=="undefined"?e:zt(e,r,3);if(typeof i=="number"){while(i--){if(e(t[i],i,t)===false){break}}}else{var n=$t(t);i=n.length;pe(t,function(t,r,o){r=n?n[--i]:--i;return e(o[r],r,o)})}return t}var Ze=It(function(t,e,r){(ct.call(t,r)?t[r]:t[r]=[]).push(e)});var Ke=It(function(t,e,r){t[r]=e});function Qe(t,e){var i=Q(arguments,2),n=-1,o=typeof e=="function",s=t?t.length:0,a=r(typeof s=="number"?s:0);qe(t,function(t){a[++n]=(o?e:t[e]).apply(t,i)});return a}function Je(t,e,i){var n=-1,o=t?t.length:0;e=St.createCallback(e,i,3);if(typeof o=="number"){var s=r(o);while(++n<o){s[n]=e(t[n],n,t)}}else{s=[];pe(t,function(t,r,i){s[++n]=e(t,r,i)})}return s}function $e(t,e,r){var i=-Infinity,n=i;if(typeof e!="function"&&r&&r[e]===t){e=null}if(e==null&&Qt(t)){var o=-1,s=t.length;while(++o<s){var a=t[o];if(a>n){n=a}}}else{e=e==null&&Ce(t)?j:St.createCallback(e,r,3);qe(t,function(t,r,o){var s=e(t,r,o);if(s>i){i=s;n=t}})}return n}function tr(t,e,r){var i=Infinity,n=i;if(typeof e!="function"&&r&&r[e]===t){e=null}if(e==null&&Qt(t)){var o=-1,s=t.length;while(++o<s){var a=t[o];if(a<n){n=a}}}else{e=e==null&&Ce(t)?j:St.createCallback(e,r,3);qe(t,function(t,r,o){var s=e(t,r,o);if(s<i){i=s;n=t}})}return n}var er=Je;function rr(t,e,r,i){if(!t)return r;var n=arguments.length<3;e=St.createCallback(e,i,4);var o=-1,s=t.length;if(typeof s=="number"){if(n){r=t[++o]}while(++o<s){r=e(r,t[o],o,t)}}else{pe(t,function(t,i,o){r=n?(n=false,t):e(r,t,i,o)})}return r}function ir(t,e,r,i){var n=arguments.length<3;e=St.createCallback(e,i,4);Ye(t,function(t,i,o){r=n?(n=false,t):e(r,t,i,o)});return r}function nr(t,e,r){e=St.createCallback(e,r,3);return Ge(t,function(t,r,i){return!e(t,r,i)})}function or(e,r,i){if(e&&typeof e.length!="number"){e=Be(e)}if(r==null||i){return e?e[Vt(0,e.length-1)]:t}var n=sr(e);n.length=wt(Tt(0,r),n.length);return n}function sr(t){var e=-1,i=t?t.length:0,n=r(typeof i=="number"?i:0);qe(t,function(t){var r=Vt(0,++e);n[e]=n[r];n[r]=t});return n}function ar(t){var e=t?t.length:0;return typeof e=="number"?e:$t(t).length}function ur(t,e,r){var i;e=St.createCallback(e,r,3);var n=-1,o=t?t.length:0;if(typeof o=="number"){while(++n<o){if(i=e(t[n],n,t)){break}}}else{pe(t,function(t,r,n){return!(i=e(t,r,n))})}return!!i}function lr(t,e,i){var n=-1,o=Qt(e),s=t?t.length:0,a=r(typeof s=="number"?s:0);if(!o){e=St.createCallback(e,i,3)}qe(t,function(t,r,i){var s=a[++n]=Y();if(o){s.criteria=Je(e,function(e){return t[e]})}else{(s.criteria=q())[0]=e(t,r,i)}s.index=n;s.value=t});s=a.length;a.sort(G);while(s--){var u=a[s];a[s]=u.value;if(!o){Z(u.criteria)}K(u)}return a}function hr(t){if(t&&typeof t.length=="number"){return Q(t)}return Be(t)}var fr=Ge;function cr(t){var e=-1,r=t?t.length:0,i=[];while(++e<r){var n=t[e];if(n){i.push(n)}}return i}function pr(t){return Ot(t,Ft(arguments,true,true,1))}function dr(t,e,r){var i=-1,n=t?t.length:0;e=St.createCallback(e,r,3);while(++i<n){if(e(t[i],i,t)){return i}}return-1}function mr(t,e,r){var i=t?t.length:0;e=St.createCallback(e,r,3);while(i--){if(e(t[i],i,t)){return i}}return-1}function vr(e,r,i){var n=0,o=e?e.length:0;if(typeof r!="number"&&r!=null){var s=-1;r=St.createCallback(r,i,3);while(++s<o&&r(e[s],s,e)){n++}}else{n=r;if(n==null||i){return e?e[0]:t}}return Q(e,0,wt(Tt(0,n),o))}function gr(t,e,r,i){if(typeof e!="boolean"&&e!=null){i=r;r=typeof e!="function"&&i&&i[e]===t?null:e;e=false}if(r!=null){t=Je(t,r,i)}return Ft(t,e)}function yr(t,e,r){if(typeof r=="number"){var i=t?t.length:0;r=r<0?Tt(0,i+r):r||0}else if(r){var n=Mr(t,e);return t[n]===e?n:-1}return V(t,e,r)}function Er(t,e,r){var i=0,n=t?t.length:0;if(typeof e!="number"&&e!=null){var o=n;e=St.createCallback(e,r,3);while(o--&&e(t[o],o,t)){i++}}else{i=e==null||r?1:e||i}return Q(t,0,wt(Tt(0,n-i),n))}function _r(){var t=[],e=-1,r=arguments.length,i=q(),n=Wt(),s=n===V,a=q();while(++e<r){var u=arguments[e];if(Qt(u)||Kt(u)){t.push(u);i.push(s&&u.length>=o&&W(e?t[e]:a))}}var l=t[0],h=-1,f=l?l.length:0,c=[];t:while(++h<f){var p=i[0];u=l[h];if((p?N(p,u):n(a,u))<0){e=r;(p||a).push(u);while(--e){p=i[e];if((p?N(p,u):n(t[e],u))<0){continue t}}c.push(u)}}while(r--){p=i[r];if(p){K(p)}}Z(i);Z(a);return c}function xr(e,r,i){var n=0,o=e?e.length:0;if(typeof r!="number"&&r!=null){var s=o;r=St.createCallback(r,i,3);while(s--&&r(e[s],s,e)){n++}}else{n=r;if(n==null||i){return e?e[o-1]:t}}return Q(e,Tt(0,o-n))}function br(t,e,r){var i=t?t.length:0;if(typeof r=="number"){i=(r<0?Tt(0,i+r):wt(r,i-1))+1}while(i--){if(t[i]===e){return i}}return-1}function Tr(t){var e=arguments,r=0,i=e.length,n=t?t.length:0;while(++r<i){var o=-1,s=e[r];while(++o<n){if(t[o]===s){mt.call(t,o--,1);n--}}}return t}function wr(t,e,i){t=+t||0;i=typeof i=="number"?i:+i||1;if(e==null){e=t;t=0}var n=-1,o=Tt(0,at((e-t)/(i||1))),s=r(o);while(++n<o){s[n]=t;t+=i}return s}function Rr(t,e,r){var i=-1,n=t?t.length:0,o=[];e=St.createCallback(e,r,3);while(++i<n){var s=t[i];if(e(s,i,t)){o.push(s);mt.call(t,i--,1);n--}}return o}function Hr(t,e,r){if(typeof e!="number"&&e!=null){var i=0,n=-1,o=t?t.length:0;e=St.createCallback(e,r,3);while(++n<o&&e(t[n],n,t)){i++}}else{i=e==null||r?1:Tt(0,e)}return Q(t,i)}function Mr(t,e,r,i){var n=0,o=t?t.length:n;r=r?St.createCallback(r,i,1):Jr;e=r(e);while(n<o){var s=n+o>>>1;r(t[s])<e?n=s+1:o=s}return n}function Sr(){return Nt(Ft(arguments,true,true))}function kr(t,e,r,i){if(typeof e!="boolean"&&e!=null){i=r;r=typeof e!="function"&&i&&i[e]===t?null:e;e=false}if(r!=null){r=St.createCallback(r,i,3)}return Nt(t,e,r)}function Ar(t){return Ot(t,Q(arguments,1))}function Cr(){var t=-1,e=arguments.length;while(++t<e){var r=arguments[t];if(Qt(r)||Kt(r)){var i=i?Nt(Ot(i,r).concat(Ot(r,i))):r}}return i||[]}function Lr(){var t=arguments.length>1?arguments:arguments[0],e=-1,i=t?$e(er(t,"length")):0,n=r(i<0?0:i);while(++e<i){n[e]=er(t,e)}return n}function Pr(t,e){var r=-1,i=t?t.length:0,n={};if(!e&&i&&!Qt(t[0])){e=[]}while(++r<i){var o=t[r];if(e){n[o]=e[r]}else if(o){n[o[0]]=o[1]}}return n}function zr(t,e){if(!we(e)){throw new et}return function(){if(--t<1){return e.apply(this,arguments)}}}function Dr(t,e){return arguments.length>2?jt(t,17,Q(arguments,2),null,e):jt(t,1,null,null,e)}function Or(t){var e=arguments.length>1?Ft(arguments,true,false,1):me(t),r=-1,i=e.length;while(++r<i){var n=e[r];t[n]=jt(t[n],1,null,null,t)}return t}function Fr(t,e){return arguments.length>2?jt(e,19,Q(arguments,2),null,t):jt(e,3,null,null,t)}function Ur(){var t=arguments,e=t.length;while(e--){if(!we(t[e])){throw new et}}return function(){var e=arguments,r=t.length;while(r--){e=[t[r].apply(this,e)]}return e[0]}}function Br(t,e){e=typeof e=="number"?e:+e||t.length;return jt(t,4,null,null,null,e)}function Vr(e,r,i){var n,o,s,a,u,l,h,f=0,c=false,p=true;if(!we(e)){throw new et}r=Tt(0,r)||0;if(i===true){var d=true;p=false}else if(Re(i)){d=i.leading;c="maxWait"in i&&(Tt(r,i.maxWait)||0);p="trailing"in i?i.trailing:p}var m=function(){var i=r-(ri()-a);if(i<=0){if(o){ut(o)}var c=h;o=l=h=t;if(c){f=ri();s=e.apply(u,n);if(!l&&!o){n=u=null}}}else{l=dt(m,i)}};var v=function(){if(l){ut(l)}o=l=h=t;if(p||c!==r){f=ri();s=e.apply(u,n);if(!l&&!o){n=u=null}}};return function(){n=arguments;a=ri();u=this;h=p&&(l||!d);if(c===false){var t=d&&!l}else{if(!o&&!d){f=a}var i=c-(a-f),g=i<=0;if(g){if(o){o=ut(o)}f=a;s=e.apply(u,n)}else if(!o){o=dt(v,i)}}if(g&&l){l=ut(l)}else if(!l&&r!==c){l=dt(m,r)}if(t){g=true;s=e.apply(u,n)}if(g&&!l&&!o){n=u=null}return s}}function Nr(e){if(!we(e)){throw new et}var r=Q(arguments,1);return dt(function(){e.apply(t,r)},1)}function Ir(e,r){if(!we(e)){throw new et}var i=Q(arguments,2);return dt(function(){e.apply(t,i)},r)}function jr(t,e){if(!we(t)){throw new et}var r=function(){var i=r.cache,o=e?e.apply(this,arguments):n+arguments[0];return ct.call(i,o)?i[o]:i[o]=t.apply(this,arguments)};r.cache={};return r}function Gr(t){var e,r;if(!we(t)){throw new et}return function(){if(e){return r}e=true;r=t.apply(this,arguments);t=null;return r}}function Wr(t){return jt(t,16,Q(arguments,1))}function Xr(t){return jt(t,32,null,Q(arguments,1))}function qr(t,e,r){var i=true,n=true;if(!we(t)){throw new et}if(r===false){i=false}else if(Re(r)){i="leading"in r?r.leading:i;n="trailing"in r?r.trailing:n}C.leading=i;C.maxWait=e;C.trailing=n;return Vr(t,e,C)}function Yr(t,e){return jt(e,16,[t])}function Zr(t){return function(){return t}}function Kr(t,e,r){var i=typeof t;if(t==null||i=="function"){return zt(t,e,r)}if(i!="object"){return ni(t)}var n=$t(t),o=n[0],s=t[o];if(n.length==1&&s===s&&!Re(s)){return function(t){var e=t[o];return s===e&&(s!==0||1/s==1/e)}}return function(e){var r=n.length,i=false;while(r--){if(!(i=Ut(e[n[r]],t[n[r]],null,true))){break}}return i}}function Qr(t){return t==null?"":tt(t).replace(ie,Gt)}function Jr(t){return t}function $r(t,e,r){var i=true,n=e&&me(e);if(!e||!r&&!n.length){if(r==null){r=e}o=kt;e=t;t=St;n=me(e)}if(r===false){i=false}else if(Re(r)&&"chain"in r){i=r.chain}var o=t,s=we(o);qe(n,function(r){var n=t[r]=e[r];if(s){o.prototype[r]=function(){var e=this.__chain__,r=this.__wrapped__,s=[r];pt.apply(s,arguments);var a=n.apply(t,s);if(i||e){if(r===a&&Re(a)){return this}a=new o(a);a.__chain__=e}return a}}})}function ti(){e._=nt;return this}function ei(){}var ri=Xt(ri=z.now)&&ri||function(){return(new z).getTime()};var ii=Rt(a+"08")==8?Rt:function(t,e){return Rt(Ce(t)?t.replace(m,""):t,e||0)};function ni(t){return function(e){return e[t]}}function oi(t,e,r){var i=t==null,n=e==null;if(r==null){if(typeof t=="boolean"&&n){r=t;t=1}else if(!n&&typeof e=="boolean"){r=e;n=true}}if(i&&n){e=1}t=+t||0;if(n){e=t;t=0}else{e=+e||0}if(r||t%1||e%1){var o=Ht();return wt(t+o*(e-t+parseFloat("1e-"+((o+"").length-1))),e)}return Vt(t,e)}function si(t,e){if(t){var r=t[e];return we(r)?t[e]():r}}function ai(e,r,i){var n=St.templateSettings;e=tt(e||"");i=ue({},i,n);var o=ue({},i.imports,n.imports),s=$t(o),a=Be(o);var c,p=0,m=i.interpolate||v,g="__p += '";var E=I((i.escape||v).source+"|"+m.source+"|"+(m===d?f:v).source+"|"+(i.evaluate||v).source+"|$","g");e.replace(E,function(t,r,i,n,o,s){i||(i=n);g+=e.slice(p,s).replace(y,X);if(r){g+="' +\n__e("+r+") +\n'"}if(o){c=true;g+="';\n"+o+";\n__p += '"}if(i){g+="' +\n((__t = ("+i+")) == null ? '' : __t) +\n'"}p=s+t.length;return t});g+="';\n";var x=i.variable,b=x;if(!b){x="obj";g="with ("+x+") {\n"+g+"\n}\n"}g=(c?g.replace(u,""):g).replace(l,"$1").replace(h,"$1;");g="function("+x+") {\n"+(b?"":x+" || ("+x+" = {});\n")+"var __t, __p = '', __e = _.escape"+(c?", __j = Array.prototype.join;\n"+"function print() { __p += __j.call(arguments, '') }\n":";\n")+g+"return __p\n}";var T="\n/*\n//# sourceURL="+(i.sourceURL||"/lodash/template/source["+_+++"]")+"\n*/";try{var w=O(s,"return "+g+T).apply(t,a)}catch(t){t.source=g;throw t}if(r){return w(r)}w.source=g;return w}function ui(t,e,i){t=(t=+t)>-1?t:0;var n=-1,o=r(t);e=zt(e,i,1);while(++n<t){o[n]=e(n)}return o}function li(t){return t==null?"":tt(t).replace(re,Zt)}function hi(t){var e=++i;return tt(t==null?"":t)+e}function fi(t){t=new kt(t);t.__chain__=true;return t}function ci(t,e){e(t);return t}function pi(){this.__chain__=true;return this}function di(){return tt(this.__wrapped__)}function mi(){return this.__wrapped__}St.after=zr;St.assign=ne;St.at=Ve;St.bind=Dr;St.bindAll=Or;St.bindKey=Fr;St.chain=fi;St.compact=cr;St.compose=Ur;St.constant=Zr;St.countBy=Ie;St.create=ae;St.createCallback=Kr;St.curry=Br;St.debounce=Vr;St.defaults=ue;St.defer=Nr;St.delay=Ir;St.difference=pr;St.filter=Ge;St.flatten=gr;St.forEach=qe;St.forEachRight=Ye;St.forIn=fe;St.forInRight=ce;St.forOwn=pe;St.forOwnRight=de;St.functions=me;St.groupBy=Ze;St.indexBy=Ke;St.initial=Er;St.intersection=_r;St.invert=ge;St.invoke=Qe;St.keys=$t;St.map=Je;St.mapValues=Pe;St.max=$e;St.memoize=jr;St.merge=ze;St.min=tr;St.omit=De;St.once=Gr;St.pairs=Oe;St.partial=Wr;St.partialRight=Xr;St.pick=Fe;St.pluck=er;St.property=ni;St.pull=Tr;St.range=wr;St.reject=nr;St.remove=Rr;St.rest=Hr;St.shuffle=sr;St.sortBy=lr;St.tap=ci;St.throttle=qr;St.times=ui;St.toArray=hr;St.transform=Ue;St.union=Sr;St.uniq=kr;St.values=Be;St.where=fr;St.without=Ar;St.wrap=Yr;St.xor=Cr;St.zip=Lr;St.zipObject=Pr;St.collect=Je;St.drop=Hr;St.each=qe;St.eachRight=Ye;St.extend=ne;St.methods=me;St.object=Pr;St.select=Ge;St.tail=Hr;St.unique=kr;St.unzip=Lr;$r(St);St.clone=oe;St.cloneDeep=se;St.contains=Ne;St.escape=Qr;St.every=je;St.find=We;St.findIndex=dr;St.findKey=le;St.findLast=Xe;St.findLastIndex=mr;St.findLastKey=he;St.has=ve;St.identity=Jr;St.indexOf=yr;St.isArguments=Kt;St.isArray=Qt;St.isBoolean=ye;St.isDate=Ee;St.isElement=_e;St.isEmpty=xe;St.isEqual=be;St.isFinite=Te;St.isFunction=we;St.isNaN=He;St.isNull=Me;St.isNumber=Se;St.isObject=Re;St.isPlainObject=ke;St.isRegExp=Ae;St.isString=Ce;St.isUndefined=Le;St.lastIndexOf=br;St.mixin=$r;St.noConflict=ti;St.noop=ei;St.now=ri;St.parseInt=ii;St.random=oi;St.reduce=rr;St.reduceRight=ir;St.result=si;St.runInContext=J;St.size=ar;St.some=ur;St.sortedIndex=Mr;St.template=ai;St.unescape=li;St.uniqueId=hi;St.all=je;St.any=ur;St.detect=We;St.findWhere=We;St.foldl=rr;St.foldr=ir;St.include=Ne;St.inject=rr;$r(function(){var t={};pe(St,function(e,r){if(!St.prototype[r]){t[r]=e}});return t}(),false);St.first=vr;St.last=xr;St.sample=or;St.take=vr;St.head=vr;pe(St,function(t,e){var r=e!=="sample";if(!St.prototype[e]){St.prototype[e]=function(e,i){var n=this.__chain__,o=t(this.__wrapped__,e,i);return!n&&(e==null||i&&!(r&&typeof e=="function"))?o:new kt(o,n)}}});St.VERSION="2.4.1";St.prototype.chain=pi;St.prototype.toString=di;St.prototype.value=mi;St.prototype.valueOf=mi;qe(["join","pop","shift"],function(t){var e=rt[t];St.prototype[t]=function(){var t=this.__chain__,r=e.apply(this.__wrapped__,arguments);return t?new kt(r,t):r}});qe(["push","reverse","sort","unshift"],function(t){var e=rt[t];St.prototype[t]=function(){e.apply(this.__wrapped__,arguments);return this}});qe(["concat","slice","splice"],function(t){var e=rt[t];St.prototype[t]=function(){return new kt(e.apply(this.__wrapped__,arguments),this.__chain__)}});return St}var $=J();if(typeof define=="function"&&typeof define.amd=="object"&&define.amd){D._=$;define(function(){return $})}else if(O&&F){if(U){(F.exports=$)._=$}else{O._=$}}else{D._=$}}).call(this);THREE.Binder={bind:function(t,e){return function(r,i){if(!i.__binds){i.__binds=[]}var n=t;if(_.isArray(r)){n=r[0];r=r[1]}var o=/^([^.:]*(?:\.[^.:]+)*)?(?:\:(.*))?$/.exec(r);var s=o[1].split(/\./g);var a=s.pop();var u=o[2]||a;var l=s.shift();var h={this:i}[l]||e[l]||t[l]||n;while(h&&(r=s.shift())){h=h[r]}if(h&&(h.on||h.addEventListener)){var f=function(e){i[u]&&i[u](e,t)};THREE.Binder._polyfill(h,["addEventListener","on"],function(t){h[t](a,f)});var c={target:h,name:a,callback:f};i.__binds.push(c);return f}else{throw"Cannot bind '"+r+"' in "+this.__name}}},unbind:function(){return function(t){if(t.__binds){t.__binds.forEach(function(t){THREE.Binder._polyfill(t.target,["removeEventListener","off"],function(e){t.target[e](t.name,t.callback)})}.bind(this));t.__binds=[]}}},apply:function(t){THREE.EventDispatcher.prototype.apply(t);t.trigger=THREE.Binder._trigger;t.triggerOnce=THREE.Binder._triggerOnce;t.on=t.addEventListener;t.off=t.removeEventListener;t.dispatchEvent=t.trigger},_triggerOnce:function(t){this.trigger(t);if(this._listeners){delete this._listeners[t.type]}},_trigger:function(t){if(this._listeners===undefined)return;var e=t.type;var r=this._listeners[e];if(r!==undefined){r=r.slice();var i=r.length;t.target=this;for(var n=0;n<i;n++){r[n].call(this,t,this)}}},_polyfill:function(t,e,r){e.map(function(e){return t.method});if(e.length)r(e[0])}};THREE.Api={apply:function(t){t.set=function(t){var e=this.options||{};var r=_.reduce(t,function(t,r,i){if(e[i]!==r)t[i]=r;return t},{});this.options=_.extend(e,r);this.trigger({type:"change",options:t,changes:r})};t.get=function(){return this.options};t.api=function(t,e){t=t||{};e&&_.each(t,function(t,r,i){if(_.isFunction(t)){i[r]=_.partialRight(t,e)}});t.set=this.set.bind(this);t.get=this.get.bind(this);return t}}};THREE.Bootstrap=function(t){if(t){var e=[].slice.apply(arguments);t={};if(e[0]instanceof Node){node=e[0];e=e.slice(1);t.element=node}if(_.isString(e[0])){t.plugins=e}if(_.isArray(e[0])){t.plugins=e[0]}if(e[0]){t=_.defaults(t,e[0])}}if(!(this instanceof THREE.Bootstrap))return new THREE.Bootstrap(t);var r={init:true,element:document.body,plugins:["core"],aliases:{},plugindb:THREE.Bootstrap.Plugins||{},aliasdb:THREE.Bootstrap.Aliases||{}};this.__options=_.defaults(t||{},r);this.__inited=false;this.__destroyed=false;this.__installed=[];var i=this.__options.element;if(i===""+i){i=document.querySelector(i)}this.plugins={};this.element=i;if(this.__options.init){this.init()}};THREE.Bootstrap.prototype={init:function(){if(this.__inited)return;this.__inited=true;this.install(this.__options.plugins);return this},destroy:function(){if(!this.__inited)return;if(this.__destroyed)return;this.__destroyed=true;this.trigger({type:"destroy"});this.uninstall();return this},resolve:function(t){t=_.isArray(t)?t:[t];var e=this.__options;var r=_.extend({},e.aliasdb,e.aliases);var i=function(t){var e=t.split(":");if(!e[1])return true;r[e[0]]=[e[1]];return false};t=_.filter(t,i);_.each(r,function(t,e){r[e]=_.isArray(t)?t:[t]});function n(t,e,o){if(o>=256)throw"Plug-in alias recursion detected.";t=_.filter(t,i);_.each(t,function(t){var i=r[t];if(!i){e.push(t)}else{e=e.concat(n(i,[],o+1))}});return e}return n(t,[],0)},install:function(t){t=_.isArray(t)?t:[t];t=this.resolve(t);_.each(t,this.__install,this);this.__ready()},uninstall:function(t){if(t){t=_.isArray(t)?t:[t];t=this.resolve(t)}_.eachRight(t||this.__installed,this.__uninstall,this)},__install:function(t){var e=this.__options.plugindb[t];if(!e)throw"[three.install] Cannot install. '"+t+"' is not registered.";if(this.plugins[t])return console.warn("[three.install] "+t+" is already installed.");var r=e;var i=new r(this.__options[t]||{},t);this.plugins[t]=i;flag=i.install(this);this.__installed.push(i);this.trigger({type:"install",plugin:i});return flag},__uninstall:function(t,e){plugin=_.isString(t)?this.plugins[t]:t;if(!plugin)return console.warn("[three.uninstall] "+t+"' is not installed.");t=plugin.__name;plugin.uninstall(this);this.__installed=_.without(this.__installed,plugin);delete this.plugins[t];this.trigger({type:"uninstall",plugin:plugin})},__ready:function(){this.triggerOnce({type:"ready"})}};THREE.Binder.apply(THREE.Bootstrap.prototype);THREE.Bootstrap.Plugins={};THREE.Bootstrap.Aliases={};THREE.Bootstrap.Plugin=function(t){this.options=_.defaults(t||{},this.defaults)};THREE.Bootstrap.Plugin.prototype={listen:[],defaults:{},install:function(t){},uninstall:function(t){}};THREE.Binder.apply(THREE.Bootstrap.Plugin.prototype);THREE.Api.apply(THREE.Bootstrap.Plugin.prototype);THREE.Bootstrap.registerPlugin=function(t,e){var r=function(e){THREE.Bootstrap.Plugin.call(this,e);this.__name=t};r.prototype=_.extend(new THREE.Bootstrap.Plugin,e);THREE.Bootstrap.Plugins[t]=r};THREE.Bootstrap.unregisterPlugin=function(t){delete THREE.Bootstrap.Plugins[t]};THREE.Bootstrap.registerAlias=function(t,e){THREE.Bootstrap.Aliases[t]=e};THREE.Bootstrap.unregisterAlias=function(t){delete THREE.Bootstrap.Aliases[t]};THREE.Bootstrap.registerAlias("empty",["fallback","bind","renderer","size","fill","loop","time"]);THREE.Bootstrap.registerAlias("core",["empty","scene","camera","render","warmup"]);THREE.Bootstrap.registerAlias("VR",["core","cursor","fullscreen","render:vr"]);THREE.Bootstrap.registerPlugin("fallback",{defaults:{force:false,fill:true,begin:'<div class="threestrap-fallback" style="display: table; width: 100%; height: 100%;'+'box-sizing: border-box; border: 1px dashed rgba(0, 0, 0, .25);">'+'<div style="display: table-cell; padding: 10px; vertical-align: middle; text-align: center;">',end:"</div></div>",message:"<big><strong>This example requires WebGL</strong></big><br>"+'Visit <a target="_blank" href="http://get.webgl.org/">get.webgl.org</a> for more info</a>'},install:function(t){var e;try{e=document.createElement("canvas");gl=e.getContext("webgl")||e.getContext("experimental-webgl");if(!gl||this.options.force){throw"WebGL unavailable."}t.fallback=false}catch(e){var r=this.options.message;var i=this.options.begin;var n=this.options.end;var o=this.options.fill;var s=document.createElement("div");s.innerHTML=i+r+n;this.children=[];while(s.childNodes.length>0){this.children.push(s.firstChild);t.element.appendChild(s.firstChild)}if(o){t.install("fill")}this.div=s;t.fallback=true;return false}},uninstall:function(t){if(this.children){this.children.forEach(function(t){t.parentNode.removeChild(t)});this.children=null}delete t.fallback}});THREE.Bootstrap.registerPlugin("renderer",{defaults:{klass:THREE.WebGLRenderer,parameters:{depth:true,stencil:true,preserveDrawingBuffer:true,antialias:true}},listen:["resize"],install:function(t){var e=t.renderer=new this.options.klass(this.options.parameters);t.canvas=e.domElement;t.element.appendChild(e.domElement)},uninstall:function(t){t.element.removeChild(t.renderer.domElement);delete t.renderer;delete t.canvas},resize:function(t,e){var r=e.renderer;var i=r.domElement;if(i&&i.tagName=="CANVAS"){r.setSize(t.renderWidth,t.renderHeight,false)}else{if(r.setRenderSize){r.setRenderSize(t.renderWidth,t.renderHeight)}r.setSize(t.viewWidth,t.viewHeight,false)}}});THREE.Bootstrap.registerPlugin("bind",{install:function(t){var e={three:t,window:window};t.bind=THREE.Binder.bind(t,e);t.unbind=THREE.Binder.unbind(t);t.bind("install:bind",this);t.bind("uninstall:unbind",this)},uninstall:function(t){t.unbind(this);delete t.bind;delete t.unbind},bind:function(t,e){var r=t.plugin;var i=r.listen;i&&i.forEach(function(t){e.bind(t,r)})},unbind:function(t,e){e.unbind(t.plugin)}});THREE.Bootstrap.registerPlugin("size",{defaults:{width:null,height:null,aspect:null,scale:1,maxRenderWidth:Infinity,maxRenderHeight:Infinity,devicePixelRatio:true},listen:["window.resize:queue","element.resize:queue","this.change:queue","ready:resize","pre:pre"],install:function(t){t.Size=this.api({renderWidth:0,renderHeight:0,viewWidth:0,viewHeight:0});this.resized=false},uninstall:function(t){delete t.Size},queue:function(t,e){this.resized=true},pre:function(t,e){if(!this.resized)return;this.resized=false;this.resize(t,e)},resize:function(t,e){var r=this.options;var i=e.element;var n=e.renderer;var o,s,a,u,l,h,f,c,p,d,m=0,v=0;o=a=r.width===undefined||r.width==null?i.offsetWidth||i.innerWidth||0:r.width;s=u=r.height===undefined||r.height==null?i.offsetHeight||i.innerHeight||0:r.height;f=o/s;if(r.aspect){if(r.aspect>f){s=Math.round(o/r.aspect);v=Math.floor((u-s)/2)}else{o=Math.round(s*r.aspect);m=Math.floor((a-o)/2)}f=o/s}d=1;if(r.devicePixelRatio&&typeof window!="undefined"){d=window.devicePixelRatio||1}l=Math.min(o*d*r.scale,r.maxRenderWidth);h=Math.min(s*d*r.scale,r.maxRenderHeight);raspect=l/h;if(raspect>f){l=Math.round(h*f)}else{h=Math.round(l/f)}d=h/s;p=n.domElement.style;p.width=o+"px";p.height=s+"px";p.marginLeft=m+"px";p.marginTop=v+"px";_.extend(e.Size,{renderWidth:l,renderHeight:h,viewWidth:o,viewHeight:s,aspect:f,pixelRatio:d});e.trigger({type:"resize",renderWidth:l,renderHeight:h,viewWidth:o,viewHeight:s,aspect:f,pixelRatio:d})}});THREE.Bootstrap.registerPlugin("fill",{defaults:{block:true,body:true,layout:true},install:function(t){function e(t){var e=t.style.height;return e=="auto"||e==""}function r(t){t.style.height="100%";t.style.margin=0;t.style.padding=0;return t}if(this.options.body&&t.element==document.body){this.applied=[t.element,document.documentElement].filter(e).map(r)}if(this.options.block&&t.canvas){t.canvas.style.display="block";this.block=true}if(this.options.layout&&t.element){var i=window.getComputedStyle(t.element);if(i.position=="static"){t.element.style.position="relative";this.layout=true}}},uninstall:function(t){if(this.applied){function e(t){t.style.height="";t.style.margin="";t.style.padding="";return t}this.applied.map(e);delete this.applied}if(this.block&&t.canvas){t.canvas.style.display="";delete this.block}if(this.layout&&t.element){t.element.style.position="";delete this.layout}},change:function(t){this.uninstall(t);this.install(t)}});THREE.Bootstrap.registerPlugin("loop",{defaults:{start:true},listen:["ready"],install:function(t){this.running=false;t.Loop=this.api({start:this.start.bind(this),stop:this.stop.bind(this),running:false},t);this.events=["pre","update","render","post"].map(function(t){return{type:t}})},uninstall:function(t){this.stop(t)},ready:function(t,e){if(this.options.start)this.start(e)},start:function(t){if(this.running)return;t.Loop.running=this.running=true;var e=t.trigger.bind(t);var r=function(){this.running&&requestAnimationFrame(r);this.events.map(e)}.bind(this);requestAnimationFrame(r);t.trigger({type:"start"})},stop:function(t){if(!this.running)return;t.Loop.running=this.running=false;t.trigger({type:"stop"})}});THREE.Bootstrap.registerPlugin("time",{defaults:{speed:1,warmup:0,timeout:1},listen:["pre:tick","this.change"],now:function(){return+new Date/1e3},install:function(t){t.Time=this.api({now:this.now(),clock:0,step:1/60,frames:0,time:0,delta:1/60,average:0,fps:0});this.last=0;this.time=0;this.clock=0;this.wait=this.options.warmup;this.clockStart=0;this.timeStart=0},tick:function(t,e){var r=this.options.speed;var i=this.options.timeout;var n=e.Time;var o=n.now=this.now();var s=this.last;var a=this.time;var u=this.clock;if(s){var l=n.delta=o-s;var h=n.average||l;if(l>i){l=0}var f=l*r;a+=l;u+=f;if(n.frames>0){n.average=h+(l-h)*.1;n.fps=1/h}n.step=f;n.clock=u-this.clockStart;n.time=a-this.timeStart;n.frames++;if(this.wait-- >0){this.clockStart=u;this.timeStart=a;n.clock=0;n.step=1e-100}}this.last=o;this.clock=u;this.time=a},uninstall:function(t){delete t.Time}});THREE.Bootstrap.registerPlugin("scene",{install:function(t){t.scene=new THREE.Scene},uninstall:function(t){delete t.scene}});THREE.Bootstrap.registerPlugin("camera",{defaults:{near:.01,far:1e4,type:"perspective",fov:60,aspect:null,left:-1,right:1,bottom:-1,top:1,klass:null,parameters:null},listen:["resize","this.change"],install:function(t){t.Camera=this.api();t.camera=null;this.aspect=1;this.change({},t)},uninstall:function(t){delete t.Camera;delete t.camera},change:function(t,e){var r=this.options;var i=e.camera;if(!e.camera||t.changes.type||t.changes.klass){var n=r.klass||{perspective:THREE.PerspectiveCamera,orthographic:THREE.OrthographicCamera}[r.type]||THREE.Camera;e.camera=r.parameters?new n(r.parameters):new n}_.each(r,function(t,i){if(e.camera.hasOwnProperty(i))e.camera[i]=r[i]}.bind(this));this.update(e);i===e.camera||e.trigger({type:"camera",camera:e.camera})},resize:function(t,e){this.aspect=t.viewWidth/Math.max(1,t.viewHeight);this.update(e)},update:function(t){t.camera.aspect=this.options.aspect||this.aspect;t.camera.updateProjectionMatrix()}});THREE.Bootstrap.registerPlugin("render",{listen:["render"],render:function(t,e){if(e.scene&&e.camera){e.renderer.render(e.scene,e.camera)}}});THREE.Bootstrap.registerPlugin("warmup",{defaults:{delay:2},listen:["ready","post"],ready:function(t,e){e.renderer.domElement.style.visibility="hidden";this.frame=0;this.hidden=true},post:function(t,e){if(this.hidden&&this.frame>=this.options.delay){e.renderer.domElement.style.visibility="visible";this.hidden=false}this.frame++}});THREE.Stats=function(){var t=Date.now(),e=t,r=0,i=Infinity,n=0,o=0,s=Infinity,a=0,u=0,l=0,h=document.createElement("div");h.id="stats";h.addEventListener("mousedown",function(t){t.preventDefault();y(++l%2)},!1);h.style.cssText="width:80px;opacity:0.9;cursor:pointer";var f=document.createElement("div");f.id="fps";f.style.cssText="padding:0 0 3px 3px;text-align:left;background-color:#002";h.appendChild(f);var c=document.createElement("div");c.id="fpsText";c.style.cssText="color:#0ff;font-family:Helvetica,Arial,sans-serif;font-size:9px;font-weight:bold;line-height:15px";c.innerHTML="FPS";f.appendChild(c);var p=document.createElement("div");p.id="fpsGraph";p.style.cssText="position:relative;width:74px;height:30px;background-color:#0ff";for(f.appendChild(p);74>p.children.length;){var d=document.createElement("span");d.style.cssText="width:1px;height:30px;float:left;background-color:#113";p.appendChild(d)}var m=document.createElement("div");m.id="ms";m.style.cssText="padding:0 0 3px 3px;text-align:left;background-color:#020;display:none";h.appendChild(m);var v=document.createElement("div");v.id="msText";v.style.cssText="color:#0f0;font-family:Helvetica,Arial,sans-serif;font-size:9px;font-weight:bold;line-height:15px";v.innerHTML="MS";m.appendChild(v);var g=document.createElement("div");g.id="msGraph";g.style.cssText="position:relative;width:74px;height:30px;background-color:#0f0";for(m.appendChild(g);74>g.children.length;)d=document.createElement("span"),d.style.cssText="width:1px;height:30px;float:left;background-color:#131",g.appendChild(d);var y=function(t){l=t;switch(l){case 0:f.style.display="block";m.style.display="none";break;case 1:f.style.display="none",m.style.display="block"}};return{REVISION:11,domElement:h,setMode:y,begin:function(){t=Date.now()},end:function(){var l=Date.now();r=l-t;i=Math.min(i,r);n=Math.max(n,r);v.textContent=r+" MS ("+i+"-"+n+")";var h=Math.min(30,30-30*(r/200));g.appendChild(g.firstChild).style.height=h+"px";u++;l>e+1e3&&(o=Math.round(1e3*u/(l-e)),s=Math.min(s,o),a=Math.max(a,o),c.textContent=o+" FPS ("+s+"-"+a+")",h=Math.min(30,30-30*(o/100)),p.appendChild(p.firstChild).style.height=h+"px",e=l,u=0);return l},update:function(){t=this.end()}}};THREE.DeviceOrientationControls=function(t){var e=this;this.object=t;this.object.rotation.reorder("YXZ");this.freeze=true;this.deviceOrientation={};this.screenOrientation=0;var r=function(t){e.deviceOrientation=t};var i=function(){e.screenOrientation=window.orientation||0};var n=function(){var t=new THREE.Vector3(0,0,1);var e=new THREE.Euler;var r=new THREE.Quaternion;var i=new THREE.Quaternion(-Math.sqrt(.5),0,0,Math.sqrt(.5));return function(n,o,s,a,u){e.set(s,o,-a,"YXZ");n.setFromEuler(e);n.multiply(i);n.multiply(r.setFromAxisAngle(t,-u))}}();this.connect=function(){i();window.addEventListener("orientationchange",i,false);window.addEventListener("deviceorientation",r,false);e.freeze=false};this.disconnect=function(){e.freeze=true;window.removeEventListener("orientationchange",i,false);window.removeEventListener("deviceorientation",r,false)};this.update=function(){if(e.freeze)return;var t=e.deviceOrientation.gamma?THREE.Math.degToRad(e.deviceOrientation.alpha):0;var r=e.deviceOrientation.beta?THREE.Math.degToRad(e.deviceOrientation.beta):0;var i=e.deviceOrientation.gamma?THREE.Math.degToRad(e.deviceOrientation.gamma):0;var o=e.screenOrientation?THREE.Math.degToRad(e.screenOrientation):0;n(e.object.quaternion,t,r,i,o)}};THREE.FirstPersonControls=function(t,e){this.object=t;this.target=new THREE.Vector3(0,0,0);this.domElement=e!==undefined?e:document;this.movementSpeed=1;this.lookSpeed=.005;this.lookVertical=true;this.autoForward=false;this.activeLook=true;this.heightSpeed=false;this.heightCoef=1;this.heightMin=0;this.heightMax=1;this.constrainVertical=false;this.verticalMin=0;this.verticalMax=Math.PI;this.autoSpeedFactor=0;this.mouseX=0;this.mouseY=0;this.lat=0;this.lon=0;this.phi=0;this.theta=0;this.moveForward=false;this.moveBackward=false;this.moveLeft=false;this.moveRight=false;this.freeze=false;this.mouseDragOn=false;this.viewHalfX=0;this.viewHalfY=0;if(this.domElement!==document){this.domElement.setAttribute("tabindex",-1)}this.handleResize=function(){if(this.domElement===document){this.viewHalfX=window.innerWidth/2;this.viewHalfY=window.innerHeight/2}else{this.viewHalfX=this.domElement.offsetWidth/2;this.viewHalfY=this.domElement.offsetHeight/2}};this.onMouseDown=function(t){if(this.domElement!==document){this.domElement.focus()}t.preventDefault();t.stopPropagation();if(this.activeLook){switch(t.button){case 0:this.moveForward=true;break;case 2:this.moveBackward=true;break}}this.mouseDragOn=true};this.onMouseUp=function(t){t.preventDefault();t.stopPropagation();if(this.activeLook){switch(t.button){case 0:this.moveForward=false;break;case 2:this.moveBackward=false;break}}this.mouseDragOn=false};this.onMouseMove=function(t){if(this.domElement===document){this.mouseX=t.pageX-this.viewHalfX;this.mouseY=t.pageY-this.viewHalfY}else{this.mouseX=t.pageX-this.domElement.offsetLeft-this.viewHalfX;this.mouseY=t.pageY-this.domElement.offsetTop-this.viewHalfY}};this.onKeyDown=function(t){switch(t.keyCode){case 38:case 87:this.moveForward=true;break;case 37:case 65:this.moveLeft=true;break;case 40:case 83:this.moveBackward=true;break;case 39:case 68:this.moveRight=true;break;case 82:this.moveUp=true;break;case 70:this.moveDown=true;break;case 81:this.freeze=!this.freeze;break}};this.onKeyUp=function(t){switch(t.keyCode){case 38:case 87:this.moveForward=false;break;case 37:case 65:this.moveLeft=false;break;case 40:case 83:this.moveBackward=false;break;case 39:case 68:this.moveRight=false;break;case 82:this.moveUp=false;break;case 70:this.moveDown=false;break}};this.update=function(t){if(this.freeze){return}if(this.heightSpeed){var e=THREE.Math.clamp(this.object.position.y,this.heightMin,this.heightMax);var r=e-this.heightMin;this.autoSpeedFactor=t*(r*this.heightCoef)}else{this.autoSpeedFactor=0}var i=t*this.movementSpeed;if(this.moveForward||this.autoForward&&!this.moveBackward)this.object.translateZ(-(i+this.autoSpeedFactor));if(this.moveBackward)this.object.translateZ(i);if(this.moveLeft)this.object.translateX(-i);if(this.moveRight)this.object.translateX(i);if(this.moveUp)this.object.translateY(i);if(this.moveDown)this.object.translateY(-i);var n=t*this.lookSpeed;if(!this.activeLook){n=0}var o=1;if(this.constrainVertical){o=Math.PI/(this.verticalMax-this.verticalMin)}this.lon+=this.mouseX*n;if(this.lookVertical)this.lat-=this.mouseY*n*o;this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=THREE.Math.degToRad(90-this.lat);this.theta=THREE.Math.degToRad(this.lon);if(this.constrainVertical){this.phi=THREE.Math.mapLinear(this.phi,0,Math.PI,this.verticalMin,this.verticalMax)}var s=this.target,a=this.object.position;s.x=a.x+100*Math.sin(this.phi)*Math.cos(this.theta);s.y=a.y+100*Math.cos(this.phi);s.z=a.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.object.lookAt(s)};this.domElement.addEventListener("contextmenu",function(t){t.preventDefault()},false);this.domElement.addEventListener("mousemove",r(this,this.onMouseMove),false);this.domElement.addEventListener("mousedown",r(this,this.onMouseDown),false);this.domElement.addEventListener("mouseup",r(this,this.onMouseUp),false);this.domElement.addEventListener("keydown",r(this,this.onKeyDown),false);this.domElement.addEventListener("keyup",r(this,this.onKeyUp),false);function r(t,e){return function(){e.apply(t,arguments)}}this.handleResize()};THREE.OrbitControls=function(t,e){this.object=t;this.domElement=e!==undefined?e:document;this.enabled=true;this.target=new THREE.Vector3;this.center=this.target;this.noZoom=false;this.zoomSpeed=1;this.minDistance=0;this.maxDistance=Infinity;this.noRotate=false;this.rotateSpeed=1;this.noPan=false;this.keyPanSpeed=7;this.autoRotate=false;this.autoRotateSpeed=2;this.minPolarAngle=0;this.maxPolarAngle=Math.PI;this.noKeys=false;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};var r=this;var i=1e-6;var n=new THREE.Vector2;var o=new THREE.Vector2;var s=new THREE.Vector2;var a=new THREE.Vector2;var u=new THREE.Vector2;var l=new THREE.Vector2;var h=new THREE.Vector3;var f=new THREE.Vector3;var c=new THREE.Vector2;var p=new THREE.Vector2;var d=new THREE.Vector2;var m=0;var v=0;var g=1;var y=new THREE.Vector3;var E=new THREE.Vector3;var _={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5};var x=_.NONE;this.target0=this.target.clone();this.position0=this.object.position.clone();var b=(new THREE.Quaternion).setFromUnitVectors(t.up,new THREE.Vector3(0,1,0));var T=b.clone().inverse();var w={type:"change"};var R={type:"start"};var H={type:"end"};this.rotateLeft=function(t){if(t===undefined){t=M()}v-=t};this.rotateUp=function(t){if(t===undefined){t=M()}m-=t};this.panLeft=function(t){var e=this.object.matrix.elements;h.set(e[0],e[1],e[2]);h.multiplyScalar(-t);y.add(h)};this.panUp=function(t){var e=this.object.matrix.elements;h.set(e[4],e[5],e[6]);h.multiplyScalar(t);y.add(h)};this.pan=function(t,e){var i=r.domElement===document?r.domElement.body:r.domElement;if(r.object.fov!==undefined){var n=r.object.position;var o=n.clone().sub(r.target);var s=o.length();s*=Math.tan(r.object.fov/2*Math.PI/180);r.panLeft(2*t*s/i.clientHeight);r.panUp(2*e*s/i.clientHeight)}else if(r.object.top!==undefined){r.panLeft(t*(r.object.right-r.object.left)/i.clientWidth);r.panUp(e*(r.object.top-r.object.bottom)/i.clientHeight)}else{console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")}};this.dollyIn=function(t){if(t===undefined){t=S()}g/=t};this.dollyOut=function(t){if(t===undefined){t=S()}g*=t};this.update=function(){var t=this.object.position;f.copy(t).sub(this.target);f.applyQuaternion(b);var e=Math.atan2(f.x,f.z);var r=Math.atan2(Math.sqrt(f.x*f.x+f.z*f.z),f.y);if(this.autoRotate){this.rotateLeft(M())}e+=v;r+=m;r=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,r));r=Math.max(i,Math.min(Math.PI-i,r));var n=f.length()*g;n=Math.max(this.minDistance,Math.min(this.maxDistance,n));this.target.add(y);f.x=n*Math.sin(r)*Math.sin(e);f.y=n*Math.cos(r);f.z=n*Math.sin(r)*Math.cos(e);f.applyQuaternion(T);t.copy(this.target).add(f);this.object.lookAt(this.target);v=0;m=0;g=1;y.set(0,0,0);if(E.distanceToSquared(this.object.position)>i){this.dispatchEvent(w);E.copy(this.object.position)}};this.reset=function(){x=_.NONE;this.target.copy(this.target0);this.object.position.copy(this.position0);this.update()};function M(){return 2*Math.PI/60/60*r.autoRotateSpeed}function S(){return Math.pow(.95,r.zoomSpeed)}function k(t){if(r.enabled===false)return;t.preventDefault();if(t.button===0){if(r.noRotate===true)return;x=_.ROTATE;n.set(t.clientX,t.clientY)}else if(t.button===1){if(r.noZoom===true)return;x=_.DOLLY;c.set(t.clientX,t.clientY)}else if(t.button===2){if(r.noPan===true)return;x=_.PAN;a.set(t.clientX,t.clientY)}document.documentElement.addEventListener("mousemove",A,false);document.documentElement.addEventListener("mouseup",C,false);r.dispatchEvent(R)}function A(t){if(r.enabled===false)return;t.preventDefault();var e=r.domElement===document?r.domElement.body:r.domElement;if(x===_.ROTATE){if(r.noRotate===true)return;o.set(t.clientX,t.clientY);s.subVectors(o,n);r.rotateLeft(2*Math.PI*s.x/e.clientWidth*r.rotateSpeed);r.rotateUp(2*Math.PI*s.y/e.clientHeight*r.rotateSpeed);n.copy(o)}else if(x===_.DOLLY){if(r.noZoom===true)return;p.set(t.clientX,t.clientY);d.subVectors(p,c);if(d.y>0){r.dollyIn()}else{r.dollyOut()}c.copy(p)}else if(x===_.PAN){if(r.noPan===true)return;u.set(t.clientX,t.clientY);l.subVectors(u,a);r.pan(l.x,l.y);a.copy(u)}r.update()}function C(){if(r.enabled===false)return;document.documentElement.removeEventListener("mousemove",A,false);document.documentElement.removeEventListener("mouseup",C,false);r.dispatchEvent(H);x=_.NONE}function L(t){if(r.enabled===false||r.noZoom===true)return;t.preventDefault();t.stopPropagation();var e=0;if(t.wheelDelta!==undefined){e=t.wheelDelta}else if(t.detail!==undefined){e=-t.detail}if(e>0){r.dollyOut()}else{r.dollyIn()}r.update();r.dispatchEvent(R);r.dispatchEvent(H)}function P(t){if(r.enabled===false||r.noKeys===true||r.noPan===true)return;switch(t.keyCode){case r.keys.UP:r.pan(0,r.keyPanSpeed);r.update();break;case r.keys.BOTTOM:r.pan(0,-r.keyPanSpeed);r.update();break;case r.keys.LEFT:r.pan(r.keyPanSpeed,0);r.update();break;case r.keys.RIGHT:r.pan(-r.keyPanSpeed,0);r.update();break}}function z(t){if(r.enabled===false)return;switch(t.touches.length){case 1:if(r.noRotate===true)return;x=_.TOUCH_ROTATE;n.set(t.touches[0].pageX,t.touches[0].pageY);break;case 2:if(r.noZoom===true)return;x=_.TOUCH_DOLLY;var e=t.touches[0].pageX-t.touches[1].pageX;var i=t.touches[0].pageY-t.touches[1].pageY;var o=Math.sqrt(e*e+i*i);c.set(0,o);break;case 3:if(r.noPan===true)return;x=_.TOUCH_PAN;a.set(t.touches[0].pageX,t.touches[0].pageY);break;default:x=_.NONE}r.dispatchEvent(R)}function D(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();var e=r.domElement===document?r.domElement.body:r.domElement;switch(t.touches.length){case 1:if(r.noRotate===true)return;if(x!==_.TOUCH_ROTATE)return;o.set(t.touches[0].pageX,t.touches[0].pageY);s.subVectors(o,n);r.rotateLeft(2*Math.PI*s.x/e.clientWidth*r.rotateSpeed);r.rotateUp(2*Math.PI*s.y/e.clientHeight*r.rotateSpeed);n.copy(o);r.update();break;case 2:if(r.noZoom===true)return;if(x!==_.TOUCH_DOLLY)return;var i=t.touches[0].pageX-t.touches[1].pageX;var h=t.touches[0].pageY-t.touches[1].pageY;var f=Math.sqrt(i*i+h*h);p.set(0,f);d.subVectors(p,c);if(d.y>0){r.dollyOut()}else{r.dollyIn()}c.copy(p);r.update();break;case 3:if(r.noPan===true)return;if(x!==_.TOUCH_PAN)return;u.set(t.touches[0].pageX,t.touches[0].pageY);l.subVectors(u,a);r.pan(l.x,l.y);a.copy(u);r.update();break;default:x=_.NONE}}function O(){if(r.enabled===false)return;r.dispatchEvent(H);x=_.NONE}this.domElement.addEventListener("contextmenu",function(t){t.preventDefault()},false);this.domElement.addEventListener("mousedown",k,false);this.domElement.addEventListener("mousewheel",L,false);this.domElement.addEventListener("DOMMouseScroll",L,false);this.domElement.addEventListener("touchstart",z,false);this.domElement.addEventListener("touchend",O,false);this.domElement.addEventListener("touchmove",D,false);window.addEventListener("keydown",P,false);this.update()};THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype);THREE.TrackballControls=function(t,e){var r=this;var i={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4};this.object=t;this.domElement=e!==undefined?e:document;this.enabled=true;this.screen={left:0,top:0,width:0,height:0};this.rotateSpeed=1;this.zoomSpeed=1.2;this.panSpeed=.3;this.noRotate=false;this.noZoom=false;this.noPan=false;this.staticMoving=false;this.dynamicDampingFactor=.2;this.minDistance=0;this.maxDistance=Infinity;this.keys=[65,83,68];this.target=new THREE.Vector3;var n=1e-6;var o=new THREE.Vector3;var s=i.NONE,a=i.NONE,u=new THREE.Vector3,l=new THREE.Vector2,h=new THREE.Vector2,f=new THREE.Vector3,c=0,p=new THREE.Vector2,d=new THREE.Vector2,m=0,v=0,g=new THREE.Vector2,y=new THREE.Vector2;this.target0=this.target.clone();this.position0=this.object.position.clone();this.up0=this.object.up.clone();var E={type:"change"};var _={type:"start"};var x={type:"end"};this.handleResize=function(){if(this.domElement===document){this.screen.left=0;this.screen.top=0;this.screen.width=window.innerWidth;this.screen.height=window.innerHeight}else{var t=this.domElement.getBoundingClientRect();var e=this.domElement.ownerDocument.documentElement;this.screen.left=t.left+window.pageXOffset-e.clientLeft;this.screen.top=t.top+window.pageYOffset-e.clientTop;this.screen.width=t.width;this.screen.height=t.height}};this.handleEvent=function(t){if(typeof this[t.type]=="function"){this[t.type](t)}};var b=function(){var t=new THREE.Vector2;return function(e,i){t.set((e-r.screen.left)/r.screen.width,(i-r.screen.top)/r.screen.height);return t}}();var T=function(){var t=new THREE.Vector2;return function(e,i){t.set((e-r.screen.width*.5-r.screen.left)/(r.screen.width*.5),(r.screen.height+2*(r.screen.top-i))/r.screen.width);return t}}();this.rotateCamera=function(){var t=new THREE.Vector3,e=new THREE.Quaternion,i=new THREE.Vector3,n=new THREE.Vector3,o=new THREE.Vector3,s=new THREE.Vector3,a;return function(){s.set(h.x-l.x,h.y-l.y,0);a=s.length();if(a){u.copy(r.object.position).sub(r.target);i.copy(u).normalize();n.copy(r.object.up).normalize();o.crossVectors(n,i).normalize();n.setLength(h.y-l.y);o.setLength(h.x-l.x);s.copy(n.add(o));t.crossVectors(s,u).normalize();a*=r.rotateSpeed;e.setFromAxisAngle(t,a);u.applyQuaternion(e);r.object.up.applyQuaternion(e);f.copy(t);c=a}else if(!r.staticMoving&&c){c*=Math.sqrt(1-r.dynamicDampingFactor);u.copy(r.object.position).sub(r.target);e.setFromAxisAngle(f,c);u.applyQuaternion(e);r.object.up.applyQuaternion(e)}l.copy(h)}}();this.zoomCamera=function(){var t;if(s===i.TOUCH_ZOOM_PAN){t=m/v;m=v;u.multiplyScalar(t)}else{t=1+(d.y-p.y)*r.zoomSpeed;if(t!==1&&t>0){u.multiplyScalar(t);if(r.staticMoving){p.copy(d)}else{p.y+=(d.y-p.y)*this.dynamicDampingFactor}}}};this.panCamera=function(){var t=new THREE.Vector2,e=new THREE.Vector3,i=new THREE.Vector3;return function(){t.copy(y).sub(g);if(t.lengthSq()){t.multiplyScalar(u.length()*r.panSpeed);i.copy(u).cross(r.object.up).setLength(t.x);i.add(e.copy(r.object.up).setLength(t.y));r.object.position.add(i);r.target.add(i);if(r.staticMoving){g.copy(y)}else{g.add(t.subVectors(y,g).multiplyScalar(r.dynamicDampingFactor))}}}}();this.checkDistances=function(){if(!r.noZoom||!r.noPan){if(u.lengthSq()>r.maxDistance*r.maxDistance){r.object.position.addVectors(r.target,u.setLength(r.maxDistance))}if(u.lengthSq()<r.minDistance*r.minDistance){r.object.position.addVectors(r.target,u.setLength(r.minDistance))}}};this.update=function(){u.subVectors(r.object.position,r.target);if(!r.noRotate){r.rotateCamera()}if(!r.noZoom){r.zoomCamera()}if(!r.noPan){r.panCamera()}r.object.position.addVectors(r.target,u);r.checkDistances();r.object.lookAt(r.target);if(o.distanceToSquared(r.object.position)>n){r.dispatchEvent(E);o.copy(r.object.position)}};this.reset=function(){s=i.NONE;a=i.NONE;r.target.copy(r.target0);r.object.position.copy(r.position0);r.object.up.copy(r.up0);u.subVectors(r.object.position,r.target);r.object.lookAt(r.target);r.dispatchEvent(E);o.copy(r.object.position)};function w(t){if(r.enabled===false)return;window.removeEventListener("keydown",w);a=s;if(s!==i.NONE){return}else if(t.keyCode===r.keys[i.ROTATE]&&!r.noRotate){s=i.ROTATE}else if(t.keyCode===r.keys[i.ZOOM]&&!r.noZoom){s=i.ZOOM}else if(t.keyCode===r.keys[i.PAN]&&!r.noPan){s=i.PAN}}function R(t){if(r.enabled===false)return;s=a;window.addEventListener("keydown",w,false)}function H(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();if(s===i.NONE){s=t.button}if(s===i.ROTATE&&!r.noRotate){h.copy(T(t.pageX,t.pageY));l.copy(h)}else if(s===i.ZOOM&&!r.noZoom){p.copy(b(t.pageX,t.pageY));d.copy(p)}else if(s===i.PAN&&!r.noPan){g.copy(b(t.pageX,t.pageY));y.copy(g)}document.addEventListener("mousemove",M,false);document.addEventListener("mouseup",S,false);r.dispatchEvent(_)}function M(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();if(s===i.ROTATE&&!r.noRotate){l.copy(h);h.copy(T(t.pageX,t.pageY))}else if(s===i.ZOOM&&!r.noZoom){d.copy(b(t.pageX,t.pageY))}else if(s===i.PAN&&!r.noPan){y.copy(b(t.pageX,t.pageY))}}function S(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();s=i.NONE;document.removeEventListener("mousemove",M);document.removeEventListener("mouseup",S);r.dispatchEvent(x)}function k(t){if(r.enabled===false||r.noZoom)return;t.preventDefault();t.stopPropagation();var e=0;if(t.wheelDelta){e=t.wheelDelta/40}else if(t.detail){e=-t.detail/3}p.y+=e*.01;r.dispatchEvent(_);r.dispatchEvent(x)}function A(t){if(r.enabled===false)return;switch(t.touches.length){case 1:s=i.TOUCH_ROTATE;h.copy(T(t.touches[0].pageX,t.touches[0].pageY));l.copy(h);break;case 2:s=i.TOUCH_ZOOM_PAN;var e=t.touches[0].pageX-t.touches[1].pageX;var n=t.touches[0].pageY-t.touches[1].pageY;v=m=Math.sqrt(e*e+n*n);var o=(t.touches[0].pageX+t.touches[1].pageX)/2;var a=(t.touches[0].pageY+t.touches[1].pageY)/2;g.copy(b(o,a));y.copy(g);break;default:s=i.NONE}r.dispatchEvent(_)}function C(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();switch(t.touches.length){case 1:l.copy(h);h.copy(T(t.touches[0].pageX,t.touches[0].pageY));break;case 2:var e=t.touches[0].pageX-t.touches[1].pageX;var n=t.touches[0].pageY-t.touches[1].pageY;v=Math.sqrt(e*e+n*n);var o=(t.touches[0].pageX+t.touches[1].pageX)/2;var a=(t.touches[0].pageY+t.touches[1].pageY)/2;y.copy(b(o,a));break;default:s=i.NONE}}function L(t){if(r.enabled===false)return;switch(t.touches.length){case 1:l.copy(h);h.copy(T(t.touches[0].pageX,t.touches[0].pageY));break;case 2:m=v=0;var e=(t.touches[0].pageX+t.touches[1].pageX)/2;var n=(t.touches[0].pageY+t.touches[1].pageY)/2;y.copy(b(e,n));g.copy(y);break}s=i.NONE;r.dispatchEvent(x)}this.domElement.addEventListener("contextmenu",function(t){t.preventDefault()},false);this.domElement.addEventListener("mousedown",H,false);this.domElement.addEventListener("mousewheel",k,false);this.domElement.addEventListener("DOMMouseScroll",k,false);this.domElement.addEventListener("touchstart",A,false);this.domElement.addEventListener("touchend",L,false);this.domElement.addEventListener("touchmove",C,false);window.addEventListener("keydown",w,false);window.addEventListener("keyup",R,false);this.handleResize();this.update()};THREE.TrackballControls.prototype=Object.create(THREE.EventDispatcher.prototype);THREE.TrackballControls.prototype.constructor=THREE.TrackballControls;THREE.VRControls=function(t,e){var r=1e-5;var i=this.dummy=new THREE.Object3D;this.object=t;this.device=new THREE.DeviceOrientationControls(i,e);this.orbit=new THREE.OrbitControls(i,e);this.orbit.target.copy(t.position);this.orbit.target.z+=r;this.orbit.rotateSpeed=-.25;this.supported=false;var n=function(t){this.supported=t&&t.alpha==+t.alpha;window.removeEventListener("deviceorientation",n,false)}.bind(this);window.addEventListener("deviceorientation",n,false)};THREE.VRControls.prototype.vr=function(t){this.vrstate=t};THREE.VRControls.prototype.update=function(t){var e=false;if(this.vrstate&&this.vrstate.orientation){e=true;this.object.quaternion.copy(this.vrstate.orientation);this.object.position.copy(this.vrstate.position);this.device.object=this.dummy;this.orbit.object=this.dummy}else if(this.vrstate&&this.supported){if(this.device.freeze)this.device.connect();this.device.object=this.object;this.orbit.object=this.dummy;this.device.update(t)}else{e=true;this.device.object=this.dummy;this.orbit.object=this.object;this.orbit.update(t)}if(e&&!this.device.freeze)this.device.disconnect()};THREE.Bootstrap.registerPlugin("stats",{listen:["pre","post"],install:function(t){var e=this.stats=new THREE.Stats;var r=e.domElement.style;r.position="absolute";r.top=r.left=0;t.element.appendChild(e.domElement);t.stats=e},uninstall:function(t){document.body.removeChild(this.stats.domElement);delete t.stats},pre:function(t,e){this.stats.begin()},post:function(t,e){this.stats.end()}});THREE.Bootstrap.registerPlugin("controls",{listen:["update","resize","camera","this.change"],defaults:{klass:null,parameters:{}},install:function(t){if(!this.options.klass)throw"Must provide class for `controls.klass`";t.controls=null;this._camera=t.camera||new THREE.PerspectiveCamera;this.change(null,t)},uninstall:function(t){delete t.controls},change:function(t,e){if(this.options.klass){if(!t||t.changes.klass){e.controls=new this.options.klass(this._camera,e.renderer.domElement)}_.extend(e.controls,this.options.parameters)}else{e.controls=null}},update:function(t,e){var r=e.Time&&e.Time.delta||1/60;var i=e.VR&&e.VR.state;if(e.controls.vr)e.controls.vr(i);e.controls.update(r)},camera:function(t,e){e.controls.object=this._camera=t.camera},resize:function(t,e){e.controls.handleResize&&e.controls.handleResize()}});THREE.Bootstrap.registerPlugin("cursor",{listen:["update","this.change","install:change","uninstall:change","element.mousemove","vr"],defaults:{cursor:null,hide:false,timeout:3},install:function(t){this.timeout=this.options.timeout;this.element=t.element;this.change(null,t)},uninstall:function(t){delete t.controls},change:function(t,e){this.applyCursor(e)},mousemove:function(t,e){if(this.options.hide){this.applyCursor(e);this.timeout=+this.options.timeout||0}},update:function(t,e){var r=e.Time&&e.Time.delta||1/60;if(this.options.hide){this.timeout-=r;if(this.timeout<0){this.applyCursor(e,"none")}}},vr:function(t,e){this.hide=t.active&&!t.hmd.fake;this.applyCursor(e)},applyCursor:function(t,e){var r=t.controls?"move":"";e=e||this.options.cursor||r;if(this.hide)e="none";if(this.cursor!=e){this.element.style.cursor=e}}});THREE.Bootstrap.registerPlugin("fullscreen",{defaults:{key:"f"},listen:["ready","update"],install:function(t){t.Fullscreen=this.api({active:false,toggle:this.toggle.bind(this)},t)},uninstall:function(t){delete t.Fullscreen},ready:function(t,e){document.body.addEventListener("keypress",function(t){if(this.options.key&&t.charCode==this.options.key.charCodeAt(0)){this.toggle(e)}}.bind(this));var r=function(){var t=!!document.fullscreenElement||!!document.mozFullScreenElement||!!document.webkitFullscreenElement||!!document.msFullscreenElement;e.Fullscreen.active=this.active=t;e.trigger({type:"fullscreen",active:t})}.bind(this);document.addEventListener("fullscreenchange",r,false);document.addEventListener("webkitfullscreenchange",r,false);document.addEventListener("mozfullscreenchange",r,false)},toggle:function(t){var e=t.canvas;var r=t.VR&&t.VR.active?{vrDisplay:t.VR.hmd}:{};if(!this.active){if(e.requestFullScreen){e.requestFullScreen(r)}else if(e.msRequestFullScreen){e.msRequestFullscreen(r)}else if(e.webkitRequestFullscreen){e.webkitRequestFullscreen(r)}else if(e.mozRequestFullScreen){e.mozRequestFullScreen(r)}}else{if(document.exitFullscreen){document.exitFullscreen()}else if(document.msExitFullscreen){document.msExitFullscreen()}else if(document.webkitExitFullscreen){document.webkitExitFullscreen()}else if(document.mozCancelFullScreen){document.mozCancelFullScreen()}}}});THREE.Bootstrap.registerPlugin("vr",{defaults:{mode:"auto",device:null,fov:80},listen:["window.load","pre","render","resize","this.change"],install:function(t){t.VR=this.api({active:false,devices:[],hmd:null,sensor:null,renderer:null,state:null},t)},uninstall:function(t){delete t.VR},mocks:function(t,e,r){var i=.03;var n=function(t){return{left:{x:-i,y:0,z:0},right:{x:i,y:0,z:0}}[t]};var o=function(i){var n=t.camera;var o=n&&n.aspect||16/9;var s=(e||(n&&n.fov||r))/2;var a=Math.atan(Math.tan(s*Math.PI/180)*o/2)*180/Math.PI;var u=s;return{left:{rightDegrees:a,leftDegrees:a,downDegrees:u,upDegrees:u},right:{rightDegrees:a,leftDegrees:a,downDegrees:u,upDegrees:u}}[i]};var s=function(){return{}};return[{fake:true,force:1,deviceId:"emu",deviceName:"Emulated",getEyeTranslation:n,getRecommendedEyeFieldOfView:o},{force:2,getState:s}]},load:function(t,e){var r=function(t){this.callback(t,e)}.bind(this);if(navigator.getVRDevices){navigator.getVRDevices().then(r)}else if(navigator.mozGetVRDevices){navigator.mozGetVRDevices(r)}else{console.warn("No native VR support detected.");r(this.mocks(e,this.options.fov,this.defaults.fov),e)}},callback:function(t,e){var r,i;var n=window.HMDVRDevice||function(){};var o=window.PositionSensorVRDevice||function(){};t=e.VR.devices=t||e.VR.devices;var s=this.options.device;for(var a=0;a<t.length;++a){var u=t[a];if(u.force==1||u instanceof n){if(s&&s!=u.deviceId)continue;r=u;break}}if(r){for(var a=0;a<t.length;++a){var u=t[a];if(u.force==2||u instanceof o&&u.hardwareUnitId==r.hardwareUnitId){i=u;break}}this.hookup(r,i,e)}},hookup:function(t,e,r){if(!THREE.VRRenderer)console.log("THREE.VRRenderer not found");var i=THREE.VRRenderer||function(){};this.renderer=new i(r.renderer,t);this.hmd=t;this.sensor=e;r.VR.renderer=this.renderer;r.VR.hmd=t;r.VR.sensor=e;console.log("THREE.VRRenderer",t.deviceName)},change:function(t,e){if(t.changes.device){this.callback(null,e)}this.pre(t,e)},pre:function(t,e){var r=this.active;var i=this.active=this.renderer&&this.options.mode!="2d";e.VR.active=i;if(i&&this.sensor){var n=this.sensor.getState();e.VR.state=n}else{e.VR.state=null}if(r!=this.active){e.trigger({type:"vr",active:i,hmd:this.hmd,sensor:this.sensor})}},resize:function(t,e){if(this.active){this.renderer.initialize()}},render:function(t,e){if(e.scene&&e.camera){var r=this.active?this.renderer:e.renderer;if(this.last!=r){if(r==e.renderer){var i=r.getPixelRatio();var n=r.domElement.width/i;var o=r.domElement.height/i;r.enableScissorTest(false);r.setViewport(0,0,n,o)}}this.last=r;r.render(e.scene,e.camera)}}});THREE.Bootstrap.registerPlugin("ui",{defaults:{theme:"white",style:".threestrap-ui { position: absolute; bottom: 5px; right: 5px; float: left; }"+".threestrap-ui button { border: 0; background: none;"+"  vertical-align: middle; font-weight: bold; } "+".threestrap-ui .glyphicon { top: 2px; font-weight: bold; } "+"@media (max-width: 640px) { .threestrap-ui button { font-size: 120% } }"+".threestrap-white button { color: #fff; text-shadow: 0 1px 1px rgba(0, 0, 0, 1), "+"0 1px 3px rgba(0, 0, 0, 1); }"+".threestrap-black button { color: #000; text-shadow: 0 0px 1px rgba(255, 255, 255, 1), "+"0 0px 2px rgba(255, 255, 255, 1), "+"0 0px 2px rgba(255, 255, 255, 1) }"},listen:["fullscreen"],markup:function(t,e,r){var i="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css";if(location.href.match(/^file:\/\//))i="http://"+i;var n=[];if(t.Fullscreen){n.push('<button class="fullscreen" title="Full Screen">'+'<span class="glyphicon glyphicon-fullscreen"></span>'+"</button>")}if(t.VR){n.push('<button class="vr" title="VR Headset">VR</button>')}return'<style type="text/css">@import url("'+i+'"); '+r+"</style>"+'<div class="threestrap-ui threestrap-'+e+'">'+n.join("\n")+"</div>"},install:function(t){var e=this.ui=document.createElement("div");e.innerHTML=this.markup(t,this.options.theme,this.options.style);document.body.appendChild(e);var r=this.ui.fullscreen=e.querySelector("button.fullscreen");if(r){t.bind([r,"click:goFullscreen"],this)}var i=this.ui.vr=e.querySelector("button.vr");if(i&&t.VR){t.VR.set({mode:"2d"});t.bind([i,"click:goVR"],this)}},uninstall:function(t){document.body.removeChild(ui)},fullscreen:function(t,e){this.ui.style.display=t.active?"none":"block";if(!t.active)e.VR&&e.VR.set({mode:"2d"})},goFullscreen:function(t,e){if(e.Fullscreen){e.Fullscreen.toggle()}},goVR:function(t,e){if(e.VR){e.VR.set({mode:"auto"});e.Fullscreen.toggle()}},uninstall:function(t){document.body.removeChild(this.ui)}});"use strict";THREE.VRRenderer=function(t,e){var r=this;r.initialize=function(){var t=e.getEyeTranslation("left");r.halfIPD=new THREE.Vector3(t.x,t.y,t.z).length();r.fovLeft=e.getRecommendedEyeFieldOfView("left");r.fovRight=e.getRecommendedEyeFieldOfView("right")};r.FovToNDCScaleOffset=function(t){var e=2/(t.leftTan+t.rightTan);var r=(t.leftTan-t.rightTan)*e*.5;var i=2/(t.upTan+t.downTan);var n=(t.upTan-t.downTan)*i*.5;return{scale:[e,i],offset:[r,n]}};r.FovPortToProjection=function(t,e,i,n,o){i=i===undefined?true:i;n=n===undefined?.01:n;o=o===undefined?1e4:o;var s=i?-1:1;var a=t.elements;var u=r.FovToNDCScaleOffset(e);a[0*4+0]=u.scale[0];a[0*4+1]=0;a[0*4+2]=u.offset[0]*s;a[0*4+3]=0;a[1*4+0]=0;a[1*4+1]=u.scale[1];a[1*4+2]=-u.offset[1]*s;a[1*4+3]=0;a[2*4+0]=0;a[2*4+1]=0;a[2*4+2]=o/(n-o)*-s;a[2*4+3]=o*n/(n-o);a[3*4+0]=0;a[3*4+1]=0;a[3*4+2]=s;a[3*4+3]=0;t.transpose()};r.FovToProjection=function(t,e,i,n,o){var s={upTan:Math.tan(e.upDegrees*Math.PI/180),downTan:Math.tan(e.downDegrees*Math.PI/180),leftTan:Math.tan(e.leftDegrees*Math.PI/180),rightTan:Math.tan(e.rightDegrees*Math.PI/180)};return r.FovPortToProjection(t,s,i,n,o)};var i=new THREE.Vector3;var n=new THREE.PerspectiveCamera;var o=new THREE.PerspectiveCamera;r.render=function(e,s){r.FovToProjection(n.projectionMatrix,r.fovLeft,true,s.near,s.far);r.FovToProjection(o.projectionMatrix,r.fovRight,true,s.near,s.far);i.set(r.halfIPD,0,0);i.applyQuaternion(s.quaternion);n.position.copy(s.position).sub(i);o.position.copy(s.position).add(i);n.quaternion.copy(s.quaternion);o.quaternion.copy(s.quaternion);var a=t.devicePixelRatio||1;var u=t.domElement.width/2/a;var l=t.domElement.height/a;t.enableScissorTest(true);t.setViewport(0,0,u,l);t.setScissor(0,0,u,l);t.render(e,n);t.setViewport(u,0,u,l);t.setScissor(u,0,u,l);t.render(e,o)};r.initialize()};THREE.VRControls=function(t,e){var r=1e-5;var i=this.dummy=new THREE.Object3D;this.object=t;this.device=new THREE.DeviceOrientationControls(i,e);this.orbit=new THREE.OrbitControls(i,e);this.orbit.target.copy(t.position);this.orbit.target.z+=r;this.orbit.rotateSpeed=-.25;this.supported=false;var n=function(t){this.supported=t&&t.alpha==+t.alpha;window.removeEventListener("deviceorientation",n,false)}.bind(this);window.addEventListener("deviceorientation",n,false)};THREE.VRControls.prototype.vr=function(t){this.vrstate=t};THREE.VRControls.prototype.update=function(t){var e=false;if(this.vrstate&&this.vrstate.orientation){e=true;this.object.quaternion.copy(this.vrstate.orientation);this.object.position.copy(this.vrstate.position);this.device.object=this.dummy;this.orbit.object=this.dummy}else if(this.vrstate&&this.supported){if(this.device.freeze)this.device.connect();this.device.object=this.object;this.orbit.object=this.dummy;this.device.update(t)}else{e=true;this.device.object=this.dummy;this.orbit.object=this.object;this.orbit.update(t)}if(e&&!this.device.freeze)this.device.disconnect()};THREE.OrbitControls=function(t,e){this.object=t;this.domElement=e!==undefined?e:document;this.enabled=true;this.target=new THREE.Vector3;this.center=this.target;this.noZoom=false;this.zoomSpeed=1;this.minDistance=0;this.maxDistance=Infinity;this.noRotate=false;this.rotateSpeed=1;this.noPan=false;this.keyPanSpeed=7;this.autoRotate=false;this.autoRotateSpeed=2;this.minPolarAngle=0;this.maxPolarAngle=Math.PI;this.noKeys=false;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};var r=this;var i=1e-6;var n=new THREE.Vector2;var o=new THREE.Vector2;var s=new THREE.Vector2;var a=new THREE.Vector2;var u=new THREE.Vector2;var l=new THREE.Vector2;var h=new THREE.Vector3;var f=new THREE.Vector3;var c=new THREE.Vector2;var p=new THREE.Vector2;var d=new THREE.Vector2;var m=0;var v=0;var g=1;var y=new THREE.Vector3;var E=new THREE.Vector3;var _={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5};var x=_.NONE;this.target0=this.target.clone();this.position0=this.object.position.clone();var b=(new THREE.Quaternion).setFromUnitVectors(t.up,new THREE.Vector3(0,1,0));var T=b.clone().inverse();var w={type:"change"};var R={type:"start"};var H={type:"end"};this.rotateLeft=function(t){if(t===undefined){t=M()}v-=t};this.rotateUp=function(t){if(t===undefined){t=M()}m-=t};this.panLeft=function(t){var e=this.object.matrix.elements;h.set(e[0],e[1],e[2]);h.multiplyScalar(-t);y.add(h)};this.panUp=function(t){var e=this.object.matrix.elements;h.set(e[4],e[5],e[6]);h.multiplyScalar(t);y.add(h)};this.pan=function(t,e){var i=r.domElement===document?r.domElement.body:r.domElement;if(r.object.fov!==undefined){var n=r.object.position;var o=n.clone().sub(r.target);var s=o.length();s*=Math.tan(r.object.fov/2*Math.PI/180);r.panLeft(2*t*s/i.clientHeight);r.panUp(2*e*s/i.clientHeight)}else if(r.object.top!==undefined){r.panLeft(t*(r.object.right-r.object.left)/i.clientWidth);r.panUp(e*(r.object.top-r.object.bottom)/i.clientHeight)}else{console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")}};this.dollyIn=function(t){if(t===undefined){t=S()}g/=t};this.dollyOut=function(t){if(t===undefined){t=S()}g*=t};this.update=function(){var t=this.object.position;f.copy(t).sub(this.target);f.applyQuaternion(b);var e=Math.atan2(f.x,f.z);var r=Math.atan2(Math.sqrt(f.x*f.x+f.z*f.z),f.y);if(this.autoRotate){this.rotateLeft(M())}e+=v;r+=m;r=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,r));r=Math.max(i,Math.min(Math.PI-i,r));var n=f.length()*g;n=Math.max(this.minDistance,Math.min(this.maxDistance,n));this.target.add(y);f.x=n*Math.sin(r)*Math.sin(e);f.y=n*Math.cos(r);f.z=n*Math.sin(r)*Math.cos(e);f.applyQuaternion(T);t.copy(this.target).add(f);this.object.lookAt(this.target);v=0;m=0;g=1;y.set(0,0,0);if(E.distanceToSquared(this.object.position)>i){this.dispatchEvent(w);E.copy(this.object.position)}};this.reset=function(){x=_.NONE;this.target.copy(this.target0);this.object.position.copy(this.position0);this.update()};function M(){return 2*Math.PI/60/60*r.autoRotateSpeed}function S(){return Math.pow(.95,r.zoomSpeed)}function k(t){if(r.enabled===false)return;t.preventDefault();if(t.button===0){if(r.noRotate===true)return;x=_.ROTATE;n.set(t.clientX,t.clientY)}else if(t.button===1){if(r.noZoom===true)return;x=_.DOLLY;c.set(t.clientX,t.clientY)}else if(t.button===2){if(r.noPan===true)return;x=_.PAN;a.set(t.clientX,t.clientY)}document.documentElement.addEventListener("mousemove",A,false);document.documentElement.addEventListener("mouseup",C,false);r.dispatchEvent(R)}function A(t){if(r.enabled===false)return;t.preventDefault();var e=r.domElement===document?r.domElement.body:r.domElement;if(x===_.ROTATE){if(r.noRotate===true)return;o.set(t.clientX,t.clientY);s.subVectors(o,n);r.rotateLeft(2*Math.PI*s.x/e.clientWidth*r.rotateSpeed);r.rotateUp(2*Math.PI*s.y/e.clientHeight*r.rotateSpeed);n.copy(o)}else if(x===_.DOLLY){if(r.noZoom===true)return;p.set(t.clientX,t.clientY);d.subVectors(p,c);if(d.y>0){r.dollyIn()}else{r.dollyOut()}c.copy(p)}else if(x===_.PAN){if(r.noPan===true)return;u.set(t.clientX,t.clientY);l.subVectors(u,a);r.pan(l.x,l.y);a.copy(u)}r.update()}function C(){if(r.enabled===false)return;document.documentElement.removeEventListener("mousemove",A,false);document.documentElement.removeEventListener("mouseup",C,false);r.dispatchEvent(H);x=_.NONE}function L(t){if(r.enabled===false||r.noZoom===true)return;t.preventDefault();t.stopPropagation();var e=0;if(t.wheelDelta!==undefined){e=t.wheelDelta}else if(t.detail!==undefined){e=-t.detail}if(e>0){r.dollyOut()}else{r.dollyIn()}r.update();r.dispatchEvent(R);r.dispatchEvent(H)}function P(t){if(r.enabled===false||r.noKeys===true||r.noPan===true)return;switch(t.keyCode){case r.keys.UP:r.pan(0,r.keyPanSpeed);r.update();break;case r.keys.BOTTOM:r.pan(0,-r.keyPanSpeed);r.update();break;case r.keys.LEFT:r.pan(r.keyPanSpeed,0);r.update();break;case r.keys.RIGHT:r.pan(-r.keyPanSpeed,0);r.update();break}}function z(t){if(r.enabled===false)return;switch(t.touches.length){case 1:if(r.noRotate===true)return;x=_.TOUCH_ROTATE;n.set(t.touches[0].pageX,t.touches[0].pageY);break;case 2:if(r.noZoom===true)return;x=_.TOUCH_DOLLY;var e=t.touches[0].pageX-t.touches[1].pageX;var i=t.touches[0].pageY-t.touches[1].pageY;var o=Math.sqrt(e*e+i*i);c.set(0,o);break;case 3:if(r.noPan===true)return;x=_.TOUCH_PAN;a.set(t.touches[0].pageX,t.touches[0].pageY);break;default:x=_.NONE}r.dispatchEvent(R)}function D(t){if(r.enabled===false)return;t.preventDefault();t.stopPropagation();var e=r.domElement===document?r.domElement.body:r.domElement;switch(t.touches.length){case 1:if(r.noRotate===true)return;if(x!==_.TOUCH_ROTATE)return;o.set(t.touches[0].pageX,t.touches[0].pageY);s.subVectors(o,n);r.rotateLeft(2*Math.PI*s.x/e.clientWidth*r.rotateSpeed);r.rotateUp(2*Math.PI*s.y/e.clientHeight*r.rotateSpeed);n.copy(o);r.update();break;case 2:if(r.noZoom===true)return;if(x!==_.TOUCH_DOLLY)return;var i=t.touches[0].pageX-t.touches[1].pageX;var h=t.touches[0].pageY-t.touches[1].pageY;var f=Math.sqrt(i*i+h*h);p.set(0,f);d.subVectors(p,c);if(d.y>0){r.dollyOut()}else{r.dollyIn()}c.copy(p);r.update();break;case 3:if(r.noPan===true)return;if(x!==_.TOUCH_PAN)return;u.set(t.touches[0].pageX,t.touches[0].pageY);l.subVectors(u,a);r.pan(l.x,l.y);a.copy(u);r.update();break;default:x=_.NONE}}function O(){if(r.enabled===false)return;r.dispatchEvent(H);x=_.NONE}this.domElement.addEventListener("contextmenu",function(t){t.preventDefault()},false);this.domElement.addEventListener("mousedown",k,false);this.domElement.addEventListener("mousewheel",L,false);this.domElement.addEventListener("DOMMouseScroll",L,false);this.domElement.addEventListener("touchstart",z,false);this.domElement.addEventListener("touchend",O,false);this.domElement.addEventListener("touchmove",D,false);window.addEventListener("keydown",P,false);this.update()};THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype);THREE.DeviceOrientationControls=function(t){var e=this;this.object=t;this.object.rotation.reorder("YXZ");this.freeze=true;this.deviceOrientation={};this.screenOrientation=0;var r=function(t){e.deviceOrientation=t};var i=function(){e.screenOrientation=window.orientation||0};var n=function(){var t=new THREE.Vector3(0,0,1);var e=new THREE.Euler;var r=new THREE.Quaternion;var i=new THREE.Quaternion(-Math.sqrt(.5),0,0,Math.sqrt(.5));return function(n,o,s,a,u){e.set(s,o,-a,"YXZ");n.setFromEuler(e);n.multiply(i);n.multiply(r.setFromAxisAngle(t,-u))}}();this.connect=function(){i();window.addEventListener("orientationchange",i,false);window.addEventListener("deviceorientation",r,false);e.freeze=false};this.disconnect=function(){e.freeze=true;window.removeEventListener("orientationchange",i,false);window.removeEventListener("deviceorientation",r,false)};this.update=function(){if(e.freeze)return;var t=e.deviceOrientation.gamma?THREE.Math.degToRad(e.deviceOrientation.alpha):0;var r=e.deviceOrientation.beta?THREE.Math.degToRad(e.deviceOrientation.beta):0;var i=e.deviceOrientation.gamma?THREE.Math.degToRad(e.deviceOrientation.gamma):0;var o=e.screenOrientation?THREE.Math.degToRad(e.screenOrientation):0;n(e.object.quaternion,t,r,i,o)}};(function t(e,r,i){function n(s,a){if(!r[s]){if(!e[s]){var u=typeof require=="function"&&require;if(!a&&u)return u(s,!0);if(o)return o(s,!0);throw new Error("Cannot find module '"+s+"'")}var l=r[s]={exports:{}};e[s][0].call(l.exports,function(t){var r=e[s][1][t];return n(r?r:t)},l,l.exports,t,e,r,i)}return r[s].exports}var o=typeof require=="function"&&require;for(var s=0;s<i.length;s++)n(i[s]);return n})({1:[function(t,e,r){e.exports={"arrow.position":"uniform float worldUnit;\nuniform float lineDepth;\nuniform float lineWidth;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nuniform float arrowSize;\nuniform float arrowSpace;\n\nattribute vec4 position4;\nattribute vec3 arrow;\nattribute vec2 attach;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvoid getArrowGeometry(vec4 xyzw, float near, float far, out vec3 left, out vec3 right, out vec3 start) {\n  right = getPosition(xyzw, 1.0);\n  left  = getPosition(vec4(near, xyzw.yzw), 0.0);\n  start = getPosition(vec4(far, xyzw.yzw), 0.0);\n}\n\nmat4 getArrowMatrix(vec3 left, vec3 right, vec3 start) {\n\n  float depth = focusDepth;\n  if (lineDepth < 1.0) {\n    // Depth blending\n    float z = max(0.00001, -right.z);\n    depth = mix(z, focusDepth, lineDepth);\n  }\n    \n  vec3 diff = left - right;\n  float l = length(diff);\n  if (l == 0.0) {\n    return mat4(1.0, 0.0, 0.0, 0.0,\n                0.0, 1.0, 0.0, 0.0,\n                0.0, 0.0, 1.0, 0.0,\n                0.0, 0.0, 0.0, 1.0);\n  }\n\n  // Construct TBN matrix around shaft\n  vec3 t = normalize(diff);\n  vec3 n = normalize(cross(t, t.yzx + vec3(.1, .2, .3)));\n  vec3 b = cross(n, t);\n  \n  // Shrink arrows when vector gets too small\n  // Approach linear scaling with cubic ease the smaller we get\n  float size = arrowSize * lineWidth * worldUnit * depth * 1.25;\n  diff = right - start;\n  l = length(diff) * arrowSpace;\n  float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n  float scale = 1.0 - mini * mini * mini;\n  float range = size * scale;\n  \n  // Size to 2.5:1 ratio\n  float rangeNB = range / 2.5;\n\n  // Anchor at end position\n  return mat4(vec4(n * rangeNB,  0),\n              vec4(b * rangeNB,  0),\n              vec4(t * range, 0),\n              vec4(right,  1.0));\n}\n\nvec3 getArrowPosition() {\n  vec3 left, right, start;\n  \n  vec4 p = min(geometryClip, position4);\n  \n  getArrowGeometry(p, attach.x, attach.y, left, right, start);\n  mat4 matrix = getArrowMatrix(left, right, start);\n  return (matrix * vec4(arrow.xyz, 1.0)).xyz;\n\n}\n","axis.position":"uniform vec4 axisStep;\nuniform vec4 axisPosition;\n\nvec4 getAxisPosition(vec4 xyzw, inout vec4 stpq) {\n  return axisStep * xyzw.x + axisPosition;\n}\n","cartesian.position":"uniform mat4 viewMatrix;\n\nvec4 getCartesianPosition(vec4 position, inout vec4 stpq) {\n  return viewMatrix * vec4(position.xyz, 1.0);\n}\n","cartesian4.position":"uniform vec4 basisScale;\nuniform vec4 basisOffset;\nuniform vec4 viewScale;\nuniform vec4 viewOffset;\n\nvec4 getCartesian4Position(vec4 position, inout vec4 stpq) {\n  return position * basisScale + basisOffset;\n}\n","clamp.position":"uniform vec4 clampLimit;\n\nvec4 getClampXYZW(vec4 xyzw) {\n  return clamp(xyzw, vec4(0.0), clampLimit);\n}\n","color.opaque":"vec4 opaqueColor(vec4 color) {\n  return vec4(color.rgb, 1.0);\n}\n","face.position":"uniform vec4 geometryClip;\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getFacePosition() {\n  vec4 p = min(geometryClip, position4);\n  return getPosition(p, 1.0);\n}\n","face.position.normal":"attribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvoid getFaceGeometry(vec4 xyzw, out vec3 pos, out vec3 normal) {\n  vec3 a, b, c;\n\n  a   = getPosition(vec4(xyzw.xyz, 0.0), 0.0);\n  b   = getPosition(vec4(xyzw.xyz, 1.0), 0.0);\n  c   = getPosition(vec4(xyzw.xyz, 2.0), 0.0);\n\n  pos = getPosition(xyzw, 1.0);\n  normal = normalize(cross(c - a, b - a));\n}\n\nvec3 getFacePositionNormal() {\n  vec3 center, normal;\n\n  getFaceGeometry(position4, center, normal);\n  vNormal   = normal;\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz);\n  vPosition = -center;\n\n  return center;\n}\n","float.encode":"/*\nFloat encoding technique by\nCarlos Scheidegger\nhttps://github.com/cscheid/lux/blob/master/src/shade/bits/encode_float.js\n\nConversion to GLSL by:\nhttp://concord-consortium.github.io/lab/experiments/webgl-gpgpu/script.js\n*/\n\nfloat shift_right(float v, float amt) { \n  v = floor(v) + 0.5; \n  return floor(v / exp2(amt)); \n}\n\nfloat shift_left(float v, float amt) { \n  return floor(v * exp2(amt) + 0.5); \n}\n\nfloat mask_last(float v, float bits) { \n  return mod(v, shift_left(1.0, bits)); \n}\n\nfloat extract_bits(float num, float from, float to) { \n  from = floor(from + 0.5); to = floor(to + 0.5); \n  return mask_last(shift_right(num, from), to - from); \n}\n\nvec4 encode_float(float val) { \n  if (val == 0.0) return vec4(0, 0, 0, 0); \n  float valuesign = val > 0.0 ? 0.0 : 1.0; \n  val = abs(val); \n  float exponent = floor(log2(val)); \n  float biased_exponent = exponent + 127.0; \n  float fraction = ((val / exp2(exponent)) - 1.0) * 8388608.0; \n  float t = biased_exponent / 2.0; \n  float last_bit_of_biased_exponent = fract(t) * 2.0; \n  float remaining_bits_of_biased_exponent = floor(t); \n  float byte4 = extract_bits(fraction, 0.0, 8.0) / 255.0; \n  float byte3 = extract_bits(fraction, 8.0, 16.0) / 255.0; \n  float byte2 = (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0; \n  float byte1 = (valuesign * 128.0 + remaining_bits_of_biased_exponent) / 255.0; \n  return vec4(byte4, byte3, byte2, byte1); \n}\n","float.index.pack":"uniform vec4 indexModulus;\n\nvec4 getSample(vec4 xyzw);\nvec4 getIndex(vec4 xyzw);\n\nvec4 floatPackIndex(vec4 xyzw) {\n  vec4 value = getSample(xyzw);\n  vec4 index = getIndex(xyzw);\n\n  vec4 offset = floor(index + .5) * indexModulus;\n  vec2 sum2 = offset.xy + offset.zw;\n  float sum = sum2.x + sum2.y;\n  return vec4(value.xyz, sum);\n}","float.stretch":"vec4 getSample(vec4 xyzw);\n\nfloat floatStretch(vec4 xyzw, float channelIndex) {\n  vec4 sample = getSample(xyzw);\n  vec2 xy = channelIndex > 1.5 ? sample.zw : sample.xy;\n  return mod(channelIndex, 2.0) > .5 ? xy.y : xy.x;\n}","fragment.clip.dashed":"varying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n\nvoid clipStrokeFragment() {\n  bool odd = mod(vClipStrokeIndex, 2.0) >= 1.0;\n\n  vec3 tangent;\n  if (odd) {\n    tangent = vClipStrokeOdd;\n  }\n  else {\n    tangent = vClipStrokeEven;\n  }\n\n  float travel = dot(vClipStrokePosition, normalize(tangent)) / vClipStrokeWidth;\n  if (mod(travel, 16.0) > 8.0) {\n    discard;\n  }\n}\n","fragment.clip.dotted":"varying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n\nvoid clipStrokeFragment() {\n  bool odd = mod(vClipStrokeIndex, 2.0) >= 1.0;\n\n  vec3 tangent;\n  if (odd) {\n    tangent = vClipStrokeOdd;\n  }\n  else {\n    tangent = vClipStrokeEven;\n  }\n\n  float travel = dot(vClipStrokePosition, normalize(tangent)) / vClipStrokeWidth;\n  if (mod(travel, 4.0) > 2.0) {\n    discard;\n  }\n}\n","fragment.clip.ends":"varying vec2 vClipEnds;\n\nvoid clipEndsFragment() {\n  if (vClipEnds.x < 0.0 || vClipEnds.y < 0.0) discard;\n}\n","fragment.clip.proximity":"varying float vClipProximity;\n\nvoid clipProximityFragment() {\n  if (vClipProximity >= 0.5) discard;\n}","fragment.color":"void setFragmentColor(vec4 color) {\n  gl_FragColor = color;\n}","fragment.map.rgba":"vec4 fragmentRGBA(vec4 rgba, vec4 stpq) {\n  return rgba;\n}","fragment.solid":"void setFragmentColor(vec4 color) {\n  if (color.a < 1.0) discard;\n  gl_FragColor = color;\n}","fragment.transparent":"void setFragmentColor(vec4 color) {\n  if (color.a >= 1.0) discard;\n  gl_FragColor = color;\n}","grid.position":"uniform vec4 gridPosition;\nuniform vec4 gridStep;\nuniform vec4 gridAxis;\n\nvec4 sampleData(vec2 xy);\n\nvec4 getGridPosition(vec4 xyzw) {\n  vec4 onAxis  = gridAxis * sampleData(vec2(xyzw.y, 0.0)).x;\n  vec4 offAxis = gridStep * xyzw.x + gridPosition;\n  return onAxis + offAxis;\n}\n","grow.position":"uniform float growScale;\nuniform vec4  growMask;\nuniform vec4  growAnchor;\n\nvec4 getSample(vec4 xyzw);\n\nvec4 getGrowSample(vec4 xyzw) {\n  vec4 anchor = xyzw * growMask + growAnchor;\n\n  vec4 position = getSample(xyzw);\n  vec4 center = getSample(anchor);\n\n  return mix(center, position, growScale);\n}","join.position":"uniform float joinStride;\nuniform float joinStrideInv;\n\nfloat getIndex(vec4 xyzw);\nvec4 getRest(vec4 xyzw);\nvec4 injectIndices(float a, float b);\n\nvec4 getJoinXYZW(vec4 xyzw) {\n\n  float a = getIndex(xyzw);\n  float b = a * joinStrideInv;\n\n  float integer  = floor(b);\n  float fraction = b - integer;\n  \n  return injectIndices(fraction * joinStride, integer) + getRest(xyzw);\n}\n","label.alpha":"varying float vPixelSize;\n\nvec4 getLabelAlphaColor(vec4 color, vec4 sample) {\n  float mask = clamp(sample.r * 1000.0, 0.0, 1.0);\n  float alpha = (sample.r - .5) * vPixelSize + .5;\n  float a = mask * alpha * color.a;\n  if (a <= 0.0) discard;\n  return vec4(color.xyz, a);\n}\n","label.map":"vec2 mapUV(vec4 uvwo, vec4 stpq) {\n  return uvwo.xy;\n}\n","label.outline":"uniform float outlineExpand;\nuniform float outlineStep;\nuniform vec3  outlineColor;\n\nvarying float vPixelSize;\n\nconst float PIXEL_STEP = 255.0 / 16.0;\n\nvec4 getLabelOutlineColor(vec4 color, vec4 sample) {\n  float ps = vPixelSize * PIXEL_STEP;\n  float os = outlineStep;\n\n  float sdf = sample.r - .5 + outlineExpand;\n  vec2  sdfs = vec2(sdf, sdf + os);\n  vec2  alpha = clamp(sdfs * ps + .5, 0.0, 1.0);\n\n  if (alpha.y <= 0.0) {\n    discard;\n  }\n\n  vec3 blend = color.xyz;\n  if (alpha.y > alpha.x) {\n    blend = sqrt(mix(outlineColor * outlineColor, blend * blend, alpha.x));\n  }\n  \n  return vec4(blend, alpha.y * color.a);\n}\n","layer.position":"uniform vec4 layerScale;\nuniform vec4 layerBias;\n\nvec4 layerPosition(vec4 position, inout vec4 stpq) {\n  return layerScale * position + layerBias;\n}\n","lerp.depth":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpDepth(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.xy, i, xyzw.w);\n  vec4 xyzw2 = vec4(xyzw.xy, i + 1.0, xyzw.w);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.height":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpHeight(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.x, i, xyzw.zw);\n  vec4 xyzw2 = vec4(xyzw.x, i + 1.0, xyzw.zw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.items":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpItems(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(xyzw.xyz, i);\n  vec4 xyzw2 = vec4(xyzw.xyz, i + 1.0);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","lerp.width":"// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 lerpWidth(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n    \n  vec4 xyzw1 = vec4(i, xyzw.yzw);\n  vec4 xyzw2 = vec4(i + 1.0, xyzw.yzw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, f);\n}\n","line.position":"// Units and calibration\nuniform float worldUnit;\nuniform float lineWidth;\nuniform float lineDepth;\nuniform float focusDepth;\n\n// General data index\nuniform vec4 geometryClip;\nattribute vec4 position4;\n\n// (Start/mid/end -1/0/1, top/bottom -1,1) \nattribute vec2 line;\n\n// 0...1 for round or bevel joins\n#ifdef LINE_JOIN_DETAIL\nattribute float joint;\n#else\nconst float joint = 0.0;\n#endif\n\n// Knock out excessively long line segments (e.g. for asymtpotes)\n#ifdef LINE_PROXIMITY\nuniform float lineProximity;\nvarying float vClipProximity;\n#endif\n\n// Ghetto line stroking (local only, not global)\n#ifdef LINE_STROKE\nvarying float vClipStrokeWidth;\nvarying float vClipStrokeIndex;\nvarying vec3  vClipStrokeEven;\nvarying vec3  vClipStrokeOdd;\nvarying vec3  vClipStrokePosition;\n#endif\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\n// Clip line ends for arrows / decoration\n#ifdef LINE_CLIP\nuniform float clipRange;\nuniform vec2  clipStyle;\nuniform float clipSpace;\n\nattribute vec2 strip;\n\nvarying vec2 vClipEnds;\n\nvoid clipEnds(vec4 xyzw, vec3 center, vec3 pos) {\n\n  // Sample end of line strip\n  vec4 xyzwE = vec4(strip.y, xyzw.yzw);\n  vec3 end   = getPosition(xyzwE, 0.0);\n\n  // Sample start of line strip\n  vec4 xyzwS = vec4(strip.x, xyzw.yzw);\n  vec3 start = getPosition(xyzwS, 0.0);\n\n  // Measure length\n  vec3 diff = end - start;\n  float l = length(diff) * clipSpace;\n\n  // Arrow length (=2.5x radius)\n  float arrowSize = 1.25 * clipRange * lineWidth * worldUnit;\n\n  vClipEnds = vec2(1.0);\n\n  if (clipStyle.y > 0.0) {\n    // Depth blend end\n    float depth = focusDepth;\n    if (lineDepth < 1.0) {\n      float z = max(0.00001, -end.z);\n      depth = mix(z, focusDepth, lineDepth);\n    }\n    \n    // Absolute arrow length\n    float size = arrowSize * depth;\n\n    // Adjust clip range\n    // Approach linear scaling with cubic ease the smaller we get\n    float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n    float scale = 1.0 - mini * mini * mini; \n    float invrange = 1.0 / (size * scale);\n  \n    // Clip end\n    diff = end - center;\n    if(diff == vec3(0.0))\n      vClipEnds.x = -1.0;\n    else {\n      diff = normalize(end - center);\n      float d = dot(end - pos, diff);\n      vClipEnds.x = d * invrange - 1.0;\n    }\n  }\n\n  if (clipStyle.x > 0.0) {\n    // Depth blend start\n    float depth = focusDepth;\n    if (lineDepth < 1.0) {\n      float z = max(0.00001, -start.z);\n      depth = mix(z, focusDepth, lineDepth);\n    }\n    \n    // Absolute arrow length\n    float size = arrowSize * depth;\n\n    // Adjust clip range\n    // Approach linear scaling with cubic ease the smaller we get\n    float mini = clamp(1.0 - l / size * .333, 0.0, 1.0);\n    float scale = 1.0 - mini * mini * mini; \n    float invrange = 1.0 / (size * scale);\n  \n    // Clip start \n    diff = center - start;\n    if(diff == vec3(0.0))\n      vClipEnds.y = -1.0;\n    else {\n      diff = normalize(center - start);\n      float d = dot(pos - start, diff);\n      vClipEnds.y = d * invrange - 1.0;\n    }\n  }\n\n\n}\n#endif\n\n// Adjust left/center/right to be inside near/far z range\nconst float epsilon = 1e-5;\nvoid fixCenter(inout vec3 left, inout vec3 center, inout vec3 right) {\n  if (center.z >= 0.0) {\n    if (left.z < 0.0) {\n      float d = (center.z + epsilon) / (center.z - left.z);\n      center = mix(center, left, d);\n    }\n    else if (right.z < 0.0) {\n      float d = (center.z + epsilon) / (center.z - right.z);\n      center = mix(center, right, d);\n    }\n  }\n\n  if (left.z >= 0.0) {\n    if (center.z < 0.0) {\n      float d = (left.z + epsilon) / (left.z - center.z);\n      left = mix(left, center, d);\n    }\n  }\n\n  if (right.z >= 0.0) {\n    if (center.z < 0.0) {\n      float d = (right.z + epsilon) / (right.z - center.z);\n      right = mix(right, center, d);\n    }\n  }\n}\n\n// Sample the source data in an edge-aware manner\nvoid getLineGeometry(vec4 xyzw, float edge, out vec3 left, out vec3 center, out vec3 right) {\n  vec4 delta = vec4(1.0, 0.0, 0.0, 0.0);\n\n  center =                 getPosition(xyzw, 1.0);\n  left   = (edge > -0.5) ? getPosition(xyzw - delta, 0.0) : center;\n  right  = (edge < 0.5)  ? getPosition(xyzw + delta, 0.0) : center;\n}\n\n// Calculate the position for a vertex along the line, including joins\nvec3 getLineJoin(float edge, bool odd, vec3 left, vec3 center, vec3 right, float width, float offset, float joint) {\n  vec2 join = vec2(1.0, 0.0);\n\n  fixCenter(left, center, right);\n\n  vec4 a = vec4(left.xy, right.xy);\n  vec4 b = a / vec4(left.zz, right.zz);\n\n  vec2 l = b.xy;\n  vec2 r = b.zw;\n  vec2 c = center.xy / center.z;\n\n  vec4 d = vec4(l, c) - vec4(c, r);\n  float l1 = dot(d.xy, d.xy);\n  float l2 = dot(d.zw, d.zw);\n\n  if (l1 + l2 > 0.0) {\n    \n    if (edge > 0.5 || l2 == 0.0) {\n      vec2 nl = normalize(d.xy);\n      vec2 tl = vec2(nl.y, -nl.x);\n\n#ifdef LINE_PROXIMITY\n      vClipProximity = 1.0;\n#endif\n\n#ifdef LINE_STROKE\n      vClipStrokeEven = vClipStrokeOdd = normalize(left - center);\n#endif\n      join = tl;\n    }\n    else if (edge < -0.5 || l1 == 0.0) {\n      vec2 nr = normalize(d.zw);\n      vec2 tr = vec2(nr.y, -nr.x);\n\n#ifdef LINE_PROXIMITY\n      vClipProximity = 1.0;\n#endif\n\n#ifdef LINE_STROKE\n      vClipStrokeEven = vClipStrokeOdd = normalize(center - right);\n#endif\n      join = tr;\n    }\n    else {\n      // Limit join stretch for tiny segments\n      float lmin2 = min(l1, l2) / (width * width);\n\n      // Hide line segment if ratio of leg lengths exceeds promixity threshold\n#ifdef LINE_PROXIMITY\n      float lr     = l1 / l2;\n      float rl     = l2 / l1;\n      float ratio  = max(lr, rl);\n      float thresh = lineProximity + 1.0;\n      vClipProximity = (ratio > thresh * thresh) ? 1.0 : 0.0;\n#endif\n\n      // Calculate normals/tangents\n      vec2 nl = normalize(d.xy);\n      vec2 nr = normalize(d.zw);\n\n      // Calculate tangents\n      vec2 tl = vec2(nl.y, -nl.x);\n      vec2 tr = vec2(nr.y, -nr.x);\n\n#ifdef LINE_PROXIMITY\n      // Mix tangents according to leg lengths\n      vec2 tc = normalize(mix(tl, tr, l1/(l1+l2)));\n#else\n      // Average tangent\n      vec2 tc = normalize(tl + tr);\n#endif\n    \n      // Miter join\n      float cosA   = dot(nl, tc);\n      float sinA   = max(0.1, abs(dot(tl, tc)));\n      float factor = cosA / sinA;\n      float scale  = sqrt(1.0 + min(lmin2, factor * factor));\n\n      // Stroke normals\n#ifdef LINE_STROKE\n      vec3 stroke1 = normalize(left - center);\n      vec3 stroke2 = normalize(center - right);\n\n      if (odd) {\n        vClipStrokeEven = stroke1;\n        vClipStrokeOdd  = stroke2;\n      }\n      else {\n        vClipStrokeEven = stroke2;\n        vClipStrokeOdd  = stroke1;\n      }\n#endif\n\n#ifdef LINE_JOIN_MITER\n      // Apply straight up miter\n      join = tc * scale;\n#endif\n\n#ifdef LINE_JOIN_ROUND\n      // Slerp bevel join into circular arc\n      float dotProduct = dot(nl, nr);\n      float angle = acos(dotProduct);\n      float sinT  = sin(angle);\n      join = (sin((1.0 - joint) * angle) * tl + sin(joint * angle) * tr) / sinT;\n#endif\n\n#ifdef LINE_JOIN_BEVEL\n      // Direct bevel join between two flat ends\n      float dotProduct = dot(nl, nr);\n      join = mix(tl, tr, joint);\n#endif\n\n#ifdef LINE_JOIN_DETAIL\n      // Check if on inside or outside of joint\n      float crossProduct = nl.x * nr.y - nl.y * nr.x;\n      if (offset * crossProduct < 0.0) {\n        // For near-180-degree bends, correct back to a miter to avoid discontinuities\n        float ratio = clamp(-dotProduct * 2.0 - 1.0, 0.0, 1.0);\n        // Otherwise collapse the inside vertices into one.\n        join = mix(tc * scale, join, ratio * ratio * ratio);\n      }\n#endif\n\n    }\n    return vec3(join, 0.0);\n  }\n  else {\n    return vec3(0.0);\n  }\n\n}\n\n// Calculate final line position\nvec3 getLinePosition() {\n  vec3 left, center, right, join;\n\n  // left/center/right\n  float edge = line.x;\n  // up/down\n  float offset = line.y;\n\n  // Clip data\n  vec4 p = min(geometryClip, position4);\n  edge += max(0.0, position4.x - geometryClip.x);\n\n  // Get position + adjacent neighbours\n  getLineGeometry(p, edge, left, center, right);\n\n#ifdef LINE_STROKE\n  // Set parameters for line stroke fragment shader\n  vClipStrokePosition = center;\n  vClipStrokeIndex = p.x;\n  bool odd = mod(p.x, 2.0) >= 1.0;\n#else\n  bool odd = true;\n#endif\n\n  // Divide line width up/down\n  float width = lineWidth * 0.5;\n\n  float depth = focusDepth;\n  if (lineDepth < 1.0) {\n    // Depth blending\n    float z = max(0.00001, -center.z);\n    depth = mix(z, focusDepth, lineDepth);\n  }\n  width *= depth;\n\n  // Convert to world units\n  width *= worldUnit;\n\n  // Calculate line join\n  join = getLineJoin(edge, odd, left, center, right, width, offset, joint);\n  vec3 pos = center + join * offset * width;\n\n#ifdef LINE_STROKE\n  vClipStrokeWidth = width;\n#endif\n\n#ifdef LINE_CLIP\n  clipEnds(p, center, pos);\n#endif\n\n  return pos;\n}\n","map.2d.data":"uniform vec2 dataResolution;\nuniform vec2 dataPointer;\n\nvec2 map2DData(vec2 xy) {\n  return (xy + dataPointer) * dataResolution;\n}\n","map.2d.data.wrap":"uniform vec2 dataResolution;\nuniform vec2 dataPointer;\n\nvec2 map2DData(vec2 xy) {\n  return fract((xy + dataPointer) * dataResolution);\n}\n","map.xyzw.2dv":"void mapXyzw2DV(vec4 xyzw, out vec2 xy, out float z) {\n  xy = xyzw.xy;\n  z  = xyzw.z;\n}\n\n","map.xyzw.align":"vec4 alignXYZW(vec4 xyzw) {\n  return floor(xyzw + .5);\n}\n\n","map.xyzw.texture":"uniform float textureItems;\nuniform float textureHeight;\n\nvec2 mapXyzwTexture(vec4 xyzw) {\n  \n  float x = xyzw.x;\n  float y = xyzw.y;\n  float z = xyzw.z;\n  float i = xyzw.w;\n  \n  return vec2(i, y) + vec2(x, z) * vec2(textureItems, textureHeight);\n}\n\n","mesh.fragment.color":"varying vec4 vColor;\n\nvec4 getColor() {\n  return vColor;\n}\n","mesh.fragment.map":"#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\nvec4 getSample(vec4 uvwo, vec4 stpq);\n\nvec4 getMapColor() {\n  #ifdef POSITION_STPQ\n  vec4 stpq = vSTPQ;\n  #else\n  vec4 stpq = vec4(0.0);\n  #endif\n\n  #ifdef POSITION_U\n  vec4 uvwo = vec4(vU, 0.0, 0.0, 0.0);\n  #endif\n  #ifdef POSITION_UV\n  vec4 uvwo = vec4(vUV, 0.0, 0.0);\n  #endif\n  #ifdef POSITION_UVW\n  vec4 uvwo = vec4(vUVW, 0.0);\n  #endif\n  #ifdef POSITION_UVWO\n  vec4 uvwo = vec4(vUVWO);\n  #endif\n\n  return getSample(uvwo, stpq);\n}\n","mesh.fragment.mask":"varying float vMask;\n\nfloat ease(float t) {\n  t = clamp(t, 0.0, 1.0);\n  return t * t * (3.0 - 2.0 * t);\n}\n\nvec4 maskColor() {\n  if (vMask <= 0.0) discard;\n  return vec4(vec3(1.0), ease(vMask));\n}\n","mesh.fragment.material":"#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\nvec4 getSample(vec4 rgba, vec4 stpq);\n\nvec4 getMaterialColor(vec4 rgba) {\n  vec4 stpq = vec4(0.0);\n\n  #ifdef POSITION_U\n  stpq.x = vU;\n  #endif\n  #ifdef POSITION_UV\n  stpq.xy = vUV;\n  #endif\n  #ifdef POSITION_UVW\n  stpq.xyz = vUVW;\n  #endif\n  #ifdef POSITION_UVWO\n  stpq = vUVWO;\n  #endif\n\n  #ifdef POSITION_STPQ\n  stpq = vSTPQ;\n  #endif\n\n  return getSample(rgba, stpq);\n}\n","mesh.fragment.shaded":"varying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvec3 offSpecular(vec3 color) {\n  vec3 c = 1.0 - color;\n  return 1.0 - c * c;\n}\n\nvec4 getShadedColor(vec4 rgba) {\n  \n  vec3 color = rgba.xyz;\n  vec3 color2 = offSpecular(rgba.xyz);\n\n  vec3 normal = normalize(vNormal);\n  vec3 light = normalize(vLight);\n  vec3 position = normalize(vPosition);\n  \n  float side    = gl_FrontFacing ? -1.0 : 1.0;\n  float cosine  = side * dot(normal, light);\n  float diffuse = mix(max(0.0, cosine), .5 + .5 * cosine, .1);\n  \n  vec3  halfLight = normalize(light + position);\n\tfloat cosineHalf = max(0.0, side * dot(normal, halfLight));\n\tfloat specular = pow(cosineHalf, 16.0);\n\t\n\treturn vec4(color * (diffuse * .9 + .05) + .25 * color2 * specular, rgba.a);\n}\n","mesh.fragment.texture":"","mesh.gamma.in":"vec4 getGammaInColor(vec4 rgba) {\n  return vec4(rgba.rgb * rgba.rgb, rgba.a);\n}\n","mesh.gamma.out":"vec4 getGammaOutColor(vec4 rgba) {\n  return vec4(sqrt(rgba.rgb), rgba.a);\n}\n","mesh.map.uvwo":"vec4 mapUVWO(vec4 uvwo, vec4 stpq) {\n  return uvwo;\n}\n","mesh.position":"uniform vec4 geometryClip;\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getMeshPosition() {\n  vec4 p = min(geometryClip, position4);\n  return getPosition(p, 1.0);\n}\n","mesh.vertex.color":"attribute vec4 position4;\nuniform vec4 geometryClip;\nvarying vec4 vColor;\n\n// External\nvec4 getSample(vec4 xyzw);\n\nvoid vertexColor() {\n  vec4 p = min(geometryClip, position4);\n  vColor = getSample(p);\n}\n","mesh.vertex.mask":"attribute vec4 position4;\nuniform vec4 geometryResolution;\nuniform vec4 geometryClip;\nvarying float vMask;\n\n// External\nfloat getSample(vec4 xyzw);\n\nvoid maskLevel() {\n  vec4 p = min(geometryClip, position4);\n  vMask = getSample(p * geometryResolution);\n}\n","mesh.vertex.position":"uniform vec4 geometryResolution;\n\n#ifdef POSITION_STPQ\nvarying vec4 vSTPQ;\n#endif\n#ifdef POSITION_U\nvarying float vU;\n#endif\n#ifdef POSITION_UV\nvarying vec2 vUV;\n#endif\n#ifdef POSITION_UVW\nvarying vec3 vUVW;\n#endif\n#ifdef POSITION_UVWO\nvarying vec4 vUVWO;\n#endif\n\n// External\nvec3 getPosition(vec4 xyzw, in vec4 stpqIn, out vec4 stpqOut);\n\nvec3 getMeshPosition(vec4 xyzw, float canonical) {\n  vec4 stpqOut, stpqIn = xyzw * geometryResolution;\n  vec3 xyz = getPosition(xyzw, stpqIn, stpqOut);\n\n  #ifdef POSITION_MAP\n  if (canonical > 0.5) {\n    #ifdef POSITION_STPQ\n    vSTPQ = stpqOut;\n    #endif\n    #ifdef POSITION_U\n    vU = stpqOut.x;\n    #endif\n    #ifdef POSITION_UV\n    vUV = stpqOut.xy;\n    #endif\n    #ifdef POSITION_UVW\n    vUVW = stpqOut.xyz;\n    #endif\n    #ifdef POSITION_UVWO\n    vUVWO = stpqOut;\n    #endif\n  }\n  #endif\n  return xyz;\n}\n","move.position":"uniform float transitionEnter;\nuniform float transitionExit;\nuniform vec4  transitionScale;\nuniform vec4  transitionBias;\nuniform float transitionSkew;\nuniform float transitionActive;\n\nuniform vec4  moveFrom;\nuniform vec4  moveTo;\n\nfloat ease(float t) {\n  t = clamp(t, 0.0, 1.0);\n  return 1.0 - (2.0 - t) * t;\n}\n\nvec4 getTransitionPosition(vec4 xyzw, inout vec4 stpq) {\n  if (transitionActive < 0.5) return xyzw;\n\n  float enter   = transitionEnter;\n  float exit    = transitionExit;\n  float skew    = transitionSkew;\n  vec4  scale   = transitionScale;\n  vec4  bias    = transitionBias;\n\n  float factor  = 1.0 + skew;\n  float offset  = dot(vec4(1.0), stpq * scale + bias);\n\n  float a1 = ease(enter * factor - offset);\n  float a2 = ease(exit  * factor + offset - skew);\n\n  return xyzw + a1 * moveFrom + a2 * moveTo;\n}","object.mask.default":"vec4 getMask(vec4 xyzw) {\n  return vec4(1.0);\n}","point.alpha.circle":"varying float vPixelSize;\n\nfloat getDiscAlpha(float mask) {\n  // Approximation: 1 - x*x is approximately linear around x = 1 with slope 2\n  return vPixelSize * (1.0 - mask);\n  //  return vPixelSize * 2.0 * (1.0 - sqrt(mask));\n}\n","point.alpha.circle.hollow":"varying float vPixelSize;\n\nfloat getDiscHollowAlpha(float mask) {\n  return vPixelSize * (0.5 - 2.0 * abs(sqrt(mask) - .75));\n}\n","point.alpha.generic":"varying float vPixelSize;\n\nfloat getGenericAlpha(float mask) {\n  return vPixelSize * 2.0 * (1.0 - mask);\n}\n","point.alpha.generic.hollow":"varying float vPixelSize;\n\nfloat getGenericHollowAlpha(float mask) {\n  return vPixelSize * (0.5 - 2.0 * abs(mask - .75));\n}\n","point.edge":"varying vec2 vSprite;\n\nfloat getSpriteMask(vec2 xy);\nfloat getSpriteAlpha(float mask);\n\nvoid setFragmentColorFill(vec4 color) {\n  float mask = getSpriteMask(vSprite);\n  if (mask > 1.0) {\n    discard;\n  }\n  float alpha = getSpriteAlpha(mask);\n  if (alpha >= 1.0) {\n    discard;\n  }\n  gl_FragColor = vec4(color.rgb, alpha * color.a);\n}\n","point.fill":"varying vec2 vSprite;\n\nfloat getSpriteMask(vec2 xy);\nfloat getSpriteAlpha(float mask);\n\nvoid setFragmentColorFill(vec4 color) {\n  float mask = getSpriteMask(vSprite);\n  if (mask > 1.0) {\n    discard;\n  }\n  float alpha = getSpriteAlpha(mask);\n  if (alpha < 1.0) {\n    discard;\n  }\n  gl_FragColor = color;\n}\n\n","point.mask.circle":"varying float vPixelSize;\n\nfloat getCircleMask(vec2 uv) {\n  return dot(uv, uv);\n}\n","point.mask.diamond":"varying float vPixelSize;\n\nfloat getDiamondMask(vec2 uv) {\n  vec2 a = abs(uv);\n  return a.x + a.y;\n}\n","point.mask.down":"varying float vPixelSize;\n\nfloat getTriangleDownMask(vec2 uv) {\n  uv.y += .25;\n  return max(uv.y, abs(uv.x) * .866 - uv.y * .5 + .6);\n}\n","point.mask.left":"varying float vPixelSize;\n\nfloat getTriangleLeftMask(vec2 uv) {\n  uv.x += .25;\n  return max(uv.x, abs(uv.y) * .866 - uv.x * .5 + .6);\n}\n","point.mask.right":"varying float vPixelSize;\n\nfloat getTriangleRightMask(vec2 uv) {\n  uv.x -= .25;\n  return max(-uv.x, abs(uv.y) * .866 + uv.x * .5 + .6);\n}\n","point.mask.square":"varying float vPixelSize;\n\nfloat getSquareMask(vec2 uv) {\n  vec2 a = abs(uv);\n  return max(a.x, a.y);\n}\n","point.mask.up":"varying float vPixelSize;\n\nfloat getTriangleUpMask(vec2 uv) {\n  uv.y -= .25;\n  return max(-uv.y, abs(uv.x) * .866 + uv.y * .5 + .6);\n}\n","point.position":"uniform float pointDepth;\n\nuniform float pixelUnit;\nuniform float renderScale;\nuniform float renderScaleInv;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 sprite;\n\nvarying vec2 vSprite;\nvarying float vPixelSize;\n\nconst float pointScale = POINT_SHAPE_SCALE;\n\n// External\nfloat getPointSize(vec4 xyzw);\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getPointPosition() {\n  vec4 p = min(geometryClip, position4);\n  vec3 center = getPosition(p, 1.0);\n\n  // Depth blending\n  // TODO: orthographic camera\n  // Workaround: set depth = 0\n  float z = -center.z;\n  float depth = mix(z, focusDepth, pointDepth);\n  \n  // Match device/unit mapping \n  // Sprite goes from -1..1, width = 2.\n  float pointSize = getPointSize(p);\n  float size = pointScale * pointSize * pixelUnit * .5;\n  float depthSize = depth * size;\n  \n  // Pad sprite by half a pixel to make the anti-aliasing straddle the pixel edge\n  // Note: pixelsize measures radius\n  float pixelSize = .5 * (pointDepth > 0.0 ? depthSize / z : size);\n  float paddedSize = pixelSize + 0.5;\n  float padFactor = paddedSize / pixelSize;\n\n  vPixelSize = paddedSize;\n  vSprite    = sprite;\n\n  return center + vec3(sprite * depthSize * renderScaleInv * padFactor, 0.0);\n}\n","point.size.uniform":"uniform float pointSize;\n\nfloat getPointSize(vec4 xyzw) {\n  return pointSize;\n}","point.size.varying":"uniform float pointSize;\n\nvec4 getSample(vec4 xyzw);\n\nfloat getPointSize(vec4 xyzw) {\n  return pointSize * getSample(xyzw).x;\n}","polar.position":"uniform float polarBend;\nuniform float polarFocus;\nuniform float polarAspect;\nuniform float polarHelix;\n\nuniform mat4 viewMatrix;\n\nvec4 getPolarPosition(vec4 position, inout vec4 stpq) {\n  if (polarBend > 0.0) {\n\n    if (polarBend < 0.001) {\n      // Factor out large addition/subtraction of polarFocus\n      // to avoid numerical error\n      // sin(x) ~ x\n      // cos(x) ~ 1 - x * x / 2\n      vec2 pb = position.xy * polarBend;\n      float ppbbx = pb.x * pb.x;\n      return viewMatrix * vec4(\n        position.x * (1.0 - polarBend + (pb.y * polarAspect)),\n        position.y * (1.0 - .5 * ppbbx) - (.5 * ppbbx) * polarFocus / polarAspect,\n        position.z + position.x * polarHelix * polarBend,\n        1.0\n      );\n    }\n    else {\n      vec2 xy = position.xy * vec2(polarBend, polarAspect);\n      float radius = polarFocus + xy.y;\n      return viewMatrix * vec4(\n        sin(xy.x) * radius,\n        (cos(xy.x) * radius - polarFocus) / polarAspect,\n        position.z + position.x * polarHelix * polarBend,\n        1.0\n      );\n    }\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}","project.position":"uniform float styleZBias;\nuniform float styleZIndex;\n\nvoid setPosition(vec3 position) {\n  vec4 pos = projectionMatrix * vec4(position, 1.0);\n\n  // Apply relative Z bias\n  float bias  = (1.0 - styleZBias / 32768.0);\n  pos.z *= bias;\n  \n  // Apply large scale Z index changes\n  if (styleZIndex > 0.0) {\n    float z = pos.z / pos.w;\n    pos.z = ((z + 1.0) / (styleZIndex + 1.0) - 1.0) * pos.w;\n  }\n  \n  gl_Position = pos;\n}","project.readback":"// This is three.js' global uniform, missing from fragment shaders.\nuniform mat4 projectionMatrix;\n\nvec4 readbackPosition(vec3 position, vec4 stpq) {\n  vec4 pos = projectionMatrix * vec4(position, 1.0);\n  vec3 final = pos.xyz / pos.w;\n  if (final.z < -1.0) {\n    return vec4(0.0, 0.0, 0.0, -1.0);\n  }\n  else {\n    return vec4(final, -position.z);\n  }\n}\n","raw.position.scale":"uniform vec4 geometryScale;\nattribute vec4 position4;\n\nvec4 getRawPositionScale() {\n  return geometryScale * position4;\n}\n","repeat.position":"uniform vec4 repeatModulus;\n\nvec4 getRepeatXYZW(vec4 xyzw) {\n  return mod(xyzw + .5, repeatModulus) - .5;\n}\n","resample.padding":"uniform vec4 resampleBias;\n\nvec4 resamplePadding(vec4 xyzw) {\n  return xyzw + resampleBias;\n}","resample.relative":"uniform vec4 resampleFactor;\n\nvec4 resampleRelative(vec4 xyzw) {\n  return xyzw * resampleFactor;\n}","reveal.mask":"uniform float transitionEnter;\nuniform float transitionExit;\nuniform vec4  transitionScale;\nuniform vec4  transitionBias;\nuniform float transitionSkew;\nuniform float transitionActive;\n\nfloat getTransitionSDFMask(vec4 stpq) {\n  if (transitionActive < 0.5) return 1.0;\n\n  float enter   = transitionEnter;\n  float exit    = transitionExit;\n  float skew    = transitionSkew;\n  vec4  scale   = transitionScale;\n  vec4  bias    = transitionBias;\n\n  float factor  = 1.0 + skew;\n  float offset  = dot(vec4(1.0), stpq * scale + bias);\n\n  vec2 d = vec2(enter, exit) * factor + vec2(-offset, offset - skew);\n  if (exit  == 1.0) return d.x;\n  if (enter == 1.0) return d.y;\n  return min(d.x, d.y);\n}","root.position":"vec3 getRootPosition(vec4 position, in vec4 stpqIn, out vec4 stpqOut) {\n  stpqOut = stpqIn; // avoid inout confusion\n  return position.xyz;\n}","sample.2d":"uniform sampler2D dataTexture;\n\nvec4 sample2D(vec2 uv) {\n  return texture2D(dataTexture, uv);\n}\n","scale.position":"uniform vec4 scaleAxis;\nuniform vec4 scaleOffset;\n\nvec4 sampleData(float x);\n\nvec4 getScalePosition(vec4 xyzw) {\n  return scaleAxis * sampleData(xyzw.x).x + scaleOffset;\n}\n","screen.map.stpq":"uniform vec4 remapSTPQScale;\n\nvec4 screenMapSTPQ(vec4 xyzw, out vec4 stpq) {\n  stpq = xyzw * remapSTPQScale;\n  return xyzw;\n}\n","screen.map.xy":"uniform vec2 remapUVScale;\n\nvec4 screenMapXY(vec4 uvwo, vec4 stpq) {\n  return vec4(floor(remapUVScale * uvwo.xy), 0.0, 0.0);\n}\n","screen.map.xyzw":"uniform vec2 remapUVScale;\nuniform vec2 remapModulus;\nuniform vec2 remapModulusInv;\n\nvec4 screenMapXYZW(vec4 uvwo, vec4 stpq) {\n  vec2 st = floor(remapUVScale * uvwo.xy);\n  vec2 xy = st * remapModulusInv;\n  vec2 ixy = floor(xy);\n  vec2 fxy = xy - ixy;\n  vec2 zw = fxy * remapModulus;\n  return vec4(ixy.x, zw.y, ixy.y, zw.x);\n}\n","screen.pass.uv":"vec2 screenPassUV(vec4 uvwo, vec4 stpq) {\n  return uvwo.xy;\n}\n","screen.position":"void setScreenPosition(vec4 position) {\n  gl_Position = vec4(position.xy * 2.0 - 1.0, 0.5, 1.0);\n}\n","slice.position":"uniform vec4 sliceOffset;\n\nvec4 getSliceOffset(vec4 xyzw) {\n  return xyzw + sliceOffset;\n}\n","spherical.position":"uniform float sphericalBend;\nuniform float sphericalFocus;\nuniform float sphericalAspectX;\nuniform float sphericalAspectY;\nuniform float sphericalScaleY;\n\nuniform mat4 viewMatrix;\n\nvec4 getSphericalPosition(vec4 position, inout vec4 stpq) {\n  if (sphericalBend > 0.0001) {\n\n    vec3 xyz = position.xyz * vec3(sphericalBend, sphericalBend / sphericalAspectY * sphericalScaleY, sphericalAspectX);\n    float radius = sphericalFocus + xyz.z;\n    float cosine = cos(xyz.y) * radius;\n\n    return viewMatrix * vec4(\n      sin(xyz.x) * cosine,\n      sin(xyz.y) * radius * sphericalAspectY,\n      (cos(xyz.x) * cosine - sphericalFocus) / sphericalAspectX,\n      1.0\n    );\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}","split.position":"uniform float splitStride;\n\nvec2 getIndices(vec4 xyzw);\nvec4 getRest(vec4 xyzw);\nvec4 injectIndex(float v);\n\nvec4 getSplitXYZW(vec4 xyzw) {\n  vec2 uv = getIndices(xyzw);\n  float offset = uv.x + uv.y * splitStride;\n  return injectIndex(offset) + getRest(xyzw);\n}\n","spread.position":"uniform vec4 spreadOffset;\nuniform mat4 spreadMatrix;\n\n// External\nvec4 getSample(vec4 xyzw);\n\nvec4 getSpreadSample(vec4 xyzw) {\n  vec4 sample = getSample(xyzw);\n  return sample + spreadMatrix * (spreadOffset + xyzw);\n}\n","sprite.fragment":"varying vec2 vSprite;\n\nvec4 getSample(vec2 xy);\n\nvec4 getSpriteColor() {\n  return getSample(vSprite);\n}","sprite.position":"uniform vec2 spriteOffset;\nuniform float spriteScale;\nuniform float spriteDepth;\nuniform float spriteSnap;\n\nuniform vec2 renderOdd;\nuniform float renderScale;\nuniform float renderScaleInv;\nuniform float pixelUnit;\nuniform float focusDepth;\n\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 sprite;\n\nvarying float vPixelSize;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\nvec4 getSprite(vec4 xyzw);\n\nvec3 getSpritePosition() {\n  // Clip points\n  vec4 p = min(geometryClip, position4);\n  float diff = length(position4 - p);\n  if (diff > 0.0) {\n    return vec3(0.0, 0.0, 1000.0);\n  }\n\n  // Make sprites\n  vec3 center = getPosition(p, 1.0);\n  vec4 atlas = getSprite(p);\n\n  // Sprite goes from -1..1, width = 2.\n  // -1..1 -> -0.5..0.5\n  vec2 halfSprite = sprite * .5;\n  vec2 halfFlipSprite = vec2(halfSprite.x, -halfSprite.y);\n\n#ifdef POSITION_UV\n  // Assign UVs\n  vUV = atlas.xy + atlas.zw * (halfFlipSprite + .5);\n#endif\n\n  // Depth blending\n  // TODO: orthographic camera\n  // Workaround: set depth = 0\n  float depth = focusDepth, z;\n  z = -center.z;\n  if (spriteDepth < 1.0) {\n    depth = mix(z, focusDepth, spriteDepth);\n  }\n  \n  // Match device/unit mapping \n  float size = pixelUnit * spriteScale;\n  float depthSize = depth * size;\n\n  // Calculate pixelSize for anti-aliasing\n  float pixelSize = (spriteDepth > 0.0 ? depthSize / z : size);\n  vPixelSize = pixelSize;\n\n  // Position sprite\n  vec2 atlasOdd = fract(atlas.zw / 2.0);\n  vec2 offset = (spriteOffset + halfSprite * atlas.zw) * depthSize;\n  if (spriteSnap > 0.5) {\n    // Snap to pixel (w/ epsilon shift to avoid jitter)\n    return vec3(((floor(center.xy / center.z * renderScale + 0.001) + renderOdd + atlasOdd) * center.z + offset) * renderScaleInv, center.z);\n  }\n  else {\n    // Place directly\n    return center + vec3(offset * renderScaleInv, 0.0);\n  }\n\n}\n","stereographic.position":"uniform float stereoBend;\n\nuniform mat4 viewMatrix;\n\nvec4 getStereoPosition(vec4 position, inout vec4 stpq) {\n  if (stereoBend > 0.0001) {\n\n    vec3 pos = position.xyz;\n    float r = length(pos);\n    float z = r + pos.z;\n    vec3 project = vec3(pos.xy / z, r);\n    \n    vec3 lerped = mix(pos, project, stereoBend);\n\n    return viewMatrix * vec4(lerped, 1.0);\n  }\n  else {\n    return viewMatrix * vec4(position.xyz, 1.0);\n  }\n}","stereographic4.position":"uniform float stereoBend;\nuniform vec4 basisScale;\nuniform vec4 basisOffset;\nuniform mat4 viewMatrix;\nuniform vec2 view4D;\n\nvec4 getStereographic4Position(vec4 position, inout vec4 stpq) {\n  \n  vec4 transformed;\n  if (stereoBend > 0.0001) {\n\n    float r = length(position);\n    float w = r + position.w;\n    vec4 project = vec4(position.xyz / w, r);\n    \n    transformed = mix(position, project, stereoBend);\n  }\n  else {\n    transformed = position;\n  }\n\n  vec4 pos4 = transformed * basisScale - basisOffset;\n  vec3 xyz = (viewMatrix * vec4(pos4.xyz, 1.0)).xyz;\n  return vec4(xyz, pos4.w * view4D.y + view4D.x);\n}\n","stpq.sample.2d":"varying vec2 vST;\n\nvec4 getSample(vec2 st);\n\nvec4 getSTSample() {\n  return getSample(vST);\n}\n","stpq.xyzw.2d":"varying vec2 vUV;\n\nvoid setRawUV(vec4 xyzw) {\n  vUV = xyzw.xy;\n}\n","strip.position.normal":"uniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec3 strip;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvoid getStripGeometry(vec4 xyzw, vec3 strip, out vec3 pos, out vec3 normal) {\n  vec3 a, b, c;\n\n  a   = getPosition(xyzw, 1.0);\n  b   = getPosition(vec4(xyzw.xyz, strip.x), 0.0);\n  c   = getPosition(vec4(xyzw.xyz, strip.y), 0.0);\n\n  normal = normalize(cross(c - a, b - a)) * strip.z;\n  \n  pos = a;\n}\n\nvec3 getStripPositionNormal() {\n  vec3 center, normal;\n\n  vec4 p = min(geometryClip, position4);\n\n  getStripGeometry(p, strip, center, normal);\n  vNormal   = normal;\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz);\n  vPosition = -center;\n\n  return center;\n}\n","style.color":"uniform vec3 styleColor;\nuniform float styleOpacity;\n\nvec4 getStyleColor() {\n  return vec4(styleColor, styleOpacity);\n}\n","subdivide.depth":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideDepth(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.xy, i + g, xyzw.w));\n}\n","subdivide.depth.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideDepthLerp(vec4 xyzw) {\n  float x = xyzw.z;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.xy, i, xyzw.w);\n  vec4 xyzw2 = vec4(xyzw.xy, i + 1.0, xyzw.w);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.height":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideHeight(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.x, i + g, xyzw.zw));\n}\n","subdivide.height.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideHeightLerp(vec4 xyzw) {\n  float x = xyzw.y;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.x, i, xyzw.zw);\n  vec4 xyzw2 = vec4(xyzw.x, i + 1.0, xyzw.zw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.items":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideItems(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(xyzw.xyz, i + g));\n}\n","subdivide.items.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideItemsLerp(vec4 xyzw) {\n  float x = xyzw.w;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(xyzw.xyz, i);\n  vec4 xyzw2 = vec4(xyzw.xyz, i + 1.0);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","subdivide.width":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideWidth(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  return sampleData(vec4(i + g, xyzw.yzw));\n}\n","subdivide.width.lerp":"uniform float subdivideBevel;\n\n// External\nvec4 sampleData(vec4 xyzw);\n\nvec4 subdivideWidthLerp(vec4 xyzw) {\n  float x = xyzw.x;\n  float i = floor(x);\n  float f = x - i;\n\n  float minf = subdivideBevel * min(f, 1.0 - f);\n  float g = (f > 0.5) ? 1.0 - minf : (f < 0.5) ? minf : 0.5;\n\n  vec4 xyzw1 = vec4(i, xyzw.yzw);\n  vec4 xyzw2 = vec4(i + 1.0, xyzw.yzw);\n  \n  vec4 a = sampleData(xyzw1);\n  vec4 b = sampleData(xyzw2);\n\n  return mix(a, b, g);\n}\n","surface.mask.hollow":"attribute vec4 position4;\n\nfloat getSurfaceHollowMask(vec4 xyzw) {\n  vec4 df = abs(fract(position4) - .5);\n  vec2 df2 = min(df.xy, df.zw);\n  float df3 = min(df2.x, df2.y);\n  return df3;\n}","surface.position":"uniform vec4 geometryClip;\nuniform vec4 geometryResolution;\nuniform vec4 mapSize;\n\nattribute vec4 position4;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvec3 getSurfacePosition() {\n  vec4 p = min(geometryClip, position4);\n  vec3 xyz = getPosition(p, 1.0);\n\n  // Overwrite UVs\n#ifdef POSITION_UV\n#ifdef POSITION_UV_INT\n  vUV = -.5 + (position4.xy * geometryResolution.xy) * mapSize.xy;\n#else\n  vUV = position4.xy * geometryResolution.xy;\n#endif\n#endif\n\n  return xyz;\n}\n","surface.position.normal":"uniform vec4 mapSize;\nuniform vec4 geometryResolution;\nuniform vec4 geometryClip;\nattribute vec4 position4;\nattribute vec2 surface;\n\n// External\nvec3 getPosition(vec4 xyzw, float canonical);\n\nvoid getSurfaceGeometry(vec4 xyzw, float edgeX, float edgeY, out vec3 left, out vec3 center, out vec3 right, out vec3 up, out vec3 down) {\n  vec4 deltaX = vec4(1.0, 0.0, 0.0, 0.0);\n  vec4 deltaY = vec4(0.0, 1.0, 0.0, 0.0);\n\n  /*\n  // high quality, 5 tap\n  center =                  getPosition(xyzw, 1.0);\n  left   = (edgeX > -0.5) ? getPosition(xyzw - deltaX, 0.0) : center;\n  right  = (edgeX < 0.5)  ? getPosition(xyzw + deltaX, 0.0) : center;\n  down   = (edgeY > -0.5) ? getPosition(xyzw - deltaY, 0.0) : center;\n  up     = (edgeY < 0.5)  ? getPosition(xyzw + deltaY, 0.0) : center;\n  */\n  \n  // low quality, 3 tap\n  center =                  getPosition(xyzw, 1.0);\n  left   =                  center;\n  down   =                  center;\n  right  = (edgeX < 0.5)  ? getPosition(xyzw + deltaX, 0.0) : (2.0 * center - getPosition(xyzw - deltaX, 0.0));\n  up     = (edgeY < 0.5)  ? getPosition(xyzw + deltaY, 0.0) : (2.0 * center - getPosition(xyzw - deltaY, 0.0));\n}\n\nvec3 getSurfaceNormal(vec3 left, vec3 center, vec3 right, vec3 up, vec3 down) {\n  vec3 dx = right - left;\n  vec3 dy = up    - down;\n  vec3 n = cross(dy, dx);\n  if (length(n) > 0.0) {\n    return normalize(n);\n  }\n  return vec3(0.0, 1.0, 0.0);\n}\n\nvarying vec3 vNormal;\nvarying vec3 vLight;\nvarying vec3 vPosition;\n\nvec3 getSurfacePositionNormal() {\n  vec3 left, center, right, up, down;\n\n  vec4 p = min(geometryClip, position4);\n\n  getSurfaceGeometry(p, surface.x, surface.y, left, center, right, up, down);\n  vNormal   = getSurfaceNormal(left, center, right, up, down);\n  vLight    = normalize((viewMatrix * vec4(1.0, 2.0, 2.0, 0.0)).xyz); // hardcoded directional light\n  vPosition = -center;\n\n#ifdef POSITION_UV\n#ifdef POSITION_UV_INT\n  vUV = -.5 + (position4.xy * geometryResolution.xy) * mapSize.xy;\n#else\n  vUV = position4.xy * geometryResolution.xy;\n#endif\n#endif\n  \n  return center;\n}\n","ticks.position":"uniform float worldUnit;\nuniform float focusDepth;\nuniform float tickSize;\nuniform float tickEpsilon;\nuniform vec3  tickNormal;\nuniform vec2  tickStrip;\n\nvec4 getSample(vec4 xyzw);\n\nvec3 transformPosition(vec4 position, in vec4 stpqIn, out vec4 stpqOut);\n\nvec3 getTickPosition(vec4 xyzw, in vec4 stpqIn, out vec4 stpqOut) {\n  float epsilon = tickEpsilon;\n\n  // determine tick direction\n  float leftX  = max(tickStrip.x, xyzw.y - 1.0);\n  float rightX = min(tickStrip.y, xyzw.y + 1.0);\n  \n  vec4 left    = getSample(vec4(leftX,  xyzw.zw, 0.0));\n  vec4 right   = getSample(vec4(rightX, xyzw.zw, 0.0));\n  vec4 diff    = right - left;\n\n  vec3 normal  = cross(normalize(diff.xyz + vec3(diff.w)), tickNormal);\n  float bias   = max(0.0, 1.0 - length(normal) * 2.0);\n       normal  = mix(normal, tickNormal.yzx, bias * bias);\n  \n  // transform (point) and (point + delta)\n  vec4 center  = getSample(vec4(xyzw.yzw, 0.0));\n  vec4 delta   = vec4(normal, 0.0) * epsilon;\n\n  vec4 a = center;\n  vec4 b = center + delta;\n\n  vec4 _;\n  vec3 c = transformPosition(a, stpqIn, stpqOut);\n  vec3 d = transformPosition(b, stpqIn, _);\n  \n  // sample on either side to create line\n  float line = xyzw.x - .5;\n  vec3  mid  = c;\n  vec3  side = normalize(d - c);\n\n  return mid + side * line * tickSize * worldUnit * focusDepth;\n}\n","transform3.position":"uniform mat4 transformMatrix;\n\nvec4 transformPosition(vec4 position, inout vec4 stpq) {\n  return transformMatrix * vec4(position.xyz, 1.0);\n}\n","transform4.position":"uniform mat4 transformMatrix;\nuniform vec4 transformOffset;\n\nvec4 transformPosition(vec4 position, inout vec4 stpq) {\n  return transformMatrix * position + transformOffset;\n}\n","view.position":"// Implicit three.js uniform\n// uniform mat4 viewMatrix;\n\nvec4 getViewPosition(vec4 position, inout vec4 stpq) {\n  return (viewMatrix * vec4(position.xyz, 1.0));\n}\n"}},{}],2:[function(t,e,r){var i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";(function(t){"use strict";var e=typeof Uint8Array!=="undefined"?Uint8Array:Array;var r="+".charCodeAt(0);var n="/".charCodeAt(0);var o="0".charCodeAt(0);var s="a".charCodeAt(0);var a="A".charCodeAt(0);var u="-".charCodeAt(0);var l="_".charCodeAt(0);function h(t){var e=t.charCodeAt(0);if(e===r||e===u)return 62;if(e===n||e===l)return 63;if(e<o)return-1;if(e<o+10)return e-o+26+26;if(e<a+26)return e-a;if(e<s+26)return e-s+26}function f(t){var r,i,n,o,s,a;if(t.length%4>0){throw new Error("Invalid string. Length must be a multiple of 4")}var u=t.length;s="="===t.charAt(u-2)?2:"="===t.charAt(u-1)?1:0;a=new e(t.length*3/4-s);n=s>0?t.length-4:t.length;var l=0;function f(t){a[l++]=t}for(r=0,i=0;r<n;r+=4,i+=3){o=h(t.charAt(r))<<18|h(t.charAt(r+1))<<12|h(t.charAt(r+2))<<6|h(t.charAt(r+3));f((o&16711680)>>16);f((o&65280)>>8);f(o&255)}if(s===2){o=h(t.charAt(r))<<2|h(t.charAt(r+1))>>4;f(o&255)}else if(s===1){o=h(t.charAt(r))<<10|h(t.charAt(r+1))<<4|h(t.charAt(r+2))>>2;f(o>>8&255);f(o&255)}return a}function c(t){var e,r=t.length%3,n="",o,s;function a(t){return i.charAt(t)}function u(t){return a(t>>18&63)+a(t>>12&63)+a(t>>6&63)+a(t&63)}for(e=0,s=t.length-r;e<s;e+=3){o=(t[e]<<16)+(t[e+1]<<8)+t[e+2];n+=u(o)}switch(r){case 1:o=t[t.length-1];n+=a(o>>2);n+=a(o<<4&63);n+="==";break;case 2:o=(t[t.length-2]<<8)+t[t.length-1];n+=a(o>>10);n+=a(o>>4&63);n+=a(o<<2&63);n+="=";break}return n}t.toByteArray=f;t.fromByteArray=c})(typeof r==="undefined"?this.base64js={}:r)},{}],3:[function(t,e,r){var i=t("buffer").Buffer;function n(t){if(t&&!i.isEncoding(t)){throw new Error("Unknown encoding: "+t)}}var o=r.StringDecoder=function(t){this.encoding=(t||"utf8").toLowerCase().replace(/[-_]/,"");n(t);switch(this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2;this.detectIncompleteChar=a;break;case"base64":this.surrogateSize=3;this.detectIncompleteChar=u;break;default:this.write=s;return}this.charBuffer=new i(6);this.charReceived=0;this.charLength=0};o.prototype.write=function(t){var e="";var r=0;while(this.charLength){var i=t.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:t.length;t.copy(this.charBuffer,this.charReceived,r,i);this.charReceived+=i-r;r=i;if(this.charReceived<this.charLength){return""}e=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var n=e.charCodeAt(e.length-1);if(n>=55296&&n<=56319){this.charLength+=this.surrogateSize;e="";continue}this.charReceived=this.charLength=0;if(i==t.length)return e;t=t.slice(i,t.length);break}var o=this.detectIncompleteChar(t);var s=t.length;if(this.charLength){t.copy(this.charBuffer,0,t.length-o,s);this.charReceived=o;s-=o}e+=t.toString(this.encoding,0,s);var s=e.length-1;var n=e.charCodeAt(s);if(n>=55296&&n<=56319){var a=this.surrogateSize;this.charLength+=a;this.charReceived+=a;this.charBuffer.copy(this.charBuffer,a,0,a);this.charBuffer.write(e.charAt(e.length-1),this.encoding);return e.substring(0,s)}return e};o.prototype.detectIncompleteChar=function(t){var e=t.length>=3?3:t.length;for(;e>0;e--){var r=t[t.length-e];if(e==1&&r>>5==6){this.charLength=2;break}if(e<=2&&r>>4==14){this.charLength=3;break}if(e<=3&&r>>3==30){this.charLength=4;break}}return e};o.prototype.end=function(t){var e="";if(t&&t.length)e=this.write(t);if(this.charReceived){var r=this.charReceived;var i=this.charBuffer;var n=this.encoding;e+=i.slice(0,r).toString(n)}return e};function s(t){return t.toString(this.encoding)}function a(t){var e=this.charReceived=t.length%2;this.charLength=e?2:0;return e}function u(t){var e=this.charReceived=t.length%3;this.charLength=e?3:0;return e}},{buffer:4}],4:[function(t,e,r){var i=t("base64-js");var n=t("ieee754");r.Buffer=o;r.SlowBuffer=o;r.INSPECT_MAX_BYTES=50;o.poolSize=8192;o._useTypedArrays=function(){try{var t=new ArrayBuffer(0);var e=new Uint8Array(t);e.foo=function(){return 42};return 42===e.foo()&&typeof e.subarray==="function"}catch(t){return false}}();function o(t,e,r){if(!(this instanceof o))return new o(t,e,r);var i=typeof t;if(e==="base64"&&i==="string"){t=A(t);while(t.length%4!==0){t=t+"="}}var n;if(i==="number")n=P(t);else if(i==="string")n=o.byteLength(t,e);else if(i==="object")n=P(t.length);else throw new Error("First argument needs to be a number, array or string.");var s;if(o._useTypedArrays){s=o._augment(new Uint8Array(n))}else{s=this;s.length=n;s._isBuffer=true}var a;if(o._useTypedArrays&&typeof t.byteLength==="number"){s._set(t)}else if(D(t)){for(a=0;a<n;a++){if(o.isBuffer(t))s[a]=t.readUInt8(a);else s[a]=t[a]}}else if(i==="string"){s.write(t,0,e)}else if(i==="number"&&!o._useTypedArrays&&!r){for(a=0;a<n;a++){s[a]=0}}return s}o.isEncoding=function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"raw":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return true;default:return false}};o.isBuffer=function(t){return!!(t!==null&&t!==undefined&&t._isBuffer)};o.byteLength=function(t,e){var r;t=t+"";switch(e||"utf8"){case"hex":r=t.length/2;break;case"utf8":case"utf-8":r=F(t).length;break;case"ascii":case"binary":case"raw":r=t.length;break;case"base64":r=V(t).length;break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":r=t.length*2;break;default:throw new Error("Unknown encoding")}return r};o.concat=function(t,e){X(z(t),"Usage: Buffer.concat(list, [totalLength])\n"+"list should be an Array.");if(t.length===0){return new o(0)}else if(t.length===1){return t[0]}var r;if(typeof e!=="number"){e=0;for(r=0;r<t.length;r++){e+=t[r].length}}var i=new o(e);var n=0;for(r=0;r<t.length;r++){var s=t[r];s.copy(i,n);n+=s.length}return i};function s(t,e,r,i){r=Number(r)||0;var n=t.length-r;if(!i){i=n}else{i=Number(i);if(i>n){i=n}}var s=e.length;X(s%2===0,"Invalid hex string");if(i>s/2){i=s/2}for(var a=0;a<i;a++){var u=parseInt(e.substr(a*2,2),16);X(!isNaN(u),"Invalid hex string");t[r+a]=u}o._charsWritten=a*2;return a}function a(t,e,r,i){var n=o._charsWritten=N(F(e),t,r,i);return n}function u(t,e,r,i){var n=o._charsWritten=N(U(e),t,r,i);return n}function l(t,e,r,i){return u(t,e,r,i)}function h(t,e,r,i){var n=o._charsWritten=N(V(e),t,r,i);return n}function f(t,e,r,i){var n=o._charsWritten=N(B(e),t,r,i);return n}o.prototype.write=function(t,e,r,i){if(isFinite(e)){if(!isFinite(r)){i=r;r=undefined}}else{var n=i;i=e;e=r;r=n}e=Number(e)||0;var o=this.length-e;if(!r){r=o}else{r=Number(r);if(r>o){r=o}}i=String(i||"utf8").toLowerCase();var c;switch(i){case"hex":c=s(this,t,e,r);break;case"utf8":case"utf-8":c=a(this,t,e,r);break;case"ascii":c=u(this,t,e,r);break;case"binary":c=l(this,t,e,r);break;case"base64":c=h(this,t,e,r);break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":c=f(this,t,e,r);break;default:throw new Error("Unknown encoding")}return c};o.prototype.toString=function(t,e,r){var i=this;t=String(t||"utf8").toLowerCase();e=Number(e)||0;r=r!==undefined?Number(r):r=i.length;if(r===e)return"";var n;switch(t){case"hex":n=v(i,e,r);break;case"utf8":case"utf-8":n=p(i,e,r);break;case"ascii":n=d(i,e,r);break;case"binary":n=m(i,e,r);break;case"base64":n=c(i,e,r);break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":n=g(i,e,r);break;default:throw new Error("Unknown encoding")}return n};o.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};o.prototype.copy=function(t,e,r,i){var n=this;if(!r)r=0;if(!i&&i!==0)i=this.length;if(!e)e=0;if(i===r)return;if(t.length===0||n.length===0)return;X(i>=r,"sourceEnd < sourceStart");X(e>=0&&e<t.length,"targetStart out of bounds");X(r>=0&&r<n.length,"sourceStart out of bounds");X(i>=0&&i<=n.length,"sourceEnd out of bounds");if(i>this.length)i=this.length;if(t.length-e<i-r)i=t.length-e+r;var s=i-r;if(s<100||!o._useTypedArrays){for(var a=0;a<s;a++)t[a+e]=this[a+r]}else{t._set(this.subarray(r,r+s),e)}};function c(t,e,r){if(e===0&&r===t.length){return i.fromByteArray(t)}else{return i.fromByteArray(t.slice(e,r))}}function p(t,e,r){var i="";var n="";r=Math.min(t.length,r);for(var o=e;o<r;o++){if(t[o]<=127){i+=I(n)+String.fromCharCode(t[o]);n=""}else{n+="%"+t[o].toString(16)}}return i+I(n)}function d(t,e,r){var i="";r=Math.min(t.length,r);for(var n=e;n<r;n++)i+=String.fromCharCode(t[n]);return i}function m(t,e,r){return d(t,e,r)}function v(t,e,r){var i=t.length;if(!e||e<0)e=0;if(!r||r<0||r>i)r=i;var n="";for(var o=e;o<r;o++){n+=O(t[o])}return n}function g(t,e,r){var i=t.slice(e,r);var n="";for(var o=0;o<i.length;o+=2){n+=String.fromCharCode(i[o]+i[o+1]*256)}return n}o.prototype.slice=function(t,e){var r=this.length;t=L(t,r,0);e=L(e,r,r);if(o._useTypedArrays){return o._augment(this.subarray(t,e))}else{var i=e-t;var n=new o(i,undefined,true);for(var s=0;s<i;s++){n[s]=this[s+t]}return n}};o.prototype.get=function(t){console.log(".get() is deprecated. Access using array indexes instead.");return this.readUInt8(t)};o.prototype.set=function(t,e){console.log(".set() is deprecated. Access using array indexes instead.");return this.writeUInt8(t,e)};o.prototype.readUInt8=function(t,e){if(!e){X(t!==undefined&&t!==null,"missing offset");X(t<this.length,"Trying to read beyond buffer length")}if(t>=this.length)return;return this[t]};function y(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e!==undefined&&e!==null,"missing offset");X(e+1<t.length,"Trying to read beyond buffer length")}var n=t.length;if(e>=n)return;var o;if(r){o=t[e];if(e+1<n)o|=t[e+1]<<8}else{o=t[e]<<8;if(e+1<n)o|=t[e+1]}return o}o.prototype.readUInt16LE=function(t,e){return y(this,t,true,e)};o.prototype.readUInt16BE=function(t,e){return y(this,t,false,e)};function E(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e!==undefined&&e!==null,"missing offset");X(e+3<t.length,"Trying to read beyond buffer length")}var n=t.length;if(e>=n)return;var o;if(r){if(e+2<n)o=t[e+2]<<16;if(e+1<n)o|=t[e+1]<<8;o|=t[e];if(e+3<n)o=o+(t[e+3]<<24>>>0)}else{if(e+1<n)o=t[e+1]<<16;if(e+2<n)o|=t[e+2]<<8;if(e+3<n)o|=t[e+3];o=o+(t[e]<<24>>>0)}return o}o.prototype.readUInt32LE=function(t,e){return E(this,t,true,e)};o.prototype.readUInt32BE=function(t,e){return E(this,t,false,e)};o.prototype.readInt8=function(t,e){if(!e){X(t!==undefined&&t!==null,"missing offset");X(t<this.length,"Trying to read beyond buffer length")}if(t>=this.length)return;var r=this[t]&128;if(r)return(255-this[t]+1)*-1;else return this[t]};function _(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e!==undefined&&e!==null,"missing offset");X(e+1<t.length,"Trying to read beyond buffer length")}var n=t.length;if(e>=n)return;var o=y(t,e,r,true);var s=o&32768;if(s)return(65535-o+1)*-1;else return o}o.prototype.readInt16LE=function(t,e){return _(this,t,true,e)};o.prototype.readInt16BE=function(t,e){return _(this,t,false,e)};function x(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e!==undefined&&e!==null,"missing offset");X(e+3<t.length,"Trying to read beyond buffer length")}var n=t.length;if(e>=n)return;var o=E(t,e,r,true);var s=o&2147483648;if(s)return(4294967295-o+1)*-1;else return o}o.prototype.readInt32LE=function(t,e){return x(this,t,true,e)};o.prototype.readInt32BE=function(t,e){return x(this,t,false,e)};function b(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e+3<t.length,"Trying to read beyond buffer length")}return n.read(t,e,r,23,4)}o.prototype.readFloatLE=function(t,e){return b(this,t,true,e)};o.prototype.readFloatBE=function(t,e){return b(this,t,false,e)};function T(t,e,r,i){if(!i){X(typeof r==="boolean","missing or invalid endian");X(e+7<t.length,"Trying to read beyond buffer length")}return n.read(t,e,r,52,8)}o.prototype.readDoubleLE=function(t,e){return T(this,t,true,e)};o.prototype.readDoubleBE=function(t,e){return T(this,t,false,e)};o.prototype.writeUInt8=function(t,e,r){if(!r){X(t!==undefined&&t!==null,"missing value");X(e!==undefined&&e!==null,"missing offset");X(e<this.length,"trying to write beyond buffer length");j(t,255)}if(e>=this.length)return;this[e]=t};function w(t,e,r,i,n){if(!n){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+1<t.length,"trying to write beyond buffer length");j(e,65535)}var o=t.length;if(r>=o)return;for(var s=0,a=Math.min(o-r,2);s<a;s++){t[r+s]=(e&255<<8*(i?s:1-s))>>>(i?s:1-s)*8}}o.prototype.writeUInt16LE=function(t,e,r){w(this,t,e,true,r)};o.prototype.writeUInt16BE=function(t,e,r){w(this,t,e,false,r)};function R(t,e,r,i,n){if(!n){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+3<t.length,"trying to write beyond buffer length");j(e,4294967295)}var o=t.length;if(r>=o)return;for(var s=0,a=Math.min(o-r,4);s<a;s++){t[r+s]=e>>>(i?s:3-s)*8&255}}o.prototype.writeUInt32LE=function(t,e,r){R(this,t,e,true,r)};o.prototype.writeUInt32BE=function(t,e,r){R(this,t,e,false,r)};o.prototype.writeInt8=function(t,e,r){if(!r){X(t!==undefined&&t!==null,"missing value");X(e!==undefined&&e!==null,"missing offset");X(e<this.length,"Trying to write beyond buffer length");G(t,127,-128)}if(e>=this.length)return;if(t>=0)this.writeUInt8(t,e,r);else this.writeUInt8(255+t+1,e,r)};function H(t,e,r,i,n){if(!n){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+1<t.length,"Trying to write beyond buffer length");G(e,32767,-32768)}var o=t.length;if(r>=o)return;if(e>=0)w(t,e,r,i,n);else w(t,65535+e+1,r,i,n)}o.prototype.writeInt16LE=function(t,e,r){H(this,t,e,true,r)};o.prototype.writeInt16BE=function(t,e,r){H(this,t,e,false,r)};function M(t,e,r,i,n){if(!n){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+3<t.length,"Trying to write beyond buffer length");G(e,2147483647,-2147483648)}var o=t.length;if(r>=o)return;if(e>=0)R(t,e,r,i,n);else R(t,4294967295+e+1,r,i,n)}o.prototype.writeInt32LE=function(t,e,r){M(this,t,e,true,r)};o.prototype.writeInt32BE=function(t,e,r){M(this,t,e,false,r)};function S(t,e,r,i,o){if(!o){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+3<t.length,"Trying to write beyond buffer length");W(e,3.4028234663852886e38,-3.4028234663852886e38)}var s=t.length;if(r>=s)return;n.write(t,e,r,i,23,4)}o.prototype.writeFloatLE=function(t,e,r){S(this,t,e,true,r)};o.prototype.writeFloatBE=function(t,e,r){S(this,t,e,false,r)};function k(t,e,r,i,o){if(!o){X(e!==undefined&&e!==null,"missing value");X(typeof i==="boolean","missing or invalid endian");X(r!==undefined&&r!==null,"missing offset");X(r+7<t.length,"Trying to write beyond buffer length");W(e,1.7976931348623157e308,-1.7976931348623157e308)}var s=t.length;if(r>=s)return;n.write(t,e,r,i,52,8)}o.prototype.writeDoubleLE=function(t,e,r){k(this,t,e,true,r)};o.prototype.writeDoubleBE=function(t,e,r){k(this,t,e,false,r)};o.prototype.fill=function(t,e,r){if(!t)t=0;if(!e)e=0;if(!r)r=this.length;if(typeof t==="string"){t=t.charCodeAt(0)}X(typeof t==="number"&&!isNaN(t),"value is not a number");X(r>=e,"end < start");if(r===e)return;if(this.length===0)return;X(e>=0&&e<this.length,"start out of bounds");X(r>=0&&r<=this.length,"end out of bounds");for(var i=e;i<r;i++){this[i]=t}};o.prototype.inspect=function(){var t=[];var e=this.length;for(var i=0;i<e;i++){t[i]=O(this[i]);if(i===r.INSPECT_MAX_BYTES){t[i+1]="...";break}}return"<Buffer "+t.join(" ")+">"};o.prototype.toArrayBuffer=function(){if(typeof Uint8Array!=="undefined"){if(o._useTypedArrays){return new o(this).buffer}else{var t=new Uint8Array(this.length);for(var e=0,r=t.length;e<r;e+=1)t[e]=this[e];return t.buffer}}else{throw new Error("Buffer.toArrayBuffer not supported in this browser")}};function A(t){if(t.trim)return t.trim();return t.replace(/^\s+|\s+$/g,"")}var C=o.prototype;o._augment=function(t){t._isBuffer=true;t._get=t.get;t._set=t.set;t.get=C.get;t.set=C.set;t.write=C.write;t.toString=C.toString;t.toLocaleString=C.toString;t.toJSON=C.toJSON;t.copy=C.copy;t.slice=C.slice;t.readUInt8=C.readUInt8;t.readUInt16LE=C.readUInt16LE;t.readUInt16BE=C.readUInt16BE;t.readUInt32LE=C.readUInt32LE;t.readUInt32BE=C.readUInt32BE;t.readInt8=C.readInt8;t.readInt16LE=C.readInt16LE;t.readInt16BE=C.readInt16BE;t.readInt32LE=C.readInt32LE;t.readInt32BE=C.readInt32BE;t.readFloatLE=C.readFloatLE;t.readFloatBE=C.readFloatBE;t.readDoubleLE=C.readDoubleLE;t.readDoubleBE=C.readDoubleBE;t.writeUInt8=C.writeUInt8;t.writeUInt16LE=C.writeUInt16LE;t.writeUInt16BE=C.writeUInt16BE;t.writeUInt32LE=C.writeUInt32LE;t.writeUInt32BE=C.writeUInt32BE;t.writeInt8=C.writeInt8;t.writeInt16LE=C.writeInt16LE;t.writeInt16BE=C.writeInt16BE;t.writeInt32LE=C.writeInt32LE;t.writeInt32BE=C.writeInt32BE;t.writeFloatLE=C.writeFloatLE;t.writeFloatBE=C.writeFloatBE;t.writeDoubleLE=C.writeDoubleLE;t.writeDoubleBE=C.writeDoubleBE;t.fill=C.fill;t.inspect=C.inspect;t.toArrayBuffer=C.toArrayBuffer;return t};function L(t,e,r){if(typeof t!=="number")return r;t=~~t;if(t>=e)return e;if(t>=0)return t;t+=e;if(t>=0)return t;return 0}function P(t){t=~~Math.ceil(+t);return t<0?0:t}function z(t){return(Array.isArray||function(t){return Object.prototype.toString.call(t)==="[object Array]"})(t)}function D(t){return z(t)||o.isBuffer(t)||t&&typeof t==="object"&&typeof t.length==="number"}function O(t){if(t<16)return"0"+t.toString(16);return t.toString(16)}function F(t){var e=[];for(var r=0;r<t.length;r++){var i=t.charCodeAt(r);if(i<=127)e.push(t.charCodeAt(r));else{var n=r;if(i>=55296&&i<=57343)r++;var o=encodeURIComponent(t.slice(n,r+1)).substr(1).split("%");for(var s=0;s<o.length;s++)e.push(parseInt(o[s],16))}}return e}function U(t){var e=[];for(var r=0;r<t.length;r++){e.push(t.charCodeAt(r)&255)}return e}function B(t){var e,r,i;var n=[];for(var o=0;o<t.length;o++){e=t.charCodeAt(o);r=e>>8;i=e%256;n.push(i);n.push(r)}return n}function V(t){return i.toByteArray(t)}function N(t,e,r,i){var n;for(var o=0;o<i;o++){if(o+r>=e.length||o>=t.length)break;e[o+r]=t[o]}return o}function I(t){try{return decodeURIComponent(t)}catch(t){return String.fromCharCode(65533)}}function j(t,e){X(typeof t==="number","cannot write a non-number as a number");X(t>=0,"specified a negative value for writing an unsigned value");X(t<=e,"value is larger than maximum value for type");X(Math.floor(t)===t,"value has a fractional component")}function G(t,e,r){X(typeof t==="number","cannot write a non-number as a number");X(t<=e,"value larger than maximum allowed value");X(t>=r,"value smaller than minimum allowed value");X(Math.floor(t)===t,"value has a fractional component")}function W(t,e,r){X(typeof t==="number","cannot write a non-number as a number");X(t<=e,"value larger than maximum allowed value");X(t>=r,"value smaller than minimum allowed value")}function X(t,e){if(!t)throw new Error(e||"Failed assertion")}},{"base64-js":2,ieee754:8}],5:[function(t,e,r){e.exports=n;var i=t("./tokenizer");function n(t,e){return function(r){return a(r,o(t),e||R)}}function o(t){for(var e in t)if(s(t,e)){t[e]=Function("return function(node, attr) { return node."+t[e]+" }");t[e]=t[e]()}return t}function s(t,e){return t.hasOwnProperty(e)&&typeof t[e]==="string"}function a(t,e,r){var n=i(),o=true,s=[[]],a,h;h=s[0];a={"":y,">":E,"+":_,"~":x};n.on("data",f).end(t);function f(t){var e;if(t.type==="comma"){s.unshift(h=[]);return}if(t.type==="op"||t.type==="any-child"){h.unshift(a[t.data]);h.unshift(d());return}h[0]=h[0]||d();e=h[0];if(t.type==="!"){e.subject=s[0].subject=true;return}e.push(t.type==="class"?m(t.type,t.data):t.type==="attr"?v(t):t.type===":"||t.type==="::"?b(t):t.type==="*"?Boolean:g(t.type,t.data,r))}return p;function p(t,e){var r,i,n,o,a;n=t;a=[];for(var l=0,f=s.length;l<f;++l){h=s[l];r=u;i=h.length;t=n;o=[];for(var c=0;c<i;c+=2){t=r(t,h[c],o);if(!t){break}r=h[c+1]}if(c>=i){if(e){return true}p(!h.subject?[n]:o)}}if(e){return false}return!a.length?false:a.length===1?a[0]:a;function p(t){var e;while(t.length){e=t.shift();if(a.indexOf(e)===-1){a.push(e)}}}}function d(){t.bits=[];t.subject=false;t.push=function(e){t.bits.push(e)};return t;function t(e,r){for(var i=0,n=t.bits.length;i<n;++i){if(!t.bits[i](e)){return false}}if(t.subject){r.push(e)}return true}}function m(t,r){return function(i){var n=e[t](i);n=Array.isArray(n)?n:n?n.toString().split(/\s+/):[];return n.indexOf(r)>=0}}function v(t){return t.data.lhs?c(e.attr,t.data.lhs,t.data.cmp,t.data.rhs):c(e.attr,t.data)}function g(t,r,i){return function(n){return i(t,e[t](n),r)}}function y(t,r,i){do{t=e.parent(t)}while(t&&!r(t,i));return t}function E(t,r,i){t=e.parent(t);return t&&r(t,i)?t:null}function _(t,r,i){var n=e.parent(t),o=0,s;s=e.children(n);for(var a=0,u=s.length;a<u;++a){if(s[a]===t){o=a;break}}return s[o-1]&&r(s[o-1],i)?s[o-1]:null}function x(t,r,i){var n=e.parent(t),o;o=e.children(n);for(var s=0,a=o.length;s<a;++s){if(o[s]===t){return null}if(r(o[s],i)){return o[s]}}return null}function b(t){return l(e,t.data,r)}}function u(t,e,r){return e(t,r)?t:null}function l(t,e,r){switch(e){case"empty":return m(t);case"first-child":return p(t);case"last-child":return d(t);case"root":return v(t)}if(e.indexOf("contains")===0){return g(t,e.slice(9,-1))}if(e.indexOf("any")===0){return f(t,e.slice(4,-1),r)}if(e.indexOf("not")===0){return h(t,e.slice(4,-1),r)}if(e.indexOf("nth-child")===0){return y(t,e.slice(10,-1))}return function(){return false}}function h(t,e,r){var i=a(e,t,r);return n;function n(t){return!i(t,true)}}function f(t,e,r){var i=a(e,t,r);return i}function c(t,e,r,i){return function(n){var o=t(n,e);if(!r){return!!o}if(r.length===1){return o==i}if(o===void 0||o===null){return false}return E[r.charAt(0)](o,i)}}function p(t){return function(e){return t.children(t.parent(e))[0]===e}}function d(t){return function(e){var r=t.children(t.parent(e));return r[r.length-1]===e}}function m(t){return function(e){return t.children(e).length===0}}function v(t){return function(e){return!t.parent(e)}}function g(t,e){return function(r){return t.contents(r).indexOf(e)!==-1}}function y(t,e){var r=function(){return false};if(e=="odd"){e="2n+1"}else if(e=="even"){e="2n"}var i=/( ?([-|\+])?(\d*)n)? ?((\+|-)? ?(\d+))? ?/;var n=e.match(i);if(n){var o=0;if(n[1]){var s=n[2]!="-";o=parseInt(n[3]==""?1:n[3]);o=o*(s?1:-1)}var a=0;if(n[4]){a=parseInt(n[6]);var u=n[5]!="-";a=a*(u?1:-1)}if(o==0){if(a!=0){r=function(t,e){return t[a-1]===e}}}else{r=function(t,e){var r=[];var i=t.length;for(var n=1;n<=i;n++){var s=(n-a)%o==0;if(s){if(o>0){r.push(n)}else{if((n-a)/o>=0){r.push(n)}}}}for(var u=0;u<r.length;u++){if(t[r[u]-1]===e){return true}}return false}}}return function(e){var i=t.children(t.parent(e));return r(i,e)}}var E={$:_,"^":x,"*":b,"~":T,"|":w};function _(t,e){return t.slice(t.length-e.length)===e}function x(t,e){return t.slice(0,e.length)===e}function b(t,e){return t.indexOf(e)>-1}function T(t,e){return t.split(/\s+/).indexOf(e)>-1}function w(t,e){return t.split("-").indexOf(e)>-1}function R(t,e,r){return e===r}},{"./tokenizer":6}],6:[function(t,e,r){e.exports=_;var i=t("through");var n="pseudo-start",o="attr-start",s="any-child",a="attr-comp",u="attr-end",l="::",h=":",f="(ready)",c="op",p="class",d="comma",m="attr",v="!",g="tag",y="*",E="id";function _(){var t=false,e=[],r=f,_=[],x=0,b,T,w,R,H,M,S,k;return b=i(A,C);function A(t){_=_.concat(t.split(""));T=_.length;while(x<T&&(k=_[x++])){switch(r){case f:L();break;case s:F();break;case c:O();break;case o:V();break;case a:N();break;case u:I();break;case h:case l:U();break;case n:B();break;case E:case g:case p:j();break}}_=_.slice(x)}function C(t){if(arguments.length){A(t)}if(e.length){b.queue(G())}}function L(){switch(true){case"#"===k:r=E;break;case"."===k:r=p;break;case":"===k:r=h;break;case"["===k:r=o;break;case"!"===k:P();break;case"*"===k:z();break;case","===k:D();break;case/[>\+~]/.test(k):r=c;break;case/\s/.test(k):r=s;break;case/[\w\d\-_]/.test(k):r=g;--x;break}}function P(){r=v;e=["!"];b.queue(G());r=f}function z(){r=y;e=["*"];b.queue(G());r=f}function D(){r=d;e=[","];b.queue(G());r=f}function O(){if(/[>\+~]/.test(k)){return e.push(k)}if(/\s/.test(k)){return}b.queue(G());r=f;--x}function F(){if(/\s/.test(k)){return}if(/[>\+~]/.test(k)){return--x,r=c}b.queue(G());r=f;--x}function U(){M=r;j(true);if(r!==f){return}if(k==="("){H=e.join("");r=n;e.length=0;R=1;++x;return}r=h;b.queue(G());r=f}function B(){if(e.length===0&&!w){w=/['"]/.test(k)?k:null;if(w){return}}if(w){if(!t&&k===w){w=null;return}if(k==="\\"){t?e.push(k):t=true;return}t=false;e.push(k);return}e.push(k);if(k==="("){++R}else if(k===")"){--R}if(!R){e.pop();b.queue({type:M,data:H+"("+e.join("")+")"});r=f;H=M=S=null;e.length=0}return}function V(){j(true);if(r!==f){return}if(k==="]"){r=m;b.queue(G());r=f;return}H=e.join("");e.length=0;r=a}function N(){if(/[=~|$^*]/.test(k)){e.push(k)}if(e.length===2||k==="="){S=e.join("");e.length=0;r=u;w=null;return}}function I(){if(!e.length&&!w){w=/['"]/.test(k)?k:null;if(w){return}}if(w){if(!t&&k===w){w=null;return}if(k==="\\"){if(t){e.push(k)}t=!t;return}t=false;e.push(k);return}j(true);if(r!==f){return}b.queue({type:m,data:{lhs:H,rhs:e.join(""),cmp:S}});r=f;H=M=S=null;e.length=0;return}function j(i){if(/[^\d\w\-_]/.test(k)&&!t){if(k==="\\"){t=true}else{!i&&b.queue(G());r=f;--x}return}t=false;e.push(k)}function G(){var t=e.join("");e.length=0;return{type:r,data:t}}}},{through:18}],7:[function(t,e,r){function i(){this._events=this._events||{};this._maxListeners=this._maxListeners||undefined}e.exports=i;i.EventEmitter=i;i.prototype._events=undefined;i.prototype._maxListeners=undefined;i.defaultMaxListeners=10;i.prototype.setMaxListeners=function(t){if(!o(t)||t<0||isNaN(t))throw TypeError("n must be a positive number");this._maxListeners=t;return this};i.prototype.emit=function(t){var e,r,i,o,u,l;if(!this._events)this._events={};if(t==="error"){if(!this._events.error||s(this._events.error)&&!this._events.error.length){e=arguments[1];if(e instanceof Error){throw e}throw TypeError('Uncaught, unspecified "error" event.')}}r=this._events[t];if(a(r))return false;if(n(r)){switch(arguments.length){case 1:r.call(this);break;case 2:r.call(this,arguments[1]);break;case 3:r.call(this,arguments[1],arguments[2]);break;default:i=arguments.length;o=new Array(i-1);for(u=1;u<i;u++)o[u-1]=arguments[u];r.apply(this,o)}}else if(s(r)){i=arguments.length;o=new Array(i-1);for(u=1;u<i;u++)o[u-1]=arguments[u];l=r.slice();i=l.length;for(u=0;u<i;u++)l[u].apply(this,o)}return true};i.prototype.addListener=function(t,e){var r;if(!n(e))throw TypeError("listener must be a function");if(!this._events)this._events={};if(this._events.newListener)this.emit("newListener",t,n(e.listener)?e.listener:e);if(!this._events[t])this._events[t]=e;else if(s(this._events[t]))this._events[t].push(e);else this._events[t]=[this._events[t],e];if(s(this._events[t])&&!this._events[t].warned){var r;if(!a(this._maxListeners)){r=this._maxListeners}else{r=i.defaultMaxListeners}if(r&&r>0&&this._events[t].length>r){this._events[t].warned=true;console.error("(node) warning: possible EventEmitter memory "+"leak detected. %d listeners added. "+"Use emitter.setMaxListeners() to increase limit.",this._events[t].length);if(typeof console.trace==="function"){console.trace()}}}return this};i.prototype.on=i.prototype.addListener;i.prototype.once=function(t,e){if(!n(e))throw TypeError("listener must be a function");var r=false;function i(){this.removeListener(t,i);if(!r){r=true;e.apply(this,arguments)}}i.listener=e;this.on(t,i);return this};i.prototype.removeListener=function(t,e){var r,i,o,a;if(!n(e))throw TypeError("listener must be a function");if(!this._events||!this._events[t])return this;r=this._events[t];o=r.length;i=-1;if(r===e||n(r.listener)&&r.listener===e){delete this._events[t];if(this._events.removeListener)this.emit("removeListener",t,e)}else if(s(r)){for(a=o;a-- >0;){if(r[a]===e||r[a].listener&&r[a].listener===e){i=a;break}}if(i<0)return this;if(r.length===1){r.length=0;delete this._events[t]}else{r.splice(i,1)}if(this._events.removeListener)this.emit("removeListener",t,e)}return this};i.prototype.removeAllListeners=function(t){var e,r;if(!this._events)return this;if(!this._events.removeListener){if(arguments.length===0)this._events={};else if(this._events[t])delete this._events[t];return this}if(arguments.length===0){for(e in this._events){if(e==="removeListener")continue;this.removeAllListeners(e)}this.removeAllListeners("removeListener");this._events={};return this}r=this._events[t];if(n(r)){this.removeListener(t,r)}else{while(r.length)this.removeListener(t,r[r.length-1])}delete this._events[t];return this};i.prototype.listeners=function(t){var e;if(!this._events||!this._events[t])e=[];else if(n(this._events[t]))e=[this._events[t]];else e=this._events[t].slice();return e};i.listenerCount=function(t,e){var r;if(!t._events||!t._events[e])r=0;else if(n(t._events[e]))r=1;else r=t._events[e].length;return r};function n(t){return typeof t==="function"}function o(t){return typeof t==="number"}function s(t){return typeof t==="object"&&t!==null}function a(t){return t===void 0}},{}],8:[function(t,e,r){r.read=function(t,e,r,i,n){var o,s;var a=n*8-i-1;var u=(1<<a)-1;var l=u>>1;var h=-7;var f=r?n-1:0;var c=r?-1:1;var p=t[e+f];f+=c;o=p&(1<<-h)-1;p>>=-h;h+=a;for(;h>0;o=o*256+t[e+f],f+=c,h-=8){}s=o&(1<<-h)-1;o>>=-h;h+=i;for(;h>0;s=s*256+t[e+f],f+=c,h-=8){}if(o===0){o=1-l}else if(o===u){return s?NaN:(p?-1:1)*Infinity}else{s=s+Math.pow(2,i);o=o-l}return(p?-1:1)*s*Math.pow(2,o-i)};r.write=function(t,e,r,i,n,o){var s,a,u;var l=o*8-n-1;var h=(1<<l)-1;var f=h>>1;var c=n===23?Math.pow(2,-24)-Math.pow(2,-77):0;var p=i?0:o-1;var d=i?1:-1;var m=e<0||e===0&&1/e<0?1:0;e=Math.abs(e);if(isNaN(e)||e===Infinity){a=isNaN(e)?1:0;s=h}else{s=Math.floor(Math.log(e)/Math.LN2);if(e*(u=Math.pow(2,-s))<1){s--;u*=2}if(s+f>=1){e+=c/u}else{e+=c*Math.pow(2,1-f)}if(e*u>=2){s++;u/=2}if(s+f>=h){a=0;s=h}else if(s+f>=1){a=(e*u-1)*Math.pow(2,n);s=s+f}else{a=e*Math.pow(2,f-1)*Math.pow(2,n);s=0}}for(;n>=8;t[r+p]=a&255,p+=d,a/=256,n-=8){}s=s<<n|a;l+=n;for(;l>0;t[r+p]=s&255,p+=d,s/=256,l-=8){}t[r+p-d]|=m*128}},{}],9:[function(t,e,r){if(typeof Object.create==="function"){e.exports=function t(e,r){if(r){e.super_=r;e.prototype=Object.create(r.prototype,{constructor:{value:e,enumerable:false,writable:true,configurable:true}})}}}else{e.exports=function t(e,r){if(r){e.super_=r;var i=function(){};i.prototype=r.prototype;e.prototype=new i;e.prototype.constructor=e}}}},{}],10:[function(t,e,r){var i=e.exports={};i.nextTick=function(){var t=typeof window!=="undefined"&&window.setImmediate;var e=typeof window!=="undefined"&&window.postMessage&&window.addEventListener;if(t){return function(t){return window.setImmediate(t)}}if(e){var r=[];window.addEventListener("message",function(t){var e=t.source;if((e===window||e===null)&&t.data==="process-tick"){t.stopPropagation();if(r.length>0){var i=r.shift();i()}}},true);return function t(e){r.push(e);window.postMessage("process-tick","*")}}return function t(e){setTimeout(e,0)}}();i.title="browser";i.browser=true;i.env={};i.argv=[];function n(){}i.on=n;i.addListener=n;i.once=n;i.off=n;i.removeListener=n;i.removeAllListeners=n;i.emit=n;i.binding=function(t){throw new Error("process.binding is not supported")};i.cwd=function(){return"/"};i.chdir=function(t){throw new Error("process.chdir is not supported")}},{}],11:[function(t,e,r){e.exports=a;var i=t("inherits");var n=t("process/browser.js").nextTick;var o=t("./readable.js");var s=t("./writable.js");i(a,o);a.prototype.write=s.prototype.write;a.prototype.end=s.prototype.end;a.prototype._write=s.prototype._write;function a(t){if(!(this instanceof a))return new a(t);o.call(this,t);s.call(this,t);if(t&&t.readable===false)this.readable=false;if(t&&t.writable===false)this.writable=false;this.allowHalfOpen=true;if(t&&t.allowHalfOpen===false)this.allowHalfOpen=false;this.once("end",u)}function u(){if(this.allowHalfOpen||this._writableState.ended)return;var t=this;n(function(){t.end()})}},{"./readable.js":15,"./writable.js":17,inherits:9,"process/browser.js":13}],12:[function(t,e,r){e.exports=o;var i=t("events").EventEmitter;var n=t("inherits");n(o,i);o.Readable=t("./readable.js");o.Writable=t("./writable.js");o.Duplex=t("./duplex.js");o.Transform=t("./transform.js");o.PassThrough=t("./passthrough.js");o.Stream=o;function o(){i.call(this)}o.prototype.pipe=function(t,e){var r=this;function n(e){if(t.writable){if(false===t.write(e)&&r.pause){r.pause()}}}r.on("data",n);function o(){if(r.readable&&r.resume){r.resume()}}t.on("drain",o);if(!t._isStdio&&(!e||e.end!==false)){r.on("end",a);r.on("close",u)}var s=false;function a(){if(s)return;s=true;t.end()}function u(){if(s)return;s=true;if(typeof t.destroy==="function")t.destroy()}function l(t){h();if(i.listenerCount(this,"error")===0){throw t}}r.on("error",l);t.on("error",l);function h(){r.removeListener("data",n);t.removeListener("drain",o);r.removeListener("end",a);r.removeListener("close",u);r.removeListener("error",l);t.removeListener("error",l);r.removeListener("end",h);r.removeListener("close",h);t.removeListener("close",h)}r.on("end",h);r.on("close",h);t.on("close",h);t.emit("pipe",r);return t}},{"./duplex.js":11,"./passthrough.js":14,"./readable.js":15,"./transform.js":16,"./writable.js":17,events:7,inherits:9}],13:[function(t,e,r){var i=e.exports={};i.nextTick=function(){var t=typeof window!=="undefined"&&window.setImmediate;var e=typeof window!=="undefined"&&window.postMessage&&window.addEventListener;if(t){return function(t){return window.setImmediate(t)}}if(e){var r=[];window.addEventListener("message",function(t){var e=t.source;if((e===window||e===null)&&t.data==="process-tick"){t.stopPropagation();if(r.length>0){var i=r.shift();i()}}},true);return function t(e){r.push(e);window.postMessage("process-tick","*")}}return function t(e){setTimeout(e,0)}}();i.title="browser";i.browser=true;i.env={};i.argv=[];i.binding=function(t){throw new Error("process.binding is not supported")};i.cwd=function(){return"/"};i.chdir=function(t){throw new Error("process.chdir is not supported")}},{}],14:[function(t,e,r){e.exports=o;var i=t("./transform.js");var n=t("inherits");n(o,i);function o(t){if(!(this instanceof o))return new o(t);i.call(this,t)}o.prototype._transform=function(t,e,r){r(null,t)}},{"./transform.js":16,inherits:9}],15:[function(t,e,r){(function(r){e.exports=h;h.ReadableState=l;var i=t("events").EventEmitter;var n=t("./index.js");var o=t("buffer").Buffer;var s=t("process/browser.js").nextTick;var a;var u=t("inherits");u(h,n);function l(e,r){e=e||{};var i=e.highWaterMark;this.highWaterMark=i||i===0?i:16*1024;this.highWaterMark=~~this.highWaterMark;this.buffer=[];this.length=0;this.pipes=null;this.pipesCount=0;this.flowing=false;this.ended=false;this.endEmitted=false;this.reading=false;this.calledRead=false;this.sync=true;this.needReadable=false;this.emittedReadable=false;this.readableListening=false;this.objectMode=!!e.objectMode;this.defaultEncoding=e.defaultEncoding||"utf8";this.ranOut=false;this.awaitDrain=0;this.readingMore=false;this.decoder=null;this.encoding=null;if(e.encoding){if(!a)a=t("string_decoder").StringDecoder;this.decoder=new a(e.encoding);this.encoding=e.encoding}}function h(t){if(!(this instanceof h))return new h(t);this._readableState=new l(t,this);this.readable=true;n.call(this)}h.prototype.push=function(t,e){var r=this._readableState;if(typeof t==="string"&&!r.objectMode){e=e||r.defaultEncoding;if(e!==r.encoding){t=new o(t,e);e=""}}return f(this,r,t,e,false)};h.prototype.unshift=function(t){var e=this._readableState;return f(this,e,t,"",true)};function f(t,e,r,i,n){var o=v(e,r);if(o){t.emit("error",o)}else if(r===null||r===undefined){e.reading=false;if(!e.ended)g(t,e)}else if(e.objectMode||r&&r.length>0){if(e.ended&&!n){var s=new Error("stream.push() after EOF");t.emit("error",s)}else if(e.endEmitted&&n){var s=new Error("stream.unshift() after end event");t.emit("error",s)}else{if(e.decoder&&!n&&!i)r=e.decoder.write(r);e.length+=e.objectMode?1:r.length;if(n){e.buffer.unshift(r)}else{e.reading=false;e.buffer.push(r)}if(e.needReadable)y(t);_(t,e)}}else if(!n){e.reading=false}return c(e)}function c(t){return!t.ended&&(t.needReadable||t.length<t.highWaterMark||t.length===0)}h.prototype.setEncoding=function(e){if(!a)a=t("string_decoder").StringDecoder;this._readableState.decoder=new a(e);this._readableState.encoding=e};var p=8388608;function d(t){if(t>=p){t=p}else{t--;for(var e=1;e<32;e<<=1)t|=t>>e;t++}return t}function m(t,e){if(e.length===0&&e.ended)return 0;if(e.objectMode)return t===0?0:1;if(isNaN(t)||t===null){if(e.flowing&&e.buffer.length)return e.buffer[0].length;else return e.length}if(t<=0)return 0;if(t>e.highWaterMark)e.highWaterMark=d(t);if(t>e.length){if(!e.ended){e.needReadable=true;return 0}else return e.length}return t}h.prototype.read=function(t){var e=this._readableState;e.calledRead=true;var r=t;if(typeof t!=="number"||t>0)e.emittedReadable=false;if(t===0&&e.needReadable&&(e.length>=e.highWaterMark||e.ended)){y(this);return null}t=m(t,e);if(t===0&&e.ended){if(e.length===0)M(this);return null}var i=e.needReadable;if(e.length-t<=e.highWaterMark)i=true;if(e.ended||e.reading)i=false;if(i){e.reading=true;e.sync=true;if(e.length===0)e.needReadable=true;this._read(e.highWaterMark);e.sync=false}if(i&&!e.reading)t=m(r,e);var n;if(t>0)n=H(t,e);else n=null;if(n===null){e.needReadable=true;t=0}e.length-=t;if(e.length===0&&!e.ended)e.needReadable=true;if(e.ended&&!e.endEmitted&&e.length===0)M(this);return n};function v(t,e){var r=null;if(!o.isBuffer(e)&&"string"!==typeof e&&e!==null&&e!==undefined&&!t.objectMode&&!r){r=new TypeError("Invalid non-string/buffer chunk")}return r}function g(t,e){if(e.decoder&&!e.ended){var r=e.decoder.end();if(r&&r.length){e.buffer.push(r);e.length+=e.objectMode?1:r.length}}e.ended=true;if(e.length>0)y(t);else M(t)}function y(t){var e=t._readableState;e.needReadable=false;if(e.emittedReadable)return;e.emittedReadable=true;if(e.sync)s(function(){E(t)});else E(t)}function E(t){t.emit("readable")}function _(t,e){if(!e.readingMore){e.readingMore=true;s(function(){x(t,e)})}}function x(t,e){var r=e.length;while(!e.reading&&!e.flowing&&!e.ended&&e.length<e.highWaterMark){t.read(0);if(r===e.length)break;else r=e.length}e.readingMore=false}h.prototype._read=function(t){this.emit("error",new Error("not implemented"))};h.prototype.pipe=function(t,e){var n=this;var o=this._readableState;switch(o.pipesCount){case 0:o.pipes=t;break;case 1:o.pipes=[o.pipes,t];break;default:o.pipes.push(t);break}o.pipesCount+=1;var a=(!e||e.end!==false)&&t!==r.stdout&&t!==r.stderr;var u=a?h:c;if(o.endEmitted)s(u);else n.once("end",u);t.on("unpipe",l);function l(t){if(t!==n)return;c()}function h(){t.end()}var f=b(n);t.on("drain",f);function c(){t.removeListener("close",m);t.removeListener("finish",v);t.removeListener("drain",f);t.removeListener("error",d);t.removeListener("unpipe",l);n.removeListener("end",h);n.removeListener("end",c);if(!t._writableState||t._writableState.needDrain)f()}var p=i.listenerCount(t,"error");function d(e){g();if(p===0&&i.listenerCount(t,"error")===0)t.emit("error",e)}t.once("error",d);function m(){t.removeListener("finish",v);g()}t.once("close",m);function v(){t.removeListener("close",m);g()}t.once("finish",v);function g(){n.unpipe(t)}t.emit("pipe",n);if(!o.flowing){this.on("readable",w);o.flowing=true;s(function(){T(n)})}return t};function b(t){return function(){var e=this;var r=t._readableState;r.awaitDrain--;if(r.awaitDrain===0)T(t)}}function T(t){var e=t._readableState;var r;e.awaitDrain=0;function n(t,i,n){var o=t.write(r);if(false===o){e.awaitDrain++}}while(e.pipesCount&&null!==(r=t.read())){if(e.pipesCount===1)n(e.pipes,0,null);else S(e.pipes,n);t.emit("data",r);if(e.awaitDrain>0)return}if(e.pipesCount===0){e.flowing=false;if(i.listenerCount(t,"data")>0)R(t);return}e.ranOut=true}function w(){if(this._readableState.ranOut){this._readableState.ranOut=false;T(this)}}h.prototype.unpipe=function(t){var e=this._readableState;if(e.pipesCount===0)return this;if(e.pipesCount===1){if(t&&t!==e.pipes)return this;if(!t)t=e.pipes;e.pipes=null;e.pipesCount=0;this.removeListener("readable",w);e.flowing=false;if(t)t.emit("unpipe",this);return this}if(!t){var r=e.pipes;var i=e.pipesCount;e.pipes=null;e.pipesCount=0;this.removeListener("readable",w);e.flowing=false;for(var n=0;n<i;n++)r[n].emit("unpipe",this);return this}var n=k(e.pipes,t);if(n===-1)return this;e.pipes.splice(n,1);e.pipesCount-=1;if(e.pipesCount===1)e.pipes=e.pipes[0];t.emit("unpipe",this);return this};h.prototype.on=function(t,e){var r=n.prototype.on.call(this,t,e);if(t==="data"&&!this._readableState.flowing)R(this);if(t==="readable"&&this.readable){var i=this._readableState;if(!i.readableListening){i.readableListening=true;i.emittedReadable=false;i.needReadable=true;if(!i.reading){this.read(0)}else if(i.length){y(this,i)}}}return r};h.prototype.addListener=h.prototype.on;h.prototype.resume=function(){R(this);this.read(0);this.emit("resume")};h.prototype.pause=function(){R(this,true);this.emit("pause")};function R(t,e){var r=t._readableState;if(r.flowing){throw new Error("Cannot switch to old mode now.")}var i=e||false;var o=false;t.readable=true;t.pipe=n.prototype.pipe;t.on=t.addListener=n.prototype.on;t.on("readable",function(){o=true;var e;while(!i&&null!==(e=t.read()))t.emit("data",e);if(e===null){o=false;t._readableState.needReadable=true}});t.pause=function(){i=true;this.emit("pause")};t.resume=function(){i=false;if(o)s(function(){t.emit("readable")});else this.read(0);this.emit("resume")};t.emit("readable")}h.prototype.wrap=function(t){var e=this._readableState;var r=false;var i=this;t.on("end",function(){if(e.decoder&&!e.ended){var t=e.decoder.end();if(t&&t.length)i.push(t)}i.push(null)});t.on("data",function(n){if(e.decoder)n=e.decoder.write(n);if(!n||!e.objectMode&&!n.length)return;var o=i.push(n);if(!o){r=true;t.pause()}});for(var n in t){if(typeof t[n]==="function"&&typeof this[n]==="undefined"){this[n]=function(e){return function(){return t[e].apply(t,arguments)}}(n)}}var o=["error","close","destroy","pause","resume"];S(o,function(e){t.on(e,function(t){return i.emit.apply(i,e,t)})});i._read=function(e){if(r){r=false;t.resume()}};return i};h._fromList=H;function H(t,e){var r=e.buffer;var i=e.length;var n=!!e.decoder;var s=!!e.objectMode;var a;if(r.length===0)return null;if(i===0)a=null;else if(s)a=r.shift();else if(!t||t>=i){if(n)a=r.join("");else a=o.concat(r,i);r.length=0}else{if(t<r[0].length){var u=r[0];a=u.slice(0,t);r[0]=u.slice(t)}else if(t===r[0].length){a=r.shift()}else{if(n)a="";else a=new o(t);var l=0;for(var h=0,f=r.length;h<f&&l<t;h++){var u=r[0];var c=Math.min(t-l,u.length);if(n)a+=u.slice(0,c);else u.copy(a,l,0,c);if(c<u.length)r[0]=u.slice(c);else r.shift();l+=c}}}return a}function M(t){var e=t._readableState;if(e.length>0)throw new Error("endReadable called on non-empty stream");if(!e.endEmitted&&e.calledRead){e.ended=true;s(function(){if(!e.endEmitted&&e.length===0){e.endEmitted=true;t.readable=false;t.emit("end")}})}}function S(t,e){for(var r=0,i=t.length;r<i;r++){e(t[r],r)}}function k(t,e){for(var r=0,i=t.length;r<i;r++){if(t[r]===e)return r}return-1}}).call(this,t("pBGvAp"))},{"./index.js":12,buffer:4,events:7,inherits:9,pBGvAp:10,"process/browser.js":13,string_decoder:3}],16:[function(t,e,r){e.exports=a;var i=t("./duplex.js");var n=t("inherits");n(a,i);function o(t,e){this.afterTransform=function(t,r){return s(e,t,r)};this.needTransform=false;this.transforming=false;this.writecb=null;this.writechunk=null}function s(t,e,r){var i=t._transformState;i.transforming=false;var n=i.writecb;if(!n)return t.emit("error",new Error("no writecb in Transform class"));i.writechunk=null;i.writecb=null;if(r!==null&&r!==undefined)t.push(r);if(n)n(e);var o=t._readableState;o.reading=false;if(o.needReadable||o.length<o.highWaterMark){t._read(o.highWaterMark)}}function a(t){if(!(this instanceof a))return new a(t);i.call(this,t);var e=this._transformState=new o(t,this);var r=this;this._readableState.needReadable=true;this._readableState.sync=false;this.once("finish",function(){if("function"===typeof this._flush)this._flush(function(t){u(r,t)});else u(r)})}a.prototype.push=function(t,e){this._transformState.needTransform=false;return i.prototype.push.call(this,t,e)};a.prototype._transform=function(t,e,r){throw new Error("not implemented")};a.prototype._write=function(t,e,r){var i=this._transformState;i.writecb=r;i.writechunk=t;i.writeencoding=e;if(!i.transforming){var n=this._readableState;if(i.needTransform||n.needReadable||n.length<n.highWaterMark)this._read(n.highWaterMark)}};a.prototype._read=function(t){var e=this._transformState;if(e.writechunk&&e.writecb&&!e.transforming){e.transforming=true;this._transform(e.writechunk,e.writeencoding,e.afterTransform)}else{e.needTransform=true}};function u(t,e){if(e)return t.emit("error",e);var r=t._writableState;var i=t._readableState;var n=t._transformState;if(r.length)throw new Error("calling transform done when ws.length != 0");if(n.transforming)throw new Error("calling transform done when still transforming");return t.push(null)}},{"./duplex.js":11,inherits:9}],17:[function(t,e,r){e.exports=f;f.WritableState=h;var i=typeof Uint8Array!=="undefined"?function(t){return t instanceof Uint8Array}:function(t){return t&&t.constructor&&t.constructor.name==="Uint8Array"};var n=typeof ArrayBuffer!=="undefined"?function(t){return t instanceof ArrayBuffer}:function(t){return t&&t.constructor&&t.constructor.name==="ArrayBuffer"};var o=t("inherits");var s=t("./index.js");var a=t("process/browser.js").nextTick;var u=t("buffer").Buffer;o(f,s);function l(t,e,r){this.chunk=t;this.encoding=e;this.callback=r}function h(t,e){t=t||{};var r=t.highWaterMark;this.highWaterMark=r||r===0?r:16*1024;this.objectMode=!!t.objectMode;this.highWaterMark=~~this.highWaterMark;this.needDrain=false;this.ending=false;this.ended=false;this.finished=false;var i=t.decodeStrings===false;this.decodeStrings=!i;this.defaultEncoding=t.defaultEncoding||"utf8";this.length=0;this.writing=false;this.sync=true;this.bufferProcessing=false;this.onwrite=function(t){E(e,t)};this.writecb=null;this.writelen=0;this.buffer=[]}function f(t){if(!(this instanceof f)&&!(this instanceof s.Duplex))return new f(t);this._writableState=new h(t,this);this.writable=true;s.call(this)}f.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe. Not readable."))};function c(t,e,r){var i=new Error("write after end");t.emit("error",i);a(function(){r(i)})}function p(t,e,r,i){var n=true;if(!u.isBuffer(r)&&"string"!==typeof r&&r!==null&&r!==undefined&&!e.objectMode){var o=new TypeError("Invalid non-string/buffer chunk");t.emit("error",o);a(function(){i(o)});n=false}return n}f.prototype.write=function(t,e,r){var o=this._writableState;var s=false;if(typeof e==="function"){r=e;e=null}if(!u.isBuffer(t)&&i(t))t=new u(t);if(n(t)&&typeof Uint8Array!=="undefined")t=new u(new Uint8Array(t));if(u.isBuffer(t))e="buffer";else if(!e)e=o.defaultEncoding;if(typeof r!=="function")r=function(){};if(o.ended)c(this,o,r);else if(p(this,o,t,r))s=m(this,o,t,e,r);return s};function d(t,e,r){if(!t.objectMode&&t.decodeStrings!==false&&typeof e==="string"){e=new u(e,r)}return e}function m(t,e,r,i,n){r=d(e,r,i);var o=e.objectMode?1:r.length;e.length+=o;var s=e.length<e.highWaterMark;e.needDrain=!s;if(e.writing)e.buffer.push(new l(r,i,n));else v(t,e,o,r,i,n);return s}function v(t,e,r,i,n,o){e.writelen=r;e.writecb=o;e.writing=true;e.sync=true;t._write(i,n,e.onwrite);e.sync=false}function g(t,e,r,i,n){if(r)a(function(){n(i)});else n(i);t.emit("error",i)}function y(t){t.writing=false;t.writecb=null;t.length-=t.writelen;t.writelen=0}function E(t,e){var r=t._writableState;var i=r.sync;var n=r.writecb;y(r);if(e)g(t,r,i,e,n);else{var o=T(t,r);if(!o&&!r.bufferProcessing&&r.buffer.length)b(t,r);if(i){a(function(){_(t,r,o,n)})}else{_(t,r,o,n)}}}function _(t,e,r,i){if(!r)x(t,e);i();if(r)w(t,e)}function x(t,e){if(e.length===0&&e.needDrain){e.needDrain=false;t.emit("drain")}}function b(t,e){e.bufferProcessing=true;for(var r=0;r<e.buffer.length;r++){var i=e.buffer[r];var n=i.chunk;var o=i.encoding;var s=i.callback;var a=e.objectMode?1:n.length;v(t,e,a,n,o,s);if(e.writing){r++;break}}e.bufferProcessing=false;if(r<e.buffer.length)e.buffer=e.buffer.slice(r);else e.buffer.length=0}f.prototype._write=function(t,e,r){r(new Error("not implemented"))};f.prototype.end=function(t,e,r){var i=this._writableState;if(typeof t==="function"){r=t;t=null;e=null}else if(typeof e==="function"){r=e;e=null}if(typeof t!=="undefined"&&t!==null)this.write(t,e);if(!i.ending&&!i.finished)R(this,i,r)};function T(t,e){return e.ending&&e.length===0&&!e.finished&&!e.writing}function w(t,e){var r=T(t,e);if(r){e.finished=true;t.emit("finish")}return r}function R(t,e,r){e.ending=true;w(t,e);if(r){if(e.finished)a(r);else t.once("finish",r)}e.ended=true}},{"./index.js":12,buffer:4,inherits:9,"process/browser.js":13}],18:[function(t,e,r){(function(i){var n=t("stream");r=e.exports=o;o.through=o;function o(t,e,r){t=t||function(t){this.queue(t)};e=e||function(){this.queue(null)};var o=false,s=false,a=[],u=false;var l=new n;l.readable=l.writable=true;l.paused=false;l.autoDestroy=!(r&&r.autoDestroy===false);l.write=function(e){t.call(this,e);return!l.paused};function h(){while(a.length&&!l.paused){var t=a.shift();if(null===t)return l.emit("end");else l.emit("data",t)}}l.queue=l.push=function(t){if(u)return l;if(t===null)u=true;a.push(t);h();return l};l.on("end",function(){l.readable=false;if(!l.writable&&l.autoDestroy)i.nextTick(function(){l.destroy()})});function f(){l.writable=false;e.call(l);if(!l.readable&&l.autoDestroy)l.destroy()}l.end=function(t){if(o)return;o=true;if(arguments.length)l.write(t);f();return l};l.destroy=function(){if(s)return;s=true;o=true;a.length=0;l.writable=l.readable=false;l.emit("close");return l};l.pause=function(){if(l.paused)return;l.paused=true;return l};l.resume=function(){if(l.paused){l.paused=false;l.emit("resume")}h();if(!l.paused)l.emit("drain");return l};return l}}).call(this,t("pBGvAp"))},{pBGvAp:10,stream:12}],19:[function(t,e,r){var i,n,o,s,a,u,l,h;n=t("./model");o=t("./overlay");s=t("./primitives");a=t("./render");u=t("./shaders");l=t("./stage");h=t("./util");i=function(){t.Namespace={Model:n,Overlay:o,Primitives:s,Render:a,Shaders:u,Stage:l,Util:h,DOM:h.VDOM};function t(t,e,r){var i;if(e==null){e=null}if(r==null){r=null}this.canvas=i=t.domElement;this.element=null;this.shaders=new u.Factory(u.Snippets);this.renderables=new a.Factory(a.Classes,t,this.shaders);this.overlays=new o.Factory(o.Classes,i);this.scene=this.renderables.make("scene",{scene:e});this.camera=this.defaultCamera=r!=null?r:new THREE.PerspectiveCamera;this.attributes=new n.Attributes(s.Types,this);this.primitives=new s.Factory(s.Types,this);this.root=this.primitives.make("root");this.model=new n.Model(this.root);this.guard=new n.Guard;this.controller=new l.Controller(this.model,this.primitives);this.animator=new l.Animator(this);this.api=new l.API(this);this.speed=1;this.time={now:+new Date/1e3,time:0,delta:0,clock:0,step:0}}t.prototype.init=function(){this.scene.inject();this.overlays.inject();return this};t.prototype.destroy=function(){this.scene.unject();this.overlays.unject();return this};t.prototype.resize=function(t){if(t==null){t={}}if(t.renderWidth==null){t.renderWidth=t.viewWidth!=null?t.viewWidth:t.viewWidth=1280}if(t.renderHeight==null){t.renderHeight=t.viewHeight!=null?t.viewHeight:t.viewHeight=720}if(t.pixelRatio==null){t.pixelRatio=t.renderWidth/Math.max(1e-6,t.viewWidth)}if(t.aspect==null){t.aspect=t.viewWidth/Math.max(1e-6,t.viewHeight)}this.root.controller.resize(t);return this};t.prototype.frame=function(t){this.pre(t);this.update();this.render();this.post();return this};t.prototype.pre=function(t){var e;if(!t){t={now:+new Date/1e3,time:0,delta:0,clock:0,step:0};t.delta=this.time.now!=null?t.now-this.time.now:0;if(t.delta>1){t.delta=1/60}t.step=t.delta*this.speed;t.time=this.time.time+t.delta;t.clock=this.time.clock+t.step}this.time=t;if(typeof(e=this.root.controller).pre==="function"){e.pre()}return this};t.prototype.update=function(){var t;this.animator.update();this.attributes.compute();this.guard.iterate({step:function(t){return function(){var e;e=t.attributes.digest();return e||(e=t.model.digest())}}(this),last:function(){return{attribute:this.attributes.getLastTrigger(),model:this.model.getLastTrigger()}}});if(typeof(t=this.root.controller).update==="function"){t.update()}this.camera=this.root.controller.getCamera();this.speed=this.root.controller.getSpeed();return this};t.prototype.render=function(){var t;if(typeof(t=this.root.controller).render==="function"){t.render()}this.scene.render();return this};t.prototype.post=function(){var t;if(typeof(t=this.root.controller).post==="function"){t.post()}return this};t.prototype.setWarmup=function(t){this.scene.warmup(t);return this};t.prototype.getPending=function(){return this.scene.pending.length};return t}();e.exports=i},{"./model":24,"./overlay":30,"./primitives":33,"./render":140,"./shaders":155,"./stage":160,"./util":166}],20:[function(t,e,r){var i,n,o,s,a;o=function(t){var e,r;r=THREE.Bootstrap(t);if(!r.fallback){if(!r.Time){r.install("time")}if(!r.MathBox){r.install(["mathbox","splash"])}}return(e=r.mathbox)!=null?e:r};window.π=Math.PI;window.τ=π*2;window.e=Math.E;window.MathBox=r;window.mathBox=r.mathBox=o;r.version="0.0.5";r.Context=i=t("./context");s=i.Namespace;for(n in s){a=s[n];r[n]=a}t("./splash");THREE.Bootstrap.registerPlugin("mathbox",{defaults:{init:true,warmup:2,inspect:true,splash:true},listen:["ready","pre","update","post","resize"],install:function(t){var e;e=false;this.first=true;return t.MathBox={init:function(r){return function(n){var o,s;if(e){return}e=true;s=(n!=null?n.scene:void 0)||r.options.scene||t.scene;o=(n!=null?n.camera:void 0)||r.options.camera||t.camera;r.context=new i(t.renderer,s,o);r.context.api.three=t.three=t;r.context.api.mathbox=t.mathbox=r.context.api;r.context.api.start=function(){return t.Loop.start()};r.context.api.stop=function(){return t.Loop.stop()};r.context.init();r.context.resize(t.Size);r.context.setWarmup(r.options.warmup);r.pending=0;r.warm=!r.options.warmup;console.log("MathBox²",MathBox.version);return t.trigger({type:"mathbox/init",version:MathBox.version,context:r.context})}}(this),destroy:function(r){return function(){if(!e){return}e=false;t.trigger({type:"mathbox/destroy",context:r.context});r.context.destroy();delete t.mathbox;delete r.context.api.three;return delete r.context}}(this),object:function(t){return function(){var e;return(e=t.context)!=null?e.scene.root:void 0}}(this)}},uninstall:function(t){t.MathBox.destroy();return delete t.MathBox},ready:function(t,e){if(this.options.init){e.MathBox.init();return setTimeout(function(t){return function(){if(t.options.inspect){return t.inspect(e)}}}(this))}},inspect:function(t){this.context.api.inspect();if(!this.options.warmup){return this.info(t)}},info:function(t){var e,r;e=function(t){var e;e=[];while(t>=1e3){e.unshift(("000"+t%1e3).slice(-3));t=Math.floor(t/1e3)}e.unshift(t);return e.join(",")};r=t.renderer.info.render;return console.log("Geometry  ",e(r.faces)+" faces  ",e(r.vertices)+" vertices  ",e(r.calls)+" draw calls  ")},resize:function(t,e){var r;return(r=this.context)!=null?r.resize(e.Size):void 0},pre:function(t,e){var r;return(r=this.context)!=null?r.pre(e.Time):void 0},update:function(t,e){var r,i,n,o;if((i=this.context)!=null){i.update()}if((r=(n=this.context)!=null?n.camera:void 0)&&r!==e.camera){e.camera=r}e.Time.set({speed:this.context.speed});this.progress(this.context.getPending(),e);return(o=this.context)!=null?o.render():void 0},post:function(t,e){var r;return(r=this.context)!=null?r.post():void 0},progress:function(t,e){var r,i,n;if(!(t||this.pending)){return}i=Math.max(t+this.options.warmup,this.pending);r=i-t;n=i;e.trigger({type:"mathbox/progress",current:i-t,total:i});if(t===0){i=0}this.pending=i;if(r===n&&!this.warm){this.warm=true;if(this.options.inspect){return this.info(e)}}}})},{"./context":19,"./splash":156}],21:[function(t,e,r){var i,n,o;i=function(){function t(t,e){this.context=e;this.traits=t.Traits;this.types=t.Types;this.pending=[];this.bound=[];this.last=null}t.prototype.make=function(t){return{enum:typeof t["enum"]==="function"?t["enum"]():void 0,type:typeof t.uniform==="function"?t.uniform():void 0,value:t.make()}};t.prototype.apply=function(t,e){return new n(t,e,this)};t.prototype.bind=function(t){return this.bound.push(t)};t.prototype.unbind=function(t){var e;return this.bound=function(){var r,i,n,o;n=this.bound;o=[];for(r=0,i=n.length;r<i;r++){e=n[r];if(e!==t){o.push(e)}}return o}.call(this)};t.prototype.queue=function(t,e,r,i){this.lastObject=e;this.lastKey=r;this.lastValue=i;return this.pending.push(t)};t.prototype.invoke=function(t){return t(this.context.time.clock,this.context.time.step)};t.prototype.compute=function(){var t,e,r,i;if(this.bound.length){i=this.bound;for(e=0,r=i.length;e<r;e++){t=i[e];this.invoke(t)}}};t.prototype.digest=function(){var t,e,r,i,n;if(!this.pending.length){return false}n=[this.pending,[]],e=n[0],this.pending=n[1];for(r=0,i=e.length;r<i;r++){t=e[r];t()}return true};t.prototype.getTrait=function(t){return this.traits[t]};t.prototype.getLastTrigger=function(){return this.lastObject.toString()+" - "+this.lastKey+"=`"+this.lastValue+"`"};return t}();o=function(t){var e,r,i;r={};for(e in t){i=t[e];r[e]=i}return r};n=function(){function t(t,e,r){var i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,N,I,j,G,W,X,q,Y,Z,K,Q,J,$,tt,et,rt,it,nt;J=e.traits,I=e.props,w=e.finals,H=e.freeform;m=this;if(t.props!=null&&t.expr!=null&&t.orig!=null&&t.computed!=null&&t.attributes!=null){V=o(t.props);U=o(t.expr);B=t.orig();F=t.computed();if((j=t.attributes)!=null){j.dispose()}}R={};N={};z={};Y=function(t){var e;return(e=z[t])!=null?e:t};v=function(e,r){if(z[r]){throw new Error(t.toString()+" - Duplicate property `"+r+"`")}return z[r]=e};M=function(t){var e,r,i;return(e=(r=m[t])!=null?r.value:void 0)!=null?e:(i=m[Y(t)])!=null?i.value:void 0};W=function(e,r,i,o){var s,l,h,c,p;e=Y(e);if((s=m[e])==null){if(!H){throw new Error(t.toString()+" - Setting unknown property `"+e+"={"+r+"}`")}s=m[e]={short:e,type:null,last:null,value:null};rt[e]=function(t){return t}}if(!i){if(a[e]){throw new Error(t.toString()+" - Can't set bound property `"+e+"={"+r+"}`")}if(n[e]){throw new Error(t.toString()+" - Can't set computed property `"+e+"={"+r+"}`")}if(u[e]){throw new Error(t.toString()+" - Can't set final property `"+e+"={"+r+"}`")}}c=true;p=et(e,r,s.last,function(){c=false;return null});if(c){l=[p,s.value],s.value=l[0],s.last=l[1];h=s.short;R[h]=p;if(!i){N[h]=r}if(!(o||_(e,s.value,s.last))){f(e,r)}}return c};d=function(t,e,r){t=Y(t);W(t,e,true,r);return u[t]=true};T={};i={};s={};a={};n={};u={};h=function(e,o,l){var h,f;if(l==null){l=false}e=Y(e);if(typeof o!=="function"){throw new Error(t.toString()+" - Expression `"+e+"=>{"+T+"}` is not a function")}if(a[e]){throw new Error(t.toString()+" - Property `"+e+"=>{"+T+"}` is already bound")}if(n[e]){throw new Error(t.toString()+" - Property `"+e+"` is computed")}if(u[e]){throw new Error(t.toString()+" - Property `"+e+"` is final")}h=l?n:a;h[e]=o;f=m[e]!=null?m[e].short:e;if(!l){T[f]=o}s[e]=o;o=o.bind(t);i[e]=function(r,i){var n,s;if(n=(s=t.clock)!=null?s.getTime():void 0){r=n.clock;i=n.step}return t.set(e,o(r,i),true)};return r.bind(i[e])};$=function(t,e){var o;if(e==null){e=false}t=Y(t);o=e?n:a;if(!o[t]){return}r.unbind(i[t]);delete i[t];delete o[t];if(m[t]!=null){t=m[t].short}return delete T[t]};x=function(t,e){var r;t=Y(t);return(r=typeof s[t]==="function"?s[t](e,0):void 0)!=null?r:m[t].value};t.expr=T;t.props=R;t.evaluate=function(t,e){var r;if(t!=null){return x(t,e)}else{r={};for(t in I){r[t]=x(t,e)}return r}};t.get=function(t){if(t!=null){return M(t)}else{return R}};t.set=function(t,e,r,i){var n;if(typeof t==="string"){W(t,e,r,i)}else{i=r;r=e;n=t;for(t in n){e=n[t];W(t,e,r,i)}}};t.bind=function(t,e,r){var i;if(typeof t==="string"){h(t,e,r)}else{r=e;i=t;for(t in i){e=i[t];h(t,e,r)}}};t.unbind=function(t,e){var r;if(typeof t==="string"){$(t,e)}else{e=T;r=t;for(t in r){$(t,e)}}};t.attribute=function(t){if(t!=null){return m[Y(t)]}else{return m}};t.orig=function(t){if(t!=null){return N[Y(t)]}else{return o(N)}};t.computed=function(t){if(t!=null){return n[Y(t)]}else{return o(n)}};P={};rt={};E={};_=function(t,e,r){return E[t](e,r)};et=function(t,e,r,i){return rt[t](e,r,i)};t.validate=function(e,r){var i,n;e=Y(e);i=P[e];if(i!=null){n=i()}return n=et(e,r,n,function(){throw new Error(t.toString()+" - Invalid value `"+e+"={"+r+"}`")})};y=false;p={};K={};c={};Z={};S=function(t){return t.split(".")[0]};f=function(e,i){var n;if(!y){y=true;r.queue(g,t,e,i)}n=S(e);p[e]=true;return K[n]=true};b={type:"change",changed:null,touched:null};g=function(){var e,r,i;b.changed=p;b.touched=K;p=c;K=Z;c=b.changed;Z=b.touched;y=false;for(e in p){p[e]=false}for(e in K){K[e]=false}b.type="change";t.trigger(b);r=[];for(i in b.touched){b.type="change:"+i;r.push(t.trigger(b))}return r};X=function(t){var e,r;e=t.split(/\./g);r=e.pop();e.pop();e.unshift(r);return e.reduce(function(t,e){return t+e.charAt(0).toUpperCase()+e.substring(1)})};l=function(t,e){var r,i,n,o,s,a,u,l;s=[];for(i in e){u=e[i];i=[t,i].join(".");a=X(i);m[i]=r={T:u,ns:t,short:a,enum:typeof u["enum"]==="function"?u["enum"]():void 0,type:typeof u.uniform==="function"?u.uniform():void 0,last:u.make(),value:l=u.make()};v(i,a);R[a]=l;P[i]=u.make;rt[i]=(n=u.validate)!=null?n:function(t){return t};s.push(E[i]=(o=u.equals)!=null?o:function(t,e){return t===e})}return s};L=[];nt={};for(k=0,C=J.length;k<C;k++){Q=J[k];G=Q.split(":"),Q=G[0],O=G[1];D=O?[O,Q].join("."):Q;q=r.getTrait(Q);L.push(Q);if(q!=null){l(D,q)}}if(I!=null){for(O in I){q=I[O];l(O,q)}}tt=L.filter(function(t,e){return L.indexOf(t)===e});t.traits=tt;if(V!=null){t.set(V,true,true)}if(w!=null){for(A in w){it=w[A];d(A,it,true)}}if(B!=null){t.set(B,false,true)}if(F!=null){t.bind(F,true)}if(U!=null){t.bind(U,false)}this.dispose=function(){for(A in n){$(A,true)}for(A in a){$(A,false)}I={};delete t.attributes;delete t.get;return delete t.set};null}return t}();e.exports=i},{}],22:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./node");i=function(t){o(e,t);function e(t,r,i,n,o,s){e.__super__.constructor.call(this,t,r,i,n,o,s);this.children=[];this.on("reindex",function(t){return function(e){var r,i,n,o,s;o=t.children;s=[];for(i=0,n=o.length;i<n;i++){r=o[i];s.push(r.trigger(e))}return s}}(this))}e.prototype.add=function(t){var e;if((e=t.parent)!=null){e.remove(t)}t._index(this.children.length,this);this.children.push(t);return t._added(this)};e.prototype.remove=function(t){var e,r,i,n,o,s;if((o=t.children)!=null?o.length:void 0){t.empty()}r=this.children.indexOf(t);if(r===-1){return}this.children.splice(r,1);t._index(null);t._removed(this);s=this.children;for(e=i=0,n=s.length;i<n;e=++i){t=s[e];if(e>=r){t._index(e)}}};e.prototype.empty=function(){var t,e,r,i;t=this.children.slice().reverse();for(e=0,r=t.length;e<r;e++){i=t[e];this.remove(i)}};return e}(n);e.exports=i},{"./node":26}],23:[function(t,e,r){var i;i=function(){function t(t){this.limit=t!=null?t:10}t.prototype.iterate=function(t){var e,r,i,n;n=t.step,e=t.last;r=this.limit;while(i=n()){if(!--r){console.warn("Last iteration",typeof e==="function"?e():void 0);throw new Error("Exceeded iteration limit.")}}return null};return t}();e.exports=i},{}],24:[function(t,e,r){r.Attributes=t("./attributes");r.Group=t("./group");r.Guard=t("./guard");r.Model=t("./model");r.Node=t("./node")},{"./attributes":21,"./group":22,"./guard":23,"./model":25,"./node":26}],25:[function(t,e,r){var i,n,o,s,a,u,l,h,f,c=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};h=t("cssauron");i="*";s=/^#([A-Za-z0-9_])$/;o=/^\.([A-Za-z0-9_]+)$/;u=/^\[([A-Za-z0-9_]+)\]$/;l=/^[A-Za-z0-9_]+$/;n=/^<([0-9]+|<*)$/;f=null;a=function(){function t(t){var e,r,i,n,o,s,a,u,l,c,p,d,m,v,g,y,E,_,x,b,T,w;this.root=t;this.root.model=this;this.root.root=this.root;this.ids={};this.classes={};this.traits={};this.types={};this.nodes=[];this.watchers=[];this.fire=false;this.lastNode=null;this.event={type:"update"};if(f==null){f=h({tag:"type",id:"id",class:"classes.join(' ')",parent:"parent",children:"children",attr:"traits.hash[attr]"})}e=function(t){return function(t){return u(t.node)}}(this);v=function(t){return function(t){return c(t.node)}}(this);this.root.on("add",e);this.root.on("remove",v);u=function(t){return function(t){n(t);a(t);s(t);t.on("change:node",w);w(null,t,true);return p(t)}}(this);c=function(t){return function(t){E(t);b(t);x(t);y(t.id,t);g(t.classes,t);t.off("change:node",w);return p(t)}}(this);m=function(t){return function(e){var r,i,n,o;n=t.watchers;for(r=0,i=n.length;r<i;r++){o=n[r];o.match=o.matcher(e)}return null}}(this);l=function(t){return function(e){var r,i,n,o,s;o=t.watchers;for(i=0,n=o.length;i<n;i++){s=o[i];r=s.fire||(s.fire=s.match!==s.matcher(e));if(r){t.lastNode=e}t.fire||(t.fire=r)}return null}}(this);p=function(t){return function(e){var r,i,n,o,s;o=t.watchers;for(i=0,n=o.length;i<n;i++){s=o[i];r=s.fire||(s.fire=s.matcher(e));if(r){t.lastNode=e}t.fire||(t.fire=r)}return null}}(this);this.digest=function(t){return function(){var e,r,i,n;if(!t.fire){return false}i=t.watchers.slice();for(e=0,r=i.length;e<r;e++){n=i[e];if(!n.fire){continue}n.fire=false;n.handler()}t.fire=false;return true}}(this);w=function(t){return function(t,e,n){var o,s,a,u,h,f,c,p;o=n||t.changed["node.id"];s=n||t.changed["node.classes"];f=false;if(o){u=e.get("node.id");if(u!==e.id){if(!n){m(e)}f=true;if(e.id!=null){y(e.id,e)}i(u,e)}}if(s){a=(c=e.get("node.classes"))!=null?c:[];h=a.join(",");if(h!==((p=e.classes)!=null?p.klass:void 0)){a=a.slice();if(!(n||f)){m(e)}f=true;if(e.classes!=null){g(e.classes,e)}r(a,e);e.classes=a;e.classes.klass=h}}if(!n&&f){l(e)}return null}}(this);o=function(t,e,r){var i,n,o,s,a;if(e==null){return}for(i=0,o=e.length;i<o;i++){n=e[i];s=(a=t[n])!=null?a:[];s.push(r);t[n]=s}return null};_=function(t,e,r){var i,n,o,s,a;if(e==null){return}for(i=0,s=e.length;i<s;i++){o=e[i];a=t[o];n=a.indexOf(r);if(n>=0){a.splice(n,1)}if(a.length===0){delete t[o]}}return null};d=function(t){var e,r,i,n,o;if(!(t.length>0)){return}e=t.hash={};o=[];for(r=0,n=t.length;r<n;r++){i=t[r];o.push(e[i]=true)}return o};T=function(t){return delete t.hash};i=function(t){return function(e,r){if(t.ids[e]){throw new Error("Duplicate node id `"+e+"`")}if(e!=null){t.ids[e]=[r]}return r.id=e!=null?e:r._id}}(this);y=function(t){return function(e,r){if(e!=null){delete t.ids[e]}return r.id=r._id}}(this);r=function(t){return function(e,r){o(t.classes,e,r);if(e!=null){return d(e)}}}(this);g=function(t){return function(e,r){_(t.classes,e,r);if(e!=null){return T(e)}}}(this);n=function(t){return function(e){return t.nodes.push(e)}}(this);E=function(t){return function(e){return t.nodes.splice(t.nodes.indexOf(e),1)}}(this);a=function(t){return function(e){return o(t.types,[e.type],e)}}(this);b=function(t){return function(e){return _(t.types,[e.type],e)}}(this);s=function(t){return function(e){o(t.traits,e.traits,e);return d(e.traits)}}(this);x=function(t){return function(e){_(t.traits,e.traits,e);return T(e.traits)}}(this);u(this.root);this.root.trigger({type:"added"})}t.prototype.filter=function(t,e){var r,i,n,o,s;n=this._matcher(e);s=[];for(r=0,i=t.length;r<i;r++){o=t[r];if(n(o)){s.push(o)}}return s};t.prototype.ancestry=function(t,e){var r,i,n,o,s;o=[];for(r=0,i=t.length;r<i;r++){n=t[r];s=n.parent;while(s!=null){if(c.call(e,s)>=0){o.push(n);break}s=s.parent}}return o};t.prototype.select=function(t,e){var r;r=this._select(t);if(e!=null){r=this.ancestry(r,e)}r.sort(function(t,e){return e.order-t.order});return r};t.prototype.watch=function(t,e){var r;e.unwatch=function(t){return function(){return t.unwatch(e)}}(this);e.watcher=r={selector:t,handler:e,matcher:this._matcher(t),match:false,fire:false};this.watchers.push(r);return this.select(t)};t.prototype.unwatch=function(t){var e;e=t.watcher;if(e==null){return}this.watchers.splice(this.watchers.indexOf(e),1);delete t.unwatch;return delete t.watcher};t.prototype._simplify=function(t){var e,r,a,h,f,c,p,d,m,v,g,y;t=t.replace(/^\s+/,"");t=t.replace(/\s+$/,"");a=e=t===i;if(!a){a=h=(c=t.match(s))!=null?c[1]:void 0}if(!a){a=f=(p=t.match(o))!=null?p[1]:void 0}if(!a){a=g=(d=t.match(u))!=null?d[1]:void 0}if(!a){a=y=(m=t.match(l))!=null?m[0]:void 0}if(!a){a=r=(v=t.match(n))!=null?v[0]:void 0}return[e,h,f,g,y,r]};t.prototype._matcher=function(t){var e,r,i,n,o,s,a;o=this._simplify(t),e=o[0],i=o[1],n=o[2],s=o[3],a=o[4],r=o[5];if(e){return function(t){return true}}if(i){return function(t){return t.id===i}}if(n){return function(t){var e,r;return(e=t.classes)!=null?(r=e.hash)!=null?r[n]:void 0:void 0}}if(s){return function(t){var e,r;return(e=t.traits)!=null?(r=e.hash)!=null?r[s]:void 0:void 0}}if(a){return function(t){return t.type===a}}if(r){throw"Auto-link matcher unsupported"}return f(t)};t.prototype._select=function(t){var e,r,i,n,o,s,a,u,l,h;n=this._simplify(t),e=n[0],r=n[1],i=n[2],l=n[3],h=n[4];if(e){return this.nodes}if(r){return(o=this.ids[r])!=null?o:[]}if(i){return(s=this.classes[i])!=null?s:[]}if(l){return(a=this.traits[l])!=null?a:[]}if(h){return(u=this.types[h])!=null?u:[]}return this.filter(this.nodes,t)};t.prototype.getRoot=function(){return this.root};t.prototype.getLastTrigger=function(){return this.lastNode.toString()};return t}();e.exports=a},{cssauron:5}],26:[function(t,e,r){var i,n,o,s;o=t("../util");s=0;n=function(){function t(t,e,r,i,n,o){this.type=t;this._id=(++s).toString();this.configure(n,o);this.parent=this.root=this.path=this.index=null;this.set(e,true,true);this.set(r,false,true);this.bind(i,false)}t.prototype.configure=function(t,e){var r,i,n,o,s,a,u,l,h,f,c,p;p=t.traits,n=t.props,r=t.finals,i=t.freeform;if(p==null){p=(o=(s=this._config)!=null?s.traits:void 0)!=null?o:[]}if(n==null){n=(a=(u=this._config)!=null?u.props:void 0)!=null?a:{}}if(r==null){r=(l=(h=this._config)!=null?h.finals:void 0)!=null?l:{}}if(i==null){i=(f=(c=this._config)!=null?c.freeform:void 0)!=null?f:false}this._config={traits:p,props:n,finals:r,freeform:i};return this.attributes=e.apply(this,this._config)};t.prototype.dispose=function(){this.attributes.dispose();return this.attributes=null};t.prototype._added=function(t){var e;this.parent=t;this.root=t.root;e={type:"add",node:this,parent:this.parent};if(this.root){this.root.trigger(e)}e.type="added";return this.trigger(e)};t.prototype._removed=function(){var t;t={type:"remove",node:this};if(this.root){this.root.trigger(t)}t.type="removed";this.trigger(t);return this.root=this.parent=null};t.prototype._index=function(t,e){var r,i;if(e==null){e=this.parent}this.index=t;this.path=r=t!=null?((i=e!=null?e.path:void 0)!=null?i:[]).concat([t]):null;this.order=r!=null?this._encode(r):Infinity;if(this.root!=null){return this.trigger({type:"reindex"})}};t.prototype._encode=function(t){var e,r,i,n,o,s,a,u,l,h,f;a=3;h=function(t){return a/(t+a)};l=function(t){return r+(e-r)*t};e=1+1/a;r=0;for(o=0,u=t.length;o<u;o++){s=t[o];i=h(s+1);n=h(s+2);f=[l(i),l(n)],e=f[0],r=f[1]}return e};t.prototype.toString=function(){var t,e,r,i,n,o,s;t=(i=this.id)!=null?i:this._id;s=(n=this.type)!=null?n:"node";r=s;r+="#"+t;if((o=this.classes)!=null?o.length:void 0){r+="."+this.classes.join(".")}if(this.children!=null){if(e=this.children.length){return"<"+r+">…("+e+")…</"+s+">"}else{return"<"+r+"></"+s+">"}}else{return"<"+r+" />"}};t.prototype.toMarkup=function(t,e){var r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y;if(t==null){t=null}if(e==null){e=""}if(t&&typeof t!=="function"){t=(p=(d=this.root)!=null?d.model._matcher(t):void 0)!=null?p:function(){return true}}g=(m=this.type)!=null?m:"node";a=this.expr;h={id:this._id};v=typeof this.orig==="function"?this.orig():void 0;for(u in v){y=v[u];h[u]=y}f=function(){var t;t=[];for(u in h){y=h[u];if(!this.expr[u]){t.push(o.Pretty.JSX.prop(u,y))}}return t}.call(this);a=function(){var t;t=[];for(u in a){y=a[u];t.push(o.Pretty.JSX.bind(u,y))}return t}();r=[""];if(f.length){r=r.concat(f)}if(a.length){r=r.concat(a)}r=r.join(" ");i=e;c=function(e){return function(){var r,n;if(!((n=e.children)!=null?n.length:void 0)){return""}return r=e.children.map(function(e){return e.toMarkup(t,i)}).filter(function(t){return t!=null&&t.length}).join("\n")}}(this);if(t&&!t(this)){return c()}if(this.children!=null){l="<"+g+r+">";s="</"+g+">";i=e+"  ";n=c();if(n.length){n="\n"+n+"\n"+e}if(n==null){n=""}return e+l+n+s}else{return e+"<"+g+r+" />"}};t.prototype.print=function(t,e){return o.Pretty.print(this.toMarkup(t),e)};return t}();i=t("../util/binder");i.apply(n.prototype);e.exports=n},{"../util":166,"../util/binder":162}],27:[function(t,e,r){var i;i={dom:t("./dom")};e.exports=i},{"./dom":28}],28:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./overlay");o=t("../util").VDOM;i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.prototype.el=o.element;e.prototype.hint=o.hint;e.prototype.apply=o.apply;e.prototype.recycle=o.recycle;e.prototype.init=function(t){return this.last=null};e.prototype.dispose=function(){this.unmount();return e.__super__.dispose.apply(this,arguments)};e.prototype.mount=function(){var t;t=document.createElement("div");t.classList.add("mathbox-overlay");this.element.appendChild(t);return this.overlay=t};e.prototype.unmount=function(t){if(this.overlay.parentNode){this.element.removeChild(this.overlay)}return this.overlay=null};e.prototype.render=function(t){var e,r,i,n,o,s;if(!this.overlay){this.mount()}if((s=typeof t)==="string"||s==="number"){t=this.el("div",null,t)}if(t instanceof Array){t=this.el("div",null,t)}r=t.type==="div";e=this.last;n=this.overlay;i=r?n:n.childNodes[0];o=r?n.parentNode:n;if(!e&&i){e=this.el("div")}this.apply(t,e,i,o,0);this.last=t;if(e!=null){this.recycle(e)}};return e}(n);e.exports=i},{"../util":166,"./overlay":31}],29:[function(t,e,r){var i;i=function(){function t(t,e){var r;this.classes=t;this.canvas=e;r=document.createElement("div");r.classList.add("mathbox-overlays");this.div=r}t.prototype.inject=function(){var t;t=this.canvas.parentNode;if(!t){throw new Error("Canvas not inserted into document.")}return t.insertBefore(this.div,this.canvas)};t.prototype.unject=function(){var t;t=this.div.parentNode;return t.removeChild(this.div)};t.prototype.getTypes=function(){return Object.keys(this.classes)};t.prototype.make=function(t,e){return new this.classes[t](this.div,e)};return t}();e.exports=i},{}],30:[function(t,e,r){r.Factory=t("./factory");r.Classes=t("./classes");r.Overlay=t("./overlay")},{"./classes":27,"./factory":29,"./overlay":31}],31:[function(t,e,r){var i;i=function(){function t(t,e){this.element=t;if(typeof this.init==="function"){this.init(e)}}t.prototype.dispose=function(){};return t}();e.exports=i},{}],32:[function(t,e,r){var i,n;n=t("../util");i=function(){function t(t,e){this.context=e;this.classes=t.Classes;this.helpers=t.Helpers}t.prototype.getTypes=function(){return Object.keys(this.classes)};t.prototype.make=function(t,e,r){var i,n,o;if(e==null){e={}}if(r==null){r=null}i=this.classes[t];if(i==null){throw new Error("Unknown primitive class `"+t+"`")}n=new i.model(t,i.defaults,e,r,i,this.context.attributes);o=new i(n,this.context,this.helpers);return n};return t}();e.exports=i},{"../util":166}],33:[function(t,e,r){r.Factory=t("./factory");r.Primitive=t("./primitive");r.Types=t("./types")},{"./factory":32,"./primitive":34,"./types":63}],34:[function(t,e,r){var i,n,o,s=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};n=t("../model");o=function(){t.Node=n.Node;t.Group=n.Group;t.model=t.Node;t.defaults=null;t.traits=null;t.props=null;t.finals=null;t.freeform=false;function t(t,e,r){this.node=t;this._context=e;this._renderables=this._context.renderables;this._attributes=this._context.attributes;this._shaders=this._context.shaders;this._overlays=this._context.overlays;this._animator=this._context.animator;this._types=this._attributes.types;this.node.controller=this;this.node.on("added",function(t){return function(e){return t._added()}}(this));this.node.on("removed",function(t){return function(e){return t._removed()}}(this));this.node.on("change",function(t){return function(e){if(t._root){return t.change(e.changed,e.touched)}}}(this));this.reconfigure();this._get=this.node.get.bind(this.node);this._helpers=r(this,this.node.traits);this._handlers={inherit:{},listen:[],watch:[],compute:[]};this._root=this._parent=null;this.init()}t.prototype.is=function(t){return this.traits.hash[t]};t.prototype.init=function(){};t.prototype.make=function(){};t.prototype.made=function(){};t.prototype.unmake=function(t){};t.prototype.unmade=function(){};t.prototype.change=function(t,e,r){};t.prototype.refresh=function(){return this.change({},{},true)};t.prototype.rebuild=function(){if(this._root){this._removed(true);return this._added()}};t.prototype.reconfigure=function(t){if(t!=null){this.node.configure(t,this._attributes)}this.traits=this.node.traits;return this.props=this.node.props};t.prototype._added=function(){var t,e,r,i;this._parent=(e=this.node.parent)!=null?e.controller:void 0;this._root=(r=this.node.root)!=null?r.controller:void 0;this.node.clock=(i=this._inherit("clock"))!=null?i:this._root;try{try{this.make();this.refresh();return this.made()}catch(e){t=e;this.node.print("warn");console.error(t);throw t}}catch(e){t=e;try{return this._removed()}catch(t){}}};t.prototype._removed=function(t){if(t==null){t=false}this.unmake(t);this._unlisten();this._unattach();this._uncompute();this._root=null;this._parent=null;return this.unmade(t)};t.prototype._listen=function(t,e,r,i){var n,o,s;if(i==null){i=this}if(t instanceof Array){for(n=0,o=t.length;n<o;n++){s=t[n];return this.__listen(s,e,r,i)}}return this.__listen(t,e,r,i)};t.prototype.__listen=function(t,e,r,i){var n;if(i==null){i=this}if(typeof t==="string"){t=this._inherit(t)}if(t!=null){n=r.bind(i);n.node=this.node;t.on(e,n);this._handlers.listen.push([t,e,n])}return t};t.prototype._unlisten=function(){var t,e,r,i,n,o,s;if(!this._handlers.listen.length){return}n=this._handlers.listen;for(e=0,r=n.length;e<r;e++){o=n[e],i=o[0],s=o[1],t=o[2];i.off(s,t)}return this._handlers.listen=[]};t.prototype._inherit=function(t){var e,r;e=this._handlers.inherit[t];if(e!==void 0){return e}return this._handlers.inherit[t]=(r=this._parent)!=null?r._find(t!=null?t:null):void 0};t.prototype._find=function(t){var e;if(this.is(t)){return this}return(e=this._parent)!=null?e._find(t):void 0};t.prototype._uninherit=function(){return this._handlers.inherit={}};t.prototype._attach=function(t,e,r,i,o,a,u){var l,h,f,c,p;if(i==null){i=this}if(o==null){o=this}if(a==null){a=false}if(u==null){u=false}l=function(t){if(t!=null&&s.call(t.traits,e)>=0){return t}};f=function(t){return t!=null?t.controller:void 0};h=function(t){var e,r,i,n;if(t==null){return t}i=[];for(e=0,r=t.length;e<r;e++){n=t[e];if(n instanceof Array){i=i.concat(n)}else{i.push(n)}}return i};p=function(t){return function(s){var f,c,d,m,v,g,y,E;if(typeof s==="object"){d=s;if(d!=null?d._up:void 0){s=u?d._targets:[d[0]];return s}if(d instanceof Array){s=u?h(d.map(p)):p(d[0]);return s}if(d instanceof n.Node){return[d]}}else if(typeof s==="string"&&s[0]==="<"){f=0;if(c=s.match(/^<([0-9])+$/)){f=+c[1]-1}if(s.match(/^<+$/)){f=+s.length-1}m=[];g=o.node;while(g){v=g.parent;if(!v){break}g=v.children[g.index-1];if(!(g||m.length)){g=v}d=null;if(l(g)){d=g}if(d!=null&&f--<=0){m.push(d)}if(!u&&m.length){return m}}if(u&&m.length){return m}}else if(typeof s==="string"){E=r.bind(i);t._handlers.watch.push(E);y=t._root.watch(s,E);if(!u){if(l(y[0])){d=y[0]}if(d!=null){return[d]}}else{m=y.filter(l);if(m.length){return m}}}if(!a){console.warn(t.node.toMarkup());throw new Error(t.node.toString()+" - Could not find "+e+" `"+s+"`")}if(u){return[]}else{return null}}}(this);c=h(p(t));if(u){if(c!=null){return c.map(f)}else{return null}}else{if(c!=null){return f(c[0])}else{return null}}};t.prototype._unattach=function(){var t,e,r,i;if(!this._handlers.watch.length){return}r=this._handlers.watch;for(t=0,e=r.length;t<e;t++){i=r[t];if(i!=null){i.unwatch()}}return this._handlers.watch=[]};t.prototype._compute=function(t,e){this._handlers.compute.push(t);return this.node.bind(t,e,true)};t.prototype._uncompute=function(){var t,e,r,i;if(!this._handlers.compute.length){return}i=this._handlers.compute;for(t=0,r=i.length;t<r;t++){e=i[t];this.node.unbind(e,true)}return this._handlers.compute=[]};return t}();i=t("../util/binder");i.apply(o.prototype);e.exports=o},{"../model":24,"../util/binder":162}],35:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./parent");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","entity","visible","active"];e.prototype.make=function(){this._helpers.visible.make();return this._helpers.active.make()};e.prototype.unmake=function(){this._helpers.visible.unmake();return this._helpers.active.unmake()};return e}(n);e.exports=i},{"./parent":37}],36:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty,a=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};n=t("./parent");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind"];e.prototype.make=function(){return this._helpers.bind.make([{to:"inherit.source",trait:"node"}])};e.prototype.unmake=function(){return this._helpers.bind.unmake()};e.prototype._find=function(t){if(this.bind.source&&a.call(this.props.traits,t)>=0){return this.bind.source._inherit(t)}return e.__super__._find.apply(this,arguments)};return e}(n);e.exports=i},{"./parent":37}],37:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("../../primitive");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.model=n.Group;e.traits=["node"];return e}(n);e.exports=i},{"../../primitive":34}],38:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./parent");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","root","clock","scene","vertex","unit"];e.prototype.init=function(){this.size=null;this.cameraEvent={type:"root.camera"};this.preEvent={type:"root.pre"};this.updateEvent={type:"root.update"};this.renderEvent={type:"root.render"};this.postEvent={type:"root.post"};this.clockEvent={type:"clock.tick"};return this.camera=null};e.prototype.make=function(){return this._helpers.unit.make()};e.prototype.unmake=function(){return this._helpers.unit.unmake()};e.prototype.change=function(t,e,r){if(t["root.camera"]||r){this._unattach();this._attach(this.props.camera,"camera",this.setCamera,this,this,true);return this.setCamera()}};e.prototype.adopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this._context.scene.add(i))}return o};e.prototype.unadopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this._context.scene.remove(i))}return o};e.prototype.select=function(t){return this.node.model.select(t)};e.prototype.watch=function(t,e){return this.node.model.watch(t,e)};e.prototype.unwatch=function(t){return this.node.model.unwatch(t)};e.prototype.resize=function(t){this.size=t;return this.trigger({type:"root.resize",size:t})};e.prototype.getSize=function(){return this.size};e.prototype.getSpeed=function(){return this.props.speed};e.prototype.getUnit=function(){return this._helpers.unit.get()};e.prototype.getUnitUniforms=function(){return this._helpers.unit.uniforms()};e.prototype.pre=function(){this.getCamera().updateProjectionMatrix();this.trigger(this.clockEvent);return this.trigger(this.preEvent)};e.prototype.update=function(){return this.trigger(this.updateEvent)};e.prototype.render=function(){return this.trigger(this.renderEvent)};e.prototype.post=function(){return this.trigger(this.postEvent)};e.prototype.setCamera=function(){var t,e;t=(e=this.select(this.props.camera)[0])!=null?e.controller:void 0;if(this.camera!==t){this.camera=t;return this.trigger({type:"root.camera"})}};e.prototype.getCamera=function(){var t,e;return(t=(e=this.camera)!=null?e.getCamera():void 0)!=null?t:this._context.defaultCamera};e.prototype.getTime=function(){return this._context.time};e.prototype.vertex=function(t,e){if(e===2){return t.pipe("view.position")}if(e===3){return t.pipe("root.position")}return t};return e}(i);e.exports=n},{"../../../util":166,"./parent":37}],39:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","source","index"];e.prototype.made=function(){return this.trigger({type:"source.rebuild"})};e.prototype.indexShader=function(t){return t.pipe(o.GLSL.identity("vec4"))};e.prototype.sourceShader=function(t){return t.pipe(o.GLSL.identity("vec4"))};e.prototype.getDimensions=function(){return{items:1,width:1,height:1,depth:1}};e.prototype.getActiveDimensions=function(){return this.getDimensions()};e.prototype.getIndexDimensions=function(){return this.getActiveDimensions()};e.prototype.getFutureDimensions=function(){return this.getActiveDimensions()};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],40:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./parent");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","unit"];e.prototype.make=function(){return this._helpers.unit.make()};e.prototype.unmake=function(){return this._helpers.unit.unmake()};e.prototype.getUnit=function(){return this._helpers.unit.get()};e.prototype.getUnitUniforms=function(){return this._helpers.unit.uniforms()};return e}(i);e.exports=n},{"../../../util":166,"./parent":37}],41:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","camera"];e.prototype.init=function(){};e.prototype.make=function(){var t;t=this._context.defaultCamera;this.camera=this.props.proxy?t:t.clone();this.euler=new THREE.Euler;return this.quat=new THREE.Quaternion};e.prototype.unmake=function(){};e.prototype.getCamera=function(){return this.camera};e.prototype.change=function(t,e,r){var i,n,s,a,u,l,h,f;if(t["camera.position"]||t["camera.quaternion"]||t["camera.rotation"]||t["camera.lookAt"]||t["camera.up"]||t["camera.fov"]||r){l=this.props,a=l.position,u=l.quaternion,h=l.rotation,s=l.lookAt,f=l.up,n=l.fov,i=l.aspect;if(a!=null){this.camera.position.copy(a)}if(u!=null||h!=null||s!=null){if(s!=null){this.camera.lookAt(s)}else{this.camera.quaternion.set(0,0,0,1)}if(h!=null){this.euler.setFromVector3(h,o.Three.swizzleToEulerOrder(this.props.eulerOrder));this.quat.setFromEuler(this.euler);this.camera.quaternion.multiply(this.quat)}if(u!=null){this.camera.quaternion.multiply(u)}}if(n!=null&&this.camera.fov!=null){this.camera.fov=n}if(f!=null){this.camera.up.copy(f)}return this.camera.updateMatrix()}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],42:[function(t,e,r){var i;i={axis:t("./draw/axis"),face:t("./draw/face"),grid:t("./draw/grid"),line:t("./draw/line"),point:t("./draw/point"),strip:t("./draw/strip"),surface:t("./draw/surface"),ticks:t("./draw/ticks"),vector:t("./draw/vector"),view:t("./view/view"),cartesian:t("./view/cartesian"),cartesian4:t("./view/cartesian4"),polar:t("./view/polar"),spherical:t("./view/spherical"),stereographic:t("./view/stereographic"),stereographic4:t("./view/stereographic4"),transform:t("./transform/transform3"),transform4:t("./transform/transform4"),vertex:t("./transform/vertex"),fragment:t("./transform/fragment"),layer:t("./transform/layer"),mask:t("./transform/mask"),array:t("./data/array"),interval:t("./data/interval"),matrix:t("./data/matrix"),area:t("./data/area"),voxel:t("./data/voxel"),volume:t("./data/volume"),scale:t("./data/scale"),image:t("./data/image"),html:t("./overlay/html"),dom:t("./overlay/dom"),text:t("./text/text"),format:t("./text/format"),label:t("./text/label"),retext:t("./text/retext"),clamp:t("./operator/clamp"),grow:t("./operator/grow"),join:t("./operator/join"),lerp:t("./operator/lerp"),memo:t("./operator/memo"),readback:t("./operator/readback"),resample:t("./operator/resample"),repeat:t("./operator/repeat"),swizzle:t("./operator/swizzle"),spread:t("./operator/spread"),split:t("./operator/split"),slice:t("./operator/slice"),subdivide:t("./operator/subdivide"),transpose:t("./operator/transpose"),group:t("./base/group"),inherit:t("./base/inherit"),root:t("./base/root"),unit:t("./base/unit"),shader:t("./shader/shader"),camera:t("./camera/camera"),rtt:t("./rtt/rtt"),compose:t("./rtt/compose"),clock:t("./time/clock"),now:t("./time/now"),move:t("./present/move"),play:t("./present/play"),present:t("./present/present"),reveal:t("./present/reveal"),slide:t("./present/slide"),step:t("./present/step")};e.exports=i},{"./base/group":35,"./base/inherit":36,"./base/root":38,"./base/unit":40,"./camera/camera":41,"./data/area":43,"./data/array":44,"./data/image":47,"./data/interval":48,"./data/matrix":49,"./data/scale":50,"./data/volume":51,"./data/voxel":52,"./draw/axis":53,"./draw/face":54,"./draw/grid":55,"./draw/line":56,"./draw/point":57,"./draw/strip":58,"./draw/surface":59,"./draw/ticks":60,"./draw/vector":61,"./operator/clamp":64,"./operator/grow":65,"./operator/join":66,"./operator/lerp":67,"./operator/memo":68,"./operator/readback":70,"./operator/repeat":71,"./operator/resample":72,"./operator/slice":73,"./operator/split":74,"./operator/spread":75,"./operator/subdivide":76,"./operator/swizzle":77,"./operator/transpose":78,"./overlay/dom":79,"./overlay/html":80,"./present/move":81,"./present/play":82,"./present/present":83,"./present/reveal":84,"./present/slide":85,"./present/step":86,"./rtt/compose":89,"./rtt/rtt":90,"./shader/shader":91,"./text/format":92,"./text/label":93,"./text/retext":94,"./text/text":95,"./time/clock":96,"./time/now":97,"./transform/fragment":99,"./transform/layer":100,"./transform/mask":101,"./transform/transform3":103,"./transform/transform4":104,"./transform/vertex":105,"./view/cartesian":107,"./view/cartesian4":108,"./view/polar":109,"./view/spherical":110,"./view/stereographic":111,"./view/stereographic4":112,"./view/view":113}],43:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./matrix");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","matrix","texture","raw","span:x","span:y","area","sampler:x","sampler:y"];e.prototype.updateSpan=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c;r=this.props.axes;c=this.props.width;i=this.props.height;t=this.props.centeredX;e=this.props.centeredY;s=this.props.paddingX;a=this.props.paddingY;u=this._helpers.span.get("x.",r[0]);l=this._helpers.span.get("y.",r[1]);this.aX=u.x;this.aY=l.x;h=u.y-u.x;f=l.y-l.x;c+=s*2;i+=a*2;if(t){n=1/Math.max(1,c);this.aX+=h*n/2}else{n=1/Math.max(1,c-1)}if(e){o=1/Math.max(1,i);this.aY+=f*o/2}else{o=1/Math.max(1,i-1)}this.bX=h*n;this.bY=f*o;this.aX+=s*this.bX;return this.aY+=a*this.bY};e.prototype.callback=function(t){this.updateSpan();if(this.last===t){return this._callback}this.last=t;if(t.length<=5){return this._callback=function(e){return function(r,i,n){var o,s;o=e.aX+e.bX*i;s=e.aY+e.bY*n;return t(r,o,s,i,n)}}(this)}else{return this._callback=function(e){return function(r,i,n){var o,s;o=e.aX+e.bX*i;s=e.aY+e.bY*n;return t(r,o,s,i,n,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.make=function(){e.__super__.make.apply(this,arguments);this._helpers.span.make();return this._listen(this,"span.range",this.updateSpan)};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this._helpers.span.unmake()};return e}(n);e.exports=i},{"../../../util":166,"./matrix":49}],44:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./buffer");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","array","texture","raw"];e.prototype.init=function(){this.buffer=this.spec=null;this.space={width:0,history:0};this.used={width:0};this.storage="arrayBuffer";this.passthrough=function(t,e){return t(e,0,0,0)};return e.__super__.init.apply(this,arguments)};e.prototype.sourceShader=function(t){var e;e=this.getDimensions();this.alignShader(e,t);return this.buffer.shader(t)};e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.history,depth:1}};e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.buffer.getFilled(),depth:1}};e.prototype.getFutureDimensions=function(){return{items:this.items,width:this.used.width,height:this.space.history,depth:1}};e.prototype.getRawDimensions=function(){return{items:this.items,width:space.width,height:1,depth:1}};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m;e.__super__.make.apply(this,arguments);u=(l=this.minFilter)!=null?l:this.props.minFilter;a=(h=this.magFilter)!=null?h:this.props.magFilter;d=(f=this.type)!=null?f:this.props.type;m=this.props.width;n=this.props.history;c=this.props.bufferWidth;t=this.props.channels;s=this.props.items;i=this.spec={channels:t,items:s,width:m};this.items=i.items;this.channels=i.channels;r=this.props.data;i=o.Data.getDimensions(r,i);p=this.space;p.width=Math.max(c,i.width||1);p.history=n;return this.buffer=this._renderables.make(this.storage,{width:p.width,history:p.history,channels:t,items:s,minFilter:u,magFilter:a,type:d})};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.buffer){this.buffer.dispose();return this.buffer=this.spec=null}};e.prototype.change=function(t,e,r){var i;if(e["texture"]||t["history.history"]||t["buffer.channels"]||t["buffer.items"]||t["array.bufferWidth"]){return this.rebuild()}if(!this.buffer){return}if(t["array.width"]){i=this.props.width;if(i>this.space.width){return this.rebuild()}}if(t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||r){return this.buffer.setCallback(this.emitter())}};e.prototype.callback=function(t){if(t.length<=2){return t}else{return function(e){return function(r,i){return t(r,i,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.update=function(){var t,e,r,i,n,s;if(!this.buffer){return}t=this.props.data;i=this,n=i.space,s=i.used;r=s.width;e=this.buffer.getFilled();this.syncBuffer(function(e){return function(r){var i,a,u;if(t!=null){a=o.Data.getDimensions(t,e.spec);if(a.width>n.width){r();return e.rebuild()}s.width=a.width;e.buffer.setActive(s.width);if(typeof(i=e.buffer.callback).rebind==="function"){i.rebind(t)}return e.buffer.update()}else{u=e.spec.width||1;e.buffer.setActive(u);u=e.buffer.update();return s.width=u}}}(this));if(s.width!==r||e!==this.buffer.getFilled()){return this.trigger({type:"source.resize"})}};return e}(n);e.exports=i},{"../../../util":166,"./buffer":45}],45:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./data");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","texture"];e.prototype.init=function(){this.bufferSlack=0;this.bufferFrames=0;this.bufferTime=0;this.bufferDelta=0;this.bufferClock=0;this.bufferStep=0;return e.__super__.init.apply(this,arguments)};e.prototype.make=function(){e.__super__.make.apply(this,arguments);return this.clockParent=this._inherit("clock")};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.rawBuffer=function(){return this.buffer};e.prototype.emitter=function(){var t,r,i;i=this.props,t=i.channels,r=i.items;return e.__super__.emitter.call(this,t,r)};e.prototype.change=function(t,e,r){var i;if(t["buffer.fps"]||r){i=this.props.fps;return this.bufferSlack=i?.5/i:0}};e.prototype.syncBuffer=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;if(!this.buffer){return}d=this.props,f=d.live,n=d.fps,a=d.hurry,h=d.limit,p=d.realtime,c=d.observe;i=this.buffer.getFilled();if(!(!i||f)){return}x=this.clockParent.getTime();if(n!=null){g=this.bufferSlack;y=x.step/x.delta;r=p?x.delta:x.step;o=1/n;E=p&&c?y*o:o;this.bufferSlack=Math.min(h/n,g+r);this.bufferDelta=r;this.bufferStep=E;s=Math.min(a,Math.floor(g*n));if(!i){s=Math.max(1,s)}_=false;e=function(){return _=true};v=[];for(u=l=0,m=s;0<=m?l<m:l>m;u=0<=m?++l:--l){this.bufferTime+=r;this.bufferClock+=E;if(_){break}t(e,this.bufferFrames++,u,s);v.push(this.bufferSlack-=o)}return v}else{this.bufferTime=x.time;this.bufferDelta=x.delta;this.bufferClock=x.clock;this.bufferStep=x.step;return t(function(){},this.bufferFrames++,0,1)}};e.prototype.alignShader=function(t,e){var r,i,n,o,s,a;a=this.props,n=a.minFilter,i=a.magFilter,r=a.aligned;o=t.items>1&&t.width>1||t.height>1&&t.depth>1;if(r||!o){return}s=n===this.node.attributes["texture.minFilter"]["enum"].nearest&&i===this.node.attributes["texture.magFilter"]["enum"].nearest;if(!s){console.warn(this.node.toString()+" - Cannot use linear min/magFilter with 3D/4D sampling")}return e.pipe("map.xyzw.align")};return e}(n);e.exports=i},{"../../../util":166,"./data":46}],46:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../base/source");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","data","source","index","entity","active"];e.prototype.init=function(){this.dataEmitter=null;return this.dataSizes=null};e.prototype.emitter=function(t,e){var r,i,n,s,a,u,l,h;i=this.props.data;r=this.props.bind;s=this.props.expr;if(i!=null){a=this.dataSizes;l=o.Data.getSizes(i);if(!a||a.length!==l.length){h=o.Data.getThunk(i);this.dataEmitter=this.callback(o.Data.makeEmitter(h,e,t));this.dataSizes=l}n=this.dataEmitter}else if(typeof u!=="undefined"&&u!==null){u=this._inherit("resolve");n=this.callback(u.callback(r))}else if(s!=null){n=this.callback(s)}else{n=this.callback(this.passthrough)}return n};e.prototype.callback=function(t){return t!=null?t:function(){}};e.prototype.update=function(){};e.prototype.make=function(){this._helpers.active.make();this.first=true;return this._listen("root","root.update",function(t){return function(){if(t.isActive||t.first){t.update()}return t.first=false}}(this))};e.prototype.unmake=function(){this._helpers.active.unmake();this.dataEmitter=null;return this.dataSizes=null};return e}(n);e.exports=i},{"../../../util":166,"../base/source":39}],47:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../base/source");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","source","index","texture","image","rawtex"];e.prototype.init=function(){this.width=this.height=this.texture=this.uniforms=null;return this.myTexture=false};e.prototype.sourceShader=function(t){t.pipe;t.pipe(o.GLSL.truncateVec(4,2));t.pipe("map.2d.data",this.uniforms);return t.pipe("sample.2d",this.uniforms)};e.prototype.imageShader=function(t){return t.pipe("sample.2d",this.uniforms)};e.prototype.getDimensions=function(){return{items:1,width:this.width,height:this.height,depth:1}};e.prototype.make=function(){var t;t=this._attributes.types;return this.uniforms={dataTexture:{type:"t",value:null},dataResolution:this._attributes.make(t.vec2()),dataPointer:this._attributes.make(t.vec2())}};e.prototype.unmake=function(){if(this.myTexture){this.texture.dispose()}this.width=this.height=this.texture=null;delete this.uniforms;return this.myTexture=false};e.prototype.change=function(t,e,r){var i,n,o,s,a,u,l,h;if(r){return this.updateTex()}h=(n=(o=this.props.width)!=null?o:(s=this.props.image)!=null?s.naturalWidth:void 0)!=null?n:1;i=(a=(u=this.props.height)!=null?u:(l=this.props.image)!=null?l.naturalHeight:void 0)!=null?a:1;if(this.width!==h||this.height!==i){return this.rebuild()}if(e["image"]){return this.updateTex()}};e.prototype.updateTex=function(){var t,e,r,i,n,o,s,a,u,l,h,f;this.width=(i=(n=this.props.width)!=null?n:(o=this.props.image)!=null?o.naturalWidth:void 0)!=null?i:1;this.height=(s=(a=this.props.height)!=null?a:(u=this.props.image)!=null?u.naturalHeight:void 0)!=null?s:1;t=this.props.image;f=this.props.texture;this.needFlip=false;r=(l=this.props.minFilter)!=null?l:THREE.LinearFilter;e=(h=this.props.magFilter)!=null?h:THREE.LinearFilter;if(this.myTexture){this.texture.dispose();this.myTexture=false}if(f==null&&t==null){f=new THREE.DataTexture(new Uint8Array(this.width*this.height*4),this.width,this.height,THREE.RGBAFormat,THREE.FloatType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,e,r,1);f.generateMipmaps=false;f.flipY=false;f.needsUpdate=true;this.myTexture=true}if(t!=null){f=new THREE.Texture(t,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,e,r,THREE.RGBAFormat,THREE.FloatType);f.generateMipmaps=false;f.unpackAlignment=1;f.flipY=false;f.needsUpdate=true;this.myTexture=true;this.needFlip=true}this.texture=f;this.uniforms.dataTexture.value=this.texture;if(this.needFlip){this.uniforms.dataResolution.value.set(1/this.width,-1/this.height);return this.uniforms.dataPointer.value.set(.5,-this.height+.5)}else{this.uniforms.dataResolution.value.set(1/this.width,1/this.height);return this.uniforms.dataPointer.value.set(.5,.5)}};return e}(n);e.exports=i},{"../../../util":166,"../base/source":39}],48:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./array");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","texture","array","span","interval","sampler","raw"];e.prototype.updateSpan=function(){var t,e,r,i,n,o,s;e=this.props.axis;s=this.props.width;t=this.props.centered;i=this.props.padding;n=this._helpers.span.get("",e);s+=i*2;this.a=n.x;o=n.y-n.x;if(t){r=1/Math.max(1,s);this.a+=o*r/2}else{r=1/Math.max(1,s-1)}this.b=o*r;return this.a+=i*this.b};e.prototype.callback=function(t){this.updateSpan();if(this.last===t){return this._callback}this.last=t;if(t.length<=3){return this._callback=function(e){return function(r,i){var n;n=e.a+e.b*i;return t(r,n,i)}}(this)}else{return this._callback=function(e){return function(r,i){var n;n=e.a+e.b*i;return t(r,n,i,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.make=function(){e.__super__.make.apply(this,arguments);this._helpers.span.make();return this._listen(this,"span.range",this.updateSpan)};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this._helpers.span.unmake()};return e}(o);e.exports=i},{"../../../util":166,"./array":44}],49:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./buffer");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","texture","matrix","raw"];e.prototype.init=function(){this.buffer=this.spec=null;this.space={width:0,height:0,history:0};this.used={width:0,height:0};this.storage="matrixBuffer";this.passthrough=function(t,e,r){return t(e,r,0,0)};return e.__super__.init.apply(this,arguments)};e.prototype.sourceShader=function(t){var e;e=this.getDimensions();this.alignShader(e,t);return this.buffer.shader(t)};e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:this.space.history}};e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.buffer.getFilled()}};e.prototype.getFutureDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.space.history}};e.prototype.getRawDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:1}};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g;e.__super__.make.apply(this,arguments);l=(h=this.minFilter)!=null?h:this.props.minFilter;u=(f=this.magFilter)!=null?f:this.props.magFilter;v=(c=this.type)!=null?c:this.props.type;g=this.props.width;n=this.props.height;s=this.props.history;p=this.props.bufferWidth;d=this.props.bufferHeight;t=this.props.channels;a=this.props.items;i=this.spec={channels:t,items:a,width:g,height:n};this.items=i.items;this.channels=i.channels;r=this.props.data;i=o.Data.getDimensions(r,i);m=this.space;m.width=Math.max(p,i.width||1);m.height=Math.max(d,i.height||1);m.history=s;return this.buffer=this._renderables.make(this.storage,{width:m.width,height:m.height,history:m.history,channels:t,items:a,minFilter:l,magFilter:u,type:v})};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.buffer){this.buffer.dispose();return this.buffer=this.spec=null}};e.prototype.change=function(t,e,r){var i,n;if(e["texture"]||t["matrix.history"]||t["buffer.channels"]||t["buffer.items"]||t["matrix.bufferWidth"]||t["matrix.bufferHeight"]){return this.rebuild()}if(!this.buffer){return}if(t["matrix.width"]){n=this.props.width;if(n>this.space.width){return this.rebuild()}}if(t["matrix.height"]){i=this.props.height;if(i>this.space.height){return this.rebuild()}}if(t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||r){return this.buffer.setCallback(this.emitter())}};e.prototype.callback=function(t){if(t.length<=3){return t}else{return function(e){return function(r,i,n){return t(r,i,n,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.update=function(){var t,e,r,i,n,s,a;if(!this.buffer){return}t=this.props.data;i=this,n=i.space,s=i.used;a=s.width;r=s.height;e=this.buffer.getFilled();this.syncBuffer(function(e){return function(r){var i,a,u,l,h,f;if(t!=null){u=o.Data.getDimensions(t,e.spec);if(u.width>n.width||u.height>n.height){r();return e.rebuild()}s.width=u.width;s.height=u.height;e.buffer.setActive(s.width,s.height);if(typeof(a=e.buffer.callback).rebind==="function"){a.rebind(t)}return e.buffer.update()}else{f=e.spec.width||1;l=e.spec.height||1;e.buffer.setActive(f,l);h=e.buffer.update();s.width=i=f;s.height=Math.ceil(h/i);if(s.height===1){return s.width=h}}}}(this));if(s.width!==a||s.height!==r||e!==this.buffer.getFilled()){return this.trigger({type:"source.resize"})}};return e}(i);e.exports=n},{"../../../util":166,"./buffer":45}],50:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../base/source");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","source","index","interval","span","scale","raw","origin"];e.prototype.init=function(){return this.used=this.space=this.scaleAxis=this.sampler=null};e.prototype.rawBuffer=function(){return this.buffer};e.prototype.sourceShader=function(t){return t.pipe(this.sampler)};e.prototype.getDimensions=function(){return{items:1,width:this.space,height:1,depth:1}};e.prototype.getActiveDimensions=function(){return{items:1,width:this.used,height:this.buffer.getFilled(),depth:1}};e.prototype.getRawDimensions=function(){return this.getDimensions()};e.prototype.make=function(){var t,e,r;this.space=r=this._helpers.scale.divide("");this.buffer=this._renderables.make("dataBuffer",{width:r,channels:1,items:1});e={scaleAxis:this._attributes.make(this._types.vec4()),scaleOffset:this._attributes.make(this._types.vec4())};this.scaleAxis=e.scaleAxis.value;this.scaleOffset=e.scaleOffset.value;t=this.sampler=this._shaders.shader();t.require(this.buffer.shader(this._shaders.shader(),1));t.pipe("scale.position",e);this._helpers.span.make();return this._listen(this,"span.range",this.updateRanges)};e.prototype.unmake=function(){this.scaleAxis=null;return this._helpers.span.unmake()};e.prototype.change=function(t,e,r){if(t["scale.divide"]){return this.rebuild()}if(e["view"]||e["interval"]||e["span"]||e["scale"]||r){return this.updateRanges()}};e.prototype.updateRanges=function(){var t,e,r,i,n,s,a,u;u=this.used;s=this.props,t=s.axis,i=s.origin;n=this._helpers.span.get("",t);r=n.x;e=n.y;a=this._helpers.scale.generate("",this.buffer,r,e);o.Axis.setDimension(this.scaleAxis,t);o.Axis.setOrigin(this.scaleOffset,t,i);this.used=a.length;if(this.used!==u){return this.trigger({type:"source.resize"})}};return e}(n);e.exports=i},{"../../../util":166,"../base/source":39}],51:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./voxel");i=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","texture","voxel","span:x","span:y","span:z","volume","sampler:x","sampler:y","sampler:z","raw"];e.prototype.updateSpan=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;n=this.props.axes;y=this.props.width;o=this.props.height;i=this.props.depth;t=this.props.centeredX;e=this.props.centeredY;r=this.props.centeredZ;l=this.props.paddingX;h=this.props.paddingY;f=this.props.paddingZ;c=this._helpers.span.get("x.",n[0]);p=this._helpers.span.get("y.",n[1]);d=this._helpers.span.get("z.",n[2]);this.aX=c.x;this.aY=p.x;this.aZ=d.x;m=c.y-c.x;v=p.y-p.x;g=d.y-d.x;y+=l*2;o+=h*2;i+=f*2;if(t){s=1/Math.max(1,y);this.aX+=m*s/2}else{s=1/Math.max(1,y-1)}if(e){a=1/Math.max(1,o);this.aY+=v*a/2}else{a=1/Math.max(1,o-1)}if(r){u=1/Math.max(1,i);this.aZ+=g*u/2}else{u=1/Math.max(1,i-1)}this.bX=m*s;this.bY=v*a;this.bZ=g*u;this.aX+=this.bX*l;this.aY+=this.bY*h;return this.aZ+=this.bZ*h};e.prototype.callback=function(t){this.updateSpan();if(this.last===t){return this._callback}this.last=t;if(t.length<=7){return this._callback=function(e){return function(r,i,n,o){var s,a,u;s=e.aX+e.bX*i;a=e.aY+e.bY*n;u=e.aZ+e.bZ*o;return t(r,s,a,u,i,n,o)}}(this)}else{return this._callback=function(e){return function(r,i,n,o){var s,a,u;s=e.aX+e.bX*i;a=e.aY+e.bY*n;u=e.aZ+e.bZ*o;return t(r,s,a,u,i,n,o,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.make=function(){e.__super__.make.apply(this,arguments);this._helpers.span.make();return this._listen(this,"span.range",this.updateSpan)};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this._helpers.span.unmake()};return e}(o);e.exports=n},{"../../../util":166,"./voxel":52}],52:[function(t,e,r){var i,n,o,s=function(t,e){return function(){return t.apply(e,arguments)}},a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("./buffer");n=t("../../../util");o=function(t){a(e,t);function e(){this.update=s(this.update,this);return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","source","index","texture","voxel","raw"];e.prototype.init=function(){this.buffer=this.spec=null;this.space={width:0,height:0,depth:0};this.used={width:0,height:0,depth:0};this.storage="voxelBuffer";this.passthrough=function(t,e,r,i){return t(e,r,i,0)};return e.__super__.init.apply(this,arguments)};e.prototype.sourceShader=function(t){var e;e=this.getDimensions();this.alignShader(e,t);return this.buffer.shader(t)};e.prototype.getDimensions=function(){return{items:this.items,width:this.space.width,height:this.space.height,depth:this.space.depth}};e.prototype.getActiveDimensions=function(){return{items:this.items,width:this.used.width,height:this.used.height,depth:this.used.depth*this.buffer.getFilled()}};e.prototype.getRawDimensions=function(){return this.getDimensions()};e.prototype.make=function(){var t,r,i,o,s,a,u,l,h,f,c,p,d,m,v,g,y;e.__super__.make.apply(this,arguments);l=(h=this.minFilter)!=null?h:this.props.minFilter;u=(f=this.magFilter)!=null?f:this.props.magFilter;g=(c=this.type)!=null?c:this.props.type;y=this.props.width;s=this.props.height;i=this.props.depth;p=this.props.bufferWidth;d=this.props.bufferHeight;m=this.props.bufferDepth;t=this.props.channels;a=this.props.items;o=this.spec={channels:t,items:a,width:y,height:s,depth:i};this.items=o.items;this.channels=o.channels;r=this.props.data;o=n.Data.getDimensions(r,o);v=this.space;v.width=Math.max(p,o.width||1);v.height=Math.max(d,o.height||1);v.depth=Math.max(m,o.depth||1);return this.buffer=this._renderables.make(this.storage,{width:v.width,height:v.height,depth:v.depth,channels:t,items:a,minFilter:l,magFilter:u,type:g})};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.buffer){this.buffer.dispose();return this.buffer=this.spec=null}};e.prototype.change=function(t,e,r){var i,n,o;if(e["texture"]||t["buffer.channels"]||t["buffer.items"]||t["voxel.bufferWidth"]||t["voxel.bufferHeight"]||t["voxel.bufferDepth"]){return this.rebuild()}if(!this.buffer){return}if(t["voxel.width"]){o=this.props.width;if(o>this.space.width){return this.rebuild()}}if(t["voxel.height"]){n=this.props.height;if(n>this.space.height){return this.rebuild()}}if(t["voxel.depth"]){i=this.props.depth;if(i>this.space.depth){return this.rebuild()}}if(t["data.map"]||t["data.data"]||t["data.resolve"]||t["data.expr"]||r){return this.buffer.setCallback(this.emitter())}};e.prototype.callback=function(t){if(t.length<=4){return t}else{return function(e){return function(r,i,n,o){return t(r,i,n,o,e.bufferClock,e.bufferStep)}}(this)}};e.prototype.update=function(){var t,e,r,i,o,s,a,u;if(!this.buffer){return}e=this.props.data;o=this,s=o.space,a=o.used;u=a.width;i=a.height;t=a.depth;r=this.buffer.getFilled();this.syncBuffer(function(t){return function(r){var i,o,u,l,h,f,c,p;if(e!=null){h=n.Data.getDimensions(e,t.spec);if(h.width>s.width||h.height>s.height||h.depth>s.depth){r();return t.rebuild()}a.width=h.width;a.height=h.height;a.depth=h.depth;t.buffer.setActive(a.width,a.height,a.depth);if(typeof(u=t.buffer.callback).rebind==="function"){u.rebind(e)}return t.buffer.update()}else{p=t.spec.width||1;f=t.spec.height||1;l=t.spec.depth||1;t.buffer.setActive(p,f,l);c=t.buffer.update();a.width=o=p;a.height=i=f;a.depth=Math.ceil(c/o/i);if(a.depth===1){a.height=Math.ceil(c/o);if(a.height===1){return a.width=c}}}}}(this));if(a.width!==u||a.height!==i||a.depth!==t||r!==this.buffer.getFilled()){return this.trigger({type:"source.resize"})}};return e}(i);e.exports=o},{"../../../util":166,"./buffer":45}],53:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);e.traits=["node","object","visible","style","line","axis","span","interval","arrow","position","origin","shade"];e.defaults={end:true,zBias:-1};function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.axisPosition=this.axisStep=this.resolution=this.line=this.arrows=null}e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;f={axisPosition:this._attributes.make(this._types.vec4()),axisStep:this._attributes.make(this._types.vec4())};this.axisPosition=f.axisPosition.value;this.axisStep=f.axisStep.value;h=this._shaders.shader();h.pipe("axis.position",f);h=this._helpers.position.pipeline(h);y=this._helpers.style.uniforms();a=this._helpers.line.uniforms();t=this._helpers.arrow.uniforms();x=this._inherit("unit").getUnitUniforms();i=this.props.detail;m=i+1;this.resolution=1/i;c=this.props,v=c.start,n=c.end;p=this.props,g=p.stroke,s=p.join;u=this._helpers.object.mask();l=this._helpers.shade.pipeline()||false;d=this.props,r=d.crossed,e=d.axis;if(!r&&u!=null&&e>1){E=["x000","y000","z000","w000"][e];u=this._helpers.position.swizzle(u,E)}_=o.JS.merge(t,a,y,x);this.line=this._renderables.make("line",{uniforms:_,samples:m,position:h,clip:v||n,stroke:g,join:s,mask:u,material:l});this.arrows=[];if(v){this.arrows.push(this._renderables.make("arrow",{uniforms:_,flip:true,samples:m,position:h,mask:u,material:l}))}if(n){this.arrows.push(this._renderables.make("arrow",{uniforms:_,samples:m,position:h,mask:u,material:l}))}this._helpers.visible.make();this._helpers.object.make(this.arrows.concat([this.line]));this._helpers.span.make();return this._listen(this,"span.range",this.updateRanges)};e.prototype.unmake=function(){this._helpers.visible.unmake();this._helpers.object.unmake();return this._helpers.span.unmake()};e.prototype.change=function(t,e,r){if(t["axis.detail"]||t["line.stroke"]||t["line.join"]||t["axis.crossed"]||t["interval.axis"]&&this.props.crossed){return this.rebuild()}if(e["interval"]||e["span"]||e["view"]||r){return this.updateRanges()}};e.prototype.updateRanges=function(){var t,e,r,i,n,s;s=this.props,t=s.axis,i=s.origin;n=this._helpers.span.get("",t);r=n.x;e=n.y;o.Axis.setDimension(this.axisPosition,t).multiplyScalar(r);o.Axis.setDimension(this.axisStep,t).multiplyScalar((e-r)*this.resolution);return o.Axis.addOrigin(this.axisPosition,t,i)};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],54:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);e.traits=["node","object","visible","style","line","mesh","face","geometry","position","bind","shade"];function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.face=null}e.prototype.resize=function(){var t,e,r,i,n,o;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();i=e.items,o=e.width,r=e.height,t=e.depth;if(this.face){this.face.geometry.clip(o,r,t,i)}if(this.line){this.line.geometry.clip(i,o,r,t)}if(this.bind.map!=null){n=this.bind.map.getActiveDimensions();if(this.face){return this.face.geometry.map(n.width,n.height,n.depth,n.items)}}};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]);if(this.bind.points==null){return}v=this.bind.points.sourceShader(this._shaders.shader());v=this._helpers.position.pipeline(v);x=this._helpers.style.uniforms();f=this._helpers.line.uniforms();w=this._inherit("unit").getUnitUniforms();H={};H.styleZBias=this._attributes.make(this._types.number());this.wireZBias=H.styleZBias;r=this.bind.points.getDimensions();a=r.items,R=r.width,s=r.height,e=r.depth;g=this.props,l=g.line,E=g.shaded,n=g.fill,_=g.stroke,u=g.join;if(this.bind.colors){t=this._shaders.shader();this.bind.colors.sourceShader(t)}p=this._helpers.object.mask();c=this._helpers.shade.map((y=this.bind.map)!=null?y.sourceShader(this._shaders.shader()):void 0);d=this._helpers.shade.pipeline();i=d||E;h=d||false;m=[];if(l){b=this._shaders.shader();b.pipe(o.GLSL.swizzleVec4("yzwx"));b.pipe(v);T=o.JS.merge(w,f,x,H);this.line=this._renderables.make("line",{uniforms:T,samples:a,strips:R,ribbons:s,layers:e,position:b,color:t,stroke:_,join:u,material:h,mask:p,closed:true});m.push(this.line)}if(n){T=o.JS.merge(w,x,{});this.face=this._renderables.make("face",{uniforms:T,width:R,height:s,depth:e,items:a,position:v,color:t,material:i,mask:p,map:c});m.push(this.face)}this._helpers.visible.make();return this._helpers.object.make(m)};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.face=this.line=null};e.prototype.change=function(t,e,r){var i,n,o,s;if(t["geometry.points"]||e["mesh"]){return this.rebuild()}if(t["style.zBias"]||t["mesh.lineBias"]||r){o=this.props,i=o.fill,s=o.zBias,n=o.lineBias;return this.wireZBias.value=s+(i?n:0)}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],55:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);e.traits=["node","object","visible","style","line","grid","area","position","origin","shade","axis:x","axis:y","scale:x","scale:y","span:x","span:y"];e.defaults={width:1,zBias:-2};function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.axes=null}e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p;u=this._helpers.object.mask();l=this._helpers.shade.pipeline()||false;e=function(t){return function(e,r,n){var s,a,h,f,p,d,m,v,g,y,E,_,x,b;a=t._get(e+"axis.detail");g=a+1;v=1/a;y=t._helpers.scale.divide(r);s=t._renderables.make("dataBuffer",{width:y,channels:1});m={gridPosition:t._attributes.make(t._types.vec4()),gridStep:t._attributes.make(t._types.vec4()),gridAxis:t._attributes.make(t._types.vec4())};b={gridPosition:m.gridPosition.value,gridStep:m.gridStep.value,gridAxis:m.gridAxis.value};p=d=t._shaders.shader();if(n!=null&&u!=null){u=t._helpers.position.swizzle(u,n)}p.require(s.shader(t._shaders.shader(),2));p.pipe("grid.position",m);d=t._helpers.position.pipeline(p);E=t._helpers.style.uniforms();f=t._helpers.line.uniforms();x=t._inherit("unit").getUnitUniforms();_=o.JS.merge(f,E,x);h=t._renderables.make("line",{uniforms:_,samples:g,strips:y,position:d,stroke:c,join:i,mask:u,material:l});return{first:e,second:r,resolution:v,samples:g,line:h,buffer:s,values:b}}}(this);h=this.props,n=h.lineX,s=h.lineY,r=h.crossed,t=h.axes;p=["0000","x000","y000","z000","w000"][t[1]];f=this.props,c=f.stroke,i=f.join;this.axes=[];n&&this.axes.push(e("x.","y.",null));s&&this.axes.push(e("y.","x.",r?null:p));a=function(){var t,r,i,n;i=this.axes;n=[];for(t=0,r=i.length;t<r;t++){e=i[t];n.push(e.line)}return n}.call(this);this._helpers.visible.make();this._helpers.object.make(a);this._helpers.span.make();return this._listen(this,"span.range",this.updateRanges)};e.prototype.unmake=function(){var t,e,r,i;this._helpers.visible.unmake();this._helpers.object.unmake();this._helpers.span.unmake();i=this.axes;for(e=0,r=i.length;e<r;e++){t=i[e];t.buffer.dispose()}return this.axes=null};e.prototype.change=function(t,e,r){if(t["x.axis.detail"]||t["y.axis.detail"]||t["x.axis.factor"]||t["y.axis.factor"]||t["grid.lineX"]||t["grid.lineY"]||t["line.stroke"]||t["line.join"]||t["grid.crossed"]||t["grid.axes"]&&this.props.crossed){return this.rebuild()}if(e["x"]||e["y"]||e["area"]||e["grid"]||e["view"]||r){return this.updateRanges()}};e.prototype.updateRanges=function(){var t,e,r,i,n,s,a,u,l;e=function(e){return function(r,i,s,a,u){var l,h,f,c,p,d,m,v,g,y,E;h=u.first,g=u.second,m=u.resolution,v=u.samples,f=u.line,l=u.buffer,E=u.values;p=s.x;c=s.y;o.Axis.setDimension(E.gridPosition,r).multiplyScalar(p);o.Axis.setDimension(E.gridStep,r).multiplyScalar((c-p)*m);o.Axis.addOrigin(E.gridPosition,t,n);p=a.x;c=a.y;y=e._helpers.scale.generate(g,l,p,c);o.Axis.setDimension(E.gridAxis,i);d=y.length;return f.geometry.clip(v,d,1,1)}}(this);u=this.props,t=u.axes,n=u.origin;s=this._helpers.span.get("x.",t[0]);a=this._helpers.span.get("y.",t[1]);l=this.props,r=l.lineX,i=l.lineY;if(r){e(t[0],t[1],s,a,this.axes[0])}if(i){return e(t[1],t[0],a,s,this.axes[+r])}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],56:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);e.traits=["node","object","visible","style","line","arrow","geometry","position","bind","shade"];function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.line=this.arrows=null}e.prototype.resize=function(){var t,e,r,i,n,o,s,a,u,l;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();u=e.width;l=e.height;a=e.depth;i=e.items;this.line.geometry.clip(u,l,a,i);o=this.arrows;s=[];for(r=0,n=o.length;r<n;r++){t=o[r];s.push(t.geometry.clip(u,l,a,i))}return s};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]);if(this.bind.points==null){return}h=this._shaders.shader();h=this.bind.points.sourceShader(h);h=this._helpers.position.pipeline(h);E=this._helpers.style.uniforms();a=this._helpers.line.uniforms();t=this._helpers.arrow.uniforms();x=this._inherit("unit").getUnitUniforms();c=this.props,v=c.start,i=c.end;p=this.props,y=p.stroke,n=p.join,f=p.proximity;this.proximity=f;r=this.bind.points.getDimensions();m=r.width;g=r.height;d=r.depth;s=r.items;if(this.bind.colors){e=this._shaders.shader();this.bind.colors.sourceShader(e)}u=this._helpers.object.mask();l=this._helpers.shade.pipeline()||false;_=o.JS.merge(t,a,E,x);this.line=this._renderables.make("line",{uniforms:_,samples:m,strips:g,ribbons:d,layers:s,position:h,color:e,clip:v||i,stroke:y,join:n,proximity:f,mask:u,material:l});this.arrows=[];if(v){this.arrows.push(this._renderables.make("arrow",{uniforms:_,flip:true,samples:m,strips:g,ribbons:d,layers:s,position:h,color:e,mask:u,material:l}))}if(i){this.arrows.push(this._renderables.make("arrow",{uniforms:_,samples:m,strips:g,ribbons:d,layers:s,position:h,color:e,mask:u,material:l}))}this._helpers.visible.make();return this._helpers.object.make(this.arrows.concat([this.line]))};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.line=this.arrows=null};e.prototype.change=function(t,e,r){if(t["geometry.points"]||t["line.stroke"]||t["line.join"]||t["arrow.start"]||t["arrow.end"]){return this.rebuild()}if(t["line.proximity"]){if(this.proximity!=null!==(this.props.proximity!=null)){return this.rebuild()}}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],57:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);e.traits=["node","object","visible","style","point","geometry","position","bind","shade"];function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.point=null}e.prototype.resize=function(){var t,e,r,i,n;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();i=e.items,n=e.width,r=e.height,t=e.depth;return this.point.geometry.clip(n,r,t,i)};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"point.sizes",trait:"source"}]);if(this.bind.points==null){return}f=this._shaders.shader();f=this.bind.points.sourceShader(f);f=this._helpers.position.pipeline(f);r=this.bind.points.getDimensions();s=r.items,g=r.width,n=r.height,e=r.depth;d=this._helpers.style.uniforms();h=this._helpers.point.uniforms();v=this._inherit("unit").getUnitUniforms();if(this.bind.colors){t=this._shaders.shader();this.bind.colors.sourceShader(t)}if(this.bind.sizes){p=this._shaders.shader();this.bind.sizes.sourceShader(p)}a=this._helpers.object.mask();u=this._helpers.shade.pipeline()||false;c=this.props.shape;i=this.props.fill;l=this.props.optical;m=o.JS.merge(v,h,d);this.point=this._renderables.make("point",{uniforms:m,width:g,height:n,depth:e,items:s,position:f,color:t,size:p,shape:c,optical:l,fill:i,mask:a,material:u});this._helpers.visible.make();return this._helpers.object.make([this.point])};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.point=null};e.prototype.change=function(t,e,r){if(t["geometry.points"]||t["point.shape"]||t["point.fill"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],58:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);e.traits=["node","object","visible","style","line","mesh","strip","geometry","position","bind","shade"];function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.strip=null}e.prototype.resize=function(){var t,e,r,i,n,o;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();i=e.items,o=e.width,r=e.height,t=e.depth;if(this.strip){this.strip.geometry.clip(o,r,t,i)}if(this.line){this.line.geometry.clip(i,o,r,t)}if(this.bind.map!=null){n=this.bind.map.getActiveDimensions();if(this.strip){return this.strip.geometry.map(n.width,n.height,n.depth,n.items)}}};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]);if(this.bind.points==null){return}v=this._shaders.shader();v=this.bind.points.sourceShader(v);v=this._helpers.position.pipeline(v);x=this._helpers.style.uniforms();f=this._helpers.line.uniforms();w=this._inherit("unit").getUnitUniforms();l=this.props.line;E=this.props.shaded;n=this.props.fill;H={};H.styleZBias=this._attributes.make(this._types.number());this.wireZBias=H.styleZBias;r=this.bind.points.getDimensions();a=r.items,R=r.width,s=r.height,e=r.depth;g=this.props,l=g.line,E=g.shaded,n=g.fill,_=g.stroke,u=g.join;if(this.bind.colors){t=this._shaders.shader();t=this.bind.colors.sourceShader(t)}p=this._helpers.object.mask();c=this._helpers.shade.map((y=this.bind.map)!=null?y.sourceShader(this._shaders.shader()):void 0);d=this._helpers.shade.pipeline();i=d||E;h=d||false;m=[];if(l){b=this._shaders.shader();b.pipe(o.GLSL.swizzleVec4("yzwx"));b.pipe(v);T=o.JS.merge(w,f,x,H);this.line=this._renderables.make("line",{uniforms:T,samples:a,strips:R,ribbons:s,layers:e,position:b,color:t,stroke:_,join:u,mask:p,material:h});m.push(this.line)}if(n){T=o.JS.merge(x,{});this.strip=this._renderables.make("strip",{uniforms:T,width:R,height:s,depth:e,items:a,position:v,color:t,material:i});m.push(this.strip)}this._helpers.visible.make();return this._helpers.object.make(m)};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.strip=null};e.prototype.change=function(t,e,r){var i,n,o,s;if(t["geometry.points"]||e["mesh"]){return this.rebuild()}if(t["style.zBias"]||t["mesh.lineBias"]||r){o=this.props,i=o.fill,s=o.zBias,n=o.lineBias;return this.wireZBias.value=s+(i?n:0)}};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],59:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);e.traits=["node","object","visible","style","line","mesh","geometry","surface","position","grid","bind","shade"];e.defaults={lineX:false,lineY:false};function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.lineX=this.lineY=this.surface=null}e.prototype.resize=function(){var t,e,r,i,n,o;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();o=e.width,r=e.height,t=e.depth,i=e.items;if(this.surface){this.surface.geometry.clip(o,r,t,i)}if(this.lineX){this.lineX.geometry.clip(o,r,t,i)}if(this.lineY){this.lineY.geometry.clip(r,o,t,i)}if(this.bind.map!=null){n=this.bind.map.getActiveDimensions();if(this.surface){return this.surface.geometry.map(n.width,n.height,n.depth,n.items)}}};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"},{to:"mesh.map",trait:"source"}]);if(this.bind.points==null){return}_=this._shaders.shader();_=this.bind.points.sourceShader(_);_=this._helpers.position.pipeline(_);M=this._helpers.style.uniforms();z=this._helpers.style.uniforms();p=this._helpers.line.uniforms();S=this._helpers.surface.uniforms();L=this._inherit("unit").getUnitUniforms();z.styleColor=this._attributes.make(this._types.color());z.styleZBias=this._attributes.make(this._types.number());this.wireColor=z.styleColor.value;this.wireZBias=z.styleZBias;this.wireScratch=new THREE.Color;s=this.bind.points.getDimensions();P=s.width,l=s.height,n=s.depth,h=s.items;b=this.props,R=b.shaded,u=b.fill,d=b.lineX,m=b.lineY,t=b.closedX,e=b.closedY,H=b.stroke,f=b.join,x=b.proximity,i=b.crossed;E=[];this.proximity=x;if(this.bind.colors){r=this._shaders.shader();this.bind.colors.sourceShader(r)}g=this._helpers.object.mask();v=this._helpers.shade.map((T=this.bind.map)!=null?T.sourceShader(this._shaders.shader()):void 0);y=this._helpers.shade.pipeline();a=y||R;c=y||false;w=this._helpers.position,k=w.swizzle,A=w.swizzle2;C=o.JS.merge(L,p,M,z);D=d||m?-50:0;if(d){this.lineX=this._renderables.make("line",{uniforms:C,samples:P,strips:l,ribbons:n,layers:h,position:_,color:r,zUnits:-D,stroke:H,join:f,mask:g,material:c,proximity:x,closed:t||closed});E.push(this.lineX)}if(m){this.lineY=this._renderables.make("line",{uniforms:C,samples:l,strips:P,ribbons:n,layers:h,position:A(_,"yxzw","yxzw"),color:k(r,"yxzw"),zUnits:-D,stroke:H,join:f,mask:k(g,i?"xyzw":"yxzw"),material:c,proximity:x,closed:e||closed});E.push(this.lineY)}if(u){C=o.JS.merge(L,S,M);this.surface=this._renderables.make("surface",{uniforms:C,width:P,height:l,surfaces:n,layers:h,position:_,color:r,zUnits:D,stroke:H,material:a,mask:g,map:v,intUV:true,closedX:t||closed,closedY:e||closed});E.push(this.surface)}this._helpers.visible.make();return this._helpers.object.make(E)};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.lineX=this.lineY=this.surface=null};e.prototype.change=function(t,e,r){var i,n,o,s,a,u;if(t["geometry.points"]||t["mesh.shaded"]||t["mesh.fill"]||t["line.stroke"]||t["line.join"]||e["grid"]){return this.rebuild()}if(t["style.color"]||t["style.zBias"]||t["mesh.fill"]||t["mesh.lineBias"]||r){a=this.props,o=a.fill,n=a.color,u=a.zBias,s=a.lineBias;this.wireZBias.value=u+(o?s:0);this.wireColor.copy(n);if(o){i=this.wireScratch;i.setRGB(n.x,n.y,n.z);i.convertGammaToLinear().multiplyScalar(.75).convertLinearToGamma();this.wireColor.x=i.r;this.wireColor.y=i.g;this.wireColor.z=i.b}}if(t["line.proximity"]){if(this.proximity!=null!==(this.props.proximity!=null)){return this.rebuild()}}};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],60:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","style","line","ticks","geometry","position","bind","shade"];e.prototype.init=function(){return this.tickStrip=this.line=null};e.prototype.resize=function(){var t,e,r,i,n;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();t=+(e.items>0);n=e.width*t;i=e.height*t;r=e.depth*t;this.line.geometry.clip(2,n,i,r);return this.tickStrip.set(0,n-1)};e.prototype.make=function(){var t,e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]);if(this.bind.points==null){return}v=this._helpers.style.uniforms();n=this._helpers.line.uniforms();_=this._inherit("unit").getUnitUniforms();E=o.JS.merge(n,v,_);h={tickEpsilon:this.node.attributes["ticks.epsilon"],tickSize:this.node.attributes["ticks.size"],tickNormal:this.node.attributes["ticks.normal"],tickStrip:this._attributes.make(this._types.vec2(0,0)),worldUnit:E.worldUnit,focusDepth:E.focusDepth};this.tickStrip=h.tickStrip.value;u=l=this._shaders.shader();u.require(this.bind.points.sourceShader(this._shaders.shader()));u.require(this._helpers.position.pipeline(this._shaders.shader()));u.pipe("ticks.position",h);f=this.props,m=f.stroke,r=f.join;e=this.bind.points.getDimensions();d=e.width;p=e.height;i=e.depth;if(this.bind.colors){t=this._shaders.shader();this.bind.colors.sourceShader(t)}s=this._helpers.object.mask();a=this._helpers.shade.pipeline()||false;c=this._helpers.position,g=c.swizzle,y=c.swizzle2;this.line=this._renderables.make("line",{uniforms:E,samples:2,strips:d,ribbons:p,layers:i,position:l,color:t,stroke:m,join:r,mask:g(s,"yzwx"),material:a});this._helpers.visible.make();return this._helpers.object.make([this.line])};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this.line=null;this._helpers.visible.unmake();return this._helpers.object.unmake()};e.prototype.change=function(t,e,r){if(t["geometry.points"]||t["line.stroke"]||t["line.join"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],61:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");n=t("../../../util");o=function(t){s(e,t);e.traits=["node","object","visible","style","line","arrow","geometry","position","bind","shade"];function e(t,r,i){e.__super__.constructor.call(this,t,r,i);this.line=this.arrows=null}e.prototype.resize=function(){var t,e,r,i,n,o,s,a,u,l;if(this.bind.points==null){return}e=this.bind.points.getActiveDimensions();u=e.items;l=e.width;a=e.height;i=e.depth;this.line.geometry.clip(u,l,a,i);o=this.arrows;s=[];for(r=0,n=o.length;r<n;r++){t=o[r];s.push(t.geometry.clip(u,l,a,i))}return s};e.prototype.make=function(){var t,e,r,i,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w;this._helpers.bind.make([{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]);if(this.bind.points==null){return}h=this._shaders.shader();this.bind.points.sourceShader(h);this._helpers.position.pipeline(h);_=this._helpers.style.uniforms();a=this._helpers.line.uniforms();t=this._helpers.arrow.uniforms();w=this._inherit("unit").getUnitUniforms();c=this.props,g=c.start,i=c.end;p=this.props,E=p.stroke,o=p.join,f=p.proximity;this.proximity=f;r=this.bind.points.getDimensions();v=r.items;y=r.width;m=r.height;s=r.depth;if(this.bind.colors){e=this._shaders.shader();this.bind.colors.sourceShader(e)}u=this._helpers.object.mask();l=this._helpers.shade.pipeline()||false;d=this._helpers.position,x=d.swizzle,b=d.swizzle2;h=b(h,"yzwx","yzwx");e=x(e,"yzwx");u=x(u,"yzwx");l=x(l,"yzwx");T=n.JS.merge(t,a,_,w);this.line=this._renderables.make("line",{uniforms:T,samples:v,ribbons:m,strips:y,layers:s,position:h,color:e,clip:g||i,stroke:E,join:o,proximity:f,mask:u,material:l});this.arrows=[];if(g){this.arrows.push(this._renderables.make("arrow",{uniforms:T,flip:true,samples:v,ribbons:m,strips:y,layers:s,position:h,color:e,mask:u,material:l}))}if(i){this.arrows.push(this._renderables.make("arrow",{uniforms:T,samples:v,ribbons:m,strips:y,layers:s,position:h,color:e,mask:u,material:l}))}this._helpers.visible.make();return this._helpers.object.make(this.arrows.concat([this.line]))};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.line=this.arrows=null};e.prototype.change=function(t,e,r){if(t["geometry.points"]||t["line.stroke"]||t["line.join"]||t["arrow.start"]||t["arrow.end"]){return this.rebuild()}if(t["line.proximity"]){if(this.proximity!=null!==(this.props.proximity!=null)){return this.rebuild()}}};return e}(i);e.exports=o},{"../../../util":166,"../../primitive":34}],62:[function(t,e,r){var i,n,o,s=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};i=t("../../util");n=t("./view/view");o={bind:{make:function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;if(this.bind==null){this.bind={}}if(this.bound==null){this.bound=[]}for(i=0,s=t.length;i<s;i++){p=t[i];v=p.to,g=p.trait,h=p.optional,y=p.unique,u=p.multiple,e=p.callback;if(e==null){e=this.rebuild}l=v.split(/\./g).pop();c=this._get(v);d=null;if(c!=null){m=this;r=false;while(!r){m=d=this._attach(c,g,e,this,m,h,u);n=y&&(d==null||this.bound.indexOf(d)<0);r=u||h||!y||n}}if(d!=null){if(this.resize!=null){this._listen(d,"source.resize",this.resize)}if(e){this._listen(d,"source.rebuild",e)}if(u){for(o=0,a=d.length;o<a;o++){f=d[o];this.bound.push(f)}}else{this.bound.push(d)}}this.bind[l]=d}return null},unmake:function(){if(!this.bind){return}delete this.bind;return delete this.bound}},span:{make:function(){this.spanView=this._inherit("view");return this._listen("view","view.range",function(t){return function(){return t.trigger({type:"span.range"})}}(this))},unmake:function(){return delete this.spanView},get:function(){var t;t=new THREE.Vector2(-1,1);return function(e,r){var i,n,o;i=this._get(e+"span.range");if(i!=null){return i}return(n=(o=this.spanView)!=null?o.axis(r):void 0)!=null?n:t}}()},scale:{divide:function(t){var e,r;e=this._get(t+"scale.divide");r=this._get(t+"scale.factor");return Math.round(e*2.5/r)},generate:function(t,e,r,n){var o,s,a,u,l,h,f,c,p,d;l=this._get(t+"scale.mode");s=this._get(t+"scale.divide");p=this._get(t+"scale.unit");o=this._get(t+"scale.base");u=this._get(t+"scale.factor");f=this._get(t+"scale.start");a=this._get(t+"scale.end");d=this._get(t+"scale.zero");h=this._get(t+"scale.nice");c=i.Ticks.make(l,r,n,s,p,o,u,f,a,d,h);e.copy(c);return c}},style:{uniforms:function(){return{styleColor:this.node.attributes["style.color"],styleOpacity:this.node.attributes["style.opacity"],styleZBias:this.node.attributes["style.zBias"],styleZIndex:this.node.attributes["style.zIndex"]}}},arrow:{uniforms:function(){var t,e,r,i,n;i=this.props.start;t=this.props.end;r=this._attributes.make(this._types.number(1.25/(i+t)));n=this._attributes.make(this._types.vec2(+i,+t));e=this.node.attributes["arrow.size"];return{clipStyle:n,clipRange:e,clipSpace:r,arrowSpace:r,arrowSize:e}}},point:{uniforms:function(){return{pointSize:this.node.attributes["point.size"],pointDepth:this.node.attributes["point.depth"]}}},line:{uniforms:function(){return{lineWidth:this.node.attributes["line.width"],lineDepth:this.node.attributes["line.depth"],lineProximity:this.node.attributes["line.proximity"]}}},surface:{uniforms:function(){return{}}},shade:{pipeline:function(t){var e,r,i;if(!this._inherit("fragment")){return t}if(t==null){t=this._shaders.shader()}for(r=e=0;e<=2;r=++e){t=(i=this._inherit("fragment"))!=null?i.fragment(t,r):void 0}t.pipe("fragment.map.rgba");return t},map:function(t){if(!t){return t}return t=this._shaders.shader().pipe("mesh.map.uvwo").pipe(t)}},position:{pipeline:function(t){var e,r,i;if(!this._inherit("vertex")){return t}if(t==null){t=this._shaders.shader()}for(r=e=0;e<=3;r=++e){t=(i=this._inherit("vertex"))!=null?i.vertex(t,r):void 0}return t},swizzle:function(t,e){if(t){return this._shaders.shader().pipe(i.GLSL.swizzleVec4(e)).pipe(t)}},swizzle2:function(t,e,r){if(t){return this._shaders.shader().split().pipe(i.GLSL.swizzleVec4(e)).next().pipe(i.GLSL.swizzleVec4(r)).join().pipe(t)}}},visible:{make:function(){var t,e,r,i;t={type:"visible.change"};r=null;this.setVisible=function(t){if(t!=null){r=t}return e()};e=function(e){return function(){var n,o,s;n=e.isVisible;s=(o=r!=null?r:e._get("object.visible"))!=null?o:true;if(typeof i!=="undefined"&&i!==null){s&&(s=i.isVisible)}e.isVisible=s;if(n!==e.isVisible){return e.trigger(t)}}}(this);i=this._inherit("visible");if(i){this._listen(i,"visible.change",e)}if(this.is("object")){this._listen(this.node,"change:object",e)}return e()},unmake:function(){return delete this.isVisible}},active:{make:function(){var t,e,r,i;r={type:"active.change"};t=null;this.setActive=function(e){if(e!=null){t=e}return i()};i=function(i){return function(){var n,o,s;n=i.isActive;s=(o=t!=null?t:i._get("entity.active"))!=null?o:true;if(typeof e!=="undefined"&&e!==null){s&&(s=e.isActive)}i.isActive=s;if(n!==i.isActive){return i.trigger(r)}}}(this);e=this._inherit("active");if(e){this._listen(e,"active.change",i)}if(this.is("entity")){this._listen(this.node,"change:entity",i)}return i()},unmake:function(){return delete this.isActive}},object:{make:function(t){var e,r,i,n,o,a,u,l,h,f,c,p,d,m;this.objects=t!=null?t:[];this.renders=this.objects.reduce(function(t,e){return t.concat(e.renders)},[]);u=this._inherit("scene");f=e=p=null;r=s.call(this.traits,"style")>=0;f=1;e=THREE.NormalBlending;m=true;d=true;if(r){f=this.props.opacity;e=this.props.blending;p=this.props.zOrder;m=this.props.zWrite;d=this.props.zTest}l=function(t){return function(r){var i,n;i=r.changed;n=null;if(i["style.opacity"]){n=f=t.props.opacity}if(i["style.blending"]){n=e=t.props.blending}if(i["style.zOrder"]){n=p=t.props.zOrder}if(i["style.zWrite"]){n=m=t.props.zWrite}if(i["style.zTest"]){n=d=t.props.zTest}if(n!=null){return h()}}}(this);n=null;h=function(t){return function(){var i,n,o,s,a,u,l,h,c,v,g,y,E,_,x,b;h=p!=null?-p:t.node.order;b=((c=t.isVisible)!=null?c:true)&&f>0;if(b){if(r){v=t.objects;E=[];for(i=0,s=v.length;i<s;i++){l=v[i];l.show(f<1,e,h);E.push(l.depth(m,d))}return E}else{g=t.objects;_=[];for(n=0,a=g.length;n<a;n++){l=g[n];_.push(l.show(true,e,h))}return _}}else{y=t.objects;x=[];for(o=0,u=y.length;o<u;o++){l=y[o];x.push(l.hide())}return x}}}(this);this._listen(this.node,"change:style",l);this._listen(this.node,"reindex",h);this._listen(this,"visible.change",h);c=this.objects;for(i=0,o=c.length;i<o;i++){a=c[i];u.adopt(a)}return h()},unmake:function(t){var e,r,i,n,o,s,a,u,l;if(t==null){t=true}if(!this.objects){return}s=this._inherit("scene");a=this.objects;for(e=0,i=a.length;e<i;e++){o=a[e];s.unadopt(o)}if(t){u=this.objects;l=[];for(r=0,n=u.length;r<n;r++){o=u[r];l.push(o.dispose())}return l}},mask:function(){var t,e;if(!(t=this._inherit("mask"))){return}return e=t.mask(e)}},unit:{make:function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v;v=Math.PI;this.unitUniforms={renderScaleInv:l=this._attributes.make(this._types.number(1)),renderScale:u=this._attributes.make(this._types.number(1)),renderAspect:o=this._attributes.make(this._types.number(1)),renderWidth:h=this._attributes.make(this._types.number(0)),renderHeight:s=this._attributes.make(this._types.number(0)),viewWidth:d=this._attributes.make(this._types.number(0)),viewHeight:p=this._attributes.make(this._types.number(0)),pixelRatio:i=this._attributes.make(this._types.number(1)),pixelUnit:n=this._attributes.make(this._types.number(1)),worldUnit:m=this._attributes.make(this._types.number(1)),focusDepth:e=this._attributes.make(this._types.number(1)),renderOdd:a=this._attributes.make(this._types.vec2())};c=new THREE.Vector3;t=new THREE.Vector3;r=function(r){return function(){var g,y,E,_,x,b,T,w,R,H,M,S,k,A;if((k=typeof f!=="undefined"&&f!==null?f.getSize():void 0)==null){return}v=Math.PI;S=r.props.scale;_=r.props.fov;E=(H=r.props.focus)!=null?H:r.inherit("unit").props.focus;b=S===null;w=1;if(g=typeof f!=="undefined"&&f!==null?f.getCamera():void 0){T=g.projectionMatrix;c.set(0,-.5,1).applyProjection(T);t.set(0,.5,1).applyProjection(T);c.sub(t);w=c.y}y=k.renderHeight/k.viewHeight;x=_!=null?w*Math.tan(_*v/360):1;R=b?y:k.renderHeight/S*x;M=k.renderHeight*w/2;A=R/M;d.value=k.viewWidth;p.value=k.viewHeight;h.value=k.renderWidth;s.value=k.renderHeight;o.value=k.aspect;u.value=M;l.value=1/M;i.value=y;n.value=R;m.value=A;e.value=E;return a.value.set(k.renderWidth%2,k.renderHeight%2).multiplyScalar(.5)}}(this);f=this.is("root")?this:this._inherit("root");this._listen(f,"root.update",r);return r()},unmake:function(){return delete this.unitUniforms},get:function(){var t,e,r,i;r={};e=this.unitUniforms;for(t in e){i=e[t];r[t]=i.value}return r},uniforms:function(){return this.unitUniforms}}};e.exports=function(t,e){var r,i,n,s,a,u,l;r={};for(i=0,s=e.length;i<s;i++){l=e[i];if(!(u=o[l])){continue}r[l]={};for(n in u){a=u[n];r[l][n]=a.bind(t)}}return r}},{"../../util":166,"./view/view":113}],63:[function(t,e,r){var i;i=t("../../model");r.Classes=t("./classes");r.Types=t("./types");r.Traits=t("./traits");r.Helpers=t("./helpers")},{"../../model":24,"./classes":42,"./helpers":62,"./traits":98,"./types":106}],64:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./operator");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","clamp"];e.prototype.indexShader=function(t){t.pipe(this.operator);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){t.pipe(this.operator);return e.__super__.sourceShader.call(this,t)};e.prototype.make=function(){var t,r;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}r={clampLimit:this._attributes.make(this._types.vec4())};this.clampLimit=r.clampLimit;t=this._shaders.shader();t.pipe("clamp.position",r);return this.operator=t};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.resize=function(){var t;if(this.bind.source!=null){t=this.bind.source.getActiveDimensions();this.clampLimit.value.set(t.width-1,t.height-1,t.depth-1,t.items-1)}return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["operator"]||e["clamp"]){return this.rebuild()}};return e}(n);e.exports=i},{"./operator":69}],65:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./operator");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","grow"];e.prototype.sourceShader=function(t){return t.pipe(this.operator)};e.prototype.make=function(){var t,r;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}r={growScale:this.node.attributes["grow.scale"],growMask:this._attributes.make(this._types.vec4()),growAnchor:this._attributes.make(this._types.vec4())};this.growMask=r.growMask.value;this.growAnchor=r.growAnchor.value;t=this._shaders.shader();t.require(this.bind.source.sourceShader(this._shaders.shader()));t.pipe("grow.position",r);return this.operator=t};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.resize=function(){this.update();return e.__super__.resize.apply(this,arguments)};e.prototype.update=function(){var t,e,r,i,n,o,s,a,u;e=this.bind.source.getFutureDimensions();a=["width","height","depth","items"];s=function(t,e){return((t||1)-1)*(.5-e*.5)};u=[];for(r=i=0,o=a.length;i<o;r=++i){n=a[r];t=this.props[n];this.growMask.setComponent(r,+(t==null));u.push(this.growAnchor.setComponent(r,t!=null?s(e[n],t):0))}return u};e.prototype.change=function(t,e,r){if(e["operator"]){return this.rebuild()}if(e["grow"]){return this.update()}};return e}(n);e.exports=i},{"./operator":69}],66:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./operator");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","join"];e.prototype.indexShader=function(t){t.pipe(this.operator);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){t.pipe(this.operator);return e.__super__.sourceShader.call(this,t)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v;h=this.order;e=this.axis;c=this.overlap;u=this.length;v=this.stride;s=["width","height","depth","items"];l=h.map(function(t){return s[t-1]});n=h.indexOf(e);m=function(){var e,i,n;n=[];for(e=0,i=l.length;e<i;e++){r=l[e];n.push(t[r])}return n}();p=((d=m[n+1])!=null?d:1)*v;m.splice(n,2,p);m=m.slice(0,3);m.push(1);f={};for(i=o=0,a=l.length;o<a;i=++o){r=l[i];f[r]=m[i]}return f};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}u=this.props.order;t=this.props.axis;l=this.props.overlap;h=u.join("");if(t==null){t=u[0]}i=h.indexOf(t);f=h.replace(t,"00").substring(0,4);n=[null,"width","height","depth","items"];a=n[t];r=this.bind.source.getDimensions();s=r[a];l=Math.min(s-1,l);c=s-l;d={joinStride:this._attributes.make(this._types.number(c)),joinStrideInv:this._attributes.make(this._types.number(1/c))};p=this._shaders.shader();p.require(o.GLSL.swizzleVec4(t,1));p.require(o.GLSL.swizzleVec4(f,4));p.require(o.GLSL.injectVec4([i,i+1]));p.pipe("join.position",d);p.pipe(o.GLSL.invertSwizzleVec4(u));this.operator=p;this.order=u;this.axis=t;this.overlap=l;this.length=s;return this.stride=c};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["join"]||e["operator"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"./operator":69}],67:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./operator");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","lerp","sampler:x","sampler:y","sampler:z","sampler:w"];e.prototype.indexShader=function(t){t.pipe(this.indexer);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){return t.pipe(this.operator)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e,r,i;i=this.resampled;e=this.centered;r=this.padding;if(this.relativeSize){if(!e.items){t.items--}if(!e.width){t.width--}if(!e.height){t.height--}if(!e.depth){t.depth--}if(i.items!=null){t.items*=i.items}if(i.width!=null){t.width*=i.width}if(i.height!=null){t.height*=i.height}if(i.depth!=null){t.depth*=i.depth}if(!e.items){t.items++}if(!e.width){t.width++}if(!e.height){t.height++}if(!e.depth){t.depth++}t.items-=r.items*2;t.width-=r.width*2;t.height-=r.height*2;t.depth-=r.depth*2}else{if(i.items!=null){t.items=i.items}if(i.width!=null){t.width=i.width}if(i.height!=null){t.height=i.height}if(i.depth!=null){t.depth=i.depth}}t.items=Math.max(0,Math.floor(t.items));t.width=Math.max(0,Math.floor(t.width));t.height=Math.max(0,Math.floor(t.height));t.depth=Math.max(0,Math.floor(t.depth));return t};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}v=this.props,b=v.size,l=v.items,R=v.width,n=v.height,i=v.depth;E=b===this.node.attributes["lerp.size"]["enum"].relative;this.resampled={};if(l!=null){this.resampled.items=l}if(R!=null){this.resampled.width=R}if(n!=null){this.resampled.height=n}if(i!=null){this.resampled.depth=i}this.centered={};this.centered.items=this.props.centeredW;this.centered.width=this.props.centeredX;this.centered.height=this.props.centeredY;this.centered.depth=this.props.centeredZ;this.padding={};this.padding.items=this.props.paddingW;this.padding.width=this.props.paddingX;this.padding.height=this.props.paddingY;this.padding.depth=this.props.paddingZ;m=this._shaders.shader();u=this._shaders.shader();T={resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),resampleBias:this._attributes.make(this._types.vec4(0,0,0,0))};this.resampleFactor=T.resampleFactor;this.resampleBias=T.resampleBias;_=l!=null||R!=null||n!=null||i!=null;m.pipe("resample.padding",T);w=[];t=false;g=["width","height","depth","items"];for(s=h=0,p=g.length;h<p;s=++h){c=g[s];r=this.centered[c];t||(t=r);w[s]=r?"0.5":"0.0"}if(t&&_){w="vec4("+w+")";m.pipe(o.GLSL.binaryOperator(4,"+",vec4));u.pipe(o.GLSL.binaryOperator(4,"+",vec4))}if(_){m.pipe("resample.relative",T);u.pipe("resample.relative",T)}else{m.pipe(o.GLSL.identity("vec4"));u.pipe(o.GLSL.identity("vec4"))}if(t&&_){m.pipe(o.GLSL.binaryOperator(4,"-",w));u.pipe(o.GLSL.binaryOperator(4,"-",w))}x=this.bind.source.sourceShader(this._shaders.shader());y=["width","height","depth","items"];for(s=f=0,d=y.length;f<d;s=++f){c=y[s];a="lerp."+c;if(this.props[c]!=null){x=this._shaders.shader().require(x);x.pipe(a,T)}}m.pipe(x);this.operator=m;this.indexer=u;return this.relativeSize=E};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this.operator=null};e.prototype.resize=function(){var t,r,i,n,o,s,a,u,l,h,f,c,p,d,m;if(this.bind.source==null){return}s=this.bind.source.getActiveDimensions();m=this.getActiveDimensions();t=function(t){return function(e){var r,i,n;r=t.centered[e];i=t.padding[e];m[e]+=i*2;n=r?s[e]/Math.max(1,m[e]):Math.max(1,s[e]-1)/Math.max(1,m[e]-1);return[n,i]}}(this);u=t("width"),d=u[0],o=u[1];l=t("height"),c=l[0],i=l[1];h=t("depth"),a=h[0],r=h[1];f=t("items"),p=f[0],n=f[1];this.resampleFactor.value.set(d,c,a,p);this.resampleBias.value.set(o,i,r,n);return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["operator"]||e["lerp"]||e["sampler"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"./operator":69}],68:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./operator");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","active","operator","source","index","texture","memo"];e.prototype.sourceShader=function(t){return this.memo.shaderAbsolute(t,1)};e.prototype.make=function(){var t,r,i,n,o,s,a,u,l,h;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}this._helpers.active.make();this._listen("root","root.update",function(t){return function(){if(t.isActive){return t.update()}}}(this));u=this.props,s=u.minFilter,o=u.magFilter,l=u.type;r=this.bind.source.getDimensions();n=r.items,h=r.width,i=r.height,t=r.depth;this.memo=this._renderables.make("memo",{items:n,width:h,height:i,depth:t,minFilter:s,magFilter:o,type:l});a=this._shaders.shader();this.bind.source.sourceShader(a);this.compose=this._renderables.make("memoScreen",{map:a,items:n,width:h,height:i,depth:t});this.memo.adopt(this.compose);this.objects=[this.compose];return this.renders=this.compose.renders};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.bind.source!=null){this._helpers.active.unmake();this.memo.unadopt(this.compose);this.memo.dispose();return this.memo=this.compose=null}};e.prototype.update=function(){var t;return(t=this.memo)!=null?t.render():void 0};e.prototype.resize=function(){var t,r,i,n;if(this.bind.source==null){return}r=this.bind.source.getActiveDimensions();n=r.width,i=r.height,t=r.depth;this.compose.cover(n,i,t);return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["texture"]||e["operator"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"./operator":69}],69:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("../base/source");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index"];e.prototype.indexShader=function(t){var e;return(e=this.bind.source)!=null?typeof e.indexShader==="function"?e.indexShader(t):void 0:void 0};e.prototype.sourceShader=function(t){var e;return(e=this.bind.source)!=null?typeof e.sourceShader==="function"?e.sourceShader(t):void 0:void 0};e.prototype.getDimensions=function(){return this.bind.source.getDimensions()};e.prototype.getFutureDimensions=function(){return this.bind.source.getFutureDimensions()};e.prototype.getActiveDimensions=function(){return this.bind.source.getActiveDimensions()};e.prototype.getIndexDimensions=function(){return this.bind.source.getIndexDimensions()};e.prototype.init=function(){return this.sourceSpec=[{to:"operator.source",trait:"source"}]};e.prototype.make=function(){e.__super__.make.apply(this,arguments);return this._helpers.bind.make(this.sourceSpec)};e.prototype.made=function(){this.resize();return e.__super__.made.apply(this,arguments)};e.prototype.unmake=function(){return this._helpers.bind.unmake()};e.prototype.resize=function(t){return this.trigger({type:"source.resize"})};return e}(n);e.exports=i},{"../base/source":39}],70:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","readback","entity","active"];e.finals={channels:4};e.prototype.init=function(){this.emitter=this.root=null;return this.active={}};e.prototype.make=function(){var t,r,i,n,o,s,a,u,l,h;e.__super__.make.apply(this,arguments);this._compute("readback.data",function(t){return function(){var e;return(e=t.readback)!=null?e.data:void 0}}(this));this._compute("readback.items",function(t){return function(){var e;return(e=t.readback)!=null?e.items:void 0}}(this));this._compute("readback.width",function(t){return function(){var e;return(e=t.readback)!=null?e.width:void 0}}(this));this._compute("readback.height",function(t){return function(){var e;return(e=t.readback)!=null?e.height:void 0}}(this));this._compute("readback.depth",function(t){return function(){var e;return(e=t.readback)!=null?e.depth:void 0}}(this));this._helpers.bind.make([{to:"operator.source",trait:"source"}]);if(this.bind.source==null){return}s=this.props,l=s.type,t=s.channels,i=s.expr;this.root=this._inherit("root");this._listen("root","root.update",this.update);a=this.bind.source.getDimensions(),o=a.items,h=a.width,n=a.height,r=a.depth;u=this.bind.source.sourceShader(this._shaders.shader());this.readback=this._renderables.make("readback",{map:u,items:o,width:h,height:n,depth:r,channels:t,type:l});if(i!=null){this.readback.setCallback(i)}return this._helpers.active.make()};e.prototype.unmake=function(){if(this.readback!=null){this.readback.dispose();this.readback=null;this.root=null;this.emitter=null;this.active={}}this._helpers.active.unmake();return this._helpers.bind.unmake()};e.prototype.update=function(){var t;if(this.readback==null){return}if(this.isActive){this.readback.update((t=this.root)!=null?t.getCamera():void 0);this.readback.post();if(this.props.expr!=null){return this.readback.iterate()}}};e.prototype.resize=function(){var t,e,r,i,n,o,s,a;if(this.readback==null){return}i=this.bind.source.getActiveDimensions(),r=i.items,a=i.width,e=i.height,t=i.depth;this.readback.setActive(r,a,e,t);this.strideI=n=r;this.strideJ=o=n*a;return this.strideK=s=o*e};e.prototype.change=function(t,e,r){if(t["readback.type"]){return this.rebuild()}if(t["readback.expr"]&&this.readback){return this.readback.setCallback(this.props.expr)}};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],71:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./operator");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","repeat"];e.prototype.indexShader=function(t){t.pipe(this.operator);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){t.pipe(this.operator);return e.__super__.sourceShader.call(this,t)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e;e=this.resample;return{items:e.items*t.items,width:e.width*t.width,height:e.height*t.height,depth:e.depth*t.depth}};e.prototype.make=function(){var t,r;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}this.resample={};r={repeatModulus:this._attributes.make(this._types.vec4())};this.repeatModulus=r.repeatModulus;t=this._shaders.shader();t.pipe("repeat.position",r);return this.operator=t};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.resize=function(){var t;if(this.bind.source!=null){t=this.bind.source.getActiveDimensions();this.repeatModulus.value.set(t.width,t.height,t.depth,t.items)}return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){var i,n,o,s,a;if(e["operator"]||e["repeat"]){return this.rebuild()}if(r){s=["items","width","height","depth"];a=[];for(i=0,o=s.length;i<o;i++){n=s[i];a.push(this.resample[n]=this.props[n])}return a}};return e}(i);e.exports=n},{"./operator":69}],72:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./operator");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","resample","sampler:x","sampler:y","sampler:z","sampler:w","include"];e.prototype.indexShader=function(t){t.pipe(this.indexer);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){return t.pipe(this.operator)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e,r,i;i=this.resampled;e=this.centered;r=this.padding;if(this.relativeSize){if(!e.items){t.items--}if(!e.width){t.width--}if(!e.height){t.height--}if(!e.depth){t.depth--}if(i.items!=null){t.items*=i.items}if(i.width!=null){t.width*=i.width}if(i.height!=null){t.height*=i.height}if(i.depth!=null){t.depth*=i.depth}if(!e.items){t.items++}if(!e.width){t.width++}if(!e.height){t.height++}if(!e.depth){t.depth++}t.items-=r.items*2;t.width-=r.width*2;t.height-=r.height*2;t.depth-=r.depth*2}else{if(i.items!=null){t.items=i.items}if(i.width!=null){t.width=i.width}if(i.height!=null){t.height=i.height}if(i.depth!=null){t.depth=i.depth}}t.items=Math.max(0,Math.floor(t.items));t.width=Math.max(0,Math.floor(t.width));t.height=Math.max(0,Math.floor(t.height));t.depth=Math.max(0,Math.floor(t.depth));return t};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:true}]);m=this.props,l=m.indices,i=m.channels;b=this.bind.shader;v=this.props,x=v.sample,T=v.size,h=v.items,M=v.width,s=v.height,n=v.depth;y=x===this.node.attributes["resample.sample"]["enum"].relative;E=T===this.node.attributes["resample.size"]["enum"].relative;this.resampled={};if(h!=null){this.resampled.items=h}if(M!=null){this.resampled.width=M}if(s!=null){this.resampled.height=s}if(n!=null){this.resampled.depth=n}this.centered={};this.centered.items=this.props.centeredW;this.centered.width=this.props.centeredX;this.centered.height=this.props.centeredY;this.centered.depth=this.props.centeredZ;this.padding={};this.padding.items=this.props.paddingW;this.padding.width=this.props.paddingX;this.padding.height=this.props.paddingY;this.padding.depth=this.props.paddingZ;d=this._shaders.shader();u=this._shaders.shader();w=[null,this._types.number,this._types.vec2,this._types.vec3,this._types.vec4][l];R={dataSize:this._attributes.make(w(0,0,0,0)),dataResolution:this._attributes.make(w(0,0,0,0)),targetSize:this._attributes.make(w(0,0,0,0)),targetResolution:this._attributes.make(w(0,0,0,0)),resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),resampleBias:this._attributes.make(this._types.vec4(0,0,0,0))};this.dataResolution=R.dataResolution;this.dataSize=R.dataSize;this.targetResolution=R.targetResolution;this.targetSize=R.targetSize;this.resampleFactor=R.resampleFactor;this.resampleBias=R.resampleBias;_=h!=null||M!=null||s!=null||n!=null;d.pipe("resample.padding",R);H=[];t=false;g=["width","height","depth","items"];for(a=f=0,p=g.length;f<p;a=++f){c=g[a];r=this.centered[c];t||(t=r);H[a]=r?"0.5":"0.0"}if(t){H="vec4("+H+")";d.pipe(o.GLSL.binaryOperator(4,"+",vec4));if(_){u.pipe(o.GLSL.binaryOperator(4,"+",vec4))}}if(y){if(_){d.pipe("resample.relative",R);u.pipe("resample.relative",R)}else{u.pipe(o.GLSL.identity("vec4"))}}if(b!=null){if(l!==4){d.pipe(o.GLSL.truncateVec(4,l))}d.callback();if(l!==4){d.pipe(o.GLSL.extendVec(l,4))}if(t){d.pipe(o.GLSL.binaryOperator(4,"-",H))}d.pipe(this.bind.source.sourceShader(this._shaders.shader()));if(i!==4){d.pipe(o.GLSL.truncateVec(4,i))}d.join();if(this.bind.shader!=null){d.pipe(this.bind.shader.shaderBind(R))}if(i!==4){d.pipe(o.GLSL.extendVec(i,4))}}else{if(t){d.pipe(o.GLSL.binaryOperator(4,"-",H))}d.pipe(this.bind.source.sourceShader(this._shaders.shader()))}if(t&&_){u.pipe(o.GLSL.binaryOperator(4,"-",H))}this.operator=d;this.indexer=u;this.indices=l;this.relativeSample=y;return this.relativeSize=E};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this.operator=null};e.prototype.resize=function(){var t,r,i,n,o,s,a,u,l,h,f,c,p,d,m;if(this.bind.source==null){return}s=this.bind.source.getActiveDimensions();m=this.getActiveDimensions();t=function(t){return function(e){var r,i,n;r=t.centered[e];i=t.padding[e];m[e]+=i*2;n=r?s[e]/Math.max(1,m[e]):Math.max(1,s[e]-1)/Math.max(1,m[e]-1);return[n,i]}}(this);u=t("width"),d=u[0],o=u[1];l=t("height"),c=l[0],i=l[1];h=t("depth"),a=h[0],r=h[1];f=t("items"),p=f[0],n=f[1];if(this.indices===1){this.dataResolution.value=1/s.width;this.targetResolution.value=1/m.width;this.dataSize.value=s.width;this.targetSize.value=m.width}else{this.dataResolution.value.set(1/s.width,1/s.height,1/s.depth,1/s.items);this.targetResolution.value.set(1/m.width,1/m.height,1/m.depth,1/m.items);this.dataSize.value.set(s.width,s.height,s.depth,s.items);this.targetSize.value.set(m.width,m.height,m.depth,m.items)}this.resampleFactor.value.set(d,c,a,p);this.resampleBias.value.set(o,i,r,n);return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["operator"]||e["resample"]||e["sampler"]||e["include"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],73:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./operator");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","slice"];e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype.sourceShader=function(t){t.pipe("slice.position",this.uniforms);return this.bind.source.sourceShader(t)};e.prototype._resolve=function(t,e){var r,i,n,o,s;o=this.props[t];r=e[t];if(o==null){return[0,r]}n=function(t,e){if(t<0){return e+t}else{return t}};s=n(Math.round(o.x),r);i=n(Math.round(o.y),r);i=Math.max(s,i);return[s,i-s]};e.prototype._resample=function(t){t.width=this._resolve("width",t)[1];t.height=this._resolve("height",t)[1];t.depth=this._resolve("depth",t)[1];t.items=this._resolve("items",t)[1];return t};e.prototype.make=function(){e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}return this.uniforms={sliceOffset:this._attributes.make(this._types.vec4())}};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.resize=function(){var t;if(this.bind.source==null){return}t=this.bind.source.getActiveDimensions();this.uniforms.sliceOffset.value.set(this._resolve("width",t)[0],this._resolve("height",t)[0],this._resolve("depth",t)[0],this._resolve("items",t)[0]);return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["operator"]){return this.rebuild()}if(e["slice"]){return this.resize()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],74:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./operator");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","split"];e.prototype.indexShader=function(t){t.pipe(this.operator);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){t.pipe(this.operator);return e.__super__.sourceShader.call(this,t)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m;h=this.order;e=this.axis;c=this.overlap;u=this.length;m=this.stride;s=["width","height","depth","items"];l=h.map(function(t){return s[t-1]});n=h.indexOf(e);d=function(){var e,i,n;n=[];for(e=0,i=l.length;e<i;e++){r=l[e];n.push(t[r])}return n}();p=Math.floor((d[n]-c)/m);d.splice(n,1,u,p);d=d.slice(0,4);f={};for(i=o=0,a=l.length;o<a;i=++o){r=l[i];f[r]=d[i]}return f};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}n=this.props.order;t=this.props.axis;s=this.props.overlap;i=this.props.length;a=n.join("");if(t==null){t=n[0]}r=a.indexOf(t);h=a[r]+((u=a[r+1])!=null?u:0);l=a.replace(h[1],"").replace(h[0],"0")+"0";s=Math.min(i-1,s);f=i-s;p={splitStride:this._attributes.make(this._types.number(f))};c=this._shaders.shader();c.require(o.GLSL.swizzleVec4(h,2));c.require(o.GLSL.swizzleVec4(l,4));c.require(o.GLSL.injectVec4(r));c.pipe("split.position",p);c.pipe(o.GLSL.invertSwizzleVec4(n));this.operator=c;this.order=n;this.axis=t;this.overlap=s;this.length=i;return this.stride=f};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.change=function(t,e,r){if(t["split.axis"]||t["split.order"]||e["operator"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],75:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./operator");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","spread"];e.prototype.sourceShader=function(t){return t.pipe(this.operator)};e.prototype.make=function(){var t,r;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}r={spreadMatrix:this._attributes.make(this._types.mat4()),spreadOffset:this._attributes.make(this._types.vec4())};this.spreadMatrix=r.spreadMatrix;this.spreadOffset=r.spreadOffset;t=this._shaders.shader();t.require(this.bind.source.sourceShader(this._shaders.shader()));t.pipe("spread.position",r);return this.operator=t};e.prototype.unmake=function(){return e.__super__.unmake.apply(this,arguments)};e.prototype.resize=function(){this.update();return e.__super__.resize.apply(this,arguments)};e.prototype.update=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E;i=this.bind.source.getFutureDimensions();f=this.spreadMatrix.value;n=f.elements;p=["width","height","depth","items"];t=["alignWidth","alignHeight","alignDepth","alignItems"];g=this.props.unit;y=this.node.attributes["spread.unit"]["enum"];h=function(){switch(g){case y.relative:return function(t,e,r,o){return n[e*4+r]=o/Math.max(1,i[t]-1)};case y.absolute:return function(t,e,r,i){return n[e*4+r]=i}}}();m=[];for(o=s=0,l=p.length;s<l;o=++s){u=p[o];v=this.props[u];e=this.props[t[o]];if(v!=null){r=(d=i[u])!=null?d:1;c=-(r-1)*(.5-e*.5)}else{c=0}this.spreadOffset.value.setComponent(o,c);m.push(function(){var t,e,r;r=[];for(a=t=0;t<=3;a=++t){E=(e=v!=null?v.getComponent(a):void 0)!=null?e:0;r.push(n[o*4+a]=h(u,o,a,E))}return r}())}return m};e.prototype.change=function(t,e,r){if(e["operator"]){return this.rebuild()}if(e["spread"]){return this.update()}};return e}(i);e.exports=n},{"./operator":69}],76:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./operator");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","subdivide"];e.prototype.indexShader=function(t){t.pipe(this.indexer);return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){return t.pipe(this.operator)};e.prototype.getDimensions=function(){return this._resample(this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._resample(this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._resample(this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._resample(this.bind.source.getIndexDimensions())};e.prototype._resample=function(t){var e;e=this.resampled;t.items--;t.width--;t.height--;t.depth--;if(e.items!=null){t.items*=e.items}if(e.width!=null){t.width*=e.width}if(e.height!=null){t.height*=e.height}if(e.depth!=null){t.depth*=e.depth}t.items++;t.width++;t.height++;t.depth++;return t};e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}p=this.props,g=p.size,a=p.items,E=p.width,r=p.height,t=p.depth,f=p.lerp;this.resampled={};if(a!=null){this.resampled.items=a}if(E!=null){this.resampled.width=E}if(r!=null){this.resampled.height=r}if(t!=null){this.resampled.depth=t}c=this._shaders.shader();s=this._shaders.shader();y={resampleFactor:this._attributes.make(this._types.vec4(0,0,0,0)),subdivideBevel:this.node.attributes["subdivide.bevel"]};this.resampleFactor=y.resampleFactor;this.resampleBias=y.resampleBias;m=a!=null||E!=null||r!=null||t!=null;if(m){c.pipe("resample.relative",y);s.pipe("resample.relative",y)}else{c.pipe(o.GLSL.identity("vec4"));s.pipe(o.GLSL.identity("vec4"))}v=this.bind.source.sourceShader(this._shaders.shader());f=f?".lerp":"";d=["width","height","depth","items"];for(i=u=0,h=d.length;u<h;i=++u){l=d[i];n="subdivide."+l+f;if(this.props[l]!=null){v=this._shaders.shader().require(v);v.pipe(n,y)}}c.pipe(v);this.operator=c;return this.indexer=s};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this.operator=null};e.prototype.resize=function(){var t,r,i,n,o,s,a;if(this.bind.source==null){return}r=this.bind.source.getActiveDimensions();a=this.getActiveDimensions();t=function(t){return Math.max(1,r[t]-1)/Math.max(1,a[t]-1)};s=t("width");n=t("height");i=t("depth");o=t("items");this.resampleFactor.value.set(s,n,i,o);return e.__super__.resize.apply(this,arguments)};e.prototype.change=function(t,e,r){if(e["operator"]||e["subdivide"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],77:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./operator");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","swizzle"];e.prototype.sourceShader=function(t){t=e.__super__.sourceShader.call(this,t);if(this.swizzler){t.pipe(this.swizzler)}return t};e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}t=this.props.order;if(t.join()!=="1234"){return this.swizzler=o.GLSL.swizzleVec4(t,4)}};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this.swizzler=null};e.prototype.change=function(t,e,r){if(e["swizzle"]||e["operator"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],78:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("./operator");o=t("../../../util");s={1:"width",2:"height",3:"depth",4:"items"};n=function(t){a(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","source","index","transpose"];e.prototype.indexShader=function(t){if(this.swizzler){t.pipe(this.swizzler)}return e.__super__.indexShader.call(this,t)};e.prototype.sourceShader=function(t){if(this.swizzler){t.pipe(this.swizzler)}return e.__super__.sourceShader.call(this,t)};e.prototype.getDimensions=function(){return this._remap(this.transpose,this.bind.source.getDimensions())};e.prototype.getActiveDimensions=function(){return this._remap(this.transpose,this.bind.source.getActiveDimensions())};e.prototype.getFutureDimensions=function(){return this._remap(this.transpose,this.bind.source.getFutureDimensions())};e.prototype.getIndexDimensions=function(){return this._remap(this.transpose,this.bind.source.getIndexDimensions())};e.prototype._remap=function(t,e){var r,i,n,o,a,u;o={};for(i=n=0;n<=3;i=++n){r=s[i+1];u=s[t[i]];o[r]=(a=e[u])!=null?a:1}return o};e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);if(this.bind.source==null){return}t=this.props.order;if(t.join()!=="1234"){this.swizzler=o.GLSL.invertSwizzleVec4(t)}this.transpose=t;return this.trigger({type:"source.rebuild"})};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);return this.swizzler=null};e.prototype.change=function(t,e,r){if(e["transpose"]||e["operator"]){return this.rebuild()}};return e}(i);e.exports=n},{"../../../util":166,"./operator":69}],79:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","object","visible","overlay","dom","attach","position"];e.prototype.init=function(){this.emitter=this.root=null;return this.active={}};e.prototype.make=function(){var t,r,i,n,o,s,a,u,l;e.__super__.make.apply(this,arguments);this._helpers.bind.make([{to:"dom.html",trait:"html"},{to:"dom.points",trait:"source"}]);if(!(this.bind.points!=null&&this.bind.html!=null)){return}this.root=this._inherit("root");this._listen("root","root.update",this.update);this._listen("root","root.post",this.post);s=this.bind.points.getDimensions();i=this.bind.html.getDimensions();o=Math.min(s.items,i.items);l=Math.min(s.width,i.width);r=Math.min(s.height,i.height);t=Math.min(s.depth,i.depth);a=this.bind.points.sourceShader(this._shaders.shader());a=this._helpers.position.pipeline(a);u=this._shaders.shader({globals:["projectionMatrix"]});u.pipe("project.readback");a.pipe(u);n=this._shaders.shader();this.readback=this._renderables.make("readback",{map:a,indexer:n,items:o,width:l,height:r,depth:t,channels:4,stpq:true});this.dom=this._overlays.make("dom");this.dom.hint(o*l*r*t*2);this.readback.setCallback(this.emitter=this.callback(this.bind.html.nodes()));return this._helpers.visible.make()};e.prototype.unmake=function(){if(this.readback!=null){this.readback.dispose();this.dom.dispose();this.readback=this.dom=null;this.root=null;this.emitter=null;this.active={}}this._helpers.bind.unmake();return this._helpers.visible.unmake()};e.prototype.update=function(){var t;if(this.readback==null){return}if(this.props.visible){this.readback.update((t=this.root)!=null?t.getCamera():void 0);this.readback.post();return this.readback.iterate()}};e.prototype.post=function(){if(this.readback==null){return}return this.dom.render(this.isVisible?this.emitter.nodes():[])};e.prototype.callback=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T;_=this._inherit("unit").getUnitUniforms();x=_.viewWidth;u=_.viewHeight;e=this.node.attributes["dom.attributes"];d=this.node.attributes["dom.size"];T=this.node.attributes["dom.zoom"];i=this.node.attributes["dom.color"];c=this.node.attributes["dom.outline"];p=this.node.attributes["dom.pointerEvents"];f=this.node.attributes["overlay.opacity"];b=this.node.attributes["overlay.zIndex"];h=this.node.attributes["attach.offset"];o=this.node.attributes["attach.depth"];m=this.node.attributes["attach.snap"];s=this.dom.el;l=[];E=null;r=null;v=g=y=0;n="";a=function(i,n,a,c,p,d,_,b){var w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B;k=b+v*p+g*d+y*_;H=t[k];M=c<0;A=1/c;S=1+(A-1)*o.value;O=M?0:S;C=+h.value.x*O;L=+h.value.y*O;U=(i+1)*x.value*.5+C;B=(n-1)*u.value*.5+L;U/=T.value;B/=T.value;if(m.value){U=Math.round(U);B=Math.round(B)}R=Math.min(.999,M?0:f.value);P={className:r,style:{transform:"translate3d("+U+"px, "+-B+"px, "+(1-c)+"px) translate(-50%, -50%) scale("+O+","+O+")",opacity:R}};for(_ in E){F=E[_];P.style[_]=F}w=e.value;if(w!=null){D=w.style;for(_ in w){F=w[_];if(_!=="style"&&_!=="className"){P[_]=F}}if(D!=null){for(_ in D){F=D[_];P.style[_]=F}}}P.className+=" "+((z=w!=null?w.className:void 0)!=null?z:"mathbox-label");return l.push(s("div",P,H))};a.reset=function(t){return function(){var e,o,s;l=[];s=[t.strideI,t.strideJ,t.strideK],v=s[0],g=s[1],y=s[2];e=i.value;o=function(t){return Math.floor(t*255)};n=e?"rgb("+[o(e.x),o(e.y),o(e.z)]+")":"";r="mathbox-outline-"+Math.round(c.value);E={};if(e){E.color=n}E.fontSize=d.value+"px";if(T.value!==1){E.zoom=T.value}if(b.value>0){E.zIndex=b.value}if(p.value){return E.pointerEvents="auto"}}}(this);a.nodes=function(){return l};return a};e.prototype.resize=function(){var t,e,r,i,n,o,s,a,u;if(this.readback==null){return}n=this.bind.points.getActiveDimensions();r=this.bind.html.getActiveDimensions();i=Math.min(n.items,r.items);u=Math.min(n.width,r.width);e=Math.min(n.height,r.height);t=Math.min(n.depth,r.depth);this.readback.setActive(i,u,e,t);this.strideI=o=r.items;this.strideJ=s=o*r.width;return this.strideK=a=s*r.height};e.prototype.change=function(t,e,r){if(t["dom.html"]||t["dom.points"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],80:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("../data/voxel");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","voxel","html"];e.finals={channels:1};e.prototype.init=function(){e.__super__.init.apply(this,arguments);return this.storage="pushBuffer"};e.prototype.make=function(){var t,r,i,n,o;e.__super__.make.apply(this,arguments);n=this.getDimensions(),i=n.items,o=n.width,r=n.height,t=n.depth;this.dom=this._overlays.make("dom");return this.dom.hint(i*o*r*t)};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.dom!=null){this.dom.dispose();return this.dom=null}};e.prototype.update=function(){return e.__super__.update.apply(this,arguments)};e.prototype.change=function(t,r,i){if(r["html"]){return this.rebuild()}return e.__super__.change.call(this,t,r,i)};e.prototype.nodes=function(){return this.buffer.read()};e.prototype.callback=function(t){var e;e=this.dom.el;if(t.length<=6){return function(r,i,n,o,s){return t(r,e,i,n,o,s)}}else{return function(r){return function(i,n,o,s,a){return t(i,e,n,o,s,a,r.bufferClock,r.bufferStep)}}(this)}};return e}(o);e.exports=i},{"../../../util":166,"../data/voxel":52}],81:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./transition");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","transition","vertex","move","visible","active"];e.prototype.make=function(){var t,r,i;e.__super__.make.apply(this,arguments);r={moveFrom:this.node.attributes["move.from"],moveTo:this.node.attributes["move.to"]};for(t in r){i=r[t];this.uniforms[t]=i}};e.prototype.vertex=function(t,e){var r,i;if(e===this.props.pass){t.pipe("move.position",this.uniforms)}return(r=(i=this._inherit("vertex"))!=null?i.vertex(t,e):void 0)!=null?r:t};return e}(n);e.exports=i},{"./transition":88}],82:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./track");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","track","trigger","play","bind"];e.prototype.init=function(){e.__super__.init.apply(this,arguments);this.skew=null;this.start=null;return this.done=false};e.prototype.reset=function(t){if(t==null){t=true}this.skew=t?0:null;this.start=null;return this.done=false};e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);this._listen("slide","slide.step",function(t){return function(e){var r;r=t.props.trigger;if(r!=null&&e.index===r){return t.reset()}if(r!=null&&e.index===0){return t.reset(false)}}}(this));if(!this.props.trigger||this._inherit("slide")==null){this.reset()}this._listen("root","root.post",this.post);t=this._inherit("clock");return this._listen(t,"clock.tick",function(e){return function(){var r,i,n,o,s,a,u,l,h,f,c,p;h=e.props,n=h.from,p=h.to,f=h.speed,a=h.pace,r=h.delay,l=h.realtime;c=t.getTime();if(e.skew!=null){o=l?c.time:c.clock;i=l?c.delta:c.step;u=f/a;if(e.start==null){e.start=o}e.skew+=i*(u-1);s=Math.max(0,o-e.start+e.skew-r*u);if(e.props.loop){s=s%(p-n)}e.playhead=Math.min(p,n+s)}else{e.playhead=0}return e.update()}}(this))};e.prototype.update=function(){return e.__super__.update.apply(this,arguments)};e.prototype.post=function(){if(this.skew!=null&&this.playhead===this.props.to&&!this.props.loop&&!this.done){return this.node.trigger({type:"play.done"})}};e.prototype.change=function(t,r,i){if(t["trigger.trigger"]||t["play.realtime"]){return this.rebuild()}return e.__super__.change.call(this,t,r,i)};return e}(n);e.exports=i},{"./track":87}],83:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../base/parent");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","present"];e.prototype.init=function(){};e.prototype.make=function(){this.nodes=[];this.steps=[];this.length=0;this.last=[];this.index=0;this.dirty=[];this._listen("root","root.update",this.update);return this._compute("present.length",function(t){return function(){return t.length}}(this))};e.prototype.adopt=function(t){var e;e=t.node;if(this.nodes.indexOf(t)<0){this.nodes.push(e)}return this.dirty.push(t)};e.prototype.unadopt=function(t){var e;e=t.node;this.nodes=this.nodes.filter(function(e){return e!==t});return this.dirty.push(t)};e.prototype.update=function(){var t,e,r,i,n;if(!this.dirty.length){return}i=this.dirty;for(e=0,r=i.length;e<r;e++){t=i[e];this.slideReset(t)}n=this.process(this.nodes),this.steps=n[0],this.indices=n[1];this.length=this.steps.length;this.index=null;this.go(this.props.index);return this.dirty=[]};e.prototype.slideLatch=function(t,e,r){return t.slideLatch(e,r)};e.prototype.slideStep=function(t,e,r){return t.slideStep(this.mapIndex(t,e),r)};e.prototype.slideRelease=function(t,e){return t.slideRelease()};e.prototype.slideReset=function(t){return t.slideReset()};e.prototype.mapIndex=function(t,e){return e-this.indices[t.node._id]};e.prototype.process=function(t){var e,r,i,n,o,s,a,u,l,h,f,c;l=function(t){var e,r,i,n;n=[];for(r=0,i=t.length;r<i;r++){e=t[r];n.push(a(e).filter(o))}return n};c=function(t){return function(e){var r,i,n;n=[];while(e&&(i=[t(e),e],e=i[0],r=i[1],i)){n.push(r)}return n}};a=c(function(t){if(t.parent.traits.hash.present){return null}else{return t.parent}});o=function(e){return t.indexOf(e)>=0};n=function(t,e){var r,i,n,o,s,a;r=t.length;i=e.length;n=r-i;if(n!==0){return false}n=Math.min(r,i);for(o=s=a=n-1;a<=0?s<0:s>0;o=a<=0?++s:--s){if(t[o]!==e[o]){return false}}return true};s=function(t){return t.sort(function(t,e){var r,i,n,o,s,a,u,l,h,f;r=t.length;i=e.length;n=Math.min(r,i);for(a=u=1,f=n;1<=f?u<=f:u>=f;a=1<=f?++u:--u){l=t[r-a];h=e[i-a];o=l.props.order;s=h.props.order;if(o!=null||s!=null){if(o!=null&&s!=null&&(n=o-s)!==0){return n}if(o!=null){return-1}if(s!=null){return 1}}if(h.order!==l.order){return h.order-l.order}}n=r-i;if(n!==0){return n}return 0})};h=function(t){var e,r,i,n,o,s;o=[];e=[];for(r=0,i=t.length;r<i;r++){s=t[r];((n=s[0]).props.steps!=null?o:e).push(s)}return[o,e]};r=function(t){var r,n,o,s,a,u,l,h,f,c,p,d;f=t[0],r=t[1];h=100;o={};d=[];c=function(t,e){var r,i,n,s,a,u,l,f,c,p,m,v;c=(u=t[0]).props;l=t[1];f=l!=null?o[l._id]:0;r=e;i=c.from!=null?f+c.from:r-c.early;v=c.to!=null?f+c.to:r+c.steps+c.late;i=Math.max(0,i);v=Math.min(h,v);if(o[a=u._id]==null){o[a]=i}for(n=s=p=i,m=v;p<=m?s<m:s>m;n=p<=m?++s:--s){d[n]=(d[n]!=null?d[n]:d[n]=[]).concat(t)}return c.steps};n=0;for(s=0,u=f.length;s<u;s++){p=f[s];n+=c(p,n)}for(a=0,l=r.length;a<l;a++){p=r[a];c(p,0)}d=function(){var t,r,n;n=[];for(t=0,r=d.length;t<r;t++){p=d[t];n.push(i(e(p)))}return n}();return[d,o]};e=function(t){var e,r,i,n,o;if(t){o=[];for(e=r=0,i=t.length;r<i;e=++r){n=t[e];if(t.indexOf(n)===e){o.push(n)}}return o}else{return[]}};i=function(t){return t.sort(function(t,e){return t.order-e.order})};u=l(t);f=s(u);return r(h(f))};e.prototype.go=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D;t=Math.max(0,Math.min(this.length+1,+t||0));l=this.last;e=(H=this.steps[t-1])!=null?H:[];z=this.props.directed?t-this.index:1;this.index=t;n=function(){var t,r,i;i=[];for(t=0,r=e.length;t<r;t++){x=e[t];if(this.last.indexOf(x)<0){i.push(x)}}return i}.call(this);o=function(){var t,r,i,n;i=this.last;n=[];for(t=0,r=i.length;t<r;t++){x=i[t];if(e.indexOf(x)<0){n.push(x)}}return n}.call(this);P=function(){var t,r,i;i=[];for(t=0,r=e.length;t<r;t++){x=e[t];if(n.indexOf(x)<0&&o.indexOf(x)<0){i.push(x)}}return i}();r=function(t){return t.sort(function(t,e){return t.order-e.order})};i=function(t){return t.sort(function(t,e){return e.order-t.order})};D=function(t){return t.toString()};M=r(n);for(s=0,h=M.length;s<h;s++){x=M[s];this.slideLatch(x.controller,true,z)}S=r(P);for(a=0,f=S.length;a<f;a++){x=S[a];this.slideLatch(x.controller,null,z)}k=r(o);for(u=0,c=k.length;u<c;u++){x=k[u];this.slideLatch(x.controller,false,z)}for(E=0,p=n.length;E<p;E++){x=n[E];this.slideStep(x.controller,t,z)}for(_=0,d=P.length;_<d;_++){x=P[_];this.slideStep(x.controller,t,z)}for(b=0,m=o.length;b<m;b++){x=o[b];this.slideStep(x.controller,t,z)}A=i(n);for(T=0,v=A.length;T<v;T++){x=A[T];this.slideRelease(x.controller)}C=i(P);for(w=0,g=C.length;w<g;w++){x=C[w];this.slideRelease(x.controller)}L=i(o);for(R=0,y=L.length;R<y;R++){x=L[R];this.slideRelease(x.controller)}this.last=e};e.prototype.change=function(t,e,r){if(t["present.index"]||r){return this.go(this.props.index)}};return e}(i);e.exports=n},{"../../../util":166,"../base/parent":37}],84:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./transition");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","transition","mask","visible","active"];e.prototype.mask=function(t){var e,r,i;if(t){i=this._shaders.shader();i.pipe(o.GLSL.identity("vec4"));i.fan();i.pipe(t,this.uniforms);i.next();i.pipe("reveal.mask",this.uniforms);i.end();i.pipe("float combine(float a, float b) { return min(a, b); }")}else{i=this._shaders.shader();i.pipe("reveal.mask",this.uniforms)}return(e=(r=this._inherit("mask"))!=null?r.mask(i):void 0)!=null?e:i};return e}(n);e.exports=i},{"../../../util":166,"./transition":88}],85:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("../base/parent");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","slide","visible","active"];e.prototype.make=function(){this._helpers.visible.make();this._helpers.active.make();if(!this._inherit("present")){throw new Error(this.node.toString()+" must be placed inside <present></present>")}return this._inherit("present").adopt(this)};e.prototype.unmake=function(){this._helpers.visible.unmake();this._helpers.active.unmake();return this._inherit("present")(unadopt(this))};e.prototype.change=function(t,e,r){if(t["slide.early"]||t["slide.late"]||t["slide.steps"]||t["slide.from"]||t["slide.to"]){return this.rebuild()}};e.prototype.slideLatch=function(t,e){this.trigger({type:"transition.latch",step:e});if(t!=null){return this._instant(t)}};e.prototype.slideStep=function(t,e){return this.trigger({type:"slide.step",index:t,step:e})};e.prototype.slideRelease=function(){return this.trigger({type:"transition.release"})};e.prototype.slideReset=function(){this._instant(false);return this.trigger({type:"slide.reset"})};e.prototype._instant=function(t){this.setVisible(t);return this.setActive(t)};return e}(i);e.exports=n},{"../base/parent":37}],86:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./track");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","track","step","trigger","bind"];e.prototype.make=function(){var t,r,i,n,o;e.__super__.make.apply(this,arguments);t=this._inherit("clock");if(this.actualIndex==null){this.actualIndex=null}this.animateIndex=this._animator.make(this._types.number(0),{clock:t,realtime:this.props.realtime,step:function(t){return function(e){return t.actualIndex=e}}(this)});if(this.lastIndex==null){this.lastIndex=null}this.animateStep=this._animator.make(this._types.number(0),{clock:t,realtime:this.props.realtime,step:function(t){return function(e){t.playhead=e;return t.update()}}(this)});this.stops=(i=this.props.stops)!=null?i:function(){o=[];for(var t=0,e=this.script.length;0<=e?t<e:t>e;0<=e?t++:t--){o.push(t)}return o}.apply(this);this._listen("slide","slide.reset",function(t){return function(e){return t.lastIndex=null}}(this));return this._listen("slide","slide.step",function(t){return function(e){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T;p=t.props,r=p.delay,i=p.duration,f=p.pace,E=p.speed,c=p.playback,v=p.rewind,g=p.skip,T=p.trigger;a=Math.max(0,Math.min(t.stops.length-1,e.index-T));s=t.playhead;b=t.stops[a];if(t.lastIndex==null&&T){t.lastIndex=a;t.animateStep.set(b);t.animateIndex.set(a);return}l=(d=(m=t.actualIndex)!=null?m:t.lastIndex)!=null?d:0;_=a-l;y=t.stops.slice(Math.min(l,a),Math.max(l,a));o=0;l=y.shift();for(u=0,h=y.length;u<h;u++){x=y[u];if(l===x){o++}l=x}t.lastIndex=a;n=E*(e.step>=0?1:v);n*=g?Math.max(1,Math.abs(_)-o):1;i+=Math.abs(b-s)*f/n;if(s!==b){t.animateIndex.immediate(a,{delay:r,duration:i,ease:c});return t.animateStep.immediate(b,{delay:r,duration:i,ease:c})}}}(this))};e.prototype.made=function(){return this.update()};e.prototype.unmake=function(){this.animateIndex.dispose();this.animateStep.dispose();this.animateIndex=this.animateStep=null;return e.__super__.unmake.apply(this,arguments)};e.prototype.change=function(t,r,i){if(t["step.stops"]||t["step.realtime"]){return this.rebuild()}return e.__super__.change.call(this,t,r,i)};return e}(n);e.exports=i},{"./track":87}],87:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;n=t("../../primitive");i=t("../../../util").Ease;s=function(t){var e,r,i;r={};for(e in t){i=t[e];if(i instanceof Array){r[e]=i.slice()}else if(i!=null&&typeof i==="object"){r[e]=s(i)}else{r[e]=i}}return r};o=function(t){a(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","track","seek","bind"];e.prototype.init=function(){this.handlers={};this.script=null;this.values=null;this.playhead=0;this.velocity=null;this.section=null;return this.expr=null};e.prototype.make=function(){var t,e,r;this._helpers.bind.make([{to:"track.target",trait:"node",callback:null}]);r=this.props.script;t=this.bind.target.node;this.targetNode=t;return e=this._process(t,r),this.script=e[0],this.values=e[1],this.start=e[2],this.end=e[3],e};e.prototype.unmake=function(){this.unbindExpr();this._helpers.bind.unmake();this.script=this.values=this.start=this.end=this.section=this.expr=null;return this.playhead=0};e.prototype.bindExpr=function(t){var e;this.unbindExpr();this.expr=t;this.targetNode.bind(t,true);e=this.targetNode.clock;return this._attributes.bind(this.measure=function(){var t;t=null;return function(r){return function(){var i;i=e.getTime().step;if(t!=null){r.velocity=(r.playhead-t)/i}return t=r.playhead}}(this)}())};e.prototype.unbindExpr=function(){if(this.expr!=null){this.targetNode.unbind(this.expr,true)}if(this.measure!=null){this._attributes.unbind(this.measure)}return this.expr=this.measure=null};e.prototype._process=function(t,e){var r,i,n,o,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b;if(e instanceof Array){y={};for(i=n=0,h=e.length;n<h;i=++n){_=e[i];y[i]=_}e=y}y=[];for(a in e){_=e[a];if(_==null){_=[]}if(_ instanceof Array){_={key:+a,props:_[0]!=null?s(_[0]):{},expr:_[1]!=null?s(_[1]):{}}}else{if(_.key==null&&!_.props&&!_.expr){_={props:s(_)}}else{_=s(_)}_.key=_.key!=null?+_.key:+a;if(_.props==null){_.props={}}if(_.expr==null){_.expr={}}}y.push(_)}e=y;if(!e.length){return[[],{},0,0]}e.sort(function(t,e){return t.key-e.key});E=e[0].key;r=e[e.length-1].key;for(a in e){_=e[a];if(typeof l!=="undefined"&&l!==null){l.next=_}l=_}l.next=l;e=y;p={};b={};for(a in e){_=e[a];d=_.props;for(o in d){x=d[o];p[o]=true}}for(a in e){_=e[a];m=_.expr;for(o in m){x=m[o];p[o]=true}}for(o in p){p[o]=t.get(o)}try{for(o in p){b[o]=[t.attribute(o).T.make(),t.attribute(o).T.make(),t.attribute(o).T.make()]}}catch(e){console.warn(this.node.toMarkup());c=this.node.toString()+" - Target "+t+" has no `"+o+"` property";throw new Error(c)}g=[];for(u=0,f=e.length;u<f;u++){_=e[u];for(o in p){x=p[o];x=t.validate(o,(v=_.props[o])!=null?v:x);p[o]=_.props[o]=x;if(_.expr[o]!=null&&typeof _.expr[o]!=="function"){console.warn(this.node.toMarkup());c=this.node.toString()+" - Expression `"+_.expr[o]+"` on property `"+o+"` is not a function";throw new Error(c)}}g.push(_)}return[g,b,E,r]};e.prototype.update=function(){var t,e,r,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_;d=this,p=d.playhead,v=d.script;m=this.props,e=m.ease,y=m.seek;c=this.targetNode;if(y!=null){p=y}if(v.length){s=function(){var t,e,r,i,n;r=v[0];for(t=e=0,i=v.length;e<i;t=++e){n=v[t];if(n.key>p){break}r=n}return r};g=this.section;if(!g||p<g.key||p>g.next.key){g=s(v,p)}if(g===this.section){return}this.section=g;a=g;_=g.next;E=a.key;n=_.key;r=function(){switch(e){case"linear":case 0:return i.clamp;case"cosine":case 1:return i.cosine;case"binary":case 2:return i.binary;case"hold":case 3:return i.hold;default:return i.cosine}}();t=c.clock;l=function(e){return function(r){var i;if(e.velocity==null){return e.playhead}i=t.getTime();return e.playhead+e.velocity*(r-i.time)}}(this);u=function(){var t;t=1/Math.max(1e-4,n-E);return function(e){return r((l(e)-E)*t,0,1)}}();f=function(t){return function(e){var r,i,n,o,s,l,h,f;n=a.expr[e];l=_.expr[e];o=a.props[e];h=_.props[e];s=function(){console.warn(c.toMarkup());throw new Error(this.node.toString()+" - Invalid expression result on track `"+e+"`")};i=c.attribute(e);f=t.values[e];r=t._animator;if(n&&l){return function(t,e,o){return function(e,o){var a,h;t[0]=a=i.T.validate(n(e,o),t[0],s);t[1]=h=i.T.validate(l(e,o),t[1],s);return t[2]=r.lerp(i.T,a,h,u(e),t[2])}}(f,a,_)}else if(n){return function(t,e,o){return function(e,o){var a;t[0]=a=i.T.validate(n(e,o),t[0],s);return t[1]=r.lerp(i.T,a,h,u(e),t[1])}}(f,a,_)}else if(l){return function(t,e,n){return function(e,n){var a;t[0]=a=i.T.validate(l(e,n),t[0],s);return t[1]=r.lerp(i.T,o,a,u(e),t[1])}}(f,a,_)}else{return function(t,e,n){return function(e,n){return t[0]=r.lerp(i.T,o,h,u(e),t[0])}}(f,a,_)}}}(this);o={};for(h in a.expr){if(o[h]==null){o[h]=f(h)}}for(h in _.expr){if(o[h]==null){o[h]=f(h)}}for(h in a.props){if(o[h]==null){o[h]=f(h)}}for(h in _.props){if(o[h]==null){o[h]=f(h)}}return this.bindExpr(o)}};e.prototype.change=function(t,e,r){if(t["track.target"]||t["track.script"]||t["track.mode"]){return this.rebuild()}if(t["seek.seek"]||r){return this.update()}};return e}(n);e.exports=o},{"../../../util":166,"../../primitive":34}],88:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../base/parent");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","transition","transform","mask","visible","active"];e.prototype.init=function(){this.animate=null;this.uniforms=null;this.state={isVisible:true,isActive:true,enter:1,exit:1};this.latched=null;return this.locked=null};e.prototype.make=function(){var t,e,r;this.uniforms={transitionFrom:this._attributes.make(this._types.vec4()),transitionTo:this._attributes.make(this._types.vec4()),transitionActive:this._attributes.make(this._types.bool()),transitionScale:this._attributes.make(this._types.vec4()),transitionBias:this._attributes.make(this._types.vec4()),transitionEnter:this._attributes.make(this._types.number()),transitionExit:this._attributes.make(this._types.number()),transitionSkew:this._attributes.make(this._types.number())};e=this._inherit("slide");r=this._inherit("visible");t=this._inherit("active");this._listen(e,"transition.latch",function(t){return function(e){return t.latch(e.step)}}(this));this._listen(e,"transition.release",function(t){return function(){return t.release()}}(this));this._listen(r,"visible.change",function(t){return function(){return t.update(t.state.isVisible=r.isVisible)}}(this));this._listen(t,"active.change",function(e){return function(){return e.update(e.state.isActive=t.isActive)}}(this));this.animate=this._animator.make(this._types.vec2(1,1),{step:function(t){return function(e){t.state.enter=e.x;t.state.exit=e.y;return t.update()}}(this),complete:function(t){return function(e){return t.complete(e)}}(this)});return this.move=this.props.from!=null||this.props.to!=null};e.prototype.unmake=function(){return this.animate.dispose()};e.prototype.latch=function(t){var e,r,i,n,o,s;this.locked=null;this.latched=n={isVisible:this.state.isVisible,isActive:this.state.isActive,step:t};s=this.isVisible;if(!s){i=n.step>=0;o=i?[0,1]:[1,0],e=o[0],r=o[1];return this.animate.set(e,r)}};e.prototype.release=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d;l=this.latched;p=this.state;this.latched=null;if(l.isVisible!==p.isVisible){u=l.step>=0;d=p.isVisible;h=d?[1,1]:u?[1,0]:[0,1],s=h[0],a=h[1];f=this.props,i=f.duration,n=f.durationEnter,o=f.durationExit;if(n==null){n=i}if(o==null){o=i}i=d*n+!d*o;c=this.props,t=c.delay,e=c.delayEnter,r=c.delayExit;if(e==null){e=t}if(r==null){r=t}t=d*e+!d*r;this.animate.immediate({x:s,y:a},{duration:i,delay:t,ease:"linear"});this.locked={isVisible:true,isActive:l.isActive||p.isActive}}return this.update()};e.prototype.complete=function(t){if(!t){return}this.locked=null;return this.update()};e.prototype.update=function(){var t,e,r,i,n,o,s,a;if(this.latched!=null){return}o=this.props,e=o.enter,r=o.exit;if(e==null){e=this.state.enter}if(r==null){r=this.state.exit}i=e*r;a=i>0;n=i<1;this.uniforms.transitionEnter.value=e;this.uniforms.transitionExit.value=r;this.uniforms.transitionActive.value=n;if(a){a=!!this.state.isVisible}if(this.locked!=null){a=this.locked.isVisible}if(this.isVisible!==a){this.isVisible=a;this.trigger({type:"visible.change"})}t=!!(this.state.isActive||((s=this.locked)!=null?s.isActive:void 0));if(this.isActive!==t){this.isActive=t;return this.trigger({type:"active.change"})}};e.prototype.change=function(t,e,r){var i,n,o,s,a,u,l,h,f;if(t["transition.enter"]||t["transition.exit"]||r){this.update()}if(t["transition.stagger"]||r){a=this.props.stagger;n=a.x<0;o=a.y<0;s=a.z<0;i=a.w<0;l=Math.abs(a.x);h=Math.abs(a.y);f=Math.abs(a.z);u=Math.abs(a.w);this.uniforms.transitionSkew.value=l+h+f+u;this.uniforms.transitionScale.value.set((1-n*2)*l,(1-o*2)*h,(1-s*2)*f,(1-i*2)*u);return this.uniforms.transitionBias.value.set(n*l,o*h,s*f,i*u)}};return e}(i);e.exports=n},{"../../../util":166,"../base/parent":37}],89:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","object","visible","operator","style","compose"];e.defaults={zWrite:false,zTest:false,color:"#ffffff"};e.prototype.init=function(){return this.compose=null};e.prototype.resize=function(){var t,e,r,i,n;if(!(this.compose&&this.bind.source)){return}e=this.bind.source.getActiveDimensions();n=e.width;r=e.height;t=e.depth;i=e.items;return this.remapUVScale.set(n,r)};e.prototype.make=function(){var t,e,r,i;this._helpers.bind.make([{to:"operator.source",trait:"source"}]);if(this.bind.source==null){return}i={remapUVScale:this._attributes.make(this._types.vec2())};this.remapUVScale=i.remapUVScale.value;r=this._shaders.shader();t=this.props.alpha;if(this.bind.source.is("image")){r.pipe("screen.pass.uv",i);r=this.bind.source.imageShader(r)}else{r.pipe("screen.map.xy",i);r=this.bind.source.sourceShader(r)}if(!t){r.pipe("color.opaque")}e=this._helpers.style.uniforms();this.compose=this._renderables.make("screen",{map:r,uniforms:e,linear:true});this._helpers.visible.make();return this._helpers.object.make([this.compose])};e.prototype.made=function(){return this.resize()};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();return this._helpers.object.unmake()};e.prototype.change=function(t,e,r){if(t["operator.source"]||t["compose.alpha"]){return this.rebuild()}};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],90:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../base/parent");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","root","scene","vertex","texture","rtt","source","index","image"];e.defaults={minFilter:"linear",magFilter:"linear",type:"unsignedByte"};e.prototype.init=function(){return this.rtt=this.scene=this.camera=this.width=this.height=this.history=this.rootSize=this.size=null};e.prototype.indexShader=function(t){return t};e.prototype.imageShader=function(t){return this.rtt.shaderRelative(t)};e.prototype.sourceShader=function(t){return this.rtt.shaderAbsolute(t,this.history)};e.prototype.getDimensions=function(){return{items:1,width:this.width,height:this.height,depth:this.history}};e.prototype.getActiveDimensions=function(){return this.getDimensions()};e.prototype.make=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d;this.parentRoot=this._inherit("root");this.rootSize=this.parentRoot.getSize();this._listen(this.parentRoot,"root.pre",this.pre);this._listen(this.parentRoot,"root.update",this.update);this._listen(this.parentRoot,"root.render",this.render);this._listen(this.parentRoot,"root.post",this.post);this._listen(this.parentRoot,"root.camera",this.setCamera);this._listen(this.parentRoot,"root.resize",function(t){return this.resize(t.size)});if(this.rootSize==null){return}s=this.props,o=s.minFilter,n=s.magFilter,h=s.type;a=this.props,p=a.width,e=a.height,i=a.history,l=a.size;u=l===this.node.attributes["rtt.size"]["enum"].relative;d=u?this.rootSize.renderWidth:1;r=u?this.rootSize.renderHeight:1;this.width=Math.round(p!=null?p*d:this.rootSize.renderWidth);this.height=Math.round(e!=null?e*r:this.rootSize.renderHeight);this.history=i;this.aspect=t=this.width/this.height;if(this.scene==null){this.scene=this._renderables.make("scene")}this.rtt=this._renderables.make("renderToTexture",{scene:this.scene,camera:this._context.defaultCamera,width:this.width,height:this.height,frames:this.history,minFilter:o,magFilter:n,type:h});t=p||e?t:this.rootSize.aspect;c=p!=null?p:this.rootSize.viewWidth;f=e!=null?e:this.rootSize.viewHeight;return this.size={renderWidth:this.width,renderHeight:this.height,aspect:t,viewWidth:c,viewHeight:f,pixelRatio:this.height/f}};e.prototype.made=function(){this.trigger({type:"source.rebuild"});if(this.size){return this.trigger({type:"root.resize",size:this.size})}};e.prototype.unmake=function(t){if(this.rtt==null){return}this.rtt.dispose();if(!t){this.scene.dispose()}return this.rtt=this.width=this.height=this.history=null};e.prototype.change=function(t,e,r){if(e["texture"]||t["rtt.width"]||t["rtt.height"]){return this.rebuild()}if(t["root.camera"]||r){this._unattach();this._attach(this.props.camera,"camera",this.setCamera,this,this,true);return this.setCamera()}};e.prototype.adopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this.scene.add(i))}return o};e.prototype.unadopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this.scene.remove(i))}return o};e.prototype.resize=function(t){var e,r,i,n;this.rootSize=t;r=this.props,n=r.width,e=r.height,t=r.size;i=t===this.node.attributes["rtt.size"]["enum"].relative;if(!this.rtt||n==null||e==null||i){return this.rebuild()}};e.prototype.select=function(t){return this._root.node.model.select(t,[this.node])};e.prototype.watch=function(t,e){return this._root.node.model.watch(t,e)};e.prototype.unwatch=function(t){return this._root.node.model.unwatch(t)};e.prototype.pre=function(t){return this.trigger(t)};e.prototype.update=function(t){var e;if((e=this.getOwnCamera())!=null){e.aspect=this.aspect||1;e.updateProjectionMatrix()}return this.trigger(t)};e.prototype.render=function(t){var e;this.trigger(t);return(e=this.rtt)!=null?e.render(this.getCamera()):void 0};e.prototype.post=function(t){return this.trigger(t)};e.prototype.setCamera=function(){var t,e;t=(e=this.select(this.props.camera)[0])!=null?e.controller:void 0;if(this.camera!==t){this.camera=t;this.rtt.camera=this.getCamera();return this.trigger({type:"root.camera"})}else if(!this.camera){return this.trigger({type:"root.camera"})}};e.prototype.getOwnCamera=function(){var t;return(t=this.camera)!=null?t.getCamera():void 0};e.prototype.getCamera=function(){var t;return(t=this.getOwnCamera())!=null?t:this._inherit("root").getCamera()};e.prototype.vertex=function(t,e){if(e===2){return t.pipe("view.position")}if(e===3){return t.pipe("root.position")}return t};return e}(i);e.exports=n},{"../../../util":166,"../base/parent":37}],91:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../../primitive");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","shader"];e.freeform=true;e.prototype.init=function(){return this.shader=null};e.prototype.make=function(){var t,e,r,i,n,o,s,a,u,l,h,f;s=this.props,i=s.language,t=s.code;if(i!=="glsl"){throw new Error("GLSL required")}this._helpers.bind.make([{to:"shader.sources",trait:"source",multiple:true}]);u=this._shaders.fetch(t);h=this._types;f={};o=function(t){return function(t){var e;switch(t){case"i":return h.int();case"f":return h.number();case"v2":return h.vec2();case"v3":return h.vec3();case"v4":return h.vec4();case"m3":return h.mat3();case"m4":return h.mat4();case"t":return h.object();default:e=t.split("");if(e.pop()==="v"){return h.array(o(e.join("")))}else{return null}}}}(this);a=u._signatures.uniform;for(r=0,n=a.length;r<n;r++){e=a[r];if(l=o(e.type)){f[e.name]=l}}return this.reconfigure({props:{uniform:f}})};e.prototype.made=function(){return this.trigger({type:"source.rebuild"})};e.prototype.unmake=function(){return this.shader=null};e.prototype.change=function(t,e,r){if(t["shader.uniforms"]||t["shader.code"]||t["shader.language"]){return this.rebuild()}};e.prototype.shaderBind=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p;if(t==null){t={}}a=this.props,n=a.language,e=a.code;u=this.node.attributes;for(i in u){p=u[i];if(p.type!=null&&p.short!=null&&p.ns==="uniform"){if(t[s=p.short]==null){t[s]=p}}}if((c=this.props.uniforms)!=null){for(i in c){p=c[i];t[i]=p}}h=this._shaders.shader();if(this.bind.sources!=null){l=this.bind.sources;for(r=0,o=l.length;r<o;r++){f=l[r];h.require(f.sourceShader(this._shaders.shader()))}}return h.pipe(e,t)};return e}(i);e.exports=n},{"../../../util":166,"../../primitive":34}],92:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../operator/operator");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","texture","text","format","font"];e.defaults={minFilter:"linear",magFilter:"linear"};e.prototype.init=function(){e.__super__.init.apply(this,arguments);this.atlas=this.buffer=this.used=this.time=null;return this.filled=false};e.prototype.sourceShader=function(t){return this.buffer.shader(t)};e.prototype.textShader=function(t){return this.atlas.shader(t)};e.prototype.textIsSDF=function(){return this.props.sdf>0};e.prototype.textHeight=function(){return this.props.detail};e.prototype.make=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g;this._helpers.bind.make([{to:"operator.source",trait:"raw"}]);h=this.props,l=h.minFilter,u=h.magFilter,d=h.type;f=this.props,o=f.font,p=f.style,m=f.variant,v=f.weight,r=f.detail,c=f.sdf;this.atlas=this._renderables.make("textAtlas",{font:o,size:r,style:p,variant:m,weight:v,outline:c,minFilter:l,magFilter:u,type:d});l=THREE.NearestFilter;u=THREE.NearestFilter;d=THREE.FloatType;i=this.bind.source.getDimensions();a=i.items,g=i.width,s=i.height,e=i.depth;this.buffer=this._renderables.make("voxelBuffer",{width:g,height:s,depth:e,channels:4,items:a,minFilter:l,magFilter:u,type:d});t=this.atlas;n=this.buffer.streamer.emit;this.buffer.streamer.emit=function(e){return t.map(e,n)};this.clockParent=this._inherit("clock");return this._listen("root","root.update",this.update)};e.prototype.made=function(){e.__super__.made.apply(this,arguments);return this.resize()};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.buffer){this.buffer.dispose();this.buffer=null}if(this.atlas){this.atlas.dispose();return this.atlas=null}};e.prototype.update=function(){var t,e,r;e=this.bind.source.rawBuffer();t=this.buffer;if(this.filled&&!this.props.live||!this.through){return}this.time=this.clockParent.getTime();r=this.used;this.atlas.begin();this.used=this.through();this.buffer.write(this.used);this.atlas.end();this.filled=true;if(r!==this.used){return this.trigger({type:"source.resize"})}};e.prototype.change=function(t,e,r){var i,n,o,s,a,u;if(e["font"]){return this.rebuild()}if(t["format.expr"]||t["format.digits"]||t["format.data"]||r){u=this.props,n=u.digits,o=u.expr,i=u.data;if(o==null){if(i!=null){o=function(t,e,r,n,o){return i[o]}}else{o=function(t){return t}}}s=o.length;if(n!=null){o=function(t){return function(e,r,i,o,s,a,u,l,h,f){return+t(e,r,i,o,s,a,u,l,h,f).toPrecision(n)}}(o)}if(s>8){a=function(t){return function(e,r,i,n,s,a,u,l,h,f,c){return e(o(r,i,n,s,a,u,l,h,t.time.clock,t.time.step))}}(this)}else{a=function(t){return function(t,e,r,i,n,s,a,u,l){return t(o(e,r,i,n,s,a,u,l))}}(this)}return this.through=this.bind.source.rawBuffer().through(a,this.buffer)}};return e}(n);e.exports=i},{"../../../util":166,"../operator/operator":69}],93:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../../primitive");o=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","object","visible","style","label","attach","geometry","position"];e.prototype.make=function(){var t,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E;e.__super__.make.apply(this,arguments);this._helpers.bind.make([{to:"label.text",trait:"text"},{to:"geometry.points",trait:"source"},{to:"geometry.colors",trait:"source"}]);if(this.bind.points==null){return}if(this.bind.text==null){return}h=this.bind.points.getDimensions();m=this.bind.text.getDimensions();v=this.bind.text.textIsSDF();s=Math.min(h.items,m.items);E=Math.min(h.width,m.width);n=Math.min(h.height,m.height);i=Math.min(h.depth,m.depth);f=this.bind.points.sourceShader(this._shaders.shader());f=this._helpers.position.pipeline(f);p=this.bind.text.sourceShader(this._shaders.shader());u=this._shaders.shader().pipe("label.map");u.pipe(this.bind.text.textShader(this._shaders.shader()));a={spriteDepth:this.node.attributes["attach.depth"],spriteOffset:this.node.attributes["attach.offset"],spriteSnap:this.node.attributes["attach.snap"],spriteScale:this._attributes.make(this._types.number()),outlineStep:this._attributes.make(this._types.number()),outlineExpand:this._attributes.make(this._types.number()),outlineColor:this.node.attributes["label.background"]};this.spriteScale=a.spriteScale;this.outlineStep=a.outlineStep;this.outlineExpand=a.outlineExpand;c=v?"label.outline":"label.alpha";r=this._shaders.shader().pipe(c,a);if(this.bind.colors){t=this._shaders.shader();this.bind.colors.sourceShader(t)}l=this._helpers.object.mask();d=this._helpers.style.uniforms();y=this._inherit("unit").getUnitUniforms();g=o.JS.merge(y,d,a);this.sprite=this._renderables.make("sprite",{uniforms:g,width:E,height:n,depth:i,items:s,position:f,sprite:p,map:u,combine:r,color:t,mask:l,linear:true});this._helpers.visible.make();return this._helpers.object.make([this.sprite])};e.prototype.unmake=function(){this._helpers.bind.unmake();this._helpers.visible.unmake();this._helpers.object.unmake();return this.sprite=null};e.prototype.resize=function(){var t,e,r,i,n,o;i=this.bind.points.getActiveDimensions();n=this.bind.text.getActiveDimensions();r=Math.min(i.items,n.items);o=Math.min(i.width,n.width);e=Math.min(i.height,n.height);t=Math.min(i.depth,n.depth);return this.sprite.geometry.clip(o,e,t,r)};e.prototype.change=function(t,e,r){var i,n,o,s,a;if(e["geometry"]||t["label.text"]){return this.rebuild()}if(this.bind.points==null){return}a=this.props.size;o=this.props.outline;i=this.props.expand;n=this.bind.text.textHeight();s=a/n;this.outlineExpand.value=i/s*16/255;this.outlineStep.value=o/s*16/255;return this.spriteScale.value=s};return e}(n);e.exports=i},{"../../../util":166,"../../primitive":34}],94:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("../operator/resample");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","bind","operator","resample","sampler:x","sampler:y","sampler:z","sampler:w","include","text"];e.prototype.init=function(){return this.sourceSpec=[{to:"operator.source",trait:"text"}]};e.prototype.textShader=function(t){return this.bind.source.textShader(t)};e.prototype.textIsSDF=function(){var t;return((t=this.bind.source)!=null?t.props.sdf:void 0)>0};e.prototype.textHeight=function(){var t;return(t=this.bind.source)!=null?t.props.detail:void 0};return e}(i);e.exports=n},{"../../../util":166,"../operator/resample":72}],95:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("../data/buffer");s=t("../data/voxel");o=t("../../../util");n=function(t){a(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","buffer","active","data","texture","voxel","text","font"];e.defaults={minFilter:"linear",magFilter:"linear"};e.finals={channels:1};e.prototype.init=function(){e.__super__.init.apply(this,arguments);return this.atlas=null};e.prototype.textShader=function(t){return this.atlas.shader(t)};e.prototype.textIsSDF=function(){return this.props.sdf>0};e.prototype.textHeight=function(){return this.props.detail};e.prototype.make=function(){var t,e,r,n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S;d=this.props,p=d.minFilter,c=d.magFilter,R=d.type;m=this.props,l=m.font,w=m.style,H=m.variant,M=m.weight,s=m.detail,b=m.sdf;this.atlas=this._renderables.make("textAtlas",{font:l,size:s,style:w,variant:H,weight:M,outline:b,minFilter:p,magFilter:c,type:R});this.minFilter=THREE.NearestFilter;this.magFilter=THREE.NearestFilter;this.type=THREE.FloatType;i.prototype.make.call(this);p=(v=this.minFilter)!=null?v:this.props.minFilter;c=(g=this.magFilter)!=null?g:this.props.magFilter;R=(y=this.type)!=null?y:this.props.type;S=this.props.width;h=this.props.height;n=this.props.depth;E=this.props.bufferWidth;_=this.props.bufferHeight;x=this.props.bufferDepth;e=this.props.channels;f=this.props.items;a=this.spec={channels:e,items:f,width:S,height:h,depth:n};this.items=a.items;this.channels=a.channels;r=this.props.data;a=o.Data.getDimensions(r,a);T=this.space;T.width=Math.max(E,a.width||1);T.height=Math.max(_,a.height||1);T.depth=Math.max(x,a.depth||1);this.buffer=this._renderables.make(this.storage,{width:T.width,height:T.height,depth:T.depth,channels:4,items:f,minFilter:p,magFilter:c,type:R});t=this.atlas;u=this.buffer.streamer.emit;return this.buffer.streamer.emit=function(e){return t.map(e,u)}};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);if(this.atlas){this.atlas.dispose();return this.atlas=null}};e.prototype.update=function(){this.atlas.begin();e.__super__.update.apply(this,arguments);return this.atlas.end()};e.prototype.change=function(t,r,i){if(r["font"]){return this.rebuild()}return e.__super__.change.call(this,t,r,i)};return e}(s);e.exports=n},{"../../../util":166,"../data/buffer":45,"../data/voxel":52}],96:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("../base/parent");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","clock","seek","play"];e.prototype.init=function(){this.skew=0;this.last=0;return this.time={now:+new Date/1e3,time:0,delta:0,clock:0,step:0}};e.prototype.make=function(){return this._listen("clock","clock.tick",this.tick)};e.prototype.reset=function(){return this.skew=0};e.prototype.tick=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p;l=this.props,n=l.from,p=l.to,f=l.speed,h=l.seek,o=l.pace,r=l.delay,u=l.realtime;s=this._inherit("clock").getTime();c=u?s.time:s.clock;i=u?s.delta:s.step;a=f/o;this.skew+=i*(a-1);if(this.last>c){this.skew=0}this.time.now=s.now+this.skew;this.time.time=s.time;this.time.delta=s.delta;e=h!=null?h:s.clock+this.skew;this.time.clock=Math.min(p,n+Math.max(0,e-r*a));this.time.step=i*a;this.last=c;return this.trigger(t)};e.prototype.getTime=function(){return this.time};return e}(n);e.exports=i},{"../base/parent":37}],97:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("../base/parent");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","clock","now"];e.prototype.init=function(){var t;this.now=t=+new Date/1e3;this.skew=0;return this.time={now:t,time:0,delta:0,clock:0,step:0}};e.prototype.make=function(){this.clockParent=this._inherit("clock");return this._listen("clock","clock.tick",this.tick)};e.prototype.unmake=function(){return this.clockParent=null};e.prototype.change=function(t,e,r){if(t["date.now"]){return this.skew=0}};e.prototype.tick=function(t){var e,r,i,n,o,s,a;n=this.props,e=n.now,s=n.seek,r=n.pace,a=n.speed;i=this.clockParent.getTime();this.skew+=i.step*r/a;if(s!=null){this.skew=s}this.time.now=this.time.time=this.time.clock=((o=this.props.now)!=null?o:this.now)+this.skew;this.time.delta=this.time.step=i.delta;return this.trigger(t)};e.prototype.getTime=function(){return this.time};return e}(n);e.exports=i},{"../base/parent":37}],98:[function(t,e,r){var i,n;n=t("./types");i={node:{id:n.nullable(n.string()),classes:n.classes()},entity:{active:n.bool(true)},object:{visible:n.bool(true)},unit:{scale:n.nullable(n.number()),fov:n.nullable(n.number()),focus:n.nullable(n.number(1),true)},span:{range:n.nullable(n.vec2(-1,1))},view:{range:n.array(n.vec2(-1,1),4)},view3:{position:n.vec3(),quaternion:n.quat(),rotation:n.vec3(),scale:n.vec3(1,1,1),eulerOrder:n.swizzle("xyz")},view4:{position:n.vec4(),scale:n.vec4(1,1,1,1)},layer:{depth:n.number(1),fit:n.fit("y")},vertex:{pass:n.vertexPass()},fragment:{pass:n.fragmentPass(),gamma:n.bool(false)},transform3:{position:n.vec3(),quaternion:n.quat(),rotation:n.vec3(),eulerOrder:n.swizzle("xyz"),scale:n.vec3(1,1,1),matrix:n.mat4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},transform4:{position:n.vec4(),scale:n.vec4(1,1,1,1),matrix:n.mat4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},camera:{proxy:n.bool(false),position:n.nullable(n.vec3()),quaternion:n.nullable(n.quat()),rotation:n.nullable(n.vec3()),lookAt:n.nullable(n.vec3()),up:n.nullable(n.vec3()),eulerOrder:n.swizzle("xyz"),fov:n.nullable(n.number(1))},polar:{bend:n.number(1),helix:n.number(0)},spherical:{bend:n.number(1)},stereographic:{bend:n.number(1)},interval:{axis:n.axis()},area:{axes:n.swizzle([1,2],2)},volume:{axes:n.swizzle([1,2,3],3)},origin:{origin:n.vec4()},scale:{divide:n.number(10),unit:n.number(1),base:n.number(10),mode:n.scale(),start:n.bool(true),end:n.bool(true),zero:n.bool(true),factor:n.positive(n.number(1)),nice:n.bool(true)},grid:{lineX:n.bool(true),lineY:n.bool(true),crossed:n.bool(false),closedX:n.bool(false),closedY:n.bool(false)},axis:{detail:n.int(1),crossed:n.bool(false)},rawtex:{width:n.nullable(n.positive(n.int(1),true)),height:n.nullable(n.positive(n.int(1),true)),image:n.nullable(n.object()),texture:n.nullable(n.object())},data:{data:n.nullable(n.data()),expr:n.nullable(n.emitter()),bind:n.nullable(n.func()),live:n.bool(true)},buffer:{channels:n["enum"](4,[1,2,3,4]),items:n.int(1),fps:n.nullable(n.int(60)),hurry:n.int(5),limit:n.int(60),realtime:n.bool(false),observe:n.bool(false),aligned:n.bool(false)},sampler:{centered:n.bool(false),padding:n.number(0)},array:{width:n.nullable(n.positive(n.int(1),true)),bufferWidth:n.int(1),history:n.int(1)},matrix:{width:n.nullable(n.positive(n.int(1),true)),height:n.nullable(n.positive(n.int(1),true)),history:n.int(1),bufferWidth:n.int(1),bufferHeight:n.int(1)},voxel:{width:n.nullable(n.positive(n.int(1),true)),height:n.nullable(n.positive(n.int(1),true)),depth:n.nullable(n.positive(n.int(1),true)),bufferWidth:n.int(1),bufferHeight:n.int(1),bufferDepth:n.int(1)},resolve:{expr:n.nullable(n.func()),items:n.int(1)},style:{opacity:n.positive(n.number(1)),color:n.color(),blending:n.blending(),zWrite:n.bool(true),zTest:n.bool(true),zIndex:n.positive(n.round()),zBias:n.number(0),zOrder:n.nullable(n.int())},geometry:{points:n.select(),colors:n.nullable(n.select())},point:{size:n.positive(n.number(4)),sizes:n.nullable(n.select()),shape:n.shape(),optical:n.bool(true),fill:n.bool(true),depth:n.number(1)},line:{width:n.positive(n.number(2)),depth:n.positive(n.number(1)),join:n.join(),stroke:n.stroke(),proximity:n.nullable(n.number(Infinity)),closed:n.bool(false)},mesh:{fill:n.bool(true),shaded:n.bool(false),map:n.nullable(n.select()),lineBias:n.number(5)},strip:{line:n.bool(false)},face:{line:n.bool(false)},arrow:{size:n.number(3),start:n.bool(false),end:n.bool(false)},ticks:{normal:n.vec3(0,0,1),size:n.positive(n.number(10)),epsilon:n.positive(n.number(.001))},attach:{offset:n.vec2(0,-20),snap:n.bool(false),depth:n.number(0)},format:{digits:n.nullable(n.positive(n.number(3))),data:n.nullable(n.data()),expr:n.nullable(n.func()),live:n.bool(true)},font:{font:n.font("sans-serif"),style:n.string(),variant:n.string(),weight:n.string(),detail:n.number(24),sdf:n.number(5)},label:{text:n.select(),size:n.number(16),outline:n.number(2),expand:n.number(0),background:n.color(1,1,1)},overlay:{opacity:n.number(1),zIndex:n.positive(n.round(0))},dom:{points:n.select(),html:n.select(),size:n.number(16),outline:n.number(2),zoom:n.number(1),color:n.nullable(n.color()),attributes:n.nullable(n.object()),pointerEvents:n.bool(false)},texture:{minFilter:n.filter("nearest"),magFilter:n.filter("nearest"),type:n.type("float")},shader:{sources:n.nullable(n.select()),language:n.string("glsl"),code:n.string(),uniforms:n.nullable(n.object())},include:{shader:n.select()},operator:{source:n.select()},spread:{unit:n.mapping(),items:n.nullable(n.vec4()),width:n.nullable(n.vec4()),height:n.nullable(n.vec4()),depth:n.nullable(n.vec4()),alignItems:n.anchor(),alignWidth:n.anchor(),alignHeight:n.anchor(),alignDepth:n.anchor()},grow:{scale:n.number(1),items:n.nullable(n.anchor()),width:n.nullable(n.anchor()),height:n.nullable(n.anchor()),depth:n.nullable(n.anchor())},split:{order:n.transpose("wxyz"),axis:n.nullable(n.axis()),length:n.int(1),overlap:n.int(0)},join:{order:n.transpose("wxyz"),axis:n.nullable(n.axis()),overlap:n.int(0)},swizzle:{order:n.swizzle()},transpose:{order:n.transpose()},repeat:{items:n.number(1),width:n.number(1),height:n.number(1),depth:n.number(1)},slice:{items:n.nullable(n.vec2()),width:n.nullable(n.vec2()),height:n.nullable(n.vec2()),depth:n.nullable(n.vec2())},lerp:{size:n.mapping("absolute"),items:n.nullable(n.number()),width:n.nullable(n.number()),height:n.nullable(n.number()),depth:n.nullable(n.number())},subdivide:{items:n.nullable(n.positive(n.int(),true)),width:n.nullable(n.positive(n.int(),true)),height:n.nullable(n.positive(n.int(),true)),depth:n.nullable(n.positive(n.int(),true)),bevel:n.number(1),lerp:n.bool(true)},resample:{indices:n.number(4),channels:n.number(4),sample:n.mapping(),size:n.mapping("absolute"),items:n.nullable(n.number()),width:n.nullable(n.number()),height:n.nullable(n.number()),depth:n.nullable(n.number())},readback:{type:n.type("float"),expr:n.nullable(n.func()),data:n.data(),channels:n["enum"](4,[1,2,3,4]),items:n.nullable(n.int()),width:n.nullable(n.int()),height:n.nullable(n.int()),depth:n.nullable(n.int())},root:{speed:n.number(1),camera:n.select("[camera]")},inherit:{source:n.select(),traits:n.array(n.string())},rtt:{size:n.mapping("absolute"),width:n.nullable(n.number()),height:n.nullable(n.number()),history:n.int(1)},compose:{alpha:n.bool(false)},present:{index:n.int(1),directed:n.bool(true),length:n.number(0)},slide:{order:n.nullable(n.int(0)),steps:n.number(1),early:n.int(0),late:n.int(0),from:n.nullable(n.int(0)),to:n.nullable(n.int(1))},transition:{stagger:n.vec4(),enter:n.nullable(n.number(1)),exit:n.nullable(n.number(1)),delay:n.number(0),delayEnter:n.nullable(n.number(0)),delayExit:n.nullable(n.number(0)),duration:n.number(.3),durationEnter:n.nullable(n.number(0)),durationExit:n.nullable(n.number(0))},move:{from:n.vec4(),to:n.vec4()},seek:{seek:n.nullable(n.number(0))},track:{target:n.select(),script:n.object({}),ease:n.ease("cosine")},trigger:{trigger:n.nullable(n.int(1),true)},step:{playback:n.ease("linear"),stops:n.nullable(n.array(n.number())),delay:n.number(0),duration:n.number(.3),pace:n.number(0),speed:n.number(1),rewind:n.number(2),skip:n.bool(true),realtime:n.bool(false)},play:{delay:n.number(0),pace:n.number(1),speed:n.number(1),from:n.number(0),to:n.number(Infinity),realtime:n.bool(false),loop:n.bool(false)},now:{now:n.nullable(n.timestamp()),seek:n.nullable(n.number(0)),pace:n.number(1),speed:n.number(1)}};e.exports=i},{"./types":106}],99:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./transform");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","include","fragment","bind"];e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:true}])};e.prototype.unmake=function(){return this._helpers.bind.unmake()};e.prototype.change=function(t,e,r){if(e["include"]||t["fragment.gamma"]){return this.rebuild()}};e.prototype.fragment=function(t,r){if(this.bind.shader!=null){if(r===this.props.pass){if(this.props.gamma){t.pipe("mesh.gamma.out")}t.pipe(this.bind.shader.shaderBind());t.split();if(this.props.gamma){t.pipe("mesh.gamma.in")}t.pass()}}return e.__super__.fragment.call(this,t,r)};return e}(n);e.exports=i},{"./transform":102}],100:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./transform");o=Math.PI;i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","vertex","layer"];e.prototype.make=function(){this._listen("root","root.resize",this.update);return this.uniforms={layerScale:this._attributes.make(this._types.vec4()),layerBias:this._attributes.make(this._types.vec4())}};e.prototype.update=function(){var t,e,r,i,n,s,a,u,l,h,f,c;r=this._inherit("root").getCamera();c=this._inherit("root").getSize();e=(u=r.aspect)!=null?u:1;s=(l=r.fov)!=null?l:1;a=Math.tan(s*o/360);t=this.node.attributes["layer.fit"]["enum"];h=this.props,n=h.fit,i=h.depth,f=h.scale;switch(n){case t.contain:n=e>1?t.y:t.x;break;case t.cover:n=e>1?t.x:t.y}switch(n){case t.x:this.uniforms.layerScale.value.set(a*e,a*e);break;case t.y:this.uniforms.layerScale.value.set(a,a)}return this.uniforms.layerBias.value.set(0,0,-i,0)};e.prototype.change=function(t,e,r){if(t["layer.fit"]||t["layer.depth"]||r){return this.update()}};e.prototype.vertex=function(t,e){if(e===2){return t.pipe("layer.position",this.uniforms)}if(e===3){return t.pipe("root.position")}return t};return e}(n);e.exports=i},{"./transform":102}],101:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("../base/parent");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","include","mask","bind"];e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:true}])};e.prototype.unmake=function(){return this._helpers.bind.unmake()};e.prototype.change=function(t,e,r){if(e["include"]){return this.rebuild()}};e.prototype.mask=function(t){var e,r,i;if(this.bind.shader!=null){if(t){i=this._shaders.shader();i.pipe(Util.GLSL.identity("vec4"));i.fan();i.pipe(t);i.next();i.pipe(this.bind.shader.shaderBind());i.end();i.pipe("float combine(float a, float b) { return min(a, b); }")}else{i=this._shaders.shader();i.pipe(this.bind.shader.shaderBind())}}else{i=t}return(e=(r=this._inherit("mask"))!=null?r.mask(i):void 0)!=null?e:i};return e}(n);e.exports=i},{"../base/parent":37}],102:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("../base/parent");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","vertex","fragment"];e.prototype.vertex=function(t,e){var r,i;return(r=(i=this._inherit("vertex"))!=null?i.vertex(t,e):void 0)!=null?r:t};e.prototype.fragment=function(t,e){var r,i;return(r=(i=this._inherit("fragment"))!=null?i.fragment(t,e):void 0)!=null?r:t};return e}(i);e.exports=n},{"../base/parent":37}],103:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./transform");o=t("../../../util");n=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","vertex","transform3"];e.prototype.make=function(){this.uniforms={transformMatrix:this._attributes.make(this._types.mat4())};return this.composer=o.Three.transformComposer()};e.prototype.unmake=function(){return delete this.uniforms};e.prototype.change=function(t,e,r){var i,n,o,s,a,u;if(t["transform3.pass"]){return this.rebuild()}if(!(e["transform3"]||r)){return}o=this.props.position;s=this.props.quaternion;a=this.props.rotation;u=this.props.scale;n=this.props.matrix;i=this.props.eulerOrder;return this.uniforms.transformMatrix.value=this.composer(o,a,s,u,n,i)};e.prototype.vertex=function(t,r){if(r===this.props.pass){t.pipe("transform3.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(i);e.exports=n},{"../../../util":166,"./transform":102}],104:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./transform");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","vertex","transform4"];e.prototype.make=function(){this.uniforms={transformMatrix:this._attributes.make(this._types.mat4()),transformOffset:this.node.attributes["transform4.position"]};return this.transformMatrix=this.uniforms.transformMatrix.value};e.prototype.unmake=function(){return delete this.uniforms};e.prototype.change=function(t,e,r){var i,n,o;if(t["transform4.pass"]){return this.rebuild()}if(!(e["transform4"]||r)){return}n=this.props.scale;i=this.props.matrix;o=this.transformMatrix;o.copy(i);return o.scale(n)};e.prototype.vertex=function(t,r){if(r===this.props.pass){t.pipe("transform4.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(i);e.exports=n},{"./transform":102}],105:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./transform");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","include","vertex","bind"];e.prototype.make=function(){return this._helpers.bind.make([{to:"include.shader",trait:"shader",optional:true}])};e.prototype.unmake=function(){return this._helpers.bind.unmake()};e.prototype.change=function(t,e,r){if(e["include"]){return this.rebuild()}};e.prototype.vertex=function(t,r){if(this.bind.shader!=null){if(r===this.props.pass){t.pipe(this.bind.shader.shaderBind())}}return e.__super__.vertex.call(this,t,r)};return e}(i);e.exports=n},{"./transform":102}],106:[function(t,e,r){var i,n,o,s=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};n=t("../../util");i={array:function(t,e,r){var i,n;if(r==null){r=null}i=t.lerp?function(e,r,i,n){var o,s,a,u;a=Math.min(e.length,r.length);for(o=s=0,u=a;0<=u?s<u:s>u;o=0<=u?++s:--s){i[o]=t.lerp(e[o],r[o],i[o],n)}return i}:void 0;n=t.op?function(e,r,i,n){var o,s,a,u;a=Math.min(e.length,r.length);for(o=s=0,u=a;0<=u?s<u:s>u;o=0<=u?++s:--s){i[o]=t.op(e[o],r[o],i[o],n)}return i}:void 0;if(r!=null&&!(r instanceof Array)){r=[r]}return{uniform:function(){if(t.uniform){return t.uniform()+"v"}else{return void 0}},make:function(){var i,n,o,s;if(r!=null){return r.slice()}if(!e){return[]}s=[];for(i=n=0,o=e;0<=o?n<o:n>o;i=0<=o?++n:--n){s.push(t.make())}return s},validate:function(r,i,n){var o,s,a,u,l,h;if(!(r instanceof Array)){r=[r]}u=i.length=e?e:r.length;for(o=a=0,l=u;0<=l?a<l:a>l;o=0<=l?++a:--a){s=(h=r[o])!=null?h:t.make();i[o]=t.validate(s,i[o],n)}return i},equals:function(e,r){var i,n,o,s,a,u;i=e.length;n=r.length;if(i!==n){return false}a=Math.min(i,n);for(o=s=0,u=a;0<=u?s<u:s>u;o=0<=u?++s:--s){if(!(typeof t.equals==="function"?t.equals(e[o],r[o]):void 0)){return false}}return true},lerp:i,op:n,clone:function(e){var r,i,n,o;n=[];for(r=0,i=e.length;r<i;r++){o=e[r];n.push(t.clone(o))}return n}}},letters:function(t,e,r){var n,o,s,a,u;if(r==null){r=null}if(r!=null){if(r===""+r){r=r.split("")}for(o=s=0,a=r.length;s<a;o=++s){u=r[o];r[o]=t.validate(u,u)}}n=i.array(t,e,r);return{uniform:function(){return n.uniform()},make:function(){return n.make()},validate:function(t,e,r){if(t===""+t){t=t.split("")}return n.validate(t,e,r)},equals:function(t,e){return n.equals(t,e)},clone:n.clone}},nullable:function(t,e){var r,i,n,o;if(e==null){e=false}o=e?t.make():null;r=t.emitter?function(e,r){if(r==null){return e}if(e==null){return r}return t.emitter(e,r)}:void 0;i=t.lerp?function(e,r,i,n){if(e===null||r===null){if(n<.5){return e}else{return r}}if(i==null){i=t.make()}o=t.lerp(e,r,i,n);return i}:void 0;n=t.op?function(e,r,i,n){if(e===null||r===null){return null}if(i==null){i=t.make()}o=t.op(e,r,i,n);return o}:void 0;return{make:function(){return o},validate:function(e,r,i){if(e===null){return e}if(r===null){r=t.make()}return t.validate(e,r,i)},uniform:function(){return typeof t.uniform==="function"?t.uniform():void 0},equals:function(e,r){var i,n,o;i=e===null;n=r===null;if(i&&n){return true}if(i^n){return false}return(o=typeof t.equals==="function"?t.equals(e,r):void 0)!=null?o:e===r},lerp:i,op:n,emitter:r}},enum:function(t,e,r){var i,n,o,s,a,u,l;if(e==null){e=[]}if(r==null){r={}}i=0;l={};for(n=0,s=e.length;n<s;n++){o=e[n];if(o!==+o){if(r[o]==null){r[o]=i++}}}for(u=0,a=e.length;u<a;u++){o=e[u];if(o===+o){l[o]=o}}for(o in r){i=r[o];l[i]=true}if(l[t]==null){t=r[t]}return{enum:function(){return r},make:function(){return t},validate:function(t,e,i){var n;n=l[t]?t:r[t];if(n!=null){return n}return i()}}},enumber:function(t,e,r){var n;if(r==null){r={}}n=i["enum"](t,e,r);return{enum:n["enum"],uniform:function(){return"f"},make:function(){var e;return(e=n.make())!=null?e:+t},validate:function(t,e,r){if(t===+t){return t}return n.validate(t,e,r)},op:function(t,e,r,i){return i(t,e)}}},select:function(t){if(t==null){t="<"}t;return{make:function(){return t},validate:function(t,e,r){if(typeof t==="string"){return t}if(typeof t==="object"){return t}return r()}}},bool:function(t){t=!!t;return{uniform:function(){return"f"},make:function(){return t},validate:function(t,e,r){return!!t}}},int:function(t){if(t==null){t=0}t=+Math.round(t);return{uniform:function(){return"i"},make:function(){return t},validate:function(t,e,r){var i;if(t!==(i=+t)){return r()}return Math.round(i)||0},op:function(t,e,r,i){return i(t,e)}}},round:function(t){if(t==null){t=0}t=+Math.round(t);return{uniform:function(){return"f"},make:function(){return t},validate:function(t,e,r){var i;if(t!==(i=+t)){return r()}return Math.round(i)||0},op:function(t,e,r,i){return i(t,e)}}},number:function(t){if(t==null){t=0}return{uniform:function(){return"f"},make:function(){return+t},validate:function(t,e,r){var i;if(t!==(i=+t)){return r()}return i||0},op:function(t,e,r,i){return i(t,e)}}},positive:function(t,e){if(e==null){e=false}return{uniform:t.uniform,make:t.make,validate:function(r,i,n){r=t.validate(r,i,n);if(r<0||e&&r<=0){return n()}return r},op:function(t,e,r,i){return i(t,e)}}},string:function(t){if(t==null){t=""}return{make:function(){return""+t},validate:function(t,e,r){var i;if(t!==(i=""+t)){return r()}return i}}},func:function(){return{make:function(){return function(){}},validate:function(t,e,r){if(typeof t==="function"){return t}return r()}}},emitter:function(){return{make:function(){return function(t){return t(1,1,1,1)}},validate:function(t,e,r){if(typeof t==="function"){return t}return r()},emitter:function(t,e){return n.Data.getLerpEmitter(t,e)}}},object:function(t){return{make:function(){return t!=null?t:{}},validate:function(t,e,r){if(typeof t==="object"){return t}return r()},clone:function(t){return JSON.parse(JSON.stringify(t))}}},timestamp:function(t){if(t==null){t=null}if(typeof t==="string"){t=Date.parse(t)}return{uniform:function(){return"f"},make:function(){return t!=null?t:+new Date},validate:function(t,e,r){var i;t=Date.parse(t);if(t!==(i=+t)){return r()}return t},op:function(t,e,r,i){return i(t,e)}}},vec2:function(t,e){var r;if(t==null){t=0}if(e==null){e=0}r=[t,e];return{uniform:function(){return"v2"},make:function(){return new THREE.Vector2(t,e)},validate:function(i,n,o){var s,a,u,l;if(i===+i){i=[i]}if(i instanceof THREE.Vector2){n.copy(i)}else if(i instanceof Array){i=i.concat(r.slice(i.length));n.set.apply(n,i)}else if(i!=null){u=(s=i.x)!=null?s:t;l=(a=i.y)!=null?a:e;n.set(u,l)}else{return o()}return n},equals:function(t,e){return t.x===e.x&&t.y===e.y},op:function(t,e,r,i){r.x=i(t.x,e.x);r.y=i(t.y,e.y);return r}}},ivec2:function(t,e){var r,n;if(t==null){t=0}if(e==null){e=0}n=i.vec2(t,e);r=n.validate;n.validate=function(t,e,i){r(t,e,i);e.x=Math.round(e.x);e.y=Math.round(e.y);return e};return n},vec3:function(t,e,r){var i;if(t==null){t=0}if(e==null){e=0}if(r==null){r=0}i=[t,e,r];return{uniform:function(){return"v3"},make:function(){return new THREE.Vector3(t,e,r)},validate:function(n,o,s){var a,u,l,h,f,c;if(n===+n){n=[n]}if(n instanceof THREE.Vector3){o.copy(n)}else if(n instanceof Array){n=n.concat(i.slice(n.length));o.set.apply(o,n)}else if(n!=null){h=(a=n.x)!=null?a:t;f=(u=n.y)!=null?u:e;c=(l=n.z)!=null?l:r;o.set(h,f,c)}else{return s()}return o},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z},op:function(t,e,r,i){r.x=i(t.x,e.x);r.y=i(t.y,e.y);r.z=i(t.z,e.z);return r}}},ivec3:function(t,e,r){var n,o;if(t==null){t=0}if(e==null){e=0}if(r==null){r=0}o=i.vec3(t,e,r);n=o.validate;o.validate=function(t,e){n(t,e,invalid);e.x=Math.round(e.x);e.y=Math.round(e.y);e.z=Math.round(e.z);return e};return o},vec4:function(t,e,r,i){var n;if(t==null){t=0}if(e==null){e=0}if(r==null){r=0}if(i==null){i=0}n=[t,e,r,i];return{uniform:function(){return"v4"},make:function(){return new THREE.Vector4(t,e,r,i)},validate:function(o,s,a){var u,l,h,f,c,p,d,m;if(o===+o){o=[o]}if(o instanceof THREE.Vector4){s.copy(o)}else if(o instanceof Array){o=o.concat(n.slice(o.length));s.set.apply(s,o)}else if(o!=null){p=(u=o.x)!=null?u:t;d=(l=o.y)!=null?l:e;m=(h=o.z)!=null?h:r;c=(f=o.w)!=null?f:i;s.set(p,d,m,c)}else{return a()}return s},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},op:function(t,e,r,i){r.x=i(t.x,e.x);r.y=i(t.y,e.y);r.z=i(t.z,e.z);r.w=i(t.w,e.w);return r}}},ivec4:function(t,e,r,n){var o,s;if(t==null){t=0}if(e==null){e=0}if(r==null){r=0}if(n==null){n=0}s=i.vec4(t,e,r,n);o=s.validate;s.validate=function(t,e){o(t,e,invalid);e.x=Math.round(e.x);e.y=Math.round(e.y);e.z=Math.round(e.z);e.w=Math.round(e.w);return e};return s},mat3:function(t,e,r,i,n,o,s,a,u){var l;if(t==null){t=1}if(e==null){e=0}if(r==null){r=0}if(i==null){i=0}if(n==null){n=1}if(o==null){o=0}if(s==null){s=0}if(a==null){a=0}if(u==null){u=1}l=[t,e,r,i,n,o,s,a,u];return{uniform:function(){return"m4"},make:function(){var l;l=new THREE.Matrix3;l.set(t,e,r,i,n,o,s,a,u);return l},validate:function(t,e,r){if(t instanceof THREE.Matrix3){e.copy(t)}else if(t instanceof Array){t=t.concat(l.slice(t.length));e.set.apply(e,t)}else{return r()}return e}}},mat4:function(t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m){var v;if(t==null){t=1}if(e==null){e=0}if(r==null){r=0}if(i==null){i=0}if(n==null){n=0}if(o==null){o=1}if(s==null){s=0}if(a==null){a=0}if(u==null){u=0}if(l==null){l=0}if(h==null){h=1}if(f==null){f=0}if(c==null){c=0}if(p==null){p=0}if(d==null){d=0}if(m==null){m=1}v=[t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m];return{uniform:function(){return"m4"},make:function(){var v;v=new THREE.Matrix4;v.set(t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m);return v},validate:function(t,e,r){if(t instanceof THREE.Matrix4){e.copy(t)}else if(t instanceof Array){t=t.concat(v.slice(t.length));e.set.apply(e,t)}else{return r()}return e}}},quat:function(t,e,r,n){var o;if(t==null){t=0}if(e==null){e=0}if(r==null){r=0}if(n==null){n=1}o=i.vec4(t,e,r,n);return{uniform:function(){return"v4"},make:function(){return new THREE.Quaternion},validate:function(t,e,r){if(t instanceof THREE.Quaternion){e.copy(t)}else{e=o.validate(t,e,r)}e.normalize();return e},equals:function(t,e){return t.x===e.x&&t.y===e.y&&t.z===e.z&&t.w===e.w},op:function(t,e,r,i){r.x=i(t.x,e.x);r.y=i(t.y,e.y);r.z=i(t.z,e.z);r.w=i(t.w,e.w);r.normalize();return r},lerp:function(t,e,r,i){THREE.Quaternion.slerp(t,e,r,i);return r}}},color:function(t,e,r){var i;if(t==null){t=.5}if(e==null){e=.5}if(r==null){r=.5}i=[t,e,r];return{uniform:function(){return"c"},make:function(){return new THREE.Color(t,e,r)},validate:function(n,o,s){var a,u,l,h,f,c;if(n===""+n){n=(new THREE.Color).setStyle(n)}else if(n===+n){n=new THREE.Color(n)}if(n instanceof THREE.Color){o.copy(n)}else if(n instanceof Array){n=n.concat(i.slice(n.length));o.setRGB.apply(o,n)}else if(n!=null){c=(l=n.r)!=null?l:t;u=(h=n.g)!=null?h:e;a=(f=n.b)!=null?f:r;o.set(c,u,a)}else{return s()}return o},equals:function(t,e){return t.r===e.r&&t.g===e.g&&t.b===e.b},op:function(t,e,r,i){r.r=i(t.r,e.r);r.g=i(t.g,e.g);r.b=i(t.b,e.b);return r}}},axis:function(t,e){var r,i,n;if(t==null){t=1}if(e==null){e=false}r={x:1,y:2,z:3,w:4,W:1,H:2,D:3,I:4,zero:0,null:0,width:1,height:2,depth:3,items:4};i=e?[0,1,2,3,4]:[1,2,3,4];if((n=r[t])!=null){t=n}return{make:function(){return t},validate:function(t,e,o){var a;if((n=r[t])!=null){t=n}t=(a=Math.round(t))!=null?a:0;if(s.call(i,t)>=0){return t}return o()}}},transpose:function(t){var e,r;if(t==null){t=[1,2,3,4]}r=i.letters(i.axis(null,false),0,t);e=i.letters(i.axis(null,false),4,t);return{make:function(){return e.make()},validate:function(t,i,n){var o,s,a,u,l;u=[1,2,3,4];r.validate(t,u,n);if(u.length<4){a=[1,2,3,4].filter(function(t){return u.indexOf(t)===-1});u=u.concat(a)}l=function(){var t,e,r;r=[];for(o=t=0,e=u.length;t<e;o=++t){s=u[o];r.push(u.indexOf(s)===o)}return r}();if(l.indexOf(false)<0){return e.validate(u,i,n)}return n()},equals:e.equals,clone:e.clone}},swizzle:function(t,e){var r,n;if(t==null){t=[1,2,3,4]}if(e==null){e=null}if(e==null){e=t.length}t=t.slice(0,e);n=i.letters(i.axis(null,false),0,t);r=i.letters(i.axis(null,true),e,t);return{make:function(){return r.make()},validate:function(i,o,s){var a;a=t.slice();n.validate(i,a,s);if(a.length<e){a=a.concat([0,0,0,0]).slice(0,e)}return r.validate(a,o,s)},equals:r.equals,clone:r.clone}},classes:function(){var t;t=i.array(i.string());return{make:function(){return t.make()},validate:function(e,r,i){if(e===""+e){e=e.split(" ")}e=e.filter(function(t){return!!t.length});return t.validate(e,r,i)},equals:t.equals,clone:t.clone}},blending:function(t){var e;if(t==null){t="normal"}e=["no","normal","add","subtract","multiply","custom"];return i["enum"](t,e)},filter:function(t){var e;if(t==null){t="nearest"}e={nearest:THREE.NearestFilter,nearestMipMapNearest:THREE.NearestMipMapNearestFilter,nearestMipMapLinear:THREE.NearestMipMapLinearFilter,linear:THREE.LinearFilter,linearMipMapNearest:THREE.LinearMipMapNearestFilter,linearMipmapLinear:THREE.LinearMipMapLinearFilter};return i["enum"](t,[],e)},type:function(t){var e;if(t==null){t="unsignedByte"}e={unsignedByte:THREE.UnsignedByteType,byte:THREE.ByteType,short:THREE.ShortType,unsignedShort:THREE.UnsignedShortType,int:THREE.IntType,unsignedInt:THREE.UnsignedIntType,float:THREE.FloatType};return i["enum"](t,[],e)},scale:function(t){var e;if(t==null){t="linear"}e=["linear","log"];return i["enum"](t,e)},mapping:function(t){var e;if(t==null){t="relative"}e=["relative","absolute"];return i["enum"](t,e)},indexing:function(t){var e;if(t==null){t="original"}e=["original","final"];return i["enum"](t,e)},shape:function(t){var e;if(t==null){t="circle"}e=["circle","square","diamond","up","down","left","right"];return i["enum"](t,e)},join:function(t){var e;if(t==null){t="miter"}e=["miter","round","bevel"];return i["enum"](t,e)},stroke:function(t){var e;if(t==null){t="solid"}e=["solid","dotted","dashed"];return i["enum"](t,e)},vertexPass:function(t){var e;if(t==null){t="view"}e=["data","view","world","eye"];return i["enum"](t,e)},fragmentPass:function(t){var e;if(t==null){t="light"}e=["color","light","rgba"];return i["enum"](t,e)},ease:function(t){var e;if(t==null){t="linear"}e=["linear","cosine","binary","hold"];return i["enum"](t,e)},fit:function(t){var e;if(t==null){t="contain"}e=["x","y","contain","cover"];return i["enum"](t,e)},anchor:function(t){var e;if(t==null){t="middle"}e={first:1,middle:0,last:-1};return i.enumber(t,[],e)},transitionState:function(t){var e;if(t==null){t="enter"}e={enter:-1,visible:0,exit:1};return i.enumber(t,[],e)},font:function(t){var e,r;if(t==null){t="sans-serif"}e=n.JS.parseQuoted;if(!(t instanceof Array)){t=e(t)}r=i.array(i.string(),0,t);return{make:function(){return r.make()},validate:function(t,i,n){try{if(!(t instanceof Array)){t=e(t)}}catch(t){return n()}t=t.filter(function(t){return!!t.length});return r.validate(t,i,n)},equals:r.equals,clone:r.clone}},data:function(t){if(t==null){t=[]}return{make:function(){return[]},validate:function(t,e,r){if(t instanceof Array){return t}else if((t!=null?t.length:void 0)!=null){return t}else{return r()}},emitter:function(t,e){return n.Data.getLerpThunk(t,e)}}}};o=function(t){var e,r;for(e in t){r=t[e];t[e]=function(t){return function(){var e;e=t.apply(t,arguments);if(e.validate==null){e.validate=function(t){return t!=null}}if(e.equals==null){e.equals=function(t,e){return t===e}}if(e.clone==null){e.clone=function(t){var e;return(e=t!=null?typeof t.clone==="function"?t.clone():void 0:void 0)!=null?e:t}}return e}}(r)}return t};e.exports=o(i)},{"../../util":166}],107:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./view");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view3","vertex"];e.prototype.make=function(){e.__super__.make.apply(this,arguments);this.uniforms={viewMatrix:this._attributes.make(this._types.mat4())};this.viewMatrix=this.uniforms.viewMatrix.value;return this.composer=n.Three.transformComposer()};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.viewMatrix;delete this.objectMatrix;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;if(!(e["view"]||e["view3"]||r)){return}u=this.props.position;f=this.props.scale;l=this.props.quaternion;h=this.props.rotation;a=this.props.range;s=this.props.eulerOrder;v=a[0].x;g=a[1].x;y=a[2].x;i=a[0].y-v||1;n=a[1].y-g||1;o=a[2].y-y||1;c=f.x;p=f.y;d=f.z;this.viewMatrix.set(2/i,0,0,-(2*v+i)/i,0,2/n,0,-(2*g+n)/n,0,0,2/o,-(2*y+o)/o,0,0,0,1);m=this.composer(u,h,l,f,null,s);this.viewMatrix.multiplyMatrices(m,this.viewMatrix);if(t["view.range"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("cartesian.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(o);e.exports=i},{"../../../util":166,"./view":113}],108:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./view");i=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view4","vertex"];e.prototype.make=function(){e.__super__.make.apply(this,arguments);this.uniforms={basisOffset:this._attributes.make(this._types.vec4()),basisScale:this._attributes.make(this._types.vec4())};this.basisScale=this.uniforms.basisScale.value;return this.basisOffset=this.uniforms.basisOffset.value};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.basisScale;delete this.basisOffset;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,n,o,s,a,u,l,h,f,c,p,d;if(!(e["view"]||e["view4"]||r)){return}l=this.props.position;h=this.props.scale;a=this.props.range;c=a[0].x;p=a[1].x;d=a[2].x;f=a[3].x;n=a[0].y-c||1;o=a[1].y-p||1;s=a[2].y-d||1;i=a[3].y-f||1;u=function(t,e){t.x*=e.x;t.y*=e.y;t.z*=e.z;return t.w*=e.w};this.basisScale.set(2/n,2/o,2/s,2/i);this.basisOffset.set(-(2*c+n)/n,-(2*p+o)/o,-(2*d+s)/s,-(2*f+i)/i);u(this.basisScale,h);u(this.basisOffset,h);this.basisOffset.add(l);if(t["view.range"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("cartesian4.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(n);e.exports=i},{"./view":113}],109:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./view");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view3","polar","vertex"];e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);t=this._attributes.types;this.uniforms={polarBend:this.node.attributes["polar.bend"],polarHelix:this.node.attributes["polar.helix"],polarFocus:this._attributes.make(t.number()),polarAspect:this._attributes.make(t.number()),viewMatrix:this._attributes.make(t.mat4())};this.viewMatrix=this.uniforms.viewMatrix.value;this.composer=n.Three.transformComposer();return this.aspect=1};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.viewMatrix;delete this.objectMatrix;delete this.aspect;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k;if(!(e["view"]||e["view3"]||e["polar"]||r)){return}this.helix=d=this.props.helix;this.bend=s=this.props.bend;this.focus=c=s>0?1/s-1:0;v=this.props.position;_=this.props.scale;g=this.props.quaternion;y=this.props.rotation;p=this.props.range;h=this.props.eulerOrder;M=p[0].x;S=p[1].x;k=p[2].x;a=p[0].y-M||1;u=p[1].y-S||1;l=p[2].y-k||1;T=_.x;w=_.y;R=_.z;m=a>0?1:-1;E=n.Axis.recenterAxis(S,u,s),S=E[0],u=E[1];i=Math.abs(u);f=a+(i*m-a)*s;x=f/T;b=u/w;this.aspect=o=Math.abs(x/b);this.uniforms.polarFocus.value=c;this.uniforms.polarAspect.value=o;this.viewMatrix.set(2/f,0,0,-(2*M+a)/a,0,2/u,0,-(2*S+u)/u,0,0,2/l,-(2*k+l)/l,0,0,0,1);H=this.composer(v,y,g,_,null,h);this.viewMatrix.multiplyMatrices(H,this.viewMatrix);if(t["view.range"]||e["polar"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("polar.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};e.prototype.axis=function(t){var e,r,i;i=this.props.range[t-1];r=i.x;e=i.y;if(t===2&&this.bend>0){e=Math.max(Math.abs(e),Math.abs(r));r=Math.max(-this.focus/this.aspect,r)}return new THREE.Vector2(r,e)};return e}(o);e.exports=i},{"../../../util":166,"./view":113}],110:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./view");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view3","spherical","vertex"];e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);t=this._attributes.types;this.uniforms={sphericalBend:this.node.attributes["spherical.bend"],sphericalFocus:this._attributes.make(this._types.number()),sphericalAspectX:this._attributes.make(this._types.number()),sphericalAspectY:this._attributes.make(this._types.number()),sphericalScaleY:this._attributes.make(this._types.number()),viewMatrix:this._attributes.make(this._types.mat4())};this.viewMatrix=this.uniforms.viewMatrix.value;this.composer=n.Three.transformComposer();this.aspectX=1;return this.aspectY=1};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.viewMatrix;delete this.objectMatrix;delete this.aspectX;delete this.aspectY;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D;if(!(e["view"]||e["view3"]||e["spherical"]||r)){return}this.bend=u=this.props.bend;this.focus=m=u>0?1/u-1:0;E=this.props.position;w=this.props.scale;_=this.props.quaternion;x=this.props.rotation;v=this.props.range;c=this.props.eulerOrder;P=v[0].x;z=v[1].x;D=v[2].x;l=v[0].y-P||1;h=v[1].y-z||1;f=v[2].y-D||1;k=w.x;A=w.y;C=w.z;b=n.Axis.recenterAxis(z,h,u),z=b[0],h=b[1];T=n.Axis.recenterAxis(D,f,u),D=T[0],f=T[1];g=l>0?1:-1;y=h>0?1:-1;i=Math.abs(f);p=l+(i*g-l)*u;d=h+(i*y-h)*u;H=p/k;M=d/A;S=f/C;this.aspectX=o=Math.abs(H/S);this.aspectY=s=Math.abs(M/S/o);a=h/l*k/A*2;this.scaleY=R=Math.min(s/u,1+(a-1)*u);this.uniforms.sphericalBend.value=u;this.uniforms.sphericalFocus.value=m;this.uniforms.sphericalAspectX.value=o;this.uniforms.sphericalAspectY.value=s;this.uniforms.sphericalScaleY.value=R;this.viewMatrix.set(2/p,0,0,-(2*P+l)/l,0,2/d,0,-(2*z+h)/h,0,0,2/f,-(2*D+f)/f,0,0,0,1);L=this.composer(E,x,_,w,null,c);this.viewMatrix.multiplyMatrices(L,this.viewMatrix);if(t["view.range"]||e["spherical"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("spherical.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};e.prototype.axis=function(t){var e,r,i;i=this.props.range[t-1];r=i.x;e=i.y;if(t===3&&this.bend>0){e=Math.max(Math.abs(e),Math.abs(r));r=Math.max(-this.focus/this.aspectX+.001,r)}return new THREE.Vector2(r,e)};return e}(o);e.exports=i},{"../../../util":166,"./view":113}],111:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./view");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view3","stereographic","vertex"];e.prototype.make=function(){var t;e.__super__.make.apply(this,arguments);t=this._attributes.types;this.uniforms={stereoBend:this.node.attributes["stereographic.bend"],viewMatrix:this._attributes.make(this._types.mat4())};this.viewMatrix=this.uniforms.viewMatrix.value;return this.composer=n.Three.transformComposer()};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.viewMatrix;delete this.rotationMatrix;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;if(!(e["view"]||e["view3"]||e["stereographic"]||r)){return}this.bend=i=this.props.bend;h=this.props.position;d=this.props.scale;f=this.props.quaternion;c=this.props.rotation;l=this.props.range;u=this.props.eulerOrder;E=l[0].x;_=l[1].x;x=l[2].x;o=l[0].y-E||1;s=l[1].y-_||1;a=l[2].y-x||1;m=d.x;v=d.y;g=d.z;p=n.Axis.recenterAxis(x,a,i,1),x=p[0],a=p[1];this.uniforms.stereoBend.value=i;this.viewMatrix.set(2/o,0,0,-(2*E+o)/o,0,2/s,0,-(2*_+s)/s,0,0,2/a,-(2*x+a)/a,0,0,0,1);y=this.composer(h,c,f,d,null,u);this.viewMatrix.multiplyMatrices(y,this.viewMatrix);if(t["view.range"]||e["stereographic"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("stereographic.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(o);e.exports=i},{"../../../util":166,"./view":113}],112:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./view");n=t("../../../util");i=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","view4","stereographic","vertex"];e.prototype.make=function(){e.__super__.make.apply(this,arguments);this.uniforms={basisOffset:this._attributes.make(this._types.vec4()),basisScale:this._attributes.make(this._types.vec4()),stereoBend:this.node.attributes["stereographic.bend"]};this.basisScale=this.uniforms.basisScale.value;return this.basisOffset=this.uniforms.basisOffset.value};e.prototype.unmake=function(){e.__super__.unmake.apply(this,arguments);delete this.basisScale;delete this.basisOffset;return delete this.uniforms};e.prototype.change=function(t,e,r){var i,o,s,a,u,l,h,f,c,p,d,m,v,g;if(!(e["view"]||e["view4"]||e["stereographic"]||r)){return}this.bend=i=this.props.bend;f=this.props.position;p=this.props.scale;l=this.props.range;m=l[0].x;v=l[1].x;g=l[2].x;d=l[3].x;s=l[0].y-m||1;a=l[1].y-v||1;u=l[2].y-g||1;o=l[3].y-d||1;h=function(t,e){t.x*=e.x;t.y*=e.y;t.z*=e.z;return t.w*=e.w};c=n.Axis.recenterAxis(d,o,i,1),d=c[0],o=c[1];this.basisScale.set(2/s,2/a,2/u,2/o);this.basisOffset.set(-(2*m+s)/s,-(2*v+a)/a,-(2*g+u)/u,-(2*d+o)/o);h(this.basisScale,p);h(this.basisOffset,p);this.basisOffset.add(f);if(t["view.range"]||e["stereographic"]){return this.trigger({type:"view.range"})}};e.prototype.vertex=function(t,r){if(r===1){t.pipe("stereographic4.position",this.uniforms)}return e.__super__.vertex.call(this,t,r)};return e}(o);e.exports=i},{"../../../util":166,"./view":113}],113:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("../transform/transform");n=function(t){o(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.traits=["node","object","visible","view","vertex"];e.prototype.make=function(){return this._helpers.visible.make()};e.prototype.unmake=function(){return this._helpers.visible.unmake()};e.prototype.axis=function(t){return this.props.range[t-1]};return e}(i);e.exports=n},{"../transform/transform":102}],114:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./databuffer");o=t("../../util");i=function(t){s(e,t);function e(t,r,i){this.width=i.width||1;this.history=i.history||1;this.samples=this.width;this.wrap=this.history>1;i.width=this.width;i.height=this.history;i.depth=1;e.__super__.constructor.call(this,t,r,i)}e.prototype.build=function(t){e.__super__.build.apply(this,arguments);this.index=0;this.pad=0;return this.streamer=this.generate(this.data)};e.prototype.setActive=function(t){return this.pad=Math.max(0,this.width-t)};e.prototype.fill=function(){var t,e,r,i,n,o,s,a,u;t=this.callback;if(typeof t.reset==="function"){t.reset()}s=this.streamer,i=s.emit,u=s.skip,e=s.count,r=s.done,a=s.reset;a();o=this.samples-this.pad;n=0;while(!r()&&n<o&&t(i,n++)!==false){true}return Math.floor(e()/this.items)};e.prototype.write=function(t){if(t==null){t=this.samples}t*=this.items;this.texture.write(this.data,0,this.index,t,1);this.dataPointer.set(.5,this.index+.5);this.index=(this.index+this.history-1)%this.history;return this.filled=Math.min(this.history,this.filled+1)};e.prototype.through=function(t,e){var r,i,n,s,a,u,l,h;l=h=this.streamer,r=l.consume,i=l.done;s=(n=e.streamer).emit;a=0;u=function(){return r(function(e,r,i,n){return t(s,e,r,i,n,a)})};u=o.Data.repeatCall(u,this.items);return function(t){return function(){var e;h.reset();n.reset();e=t.samples-t.pad;a=0;while(!i()&&a<e){u();a++}return h.count()}}(this)};return e}(n);e.exports=i},{"../../util":166,"./databuffer":117}],115:[function(t,e,r){var i,n,o,s,a,u,l=function(t,e){for(var r in e){if(h.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},h={}.hasOwnProperty;s=t("../renderable");u=t("../../util");o=t("./texture/datatexture");n=t("./texture/backedtexture");i=function(t){l(e,t);function e(t,r,i){if(this.width==null){this.width=i.width||512}if(this.height==null){this.height=i.height||512}if(this.channels==null){this.channels=i.channels||4}if(this.backed==null){this.backed=i.backed||false}this.samples=this.width*this.height;e.__super__.constructor.call(this,t,r);this.build(i)}e.prototype.shader=function(t){t.pipe("map.2d.data",this.uniforms);t.pipe("sample.2d",this.uniforms);if(this.channels<4){t.pipe(u.GLSL.swizzleVec4(["0000","x000","xw00","xyz0"][this.channels]))}return t};e.prototype.build=function(t){var e;this.klass=e=this.backed?n:o;this.texture=new e(this.gl,this.width,this.height,this.channels,t);this.uniforms={dataPointer:{type:"v2",value:new THREE.Vector2(0,0)}};this._adopt(this.texture.uniforms);return this.reset()};e.prototype.reset=function(){this.rows=[];return this.bottom=0};e.prototype.resize=function(t,e){if(!this.backed){throw new Error("Cannot resize unbacked texture atlas")}if(t>2048&&e>2048){console.warn("Giant text atlas "+t+"x"+e+".")}else{console.info("Resizing text atlas "+t+"x"+e+".")}this.texture.resize(t,e);this.width=t;this.height=e;return this.samples=t*e};e.prototype.collapse=function(t){var e,r,i;i=this.rows;i.splice(i.indexOf(t),1);this.bottom=(e=(r=i[i.length-1])!=null?r.bottom:void 0)!=null?e:0;if(this.last===t){return this.last=null}};e.prototype.allocate=function(t,e,r,i){var n,o,s,u,l,h,f,c,p,d,m,v;v=this.width;s=this.height;c=r*2;if(e>v){this.resize(v*2,s*2);this.last=null;return this.allocate(t,e,r,i)}d=this.last;if(d!=null){if(d.height>=r&&d.height<c&&d.width+e<=v){d.append(t,e,r,i);return}}n=0;l=-1;m=0;p=this.rows;for(u=h=0,f=p.length;h<f;u=++h){d=p[u];o=d.top-n;if(o>=r&&l<0){l=u;m=n}n=d.bottom;if(d.height>=r&&d.height<c&&d.width+e<=v){d.append(t,e,r,i);this.last=d;return}}if(l>=0){d=new a(m,r);this.rows.splice(l,0,d)}else{m=n;n+=r;if(n>=s){this.resize(v*2,s*2);this.last=null;return this.allocate(t,e,r,i)}d=new a(m,r);this.rows.push(d);this.bottom=n}d.append(t,e,r,i);this.last=d};e.prototype.read=function(){return this.texture.textureObject};e.prototype.write=function(t,e,r,i,n){return this.texture.write(t,e,r,i,n)};e.prototype.dispose=function(){this.texture.dispose();this.data=null;return e.__super__.dispose.apply(this,arguments)};return e}(s);a=function(){function t(t,e){this.top=t;this.bottom=t+e;this.width=0;this.height=e;this.alive=0;this.keys=[]}t.prototype.append=function(t,e,r,i){var n,o;n=this.width;o=this.top;this.alive++;this.width+=e;this.keys.push(t);return i(this,n,o)};return t}();e.exports=i},{"../../util":166,"../renderable":152,"./texture/backedtexture":124,"./texture/datatexture":125}],116:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../renderable");o=t("../../util");i=function(t){s(e,t);function e(t,r,i){if(this.items==null){this.items=i.items||1}if(this.samples==null){this.samples=i.samples||1}if(this.channels==null){this.channels=i.channels||4}if(this.callback==null){this.callback=i.callback||function(){}}e.__super__.constructor.call(this,t,r)}e.prototype.dispose=function(){return e.__super__.dispose.apply(this,arguments)};e.prototype.update=function(){var t;t=this.fill();this.write(t);return t};e.prototype.setActive=function(t,e,r,i){};e.prototype.setCallback=function(t){this.callback=t};e.prototype.write=function(){};e.prototype.fill=function(){};e.prototype.generate=function(t){return o.Data.getStreamer(t,this.samples,this.channels,this.items)};return e}(n);e.exports=i},{"../../util":166,"../renderable":152}],117:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("./buffer");o=t("./texture/datatexture");s=t("../../util");n=function(t){a(e,t);function e(t,r,i){this.width=i.width||1;this.height=i.height||1;this.depth=i.depth||1;if(this.samples==null){this.samples=this.width*this.height*this.depth}e.__super__.constructor.call(this,t,r,i);this.build(i)}e.prototype.shader=function(t,e){var r;if(e==null){e=4}if(this.items>1||this.depth>1){if(e!==4){t.pipe(s.GLSL.extendVec(e,4))}t.pipe("map.xyzw.texture",this.uniforms)}else{if(e!==2){t.pipe(s.GLSL.truncateVec(e,2))}}r=this.wrap?".wrap":"";t.pipe("map.2d.data"+r,this.uniforms);t.pipe("sample.2d",this.uniforms);if(this.channels<4){t.pipe(s.GLSL.swizzleVec4(["0000","x000","xw00","xyz0"][this.channels]))}return t};e.prototype.build=function(t){this.data=new Float32Array(this.samples*this.channels*this.items);this.texture=new o(this.gl,this.items*this.width,this.height*this.depth,this.channels,t);this.filled=0;this.used=0;this._adopt(this.texture.uniforms);this._adopt({dataPointer:{type:"v2",value:new THREE.Vector2},textureItems:{type:"f",value:this.items},textureHeight:{type:"f",value:this.height}});this.dataPointer=this.uniforms.dataPointer.value;return this.streamer=this.generate(this.data)};e.prototype.dispose=function(){this.data=null;this.texture.dispose();return e.__super__.dispose.apply(this,arguments)};e.prototype.getFilled=function(){return this.filled};e.prototype.setCallback=function(t){this.callback=t;return this.filled=0};e.prototype.copy=function(t){var e,r,i,n,o;n=Math.min(t.length,this.samples*this.channels*this.items);e=this.data;for(r=i=0,o=n;0<=o?i<o:i>o;r=0<=o?++i:--i){e[r]=t[r]}return this.write(Math.ceil(n/this.channels/this.items))};e.prototype.write=function(t){var e,r;if(t==null){t=this.samples}e=t/this.width;t*=this.items;r=e<1?t:this.items*this.width;e=Math.ceil(e);this.texture.write(this.data,0,0,r,e);this.dataPointer.set(.5,.5);this.filled=1;return this.used=t};e.prototype.through=function(t,e){var r,i,n,o,a,u,l,h;l=h=this.streamer,r=l.consume,i=l.done;o=(n=e.streamer).emit;a=0;u=function(){return r(function(e,r,i,n){return t(o,e,r,i,n,a)})};u=s.Data.repeatCall(u,this.items);return function(t){return function(){var e;h.reset();n.reset();e=t.used;a=0;while(!i()&&a<e){u();a++}return h.count()}}(this)};return e}(i);e.exports=n},{"../../util":166,"./buffer":116,"./texture/datatexture":125}],118:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./databuffer");o=t("../../util");n=function(t){s(e,t);function e(t,r,i){this.width=i.width||1;this.height=i.height||1;this.history=i.history||1;this.samples=this.width*this.height;this.wrap=this.history>1;i.depth=this.history;e.__super__.constructor.call(this,t,r,i)}e.prototype.build=function(t){e.__super__.build.apply(this,arguments);this.index=0;this.pad={x:0,y:0};return this.streamer=this.generate(this.data)};e.prototype.getFilled=function(){return this.filled};e.prototype.setActive=function(t,e){var r;return r=[Math.max(0,this.width-t),Math.max(0,this.height-e)],this.pad.x=r[0],this.pad.y=r[1],r};e.prototype.fill=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p;t=this.callback;if(typeof t.reset==="function"){t.reset()}h=this.streamer,i=h.emit,p=h.skip,e=h.count,r=h.done,c=h.reset;c();u=this.width;l=this.pad.x;a=this.samples-this.pad.y*u;n=o=s=0;if(l){while(!r()&&s<a){s++;f=t(i,n,o);if(++n===u-l){p(l);n=0;o++}if(f===false){break}}}else{while(!r()&&s<a){s++;f=t(i,n,o);if(++n===u){n=0;o++}if(f===false){break}}}return Math.floor(e()/this.items)};e.prototype.write=function(t){var e,r;if(t==null){t=this.samples}t*=this.items;r=this.width*this.items;e=Math.ceil(t/r);this.texture.write(this.data,0,this.index*this.height,r,e);this.dataPointer.set(.5,this.index*this.height+.5);this.index=(this.index+this.history-1)%this.history;return this.filled=Math.min(this.history,this.filled+1)};e.prototype.through=function(t,e){var r,i,n,s,a,u,l,h,f;h=f=this.streamer,r=h.consume,i=h.done;s=(n=e.streamer).emit;a=u=0;l=function(){return r(function(e,r,i,n){return t(s,e,r,i,n,a,u)})};l=o.Data.repeatCall(l,this.items);return function(t){return function(){var e,r,o,s;f.reset();n.reset();o=t.width;s=t.pad.x;r=t.samples-t.pad.y*o;a=u=e=0;if(s){while(!i()&&e<r){e++;l();if(++a===o-s){skip(s);a=0;u++}}}else{while(!i()&&e<r){e++;l();if(++a===o){a=0;u++}}}return f.count()}}(this)};return e}(i);e.exports=n},{"../../util":166,"./databuffer":117}],119:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;o=t("../renderable");n=t("./rendertotexture");s=t("../../util");i=function(t){a(e,t);function e(t,r,i){if(this.items==null){this.items=i.items||1}if(this.channels==null){this.channels=i.channels||4}if(this.width==null){this.width=i.width||1}if(this.height==null){this.height=i.height||1}if(this.depth==null){this.depth=i.depth||1}i.format=THREE.RGBAFormat;i.width=this._width=this.items*this.width;i.height=this._height=this.height*this.depth;i.frames=1;delete i.items;delete i.depth;delete i.channels;e.__super__.constructor.call(this,t,r,i);this._adopt({textureItems:{type:"f",value:this.items},textureHeight:{type:"f",value:this.height}})}e.prototype.shaderAbsolute=function(t){if(t==null){t=this.shaders.shader()}t.pipe("map.xyzw.texture",this.uniforms);return e.__super__.shaderAbsolute.call(this,t,1,2)};return e}(n);e.exports=i},{"../../util":166,"../renderable":152,"./rendertotexture":122}],120:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./buffer");o=t("../../util");n=function(t){s(e,t);function e(t,r,i){this.width=i.width||1;this.height=i.height||1;this.depth=i.depth||1;if(this.samples==null){this.samples=this.width*this.height*this.depth}e.__super__.constructor.call(this,t,r,i);this.build(i)}e.prototype.build=function(t){this.data=[];this.data.length=this.samples;this.filled=0;this.pad={x:0,y:0,z:0};return this.streamer=this.generate(this.data)};e.prototype.dispose=function(){this.data=null;return e.__super__.dispose.apply(this,arguments)};e.prototype.getFilled=function(){return this.filled};e.prototype.setActive=function(t,e,r){var i;return i=[this.width-t,this.height-e,this.depth-r],this.pad.x=i[0],this.pad.y=i[1],this.pad.z=i[2],i};e.prototype.read=function(){return this.data};e.prototype.copy=function(t){var e,r,i,n,o,s;i=Math.min(t.length,this.samples);e=this.data;s=[];for(r=n=0,o=i;0<=o?n<o:n>o;r=0<=o?++n:--n){s.push(e[r]=t[r])}return s};e.prototype.fill=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g;t=this.callback;if(typeof t.reset==="function"){t.reset()}d=this.streamer,i=d.emit,g=d.skip,e=d.count,r=d.done,v=d.reset;v();h=this.width;l=this.height;f=this.depth;c=this.pad.x;p=this.pad.y;u=this.samples-this.pad.z*h*l;n=o=s=a=0;if(c>0||p>0){while(!r()&&a<u){a++;m=t(i,n,o,s);if(++n===h-c){g(c);n=0;if(++o===l-p){g(h*p);o=0;s++}}if(m===false){break}}}else{while(!r()&&a<u){a++;m=t(i,n,o,s);if(++n===h){n=0;if(++o===l){o=0;s++}}if(m===false){break}}}this.filled=1;return e()};return e}(i);e.exports=n},{"../../util":166,"./buffer":116}],121:[function(t,e,r){var i,n,o,s,a,u,l=function(t,e){for(var r in e){if(h.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},h={}.hasOwnProperty;a=t("../renderable");i=t("./buffer");n=t("./memo");o=t("../meshes/memoscreen");u=t("../../util");s=function(t){l(e,t);function e(t,r,i){if(this.items==null){this.items=i.items||1}if(this.channels==null){this.channels=i.channels||4}if(this.width==null){this.width=i.width||1}if(this.height==null){this.height=i.height||1}if(this.depth==null){this.depth=i.depth||1}if(this.type==null){this.type=i.type||THREE.FloatType}if(this.stpq==null){this.stpq=i.stpq||false}this.isFloat=this.type===THREE.FloatType;this.active=this.sampled=this.rect=this.pad=null;e.__super__.constructor.call(this,t,r);this.build(i)}e.prototype.build=function(t){var e,r,i,s,a,l,h,f,c,p,d,m,v,g,y;c=t.map;l=t.indexer;h=l!=null&&!l.empty();p=this,f=p.items,y=p.width,a=p.height,r=p.depth,m=p.stpq;d=c;if(h){this._adopt({indexModulus:{type:"v4",value:new THREE.Vector4(f,f*y,f*y*a,1)}});d=this.shaders.shader();d.require(c);d.require(l);d.pipe("float.index.pack",this.uniforms)}if(this.isFloat&&this.channels>1){this.floatMemo=new n(this.renderer,this.shaders,{items:f,channels:4,width:y,height:a,depth:r,history:0,type:THREE.FloatType});this.floatCompose=new o(this.renderer,this.shaders,{map:d,items:f,width:y,height:a,depth:r,stpq:m});this.floatMemo.adopt(this.floatCompose);m=false;d=this.shaders.shader();this.floatMemo.shaderAbsolute(d)}if(this.isFloat){v=this.channels;e=4}else{v=1;e=this.channels}if(v>1){i=this.shaders.shader();i.pipe(u.GLSL.mapByte2FloatOffset(v));i.require(d);i.pipe("float.stretch");i.pipe("float.encode");d=i}else if(this.isFloat){i=this.shaders.shader();i.pipe(d);i.pipe(u.GLSL.truncateVec4(4,1));i.pipe("float.encode");d=i}this.byteMemo=new n(this.renderer,this.shaders,{items:f*v,channels:4,width:y,height:a,depth:r,history:0,type:THREE.UnsignedByteType});this.byteCompose=new o(this.renderer,this.shaders,{map:d,items:f*v,width:y,height:a,depth:r,stpq:m});this.byteMemo.adopt(this.byteCompose);g=f*y*v;s=a*r;this.samples=this.width*this.height*this.depth;this.bytes=new Uint8Array(g*s*4);if(this.isFloat){this.floats=new Float32Array(this.bytes.buffer)}this.data=this.isFloat?this.floats:this.bytes;this.streamer=this.generate(this.data);this.active={items:0,width:0,height:0,depth:0};this.sampled={items:0,width:0,height:0,depth:0};this.rect={w:0,h:0};this.pad={x:0,y:0,z:0,w:0};this.stretch=v;this.isIndexed=h;return this.setActive(f,y,a,r)};e.prototype.generate=function(t){return u.Data.getStreamer(t,this.samples,4,this.items)};e.prototype.setActive=function(t,e,r,i){var n,o,s,a,u,l,h,f;if(!(t!==this.active.items||e!==this.active.width||r!==this.active.height||i!==this.active.depth)){return}o=[t,e,r,i],this.active.items=o[0],this.active.width=o[1],this.active.height=o[2],this.active.depth=o[3];if((s=this.floatCompose)!=null){s.cover(e,r,i)}if((a=this.byteCompose)!=null){a.cover(e*this.stretch,r,i)}t=this.items;e=this.active.width;r=this.depth===1?this.active.height:this.height;i=this.active.depth;f=t*e*this.stretch;n=r*i;u=[t,e,r,i],this.sampled.items=u[0],this.sampled.width=u[1],this.sampled.height=u[2],this.sampled.depth=u[3];l=[f,n],this.rect.w=l[0],this.rect.h=l[1];return h=[this.sampled.width-this.active.width,this.sampled.height-this.active.height,this.sampled.depth-this.active.depth,this.sampled.items-this.active.items],this.pad.x=h[0],this.pad.y=h[1],this.pad.z=h[2],this.pad.w=h[3],h};e.prototype.update=function(t){var e,r;if((e=this.floatMemo)!=null){e.render(t)}return(r=this.byteMemo)!=null?r.render(t):void 0};e.prototype.post=function(){this.renderer.setRenderTarget(this.byteMemo.target.reads[0]);return this.gl.readPixels(0,0,this.rect.w,this.rect.h,gl.RGBA,gl.UNSIGNED_BYTE,this.bytes)};e.prototype.readFloat=function(t){var e;return(e=this.floatMemo)!=null?e.read(t):void 0};e.prototype.readByte=function(t){var e;return(e=this.byteMemo)!=null?e.read(t):void 0};e.prototype.setCallback=function(t){return this.emitter=this.callback(t)};e.prototype.callback=function(t){var e,r,i,n,o;if(!this.isIndexed){return t}i=this.width;r=this.height;n=this.depth;o=this.items;e=function(e,n,s,a){var u,l,h,f,c;u=a;c=u%o;u=(u-c)/o;l=u%i;u=(u-l)/i;h=u%r;u=(u-h)/r;f=u;return t(e,n,s,a,l,h,f,c)};e.reset=function(){return typeof t.reset==="function"?t.reset():void 0};return e};e.prototype.iterate=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;n=this.emitter;if(typeof n.reset==="function"){n.reset()}y=this.streamer,e=y.consume,x=y.skip,r=y.count,i=y.done,_=y.reset;_();f=this.sampled.width|0;h=this.sampled.height|0;c=this.sampled.depth|0;p=this.sampled.items|0;m=this.pad.x|0;v=this.pad.y|0;g=this.pad.z|0;d=this.pad.w|0;l=f*h*p*(c-g);if(!this.isIndexed){t=n;n=function(e,r,i,n){return t(e,r,i,n,o,s,a,u)}}o=s=a=u=h=0;while(!i()&&h<l){h++;E=e(n);if(++u===p-d){x(m);u=0;if(++o===f-m){x(p*m);o=0;if(++s===h-v){x(p*f*v);s=0;a++}}}if(E===false){break}}return Math.floor(r()/p)};e.prototype.dispose=function(){var t,e,r,i,n,o;if((t=this.floatMemo)!=null){t.unadopt(this.floatCompose)}if((e=this.floatMemo)!=null){e.dispose()}if((r=this.floatCompose)!=null){r.dispose()}if((i=this.byteMemo)!=null){i.unadopt(this.byteCompose)}if((n=this.byteMemo)!=null){n.dispose()}if((o=this.byteCompose)!=null){o.dispose()}return this.floatMemo=this.byteMemo=this.floatCompose=this.byteCompose=null};return e}(a);e.exports=s},{"../../util":166,"../meshes/memoscreen":146,"../renderable":152,"./buffer":116,"./memo":119}],122:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;o=t("../renderable");i=t("./texture/rendertarget");s=t("../../util");n=function(t){a(e,t);function e(t,r,i){var n;this.scene=(n=i.scene)!=null?n:new THREE.Scene;this.camera=i.camera;e.__super__.constructor.call(this,t,r);this.build(i)}e.prototype.shaderRelative=function(t){if(t==null){t=this.shaders.shader()}return t.pipe("sample.2d",this.uniforms)};e.prototype.shaderAbsolute=function(t,e,r){var i;if(e==null){e=1}if(r==null){r=4}if(t==null){t=this.shaders.shader()}if(e<=1){if(r>2){t.pipe(s.GLSL.truncateVec(r,2))}t.pipe("map.2d.data",this.uniforms);return t.pipe("sample.2d",this.uniforms)}else{i=s.GLSL.sample2DArray(Math.min(e,this.target.frames));if(r<4){t.pipe(s.GLSL.extendVec(r,4))}t.pipe("map.xyzw.2dv");t.split();t.pipe("map.2d.data",this.uniforms);t.pass();return t.pipe(i,this.uniforms)}};e.prototype.build=function(t){var e;if(!this.camera){this.camera=new THREE.PerspectiveCamera;this.camera.position.set(0,0,3);this.camera.lookAt(new THREE.Vector3)}if(typeof(e=this.scene).inject==="function"){e.inject()}this.target=new i(this.gl,t.width,t.height,t.frames,t);this.target.warmup(function(t){return function(e){return t.renderer.setRenderTarget(e)}}(this));this.renderer.setRenderTarget(null);this._adopt(this.target.uniforms);this._adopt({dataPointer:{type:"v2",value:new THREE.Vector2(.5,.5)}});return this.filled=0};e.prototype.adopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this.scene.add(i))}return o};e.prototype.unadopt=function(t){var e,r,i,n,o;n=t.renders;o=[];for(e=0,r=n.length;e<r;e++){i=n[e];o.push(this.scene.remove(i))}return o};e.prototype.render=function(t){var e;if(t==null){t=this.camera}this.renderer.render((e=this.scene.scene)!=null?e:this.scene,t,this.target.write);this.target.cycle();if(this.filled<this.target.frames){return this.filled++}};e.prototype.read=function(t){if(t==null){t=0}return this.target.reads[Math.abs(t)]};e.prototype.getFrames=function(){return this.target.frames};e.prototype.getFilled=function(){return this.filled};e.prototype.dispose=function(){var t;if(typeof(t=this.scene).unject==="function"){t.unject()}this.scene=this.camera=null;this.target.dispose();return e.__super__.dispose.apply(this,arguments)};return e}(o);e.exports=n},{"../../util":166,"../renderable":152,"./texture/rendertarget":126}],123:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./atlas");n=512/16;o=function(t){s(e,t);function e(t,r,i){var n,o,s,a,u,l,h;this.font=(n=i.font)!=null?n:["sans-serif"];this.size=i.size||24;this.style=(o=i.style)!=null?o:"normal";this.variant=(s=i.variant)!=null?s:"normal";this.weight=(a=i.weight)!=null?a:"normal";this.outline=(u=+((l=i.outline)!=null?l:5))!=null?u:0;i.width||(i.width=256);i.height||(i.height=256);i.type=THREE.UnsignedByteType;i.channels=1;i.backed=true;this.gamma=1;if(typeof navigator!=="undefined"){h=navigator.userAgent;if(h.match(/Chrome/)&&h.match(/OS X/)){this.gamma=.5}}this.scratchW=this.scratchH=0;e.__super__.constructor.call(this,t,r,i)}e.prototype.build=function(t){var r,i,o,s,a,u,l,h,f,c,p,d,m;e.__super__.build.call(this,t);f=16;f=this.size;f+=4+2*Math.min(1,this.outline);c=n*f;r=document.createElement("canvas");r.width=c;r.height=f;p=function(t){return'"'+t.replace(/(['"\\])/g,"\\$1")+'"'};a=this.font.map(p).join(", ");o=r.getContext("2d");o.font=this.style+" "+this.variant+" "+this.weight+" "+this.size+"px "+this.font;o.fillStyle="#FF0000";o.textAlign="left";o.textBaseline="bottom";o.lineJoin="round";i=[];s=this.outline*3;for(l=h=0,d=s;0<=d?h<d:h>d;l=0<=d?++h:--h){u=("00"+Math.max(0,-l*8+128-!l*8).toString(16)).slice(-2);i.push("#"+u+u+u)}m=new Uint8Array(c*f*2);this.canvas=r;this.context=o;this.lineHeight=f;this.maxWidth=c;this.colors=i;this.scratch=m;this._allocate=this.allocate.bind(this);return this._write=this.write.bind(this)};e.prototype.reset=function(){e.__super__.reset.apply(this,arguments);return this.mapped={}};e.prototype.begin=function(){var t,e,r,i,n;r=this.rows;i=[];for(t=0,e=r.length;t<e;t++){n=r[t];i.push(n.alive=0)}return i};e.prototype.end=function(){var t,e,r,i,n,o,s,a,u;o=this.mapped;s=this.rows.slice();for(t=0,i=s.length;t<i;t++){u=s[t];if(!(u.alive===0)){continue}a=u.keys;for(r=0,n=a.length;r<n;r++){e=a[r];delete o[e]}this.collapse(u)}};e.prototype.map=function(t,e){var r,i,n,o,s,a,u;s=this.mapped;i=s[t];if(i!=null){i.row.alive++;return e(i.x,i.y,i.w,i.h)}this.draw(t);n=this.scratch;a=this.scratchW;o=this.scratchH;r=this._allocate;u=this._write;return r(t,a,o,function(r,i,l){s[t]={x:i,y:l,w:a,h:o,row:r};u(n,i,l,a,o);return e(i,l,a,o)})};e.prototype.draw=function(t){var e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R;T=this.width;l=this.lineHeight;E=this.outline;o=this.context;a=this.scratch;g=this.maxWidth;n=this.colors;w=E+1;R=Math.round(l*1.05-1);m=o.measureText(t);T=Math.min(g,Math.ceil(m.width+2*w+1));o.clearRect(0,0,T,l);if(this.outline===0){o.fillText(t,w,R);s=(f=o.getImageData(0,0,T,l)).data;c=3;for(h=p=0,_=s.length/4;0<=_?p<_:p>_;h=0<=_?++p:--p){a[h]=s[c];c+=4}this.scratchW=T;return this.scratchH=l}else{o.globalCompositeOperation="source-over";for(h=d=x=E+1;x<=1?d<=1:d>=1;h=x<=1?++d:--d){c=h>1?h*2-2:h;o.strokeStyle=n[c-1];o.lineWidth=c;o.strokeText(t,w,R)}o.globalCompositeOperation="multiply";o.fillText(t,w,R);s=(f=o.getImageData(0,0,T,l)).data;c=0;u=this.gamma;for(h=y=0,b=s.length/4;0<=b?y<b:y>b;h=0<=b?++y:--y){e=s[c];v=e?s[c+1]/e:1;if(u===.5){v=Math.sqrt(v)}v=Math.min(1,Math.max(0,v));r=256-e;i=r+(e-r)*v;a[h]=Math.max(0,Math.min(255,i+2));c+=4}this.scratchW=T;return this.scratchH=l}};return e}(i);e.exports=o},{"./atlas":115}],124:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("../../../util");n=t("./datatexture");i=function(t){s(e,t);function e(t,r,i,n,o){e.__super__.constructor.call(this,t,r,i,n,o);this.data=new this.ctor(this.n)}e.prototype.resize=function(t,e){var r,i,n,o;i=this.data;o=this.width;n=this.height;this.width=t;this.height=e;this.n=t*e*this.channels;this.data=new this.ctor(this.n);r=this.gl;r.bindTexture(r.TEXTURE_2D,this.texture);r.pixelStorei(r.UNPACK_ALIGNMENT,1);r.texImage2D(r.TEXTURE_2D,0,this.format,t,e,0,this.format,this.type,this.data);this.uniforms.dataResolution.value.set(1/t,1/e);return this.write(i,0,0,o,n)};e.prototype.write=function(t,r,i,n,o){var s,a,u,l,h,f,c,p,d,m,v,g;p=this.width;a=this.data;s=this.channels;u=0;if(p===n&&r===0){l=i*n*s;f=n*o*s;while(u<f){a[l++]=t[u++]}}else{c=p*s;d=n*s;m=r*s;g=i;v=i+o;while(g<v){h=0;l=m+g*c;while(h++<d){a[l++]=t[u++]}g++}}return e.__super__.write.call(this,t,r,i,n,o)};e.prototype.dispose=function(){this.data=null;return e.__super__.dispose.apply(this,arguments)};return e}(n);e.exports=i},{"../../../util":166,"./datatexture":125}],125:[function(t,e,r){var i,n;n=t("../../../util");i=function(){function t(t,e,r,i,o){var s,a,u,l,h,f,c;this.gl=t;this.width=e;this.height=r;this.channels=i;this.n=this.width*this.height*this.channels;s=this.gl;u=(l=o.minFilter)!=null?l:THREE.NearestFilter;a=(h=o.magFilter)!=null?h:THREE.NearestFilter;c=(f=o.type)!=null?f:THREE.FloatType;this.minFilter=n.Three.paramToGL(s,u);this.magFilter=n.Three.paramToGL(s,a);this.type=n.Three.paramToGL(s,c);this.ctor=n.Three.paramToArrayStorage(c);this.build(o)}t.prototype.build=function(t){var e;e=this.gl;this.texture=e.createTexture();this.format=[null,e.LUMINANCE,e.LUMINANCE_ALPHA,e.RGB,e.RGBA][this.channels];this.format3=[null,THREE.LuminanceFormat,THREE.LuminanceAlphaFormat,THREE.RGBFormat,THREE.RGBAFormat][this.channels];e.bindTexture(e.TEXTURE_2D,this.texture);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,this.minFilter);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,this.magFilter);this.data=new this.ctor(this.n);e.pixelStorei(e.UNPACK_ALIGNMENT,1);e.texImage2D(e.TEXTURE_2D,0,this.format,this.width,this.height,0,this.format,this.type,this.data);this.textureObject=new THREE.Texture(new Image,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,t.minFilter,t.magFilter);this.textureObject.__webglInit=true;this.textureObject.__webglTexture=this.texture;this.textureObject.format=this.format3;this.textureObject.type=THREE.FloatType;this.textureObject.unpackAlignment=1;this.textureObject.flipY=false;this.textureObject.generateMipmaps=false;return this.uniforms={dataResolution:{type:"v2",value:new THREE.Vector2(1/this.width,1/this.height)},dataTexture:{type:"t",value:this.textureObject}}};t.prototype.write=function(t,e,r,i,n){var o;o=this.gl;o.bindTexture(o.TEXTURE_2D,this.texture);o.pixelStorei(o.UNPACK_ALIGNMENT,1);return o.texSubImage2D(o.TEXTURE_2D,0,e,r,i,n,this.format,this.type,t)};t.prototype.dispose=function(){this.gl.deleteTexture(this.texture);this.textureObject.__webglInit=false;this.textureObject.__webglTexture=null;return this.textureObject=this.texture=null};return t}();e.exports=i},{"../../../util":166}],126:[function(t,e,r){var i;i=function(){function t(t,e,r,i,n){this.gl=t;if(n==null){n={}}if(n.minFilter==null){n.minFilter=THREE.NearestFilter}if(n.magFilter==null){n.magFilter=THREE.NearestFilter}if(n.format==null){n.format=THREE.RGBAFormat}if(n.type==null){n.type=THREE.UnsignedByteType}this.options=n;this.width=e||1;this.height=r||1;this.frames=i||1;this.buffers=this.frames+1;this.build()}t.prototype.build=function(){var t,e;e=function(t){return function(){return new THREE.WebGLRenderTarget(t.width,t.height,t.options)}}(this);this.targets=function(){var r,i,n;n=[];for(t=r=0,i=this.buffers;0<=i?r<i:r>i;t=0<=i?++r:--r){n.push(e())}return n}.call(this);this.reads=function(){var r,i,n;n=[];for(t=r=0,i=this.buffers;0<=i?r<i:r>i;t=0<=i?++r:--r){n.push(e())}return n}.call(this);this.write=e();this.index=0;return this.uniforms={dataResolution:{type:"v2",value:new THREE.Vector2(1/this.width,1/this.height)},dataTexture:{type:"t",value:this.reads[0]},dataTextures:{type:"tv",value:this.reads}}};t.prototype.cycle=function(){var t,e,r,i,n,o,s,a,u;o=["__webglTexture","__webglFramebuffer","__webglRenderbuffer"];e=this.buffers;r=function(t,e){var r,i,n;for(r=0,n=o.length;r<n;r++){i=o[r];e[i]=t[i]}return null};t=function(t,r){return(t+r+e*2)%e};r(this.write,this.targets[this.index]);u=this.reads;for(i=n=0,s=u.length;n<s;i=++n){a=u[i];r(this.targets[t(this.index,-i)],a)}this.index=t(this.index,1);return r(this.targets[this.index],this.write)};t.prototype.warmup=function(t){var e,r,i,n;n=[];for(e=r=0,i=this.buffers;0<=i?r<i:r>i;e=0<=i?++r:--r){t(this.write);n.push(this.cycle())}return n};t.prototype.dispose=function(){var t,e,r,i;r=this.targets;for(t=0,e=r.length;t<e;t++){i=r[t];i.dispose()}return this.targets=this.reads=this.write=null};return t}();e.exports=i},{}],127:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./databuffer");n=t("../../util");o=function(t){s(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.prototype.build=function(t){e.__super__.build.apply(this,arguments);this.pad={x:0,y:0,z:0};return this.streamer=this.generate(this.data)};e.prototype.setActive=function(t,e,r){var i;return i=[Math.max(0,this.width-t),Math.max(0,this.height-e),Math.max(0,this.depth-r)],this.pad.x=i[0],this.pad.y=i[1],this.pad.z=i[2],i};e.prototype.fill=function(){var t,e,r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g;t=this.callback;if(typeof t.reset==="function"){t.reset()}d=this.streamer,i=d.emit,g=d.skip,e=d.count,r=d.done,v=d.reset;v();h=this.width;l=this.height;f=this.depth;c=this.pad.x;p=this.pad.y;u=this.samples-this.pad.z*h*l;n=o=s=a=0;if(c>0||p>0){while(!r()&&a<u){a++;m=t(i,n,o,s);if(++n===h-c){g(c);n=0;if(++o===l-p){g(h*p);o=0;s++}}if(m===false){break}}}else{while(!r()&&a<u){a++;m=t(i,n,o,s);if(++n===h){n=0;if(++o===l){o=0;s++}}if(m===false){break}}}return Math.floor(e()/this.items)};e.prototype.through=function(t,e){var r,i,o,s,a,u,l,h,f,c;f=c=this.streamer,r=f.consume,i=f.done;s=(o=e.streamer).emit;a=u=l=0;h=function(){return r(function(e,r,i,n){return t(s,e,r,i,n,a,u,l)})};h=n.Data.repeatCall(h,this.items);return function(t){return function(){var e,r,n,s,f,p,d;c.reset();o.reset();s=t.width;n=t.height;f=t.depth;p=t.pad.x;d=t.pad.y;r=t.samples-t.pad.z*s*n;a=u=l=e=0;if(p>0||d>0){while(!i()&&e<r){e++;h();if(++a===s-p){skip(p);a=0;if(++u===n-d){skip(s*d);u=0;l++}}}}else{while(!i()&&e<r){e++;h();if(++a===s){a=0;if(++u===n){u=0;l++}}}}return c.count()}}(this)};return e}(i);e.exports=o},{"../../util":166,"./databuffer":117}],128:[function(t,e,r){var i;i={sprite:t("./meshes/sprite"),point:t("./meshes/point"),line:t("./meshes/line"),surface:t("./meshes/surface"),face:t("./meshes/face"),strip:t("./meshes/strip"),arrow:t("./meshes/arrow"),screen:t("./meshes/screen"),memoScreen:t("./meshes/memoscreen"),debug:t("./meshes/debug"),dataBuffer:t("./buffer/databuffer"),arrayBuffer:t("./buffer/arraybuffer"),matrixBuffer:t("./buffer/matrixbuffer"),voxelBuffer:t("./buffer/voxelbuffer"),pushBuffer:t("./buffer/pushbuffer"),renderToTexture:t("./buffer/rendertotexture"),memo:t("./buffer/memo"),readback:t("./buffer/readback"),atlas:t("./buffer/atlas"),textAtlas:t("./buffer/textatlas"),scene:t("./scene")};e.exports=i},{"./buffer/arraybuffer":114,"./buffer/atlas":115,"./buffer/databuffer":117,"./buffer/matrixbuffer":118,"./buffer/memo":119,"./buffer/pushbuffer":120,"./buffer/readback":121,"./buffer/rendertotexture":122,"./buffer/textatlas":123,"./buffer/voxelbuffer":127,"./meshes/arrow":141,"./meshes/debug":143,"./meshes/face":144,"./meshes/line":145,"./meshes/memoscreen":146,"./meshes/point":147,"./meshes/screen":148,"./meshes/sprite":149,"./meshes/strip":150,"./meshes/surface":151,"./scene":153}],129:[function(t,e,r){var i;i=function(){function t(t,e,r){this.classes=t;this.renderer=e;this.shaders=r}t.prototype.getTypes=function(){return Object.keys(this.classes)};t.prototype.make=function(t,e){return new this.classes[t](this.renderer,this.shaders,e)};return t}();e.exports=i},{}],130:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./clipgeometry");i=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,N,I,j,G,W,X,q,Y;e.__super__.constructor.call(this,t);this._clipUniforms();this.sides=N=+t.sides||12;this.samples=V=+t.samples||2;this.strips=j=+t.strips||1;this.ribbons=B=+t.ribbons||1;this.layers=_=+t.layers||1;this.flip=d=(A=t.flip)!=null?A:false;this.anchor=i=(C=t.anchor)!=null?C:d?0:V-1;s=j*B*_;H=(N+2)*s;W=N*2*s;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(W*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(H*4),4));this.addAttribute("arrow",new THREE.BufferAttribute(new Float32Array(H*3),3));this.addAttribute("attach",new THREE.BufferAttribute(new Float32Array(H*2),2));this._autochunk();v=this._emitter("index");M=this._emitter("position4");o=this._emitter("arrow");a=this._emitter("attach");c=[];for(y=g=0,L=N;0<=L?g<L:g>L;y=0<=L?++g:--g){n=y/N*τ;c.push([Math.cos(n),Math.sin(n),1])}h=0;for(m=x=0,P=s;0<=P?x<P:x>P;m=0<=P?++x:--x){G=h++;l=G+N+1;for(y=b=0,z=N;0<=z?b<z:b>z;y=0<=z?++b:--b){r=h+y%N;u=h+(y+1)%N;v(G);v(r);v(u);v(u);v(r);v(l)}h+=N+1}I=d?1:-1;p=d?V-1:0;T=i+I;X=i;for(E=w=0,D=_;0<=D?w<D:w>D;E=0<=D?++w:--w){for(Y=R=0,O=B;0<=O?R<O:R>O;Y=0<=O?++R:--R){for(q=S=0,F=j;0<=F?S<F:S>F;q=0<=F?++S:--S){M(X,q,Y,E);o(0,0,0);a(T,p);for(y=k=0,U=N;0<=U?k<U:k>U;y=0<=U?++k:--k){M(X,q,Y,E);f=c[y];o(f[0],f[1],f[2]);a(T,p)}M(X,q,Y,E);o(0,0,1);a(T,p)}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){var n,o,s,a;if(t==null){t=this.samples}if(e==null){e=this.strips}if(r==null){r=this.ribbons}if(i==null){i=this.layers}a=Math.max(0,t-1);this._clipGeometry(t,e,r,i);if(t>this.anchor){n=[i,r,e];o=[this.layers,this.ribbons,this.strips];s=this.sides*this._reduce(n,o)}else{s=0}return this._offsets([{start:0,count:s*6}])};return e}(n);e.exports=i},{"./clipgeometry":131}],131:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;n=t("./geometry");o=false;s=function(){var t;t=+new Date;return function(e){var r;r=+new Date-t;console.log(e,r+" ms");return r}};i=function(t){a(e,t);function e(){return e.__super__.constructor.apply(this,arguments)}e.prototype._clipUniforms=function(){this.geometryClip=new THREE.Vector4(1e10,1e10,1e10,1e10);this.geometryResolution=new THREE.Vector4;this.mapSize=new THREE.Vector4;if(this.uniforms==null){this.uniforms={}}this.uniforms.geometryClip={type:"v4",value:this.geometryClip};this.uniforms.geometryResolution={type:"v4",value:this.geometryResolution};return this.uniforms.mapSize={type:"v4",value:this.mapSize}};e.prototype._clipGeometry=function(t,e,r,i){var n,o;n=function(t){return Math.max(0,t-1)};o=function(t){return 1/Math.max(1,t-1)};this.geometryClip.set(n(t),n(e),n(r),n(i));return this.geometryResolution.set(o(t),o(e),o(r),o(i))};e.prototype._clipMap=function(t,e,r,i){return this.mapSize.set(t,e,r,i)};e.prototype._clipOffsets=function(t,e,r,i,n,o,s,a,u){var l,h,f;l=[i,r,e,n];f=[a,s,o,u];h=this._reduce(l,f);return this._offsets([{start:0,count:h*t}])};return e}(n);e.exports=i},{"./geometry":133}],132:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./clipgeometry");n=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A;e.__super__.constructor.call(this,t);this._clipUniforms();this.items=a=+t.items||2;this.width=M=+t.width||1;this.height=n=+t.height||1;this.depth=i=+t.depth||1;this.sides=R=Math.max(0,a-2);w=M*n*i;m=a*w;H=R*w;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(H*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(m*4),4));this._autochunk();s=this._emitter("index");v=this._emitter("position4");r=0;for(o=l=0,y=w;0<=y?l<y:l>y;o=0<=y?++l:--l){for(u=f=0,E=R;0<=E?f<E:f>E;u=0<=E?++f:--f){s(r);s(r+u+1);s(r+u+2)}r+=a}for(A=c=0,_=i;0<=_?c<_:c>_;A=0<=_?++c:--c){for(k=p=0,x=n;0<=x?p<x:p>x;k=0<=x?++p:--p){for(S=d=0,b=M;0<=b?d<b:d>b;S=0<=b?++d:--d){for(h=g=0,T=a;0<=T?g<T:g>T;h=0<=T?++g:--g){v(S,k,A,h)}}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){var n;if(t==null){t=this.width}if(e==null){e=this.height}if(r==null){r=this.depth}if(i==null){i=this.items}n=Math.max(0,i-2);this._clipGeometry(t,e,r,i);return this._clipOffsets(3,t,e,r,n,this.width,this.height,this.depth,this.sides)};return e}(i);e.exports=n},{"./clipgeometry":131}],133:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=false;o=function(){var t;t=+new Date;return function(e){var r;r=+new Date-t;console.log(e,r+" ms");return r}};i=function(t){s(e,t);function e(){THREE.BufferGeometry.call(this);if(this.uniforms==null){this.uniforms={}}if(this.offsets==null){this.offsets=[]}if(n){this.tock=o()}this.chunked=false;this.limit=65535}e.prototype._reduce=function(t,e){var r,i,n,o,s,a,u;a=false;for(i=n=0,o=t.length;n<o;i=++n){r=t[i];s=e[i];if(a){t[i]=s}if(r>1){a=true}}return u=t.reduce(function(t,e){return t*e})};e.prototype._emitter=function(t){var e,r,i,n,o,s,a,u;r=this.attributes[t];i=r.itemSize;e=r.array;o=0;s=function(t){return e[o++]=t};u=function(t,r){e[o++]=t;return e[o++]=r};a=function(t,r,i){e[o++]=t;e[o++]=r;return e[o++]=i};n=function(t,r,i,n){e[o++]=t;e[o++]=r;e[o++]=i;return e[o++]=n};return[null,s,u,a,n][i]};e.prototype._autochunk=function(){var t,e,r,i,n,o;r=this.attributes.index;o=this.attributes;for(i in o){e=o[i];if(i!=="index"&&r){n=e.array.length/e.itemSize;if(n>this.limit){this.chunked=true}break}}if(this.chunked&&!r.u16){r.u16=t=r.array;return r.array=new Uint32Array(t.length)}};e.prototype._finalize=function(){var t;if(!this.chunked){return}t=this.attributes.index;this.chunks=this._chunks(t.array,this.limit);this._chunkify(t,this.chunks);if(n){return this.tock(this.constructor.name)}};e.prototype._chunks=function(t,e){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;n=[];p=0;y=t[0];o=t[0];v=function(t){var e,r,i;i=p*3;r=t*3;e=r-i;return n.push({index:y,start:i,count:e,end:r})};d=Math.floor(t.length/3);m=0;for(s=a=0,g=d;0<=g?a<g:a>g;s=0<=g?++a:--a){u=t[m++];l=t[m++];h=t[m++];c=Math.min(u,l,h);f=Math.max(u,l,h);r=Math.min(y,c);i=Math.max(o,f);if(i-r>e){v(s);r=c;i=f;p=s}y=r;o=i}v(d);return n};e.prototype._chunkify=function(t,e){var r,i,n,o,s,a,u,l,h,f;if(!t.u16){return}i=t.array;f=t.u16;for(o=0,a=e.length;o<a;o++){r=e[o];u=r.index;for(n=s=l=r.start,h=r.end;l<=h?s<h:s>h;n=l<=h?++s:--s){f[n]=i[n]-u}}t.array=t.u16;return delete t.u16};e.prototype._offsets=function(t){var e,r,i,n,o,s,a,u,l,h,f,c;if(!this.chunked){this.offsets=t}else{n=this.chunks;f=this.offsets;f.length=null;for(s=0,u=t.length;s<u;s++){h=t[s];c=h.start;o=h.count-c;for(a=0,l=n.length;a<l;a++){i=n[a];r=i.start;e=i.end;if(c<=r&&o>r||c<e&&o>=e||c>r&&o<e){r=Math.max(c,r);e=Math.min(o,e);f.push({index:i.index,start:r,count:e-r})}}}}return null};return e}(THREE.BufferGeometry);e.exports=i},{}],134:[function(t,e,r){r.Geometry=t("./geometry");r.ArrowGeometry=t("./arrowgeometry");r.FaceGeometry=t("./facegeometry");r.LineGeometry=t("./linegeometry");r.ScreenGeometry=t("./screengeometry");r.SpriteGeometry=t("./spritegeometry");r.StripGeometry=t("./stripgeometry");r.SurfaceGeometry=t("./surfacegeometry")},{"./arrowgeometry":130,"./facegeometry":132,"./geometry":133,"./linegeometry":135,"./screengeometry":136,"./spritegeometry":137,"./stripgeometry":138,"./surfacegeometry":139}],135:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./clipgeometry");n=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,N,I,j,G,W,X,q,Y,Z,K,Q,J,$,tt,et;e.__super__.constructor.call(this,t);this._clipUniforms();this.closed=i=t.closed||false;this.samples=I=(+t.samples||2)+(i?1:0);this.strips=W=+t.strips||1;this.ribbons=V=+t.ribbons||1;this.layers=v=+t.layers||1;this.detail=n=+t.detail||1;y=I-1;this.joints=p=n-1;this.vertices=K=(y-1)*p+I;this.segments=j=(y-1)*p+y;J=I-(i?1:0);T=K*W*V*v*2;H=j*W*V*v;q=H*2;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(q*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(T*4),4));this.addAttribute("line",new THREE.BufferAttribute(new Float32Array(T*2),2));this.addAttribute("strip",new THREE.BufferAttribute(new Float32Array(T*2),2));if(n>1){this.addAttribute("joint",new THREE.BufferAttribute(new Float32Array(T),1))}this._autochunk();l=this._emitter("index");w=this._emitter("position4");g=this._emitter("line");G=this._emitter("strip");if(n>1){c=this._emitter("joint")}r=0;for(a=_=0,S=V*v;0<=S?_<S:_>S;a=0<=S?++_:--_){for(h=x=0,k=W;0<=k?x<k:x>k;h=0<=k?++x:--x){for(d=b=0,L=j;0<=L?b<L:b>L;d=0<=L?++b:--b){l(r);l(r+1);l(r+2);l(r+2);l(r+1);l(r+3);r+=2}r+=2}}s=i?function(){return 0}:function(t){if(t===0){return-1}else if(t===I-1){return 1}else{return 0}};if(n>1){for(m=R=0,P=v;0<=P?R<P:R>P;m=0<=P?++R:--R){for(et=M=0,z=V;0<=z?M<z:M>z;et=0<=z?++M:--M){for(tt=N=0,D=W;0<=D?N<D:N>D;tt=0<=D?++N:--N){for($=X=0,O=I;0<=O?X<O:X>O;$=0<=O?++X:--X){if(i){$=$%J}o=s($);if(o!==0){w($,tt,et,m);w($,tt,et,m);g(o,1);g(o,-1);G(0,j);G(0,j);c(.5);c(.5)}else{for(E=Y=0,F=n;0<=F?Y<F:Y>F;E=0<=F?++Y:--Y){w($,tt,et,m);w($,tt,et,m);g(o,1);g(o,-1);G(0,j);G(0,j);c(E/p);c(E/p)}}}}}}}else{for(m=Z=0,U=v;0<=U?Z<U:Z>U;m=0<=U?++Z:--Z){for(et=Q=0,B=V;0<=B?Q<B:Q>B;et=0<=B?++Q:--Q){for(tt=u=0,A=W;0<=A?u<A:u>A;tt=0<=A?++u:--u){for($=f=0,C=I;0<=C?f<C:f>C;$=0<=C?++f:--f){if(i){$=$%J}o=s($);w($,tt,et,m);w($,tt,et,m);g(o,1);g(o,-1);G(0,j);G(0,j)}}}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){var n,o;if(t==null){t=this.samples-this.closed}if(e==null){e=this.strips}if(r==null){r=this.ribbons}if(i==null){i=this.layers}n=Math.max(0,t-(this.closed?0:1));o=t+(t-2)*this.joints;n=o-1;this._clipGeometry(o,e,r,i);return this._clipOffsets(6,n,e,r,i,this.segments,this.strips,this.ribbons,this.layers)};return e}(i);e.exports=n},{"./clipgeometry":131}],136:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;n=t("./surfacegeometry");i=function(t){o(e,t);function e(t){var r,i;if(this.uniforms==null){this.uniforms={}}this.uniforms.geometryScale={type:"v4",value:new THREE.Vector4};t.width=Math.max(2,(r=+t.width)!=null?r:2);t.height=Math.max(2,(i=+t.height)!=null?i:2);this.cover();e.__super__.constructor.call(this,t)}e.prototype.cover=function(t,e,r,i){this.scaleX=t!=null?t:1;this.scaleY=e!=null?e:1;this.scaleZ=r!=null?r:1;this.scaleW=i!=null?i:1};e.prototype.clip=function(t,r,i,n){var o;if(t==null){t=this.width}if(r==null){r=this.height}if(i==null){i=this.surfaces}if(n==null){n=this.layers}e.__super__.clip.call(this,t,r,i,n);o=function(t){return 1/Math.max(1,t-1)};return this.uniforms.geometryScale.value.set(o(t)*this.scaleX,o(r)*this.scaleY,o(i)*this.scaleZ,o(n)*this.scaleW)};return e}(n);e.exports=i},{"./surfacegeometry":139}],137:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./clipgeometry");n=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C;e.__super__.constructor.call(this,t);this._clipUniforms();this.items=a=+t.items||2;this.width=S=+t.width||1;this.height=n=+t.height||1;this.depth=i=+t.depth||1;w=a*S*n*i;v=w*4;H=w*2;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(H*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(v*4),4));this.addAttribute("sprite",new THREE.BufferAttribute(new Float32Array(v*2),2));this._autochunk();s=this._emitter("index");g=this._emitter("position4");R=this._emitter("sprite");y=[[-1,-1],[-1,1],[1,-1],[1,1]];r=0;for(o=u=0,E=w;0<=E?u<E:u>E;o=0<=E?++u:--u){s(r);s(r+1);s(r+2);s(r+1);s(r+2);s(r+3);r+=4}for(C=l=0,_=i;0<=_?l<_:l>_;C=0<=_?++l:--l){for(A=c=0,x=n;0<=x?c<x:c>x;A=0<=x?++c:--c){for(k=p=0,b=S;0<=b?p<b:p>b;k=0<=b?++p:--p){for(h=d=0,T=a;0<=T?d<T:d>T;h=0<=T?++d:--d){for(m=0,f=y.length;m<f;m++){M=y[m];g(k,A,C,h);R(M[0],M[1])}}}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){if(t==null){t=this.width}if(e==null){e=this.height}if(r==null){r=this.depth}if(i==null){i=this.items}this._clipGeometry(t,e,r,i);return this._clipOffsets(6,t,e,r,i,this.width,this.height,this.depth,this.items)};return e}(i);e.exports=n},{"./clipgeometry":131}],138:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./clipgeometry");n=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z;e.__super__.constructor.call(this,t);this._clipUniforms();this.items=u=+t.items||2;this.width=C=+t.width||1;this.height=o=+t.height||1;this.depth=i=+t.depth||1;this.sides=S=Math.max(0,u-2);M=C*o*i;g=u*M;A=S*M;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(A*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(g*4),4));this.addAttribute("strip",new THREE.BufferAttribute(new Float32Array(g*3),3));this._autochunk();a=this._emitter("index");y=this._emitter("position4");k=this._emitter("strip");r=0;for(s=h=0,x=M;0<=x?h<x:h>x;s=0<=x?++h:--h){m=r;for(l=p=0,b=S;0<=b?p<b:p>b;l=0<=b?++p:--p){if(l&1){a(m+1);a(m);a(m+2)}else{a(m);a(m+1);a(m+2)}m++}r+=u}c=u-1;for(z=d=0,T=i;0<=T?d<T:d>T;z=0<=T?++d:--d){for(P=v=0,w=o;0<=w?v<w:v>w;P=0<=w?++v:--v){for(L=E=0,R=C;0<=R?E<R:E>R;L=0<=R?++E:--E){n=1;y(L,P,z,0);k(1,2,n);for(f=_=1,H=c;1<=H?_<H:_>H;f=1<=H?++_:--_){y(L,P,z,f);k(f-1,f+1,n=-n)}y(L,P,z,c);k(c-2,c-1,-n)}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){var n;if(t==null){t=this.width}if(e==null){e=this.height}if(r==null){r=this.depth}if(i==null){i=this.items}n=Math.max(0,i-2);this._clipGeometry(t,e,r,i);return this._clipOffsets(3,t,e,r,n,this.width,this.height,this.depth,this.sides)};return e}(i);e.exports=n},{"./clipgeometry":131}],139:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./clipgeometry");n=function(t){o(e,t);function e(t){var r,i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,N,I,j;e.__super__.constructor.call(this,t);this._clipUniforms();this.closedX=i=t.closedX||false;this.closedY=n=t.closedY||false;this.width=U=(+t.width||2)+(i?1:0);this.height=l=(+t.height||2)+(n?1:0);this.surfaces=O=+t.surfaces||1;this.layers=m=+t.layers||1;B=U-(i?1:0);V=l-(n?1:0);this.segmentsX=P=Math.max(0,U-1);this.segmentsY=z=Math.max(0,l-1);_=U*l*O*m;T=P*z*O*m;F=T*2;this.addAttribute("index",new THREE.BufferAttribute(new Uint16Array(F*3),1));this.addAttribute("position4",new THREE.BufferAttribute(new Float32Array(_*4),4));this.addAttribute("surface",new THREE.BufferAttribute(new Float32Array(_*2),2));this._autochunk();f=this._emitter("index");x=this._emitter("position4");D=this._emitter("surface");r=0;for(h=v=0,R=O*m;0<=R?v<R:v>R;h=0<=R?++v:--v){for(c=g=0,H=z;0<=H?g<H:g>H;c=0<=H?++g:--g){for(p=y=0,M=P;0<=M?y<M:y>M;p=0<=M?++y:--y){f(r);f(r+1);f(r+U);f(r+U);f(r+1);f(r+U+1);r++}r++}r+=U}a=i?function(){return 0}:function(t){if(t===0){return-1}else if(t===P){return 1}else{return 0}};u=n?function(){return 0}:function(t){if(t===0){return-1}else if(t===z){return 1}else{return 0}};for(d=E=0,S=m;0<=S?E<S:E>S;d=0<=S?++E:--E){for(j=b=0,k=O;0<=k?b<k:b>k;j=0<=k?++b:--b){for(I=w=0,A=l;0<=A?w<A:w>A;I=0<=A?++w:--w){if(n){I=I%V}s=u(I);for(N=L=0,C=U;0<=C?L<C:L>C;N=0<=C?++L:--L){if(i){N=N%B}o=a(N);x(N,I,j,d);D(o,s)}}}}this._finalize();this.clip();return}e.prototype.clip=function(t,e,r,i){var n,o;if(t==null){t=this.width}if(e==null){e=this.height}if(r==null){r=this.surfaces}if(i==null){i=this.layers}n=Math.max(0,t-1);o=Math.max(0,e-1);this._clipGeometry(t,e,r,i);return this._clipOffsets(6,n,o,r,i,this.segmentsX,this.segmentsY,this.surfaces,this.layers)};e.prototype.map=function(t,e,r,i){if(t==null){t=this.width}if(e==null){e=this.height}if(r==null){r=this.surfaces}if(i==null){i=this.layers}return this._clipMap(t,e,r,i)};return e}(i);e.exports=n},{"./clipgeometry":131}],140:[function(t,e,r){r.Scene=t("./scene");r.Factory=t("./factory");r.Renderable=t("./scene");r.Classes=t("./classes")},{"./classes":128,"./factory":129,"./scene":153}],141:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;o=t("./base");n=t("../geometry").ArrowGeometry;i=function(t){s(e,t);function e(t,r,i){var o,s,a,u,l,h,f,c,p,d,m,v,g,y;e.__super__.constructor.call(this,t,r,i);g=i.uniforms,p=i.material,m=i.position,o=i.color,c=i.mask,f=i.map,s=i.combine,v=i.stpq,h=i.linear;if(g==null){g={}}l=g.styleColor!=null;this.geometry=new n({sides:i.sides,samples:i.samples,strips:i.strips,ribbons:i.ribbons,layers:i.layers,anchor:i.anchor,flip:i.flip});this._adopt(g);this._adopt(this.geometry.uniforms);u=r.material();y=u.vertex;y.pipe(this._vertexColor(o,c));y.require(this._vertexPosition(m,p,f,1,v));y.pipe("arrow.position",this.uniforms);y.pipe("project.position",this.uniforms);u.fragment=a=this._fragmentColor(l,p,o,c,f,1,v,s,h);a.pipe("fragment.color",this.uniforms);this.material=this._material(u.link({}));d=new THREE.Mesh(this.geometry,this.material);d.frustumCulled=false;d.matrixAutoUpdate=false;this._raw(d);this.renders=[d]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(o);e.exports=i},{"../geometry":134,"./base":142}],142:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("../renderable");o=t("../../util");i=function(t){s(e,t);function e(t,r,i){var n;e.__super__.constructor.call(this,t,r,i);this.zUnits=(n=i.zUnits)!=null?n:0}e.prototype.raw=function(){var t,e,r,i;i=this.renders;for(t=0,e=i.length;t<e;t++){r=i[t];this._raw(r)}return null};e.prototype.depth=function(t,e){var r,i,n,o;o=this.renders;for(r=0,i=o.length;r<i;r++){n=o[r];this._depth(n,t,e)}return null};e.prototype.polygonOffset=function(t,e){var r,i,n,o;o=this.renders;for(r=0,i=o.length;r<i;r++){n=o[r];this._polygonOffset(n,t,e)}return null};e.prototype.show=function(t,e,r){var i,n,o,s,a;s=this.renders;a=[];for(i=0,n=s.length;i<n;i++){o=s[i];a.push(this._show(o,t,e,r))}return a};e.prototype.hide=function(){var t,e,r,i;i=this.renders;for(t=0,e=i.length;t<e;t++){r=i[t];this._hide(r)}return null};e.prototype._material=function(t){var e,r,i,n,o,s,a,u;s=this.renderer.getPrecision();u="    precision "+s+" float;\n    precision "+s+" int;\nuniform mat4 modelMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;";e="    precision "+s+" float;\n    precision "+s+" int;\nuniform mat4 viewMatrix;\nuniform vec3 cameraPosition;";o=new THREE.RawShaderMaterial(t);a=["vertexGraph","fragmentGraph"];for(r=0,n=a.length;r<n;r++){i=a[r];o[i]=t[i]}o.vertexShader=[u,o.vertexShader].join("\n");o.fragmentShader=[e,o.fragmentShader].join("\n");return o};e.prototype._raw=function(t){t.rotationAutoUpdate=false;t.frustumCulled=false;t.matrixAutoUpdate=false;return t.material.defaultAttributeValues=void 0};e.prototype._depth=function(t,e,r){var i;i=t.material;i.depthWrite=e;return i.depthTest=r};e.prototype._polygonOffset=function(t,e,r){var i,n;r-=this.zUnits;i=r!==0;n=t.material;n.polygonOffset=i;if(i){n.polygonOffsetFactor=e;return n.polygonOffsetUnits=r}};e.prototype._show=function(t,e,r,i){var n;e=true;n=t.material;t.renderOrder=-i;t.visible=true;n.transparent=e;n.blending=r;return null};e.prototype._hide=function(t){return t.visible=false};e.prototype._vertexColor=function(t,e){var r;if(!(t||e)){return}r=this.shaders.shader();if(t){r.require(t);r.pipe("mesh.vertex.color",this.uniforms)}if(e){r.require(e);r.pipe("mesh.vertex.mask",this.uniforms)}return r};e.prototype._vertexPosition=function(t,e,r,i,n){var o,s;s=this.shaders.shader();if(r||e&&e!==true){o={};if(i>0||n){o.POSITION_MAP=""}if(i>0){o[["POSITION_U","POSITION_UV","POSITION_UVW","POSITION_UVWO"][i-1]]=""}if(n){o.POSITION_STPQ=""}}s.require(t);return s.pipe("mesh.vertex.position",this.uniforms,o)};e.prototype._fragmentColor=function(t,e,r,i,n,s,a,u,l){var h,f,c,p;f=this.shaders.shader();p=false;c=false;h={};if(s>0){h[["POSITION_U","POSITION_UV","POSITION_UVW","POSITION_UVWO"][s-1]]=""}if(a){h.POSITION_STPQ=""}if(t){f.pipe("style.color",this.uniforms);p=true;if(r||n||e){if(!l||r){f.pipe("mesh.gamma.in")}c=true}}if(r){f.isolate();f.pipe("mesh.fragment.color",this.uniforms);if(!l||p){f.pipe("mesh.gamma.in")}f.end();if(p){f.pipe(o.GLSL.binaryOperator("vec4","*"))}if(l&&p){f.pipe("mesh.gamma.out")}p=true;c=true}if(n){if(!p&&u){f.pipe(o.GLSL.constant("vec4","vec4(1.0)"))}f.isolate();f.require(n);f.pipe("mesh.fragment.map",this.uniforms,h);if(!l){f.pipe("mesh.gamma.in")}f.end();if(u){f.pipe(u)}else{if(p){f.pipe(o.GLSL.binaryOperator("vec4","*"))}}p=true;c=true}if(e){if(!p){f.pipe(o.GLSL.constant("vec4","vec4(1.0)"))}if(e===true){f.pipe("mesh.fragment.shaded",this.uniforms)}else{f.require(e);f.pipe("mesh.fragment.material",this.uniforms,h)}c=true}if(c&&!l){f.pipe("mesh.gamma.out")}if(i){f.pipe("mesh.fragment.mask",this.uniforms);if(p){f.pipe(o.GLSL.binaryOperator("vec4","*"))}}return f};return e}(n);e.exports=i},{"../../util":166,"../renderable":152}],143:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./base");n=function(t){o(e,t);function e(t,r,i){var n;e.__super__.constructor.call(this,t,r,i);this.geometry=new THREE.PlaneGeometry(1,1);this.material=new THREE.MeshBasicMaterial({map:i.map});this.material.side=THREE.DoubleSide;n=new THREE.Mesh(this.geometry,this.material);n.position.x+=i.x||0;n.position.y+=i.y||0;n.frustumCulled=false;n.scale.set(2,2,2);n.__debug=true;this.objects=[n]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.objects=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"./base":142}],144:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./base");o=t("../geometry").FaceGeometry;n=function(t){s(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y;e.__super__.constructor.call(this,t,r,i);g=i.uniforms,p=i.material,m=i.position,n=i.color,c=i.mask,f=i.map,s=i.combine,v=i.stpq,h=i.linear;if(g==null){g={}}if(p==null){p=true}l=g.styleColor!=null;this.geometry=new o({items:i.items,width:i.width,height:i.height,depth:i.depth});this._adopt(g);this._adopt(this.geometry.uniforms);u=r.material();y=u.vertex;y.pipe(this._vertexColor(n,c));y.require(this._vertexPosition(m,p,f,2,v));if(!p){y.pipe("face.position",this.uniforms)}if(p){y.pipe("face.position.normal",this.uniforms)}y.pipe("project.position",this.uniforms);u.fragment=a=this._fragmentColor(l,p,n,c,f,2,v,s,h);a.pipe("fragment.color",this.uniforms);this.material=this._material(u.link({side:THREE.DoubleSide}));d=new THREE.Mesh(this.geometry,this.material);this._raw(d);this.renders=[d]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../geometry":134,"./base":142}],145:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./base");o=t("../geometry").LineGeometry;n=function(t){s(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R;e.__super__.constructor.call(this,t,r,i);w=i.uniforms,g=i.material,E=i.position,s=i.color,v=i.mask,m=i.map,a=i.combine,b=i.stpq,d=i.linear,n=i.clip,T=i.stroke,p=i.join,_=i.proximity;if(w==null){w={}}T=[null,"dotted","dashed"][T];c=w.styleColor!=null;p=(x=["miter","round","bevel"][p])!=null?x:"miter";l={miter:1,round:4,bevel:2}[p];this.geometry=new o({samples:i.samples,strips:i.strips,ribbons:i.ribbons,layers:i.layers,anchor:i.anchor,closed:i.closed,detail:l});this._adopt(w);this._adopt(this.geometry.uniforms);f=r.material();u={};if(T){u.LINE_STROKE=""}if(n){u.LINE_CLIP=""}if(_!=null){u.LINE_PROXIMITY=""}u["LINE_JOIN_"+p.toUpperCase()]="";if(l>1){u["LINE_JOIN_DETAIL"]=l}R=f.vertex;R.pipe(this._vertexColor(s,v));R.require(this._vertexPosition(E,g,m,2,b));R.pipe("line.position",this.uniforms,u);R.pipe("project.position",this.uniforms);h=f.fragment;if(T){h.pipe("fragment.clip."+T,this.uniforms)}if(n){h.pipe("fragment.clip.ends",this.uniforms)}if(_!=null){h.pipe("fragment.clip.proximity",this.uniforms)}h.pipe(this._fragmentColor(c,g,s,v,m,2,b,a,d));h.pipe("fragment.color",this.uniforms);this.material=this._material(f.link({side:THREE.DoubleSide}));y=new THREE.Mesh(this.geometry,this.material);this._raw(y);this.renders=[y]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../geometry":134,"./base":142}],146:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;n=t("./screen");o=t("../../util");i=function(t){s(e,t);function e(t,r,i){var n,o,s,a,u,l,h,f,c,p,d,m;this.memo=(l=i.items,m=i.width,o=i.height,n=i.depth,d=i.stpq,i);a=function(t){return 1/Math.max(1,t)};u=function(t){return 1/Math.max(1,t-1)};this.uniforms={remapUVScale:{type:"v2",value:new THREE.Vector2(l*m,o*n)},remapModulus:{type:"v2",value:new THREE.Vector2(l,o)},remapModulusInv:{type:"v2",value:new THREE.Vector2(a(l),a(o))},remapSTPQScale:{type:"v4",value:new THREE.Vector4(u(m),u(o),u(n),u(l))}};f=r.shader();f.pipe("screen.map.xyzw",this.uniforms);if(i.map!=null){if(d){f.pipe("screen.map.stpq",this.uniforms)}f.pipe(i.map)}e.__super__.constructor.call(this,t,r,{map:f,linear:true});p=this.renders;for(s=0,h=p.length;s<h;s++){c=p[s];c.transparent=false}null}e.prototype.cover=function(t,e,r,i){var n,o,s;if(t==null){t=this.memo.width}if(e==null){e=this.memo.height}if(r==null){r=this.memo.depth}if(i==null){i=this.memo.items}n=function(t){return 1/Math.max(1,t-1)};this.uniforms.remapSTPQScale.value.set(n(t),n(e),n(r),n(i));o=t/this.memo.width;s=r/this.memo.depth;if(this.memo.depth===1){s=e/this.memo.height}return this.geometry.cover(o,s)};return e}(n);e.exports=i},{"../../util":166,"./screen":148}],147:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./base");o=t("../geometry").SpriteGeometry;n=function(t){s(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S,k,A,C,L,P,z,D;e.__super__.constructor.call(this,t,r,i);z=i.uniforms,_=i.material,w=i.position,u=i.color,L=i.size,E=i.mask,y=i.map,l=i.combine,g=i.linear,A=i.shape,x=i.optical,d=i.fill,P=i.stpq;if(z==null){z={}}A=(R=+A)!=null?R:0;if(d==null){d=true}v=z.styleColor!=null;C=["circle","square","diamond","up","down","left","right"];T=["circle","generic","generic","generic","generic","generic","generic"];k=[1.2,1,1.414,1.16,1.16,1.16,1.16];b=(H=T[A])!=null?H:T[0];s=(M=C[A])!=null?M:C[0];n=(S=x&&k[A])!=null?S:1;a=d?b:b+".hollow";this.geometry=new o({items:i.items,width:i.width,height:i.height,depth:i.depth});this._adopt(z);this._adopt(this.geometry.uniforms);h={POINT_SHAPE_SCALE:+(n+1e-5)};p=r.material();D=p.vertex;D.pipe(this._vertexColor(u,E));if(L){D.isolate();D.require(L);D.require("point.size.varying",this.uniforms);D.end()}else{D.require("point.size.uniform",this.uniforms)}D.require(this._vertexPosition(w,_,y,2,P));D.pipe("point.position",this.uniforms,h);D.pipe("project.position",this.uniforms);p.fragment=c=this._fragmentColor(v,_,u,E,y,2,P,l,g);f=r.material();f.vertex.pipe(D);c=f.fragment.pipe(p.fragment);c.require("point.mask."+s,this.uniforms);c.require("point.alpha."+a,this.uniforms);c.pipe("point.edge",this.uniforms);m=r.material();m.vertex.pipe(D);c=m.fragment.pipe(p.fragment);c.require("point.mask."+s,this.uniforms);c.require("point.alpha."+a,this.uniforms);c.pipe("point.fill",this.uniforms);this.fillMaterial=this._material(m.link({side:THREE.DoubleSide}));this.edgeMaterial=this._material(f.link({side:THREE.DoubleSide}));this.fillObject=new THREE.Mesh(this.geometry,this.fillMaterial);this.edgeObject=new THREE.Mesh(this.geometry,this.edgeMaterial);this._raw(this.fillObject);this._raw(this.edgeObject);this.renders=[this.fillObject,this.edgeObject]}e.prototype.show=function(t,e,r,i){this._show(this.edgeObject,true,e,r,i);return this._show(this.fillObject,t,e,r,i)};e.prototype.dispose=function(){this.geometry.dispose();this.edgeMaterial.dispose();this.fillMaterial.dispose();this.renders=this.edgeObject=this.fillObject=this.geometry=this.edgeMaterial=this.fillMaterial=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../geometry":134,"./base":142}],148:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("./base");o=t("../geometry").ScreenGeometry;s=t("../../util");n=function(t){a(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d;e.__super__.constructor.call(this,t,r,i);p=i.uniforms,h=i.map,n=i.combine,c=i.stpq,l=i.linear;if(p==null){p={}}u=p.styleColor!=null;this.geometry=new o({width:i.width,height:i.height});this._adopt(p);this._adopt(this.geometry.uniforms);a=r.material();d=a.vertex;d.pipe("raw.position.scale",this.uniforms);d.fan();d.pipe("stpq.xyzw.2d",this.uniforms);d.next();d.pipe("screen.position",this.uniforms);d.join();a.fragment=s=this._fragmentColor(u,false,null,null,h,2,c,n,l);s.pipe("fragment.color",this.uniforms);this.material=this._material(a.link({side:THREE.DoubleSide}));f=new THREE.Mesh(this.geometry,this.material);f.frustumCulled=false;this._raw(f);this.renders=[f]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../../util":166,"../geometry":134,"./base":142}],149:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./base");o=t("../geometry").SpriteGeometry;n=function(t){s(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_;e.__super__.constructor.call(this,t,r,i);E=i.uniforms,m=i.material,v=i.position,g=i.sprite,p=i.map,s=i.combine,c=i.linear,n=i.color,d=i.mask,y=i.stpq;if(E==null){E={}}f=E.styleColor!=null;this.geometry=new o({items:i.items,width:i.width,height:i.height,depth:i.depth});this._adopt(E);this._adopt(this.geometry.uniforms);l=r.material();_=l.vertex;_.pipe(this._vertexColor(n,d));_.require(this._vertexPosition(v,m,p,2,y));_.require(g);_.pipe("sprite.position",this.uniforms);_.pipe("project.position",this.uniforms);l.fragment=u=this._fragmentColor(f,m,n,d,p,2,y,s,c);a=r.material();a.vertex.pipe(_);a.fragment.pipe(u);a.fragment.pipe("fragment.transparent",this.uniforms);h=r.material();h.vertex.pipe(_);h.fragment.pipe(u);h.fragment.pipe("fragment.solid",this.uniforms);this.fillMaterial=this._material(h.link({side:THREE.DoubleSide}));this.edgeMaterial=this._material(a.link({side:THREE.DoubleSide}));this.fillObject=new THREE.Mesh(this.geometry,this.fillMaterial);this.edgeObject=new THREE.Mesh(this.geometry,this.edgeMaterial);this._raw(this.fillObject);this._raw(this.edgeObject);this.renders=[this.fillObject,this.edgeObject]}e.prototype.show=function(t,e,r,i){this._show(this.edgeObject,true,e,r,i);return this._show(this.fillObject,t,e,r,i)};e.prototype.dispose=function(){this.geometry.dispose();this.edgeMaterial.dispose();this.fillMaterial.dispose();this.nreders=this.geometry=this.edgeMaterial=this.fillMaterial=this.edgeObject=this.fillObject=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../geometry":134,"./base":142}],150:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty;i=t("./base");o=t("../geometry").StripGeometry;n=function(t){s(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y;e.__super__.constructor.call(this,t,r,i);g=i.uniforms,p=i.material,m=i.position,n=i.color,c=i.mask,f=i.map,s=i.combine,h=i.linear,v=i.stpq;if(g==null){g={}}if(p==null){p=true}l=g.styleColor!=null;this.geometry=new o({items:i.items,width:i.width,height:i.height,depth:i.depth});this._adopt(g);this._adopt(this.geometry.uniforms);u=r.material();y=u.vertex;y.pipe(this._vertexColor(n,c));y.require(this._vertexPosition(m,p,f,2,v));if(!p){y.pipe("mesh.position",this.uniforms)}if(p){y.pipe("strip.position.normal",this.uniforms)}y.pipe("project.position",this.uniforms);u.fragment=a=this._fragmentColor(l,p,n,c,f,2,v,s,h);a.pipe("fragment.color",this.uniforms);this.material=this._material(u.link({side:THREE.DoubleSide}));d=new THREE.Mesh(this.geometry,this.material);this._raw(d);this.renders=[d]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../geometry":134,"./base":142}],151:[function(t,e,r){var i,n,o,s,a=function(t,e){for(var r in e){if(u.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},u={}.hasOwnProperty;i=t("./base");o=t("../geometry").SurfaceGeometry;s=t("../../util");n=function(t){a(e,t);function e(t,r,i){var n,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;e.__super__.constructor.call(this,t,r,i);_=i.uniforms,v=i.material,y=i.position,n=i.color,m=i.mask,d=i.map,s=i.combine,p=i.linear,E=i.stpq,c=i.intUV;if(_==null){_={}}if(v==null){v=true}f=_.styleColor!=null;h=_.surfaceHollow!=null;this.geometry=new o({width:i.width,height:i.height,surfaces:i.surfaces,layers:i.layers,closedX:i.closedX,closedY:i.closedY});this._adopt(_);this._adopt(this.geometry.uniforms);l=r.material();x=l.vertex;if(c){a={POSITION_UV_INT:""}}x.pipe(this._vertexColor(n,m));x.require(this._vertexPosition(y,v,d,2,E));if(!v){x.pipe("surface.position",this.uniforms,a)}if(v){x.pipe("surface.position.normal",this.uniforms,a)}x.pipe("project.position",this.uniforms);l.fragment=u=this._fragmentColor(f,v,n,m,d,2,E,s,p);u.pipe("fragment.color",this.uniforms);this.material=this._material(l.link({side:THREE.DoubleSide}));g=new THREE.Mesh(this.geometry,this.material);this._raw(g);this.renders=[g]}e.prototype.dispose=function(){this.geometry.dispose();this.material.dispose();this.renders=this.geometry=this.material=null;return e.__super__.dispose.apply(this,arguments)};return e}(i);e.exports=n},{"../../util":166,"../geometry":134,"./base":142}],152:[function(t,e,r){var i;i=function(){function t(t,e){this.renderer=t;this.shaders=e;this.gl=this.renderer.context;if(this.uniforms==null){this.uniforms={}}}t.prototype.dispose=function(){return this.uniforms=null};t.prototype._adopt=function(t){var e,r;for(e in t){r=t[e];this.uniforms[e]=r}};t.prototype._set=function(t){var e,r;for(e in t){r=t[e];if(this.uniforms[e]!=null){this.uniforms[e].value=r}}};return t}();e.exports=i},{}],153:[function(t,e,r){var i,n,o,s=function(t,e){for(var r in e){if(a.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},a={}.hasOwnProperty,u=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};n=t("./renderable");i=function(t){s(e,t);function e(){e.__super__.constructor.apply(this,arguments);this.rotationAutoUpdate=false;this.frustumCulled=false;this.matrixAutoUpdate=false}return e}(THREE.Object3D);o=function(t){s(e,t);function e(t,r,n){e.__super__.constructor.call(this,t,r,n);this.root=new i;if((n!=null?n.scene:void 0)!=null){this.scene=n.scene}if(this.scene==null){this.scene=new THREE.Scene}this.pending=[];this.async=0;this.scratch=new THREE.WebGLRenderTarget(1,1);this.camera=new THREE.PerspectiveCamera}e.prototype.inject=function(t){if(t!=null){this.scene=t}return this.scene.add(this.root)};e.prototype.unject=function(){var t;return(t=this.scene)!=null?t.remove(this.root):void 0};e.prototype.add=function(t){if(this.async){return this.pending.push(t)}else{return this._add(t)}};e.prototype.remove=function(t){this.pending=this.pending.filter(function(e){return e!==t});if(t.parent!=null){return this._remove(t)}};e.prototype._add=function(t){return this.root.add(t)};e.prototype._remove=function(t){return this.root.remove(t)};e.prototype.dispose=function(){if(this.root.parent!=null){return this.unject()}};e.prototype.warmup=function(t){return this.async=+t||0};e.prototype.render=function(){var t,e,r,i,n,o,s;if(!this.pending.length){return}e=this.root.children;t=[];for(r=i=0,o=this.async;0<=o?i<o:i>o;r=0<=o?++i:--i){n=this.pending.shift();if(!n){break}this._add(n);t.push(t)}s=e.map(function(t){var e;return e=t.visible});e.map(function(e){return e.visible=u.call(t,e)<0});this.renderer.render(this.scene,this.camera,this.scratch);return e.map(function(t,e){return t.visible=s[e]})};e.prototype.toJSON=function(){return this.root.toJSON()};return e}(n);e.exports=o},{"./renderable":152}],154:[function(t,e,r){var i,n;n=t("../../vendor/shadergraph/src");i=function(t){var e;e=function(e){var r,i,n,o,s;o=t[e];if(o!=null){return o}i=(n=e[0])==="#"||n==="."||n===":"||n==="[";s=i?e:"#"+e;r=document.querySelector(s);if(r!=null&&r.tagName==="SCRIPT"){return r.textContent||r.innerText}throw new Error("Unknown shader `"+e+"`")};return new n(e,{autoInspect:true})};e.exports=i},{"../../vendor/shadergraph/src":195}],155:[function(t,e,r){r.Factory=t("./factory");r.Snippets=t("../../build/shaders")},{"../../build/shaders":1,"./factory":154}],156:[function(t,e,r){THREE.Bootstrap.registerPlugin("splash",{defaults:{color:"mono",fancy:true},listen:["ready","mathbox/init:init","mathbox/progress:progress","mathbox/destroy:destroy"],uninstall:function(){return this.destroy()},ready:function(t,e){if(e.MathBox&&!this.div){return init(t,e)}},init:function(t,e){var r,i,n,o,s,a,u;this.destroy();r=this.options.color;n='<div class="mathbox-loader mathbox-splash-'+r+'">\n  <div class="mathbox-logo">\n    <div> <div></div><div></div><div></div> </div>\n    <div> <div></div><div></div><div></div> </div>\n  </div>\n  <div class="mathbox-progress"><div></div></div>\n</div>';this.div=i=document.createElement("div");i.innerHTML=n;e.element.appendChild(i);s=Math.random()*2-1;a=Math.random()*2-1;u=Math.random()*2-1;o=1/Math.sqrt(s*s+a*a+u*u);this.loader=i.querySelector(".mathbox-loader");this.bar=i.querySelector(".mathbox-progress > div");this.gyro=i.querySelectorAll(".mathbox-logo > div");this.transforms=["rotateZ(22deg) rotateX(24deg) rotateY(30deg)","rotateZ(11deg) rotateX(12deg) rotateY(15deg) scale3d(.6, .6, .6)"];this.random=[s*o,a*o,u*o];this.start=e.Time.now;return this.timer=null},progress:function(t,e){var r,i,n,o,s,a,u,l,h,f,c,p,d,m;if(!this.div){return}r=t.current,c=t.total;p=r<c;clearTimeout(this.timer);if(p){this.loader.classList.remove("mathbox-exit");this.loader.style.display="block"}else{this.loader.classList.add("mathbox-exit");this.timer=setTimeout(function(t){return function(){return t.loader.style.display="none"}}(this),150)}m=r<c?Math.round(1e3*r/c)*.1+"%":"100%";this.bar.style.width=m;if(this.options.fancy){d=this.random;n=Math.max(0,Math.min(1,e.Time.now-this.start));s=function(t,r){if(r==null){r=0}return t.replace(/(-?[0-9.e]+)deg/g,function(t,i){return+i+d[r++]*n*e.Time.step*60+"deg"})};l=this.gyro;h=[];for(o=a=0,u=l.length;a<u;o=++a){i=l[o];this.transforms[o]=f=s(this.transforms[o]);h.push(i.style.transform=i.style.WebkitTransform=f)}return h}},destroy:function(){var t;if((t=this.div)!=null){t.remove()}return this.div=null}})},{}],157:[function(t,e,r){var i,n,o;o=t("../util").Ease;n=function(){function t(t){this.context=t;this.anims=[]}t.prototype.make=function(t,e){var r;r=new i(this,this.context.time,t,e);this.anims.push(r);return r};t.prototype.unmake=function(t){var e;return this.anims=function(){var r,i,n,o;n=this.anims;o=[];for(r=0,i=n.length;r<i;r++){e=n[r];if(e!==t){o.push(e)}}return o}.call(this)};t.prototype.update=function(){var t,e;e=this.context.time;return this.anims=function(){var r,i,n,o;n=this.anims;o=[];for(r=0,i=n.length;r<i;r++){t=n[r];if(t.update(e)!==false){o.push(t)}}return o}.call(this)};t.prototype.lerp=function(t,e,r,i,n){var o,s,a,u;if(n==null){n=t.make()}if(t.lerp){n=t.lerp(e,r,n,i)}else if(t.emitter){s=e.emitterFrom;u=r.emitterTo;if(s!=null&&u!=null&&s===u){s.lerp(i);return s}else{o=t.emitter(e,r);e.emitterFrom=o;r.emitterTo=o;o.lerp(i);return o}}else if(t.op){a=function(t,e){if(t===+t&&e===+e){return t+(e-t)*i}else{if(i>.5){return e}else{return t}}};n=t.op(e,r,n,a)}else{n=i>.5?r:e}return n};return t}();i=function(){function t(t,e,r,i){this.animator=t;this.time=e;this.type=r;this.options=i;this.value=this.type.make();this.target=this.type.make();this.queue=[]}t.prototype.dispose=function(){return this.animator.unmake(this)};t.prototype.set=function(){var t,e,r;e=this.target;r=arguments.length>1?[].slice.call(arguments):arguments[0];t=false;r=this.type.validate(r,e,function(){return t=true});if(!t){e=r}this.cancel();this.target=this.value;this.value=e;return this.notify()};t.prototype.getTime=function(){var t,e;t=this.options.clock;e=t?t.getTime():this.time;if(this.options.realtime){return e.time}else{return e.clock}};t.prototype.cancel=function(t){var e,r,i,n,o,s;if(t==null){t=this.getTime()}o=this.queue;r=function(){var e,r,i;i=[];for(e=0,r=o.length;e<r;e++){s=o[e];if(s.end>=t){i.push(s)}}return i}();this.queue=function(){var e,r,i;i=[];for(e=0,r=o.length;e<r;e++){s=o[e];if(s.end<t){i.push(s)}}return i}();for(i=0,n=r.length;i<n;i++){s=r[i];if(typeof s.complete==="function"){s.complete(false)}}if(typeof(e=this.options).complete==="function"){e.complete(false)}};t.prototype.notify=function(){var t;return typeof(t=this.options).step==="function"?t.step(this.value):void 0};t.prototype.immediate=function(t,e){var r,i,n,o,s,a,u,l,h,f;n=e.duration,i=e.delay,o=e.ease,l=e.step,r=e.complete;f=this.getTime();u=f+i;s=u+n;a=false;h=this.type.make();t=this.type.validate(t,h,function(){a=true;return null});if(t!==void 0){h=t}this.cancel(u);return this.queue.push({from:null,to:h,start:u,end:s,ease:o,step:l,complete:r})};t.prototype.update=function(t){var e,r,i,n,s,a,u,l,h,f,c,p,d,m,v,g,y;this.time=t;if(this.queue.length===0){return true}i=this.getTime();c=this,y=c.value,f=c.queue;e=false;while(!e){p=d=f[0],l=p.from,g=p.to,m=p.start,a=p.end,v=p.step,n=p.complete,s=p.ease;if(l==null){l=d.from=this.type.clone(this.value)}u=o.clamp((i-m)/Math.max(1e-5,a-m)||0,0,1);if(u===0){return}h=function(){switch(s){case"linear":case 0:return null;case"cosine":case 1:return o.cosine;case"binary":case 2:return o.binary;case"hold":case 3:return o.hold;default:return o.cosine}}();if(h!=null){u=h(u)}e=u<1;y=e?this.animator.lerp(this.type,l,g,u,y):g;if(typeof v==="function"){v(y)}if(!e){if(typeof n==="function"){n(true)}if(typeof(r=this.options).complete==="function"){r.complete(true)}f.shift();if(f.length===0){break}}}this.value=y;return this.notify()};return t}();e.exports=n},{"../util":166}],158:[function(t,e,r){var i,n;n=t("../util");i=function(){t.prototype.v2=function(){return this};function t(t,e,r){var i,n,o,s,a,u,l,h,f,c;this._context=t;this._up=e;this._targets=r;h=this._context.controller.getRoot();if(this._targets==null){this._targets=[h]}this.isRoot=this._targets.length===1&&this._targets[0]===h;this.isLeaf=this._targets.length===1&&this._targets[0].children==null;u=this._targets;for(i=n=0,s=u.length;n<s;i=++n){f=u[i];this[i]=f}this.length=this._targets.length;l=this._context.controller.getTypes();for(o=0,a=l.length;o<a;o++){c=l[o];if(c!=="root"){(function(t){return function(e){return t[e]=function(r,i){return t.add(e,r,i)}}})(this)(c)}}}t.prototype.select=function(t){var e;e=this._context.model.select(t,!this.isRoot?this._targets:null);return this._push(e)};t.prototype.eq=function(t){if(this._targets.length>t){return this._push([this._targets[t]])}return this._push([])};t.prototype.filter=function(t){var e;if(typeof t==="string"){e=this._context.model._matcher(t);t=function(t){return e(t)}}return this._push(this._targets.filter(t))};t.prototype.map=function(t){var e,r,i,n;n=[];for(e=r=0,i=this.length;0<=i?r<i:r>i;e=0<=i?++r:--r){n.push(t(this[e],e,this))}return n};t.prototype.each=function(t){var e,r,i;for(e=r=0,i=this.length;0<=i?r<i:r>i;e=0<=i?++r:--r){t(this[e],e,this)}return this};t.prototype.add=function(t,e,r){var i,n,o,s,a,u,l;i=this._context.controller;if(this.isLeaf){return this._pop().add(t,e,r)}a=[];u=this._targets;for(n=0,o=u.length;n<o;n++){l=u[n];s=i.make(t,e,r);i.add(s,l);a.push(s)}return this._push(a)};t.prototype.remove=function(t){var e,r,i,n;if(t){return this.select(t).remove()}i=this._targets.slice().reverse();for(e=0,r=i.length;e<r;e++){n=i[e];this._context.controller.remove(n)}return this._pop()};t.prototype.set=function(t,e){var r,i,n,o;n=this._targets;for(r=0,i=n.length;r<i;r++){o=n[r];this._context.controller.set(o,t,e)}return this};t.prototype.getAll=function(t){var e,r,i,n,o;i=this._targets;n=[];for(e=0,r=i.length;e<r;e++){o=i[e];n.push(this._context.controller.get(o,t))}return n};t.prototype.get=function(t){var e;return(e=this._targets[0])!=null?e.get(t):void 0};t.prototype.evaluate=function(t,e){var r;return(r=this._targets[0])!=null?r.evaluate(t,e):void 0};t.prototype.bind=function(t,e){var r,i,n,o;n=this._targets;for(r=0,i=n.length;r<i;r++){o=n[r];this._context.controller.bind(o,t,e)}return this};t.prototype.unbind=function(t){var e,r,i,n;i=this._targets;for(e=0,r=i.length;e<r;e++){n=i[e];this._context.controller.unbind(n,t)}return this};t.prototype.end=function(){return(this.isLeaf?this._pop():this)._pop()};t.prototype._push=function(e){return new t(this._context,this,e)};t.prototype._pop=function(){var t;return(t=this._up)!=null?t:this};t.prototype._reset=function(){var t,e;return(t=(e=this._up)!=null?e.reset():void 0)!=null?t:this};t.prototype.map=function(t){return this._targets.map(t)};t.prototype["on"]=function(){var t;t=arguments;this._targets.map(function(e){return e.on.apply(e,t)});return this};t.prototype["off"]=function(){var t;t=arguments;this._targets.map(function(e){return e.off.apply(e,t)});return this};t.prototype.toString=function(){var t;t=this._targets.map(function(t){return t.toString()});if(this._targets.length>1){return"["+t.join(", ")+"]"}else{return t[0]}};t.prototype.toMarkup=function(){var t;t=this._targets.map(function(t){return t.toMarkup()});return t.join("\n\n")};t.prototype.print=function(){n.Pretty.print(this._targets.map(function(t){return t.toMarkup()}).join("\n\n"));return this};t.prototype.debug=function(){var t,e,r,i,n,o,s,a;e=this.inspect();console.log("Renderables: ",e.renderables);console.log("Renders: ",e.renders);console.log("Shaders: ",e.shaders);t=function(t){return t.constructor.toString().match("function +([^(]*)")[1]};a=[];o=e.shaders;for(r=0,i=o.length;r<i;r++){s=o[r];n=t(s.owner);a.push(n+" - Vertex");a.push(s.vertex);a.push(n+" - Fragment");a.push(s.fragment)}return ShaderGraph.inspect(a)};t.prototype.inspect=function(t,e,r){var i,n,o,s,a,u,l,h,f,c,p,d,m;if(typeof e==="boolean"){r=e;e=null}if(r==null){r=true}h=function(t){var e,r;return(e=(r=t.controller)!=null?r.objects:void 0)!=null?e:[]};f=d=function(t,r){var i,n,o,s;if(r==null){r=[]}if(!e||t.traits.hash[e]){r.push(h(t))}if(t.children!=null){s=t.children;for(n=0,o=s.length;n<o;n++){i=s[n];d(i,r)}}return r};n=function(t){t=t.reduce(function(t,e){return t.concat(e)},[]);return t=t.filter(function(e,r){return e!=null&&t.indexOf(e)===r})};l=function(t,e){var r;r={};r.owner=t;r.geometry=e.geometry;r.material=e.material;r.vertex=e.material.vertexGraph;r.fragment=e.material.fragmentGraph;return r};o={nodes:this._targets.slice(),renderables:[],renders:[],shaders:[]};c=this._targets;for(s=0,u=c.length;s<u;s++){m=c[s];if(r){m.print(t,"info")}i={renderables:p=n(f(m)),renders:n(p.map(function(t){return t.renders})),shaders:n(p.map(function(t){var e;return(e=t.renders)!=null?e.map(function(e){return l(t,e)}):void 0}))};for(a in i){o[a]=o[a].concat(i[a])}}return o};return t}();e.exports=i},{"../util":166}],159:[function(t,e,r){var i,n;n=t("../util");i=function(){function t(t,e){this.model=t;this.primitives=e}t.prototype.getRoot=function(){return this.model.getRoot()};t.prototype.getTypes=function(){return this.primitives.getTypes()};t.prototype.make=function(t,e,r){return this.primitives.make(t,e,r)};t.prototype.get=function(t,e){return t.get(e)};t.prototype.set=function(t,e,r){var i;try{return t.set(e,r)}catch(e){i=e;t.print(null,"warn");return console.error(i)}};t.prototype.bind=function(t,e,r){var i;try{return t.bind(e,r)}catch(e){i=e;t.print(null,"warn");return console.error(i)}};t.prototype.unbind=function(t,e){var r;try{return t.unbind(e)}catch(e){r=e;t.print(null,"warn");return console.error(r)}};t.prototype.add=function(t,e){if(e==null){e=this.model.getRoot()}return e.add(t)};t.prototype.remove=function(t){var e;e=t.parent;if(e){return e.remove(t)}};return t}();e.exports=i},{"../util":166}],160:[function(t,e,r){r.Animator=t("./animator");r.API=t("./api");r.Controller=t("./controller")},{"./animator":157,"./api":158,"./controller":159}],161:[function(t,e,r){var i=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};r.setOrigin=function(t,e,r){var n,o,s,a;if(+e===e){e=[e]}o=i.call(e,1)>=0?0:r.x;s=i.call(e,2)>=0?0:r.y;a=i.call(e,3)>=0?0:r.z;n=i.call(e,4)>=0?0:r.w;return t.set(o,s,a,n)};r.addOrigin=function(){var t;t=new THREE.Vector4;return function(e,i,n){r.setOrigin(t,i,n);return e.add(t)}}();r.setDimension=function(t,e){var r,i,n,o;i=e===1?1:0;n=e===2?1:0;o=e===3?1:0;r=e===4?1:0;return t.set(i,n,o,r)};r.setDimensionNormal=function(t,e){var r,i,n,o;i=e===1?1:0;n=e===2?1:0;o=e===3?1:0;r=e===4?1:0;return t.set(n,o+i,r,0)};r.recenterAxis=function(){var t;t=[0,0];return function(e,r,i,n){var o,s,a,u,l,h;if(n==null){n=0}if(i>0){l=e;h=e+r;o=Math.max(Math.abs(l),Math.abs(h));s=o*n;u=Math.min(l,h);a=Math.max(l,h);e=u+(-o+s-u)*i;r=a+(o+s-a)*i-e}t[0]=e;t[1]=r;return t}}()},{}],162:[function(t,e,r){e.exports=self={bind:function(t,e){return function(r,i){if(!i.__binds){i.__binds=[]}var n=t;if(_.isArray(r)){n=r[0];r=r[1]}var o=/^([^.:]*(?:\.[^.:]+)*)?(?:\:(.*))?$/.exec(r);var s=o[1].split(/\./g);var a=s.pop();var u=o[2]||a;var l=s.shift();var h={this:i}[l]||e[l]||t[l]||n;while(h&&(r=s.shift())){h=h[r]}if(h&&(h.on||h.addEventListener)){var f=function(e){i[u]&&i[u](e,t)};self._polyfill(h,["addEventListener","on"],function(t){h[t](a,f)});var c={target:h,name:a,callback:f};i.__binds.push(c);return f}else{throw"Cannot bind '"+r+"' in "+this.__name}}},unbind:function(){return function(t){if(t.__binds){t.__binds.forEach(function(t){self._polyfill(t.target,["removeEventListener","off"],function(e){t.target[e](t.name,t.callback)})}.bind(this));t.__binds=[]}}},apply:function(t){THREE.EventDispatcher.prototype.apply(t);t.trigger=self._trigger;t.triggerOnce=self._triggerOnce;t.on=t.addEventListener;t.off=t.removeEventListener;t.dispatchEvent=t.trigger},_triggerOnce:function(t){this.trigger(t);if(this._listeners){delete this._listeners[t.type]}},_trigger:function(t){if(this._listeners===undefined)return;var e=t.type;var r=this._listeners[e];if(r!==undefined){r=r.slice();var i=r.length;t.target=this;for(var n=0;n<i;n++){r[n].call(this,t,this)}}},_polyfill:function(t,e,r){e.map(function(e){return t.method});if(e.length)r(e[0])}}},{}],163:[function(t,e,r){var i;r.getSizes=i=function(t){var e,r;r=[];e=t;while(typeof e!=="string"&&(e!=null?e.length:void 0)!=null){r.push(e.length);e=e[0]}return r};r.getDimensions=function(t,e){var r,n,o,s,a,u,l,h,f,c,p,d,m,v,g;if(e==null){e={}}a=e.items,r=e.channels,g=e.width,s=e.height,n=e.depth;o={};if(!t||!t.length){return{items:a,channels:r,width:g!=null?g:0,height:s!=null?s:0,depth:n!=null?n:0}}v=i(t);h=v.length;o.channels=r!==1&&v.length>1?v.pop():r;o.items=a!==1&&v.length>1?v.pop():a;o.width=g!==1&&v.length>1?v.pop():g;o.height=s!==1&&v.length>1?v.pop():s;o.depth=n!==1&&v.length>1?v.pop():n;u=h;if(r===1){u++}if(a===1&&u>1){u++}if(g===1&&u>2){u++}if(s===1&&u>3){u++}l=(f=v.pop())!=null?f:1;if(u<=1){l/=(c=o.channels)!=null?c:1}if(u<=2){l/=(p=o.items)!=null?p:1}if(u<=3){l/=(d=o.width)!=null?d:1}if(u<=4){l/=(m=o.height)!=null?m:1}l=Math.floor(l);if(o.width==null){o.width=l;l=1}if(o.height==null){o.height=l;l=1}if(o.depth==null){o.depth=l;l=1}return o};r.repeatCall=function(t,e){switch(e){case 0:return function(){return true};case 1:return function(){return t()};case 2:return function(){t();return t()};case 3:return function(){t();t();t();return t()};case 4:return function(){t();t();t();return t()};case 6:return function(){t();t();t();t();t();return t()};case 8:return function(){t();t();t();t();t();return t()}}};r.makeEmitter=function(t,e,r){var i,n,o,s;i=function(){switch(r){case 0:return function(){return true};case 1:return function(e){return e(t())};case 2:return function(e){return e(t(),t())};case 3:return function(e){return e(t(),t(),t())};case 4:return function(e){return e(t(),t(),t(),t())};case 6:return function(e){return e(t(),t(),t(),t(),t(),t())};case 8:return function(e){return e(t(),t(),t(),t(),t(),t(),t(),t())}}}();o=null;while(e>0){n=Math.min(e,8);s=function(){switch(n){case 1:return function(t){return i(t)};case 2:return function(t){i(t);return i(t)};case 3:return function(t){i(t);i(t);return i(t)};case 4:return function(t){i(t);i(t);i(t);return i(t)};case 5:return function(t){i(t);i(t);i(t);i(t);return i(t)};case 6:return function(t){i(t);i(t);i(t);i(t);i(t);return i(t)};case 7:return function(t){i(t);i(t);i(t);i(t);i(t);i(t);return i(t)};case 8:return function(t){i(t);i(t);i(t);i(t);i(t);i(t);i(t);return i(t)}}}();if(o!=null){o=function(t,e){return function(r){t(r);return e(r)}}(s,o)}else{o=s}e-=n}s=o!=null?o:function(){return true};s.reset=t.reset;s.rebind=t.rebind;return s};r.getThunk=function(t){var e,r,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x,b,T,w,R,H,M,S;H=i(t);d=H.length;e=H.pop();r=H.pop();n=H.pop();o=H.pop();s=false;switch(d){case 0:S=function(){return 0};S.reset=function(){};break;case 1:l=0;S=function(){return t[l++]};S.reset=function(){return l=0};break;case 2:l=h=0;a=(m=t[h])!=null?m:[];S=function(){var r,i;i=a[l++];if(l===e){l=0;h++;a=(r=t[h])!=null?r:[]}return i};S.reset=function(){var e;l=h=0;a=(e=t[h])!=null?e:[]};break;case 3:l=h=f=0;R=(v=t[f])!=null?v:[];a=(g=R[h])!=null?g:[];S=function(){var i,n,o;o=a[l++];if(l===e){l=0;h++;if(h===r){h=0;f++;R=(i=t[f])!=null?i:[]}a=(n=R[h])!=null?n:[]}return o};S.reset=function(){var e,r;l=h=f=0;R=(e=t[f])!=null?e:[];a=(r=R[h])!=null?r:[]};break;case 4:l=h=f=c=0;M=(y=t[c])!=null?y:[];R=(E=M[f])!=null?E:[];a=(_=R[h])!=null?_:[];S=function(){var i,o,s,u;u=a[l++];if(l===e){l=0;h++;if(h===r){h=0;f++;if(f===n){f=0;c++;M=(i=t[c])!=null?i:[]}R=(o=M[f])!=null?o:[]}a=(s=R[h])!=null?s:[]}return u};S.reset=function(){var e,r,i;l=h=f=c=0;M=(e=t[c])!=null?e:[];R=(r=M[f])!=null?r:[];a=(i=R[h])!=null?i:[]};break;case 5:l=h=f=c=p=0;u=(x=t[p])!=null?x:[];M=(b=u[c])!=null?b:[];R=(T=M[f])!=null?T:[];a=(w=R[h])!=null?w:[];S=function(){var i,s,d,m,v;v=a[l++];if(l===e){l=0;h++;if(h===r){h=0;f++;if(f===n){f=0;c++;if(c===o){c=0;p++;u=(i=t[p])!=null?i:[]}M=(s=u[c])!=null?s:[]}R=(d=M[f])!=null?d:[]}a=(m=R[h])!=null?m:[]}return v};S.reset=function(){var e,r,i,n;l=h=f=c=p=0;u=(e=t[p])!=null?e:[];M=(r=u[c])!=null?r:[];R=(i=M[f])!=null?i:[];a=(n=R[h])!=null?n:[]}}S.rebind=function(o){t=o;H=i(t);if(H.length){e=H.pop()}if(H.length){r=H.pop()}if(H.length){n=H.pop()}if(H.length){return o=H.pop()}};return S};r.getStreamer=function(t,e,r,i){var n,o,s,a,u,l,h,f,c;h=u=l=0;f=function(){h=e*r*i;return u=l=0};o=function(){return l};s=function(){return h-u<=0};c=function(){switch(r){case 1:return function(t){u+=t;l+=t};case 2:return function(t){u+=t*2;l+=t};case 3:return function(t){u+=t*3;l+=t};case 4:return function(t){u+=t*4;l+=t}}}();n=function(){switch(r){case 1:return function(e){e(t[u++]);++l};case 2:return function(e){e(t[u++],t[u++]);++l};case 3:return function(e){e(t[u++],t[u++],t[u++]);++l};case 4:return function(e){e(t[u++],t[u++],t[u++],t[u++]);++l}}}();a=function(){switch(r){case 1:return function(e){t[u++]=e;++l};case 2:return function(e,r){t[u++]=e;t[u++]=r;++l};case 3:return function(e,r,i){t[u++]=e;t[u++]=r;t[u++]=i;++l};case 4:return function(e,r,i,n){t[u++]=e;t[u++]=r;t[u++]=i;t[u++]=n;++l}}}();n.reset=f;a.reset=f;f();return{emit:a,consume:n,skip:c,count:o,done:s,reset:f}};r.getLerpEmitter=function(t,e){var r,i,n,o,s,a,u,l,h,f,c;c=new Float32Array(4096);s=a=.5;u=l=h=f=0;i=function(t,e,r,i){h++;c[u++]=t*s;c[u++]=e*s;c[u++]=r*s;return c[u++]=i*s};n=function(t,e,r,i){f++;c[l++]+=t*a;c[l++]+=e*a;c[l++]+=r*a;return c[l++]+=i*a};r=Math.max(t.length,e.length);if(r<=3){o=function(r,o,s){var a,p,d,m,v,g;u=l=h=f=0;t(i,o,s);e(n,o,s);d=Math.min(h,f);p=0;g=[];for(a=m=0,v=d;0<=v?m<v:m>v;a=0<=v?++m:--m){g.push(r(c[p++],c[p++],c[p++],c[p++]))}return g}}else if(r<=5){o=function(r,o,s,a,p){var d,m,v,g,y,E;u=l=h=f=0;t(i,o,s,a,p);e(n,o,s,a,p);v=Math.min(h,f);m=0;E=[];for(d=g=0,y=v;0<=y?g<y:g>y;d=0<=y?++g:--g){E.push(r(c[m++],c[m++],c[m++],c[m++]))}return E}}else if(r<=7){o=function(r,o,s,a,p,d,m){var v,g,y,E,_;u=l=h=f=0;t(i,o,s,a,p,d,m);e(n,o,s,a,p,d,m);g=Math.min(h,f);v=0;_=[];for(m=y=0,E=g;0<=E?y<E:y>E;m=0<=E?++y:--y){_.push(r(c[v++],c[v++],c[v++],c[v++]))}return _}}else if(r<=9){o=function(r,o,s,a,p,d,m,v,g){var y,E,_,x;u=l=h=f=0;t(i,o,s,a,p,d,m,v,g);e(n,o,s,a,p,d,m,v,g);y=Math.min(h,f);g=0;x=[];for(v=E=0,_=y;0<=_?E<_:E>_;v=0<=_?++E:--E){x.push(r(c[g++],c[g++],c[g++],c[g++]))}return x}}else{o=function(r,o,s,a,p,d,m,v,g,y,E){var _,x,b,T;u=l=0;t(i,o,s,a,p,d,m,v,g,y,E);e(n,o,s,a,p,d,m,v,g,y,E);_=Math.min(h,f);g=0;T=[];for(v=x=0,b=_;0<=b?x<b:x>b;v=0<=b?++x:--x){T.push(r(c[g++],c[g++],c[g++],c[g++]))}return T}}o.lerp=function(t){var e;return e=[1-t,t],s=e[0],a=e[1],e};return o};r.getLerpThunk=function(t,e){var i,n,o,s,a,u;n=r.getSizes(t).reduce(function(t,e){return t*e});o=r.getSizes(e).reduce(function(t,e){return t*e});i=Math.min(n,o);a=r.getThunk(t);u=r.getThunk(e);s=new Float32Array(i);s.lerp=function(t){var e,r,n,o;a.reset();u.reset();n=0;o=[];while(n<i){e=a();r=u();o.push(s[n++]=e+(r-e)*t)}return o};return s}},{}],164:[function(t,e,r){var i,n;n=Math.PI;i={clamp:function(t,e,r){return Math.max(e,Math.min(r,t))},cosine:function(t){return.5-.5*Math.cos(i.clamp(t,0,1)*n)},binary:function(t){return+(t>=.5)},hold:function(t){return+(t>=1)}};e.exports=i},{}],165:[function(t,e,r){var i,n,o,s,a,u=[].indexOf||function(t){for(var e=0,r=this.length;e<r;e++){if(e in this&&this[e]===t)return e}return-1};n="xyzw".split("");i={0:-1,x:0,y:1,z:2,w:3};o=function(t){if(t===""+t){t=t.split("")}if(t===+t){t=[t]}return t};a=function(t){if(t===+t){t="vec"+t}if(t==="vec1"){t="float"}return t};s=function(t){t=""+t;if(t.indexOf(".")<0){return t+=".0"}};r.mapByte2FloatOffset=function(t){var e;if(t==null){t=4}e=s(t);return"vec4 float2ByteIndex(vec4 xyzw, out float channelIndex) {\n  float relative = xyzw.w / "+e+";\n  float w = floor(relative);\n  channelIndex = (relative - w) * "+e+";\n  return vec4(xyzw.xyz, w);\n}"};r.sample2DArray=function(t){var e,r;r=function(t,e){var i,n;if(t===e){n="return texture2D(dataTextures["+t+"], uv);"}else{i=Math.ceil(t+(e-t)/2);n="if (z < "+(i-.5)+") {\n  "+r(t,i-1)+"\n}\nelse {\n  "+r(i,e)+"\n}"}return n=n.replace(/\n/g,"\n  ")};e=r(0,t-1);return"uniform sampler2D dataTextures["+t+"];\n\nvec4 sample2DArray(vec2 uv, float z) {\n  "+e+"\n}"};r.binaryOperator=function(t,e,r){t=a(t);if(r!=null){return t+" binaryOperator("+t+" a) {\n  return a "+e+" "+r+";\n}"}else{return t+" binaryOperator("+t+" a, "+t+" b) {\n  return a "+e+" b;\n}"}};r.extendVec=function(t,e,i){var n,o,u,l,h;if(i==null){i=0}if(t>e){return r.truncateVec(t,e)}o=e-t;t=a(t);e=a(e);i=s(i);l=function(){h=[];for(var t=0;0<=o?t<=o:t>=o;0<=o?t++:t--){h.push(t)}return h}.apply(this).map(function(t){if(t){return i}else{return"v"}});n=l.join(",");return e+" extendVec("+t+" v) { return "+e+"("+n+"); }"};r.truncateVec=function(t,e){var i;if(t<e){return r.extendVec(t,e)}i="."+"xyzw".substr(0,e);t=a(t);e=a(e);return e+" truncateVec("+t+" v) { return v"+i+"; }"};r.injectVec4=function(t){var e,r,n,s,a,u,l;l=["0.0","0.0","0.0","0.0"];t=o(t);t=t.map(function(t){if(t===""+t){return i[t]}else{return t}});for(n=s=0,a=t.length;s<a;n=++s){r=t[n];l[r]=["a","b","c","d"][n]}u=l.slice(0,4).join(", ");e=["float a","float b","float c","float d"].slice(0,t.length);return"vec4 inject("+e+") {\n  return vec4("+u+");\n}"};r.swizzleVec4=function(t,e){var r,n;if(e==null){e=null}r=["0.0","xyzw.x","xyzw.y","xyzw.z","xyzw.w"];if(e==null){e=t.length}t=o(t);t=t.map(function(t){var e;if(e=+t,u.call([0,1,2,3,4],e)>=0){t=+t}if(t===""+t){t=i[t]+1}return r[t]});while(t.length<e){t.push("0.0")}n=t.join(", ");return("vec"+e+" swizzle(vec4 xyzw) {\n  return vec"+e+"("+n+");\n}").replace(/vec1/g,"float")};r.invertSwizzleVec4=function(t){var e,r,s,a,u,l,h,f;f=["0.0","0.0","0.0","0.0"];t=o(t);t=t.map(function(t){if(t===+t){return n[t-1]}else{return t}});for(e=s=0,a=t.length;s<a;e=++s){u=t[e];h=n[e];r=i[u];f[r]="xyzw."+h}l=f.join(", ");return"vec4 invertSwizzle(vec4 xyzw) {\n  return vec4("+l+");\n}"};r.identity=function(t){var e;e=[].slice.call(arguments);if(e.length>1){e=e.map(function(t,e){return["inout",t,String.fromCharCode(97+e)].join(" ")});e=e.join(", ");return"void identity("+e+") { }"}else{return t+" identity("+t+" x) {\n  return x;\n}"}};r.constant=function(t,e){return t+" constant() {\n  return "+e+";\n}"};r.toType=a},{}],166:[function(t,e,r){r.Axis=t("./axis");r.Data=t("./data");r.Ease=t("./ease");r.GLSL=t("./glsl");r.JS=t("./js");r.Pretty=t("./pretty");r.Three=t("./three");r.Ticks=t("./ticks");r.VDOM=t("./vdom")},{"./axis":161,"./data":163,"./ease":164,"./glsl":165,"./js":167,"./pretty":168,"./three":169,"./ticks":170,"./vdom":171}],167:[function(t,e,r){r.merge=function(){var t,e,r,i,n,o;o={};for(t=0,r=arguments.length;t<r;t++){i=arguments[t];for(e in i){n=i[e];o[e]=n}}return o};r.clone=function(t){return JSON.parse(JSON.serialize(t))};r.parseQuoted=function(t){var e,r,i,n,o,s,a,u,l,h;e="";h=function(t){return t=t.replace(/\\/g,"")};a=function(t){if(e.length){s.push(h(e))}return e=t!=null?t:""};t=t.split(/(?=(?:\\.|["' ,]))/g);u=false;s=[];for(n=0,o=t.length;n<o;n++){i=t[n];r=i[0];l=i.slice(1);switch(r){case'"':case"'":if(u){if(u===r){u=false;a(l)}else{e+=i}}else{if(e!==""){throw new Error("ParseError: String `"+t+"` does not contain comma-separated quoted tokens.")}u=r;e+=l}break;case" ":case",":if(!u){a(l)}else{e+=i}break;default:e+=i}}a();return s}},{}],168:[function(t,e,r){var i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y;i=5;n=1e-4;o=function(t,e){return Math.abs(t/e-Math.round(t/e))<n};s=function(t){return o(t,1)};h=function(t,e,r,i){var n;n=Math.round(t/e);if(n===1){return""+r}if(n===-1){return"-"+r}if(r==="1"){return""+n}if(i){return""+n+r}else{return n+"*"+r}};l=function(t,e,r,i){var n;n=Math.round(t*e);if(Math.abs(n)===1){n=n<0?"-":"";n+=r}else if(r!=="1"){n+=i?""+r:"*"+r}return n+"/"+e};u=[{1:1},{1:1,"τ":Math.PI*2},{1:1,"π":Math.PI},{1:1,"τ":Math.PI*2,"π":Math.PI},{1:1,e:Math.E},{1:1,"τ":Math.PI*2,e:Math.E},{1:1,"π":Math.PI,e:Math.E},{1:1,"τ":Math.PI*2,"π":Math.PI,e:Math.E}];f=[[2*2*3*5*7,[2,3,5,7]],[2*2*2*3*3*5*5*7*7,[2,3,5,7]],[2*2*3*5*7*11*13,[2,3,5,7,11,13]],[2*2*17*19*23*29,[2,17,19,23,29]],[256*256,[2]],[1e6,[2,5]]];g=function(t){var e,r,o,a,c,p,d,m,v,g;if(t){e=t.cache,o=t.compact,v=t.tau,d=t.pi,a=t.e,g=t.threshold,m=t.precision}o=+!!(o!=null?o:true);v=+!!(v!=null?v:true);d=+!!(d!=null?d:true);a=+!!(a!=null?a:true);e=+!!(e!=null?e:true);g=+(g!=null?g:n);m=+(m!=null?m:i);c=v+d*2+a*4;r=c+g+m;p=e?{}:null;return function(t){var e,r,n,a,d,m,v,g,y,E,_,x,b,T,w,R,H,M;if(p!=null){if((r=p[t])!=null){return r}if(t===Math.round(t)){return p[t]=""+t}}w=""+t;e=w.length+w.indexOf(".")+2;x=function(t){var r;r=t.length;if(r<=e){w=""+t;return e=r}};H=u[c];for(g in H){d=H[g];if(s(t/d)){x(""+h(t/d,1,g,o))}else{for(m=0,y=f.length;m<y;m++){M=f[m],a=M[0],_=M[1];T=t/d*a;if(s(T)){for(v=0,E=_.length;v<E;v++){R=_[v];while(s(b=T/R)&&s(n=a/R)){T=b;a=n}}x(""+l(t/d,a,g,o));break}}}}if((""+t).length>i){x(""+t.toPrecision(i))}if(p!=null){p[t]=w}return w}};y=function(t,e){if(e==null){e="info"}t=v(t);return console[e].apply(console,t)};v=function(t){var e,r,i,n,o,s,a,u;a="color:rgb(128,0,128)";r="color:rgb(144,64,0)";s="color:rgb(0,0,192)";n="color:rgb(0,70,156)";u="color:inherit";o=false;i=0;e=[];t=t.replace(/(\\[<={}> "'])|(=>|[<={}> "'])/g,function(t,l,h){var f;if(l!=null?l.length:void 0){return l}if(o&&(h!=='"'&&h!=="'")){return h}if(i&&(h!=='"'&&h!=="'"&&h!=="{"&&h!=="}")){return h}return f=function(){switch(h){case"<":e.push(a);return"%c<";case">":e.push(a);e.push(u);return"%c>%c";case" ":e.push(r);return" %c";case"=":case"=>":e.push(a);return"%c"+h;case'"':case"'":o=!o;if(o){e.push(i?r:s);return h+"%c"}else{e.push(i?n:a);return"%c"+h}break;case"{":if(i++===0){e.push(n);return"%c"+h}else{return h}break;case"}":if(--i===0){e.push(a);return h+"%c"}else{return h}break;default:return h}}()});return[t].concat(e)};m=function(t,e){return d(t,e,"=")};p=function(t,e){return d(t,e,"=>")};d=function(){var t;t=g({compact:false});return function(e,r,i){var n,o,s;n=function(t){if(t===""+ +t||t.match(/^[A-Za-z_][A-Za-z0-9]*$/)){return t}else{return JSON.stringify(t)}};s=function(t){if(t.match('\n*"')){return t}else{return"{"+t+"}"}};o=function(e){var r,i;if(e instanceof Array){return"["+e.map(o).join(", ")+"]"}switch(typeof e){case"string":if(e.match("\n")){return'"\n'+e+'"\n'}else{return'"'+e+'"'}break;case"function":e=""+e;if(e.match("\n")){"\n"+e+"\n"}else{""+e}e=e.replace(/^function (\([^)]+\))/,"$1 =>");return e=e.replace(/^(\([^)]+\)) =>\s*{\s*return\s*([^}]+)\s*;\s*}/,"$1 => $2");case"number":return t(e);default:if(e!=null&&e!==!!e){if(e._up!=null){return o(e.map(function(t){return t}))}if(e.toMarkup){return e.toString()}else{return"{"+function(){var t;t=[];for(r in e){i=e[r];if(e.hasOwnProperty(r)){t.push(n(r)+": "+o(i))}}return t}().join(", ")+"}"}}else{return""+JSON.stringify(e)}}};return[e,i,s(o(r))].join("")}}();a=function(t){t=t.replace(/&/g,"&amp;");t=t.replace(/</g,"&lt;");return t=t.replace(/"/g,"&quot;")};c=function(t){var e,r,i,n,o;r=[].slice.call(arguments);r.shift();o="<span>";t=a(t);for(i=0,n=r.length;i<n;i++){e=r[i];t=t.replace(/%([a-z])/,function(t,e){var i;i=r.shift();switch(e){case"c":return'</span><span style="'+a(i)+'">';default:return a(i)}})}o+=t;return o+="</span>"};e.exports={markup:v,number:g,print:y,format:c,JSX:{prop:m,bind:p}}},{}],169:[function(t,e,r){r.paramToGL=function(t,e){if(e===THREE.RepeatWrapping){return t.REPEAT}if(e===THREE.ClampToEdgeWrapping){return t.CLAMP_TO_EDGE}if(e===THREE.MirroredRepeatWrapping){return t.MIRRORED_REPEAT}if(e===THREE.NearestFilter){return t.NEAREST}if(e===THREE.NearestMipMapNearestFilter){return t.NEAREST_MIPMAP_NEAREST}if(e===THREE.NearestMipMapLinearFilter){return t.NEAREST_MIPMAP_LINEAR}if(e===THREE.LinearFilter){return t.LINEAR}if(e===THREE.LinearMipMapNearestFilter){return t.LINEAR_MIPMAP_NEAREST}if(e===THREE.LinearMipMapLinearFilter){return t.LINEAR_MIPMAP_LINEAR}if(e===THREE.UnsignedByteType){return t.UNSIGNED_BYTE}if(e===THREE.UnsignedShort4444Type){return t.UNSIGNED_SHORT_4_4_4_4}if(e===THREE.UnsignedShort5551Type){return t.UNSIGNED_SHORT_5_5_5_1}if(e===THREE.UnsignedShort565Type){return t.UNSIGNED_SHORT_5_6_5}if(e===THREE.ByteType){return t.BYTE}if(e===THREE.ShortType){return t.SHORT}if(e===THREE.UnsignedShortType){return t.UNSIGNED_SHORT}if(e===THREE.IntType){return t.INT}if(e===THREE.UnsignedIntType){return t.UNSIGNED_INT}if(e===THREE.FloatType){return t.FLOAT}if(e===THREE.AlphaFormat){return t.ALPHA}if(e===THREE.RGBFormat){return t.RGB}if(e===THREE.RGBAFormat){return t.RGBA}if(e===THREE.LuminanceFormat){return t.LUMINANCE}if(e===THREE.LuminanceAlphaFormat){return t.LUMINANCE_ALPHA}if(e===THREE.AddEquation){return t.FUNC_ADD}if(e===THREE.SubtractEquation){return t.FUNC_SUBTRACT}if(e===THREE.ReverseSubtractEquation){return t.FUNC_REVERSE_SUBTRACT}if(e===THREE.ZeroFactor){return t.ZERO}if(e===THREE.OneFactor){return t.ONE}if(e===THREE.SrcColorFactor){return t.SRC_COLOR}if(e===THREE.OneMinusSrcColorFactor){return t.ONE_MINUS_SRC_COLOR}if(e===THREE.SrcAlphaFactor){return t.SRC_ALPHA}if(e===THREE.OneMinusSrcAlphaFactor){return t.ONE_MINUS_SRC_ALPHA}if(e===THREE.DstAlphaFactor){return t.DST_ALPHA}if(e===THREE.OneMinusDstAlphaFactor){return t.ONE_MINUS_DST_ALPHA}if(e===THREE.DstColorFactor){return t.DST_COLOR}if(e===THREE.OneMinusDstColorFactor){return t.ONE_MINUS_DST_COLOR}if(e===THREE.SrcAlphaSaturateFactor){return t.SRC_ALPHA_SATURATE}return 0};r.paramToArrayStorage=function(t){switch(t){case THREE.UnsignedByteType:return Uint8Array;case THREE.ByteType:return Int8Array;case THREE.ShortType:return Int16Array;case THREE.UnsignedShortType:return Uint16Array;case THREE.IntType:return Int32Array;case THREE.UnsignedIntType:return Uint32Array;case THREE.FloatType:return Float32Array}};r.swizzleToEulerOrder=function(t){return t.map(function(t){return["","X","Y","Z"][t]}).join("")};r.transformComposer=function(){var t,e,i,n,o;t=new THREE.Euler;i=new THREE.Quaternion;e=new THREE.Vector3;n=new THREE.Vector3;o=new THREE.Matrix4;return function(s,a,u,l,h,f){if(f==null){f="XYZ"}if(a!=null){if(f instanceof Array){f=r.swizzleToEulerOrder(f)}t.setFromVector3(a,f);i.setFromEuler(t)}else{i.set(0,0,0,1)}if(u!=null){i.multiply(u)}if(s!=null){e.copy(s)}else{e.set(0,0,0)}if(l!=null){n.copy(l)}else{n.set(1,1,1)}o.compose(e,i,n);if(h!=null){o.multiplyMatrices(o,h)}return o}}},{}],170:[function(t,e,r){var i,n,o,s,a;o=function(t,e,r,i,n,o,s,a,u,l){var h,f,c,p,d,m,v,g,y,E;if(l==null){l=true}r||(r=10);i||(i=1);n||(n=10);o||(o=1);v=e-t;d=v/r;if(!l){E=function(){var e,i,n;n=[];for(p=e=0,i=r;0<=i?e<=i:e>=i;p=0<=i?++e:--e){n.push(t+p*d)}return n}();if(!s){E.shift()}if(!a){E.pop()}if(!u){E=E.filter(function(t){return t!==0})}return E}i||(i=1);n||(n=10);m=i*Math.pow(n,Math.floor(Math.log(d/i)/Math.log(n)));c=n%2===0?[n/2,1,1/2]:n%3===0?[n/3,1,1/3]:[1];y=function(){var t,e,r;r=[];for(t=0,e=c.length;t<e;t++){f=c[t];r.push(m*f)}return r}();h=Infinity;g=y.reduce(function(t,e){var r;f=e/d;r=Math.max(f,1/f);if(r<h){h=r;return e}else{return t}},m);g*=o;t=Math.ceil(t/g+ +!s)*g;e=(Math.floor(e/g)-+!a)*g;r=Math.ceil((e-t)/g);E=function(){var e,i,n;n=[];for(p=e=0,i=r;0<=i?e<=i:e>=i;p=0<=i?++e:--e){n.push(t+p*g)}return n}();if(!u){E=E.filter(function(t){return t!==0})}return E};s=function(t,e,r,i,n,o,s,a,u,l){throw new Error("Log ticks not yet implemented.")};i=0;n=1;a=function(t,e,r,a,u,l,h,f,c,p,d){switch(t){case i:return o(e,r,a,u,l,h,f,c,p,d);case n:return s(e,r,a,u,l,h,f,c,p,d)}};r.make=a;r.linear=o;r.log=s},{}],171:[function(t,e,r){var i,n,o,s,a,u,l,h,f,c,p,d,m,v,g,y,E,_,x;i=[];h=0;n={};a=function(){return{id:h++,type:null,props:null,children:null,rendered:null,instance:null}};l=function(t){var e,r,n,o;t*=2;t=Math.max(0,i.length-t);o=[];for(e=r=0,n=t;0<=n?r<n:r>n;e=0<=n?++r:--r){o.push(i.push(a()))}return o};u=function(t,e,r){var n;n=i.length?i.pop():a();n.type=t!=null?t:"div";n.props=e!=null?e:null;n.children=r!=null?r:null;return n};g=function(t){var e,r,n,o;if(!t.type){return}r=t.children;t.type=t.props=t.children=t.instance=null;i.push(t);if(r!=null){for(n=0,o=r.length;n<o;n++){e=r[n];g(e)}}};o=function(t,e,r,i,s){var a,l,h,f,c,p,d,v,g,y,b,T,w,R,H,M,S,k,A,C,L,P,z,D,O,F,U,B,V,N;if(t!=null){if(e==null){return m(t,i,s)}else{if(t instanceof Node){F=t===e;if(F){return}}else{F=typeof t===typeof e&&e!==null&&t!==null&&t.type===e.type}if(!F){_(e.instance,r);r.remove();return m(t,i,s)}else{t.instance=e.instance;B=((L=t.type)!=null?L.isComponentClass:void 0)?t.type:n[t.type];A=e!=null?e.props:void 0;H=t.props;f=(P=e!=null?e.children:void 0)!=null?P:null;R=t.children;if(H!=null){H.children=R}if(B!=null){p=r._COMPONENT_DIRTY;if(A!=null!==(H!=null)){p=true}if(f!==R){p=true}if(A!=null&&H!=null){if(!p){for(y in A){if(!H.hasOwnProperty(y)){p=true}}}if(!p){for(y in H){N=H[y];if((C=A[y])!==N){p=true}}}}if(p){c=e.instance;if(t.props==null){t.props={}}z=c.defaultProps;for(g in z){V=z[g];if((a=t.props)[g]==null){a[g]=V}}t.props.children=t.children;if(typeof c.willReceiveProps==="function"){c.willReceiveProps(t.props)}U=r._COMPONENT_FORCE||((D=typeof c.shouldUpdate==="function"?c.shouldUpdate(t.props):void 0)!=null?D:true);if(U){M=c.getNextState();if(typeof c.willUpdate==="function"){c.willUpdate(t.props,M)}}S=c.props;k=c.applyNextState();c.props=t.props;c.children=t.children;if(U){t=t.rendered=typeof c.render==="function"?c.render(u,t.props,t.children):void 0;o(t,e.rendered,r,i,s);if(typeof c.didUpdate==="function"){c.didUpdate(S,k)}}}else{t.rendered=e.rendered}return}else{if(A!=null){for(y in A){if(!H.hasOwnProperty(y)){x(r,y,A[y])}}}if(H!=null){for(y in H){N=H[y];if((C=A[y])!==N&&y!=="children"){E(r,y,N,C)}}}if(R!=null){if((O=typeof R)==="string"||O==="number"){if(R!==f){r.textContent=R}}else{if(R.type!=null){o(R,f,r.childNodes[0],r,0)}else{h=r.childNodes;if(f!=null){for(d=v=0,T=R.length;v<T;d=++v){l=R[d];o(l,f[d],h[d],r,d)}}else{for(d=b=0,w=R.length;b<w;d=++b){l=R[d];o(l,null,h[d],r,d)}}}}}else if(f!=null){_(null,r);r.innerHTML=""}}return}}}if(e!=null){_(e.instance,r);return e.node.remove()}};m=function(t,e,r){var i,o,s,a,l,h,f,c,p,d,v,g,y,_,x,b,T,w,R,H;if(r==null){r=0}w=((g=t.type)!=null?g.isComponentClass:void 0)?t.type:n[t.type];if(t instanceof Node){v=t}else{if(w!=null){l=((y=t.type)!=null?y.isComponentClass:void 0)?t.type:n[t.type];if(!l){t=t.rendered=u("noscript");v=m(t,e,r);return v}t.instance=a=new l(e);if(t.props==null){t.props={}}_=a.defaultProps;for(c in _){R=_[c];if((i=t.props)[c]==null){i[c]=R}}t.props.children=t.children;a.props=t.props;a.children=t.children;a.setState(typeof a.getInitialState==="function"?a.getInitialState():void 0);if(typeof a.willMount==="function"){a.willMount()}t=t.rendered=typeof a.render==="function"?a.render(u,t.props,t.children):void 0;v=m(t,e,r);if(typeof a.didMount==="function"){a.didMount(t)}v._COMPONENT=a;return v}else if((x=typeof t)==="string"||x==="number"){v=document.createTextNode(t)}else{v=document.createElement(t.type);b=t.props;for(p in b){H=b[p];E(v,p,H)}}s=t.children;if(s!=null){if((T=typeof s)==="string"||T==="number"){v.textContent=s}else{if(s.type!=null){m(s,v,0)}else{for(h=f=0,d=s.length;f<d;h=++f){o=s[h];m(o,v,h)}}}}}e.insertBefore(v,e.childNodes[r]);return v};_=function(t,e){var r,i,n,o,s,a;if(t){if(typeof t.willUnmount==="function"){t.willUnmount()}for(n in t){delete t[n]}}s=e.childNodes;a=[];for(i=0,o=s.length;i<o;i++){r=s[i];_(r._COMPONENT,r);a.push(delete r._COMPONENT)}return a};v=function(t){var e,r,i,n;if(typeof document==="undefined"){return true}if(document.documentElement.style[t]!=null){return t}t=t[0].toUpperCase()+t.slice(1);n=["webkit","moz","ms","o"];for(e=0,r=n.length;e<r;e++){i=n[e];if(document.documentElement.style[i+t]!=null){return i+t}}};d={};y=["transform"];for(f=0,p=y.length;f<p;f++){c=y[f];d[c]=v(c)}E=function(t,e,r,i){var n,o,s;if(e==="style"){for(n in r){s=r[n];if((i!=null?i[n]:void 0)!==s){t.style[(o=d[n])!=null?o:n]=s}}return}if(t[e]!=null){t[e]=r;return}if(t instanceof Node){t.setAttribute(e,r)}};x=function(t,e,r){var i,n,o;if(e==="style"){for(i in r){o=r[i];t.style[(n=d[i])!=null?n:i]=""}return}if(t[e]!=null){t[e]=void 0}if(t instanceof Node){t.removeAttribute(e)}};s=function(t){var e,r,i,n,o;i={willMount:"componentWillMount",didMount:"componentDidMount",willReceiveProps:"componentWillReceiveProps",shouldUpdate:"shouldComponentUpdate",willUpdate:"componentWillUpdate",didUpdate:"componentDidUpdate",willUnmount:"componentWillUnmount"};for(r in i){n=i[r];if(t[r]==null){t[r]=t[n]}}e=function(){function e(e,r,i,n){var o,s,a,u;this.props=r!=null?r:{};this.state=i!=null?i:null;this.children=n!=null?n:null;o=function(t,e){if(typeof t==="function"){return t.bind(e)}else{return t}};for(s in t){u=t[s];this[s]=o(u,this)}a=null;this.setState=function(t){if(a==null){a=t?a!=null?a:{}:null}for(s in t){u=t[s];a[s]=u}e._COMPONENT_DIRTY=true};this.forceUpdate=function(){var t,r;e._COMPONENT_FORCE=e._COMPONENT_DIRTY=true;t=e;r=[];while(t=t.parentNode){if(t._COMPONENT){r.push(t._COMPONENT_FORCE=true)}else{r.push(void 0)}}return r};this.getNextState=function(){return a};this.applyNextState=function(){var t,r;e._COMPONENT_FORCE=e._COMPONENT_DIRTY=false;t=this.state;r=[null,a],a=r[0],this.state=r[1];return t};return}return e}();e.isComponentClass=true;e.prototype.defaultProps=(o=typeof t.getDefaultProps==="function"?t.getDefaultProps():void 0)!=null?o:{};return e};e.exports={element:u,recycle:g,apply:o,hint:l,Types:n,createClass:s}},{}],172:[function(t,e,r){var i,n,o,s,a,u;n=t("../graph");a=t("../linker").Program;o=t("../linker").Layout;u=false;i=function(){t.previous=function(t){var e;return(e=t.input)!=null?e.node.owner:void 0};function t(){var t;if(this.namespace==null){this.namespace=a.entry()}this.node=new n.Node(this,(t=typeof this.makeOutlets==="function"?this.makeOutlets():void 0)!=null?t:{})}t.prototype.refresh=function(){var t;return this.node.setOutlets((t=typeof this.makeOutlets==="function"?this.makeOutlets():void 0)!=null?t:{})};t.prototype.clone=function(){return new t};t.prototype.compile=function(t,e){var r;r=new a(t,e!=null?e:a.entry(),this.node.graph);this.call(r,0);return r.assemble()};t.prototype.link=function(t,e){var r,i;i=this.compile(t,e);r=new o(t,this.node.graph);this._include(i,r,0);this["export"](r,0);return r.link(i)};t.prototype.call=function(t,e){};t.prototype.callback=function(t,e,r,i,n){};t.prototype["export"]=function(t,e){};t.prototype._info=function(t){var e,r,i;i=(e=(r=this.node.owner.snippet)!=null?r._name:void 0)!=null?e:this.node.owner.namespace;if(t!=null){return i+="."+t}};t.prototype._outlet=function(t,e){var r;r=n.Outlet.make(t,e);r.meta.def=t;return r};t.prototype._call=function(t,e,r){return e.call(this.node,t,r)};t.prototype._require=function(t,e){return e.require(this.node,t)};t.prototype._inputs=function(e,r,i){var n,o,s,a,u,l,h;u=e.main.signature;h=[];for(o=0,s=u.length;o<s;o++){n=u[o];a=this.node.get(n.name);h.push((l=t.previous(a))!=null?l.call(r,i+1):void 0)}return h};t.prototype._callback=function(t,e,r,i,n,o){return e.callback(this.node,t,r,i,n,o)};t.prototype._include=function(t,e,r){return e.include(this.node,t,r)};t.prototype._link=function(e,r,i){var n,o,a,l,h,f,c,p,d,m,v,g;u&&console.log("block::_link",this.toString(),e.namespace);d=e.symbols;g=[];for(a=0,h=d.length;a<h;a++){l=d[a];o=e.externals[l];c=this.node.get(o.name);if(!c){throw new s("External not found on "+this._info(o.name))}if(c.meta.child!=null){continue}m=[c,c,null],f=m[0],p=m[1],n=m[2];while(!n&&p){v=[c.meta.parent,p],p=v[0],c=v[1]}n=t.previous(c);if(!n){throw new s("Missing connection on "+this._info(o.name))}u&&console.log("callback -> ",this.toString(),o.name,c);n.callback(r,i+1,l,o,c.input);g.push(n!=null?n["export"](r,i+1):void 0)}return g};t.prototype._trace=function(e,r,i){var n,o,s,a,l,h,f;u&&console.log("block::_trace",this.toString(),e.namespace);l=e.main.signature;f=[];for(o=0,s=l.length;o<s;o++){n=l[o];a=this.node.get(n.name);f.push((h=t.previous(a))!=null?h["export"](r,i+1):void 0)}return f};return t}();s=function(t){var e;e=new Error(t);e.name="OutletError";return e};s.prototype=new Error;e.exports=i},{"../graph":192,"../linker":197}],173:[function(t,e,r){var i,n,o=function(t,e){for(var r in e){if(s.call(e,r))t[r]=e[r]}function i(){this.constructor=t}i.prototype=e.prototype;t.prototype=new i;t.__super__=e.prototype;return t},s={}.hasOwnProperty;i=t("./block");n=function(t){o(e,t);function e(t){this.snippet=t;this.namespace=this.snippet.namespace;e.__super__.constructor.apply(this,arguments)}e.prototype.clone=function(){return new e(this.snippet)};e.prototype.makeOutlets=function(){var t,e,r,i,n,o,s;i=this.snippet.main.signature;e=this.snippet.externals;s=this.snippet.symbols;o=function(){var t,e,r;r=[];for(t=0,e=i.length;t<e;t++){n=i[t];r.push(this._outlet(n,{callback:false}))