// Generated by CoffeeScript 1.10.0
(function() {
  var Data, LocaTable, Table,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Table = require('../table');

  Data = require('../../data');

  LocaTable = (function(superClass) {
    extend(LocaTable, superClass);

    function LocaTable() {
      return LocaTable.__super__.constructor.apply(this, arguments);
    }

    LocaTable.prototype.tag = 'loca';

    LocaTable.prototype.parse = function(data) {
      var format, i;
      data.pos = this.offset;
      format = this.file.head.indexToLocFormat;
      if (format === 0) {
        return this.offsets = (function() {
          var j, ref, results;
          results = [];
          for (i = j = 0, ref = this.length; j < ref; i = j += 2) {
            results.push(data.readUInt16() * 2);
          }
          return results;
        }).call(this);
      } else {
        return this.offsets = (function() {
          var j, ref, results;
          results = [];
          for (i = j = 0, ref = this.length; j < ref; i = j += 4) {
            results.push(data.readUInt32());
          }
          return results;
        }).call(this);
      }
    };

    LocaTable.prototype.indexOf = function(id) {
      return this.offsets[id];
    };

    LocaTable.prototype.lengthOf = function(id) {
      return this.offsets[id + 1] - this.offsets[id];
    };

    LocaTable.prototype.encode = function(offsets) {
      var j, k, l, len, len1, len2, o, offset, ref, ret, table;
      table = new Data;
      for (j = 0, len = offsets.length; j < len; j++) {
        offset = offsets[j];
        if (!(offset > 0xFFFF)) {
          continue;
        }
        ref = this.offsets;
        for (k = 0, len1 = ref.length; k < len1; k++) {
          o = ref[k];
          table.writeUInt32(o);
        }
        return ret = {
          format: 1,
          table: table.data
        };
      }
      for (l = 0, len2 = offsets.length; l < len2; l++) {
        o = offsets[l];
        table.writeUInt16(o / 2);
      }
      return ret = {
        format: 0,
        table: table.data
      };
    };

    return LocaTable;

  })(Table);

  module.exports = LocaTable;

}).call(this);
