/**
* @author Joel Espinosa Longi
* @licencia LGPL - http://www.gnu.org/licenses/lgpl.html
*/

var tooltip = (function(tooltip) {

 /**
  * 
  */
 tooltip.por = 
 {
	Panels: {
		Buttons: 'Selecione o painel de edição de configuração geral da cena e as linhas de controles numéricos.',
		Spaces: 'Seleciona o painel de edição de Espaços.',
		Controls: 'Seleciona o painel de edição de controles.',
		Definitions: 'Selecione o painel de edição Definições.\n\nDefinições são todos os vetores, matrizes, funções, variáveis e bibliotecas de uma cena.',
		Programs: 'Selecione o painel de edição do programa.\n\nOs programas são todos os algoritmos e eventos de uma cena',
		Graphics: 'Seleciona o painel de edição de Gráficos 2-D.',
		Graphics3D: 'Seleciona o painel de edição de Gráficos 3-D.',
		Animation: 'Seleciona o painel de edição da Animação.',
	},

	Buttons: {
		width: 'A largura da cena em pixels.',
		height: 'A altura da cena em pixels.',
		about: 'Determina se o botão "Créditos" aparece na cena.\n\nO botão "Créditos" abre uma janela com as informações dos autores de Descartes.',
		config: 'Determina se o botão "Config" aparece na cena.\n\nO botão "Config" abre uma janela com as configurações da cena.',
		init: 'Determina se o botão "Iniciar" aparece na cena.\n\nO botão "Iniciar" reinicia os valores dos controles, definições e programas, retornando a cena ao seu estado inicial.\n\nSe houver animação automática, ela será iniciada novamente.',
		clear: 'Determina se o botão "Limpar" aparece na cena.\n\nO botão "Limpar" exclui os traços deixados pelos objetos gráficos que possuem a opção "traço" ativada.',
		rowsNorth: 'Número de linhas que serão ocupadas pelos controles numéricos colocados na região norte.\n\nSe o valor for zero, haverá uma linha, se necessário, mas, se não for, não haverá nenhuma.\n\nO valor padrão é zero.',
		rowsSouth: 'Número de linhas que serão ocupadas pelos controles numéricos colocados na região sul.\n\nSe o valor for zero, então (se necessário) haverá uma linha, se não for, não haverá nenhuma.\n\nO valor padrão é zero.',
		widthWest: 'Largura em pixels da região oeste para controles numéricos.O valor padrão é 150.\n\nSe o valor for 0, mas houver pelo menos um controle numérico na região oeste, um valor de 125 será adotado por padrão.',
		widthEast: 'Largura em pixels da região leste para controles numéricos.O valor padrão é 150.\n\nSe o valor for 0, mas houver pelo menos um controle numérico na região leste, um valor de 125 será adotado por padrão.',
		heightRows: 'Altura em pixels dos controles numéricos nas regiões norte e sul. O valor padrão é 40.',
		decimal_symbol: 'Símbolo que separa os inteiros dos decimais em uma expressão decimal.\n\nEm alguns países, a vírgula é usada e, em outros, o ponto.',
		language: 'Idioma em que a configuração da cena é salva.',
		editable: 'Determina se o espaço exterior é exibido, clicando com o botão direito na cena.',
		expand: 'Opções para modificar as dimensões da cena.\n\n"Capa": altera apenas a largura e a altura das cenas que têm um valor de 100%, para que tenham as dimensões de seu contêiner.\n\n"Escala": modifica a escala dos pixels da cena para cobrir as dimensões de seu contêiner, gerando um efeito geral de zoom em toda a cena.\n\nO valor padrão é vazio, o que indica que não há alterações nas dimensões.',
		image_loader: 'Imagem que será usada como imagem de carregamento da cena.\n\nO valor padrão é vazio, indicando que o logotipo da Descartes será exibido.',
	},

	ListEditButtons: {
		add: 'Adicione um novo item à lista',
		clone: 'Adicione à lista um novo item idêntico ao selecionado.',
		delete: 'Remover o item selecionado da lista',
		list: 'Abra uma janela de texto para editar manualmente todos os objetos na lista.',
		up_down: 'Altere a ordem da lista alterando o elemento selecionado por seu vizinho.\n\nSe ficar pressionado, repete a operação rapidamente',
	},

	Spaces: {
		type: 'Determina o tipo de espaço que pode ser de dois ou três dimensões ou de tipo HTMLIFrame',
		id: 'O identificador do espaço.',
		cID: '*********',
		x: 'Abscissa da extremidade superior esquerda da janela do espaço. Ou seja, sua distância até a margem esquerda da cena.\n\nPode ser especificado com um número de pixels (por exemplo, 20) ou com uma porcentagem (por exemplo, 10%) da largura total da cena.',
		y: '\nOrdenada no canto superior esquerdo da janela do espaço. Ou seja, sua distância até a margem superior da cena.\n\nPode ser especificado com um número de pixels (por exemplo, 20) ou com uma porcentagem (por exemplo, 10%) da altura total da cena.',
		width: 'Largura da janela do espaço.\n\nÉ possível especificar com um número de pixels (por exemplo 240) ou com uma porcentagem (por exemplo 50%) da largura total da cena.',
		height: 'Altura do espaço\n\nPode ser especificado com um número de pixels (por exemplo, 180) ou com uma porcentagem (por exemplo, 50%) da altura total da cena.',
		drawif: 'Expressão booleana que determina se o espaço é visível ou não.\n\nO espaço é invisível, se e somente se, o valor da expressão é zero.\n\nSe deixado em branco, este espaço será sempre visível.\n',
		fixed: '*********',
		fixed_R2: 'Seletor que impede que o usuário modifique a escala e a localização da origem ou o ponto de vista  arrastando o mouse.',
		fixed_R3: 'Seletor que impede que o usuário modifique a escala e a localização da origem  ou o ponto de vista  arrastando o mouse.\n\n',
		scale: 'Tamanho em pixels de um segmento de unidade (ou comprimento 1).\n\nPara modificar esta variável, é necessário referir-se a ela como <id> .scale, onde <id> é o identificador do espaço.\n\nNota: É importante que os identificadores não contenham espaços ou símbolos do operador.',
		"O.x": 'Distância em pixels à direita, do centro do espaço até o ponto em que a origem da coordenada será desenhada.\n\nPara modificar essa variável, você deve se referir a ela como <id> .Ox, onde <id> é o identificador do espaço.\n\nNota: É importante que os identificadores não contenham espaços ou símbolos do operador.',
		"O.y": 'Distância (em pixles) da margem superior da janela do espaço ao ponto onde se desenhará a origem das coordenadas.\n\nPara modificar esta variável deve se referir a ela como <id>.O.y, onde <id> é o identificador do espaço.\n\nNota: é importante que os identificadores não contenham espaços nem símbolos de operadores.',
		image: 'Imagem usada como um plano de fundo do espaço.\n\nOs arquivos de imagem devem ser colocados no mesmo diretório onde o arquivo html da cena é colocado ou em subdiretórios, além do nome do arquivo, é necessário incluir os subdiretórios.\n\nVocê pode usar arquivos png, jpg, gif e svg.',
		bg_display: 'Opções para modificar a maneira em que a imagem de fundo do espaço será exibida.\n\n"arr-izq": o canto superior esquerdo da imagem é alinhado com o canto superior esquerdo do espaço.\n\n"expandir": a imagem é dimensionada para cobrir o espaço.\n\n"mosaico": a imagem é repetida quantas vezes forem necessárias para cobrir o espaço.\n\n"centrado": a imagem é desenhada',
		background: 'Cor do fundo do espaço.\n\nO botão chama o editor de cores.\n\nO valor padrão é branco (#ffffff).',
		axes: 'Cor dos eixos coordenados.\n\nO seletor é usado para decidir se os eixos são desenhados ou não.\n\nO botão chama o editor de cores.\n\nOs valores padrão são o seletor ativado e a cor cinza escuro (# 404040).',
		net: 'Cor da rede de linhas retas paralelas aos eixos coordenados que servem de referência.\n\nO seletor é usado para decidir se a rede é desenhada ou não.\n\nO botão chama o editor de cores.\n\nOs valores padrão são o seletor ativado e a cor cinza claro (# c0c0c0)',
		net10: 'Cor da rede de linhas retas paralelas aos eixos coordenados que servem de referência.\n\nO seletor é usado para decidir se a rede é desenhada ou não.\n\nO botão chama o editor de cores.\n\nOs valores padrão são o seletor ativado e a cor cinza claro (# c0c0c0)',
		text: 'Cor das coordenadas mostradas ao clicar com o botão esquerdo no espaço.\n\nO seletor é usado para decidir se as coordenadas são escritas ou não.\n\nO botão chama o editor de cores.\n\nO valor padrão é o seletor desativado.',
		numbers: 'Determina se alguns valores de coordenadas estão escritos nos eixos. Se gravadas, essas coordenadas aparecem na mesma cor dos eixos.\n\nApenas as coordenadas podem ser escritas se os eixos forem desenhados.\n\nO valor padrão está desativado.',
		x_axis: 'Rótulo que será desenhado à direita da cena, logo abaixo do eixo x.\n\nA cor do rótulo é a mesma dos eixos.\n\nSe o conteúdo for "não", o eixo não será desenhado',
		y_axis: 'Rótulo a ser desenhado acima da cena, à esquerda do eixo y.\n\nA cor do rótulo é a dos eixos.\n\nSe o conteúdo for "não", o eixo não será desenhado.\n',
		render: 'Método usado para exibir os objetos em três dimensões.\n\n"ordem": desenhe os objetos tridimensionais de trás para frente. É o mais rápido, mas tem falhas quando os objetos são compostos de grandes faces.\n\n"pintor": é um pouco mais lento, mas é muito mais confiável do que a opção "ordem".\n\n"traçado de raios": preencha o espaço de pixel a pixel, desenhando a cor do objeto que está mais próximo do observador. É o método mais confiável, mas também o mais lento.',
		split: 'Seletor que permite decidir se todos os corpos do espaço se interceptam. \n\nO valor padrão é não selecionado.\n\n Se duas superfícies se interceptam mas não lhes é permitido cortar-se, sua implantação é "impossível" e o desenho fica imcompreensível.\n\nQuando os objetos do espaço não se interceptam, não é necessário selecionar esta opcao',
		sensitive_to_mouse_movements: 'Quando ativado, determina se a cena detectará os movimentos do mouse sobre esse espaço.\n\nO valor padrão é desativado',
		file: 'Nome do arquivo referenciado pelo espaço HTMLIFrame.',
		info: 'Comentarios',
		resizable: 'Permite que a largura e a altura do espaço sejam alteradas, permitindo a avaliação de variáveis nesses parâmetros.\n\nNota: Modifica o comportamento original, em que os espaços não podem ser maiores que a área da cena.',
	},

	Controls: {
		id: 'Identificador do controle.\n\nSe o controle for numérico, <id>, será o nome da variável numérica que ele representa.\n\nSe for gráfico, então <id> .x e <id> .y, são as coordenadas do contro',
		type: '*********',
		gui: 'Tipo de interface gráfica do controle numérico. As opções são: interruptor (pulsador), escolha (desdobrável), barra de rolagem e botão.\n',
		onlyText: 'Seletor que quando está ativo faz com que o campo de texto não interprete os números ou variáveis que nele forem escritos, tomando-os apenas como cadeias de texto.',
		region: 'Região da cena em que o controle numérico é atribuído.\n\n"north": é uma ou várias linhas horizontais no topo da cena entre os créditos e os botões de configuração.\n\n"south": é uma ou várias linhas horizontais na parte inferior da cena, entre os botões start e clean.\n\n"oeste" e "leste": colunas à esquerda e à direita da cena.\n\n"fora" é uma janela que aparece quando você clica com o botão direito na cena.\n\n"interior": quando um controle numérico é associado à região interior, ele pode ser colocado em qualquer um dos espaços da cena e sua posição lá é determinada pelo parâmetro "expression".\n\nO valor padrão é "sul".',
		space: 'Lista com os identificadores de todos os espaços definidos na cena.\n\nEsse parâmetro só faz sentido nos controles atribuídos à região interna e nos controles gráficos.',
		color_CTRGRAPHIC: 'Cor da circunferência do disco que representa um controle gráfico.\n\nA cor padrão da costa é # 222222.',
		colorInt_CTRGRAPHIC: 'Cor do círculo ou interior da circunferência do disco que representa um controle gráfico.\n\nA cor padrão do interior é # f0f8ff.',
		image_CTRGRAPHIC: 'Nome do arquivo de uma imagem que será usada no lugar do círculo que Descartes usa para mostrar esse controle gráfico.',
		size: 'Rádio de controle gráfico em pixels.\n\nPode ser qualquer número ou expressão positiva.\n\nO valor padrão é 4.',
		name: 'Nome externo do controle que aparece como um rótulo à esquerda do controle numérico e não tem outra função dentro do programa.\n\nSeu valor padrão é igual ao identificador de controle',
		expression: 'Extremidade superior esquerda de um controle numérico interno.\n\nÉ expresso com dois números entre parênteses separados por uma vírgula. Os números podem ser constantes ou expressões nas quais constantes ou parâmetros definidos nos controles anteriores intervêm.\n\nNo caso de um controle numérico interno, uma expressão de quatro valores (x, y, w, h) pode ser usada, onde as duas primeiras são as coordenadas do canto superior esquerdo do controle e as duas últimas são a largura e a altura.\n\nO valor padrão é (0,0,150,40)',
		expression_CTRGRAPHIC: 'Ponto de partida de um controle gráfico.\n\nÉ expresso com dois números entre parênteses separados por uma vírgula. Os números podem ser constantes ou expressões nas quais constantes ou parâmetros definidos nos controles anteriores intervêm.\n\nO valor padrão é (0,0).',
		value: 'Valor inicial da variável <id>.\n\nPode ser uma expressão decimal ou uma fórmula na qual constantes e outros parâmetros definidos em controles anteriores podem intervir.\n\nSeu valor padrão é 0.\n\nNo caso de botões, é o valor que é atribuído à variável quando o botão é pressionado.',
		constraint: 'Equação em x ou y que as coordenadas do controle gráfico devem satisfazer. Ou seja, o controle é restrito a se mover no gráfico de sua constrição.\n\nPode ser qualquer expressão ou estar vazia. Se estiver vazio, o controle não está limitado em seu movimento.\n\nO valor padrão está vazio.',
		text: 'Etiqueta que acompanha o controle.\n\nPode ser qualquer texto que também inclua valores numéricos variáveis.\n\nO valor padrão está vazio.',
		text_CTRTEXT: 'Conteúdo inicial da área de texto.\n\nO valor padrão está vazio.',
		incr: 'É a quantidade que aumenta ou diminui o valor da variável <id>; quando pressionam-se as setas do controle numérico.\n\nPode ser uma constante ou uma expressão.\n\nO valor padrão é 0.1.',
		min: 'Valor mínimo que o controle pode ter.\n\nPode ser uma constante, uma expressão ou estar vazia, caso em que não há valor mínimo e o controle não é limitado inferiormente.\n\nO valor padrão está vazio.\n',
		max: 'É o valor máximo que pode ter o parâmetro.\n\nPode ser uma constante, uma expressão ou estar vazio, em cujo caso não tem valor máximo e o parâmetro não está limitado superiormente.\n\nO valor padrão é vazio.',
		discrete: 'Obriga que os valores do controle numérico difiram do valor inicial somente em múltiplos exatos do incremento.\n\nIsto funciona corretamente apenas se o incremento é constante e pode ser expresso exatamente com o número de decimais escolhido.\n\nO valor padrão é desativado.',
		decimals: 'Número de decimais com os quais os valores de <id> serão gravados.\n\nPode ser qualquer número ou expressão.\n\nA expressão é avaliada e arredondada para o número inteiro mais próximo para especificar o número de decimais, p. 3.5 é arredondado para 4.\n\nO valor padrão é 2.',
		fixed: 'Quando ativado, escreva números com o número especificado de decimais.\n\nSe não estiver ativado, a notação ajustada é usada. Nesse caso, os zeros desnecessários e o ponto decimal desnecessário são eliminados. Por exemplo, em vez de 25,3400, escreva 25,34 e, em vez de 13,0, escreva 13 (sem ponto decimal).\n\nSe a notação exponencial é usada, os números são sempre escritos em notação ajustada, isto é, o atributo fixo é ignorado.\n\nO valor padrão é ativado.',
		exponentialif: 'É uma expressão booleana que quando se cumpre faz com que o valor do parâmetro possa escrever-se em notação exponencial. Se a expressão é vazia, nunca se usa a notação exponencial. É importante observar que isto não força que apareça a notação exponencial, apenas a permite. Se a expressão não se cumpre, não haverá notação exponencial.\n\nO valor padrão é vazio.',
		visible: 'É um seletor que indica se o valor do parâmetro deve ser exibido ou não (o nome e os interruptores são exibidos sempre).\n\nO valor padrão é selecionado, ou seja, que o valor do parâmetro é exibido.',
		trace: 'Seletor que indica se, ao mover-se, o controle deve deixar rastro de seu caminho percorrido. O rastro de um controle é o de sua margem somente.\n\nPor padrão, aparece desativado.',
		color: 'Cor do texto na etiqueta do botão.',
		colorInt: 'Cor do fundo da etiqueta do botão.',
		bold: 'Seletor que ao ser ativado faz com que o texto da etiqueta do botão seja escrito em negrito.',
		italics: 'Seletor que ao ser ativado faz com que o texto da etiqueta do botão seja escrito em itálico.',
		underlined: 'Seletor que ao ser ativado faz com que o texto da etiqueta do botão apareça sublinhado.',
		font_size: 'Tamanho, em pontos, da fonte com a qual se escreve o texto da etiqueta do botão.\n\nO tipo de letra é sempre SansSerif.',
		image: 'Nome do arquivo de uma imagem que será usada como plano de fundo do botão.\n\nSe na mesma pasta onde a imagem está existe outro com o mesmo nome seguido por "_over" e com a mesma extensão, então esta imagem aparecerá no botão quando o cursor do mouse estiver sobre ele.\n\nSe na mesma pasta onde a imagem está existe outra com o mesmo nome seguido por "_down" e com a mesma extensão, então esta imagem aparecerá no botão quando o botão for pressionado com o mouse.\n',
		options: 'Lista de opções  com interface de "escolha".\n\nAs opções devem ser palavras separadas por vírgulas. Depois de cada palavra pode vir entre colchetes [] o valor que deve associar-se ao parâmetro quando seleciona-se esta opção. Se o valor não é definido, então associa-se automaticamente um valor inteiro correspondente ao índice da opção.\n',
		action: 'A ação que se realiza quando o usuário manipula o controle numérico (clicar no botão, selecionar um elemento da lista, mover a barra de rolagem, clicar em um interruptor, ou dar &lt;intro&gt; no campo de texto).\nExistem as seguintes opções possíveis:  "calcular", "abrir URL", "abrir cena", "início", "limpar", "animar" e "iniciar animação".\n',
		parameter: 'O parâmetro da ação.\n\nSe a ação for "calcular", ela deverá conter zero ou várias atribuições separadas por um ponto-e-vírgula (;) ou quebra de linha (\\ n), que o programa executará quando a ação for executada.\n\nSe a ação for "URL aberto", o parâmetro deve ser um URL.\n\nSe a ação for "cena aberta", o parâmetro deve ser um endereço relativo e o que ele faz é abrir a cena Descartes que está em um arquivo de texto com esse endereço.\n\nAs outras ações não usam o parâmetro.',
		drawif: 'Expressão booleana que determina quando o controle é visível.\n\nO valor padrão está vazio e, nesse caso, o controle está sempre visível.',
		activeif: 'Expressão booleana que determina quando o controle é visível.\nO valor padrão é vazio, e neste caso o controle é sempre visível.',
		evaluate: 'Determina se o controle carrega avaliação automática.\n\nSó se aplica nos controles das cenas que são itens (ou reagentes) para avaliações.\n\nAparece desativado por padrão. Quando ativado em um controle de um item, o programa sabe que ao avaliar o item deve considerar o que o usuário escreveu ou selecionou no controle, como uma resposta e compará-lo com o padrão de resposta associado.\n',
		answer: 'Este campo está inativo enquanto o seletor "avaliar" está desativado.\n\nA resposta esperada, programada pelo autor da lição. Essa é a resposta na qual a resposta do usuário é comparada para determinar se está correta.\n\nEle é aplicado apenas com controles que levantam questões e onde uma resposta precisa ser avaliada comparando a resposta do usuário com a resposta da lição.\n\nPode consistir em um ou mais textos separados por |, cada um deles é comparado com a resposta do usuário.\n\nSe houver um emparelhamento, a resposta será marcada como correta, caso contrário, será marcada como incorreta.\n\nQuando a resposta esperada é numérica, o autor da lição precisa estabelecer um intervalo válido, por exemplo, [a, b], (a, b), (a, b] ou [a, a].\n\nQuando o controle é do tipo "somente texto", a avaliação da resposta é realizada comparando letra por letra.\n\nSe uma opção de resposta for terminada com *, a resposta do usuário será comparada apenas ao início da resposta.\n\nSe uma opção de resposta começar com *, a resposta do usuário deverá terminar com o mesmo valor de resposta.\n\nSe uma opção de resposta começar e terminar com *, por exemplo, * response *, a resposta do usuário deverá conter a "resposta".\n\nSe a resposta esperada puder ser maiúscula ou minúscula, a opção de resposta deverá ser escrita entre aspas simples, por exemplo, \'responder\'.\n\nSe os acentos ou n ou ñ não são distinguíveis, a opção de resposta deve ser escrita entre acentos à esquerda e à direita, por exemplo, \'resposta\'.\n\nDa mesma forma, \'\' answer \'\' permitiria ignorar letras maiúsculas e minúsculas, acentos e n de ñ.\n\nPara fazer uma carta ignorar, deveria ser usada? em vez da letra.',
		weight: 'Peso (no contexto de uma média ponderada) que é dado à resposta dada na avaliação ao calcular a nota.\n\nApenas valores inteiros positivos são permitidos e recomenda-se usar apenas 0, 1 ou 2.\n\n',
		tooltip: 'Texto que aparece quando o mouse fica parado mais de um segundo e meio sobre a etiqueta de um controle numérico ou dentro do círculo de um controle gráfico.\n\nO valor padrão é vazio.',
		explication: 'Texto que aparece quando o usuário clica com o botão direito sobre a etiqueta de um controle numérico ou dentro do círculo de um controle gráfico.\n\nO valor padrão é o de "tooptip"',
		cID: 'Identificador para os controles que estão no cenário.\n\nÉ útil apenas em cenas de Arquimedes ou Fala.\n\nO valor do identificador é calculado pelo programa de acordo com o momento exato em que foi criado, portanto, todos os identificadores criados no mesmo computador são diferentes.\n\nA manipulação manual deste identificador não é recomendada.\n',
		file: 'Nome do arquivo multimídia (áudio ou vídeo).',
		info: 'Comentários',
		borderColor: 'Cor da borda do texto do botão.\n\nQuando ativado, o texto do botão é desenhado com uma borda da cor selecionada.\n\nO valor padrão está desativado.',
		flat: 'Quando ativado, o botão é desenhado sem gradiente (estilo plano).\n\nO valor padrão é desativado, isto é, o botão é desenhado com gradiente (estilo tradicional de Descartes).',
		text_align: 'Opções para escolher o alinhamento da etiqueta do botão, em relação à região retangular ocupada pelo controle.',
		image_align: 'Opções para escolher o alinhamento da imagem do botão, em relação à região retangular ocupada pelo controle.',
		cssClass: 'Classes de estilo CSS às quais o botão pertence.\n\nIsso permite modificar o estilo do botão por meio de folhas de estilo externas.',
		radio_group: 'Se o valor estiver vazio, o controle se comportará como uma caixa de seleção.\n\nSe, em vez disso, ele contiver um nome, o controle se comportará como um botão de opção pertencente ao grupo com o nome especificado. Quando é um botão de opção, apenas um dos controles com o mesmo grupo pode ser selecionado.',
	},

	Definitions: {
		id: 'Identificador da definição.\n\nNo caso de uma função, deve incluir os parâmetros de que depende, escritos entre parênteses e separados por vírgulas. Por exemplo: f (x, y, x).',
		expression: 'Valor da constante, variável ou função.',
		evaluate: 'Opções que permitem definir se a constante, a expressão do vetor ou o algoritmo devem ser avaliados toda vez que o usuário modifica um controle ou apenas uma vez quando a cena inicia.\n\nÉ importante selecionar "apenas uma vez" quando for possível que a operação da cena seja mais rápida.',
		size: 'Número de elementos do vetor.',
		rows: 'Número de linhas na matriz.',
		columns: 'Número de colunas na matriz.',
		range: 'Expressão booleana que determina o domínio da função.\n\nQualquer tentativa de avaliar a função fora de seu domínio lançará uma exceção, na qual, por exemplo, seu gráfico não é desenhado em pontos que não estão no domínio.\n\nO valor padrão é vazio, o que é interpretado como o domínio não é restrito',
		algorithm: 'Quando ativado, indica que a função a ser avaliada deve usar um algoritmo; isto é, use os cálculos indicados em "start", "do" e "while".\n\nO valor padrão não está ativado.',
		expression2: 'Atribuições para valores vetoriais, separados por ponto e vírgula (;) ou quebras de linha (\\ n).\n\nPor exemplo, se o identificador do vetor for v e tiver tamanho 3, você poderá escrever:\n\nv [0] = 1\nv [1] = 2,5\nv [2] = - 3,1',
		local: 'Declaração das variáveis que devem ser protegidas durante a execução da função.\n\nPara proteger as variáveis, você deve escrever os identificadores separados por vírgulas (,) ou ponto e vírgula (;).\n\nPor exemplo: i, j; k.',
		init: 'Atribuições e chamadas para funções separadas por ponto e vírgula (;), de forma que tudo nesse campo seja executado no início do cálculo.',
		doExpr: 'Atribuições e chamadas para funções separadas por quebras de linha (\\ n), de tal forma que tudo neste campo é executado repetidamente enquanto a condição do parâmetro "enquanto" é válida.',
		whileExpr: 'Expressão booleana que determina a condição para repetir as instruções do parâmetro "fazer".',
		file: 'Arquivo de texto (recomenda-se que tenha uma extensão .txt) na qual os valores dos elementos do vetor, separados por uma quebra de linha, aparecem em ordem.\n\nOs valores podem ser numéricos ou string; nesse caso, eles devem aparecer entre aspas simples, por exemplo, \'value\'.',
		info: 'Comentários',
	},

	Programs: {
		id: 'Identificador do programa.',
		evaluate: 'Opções que permitem definir se a constante, a expressão do vetor ou o algoritmo devem ser avaliados toda vez que o usuário modifica um controle ou apenas uma vez quando a cena inicia.\n\nÉ importante selecionar "apenas uma vez" quando for possível que a operação da cena seja mais rápida.',
		init: 'Atribuições e chamadas para funções separadas por ponto e vírgula (;), de forma que tudo nesse campo seja executado no início do cálculo.',
		doExpr: 'Atribuições e chamadas para funções separadas por quebras de linha (\\ n), de tal forma que tudo neste campo é executado repetidamente enquanto a condição do parâmetro "enquanto" é válida.',
		whileExpr: 'Expressão booleana que determina a condição para repetir as instruções do parâmetro "fazer"',
		condition: 'Expressão booleana que, quando cumprida, executa a ação.\n\nA repetição da ação é condicionada pelo parâmetro "execução"',
		action: 'Ação que é executada ao interagir com a cena e cumprir a condição booleana do parâmetro "condição".\n\nExistem as seguintes ações: "calcular", "abrir URL", "abrir cena", "iniciar", "limpar", "animar", "reiniciar animação" e "reproduzir".',
		parameter: 'Parâmetro utilizado para a ação.\n\nSe a ação for "calcular", ela deverá conter zero ou várias atribuições que o programa fará quando a ação for executada.\n\nSe a ação for "URL aberto", ela deverá ser qualquer URL.\n\nSe a ação é "cena aberta", então deve ser uma direção absoluta ou relativa para a cena de Descartes que você deseja abrir.\n\nAs outras ações não usam o parâmetro.',
		execution: 'Determina o modo de execução da ação do evento.\n\n"uma só vez": a ação só é executada na primeira vez que a condição é atendida.\n\n"alternar": a ação é executada na primeira vez que a condição é satisfeita, mas se a condição deixar de ser válida e retornar a ela mais tarde, a ação é executada novamente.\n\n"sempre": a ação é executada desde que a condição seja atendida.\n\nO valor padrão é "somente uma vez".',
		info: 'Comentários',
	},

	Graphics: {
		space: 'Lista dos espaços bidimensionais que foram definidos.\n\nÉ usado para atribuir o espaço ao qual o gráfico pertence.',
		type: 'Campo de texto não editável que mostra o tipo do gráfico',
		background: 'Quando ativado, indica que o gráfico é desenhado somente no fundo da cena e, portanto, é atualizado somente quando "start" é pressionado e quando a escala ou posição da origem é modificada (O.xe O.y).\n\nQuando um gráfico é sempre fixo na cena, isto é, não depende dos controles, definições ou programas, é conveniente ativar esta opção, pois isso economiza o trabalho de desenhar o gráfico toda vez que houver uma mudança na cena.',
		color: 'Cor do gráfico\n\nO botão chama o editor de cores.\n\nO valor padrão é # 20303a.',
		color_ARROW: 'Cor da borda ou borda da seta, seu interior é desenhado na cor do parâmetro "seta".\n\nO valor padrão é # 20303a.',
		drawif: 'Expressão booleana que determina se o gráfico é desenhado ou não.\n\nO gráfico é desenhado se a expressão estiver vazia ou se tiver um valor verdadeiro (ou maior que zero).\n\nO valor padrão é vazio, o que indica que é sempre desenhado.',
		drawif_EQUATION: 'Expressão booleana que determina se o gráfico é desenhado ou não.\n\nO gráfico é desenhado se a expressão estiver vazia ou se tiver um valor verdadeiro (ou maior que zero).\n\nSe a expressão depende de x ou y, e o gráfico é uma equação, somente os pontos no gráfico que satisfazem a expressão são desenhados.\n\nSe o valor de x ou y, não permite que a expressão seja preenchida no momento em que um objeto deve ser desenhado, então ele não é desenhado (é de responsabilidade do autor controlar o valor de xey fora das equações).\n\nO valor padrão é vazio, o que indica que é sempre desenhado.',
		abs_coord: 'Quando ativado, o gráfico é interpretado em pixels e em coordenadas absolutas, com a origem no canto superior esquerdo da área do espaço ao qual o gráfico pertence e a escala igual a 1 pixel por unidade.\n\nGráficos definidos em coordenadas absolutas não se movem ao alterar a origem ou escala do sistema.',
		expression_EQUATION: 'Deve ser uma equação em x, y. O objeto gráfico associado a uma equação é o locus dos pontos que a satisfazem.\n\nO valor padrão é y = x.',
		expression_CURVE: 'Expressão da forma (f (t), g (t)), onde f e g são quaisquer funções do parâmetro t (ou aquele que é definido no campo "parâmetro").\n\nO valor padrão é (t, t).\n',
		expression_SEQUENCE: 'Expressão do tipo (X, Y), onde X e Y são expressões reais dependentes de n, que representam a abscissa e a ordenada dos pontos da sequência.\n\nO valor padrão é (n, 1 / n).\n',
		expression_POINT: 'Expressão do tipo (X, Y), onde X e Y são quaisquer expressões reais que representam a abscissa e a ordenada do ponto.\n\nO valor padrão é (0,0).',
		expression_SEGMENT: 'Expressão do tipo (X1, Y1) (X2, Y2), onde (X1, Y1) são as coordenadas do início do segmento e (X2, Y2) as do final do segmento.\n\nO valor padrão é (0,0) (1,1), ou seja, o segmento entre a origem e o ponto (1,1).',
		expression_ARROW: 'Expressão do tipo (X1, Y1) (X2, Y2), onde (X1, Y1) são as coordenadas do início da seta e (X2, Y2) as da ponta.\n\nO valor padrão é (0,0) (1,1), isto é, a seta que vai da origem ao ponto (1,1).',
		expression_POLYGON: 'Tipo de expressão\n\n(x1, y1) (x2, y2) ... (xN, yN),\n\nonde xn e yn são expressões reais arbitrárias.\n\nO gráfico é o polígono com vértices nos pontos (xn, yn).\n\nO valor padrão é (0,0) (1,1) (2, -1).',
		expression_FILL: 'Expressão do tipo (X, Y), onde X e Y são quaisquer expressões reais que representam a abcissa e ordenada do ponto onde o processo de preenchimento ou coloração da região fechada que tem o ponto (X, Y) em seu interior começará .\n\nO valor padrão é (0,0).',
		expression_TEXT: 'Expressão do tipo [X, Y], onde X e Y são quaisquer expressões reais que representam a abscissa e ordenada do início do texto, mas medidas em pixels a partir do canto superior esquerdo da cena.\n\nO valor padrão é [20,20].',
		expression_IMAGE: 'Expressão do tipo (X, Y), onde X e Y são quaisquer expressões reais que representam a abscissa e a ordenada da extremidade superior esquerda da imagem em relação à origem das coordenadas espaciais.\n\nO valor padrão é (0,0).',
		expression_MACRO: 'Nome do arquivo que contém os dados da macro. O arquivo deve estar na pasta onde está a página que contém a cena ou em subpastas dela.',
		expression: '*********',
		center: 'Deve ser uma expressão do tipo (X,Y) que representará o centro do arco, onde X e Y podem ser expressões reais arbitrárias.                  \n\nO valor  padrão é (0,0)',
		radius: 'É o raio do arco. Pode ser uma expressão real arbitrária.',
		init: 'Começo do arco.\n\nExistem duas opções: uma expressão real arbitrária que será interpretada como o ângulo inicial em graus, outra pode ser uma expressão da forma (x1, y1) que será interpretada como um ponto. No segundo caso, o arco começa no segmento que une o centro (X, Y) com o ponto (x1, y1).\n',
		end: 'Fim do arco\n\nExistem duas opções: uma expressão real arbitrária que será interpretada como o ângulo final em graus, outra pode ser uma expressão da forma (x2, y2) que será interpretada como um ponto. No segundo caso, o arco termina no segmento que une o centro (X, Y) com o ponto (x2, y2).\n',
		vectors: 'Determina que o lado inicial e final do arco são obtidos de dois vetores que partem do centro do arco e não de dois pontos do plano.\n',
		trace: 'Se seleciona-se rastro, o objeto deixa um rastro na cena da cor selecionada. \n\nPara escolher uma cor deve-se clicar no botão quadrado que aparece junto ao seletor (ver cores).\n                                                                                 \nQuando um gráfico deixa rastro, pode-se apreciar sua trajetória na cena. Clicando no botão limpar, apagam-se os rastros dos gráficos.\n\nO valor padrão é não ativado\n',
		useFamily: 'Quando ativado, ele converte um gráfico em uma família inteira de gráficos, dependendo de um parâmetro.\n\nAo selecionar família, os campos "parâmetro "," intervalo "e" etapas " são ativados.\n\nO valor padrão não está ativado',
		family: 'Nome do parâmetro usado na definição do objeto gráfico para definir a família.\n\nO valor padrão é "s".\n\nO programa desenhará os gráficos, com os valores de "s", passando pelo intervalo especificado no número de passos escolhidos.',
		family_interval: 'Intervalo no qual o parâmetro da família obterá os valores ao percorrê-lo no número especificado de etapas.\n\nSão duas expressões reais entre parênteses e separadas por uma vírgula.\n\nO valor padrão é [0,1].',
		family_steps: 'Número de subintervalos iguais em que o intervalo da família é dividido e o parâmetro da família passa pelas extremidades dos subintervalos.\n\nO valor padrão é 8.\n',
		parameter: 'Identificador do parâmetro usado na curva. Recomenda-se usar uma palavra curta. O valor padrão é "t".\n\nO programa irá desenhar o polígono com vértices:\n\n(f (t), g (t)) para "t" entre o primeiro e o último dos valores de intervalo, com incrementos iguais à duração do intervalo entre o número de etapas.\n',
		parameter_interval: 'Intervalo no qual o parâmetro da curva obterá os valores ao cruzá-lo no número especificado de etapas.\n\nSão duas expressões reais ti e tf entre parênteses e separadas por uma vírgula, ou seja, [ti, tf].\n\nO valor padrão é [0,1].',
		parameter_steps: '\nNúmero de subintervalos iguais em que se divide o intervalo de la curva. E o parâmetro de la curva passa pelos extremos dos subintervalos. \n\nO valor padroa é 8',
		text: 'Rótulo que acompanha o objeto gráfico e está escrito próximo à sua posição ou algo que pode ser considerado como sua posição.\n\nOs textos são desenhados na mesma cor do objeto gráfico.\n\nOs textos podem ter várias linhas e também podem incluir valores numéricos variáveis.\n\nO valor padrão está vazio.',
		decimals: 'É o número de decimais com que se escrevem os números no texto.\n\nPode ser um  número fixo ou expressão. Ao ser analisada, arredonda-se para decidir o número de decimais.\n\nSeu valor padrão é 2.',
		fixed: 'Quando ativado, determina se o número de casas decimais é fixo ou se, ao contrário, a notação ajustada é usada, na qual os zeros desnecessários são eliminados e o ponto decimal se também é desnecessário.\n\nPor exemplo: em vez de 25,3400, 25,34 é gravado e, em vez de 13,0, 13 é gravado (sem um ponto decimal).\n\nSe a notação exponencial é usada, os números são sempre escritos em uma forma ajustada, ou seja, o atributo fixo não intervém nesse caso.\n\nO valor padrão é desativado',
		border: 'Cor da borda no texto.',
		font: '*********',
		fill: 'Quando ativado, o programa preenche o interior da curva (considerada como um polígono) com a cor selecionada. Se a curva não tiver um interior bem definido, o resultado pode ser algo estranho.\n',
		fillP: 'Quando ativado:\n\nSe a equação é da forma y = f (x), o espaço entre o eixo xeo gráfico (acima do eixo x) é preenchido com a cor selecionada.\n\nSe a equação for da forma x = g (y), o espaço entre o eixo yeo gráfico (à direita do eixo y) é preenchido com a cor selecionada.\n\nO valor padrão está desativado.',
		fillM: 'Quando ativado:\n\nSe a equação for da forma y = f (x), o espaço entre o eixo xeo gráfico (abaixo do eixo x) é preenchido com a cor selecionada.\n\nSe a equação for da forma x = g (y), o espaço entre o eixo yeo gráfico (à esquerda do eixo y) é preenchido com a cor selecionada.\n\nO valor padrão está desativado.',
		size: '*********',
		size_POINT: 'Raio do disco usado para representar o ponto.\n\nSe o valor for 0, o ponto não será desenhado. O último pode ser usado para desenhar textos associados a pontos invisíveis, usando as coordenadas do espaço.\n\nO valor padrão é 2.',
		size_SEQUENCE: 'Raio de disco usado para representar os pontos da sequência.\n\nSe o valor for 0, os pontos não serão desenhados.\n\nO valor padrão é 2',
		size_SEGMENT: 'Raio do disco usado para representar as extremidades do segmento.\n\nSe o valor for 0, as extremidades não serão desenhadas.\n\nO valor padrão é 2.\n',
		width: '*********',
		width_EQUATION: 'Largura ou espessura do traço em pixels.\n\nO valor padrão é 1.                        Recomenda-se usar um pouco as larguras diferentes de 1, porque eles diminuem a velocidade do desenho.',
		width_CURVE: 'Largura ou espessura em pixels, dos segmentos da curva.\n\nO valor padrão é 1.',
		width_SEGMENT: 'Largura ou espessura em pixels, do segmento.\n\nO valor padrão é 1.',
		width_POLYGON: 'Largura ou espessura em pixels, dos segmentos do polígono.\n\nO valor padrão é 1.',
		width_ARC: 'Largura ou espessura em pixels, do arco.\n\nO valor padrão é 1.',
		width_ARROW: 'Largura ou espessura em pixels da seta.\n\nO valor padrão é 5.',
		width_TEXT: 'Em textos não enriquecidos, especifique a largura máxima de uma linha de texto antes de adicionar quebras de linha.\n\nSe for usado em textos ricos ou se o valor for menor que 20, ele será ignorado.\n\nO valor padrão é 1.',
		spear: 'É a largura da ponta da seta. Seu valor padrão é 8.',
		arrow: 'Cor do interior da flecha.\n\nO valor padrão é # ee0022.',
		visible: 'Quando ativado, um campo de texto aparecerá na parte inferior da cena, onde você poderá ver a expressão da equação na mesma cor do gráfico e com a cor de fundo da cena.\n\nO valor padrão não está ativado.\n\nSe houver várias equações ou curvas em uma cena, abaixo dela, aparecem os campos de texto de todos e de cada um dos que são visíveis. Se houver muitos campos, eles podem ser muito pequenos, por isso é recomendável não deixar visíveis os campos de texto de mais de três ou quatro equações ou curvas.',
		editable: 'Quando ativado, o conteúdo do campo de texto que aparece sob a cena com a equação (ou curva) pode ser modificado pelo usuário.\n\nEssa opção é útil quando você deseja que o aluno pratique a redação da fórmula.\n',
		range: 'Expressão da forma [n1, n2] em que n1 e n2 são dois inteiros que são interpretados como o início e o fim do intervalo de inteiros que "n" irá percorrer. O programa desenha os pontos (X, Y) para cada valor de "n" entre n1 e n2.\n',
		file: 'Nome do arquivo da imagem que você deseja usar como um objeto gráfico. Somente arquivos png, jpg, gif e svg podem ser usados. Os arquivos de imagem devem ser colocados no mesmo local onde o arquivo html da cena é colocado ou em subdiretórios de lá. Os subdiretórios devem ser incluídos no nome do arquivo.',
		inirot: 'Ângulo de rotação do objeto gráfico, no sentido anti-horário.\n\nPode ser uma expressão ou um número fixo.',
		inipos: 'É um campo de texto cujo conteúdo deve ser do tipo (X,Y), onde X e Y são expressões reais quaisquer que representam a abscissa e a ordenada do ponto inicial da macro  com relação à origem das coordenadas do espaço.',
		name: 'Nome da macro, que é usada para acessar seus parâmetros ao calcular.\n\nA sintaxe para acessar os parâmetros é <name_macro> .name_do_ parâmetro.',
		opacity: 'Nível de opacidade da imagem, ou seja, opaco ou translúcido.\n\nO valor aceito é um número entre 0 e 1, em que 0 é completamente transparente e 1 é completamente opaco.\n\nO valor padrão é 1.',
		align: 'O alinhamento do texto em relação a uma caixa, cuja largura é determinada pelo tamanho da linha de texto mais longa que compõe o texto e a altura, é determinada pela altura do texto.\n\nO texto pode ser alinhado à borda esquerda, centralizado ou anexado à borda direita da caixa.\n\nSe o texto consistir em uma única linha, os três alinhamentos desenham o texto da mesma maneira.',
		anchor: 'O ponto de ancoragem da caixa de texto, cuja largura é determinada pelo tamanho da linha de texto mais longa que compõe o texto e a altura, é determinado pela altura do texto.\n\nA posição do texto (dada pelo parâmetro de expressão) e o ponto de ancoragem determinam como a caixa de texto é construída e, consequentemente, a posição do texto dentro do espaço.',
		lineDash: 'Opções que determinam o estilo de desenho do traçado gráfico, que pode ser "sólido", "ralado" ou "pontilhado".',
		info: 'Comentários\n',
	},

	Graphics3D: {
		name: 'Nome da macro, que é usada para acessar seus parâmetros ao calcular.\n\nA sintaxe para acessar os parâmetros é <nome_macro> .nome do parâmetro',
		space: 'Lista de espaços tridimensionais que foram definidos.\n\nÉ usado para atribuir o espaço ao qual o gráfico pertence.',
		type: 'Campo de texto não editável que mostra o tipo do gráfico',
		background: 'Se seleciona-se "fundo", o gráfico 3D é calculado apenas uma vez e é atualizado apenas quando se clica em início.\nQuando um gráfico 3D não depende dos controles nem dos auxiliares, convém definir-lo como de fundo, pois assim se poupa trabalho ao processador, que não terá que calcula-lo cada vez que haja uma alteração na cena.\n',
		color: 'Cor do gráfico\n\nO botão chama o editor de cores.\n\nO valor padrão é #eeffaa.',
		backcolor: 'Cor da parte de trás do gráfico.\n\nO botão chama o editor de cores.\n\nO valor padrão é # 6090a0.',
		drawif: 'Expressão booleana que determina se o gráfico é desenhado ou não.\n\nO gráfico é desenhado se a expressão estiver vazia ou se tiver um valor verdadeiro (ou maior que zero).\n\nO valor padrão é vazio, o que indica que é sempre desenhado.',
		expression: '*********',
		expression_POINT: '  Expressão do formulário:\n\n(X, Y, Z)\n\nonde X, Y e Z são quaisquer expressões numéricas, representando a posição espacial de um ponto em três dimensões.\n\nO valor padrão é (0,0,0)',
		expression_SEGMENT: 'Expressão do formulário:\n\n(X1, Y1, Z1) (X2, Y2, Z2)\n\nonde X1, Y1, Z1, X2, Y2, Z2 são expressões numéricas, que representam a posição espacial das extremidades do segmento em três dimensões.\n\nO valor padrão é (0,0,0) (1,1,1).',
		expression_POLYGON: 'Expressão do formulário:\n\n(X1, Y1, Z1) (X2, Y2, Z2) ... (Xn, Yn, Zn)\n\nonde X1, Y1, Z1, X2, Y2, Z2, ..., Xn, Yn, Zn são expressões numéricas, representando vários segmentos representando um polígono (sem faces) em três dimensões.\n\nO valor padrão é (0,0,0) (1,0,0) (1,1,0) (1,1,1).',
		expression_CURVE: 'Expressão do formulário:\n\nx = X (u)\ny = Y (u)\nz = Z (u)\n\nonde X, Y e Z são expressões numéricas dependentes do parâmetro u.\n\nA curva é desenhada como um polígono com os lados Nu cujos vértices Nu + 1 são os pontos:\n\n(X (i / Nu), Y (i / Nu), Z (i / Nu)) para i = 0, ..., Nu + 1.\n\nAntes de x, y, z, você pode definir variáveis intermediárias que são usadas apenas para os cálculos feitos ao desenhar a curva.',
		expression_TRIANGLE: 'Coordenadas de três pontos do espaço, isto é, uma expressão da forma:\n\n(X1, Y1, Z1) (X2, Y2, Z2) (X3, Y3, Z3)\n\nonde Xi, Yi, para i = 1,2,3 pode ser expressões numéricas.',
		expression_FACE: 'Coordenadas de um polígono no plano, isto é, uma expressão do formulário:\n(X1, Y1) (X2, Y2) ... (Xn, Yn)\nonde Xi, Yi, para i = 1, ..., n são expressões numéricas.',
		expression_SURFACE: 'Expressão do formulário:\n\nx = X (u, v)\ny = Y (u, v)\nz = Z (u, v)\n\nonde X, Y e Z são expressões numéricas dependentes dos parâmetros u e v.\n\nA superfície consiste na rede de quadriláteros formados pelos pontos:\n\n(X (i / Nu, j / Nv), Y (i / Nu, j / Nv), Z (i / Nu, j / Nv))\n\npara i = 0, ..., Nu + 1 ej = 0, ..., Nv + 1.\n\nAntes de x, y, z, você pode definir variáveis intermediárias que são usadas apenas para os cálculos feitos ao desenhar a superfície.',
		expression_TEXT: 'Expressão do formulário:\n\n[X, Y]\n\nonde X e Y são expressões numéricas que determinam a posição do texto em pixels medidos da esquerda para a direita e de cima para baixo em relação ao canto superior esquerdo do espaço.',
		expression_MACRO: 'Nome do arquivo que contém os dados da macro. O arquivo deve estar na pasta onde está a página que contém a cena ou em subpastas dela.',
		useFamily: 'Quando ativado, ele converte um gráfico em uma família inteira de gráficos, dependendo de um parâmetro.\n\nAo selecionar família, os campos "parameter", "interval" e "steps" são ativados.\n\nO valor padrão não está ativado.',
		family: 'Nome do parâmetro usado na definição do objeto gráfico para definir a família.\n\nO valor padrão é "s".\n\nO programa irá desenhar os gráficos, com os valores de "s", passando pelo intervalo especificado no número de passos escolhidos.',
		family_interval: 'Intervalo no qual o parâmetro da família obterá os valores ao percorrê-lo no número de etapas especificado.\n\nSão duas expressões reais entre parênteses e separadas por uma vírgula.\n\nO valor padrão é [0,1].',
		family_steps: 'Número de subintervalos iguais em que o intervalo da família é dividido e o parâmetro da família passa pelas extremidades dos subintervalos.\n\nO valor padrão é 8.',
		inirot: 'Vetor de três componentes (A, B, C) que representam uma rotação inicial, cujos elementos são rotações (em graus) em torno do eixo x, eixo y e eixo z, respectivamente, que serão aplicados ao objeto gráfico antes desenhar\n\nSe a palavra "Euler" é adicionada antes do triplo ordenado, isto é, Euler é escrito (A, B, C), então os ângulos A, B e C são interpretados como rotações de Euler, isto é, A é uma rotação em torno do eixo z, B em torno do novo eixo x (aquele obtido após a primeira rotação) e C em torno do novo eixo z (aquele obtido após as duas primeiras rotações).\n\nNota: É aplicado antes da translação inicial.',
		inipos: 'Vetor de três componentes (A, B, C) que representa uma tradução inicial, que será aplicada ao objeto gráfico antes do desenho.\n\nNota: É aplicado após a rotação inicial e antes da rotação final.',
		endrot: 'Vetor de três componentes (A, B, C) que representam uma rotação final, cujos elementos são rotações (em graus) ao redor do eixo x, eixo y e eixo z, respectivamente, que serão aplicados ao objeto gráfico antes desenhar\n\nSe a palavra "Euler" é adicionada antes do triplo ordenado, isto é, Euler é escrito (A, B, C), então os ângulos A, B e C são interpretados como rotações de Euler, isto é, A é uma rotação em torno do eixo z, B em torno do novo eixo x (aquele obtido após a primeira rotação) e C em torno do novo eixo z (aquele obtido após as duas primeiras rotações).\n\nNota: É aplicado após a tradução inicial e antes da translação final.',
		endpos: 'Vetor de três componentes (A, B, C) que representa uma tradução final, que será aplicada ao objeto gráfico antes do desenho.\n\nNota: Aplica-se após a rotação final',
		split: 'Quando ativado, indica se a superfície deve ser cortada pelos gráficos do mesmo espaço que a precedem na lista, no caso de interseção.\n\nÉ aconselhável manter esta opção sempre ativada, a menos que você esteja usando muitos gráficos que não se cruzam e é conveniente tornar a execução um pouco mais rápida.',
		edges: 'Quando ativado, determina se as arestas das faces que compõem o objeto devem ser desenhadas ou não. As bordas são desenhadas em cinza.',
		text: 'Rótulo que acompanha o objeto gráfico e está escrito próximo à sua posição ou algo que pode ser considerado como sua posição.\n\nOs textos são desenhados na mesma cor do objeto gráfico.\n\nOs textos podem ter várias linhas e também podem incluir valores numéricos variáveis.\n\nO valor padrão está vazio.',
		font: '*********',
		decimals: 'Número de decimais com o qual os números incluídos no texto são gravados.\n\nPode ser um número fixo ou uma expressão. Ao avaliar os números são arredondados para decidir o número de decimais.\n\nO valor padrão é 2.',
		fixed: 'Quando ativado, determina se o número de casas decimais é fixo ou se, ao contrário, a notação ajustada é usada, na qual os zeros desnecessários são eliminados e o ponto decimal se também é desnecessário.\n\nPor exemplo: em vez de 25,3400, 25,34 é gravado e, em vez de 13,0, 13 é gravado (sem um ponto decimal).\n\nSe a notação exponencial é usada, os números são sempre escritos em uma forma ajustada, ou seja, o atributo fixo não intervém nesse caso.\n\nO valor padrão está desativado.',
		model: 'Opções para desenhar as faces do objeto gráfico.\n\n"cor": faz com que desenhe com cores sólidas.\n\n"light": torna a cor mais ou menos brilhante de acordo com a orientação, para dar uma sensação de iluminação.\n\n"metal": é como a luz, mas com um brilho mais contrastado para dar a impressão de que a superfície é metálica.\n\n"wire": desenha apenas as bordas na cor selecionada.\n\nNota: Com o modelo de arame, as arestas são desenhadas na cor selecionada e não em cinza como nos outros modelos.',
		width: '*********',
		width_POINT: 'Tamanho do ponto em pixels.\n\nO valor padrão é 1.',
		width_SEGMENT: 'Largura ou espessura em pixels, do segmento.\n\nO valor padrão é 1.',
		width_POLYGON: 'Largura ou espessura em pixels, dos segmentos do polígono.\n\nO valor padrão é 1.',
		width_CURVE: 'Largura ou espessura em pixels, dos segmentos da curva.\n\nO valor padrão é 1.',
		width_POLIREG: 'Metade do raio do polígono regular se largura = comprido. Se largura! = comprido, então o polígono não é regular, mas é uma deformação de um regular.',
		width_CUBE: 'Tamanho do lado do cubo em pixels.\n\nO valor padrão é 2.',
		width_BOX: 'Dimensão ao longo do eixo x.\n\nO valor padrão é 2.',
		width_TETRAHEDRON: 'Tamanho do lado do tetraedro em pixels.\n\nO valor padrão é 2.',
		width_OCTAHEDRON: 'Tamanho do lado do octaedro em pixels.\n\nO valor padrão é 2.',
		width_DODECAHEDRON: 'Tamanho do lado do dodecaedro em pixels.\n\nO valor padrão é 2.',
		width_ICOSAHEDRON: 'Tamanho do lado do icosaedro em pixels.\n\nO valor padrão é 2.',
		width_SPHERE: 'Tamanho do diâmetro da esfera em pixels.\n\nO valor padrão é 2',
		width_ELLIPSOID: 'Dimensão ao longo do eixo x.\n\nO valor padrão é 2.',
		width_CONE: 'Dimensão ao longo do eixo x.\n\nO valor padrão é 2.',
		width_CYLINDER: 'Dimensão ao longo do eixo x.\n\nO valor padrão é 2.',
		length: '*********',
		length_POLIREG: 'Metade do raio do polígono regular se largura = comprido. Se largura! = comprido, então o polígono não é regular, mas é uma deformação de um regular.',
		length_ELLIPSOID: 'Dimensão ao longo do eixo y.\n\nO valor padrão é 2.',
		length_CONE: 'Dimensão ao longo do eixo y.\n\nO valor padrão é 2.',
		length_CYLINDER: 'Dimensão ao longo do eixo y.\n\nO valor padrão é 2.',
		height: 'Dimensão ao longo do eixo z.\n\nO valor padrão é 2.',
		Nu: 'Número de intervalos em que o intervalo unitário [0,1] é dividido para o parâmetro "u".',
		Nv: 'Número de intervalos em que o intervalo unitário [0,1] é dividido para o parâmetro "v"',
		offset_dist: 'Rolagem do texto em relação à posição do ponto.',
		offset_angle: 'Ângulo no qual o texto é movido em relação à posição do ponto.',
		info: 'Comentários.',
	},

	Animation: {
		useAnimation: 'Quando ativado, todos os campos do painel de animação são ativados e o autor pode escrever neles ou escolher opções para programar a animação.',
		delay: 'O tempo em milissegundos que o programa aguarda em cada etapa da animação.\n\nO valor padrão é 40.\n\nValores pequenos tornam a animação mais rápida e vice-versa. Nos processadores lentos, os valores pequenos não produzem necessariamente animações rápidas.',
		auto: 'Quando ativado, determina se a animação começa automaticamente quando a cena aparece na tela e cada vez que o botão "Iniciar" é pressionado.\n\nQuando a animação está desativada, ela é iniciada apenas quando o usuário executa uma ação que inicia a animação.',
		loop: 'Quando habilitado, determina se a animação se repete indefinidamente ou quando a condição "enquanto" deixa de ser verdadeira.',
		init: 'Atribuições e chamadas para funções separadas por ponto-e-vírgula (;), de forma que tudo nesse campo seja executado no início do cálculo.',
		doExpr: 'Atribuições e chamadas para funções separadas por quebras de linha (\\ n), de forma que tudo neste campo é executado repetidamente enquanto a condição do parâmetro "enquanto" é válida.',
		whileExpr: 'Expressão booleana que determina a condição para repetir as instruções do parâmetro "fazer".',
		info: 'Comentários',
	},

	Extra: {
		expand: 'Expande o conteúdo do campo de texto.',
		simple_text_editor: 'Editor de texto simples.',
		rich_text_editor: 'Editor de texto enriquecido',
	},

  }

  return tooltip;
})(tooltip || {});