var conversionObject = {
    special: {
        "Temperatura": {
            "Kelvin": {
                toKelvin: function (e) {
                    return e;
                },
                toCelsius: function (e) {
                    return (e - 273.15);
                },
                toFahrenheit: function (e) {
                    return (e * (9 / 5) - 459.67);
                },
                toRankine: function (e) {
                    return (e * (9 / 5));
                }
            },
            "Celsius": {
                toKelvin: function (e) {
                    return (e + 273.15);
                },
                toCelsius: function (e) {
                    return e;
                },
                toFahrenheit: function (e) {
                    return (e * (9 / 5) + 32);
                },
                toRankine: function (e) {
                    return ((e + 273.15) * (9 / 5));
                }
            },
            "Fahrenheit": {
                toKelvin: function (e) {
                    return ((e + 459.67) * 5 / 9);
                },
                toCelsius: function (e) {
                    return ((e - 32) * 5 / 9);
                },
                toFahrenheit: function (e) {
                    return e;
                },
                toRankine: function (e) {
                    return (e + 459.67);
                }
            },
            "Rankine": {
                toKelvin: function (e) {
                    return (e * 5 / 9);
                },
                toCelsius: function (e) {
                    return ((e - 491.67) * 5 / 9);
                },
                toFahrenheit: function (e) {
                    return e;
                },
                toRankine: function (e) {
                    return (e * 9 / 5);
                }
            }
        }
    },
    master: {
        "Aceleración": {
            "Metro/Segundo cuadrado": "1",
            "Kilómetro/Segundo cuadrado": "0.001",
            "Milímetro/Segundo cuadrado": "1000",
            "Micrómetro/Segundo cuadrado": "1000000",
            "Nanómetro/Segundo cuadrado": "1000000000",
            "Galileo": "100",
            "Milla/Segundo cuadrado": "0.000621371",
            "Milla(naútica)/Segundo cuadrado": "0.0007150611",
            "Yarda/Segundo cuadrado": "1.093613298",
            "Pie/Segundo cuadrado": "3.280839895",
            "Pulgada/Segundo cuadrado": "39.37007874",
            "Gravedad": "0.101971621",
            "Nudos/Segundo cuadrado": "1.94384"
        },
        "Ángulo": {
            "Grado": "1",
            "Gradiente": "1.11111",
            "Mil": "17.7778",
            "Radián": Math.PI / 180,
            "Revolución": "0.00277778",
            "Arcominuto": "60",
            "Arcosegundo": "3600"
        },
        "Área": {
            "Nanómetro cuadrado": "1000000000000000000",
            "Micrómetro cuadrado": "1000000000000",
            "Milímetro cuadrado": "1000000",
            "Centímetro cuadrado": "10000",
            "Decímetro cuadrado": "100",
            "Metro cuadrado": "1",
            "Dekámetro cuadrado": "0.01",
            "Hectómetro cuadrado": "0.0001",
            "Kilómetro cuadrado": "0.000001",
            "Area": "0.01",
            "Hectárea": "0.0001",
            "Pulgada cuadrada": "1550.003100006",
            "Pie cuadrado": "10.763910417",
            "Yarda cuadrada": "1.195990046",
            "Milla cuadrada": "0.000000386",
            "Angstrom": "100000000000000000000.00",
            "Millimicron": "1000000000000000000.00",
            "Micron": "1000000000000",
            "Acre": "0.000247105",
            "Barn": "1e+28",
            "Light-Year": "1.1173e-32",
            "Astron.-Unit": "4.46837e-23",
            "Li": "1.500",
            "Fen": "0.15",
            "Mu": "0.0015",
            "Qing": "0.0149999992"
        },
		   "Carga eléctrica": {
            "Coulomb": "1",
            "Kilocoulomb": "1e-3",
            "Megacoulomb": "1e-6",
            "Abcoulomb": "0.1",
            "Nanocoulomb": "1000000000",
            "Microcoulomb": "1000000",
            "Millicoulomb": "1000",
            "Milliampere Hour": "0.277778",
            "Ampere Hour": "0.00028",
            "Faraday": "0.00001",
            "Statcoulomb": "2997924580",
            "Elementary Charge": "6.24151e+18"
        },
		 "Consumo de combustible": {
            "Millas/Litro": "1",
            "Kilómetro/Litro": "1.60934",
            "Millas/Gallón(US)": "3.78517704",
            "Millas/Gallón(UK)": "4.5463968",
            "Kilometro/Galón(US)": "6.09165188",
            "Kilómetro/Galón(UK)": "7.31671632"
        },
        "Data": {
            "Bit": "1",
            "Kilobit": "0.001",
            "Megabit": "0.000001",
            "Gigabit": "1.0e-9",
            "Terabit": "1.0e-12",
            "Petabit": "1.0e-15",
            "Exabit": "1.0e-18",
            "Zettabit": "1.0e-21",
            "Yottabit": "1.0e-24",
            "Byte": "0.125",
            "Kilobyte": "0.00012207",
            "Megabyte": "1.1920929e-7",
            "Gigabyte": "1.16415322e-10",
            "Terabyte": "1.13686838e-13",
            "Petabyte": "1.11022302e-16",
            "Exabyte": "1.08420217e-19",
            "Zettabyte": "1.05879118e-22",
            "Yottabyte": "1.03397577e-25"
        },
        "Data Transfer": {
            "Bit/Second": "1048576",
            "Bit/Minute": "62914560",
            "Bit/Hour": "3774873600",
            "Byte/Second": "131072",
            "Byte/Minute": "7864320",
            "Byte/Hour": "471859200",
            "Kilobit/Second": "1024",
            "Kilobit/Minute": "61440",
            "Kilobit/Hour": "3686400",
            "Kilobyte/Second": "128",
            "Kilobyte/Minute": "768",
            "Kilobyte/Hour": "460800",
            "Megabit/Second": "1",
            "Megabit/Minute": "60",
            "Megabit/Hour": "3600",
            "Megabyte/Second": "0.125",
            "Megabyte/Minute": "7.5",
            "Megabyte/Hour": "450",
            "Gigabit/Second": "0.000976563",
            "Gigabit/Minute": "0.05859378",
            "Gigabit/Hour": "3.5156268",
            "Gigabyte/Second": "0.00012207",
            "Gigabyte/Minute": "7.3242e-3",
            "Gigabyte/Hour": "0.439452",
            "Terabit/Second": "0.000000954",
            "Terabit/Minute": "5.724e-5",
            "Terabit/Hour": "3.4344e-3",
            "Terabyte/Second": "0.000000119",
            "Terabyte/Minute": "7.14e-6",
            "Terabyte/Hour": "4.284e-4",
            "Ethernet": "0.1048576",
            "Ethernet(fast)": "0.01048576",
            "Ethernet(Gigabit)": "0.001048576",
            "ISDN(single)": "16.384",
            "ISDN(dual)": "8.192",
            "Modem(110)": "9532.509090909",
            "Modem(300)": "3495.253333333",
            "Modem(1200)": "873.8133333333",
            "Modem(2400)": "436.9066666667",
            "Modem(9600)": "109.2266666667",
            "Modem(14.4k)": "72.8177777778",
            "Modem(28.8k)": "36.4088888889",
            "Modem(33.6k)": "31.207619048",
            "Modem(56k)": "18.724571429",
            "USB": "0.0873813333",
            "Firewire(IEEE-1394)": "0.00262144"
        },
        "Densidad": {
            "Kilogramo/Litro": "0.001",
            "Gramo/Litro": "1",
            "Milígramo/Litro": "1000",
            "Microgramo/Litro": "1000000",
            "Nanogramm/Liter": "1000000000",
            "Kilogramo/Metro cúbico": "1",
            "Gramo/Metro cúbico": "1000",
            "Kilogramo/Centímetro cúbico": "0.000001",
            "Gramo/Centímetro cúbico": "0.001",
            "Gramo/Milímetro cúbico": "0.000001",
            "Pound/Inch": "0.00003613",
            "Pound/Foot": "0.06242796",
            "Ounze/Inch": "0.00057804",
            "Ounze/Foot": "0.99884737"
        },
        "Distancia/Longitud": {
            "Nanómetro": "1e+09",
            "Micrómetro": "1e+06",
            "Milímetro": "1000",
            "Centimeter": "100",
            "Decímetro": "10",
            "Metro": "1.000",
            "Kilómetro": "0.001",
            "Picómetro": "1e+12",
            "Femtómetro": "1e+15",
            "Attommeter": "1e+18",
            "Zeptometer": "1e+21",
            "Yoctometer": "1e+24",
            "Pulgada": "39.3701",
            "Pie": "3.28084",
            "Yarda": "1.09361",
            "Milla": "0.000621371",
            "Milla(naútica)": "0.000539957",
            "Año luz": "1.057e-16",
            "Día luz": "3.860e-14",
            "Minuto luz": "5.5594e-11",
            "Segundo luz": "3.33564e-9",
            "Astron. Unit": "6.68459e-12",
            "Parsec": "3.24078e-17",
            "Chain": "0.0497097",
            "Furlong": "0.00497097",
            "Point": "2834.64",
            "Cun": "30",
            "Chi": "3",
            "Li": "3000",
            "Gongli": "6000"
        },
     
        "Energía & Trabajo": {
            "Joule": "1",
            "Kilojoule": "0.001",
            "Megajoule": "0.000001",
            "Millijoule": "1000",
            "Kilowatt Hour": "0.000000278",
            "Kilowatt Second": "0.001",
            "Watt Hour": "0.000277778",
            "Watt Second": "1",
            "Newton Meter": "1",
            "Horsepower Hour": "0.00000037",
            "Kilocalorie(int.)": "0.000238846",
            "Kilocalorie(therm.)": "0.000239006",
            "Calorie(int.)": "0.238845897",
            "Calorie(therm.)": "0.239005736",
            "Calorie(Nutrition)": "0.238845897",
            "Kilocalorie(Nutrition)": "0.000238846",
            "Hartree Energy": "2.293710449e+17",
            "Rydberg": "4.587420897e+17",
            "British Thermal Unit": "0.00094782",
            "Erg": "10000000",
            "Electron Volt": "6.24151154e+18",
            "Foot Pound": "0.73756215"
        },
        "Flow Rate": {
            "Metro/Segundo": "1",
            "Metro/Minuto": "60",
            "Metro/Hora": "3600",
            "Kilómetro/Segundo": "1e-9",
            "Kilómetro/Minuto": "6e-8",
            "Kilómetro/Hora": "0.000004",
            "Decímetro/Segundo": "1000",
            "Decímetro/Minuto": "60000",
            "Decímetro/Hora": "3600000",
            "Centímetro/Segundo": "1000000",
            "Centímetro/Minuto": "60000000",
            "Centímetro/Hora": "3600000000",
            "Milímetro/Segundo": "1000000000",
            "Milímetro/Minuto": "60000000000",
            "Milímetro/Hora": "3.6e+12",
            "Pie/Segundo": "35.314667",
            "Pie/Minuto": "2118.880003",
            "Pie/Hora": "1.271328e+5",
            "Litro/Segundo": "1000",
            "Litro/Minuto": "60000",
            "Litro/Hora": "3600000",
            "Galón(US)/Segundo": "264.172052",
            "Galón(US)/Minuto": "15850.323141",
            "Galón(US)/Hora": "9.510194e+5",
            "Galón(Imperial)/Segundo": "219.969248",
            "Galón(Imperial)/Minuto": "13198.154898",
            "Galón(Imperial)/Hora": "7.918893e+5",
            "Morgen-Foot/Second": "0.000811",
            "Morgen-Foot/Minute": "0.048643",
            "Morgen-Foot/Hour": "2.918567",
            "Scheffel(US)/Second": "28.377593",
            "Scheffel(US)/Minute": "1702.655596",
            "Scheffel(US)/Hour": "102159.33573",
            "Scheffel(UK)/Second": "27.496156",
            "Scheffel(UK)/Minute": "1649.769362",
            "Scheffel(UK)/Hour": "98986.161735",
            "Barrel(Oil)/Second": "6.289810771",
            "Barrel(Oil)/Minute": "377.38864623",
            "Barrel(Oil)/Hour": "22643.31877354"
        },
        "Fuerza": {
            "Newton": "1",
            "Kilonewton": "0.001",
            "Milinewton": "1000",
            "Dina": "100000",
            "Joule/Metro": "1",
            "Pond": "101.971621298",
            "Kilopond": "0.101971621298"
        },
       
        "Luminance": {
            "Candela/Metro": "1",
            "Kilocandela/Metro": "0.001",
            "Candela/Centímetro": "0.0001",
            "Candela/Foot": "0.09",
            "Foot Lambert": "0.29",
            "Lambert": "3.14e-4",
            "Nit": "1",
            "Stilb": "0.0001"
        },
        "Masa/Peso": {
            "Microgramo": "1000000",
            "Miligramo": "1000",
            "Gramo": "1",
            "Kilogramo": "0.001",
            "Ton(US)": "1.10231131e-6",
            "Ton(UK)": "9.84206528e-7",
            "Ounce": "3.5273962e-2",
            "Pound": "2.20462262e-3",
            "Pound(metric)": "2e-3",
            "Stone": "0.000157473",
            "Carat": "5",
            "Grain": "15.43236"
        },
        "Potencia": {
            "Watt": "1",
            "Milliwatt": "1000",
            "Kilowatt": "0.001",
            "Megawatt": "0.000001",
            "Joule/Segundo": "1",
            "Kilojoule/Segundo": "0.001",
            "Horsepower": "0.001341",
            "Horsepower(metric)": "0.0013596",
            "Horsepower(Boiler)": "0.000102",
            "Decibel Milliwatt": "30",
            "Calories/Second": "0.238846",
            "Calories/Hour": "859.8456",
            "Kilocalories/Second": "0.000238846",
            "Kilocalories/Hour": "0.8598456",
            "Foot-Pound/Second": "0.737562",
            "Foot-Pound/Hour": "2655.22",
            "Newton Meter/Second": "1",
            "Newton Meter/Hour": "3600",
            "BTU/Second": "0.000947817",
            "BTU/Minute": "0.056869",
            "BTU/Hour": "3.41214"
        },
        "Presión": {
            "Pascal": "1.0",
            "Kilopascal": "0.001",
            "Hectopascal": "0.01",
            "Millipascal": "1000",
            "Newton/Metro cuadrado": "1",
            "Bar": "0.00001",
            "Millibar": "0.01",
            "Kip/Inch": "0.000000145",
            "Pounds/Inch": "0.000145038",
            "Torr": "0.007500617",
            "Millimeter Mercury": "0.00750062",
            "Inches Mercury": "0.000295301"
        },
        "Radioactividad": {
            "Curie": "1",
            "Kilocurie": "0.001",
            "Millicurie": "1000",
            "Microcurie": "1000000",
            "Nanocurie": "1000000000",
            "Picocurie": "1e+12",
            "Becquerel": "3.7e+10",
            "Terabecquerel": "0.037",
            "Gigabecquerel": "37",
            "Megabecquerel": "37000",
            "Kilobecquerel": "37000000",
            "Milliecquerel": "3.7e+13",
            "Rutherford": "37000",
            "1/Second": "3.7e+10",
            "Disintegrations/Second": "3.7e+10",
            "Disintegrations/Minute": "2.22e+12"
        },
       
        "Temperatura": {
            "Celsius": "1",
            "Kelvin": "1",
            "Fahrenheit": "1",
            "Rankine": "1"
        },
        "Tiempo": {
            "Milisegundo": "604800000",
            "Microsegundo": "604800000000",
            "Nanosegundo": "604800000000000",
            "Segundo": "604800",
            "Minuto": "10080",
            "Hora": "168",
            "Día": "7",
            "Semana": "1",
            "Mes(31)": "0.22580645",
            "Mes(30)": "0.2333333333",
            "Mes(29)": "0.24137931",
            "Mes(28)": "0.25",
            "Año": "0.019165"
        },
        "Torque": {
            "Newton Metro": "1",
            "Newton Centimeter": "100",
            "Newton Millimeter": "1000",
            "Kilonewton Metro": "0.001",
            "Meganewton Metro": "0.000001",
            "Micronewton Metro": "1000000",
            "Millinewton Metro": "1000",
            "Pound-Force Foot": "0.73756",
            "Pound-Force Inch": "8.85075",
            "Ounce-Force Foot": "11.80097",
            "Ounce-Force Inch": "141.61165",
            "Kilogramm-Force Metro": "0.10197",
            "Gramm-Force Centimeter": "10197.2",
            "Dina Metro": "100000",
            "Dyne Centimeter": "10000000",
            "Dyne Millimeter": "100000000"
        },
		 "Velocidad": {
            "Metro/Segundo": "4.4704e-1",
            "Metro/Hora": "1.609344e+3",
            "Kilometro/Hora": "1.609344",
            "Pie/Hora": "5.28e+3",
            "Yarda/Hora": "1.76e+3",
            "Millas/Hora": "1",
            "Nudos": "8.68976242e-1",
            "Mach(SI Standard)": "1.51515152e-3",
            "Velocidad de la luz": "1.49116493e-9"
        },
        "Volumen": {
            "Barrel(Oil)": "6.28981",
            "Pie cúbico": "35.31466621",
            "Pulgada cúbica": "61023.74409473",
            "Yarda cúbica": "1.30796773",
            "Milímetro cúbico": "1000000000",
            "Centímetro cúbico": "1000000",
            "Metro cúbico": "1",
            "Fluid Ounze(US)": "33814.02220161",
            "Galón(US)": "264.17205124",
            "Litro": "1000",
            "Mililitro": "1e+6",
            "Centilitro": "100000",
            "Decilitro": "10000",
            "Hectolitro": "10",
            "Pint(UK)": "1759.75",
            "Pint(US)": "2113.38",
            "Tablespoon(US)": "67613.3",
            "Tablespoon(UK)": "66666.7",
            "Teaspoon(US)": "202840",
            "Teaspoon(UK)": "200000",
            "Cup(US)": "4226.72",
            "Cup(UK)": "3519.89"
        }
    },

    functions: {
        converter: function (context, from, to, subject) {
            context = context.toUpperCase().substring(0, 1) + context.substring(1);
            to = to.toUpperCase().substring(0, 1) + to.substring(1);
            from = from.toUpperCase().substring(0, 1) + from.substring(1);
            subject = parseInt(subject);
            var specialTest = false;
            for (var i in conversionObject.special) {
                if (i == context) {
                    specialTest = i;
                }
            }
            if (specialTest !== false) {
                if (typeof conversionObject.special[specialTest][from] !== "undefined") {
                    return conversionObject.special[specialTest][from]["to" + to](subject);
                }
                return false;
            }
            return conversionObject.master[context][to] / conversionObject.master[context][from] * subject;
        }
    }
}