/*
 * Decompiled with CFR 0.152.
 */
package com.mja.math;

public class R2 {
    public double x;
    public double y;

    public R2() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public R2(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public R2 copy() {
        return new R2(this.x, this.y);
    }

    public int ix() {
        return (int)Math.round(Math.max(Math.min(this.x, 32000.0), -32000.0));
    }

    public int iy() {
        return (int)Math.round(Math.max(Math.min(this.y, 32000.0), -32000.0));
    }

    public boolean equals(R2 r2) {
        return this.x == r2.x && this.y == r2.y;
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y;
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public double distance(R2 r2) {
        R2 r22 = this.copy();
        r22.sub(r2);
        return r22.norm();
    }

    public double dot(R2 r2) {
        return this.x * r2.x + this.y * r2.y;
    }

    public double det(R2 r2) {
        return this.x * r2.y - this.y * r2.x;
    }

    public void mul(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void div(double d) {
        this.x /= d;
        this.y /= d;
    }

    public void add(R2 r2) {
        this.x += r2.x;
        this.y += r2.y;
    }

    public void sub(R2 r2) {
        this.x -= r2.x;
        this.y -= r2.y;
    }

    public void normalize() {
        double d = this.norm();
        if (d != 0.0) {
            this.div(d);
        }
    }

    public void rotR90() {
        double d = this.x;
        this.x = this.y;
        this.y = -d;
    }

    public void rotL90() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
    }

    public void rot(double d) {
        R2 r2 = this.copy();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.x = r2.x * d2 - r2.y * d3;
        this.y = r2.x * d3 + r2.y * d2;
    }

    public void rot(int n) {
        this.rot((double)n * Math.PI / 180.0);
    }

    public static R2 intersection(R2 r2, R2 r22, R2 r23, R2 r24) {
        double d = r22.x - r2.x;
        double d2 = r23.x - r24.x;
        double d3 = r23.x - r2.x;
        double d4 = r22.y - r2.y;
        double d5 = r23.y - r24.y;
        double d6 = r23.y - r2.y;
        double d7 = d * d5 - d2 * d4;
        if (Math.abs(d7) > 1.0E-6) {
            double d8 = (d3 * d5 - d6 * d2) / d7;
            double d9 = (-d3 * d4 + d6 * d) / d7;
            if (0.0 <= d8 && d8 <= 1.0 && 0.0 <= d9 && d9 <= 1.0) {
                return new R2(r2.x + d * d8, r2.y + d4 * d8);
            }
            return null;
        }
        if ((r22.x - r23.x) * d6 != (r22.y - r23.y) * d3) {
            return null;
        }
        if (r2.x != r22.x) {
            double d10 = Math.min(r2.x, r22.x);
            double d11 = Math.max(r2.x, r22.x);
            if (d10 <= r23.x && r23.x <= d11) {
                return r23;
            }
            if (d10 <= r24.x && r24.x <= d11) {
                return r24;
            }
            return null;
        }
        if (r23.x != r24.x) {
            double d12 = Math.min(r23.x, r24.x);
            double d13 = Math.max(r23.x, r24.x);
            if (d12 <= r2.x && r2.x <= d13) {
                return r2;
            }
            if (d12 <= r22.x && r22.x <= d13) {
                return r22;
            }
            return null;
        }
        if (r2.y != r22.y) {
            double d14 = Math.min(r2.y, r22.y);
            double d15 = Math.max(r2.y, r22.y);
            if (d14 <= r23.y && r23.y <= d15) {
                return r23;
            }
            if (d14 <= r24.y && r24.y <= d15) {
                return r24;
            }
            return null;
        }
        if (r23.y != r24.y) {
            double d16 = Math.min(r23.y, r24.y);
            double d17 = Math.max(r23.y, r24.y);
            if (d16 <= r2.y && r2.y <= d17) {
                return r2;
            }
            if (d16 <= r22.y && r22.y <= d17) {
                return r22;
            }
            return null;
        }
        if (r2.x == r23.x && r2.y == r23.y) {
            return r2;
        }
        return null;
    }
}

