function PointChargeElectricPotential(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var width; // EjsS Model.Variables.Drawing Vars.width
  var height; // EjsS Model.Variables.Drawing Vars.height
  var xmin; // EjsS Model.Variables.Drawing Vars.xmin
  var xmax; // EjsS Model.Variables.Drawing Vars.xmax
  var ymin; // EjsS Model.Variables.Drawing Vars.ymin
  var ymax; // EjsS Model.Variables.Drawing Vars.ymax
  var headSize; // EjsS Model.Variables.Drawing Vars.headSize
  var upper; // EjsS Model.Variables.Drawing Vars.upper
  var msg; // EjsS Model.Variables.Drawing Vars.msg
  var msg2; // EjsS Model.Variables.Drawing Vars.msg2

  var n; // EjsS Model.Variables.Charge Vars.n
  var x; // EjsS Model.Variables.Charge Vars.x
  var y; // EjsS Model.Variables.Charge Vars.y
  var q; // EjsS Model.Variables.Charge Vars.q
  var qactive; // EjsS Model.Variables.Charge Vars.qactive
  var xactive; // EjsS Model.Variables.Charge Vars.xactive
  var yactive; // EjsS Model.Variables.Charge Vars.yactive
  var selected; // EjsS Model.Variables.Charge Vars.selected
  var active; // EjsS Model.Variables.Charge Vars.active
  var colors; // EjsS Model.Variables.Charge Vars.colors

  var nCont; // EjsS Model.Variables.Field Vars.nCont
  var xCont; // EjsS Model.Variables.Field Vars.xCont
  var yCont; // EjsS Model.Variables.Field Vars.yCont
  var cupper; // EjsS Model.Variables.Field Vars.cupper
  var nx; // EjsS Model.Variables.Field Vars.nx
  var ny; // EjsS Model.Variables.Field Vars.ny
  var xPos; // EjsS Model.Variables.Field Vars.xPos
  var yPos; // EjsS Model.Variables.Field Vars.yPos
  var t; // EjsS Model.Variables.Field Vars.t
  var dt; // EjsS Model.Variables.Field Vars.dt
  var data; // EjsS Model.Variables.Field Vars.data
  var scalarField; // EjsS Model.Variables.Field Vars.scalarField
  var cdata; // EjsS Model.Variables.Field Vars.cdata
  var contour; // EjsS Model.Variables.Field Vars.contour
  var showContours; // EjsS Model.Variables.Field Vars.showContours

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      width : width,
      height : height,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      headSize : headSize,
      upper : upper,
      msg : msg,
      msg2 : msg2,
      n : n,
      x : x,
      y : y,
      q : q,
      qactive : qactive,
      xactive : xactive,
      yactive : yactive,
      selected : selected,
      active : active,
      colors : colors,
      nCont : nCont,
      xCont : xCont,
      yCont : yCont,
      cupper : cupper,
      nx : nx,
      ny : ny,
      xPos : xPos,
      yPos : yPos,
      t : t,
      dt : dt,
      data : data,
      scalarField : scalarField,
      cdata : cdata,
      contour : contour,
      showContours : showContours
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.width != "undefined") width = json.width;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.headSize != "undefined") headSize = json.headSize;
    if(typeof json.upper != "undefined") upper = json.upper;
    if(typeof json.msg != "undefined") msg = json.msg;
    if(typeof json.msg2 != "undefined") msg2 = json.msg2;
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.q != "undefined") q = json.q;
    if(typeof json.qactive != "undefined") qactive = json.qactive;
    if(typeof json.xactive != "undefined") xactive = json.xactive;
    if(typeof json.yactive != "undefined") yactive = json.yactive;
    if(typeof json.selected != "undefined") selected = json.selected;
    if(typeof json.active != "undefined") active = json.active;
    if(typeof json.colors != "undefined") colors = json.colors;
    if(typeof json.nCont != "undefined") nCont = json.nCont;
    if(typeof json.xCont != "undefined") xCont = json.xCont;
    if(typeof json.yCont != "undefined") yCont = json.yCont;
    if(typeof json.cupper != "undefined") cupper = json.cupper;
    if(typeof json.nx != "undefined") nx = json.nx;
    if(typeof json.ny != "undefined") ny = json.ny;
    if(typeof json.xPos != "undefined") xPos = json.xPos;
    if(typeof json.yPos != "undefined") yPos = json.yPos;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.data != "undefined") data = json.data;
    if(typeof json.scalarField != "undefined") scalarField = json.scalarField;
    if(typeof json.cdata != "undefined") cdata = json.cdata;
    if(typeof json.contour != "undefined") contour = json.contour;
    if(typeof json.showContours != "undefined") showContours = json.showContours;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Vector Field"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    width = (_isMobile||_isEPub)?400:500; // EjsS Model.Variables.Drawing Vars.width
    height = (_isMobile||_isEPub)?400:500; // EjsS Model.Variables.Drawing Vars.height
    xmin = -10; // EjsS Model.Variables.Drawing Vars.xmin
    xmax = 10; // EjsS Model.Variables.Drawing Vars.xmax
    ymin = -10; // EjsS Model.Variables.Drawing Vars.ymin
    ymax = 10; // EjsS Model.Variables.Drawing Vars.ymax
    headSize = 3; // EjsS Model.Variables.Drawing Vars.headSize
    upper = 2; // EjsS Model.Variables.Drawing Vars.upper
    msg = "Arrastra la carga"; // EjsS Model.Variables.Drawing Vars.msg
    msg2 = ""; // EjsS Model.Variables.Drawing Vars.msg2
  });

  _model.addToReset(function() {
    n = 1; // EjsS Model.Variables.Charge Vars.n
    x = new Array(n); // EjsS Model.Variables.Charge Vars.x
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Charge Vars.x
        x[_i0] = 0;  // EjsS Model.Variables.Charge Vars.x
      }
    }());
    y = new Array(n); // EjsS Model.Variables.Charge Vars.y
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Charge Vars.y
        y[_i0] = 0;  // EjsS Model.Variables.Charge Vars.y
      }
    }());
    q = new Array(n); // EjsS Model.Variables.Charge Vars.q
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Charge Vars.q
        q[_i0] = 1;  // EjsS Model.Variables.Charge Vars.q
      }
    }());
    qactive = 1; // EjsS Model.Variables.Charge Vars.qactive
    xactive = 0; // EjsS Model.Variables.Charge Vars.xactive
    yactive = 0; // EjsS Model.Variables.Charge Vars.yactive
    selected = 0; // EjsS Model.Variables.Charge Vars.selected
    active = selected+1; // EjsS Model.Variables.Charge Vars.active
    colors = new Array(n); // EjsS Model.Variables.Charge Vars.colors
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Charge Vars.colors
        colors[_i0] = "red";  // EjsS Model.Variables.Charge Vars.colors
      }
    }());
  });

  _model.addToReset(function() {
    nCont = (_isMobile||_isEPub)?32:64; // EjsS Model.Variables.Field Vars.nCont
    xCont = new Array(0); // EjsS Model.Variables.Field Vars.xCont
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.xCont
        xCont[_i0] = 0;  // EjsS Model.Variables.Field Vars.xCont
      }
    }());
    yCont = new Array(0); // EjsS Model.Variables.Field Vars.yCont
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.yCont
        yCont[_i0] = 0;  // EjsS Model.Variables.Field Vars.yCont
      }
    }());
    cupper = 2; // EjsS Model.Variables.Field Vars.cupper
    nx = (_isMobile||_isEPub)?64:128; // EjsS Model.Variables.Field Vars.nx
    ny = (_isMobile||_isEPub)?64:128; // EjsS Model.Variables.Field Vars.ny
    xPos = new Array(0); // EjsS Model.Variables.Field Vars.xPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.xPos
        xPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.xPos
      }
    }());
    yPos = new Array(0); // EjsS Model.Variables.Field Vars.yPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.yPos
        yPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.yPos
      }
    }());
    t = 0; // EjsS Model.Variables.Field Vars.t
    dt = 0.1; // EjsS Model.Variables.Field Vars.dt
    data = new Array(1); // EjsS Model.Variables.Field Vars.data
    (function () {
      var _i0;
      for (_i0=0; _i0<1; _i0+=1) {  // EjsS Model.Variables.Field Vars.data
        data[_i0] = 0;  // EjsS Model.Variables.Field Vars.data
      }
    }());
    scalarField = undefined; // EjsS Model.Variables.Field Vars.scalarField
    cdata = new Array(1); // EjsS Model.Variables.Field Vars.cdata
    (function () {
      var _i0;
      for (_i0=0; _i0<1; _i0+=1) {  // EjsS Model.Variables.Field Vars.cdata
        cdata[_i0] = 0;  // EjsS Model.Variables.Field Vars.cdata
      }
    }());
    contour = undefined; // EjsS Model.Variables.Field Vars.contour
    showContours = true; // EjsS Model.Variables.Field Vars.showContours
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setFPS(10);
    _model.setStepsPerDisplay(1);
  });

  function drawField(context,element) {  // > CustomCode.Draw Scalar Field:1
    var ospCanvas = new OSPCanvas(context,element, xmin,xmax,ymin,ymax);  // > CustomCode.Draw Scalar Field:2
    scalarField.updateData(data);  // > CustomCode.Draw Scalar Field:3
    ospCanvas.addDrawable(scalarField);  // > CustomCode.Draw Scalar Field:4
    if(showContours){  // > CustomCode.Draw Scalar Field:5
      contour.updateData(cdata);  // > CustomCode.Draw Scalar Field:6
      ospCanvas.addDrawable(contour);  // > CustomCode.Draw Scalar Field:7
    }  // > CustomCode.Draw Scalar Field:8
    ospCanvas.drawObjects();  // > CustomCode.Draw Scalar Field:9
  }  // > CustomCode.Draw Scalar Field:10

  function createData() {  // > CustomCode.Create Data:1
    var newData= [];  // > CustomCode.Create Data:2
    for(var i=0; i<nx; i++) {  // > CustomCode.Create Data:3
      newData.push([]);  // > CustomCode.Create Data:4
      for (var j=0; j<ny; j++) {  // > CustomCode.Create Data:5
        var U =0;  // > CustomCode.Create Data:6
        var xi=xPos[i];  // > CustomCode.Create Data:7
        var yj=yPos[j];  // > CustomCode.Create Data:8
        for(var p=0; p<n; p++) { // loop over charges  // > CustomCode.Create Data:9
          var dx=xi-x[p];                      // grid point x-separation  // > CustomCode.Create Data:10
          var dy=yj-y[p];                      // grid point y-separation  // > CustomCode.Create Data:11
          var r=Math.sqrt(dx*dx+dy*dy);         // distance  // > CustomCode.Create Data:12
          if(r!=0) {  // > CustomCode.Create Data:13
            // check for singularity  // > CustomCode.Create Data:14
            U += q[p]/r;  // > CustomCode.Create Data:15
          } else {U=0;}  // > CustomCode.Create Data:16
        }  // > CustomCode.Create Data:17
        newData[i].push(U); //adds the z values to the data  // > CustomCode.Create Data:18
      }  // > CustomCode.Create Data:19
    }  // > CustomCode.Create Data:20
    return newData; //returns new data  // > CustomCode.Create Data:21
  }  // > CustomCode.Create Data:22
  function createContourData() {  // > CustomCode.Create Data:23
    var newData= [];  // > CustomCode.Create Data:24
    for(var i=0; i<nCont; i++) {  // > CustomCode.Create Data:25
      newData.push([]);  // > CustomCode.Create Data:26
      for (var j=0; j<nCont; j++) {  // > CustomCode.Create Data:27
        var U =0;  // > CustomCode.Create Data:28
        var xi=xCont[i];  // > CustomCode.Create Data:29
        var yj=yCont[j];  // > CustomCode.Create Data:30
        for(var p=0; p<n; p++) { // loop over charges  // > CustomCode.Create Data:31
          var dx=xi-x[p];                      // grid point x-separation  // > CustomCode.Create Data:32
          var dy=yj-y[p];                      // grid point y-separation  // > CustomCode.Create Data:33
          var r=Math.sqrt(dx*dx+dy*dy);         // distance  // > CustomCode.Create Data:34
          if(r!=0) { // check for singularity  // > CustomCode.Create Data:35
            U += q[p]/r;  // > CustomCode.Create Data:36
          } else{ U=0; }  // > CustomCode.Create Data:37
        }  // > CustomCode.Create Data:38
        U=Math.min(U,cupper);  // > CustomCode.Create Data:39
        U=Math.max(U,-cupper);  // > CustomCode.Create Data:40
        newData[i].push(U); //adds the z values to the data  // > CustomCode.Create Data:41
      }  // > CustomCode.Create Data:42
    }  // > CustomCode.Create Data:43
    return newData; //returns new data  // > CustomCode.Create Data:44
  }  // > CustomCode.Create Data:45

  function addCharge(qn) {  // > CustomCode.Actions:1
    x.push(x[selected]+1);  // > CustomCode.Actions:2
    y.push(0);  // > CustomCode.Actions:3
    q.push(qn);  // > CustomCode.Actions:4
    if(qn>0){  // > CustomCode.Actions:5
      colors.push("red");  // > CustomCode.Actions:6
    }else{  // > CustomCode.Actions:7
     colors.push("blue");  // > CustomCode.Actions:8
    }  // > CustomCode.Actions:9
    n++;  // > CustomCode.Actions:10
    selected=n-1;  // > CustomCode.Actions:11
    qactive=q[selected];  // > CustomCode.Actions:12
    xactive=x[selected];  // > CustomCode.Actions:13
    yactive=y[selected];  // > CustomCode.Actions:14
    active=n;  // > CustomCode.Actions:15
    _view._update();  // > CustomCode.Actions:16
  }  // > CustomCode.Actions:17

  function computePotential (pos) {  // > CustomCode.Compute Field:1
    var U =0;  // > CustomCode.Compute Field:2
    var xi=pos[0];  // > CustomCode.Compute Field:3
    var yj=pos[1];  // > CustomCode.Compute Field:4
    for(var p=0; p<n; p++) {  // > CustomCode.Compute Field:5
      // loop over charges  // > CustomCode.Compute Field:6
      var dx=xi-x[p];                      // grid point x-separation  // > CustomCode.Compute Field:7
      var dy=yj-y[p];                      // grid point y-separation  // > CustomCode.Compute Field:8
      var r=Math.sqrt(dx*dx+dy*dy);         // distance   // > CustomCode.Compute Field:9
      if(r!=0) {                            // check for singularity  // > CustomCode.Compute Field:10
        U += q[p]/r;                // > CustomCode.Compute Field:11
      } // end of if statement  // > CustomCode.Compute Field:12
    }  // > CustomCode.Compute Field:13
    msg2="U ="+U.toFixed(4);  // > CustomCode.Compute Field:14
  }  // > CustomCode.Compute Field:15

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Vector Field"]) return;
    _view.custom.setFunction(drawField);  // > Initialization.Init Vector Field:1
    _view._update();  // updates the function Field and draws the wave function   // > Initialization.Init Vector Field:2
    // data for scalar field plot  // > Initialization.Init Vector Field:3
    xPos= arrayCoordinates(xmin, xmax, nx); // returns array(nx);  // > Initialization.Init Vector Field:4
    yPos= arrayCoordinates(ymin, ymax, ny); // returns array(nx);  // > Initialization.Init Vector Field:5
    data=createData();  // creates component arrays  // > Initialization.Init Vector Field:6
    scalarField = new ScalarField(data, xmin,xmax,nx,ymin,ymax,ny,false, -upper,upper);  // > Initialization.Init Vector Field:7
    scalarField.setThreshold(-upper,upper, 4);  // expand the low level color scale  // > Initialization.Init Vector Field:8
    // data for contour plot  // > Initialization.Init Vector Field:9
    // data for scalar field plot  // > Initialization.Init Vector Field:10
    xCont= arrayCoordinates(xmin, xmax, nCont); // returns array(nx);  // > Initialization.Init Vector Field:11
    yCont= arrayCoordinates(ymin, ymax, nCont); // returns array(nx);  // > Initialization.Init Vector Field:12
    cdata= createContourData();  // > Initialization.Init Vector Field:13
    contour = new Contour(cdata, xmin,xmax,nCont,ymin,ymax,nCont,false, -cupper,cupper, 16, "#FFFFFF");  // > Initialization.Init Vector Field:14
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    data = createData();  // > FixedRelations.FixRel Page:1
    cdata= createContourData();  // > FixedRelations.FixRel Page:2
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new PointChargeElectricPotential_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.upperPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'upperPanel'
          _view.xminField.linkProperty("Value",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'Value' for element 'xminField'
          _view.xminField.linkProperty("Editable",  function() { return _isPaused; } ); // HtmlView Page linking property 'Editable' for element 'xminField'
          _view.xminField.setAction("OnChange", function() {
  _initialize();

}); // HtmlView Page setting action 'OnChange' for element 'xminField'
          _view.xmaxField.linkProperty("Value",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'Value' for element 'xmaxField'
          _view.xmaxField.linkProperty("Editable",  function() { return _isPaused; } ); // HtmlView Page linking property 'Editable' for element 'xmaxField'
          _view.xmaxField.setAction("OnChange", function() {
  _initialize();

}); // HtmlView Page setting action 'OnChange' for element 'xmaxField'
          _view.yminField.linkProperty("Value",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'Value' for element 'yminField'
          _view.yminField.linkProperty("Editable",  function() { return _isPaused; } ); // HtmlView Page linking property 'Editable' for element 'yminField'
          _view.yminField.setAction("OnChange", function() {
  _initialize();

}); // HtmlView Page setting action 'OnChange' for element 'yminField'
          _view.ymaxField.linkProperty("Value",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'Value' for element 'ymaxField'
          _view.ymaxField.linkProperty("Editable",  function() { return _isPaused; } ); // HtmlView Page linking property 'Editable' for element 'ymaxField'
          _view.ymaxField.setAction("OnChange", function() {
  _initialize();

}); // HtmlView Page setting action 'OnChange' for element 'ymaxField'
          _view.plottingPanel.linkProperty("Height",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnRelease", function() {
  msg2="";

}); // HtmlView Page setting action 'OnRelease' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnPress", computePotential); // HtmlView Page setting action 'OnPress' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TLMessage",  function() { return msg; }, function(_v) { msg = _v; } ); // HtmlView Page linking property 'TLMessage' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnDrag", computePotential); // HtmlView Page setting action 'OnDrag' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumX",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumX",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'MinimumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumY",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'MinimumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("BLMessage",  function() { return msg2; }, function(_v) { msg2 = _v; } ); // HtmlView Page linking property 'BLMessage' for element 'plottingPanel'
          _view.custom.linkProperty("SizeX",  function() { return xmax-xmin; } ); // HtmlView Page linking property 'SizeX' for element 'custom'
          _view.custom.linkProperty("X",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'X' for element 'custom'
          _view.custom.linkProperty("Y",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'Y' for element 'custom'
          _view.custom.linkProperty("SizeY",  function() { return ymax-ymin; } ); // HtmlView Page linking property 'SizeY' for element 'custom'
          _view.chargeSet.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'chargeSet'
          _view.chargeSet.linkProperty("FillColor",  function() { return colors; }, function(_v) { colors = _v; } ); // HtmlView Page linking property 'FillColor' for element 'chargeSet'
          _view.chargeSet.setAction("OnDrag", function() {
  active=selected+1;
  xactive=x[selected];
  yactive=y[selected];
  msg=""
  createData ();

}); // HtmlView Page setting action 'OnDrag' for element 'chargeSet'
          _view.chargeSet.linkProperty("ElementInteracted",  function() { return selected; }, function(_v) { selected = _v; } ); // HtmlView Page linking property 'ElementInteracted' for element 'chargeSet'
          _view.chargeSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'chargeSet'
          _view.chargeSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'chargeSet'
          _view.chargeSet.setAction("OnPress", function() {
  active=selected+1;
  xactive=x[selected];
  yactive=y[selected];
  qactive=q[selected];

}); // HtmlView Page setting action 'OnPress' for element 'chargeSet'
          _view.controlPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'controlPanel'
          _view.nField.linkProperty("Value",  function() { return nx; }, function(_v) { nx = _v; } ); // HtmlView Page linking property 'Value' for element 'nField'
          _view.nField.setAction("OnChange", function() {
  nx =Math.max(nx,8);
  nx =Math.min(nx,256);
  ny=nx;
  nCont=Math.round(nx/2);
  _initialize();

}); // HtmlView Page setting action 'OnChange' for element 'nField'
          _view.activeField.linkProperty("Value",  function() { return active; }, function(_v) { active = _v; } ); // HtmlView Page linking property 'Value' for element 'activeField'
          _view.activeField.setAction("OnChange", function() {
  active =Math.max(active,1);
  active =Math.min(active,n);
  selected=active-1;
  qactive=q[selected];
  xactive=x[selected];
  yactive=y[selected];

}); // HtmlView Page setting action 'OnChange' for element 'activeField'
          _view.qField.linkProperty("Value",  function() { return qactive; }, function(_v) { qactive = _v; } ); // HtmlView Page linking property 'Value' for element 'qField'
          _view.qField.setAction("OnChange", function() {
  q[selected]=qactive;
  if(qactive>0) {
    colors[selected]="red";
  } else {
    colors[selected]="blue";
  }

}); // HtmlView Page setting action 'OnChange' for element 'qField'
          _view.xiField.linkProperty("Value",  function() { return xactive; }, function(_v) { xactive = _v; } ); // HtmlView Page linking property 'Value' for element 'xiField'
          _view.xiField.setAction("OnChange", function() {
  x[selected]=xactive;

}); // HtmlView Page setting action 'OnChange' for element 'xiField'
          _view.yiField.linkProperty("Value",  function() { return yactive; }, function(_v) { yactive = _v; } ); // HtmlView Page linking property 'Value' for element 'yiField'
          _view.yiField.setAction("OnChange", function() {
  y[selected]=yactive;

}); // HtmlView Page setting action 'OnChange' for element 'yiField'
          _view.showFieldCheck.linkProperty("Checked",  function() { return showContours; }, function(_v) { showContours = _v; } ); // HtmlView Page linking property 'Checked' for element 'showFieldCheck'
          _view.addPosButton.setAction("OnPress", function() {
  addCharge(+1);

}); // HtmlView Page setting action 'OnPress' for element 'addPosButton'
          _view.addNegButton.setAction("OnPress", function() {
  addCharge(-1);

}); // HtmlView Page setting action 'OnPress' for element 'addNegButton'
          _view.resetButton.setAction("OnClick", function() {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(10);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function PointChargeElectricPotential_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = PointChargeElectricPotential_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function PointChargeElectricPotential_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.wrappedPanel,"wrappedPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'wrappedPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"titlePanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'titlePanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"titleLabel", _view.titlePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'titleLabel'
 
    _view._addElement(EJSS_INTERFACE.panel,"upperPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'upperPanel'
      .setProperty("CSS",{ "display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'upperPanel'
      .setProperty("Background","rgba(240,240,240,255)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'upperPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'upperPanel'
      .setProperty("BorderColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'upperPanel'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'upperPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"ioPanel", _view.upperPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'ioPanel'
      .setProperty("CSS",{"display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'ioPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"xPanel", _view.ioPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'xPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"xminLabel", _view.xPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xminLabel'
      .setProperty("Text","x min =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'xminLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"xminField", _view.xPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xminField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'xminField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'xminField'
      .setProperty("Tooltip","minimum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'xminField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"xmaxLabel", _view.xPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xmaxLabel'
      .setProperty("Text","x max =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'xmaxLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"xmaxField", _view.xPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xmaxField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'xmaxField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'xmaxField'
      .setProperty("Tooltip","maximum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'xmaxField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"yPanel", _view.ioPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'yPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"yminLabel", _view.yPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yminLabel'
      .setProperty("Text","y min =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'yminLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"yminField", _view.yPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yminField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'yminField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'yminField'
      .setProperty("Tooltip","minimum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'yminField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"ymaxLabel", _view.yPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'ymaxLabel'
      .setProperty("Text","y max =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'ymaxLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"ymaxField", _view.yPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'ymaxField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'ymaxField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'ymaxField'
      .setProperty("Tooltip","maximum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'ymaxField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'mainPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.mainPanel,"GRAPHICS2D_CANVAS") // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("ShowAreaRectangle",false) // EJsS HtmlView.HtmlView Page: setting property 'ShowAreaRectangle' for element 'plottingPanel'
      .setProperty("ShowCoordinates",false) // EJsS HtmlView.HtmlView Page: setting property 'ShowCoordinates' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("XTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("GraphicsMode","Canvas") // EJsS HtmlView.HtmlView Page: setting property 'GraphicsMode' for element 'plottingPanel'
      .setProperty("GridXShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridXShow' for element 'plottingPanel'
      .setProperty("Background","White") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("Title","Potencial Eléctrico") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("SquareAspect",false) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'plottingPanel'
      .setProperty("GridYShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridYShow' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.custom,"custom", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'custom'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'custom'
      .setProperty("RelativePosition","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'custom'
      .setProperty("LineColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'custom'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'custom'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"chargeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'chargeSet'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'chargeSet'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'chargeSet'
      .setProperty("Sensitivity",15) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'chargeSet'
      .setProperty("SizeX",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'chargeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'chargeSet'
      .setProperty("SizeY",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'chargeSet'
      .setProperty("EnabledPosition","ENABLED_ANY") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'chargeSet'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      .setProperty("CSS",{ "display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'controlPanel'
      .setProperty("Background","rgba(240,240,240,255)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'controlPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'controlPanel'
      .setProperty("BorderColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'controlPanel'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"chargePanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'chargePanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'chargePanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"nPanel", _view.chargePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'nPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nLabel", _view.nPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nLabel'
      .setProperty("Text"," grid n =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nField", _view.nPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nField'
      .setProperty("Width",25) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"activePanel", _view.chargePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'activePanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'activePanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"activeLabel", _view.activePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'activeLabel'
      .setProperty("Text"," i =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'activeLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"activeField", _view.activePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'activeField'
      .setProperty("Width",20) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'activeField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'activeField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"qPanel", _view.chargePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'qPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'qPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"qLabel", _view.qPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'qLabel'
      .setProperty("Text"," q<sub>i</sub> =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'qLabel'
      .setProperty("Font","normal bold 12px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'qLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"qField", _view.qPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'qField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'qField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'qField'
      .setProperty("Tooltip","minimum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'qField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"xiPanel", _view.chargePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xiPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'xiPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"xiLabel", _view.xiPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xiLabel'
      .setProperty("Text"," x<sub>i</sub> =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'xiLabel'
      .setProperty("Font","normal bold 12px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'xiLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"xiField", _view.xiPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'xiField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'xiField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'xiField'
      .setProperty("Tooltip","minimum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'xiField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"yiPanel", _view.chargePanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yiPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'yiPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"yiLabel", _view.yiPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yiLabel'
      .setProperty("Text"," y<sub>i</sub> =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'yiLabel'
      .setProperty("Font","normal bold 12px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'yiLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"yiField", _view.yiPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yiField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'yiField'
      .setProperty("Format","0.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'yiField'
      .setProperty("Tooltip","minimum x") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'yiField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"buttonPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonPanel'
      .setProperty("CSS",{"display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'buttonPanel'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"showFieldCheck", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'showFieldCheck'
      .setProperty("Text","Mostrar contornos") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'showFieldCheck'
      ;

    _view._addElement(EJSS_INTERFACE.button,"addPosButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'addPosButton'
      .setProperty("Tooltip","Adds a ositive charge") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'addPosButton'
      .setProperty("Text","Añade +") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'addPosButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"addNegButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'addNegButton'
      .setProperty("Tooltip","Adds a negative charge") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'addNegButton'
      .setProperty("Text","Añade -") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'addNegButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

 

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new PointChargeElectricPotential("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined") _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
