RadiusOfBoards = new Array();

PuckPosX = new Array();

PuckPosY = new Array();

PuckHitWallX = new Array();

BoardAngle = new Array();

HitBoards = new Array();

PosCollisionSpeedX = new Array();

PosCollisionSpeedY = new Array();

StartPuckY = new Array();

ReboundAngle = new Array();




/* called by onLoad */

function initialize(){
	Running = "no";
	FirstRun = "yes";
	
	XPosBoards = 915;
	YPosBoards = 300;
	SmallestRadius = 400;
	ThicknessBoards = 10;
	boardnumber = 3;
	StartPuckX = 50;
	RadiusPuck = 3;
	elapsedtime = 0;
	AubsX = 50;
	AubsY = 35;
	PuckSpeed = 20;
	
	ShowRuler = "no";
	
	RulerMessage = "Show Ruler";
	
	// 40 pix = 1 m;
	WorldScale = 40;
	
	
	mirror = "Ideal";
	
	
	
	for (i = 0; i < 8; i++){
		RadiusOfBoards[i] = SmallestRadius + Math.floor(Math.random()*40) + 60*i;
	}
	
	
	CalculateParameters();
	
/* Initial Conditions */	
	
//  Sets up the canvas for live action.

	theCanvas = document.getElementById("CanvasOne");
	ctx = theCanvas.getContext("2d");	
}


/* Called by the Begin Button */

function LoadIt(){
	document.getElementById("LabSection").style.visibility = "visible";
	document.getElementById("OverviewSection").style.visibility = "hidden";
	StartItMoving = setInterval(drawingpart, 20);
}

function CalculateParameters(){
	
	RadiusBoards = RadiusOfBoards[boardnumber];
	
	IdealFocalPointX = XPosBoards-0.5*RadiusBoards;
	
	YPuckSeparation = 75;
	
	Start1stPuckY = YPosBoards - 3.0*YPuckSeparation;
	
	elapsedtime = 0;
	
	for (i = 0; i < 7; i++){
		
		
		PuckPosX[i] = StartPuckX;
		StartPuckY[i] = Start1stPuckY + YPuckSeparation*i;
		PuckPosY[i] = StartPuckY[i];
		
		HitBoards[i] = 0;
		BoardAngle[i] = Math.asin((PuckPosY[i]-YPosBoards)/(RadiusBoards-8));
		PuckHitWallX[i] = XPosBoards-RadiusBoards + (RadiusBoards-8)*Math.cos(BoardAngle[i]);
		
		if (mirror == "Real"){
			PosCollisionSpeedX[i] = -PuckSpeed*Math.cos(2*BoardAngle[i]);
			PosCollisionSpeedY[i] = -PuckSpeed*Math.sin(2*BoardAngle[i]);
		}
		else{
			ReboundAngle[i] = Math.atan((PuckPosY[i]-YPosBoards)/(IdealFocalPointX - PuckHitWallX[i]));
			PosCollisionSpeedX[i] = -PuckSpeed*Math.cos(ReboundAngle[i]);
			PosCollisionSpeedY[i] = PuckSpeed*Math.sin(ReboundAngle[i]);
		}	
		
	}
	
	MirrorMessageText = "Mirror is " + mirror;
	PrevioiusPuckToWorkWith = -1.0;
	AubsY = 35;
}



function drawingpart(){
			
/* 	background drawing */

	ctx.fillStyle="#dbfaf9";
	ctx.fillRect(0,0,925,600);
	
	elapsedtime = elapsedtime + 0.050;
	
	PuckToWorkWith = Math.floor(elapsedtime/5);
	
	if (HitBoards[PuckToWorkWith] == 0){
		PuckPosX[PuckToWorkWith] = PuckPosX[PuckToWorkWith] + PuckSpeed;
	}
	if ((HitBoards[PuckToWorkWith] == 0) && (PuckHitWallX[PuckToWorkWith] < PuckPosX[PuckToWorkWith])){
		PuckPosX[PuckToWorkWith] = PuckHitWallX[PuckToWorkWith];
		HitBoards[PuckToWorkWith] = 1;
	}
	if (HitBoards[PuckToWorkWith] == 1){
		PuckPosX[PuckToWorkWith] = PuckPosX[PuckToWorkWith] + PosCollisionSpeedX[PuckToWorkWith];
		PuckPosY[PuckToWorkWith] = PuckPosY[PuckToWorkWith] + PosCollisionSpeedY[PuckToWorkWith];
	}
	AubsY = AubsY + 0.76;
	if (AubsY > 510){
		AubsY = 510;
	}
	
	DrawPrincipleAxis();
	DrawBoards();
	DrawPucks();
	RulerControlArea();
	MirrorControlArea();
	if (PuckToWorkWith != PrevioiusPuckToWorkWith){
		DrawAubs(AubsX,AubsY,30,1);
		PrevioiusPuckToWorkWith = PuckToWorkWith;
	}
	else{
		DrawAubs(AubsX,AubsY,30,0);
	}
	
	
	WriteText(450,30,MirrorMessageText,18,"#990000",0.5);
	
	FirstRun = "no";
	if (ShowRuler == "yes"){
		DrawRuler();
	}
	
}

function DrawAubs(x,y,w,s){
	
	if (s == 0){
		endshot = -0.3*w;
	}
	else{
		endshot = 0.3*w;
	}
	
	h = w;
	//Stick
	ctx.strokeStyle = "#9b5305";
	ctx.lineWidth = 3.0;
	ctx.beginPath();
	ctx.moveTo(x, y+h);
	ctx.lineTo(x+endshot, y+h);
	ctx.lineTo(x+endshot, y+1.5*h);
	ctx.stroke();
	
	
	//Pants
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#000000";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.moveTo(x-0.5*w, y-0.2*h);
	ctx.bezierCurveTo(x-0.5*w, y-0.2*h-4, x+0.5*w, y-0.2*h-4, x+0.5*w, y-0.2*h);
	ctx.bezierCurveTo(x+0.5*w+2, y-0.2*h, x+0.5*w+2, y+0.1*h, x+0.5*w, y+0.1*h);
	ctx.lineTo(x-0.5*w, y+0.1*h);
	ctx.bezierCurveTo(x-0.5*w-2, y+0.1*h, x-0.5*w-2, y-0.2*h, x-0.5*w, y-0.2*h);
	ctx.stroke();
	ctx.fill();
	
	
	//Trunk
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#ff8908";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.moveTo(x-0.5*w, y);
	ctx.bezierCurveTo(x-0.5*w, y-4, x+0.5*w, y-4, x+0.5*w, y);
	ctx.bezierCurveTo(x+0.5*w-2, y, x+0.5*w-2, y+1.0*h, x+0.5*w, y+h);
	ctx.lineTo(x-0.5*w, y+h);
	ctx.bezierCurveTo(x-0.5*w+2, y+h, x-0.5*w+2, y, x-0.5*w, y);
	ctx.stroke();
	ctx.fill();
	
	ctx.save();
	ctx.translate(x,y+0.5*h);
	ctx.rotate(Math.PI);
	WriteText(0,0.30*h,"6",12,"#FFFFFF",0.5);
	WriteText(0,-0.1*h,"Weyhmirror",4,"#FFFFFF",0.5);
	ctx.restore();
	
	
	//Head
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#000000";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.arc(x,y+h,0.25*w,0, 2*Math.PI);
	ctx.stroke();
	ctx.fill();
	
}


function RulerControlArea(){
	DrawRectangle(-10, 570, 210, 55, 10, "#990000", "#FFFFFF", 5);
	WriteText(100,590,RulerMessage,18,"#990000",0.5);
}

function MirrorControlArea(){
	DrawRectangle(205, 570, 210, 55, 10, "#990000", "#FFFFFF", 5);
	WriteText(305,590,"Change Curvature",18,"#990000",0.5);
}

function DrawRuler(){
	ctx.fillStyle = "#FFFFFF";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.strokeRect(10, 303, 920, 75);
	ctx.globalAlpha = 0.8;
	ctx.fillRect(10, 303, 920, 75);
	ctx.globalAlpha = 1.0;
	
	ctx.beginPath();
	for (i = 0; i < 45; i++){
		if (i%2 == 0){
			endy = 340;
		}
		else{
			endy = 320;
		}
		ctx.moveTo(XPosBoards-6 - i*0.5*WorldScale, 303);
		ctx.lineTo(XPosBoards-6 - i*0.5*WorldScale, endy);
		
		if (i%4 == 0){
			numb = Math.floor(i/2);
			WriteText(XPosBoards-6 - i*0.5*WorldScale,360,numb,18,"#000000",0.5);
		}
	}
	ctx.stroke();
	WriteText(XPosBoards+0 - 43*0.5*WorldScale,360,"m",18,"#000000",0.5);
}

function DrawPucks(){
	for (i=0; i < 7; i++){
		if (HitBoards[i] == 0){
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(StartPuckX, PuckPosY[i]);
			ctx.lineTo(PuckPosX[i], PuckPosY[i]);
			ctx.stroke();
		}
		if (HitBoards[i] == 1){
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(StartPuckX, StartPuckY[i]);
			ctx.lineTo(PuckHitWallX[i], StartPuckY[i]);
			ctx.stroke();
			
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(PuckHitWallX[i], StartPuckY[i]);
			ctx.lineTo(PuckPosX[i], PuckPosY[i]);
			ctx.stroke();
		}
		
		
		ctx.fillStyle = "#333333";
		ctx.strokeStyle = "#000000";
		ctx.lineWidth = 1;
		ctx.beginPath();
		ctx.arc(PuckPosX[i], PuckPosY[i], RadiusPuck, 0.0*Math.PI, 2.0*Math.PI);
		ctx.stroke();
		ctx.fill();
	}
}


function DrawPrincipleAxis(){
	StartX = 0;
	StartY = 300;
	NumberOfSmallLines = 30;
	SizeX = 930/NumberOfSmallLines;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 3;
	ctx.beginPath();
	for (i = 0; i < NumberOfSmallLines; i++){
		ctx.moveTo(StartX+i*SizeX, StartY);
		ctx.lineTo(StartX+(i + 0.5)*SizeX, StartY);
	}
	ctx.stroke();
}



function DrawBoards(){
	
	//Area to left of the boards
	
	ctx.fillStyle = "#2d0503";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.arc(XPosBoards-RadiusBoards, YPosBoards, RadiusBoards, 5.0*Math.PI/3, 1.0*Math.PI/3);
	ctx.lineTo(930, 620);
	ctx.lineTo(930, -10);
	ctx.closePath();
	ctx.stroke();
	ctx.fill();
	
	//Actual Boards
	
	ctx.fillStyle = "#990000";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.arc(XPosBoards-RadiusBoards, YPosBoards, RadiusBoards, 5.0*Math.PI/3, 1.0*Math.PI/3);
	ctx.arc(XPosBoards-RadiusBoards, YPosBoards, RadiusBoards + ThicknessBoards, 1.0*Math.PI/3, 5.0*Math.PI/3, true);
	ctx.stroke();
	ctx.fill();
	ctx.lineWidth = 8;
	ctx.strokeStyle = "#FFFFFF";
	ctx.beginPath();
	ctx.arc(XPosBoards-RadiusBoards, YPosBoards, RadiusBoards, 5.0*Math.PI/3, 1.0*Math.PI/3);
	ctx.stroke();
	ctx.strokeStyle = "#FFFF00";
	ctx.beginPath();
	ctx.lineWidth = 2;
	ctx.arc(XPosBoards-RadiusBoards, YPosBoards, RadiusBoards - 5, 5.0*Math.PI/3, 1.0*Math.PI/3);
	ctx.stroke();
	
	WriteText(XPosBoards-RadiusBoards, YPosBoards+7,"X",16,"#000099",0.5);
	
	
	
}

function ChangeRealism(){
	if (mirror == "Real"){
		mirror = "Ideal";
	}
	else{
		mirror = "Real";
	}
	CalculateParameters();
}

function ChangeRuler(){
	if (ShowRuler == "yes"){
		ShowRuler = "no";
		RulerMessage = "Show Ruler";
	}
	else{
		ShowRuler = "yes";
		RulerMessage = "Hide Ruler";
	}
}

function ChangeCurvature(){
	boardnumber++;
	if (boardnumber > 7){
		boardnumber = 0;
	}
	CalculateParameters();
}

function WriteText(x,y,t,s,c,m){
	ctx.fillStyle = c;
	ctx.font= s + "px Arial";
	temptext = t;
	metrics = ctx.measureText(temptext);
	textWidth = metrics.width;
	xposition = x - m*textWidth;
	ctx.fillText(temptext,xposition, y);
}

function DrawArrow(x, y, h, w, c, r){
	ctx.save();
	ctx.translate(x, y+0.5*h);
	ctx.rotate(r);
	ctx.fillStyle = c;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(0,-0.5*h);
	ctx.lineTo(0+w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+w);
	ctx.lineTo(0-w, -0.5*h+w);
	ctx.lineTo(0,-0.5*h);
	ctx.stroke();
	ctx.closePath();
	ctx.fill();
	ctx.restore();
}




function DrawRectangle(xrect, yrect, wrect, hrect, curverectangle, lcolor, fcolor, lwid){
	ctx.fillStyle = fcolor;
	ctx.strokeStyle = lcolor;
	ctx.lineWidth = lwid;
	ctx.beginPath();
	ctx.moveTo(xrect+curverectangle, yrect);
	ctx.lineTo(xrect+wrect-curverectangle, yrect);
	ctx.arc(xrect+wrect-curverectangle, yrect+curverectangle, curverectangle, 1.5*Math.PI, 0*Math.PI, false);
	ctx.lineTo(xrect+wrect, yrect+hrect-curverectangle);
	ctx.arc(xrect+wrect-curverectangle, yrect+hrect-curverectangle, curverectangle, 0.0*Math.PI, 0.5*Math.PI, false);
	ctx.lineTo(xrect+curverectangle, yrect+hrect);
	ctx.arc(xrect+curverectangle, yrect+hrect-curverectangle, curverectangle, 0.5*Math.PI, 1.0*Math.PI, false);
	ctx.lineTo(xrect, yrect+curverectangle);
	ctx.arc(xrect+curverectangle, yrect+curverectangle, curverectangle, 1.0*Math.PI, 1.5*Math.PI, false);
	ctx.stroke();
	ctx.fill();
}

