PuckPosX = new Array();

PuckPosY = new Array();

PuckHitWallX = new Array();

BoardAngle = new Array();

HitBoards = new Array();

PosCollisionSpeedX = new Array();

PosCollisionSpeedY = new Array();

StartPuckY = new Array();

ReboundAngle = new Array();

EndFakeLineX = new Array();



/* called by onLoad */

function initialize(){
	Running = "no";
	FirstRun = "yes";
	
	XPosBoards = 600;
	YPosBoards = 300;
	ThicknessBoards = 10;
	boardnumber = 0;
	StartPuckX = 50;
	RadiusPuck = 3;
	elapsedtime = 0;
	AubsX = 50;
	AubsY = 35;
	PuckSpeed = 15;
	
	ShowProtractor = "no";
	
	ProtractorMessage = "Mostrar transportador";
	
	// 40 pix = 1 m;
	WorldScale = 40;
	
	BoardAngle[0] = 0;
	
	for (i = 1; i < 8; i++){
		AnginDegrees = 0 + (Math.floor(Math.random()*35) + 50*i)/10;
		BoardAngle[i] = AnginDegrees*Math.PI/180;
	}
	
	CalculateParameters();
	
/* Initial Conditions */	
	
//  Sets up the canvas for live action.

	theCanvas = document.getElementById("CanvasOne");
	ctx = theCanvas.getContext("2d");	
}


/* Called by the Begin Button */

function LoadIt(){
	document.getElementById("LabSection").style.visibility = "visible";
	document.getElementById("OverviewSection").style.visibility = "hidden";
	StartItMoving = setInterval(drawingpart, 20);
}

function CalculateParameters(){
	
	YPuckSeparation = 75;
	
	Start1stPuckY = YPosBoards - 3.0*YPuckSeparation;
	
	elapsedtime = 0;
	
	for (i = 0; i < 7; i++){
		
		
		PuckPosX[i] = StartPuckX;
		StartPuckY[i] = Start1stPuckY + YPuckSeparation*i;
		PuckPosY[i] = StartPuckY[i];
		
		HitBoards[i] = 0;
		PuckHitWallX[i] = XPosBoards - (PuckPosY[i]-YPosBoards)/Math.tan(Math.PI/2 - BoardAngle[boardnumber]);
		
		PosCollisionSpeedX[i] = -PuckSpeed*Math.cos(2*BoardAngle[boardnumber]);
		PosCollisionSpeedY[i] = -PuckSpeed*Math.sin(2*BoardAngle[boardnumber]);
		
	}
	
	PrevioiusPuckToWorkWith = -1.0;
	AubsY = 35;
}



function drawingpart(){
			
/* 	background drawing */

	ctx.fillStyle="#dbfaf9";
	ctx.fillRect(0,0,925,600);
	
	elapsedtime = elapsedtime + 0.050;
	
	PuckToWorkWith = Math.floor(elapsedtime/5);
	
	if (HitBoards[PuckToWorkWith] == 0){
		PuckPosX[PuckToWorkWith] = PuckPosX[PuckToWorkWith] + PuckSpeed;
	}
	if ((HitBoards[PuckToWorkWith] == 0) && (PuckHitWallX[PuckToWorkWith] < PuckPosX[PuckToWorkWith])){
		PuckPosX[PuckToWorkWith] = PuckHitWallX[PuckToWorkWith];
		HitBoards[PuckToWorkWith] = 1;
	}
	if (HitBoards[PuckToWorkWith] == 1){
		PuckPosX[PuckToWorkWith] = PuckPosX[PuckToWorkWith] + PosCollisionSpeedX[PuckToWorkWith];
		PuckPosY[PuckToWorkWith] = PuckPosY[PuckToWorkWith] + PosCollisionSpeedY[PuckToWorkWith];
	}
	AubsY = AubsY + 0.76;
	if (AubsY > 510){
		AubsY = 510;
	}
		
	DrawBoards();
	DrawPucks();
	ProtractorControlArea();
	MirrorControlArea();
	
	
	if (PuckToWorkWith != PrevioiusPuckToWorkWith){
		DrawAubs(AubsX,AubsY,30,1);
		PrevioiusPuckToWorkWith = PuckToWorkWith;
	}
	else{
		DrawAubs(AubsX,AubsY,30,0);
	}
	
	if (ShowProtractor == "yes"){
		DrawProtractor();
	}
	
}

function DrawAubs(x,y,w,s){
	
	if (s == 0){
		endshot = -0.3*w;
	}
	else{
		endshot = 0.3*w;
	}
	
	h = w;
	//Stick
	ctx.strokeStyle = "#9b5305";
	ctx.lineWidth = 3.0;
	ctx.beginPath();
	ctx.moveTo(x, y+h);
	ctx.lineTo(x+endshot, y+h);
	ctx.lineTo(x+endshot, y+1.5*h);
	ctx.stroke();
	
	
	//Pants
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#000000";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.moveTo(x-0.5*w, y-0.2*h);
	ctx.bezierCurveTo(x-0.5*w, y-0.2*h-4, x+0.5*w, y-0.2*h-4, x+0.5*w, y-0.2*h);
	ctx.bezierCurveTo(x+0.5*w+2, y-0.2*h, x+0.5*w+2, y+0.1*h, x+0.5*w, y+0.1*h);
	ctx.lineTo(x-0.5*w, y+0.1*h);
	ctx.bezierCurveTo(x-0.5*w-2, y+0.1*h, x-0.5*w-2, y-0.2*h, x-0.5*w, y-0.2*h);
	ctx.stroke();
	ctx.fill();
	
	
	//Trunk
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#ff8908";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.moveTo(x-0.5*w, y);
	ctx.bezierCurveTo(x-0.5*w, y-4, x+0.5*w, y-4, x+0.5*w, y);
	ctx.bezierCurveTo(x+0.5*w-2, y, x+0.5*w-2, y+1.0*h, x+0.5*w, y+h);
	ctx.lineTo(x-0.5*w, y+h);
	ctx.bezierCurveTo(x-0.5*w+2, y+h, x-0.5*w+2, y, x-0.5*w, y);
	ctx.stroke();
	ctx.fill();
	
	ctx.save();
	ctx.translate(x,y+0.5*h);
	ctx.rotate(Math.PI);
	WriteText(0,0.30*h,"6",12,"#FFFFFF",0.5);
	WriteText(0,-0.1*h,"Weyhmirror",4,"#FFFFFF",0.5);
	ctx.restore();
	
	
	//Head
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#000000";
	ctx.lineWidth = 1.0;
	ctx.beginPath();
	ctx.arc(x,y+h,0.25*w,0, 2*Math.PI);
	ctx.stroke();
	ctx.fill();
	
}


function ProtractorControlArea(){
	DrawRectangle(500, 570, 210, 55, 10, "#990000", "#FFFFFF", 5);
	WriteText(600,590,ProtractorMessage,18,"#990000",0.5);
}

function MirrorControlArea(){
	DrawRectangle(720, 570, 200, 55, 10, "#990000", "#FFFFFF", 5);
	WriteText(820,590,"Cambiar Ángulo",18,"#990000",0.5);
}

function DrawProtractor(){
	ctx.fillStyle = "#FFFFFF";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1.0;
	ctx.globalAlpha = 0.8;
	ctx.beginPath();
	ctx.arc(XPosBoards, YPosBoards, 200, 0, Math.PI, true);
	ctx.stroke();
	ctx.fill();
	ctx.globalAlpha = 1.0;
	ctx.lineWidth = 0.5;
	ctx.beginPath();
	for (i = 0; i < 90; i++){
		if (i%5 == 0){
			endy = 170;
		}
		else{
			endy = 185;
		}
		if (i%10 == 0){
			endy = 160;
		}
		ctx.save();
		ctx.translate(XPosBoards, YPosBoards);
		AngToRotate = i/180*Math.PI;
		ctx.rotate(AngToRotate);
		
		ctx.moveTo(0, -200);
		ctx.lineTo(0, -1.0*endy);
		
		if (i%10 == 0){
			numb = 90 - Math.floor(i);
			if (numb > 0){
				WriteText(0,-140,numb,14,"#000000",0.5);
			}
			
		}
		
		ctx.restore();
		ctx.save();
		ctx.translate(XPosBoards, YPosBoards);
		AngToRotate = i/180*Math.PI;
		ctx.rotate(-1.0*AngToRotate);
		
		ctx.moveTo(0, -200);
		ctx.lineTo(0, -1.0*endy);
		
		if (i%10 == 0){
			numb = 90 - Math.floor(i);
			if (numb > 0){
				WriteText(0,-140,numb,14,"#000000",0.5);
			}
			
		}
		
		ctx.restore();
	}
	ctx.stroke();
	ctx.fillStyle = "#000000";
	ctx.beginPath();
	ctx.arc(XPosBoards, YPosBoards, 3, 0, Math.PI, true);
	ctx.stroke();
	ctx.fill();


	
	}


function DrawPucks(){
	for (i=0; i < 7; i++){
		if (HitBoards[i] == 0){
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(StartPuckX, PuckPosY[i]);
			ctx.lineTo(PuckPosX[i], PuckPosY[i]);
			ctx.stroke();
		}
		if (HitBoards[i] == 1){
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(StartPuckX, StartPuckY[i]);
			ctx.lineTo(PuckHitWallX[i], StartPuckY[i]);
			ctx.stroke();
			
			ctx.strokeStyle = "#990000";
			ctx.lineWidth = 0.5;
			ctx.beginPath();
			ctx.moveTo(PuckHitWallX[i], StartPuckY[i]);
			ctx.lineTo(PuckPosX[i], PuckPosY[i]);
			ctx.stroke();
		}
		
		
		ctx.fillStyle = "#333333";
		ctx.strokeStyle = "#000000";
		ctx.lineWidth = 1;
		ctx.beginPath();
		ctx.arc(PuckPosX[i], PuckPosY[i], RadiusPuck, 0.0*Math.PI, 2.0*Math.PI);
		ctx.stroke();
		ctx.fill();
	}
}


function DrawPrincipleAxis(){
	StartX = 0;
	StartY = 300;
	NumberOfSmallLines = 30;
	SizeX = 930/NumberOfSmallLines;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 3;
	ctx.beginPath();
	for (i = 0; i < NumberOfSmallLines; i++){
		ctx.moveTo(StartX+i*SizeX, StartY);
		ctx.lineTo(StartX+(i + 0.5)*SizeX, StartY);
	}
	ctx.stroke();
}



function DrawBoards(){
		
	//Actual Boards
	ctx.save();
	ctx.translate(XPosBoards, YPosBoards);
	ctx.rotate(BoardAngle[boardnumber]);
	ctx.fillStyle = "#990000";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(5,0);
	ctx.lineTo(5,-500);
	ctx.lineTo(5+ThicknessBoards, -500);
	ctx.lineTo(5+ThicknessBoards, 500);
	ctx.lineTo(5, 500);
	ctx.lineTo(5,0);
	ctx.stroke();
	ctx.fill();
	ctx.lineWidth = 8;
	ctx.strokeStyle = "#FFFFFF";
	ctx.beginPath();
	ctx.moveTo(5, 500);
	ctx.lineTo(5,-500);
	ctx.stroke();
	ctx.strokeStyle = "#FFFF00";
	ctx.beginPath();
	ctx.lineWidth = 3;
	ctx.beginPath();
	ctx.moveTo(2, 500);
	ctx.lineTo(2,-500);
	ctx.stroke();
	ctx.strokeStyle = "#000000";
	ctx.beginPath();
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(0, 500);
	ctx.lineTo(0,-500);
	ctx.stroke();
	ctx.restore();
}


function ChangeProtractor(){
	if (ShowProtractor == "yes"){
		ShowProtractor = "no";
		ProtractorMessage = "Mostrar transportador";
	}
	else{
		ShowProtractor = "yes";
		ProtractorMessage = "Ocultar transportador";
	}
}


function ChangeAngle(){
	boardnumber++;
	if (boardnumber > 7){
		boardnumber = 0;
	}
	CalculateParameters();
}


function WriteText(x,y,t,s,c,m){
	ctx.fillStyle = c;
	ctx.font= s + "px Arial";
	temptext = t;
	metrics = ctx.measureText(temptext);
	textWidth = metrics.width;
	xposition = x - m*textWidth;
	ctx.fillText(temptext,xposition, y);
}

function DrawArrow(x, y, h, w, c, r){
	ctx.save();
	ctx.translate(x, y+0.5*h);
	ctx.rotate(r);
	ctx.fillStyle = c;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(0,-0.5*h);
	ctx.lineTo(0+w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+w);
	ctx.lineTo(0-w, -0.5*h+w);
	ctx.lineTo(0,-0.5*h);
	ctx.stroke();
	ctx.closePath();
	ctx.fill();
	ctx.restore();
}




function DrawRectangle(xrect, yrect, wrect, hrect, curverectangle, lcolor, fcolor, lwid){
	ctx.fillStyle = fcolor;
	ctx.strokeStyle = lcolor;
	ctx.lineWidth = lwid;
	ctx.beginPath();
	ctx.moveTo(xrect+curverectangle, yrect);
	ctx.lineTo(xrect+wrect-curverectangle, yrect);
	ctx.arc(xrect+wrect-curverectangle, yrect+curverectangle, curverectangle, 1.5*Math.PI, 0*Math.PI, false);
	ctx.lineTo(xrect+wrect, yrect+hrect-curverectangle);
	ctx.arc(xrect+wrect-curverectangle, yrect+hrect-curverectangle, curverectangle, 0.0*Math.PI, 0.5*Math.PI, false);
	ctx.lineTo(xrect+curverectangle, yrect+hrect);
	ctx.arc(xrect+curverectangle, yrect+hrect-curverectangle, curverectangle, 0.5*Math.PI, 1.0*Math.PI, false);
	ctx.lineTo(xrect, yrect+curverectangle);
	ctx.arc(xrect+curverectangle, yrect+curverectangle, curverectangle, 1.0*Math.PI, 1.5*Math.PI, false);
	ctx.stroke();
	ctx.fill();
}

