ProgramFont = "Comic Sans MS";

XPos = new Array();
YPosrel = new Array();
ZPos = new Array();

XVelocity = new Array();

Pipe1Radius = new Array();
Pipe2Radius = new Array();

Pipe1Speeds = new Array();
Pipe1Pressure = new Array();


function initialize(){
	
/* Initial Conditions */	
	
//  Sets up the canvas for live action.
	
	theCanvas = document.getElementById("CanvasOne");
	ctx = theCanvas.getContext("2d");
	
	Shrinkage = 2.5;
	Peek = "no";
	
	NumberOfParticles = 0;
	NewParticleCreation = 5;
	StopCreation = "no";
	DensityOfWater = 1000;
	
	MiddleOfPipe = 200;
	ShowZoomOne = "no";
	ShowZoomTwo = "no";
	
	for (i = 0; i < 10; i++){
		Pipe1Radius[i] = Math.floor(Math.random()*8+100+10*i)/10;
		Pipe2Radius[i] = Pipe1Radius[i];
		Pipe1Speeds[i] = Math.floor(Math.random()*12+50 + 15*i)/10;
		Pipe1Pressure[i] = Math.floor(Math.random()*25+150 + 30*i);
	}
	
	pipeonenumber = 5;
	pipetwonumber = 3;
	speednumber = 5;
	pressurenumber = 5;
	
	
	CalculateParameters();
}



/* Called by the Begin Button */

function LoadIt(){
	document.getElementById("LabSection").style.visibility = "visible";
	document.getElementById("OverviewSection").style.visibility = "hidden";
	StartItMoving=setInterval(drawingpart, 20);
}

function CalculateParameters(){
	
	NumberOfParticles = 0;
	NewParticleCreation = 5;
	StopCreation = "no";
	Peek = "no";
	
	R1 = Pipe1Radius[pipeonenumber];
	R2 = Pipe2Radius[pipetwonumber];
	F1 = Pipe1Speeds[speednumber];
	P1 = Pipe1Pressure[pressurenumber];	
	
	R1m = R1/1000;
	R2m = R2/1000;
	A1 = Math.PI*Math.pow(R1m, 2.0);
	A2 = Math.PI*Math.pow(R2m, 2.0);
	FR = F1*A1*10;
	F2= F1*A1/A2;
	V1 = F1;
	V2 = F2;
	P2 = (P1*1000 + 0.5*DensityOfWater*Math.pow(V1,2.0) - 0.5*DensityOfWater*Math.pow(V2,2.0))/1000;
	CheckIt();
}

function CheckIt(){
	if (P2 > 500 || P2 < 10){
		if (LastSwitch == "Pressure"){
			pressurenumber = LastValue;
		}
		if (LastSwitch == "RadiusL"){
			pipeonenumber = LastValue;
		}
		if (LastSwitch == "RadiusR"){
			pipetwonumber = LastValue;
		}
		if (LastSwitch == "Speed"){
			speednumber = LastValue;
		}
		CalculateParameters();
		MessageToUser = "The combination of values was invalid.  Your system was not changed.";
	}
	else{
		MessageToUser = "Haz clic en los medidores para leer sus valores";
	}
	document.getElementById("SystemMessage").innerHTML = MessageToUser;
}

function drawingpart(){
	
	ctx.fillStyle = "#ffffff";
	ctx.fillRect(0,0,950,600);
	
	DrawPressureGauge1(200, MiddleOfPipe - Shrinkage*R1, 40);
	
	DrawPressureGauge2(700, MiddleOfPipe - Shrinkage*R2, 40);
	
	DrawBackPipe(-10, MiddleOfPipe);
	DrawFluid(-10, MiddleOfPipe);
	DrawFrontPipe(-10, MiddleOfPipe);
	ReducerPipe(350, MiddleOfPipe);
	
	if (NewParticleCreation >= 5 && StopCreation == "no"){
		NumberOfParticles = NumberOfParticles + 5;
		for (i = (NumberOfParticles - 5); i < NumberOfParticles; i++){
			XPos[i] = 0;
			YPosrel[i] = Math.random()*90 + 5;
			XVelocity[i] = F1;
		}
		NewParticleCreation = 0;
	}
	
	
	for (i = 0; i < NumberOfParticles; i++){
		if (XPos[i] > 500){
			XPos[i] = XPos[i] + F2/10;
		}
		else if (XPos[i] <= 400){
			XPos[i] = XPos[i] + F1/10;
		}
		else{
			XPos[i] = XPos[i] + (F1 + (F2 - F1)/100*(XPos[i]-400))/10;
		}
		
		if (StopCreation == "no"){
			if (XPos[1] > 900){
				StopCreation = "yes";
			}
			
		}
		
		if (XPos[i] > 900){
			XPos[i] = 0;
		}
	}
	
	if (StopCreation == "no"){
		NewParticleCreation++;
	}
	
	TubeOneControlArea(25,300,400,290);
	
	TubeTwoControlArea(475,300,400,290);
	
	
	if (ShowZoomOne == "yes"){
		ctx.globalAlpha = 0.8;
		DrawRectangle(150, 0, 600, 600, 5, "#990000", "#CCCCCC", 3);
		ctx.globalAlpha = 1.0;
		DrawPressureGauge1(450,600,250);
		WriteText(720,35,"X",32,"#990000",0.5,ProgramFont);
	}
	if (ShowZoomTwo == "yes"){
		ctx.globalAlpha = 0.8;
		DrawRectangle(150, 0, 600, 600, 5, "#990000", "#CCCCCC", 3);
		ctx.globalAlpha = 1.0;
		DrawPressureGauge2(450,600,250);
		WriteText(720,35,"X",32,"#990000",0.5,ProgramFont);
	}
}

function TubeOneControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 5, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+40,"Tubería izquierda",32,"#000000",0.5,"Arial");
	
	WriteText(x+0.5*w,y+100,"Presión (Medidor)",24,"#990000",0.5,"Arial");
	
	WriteText(x+0.5*w,y+180,"Radio:  " + R1.toFixed(1) + " cm",24,"#009900",0.5,"Arial");
	
	WriteText(x+0.5*w,y+260,"Velocidad:  " + F1.toFixed(1) + " m/s",24,"#000099",0.5,"Arial");
	
	DrawArrow(x+0.1*w, y+63, 50, 25, "#990000", Math.PI);
	DrawArrow(x+0.9*w, y+63, 50, 25, "#990000", 0);
	
	DrawArrow(x+0.1*w, y+143, 50, 25, "#009900", Math.PI);
	DrawArrow(x+0.9*w, y+143, 50, 25, "#009900", 0);
	
	DrawArrow(x+0.1*w, y+223, 50, 25, "#000099", Math.PI);
	DrawArrow(x+0.9*w, y+223, 50, 25, "#000099", 0);
	
}

function TubeTwoControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 5, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+40,"Tubería derecha",32,"#000000",0.5,"Arial");
	
	WriteText(x+0.5*w,y+180,"Radius:  " + R2.toFixed(1) + " cm",24,"#009900",0.5,"Arial");
	
	if (StopCreation == "yes" || Peek == "yes"){
		WriteText(x+0.5*w,y+100,"Presión (Medidor)",24,"#990000",0.5,"Arial");
		WriteText(x+0.5*w,y+260,"Velocidad:  " + F2.toFixed(1) + " m/s",24,"#000099",0.5,"Arial");
	}
	else{
		WriteText(x+0.5*w,y+100,"Lectura de presión no disponible aún.",18,"#990000",0.5,"Arial");
		WriteText(x+0.5*w,y+230,"Velocidad no disponible aún.",18,"#000099",0.5,"Arial");
		WriteText(x+0.5*w,y+260,"Observa cómo fluye el fluido.",18,"#000099",0.5,"Arial");
	}
	
	DrawArrow(x+0.1*w, y+143, 50, 25, "#009900", Math.PI);
	DrawArrow(x+0.9*w, y+143, 50, 25, "#009900", 0);
	
}



function DrawPressureGauge1(x,y,r){
	angleP1 = (1.6*(P1/500)+0.2)*Math.PI;
	GS = r/80;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#fff323";
	ctx.lineWidth = 2*GS;
	ctx.beginPath();
	ctx.moveTo(x-0.33*r,y);
	ctx.lineTo(x-0.33*r,y - 1.25*r);
	ctx.lineTo(x+0.33*r,y - 1.25*r);
	ctx.lineTo(x+0.33*r,y);
	ctx.stroke();
	ctx.fill();
	
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#fff323";
	ctx.lineWidth = 2*GS;
	ctx.beginPath();
	ctx.arc(x,y - 1.25*r, 1.1*r, 0, 2*Math.PI);
	ctx.stroke();
	ctx.fill();
	
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#FFFFFF";
	ctx.lineWidth = 8*GS;
	ctx.beginPath();
	ctx.arc(x,y - 1.25*r, r, 0, 2*Math.PI);
	ctx.stroke();
	ctx.fill();
	
	for (i = 0; i < 51; i++){
		if (i%5 == 0){
			startline = 0.75;
		}
		else{
			startline = 0.85;
		}
		
		ctx.lineWidth = GS;
		ctx.strokeStyle = "#000000";
		angleat = (0.032*i+0.2)*Math.PI;
		ctx.save();
		ctx.translate(x,y - 1.25*r);
		ctx.rotate(angleat);
		ctx.beginPath();
		ctx.moveTo(0,0+startline*r);
		ctx.lineTo(0,0+0.99*r);
		ctx.stroke();
		
		if (i%10 == 0){
			texttowrite = i*10;
			ctx.save();
			ctx.translate(0,0.6*r);
			ctx.rotate(-1.0*angleat);
			WriteText(0,0.1,texttowrite.toFixed(0),10*GS,"#000000",0.5,"Arial");
			ctx.restore();
		}
		
		ctx.restore();
		
	}
	
	ctx.lineWidth = 2*GS;
	ctx.strokeStyle = "#990000";
	ctx.save();
	ctx.translate(x,y - 1.25*r);
	ctx.rotate(angleP1);
	ctx.beginPath();
	ctx.moveTo(0,0-0.15*r);
	ctx.lineTo(0,0+0.99*r);
	ctx.stroke();
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#000000";
	ctx.beginPath();
	ctx.arc(0,0, 0.02*r, 0, 2*Math.PI);
	ctx.stroke();
	ctx.fill();
	ctx.restore();
	
	WriteText(x,y-0.60*r,"Presíon",10*GS,"#000000",0.5,"Arial");
	WriteText(x,y-0.45*r,"Absoluta",10*GS,"#000000",0.5,"Arial");
	WriteText(x,y-0.30*r,"kPa",10*GS,"#000000",0.5,"Arial");
}

function DrawPressureGauge2(x,y,r){
	if (StopCreation == "yes" || Peek == "yes"){
		angleP2 = (1.6*(P2/500)+0.2)*Math.PI;
		GS = r/80;
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#fff323";
		ctx.lineWidth = 2*GS;
		ctx.beginPath();
		ctx.moveTo(x-0.33*r,y);
		ctx.lineTo(x-0.33*r,y - 1.25*r);
		ctx.lineTo(x+0.33*r,y - 1.25*r);
		ctx.lineTo(x+0.33*r,y);
		ctx.stroke();
		ctx.fill();
		
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#fff323";
		ctx.lineWidth = 2*GS;
		ctx.beginPath();
		ctx.arc(x,y - 1.25*r, 1.1*r, 0, 2*Math.PI);
		ctx.stroke();
		ctx.fill();
		
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#FFFFFF";
		ctx.lineWidth = 8*GS;
		ctx.beginPath();
		ctx.arc(x,y - 1.25*r, r, 0, 2*Math.PI);
		ctx.stroke();
		ctx.fill();
		
		for (i = 0; i < 51; i++){
			if (i%5 == 0){
				startline = 0.75;
			}
			else{
				startline = 0.85;
			}
			
			ctx.lineWidth = GS;
			ctx.strokeStyle = "#000000";
			angleat = (0.032*i+0.2)*Math.PI;
			ctx.save();
			ctx.translate(x,y - 1.25*r);
			ctx.rotate(angleat);
			ctx.beginPath();
			ctx.moveTo(0,0+startline*r);
			ctx.lineTo(0,0+0.99*r);
			ctx.stroke();
			
			if (i%10 == 0){
				texttowrite = i*10;
				ctx.save();
				ctx.translate(0,0.6*r);
				ctx.rotate(-1.0*angleat);
				WriteText(0,0.1,texttowrite.toFixed(0),10*GS,"#000000",0.5,"Arial");
				ctx.restore();
			}
			
			ctx.restore();
			
		}
	
	
		ctx.lineWidth = 2*GS;
		ctx.strokeStyle = "#990000";
		ctx.save();
		ctx.translate(x,y - 1.25*r);
		ctx.rotate(angleP2);
		ctx.beginPath();
		ctx.moveTo(0,0-0.15*r);
		ctx.lineTo(0,0+0.99*r);
		ctx.stroke();
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#000000";
		ctx.beginPath();
		ctx.arc(0,0, 0.02*r, 0, 2*Math.PI);
		ctx.stroke();
		ctx.fill();
		ctx.restore();
		
		WriteText(x,y-0.60*r,"Presión",10*GS,"#000000",0.5,"Arial");
		WriteText(x,y-0.45*r,"Absolute",10*GS,"#000000",0.5,"Arial");
		WriteText(x,y-0.30*r,"kPa",10*GS,"#000000",0.5,"Arial");
	}
	
	else{
		angleP2 = (1.6*(0/500)+0.2)*Math.PI;
		GS = r/80;
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#fff323";
		ctx.lineWidth = 2*GS;
		ctx.beginPath();
		ctx.moveTo(x-0.33*r,y);
		ctx.lineTo(x-0.33*r,y - 1.25*r);
		ctx.lineTo(x+0.33*r,y - 1.25*r);
		ctx.lineTo(x+0.33*r,y);
		ctx.stroke();
		ctx.fill();
		
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#fff323";
		ctx.lineWidth = 2*GS;
		ctx.beginPath();
		ctx.arc(x,y - 1.25*r, 1.1*r, 0, 2*Math.PI);
		ctx.stroke();
		ctx.fill();
		
		ctx.strokeStyle = "#000000";
		ctx.fillStyle = "#000000";
		ctx.lineWidth = 8*GS;
		ctx.beginPath();
		ctx.arc(x,y - 1.25*r, r, 0, 2*Math.PI);
		ctx.stroke();
		ctx.fill();
		
		for (i = 0; i < 51; i++){
			if (i%5 == 0){
				startline = 0.75;
			}
			else{
				startline = 0.85;
			}
			
			ctx.lineWidth = GS;
			ctx.strokeStyle = "#000000";
			angleat = (0.032*i+0.2)*Math.PI;
			ctx.save();
			ctx.translate(x,y - 1.25*r);
			ctx.rotate(angleat);
			ctx.beginPath();
			ctx.moveTo(0,0+startline*r);
			ctx.lineTo(0,0+0.99*r);
			ctx.stroke();
			
			if (i%10 == 0){
				texttowrite = i*10;
				ctx.save();
				ctx.translate(0,0.6*r);
				ctx.rotate(-1.0*angleat);
				WriteText(0,0.1,texttowrite.toFixed(0),10*GS,"#000000",0.5,"Arial");
				ctx.restore();
			}
			
			ctx.restore();
			
		}
		
		WriteText(x,y-0.60*r,"Absolute",10*GS,"#000000",0.5,"Arial");
		WriteText(x,y-0.45*r,"Pressure",10*GS,"#000000",0.5,"Arial");
		WriteText(x,y-0.30*r,"kPa",10*GS,"#000000",0.5,"Arial");
		
	}
	

}

function DrawBackPipe(x,y){
	ctx.fillStyle = "#EEEEEE";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 4;
	ctx.beginPath();
	ctx.moveTo(x,y-Shrinkage*R1);
	ctx.lineTo(x,y+Shrinkage*R1);
	ctx.lineTo(400,y+Shrinkage*R1);
	ctx.bezierCurveTo(400+0.1*Shrinkage*R1,y+Shrinkage*R1, 400+0.1*Shrinkage*R1,y-Shrinkage*R1, 400,y-Shrinkage*R1);
	ctx.lineTo(x, y-Shrinkage*R1);
	ctx.stroke();
	ctx.fill();
	
	ctx.beginPath();
	ctx.lineTo(500,y+Shrinkage*R2);
	ctx.lineTo(940,y+Shrinkage*R2);
	ctx.lineTo(940,y-Shrinkage*R2);
	ctx.lineTo(500,y-Shrinkage*R2);
	ctx.bezierCurveTo(500+0.1*Shrinkage*R2,y-Shrinkage*R2, 500+0.1*Shrinkage*R2,y+Shrinkage*R2, 500,y+Shrinkage*R2);
	ctx.stroke();
	ctx.fill();
}

function DrawFluid(x,y){
	ctx.fillStyle = "#a0ebee";
	ctx.beginPath();
	ctx.moveTo(x,y-Shrinkage*R1);
	ctx.lineTo(x,y+Shrinkage*R1);
	ctx.lineTo(400,y+Shrinkage*R1);
	ctx.lineTo(500,y+Shrinkage*R2);
	ctx.lineTo(940,y+Shrinkage*R2);
	ctx.lineTo(940,y-Shrinkage*R2);
	ctx.lineTo(500,y-Shrinkage*R2);
	ctx.lineTo(400,y-Shrinkage*R1);
	ctx.lineTo(x, y-Shrinkage*R1);
	ctx.globalAlpha = 0.4;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	for (i = 0; i < NumberOfParticles; i++){
		if (XPos[i] <= 400){
			YPos = MiddleOfPipe - Shrinkage*R1 + YPosrel[i]*2*Shrinkage*R1/100;
		}
		else if (XPos[i] > 500){
			YPos = MiddleOfPipe - Shrinkage*R2 + YPosrel[i]*2*Shrinkage*R2/100;
		}
		else{
			YPos1 = MiddleOfPipe - Shrinkage*R1 + YPosrel[i]*2*Shrinkage*R1/100;
			YPos2 = MiddleOfPipe - Shrinkage*R2 + YPosrel[i]*2*Shrinkage*R2/100;
			YPos = YPos1 + (YPos2 - YPos1)/100*(XPos[i]-400);
		}
		
		DrawBall(XPos[i], YPos);
	}
	
}

function DrawBall(xball,yball){
	ctx.fillStyle = "#0aedee";
	ctx.beginPath();
	ctx.arc(xball,yball,2,0,2*Math.PI);
	ctx.fill();
}



function DrawFrontPipe(x,y){
	ctx.fillStyle = "#EEEEEE";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 4;
	ctx.beginPath();
	ctx.moveTo(x,y-Shrinkage*R1);
	ctx.lineTo(x,y+Shrinkage*R1);
	ctx.lineTo(400,y+Shrinkage*R1);
	ctx.bezierCurveTo(400-0.1*Shrinkage*R1,y+Shrinkage*R1, 400-0.1*Shrinkage*R1,y-Shrinkage*R1, 400,y-Shrinkage*R1);
	ctx.lineTo(x, y-Shrinkage*R1);
	ctx.stroke();
	ctx.globalAlpha = 0.4;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	ctx.beginPath();
	ctx.lineTo(500,y+Shrinkage*R2);
	ctx.lineTo(940,y+Shrinkage*R2);
	ctx.lineTo(940,y-Shrinkage*R2);
	ctx.lineTo(500,y-Shrinkage*R2);
	ctx.bezierCurveTo(500-0.1*Shrinkage*R2,y-Shrinkage*R2, 500-0.1*Shrinkage*R2,y+Shrinkage*R2, 500,y+Shrinkage*R2);
	ctx.stroke();
	ctx.globalAlpha = 0.4;
	ctx.fill();
	ctx.globalAlpha = 1.0;
}

function ReducerPipe(x,y){
	ctx.fillStyle = "#EEEEEE";
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 10;
	ctx.beginPath();
	ctx.moveTo(x,y-Shrinkage*R1);
	ctx.lineTo(x,y+Shrinkage*R1);
	ctx.lineTo(400,y+Shrinkage*R1);
	ctx.lineTo(500,y+Shrinkage*R2);
	ctx.lineTo(550,y+Shrinkage*R2);
	ctx.lineTo(550,y-Shrinkage*R2);
	ctx.lineTo(500,y-Shrinkage*R2);
	ctx.lineTo(400,y-Shrinkage*R1);
	ctx.lineTo(x, y-Shrinkage*R1);
	ctx.closePath();
	ctx.stroke();
	ctx.globalAlpha = 0.7;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
}

function ZoomG1(){
	document.getElementById("GaugeOneZoom").style.visibility = "hidden";
	document.getElementById("GaugeTwoZoom").style.visibility = "hidden";
	document.getElementById("PressureDownButton").style.visibility = "hidden";
	document.getElementById("PressureUpButton").style.visibility = "hidden";
	document.getElementById("RadiusLDownButton").style.visibility = "hidden";
	document.getElementById("RadiusLUpButton").style.visibility = "hidden";
	document.getElementById("SpeedDownButton").style.visibility = "hidden";
	document.getElementById("SpeedUpButton").style.visibility = "hidden";
	document.getElementById("RadiusRDownButton").style.visibility = "hidden";
	document.getElementById("RadiusRUpButton").style.visibility = "hidden";
	document.getElementById("SystemMessage").style.visibility = "hidden";
	document.getElementById("GaugeHide").style.visibility = "visible";
	ShowZoomOne = "yes";
	ShowZoomTwo = "no";
}

function ZoomG2(){
	document.getElementById("GaugeOneZoom").style.visibility = "hidden";
	document.getElementById("GaugeTwoZoom").style.visibility = "hidden";
	document.getElementById("PressureDownButton").style.visibility = "hidden";
	document.getElementById("PressureUpButton").style.visibility = "hidden";
	document.getElementById("RadiusLDownButton").style.visibility = "hidden";
	document.getElementById("RadiusLUpButton").style.visibility = "hidden";
	document.getElementById("SpeedDownButton").style.visibility = "hidden";
	document.getElementById("SpeedUpButton").style.visibility = "hidden";
	document.getElementById("RadiusRDownButton").style.visibility = "hidden";
	document.getElementById("RadiusRUpButton").style.visibility = "hidden";
	document.getElementById("SystemMessage").style.visibility = "hidden";
	document.getElementById("GaugeHide").style.visibility = "visible";
	ShowZoomOne = "no";
	ShowZoomTwo = "yes";
}

function HideGauges(){
	ShowZoomOne = "no";
	ShowZoomTwo = "no";
	document.getElementById("GaugeOneZoom").style.visibility = "visible";
	document.getElementById("GaugeTwoZoom").style.visibility = "visible";
	document.getElementById("PressureDownButton").style.visibility = "visible";
	document.getElementById("PressureUpButton").style.visibility = "visible";
	document.getElementById("RadiusLDownButton").style.visibility = "visible";
	document.getElementById("RadiusLUpButton").style.visibility = "visible";
	document.getElementById("SpeedDownButton").style.visibility = "visible";
	document.getElementById("SpeedUpButton").style.visibility = "visible";
	document.getElementById("RadiusRDownButton").style.visibility = "visible";
	document.getElementById("RadiusRUpButton").style.visibility = "visible";
	document.getElementById("SystemMessage").style.visibility = "visible";
	document.getElementById("GaugeHide").style.visibility = "hidden";
}

function SwitchPressure(x){
	LastSwitch = "Pressure";
	LastValue = pressurenumber;
	pressurenumber = pressurenumber + x;
	if (pressurenumber > 9){
		pressurenumber = 9;
	}
	if (pressurenumber < 0){
		pressurenumber = 0;
	}
	CalculateParameters();
}

function SwitchRadiusL(x){
	LastSwitch = "RadiusL";
	LastValue = pipeonenumber;
	pipeonenumber = pipeonenumber + x;
	if (pipeonenumber > 9){
		pipeonenumber = 9;
	}
	if (pipeonenumber < 0){
		pipeonenumber = 0;
	}
	CalculateParameters();
}


function SwitchRadiusR(x){
	LastSwitch = "RadiusR";
	LastValue = pipetwonumber;
	pipetwonumber = pipetwonumber + x;
	if (pipetwonumber > 9){
		pipetwonumber = 9;
	}
	if (pipetwonumber < 0){
		pipetwonumber = 0;
	}
	CalculateParameters();
}

function SwitchSpeed(x){
	LastSwitch = "Speed";
	LastValue = speednumber;
	speednumber = speednumber + x;
	if (speednumber > 9){
		speednumber = 9;
	}
	if (speednumber < 0){
		speednumber = 0;
	}
	CalculateParameters();
}

function CNumbers(){
	if (Peek == "yes"){
		Peek = "no";
	}
	else{
		Peek = "yes";
	}
	
}


function WriteText(x,y,t,s,c,m,f){
	ctx.fillStyle = c;
	ctx.font= s + "px " + f;
	temptext = t;
	metrics = ctx.measureText(temptext);
	textWidth = metrics.width;
	xposition = x - m*textWidth;
	ctx.fillText(temptext,xposition, y);
}

function DrawRectangle(xrect, yrect, wrect, hrect, curverectangle, lcolor, fcolor, lwid){
	ctx.fillStyle = fcolor;
	ctx.strokeStyle = lcolor;
	ctx.lineWidth = lwid;
	ctx.beginPath();
	ctx.moveTo(xrect+curverectangle, yrect);
	ctx.lineTo(xrect+wrect-curverectangle, yrect);
	ctx.arc(xrect+wrect-curverectangle, yrect+curverectangle, curverectangle, 1.5*Math.PI, 0*Math.PI, false);
	ctx.lineTo(xrect+wrect, yrect+hrect-curverectangle);
	ctx.arc(xrect+wrect-curverectangle, yrect+hrect-curverectangle, curverectangle, 0.0*Math.PI, 0.5*Math.PI, false);
	ctx.lineTo(xrect+curverectangle, yrect+hrect);
	ctx.arc(xrect+curverectangle, yrect+hrect-curverectangle, curverectangle, 0.5*Math.PI, 1.0*Math.PI, false);
	ctx.lineTo(xrect, yrect+curverectangle);
	ctx.arc(xrect+curverectangle, yrect+curverectangle, curverectangle, 1.0*Math.PI, 1.5*Math.PI, false);
	ctx.stroke();
	ctx.fill();
}

function DrawLineArrow(x, y, h, w, c, r){
	ctx.save();
	ctx.translate(x, y+0.5*h);
	ctx.rotate(r);
	ctx.strokeStyle = c;
	ctx.lineWidth = w;
	ctx.beginPath();
	ctx.moveTo(0,0.5*h);
	ctx.lineTo(0,-0.5*h);
	ctx.moveTo(0-5*w,-0.5*h+5*w);
	ctx.lineTo(0,-0.5*h);
	ctx.lineTo(0+5*w,-0.5*h+5*w);
	ctx.stroke();
	ctx.restore();
}

function DrawArrow(x, y, h, w, c, r){
	ctx.save();
	ctx.translate(x, y+0.5*h);
	ctx.rotate(r);
	ctx.fillStyle = c;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(0,-0.5*h);
	ctx.lineTo(0+w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+w);
	ctx.lineTo(0-w, -0.5*h+w);
	ctx.lineTo(0,-0.5*h);
	ctx.stroke();
	ctx.closePath();
	ctx.fill();
	ctx.restore();
}
