var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./ch19_resources/wc_icon.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./ch19_resources/mjb_icon.png"]="data:image/png;base64,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";
__base64Images["./ch19_i01/ch19_i1_icon.png"]="data:image/png;base64,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";
__base64Images["./ch19_i01/ch19_i1.PNG"]="data:image/png;base64,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";
__base64Images["./ch19_resources/cox_icon.png"]="data:image/png;base64,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";
__base64Images["./ch19_resources/tate_icon.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./ch19_resources/hbh_icon (2).png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepback.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM4WLrcPCIOUEYQ1NlZb3YVBWGgMpjD2VgXZ5Ga4Hplbd+oGATfws4w006iC/qIHeMD2HNkAFCcIwEAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
