function CoulombField_addTestCharges(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var width; // EjsS Model.Variables.Drawing Vars.width
  var height; // EjsS Model.Variables.Drawing Vars.height
  var xmin; // EjsS Model.Variables.Drawing Vars.xmin
  var xmax; // EjsS Model.Variables.Drawing Vars.xmax
  var ymin; // EjsS Model.Variables.Drawing Vars.ymin
  var ymax; // EjsS Model.Variables.Drawing Vars.ymax
  var headSize; // EjsS Model.Variables.Drawing Vars.headSize
  var lower; // EjsS Model.Variables.Drawing Vars.lower
  var upper; // EjsS Model.Variables.Drawing Vars.upper

  var nx; // EjsS Model.Variables.Field Vars.nx
  var ny; // EjsS Model.Variables.Field Vars.ny
  var xPos; // EjsS Model.Variables.Field Vars.xPos
  var yPos; // EjsS Model.Variables.Field Vars.yPos
  var showField; // EjsS Model.Variables.Field Vars.showField
  var data; // EjsS Model.Variables.Field Vars.data
  var vectorField; // EjsS Model.Variables.Field Vars.vectorField
  var scale; // EjsS Model.Variables.Field Vars.scale

  var n; // EjsS Model.Variables.Charge Vars.n
  var nMax; // EjsS Model.Variables.Charge Vars.nMax
  var nPos; // EjsS Model.Variables.Charge Vars.nPos
  var nNeg; // EjsS Model.Variables.Charge Vars.nNeg
  var x; // EjsS Model.Variables.Charge Vars.x
  var y; // EjsS Model.Variables.Charge Vars.y
  var vis; // EjsS Model.Variables.Charge Vars.vis
  var q; // EjsS Model.Variables.Charge Vars.q
  var qColor; // EjsS Model.Variables.Charge Vars.qColor
  var msgStr; // EjsS Model.Variables.Charge Vars.msgStr
  var hideCharges; // EjsS Model.Variables.Charge Vars.hideCharges

  var nTestMax; // EjsS Model.Variables.Test Charge Vars.nTestMax
  var nq; // EjsS Model.Variables.Test Charge Vars.nq
  var xTest; // EjsS Model.Variables.Test Charge Vars.xTest
  var yTest; // EjsS Model.Variables.Test Charge Vars.yTest
  var visTest; // EjsS Model.Variables.Test Charge Vars.visTest
  var ExTest; // EjsS Model.Variables.Test Charge Vars.ExTest
  var EyTest; // EjsS Model.Variables.Test Charge Vars.EyTest

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      width : width,
      height : height,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      headSize : headSize,
      lower : lower,
      upper : upper,
      nx : nx,
      ny : ny,
      xPos : xPos,
      yPos : yPos,
      showField : showField,
      data : data,
      vectorField : vectorField,
      scale : scale,
      n : n,
      nMax : nMax,
      nPos : nPos,
      nNeg : nNeg,
      x : x,
      y : y,
      vis : vis,
      q : q,
      qColor : qColor,
      msgStr : msgStr,
      hideCharges : hideCharges,
      nTestMax : nTestMax,
      nq : nq,
      xTest : xTest,
      yTest : yTest,
      visTest : visTest,
      ExTest : ExTest,
      EyTest : EyTest
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.width != "undefined") width = json.width;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.headSize != "undefined") headSize = json.headSize;
    if(typeof json.lower != "undefined") lower = json.lower;
    if(typeof json.upper != "undefined") upper = json.upper;
    if(typeof json.nx != "undefined") nx = json.nx;
    if(typeof json.ny != "undefined") ny = json.ny;
    if(typeof json.xPos != "undefined") xPos = json.xPos;
    if(typeof json.yPos != "undefined") yPos = json.yPos;
    if(typeof json.showField != "undefined") showField = json.showField;
    if(typeof json.data != "undefined") data = json.data;
    if(typeof json.vectorField != "undefined") vectorField = json.vectorField;
    if(typeof json.scale != "undefined") scale = json.scale;
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.nMax != "undefined") nMax = json.nMax;
    if(typeof json.nPos != "undefined") nPos = json.nPos;
    if(typeof json.nNeg != "undefined") nNeg = json.nNeg;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.vis != "undefined") vis = json.vis;
    if(typeof json.q != "undefined") q = json.q;
    if(typeof json.qColor != "undefined") qColor = json.qColor;
    if(typeof json.msgStr != "undefined") msgStr = json.msgStr;
    if(typeof json.hideCharges != "undefined") hideCharges = json.hideCharges;
    if(typeof json.nTestMax != "undefined") nTestMax = json.nTestMax;
    if(typeof json.nq != "undefined") nq = json.nq;
    if(typeof json.xTest != "undefined") xTest = json.xTest;
    if(typeof json.yTest != "undefined") yTest = json.yTest;
    if(typeof json.visTest != "undefined") visTest = json.visTest;
    if(typeof json.ExTest != "undefined") ExTest = json.ExTest;
    if(typeof json.EyTest != "undefined") EyTest = json.EyTest;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Vector Field"] = true;
    __pagesEnabled["Compute Field"] = true;
  });

  _model.addToReset(function() {
    width = (_isMobile||_isEPub)?400:600; // EjsS Model.Variables.Drawing Vars.width
    height = (_isMobile||_isEPub)?400:600; // EjsS Model.Variables.Drawing Vars.height
    xmin = -10; // EjsS Model.Variables.Drawing Vars.xmin
    xmax = 10; // EjsS Model.Variables.Drawing Vars.xmax
    ymin = -10; // EjsS Model.Variables.Drawing Vars.ymin
    ymax = 10; // EjsS Model.Variables.Drawing Vars.ymax
    headSize = 3; // EjsS Model.Variables.Drawing Vars.headSize
    lower = 0.2; // EjsS Model.Variables.Drawing Vars.lower
    upper = 1.0; // EjsS Model.Variables.Drawing Vars.upper
  });

  _model.addToReset(function() {
    nx = 18; // EjsS Model.Variables.Field Vars.nx
    ny = 18; // EjsS Model.Variables.Field Vars.ny
    xPos = new Array(0); // EjsS Model.Variables.Field Vars.xPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.xPos
        xPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.xPos
      }
    }());
    yPos = new Array(0); // EjsS Model.Variables.Field Vars.yPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.yPos
        yPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.yPos
      }
    }());
    showField = false; // EjsS Model.Variables.Field Vars.showField
    data = new Array(2); // EjsS Model.Variables.Field Vars.data
    scale = 3; // EjsS Model.Variables.Field Vars.scale
  });

  _model.addToReset(function() {
    n = 1; // EjsS Model.Variables.Charge Vars.n
    nMax = 20; // EjsS Model.Variables.Charge Vars.nMax
    nPos = 1; // EjsS Model.Variables.Charge Vars.nPos
    nNeg = 1; // EjsS Model.Variables.Charge Vars.nNeg
    x = new Array(nMax); // EjsS Model.Variables.Charge Vars.x
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.x
        x[_i0] = 0;  // EjsS Model.Variables.Charge Vars.x
      }
    }());
    y = new Array(nMax); // EjsS Model.Variables.Charge Vars.y
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.y
        y[_i0] = 0;  // EjsS Model.Variables.Charge Vars.y
      }
    }());
    vis = new Array(nMax); // EjsS Model.Variables.Charge Vars.vis
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.vis
        vis[_i0] = false;  // EjsS Model.Variables.Charge Vars.vis
      }
    }());
    q = new Array(nMax); // EjsS Model.Variables.Charge Vars.q
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.q
        q[_i0] = 1;  // EjsS Model.Variables.Charge Vars.q
      }
    }());
    qColor = new Array(nMax); // EjsS Model.Variables.Charge Vars.qColor
    msgStr = " "; // EjsS Model.Variables.Charge Vars.msgStr
    hideCharges = false; // EjsS Model.Variables.Charge Vars.hideCharges
  });

  _model.addToReset(function() {
    nTestMax = 20; // EjsS Model.Variables.Test Charge Vars.nTestMax
    nq = 1; // EjsS Model.Variables.Test Charge Vars.nq
    xTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.xTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.xTest
        xTest[_i0] = 0;  // EjsS Model.Variables.Test Charge Vars.xTest
      }
    }());
    yTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.yTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.yTest
        yTest[_i0] = 0;  // EjsS Model.Variables.Test Charge Vars.yTest
      }
    }());
    visTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.visTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.visTest
        visTest[_i0] = false;  // EjsS Model.Variables.Test Charge Vars.visTest
      }
    }());
    ExTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.ExTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.ExTest
        ExTest[_i0] = 0;  // EjsS Model.Variables.Test Charge Vars.ExTest
      }
    }());
    EyTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.EyTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.EyTest
        EyTest[_i0] = 0;  // EjsS Model.Variables.Test Charge Vars.EyTest
      }
    }());
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setFPS(10);
    _model.setStepsPerDisplay(1);
  });

  function drawVectorField(context,element) {  // > CustomCode.Draw Vectors:1
    if(!showField) return;  // > CustomCode.Draw Vectors:2
    var ospCanvas = new OSPCanvas(context,element, xmin,xmax,ymin,ymax);  // > CustomCode.Draw Vectors:3
    vectorField.updateData(data);  // > CustomCode.Draw Vectors:4
    ospCanvas.addDrawable(vectorField);  // > CustomCode.Draw Vectors:5
    ospCanvas.drawObjects();  // > CustomCode.Draw Vectors:6
  }  // > CustomCode.Draw Vectors:7

  function createData() {  // > CustomCode.Create Data Array:1
    var newXData= [];  // > CustomCode.Create Data Array:2
    var newYData= [];  // > CustomCode.Create Data Array:3
    for(var i=0; i<nx; i++) {  // > CustomCode.Create Data Array:4
      newXData.push([]);  // > CustomCode.Create Data Array:5
      newYData.push([]);  // > CustomCode.Create Data Array:6
      for (var j=0; j<ny; j++) {  // > CustomCode.Create Data Array:7
        newXData[i].push(0); //adds the value to the data  // > CustomCode.Create Data Array:8
        newYData[i].push(0); //adds the value to the data  // > CustomCode.Create Data Array:9
      }  // > CustomCode.Create Data Array:10
    }  // > CustomCode.Create Data Array:11
    return [newXData,newYData]; //returns new component arrays  // > CustomCode.Create Data Array:12
  }  // > CustomCode.Create Data Array:13

  function chargeVisible () {  // > CustomCode.chargeVisitble:1
    if (hideCharges){  // > CustomCode.chargeVisitble:2
    for (var i=0; i<nMax; i++){  // > CustomCode.chargeVisitble:3
    vis[i]=false;  // > CustomCode.chargeVisitble:4
    }  // > CustomCode.chargeVisitble:5
    }  // > CustomCode.chargeVisitble:6
    else {  // > CustomCode.chargeVisitble:7
      for (var i=0; i<n; i++){  // > CustomCode.chargeVisitble:8
    vis[i]=true;  // > CustomCode.chargeVisitble:9
    }  // > CustomCode.chargeVisitble:10
      }  // > CustomCode.chargeVisitble:11
  }  // > CustomCode.chargeVisitble:12

  function addTestCharge () {  // > CustomCode.addTestCharge:1
    nq=1+nq;  // > CustomCode.addTestCharge:2
    xTest[nq]=xmin+(xmax-xmin)*Math.random();  // > CustomCode.addTestCharge:3
    yTest[nq]=ymin+(ymax-ymin)*Math.random();  // > CustomCode.addTestCharge:4
    visTest[nq]=true;  // > CustomCode.addTestCharge:5
    getETest();  // > CustomCode.addTestCharge:6
      // > CustomCode.addTestCharge:7
  }  // > CustomCode.addTestCharge:8

  function getETest () {  // > CustomCode.EField_Test:1
    for (var i=0;i<=nq; i++) {  // > CustomCode.EField_Test:2
      ExTest[i]=0;  // > CustomCode.EField_Test:3
      EyTest[i]=0;  // > CustomCode.EField_Test:4
      for(var p=0; p<n; p++) {  // > CustomCode.EField_Test:5
        // loop over charges  // > CustomCode.EField_Test:6
        var dx=xTest[i]-x[p];                      // grid point x-separation  // > CustomCode.EField_Test:7
        var dy=yTest[i]-y[p];                      // grid point y-separation  // > CustomCode.EField_Test:8
        var r2=dx*dx+dy*dy;                  // distance squared  // > CustomCode.EField_Test:9
        var r3=r2*Math.sqrt(r2);             // distance cubed  // > CustomCode.EField_Test:10
        if(r2!=0) {  // > CustomCode.EField_Test:11
          // check for singularity  // > CustomCode.EField_Test:12
          ExTest[i]+= 1000*q[p]*dx/r3;               // add E field x-component  // > CustomCode.EField_Test:13
          EyTest[i]+= 1000*q[p]*dy/r3;               // add E field y-component  // > CustomCode.EField_Test:14
        } // end of if statement  // > CustomCode.EField_Test:15
      }  // > CustomCode.EField_Test:16
    }  // > CustomCode.EField_Test:17
  }  // > CustomCode.EField_Test:18

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Vector Field"]) return;
    _view.custom.setFunction(drawVectorField);  // > Initialization.Init Vector Field:1
    _view._update();  // updates the function Field and draws the wave function   // > Initialization.Init Vector Field:2
    xPos= arrayCoordinates(xmin, xmax, nx); // returns array(nx);  // > Initialization.Init Vector Field:3
    yPos= arrayCoordinates(ymin, ymax, ny); // returns array(nx);  // > Initialization.Init Vector Field:4
    data=createData();  // creates component arrays  // > Initialization.Init Vector Field:5
    vectorField = new VectorField(data, xmin,xmax,nx,ymin,ymax,ny);  // > Initialization.Init Vector Field:6
    vectorField.setThreshold(lower,upper);  // > Initialization.Init Vector Field:7
    showField=false;  // > Initialization.Init Vector Field:8
    hideCharges=false;  // > Initialization.Init Vector Field:9
    n=nPos+nNeg;  // > Initialization.Init Vector Field:10
    if (n<1 || n>20){  // > Initialization.Init Vector Field:11
      msgStr = "Number of charges must be between 1 and 20";  // > Initialization.Init Vector Field:12
      n=2;  // > Initialization.Init Vector Field:13
      nPos=1;  // > Initialization.Init Vector Field:14
      nNeg=1;  // > Initialization.Init Vector Field:15
      }  // > Initialization.Init Vector Field:16
     else {  // > Initialization.Init Vector Field:17
       msgStr ="";  // > Initialization.Init Vector Field:18
       }  // > Initialization.Init Vector Field:19
    for (var i=0;i<nPos;i++){  // > Initialization.Init Vector Field:20
      x[i]=xmax*(i/n);  // > Initialization.Init Vector Field:21
      y[i]=0;  // > Initialization.Init Vector Field:22
      q[i]=1;  // > Initialization.Init Vector Field:23
      vis[i]=true;  // > Initialization.Init Vector Field:24
      qColor[i]="rgb(255,0,0)";  // > Initialization.Init Vector Field:25
      }  // > Initialization.Init Vector Field:26
    for (var i=nPos;i<n;i++){  // > Initialization.Init Vector Field:27
      x[i]=xmax*(i/n);  // > Initialization.Init Vector Field:28
      y[i]=ymin/2;  // > Initialization.Init Vector Field:29
      q[i]=-1;  // > Initialization.Init Vector Field:30
      vis[i]=true;  // > Initialization.Init Vector Field:31
      qColor[i]="rgb(0,0,255)";  // > Initialization.Init Vector Field:32
      }  // > Initialization.Init Vector Field:33
        // > Initialization.Init Vector Field:34
      //make old charges invisible  // > Initialization.Init Vector Field:35
      for (var i=n; i<nMax; i++){  // > Initialization.Init Vector Field:36
      vis[i]=false;  // > Initialization.Init Vector Field:37
      }  // > Initialization.Init Vector Field:38
      //make old test charges invisible  // > Initialization.Init Vector Field:39
      for(var i=0;i<nTestMax;i++){  // > Initialization.Init Vector Field:40
        visTest[i]=false;  // > Initialization.Init Vector Field:41
        }  // > Initialization.Init Vector Field:42
      nq=0;  // > Initialization.Init Vector Field:43
      addTestCharge();  // > Initialization.Init Vector Field:44
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Compute Field"]) return;
    var xField=data[0];  // > FixedRelations.Compute Field:1
    var yField=data[1];  // > FixedRelations.Compute Field:2
    for (var i=0; i<nx; i++) {  // > FixedRelations.Compute Field:3
      for (var j=0; j<ny; j++) {  // > FixedRelations.Compute Field:4
        xField[i][j]=0;  // > FixedRelations.Compute Field:5
        yField[i][j]=0;  // > FixedRelations.Compute Field:6
        var xi=xPos[i];  // > FixedRelations.Compute Field:7
        var yj=yPos[j];  // > FixedRelations.Compute Field:8
        for(var p=0; p<n; p++) {  // > FixedRelations.Compute Field:9
          // loop over charges  // > FixedRelations.Compute Field:10
          var dx=xi-x[p];                      // grid point x-separation  // > FixedRelations.Compute Field:11
          var dy=yj-y[p];                      // grid point y-separation  // > FixedRelations.Compute Field:12
          var r2=dx*dx+dy*dy;                  // distance squared  // > FixedRelations.Compute Field:13
          var r3=r2*Math.sqrt(r2);             // distance cubed  // > FixedRelations.Compute Field:14
          if(r2!=0) {  // > FixedRelations.Compute Field:15
            // check for singularity  // > FixedRelations.Compute Field:16
            xField[i][j] += scale*q[p]*dx/r3;               // add E field x-component  // > FixedRelations.Compute Field:17
            yField[i][j] += scale*q[p]*dy/r3;               // add E field y-component  // > FixedRelations.Compute Field:18
          } // end of if statement  // > FixedRelations.Compute Field:19
        }  // > FixedRelations.Compute Field:20
      }  // > FixedRelations.Compute Field:21
    }  // > FixedRelations.Compute Field:22
    getETest(); //find electric field at location of each test charge  // > FixedRelations.Compute Field:23
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new CoulombField_addTestCharges_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.plottingPanel.linkProperty("Height",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumX",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumX",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'MinimumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumY",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'MinimumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("BRMessage",  function() { return msgStr; }, function(_v) { msgStr = _v; } ); // HtmlView Page linking property 'BRMessage' for element 'plottingPanel'
          _view.custom.linkProperty("SizeX",  function() { return xmax-xmin; } ); // HtmlView Page linking property 'SizeX' for element 'custom'
          _view.custom.linkProperty("X",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'X' for element 'custom'
          _view.custom.linkProperty("Y",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'Y' for element 'custom'
          _view.custom.linkProperty("SizeY",  function() { return ymax-ymin; } ); // HtmlView Page linking property 'SizeY' for element 'custom'
          _view.chargeSet.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'chargeSet'
          _view.chargeSet.linkProperty("FillColor",  function() { return qColor; }, function(_v) { qColor = _v; } ); // HtmlView Page linking property 'FillColor' for element 'chargeSet'
          _view.chargeSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'chargeSet'
          _view.chargeSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'chargeSet'
          _view.chargeSet.linkProperty("Visibility",  function() { return vis; }, function(_v) { vis = _v; } ); // HtmlView Page linking property 'Visibility' for element 'chargeSet'
          _view.testChargeSet.linkProperty("NumberOfElements",  function() { return nTestMax; }, function(_v) { nTestMax = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("X",  function() { return xTest; }, function(_v) { xTest = _v; } ); // HtmlView Page linking property 'X' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("Y",  function() { return yTest; }, function(_v) { yTest = _v; } ); // HtmlView Page linking property 'Y' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("Visibility",  function() { return visTest; }, function(_v) { visTest = _v; } ); // HtmlView Page linking property 'Visibility' for element 'testChargeSet'
          _view.testChargeSet.setAction("OnDrag", getETest); // HtmlView Page setting action 'OnDrag' for element 'testChargeSet'
          _view.testChargeForceSet.linkProperty("NumberOfElements",  function() { return nTestMax; }, function(_v) { nTestMax = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'testChargeForceSet'
          _view.testChargeForceSet.linkProperty("SizeX",  function() { return ExTest; }, function(_v) { ExTest = _v; } ); // HtmlView Page linking property 'SizeX' for element 'testChargeForceSet'
          _view.testChargeForceSet.linkProperty("X",  function() { return xTest; }, function(_v) { xTest = _v; } ); // HtmlView Page linking property 'X' for element 'testChargeForceSet'
          _view.testChargeForceSet.linkProperty("Y",  function() { return yTest; }, function(_v) { yTest = _v; } ); // HtmlView Page linking property 'Y' for element 'testChargeForceSet'
          _view.testChargeForceSet.linkProperty("Visibility",  function() { return visTest; }, function(_v) { visTest = _v; } ); // HtmlView Page linking property 'Visibility' for element 'testChargeForceSet'
          _view.testChargeForceSet.linkProperty("SizeY",  function() { return EyTest; }, function(_v) { EyTest = _v; } ); // HtmlView Page linking property 'SizeY' for element 'testChargeForceSet'
          _view.controlPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'controlPanel'
          _view.resetButton.setAction("OnClick", function() {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.addTestChargeButton.setAction("OnClick", addTestCharge); // HtmlView Page setting action 'OnClick' for element 'addTestChargeButton'
          _view.showFieldCheckBox.linkProperty("Checked",  function() { return showField; }, function(_v) { showField = _v; } ); // HtmlView Page linking property 'Checked' for element 'showFieldCheckBox'
          _view.showCharges.linkProperty("Checked",  function() { return hideCharges; }, function(_v) { hideCharges = _v; } ); // HtmlView Page linking property 'Checked' for element 'showCharges'
          _view.showCharges.setAction("OnChange", chargeVisible); // HtmlView Page setting action 'OnChange' for element 'showCharges'
          _view.nPosField.linkProperty("Value",  function() { return nPos; }, function(_v) { nPos = _v; } ); // HtmlView Page linking property 'Value' for element 'nPosField'
          _view.nPosField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'nPosField'
          _view.nNegField.linkProperty("Value",  function() { return nNeg; }, function(_v) { nNeg = _v; } ); // HtmlView Page linking property 'Value' for element 'nNegField'
          _view.nNegField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'nNegField'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(10);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function CoulombField_addTestCharges_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = CoulombField_addTestCharges_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function CoulombField_addTestCharges_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.wrappedPanel,"wrappedPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'wrappedPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"titlePanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'titlePanel'
      .setProperty("Html","<h2>Electric Field with Test Charge</h2>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'titlePanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'mainPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.mainPanel,"GRAPHICS2D_CANVAS") // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Background","White") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("Title","Electric Field") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("SquareAspect",false) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("GridYShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridYShow' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("XTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("GraphicsMode","Canvas") // EJsS HtmlView.HtmlView Page: setting property 'GraphicsMode' for element 'plottingPanel'
      .setProperty("GridXShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridXShow' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.custom,"custom", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'custom'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'custom'
      .setProperty("RelativePosition","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'custom'
      .setProperty("LineColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'custom'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'custom'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"chargeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'chargeSet'
      .setProperty("Sensitivity",15) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'chargeSet'
      .setProperty("SizeX",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'chargeSet'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'chargeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'chargeSet'
      .setProperty("SizeY",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'chargeSet'
      .setProperty("EnabledPosition","ENABLED_ANY") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'chargeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"testChargeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'testChargeSet'
      .setProperty("FillColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'testChargeSet'
      .setProperty("Sensitivity",15) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'testChargeSet'
      .setProperty("MovesGroup",false) // EJsS HtmlView.HtmlView Page: setting property 'MovesGroup' for element 'testChargeSet'
      .setProperty("SizeX",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'testChargeSet'
      .setProperty("SizeY",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'testChargeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'testChargeSet'
      .setProperty("EnabledPosition","ENABLED_ANY") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'testChargeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.arrowSet,"testChargeForceSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'testChargeForceSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'testChargeForceSet'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'testChargeForceSet'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      .setProperty("CSS",{ "display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'controlPanel'
      .setProperty("Background","rgba(240,240,240,255)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'controlPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'controlPanel'
      .setProperty("BorderColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'controlPanel'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"buttonPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonPanel'
      .setProperty("CSS",{"display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'buttonPanel'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"addTestChargeButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'addTestChargeButton'
      .setProperty("Text","Add Test Charge") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'addTestChargeButton'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"showFieldCheckBox", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'showFieldCheckBox'
      .setProperty("Text","Show Field Vector") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'showFieldCheckBox'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"showCharges", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'showCharges'
      .setProperty("Text","Hide Charges") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'showCharges'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"inputPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'inputPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nPosLabel", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nPosLabel'
      .setProperty("Text","Number of positive charges: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nPosLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nPosField", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nPosField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nPosField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nPosField'
      .setProperty("Editable",true) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'nPosField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nNegLabel", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nNegLabel'
      .setProperty("Text","and negative charges: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nNegLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nNegField", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nNegField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nNegField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nNegField'
      .setProperty("Editable",true) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'nNegField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"narrativePanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'narrativePanel'
      .setProperty("Html","<p>You can add positive (<font color=\"#ff0000\">red</font>) and negative (<font color=\"#0000ff\">blue</font>) charges as well as \"test\" charges (black). A test charge is like a ghost 	  charge: it shows you the force that a positive charge would feel at a given location, but it does not 	  change the surrounding field. In other words, the test charge shows you the direction and magnitude of the 	  electric field at a given point. You can also show or hide the electric field and the positive and negative charges.</p> 	  <p><ul> 	  <li>Start with one positive charge (and no negative charges). Add several test charges. Move them around. Describe the field around a positive charge.</li> 	  <li>Now put in one negative charge (and no positive charges). Add several test charges. How is the field different?</li> 	  <li>Click on the \"Show Field Vector\" check box. What does this show you? How is this representation the same as what you  	  saw with several test charges? How is it different?</li> 	  <li>Set up a configuration with two of the same charge. Describe the vector field.</li> 	  <li>Set up a dipole: one positive and one negative charge. Describe that vector field.</li> 	  <li>Set up a configuration of 4 individual charges. Try set-ups where you stack the charges. Hide the charges. 	  How can you use test charges to tell where the charges are? Create a set-up with 4 \"hidden\" charges for another lab group 	  to test. Can they tell where your charges are \"hidden\"? Can you tell where their charges are \"hidden\"?</li> 	  <li>Create a line of positive charges (10 or so close together). What does the field look like?</li> 	  <li>Describe the field between two parallel lines of opposite charge (this is like a capacitor).</li> 	  </ul></p>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'narrativePanel'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new CoulombField_addTestCharges("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined") _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
