"use strict";

import {resize, Select} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import {Cylinder, Plane} from "../../geometry/Figure.js";
import V3 from "../../modules/V3.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import TexcoordGenerator from "../../materials/TexcoordGenerator.js";

/**
 * Ejemplo de mapeo de texturas.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    let srcTextures = [ "../../../images/capitulo_07/textures/bark_brown_02_diff_1k.jpg"];
    
    let uniforms = {u_material : {}, 
                    u_light: {  la: [0.5,0.5,0.5], ld: [1, 1, 1],
                                ls: [0.2, 0.2, 0.1]}};
    
    let cylinderFigure = new Cylinder(1, 2, 35, 35);
    
    let configMaterial = { filters: {min: gl.NEAREST, mag: gl.NEAREST, wrap_s: gl.REPEAT, wrap_t: gl.REPEAT}};
    let cylinderMaterial = new TexcoordGenerator(gl, WebGL, cylinderFigure, srcTextures, setTextures, uniforms, configMaterial); 
    
    let cylinder = new GeometryPainter(gl, cylinderMaterial);
  
    let viewMatrix = M4.camera(new V3(0,.1,2), new V3(0,0,0), new V3(0,1,0));

    let textures;
    let angle = 0;

    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.SCISSOR_TEST);
    
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    requestAnimationFrame(draw);

    function draw(){        
        resize(canvas);
        
        const {width, height} = gl.canvas;
        const leftWidth = width / 2 | 0;
        const rightWidth = width - leftWidth;
        angle = (angle + 0.1)% 360;
        
        //dibuja vista izquierda
        gl.viewport(0, 0, leftWidth, height);
        gl.scissor(0, 0, leftWidth, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
       
        var projectionMatrix = M4.ortho(-2.8, 2.8, 2.8, -2.8, .1, -10);
        var modelMatrix =  M4.multiply(M4.translate(0,0,-.5), M4.multiply(M4.rotateX(20), M4.rotateY(angle)));
        var modelViewMatrix = M4.multiply(viewMatrix, modelMatrix);
        var lightPos = M4.multiplyVector(viewMatrix, [0, 2.5, -5.5, 0]);
        uniforms.u_light.position = lightPos;
        if(textures){
            uniforms.u_material = { diffuse_map : { id: 0, texture: textures[0]},
                                    shininess: 0.088*128};
            cylinder.draw(gl, M4.multiply(modelViewMatrix, M4.scale(1.7,1.7,1.7)), projectionMatrix, uniforms);   
        }

        //dibuja vista derecha
        gl.viewport(leftWidth, 0, rightWidth, height);
        gl.scissor(leftWidth, 0, rightWidth, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

        var aspect =rightWidth/height;
        projectionMatrix = M4.perspective(85, aspect, .1, 10);
        modelMatrix =  M4.multiply(M4.translate(0,0,-.5), M4.multiply(M4.rotateX(-20), M4.rotateY(-angle)));
        modelViewMatrix = M4.multiply(viewMatrix, modelMatrix);
        lightPos = M4.multiplyVector(viewMatrix, [0, 1.8, .3, 0]);
        if(textures){
            uniforms.u_light.position = lightPos;
            cylinder.draw(gl, modelViewMatrix, projectionMatrix, uniforms);   
        }
        
        requestAnimationFrame(draw);
        
    }
    function setTextures(loadedTextures){
        textures = loadedTextures;
        draw();
    }
} 