"use strict";

import {Checkbox, resize} from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M4 from "../../../modules/M4.js";
import Diffuse from "../../../materials/Diffuse.js";
import DirectionalLight from "../../../materials/DirectionalLight.js";
import SolidColor from "../../../materials/SolidColor.js";
import GeometryPainter from "../../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../../modules/Trackballcamera.js";
import V3 from "../../../modules/V3.js";
import Boat from "../../../geometry/Boat.js";

/**
 * La Canoa. Ejemplo del uso de parches de Bézier. 
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);
function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    let geometryFigure = new Boat(); //new LoadObj("../../../geometry/OBJ/boat_8330.obj");
    
    let lightDirection = [2, -1, 0, 0];
    let material = { ka: [0.329412, 0.223529, 0.027451], kd: [0.780392, 0.568627, 0.113725], ks: [0.992157, 0.941176, 0.807843], 
                     shininess: 0.21794872*128};
    let light = { direction: lightDirection, la: [.3, .3, .3], ld: [1,1,1], ls: [1.0, 1.0, 1.0]};
    let uniforms = { u_light: light, u_material: material};  
    let transform = M4.multiply(M4.translate(.5,.5,0), M4.multiply(M4.rotateY(0),M4.scale(2,2,2)));
    let figure = new GeometryPainter(gl, new DirectionalLight(gl, WebGL, geometryFigure, uniforms), transform);
    let wireframe = new GeometryPainter(gl, new SolidColor(gl, WebGL, geometryFigure, [.24,.24,.24,1]), transform);

    let check_controls = document.getElementById("right-options");
    let checkboxShading = new Checkbox(check_controls, "sombreado", "Sombreado", draw, false);

    var fov = 80;
    if(window.innerWidth < window.innerHeight)
        fov = 120;

    let zNear = .1;
    let zFar = 2000;
    let camera = new TrackballCamera( new V3(0,1,5));
    camera.setZoomConfig(7.5,4.5);
    resize(canvas);
    
    gl.enable(gl.DEPTH_TEST);

    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    
    draw();
    
    function draw(){        
        resize(canvas);
        var {width, height} = gl.canvas;
        if(checkboxShading.checked()){
            gl.clearColor(0, 0, 0, 1);
            check_controls.setAttribute("obscure-mode", "true");
        }
        else{
            gl.clearColor(0, 0, 0, 0);
            check_controls.setAttribute("obscure-mode", "false");
        }
            
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
             
        let aspect = width/height;
        var projectionMatrix = M4.perspective(fov, aspect, zNear, zFar);

        let viewMatrix = camera.getMatrix();
        if(checkboxShading.checked()){
            var lightDir = M4.multiplyVector(viewMatrix, lightDirection);
            uniforms.u_light.direction = lightDir;
            figure.draw(gl, viewMatrix, projectionMatrix, uniforms);   
        }else{
            wireframe.drawWireframe(gl, viewMatrix, projectionMatrix);   
        }
       
    }
}