import {resize, Slider, Checkbox, createResetButton} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M3 from "../../modules/M3.js";
import Grid from "../../geometry/Grid.js";
import V2 from "../../modules/V2.js";
import Vector2D from "../../geometry/Vector2D.js";

/**
 * Transformación de Traslación.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);
var vsh = `#version 300 es
            uniform vec2 u_translation;
            //Para ajustar los puntos dentro del clipspace
            uniform mat3 u_projection;
            
            in vec4 a_color; 
            in vec2 a_position;
            
            out vec4 color;

            void main(){
                color = a_color;
                
                vec2 tPosition = a_position + u_translation;
                vec3 resizedPos = u_projection * vec3(tPosition,1);
              
                gl_Position = vec4(resizedPos.xy, 0, 1);
            }
            `;
var fsh = `#version 300 es
            precision highp float;
            
            in vec4 color;
            
            out vec4 glColor;
            
            void main(){
                glColor = color;
            }
            `;
var translation = [0,0];

function main(){
    document.body.style.backgroundColor = "white"; 
    var canvas = document.getElementById("gl_canvas");    
    var gl = WebGL.init(canvas);
    if(!gl) return;

    var program = WebGL.createProgram(gl,vsh,fsh);

    var attributes = {  position:   { numComponents: 2,
                                      data: [  0,   0,
                                             100,   0, 
                                               0, 100]},
                          color:    { numComponents: 4, 
                                      type: gl.UNSIGNED_BYTE, 
                                      normalize: true, 
                                      dataType: Uint8Array,
                                      data: [ 22, 177, 176, 255,
                                                 22, 164, 133, 255,
                                                129, 90, 134, 255 ]}
                    };

    var vao = WebGL.setVAOAndAttributes(gl, program, attributes);    

    var projectionU = gl.getUniformLocation(program, "u_projection");
    var translationU = gl.getUniformLocation(program, "u_translation");

    //Grid
    resize(canvas);
    const unit = 50;
    const gridColor = [175, 167, 206, 255];
    const axisColor = [81, 56, 93, 255];
    var grid = new Grid(gl, unit);
    var gridBasis = new Grid(gl, unit, true, null, [gridColor, axisColor]);
    
    //HTML CONTROLS
    let controls = document.getElementById("ui-container");
    controls.className = "right-box";

    const offset = 100;
    var widthL = .4 * gl.canvas.width;
    var widthR = .6 * gl.canvas.width;
    var heightT = .6 *gl.canvas.height;
    var heightB = .4 *gl.canvas.height;

    let sliderX = new Slider(controls, "T<sub>x</sub>", - widthL, widthR - offset, updateTranslation(0), translation[0], 1);
    let sliderY =  new Slider(controls, "T<sub>y</sub>", - heightB, heightT - offset, updateTranslation(1), translation[1], 1);
    
    
    let checkbox = new Checkbox(controls, "Grid", "Cuadrícula", draw);
    let checkboxBasis = new Checkbox(controls, "Grid", "Cuadrícula Transformada", draw);

    createResetButton(reset);

    draw();

    window.addEventListener('resize', draw);

    function draw(){
        resize(canvas);

        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clearColor(0, 0, 0, 0);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        gl.useProgram(program);

        gl.bindVertexArray(vao);

        let boundary = { l: -.4*width, r: .6*width ,
                            t: .6*height, b: -.4*height};
        
        var projectionMatrix =  M3.projection(boundary.l, boundary.r, boundary.t, boundary.b);
        gl.uniformMatrix3fv(projectionU, false, projectionMatrix);
        gl.uniform2fv(translationU, translation);

        gl.drawArrays(gl.TRIANGLES,0,3);
       
        //Grid
        if(checkboxBasis.checked()){
            let boundaryT = { l: (-.4 - translation[0]/width)*width , r: (.6- translation[0]/width)*width,
                                t: (.6- translation[1]/height)*height, b: (-.4- translation[1]/height)*height};
            console.log(translation[0]/width);
            gridBasis.draw(gl, boundaryT);
        }
        if(checkbox.checked())
            grid.draw(gl, boundary);
    }
    function updateTranslation(index){
        return function(value){
            translation[index] = value;
            draw();
        };
    }
    function reset(){
        translation = [0,0];
        sliderX.updateSlider(translation[0]);
        sliderY.updateSlider(translation[0]);
        draw();
    }
}