import {resizeContainer2D} from "../../modules/HTMLUtils.js";
/**
 * Diagrama de mapeo ambiental. Corrección del vector de reflexión.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    let diagram1 = document.getElementById("diagram1");

    let angle = 40;
    let time = 0;
    const wait_time = .7;

    window.addEventListener('resize', render);
    requestAnimationFrame(render);

    function render(){
        resizeContainer2D();
        diagram1.style.transform = `rotate(${-1*angle}deg)`;

        if(angle <= 0 && time <= wait_time){
            time += 0.01;
        }
        else{
            if(time > 0)
                angle = 40;
            time = 0;
            angle = (angle - 0.1) % 40; 
        }
        
        requestAnimationFrame(render);
    }
}