"use strict";

import {resize, resizeAndCenterX, Select, Slider, TextBox} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import ProceduralTexture from "../../materials/ProceduralTexture.js";
import {Cube, Sphere} from "../../geometry/Figure.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import Light from "../../geometry/Light.js";
import Teapot from "../../geometry/Teapot.js";

/**
 * Mapeo de texturas procedurales geométricas (básicas).
 * MODO 0: coordenadas de textura.
 * MODO 1: coordenadas de superficie.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let textureIds = { ajedrez: 0, líneas: 1, enrejado: 2, círculos: 3,  flor: 4};
    let objectIds = { "cubo": 0,  "tetera": 1};
    
    let lightPosition = [0, 1, 2.3, 0];
    let uniforms = { u_light: { position: lightPosition, la: [0.2,0.2,0.2], ld: [1, 1, 1],
                                                        ls: [0.9, 0.9, 0.7]}};
    let figuresGeom = [ new Cube(1), new Teapot()];
    
    let materials = [];
    for(var i= 0; i < figuresGeom.length; i++)
        materials.push( new ProceduralTexture(gl, WebGL, figuresGeom[i], uniforms)); 
    
    let scale = M4.scale(.5,.5,.5);
    let figures = [ new GeometryPainter(gl, materials[0], scale),
                    new GeometryPainter(gl, materials[1], M4.scale(.3,.3,.3))
                  ];
    let t = [.45, .5];
    var pos = new V3(0,0,.85);
    let camera = new TrackballCamera(pos);
    camera.setZoomConfig(1.2, .8);
    let bulb = new Light(gl, WebGL, lightPosition, .5);
    let right_controls = document.getElementById("right-options");
    let up_controls = document.getElementById("ui-container-up");
    let selectObject= new Select(right_controls, "coords", setObject, objectIds, "cubo");
    let objId = 0;
    let selectTexture = new Select(right_controls, "textures", setTextureId, textureIds, "enrejado");
    let scaleFactorSlider = new Slider(up_controls, "Escalar", 1, 15, updateScaleFactor, 14.5, 0.1, ["#4994D0"]);
   
    let texcoordLabel = new TextBox(container, {}, "Coordenadas 2D");
    let objectLabel = new TextBox(container, {}, "Coordenadas 3D");
    
    uniforms.coord_type = 0;
    uniforms.texture_type = 2;
    uniforms.scale_factor = 14.5;

    gl.enable(gl.DEPTH_TEST);
    gl.clearColor(0, 0, 0, 0);
    
    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    draw();

    function draw(){        
        resize(canvas);
        resizeAndCenterX(up_controls, 0);
        
        var {width, height} = gl.canvas;
        
        texcoordLabel.setPosition({bottom: 2, left:15});
        objectLabel.setPosition({bottom: 2, left: 60});
        
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        let aspect = width/height;
        var projectionMatrix = M4.perspective(85, aspect, .1, 100);
        var viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        
        uniforms.u_light.position = lightPos;
        console.log(figures[objId])
        uniforms.coord_type = 0;
        figures[objId].draw(gl, M4.multiply(viewMatrix, M4.translate(-t[objId],-.1,0)), projectionMatrix, uniforms);
        uniforms.coord_type = 1;
        figures[objId].draw(gl, M4.multiply(viewMatrix, M4.translate(t[objId],-.1,0)), projectionMatrix, uniforms);
        
        //bulb.draw(gl, M4.multiply(viewMatrix, M4.scale(.5, .5, .5)), projectionMatrix, lightPosition);
    }
    function setObject(value){
        objId = objectIds[value];
        draw();
    }    
    function setTextureId(value){
        uniforms.texture_type = textureIds[value];
        draw();
    }
    function updateScaleFactor(value){
        uniforms.scale_factor = value;
        draw();
    }
} 