"use strict";

import {resize, Select, addLabel, scaleToFitContainer, resizeAndCenterX} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import Texture from "../../materials/Texture.js";
import {Plane} from "../../geometry/Figure.js";
/**
 * Función de correspondencia: Texture wrapping. 
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
   
    let planeFigure = new Plane();
    let srcTexture = "../../../images/capitulo_07/fave.png";
    //planeFigure.setTexcoords( [-4,-4, 5,-4, 5,5, -4,5]);
    planeFigure.setTexcoords( [-1,-1, 2,-1, 2,2, -1,2]);
    let material =  new Texture(gl, WebGL, planeFigure, srcTexture, setTexture); 
    
    let wrapping_modes = { CLAMP: gl.CLAMP_TO_EDGE, REPEAT: gl.REPEAT, MIRROR: gl.MIRRORED_REPEAT, BORDER: gl.CLAMP_TO_EDGE};

    let controls = document.getElementById("ui-container-center");
    controls.className = "big-bottom-box";
    

    let u_control = document.getElementById("u-mode");
    let v_control = document.getElementById("v-mode");

    var wrapU = gl.CLAMP_TO_EDGE;
    var wrapV = gl.CLAMP_TO_EDGE;
    
    /* Selects */
    addLabel(u_control, "coordenada u:");
    let selectUMode = new Select(u_control, "U", setMode(0), wrapping_modes,"BORDER");
    addLabel(v_control, "coordenada v:");
    let selectVMode = new Select(v_control, "V", setMode(1), wrapping_modes,"BORDER");
    setMode(0)("BORDER");
    setMode(1)("BORDER");
    var loadedTexture;
    
    gl.enable(gl.DEPTH_TEST);
    
    gl.clearColor(0, 0, 0, 0);
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);

    window.addEventListener('resize', draw);
    
    draw();

    function draw(){        
        resizeAndCenterX(controls, {bottom: -3});
        resize(canvas);
        var {width, height} = gl.canvas;

        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
             
        let aspect = width/height;
        var projectionMatrix = M4.perspective(90, aspect, .1, 100);

        gl.useProgram(material.program);
        gl.bindVertexArray(material.vao);
      
        let matrix = M4.multiply(projectionMatrix, M4.translate(0,.1,-.7)); 
        material.uniforms.u_PVM_matrix = matrix;
          
        if(loadedTexture){
            material.uniforms.u_texture = {id:0, texture: loadedTexture};
        } 
        material.setUniforms(material.uniforms);
        
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, wrapU);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, wrapV);
        
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, material.indexBuffer);
        gl.drawElements( gl.TRIANGLES, material.numIndices,  gl.UNSIGNED_SHORT, 0);
       // gl.drawArrays(gl.TRIANGLES, 0, material.numElements);
    
        gl.bindBuffer(gl.ARRAY_BUFFER, null);      
    }
    function setMode(index){
        return function(value){
            if(!index){
                wrapU = wrapping_modes[value];
                material.uniforms.clamp_to_border_S = (value == "BORDER") ? 1.0 : 0.0;
            }
            else{
                wrapV = wrapping_modes[value];
                material.uniforms.clamp_to_border_T = (value == "BORDER") ? 1.0 : 0.0;
            }    
            draw();
        }
    }
    function setTexture(texture){
        loadedTexture = texture;
        draw();
    }
} 