/**
 * Programa de sombreado que asigna un color por vértice.
 * @author Melissa Méndez Servín.
 */
export default class VertexColor {

    constructor(gl, WebGL, figure, eight_bits){
        var vsh = `#version 300 es
            uniform mat4 u_PVM_matrix;
        
            in vec4 a_position;
            in vec4 a_color;
        
            out vec4 v_color;

            void main(){

                v_color = a_color;

                gl_Position =  u_PVM_matrix * a_position;
            }
            `;
        var fsh = `#version 300 es
            precision highp float;

            in vec4 v_color;
            
            out vec4 glColor;
            
            void main(){
                glColor = v_color;
            }
            `; 
        if (WebGL.programs["VertexColor"])
            this.program = WebGL.programs["VertexColor"];
        else
            this.program = WebGL.createProgram(gl, vsh, fsh, "VertexColor");
        

        let colorConstructor  = { numComponents: 4,
                                           data: figure.colors};
        if(eight_bits){
            colorConstructor = Object.assign( {}, 
                                colorConstructor,
                                { type: 5121, 
                                normalize: true, 
                                dataType: Uint8Array});
        }
        
        let attributes = {  position: { numComponents: 3, 
                                data: figure.getVertices(),
                                        }, 
                               color: colorConstructor
                         };
        if(figure.byIndices){
            let vaoAndIndices = WebGL.setVAOAndAttributes(gl, this.program, attributes, figure.getFaces());
            this.vao = vaoAndIndices.vao;
            this.indexBuffer = vaoAndIndices.indexBuffer;
            this.numIndices = figure.numIndices;
        }else{
            this.vao = WebGL.setVAOAndAttributes(gl, this.program, attributes);  
            this.numElements = attributes.position.data.length/3;
        }
        
        this.setUniforms = WebGL.setUniforms(gl, this.program);
        this.uniforms = {};
    }
}