"use strict";

import {Button, MathBox, resizeContainer2D} from "../../../modules/HTMLUtils.js";

/**
 * Sistema de dos ecuaciones con dos incógnitas.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

let index = 0;
let max_index;
function main(){
    //HTML CONTROLS
    let controls = document.getElementById("ui-container");
    controls.className = "vertical-bttns-box";
    let image = document.getElementById("image-patch");
    
    //HTML CONTROLS
    let buttons = [ new Button(controls, upadateStep(-1), "Prev", null, true),
                    new Button(controls, upadateStep(1), "Sig"),
                    new Button(controls, reset, "Reset")];

    let container =  document.getElementById("container2D");
    let description = new MathBox(container, {top:0, left:0});
    let infoByIndex = [ "\\text{Se definen los puntos de control } P^0_{ij} \\text{de un parche}" + 
                        "\\\\ \\text{de Bézier de grado } (3\\times4).", 
                        "\\text{Primero se calculan los puntos } P^1_{ij} \\text{ usando interpolación }\\\\" +
                         "\\text{bilineal entre los puntos cercanos} P^0_{ij}.",
                         "\\text{Con los cuales se forma un parche de Bézier de grado } (2\\times3).", 
                         "\\text{Se repite el proceso con los puntos }P^1_{ij}, \\text{ describiendo un nuevo} \\\\" +
                         "\\text{parche de Bézier de grado }(1\\times2) \\text{ conformado por los puntos } P^2_{ij}.",
                        "\\text{Se vuelve a aplicar interpolación bilineal entre los puntos cercanos} \\\\" + 
                        " P^2_{ij}, \\text{ obteniendo dos puntos intermedios }P^3_{ij}.", 
                        "\\text{Finalmente se obtiene al punto final sobre la superfice } P^4_{00} \\\\" +
                        "\\text{haciendo una interpolación lineal entre los puntos }P^3_{ij}."
                    ];
    let src_images = ["special-patch-1.svg", "special-patch-2-1.svg", "special-patch-2.svg",
                      "special-patch-3.svg", "special-patch-4.svg", "special-patch-5.svg"];
    max_index = src_images.length -1;
    window.addEventListener('resize', draw);
    
    draw();

    function draw(){
        resizeContainer2D();
        image.src = src_images[index];
        description.setText(infoByIndex[index]);
    }
    function upadateStep(button){
        return function(){
            if (index + button < 0 || index + button > max_index)
                return;
            index += button;

            buttons[0].updateState(index, 1, max_index);
            buttons[1].updateState(index, 0, max_index-1);
            draw(); 
        }
    }
    function reset(){
        index = 0;
        buttons[0].updateState(index, 1, max_index);
        buttons[1].updateState(index, 0, max_index-1);
        draw();
    }
}