import {resizeContainerAndCanvas, createButton} from "../../modules/HTMLUtils.js";
import CtxUtils from "../../modules/Context2DUtils.js";
import V2 from "../../modules/V2.js"; 

/**
 * Rotación de un punto en 2D.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

const vPrimeColor = "rgb(65, 172, 196)";
const vColor = "rgb(119, 167, 114)";
const basisColor = "rgb(19, 41, 61)";
function main(){
    document.body.style.backgroundColor = "white"; 
    const canvas = document.getElementById("canvas");
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";

    //HTML CONTROLS
    let buttons = [ createButton(controls, upadateStep(-1), "Prev", true),
                    createButton(controls, reset, "Reset", true),
                    createButton(controls, upadateStep(1), "Sig", true)];
    buttons[0].disabled = true;

    resizeContainerAndCanvas(canvas);
    var step = 0;
    let {width, height} = canvas;
    var origin = new V2(.2 * width, .69 *  height); 
    var axes = { origin: origin, x: new V2(.14 * width, .8 * width), y: new V2(0.74 * height, .1 * height)};
    
    var initialPos =  new V2(.65 * width, .45 *  height);
    var radius = initialPos.sub(origin).length() + 2;
    var vectorV = initialPos;  
     
    const arrowThickness = 2.3;
    //Para la animación
    var current = 0;
    var elapsed = 0;
    var lastTime = Date.now();
    let max_elapsed_wait = 80/1000;
    let t_time = 0;
    let time_step = 0.05;
    var animation = true;
    var t = 0;
    // Ángulo phi
    const phiTop = 25;
    var phi = t * (Math.PI / 180);
    
    var thetaphi; //= theta + phi;
    var pointR; //= new V2( origin.x + (radius * Math.cos(thetaphi)), origin.y - (radius * Math.sin(thetaphi)));

    draw();
    window.addEventListener('resize', draw);
    
    function draw(){
        resizeContainerAndCanvas(canvas);
        
        let {width, height} = canvas;
        origin = new V2(.29 * width, .65 *  height); 
        axes = { origin: origin, x: new V2(.24 * width, .85 * width), y: new V2(0.7 * height, .1 * height)};
    
        initialPos = new V2(.73 * width, .43 *  height);
        radius = initialPos.sub(origin).length() + 2;
        vectorV = initialPos;  
        var vectorRad = vectorV.movePoints(-.33 * vectorV.x, .18 * vectorV.y); 

        // Ángulo thetha
        var co = origin.y - vectorV.y;
        var ca = vectorV.x- origin.x; 
        var theta = Math.atan(co/ca);

        current = Date.now();
        elapsed = (current - lastTime) / 1000;
        if (elapsed > max_elapsed_wait) {
            elapsed = max_elapsed_wait;
        }
        //Utils.resizeContainer2D();
        CtxUtils.clear();
        // Ejes y plano
        CtxUtils.drawAxes(axes, 3, basisColor);
        disableButtons(false);
        if(step == 0)
            buttons[0].disabled = true;
        if (step < 3){
            var dashPointX = new V2( vectorV.x, origin.y);
            var dashPointY = new V2( origin.x, vectorV.y);
            if (step < 2) animation = true;

            if (step > 0){
                CtxUtils.drawArc(origin, radius ,-theta, 0, vColor, 2);
                CtxUtils.putText("θ", 19, 1.07 * vectorV.x, 1.3 * vectorV.y - 12, vColor);
            }
            if (step == 2){
                //Calculamos phi
                if (t <= phiTop && animation){ //Animación
                    if (t_time > time_step) {
                        t = (t+1);
                        t_time = 0;
                      }
                    t_time += elapsed;
                    lastTime = current;
                    phi = t * (Math.PI / 180);
                    thetaphi = theta + phi;
                    pointR = new V2( origin.x + (radius * Math.cos(thetaphi)), origin.y - (radius * Math.sin(thetaphi)));
                    disableButtons(true);
                }  
                else{
                    animation = false;
                    t = 0;
                    phi = phiTop * (Math.PI / 180);
                    thetaphi = theta + phi;
                    pointR = new V2( origin.x + (radius * Math.cos(thetaphi)), origin.y - (radius * Math.sin(thetaphi)));
                } 
                CtxUtils.drawArc(origin, radius , -thetaphi, -theta, vPrimeColor,2);

                let dashRPointX = new V2( pointR.x, origin.y);
                let dashRPointY = new V2( origin.x, pointR.y);
                CtxUtils.drawDashLine(dashRPointX, pointR, [5,5], 2, vPrimeColor);
                CtxUtils.drawDashLine(dashRPointY, pointR, [5,5], 2, vPrimeColor);
                
                var phiPos = new V2(pointR.x + 4 - .65 * (pointR.x - vectorV.x), pointR.y - 12 + .53 * (vectorV.y - pointR.y));
                CtxUtils.drawArrow(origin, pointR, arrowThickness, vPrimeColor);
                CtxUtils.putText("v'", 20, pointR.x + 12, pointR.y - 12, vPrimeColor);
                CtxUtils.putText("φ", 19, phiPos.x, phiPos.y); 
                CtxUtils.putText("y'", 20, dashRPointY.x - 20, dashRPointY.y, vPrimeColor);
                CtxUtils.putText("x'", 20, dashRPointX.x - 5, dashRPointX.y + 25, vPrimeColor);
                vectorRad = pointR.movePoints(-.33 * pointR.x, .18 * phiPos.y - .45 * (pointR.y - vectorV.y)); 
            }
            //Radius
            CtxUtils.putText("r", 20, vectorRad.x, vectorRad.y);

            //Vector v
            CtxUtils.drawArrow(origin, vectorV, arrowThickness, vColor);
            CtxUtils.drawDashLine(dashPointX, vectorV, [5,5], 2, vColor);
            CtxUtils.putText("y", 20, dashPointY.x - 20, dashPointY.y, vColor);
            CtxUtils.putText("x", 20, dashPointX.x - 5, dashPointX.y + 25, vColor);
            CtxUtils.drawDashLine(dashPointY, vectorV, [5,5], 2, vColor);
            CtxUtils.putText("v", 20, vectorV.x + 12, vectorV.y - 12, vColor);
            if (animation){
                window.requestAnimationFrame(draw);
            }
        }
        if(step == 3){
            buttons[2].disabled = true;
            animation = true;
            //Vector v' (rotado)
            CtxUtils.drawArrow(origin, pointR, arrowThickness, vPrimeColor);
            CtxUtils.drawArc(origin, radius , -thetaphi, 0, vPrimeColor,2);
            CtxUtils.putText("v'", 20, pointR.x + 12, pointR.y - 12, vPrimeColor);
            CtxUtils.putText("(θ + φ)", 19, vectorV.x + 12, vectorV.y - 12, vPrimeColor);
        }
    }
    function upadateStep(button){
        return function(){
            if (step + button < 0 || step + button > 3)
                return;
            step += button;
            draw(); 
        }
    }
    function reset(){
        step = 0;
        vectorV =  initialPos;   
        draw();
    }
    function disableButtons(disable){
        for(var i = 0; i < 3; i++)
            buttons[i].disabled = disable;
    }
}
