import {resizeContainerAndCanvas, SliderOnly, setElementPosition} from "../../modules/HTMLUtils.js";
import CtxUtils from "../../modules/Context2DUtils.js";
import V2 from "../../modules/V2.js"; 

/**
 * Relación entre el ángulo de visión y la distancia focal.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

var d = -20;
const LINE_COLOR = "#FF7F50";
function main(){
    document.body.style.backgroundColor = '#FFFFFF';
    var canvas = document.getElementById("canvas");
    resizeContainerAndCanvas(canvas);

    let controls = document.getElementById("ui-container");

    const {width, height} = canvas;
    var camera = { h: height/8, base: Math.floor(width /110)};

    //HTML CONTROLS
    const colors = ["#DFD7CB", "#FFA62F"];
    let sliderD = new SliderOnly(controls, "d", -50, -5, updateD, d, 1, colors);
    setElementPosition(controls, {left: 14, top: 50});
    
    var side_candle = new Image();
    side_candle.onload = draw;
    side_candle.src = "../../../images/capitulo_01/perfil_vela.svg";
    
    var front_candle = new Image();
    front_candle.onload = draw;
    front_candle.src = "../../../images/capitulo_01/frente_vela.svg";

    window.addEventListener('resize', draw);
    draw();

    function draw(){
        resizeContainerAndCanvas(canvas);
        CtxUtils.clear();

        var {width, height} = canvas;
        camera = { h: height/8, base: Math.floor(width /110)};
        var candle_svg = { sw: camera.h * 1.5, sh: camera.h * 2, w:416, h: 567};
        var rec = {x: 0.07 * width, y: height - 1.1* candle_svg.sh};
        //Centro de la cámara
        var pinhole = new V2(0.5 * width , 0.36 * height);
        //Ejes Y y Z
        var y = new V2(pinhole.x ,pinhole.y - (camera.h * 1.5));
        var z = new V2(pinhole.x + 100 , pinhole.y);
        var candle_pos = new V2(pinhole.x + 145, pinhole.y - candle_svg.sh/2);

        //Dibuja la vela
        CtxUtils.ctx.drawImage(side_candle, candle_pos.x, candle_pos.y, candle_svg.sw, candle_svg.sh);
        //Dibuja ejes Y y Z
        CtxUtils.drawUpArrow(pinhole, y, "black", 1.5, "y");
        CtxUtils.drawRightArrow(pinhole, z, "black", 1.5, "z");
        
        //Caja
        CtxUtils.drawCircle(pinhole, 2, "black");
        camera.w = camera.base * -1*d;
        var upCorner = new V2(pinhole.x - camera.w, pinhole.y - camera.h/2);
        var bottomCorner = new V2(pinhole.x - camera.w, pinhole.y + camera.h/2);
        CtxUtils.drawRect(upCorner, camera.w, camera.h, "black", 2);
        var dz = {x: pinhole.x - camera.w , y: pinhole.y};
        CtxUtils.drawDashLine(pinhole, dz, [5,5]);
           
        // d
        CtxUtils.drawDistanceH(bottomCorner.movePoints(0,18), bottomCorner.movePoints(camera.w ,18), "d");
        // h
        CtxUtils.drawDistanceV(upCorner.movePoints(-15 ,0), bottomCorner.movePoints(-15,0), "h");
        
        // tv = t(pinhole - corner) 
        const t = 15;
        var pU = pinhole.sub(upCorner).scale(t);
        var u = pU.add(upCorner);
        var pB = pinhole.sub(bottomCorner).scale(t);
        var w = pB.add(bottomCorner);

        CtxUtils.drawDashLine(upCorner, pinhole, [5,5], 1, LINE_COLOR);
        CtxUtils.drawDashLine(bottomCorner, pinhole, [5,5], 1, LINE_COLOR);
        // angle = 2 tan(h/2d)
        var angle = 2* Math.atan(camera.h/(2*camera.w));
        CtxUtils.drawArc(pinhole,85,-angle/2,angle/2);
        //símbolo theta 
        var theta = z.movePoints(-10,-11);
        CtxUtils.putText("θ", 14, theta.x, theta.y);

        CtxUtils.drawLine(pinhole, u, 1.35, LINE_COLOR);
        CtxUtils.drawLine(pinhole, w, 1.35, LINE_COLOR);
        CtxUtils.drawTriangle(pinhole, u, w, 1.35, "rgba(0,0,0,0)", "rgb(251, 185,	23, 0.1)");
        
        //Ventana de visión 
        //CtxUtils.drawRect(rec, candle_svg.sw, candle_svg.sh, "black", 1);
        //Calculamos los puntos de intersección entre el svg escalado y las líneas guías del ángulo de visión
        var r = 145 + candle_svg.sw/2;

        var candle_p1 = new V2(r*Math.cos(-angle/2), r*Math.sin(-angle/2));
        candle_p1 = pinhole.add(candle_p1);
        var candle_p2 = new V2(r*Math.cos(angle/2), r*Math.sin(angle/2));
        candle_p2 = pinhole.add(candle_p2);

        //Calculamos h, la mitad de altura entre los puntos de intersección (sección visible del svg escalado)
        var h = (candle_p2.y - candle_p1.y)/2;
        //Calculamos el punto medio del svg (paralelo a h)
        var candle_middle = new V2(candle_p1.x, candle_pos.y + candle_svg.sh/2);
        
        /* Test: CtxUtils.drawCircle(candle_middle.movePoints(0,+h), 5, "black");
        CtxUtils.drawLine(candle_p1, candle_p2, 1, "black");*/
        
        //Calculamos la altura equivalente a h en el svg original, es decir, 
        //H = (altura original del svg)/(altura de la escala del svg) * h
        var H = (candle_svg.h/candle_svg.sh)*(h);
        // Comenzamos a dibujar desde la altura respectiva del centro del svg - H, con 2*H de altura, 
        // el ancho se calcula de manera similar + tanteo 
        CtxUtils.ctx.drawImage(front_candle, (candle_svg.w/2)-(0.8*H), (candle_svg.h/2)-H, 1.5*H,2*H, rec.x, rec.y, candle_svg.sw, candle_svg.sh);
        CtxUtils.drawRect(rec, candle_svg.sw, candle_svg.sh, "black", 1);
    }
    function updateD(value){
        d = value;
        draw();
    }
}