"use strict";

import {resize, MathBox} from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M4 from "../../../modules/M4.js";
import Diffuse from "../../../materials/Diffuse.js";
import SolidColor from "../../../materials/SolidColor.js";
import Vector3D from "../../../geometry/Vector3D.js";
import Line3D from "../../../geometry/Line3D.js";
import {Sphere, RectangularPrism} from "../../../geometry/Figure.js";
import {getPixel3DPosition} from "../../../modules/MathUtils.js";
import GeometryPainter from "../../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../../modules/Trackballcamera.js";
import V3 from "../../../modules/V3.js";

/**
 * Plano.
 * @author Melissa Méndez Servín.
 * */
 window.addEventListener("load", main);
 
 function main(){
     var canvas = document.getElementById("gl_canvas");
     var gl = WebGL.init(canvas);
     if(!gl) return;
 
     let lightPosition = [2, 3, 3, 0];
     let diffuseUniforms = { u_light_position: lightPosition}; 
     let sColor = { u_color: [.8,.8,.8,1] };
     let pColor = { u_color: [.4,.4,.5,1]}
     let sPoint = new V3(-1.2,0.5,-1);
     let d1_label = new MathBox(container, {}, "\\mathbf{d}_1");
     let d2_label = new MathBox(container, {}, "\\mathbf{d}_2");
     let p_label = new MathBox(container, {}, "P");
     let s_label = new MathBox(container, {}, "S");
     //Flechas
     let t1_vec = new V3(.1,0,1.8);
     let t2_vec = new V3(1.8,0,.4);
     let d1_vec = t1_vec.normalize();
     let d2_vec = t2_vec.normalize();
     let point_vec = t1_vec.add(t2_vec);
     let correct_point = sPoint.add(point_vec);
     let translatePoint = M4.translate(correct_point.x , correct_point.y, correct_point.z);
     let d1Arrow = new Vector3D(gl, WebGL, d1_vec, sPoint, .1, [1,.2,.3,1], lightPosition, d1_label);
     let d2Arrow = new Vector3D(gl, WebGL, d2_vec, sPoint, .1, [0,.6,.4,1], lightPosition, d2_label); 
 
     let s = new GeometryPainter(gl, new Diffuse(gl, WebGL, new Sphere(.07, 30, 30), sColor));
     let point = new GeometryPainter(gl, new Diffuse(gl, WebGL, new Sphere(.07, 30, 30), pColor));
     //Plano
     var rect = new RectangularPrism(4.5,.02,4.5,true);
     let plane = new GeometryPainter(gl, new SolidColor(gl, WebGL, rect, [.8,.9,1,1]), M4.translate(0,sPoint.y,0));    
 
     //Lineas
     let lineD1ToT1 = new Line3D(gl, WebGL, new V3(0,0,0), t1_vec, sPoint, .025, [0,0,0,1]);
     let lineD2ToT2 = new Line3D(gl, WebGL, d2_vec, t2_vec, sPoint, .025, [0,0,0,1]);
     let lineT1ToP = new Line3D(gl, WebGL, t1_vec, point_vec, sPoint, .025, [0,0,0,1]);
     let lineT2ToP = new Line3D(gl, WebGL, t2_vec, point_vec, sPoint, .025, [0,0,0,1]);
 
     var fov = 80;  
     if(window.innerWidth < window.innerHeight)
         fov = 120;
 
     let zNear = .1;
     let zFar = 2000;
     let pos = M4.multiplyVector(M4.rotateY(-90), [1.2,1.1,2.5,1]);
     let camera = new TrackballCamera(new V3(pos[0],pos[1],pos[2]));
     camera.setZoomConfig(4.5,2.3);
     resize(canvas);
 
     gl.enable(gl.DEPTH_TEST);
     gl.enable(gl.CULL_FACE);
     gl.clearColor(0, 0, 0, 0);
 
     window.addEventListener('resize', draw);
     registerCameraEvents(camera, canvas, draw);
 
     draw();
 
 
     function draw(){        
         resize(canvas);
         var {width, height} = gl.canvas;
 
         gl.viewport(0, 0, width, height);
         gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
 
         let aspect = width/height;
         var projectionMatrix = M4.perspective(fov, aspect, zNear, zFar);
 
         let viewMatrix = camera.getMatrix();
         var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
         diffuseUniforms.u_light_position = lightPos;
 
         d1Arrow.draw(gl, viewMatrix, projectionMatrix, lightPos);
         d2Arrow.draw(gl, viewMatrix, projectionMatrix, lightPos);
 
         let sVM = M4.multiply(viewMatrix, M4.translate(sPoint.x, sPoint.y, sPoint.z));
         s.draw(gl, sVM, projectionMatrix, diffuseUniforms);
 
         let pointVM = M4.multiply(viewMatrix, translatePoint);
         point.draw(gl, pointVM, projectionMatrix, diffuseUniforms);
 
         let s_label_pos = getPixel3DPosition(gl, M4.multiply(projectionMatrix, sVM), -25, -10); 
         s_label.setPosition(s_label_pos);
         let p_label_pos = getPixel3DPosition(gl, M4.multiply(projectionMatrix, pointVM), 7, -10); 
         p_label.setPosition(p_label_pos);
 
         lineD1ToT1.draw(gl, viewMatrix, projectionMatrix);
         lineD2ToT2.draw(gl, viewMatrix, projectionMatrix);
         lineT1ToP.draw(gl, viewMatrix, projectionMatrix);
         lineT2ToP.draw(gl, viewMatrix, projectionMatrix);
         plane.draw(gl, viewMatrix, projectionMatrix);
     }
 
 } 