export default class Particle {
  constructor(x=0, y=0) {
    this.x = x;
    this.y = y;

    this.velocity = {
      x : -1 + 2*Math.random(),
      y : -1 + 2*Math.random()
    }
    this.acceleration = {
      x : 0.001,
      y : 0.001
    }

    this.fillStyle = `rgba(${parseInt(255*Math.random())}, ${parseInt(255*Math.random())}, ${parseInt(255*Math.random())}, ${0.2 + Math.random()})`;

    this.life = 0;
  }

  update() {
    this.velocity.x += this.acceleration.x;
    this.velocity.y += this.acceleration.y;

    this.x += this.velocity.x;
    this.y += this.velocity.y;

    this.life++;
  }

  draw(ctx) {
    ctx.fillStyle = this.fillStyle;
    ctx.beginPath();
    ctx.arc(this.x, this.y, 10, 0, (Math.PI * 2), true);
    ctx.fill();
  }
}
