"use strict";

import {resize, Color, Slider, hexToRgbNormalized, DarkMode, TextBox, Select} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import {Cube, Sphere} from "../../geometry/Figure.js";
import Teapot from "../../geometry/Teapot.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import SolidColor from "../../materials/SolidColor.js";
import Bunny from "../../geometry/Bunny.js";

/**
 * Modelo de luz ambiental.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
   
    let sphereFigure = new Sphere(1, 30,30);
    let cubeFigure = new Cube(1.3);
    let teapotFigure = new Teapot();
    let bunnyFigure = new Bunny();

    let colorUniform = {u_color: [0.2, 0.588, 1,1]};
    
    let figures = { 
        tetera: new GeometryPainter(gl, new SolidColor(gl, WebGL, teapotFigure, colorUniform)),
        esfera : new GeometryPainter(gl, new SolidColor(gl, WebGL, sphereFigure, colorUniform)),
        conejo: new GeometryPainter(gl, new SolidColor(gl, WebGL, bunnyFigure, colorUniform)),
        cubo: new GeometryPainter(gl, new SolidColor(gl, WebGL, cubeFigure, colorUniform))};
    let selectedFigure = figures.tetera;  
    
    var fov = 90;
    let zNear = 1;
    let zFar = 100;
    var pos = new V3(0,1.4,2.3);
    let camera = new TrackballCamera(pos);
    
    var kA = 0.3;
    var LA = colorUniform.u_color;
    var intensity;

    let controls = document.getElementById("ui-container");
    controls.className = "big-bottom-box";
    var kA_slider = new Slider(controls, "k<sub>A</sub>", 0, 1, upadeteKA, kA, 0.01, ["#4994D0"]);
    var ambient_color = new Color(controls, "L<sub>A</sub>", setColor, "#3396FF"); 
    let darkMode = new DarkMode(draw, [controls]);
    
    let ccLabel = new TextBox(container, { left: 2, top: 3}, "", "author-small");

    /* Selects */
    let right_controls = document.getElementById("right-options");
    let selectFigure = new Select(right_controls, "figures", setFigure, figures);
  
   
    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.CULL_FACE);
    
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    
    draw();

    function draw(){        
        resize(canvas);
        var {width, height} = gl.canvas;

        darkMode.check(gl);

        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
             
        let aspect = width/height;
        var projectionMatrix = M4.perspective(fov, aspect, zNear, zFar);
        let viewMatrix = camera.getMatrix();
        
        intensity = [kA * LA[0], kA * LA[1], kA * LA[2], 1.0];
        colorUniform.u_color = intensity;

        selectedFigure.draw(gl, viewMatrix, projectionMatrix, colorUniform);       
    }
    function setFigure(value){
        if(value == 'conejo'){
            ccLabel.setText( "<i>Bunny</i>. Modelo obtenido de <i>Stanford University <br>Computer Graphics Laboratory</i>.");
        }else
            ccLabel.setText("");
        selectedFigure = figures[value];
        draw();
    }
    function upadeteKA(value){
        kA = value;
        draw();
    }
    function setColor(value){
        LA = value;
        draw();
    }
}