import * as MU from "../../../modules/MathUtils.js";
import {resize, MathBox, BigSlider} from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Line2D from "../../../geometry/Line2D.js";
import Figure2D from "../../../geometry/Figure2D.js";

/**
 * Línea.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    
    document.body.style.backgroundColor = "white"; 
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let container = document.getElementById("container");
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
    controls.style.bottom = "-50px";
    resize(canvas);
    
    const unit = 55;   
    
    //Colores
    const basisColor = [0, 139, 139, 255]; 
    const rayColor = [70, 130, 180, 255];
    
    const {width, height} = gl.canvas;
    
    //Vectores
    var dir_vec = new V2(1.5, .8);
    let s_point  = new V2(-.5, -.2);
    let e = new Vector2D(gl, WebGL, s_point, dir_vec, unit, 2, basisColor);
    let minus_infinity = s_point.add(dir_vec.scale(-10));
            
    //Punto céntrico
    var eparams = { center: s_point, r: 0.1, numPoints: 10};
    let cPoint = new Figure2D(gl, WebGL, 'circle', unit, basisColor, eparams);
    var p_t = s_point.add(dir_vec);
    eparams.center = p_t;
    let pPoint = new Figure2D(gl, WebGL, 'circle', unit, rayColor, eparams);
    
    //Line
    let ray = new Line2D(gl, WebGL, s_point, dir_vec, width, unit, .6, rayColor);
    let line = new Line2D(gl, WebGL, minus_infinity, dir_vec, width, unit, .6);
    
    //Etiqueta s_vec
    let s_label = new MathBox(container, {});
    let dir_label = new MathBox(container, {});
    let p_label = new MathBox(container, {});
    
    //HTML CONTROLS
    var t = 1;
    const prop = (dir_vec.length()*unit);
    const p_limit_min = -.5*width/prop;
    const p_limit_max = .595*width/prop;

    const colorsSlider = ["#619AC8", "#D1CDCA"];
    let sliderTAttrib = new BigSlider(controls, "t", p_limit_min, p_limit_max,  updateT, t, 0.1, colorsSlider);
     
    gl.clearColor(0, 0, 0, 0);
    
    draw();
    window.addEventListener('resize', draw);
    
    function draw(){
        resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        
        gl.depthMask(true);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var projectionMatrix = M3.projection(-.5*width, .5*width, .5*height, -.5*height);

        let diff = {t: -10, l: -15};
        let labelPosition = MU.getVectorLabelPosition(s_point, projectionMatrix, width, height, unit, diff, 1.2);
        s_label.setPosition(labelPosition);
        s_label.setText("\\mathbf{s}");
        
        diff = {t: 4, l: -17};
        labelPosition = MU.getVectorLabelPosition(s_point.add(dir_vec.scale(.6)), projectionMatrix, width, height, unit, diff, 1);
        dir_label.setPosition(labelPosition);
        dir_label.setText("\\mathbf{d}");
        
        p_t = s_point.add(dir_vec.scale(t));

        diff = {t: -5, l: 6};
        labelPosition = MU.getVectorLabelPosition(p_t, projectionMatrix, width, height, unit, diff, 1);
        p_label.setPosition(labelPosition);
        p_label.setText("P");
        
        
        line.draw(gl, projectionMatrix);
        ray.draw(gl, projectionMatrix);
        e.draw(gl, projectionMatrix, null, dir_vec);
        cPoint.draw(gl, M3.identity(), projectionMatrix); 
        pPoint.draw(gl, M3.identity(), projectionMatrix, p_t);
            
    }
    function updateT(value){
        t = value;
        draw();
    }
}