import * as MU from "../../../modules/MathUtils.js";
import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Figure2D from "../../../geometry/Figure2D.js";
import { MouseVector, registerMouseEvents2DVec } from "../../../modules/MouseEvents.js";

/**
 * Multiplicación de vectores por un escalar.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

const BLUE = "rgb(22, 50, 79)";
var k = 1;
function main(){
    //document.body.style.background = "background: linear-gradient(#f3f4f5, #bac4cc)";
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let container = document.getElementById("container");
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
    controls.style.bottom = "-30px";
    
    //HTML CONTROLS
    const colorsSlider = [BLUE, "#D1CDCA"];
    let sliderKAttrib = new Utils.BigSlider(controls, "k", -2, 2,  updateK, k, 0.1, colorsSlider);
    const unit = 25;   

    Utils.resize(canvas);
    //Vectores
    const color1 = [19, 41, 61, 255]; 
    const color2 = [132, 121, 150, 255];
    const opaqueColor = [97, 100, 112, 200]; 
    
    const {width, height} = gl.canvas;
    var offset = Math.floor(width/unit/4);
    
    let vsPoint = new V2(-offset,0);
    let kvsPoint = new V2(offset-2,0);

    let vector  = new V2(2,3);
    let v = new Vector2D(gl, WebGL, vsPoint, vector, unit, 4, color1);
    let kv = new Vector2D(gl, WebGL, kvsPoint, vector, unit, 4, color2);

    //Puntos de los vectores
    var vparams = { center: vsPoint, r: 0.15, numPoints: 10};
    let vPoint = new Figure2D(gl, WebGL, 'circle', unit, color1, vparams);
    vparams.center = kvsPoint;
    let kvPoint = new Figure2D(gl, WebGL, 'circle', unit, color2, vparams);
    
    //Constructor auxiliar para  el manejador de eventos con el ratón
    const radiusRegion = 0.6;
    let mouseVector = new MouseVector(gl, radiusRegion, unit, vector, null, false, vsPoint);
    let mouseVectors = [mouseVector];

    //Circunferencia para señalar el área para mover la flecha
    var cparams = { center: vsPoint, r: radiusRegion, thickness: 0.2, numPoints: 10};
    let cRegion = new Figure2D(gl, WebGL, 'circumference', unit, opaqueColor, cparams);

    //Etiquetas vectores
    let vLabel = Utils.createMathBox(container, {});
    let kvLabel = Utils.createMathBox(container, {});
 
    gl.clearColor(0, 0, 0, 0);
    
    draw();
    window.addEventListener('resize', draw);
    registerMouseEvents2DVec(canvas,mouseVectors, draw);
    
    function draw(){
        Utils.resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var projectionMatrix = M3.projection(-width/2, width/2, height/2, -height/2);
        
        var translateL = M3.translate(-offset,0);
        var translateR = M3.translate(offset,0);

        if(mouseVector.showRegion){
            let translateRegion = M3.translate(mouseVector.vector.x, mouseVector.vector.y);
            cRegion.draw(gl, translateRegion, projectionMatrix);
        }
        
        var kvVector = mouseVector.vector.scale(k);
        v.draw(gl, projectionMatrix, null, mouseVector.vector);
        kv.draw(gl, projectionMatrix, null, kvVector);
         
        vPoint.draw(gl, M3.identity(), projectionMatrix);        
        kvPoint.draw(gl, M3.identity(), projectionMatrix);  
        
        let labelPos = MU.getVectorLabelEndPosition(projectionMatrix, width, height, unit, mouseVector.vector, vsPoint);
        Utils.setElementPosition(vLabel, labelPos);
        Utils.setMathBox(vLabel, "\\mathbf{v}");

        labelPos = MU.getVectorLabelEndPosition(projectionMatrix, width, height, unit, kvVector, kvsPoint);
        Utils.setElementPosition(kvLabel, labelPos);
        Utils.setMathBox(kvLabel, "k\\mathbf{v}");     
    }
    
    function updateK(value){
        k = value;
        draw();
    }
}